/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;

public abstract class StdSerializer<T>
extends JsonSerializer<T>
implements JsonFormatVisitable,
SchemaAware {
    protected final Class<T> _handledType;

    protected StdSerializer(Class<T> clazz2) {
        this._handledType = clazz2;
    }

    protected StdSerializer(JavaType javaType2) {
        this._handledType = javaType2.getRawClass();
    }

    protected StdSerializer(Class<?> clazz2, boolean bl) {
        this._handledType = clazz2;
    }

    @Override
    public Class<T> handledType() {
        return this._handledType;
    }

    @Override
    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonGenerationException;

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        return this.createSchemaNode("string");
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type, boolean bl) throws JsonMappingException {
        ObjectNode objectNode = (ObjectNode)this.getSchema(serializerProvider, type);
        if (!bl) {
            objectNode.put("required", !bl);
        }
        return objectNode;
    }

    protected ObjectNode createObjectNode() {
        return JsonNodeFactory.instance.objectNode();
    }

    protected ObjectNode createSchemaNode(String string2) {
        ObjectNode objectNode = this.createObjectNode();
        objectNode.put("type", string2);
        return objectNode;
    }

    protected ObjectNode createSchemaNode(String string2, boolean bl) {
        ObjectNode objectNode = this.createSchemaNode(string2);
        if (!bl) {
            objectNode.put("required", !bl);
        }
        return objectNode;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType2) throws JsonMappingException {
        jsonFormatVisitorWrapper.expectAnyFormat(javaType2);
    }

    public void wrapAndThrow(SerializerProvider serializerProvider, Throwable throwable2, Object object, String string2) throws IOException {
        boolean bl;
        while (throwable2 instanceof InvocationTargetException && throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        if (throwable2 instanceof Error) {
            throw (Error)throwable2;
        }
        boolean bl2 = bl = serializerProvider == null || serializerProvider.isEnabled(SerializationFeature.WRAP_EXCEPTIONS);
        if (throwable2 instanceof IOException) {
            if (!bl || !(throwable2 instanceof JsonMappingException)) {
                throw (IOException)throwable2;
            }
        } else if (!bl && throwable2 instanceof RuntimeException) {
            throw (RuntimeException)throwable2;
        }
        throw JsonMappingException.wrapWithPath(throwable2, object, string2);
    }

    public void wrapAndThrow(SerializerProvider serializerProvider, Throwable throwable2, Object object, int n) throws IOException {
        boolean bl;
        while (throwable2 instanceof InvocationTargetException && throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        if (throwable2 instanceof Error) {
            throw (Error)throwable2;
        }
        boolean bl2 = bl = serializerProvider == null || serializerProvider.isEnabled(SerializationFeature.WRAP_EXCEPTIONS);
        if (throwable2 instanceof IOException) {
            if (!bl || !(throwable2 instanceof JsonMappingException)) {
                throw (IOException)throwable2;
            }
        } else if (!bl && throwable2 instanceof RuntimeException) {
            throw (RuntimeException)throwable2;
        }
        throw JsonMappingException.wrapWithPath(throwable2, object, n);
    }

    protected boolean isDefaultSerializer(JsonSerializer<?> jsonSerializer) {
        return ClassUtil.isJacksonStdImpl(jsonSerializer);
    }

    protected JsonSerializer<?> findConvertingContentSerializer(SerializerProvider serializerProvider, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer) throws JsonMappingException {
        Object object;
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        if (annotationIntrospector != null && beanProperty != null && (object = annotationIntrospector.findSerializationContentConverter(beanProperty.getMember())) != null) {
            Converter<Object, Object> converter = serializerProvider.converterInstance(beanProperty.getMember(), object);
            JavaType javaType2 = converter.getOutputType(serializerProvider.getTypeFactory());
            if (jsonSerializer == null) {
                jsonSerializer = serializerProvider.findValueSerializer(javaType2, beanProperty);
            }
            return new StdDelegatingSerializer(converter, javaType2, jsonSerializer);
        }
        return jsonSerializer;
    }

    protected PropertyFilter findPropertyFilter(SerializerProvider serializerProvider, Object object, Object object2) throws JsonMappingException {
        FilterProvider filterProvider = serializerProvider.getFilterProvider();
        if (filterProvider == null) {
            throw new JsonMappingException("Can not resolve PropertyFilter with id '" + object + "'; no FilterProvider configured");
        }
        PropertyFilter propertyFilter = filterProvider.findPropertyFilter(object, object2);
        return propertyFilter;
    }
}

