/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;

public abstract class TypeBase
extends JavaType
implements JsonSerializable {
    private static final long serialVersionUID = -3581199092426900829L;
    volatile transient String _canonicalName;

    @Deprecated
    protected TypeBase(Class<?> clazz2, int n, Object object, Object object2) {
        this(clazz2, n, object, object2, false);
    }

    protected TypeBase(Class<?> clazz2, int n, Object object, Object object2, boolean bl) {
        super(clazz2, n, object, object2, bl);
    }

    @Override
    public String toCanonical() {
        String string2 = this._canonicalName;
        if (string2 == null) {
            string2 = this.buildCanonicalName();
        }
        return string2;
    }

    protected abstract String buildCanonicalName();

    @Override
    public abstract StringBuilder getGenericSignature(StringBuilder var1);

    @Override
    public abstract StringBuilder getErasedSignature(StringBuilder var1);

    @Override
    public <T> T getValueHandler() {
        return (T)this._valueHandler;
    }

    @Override
    public <T> T getTypeHandler() {
        return (T)this._typeHandler;
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
        typeSerializer.writeTypePrefixForScalar(this, jsonGenerator);
        this.serialize(jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffixForScalar(this, jsonGenerator);
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        jsonGenerator.writeString(this.toCanonical());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static StringBuilder _classSignature(Class<?> clazz2, StringBuilder stringBuilder, boolean bl) {
        if (clazz2.isPrimitive()) {
            if (clazz2 == Boolean.TYPE) {
                stringBuilder.append('Z');
                return stringBuilder;
            } else if (clazz2 == Byte.TYPE) {
                stringBuilder.append('B');
                return stringBuilder;
            } else if (clazz2 == Short.TYPE) {
                stringBuilder.append('S');
                return stringBuilder;
            } else if (clazz2 == Character.TYPE) {
                stringBuilder.append('C');
                return stringBuilder;
            } else if (clazz2 == Integer.TYPE) {
                stringBuilder.append('I');
                return stringBuilder;
            } else if (clazz2 == Long.TYPE) {
                stringBuilder.append('J');
                return stringBuilder;
            } else if (clazz2 == Float.TYPE) {
                stringBuilder.append('F');
                return stringBuilder;
            } else if (clazz2 == Double.TYPE) {
                stringBuilder.append('D');
                return stringBuilder;
            } else {
                if (clazz2 != Void.TYPE) throw new IllegalStateException("Unrecognized primitive type: " + clazz2.getName());
                stringBuilder.append('V');
            }
            return stringBuilder;
        } else {
            stringBuilder.append('L');
            String string2 = clazz2.getName();
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (c == '.') {
                    c = '/';
                }
                stringBuilder.append(c);
            }
            if (!bl) return stringBuilder;
            stringBuilder.append(';');
        }
        return stringBuilder;
    }
}

