/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public final class ClassUtil {
    public static List<Class<?>> findSuperTypes(Class<?> clazz2, Class<?> clazz3) {
        return ClassUtil.findSuperTypes(clazz2, clazz3, new ArrayList(8));
    }

    public static List<Class<?>> findSuperTypes(Class<?> clazz2, Class<?> clazz3, List<Class<?>> list2) {
        ClassUtil._addSuperTypes(clazz2, clazz3, list2, false);
        return list2;
    }

    private static void _addSuperTypes(Class<?> clazz2, Class<?> clazz3, Collection<Class<?>> collection, boolean bl) {
        if (clazz2 == clazz3 || clazz2 == null || clazz2 == Object.class) {
            return;
        }
        if (bl) {
            if (collection.contains(clazz2)) {
                return;
            }
            collection.add(clazz2);
        }
        for (Class<?> clazz4 : clazz2.getInterfaces()) {
            ClassUtil._addSuperTypes(clazz4, clazz3, collection, true);
        }
        ClassUtil._addSuperTypes(clazz2.getSuperclass(), clazz3, collection, true);
    }

    public static String canBeABeanType(Class<?> clazz2) {
        if (clazz2.isAnnotation()) {
            return "annotation";
        }
        if (clazz2.isArray()) {
            return "array";
        }
        if (clazz2.isEnum()) {
            return "enum";
        }
        if (clazz2.isPrimitive()) {
            return "primitive";
        }
        return null;
    }

    public static String isLocalType(Class<?> clazz2, boolean bl) {
        try {
            if (clazz2.getEnclosingMethod() != null) {
                return "local/anonymous";
            }
            if (!bl && clazz2.getEnclosingClass() != null && !Modifier.isStatic(clazz2.getModifiers())) {
                return "non-static member class";
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public static Class<?> getOuterClass(Class<?> clazz2) {
        try {
            if (clazz2.getEnclosingMethod() != null) {
                return null;
            }
            if (!Modifier.isStatic(clazz2.getModifiers())) {
                return clazz2.getEnclosingClass();
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isProxyType(Class<?> clazz2) {
        String string2 = clazz2.getName();
        return string2.startsWith("net.sf.cglib.proxy.") || string2.startsWith("org.hibernate.proxy.");
    }

    public static boolean isConcrete(Class<?> clazz2) {
        int n = clazz2.getModifiers();
        return (n & 0x600) == 0;
    }

    public static boolean isConcrete(Member member) {
        int n = member.getModifiers();
        return (n & 0x600) == 0;
    }

    public static boolean isCollectionMapOrArray(Class<?> clazz2) {
        if (clazz2.isArray()) {
            return true;
        }
        if (Collection.class.isAssignableFrom(clazz2)) {
            return true;
        }
        return Map.class.isAssignableFrom(clazz2);
    }

    public static String getClassDescription(Object object) {
        if (object == null) {
            return "unknown";
        }
        Class<?> clazz2 = object instanceof Class ? (Class<?>)object : object.getClass();
        return clazz2.getName();
    }

    public static Class<?> findClass(String string2) throws ClassNotFoundException {
        if (string2.indexOf(46) < 0) {
            if ("int".equals(string2)) {
                return Integer.TYPE;
            }
            if ("long".equals(string2)) {
                return Long.TYPE;
            }
            if ("float".equals(string2)) {
                return Float.TYPE;
            }
            if ("double".equals(string2)) {
                return Double.TYPE;
            }
            if ("boolean".equals(string2)) {
                return Boolean.TYPE;
            }
            if ("byte".equals(string2)) {
                return Byte.TYPE;
            }
            if ("char".equals(string2)) {
                return Character.TYPE;
            }
            if ("short".equals(string2)) {
                return Short.TYPE;
            }
            if ("void".equals(string2)) {
                return Void.TYPE;
            }
        }
        Throwable throwable2 = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                return Class.forName(string2, true, classLoader);
            }
            catch (Exception exception) {
                throwable2 = ClassUtil.getRootCause(exception);
            }
        }
        try {
            return Class.forName(string2);
        }
        catch (Exception exception) {
            if (throwable2 == null) {
                throwable2 = ClassUtil.getRootCause(exception);
            }
            if (throwable2 instanceof RuntimeException) {
                throw (RuntimeException)throwable2;
            }
            throw new ClassNotFoundException(throwable2.getMessage(), throwable2);
        }
    }

    public static boolean hasGetterSignature(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray != null && classArray.length != 0) {
            return false;
        }
        return Void.TYPE != method.getReturnType();
    }

    public static Throwable getRootCause(Throwable throwable2) {
        while (throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        return throwable2;
    }

    public static void throwRootCause(Throwable throwable2) throws Exception {
        if ((throwable2 = ClassUtil.getRootCause(throwable2)) instanceof Exception) {
            throw (Exception)throwable2;
        }
        throw (Error)throwable2;
    }

    public static void throwAsIAE(Throwable throwable2) {
        ClassUtil.throwAsIAE(throwable2, throwable2.getMessage());
    }

    public static void throwAsIAE(Throwable throwable2, String string2) {
        if (throwable2 instanceof RuntimeException) {
            throw (RuntimeException)throwable2;
        }
        if (throwable2 instanceof Error) {
            throw (Error)throwable2;
        }
        throw new IllegalArgumentException(string2, throwable2);
    }

    public static void unwrapAndThrowAsIAE(Throwable throwable2) {
        ClassUtil.throwAsIAE(ClassUtil.getRootCause(throwable2));
    }

    public static void unwrapAndThrowAsIAE(Throwable throwable2, String string2) {
        ClassUtil.throwAsIAE(ClassUtil.getRootCause(throwable2), string2);
    }

    public static <T> T createInstance(Class<T> clazz2, boolean bl) throws IllegalArgumentException {
        Constructor<T> constructor = ClassUtil.findConstructor(clazz2, bl);
        if (constructor == null) {
            throw new IllegalArgumentException("Class " + clazz2.getName() + " has no default (no arg) constructor");
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            ClassUtil.unwrapAndThrowAsIAE(exception, "Failed to instantiate class " + clazz2.getName() + ", problem: " + exception.getMessage());
            return null;
        }
    }

    public static <T> Constructor<T> findConstructor(Class<T> clazz2, boolean bl) throws IllegalArgumentException {
        try {
            Constructor<T> constructor = clazz2.getDeclaredConstructor(new Class[0]);
            if (bl) {
                ClassUtil.checkAndFixAccess(constructor);
            } else if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new IllegalArgumentException("Default constructor for " + clazz2.getName() + " is not accessible (non-public?): not allowed to try modify access via Reflection: can not instantiate type");
            }
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            ClassUtil.unwrapAndThrowAsIAE(exception, "Failed to find default constructor of class " + clazz2.getName() + ", problem: " + exception.getMessage());
        }
        return null;
    }

    public static Object defaultValue(Class<?> clazz2) {
        if (clazz2 == Integer.TYPE) {
            return 0;
        }
        if (clazz2 == Long.TYPE) {
            return 0L;
        }
        if (clazz2 == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz2 == Double.TYPE) {
            return 0.0;
        }
        if (clazz2 == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz2 == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz2 == Short.TYPE) {
            return (short)0;
        }
        if (clazz2 == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        throw new IllegalArgumentException("Class " + clazz2.getName() + " is not a primitive type");
    }

    public static Class<?> wrapperType(Class<?> clazz2) {
        if (clazz2 == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz2 == Long.TYPE) {
            return Long.class;
        }
        if (clazz2 == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz2 == Double.TYPE) {
            return Double.class;
        }
        if (clazz2 == Float.TYPE) {
            return Float.class;
        }
        if (clazz2 == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz2 == Short.TYPE) {
            return Short.class;
        }
        if (clazz2 == Character.TYPE) {
            return Character.class;
        }
        throw new IllegalArgumentException("Class " + clazz2.getName() + " is not a primitive type");
    }

    public static void checkAndFixAccess(Member member) {
        block2: {
            AccessibleObject accessibleObject = (AccessibleObject)((Object)member);
            try {
                accessibleObject.setAccessible(true);
            }
            catch (SecurityException securityException) {
                if (accessibleObject.isAccessible()) break block2;
                Class<?> clazz2 = member.getDeclaringClass();
                throw new IllegalArgumentException("Can not access " + member + " (from class " + clazz2.getName() + "; failed to set access: " + securityException.getMessage());
            }
        }
    }

    public static Class<? extends Enum<?>> findEnumType(EnumSet<?> enumSet) {
        if (!enumSet.isEmpty()) {
            return ClassUtil.findEnumType((Enum)enumSet.iterator().next());
        }
        return EnumTypeLocator.instance.enumTypeFor(enumSet);
    }

    public static Class<? extends Enum<?>> findEnumType(EnumMap<?, ?> enumMap) {
        if (!enumMap.isEmpty()) {
            return ClassUtil.findEnumType((Enum)enumMap.keySet().iterator().next());
        }
        return EnumTypeLocator.instance.enumTypeFor(enumMap);
    }

    public static Class<? extends Enum<?>> findEnumType(Enum<?> enum_) {
        Class<?> clazz2 = enum_.getClass();
        if (clazz2.getSuperclass() != Enum.class) {
            clazz2 = clazz2.getSuperclass();
        }
        return clazz2;
    }

    public static Class<? extends Enum<?>> findEnumType(Class<?> clazz2) {
        if (clazz2.getSuperclass() != Enum.class) {
            clazz2 = clazz2.getSuperclass();
        }
        return clazz2;
    }

    public static boolean isJacksonStdImpl(Object object) {
        return object != null && ClassUtil.isJacksonStdImpl(object.getClass());
    }

    public static boolean isJacksonStdImpl(Class<?> clazz2) {
        return clazz2.getAnnotation(JacksonStdImpl.class) != null;
    }

    private static class EnumTypeLocator {
        static final EnumTypeLocator instance = new EnumTypeLocator();
        private final Field enumSetTypeField = EnumTypeLocator.locateField(EnumSet.class, "elementType", Class.class);
        private final Field enumMapTypeField = EnumTypeLocator.locateField(EnumMap.class, "elementType", Class.class);

        private EnumTypeLocator() {
        }

        public Class<? extends Enum<?>> enumTypeFor(EnumSet<?> enumSet) {
            if (this.enumSetTypeField != null) {
                return (Class)this.get(enumSet, this.enumSetTypeField);
            }
            throw new IllegalStateException("Can not figure out type for EnumSet (odd JDK platform?)");
        }

        public Class<? extends Enum<?>> enumTypeFor(EnumMap<?, ?> enumMap) {
            if (this.enumMapTypeField != null) {
                return (Class)this.get(enumMap, this.enumMapTypeField);
            }
            throw new IllegalStateException("Can not figure out type for EnumMap (odd JDK platform?)");
        }

        private Object get(Object object, Field field2) {
            try {
                return field2.get(object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
        }

        private static Field locateField(Class<?> clazz2, String string2, Class<?> clazz3) {
            Field[] fieldArray;
            Field field2 = null;
            for (Field field3 : fieldArray = clazz2.getDeclaredFields()) {
                if (!string2.equals(field3.getName()) || field3.getType() != clazz3) continue;
                field2 = field3;
                break;
            }
            if (field2 == null) {
                for (Field field3 : fieldArray) {
                    if (field3.getType() != clazz3) continue;
                    if (field2 != null) {
                        return null;
                    }
                    field2 = field3;
                }
            }
            if (field2 != null) {
                try {
                    field2.setAccessible(true);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            return field2;
        }
    }
}

