/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public final class EnumValues {
    private final Class<Enum<?>> _enumClass;
    private final EnumMap<?, SerializedString> _values;

    private EnumValues(Class<Enum<?>> clazz2, Map<Enum<?>, SerializedString> map2) {
        this._enumClass = clazz2;
        this._values = new EnumMap(map2);
    }

    public static EnumValues construct(Class<Enum<?>> clazz2, AnnotationIntrospector annotationIntrospector) {
        return EnumValues.constructFromName(clazz2, annotationIntrospector);
    }

    public static EnumValues constructFromName(Class<Enum<?>> clazz2, AnnotationIntrospector annotationIntrospector) {
        Class<Enum<?>> clazz3 = ClassUtil.findEnumType(clazz2);
        Enum<?>[] enumArray = clazz3.getEnumConstants();
        if (enumArray != null) {
            HashMap hashMap = new HashMap();
            for (Enum<?> enum_ : enumArray) {
                String string2 = annotationIntrospector.findEnumValue(enum_);
                hashMap.put(enum_, new SerializedString(string2));
            }
            return new EnumValues(clazz2, hashMap);
        }
        throw new IllegalArgumentException("Can not determine enum constants for Class " + clazz2.getName());
    }

    public static EnumValues constructFromToString(Class<Enum<?>> clazz2, AnnotationIntrospector annotationIntrospector) {
        Class<Enum<?>> clazz3 = ClassUtil.findEnumType(clazz2);
        Enum<?>[] enumArray = clazz3.getEnumConstants();
        if (enumArray != null) {
            HashMap hashMap = new HashMap();
            for (Enum<?> enum_ : enumArray) {
                hashMap.put(enum_, new SerializedString(enum_.toString()));
            }
            return new EnumValues(clazz2, hashMap);
        }
        throw new IllegalArgumentException("Can not determine enum constants for Class " + clazz2.getName());
    }

    public SerializedString serializedValueFor(Enum<?> enum_) {
        return this._values.get(enum_);
    }

    public Collection<SerializedString> values() {
        return this._values.values();
    }

    public EnumMap<?, SerializedString> internalMap() {
        return this._values;
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }
}

