/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import java.io.Serializable;

public abstract class ViewMatcher {
    public abstract boolean isVisibleForView(Class<?> var1);

    public static ViewMatcher construct(Class<?>[] classArray) {
        if (classArray == null) {
            return Empty.instance;
        }
        switch (classArray.length) {
            case 0: {
                return Empty.instance;
            }
            case 1: {
                return new Single(classArray[0]);
            }
        }
        return new Multi(classArray);
    }

    private static final class Multi
    extends ViewMatcher
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Class<?>[] _views;

        public Multi(Class<?>[] classArray) {
            this._views = classArray;
        }

        @Override
        public boolean isVisibleForView(Class<?> clazz2) {
            for (Class<?> clazz3 : this._views) {
                if (clazz2 != clazz3 && !clazz3.isAssignableFrom(clazz2)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class Single
    extends ViewMatcher
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Class<?> _view;

        public Single(Class<?> clazz2) {
            this._view = clazz2;
        }

        @Override
        public boolean isVisibleForView(Class<?> clazz2) {
            return clazz2 == this._view || this._view.isAssignableFrom(clazz2);
        }
    }

    private static final class Empty
    extends ViewMatcher
    implements Serializable {
        private static final long serialVersionUID = 1L;
        static final Empty instance = new Empty();

        private Empty() {
        }

        @Override
        public boolean isVisibleForView(Class<?> clazz2) {
            return false;
        }
    }
}

