/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.concurrent;

import com.twitter.concurrent.AsyncMeter$;
import com.twitter.concurrent.Period$;
import com.twitter.util.Closable;
import com.twitter.util.Closable$;
import com.twitter.util.Duration;
import com.twitter.util.Duration$;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Promise;
import com.twitter.util.Promise$;
import com.twitter.util.Stopwatch$;
import com.twitter.util.Timer;
import com.twitter.util.TokenBucket;
import com.twitter.util.TokenBucket$;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.RejectedExecutionException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015s!B\u0001\u0003\u0011\u0003I\u0011AC!ts:\u001cW*\u001a;fe*\u00111\u0001B\u0001\u000bG>t7-\u001e:sK:$(BA\u0003\u0007\u0003\u001d!x/\u001b;uKJT\u0011aB\u0001\u0004G>l7\u0001\u0001\t\u0003\u0015-i\u0011A\u0001\u0004\u0006\u0019\tA\t!\u0004\u0002\u000b\u0003NLhnY'fi\u0016\u00148CA\u0006\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\")Qc\u0003C\u0001-\u00051A(\u001b8jiz\"\u0012!\u0003\u0005\t1-\u0011\r\u0011\"\u0001\u00033\u0005yQ*\u001b8j[Vl\u0017J\u001c;feZ\fG.F\u0001\u001b!\tYb$D\u0001\u001d\u0015\tiB!\u0001\u0003vi&d\u0017BA\u0010\u001d\u0005!!UO]1uS>t\u0007BB\u0011\fA\u0003%!$\u0001\tNS:LW.^7J]R,'O^1mA!)1e\u0003C\u0001I\u0005I\u0001/\u001a:TK\u000e|g\u000e\u001a\u000b\u0006K\u0005\u0015\u0012q\u0005\u000b\u0004M\u0005\r\u0002C\u0001\u0006(\r\u0011a!\u0001\u0001\u0015\u0014\u0005\u001dr\u0001\"\u0003\u0016(\u0005\u000b\u0007I\u0011\u0001\u0002,\u0003%\u0011WO]:u'&TX-F\u0001-!\tyQ&\u0003\u0002/!\t\u0019\u0011J\u001c;\t\u0011A:#\u0011!Q\u0001\n1\n!BY;sgR\u001c\u0016N_3!\u0011!\u0011tE!A!\u0002\u0013Q\u0012!\u00042veN$H)\u001e:bi&|g\u000e\u0003\u00055O\t\u0005\t\u0015!\u0003-\u0003)i\u0017\r_,bSR,'o\u001d\u0005\tm\u001d\u0012\t\u0011)A\u0006o\u0005)A/[7feB\u00111\u0004O\u0005\u0003sq\u0011Q\u0001V5nKJDa!F\u0014\u0005\u0002\tYD\u0003\u0002\u001f?\u007f\u0001#\"AJ\u001f\t\u000bYR\u00049A\u001c\t\u000b)R\u0004\u0019\u0001\u0017\t\u000bIR\u0004\u0019\u0001\u000e\t\u000bQR\u0004\u0019\u0001\u0017\t\r\t;\u0003\u0015!\u0003D\u0003\u0019\u0001XM]5pIB\u0011!\u0002R\u0005\u0003\u000b\n\u0011a\u0001U3sS>$\u0007BB$(A\u0003%!$\u0001\u0005j]R,'O^1m\u0011\u0019Iu\u0005)A\u0005\u0015\u00061!-^2lKR\u0004\"aG&\n\u00051c\"a\u0003+pW\u0016t')^2lKRDaAT\u0014!B\u0013y\u0015!\u0003:f[\u0006Lg\u000eZ3s!\ty\u0001+\u0003\u0002R!\t1Ai\\;cY\u0016DaaU\u0014!B\u0013!\u0016a\u0002:v]:Lgn\u001a\t\u0003\u001fUK!A\u0016\t\u0003\u000f\t{w\u000e\\3b]\"\u0012!\u000b\u0017\t\u0003\u001feK!A\u0017\t\u0003\u0011Y|G.\u0019;jY\u0016Da\u0001X\u0014!B\u0013i\u0016\u0001\u0002;bg.\u0004\"a\u00070\n\u0005}c\"\u0001C\"m_N\f'\r\\3\t\r\u0005<\u0003\u0015)\u0003c\u0003\u001d)G.\u00199tK\u0012\u0004\"a\u00194\u000f\u0005m!\u0017BA3\u001d\u0003%\u0019Fo\u001c9xCR\u001c\u0007.\u0003\u0002hQ\n9Q\t\\1qg\u0016$\u0017BA5\u001d\u0005%\u0019Fo\u001c9xCR\u001c\u0007\u000e\u0003\u0004lO\u0001\u0006I\u0001\\\u0001\u0002cB\u0019QN\u001d;\u000e\u00039T!aA8\u000b\u0005u\u0001(\"A9\u0002\t)\fg/Y\u0005\u0003g:\u0014!#\u0011:sCf\u0014En\\2lS:<\u0017+^3vKB!q\"^<-\u0013\t1\bC\u0001\u0004UkBdWM\r\t\u00047aT\u0018BA=\u001d\u0005\u001d\u0001&o\\7jg\u0016\u0004\"aD>\n\u0005q\u0004\"\u0001B+oSRDQA`\u0014\u0005\u0002}\fQ!Y<bSR$B!!\u0001\u0002\bA!1$a\u0001{\u0013\r\t)\u0001\b\u0002\u0007\rV$XO]3\t\r\u0005%Q\u00101\u0001-\u0003\u001d\u0001XM]7jiND\u0001\"!\u0004(A\u0013%\u0011qB\u0001\rkB$\u0017\r^3B]\u0012<U\r\u001e\u000b\u0004)\u0006E\u0001bBA\n\u0003\u0017\u0001\r\u0001L\u0001\u0007i>\\WM\\:\t\u0011\u0005]q\u0005)C\u0005\u00033\tQB]3ge\u0016\u001c\b\u000eV8lK:\u001cH#\u0001>\t\u0011\u0005uq\u0005)C\u0005\u00033\t!C]3ti\u0006\u0014H\u000fV5nKJLe\rR3bI\"A\u0011\u0011E\u0014!\n\u001b\tI\"A\u0003bY2|w\u000fC\u00037E\u0001\u000fq\u0007\u0003\u0004\u0002\n\t\u0002\r\u0001\f\u0005\u0006i\t\u0002\r\u0001\f\u0005\b\u0003WYA\u0011AA\u0017\u0003!qWm^'fi\u0016\u0014H\u0003CA\u0018\u0003g\t)$a\u000e\u0015\u0007\u0019\n\t\u0004\u0003\u00047\u0003S\u0001\u001da\u000e\u0005\u0007U\u0005%\u0002\u0019\u0001\u0017\t\rI\nI\u00031\u0001\u001b\u0011\u0019!\u0014\u0011\u0006a\u0001Y!9\u00111H\u0006\u0005\u0002\u0005u\u0012AD3yiJ\fw+\u001b3f\u0003^\f\u0017\u000e\u001e\u000b\u0007\u0003\u0003\ty$!\u0011\t\u000f\u0005%\u0011\u0011\ba\u0001Y!9\u00111IA\u001d\u0001\u00041\u0013!B7fi\u0016\u0014\b")
public class AsyncMeter {
    private final int burstSize;
    public final Duration com$twitter$concurrent$AsyncMeter$$burstDuration;
    public final int com$twitter$concurrent$AsyncMeter$$maxWaiters;
    private final Timer timer;
    private final Duration period;
    private final Duration interval;
    private final TokenBucket bucket;
    private double remainder;
    private volatile boolean running;
    private Closable task;
    private Function0<Duration> elapsed;
    public final ArrayBlockingQueue<Tuple2<Promise<BoxedUnit>, Object>> com$twitter$concurrent$AsyncMeter$$q;

    public static Future<BoxedUnit> extraWideAwait(int n, AsyncMeter asyncMeter) {
        return AsyncMeter$.MODULE$.extraWideAwait(n, asyncMeter);
    }

    public static AsyncMeter newMeter(int n, Duration duration, int n2, Timer timer) {
        return AsyncMeter$.MODULE$.newMeter(n, duration, n2, timer);
    }

    public static AsyncMeter perSecond(int n, int n2, Timer timer) {
        return AsyncMeter$.MODULE$.perSecond(n, n2, timer);
    }

    public int burstSize() {
        return this.burstSize;
    }

    public Future<BoxedUnit> await(int permits) {
        Future<BoxedUnit> future2;
        if (permits > this.burstSize()) {
            return Future$.MODULE$.exception(new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tried to await on ", " permits, but the maximum burst size was ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(permits), BoxesRunTime.boxToInteger(this.burstSize())}))));
        }
        if (!this.running && this.updateAndGet(permits)) {
            return Future$.MODULE$.Done();
        }
        Promise<BoxedUnit> p = Promise$.MODULE$.apply();
        Tuple2 tup = new Tuple2(p, BoxesRunTime.boxToInteger(permits));
        if (this.com$twitter$concurrent$AsyncMeter$$q.offer(tup)) {
            p.setInterruptHandler((PartialFunction<Throwable, BoxedUnit>)((Object)new Serializable(this, p, tup){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AsyncMeter $outer;
                private final Promise p$1;
                private final Tuple2 tup$1;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    BoxedUnit boxedUnit;
                    Boolean bl;
                    Object object;
                    A1 A1 = x1;
                    if (A1 == null) {
                        object = function1.apply(x1);
                        return object;
                    }
                    A1 A12 = A1;
                    AsyncMeter asyncMeter = this.$outer;
                    synchronized (asyncMeter) {
                        bl = BoxesRunTime.boxToBoolean(this.$outer.com$twitter$concurrent$AsyncMeter$$q.remove(this.tup$1));
                    }
                    boolean rem = BoxesRunTime.unboxToBoolean(bl);
                    if (rem) {
                        CancellationException e = new CancellationException("Request for permits was cancelled.");
                        e.initCause(A12);
                        this.p$1.setException(e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                    return object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable2 = x1;
                    boolean bl = throwable2 != null;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.p$1 = p$1;
                    this.tup$1 = tup$1;
                }
            }));
            this.restartTimerIfDead();
            future2 = p;
        } else {
            future2 = Future$.MODULE$.exception(new RejectedExecutionException("Tried to wait when there were already the maximum number of waiters."));
        }
        return future2;
    }

    private boolean updateAndGet(int tokens) {
        this.refreshTokens();
        return this.bucket.tryGet(tokens);
    }

    private void refreshTokens() {
        AsyncMeter asyncMeter = this;
        synchronized (asyncMeter) {
            double newTokens = Period$.MODULE$.numPeriods$extension(this.period, this.elapsed.apply());
            this.elapsed = Stopwatch$.MODULE$.start();
            double num = newTokens + this.remainder;
            double floor = package$.MODULE$.floor(num);
            this.remainder = num - floor;
            Integer n = BoxesRunTime.boxToInteger((int)floor);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
            this.bucket.put(BoxesRunTime.unboxToInt(n));
            return;
        }
    }

    private synchronized void restartTimerIfDead() {
        if (!this.running) {
            this.running = true;
            this.task = this.timer.schedule(this.interval, (Function0<BoxedUnit>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AsyncMeter $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.com$twitter$concurrent$AsyncMeter$$allow();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void com$twitter$concurrent$AsyncMeter$$allow() {
        this.refreshTokens();
        while (true) {
            var2_2 = this;
            synchronized (var2_2) {
                block8: {
                    block7: {
                        var4_4 = this.com$twitter$concurrent$AsyncMeter$$q.peek();
                        if (var4_4 != null) break block7;
                        this.running = false;
                        this.task.close();
                        var5_5 /* !! */  = None$.MODULE$;
                        break block8;
                    }
                    if (var4_4 == null) ** GOTO lbl-1000
                    p = var4_4._1();
                    num = var4_4._2$mcI$sp();
                    if (this.bucket.tryGet(num)) {
                        this.com$twitter$concurrent$AsyncMeter$$q.poll();
                        var5_5 /* !! */  = new Some<Promise<BoxedUnit>>(p);
                    } else lbl-1000:
                    // 2 sources

                    {
                        var5_5 /* !! */  = None$.MODULE$;
                    }
                }
                var3_3 = var5_5 /* !! */ ;
            }
            var8_8 = control = (Option)var3_3;
            if (!(var8_8 instanceof Some)) break;
            var9_9 = (Some)var8_8;
            p = (Promise)var9_9.x();
            p.setValue(BoxedUnit.UNIT);
            var11_11 = BoxedUnit.UNIT;
        }
        if (None$.MODULE$.equals(var8_8)) {
            return;
        }
        throw new MatchError(var8_8);
        {
            catch (Throwable v0) {
                throw v0;
            }
        }
    }

    public AsyncMeter(int burstSize, Duration burstDuration, int maxWaiters, Timer timer) {
        this.burstSize = burstSize;
        this.com$twitter$concurrent$AsyncMeter$$burstDuration = burstDuration;
        this.com$twitter$concurrent$AsyncMeter$$maxWaiters = maxWaiters;
        this.timer = timer;
        Predef$.MODULE$.require(burstSize > 0, (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncMeter $outer;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"burst size of ", ", which is <= 0 doesn't make sense"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.burstSize())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        Predef$.MODULE$.require(burstDuration.$greater(Duration$.MODULE$.Zero()), (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncMeter $outer;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"burst duration of ", ", which is <= 0 nanoseconds doesn't make sense"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.com$twitter$concurrent$AsyncMeter$$burstDuration}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        Predef$.MODULE$.require(maxWaiters > 0, (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncMeter $outer;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max waiters of ", ", which is <= 0 doesn't make sense"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.com$twitter$concurrent$AsyncMeter$$maxWaiters)}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.period = Period$.MODULE$.fromBurstiness(burstSize, burstDuration);
        this.interval = Period$.MODULE$.realInterval$extension(this.period);
        this.bucket = TokenBucket$.MODULE$.newBoundedBucket(burstSize);
        this.bucket.put(burstSize);
        this.remainder = 0.0;
        this.running = false;
        this.task = Closable$.MODULE$.nop();
        this.elapsed = Stopwatch$.MODULE$.start();
        this.com$twitter$concurrent$AsyncMeter$$q = new ArrayBlockingQueue(maxWaiters, true);
    }
}

