/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.io;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.HashMap;
import java.util.Map;
import scala.runtime.BoxedUnit;

public final class Charsets$ {
    public static final Charsets$ MODULE$;
    private final Charset Utf16;
    private final Charset Utf16BE;
    private final Charset Utf16LE;
    private final Charset Utf8;
    private final Charset Iso8859_1;
    private final Charset UsAscii;
    private final ThreadLocal<Map<Charset, CharsetEncoder>> encoders;
    private final ThreadLocal<Map<Charset, CharsetDecoder>> decoders;

    static {
        new Charsets$();
    }

    public Charset Utf16() {
        return this.Utf16;
    }

    public Charset Utf16BE() {
        return this.Utf16BE;
    }

    public Charset Utf16LE() {
        return this.Utf16LE;
    }

    public Charset Utf8() {
        return this.Utf8;
    }

    public Charset Iso8859_1() {
        return this.Iso8859_1;
    }

    public Charset UsAscii() {
        return this.UsAscii;
    }

    public CharsetEncoder encoder(Charset charset) {
        Object object;
        CharsetEncoder e = this.encoders.get().get(charset);
        if (e == null) {
            e = charset.newEncoder();
            object = this.encoders.get().put(charset, e);
        } else {
            object = BoxedUnit.UNIT;
        }
        e.reset();
        e.onMalformedInput(CodingErrorAction.REPLACE);
        return e.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public CharsetDecoder decoder(Charset charset) {
        Object object;
        CharsetDecoder d = this.decoders.get().get(charset);
        if (d == null) {
            d = charset.newDecoder();
            object = this.decoders.get().put(charset, d);
        } else {
            object = BoxedUnit.UNIT;
        }
        d.reset();
        d.onMalformedInput(CodingErrorAction.REPLACE);
        return d.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    private Charsets$() {
        MODULE$ = this;
        this.Utf16 = Charset.forName("UTF-16");
        this.Utf16BE = Charset.forName("UTF-16BE");
        this.Utf16LE = Charset.forName("UTF-16LE");
        this.Utf8 = Charset.forName("UTF-8");
        this.Iso8859_1 = Charset.forName("ISO-8859-1");
        this.UsAscii = Charset.forName("US-ASCII");
        this.encoders = new ThreadLocal<Map<Charset, CharsetEncoder>>(){

            public HashMap<Charset, CharsetEncoder> initialValue() {
                return new HashMap<Charset, CharsetEncoder>();
            }
        };
        this.decoders = new ThreadLocal<Map<Charset, CharsetDecoder>>(){

            public HashMap<Charset, CharsetDecoder> initialValue() {
                return new HashMap<Charset, CharsetDecoder>();
            }
        };
    }
}

