/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util;

import com.twitter.util.Duration;
import com.twitter.util.Duration$;
import com.twitter.util.DurationBox;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import com.twitter.util.TimeLike;
import com.twitter.util.TimeLikeOps;
import com.twitter.util.TimeLikeOps$Finite$;
import com.twitter.util.TimeLikeOps$Nanoseconds$;
import com.twitter.util.TimeLikeOps$class;
import java.util.concurrent.TimeUnit;
import scala.Array$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.util.matching.Regex;

public final class Duration$
implements TimeLikeOps<Duration>,
Serializable {
    public static final Duration$ MODULE$;
    private final long NanosPerMicrosecond;
    private final long NanosPerMillisecond;
    private final long NanosPerSecond;
    private final long NanosPerMinute;
    private final long NanosPerHour;
    private final long NanosPerDay;
    private final Duration Zero;
    private final Duration Top;
    private final Duration Bottom;
    private final Duration Undefined;
    private final Seq<TimeUnit> com$twitter$util$Duration$$timeUnits;
    private final Map<String, TimeUnit> com$twitter$util$Duration$$nameToUnit;
    private final Regex SingleDurationRegex;
    private final Regex FullDurationRegex;
    private volatile TimeLikeOps$Nanoseconds$ Nanoseconds$module;
    private volatile TimeLikeOps$Finite$ Finite$module;

    static {
        new Duration$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TimeLikeOps$Nanoseconds$ Nanoseconds$lzycompute() {
        Duration$ duration$ = this;
        synchronized (duration$) {
            if (this.Nanoseconds$module != null) return this.Nanoseconds$module;
            this.Nanoseconds$module = new TimeLikeOps$Nanoseconds$(this);
            return this.Nanoseconds$module;
        }
    }

    @Override
    public TimeLikeOps$Nanoseconds$ Nanoseconds() {
        return this.Nanoseconds$module == null ? this.Nanoseconds$lzycompute() : this.Nanoseconds$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TimeLikeOps$Finite$ Finite$lzycompute() {
        Duration$ duration$ = this;
        synchronized (duration$) {
            if (this.Finite$module != null) return this.Finite$module;
            this.Finite$module = new TimeLikeOps$Finite$(this);
            return this.Finite$module;
        }
    }

    @Override
    public TimeLikeOps$Finite$ Finite() {
        return this.Finite$module == null ? this.Finite$lzycompute() : this.Finite$module;
    }

    @Override
    public void com$twitter$util$TimeLikeOps$_setter_$Zero_$eq(TimeLike x$1) {
    }

    @Override
    public Duration fromNanoseconds(long nanoseconds) {
        return new Duration(nanoseconds);
    }

    @Override
    public Duration fromFractionalSeconds(double seconds) {
        return (Duration)TimeLikeOps$class.fromFractionalSeconds(this, seconds);
    }

    @Override
    public Duration fromSeconds(int seconds) {
        return (Duration)TimeLikeOps$class.fromSeconds(this, seconds);
    }

    @Override
    public Duration fromMilliseconds(long millis) {
        return (Duration)TimeLikeOps$class.fromMilliseconds(this, millis);
    }

    @Override
    public Duration fromMicroseconds(long micros) {
        return (Duration)TimeLikeOps$class.fromMicroseconds(this, micros);
    }

    public long NanosPerMicrosecond() {
        return this.NanosPerMicrosecond;
    }

    public long NanosPerMillisecond() {
        return this.NanosPerMillisecond;
    }

    public long NanosPerSecond() {
        return this.NanosPerSecond;
    }

    public long NanosPerMinute() {
        return this.NanosPerMinute;
    }

    public long NanosPerHour() {
        return this.NanosPerHour;
    }

    public long NanosPerDay() {
        return this.NanosPerDay;
    }

    public Duration fromTimeUnit(long value2, TimeUnit unit2) {
        return this.apply(value2, unit2);
    }

    public Duration apply(long value2, TimeUnit unit2) {
        long ns = TimeUnit.NANOSECONDS.convert(value2, unit2);
        return this.fromNanoseconds(ns);
    }

    @Override
    public Duration Zero() {
        return this.Zero;
    }

    @Override
    public Duration Top() {
        return this.Top;
    }

    @Override
    public Duration Bottom() {
        return this.Bottom;
    }

    @Override
    public Duration Undefined() {
        return this.Undefined;
    }

    public Seq<TimeUnit> com$twitter$util$Duration$$timeUnits() {
        return this.com$twitter$util$Duration$$timeUnits;
    }

    public Map<String, TimeUnit> com$twitter$util$Duration$$nameToUnit() {
        return this.com$twitter$util$Duration$$nameToUnit;
    }

    private Regex SingleDurationRegex() {
        return this.SingleDurationRegex;
    }

    private Regex FullDurationRegex() {
        return this.FullDurationRegex;
    }

    public Duration parse(String s2) {
        String ss;
        String string2 = ss = s2.toLowerCase();
        Option<List<String>> option = this.FullDurationRegex().unapplySeq(string2);
        if (option.isEmpty()) {
            throw new NumberFormatException(new StringBuilder().append((Object)"Invalid duration: ").append((Object)s2).toString());
        }
        Duration duration = this.SingleDurationRegex().findAllIn(ss).matchData().zipWithIndex().map(new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final Duration apply(Tuple2<Regex.Match, Object> x0$1) {
                Tuple2<Regex.Match, Object> tuple2;
                block7: {
                    List<String> list2;
                    block8: {
                        Option<B> option;
                        block13: {
                            Duration duration;
                            Duration duration2;
                            String signStr;
                            int i;
                            block10: {
                                TimeUnit t;
                                TimeUnit timeUnit;
                                String unitStr;
                                String numStr;
                                block12: {
                                    String string2;
                                    block11: {
                                        block9: {
                                            Tuple4<String, String, String, String> tuple4;
                                            tuple2 = x0$1;
                                            if (tuple2 == null) break block7;
                                            Regex.Match m = tuple2._1();
                                            i = tuple2._2$mcI$sp();
                                            list2 = m.subgroups();
                                            Some<List<String>> some = List$.MODULE$.unapplySeq(list2);
                                            if (some.isEmpty() || some.get() == null || ((LinearSeqOptimized)some.get()).lengthCompare(4) != 0) break block8;
                                            String signStr2 = (String)((LinearSeqOptimized)some.get()).apply(0);
                                            String numStr2 = (String)((LinearSeqOptimized)some.get()).apply(1);
                                            String unitStr2 = (String)((LinearSeqOptimized)some.get()).apply(2);
                                            String special = (String)((LinearSeqOptimized)some.get()).apply(3);
                                            Tuple4<String, String, String, String> tuple42 = tuple4 = new Tuple4<String, String, String, String>(signStr2, numStr2, unitStr2, special);
                                            signStr = tuple42._1();
                                            numStr = tuple42._2();
                                            unitStr = tuple42._3();
                                            String special2 = tuple42._4();
                                            string2 = special2;
                                            if (!"top".equals(string2)) break block9;
                                            duration2 = Duration$.MODULE$.Top();
                                            break block10;
                                        }
                                        if (!"bottom".equals(string2)) break block11;
                                        duration2 = Duration$.MODULE$.Bottom();
                                        break block10;
                                    }
                                    if (!"undefined".equals(string2)) break block12;
                                    duration2 = Duration$.MODULE$.Undefined();
                                    break block10;
                                }
                                option = Duration$.MODULE$.com$twitter$util$Duration$$nameToUnit().get(unitStr);
                                if (!(option instanceof Some)) break block13;
                                Some some = (Some)option;
                                TimeUnit u = timeUnit = (t = (TimeUnit)((Object)some.x()));
                                duration2 = Duration$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString(numStr)).toLong(), u);
                            }
                            Duration absDuration = duration2;
                            String string3 = signStr;
                            if ("-".equals(string3)) {
                                duration = absDuration.unary_$minus();
                            } else {
                                if ("".equals(string3) && i > 0) {
                                    throw new NumberFormatException("Expected a sign between durations");
                                }
                                duration = absDuration;
                            }
                            Duration duration3 = duration;
                            return duration3;
                        }
                        if (None$.MODULE$.equals(option)) {
                            void var16_15;
                            throw new NumberFormatException(new StringBuilder().append((Object)"Invalid unit: ").append(var16_15).toString());
                        }
                        throw new MatchError(option);
                    }
                    throw new MatchError(list2);
                }
                throw new MatchError(tuple2);
            }
        }).reduce(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Duration apply(Duration x$2, Duration x$3) {
                return (Duration)x$2.$plus(x$3);
            }
        });
        return duration;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Duration$() {
        MODULE$ = this;
        TimeLikeOps$class.$init$(this);
        this.NanosPerMicrosecond = 1000L;
        this.NanosPerMillisecond = this.NanosPerMicrosecond() * 1000L;
        this.NanosPerSecond = this.NanosPerMillisecond() * 1000L;
        this.NanosPerMinute = this.NanosPerSecond() * 60L;
        this.NanosPerHour = this.NanosPerMinute() * 60L;
        this.NanosPerDay = this.NanosPerHour() * 24L;
        this.Zero = this.fromNanoseconds(0L);
        this.Top = new Duration(){

            public int hashCode() {
                return System.identityHashCode(this);
            }

            public int compare(Duration that) {
                return that == Duration$.MODULE$.Undefined() ? -1 : (that == Duration$.MODULE$.Top() ? 0 : 1);
            }

            public boolean equals(Object other) {
                Duration duration;
                Object object = other;
                boolean bl = object instanceof Duration ? (duration = (Duration)object) == this : false;
                return bl;
            }

            public Duration $times(long x) {
                return x == 0L ? Duration$.MODULE$.Undefined() : (x < 0L ? Duration$.MODULE$.Bottom() : Duration$.MODULE$.Top());
            }

            public Duration $times(double x) {
                return x == 0.0 || Double.isNaN(x) ? Duration$.MODULE$.Undefined() : (x < 0.0 ? Duration$.MODULE$.Bottom() : Duration$.MODULE$.Top());
            }

            public Duration $div(long x) {
                return x == 0L ? Duration$.MODULE$.Undefined() : (x < 0L ? Duration$.MODULE$.Bottom() : Duration$.MODULE$.Top());
            }

            public Duration $div(double x) {
                return x == 0.0 || Double.isNaN(x) ? Duration$.MODULE$.Undefined() : (x < 0.0 ? Duration$.MODULE$.Bottom() : Duration$.MODULE$.Top());
            }

            public boolean isFinite() {
                return false;
            }

            public Duration $percent(Duration x) {
                return Duration$.MODULE$.Undefined();
            }

            public anon.1 abs() {
                return this;
            }

            public Time fromNow() {
                return Time$.MODULE$.Top();
            }

            public Time ago() {
                return Time$.MODULE$.Bottom();
            }

            public Time afterEpoch() {
                return Time$.MODULE$.Top();
            }

            public Duration $plus(Duration delta) {
                boolean bl;
                Duration duration = delta;
                Duration duration2 = Duration$.MODULE$.Bottom();
                Duration duration3 = duration;
                if (!(duration2 != null ? !((Object)duration2).equals(duration3) : duration3 != null)) {
                    bl = true;
                } else {
                    Duration duration4 = Duration$.MODULE$.Undefined();
                    Duration duration5 = duration;
                    bl = !(duration4 != null ? !((Object)duration4).equals(duration5) : duration5 != null);
                }
                Duration duration6 = bl ? Duration$.MODULE$.Undefined() : this;
                return duration6;
            }

            public Duration unary_$minus() {
                return Duration$.MODULE$.Bottom();
            }

            public String toString() {
                return "Duration.Top";
            }

            private Object writeReplace() {
                return new DurationBox.Top();
            }
        };
        this.Bottom = new Duration(){

            public int hashCode() {
                return System.identityHashCode(this);
            }

            public int compare(Duration that) {
                return this == that ? 0 : -1;
            }

            public boolean equals(Object other) {
                Duration duration;
                Object object = other;
                boolean bl = object instanceof Duration ? (duration = (Duration)object) == this : false;
                return bl;
            }

            public Duration $times(long x) {
                return x == 0L ? Duration$.MODULE$.Undefined() : (x < 0L ? Duration$.MODULE$.Top() : Duration$.MODULE$.Bottom());
            }

            public Duration $times(double x) {
                return x == 0.0 || Double.isNaN(x) ? Duration$.MODULE$.Undefined() : (x < 0.0 ? Duration$.MODULE$.Top() : Duration$.MODULE$.Bottom());
            }

            public Duration $div(long x) {
                return x == 0L ? Duration$.MODULE$.Undefined() : (x < 0L ? Duration$.MODULE$.Top() : Duration$.MODULE$.Bottom());
            }

            public Duration $div(double x) {
                return x == 0.0 || Double.isNaN(x) ? Duration$.MODULE$.Undefined() : (x < 0.0 ? Duration$.MODULE$.Top() : Duration$.MODULE$.Bottom());
            }

            public Duration $percent(Duration x) {
                return Duration$.MODULE$.Undefined();
            }

            public Duration abs() {
                return Duration$.MODULE$.Top();
            }

            public Time fromNow() {
                return Time$.MODULE$.Bottom();
            }

            public Time ago() {
                return Time$.MODULE$.Top();
            }

            public Time afterEpoch() {
                return Time$.MODULE$.Bottom();
            }

            public boolean isFinite() {
                return false;
            }

            public Duration $plus(Duration delta) {
                boolean bl;
                Duration duration = delta;
                Duration duration2 = Duration$.MODULE$.Top();
                Duration duration3 = duration;
                if (!(duration2 != null ? !((Object)duration2).equals(duration3) : duration3 != null)) {
                    bl = true;
                } else {
                    Duration duration4 = Duration$.MODULE$.Undefined();
                    Duration duration5 = duration;
                    bl = !(duration4 != null ? !((Object)duration4).equals(duration5) : duration5 != null);
                }
                Duration duration6 = bl ? Duration$.MODULE$.Undefined() : this;
                return duration6;
            }

            public Duration unary_$minus() {
                return Duration$.MODULE$.Top();
            }

            public String toString() {
                return "Duration.Bottom";
            }

            private Object writeReplace() {
                return new DurationBox.Bottom();
            }
        };
        this.Undefined = new Duration(){

            public int hashCode() {
                return System.identityHashCode(this);
            }

            public int compare(Duration that) {
                return this == that ? 0 : 1;
            }

            public boolean equals(Object other) {
                Duration duration;
                Object object = other;
                boolean bl = object instanceof Duration ? (duration = (Duration)object) == this : false;
                return bl;
            }

            public Duration $times(long x) {
                return this;
            }

            public Duration $times(double x) {
                return this;
            }

            public Duration $div(long x) {
                return this;
            }

            public Duration $div(double x) {
                return this;
            }

            public Duration $percent(Duration x) {
                return this;
            }

            public anon.3 abs() {
                return this;
            }

            public Time fromNow() {
                return Time$.MODULE$.Undefined();
            }

            public Time ago() {
                return Time$.MODULE$.Undefined();
            }

            public Time afterEpoch() {
                return Time$.MODULE$.Undefined();
            }

            public anon.3 $plus(Duration delta) {
                return this;
            }

            public anon.3 unary_$minus() {
                return this;
            }

            public boolean isFinite() {
                return false;
            }

            public String toString() {
                return "Duration.Undefined";
            }

            private Object writeReplace() {
                return new DurationBox.Undefined();
            }
        };
        this.com$twitter$util$Duration$$timeUnits = (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new TimeUnit[]{TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES, TimeUnit.SECONDS, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS}));
        this.com$twitter$util$Duration$$nameToUnit = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])TimeUnit.values()).flatMap(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple2<String, TimeUnit>> apply(TimeUnit u) {
                String pluralK = u.toString().toLowerCase();
                String singularK = (String)new StringOps(Predef$.MODULE$.augmentString(pluralK)).dropRight(1);
                return (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(pluralK), u), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(singularK), u)}));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        this.SingleDurationRegex = new StringOps(Predef$.MODULE$.augmentString("\\s*([+-]?)\\s*(?:([0-9]+)\\.([a-z]+)|duration\\.(top|bottom|undefined))")).r();
        this.FullDurationRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)"(").append((Object)this.SingleDurationRegex().pattern().pattern()).append((Object)")+\\s*").toString())).r();
    }
}

