/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.collection.Iterable;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class NetUtil$ {
    public static final NetUtil$ MODULE$;

    static {
        new NetUtil$();
    }

    public boolean isIpv4Address(String ip) {
        return this.ipToOptionInt(ip).isDefined();
    }

    public boolean isPrivateAddress(InetAddress ip) {
        Inet4Address inet4Address;
        byte[] addr;
        InetAddress inetAddress = ip;
        boolean bl = inetAddress instanceof Inet4Address ? ((addr = (inet4Address = (Inet4Address)inetAddress).getAddress())[0] == (byte)10 ? true : (addr[0] == (byte)172 && (addr[1] & 0xF0) == (byte)16 ? true : addr[0] == (byte)192 && addr[1] == (byte)168)) : false;
        return bl;
    }

    public int ipToInt(String ip) {
        return BoxesRunTime.unboxToInt(this.ipToOptionInt(ip).getOrElse(new Serializable(ip){
            public static final long serialVersionUID = 0L;
            private final String ip$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"invalid IPv4 address: ").append((Object)this.ip$1).toString());
            }
            {
                this.ip$1 = ip$1;
            }
        }));
    }

    public Option<Object> ipToOptionInt(String ip) {
        int dot1 = ip.indexOf(46);
        if (dot1 <= 0) {
            return None$.MODULE$;
        }
        int dot2 = ip.indexOf(46, dot1 + 1);
        if (dot2 == -1) {
            return None$.MODULE$;
        }
        int dot3 = ip.indexOf(46, dot2 + 1);
        if (dot3 == -1) {
            return None$.MODULE$;
        }
        int num1 = this.ipv4DecimalToInt(ip.substring(0, dot1));
        if (num1 < 0) {
            return None$.MODULE$;
        }
        int num2 = this.ipv4DecimalToInt(ip.substring(dot1 + 1, dot2));
        if (num2 < 0) {
            return None$.MODULE$;
        }
        int num3 = this.ipv4DecimalToInt(ip.substring(dot2 + 1, dot3));
        if (num3 < 0) {
            return None$.MODULE$;
        }
        int num4 = this.ipv4DecimalToInt(ip.substring(dot3 + 1));
        if (num4 < 0) {
            return None$.MODULE$;
        }
        return new Some<Object>(BoxesRunTime.boxToInteger(num1 << 24 | num2 << 16 | num3 << 8 | num4));
    }

    private int ipv4DecimalToInt(String s2) {
        if (s2.isEmpty() || s2.length() > 3) {
            return -1;
        }
        int num = 0;
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c < '0' || c > '9') {
                return -1;
            }
            num = num * 10 + (c - 48);
        }
        return num >= 0 && num <= 255 ? num : -1;
    }

    public int inetAddressToInt(InetAddress inetAddress) {
        InetAddress inetAddress2 = inetAddress;
        if (inetAddress2 instanceof Inet4Address) {
            Inet4Address inet4Address = (Inet4Address)inetAddress2;
            byte[] addr = inet4Address.getAddress();
            int n = (addr[0] & 0xFF) << 24 | (addr[1] & 0xFF) << 16 | (addr[2] & 0xFF) << 8 | addr[3] & 0xFF;
            return n;
        }
        throw new IllegalArgumentException("non-Inet4Address cannot be converted to an Int");
    }

    public Tuple2<Object, Object> ipToIpBlock(String ip, Option<Object> prefixLen) {
        String[] arr = new StringOps(Predef$.MODULE$.augmentString(ip)).split('.');
        Option<Object> option = prefixLen;
        int n = None$.MODULE$.equals(option) && arr.length != 4 ? arr.length * 8 : BoxesRunTime.unboxToInt(option.getOrElse(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 32;
            }
        }));
        int pLen = n;
        int netIp = this.ipToInt(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])arr).padTo(4, "0", Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("."));
        int mask2 = Integer.MIN_VALUE >> pLen - 1;
        return new Tuple2$mcII$sp(netIp, mask2);
    }

    public Tuple2<Object, Object> cidrToIpBlock(String cidr) {
        String[] stringArray;
        block4: {
            Tuple2<Object, Object> tuple2;
            block3: {
                block2: {
                    stringArray = new StringOps(Predef$.MODULE$.augmentString(cidr)).split('/');
                    Option option = Array$.MODULE$.unapplySeq(stringArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) break block2;
                    String ip = (String)((SeqLike)option.get()).apply(0);
                    String prefixLen = (String)((SeqLike)option.get()).apply(1);
                    tuple2 = this.ipToIpBlock(ip, new Some<Object>(BoxesRunTime.boxToInteger(new StringOps(Predef$.MODULE$.augmentString(prefixLen)).toInt())));
                    break block3;
                }
                Option option = Array$.MODULE$.unapplySeq(stringArray);
                if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0) break block4;
                String ip = (String)((SeqLike)option.get()).apply(0);
                tuple2 = this.ipToIpBlock(ip, None$.MODULE$);
            }
            return tuple2;
        }
        throw new MatchError(stringArray);
    }

    public boolean isIpInBlock(int ip, Tuple2<Object, Object> ipBlock) {
        Tuple2<Object, Object> tuple2 = ipBlock;
        if (tuple2 != null) {
            int netIp = tuple2._1$mcI$sp();
            int mask2 = tuple2._2$mcI$sp();
            boolean bl = (mask2 & ip) == netIp;
            return bl;
        }
        throw new MatchError(tuple2);
    }

    public boolean isInetAddressInBlock(InetAddress inetAddress, Tuple2<Object, Object> ipBlock) {
        return this.isIpInBlock(this.inetAddressToInt(inetAddress), ipBlock);
    }

    public boolean isIpInBlocks(int ip, Iterable<Tuple2<Object, Object>> ipBlocks) {
        return ipBlocks.exists((Function1<Tuple2<Object, Object>, Object>)((Object)new Serializable(ip){
            public static final long serialVersionUID = 0L;
            private final int ip$2;

            public final boolean apply(Tuple2<Object, Object> ipBlock) {
                return NetUtil$.MODULE$.isIpInBlock(this.ip$2, ipBlock);
            }
            {
                this.ip$2 = ip$2;
            }
        }));
    }

    public boolean isIpInBlocks(String ip, Iterable<Tuple2<Object, Object>> ipBlocks) {
        return this.isIpInBlocks(this.ipToInt(ip), ipBlocks);
    }

    public boolean isInetAddressInBlocks(InetAddress inetAddress, Iterable<Tuple2<Object, Object>> ipBlocks) {
        return this.isIpInBlocks(this.inetAddressToInt(inetAddress), ipBlocks);
    }

    public String getLocalHostName() {
        Option<String> option;
        block4: {
            String string2;
            try {
                string2 = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                String string3;
                option = Option$.MODULE$.apply(unknownHostException.getMessage());
                if (option instanceof Some) {
                    String hostName;
                    Some some = (Some)option;
                    String host = (String)some.x();
                    String[] stringArray = host.split(":");
                    Option option2 = Array$.MODULE$.unapplySeq(stringArray);
                    String string4 = !option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(2) == 0 ? (hostName = (String)((SeqLike)option2.get()).apply(0)) : "unknown_host";
                    string3 = string4;
                } else {
                    if (!None$.MODULE$.equals(option)) break block4;
                    string3 = "unknown_host";
                }
                string2 = string3;
            }
            return string2;
        }
        throw new MatchError(option);
    }

    private NetUtil$() {
        MODULE$ = this;
    }
}

