/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util;

import java.text.SimpleDateFormat;
import java.util.Locale;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class TwitterDateFormat$ {
    public static final TwitterDateFormat$ MODULE$;

    static {
        new TwitterDateFormat$();
    }

    public SimpleDateFormat apply(String pattern) {
        this.validatePattern(pattern);
        return new SimpleDateFormat(pattern);
    }

    public SimpleDateFormat apply(String pattern, Locale locale) {
        this.validatePattern(pattern);
        return new SimpleDateFormat(pattern, locale);
    }

    public void validatePattern(String pattern) {
        String stripped = this.stripSingleQuoted(pattern);
        if (new StringOps(Predef$.MODULE$.augmentString(stripped)).contains(BoxesRunTime.boxToCharacter('Y')) && !new StringOps(Predef$.MODULE$.augmentString(stripped)).contains(BoxesRunTime.boxToCharacter('w'))) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid date format uses 'Y' for week-of-year without 'w': %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{pattern})));
        }
    }

    public String stripSingleQuoted(String pattern) {
        StringBuilder buf = new StringBuilder(new StringOps(Predef$.MODULE$.augmentString(pattern)).size());
        int startIndex = 0;
        int endIndex = 0;
        while (startIndex >= 0 && startIndex < new StringOps(Predef$.MODULE$.augmentString(pattern)).size()) {
            endIndex = pattern.indexOf(39, startIndex);
            if (endIndex < 0) {
                buf.append(pattern.substring(startIndex));
                startIndex = -1;
                continue;
            }
            buf.append(pattern.substring(startIndex, endIndex));
            startIndex = endIndex + 1;
            endIndex = pattern.indexOf(39, startIndex);
            if (endIndex < 0) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Unmatched quote in date format: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{pattern})));
            }
            startIndex = endIndex + 1;
        }
        return buf.toString();
    }

    private TwitterDateFormat$() {
        MODULE$ = this;
    }
}

