/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.asm;

import scala.tools.asm.AnnotationVisitor;
import scala.tools.asm.ByteVector;
import scala.tools.asm.ClassWriter;
import scala.tools.asm.Item;
import scala.tools.asm.Type;
import scala.tools.asm.TypePath;

final class AnnotationWriter
extends AnnotationVisitor {
    private final ClassWriter cw;
    private int size;
    private final boolean named;
    private final ByteVector bv;
    private final ByteVector parent;
    private final int offset;
    AnnotationWriter next;
    AnnotationWriter prev;

    AnnotationWriter(ClassWriter cw, boolean named, ByteVector bv, ByteVector parent, int offset) {
        super(327680);
        this.cw = cw;
        this.named = named;
        this.bv = bv;
        this.parent = parent;
        this.offset = offset;
    }

    @Override
    public void visit(String name2, Object value2) {
        ++this.size;
        if (this.named) {
            this.bv.putShort(this.cw.newUTF8(name2));
        }
        if (value2 instanceof String) {
            this.bv.put12(115, this.cw.newUTF8((String)value2));
        } else if (value2 instanceof Byte) {
            this.bv.put12(66, this.cw.newInteger((int)((Byte)value2).byteValue()).index);
        } else if (value2 instanceof Boolean) {
            int v = (Boolean)value2 != false ? 1 : 0;
            this.bv.put12(90, this.cw.newInteger((int)v).index);
        } else if (value2 instanceof Character) {
            this.bv.put12(67, this.cw.newInteger((int)((Character)value2).charValue()).index);
        } else if (value2 instanceof Short) {
            this.bv.put12(83, this.cw.newInteger((int)((Short)value2).shortValue()).index);
        } else if (value2 instanceof Type) {
            this.bv.put12(99, this.cw.newUTF8(((Type)value2).getDescriptor()));
        } else if (value2 instanceof byte[]) {
            byte[] v = (byte[])value2;
            this.bv.put12(91, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.bv.put12(66, this.cw.newInteger((int)v[i]).index);
            }
        } else if (value2 instanceof boolean[]) {
            boolean[] v = (boolean[])value2;
            this.bv.put12(91, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.bv.put12(90, this.cw.newInteger((int)(v[i] ? 1 : 0)).index);
            }
        } else if (value2 instanceof short[]) {
            short[] v = (short[])value2;
            this.bv.put12(91, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.bv.put12(83, this.cw.newInteger((int)v[i]).index);
            }
        } else if (value2 instanceof char[]) {
            char[] v = (char[])value2;
            this.bv.put12(91, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.bv.put12(67, this.cw.newInteger((int)v[i]).index);
            }
        } else if (value2 instanceof int[]) {
            int[] v = (int[])value2;
            this.bv.put12(91, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.bv.put12(73, this.cw.newInteger((int)v[i]).index);
            }
        } else if (value2 instanceof long[]) {
            long[] v = (long[])value2;
            this.bv.put12(91, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.bv.put12(74, this.cw.newLong((long)v[i]).index);
            }
        } else if (value2 instanceof float[]) {
            float[] v = (float[])value2;
            this.bv.put12(91, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.bv.put12(70, this.cw.newFloat((float)v[i]).index);
            }
        } else if (value2 instanceof double[]) {
            double[] v = (double[])value2;
            this.bv.put12(91, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.bv.put12(68, this.cw.newDouble((double)v[i]).index);
            }
        } else {
            Item i = this.cw.newConstItem(value2);
            this.bv.put12(".s.IFJDCS".charAt(i.type), i.index);
        }
    }

    @Override
    public void visitEnum(String name2, String desc, String value2) {
        ++this.size;
        if (this.named) {
            this.bv.putShort(this.cw.newUTF8(name2));
        }
        this.bv.put12(101, this.cw.newUTF8(desc)).putShort(this.cw.newUTF8(value2));
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name2, String desc) {
        ++this.size;
        if (this.named) {
            this.bv.putShort(this.cw.newUTF8(name2));
        }
        this.bv.put12(64, this.cw.newUTF8(desc)).putShort(0);
        return new AnnotationWriter(this.cw, true, this.bv, this.bv, this.bv.length - 2);
    }

    @Override
    public AnnotationVisitor visitArray(String name2) {
        ++this.size;
        if (this.named) {
            this.bv.putShort(this.cw.newUTF8(name2));
        }
        this.bv.put12(91, 0);
        return new AnnotationWriter(this.cw, false, this.bv, this.bv, this.bv.length - 2);
    }

    @Override
    public void visitEnd() {
        if (this.parent != null) {
            byte[] data2 = this.parent.data;
            data2[this.offset] = (byte)(this.size >>> 8);
            data2[this.offset + 1] = (byte)this.size;
        }
    }

    int getSize() {
        int size2 = 0;
        AnnotationWriter aw = this;
        while (aw != null) {
            size2 += aw.bv.length;
            aw = aw.next;
        }
        return size2;
    }

    void put(ByteVector out) {
        int n = 0;
        int size2 = 2;
        AnnotationWriter aw = this;
        AnnotationWriter last2 = null;
        while (aw != null) {
            ++n;
            size2 += aw.bv.length;
            aw.visitEnd();
            aw.prev = last2;
            last2 = aw;
            aw = aw.next;
        }
        out.putInt(size2);
        out.putShort(n);
        aw = last2;
        while (aw != null) {
            out.putByteArray(aw.bv.data, 0, aw.bv.length);
            aw = aw.prev;
        }
    }

    static void put(AnnotationWriter[] panns, int off, ByteVector out) {
        int i;
        int size2 = 1 + 2 * (panns.length - off);
        for (i = off; i < panns.length; ++i) {
            size2 += panns[i] == null ? 0 : panns[i].getSize();
        }
        out.putInt(size2).putByte(panns.length - off);
        for (i = off; i < panns.length; ++i) {
            AnnotationWriter aw = panns[i];
            AnnotationWriter last2 = null;
            int n = 0;
            while (aw != null) {
                ++n;
                aw.visitEnd();
                aw.prev = last2;
                last2 = aw;
                aw = aw.next;
            }
            out.putShort(n);
            aw = last2;
            while (aw != null) {
                out.putByteArray(aw.bv.data, 0, aw.bv.length);
                aw = aw.prev;
            }
        }
    }

    static void putTarget(int typeRef2, TypePath typePath, ByteVector out) {
        switch (typeRef2 >>> 24) {
            case 0: 
            case 1: 
            case 22: {
                out.putShort(typeRef2 >>> 16);
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                out.putByte(typeRef2 >>> 24);
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                out.putInt(typeRef2);
                break;
            }
            default: {
                out.put12(typeRef2 >>> 24, (typeRef2 & 0xFFFF00) >> 8);
            }
        }
        if (typePath == null) {
            out.putByte(0);
        } else {
            int length = typePath.b[typePath.offset] * 2 + 1;
            out.putByteArray(typePath.b, typePath.offset, length);
        }
    }
}

