/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.asm.signature;

import scala.tools.asm.signature.SignatureVisitor;

public class SignatureReader {
    private final String signature;

    public SignatureReader(String signature2) {
        this.signature = signature2;
    }

    public void accept(SignatureVisitor v) {
        int pos2;
        String signature2 = this.signature;
        int len = signature2.length();
        if (signature2.charAt(0) == '<') {
            char c;
            pos2 = 2;
            do {
                int end = signature2.indexOf(58, pos2);
                v.visitFormalTypeParameter(signature2.substring(pos2 - 1, end));
                pos2 = end + 1;
                c = signature2.charAt(pos2);
                if (c == 'L' || c == '[' || c == 'T') {
                    pos2 = SignatureReader.parseType(signature2, pos2, v.visitClassBound());
                }
                while ((c = signature2.charAt(pos2++)) == ':') {
                    pos2 = SignatureReader.parseType(signature2, pos2, v.visitInterfaceBound());
                }
            } while (c != '>');
        } else {
            pos2 = 0;
        }
        if (signature2.charAt(pos2) == '(') {
            ++pos2;
            while (signature2.charAt(pos2) != ')') {
                pos2 = SignatureReader.parseType(signature2, pos2, v.visitParameterType());
            }
            pos2 = SignatureReader.parseType(signature2, pos2 + 1, v.visitReturnType());
            while (pos2 < len) {
                pos2 = SignatureReader.parseType(signature2, pos2 + 1, v.visitExceptionType());
            }
        } else {
            pos2 = SignatureReader.parseType(signature2, pos2, v.visitSuperclass());
            while (pos2 < len) {
                pos2 = SignatureReader.parseType(signature2, pos2, v.visitInterface());
            }
        }
    }

    public void acceptType(SignatureVisitor v) {
        SignatureReader.parseType(this.signature, 0, v);
    }

    private static int parseType(String signature2, int pos2, SignatureVisitor v) {
        char c = signature2.charAt(pos2++);
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                v.visitBaseType(c);
                return pos2;
            }
            case '[': {
                return SignatureReader.parseType(signature2, pos2, v.visitArrayType());
            }
            case 'T': {
                int end = signature2.indexOf(59, pos2);
                v.visitTypeVariable(signature2.substring(pos2, end));
                return end + 1;
            }
        }
        int start2 = pos2;
        boolean visited = false;
        boolean inner2 = false;
        while (true) {
            c = signature2.charAt(pos2++);
            block5 : switch (c) {
                case '.': 
                case ';': {
                    String name2;
                    if (!visited) {
                        name2 = signature2.substring(start2, pos2 - 1);
                        if (inner2) {
                            v.visitInnerClassType(name2);
                        } else {
                            v.visitClassType(name2);
                        }
                    }
                    if (c == ';') {
                        v.visitEnd();
                        return pos2;
                    }
                    start2 = pos2;
                    visited = false;
                    inner2 = true;
                    break;
                }
                case '<': {
                    String name2 = signature2.substring(start2, pos2 - 1);
                    if (inner2) {
                        v.visitInnerClassType(name2);
                    } else {
                        v.visitClassType(name2);
                    }
                    visited = true;
                    block15: while (true) {
                        c = signature2.charAt(pos2);
                        switch (c) {
                            case '>': {
                                break block5;
                            }
                            case '*': {
                                ++pos2;
                                v.visitTypeArgument();
                                continue block15;
                            }
                            case '+': 
                            case '-': {
                                pos2 = SignatureReader.parseType(signature2, pos2 + 1, v.visitTypeArgument(c));
                                continue block15;
                            }
                        }
                        pos2 = SignatureReader.parseType(signature2, pos2, v.visitTypeArgument('='));
                    }
                }
            }
        }
    }
}

