/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline_embedded.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import scala.tools.jline_embedded.internal.Log;
import scala.tools.jline_embedded.internal.Preconditions;
import scala.tools.jline_embedded.internal.Urls;

public class Configuration {
    public static final String JLINE_CONFIGURATION = "scala.tools.jline_embedded.configuration";
    public static final String JLINE_RC = ".jline.rc";
    private static volatile Properties properties;

    private static Properties initProperties() {
        URL url = Configuration.determineUrl();
        Properties props2 = new Properties();
        try {
            Configuration.loadProperties(url, props2);
        }
        catch (IOException e) {
            Log.debug("Unable to read configuration from: ", url, e);
        }
        return props2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties(URL url, Properties props2) throws IOException {
        Log.debug("Loading properties from: ", url);
        InputStream input2 = url.openStream();
        try {
            props2.load(new BufferedInputStream(input2));
        }
        finally {
            try {
                input2.close();
            }
            catch (IOException e) {}
        }
        if (Log.DEBUG) {
            Log.debug("Loaded properties:");
            for (Map.Entry<Object, Object> entry2 : props2.entrySet()) {
                Log.debug("  ", entry2.getKey(), "=", entry2.getValue());
            }
        }
    }

    private static URL determineUrl() {
        String tmp = System.getProperty(JLINE_CONFIGURATION);
        if (tmp != null) {
            return Urls.create(tmp);
        }
        File file = new File(Configuration.getUserHome(), JLINE_RC);
        return Urls.create(file);
    }

    public static void reset() {
        Log.debug("Resetting");
        properties = null;
        Configuration.getProperties();
    }

    public static Properties getProperties() {
        if (properties == null) {
            properties = Configuration.initProperties();
        }
        return properties;
    }

    public static String getString(String name2, String defaultValue2) {
        Preconditions.checkNotNull(name2);
        String value2 = System.getProperty(name2);
        if (value2 == null && (value2 = Configuration.getProperties().getProperty(name2)) == null) {
            value2 = defaultValue2;
        }
        return value2;
    }

    public static String getString(String name2) {
        return Configuration.getString(name2, null);
    }

    public static boolean getBoolean(String name2, boolean defaultValue2) {
        String value2 = Configuration.getString(name2);
        if (value2 == null) {
            return defaultValue2;
        }
        return value2.length() == 0 || value2.equalsIgnoreCase("1") || value2.equalsIgnoreCase("on") || value2.equalsIgnoreCase("true");
    }

    public static int getInteger(String name2, int defaultValue2) {
        String str = Configuration.getString(name2);
        if (str == null) {
            return defaultValue2;
        }
        return Integer.parseInt(str);
    }

    public static long getLong(String name2, long defaultValue2) {
        String str = Configuration.getString(name2);
        if (str == null) {
            return defaultValue2;
        }
        return Long.parseLong(str);
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static File getUserHome() {
        return new File(System.getProperty("user.home"));
    }

    public static String getOsName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static boolean isWindows() {
        return Configuration.getOsName().startsWith("windows");
    }

    public static String getFileEncoding() {
        return System.getProperty("file.encoding");
    }

    public static String getEncoding() {
        String envEncoding = Configuration.extractEncodingFromCtype(System.getenv("LC_CTYPE"));
        if (envEncoding != null) {
            return envEncoding;
        }
        return System.getProperty("input.encoding", Charset.defaultCharset().name());
    }

    static String extractEncodingFromCtype(String ctype) {
        if (ctype != null && ctype.indexOf(46) > 0) {
            String encodingAndModifier = ctype.substring(ctype.indexOf(46) + 1);
            if (encodingAndModifier.indexOf(64) > 0) {
                return encodingAndModifier.substring(0, encodingAndModifier.indexOf(64));
            }
            return encodingAndModifier;
        }
        return null;
    }
}

