'use strict';

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _diff = require('diff');

var _chalk = require('chalk');

var _config = require('../metarpheus/config');

var _config2 = _interopRequireDefault(_config);

var _run = require('../metarpheus/run');

var _run2 = _interopRequireDefault(_run);

var _util = require('../../util');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _runMetarpheusTcomb = (0, _run2.default)(_config2.default),
    model = _runMetarpheusTcomb.model,
    api = _runMetarpheusTcomb.api;

var parseDiffsAcc = {
  output: '\n',
  exitCode: 0
};

function getExitCode(part, exitCode) {
  if (part.added || part.removed) {
    return 1;
  }
  return exitCode;
}

function buildOutput(part) {
  if (part.added || part.removed) {
    var color = part.added ? _chalk.green : _chalk.red;
    return color(part.value);
  }
  return '';
}

function parseDiffs(_ref, part) {
  var output = _ref.output,
      exitCode = _ref.exitCode;

  return {
    exitCode: getExitCode(part, exitCode),
    output: output + buildOutput(part)
  };
}

// API diff
_util.logger.metarpheusDiff('Diffing api files...');

var _diffLines$reduce = (0, _diff.diffLines)(_fs2.default.readFileSync(_config2.default.apiOut, 'utf-8'), api).reduce(parseDiffs, parseDiffsAcc),
    apiOutput = _diffLines$reduce.output,
    apiExitCode = _diffLines$reduce.exitCode;

process.stdout.write(apiOutput);

// model diff
_util.logger.metarpheusDiff('Diffing models files...');

var _diffLines$reduce2 = (0, _diff.diffLines)(_fs2.default.readFileSync(_config2.default.modelOut, 'utf-8'), model).reduce(parseDiffs, parseDiffsAcc),
    modelOutput = _diffLines$reduce2.output,
    modelExitCode = _diffLines$reduce2.exitCode;

process.stdout.write(modelOutput);

// exit with code from diffs
process.exit(modelExitCode || apiExitCode);