/**
 * Created by zhangyq on 2016/9/15.
 */

import React from 'react';
import model from './models/model.js';
import 'antd/dist/antd.css';
import Table from 'antd/lib/table';
import Icon from 'antd/lib/icon';
import Button from 'antd/lib/button';
import Popconfirm from 'antd/lib/popconfirm';
//import { Table, Icon,Popconfirm } from 'antd';

const rowSelection = {
    onChange: (selectedRowKeys, selectedRows) => {
        console.log(`selectedRowKeys: ${selectedRowKeys}`, 'selectedRows: ', selectedRows);
    },
    onSelect: (record, selected, selectedRows) => {
        console.log(record, selected, selectedRows);
    },
    onSelectAll: (selected, selectedRows, changeRows) => {
        console.log(selected, selectedRows, changeRows);
    },
};


const ListExample = React.createClass({
        getInitialState()
        {
            this.columns = [{
                title: 'Name',
                dataIndex: 'name',
                key: 'name',
                render: text => <a href="#">{text}</a>,
            }, {
                title: 'Age',
                dataIndex: 'age',
                key: 'age',
            }, {
                title: 'Address',
                dataIndex: 'address',
                key: 'address',
            }, {
                title: 'Action',
                key: 'action',
                render: (text, record, index) => (
                    <span>
      <a href="#" onClick={this.handleAdd} >Add</a>

      <span className="ant-divider"/>
      <Popconfirm title="Sure to delete?" onConfirm={this.onDelete(index)}>
          <a href="#">Delete</a>
      </Popconfirm>
                        <span className="ant-divider"/>
      <a href="#" onClick={this.handleAdd} >Update</a>
                        <span className="ant-divider"/>
                        <a href="#" onClick={this.handleAdd} >Detail</a>
    </span>
                ),
            }];

            return {
                list: []
            };
        },

        componentWillMount()
        {
            var that = this;
            var displayItemsData = [];
            model.query(function (response) {
                if (response) {
                    console.log(JSON.stringify(response.data));
                    response.data.map(function (item, i) {
                        var itemData = {};
                        itemData.key = item.id;
                        itemData.name = item.name;
                        itemData.age = item.age;
                        itemData.address = item.description;
                        var picPath = "http://121.196.221.190:8080/" + item.pic;
                        itemData.media = picPath;


                        displayItemsData.push(itemData);
                    });
                    that.setState({list: displayItemsData});
                }
            });
        },
        pagination(){
            return {
                total: this.state.list.length,
                showSizeChanger: true,
                onShowSizeChange: (current, pageSize) => {
                    console.log('Current: ', current, '; PageSize: ', pageSize);
                },
                onChange: (current) => {
                    console.log('Current: ', current);
                },
            };
        },
        handleAdd(){
            const { count, list } = this.state;
            const newData = {
                key: count,
                name: `Edward King ${count}`,
                age: 33,
                address: `London, Park Lane no. ${count}`,
            };
            this.setState({
                list: [...this.state.list, newData],
                count: count + 1,
            });
        },
        onDelete(index){
            return ()=>alert("remove row[" + index + "]");
        },
        render()
        {
            return (
                <div>


                    <Table rowSelection={rowSelection} columns={this.columns} dataSource={this.state.list}
                           pagination={this.pagination()}
                           bordered
                           title={() => <Button className="editable-add-btn" type="ghost" onClick={this.handleAdd}>Add</Button>}
                           footer={() => 'Footer'}/>

                </div>
            );
        }
    })
    ;

export default ListExample;

