package <%=data.packageName%>.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
//import org.springframework.web.servlet.ModelAndView;

import com.simple.core.base.user.entity.*;
import com.simple.core.base.user.service.*;

import com.simple.server.bz.entity.*;
import com.simple.server.bz.service.*;

import <%=data.packageName%>.entity.*;
import <%=data.packageName%>.service.*;
import <%=data.packageName%>.dao.*;


//import io.swagger.annotations.ApiImplicitParam;
//import io.swagger.annotations.ApiOperation;

@Controller
@RequestMapping("/<%=data.originModuleName%>")
public class <%=data.moduleName%>Controller {
	@Autowired
	<%=data.moduleName%>Service service;

	@Autowired
    <%=data.moduleName%>QueryDao queryDao;

  <% for (var field in data.moduleDefine){
                var fieldDef  = data.moduleDefine[field];
                var fieldName = fieldDef.dName;
                var keyName = field;

                var refer = fieldDef.refer;
                if (refer) {
                var clsName = data.firstUpper(refer.module);
                %>
   @Autowired
   private  <%=clsName%>Service <%=refer.module%>Service;
   <%}}%>


	@RequestMapping(value= "/", method=RequestMethod.GET)
    public String rootpage(){
    	       return "index";
    }
	@RequestMapping(value = "/queryAll", method = RequestMethod.GET)
	@ResponseBody
	public List<<%=data.moduleName%>> findAll() {
		return service.findAll();
	}
	@ResponseBody
    @RequestMapping(value = "/query/{id}", method = RequestMethod.GET)
    public <%=data.moduleName%> findById(@PathVariable Long id) {
       	System.out.println("input param Id:" + id);
       	<%=data.moduleName%> result = service.findById(id);
    	return result;
    }
    @ResponseBody
    @RequestMapping(value = "/queryByNameLike/", method = RequestMethod.GET)
    public List<<%=data.moduleName%>> findByNameLike(@RequestParam("name") String name ) {
           	System.out.println("input param Name:" + name);
            return service.findByNameLike(name);

    }


    @ResponseBody
    @RequestMapping(value = "/queryByName", method = RequestMethod.GET)
    public List<<%=data.moduleName%>> findByName(@RequestParam("name") String name ) {
           	System.out.println("input param Name:" + name);
            return queryDao.findByName(name);

    }

    @ResponseBody
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	public Long save2(@RequestBody <%=data.moduleName%> item) {
		 <% for (var field in data.moduleDefine){
                                   var fieldDef  = data.moduleDefine[field];
                                   var fieldName = fieldDef.dName;
                                   var keyName = field;

                                   var refer = fieldDef.refer;
                                   if (refer&&(refer.map==="ManyToOne")) {
                                   var clsName = data.firstUpper(refer.module);
                                   var fieldNameUpper = data.firstUpper(field);
                                   var idType = data.moduleDefine['id'].type;
                                   if(refer.module==='user'){%>
         User currentUser = userService.obtainCurrentUser();
         if(null == currentUser){throw new RuntimeException("User not Login!"); };
         item.set<%=fieldNameUpper%>(currentUser);
                                   <%}}}%>

		System.out.println("input device params:" + item.toString());
		<%=data.moduleName%> result = service.save(item);
		System.out.println("output device result data:" + result.toString());
		return result.getId();
	}



 	@ResponseBody
    @RequestMapping(value = "/update/{id}", method = RequestMethod.POST)
    public Long updateSave(@PathVariable Long id, @RequestBody <%=data.moduleName%> item) {
     	   <% for (var field in data.moduleDefine){
                           var fieldDef  = data.moduleDefine[field];
                           var fieldName = fieldDef.dName;
                           var keyName = field;

                           var refer = fieldDef.refer;
                           if (refer&&(refer.map==="ManyToOne")) {

                           var clsName = data.firstUpper(refer.module);
                           var fieldNameUpper = data.firstUpper(field);
                           var idType = data.moduleDefine['id'].type;
                           if(refer.module==='user'){%>
         User currentUser = userService.obtainCurrentUser();
         if(null == currentUser){throw new RuntimeException("User not Login!"); };
         item.set<%=fieldNameUpper%>(currentUser);
                                             <%}}}%>

     	 System.out.println("input device params:" + item.toString());
     	 <%=data.moduleName%> result = service.save(item);
     	 System.out.println("output device result data:" + result.toString());
     	 return result.getId();
    }



    @ResponseBody
   	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
   	public Long remove(@PathVariable Long id) {
		service.remove(id);
        return id;
    }
    @ResponseBody
    @RequestMapping(value = "/remove/{id}", method = RequestMethod.POST)
    public Long removeById(@PathVariable Long id) {
    	service.remove(id);
    	return id;
    }




    <%if (data.moduleName=='Dictionary'){%>
    @ResponseBody
    @RequestMapping(value = "/queryByCategory/", method = RequestMethod.GET)
    public List<Dictionary> findByParams(@RequestParam("category") String category) {
           	System.out.println("input param category:" + category);
            Category citem  = categoryService.findOneByName(category);
           	List<Dictionary> result = service.findByCategory(citem);
        	return result;
    }
   <%}%>

}