import React from 'react';
import { browserHistory } from 'react-router';
import { Form, Input,Button} from 'antd';
import model from './models/model.js';
import '../common/styles/App.less';

const FormItem = Form.Item;
const formItemLayout = {
    labelCol: {
        span: 6,
    },
    wrapperCol: {
        span: 14,
    },
};


class EditForm extends React.Component {
    constructor(props) {
        super(props);
        this.state = {};
        this.state.item = this.props.location.state.item;

    }
    componentWillMount(){
        this.setState({item:this.props.location.state.item});
    }
    
    handleSubmit(e) {
        browserHistory.push('/<%=data.endName%>/<%=data.moduleName%>/');
    }
   

checkNumber(rule, value, callback)
{
    if (!value) {
        callback(new Error('年龄未填写'));
    }
    if (!/^[\d]{1,2}$/.test(value)) {
        callback(new Error('年龄不合法'));
    } else {
        callback();
    }
}


render()
{
        
    var listItem = this.state.item;
    const { getFieldDecorator } = this.props.form;
    console.log("modal interal" + JSON.stringify(listItem));
    
    return (
        
            <Form horizontal onSubmit={this.handleSubmit.bind(this)}>
                <%
                for (var field in data.moduleDefine){
                    var fieldDisplayName = data.moduleDefine[field].dName;
                    var fieldShow = data.moduleDefine[field].show;
                    var fieldRefer =  data.moduleDefine[field].refer;

                    if (fieldShow=="image"){
                %>
                <FormItem
                    label="<%=fieldDisplayName%>"
                    hasFeedback
                    {...formItemLayout}
                    >
                    {getFieldDecorator("<%=field%>", {
                        initialValue: 'empty',
                    })(
                        <FileUpload />
                    )}
                </FormItem>


                <%}else if ((fieldShow=="select")&&(fieldRefer)){
                    var referCategory;var referm;
                    if (fieldRefer.module == "dictionary"){
                        referCategory = fieldRefer.category;
                        referm ="";
                    }else{
                        referCategory="";
                        referm = fieldRefer.module;
                    }

                %>

                <Form.Item label="<%=fieldDisplayName%>"
                            hasFeedback {...formItemLayout}> {
                    getFieldDecorator("<%=field%>", {
                        initialValue: {id:"-1"},
                    })(
                        < XSelect  category="<%=referCategory%>" refer ="<%=referm%>"  />
                    )}
                    < /Form.Item>

                <%}else if(fieldShow=="yes"){%>
                        <FormItem
                            label="<%=fieldDisplayName%>"
                            hasFeedback
                            {...formItemLayout}
                            >
                            {getFieldDecorator("<%=field%>", {
                                initialValue: 'test',
                                rules: [
                                    {required: true, message: '名称未填写'},
                                ],
                            })(
                                <Input type="text" />
                            )}
                        </FormItem>
                <%}}%>
                 <FormItem className="form-item-clear" >
                    <Button type="primary" htmlType="submit" size="large">Go Back</Button>
                </FormItem>
            </Form>
        
    );
}
}

export default Form.create()(EditForm);
