import React from 'react';
import { browserHistory } from 'react-router';
import { Form, Input,Button} from 'antd';
import FileUpload from '../common/components/form/upload';
import XSelect from '../common/components/form/select';
import model from './models/model.js';
import '../common/styles/App.less';

const FormItem = Form.Item;
const formItemLayout = {
    labelCol: {
        span: 6,
    },
    wrapperCol: {
        span: 14,
    },
};


class EditForm extends React.Component {
    constructor(props) {
        super(props);
        this.state = {};
        this.state.item = this.props.location.state.item;

    }
    componentWillMount(){
        this.setState({item:this.props.location.state.item});
    }
    
    handleSubmitUpdate(data) {
        model.update(data, function(response) {
            if (response && response.data) {
                console.log(data);
                browserHistory.push('/<%=data.endName%>/<%=data.moduleName%>/');
            }
        })

    }
    
    handleSubmit(e) {
        e.preventDefault();
        var that = this;
        this.props.form.validateFieldsAndScroll((err, values) => {
            if (!err) {
                const data = {...values, id:this.state.item.id};
                console.log('Received values of form: ', values);
                that.handleSubmitUpdate(data);
            }
        });
    }
   

checkNumber(rule, value, callback)
{
    if (!value) {
        callback(new Error('年龄未填写'));
    }
    if (!/^[\d]{1,2}$/.test(value)) {
        callback(new Error('年龄不合法'));
    } else {
        callback();
    }
}


render()
{
        
    var listItem = this.state.item;
    var sexId;
    if (!listItem.sex){
        sexId = "-1";
    } else {
        if(!listItem.sex.id){
            sexId = "-1";
        }else{
            sexId = listItem.sex.id;
        }
    }
    const { getFieldDecorator } = this.props.form;
    console.log("modal interal" + JSON.stringify(listItem));
    
    return (
        
            <Form horizontal onSubmit={this.handleSubmit.bind(this)}>
               <%
                for (var field in data.moduleDefine){
                    var fieldDisplayName = data.moduleDefine[field].dName;
                    var fieldShow = data.moduleDefine[field].show;
                    var fieldRefer =  data.moduleDefine[field].refer;

                    if (fieldShow=="image"){
                %>
                <FormItem
                    label="<%=fieldDisplayName%>"
                    hasFeedback
                    {...formItemLayout}
                    >
                    {getFieldDecorator("<%=field%>", {
                        initialValue: 'empty',
                    })(
                        <FileUpload />
                    )}
                </FormItem>


                <%}else if ((fieldShow=="select")&&(fieldRefer)){
                    var referCategory;var referm;
                    if (fieldRefer.module == "dictionary"){
                        referCategory = fieldRefer.category;
                        referm ="";
                    }else{
                        referCategory="";
                        referm = fieldRefer.module;
                    }

                %>

                <Form.Item label="<%=fieldDisplayName%>"
                            hasFeedback {...formItemLayout}> {
                    getFieldDecorator("<%=field%>", {
                        initialValue: {id:"-1"},
                    })(
                        < XSelect  category="<%=referCategory%>" refer ="<%=referm%>"  />
                    )}
                    < /Form.Item>

                <%}else if(fieldShow=="yes"){%>
                        <FormItem
                            label="<%=fieldDisplayName%>"
                            hasFeedback
                            {...formItemLayout}
                            >
                            {getFieldDecorator("<%=field%>", {
                                initialValue: 'test',
                                rules: [
                                    {required: true, message: '名称未填写'},
                                ],
                            })(
                                <Input type="text" />
                            )}
                        </FormItem>
                <%}}%>
                 <FormItem className="form-item-clear" >
                    <Button type="primary" htmlType="submit" size="large">Save</Button>
                </FormItem>
            </Form>
        
    );
}
}

export default Form.create()(EditForm);
