(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(require('substance'), require('substance-texture'), require('stencila')) :
	typeof define === 'function' && define.amd ? define(['substance', 'substance-texture', 'stencila'], factory) :
	(factory(global.window.substance,global.window.texture,global.window.stencila));
}(this, (function (substance,substanceTexture,stencila) { 'use strict';

window.addEventListener('load', () => {
  substance.substanceGlobals.DEBUG_RENDERING = substance.platform.devtools;
  App.mount({}, window.document.body);
});

class App extends substance.Component {

  didMount() {
    this._init();
    substance.DefaultDOMElement.getBrowserWindow().on('keydown', this._keyDown, this);
  }

  dispose() {
    substance.DefaultDOMElement.getBrowserWindow().off(this);
  }

  getInitialState() {
    return {
      archive: undefined,
      error: undefined
    }
  }

  render($$) {
    let el = $$('div').addClass('sc-app');
    let { archive, host, functionManager, engine, error } = this.state;

    if (archive) {

      el.append(
        $$(stencila.Project, {
          documentArchive: archive,
          host,
          functionManager,
          engine
        })
      );
    } else if (error) {
      if (error.type === 'jats-import-error') {
        el.append(
          $$(substanceTexture.JATSImportDialog, { errors: error.detail })
        );
      } else {
        el.append(
          'ERROR:',
          error.message
        );
      }
    } else {
      // LOADING...
    }
    return el
  }

  _init() {
    let archiveId = substance.getQueryStringParam('archive') || 'kitchen-sink';
    let storageType = substance.getQueryStringParam('storage') || 'vfs';
    let storageUrl = substance.getQueryStringParam('storageUrl') || '/archives';
    let storage;
    if (storageType==='vfs') {
      storage = new substance.VfsStorageClient(window.vfs, './examples/');
    } else {
      storage = new substance.HttpStorageClient(storageUrl);
    }
    let buffer = new substance.InMemoryDarBuffer();
    let archive = new stencila.StencilaArchive(storage, buffer);
    archive.load(archiveId)
    .then(() => {
      return stencila.setupStencilaContext(archive)
    }).then(({host, functionManager, engine}) => {
      this.setState({archive, functionManager, engine, host});
    })
    .catch(error => {
      console.error(error);
      this.setState({error});
    });
  }

  /*
    We may want an explicit save button, that can be configured on app level,
    but passed down to editor toolbars.
  */
  _save() {
    this.state.archive.save().then(() => {
      console.info('successfully saved');
    }).catch(err => {
      console.error(err);
    });
  }

  _keyDown(e) {
    let key = substance.parseKeyEvent(e);
    // CommandOrControl+S
    if (key === 'META+83' || key === 'CTRL+83') {
      this._save();
      e.preventDefault();
    }
  }
}

})));

//# sourceMappingURL=./app.js.map