window.STENCILA_LIBCORE = "\n<!DOCTYPE function PUBLIC \"StencilaFunctionLibrary 1.0\" \"StencilaFunctionLibrary.dtd\">\n<library name=\"stencila-libcore\">\n<function>\n    <name>add</name>\n    <title>add</title>\n    <summary>Addition of two values</summary>\n    <description>Returns the addition of two values. The plus sign, `+`, is used as an alias for `add` e.g. `x + y` is equivalent to `add(x, y)`.</description>\n    <examples>\n        <example>\n            <usage>add(x, y)</usage>\n        </example>\n        <example>\n            <usage>x + y</usage>\n        </example>\n    </examples>\n    <params>\n        <param name=\"value\" type=\"any\">\n            <description>The number</description>\n        </param>\n        <param name=\"other\" type=\"any\">\n            <description>The other number</description>\n        </param>\n    </params>\n    <return type=\"any\">\n        <description>Result of addition</description>\n    </return>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n    <authors>\n        <author>Nokome Bentley</author>\n    </authors>\n</function>\n<function>\n    <name>and</name>\n    <params>\n        <param name=\"value\" type=\"any\"/>\n        <param name=\"other\" type=\"any\"/>\n    </params>\n    <return type=\"any\"/>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n</function>\n<function>\n    <name>divide</name>\n    <title>divide</title>\n    <summary>Divide two numbers</summary>\n    <description>Divide two numbers. The asterisk, `/`, is used as an alias for `divide` e.g. `x / y` is equivalent to `divide(x, y)`.</description>\n    <examples>\n        <example>\n            <usage>divide(x, y)</usage>\n        </example>\n        <example>\n            <usage>x / y</usage>\n        </example>\n    </examples>\n    <params>\n        <param name=\"value\" type=\"number\">\n            <description>The value to be divided</description>\n        </param>\n        <param name=\"other\" type=\"number\">\n            <description>The divisor</description>\n        </param>\n    </params>\n    <return type=\"number\">\n        <description>Division result</description>\n    </return>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n    <authors>\n        <author>Nokome Bentley</author>\n    </authors>\n</function>\n<function>\n    <name>greater_or_equal</name>\n    <params>\n        <param name=\"value\" type=\"any\"/>\n        <param name=\"other\" type=\"any\"/>\n    </params>\n    <return type=\"any\"/>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n</function>\n<function>\n    <name>greater</name>\n    <params>\n        <param name=\"value\" type=\"any\"/>\n        <param name=\"other\" type=\"any\"/>\n    </params>\n    <return type=\"any\"/>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n</function>\n<function>\n    <name>less_or_equal</name>\n    <params>\n        <param name=\"value\" type=\"any\"/>\n        <param name=\"other\" type=\"any\"/>\n    </params>\n    <return type=\"any\"/>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n</function>\n<function>\n    <name>less</name>\n    <params>\n        <param name=\"value\" type=\"any\"/>\n        <param name=\"other\" type=\"any\"/>\n    </params>\n    <return type=\"any\"/>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n</function>\n<function>\n    <name>multiply</name>\n    <title>multiply</title>\n    <summary>Multiply two numbers</summary>\n    <description>Multiply two numbers. The asterisk, `*`, is used as an alias for `multiply` e.g. `x * y` is equivalent to `multiply(x, y)`.</description>\n    <examples>\n        <example>\n            <usage>multiply(x, y)</usage>\n        </example>\n        <example>\n            <usage>x * y</usage>\n        </example>\n    </examples>\n    <params>\n        <param name=\"value\" type=\"number\">\n            <description>The value to be multiplied</description>\n        </param>\n        <param name=\"other\" type=\"number\">\n            <description>The multiplier</description>\n        </param>\n    </params>\n    <return type=\"number\">\n        <description>Muliplication result</description>\n    </return>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n    <authors>\n        <author>Nokome Bentley</author>\n    </authors>\n</function>\n<function>\n    <name>negative</name>\n    <title>negative</title>\n    <summary>Return the negative of the value</summary>\n    <description>Returns the negative of the value. The unary negation, `-` operator is an alias for `negative` e.g. `-x` is equivalent to `negative(x)`.</description>\n    <examples>\n        <example>\n            <usage>negative(x)</usage>\n        </example>\n        <example>\n            <usage>-x</usage>\n        </example>\n    </examples>\n    <params>\n        <param name=\"value\" type=\"number\">\n            <description>The value</description>\n        </param>\n    </params>\n    <return type=\"number\">\n        <description>The negative of the value</description>\n    </return>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n    <authors>\n        <author>Nokome Bentley</author>\n    </authors>\n</function>\n<function>\n    <name>not_equal</name>\n    <params>\n        <param name=\"value\" type=\"any\"/>\n        <param name=\"other\" type=\"any\"/>\n    </params>\n    <return type=\"any\"/>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n</function>\n<function>\n    <name>not</name>\n    <title>Not</title>\n    <summary>Logically invert an expression</summary>\n    <description>If `value` is `true` then return `false`, and if `false` then return `true`. The exclamation operator `!` is an alias for `not` e.g. `!(x>0)` is equivalent to `not(x>0)`.</description>\n    <examples>\n        <example>\n            <usage>not(x > 4)</usage>\n        </example>\n    </examples>\n    <params>\n        <param name=\"value\" type=\"boolean\">\n            <description>The value to be negated</description>\n        </param>\n    </params>\n    <return type=\"boolean\">\n        <description>The logical inverse</description>\n    </return>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n    <authors>\n        <author>Nokome Bentley</author>\n    </authors>\n</function>\n<function>\n    <name>or</name>\n    <params>\n        <param name=\"value\" type=\"any\"/>\n        <param name=\"other\" type=\"any\"/>\n    </params>\n    <return type=\"any\"/>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n</function>\n<function>\n    <name>positive</name>\n    <title>positive</title>\n    <summary>Return the value unmodifed</summary>\n    <description>This function does nothing but is provided for completeness as the antonym of the `negative` function and to support the plus operator `+`. The `+` operator is an alias for `positive` e.g. `+x` is equivalent to `positive(x)`, which is equivalent to\n        `x`.</description>\n    <examples>\n        <example>\n            <usage>positive(x)</usage>\n        </example>\n        <example>\n            <usage>+x</usage>\n        </example>\n    </examples>\n    <params>\n        <param name=\"value\" type=\"number\">\n            <description>The value</description>\n        </param>\n    </params>\n    <return type=\"number\">\n        <description>The value</description>\n    </return>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n    <authors>\n        <author>Nokome Bentley</author>\n    </authors>\n</function>\n<function>\n    <name>pow</name>\n    <title>pow</title>\n    <summary>Raise a value to a power</summary>\n    <description>Returns the value raised to the power. The caret character, `^`, is used as an alias for `pow` e.g. `x ^ y` is equivalent to `pow(x, y)`.</description>\n    <examples>\n        <example>\n            <usage>pow(x, y)</usage>\n        </example>\n        <example>\n            <usage>x ^ y</usage>\n        </example>\n    </examples>\n    <params>\n        <param name=\"value\" type=\"number\">\n            <description>Base value to be raised</description>\n        </param>\n        <param name=\"exponent\" type=\"number\">\n            <description>Exponent</description>\n        </param>\n    </params>\n    <return type=\"number\">\n        <description>Vakue raised to the power of the exponent</description>\n    </return>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n    <authors>\n        <author>Nokome Bentley</author>\n    </authors>\n</function>\n<function>\n    <name>remainder</name>\n    <title>remainder</title>\n    <summary>Remainder</summary>\n    <description>Returns the remainder left over when a number is divided by a second number. The percent sign, `%`, is used as an alias for `remainder` e.g. `x % y` is equivalent to `remainder(x, y)`.</description>\n    <examples>\n        <example>\n            <usage>remainder(x, y)</usage>\n        </example>\n        <example>\n            <usage>x % y</usage>\n        </example>\n    </examples>\n    <params>\n        <param name=\"value\" type=\"number\">\n            <description>The number</description>\n        </param>\n        <param name=\"other\" type=\"number\">\n            <description>The other number</description>\n        </param>\n    </params>\n    <return type=\"number\">\n        <description>Remainder</description>\n    </return>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n    <authors>\n        <author>Nokome Bentley</author>\n    </authors>\n</function>\n<function>\n    <name>select</name>\n    <title>Select</title>\n    <summary>Select one or more members of a value</summary>\n    <description>A general purpose function for selecting members of a compound value (e.g. array, object or table) . When the `members` parameter is an atomic value (e.g. an integer or a string) then a single member is returned. For example, `select(array, 2)` returns\n        the second member of an array. When `members` is an array, then one or more members are returned. One-based indexing is used. The dot operator `.` is an alias for `select` with a single string e.g `table.column1` is equaivalent to `select(table,\n        'column1')`. The square brackets operator `[]` is an alias for `select` for other member selectors e.g `table[['column1', 'column2']]` is equaivalent to `select(table, ['column1', 'column2'])`.</description>\n    <examples>\n        <example>\n            <usage>select(array, index)</usage>\n        </example>\n        <example>\n            <usage>select(object, 'property')</usage>\n        </example>\n        <example>\n            <usage>select(table, ['column1', 'column2'])</usage>\n        </example>\n    </examples>\n    <params>\n        <param name=\"value\" type=\"any\">\n            <description>The value to select values from</description>\n        </param>\n        <param name=\"members\" type=\"any\">\n            <description>The members to select from the value</description>\n        </param>\n    </params>\n    <return type=\"any\">\n        <description>The members of the value</description>\n    </return>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n    <authors>\n        <author>Nokome Bentley</author>\n    </authors>\n</function>\n<function>\n    <name>sleep</name>\n    <description>Delay execution for a specified time interval (in seconds). In Javascript this function is implemented in blocking, CPU-hogging way.</description>\n    <params>\n        <param name=\"seconds\" type=\"number\">\n            <description>Duration of delay</description>\n        </param>\n    </params>\n    <return type=\"number\">\n        <description>Duration of delay</description>\n    </return>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n</function>\n<function>\n    <name>subtract</name>\n    <title>subtract</title>\n    <summary>Subtraction of two values</summary>\n    <description>Returns the subtraction of two values. The minus sign, `-`, is used as an alias for `subtract` e.g. `x - y` is equivalent to `subtract(x, y)`.</description>\n    <examples>\n        <example>\n            <usage>subtract(x, y)</usage>\n        </example>\n        <example>\n            <usage>x - y</usage>\n        </example>\n    </examples>\n    <params>\n        <param name=\"value\" type=\"any\">\n            <description>The number</description>\n        </param>\n        <param name=\"other\" type=\"any\">\n            <description>The other number</description>\n        </param>\n    </params>\n    <return type=\"any\">\n        <description>Result of subtraction</description>\n    </return>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n    <authors>\n        <author>Nokome Bentley</author>\n    </authors>\n</function>\n<function>\n    <name>sum</name>\n    <title>Sum</title>\n    <summary>Sum of numbers</summary>\n    <params>\n        <param name=\"values\" type=\"array[number]\">\n            <description>An array of numbers to sum</description>\n        </param>\n    </params>\n    <return type=\"number\">\n        <description>The sum of the numbers</description>\n    </return>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n    <authors>\n        <author>Nokome Bentley</author>\n    </authors>\n</function>\n<function>\n    <name>table</name>\n    <title>table</title>\n    <summary>Create a table value</summary>\n    <description>Creates a table from either an object of arrays, or an array of objects.</description>\n    <examples>\n        <example>\n            <usage>table({height: [134, 213, 456], weight: [432, 423, 898]})</usage>\n        </example>\n        <example>\n            <usage>table([{height: 134, weight: 432}, ...])</usage>\n        </example>\n    </examples>\n    <params>\n        <param name=\"value\" type=\"any\">\n            <description>Either an object of arrays, or an array of objects</description>\n        </param>\n    </params>\n    <return type=\"table\">\n        <description>A new value of type 'table'</description>\n    </return>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n</function>\n<function>\n  <name>between</name>\n  <title>Between</title>\n  <params>\n    <param name=\"value\" type=\"number\">\n      <description>The value to test.</description>\n    </param>\n    <param name=\"lower\" type=\"number\">\n      <description>The lower bound of the range.</description>\n    </param>\n    <param name=\"upper\" type=\"number\">\n      <description>The upper bound of the range.</description>\n    </param>\n  </params>\n  <return type=\"boolean\">\n    <description>True if the value is between lower and upper, else false.</description>\n  </return>\n  <implems>\n    <implem language=\"js\"/>\n  </implems>\n</function>\n<function>\n  <name>close</name>\n  <title>Close</title>\n  <summary>Is a value close to another?</summary>\n  <params>\n    <param name=\"value\" type=\"number\">\n      <description>The value to test.</description>\n    </param>\n    <param name=\"other\" type=\"number\">\n      <description>The other value to compare to.</description>\n    </param>\n    <param name=\"precision\" type=\"number\">\n      <description>The precision of the comparision.</description>\n    </param>\n  </params>\n  <return type=\"boolean\">\n    <description>True if the value is within plus or minus precision of the other value, else false.</description>\n  </return>\n  <implems>\n    <implem language=\"js\"/>\n  </implems>\n</function>\n<function>\n  <name>cor</name>\n  <title>Pearson correlation</title>\n  <summary/>\n  <description/>\n  <relateds>\n    <related/>\n  </relateds>\n  <params>\n    <param name=\"x\" type=\"array[number]\">\n      <description/>\n    </param>\n    <param name=\"y\" type=\"array[number]\">\n      <description/>\n    </param>\n  </params>\n  <return type=\"number\">\n    <description>The Pearson correlation between x and y</description>\n  </return>\n  <implems>\n    <implem language=\"r\"/>\n  </implems>\n  <examples>\n    <example>\n      <description/>\n      <usage/>\n      <result type=\"\"/>\n    </example>\n  </examples>\n  <tests>\n  </tests>\n</function>\n<function>\n  <name>cos</name>\n  <title>Cosine</title>\n  <params>\n  \t<param name=\"value\" type=\"number\"/>\n  </params>\n  <implems>\n    <implem language=\"js\">\n      <code>Math.cos</code>\n    </implem>\n    <implem language=\"py\">\n      <code>math.cos</code>\n    </implem>\n    <implem language=\"r\"/>\n  </implems>\n  <tests>\n    <test>\n      <args>\n        <arg type=\"number\">0</arg>\n      </args>\n      <result type=\"number\">1</result>\n    </test>\n  </tests>\n</function>\n<function>\n  <name>equal</name>\n  <title>Equal</title>\n  <summary>Are two values equal?</summary>\n  <description>Performs a deep comparison between two values to determine if they are equivalent.</description>\n  <params>\n    <param name=\"value\" type=\"any\">\n      <description>The value to compare.</description>\n    </param>\n    <param name=\"other\" type=\"any\">\n      <description>The other value to compare.</description>\n    </param>\n  </params>\n  <return type=\"boolean\">\n    <description>True if the values are equivalent, else false.</description>\n  </return>\n  <implems>\n    <implem language=\"js\"/>\n  </implems>\n</function>\n<function>\n  <name>filter</name>\n  <params>\n    <param name=\"value\" type=\"table\"/>\n    <param name=\"clause\" type=\"string\"/>\n  </params>\n  <implems>\n    <implem language=\"js\"/>\n  </implems>\n  <tests>\n  </tests>\n</function>\n<function>\n  <name>max</name>\n  <title>Maximum</title>\n  <summary/>\n  <description/>\n  <relateds>\n    <related/>\n  </relateds>\n  <params>\n    <param name=\"values\" type=\"array[number]\">\n      <description/>\n    </param>\n  </params>\n  <return type=\"number\">\n    <description>The maximum value</description>\n  </return>\n  <implems>\n    <implem language=\"js\"/>\n  </implems>\n  <examples>\n    <example>\n      <description/>\n      <usage/>\n      <result type=\"\"/>\n    </example>\n  </examples>\n  <tests>\n  </tests>\n</function>\n<function>\n  <name>mean</name>\n  <title>Arithmetic Mean</title>\n  <summary/>\n  <description/>\n  <relateds>\n    <related/>\n  </relateds>\n  <params>\n    <param name=\"values\" type=\"array[number]\">\n      <description/>\n    </param>\n  </params>\n  <return type=\"number\">\n    <description>The arithmetic mean</description>\n  </return>\n  <implems>\n    <implem language=\"js\"/>\n  </implems>\n  <examples>\n    <example>\n      <description/>\n      <usage/>\n      <result type=\"\"/>\n    </example>\n  </examples>\n  <tests>\n  </tests>\n</function>\n<function>\n  <name>min</name>\n  <title>Minimum</title>\n  <summary/>\n  <description/>\n  <relateds>\n    <related/>\n  </relateds>\n  <params>\n    <param name=\"values\" type=\"array[number]\">\n      <description/>\n    </param>\n  </params>\n  <return type=\"number\">\n    <description>The minimum value</description>\n  </return>\n  <implems>\n    <implem language=\"js\"/>\n  </implems>\n  <examples>\n    <example>\n      <description/>\n      <usage/>\n      <result type=\"\"/>\n    </example>\n  </examples>\n  <tests>\n  </tests>\n</function>\n<function>\n    <name>plot</name>\n    <title>plot</title>\n    <summary>Create a plot value</summary>\n    <description>Creates a plot.</description>\n    <examples>\n        <example>\n            <usage>plot(x)</usage>\n        </example>\n        <example>\n            <usage>plot(x, y)</usage>\n        </example>\n        <example>\n            <usage>plot({x: x, y: y})</usage>\n        </example>\n    </examples>\n    <params>\n        <param name=\"arg1\" type=\"any\">\n            <description>Either an array or a table</description>\n        </param>\n        <param name=\"arg2\" type=\"any\">\n            <default type=\"null\">null</default>\n            <description>An array</description>\n        </param>\n    </params>\n    <return type=\"plot\">\n        <description>A new plot</description>\n    </return>\n    <implems>\n        <implem language=\"js\"/>\n    </implems>\n</function>\n<function>\n  <name>sd</name>\n  <params>\n    <param name=\"x\" type=\"array[number]\">\n      <description/>\n    </param>\n  </params>\n  <implems>\n    <implem language=\"py\"/>\n    <implem language=\"r\"/>\n  </implems>\n</function>\n<function>\n  <name>test_between</name>\n  <title>Between</title>\n  <summary>Test that a value if between two other values</summary>\n  <params>\n    <param name=\"value\" type=\"number\">\n      <description>The value to test.</description>\n    </param>\n    <param name=\"lower\" type=\"number\">\n      <description>The lower bound of the range.</description>\n    </param>\n    <param name=\"upper\" type=\"number\">\n      <description>The upper bound of the range.</description>\n    </param>\n  </params>\n  <return type=\"boolean\">\n    <description>True if the value is between lower and upper, else false.</description>\n  </return>\n  <implems>\n    <implem language=\"js\"/>\n  </implems>\n</function>\n<function>\n  <name>test_close</name>\n  <title>Test closeness</title>\n  <summary>Test that a value is close to another value</summary>\n  <params>\n    <param name=\"value\" type=\"number\">\n      <description>The value to test.</description>\n    </param>\n    <param name=\"other\" type=\"number\">\n      <description>The other value to compare to.</description>\n    </param>\n    <param name=\"precision\" type=\"number\">\n      <description>The precision of the comparision.</description>\n    </param>\n  </params>\n  <return type=\"test\">\n    <description>True if the value is within plus or minus precision of the other value, else false.</description>\n  </return>\n  <implems>\n    <implem language=\"js\"/>\n  </implems>\n</function>\n<function>\n  <name>test_equal</name>\n  <title>Test equality</title>\n  <summary>Test that two values are equal</summary>\n  <params>\n    <param name=\"value\" type=\"any\">\n      <description>The value to compare.</description>\n    </param>\n    <param name=\"other\" type=\"any\">\n      <description>The other value to compare.</description>\n    </param>\n  </params>\n  <return type=\"test\">\n    <description>A test result object</description>\n  </return>\n  <implems>\n    <implem language=\"js\"/>\n  </implems>\n</function>\n<function>\n  <name>test</name>\n  <title>Test</title>\n  <summary>If a value is true then return a passed test, otherwise return a failed test with an optional message.</summary>\n  <params>\n    <param name=\"value\" type=\"boolean\">\n    </param>\n    <param name=\"message\" type=\"string\">\n      <description>The failiure method</description>\n      <default type=\"string\">Failed</default>\n    </param>\n  </params>\n  <return type=\"test\">\n    <description>A test object</description>\n  </return>\n  <implems>\n    <implem language=\"js\"/>\n  </implems>\n</function>\n<function>\n  <name>ttest</name>\n  <title>Student's t-Test</title>\n  <summary>One-sample and paired Student's t-Test on arrays of numbers</summary>\n  <description/>\n  <relateds>\n    <related/>\n  </relateds>\n  <params>\n    <param name=\"x\" type=\"array[number]\">\n      <description/>\n    </param>\n    <param name=\"y\" type=\"array[number]\">\n      <description/>\n      <default type=\"null\"/>\n    </param>\n    <param name=\"mu\" type=\"string\">\n      <description>The hypothesized true mean under the null hypothesis.</description>\n      <default type=\"number\">0</default>\n    </param>\n    <param name=\"tails\" type=\"integer\">\n      <description>Whether the alternative hypothesis is that the mean of x (or difference between x and y) is larger than mu (1, i.e. \"one-sided greater than\"), smaller than mu (-1, i.e. \"one-sided less than\") or equal to mu (0, i.e. \"two-sided\").</description>\n      <default type=\"string\">\"two-sided\"</default>\n    </param>\n    <param name=\"paired\" type=\"boolean\">\n      <description>Perform a paired t-test?</description>\n      <default type=\"boolean\">false</default>\n    </param>\n    <param name=\"alpha\" type=\"number\">\n      <description>Number in the interval [0,1] giving the significance level of the hypothesis test.</description>\n      <default type=\"number\">0.5</default>\n    </param>\n  </params>\n  <return type=\"object\">\n    <description>An object of class \"ttest\"</description>\n  </return>\n  <implems>\n    <implem language=\"js\"/>\n    <implem language=\"r\"/>\n  </implems>\n  <examples>\n    <example>\n      <description>Perform a one sided, </description>\n      <usage>ttest(x, y, tails=-1)</usage>\n      <result type=\"object\"/>\n    </example>\n  </examples>\n  <tests>\n    <test>\n      <description/>\n      <args>\n        <arg type=\"\"/>\n      </args>\n      <result type=\"\"/>\n    </test>\n  </tests>\n</function>\n<function>\n  <name>type</name>\n  <title>Type</title>\n  <summary>Get the type name of a value</summary>\n  <description>A base function that returns the type name e.g. \"number\" of a value</description>\n  <params>\n    <param name=\"value\" type=\"any\">\n      <description>The value for which the type is wanted</description>\n    </param>\n  </params>\n  <return type=\"string\">\n    <description>The type name for the value</description>\n  </return>\n  <implems>\n    <implem language=\"js\"/>\n  </implems>\n  <examples>\n    <example>\n      <description>Get the type of an integer literal</description>\n      <usage>type(42)</usage>\n      <result type=\"string\">\"integer\"</result>\n    </example>\n    <example>\n      <description>Get the type of a one-dimensional array of Sheet cells</description>\n      <usage>type(A1:A10)</usage>\n      <result type=\"string\">\"array[string]\"</result>\n    </example>\n    <example>\n      <description>Get the type of a two-dimensional array of Sheet cells</description>\n      <usage>type(A1:D5)</usage>\n      <result type=\"string\">\"matrix[number]\"</result>\n    </example>\n  </examples>\n  <tests>\n    <test>\n      <description/>\n      <args>\n        <arg type=\"boolean\">true</arg>\n      </args>\n      <result type=\"string\">\"boolean\"</result>\n    </test>\n  </tests>\n</function>\n</library>\n"