var fs = require('fs'), 
	parser = require('./parser'),
	Ascii = require('./ascii'),
	Binary = require('./binary'),
	package = JSON.parse( fs.readFileSync("../package.json", "utf-8") ), 
	utils = require('./utils'),
    THREE = require('three');

// default options
var defaults = require('./options');
	
Main = function ( options ) {
	// fallbacks
	options = options || {};
	// set default options
	this.options = defaults;
	// extend default options
	this.options = utils.extend( this.options, options );
	// add info from package.json
	this.options.package = package;
	this.options.files = [];
};

Main.prototype = {
	
	constructor: Main,
	// containers
	data: {}, 
	
	//extends options with custome ones
	set: function ( options ) {
		// 
		this.options = utils.extend( this.options, options );
	},
	 
	load: function ( file, callback ) { 
		
		var self = this;
		
		this.options.files.push( file );
		
		fs.readFile(file, 'utf8', function( err, obj ){
			if( err ) console.log( err );
			// convert the response to json
			self.data = self.parse( obj );
			// output the result (for the callback)
			if ( callback ) callback( self.data );
			
		});

	},
	
	// parse an OBJ to JSON
	parse: parser, 
	
	// load & output to a json file (ascii)
	convert: function ( source, destination, callback ) {
		var self = this;
		//set type to ascii
		this.set({ type : "ascii" });
		// load the OBJ file
		self.load( source, function( data ){
			// validate data?
			self.output( data, destination, function(){
				//
				if ( callback ) callback( data );
				
			});
		});
			
	}, 
	
    //Convert infile.obj to outfile.js + outfile.bin
    minify: function ( source, destination, callback ) {
        //
        if( !fs.existsSync(source) ) return console.log("Couldn't find "+ source);
		//
        var self = this;
		//set type to ascii
		this.set({ type : "binary" });
		// load the OBJ file
		self.load( source, function( data ){
			// validate data?
			self.output( data, destination, function(){
				//
				if ( callback ) callback( data );
				
			});
		});
			
	}, 
	
	// convert data to binary file
	compress: function ( json ) {
        
		var self = this;
		//set type to ascii
		this.set({ type : "binary" });
		// load the OBJ file
		self.load( source, function( data ){
			// validate data?
			self.output( data, destination, function(){
				//
				if ( callback ) callback( data );
				
			});
		});
			
	}, 
	
	output: function( data, destination, callback ){
		var json, output = {};
        // 
		switch( this.options.type ){
			case "ascii":
				var ascii = new Ascii( this.options );
				output = ascii.compile( data );
                // save json to file
                ascii.save( destination, output, callback );
			break;
			case "binary":
                // add binary file in the options
                this.set({ buffers : utils.get_name(destination) +".bin" });
				var binary = new Binary( this.options );
				output = binary.compile( data );
                binary.save( destination, output, callback );
			break;
		};
		
	}
	
};

module.exports  = new Main();