# #####################################################
# Morphs
# #####################################################

var TEMPLATE_MORPH_VERTICES = '\t{ "name": "%s", "vertices": [%s] }';
var TEMPLATE_MORPH_COLORS   = '\t{ "name": "%s", "colors": [%s] }';

function Morphs( options ){
	this.options = options;
}

Morphs.prototype = {

	generate_morph_vertex: function(name, vertices){
		var vertex_string = ",".join(generate_vertex(v, this.options.truncate, this.options.scale) for v in vertices);
		return TEMPLATE_MORPH_VERTICES % (name, vertex_string);
	},

	generate_morph_color: function(name, colors){
		color_string = ",".join(generate_color_rgb(c) for c in colors)
		return TEMPLATE_MORPH_COLORS % (name, color_string)
	},

	// - Extract diffuse colors from MTL materials
	extract_material_colors: function(materials, mtlfilename, basename){

		materials = materials || { 'default': 0 };

		var mtl = create_materials(materials, mtlfilename, basename);
		var mtlColorArraySrt = [];

		for( m in mtl ){
			if( m in materials ){
				index = materials[m]
				color = mtl[m].get("colorDiffuse", [1,0,0])
				mtlColorArraySrt.append([index, color])
			}
		}
		mtlColorArraySrt.sort();
		mtlColorArray = [x[1] for x in mtlColorArraySrt];

		return mtlColorArray;
	},
	// - Extract colors from materials and assign them to faces
	extract_face_colors: function(faces, material_colors){

		var faceColors = [];

		for( var i in faces ){
			var face = faces[i];
			material_index = face['material'];
			faceColors.append(material_colors[material_index])
		}
		return faceColors;
	},

	generate_morph_targets: function(morphfiles, n_vertices, infile){
		var skipOriginalMorph = false;
			//norminfile = os.path.normpath(infile);

		var morphVertexData = [];

		for( var i in morphfiles.split() ){
			mfilepattern = morphfiles[i];
			matches = glob.glob(mfilepattern);
			matches.sort();

			var indices = range(0, len(matches), this.options.framestep);
			for( var i in indices ){
				var path = matches[i];

				var normpath = os.path.normpath(path);

				if( normpath != norminfile || !skipOriginalMorph ){

					var name = os.path.basename(normpath);

					morphFaces, morphVertices, morphUvs, morphNormals, morphMaterials, morphMtllib = parse_obj(normpath)

					var n_morph_vertices = len(morphVertices);

					if( n_vertices != n_morph_vertices ){

						console.log("WARNING: skipping morph [%s] with different number of vertices [%d] than the original model [%d]" % (name, n_morph_vertices, n_vertices) );

					} else {
						// - alignment
						var faces = new Faces( this.options );
						if( this.options.align == "center" ){
							data.vertices = faces.center( data.vertices );
						} else if( this.options.align == "centerxz" ){
							data.vertices = faces.centerxz( data.vertices );
						} else if( this.options.align == "bottom" ){
							data.vertices = faces.bottom( data.vertices );
						} else if( this.options.align == "top" ){
							data.vertices = faces.top( data.vertices );
						}
						morphVertexData.append((get_name(name), morphVertices));
						console.log( "adding [%s] with %d vertices" % (name, n_morph_vertices) );
					}
				}
			}
		}
		// output
		var morphTargets = "";
		if( morphVertexData.length ){
			morphTargets = "\n%s\n\t" % ",\n".join( this.generate_morph_vertex(name, vertices) for name, vertices in morphVertexData)
		}
		return morphTargets;
	},

	generate_morph_colors: function(colorfiles, n_vertices, n_faces){
		var morphColorData = [],
			colorFaces = [],
			materialColors = [];

		for( mfilepattern in colorfiles.split() ){

			matches = glob.glob(mfilepattern)
			matches.sort()
			for( var i in matches ){
				var path = matches[i];
				var normpath = os.path.normpath(path);
				var name = os.path.basename(normpath);

				morphFaces, morphVertices, morphUvs, morphNormals, morphMaterials, morphMtllib = parse_obj(normpath)

				n_morph_vertices = len(morphVertices)
				n_morph_faces = len(morphFaces)

				if( n_vertices != n_morph_vertices ){

					console.log("WARNING: skipping morph color map [%s] with different number of vertices [%d] than the original model [%d]" % (name, n_morph_vertices, n_vertices) );

				} else if( n_faces != n_morph_faces ){

					console.log("WARNING: skipping morph color map [%s] with different number of faces [%d] than the original model [%d]" % (name, n_morph_faces, n_faces) );

				} else {

					morphMaterialColors = this.extract_material_colors(morphMaterials, morphMtllib, normpath);
					morphFaceColors = this.extract_face_colors(morphFaces, morphMaterialColors);
					morphColorData.append((get_name(name), morphFaceColors));

					// take first color map for baking into face colors

					if( colorFaces.length == 0 ){
						colorFaces = morphFaces;
						materialColors = morphMaterialColors;
					}
					console.log("adding [%s] with %d face colors" % (name, len(morphFaceColors)) );
				}
			}
		}
		var morphColors = "";

		if( morphColorData.length ){
			morphColors = "\n%s\n\t" % ",\n".join(generate_morph_color(name, colors) for name, colors in morphColorData)
		}
		return morphColors, colorFaces, materialColors;
	}
}


module.exports = Faces;
