var list = {

	"Manual": {
		"Introduction": [
			[ "Creating a scene", "manual/introduction/Creating-a-scene" ],
			[ "Matrix transformations", "manual/introduction/Matrix-transformations" ]
		]
	},

	"Reference": {
		"Constants": [
			[ "CustomBlendingEquation", "api/constants/CustomBlendingEquations" ],
			[ "DrawModes", "api/constants/DrawModes" ],
			[ "GLState", "api/constants/GLState" ],
			[ "Materials", "api/constants/Materials" ],
			[ "ShadowingTypes", "api/constants/ShadowingTypes" ],
			[ "Textures", "api/constants/Textures" ]
		],

		"Cameras": [
			[ "Camera", "api/cameras/Camera" ],
			[ "CubeCamera", "api/cameras/CubeCamera" ],
			[ "OrthographicCamera", "api/cameras/OrthographicCamera" ],
			[ "PerspectiveCamera", "api/cameras/PerspectiveCamera" ]
		],

		"Core": [
			[ "BufferAttribute", "api/core/BufferAttribute" ],
			[ "BufferGeometry", "api/core/BufferGeometry" ],
			[ "Clock", "api/core/Clock" ],
			[ "EventDispatcher", "api/core/EventDispatcher" ],
			[ "Face3", "api/core/Face3" ],
			[ "Geometry", "api/core/Geometry" ],
			[ "Layers", "api/core/Layers" ],
			[ "Object3D", "api/core/Object3D" ],
			[ "Raycaster", "api/core/Raycaster" ],
			[ "Uniform", "api/core/Uniform"]
		],

		"Geometries": [
			[ "BoxBufferGeometry", "api/geometries/BoxBufferGeometry" ],
			[ "BoxGeometry", "api/geometries/BoxGeometry" ],
			[ "CircleBufferGeometry", "api/geometries/CircleBufferGeometry" ],
			[ "CircleGeometry", "api/geometries/CircleGeometry" ],
			[ "ConeBufferGeometry", "api/geometries/ConeBufferGeometry" ],
			[ "ConeGeometry", "api/geometries/ConeGeometry" ],
			[ "CylinderBufferGeometry", "api/geometries/CylinderBufferGeometry" ],
			[ "CylinderGeometry", "api/geometries/CylinderGeometry" ],
			[ "DodecahedronBufferGeometry", "api/geometries/DodecahedronBufferGeometry" ],
			[ "DodecahedronGeometry", "api/geometries/DodecahedronGeometry" ],
			[ "ExtrudeGeometry", "api/geometries/ExtrudeGeometry" ],
			[ "IcosahedronBufferGeometry", "api/geometries/IcosahedronBufferGeometry" ],
			[ "IcosahedronGeometry", "api/geometries/IcosahedronGeometry" ],
			[ "LatheBufferGeometry", "api/geometries/LatheBufferGeometry" ],
			[ "LatheGeometry", "api/geometries/LatheGeometry" ],
			[ "OctahedronBufferGeometry", "api/geometries/OctahedronBufferGeometry" ],
			[ "OctahedronGeometry", "api/geometries/OctahedronGeometry" ],
			[ "ParametricBufferGeometry", "api/geometries/ParametricBufferGeometry" ],
			[ "ParametricGeometry", "api/geometries/ParametricGeometry" ],
			[ "PlaneBufferGeometry", "api/geometries/PlaneBufferGeometry" ],
			[ "PlaneGeometry", "api/geometries/PlaneGeometry" ],
			[ "PolyhedronBufferGeometry", "api/geometries/PolyhedronBufferGeometry" ],
			[ "PolyhedronGeometry", "api/geometries/PolyhedronGeometry" ],
			[ "RingBufferGeometry", "api/geometries/RingBufferGeometry" ],
			[ "RingGeometry", "api/geometries/RingGeometry" ],
			[ "ShapeGeometry", "api/geometries/ShapeGeometry" ],
			[ "SphereBufferGeometry", "api/geometries/SphereBufferGeometry" ],
			[ "SphereGeometry", "api/geometries/SphereGeometry" ],
			[ "TetrahedronBufferGeometry", "api/geometries/TetrahedronBufferGeometry" ],
			[ "TetrahedronGeometry", "api/geometries/TetrahedronGeometry" ],
			[ "TextGeometry", "api/geometries/TextGeometry" ],
			[ "TorusBufferGeometry", "api/geometries/TorusBufferGeometry" ],
			[ "TorusGeometry", "api/geometries/TorusGeometry" ],
			[ "TorusKnotBufferGeometry", "api/geometries/TorusKnotBufferGeometry" ],
			[ "TorusKnotGeometry", "api/geometries/TorusKnotGeometry" ],
			[ "TubeGeometry", "api/geometries/TubeGeometry" ],
			[ "TubeBufferGeometry", "api/geometries/TubeBufferGeometry" ]
		],

		"Lights": [
			[ "AmbientLight", "api/lights/AmbientLight" ],
			[ "DirectionalLight", "api/lights/DirectionalLight" ],
			[ "DirectionalLightShadow", "api/lights/DirectionalLightShadow" ],
			[ "HemisphereLight", "api/lights/HemisphereLight" ],
			[ "Light", "api/lights/Light" ],
			[ "LightShadow", "api/lights/LightShadow" ],
			[ "PointLight", "api/lights/PointLight" ],
			[ "SpotLight", "api/lights/SpotLight" ],
			[ "SpotLightShadow", "api/lights/SpotLightShadow" ]
		],


		"Loaders": [
			[ "AudioLoader", "api/loaders/AudioLoader" ],
			[ "BabylonLoader", "api/loaders/BabylonLoader" ],
			[ "BufferGeometryLoader", "api/loaders/BufferGeometryLoader" ],
			[ "Cache", "api/loaders/Cache" ],
			[ "ColladaLoader", "api/loaders/ColladaLoader" ],
			[ "GLTFLoader", "api/loaders/GLTFLoader" ],
			[ "ImageLoader", "api/loaders/ImageLoader" ],
			[ "JSONLoader", "api/loaders/JSONLoader" ],
			[ "Loader", "api/loaders/Loader" ],
			[ "LoadingManager", "api/loaders/LoadingManager" ],
			[ "MaterialLoader", "api/loaders/MaterialLoader" ],
			[ "MTLLoader", "api/loaders/MTLLoader" ],
			[ "OBJLoader", "api/loaders/OBJLoader" ],
			[ "ObjectLoader", "api/loaders/ObjectLoader" ],
			[ "PDBLoader", "api/loaders/PDBLoader" ],
			[ "SVGLoader", "api/loaders/SVGLoader" ],
			[ "TextureLoader", "api/loaders/TextureLoader" ],
			[ "TGALoader", "api/loaders/TGALoader" ],
			[ "XHRLoader", "api/loaders/XHRLoader" ]
		],

		"Materials": [
			[ "LineBasicMaterial", "api/materials/LineBasicMaterial" ],
			[ "LineDashedMaterial", "api/materials/LineDashedMaterial" ],
			[ "Material", "api/materials/Material" ],
			[ "MeshBasicMaterial", "api/materials/MeshBasicMaterial" ],
			[ "MeshDepthMaterial", "api/materials/MeshDepthMaterial" ],
			[ "MultiMaterial", "api/materials/MultiMaterial" ],
			[ "MeshLambertMaterial", "api/materials/MeshLambertMaterial" ],
			[ "MeshNormalMaterial", "api/materials/MeshNormalMaterial" ],
			[ "MeshPhongMaterial", "api/materials/MeshPhongMaterial" ],
			[ "MeshStandardMaterial", "api/materials/MeshStandardMaterial" ],
			[ "PointsMaterial", "api/materials/PointsMaterial" ],
			[ "RawShaderMaterial", "api/materials/RawShaderMaterial" ],
			[ "ShaderMaterial", "api/materials/ShaderMaterial" ],
			[ "SpriteMaterial", "api/materials/SpriteMaterial" ]
		],

		"Math": [
			[ "Box2", "api/math/Box2" ],
			[ "Box3", "api/math/Box3" ],
			[ "Color", "api/math/Color" ],
			[ "Euler", "api/math/Euler" ],
			[ "Frustum", "api/math/Frustum" ],
			[ "Line3", "api/math/Line3" ],
			[ "Math", "api/math/Math" ],
			[ "Matrix3", "api/math/Matrix3" ],
			[ "Matrix4", "api/math/Matrix4" ],
			[ "Plane", "api/math/Plane" ],
			[ "Quaternion", "api/math/Quaternion" ],
			[ "Ray", "api/math/Ray" ],
			[ "Sphere", "api/math/Sphere" ],
			[ "Spline", "api/math/Spline" ],
			[ "Triangle", "api/math/Triangle" ],
			[ "Vector2", "api/math/Vector2" ],
			[ "Vector3", "api/math/Vector3" ],
			[ "Vector4", "api/math/Vector4" ]
		],

		"Objects": [
			[ "Bone", "api/objects/Bone" ],
			[ "LensFlare", "api/objects/LensFlare" ],
			[ "Line", "api/objects/Line" ],
			[ "LineSegments", "api/objects/LineSegments" ],
			[ "LOD", "api/objects/LOD" ],
			[ "Mesh", "api/objects/Mesh" ],
			[ "Points", "api/objects/Points" ],
			[ "Skeleton", "api/objects/Skeleton" ],
			[ "SkinnedMesh", "api/objects/SkinnedMesh" ],
			[ "Sprite", "api/objects/Sprite" ]
		],

		"Renderers": [
			[ "CanvasRenderer", "api/renderers/CanvasRenderer" ],
			[ "WebGLRenderer", "api/renderers/WebGLRenderer" ],
			[ "WebGLRenderTarget", "api/renderers/WebGLRenderTarget" ],
			[ "WebGLRenderTargetCube", "api/renderers/WebGLRenderTargetCube" ]
		],

		"Renderers / Shaders": [
			[ "ShaderChunk", "api/renderers/shaders/ShaderChunk" ],
			[ "ShaderLib", "api/renderers/shaders/ShaderLib" ],
			[ "UniformsLib", "api/renderers/shaders/UniformsLib" ],
			[ "UniformsUtils", "api/renderers/shaders/UniformsUtils" ]
		],

		"Renderers / WebGL": [
			[ "WebGLProgram", "api/renderers/webgl/WebGLProgram" ],
			[ "WebGLShader", "api/renderers/webgl/WebGLShader" ],
			[ "WebGLState", "api/renderers/webgl/WebGLState" ]
		],

		"Renderers / WebGL / Plugins": [
			[ "LensFlarePlugin", "api/renderers/webgl/plugins/LensFlarePlugin" ],
			[ "SpritePlugin", "api/renderers/webgl/plugins/SpritePlugin" ]
		],

		"Scenes": [
			[ "Fog", "api/scenes/Fog" ],
			[ "FogExp2", "api/scenes/FogExp2" ],
			[ "Scene", "api/scenes/Scene" ]
		],

		"Textures": [
			[ "CompressedTexture", "api/textures/CompressedTexture" ],
			[ "CubeTexture", "api/textures/CubeTexture" ],
			[ "DataTexture", "api/textures/DataTexture" ],
			[ "Texture", "api/textures/Texture" ]
		],

		"Extras": [
			[ "SceneUtils", "api/extras/SceneUtils" ]
		],

		"Extras / Animation": [
			[ "Animation", "api/extras/animation/Animation" ],
			[ "AnimationHandler", "api/extras/animation/AnimationHandler" ],
			[ "KeyFrameAnimation", "api/extras/animation/KeyFrameAnimation" ]
		],

		"Extras / Core": [
			[ "Curve", "api/extras/core/Curve" ],
			[ "CurvePath", "api/extras/core/CurvePath" ],
			[ "Path", "api/extras/core/Path" ],
			[ "Shape", "api/extras/core/Shape" ]
		],

		"Extras / Curves": [
			[ "ArcCurve", "api/extras/curves/ArcCurve" ],
			[ "CatmullRomCurve3", "api/extras/curves/CatmullRomCurve3" ],
			[ "ClosedSplineCurve3", "api/extras/curves/ClosedSplineCurve3" ],
			[ "CubicBezierCurve", "api/extras/curves/CubicBezierCurve" ],
			[ "CubicBezierCurve3", "api/extras/curves/CubicBezierCurve3" ],
			[ "EllipseCurve", "api/extras/curves/EllipseCurve" ],
			[ "LineCurve", "api/extras/curves/LineCurve" ],
			[ "LineCurve3", "api/extras/curves/LineCurve3" ],
			[ "QuadraticBezierCurve", "api/extras/curves/QuadraticBezierCurve" ],
			[ "QuadraticBezierCurve3", "api/extras/curves/QuadraticBezierCurve3" ],
			[ "SplineCurve", "api/extras/curves/SplineCurve" ],
			[ "SplineCurve3", "api/extras/curves/SplineCurve3" ]
		],

		"Extras / Helpers": [
			[ "ArrowHelper", "api/extras/helpers/ArrowHelper" ],
			[ "AxisHelper", "api/extras/helpers/AxisHelper" ],
			[ "BoundingBoxHelper", "api/extras/helpers/BoundingBoxHelper" ],
			[ "BoxHelper", "api/extras/helpers/BoxHelper" ],
			[ "CameraHelper", "api/extras/helpers/CameraHelper" ],
			[ "DirectionalLightHelper", "api/extras/helpers/DirectionalLightHelper" ],
			[ "FaceNormalsHelper", "api/extras/helpers/FaceNormalsHelper" ],
			[ "GridHelper", "api/extras/helpers/GridHelper" ],
			[ "HemisphereLightHelper", "api/extras/helpers/HemisphereLightHelper" ],
			[ "PointLightHelper", "api/extras/helpers/PointLightHelper" ],
			[ "SpotLightHelper", "api/extras/helpers/SpotLightHelper" ],
			[ "VertexNormalsHelper", "api/extras/helpers/VertexNormalsHelper" ]
		],

		"Extras / Objects": [
			[ "ImmediateRenderObject", "api/extras/objects/ImmediateRenderObject" ],
			[ "MorphBlendMesh", "api/extras/objects/MorphBlendMesh" ]
		],

		"Examples" : [
			[ "CombinedCamera", "api/examples/cameras/CombinedCamera" ],
			[ "LookupTable", "api/examples/Lut" ],
			[ "SpriteCanvasMaterial", "api/examples/SpriteCanvasMaterial" ]

		]

	}

};

var pages = {};

for ( var section in list ) {

	pages[ section ] = {};

	for ( var category in list[ section ] ) {

		pages[ section ][ category ] = {};

		for ( var i = 0; i < list[ section ][ category ].length; i ++ ) {

			var page = list[ section ][ category ][ i ];
			pages[ section ][ category ][ page[ 0 ] ] = page[ 1 ];

		}

	}

}
