
// strings.js

(function() {
var e = XT.stringsFor("en_US", {
_accountsReceivable: "Accounts Receivable",
_americanExpress: "American Express",
_asOf: "As Of",
_application: "Application",
_applications: "Applications",
_applied: "Applied",
_appliedAmount: "Applied Amount",
_applyARMemos: "Apply Receivable Memos",
_applyBalanceAs: "Apply Balance As",
_applyBalanceToCreditMemo: "Credit Memo",
_applyBalanceToCustomerDeposit: "Customer Deposit",
_autoCloseARIncident: "Auto Close Incidents when Invoice Paid",
_autoCreditWarnLateCustomers: "Credit warn Customers when Late",
_billing: "Billing",
_billingDescription: "Corporate Relationship Management",
_cashReceipt: "Cash Receipt",
_cashReceiptApplications: "Cash Receipt Applications",
_cashReceipts: "Cash Receipts",
_cashReceiptCurrencyMismatchWarning: "Cash Receipt currency {cr_currency} does not match Bank Account Currency {ba_currency}",
_certifiedCheck: "Certified Check",
_check: "Check",
_configureAR: "Configure Billing",
_createNewCurrency: "Create New Currency",
_credits: "Credits",
_creditTaxDiscount: "Credit Taxes for Early Payment Discounts",
_customerDeposit: "Customer Deposit",
_debits: "Debits",
_defaultARIncidentStatus: "Default Incident Category",
_defaultAutoCreditWarnGraceDays: "Default Grace Period Days",
_discover: "Discover",
_distributionDate: "Distribution Date",
_applicationDate: "Application Date",
_editAROpenItem: "Edit Receivables",
_enableCustomerDeposits: "Enable Customer Deposits",
_fundsType: "Type of Funds",
_hideApplyToBalance: "Hide 'Apply to Balance' Action",
_isPosted: "Posted",
_isNotPosted: "Unposted",
_maintainCashReceipts: "Maintain Cash Receipts",
_maintainCreditMemos: "Maintain Credit Memos",
_maintainCurrencies: "Maintain Currencies",
_maintainCustomerEmailProfiles: "Maintain Customer Email Profiles",
_maintainMiscInvoices: "Maintain Invoices",
_maintainSalesCategories: "Maintain Sales Categories",
_mastercard: "Mastercard",
_nextARMemoNumber: "Next Receivables Memo",
_nextCashRcptNumber: "Next Cash Receipt",
_otherCreditCard: "Other Credit Card",
_orderNumber: "Order #",
_other: "Other",
_payment: "Payment",
_postARDocuments: "Post Receivable Documents",
_postCashReceipts: "Post Cash Receipts",
_postCashPayment: "Post Cash Payment",
_postMiscInvoices: "Post Invoices",
_printInvoices: "Print Invoices",
_printOnPost: "Print on Post",
_receivable: "Receivable",
_receivables: "Receivables",
_recordReceiptAs: "Record Receipt As",
_recurringInvoiceBuffer: "Recurring Invoice Buffer Days",
_salesCategories: "Sales Categories",
_salesCategory: "Sales Category",
_salesOrderPaymentOverapplicationWarn: "The payment amount entered is larger than the Sales Order balance. Are you sure you would like to overpay this Sales Order?",
_salesOrderPaymentFailure: "We encountered a problem posting payment to this Sales Order",
_salesOrderPaymentSuccess: "Payment Successfully posted to Sales Order",
_taxes: "Taxes",
_taxTotal: "Tax Total",
_unposted: "Unposted",
_useCustomerDeposit: "Use Customer Deposit",
_viewAROpenItems: "View Receivables",
_viewCashReceipts: "View Cash Receipts",
_viewCreditMemos: "View Credit Memos",
_viewMiscInvoices: "View Invoices",
_visa: "Visa",
_void: "Void",
_voidPostedARCreditMemos: "Void Posted Returns",
_voidPostedCashReceipts: "Void Posted Cash Receipts",
_voidPostedInvoices: "Void Posted Invoices",
_wireTransfer: "Wire Transfer",
_taxesMustNotBeGreater: "The Tax Total may not be greater than the Amount"
});
typeof exports != "undefined" && (exports.language = e);
})();

// core.js

(function() {
"use strict";
XT.extensions.billing = {
name: "billing",
setVersion: function() {
XT.setVersion("", XT.extensions.billing.name);
}
};
})();

// configure.js

(function() {
"use strict";
XT.extensions.billing.initSettings = function() {
XM.Billing = XM.Settings.extend({
recordType: "XM.Billing",
privileges: "ConfigureAR",
bindEvents: function() {
XM.Settings.prototype.bindEvents.apply(this, arguments), this.on("statusChange", this.statusDidChange);
}
}), XM.billing = new XM.Billing;
};
})();

// sales_category.js

XT.extensions.billing.initSalesCategoryModel = function() {
"use strict";
XM.SalesCategory = XM.Document.extend({
recordType: "XM.SalesCategory",
idAttribute: "name",
documentKey: "name",
getUnpostedInvoices: function() {
this.dispatch("XM.SalesCategory", "queryUnpostedInvoices", [ this.id ], {
success: _.bind(this.trigger, this, "change:unpostedInvoices"),
error: _.bind(this.trigger, this, "change:canDeactivate", !1)
});
},
canDeactivate: function(e) {
var t = this, n = _(_.all).bind(this, [ this.get("isActive"), this.canEdit("isActive"), this.canUpdate() ]), r = function(r) {
var i = n() && !r;
t.trigger("change:canDeactivate", i), _.isFunction(e) && e(i);
};
if (!n()) return e(!1);
this.once("change:unpostedInvoices", r), this.getUnpostedInvoices();
},
hasDeactivateActionPrerequisite: function(e) {
this.once("change:canDeactivate", e), this.canDeactivate();
},
deactivate: function() {
var e = function(e) {
e.releaseLock();
}, t = function(t) {
if (!t.get("isActive")) {
t.releaseLock();
return;
}
t.save({
isActive: !1
}, {
success: e
});
};
this.fetch({
success: t
});
}
}), XM.SalesCategoryCollection = XM.Collection.extend({
model: XM.SalesCategory
}), XT.cacheCollection("XM.salesCategories", "XM.SalesCategoryCollection");
};

// sales_order.js

XT.extensions.billing.extendSalesOrder = function() {
"use strict";
if (_.isUndefined(XM.SalesOrder)) throw "XM.SalesOrder is not defined";
XM.SalesOrder.prototype.addPayment = function(e) {
var t = this;
if (this.isDirty() || this.isNew()) {
this.notify("Cannot add payment to an unsaved Sales Order");
return;
}
e.once("sync", function(e, n, r) {
t.dispatch("XM.SalesOrder", "addPayment", [ e.get("number"), t.get("number") ], {
success: function(e) {
e.paid ? t.trigger("payment:success") : t.trigger("payment:error", "Not able to post payment");
},
error: function(e) {
t.trigger("payment:error", e);
}
});
}), e.save();
};
};

// receivable.js

XT.extensions.billing.initReceivableModel = function() {
"use strict";
XM.Receivable = XM.Document.extend({
recordType: "XM.Receivable",
idAttribute: "uuid",
nameAttribute: "documentNumber",
documentKey: "documentNumber",
numberPolicy: XM.Document.AUTO_NUMBER,
defaults: function() {
return {
currency: XT.baseCurrency(),
balance: 0,
taxTotal: 0
};
},
readOnlyAttributes: [ "balance", "taxTotal", "paid", "commission" ],
bindEvents: function(e, t) {
XM.Model.prototype.bindEvents.apply(this, arguments), this.on("change:amount", this.amountDidChange), this.on("change:customer", this.customerDidChange), this.on("change:documentDate change:terms", this.documentDateDidChange), this.on("change:paid", this.paidDidChange), this.on("statusChange", this.statusDidChange), this.on("add:taxes remove:taxes", this.taxesDidChange);
},
amountDidChange: function() {
this.set("commission", this.calculateCommission()), this.set("balance", this.calculateBalance());
},
customerDidChange: function() {
this.copyFromCustomer(), this.calculateCommission();
},
documentDateDidChange: function() {
this.set("dueDate", this.calculateDueDate());
},
paidDidChange: function() {
this.set("balance", this.calculateBalance());
},
statusDidChange: function() {
var e = this.getStatus() === XM.Model.READY_CLEAN;
this.setReadOnly([ "customer", "documentDate", "documentType", "documentNumber", "terms" ], e);
},
taxesDidChange: function(e) {
e ? e.on("change:taxAmount", this.taxAmountDidChange, this) : this.taxAmountDidChange();
},
taxAmountDidChange: function() {
this.set("taxTotal", this.calculateTaxTotal());
},
calculateTaxTotal: function() {
var e = this.get("taxes");
if (!e || e.length === 0) return 0;
var t = _.map(e.models, function(e) {
return e.get("taxAmount") || 0;
});
return _.reduce(t, function(e, t) {
return e + t;
}, 0);
},
calculateBalance: function() {
var e = this.get("amount"), t = this.get("paid");
return e - t;
},
calculateCommission: function() {
var e = this.get("customer"), t = this.get("amount");
return e ? e.get("commission") * t : 0;
},
calculateDueDate: function() {
var e = this.get("terms"), t = this.get("documentDate");
return e && t ? e.calculateDueDate(t) : null;
},
copyFromCustomer: function() {
var e = this.get("customer");
e ? (this.set("terms", e.get("terms")), this.set("currency", e.get("currency")), this.set("salesRep", e.get("salesRep"))) : (this.set("terms", null), this.set("currency", null), this.set("salesRep", null));
},
createCreditMemo: function(e, t) {
return this.dispatch("XM.Receivable", "createCreditMemo", e, t);
},
createDebitMemo: function(e, t) {
return this.dispatch("XM.Receivable", "createDebitMemo", e, t);
},
save: function(e, t, n) {
if (this.getStatus() === XM.Model.READY_NEW) {
var r = this, i, s = {}, o, u, a;
return e === null || typeof e == "object" ? (a = e, n = t) : (a = {})[e] = t, n = _.extend({
validate: !0
}, n), this._validate(a, n) ? (o = n.success, i = r.get("taxes") ? r.get("taxes").models : null, i = _.map(i, function(e) {
return {
taxAmount: e.get("taxAmount"),
parent: e.get("tax").id,
taxCode: e.get("taxCode").id,
taxType: e.get("taxType") ? e.get("taxType").id : null,
basis: e.get("basis"),
percent: e.get("percent"),
documentDate: e.get("documentDate"),
uuid: e.id
};
}), u = [ r.id, r.get("customer").id, r.get("documentNumber"), r.get("documentDate"), r.get("amount"), r.get("dueDate"), r.get("currency").id, XM.currencyRates.getScalarRate("to base from", r.get("currency"), r.get("documentDate")), r.get("commission"), r.get("orderNumber"), r.get("notes"), r.get("terms") ? r.get("terms").id : null, r.get("reasonCode") ? r.get("reasonCode").id : null, r.get("salesRep") ? r.get("salesRep").id : null, r.get("paid"), i ], s.success = function(e) {
r.setStatus(XM.Model.READY_CLEAN, n), o && o(r, e, n);
}, s.error = function() {}, this.isCredit() ? (_.each(u.taxes, function(e) {
e.taxAmount = -Math.abs(e.taxAmount);
}), this.createCreditMemo(u, s)) : this.isDebit() && this.createDebitMemo(u, s), this) : !1;
}
return XM.Model.prototype.save.call(this, e, t, n);
},
validate: function() {
var e = this.get("amount") || 0, t = this.get("taxTotal") || 0, n = this.get("currency"), r = this.get("documentDate"), i, s = {}, o;
o = XM.Document.prototype.validate.apply(this, arguments);
if (o) return o;
i = XM.currencyRates.getScalarRate("to base from", n, r);
if (!i || isNaN(i)) return s.currency = n.get("abbreviation"), s.asOf = Globalize.format(r, "d"), XT.Error.clone("xt2010", {
params: s
});
if (e <= 0) return s = {
attr: "_amount".loc(),
value: e
}, XT.Error.clone("xt1013", {
params: s
});
if (Math.max(t, e) === t) return XT.Error.clone("xt2024");
return;
}
}), XM.ReceivableMixin = {
isDebit: function() {
return this.get("documentType") === XM.Receivable.DEBIT_MEMO || this.get("documentType") === XM.Receivable.INVOICE ? !0 : !1;
},
isCredit: function() {
return this.get("documentType") === XM.Receivable.CREDIT_MEMO || this.get("documentType") === XM.Receivable.INVOICE ? !0 : !1;
}
}, XM.Receivable = XM.Receivable.extend(XM.ReceivableMixin), _.extend(XM.Receivable, {
INVOICE: "I",
DEBIT_MEMO: "D",
CREDIT_MEMO: "C",
CUSTOMER_DEPOSIT: "R"
}), XM.ReceivableTax = XM.Model.extend({
recordType: "XM.ReceivableTax",
idAttribute: "uuid",
defaults: function() {
return {
basis: 0,
percent: 0,
amount: 0
};
},
bindEvents: function(e, t) {
XM.Model.prototype.bindEvents.apply(this, arguments), this.on("change:tax", this.parentDidChange), this.on("statusChange", this.statusDidChange);
},
parentDidChange: function() {
var e = this.get("tax");
this.set("documentDate", e.get("documentDate"));
},
statusDidChange: function() {
var e = this.getStatus() === XM.Model.READY_CLEAN;
this.setReadOnly([ "taxCode", "taxAmount" ], e);
}
}), XM.ReceivableApplication = XM.Model.extend({
recordType: "XM.ReceivableApplication",
idAttribute: "uuid"
}), XM.ReceivableListItem = XM.Info.extend({
recordType: "XM.ReceivableListItem",
idAttribute: "uuid",
editableModel: "XM.Receivable",
canOpen: function(e) {
return e && e(this.get("isPosted")), this;
}
}), XM.ReceivableRelation = XM.Model.extend({
recordType: "XM.ReceivableRelation",
idAttribute: "uuid"
}), XM.ReceivableRelationCollection = XM.Collection.extend({
model: XM.ReceivableRelation
}), XM.ReceivableListItemCollection = XM.Collection.extend({
model: XM.ReceivableListItem
}), XM.ReceivableTaxCollection = XM.Collection.extend({
model: XM.ReceivableTax
}), XM.ReceivableApplicationCollection = XM.Collection.extend({
model: XM.ReceivableApplication
});
};

// static.js

(function() {
"use strict";
XT.extensions.billing.initStaticModels = function() {
var e, t;
t = XM.Receivable;
var n = [ {
id: t.INVOICE,
name: "_invoice".loc()
}, {
id: t.DEBIT_MEMO,
name: "_debitMemo".loc()
}, {
id: t.CREDIT_MEMO,
name: "_creditMemo".loc()
}, {
id: t.CUSTOMER_DEPOSIT,
name: "_customerDeposit".loc()
} ];
XM.ReceivableTypeModel = Backbone.Model.extend({}), XM.ReceivableTypeCollection = Backbone.Collection.extend({
model: XM.ReceivableTypeModel
}), XM.receivableTypes = new XM.ReceivableTypeCollection;
for (e = 0; e < n.length; e++) {
var r = new XM.ReceivableTypeModel(n[e]);
XM.receivableTypes.add(r);
}
XM.FundsTypeEnum = {
C: "CHECK",
T: "CERTIFIED_CHECK",
K: "CASH",
M: "MASTERCARD",
V: "VISA",
A: "AMERICAN_EXPRESS",
D: "DISCOVER",
R: "OTHER_CREDIT_CARD",
W: "WIRE_TRANSFER",
O: "OTHER"
}, XM.FundsType = XM.StaticModel.extend({
isCreditCard: function() {
return _.contains([ "M", "V", "A", "D", "R" ], this.id);
}
}), XM.fundsTypes = new XM.EnumMapCollection(XM.FundsTypeEnum, {
model: XM.FundsType
}), XM.CashReceiptApplyOptionEnum = {
0: "APPLY_BALANCE_TO_CREDIT_MEMO",
1: "APPLY_BALANCE_TO_CUSTOMER_DEPOSIT"
}, XM.cashReceiptApplyOptions = new XM.EnumMapCollection(XM.CashReceiptApplyOptionEnum);
};
})();

// cash_receipt.js

XT.extensions.billing.initCashReceipt = function() {
"use strict";
XM.CashReceipt = XM.Document.extend({
recordType: "XM.CashReceipt",
idAttribute: "number",
documentKey: "number",
documentDateKey: "documentDate",
enforceUpperKey: !1,
numberPolicy: XM.Document.AUTO_NUMBER,
defaults: function() {
return this.meta = new Backbone.Model, {
isPosted: !1,
fundsType: XM.CashReceipt.CHECK,
useCustomerDeposit: !1,
currency: XM.baseCurrency,
currencyRate: 1,
documentDate: new Date,
amount: 0,
appliedAmount: 0,
balance: 0
};
},
readOnlyAttributes: [ "balance", "appliedAmount", "currencyRate" ],
handlers: {
"status:READY_CLEAN": "onReadyClean",
"change:appliedAmount": "updateBalance",
"change:amount": "updateBalance",
"change:customer": "customerChanged",
"change:currency": "currencyChanged",
"change:distributionDate": "distributionDateChanged",
"change:applicationDate": "dateChanged",
"change:useCustomerDeposit": "useCustomerDepositChanged",
add: "lineItemAdded"
},
useCustomerDepositChanged: function() {
this.attributes.useCustomerDeposit = this.get("useCustomerDeposit") === "1";
},
distributionDateChanged: function() {
this.dateChanged(), this.checkCurrency();
},
updateAppliedAmount: function() {
var e = _.reduce(this.get("lineItems"), function(e, t) {
return e + t.get("appliedAmount");
}, 0);
this.set("appliedAmount", e);
},
updateBalance: function() {
this.set({
balance: this.get("amount") - this.get("appliedAmount")
});
},
lineItemAdded: function() {
console.log("added"), console.log(arguments);
},
onReadyClean: function(e) {
this.setReadOnly([ "amount", "fundsType", "documentNumber", "documentDate", "bankAccount", "distributionDate", "applicationDate" ], XM.fundsTypes.get(this.get("fundsType")).isCreditCard());
},
customerChanged: function(e, t) {
this.set({
currency: t.get("currency")
});
},
currencyChanged: function(e, t) {
var n = this;
this.checkCurrency();
},
getMinimumDate: function() {
return this.lineItems ? _.max(this.lineItems.pluck("documentDate")) : XT.date.startOfTime();
},
checkCurrency: function(e) {
var t = this, n = function(n) {
var r = t.previousAttributes().currency;
n || (console.log("canceled currency change from " + r + " to " + t.get("currency")), t.set({
currency: r
}));
if (_.isFunction(e)) return e(n), t;
}, r = this.get("bankAccount"), i, s;
return this.get("bankAccount") ? (i = r.get("currency").get("abbreviation"), s = this.get("currency").get("abbreviation"), i !== s && this.meta.get("currencyWarning") && (this.notify("_currencyMismatchWarning".loc().replace("{cr_currency}", s).replace("{ba_currency}", i), {
callback: n
}), this.meta.set({
currencyWarning: !1
})), n(!0)) : n(!0);
},
dateChanged: function() {
var e = this.getMinimumDate(), t = this.get("applicationDate"), n = this.get("distributionDate");
moment(t).isBefore(e) && this.set("applicationDate", e), moment(n).isAfter(t) && this.set("distributionDate", t);
},
applyAmount: function(e, t, n) {
this.lineItems.add(new XM.CashReceiptLine({
receivable: e,
amount: t,
discountAmount: n
}));
},
_applyLineBalance: function(e, t, n) {
if (e.isDebit() && this.get("balance") === 0) return t.error("_noApplicableCashReceiptBalance".loc());
var r = this, i = {
checkCurrency: function() {
return r.checkCurrency(function(n) {
if (!n) return;
r._applyLineBalance(e, t, "convertCurrency");
});
},
convertCurrency: function() {
return e.get("currency").toCurrency(r.get("currency"), e.get("balance"), r.get("distributionDate"), {
success: function(n) {
r._applyLineBalance(e, t, "fetchReceivable");
},
error: function() {
t.error("_currencyConversionError".loc());
}
});
},
fetchReceivable: function() {
e.fetch({
success: function(e) {
e.getLockKey() ? t.success(e) : t.error("locked");
},
error: t.error
});
}
};
return i[n || "checkCurrency"]();
},
applyLineBalance: function(e, t) {
var n = this, r = {
success: function(e) {
var n = e.get("terms"), r = _.extend(this._calculateReceivableApplication(e), {
receivable: e
}), i = new XM.CashReceiptLine(r), s = new XM.CashReceiptLinePending(r);
e.get("pendingApplications").add(s), this.get("lineItems").add(i), t();
},
error: function() {}
};
return this._applyLineBalance(e, r), this;
},
_calculateReceivableApplication: function(e) {
if (!e.isDebit()) return null;
var t = e.get("terms"), n = this.get("documentDate"), r = t ? t.calculateDiscountDate(n) : 0, i = e.get("balance"), s = this.get("balance"), o = t ? t.get("discountPercent") : 0, u = i >= s - i * o, a = XT.math.round(u ? i * o : s / (1 - o), XT.MONEY_SCALE), f = XT.math.round(u ? i - i * o : s);
return {
applyAmount: f,
discountAmount: a
};
},
applyBalance: function(e, t, n) {
var r = this, i = t ? e.getCredits() : [], s = e.getDebits(), o = _.union(i, s), u = 0, a = function() {
while (r.get("balance") > 0) return r.applyLineBalance(o[u++], a);
};
return a();
},
clearLine: function(e) {
var t = this.get("lineItems");
t.remove(t.where({
receivable: e
}));
}
}, _.invert(XM.FundsTypeEnum)), XM.CashReceiptLine = XM.Document.extend({
recordType: "XM.CashReceiptLine",
enforceUpperKey: !1,
numberPolicy: XM.Document.AUTO_NUMBER,
defaults: {
amount: 0,
discountAmount: 0
}
}), XM.CashReceiptLinePending = XM.Model.extend({
recordType: "XM.CashReceiptLinePending",
readOnly: !0
}), XM.CashReceiptReceivable = XM.Receivable.extend({
recordType: "XM.CashReceiptReceivable",
idAttribute: "uuid",
readOnly: !0,
readOnlyAttributes: [ "receivable.documentNumber", "receivable.documentType", "receivable.orderNumber", "receivable.dueDate", "receivable.currency", "balance", "allPending" ],
initialize: function() {
this.isNew() && this.setReadOnly(this.readOnlyAttributes, !1);
},
events: {
"change:amount": "updateBalance",
"change:appliedAmount": "updateBalance"
},
updateBalance: function() {
this.set({
balance: this.get("amount") - this.get("appliedAmount")
});
}
}), XM.CashReceiptReceivable = XM.CashReceiptReceivable.extend(XM.ReceivableMixin), XM.CashReceiptListItem = XM.Info.extend({
recordType: "XM.CashReceiptListItem",
editableModel: "XM.CashReceipt",
idAttribute: "number",
canPost: function(e) {
e(XT.session.privileges.get("MaintainCashReceipts"));
},
canVoid: function(e) {
e(!this.get("isPosted") || XT.session.privileges.get("VoidPostedCashReceipts"));
}
}), XM.CashReceiptLineListItem = XM.Info.extend({
recordType: "XM.CashReceiptLineListItem",
editableModel: "XM.CashReceiptLine",
idAttribute: "number",
canPost: function(e) {
e(XT.session.privileges.get("PostCashReceipts"));
}
}), XM.CashReceiptRelation = XM.Info.extend({
recordType: "XM.CashReceiptRelation",
editableModel: "XM.CashReceipt"
}), XM.CashReceiptCollection = XM.Collection.extend({
model: XM.CashReceipt
}), XM.CashReceiptRelationCollection = XM.Collection.extend({
model: XM.CashReceiptRelation
}), XM.CashReceiptLineListItemCollection = XM.Collection.extend({
model: XM.CashReceiptLineListItem
}), XM.CashReceiptListItemCollection = XM.Collection.extend({
model: XM.CashReceiptListItem
}), XM.CashReceiptReceivableCollection = XM.Collection.extend({
model: XM.CashReceiptReceivable,
comparator: function(e) {
return 0 - parseInt(String(e.get("dueDate").valueOf()) + String(e.get("documentNumber")));
},
getCredits: function() {
return this.where({
documentType: XM.Receivable.CREDIT_MEMO
});
},
getDebits: function() {
return this.where({
documentType: XM.Receivable.DEBIT_MEMO
});
}
});
};

// startup.js

(function() {
"use strict";
XT.extensions.billing.initStartup = function() {
XT.cacheCollection("XM.bankAccountRelations", "XM.BankAccountRelationCollection"), XT.cacheCollection("XM.customerEmailProfiles", "XM.CustomerEmailProfileCollection"), XT.cacheCollection("XM.incidentCategories", "XM.IncidentCategoryCollection");
};
})();

// sales_category.js

XT.extensions.billing.initSalesCategoryView = function() {
var e = "XM.SalesCategory";
XM.SalesCategoryView = XM.EnyoView.extend({
events: {
"change:canDeactivate": "onCanDeactivateChange",
"change:isActive": "onIsActiveChange",
"status:READY_CLEAN": "onModelReadyClean"
},
item: {
model: e,
template: [ [ {
attr: "name"
}, {
attr: "description"
} ] ]
},
list: {
model: e,
query: {
orderBy: [ {
attribute: "isActive",
descending: !0
}, {
attribute: "name"
} ]
},
actions: [ {
name: "deactivate",
privilege: "MaintainSalesCategories",
prerequisite: "canDeactivate",
method: "deactivate"
} ]
},
workspace: {
model: e,
template: [ {
title: "_overview".loc(),
template: [ {
attr: "name"
}, {
attr: "description"
}, {
attr: "isActive",
prerequisite: "canDeactivate"
} ]
} ]
}
});
};

// cash_receipt.js

XT.extensions.billing.initCashReceiptView = function() {
var e = "XM.CashReceipt";
XM.CashReceiptView = XM.EnyoView.extend({
events: {
"view:notify": "doNotify",
"change:distributionDate": "onDateChange",
"change:applicationDate": "onDateChange",
"change:balance": "onBalanceChange"
},
item: {
model: e + "ListItem",
template: [ [ {
attr: "number",
colspan: 2
}, {
attr: "posted",
formatter: "formatIsPosted"
}, {
attr: "amount"
}, {
attr: "distributionDate"
} ], [ {
attr: "customer.name",
colspan: 2
}, {
attr: "fundsType",
formatter: "formatFundsType"
}, {
attr: "bankAccount.name"
} ] ]
},
list: {
model: e + "ListItem",
allowPrint: !0,
query: {
orderBy: [ {
attribute: "distributionDate",
descending: !0
}, {
attribute: "number",
descending: !0
} ]
},
parameters: [ {
category: "_cashReceipts".loc(),
parameters: [ {
label: "_number".loc()
} ]
}, {
category: "_show".loc(),
parameters: [ {
label: "_unposted".loc(),
"default": !1
} ]
}, {
category: "_customer".loc(),
parameters: [ {
label: "_number".loc()
}, {
label: "_type".loc(),
type: "enum"
}, {
label: "_typePattern".loc()
}, {
label: "_group".loc()
} ]
}, {
category: "_documentDate".loc(),
parameters: [ {
label: "_fromDate".loc()
}, {
label: "_toDate".loc()
} ]
} ],
actions: [ {
name: "post",
privilege: "PostCashReceipts",
prerequisite: "canPost",
method: "post"
}, {
name: "void",
privilege: "VoidPostedCashReceipts",
prerequisite: "canVoid",
method: "void"
} ]
},
workspace: {
model: e,
panels: [ {
title: "_overview".loc(),
template: []
}, {
type: "relation",
attribute: "lineItems"
} ],
relations: []
}
});
};

// list.js

XT.extensions.billing.initLists = function() {
"use strict";
enyo.kind({
name: "XV.SalesCategoryList",
kind: "XV.List",
view: "XM.SalesCategoryView",
label: "_salesCategories".loc(),
collection: "XM.SalesCategoryCollection",
components: [ {
kind: "XV.ListItemDecorator",
components: [ {
name: "listItem",
kind: "XV.SalesCategoryListItem"
} ]
} ]
}), XV.registerModelList("XM.SalesCategory", "XV.SalesCategoryList"), enyo.kind({
name: "XV.CashReceiptList",
kind: "XV.List",
view: "XM.CashReceiptView",
label: "_cashReceipts".loc(),
collection: "XM.CashReceiptListItemCollection",
parameterWidget: "XV.CashReceiptListParameters",
components: [ {
kind: "XV.ListItemDecorator",
components: [ {
name: "listItem",
kind: "XV.CashReceiptListItem"
} ]
} ]
}), XV.registerModelList("XM.CashReceiptListItem", "XV.CashReceiptList"), enyo.kind({
name: "XV.ReceivableList",
kind: "XV.List",
view: "XM.ReceivableView",
label: "_receivables".loc(),
collection: "XM.ReceivableListItemCollection",
parameterWidget: "XV.ReceivableListParameters",
allowPrint: !0,
multiSelect: !0,
showDeleteAction: !1,
query: {
orderBy: [ {
attribute: "documentNumber"
} ]
},
newActions: [ {
name: "creditMemo",
label: "_miscCreditMemo".loc(),
allowNew: !1,
defaults: {
documentType: XM.Receivable.CREDIT_MEMO
}
}, {
name: "debitMemo",
label: "_miscDebitMemo".loc(),
allowNew: !1,
defaults: {
documentType: XM.Receivable.DEBIT_MEMO
}
} ],
actions: [ {
name: "open",
privilege: "ViewAROpenItems",
prerequisite: "canOpen",
method: "openReceivable",
notify: !1,
isViewMethod: !0
} ],
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListColumn",
classes: "short",
components: [ {
kind: "XV.ListAttr",
attr: "documentType",
formatter: "formatDocumentType"
} ]
}, {
kind: "XV.ListColumn",
classes: "third",
components: [ {
kind: "XV.ListAttr",
attr: "isPosted",
formatter: "formatPosted"
} ]
}, {
kind: "XV.ListColumn",
classes: "money",
components: [ {
kind: "XV.ListAttr",
attr: "documentNumber"
} ]
}, {
kind: "XV.ListColumn",
classes: "descr",
components: [ {
kind: "XV.ListAttr",
attr: "customer.name"
} ]
}, {
kind: "XV.ListColumn",
classes: "money",
components: [ {
kind: "XV.ListAttr",
attr: "documentDate"
} ]
}, {
kind: "XV.ListColumn",
classes: "money",
components: [ {
kind: "XV.ListAttr",
attr: "dueDate"
} ]
}, {
kind: "XV.ListColumn",
classes: "money",
components: [ {
kind: "XV.ListAttr",
attr: "amount",
formatter: "formatMoney"
} ]
}, {
kind: "XV.ListColumn",
classes: "money",
components: [ {
kind: "XV.ListAttr",
attr: "paid",
formatter: "formatMoney"
} ]
}, {
kind: "XV.ListColumn",
classes: "money",
components: [ {
kind: "XV.ListAttr",
attr: "balance",
formatter: "formatMoney"
} ]
} ]
} ]
} ],
formatMoney: function(e, t, n) {
var r = n ? n.get("currency") : !1, i = XT.locale.moneyScale;
return r ? r.format(e, i) : "";
},
formatDocumentType: function(e, t, n) {
var r = XM.Receivable, i = n ? n.get("documentType") : null;
switch (i) {
case r.INVOICE:
return "_invoice".loc();
case r.DEBIT_MEMO:
return "_debitMemo".loc();
case r.CREDIT_MEMO:
return "_creditMemo".loc();
case r.CUSTOMER_DEPOSIT:
return "_customerDeposit".loc();
}
return "";
},
formatPosted: function(e, t, n) {
var r = n ? n.get("isPosted") : null;
return r ? "_yes".loc() : "_no".loc();
},
openReceivable: function(e) {
var t = e.model;
this.doWorkspace({
workspace: this.getWorkspace(),
id: t.id,
allowNew: !1
});
}
}), XV.registerModelList("XM.Receivable", "XV.ReceivableList");
};

// list_relations.js

(function() {
XT.extensions.billing.initListRelations = function() {
enyo.kind({
name: "XV.ReceivableTaxListRelations",
kind: "XV.ListRelations",
parentKey: "receivable",
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListColumn",
classes: "short",
fit: !0,
components: [ {
kind: "XV.ListAttr",
attr: "taxCode.code",
classes: "bold"
} ]
}, {
kind: "XV.ListColumn",
components: [ {
kind: "XV.ListAttr",
attr: "taxAmount",
classes: "bold"
} ]
} ]
} ]
} ]
}), enyo.kind({
name: "XV.ReceivableApplicationListRelations",
kind: "XV.ListRelations",
parentKey: "receivable",
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListColumn",
fit: !0,
components: [ {
kind: "XV.ListAttr",
attr: "documentNumber",
classes: "bold"
} ]
}, {
kind: "XV.ListColumn",
components: [ {
kind: "XV.ListAttr",
attr: "applicationDate"
} ]
} ]
} ]
} ]
}), enyo.kind({
name: "XV.CashReceiptLineList",
kind: "XV.ListRelations",
parentKey: "cashReceipt",
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListColumn",
classes: "short",
fit: !0,
components: [ {
kind: "XV.ListAttr",
attr: "cashReceiptReceivable.receivable.documentNumber",
classes: "bold"
} ]
}, {
kind: "XV.ListColumn",
components: [ {
kind: "XV.ListAttr",
attr: "amount",
formatter: "formatMoney"
} ]
} ]
} ]
} ],
formatMoney: function(e, t, n) {
var r = n ? n.getValue("cashReceipt.currency") : !1, i = XT.locale.moneyScale;
return r ? r.format(e, i) : "";
}
}), enyo.kind({
name: "XV.CashAllocationList",
kind: "XV.ListRelations",
parentKey: "targetDocument",
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListColumn",
components: [ {
kind: "XV.ListAttr",
attr: "amount",
formatter: "formatMoney",
classes: "bold",
fit: !0
} ]
}, {
kind: "XV.ListColumn",
classes: "short",
components: [ {
kind: "XV.ListAttr",
attr: "documentDate"
} ]
} ]
} ]
} ],
formatMoney: function(e, t, n) {
var r = n ? n.getValue("currency") : !1, i = XT.locale.moneyScale;
return r ? r.format(e, i) : "";
}
});
};
})();

// list_relations_box.js

(function() {
XT.extensions.billing.initListRelationsBox = function() {
enyo.kind({
name: "XV.ReceivableTaxBox",
kind: "XV.ListRelationsEditorBox",
title: "_tax".loc(),
editor: "XV.ReceivableTaxEditor",
parentKey: "receivable",
listRelations: "XV.ReceivableTaxListRelations",
fitButtons: !1,
create: function() {
this.inherited(arguments), this.$.deleteButton.setShowing(!1);
}
}), enyo.kind({
name: "XV.ReceivableApplicationsListRelationsBox",
kind: "XV.ListRelationsBox",
title: "_applications".loc(),
parentKey: "receivable",
listRelations: "XV.ReceivableApplicationListRelations"
}), enyo.kind({
name: "XV.CashReceiptApplicationsBox",
kind: "XV.ListRelationsEditorBox",
editor: "XV.CashReceiptLineEditor",
parentKey: "cashReceipt",
listRelations: "XV.CashReceiptLineList",
title: "_cashReceiptApplications".loc()
});
};
})();

// list_relations_editor_box.js

XT.extensions.billing.initListRelationsEditors = function() {
enyo.kind({
name: "XV.SalesOrderPaymentBox",
kind: "XV.RelationsEditor",
controlClasses: "in-panel",
published: {
salesOrder: null
},
events: {
onPaymentPosted: ""
},
components: [ {
kind: "onyx.GroupboxHeader",
content: "_payment".loc()
}, {
kind: "XV.InputWidget",
attr: "number"
}, {
kind: "XV.DateWidget",
attr: "documentDate"
}, {
kind: "XV.BankAccountWidget",
attr: "bankAccount"
}, {
kind: "XV.FundsTypePicker",
attr: "fundsType",
onSelect: "fundsTypeSelected"
}, {
kind: "XV.MoneyWidget",
name: "payment",
label: "_payment".loc(),
attr: {
localValue: "amount",
currency: "currency"
}
}, {
kind: "XV.MoneyWidget",
label: "_balance".loc(),
attr: {
localValue: "balance",
currency: "currency"
}
}, {
kind: "FittableColumns",
components: [ {
kind: "onyx.Button",
name: "postButton",
content: "_postCashPayment".loc(),
classes: "onyx-blue",
fit: !0,
ontap: "validatePayment",
disabled: !0
} ]
} ],
valueChanged: function() {
this.value.off("change:amount"), this.inherited(arguments);
},
salesOrderChanged: function() {
var e = this, t = function(t) {
e.$.postButton.setDisabled(!1), e.newItem();
}, n = function(t) {
e.$.postButton.setDisabled(!0);
};
this.salesOrder.getStatus() === XM.Model.READY_CLEAN && t(this.salesOrder), this.salesOrder.getStatus() === XM.Model.READY_DIRTY && n(this.salesOrder), this.salesOrder.once("status:READY_CLEAN", t), this.salesOrder.once("status:READY_DIRTY", n);
},
newItem: function() {
var e = this.salesOrder;
this.setValue(new XM.CashReceipt({
balance: e.get("balance"),
amount: e.get("balance"),
customer: e.get("customer"),
documentDate: new Date,
applicationDate: e.get("orderDate"),
distributionDate: e.get("orderDate"),
currency: e.get("currency")
}, {
isNew: !0
}));
},
validatePayment: function(e, t) {
var n = this, r = n.value;
r.get("amount") > r.get("balance") && n.doNotify({
type: XM.Model.YES_NO_CANCEL,
message: "_salesOrderPaymentOverapplicationWarn".loc(),
callback: function(e) {
e.answer === !0 && n.addPayment();
}
});
},
addPayment: function(e, t) {
var n = this, r = n.value;
this.salesOrder.once("payment:success", function() {
n.doNotify({
type: XM.Model.NOTICE,
message: "_salesOrderPaymentSuccess".loc(),
callback: function() {
n.doPaymentPosted(), setTimeout(function() {
n.newItem();
}, 2e3);
}
});
}), this.salesOrder.once("payment:error", function(e) {
n.doNotify({
type: XM.Model.WARNING,
message: "_salesOrderPaymentFailure".loc()
}), n.newItem();
});
if (!r || !r.isValid()) return n.doNotify({
type: XM.Model.NOTICE,
message: "Please correct errors in the Payment editor"
}), !0;
this.salesOrder.addPayment(r);
}
}), enyo.kind({
name: "XV.CashReceiptLineEditor",
kind: "XV.RelationsEditor",
style: "width: 100%",
components: [ {
kind: "XV.ScrollableGroupbox",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.InputWidget",
attr: "cashReceiptReceivable.receivable.documentNumber",
label: "_documentNumber".loc()
}, {
kind: "XV.InputWidget",
attr: "cashReceiptReceivable.receivable.orderNumber",
label: "_orderNumber".loc()
}, {
kind: "XV.DateWidget",
attr: "cashReceiptReceivable.receivable.dueDate",
label: "_dueDate".loc()
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "amount",
currency: "cashReceipt.currency"
},
label: "_amount".loc(),
disableCurrency: !0
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "discountAmount",
currency: "cashReceipt.currency"
},
label: "_discount".loc(),
disableCurrency: !0
} ]
} ]
}), enyo.kind({
name: "XV.ReceivableTaxEditor",
kind: "XV.RelationsEditor",
components: [ {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.TaxCodePicker",
attr: "taxCode"
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "taxAmount"
},
label: "_amount".loc(),
currencyShowing: !1
} ]
} ]
});
};

// receivable.js

XT.extensions.billing.initReceivableView = function() {
var e = "XM.Receivable";
XM.ReceivableView = XM.EnyoView.extend({
events: {
statusChange: "onStatusChange"
}
});
};

// workspace.js

(function() {
XT.extensions.billing.initWorkspaces = function() {
enyo.kind({
name: "XV.BillingWorkspace",
kind: "XV.Workspace",
title: "_configure".loc() + " " + "_billing".loc(),
model: "XM.Billing",
components: [ {
kind: "Panels",
arrangerKind: "CarouselArranger",
fit: !0,
components: [ {
kind: "XV.Groupbox",
name: "mainPanel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_overview".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.NumberWidget",
attr: "NextARMemoNumber",
label: "_nextARMemoNumber".loc(),
formatting: !1
}, {
kind: "XV.NumberWidget",
attr: "NextCashRcptNumber",
label: "_nextCashRcptNumber".loc(),
formatting: !1
}, {
kind: "XV.ToggleButtonWidget",
name: "hideApplyToBalance",
attr: "HideApplyToBalance",
label: "_hideApplyToBalance".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "EnableCustomerDeposits",
label: "_enableCustomerDeposits".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "CreditTaxDiscount",
label: "_creditTaxDiscount".loc(),
formatting: !1
}, {
kind: "XV.AddressFieldsWidget",
name: "address",
attr: {
name: "remitto_name",
line1: "remitto_address1",
line2: "remitto_address2",
line3: "remitto_address3",
city: "remitto_city",
state: "remitto_state",
postalCode: "remitto_zipcode",
country: "remitto_country"
}
}, {
kind: "XV.InputWidget",
attr: "remitto_phone",
label: "_phone".loc(),
formatting: !1
}, {
kind: "XV.ToggleButtonWidget",
attr: "AutoCreditWarnLateCustomers",
label: "_autoCreditWarnLateCustomers".loc()
}, {
kind: "XV.NumberSpinnerWidget",
attr: "DefaultAutoCreditWarnGraceDays",
label: "_defaultAutoCreditWarnGraceDays".loc()
}, {
kind: "XV.NumberSpinnerWidget",
attr: "RecurringInvoiceBuffer",
label: "_recurringInvoiceBuffer".loc()
}, {
kind: "XV.IncidentCategoryPicker",
attr: "DefaultARIncidentStatus",
label: "_defaultARIncidentStatus".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "AutoCloseARIncident",
label: "_autoCloseARIncident".loc()
} ]
} ]
} ]
} ]
});
}, enyo.kind({
name: "XV.ReceivableWorkspace",
kind: "XV.Workspace",
title: "_receivable".loc(),
model: "XM.Receivable",
view: "XM.ReceivableView",
events: {
onPrint: ""
},
components: [ {
kind: "Panels",
arrangerKind: "CarouselArranger",
fit: !0,
components: [ {
kind: "XV.Groupbox",
name: "mainPanel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_overview".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.SalesCustomerWidget",
attr: "customer"
}, {
kind: "XV.DateWidget",
attr: "documentDate"
}, {
kind: "XV.DateWidget",
attr: "dueDate"
}, {
kind: "XV.ReceivableTypePicker",
attr: "documentType"
}, {
kind: "XV.InputWidget",
attr: "documentNumber"
}, {
kind: "XV.InputWidget",
attr: "orderNumber"
}, {
kind: "XV.ReasonCodePicker",
name: "reasonCodePicker",
attr: "reasonCode",
documentType: null
}, {
kind: "onyx.GroupboxHeader",
content: "_notes".loc()
}, {
kind: "XV.TextArea",
attr: "notes"
}, {
kind: "onyx.GroupboxHeader",
content: "_options".loc()
}, {
kind: "XV.StickyCheckboxWidget",
label: "_printOnPost".loc(),
name: "printOnPost"
} ]
} ]
}, {
kind: "XV.Groupbox",
name: "settingsPanel",
title: "_settings".loc(),
components: [ {
kind: "onyx.GroupboxHeader",
content: "_settings".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "settingsGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.BillingTermsPicker",
attr: "terms"
}, {
kind: "XV.SalesRepPicker",
attr: "salesRep"
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "amount",
currency: "currency"
},
label: "_amount".loc(),
effective: "documentDate"
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "paid",
currency: "currency"
},
label: "_paid".loc(),
effective: "documentDate",
currencyDisabled: !0
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "balance",
currency: "currency"
},
label: "_balance".loc(),
effective: "documentDate",
currencyDisabled: !0
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "commission",
currency: "currency"
},
label: "_commission".loc(),
effective: "documentDate",
currencyDisabled: !0
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "taxTotal"
},
label: "_taxTotal".loc(),
name: "taxTotal",
currencyShowing: !1
} ]
} ]
}, {
kind: "XV.ReceivableTaxBox",
name: "taxes",
attr: "taxes",
title: "_taxes".loc()
}, {
kind: "XV.ReceivableApplicationsListRelationsBox",
attr: "applications",
title: "_applications".loc()
} ]
} ],
handlers: {
onStatusChange: "statusChanged"
},
attributesChanged: function(e, t) {
this.inherited(arguments);
var n = this.value.get("documentType");
if (!n) return;
var r = n === XM.Receivable.INVOICE;
this.$.taxTotal.setShowing(!r), this.$.taxes.setShowing(!r), n === XM.Receivable.CREDIT_MEMO ? this.$.reasonCodePicker.setDocumentType(XM.ReasonCode.CREDIT_MEMO) : n === XM.Receivable.DEBIT_MEMO && this.$.reasonCodePicker.setDocumentType(XM.ReasonCode.DEBIT_MEMO);
},
statusChanged: function(e, t) {
var n = this.value.getStatus() === XM.Model.READY_NEW;
n && this.setSaveText("_post".loc()), this.$.printOnPost.setShowing(n);
},
save: function(e) {
this.$.printOnPost.isChecked() && this.doPrint(), this.inherited(arguments);
}
}), XV.registerModelWorkspace("XM.Receivable", "XV.ReceivableWorkspace"), XV.registerModelWorkspace("XM.ReceivableListItem", "XV.ReceivableWorkspace"), enyo.kind({
name: "XV.SalesCategoryWorkspace",
kind: "XV.Workspace",
model: "XM.SalesCategory",
view: "XM.SalesCategoryView",
title: "_salesCategory".loc(),
components: [ {
kind: "Panels",
arrangerKind: "CarouselArranger",
fit: !0,
components: [ {
kind: "XV.Groupbox",
name: "mainPanel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_overview".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
classes: "in-panel",
components: [ {
kind: "XV.InputWidget",
attr: "name"
}, {
kind: "XV.InputWidget",
attr: "description"
}, {
kind: "XV.CheckboxWidget",
name: "isActive",
attr: "isActive",
disabled: !0
} ]
} ]
} ]
} ],
handlers: {
onCanDeactivateChange: "canDeactivateChanged",
onModelReadyClean: "modelReady"
},
modelReady: function(e, t) {
return this.value.get("isActive") ? t.result.canDeactivate() : this.$.isActive.setDisabled(!this.value.canEdit("isActive")), !0;
},
canDeactivateChanged: function(e, t) {
return this.$.isActive.setDisabled(!t), !0;
}
}), XV.registerModelWorkspace("XM.SalesCategory", "XV.SalesCategoryWorkspace"), enyo.kind({
name: "XV.CashReceiptWorkspace",
kind: "XV.Workspace",
view: "XM.CashReceiptView",
model: "XM.CashReceipt",
title: "_cashReceipt".loc(),
components: [ {
kind: "Panels",
arrangerKind: "CarouselArranger",
fit: !0,
components: [ {
kind: "XV.Groupbox",
name: "mainPanel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_overview".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
classes: "in-panel",
components: [ {
kind: "XV.InputWidget",
attr: "number"
}, {
kind: "XV.CheckboxWidget",
attr: "isPosted",
label: "_posted".loc()
}, {
kind: "XV.SalesCustomerWidget",
attr: "customer"
}, {
kind: "XV.BankAccountWidget",
attr: "bankAccount"
}, {
kind: "XV.FundsTypePicker",
attr: "fundsType",
onSelect: "fundsTypeSelected"
}, {
kind: "XV.CashReceiptApplyOptionsPicker",
attr: "useCustomerDeposit",
onSelect: "applyOptionSelected"
}, {
tag: "hr"
}, {
kind: "XV.DateWidget",
attr: "documentDate"
}, {
kind: "XV.DateWidget",
attr: "distributionDate"
}, {
kind: "XV.DateWidget",
attr: "applicationDate"
}, {
tag: "hr"
}, {
kind: "XV.MoneyWidget",
name: "balance",
label: "_balance".loc(),
attr: {
localValue: "balance",
currency: "currency"
},
disableCurrency: !0
}, {
kind: "XV.MoneyWidget",
label: "_amount".loc(),
attr: {
localValue: "amount",
currency: "currency"
},
disableCurrency: !0
}, {
kind: "XV.MoneyWidget",
label: "_appliedAmount".loc(),
attr: {
localValue: "appliedAmount",
currency: "currency"
},
disableCurrency: !0
}, {
kind: "onyx.GroupboxHeader",
content: "_notes".loc()
}, {
kind: "XV.TextArea",
attr: "notes"
} ]
} ]
}, {
kind: "XV.CashReceiptApplicationsBox",
attr: "lineItems"
}, {
kind: "XV.CreditCardBox",
attr: "customer.creditCards"
} ]
} ],
handlers: {
onDateChange: "dateChanged",
onBalanceChange: "balanceChanged",
newItem: "newCashReceiptLineTapped"
},
newCashReceiptLineTapped: function(e, t) {
this.log(t);
},
balanceChanged: function(e, t) {
this.$.balance.addRemoveClass("xv-balance-negative", this.value.get("balance") < 0);
},
dateChanged: function(e, t) {}
}), XV.registerModelWorkspace("XM.CashReceipt", "XV.CashReceiptWorkspace"), XV.registerModelWorkspace("XM.CashReceiptRelation", "XV.CashReceiptWorkspace"), XV.registerModelWorkspace("XM.CashReceiptListItem", "XV.CashReceiptWorkspace"), enyo.kind({
name: "XV.CashReceiptReceivableWorkspace",
kind: "XV.Workspace",
view: "XM.CashReceiptView",
title: "_cashReceiptReceivable".loc(),
components: [ {
kind: "Panels",
arrangerKind: "CarouselArranger",
fit: !0,
components: [ {
kind: "XV.Groupbox",
name: "mainPanel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_overview".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
classes: "in-panel",
components: [ {
kind: "XV.InputWidget",
attr: "number"
} ]
} ]
} ]
} ]
}), XV.registerModelWorkspace("XM.CashReceiptLineListItem", "XV.CashReceiptReceivableWorkspace");
})();

// list_item.js

XT.extensions.billing.initSalesCategoryListItem = function() {
enyo.kind({
name: "XV.SalesCategoryListItem",
kind: "XV.ListItem",
view: "XM.SalesCategoryView"
}), XV.CashReceiptFormatters = {
formatIsPosted: function(e, t) {
var n = e.get("isPosted");
t.setContent((n ? "_isPosted" : "_isNotPosted").loc()), t.addRemoveClass("isPosted", n);
},
formatFundsType: function(e, t) {
var n = XM.fundsTypes.get(e.get("fundsType"));
t.setContent(n.get("label"));
}
}, enyo.kind(enyo.mixin(XV.CashReceiptFormatters, {
name: "XV.CashReceiptListItem",
kind: "XV.ListItem",
view: "XM.CashReceiptView"
})), enyo.kind(enyo.mixin(XV.CashReceiptFormatters, {
name: "XV.CashReceiptLineListItem",
kind: "XV.ListItem",
view: "XM.CashReceiptView"
})), enyo.kind(enyo.mixin(XV.CashReceiptFormatters, {
name: "XV.CashReceiptLinePendingListItem",
kind: "XV.ListItem",
view: "XM.CashReceiptView"
}));
};

// picker.js

(function() {
XT.extensions.billing.initPickers = function() {
enyo.kind({
name: "XV.ReceivableTypePicker",
kind: "XV.PickerWidget",
collection: "XM.receivableTypes",
showNone: !1
}), enyo.kind({
name: "XV.FundsTypePicker",
kind: "XV.PickerWidget",
collection: "XM.fundsTypes",
nameAttribute: "label",
label: "_fundsType".loc(),
showNone: !1,
published: {
allowCreditCards: !1
},
create: function() {
this.setAllowCreditCards(XT.session.privileges.get("ProcessCreditCards")), this.inherited(arguments);
},
filter: function(e, t) {
var n = this;
return _.filter(e, function(e) {
return n.allowCreditCards || !e.isCreditCard();
});
}
}), enyo.kind({
name: "XV.CashReceiptApplyOptionsPicker",
kind: "XV.PickerWidget",
collection: "XM.cashReceiptApplyOptions",
nameAttribute: "label",
label: "_applyBalanceAs".loc(),
showNone: !1,
create: function() {
this.inherited(arguments), this.setShowing(XT.session.settings.get("EnableCustomerDeposits"));
}
});
};
})();

// parameter.js

(function() {
XT.extensions.billing.initParameters = function() {
enyo.kind({
name: "XV.ReceivableListParameters",
kind: "XV.ParameterWidget",
defaultParameters: function() {
return {
showDebits: !0,
showCredits: !0,
asOfDate: new Date
};
},
components: [ {
kind: "onyx.GroupboxHeader",
content: "_receivable".loc()
}, {
name: "number",
label: "_number".loc(),
attr: "documentNumber",
defaultKind: "XV.NumberWidget"
}, {
name: "asOfDate",
label: "_asOf".loc(),
attr: "closeDate",
defaultKind: "XV.DateWidget",
getParameter: function() {
var e;
return this.getValue() && (e = [ {
attribute: this.getAttr(),
operator: ">=",
value: this.getValue(),
includeNull: !0
}, {
attribute: "documentDate",
operator: "<=",
value: this.getValue(),
includeNull: !0
} ]), e;
}
}, {
kind: "onyx.GroupboxHeader",
content: "_show".loc()
}, {
name: "showUnposted",
label: "_unposted".loc(),
attr: "isPosted",
defaultKind: "XV.CheckboxWidget",
getParameter: function() {
var e;
return this.getValue() || (e = {
attribute: this.getAttr(),
operator: "=",
value: !0
}), e;
}
}, {
name: "showClosed",
label: "_closed".loc(),
attr: "closeDate",
defaultKind: "XV.CheckboxWidget",
getParameter: function() {
var e;
return this.getValue() || (e = {
attribute: this.getAttr(),
operator: "=",
value: null,
includeNull: !0
}), e;
}
}, {
name: "showDebits",
label: "_debits".loc(),
attr: "documentType",
defaultKind: "XV.CheckboxWidget",
getParameter: function() {
var e;
return this.getValue() || (e = {
attribute: this.getAttr(),
operator: "!=",
value: "D"
}), e;
}
}, {
name: "showCredits",
label: "_credits".loc(),
attr: "documentType",
defaultKind: "XV.CheckboxWidget",
getParameter: function() {
var e;
return this.getValue() || (e = {
attribute: this.getAttr(),
operator: "!=",
value: "C"
}), e;
}
}, {
kind: "onyx.GroupboxHeader",
content: "_customer".loc()
}, {
name: "customer",
attr: "customer",
label: "_customer".loc(),
defaultKind: "XV.SalesCustomerWidget"
}, {
name: "customerType",
attr: "customer.customerType",
label: "_customerType".loc(),
defaultKind: "XV.CustomerTypePicker"
}, {
kind: "onyx.GroupboxHeader",
content: "_dueDate".loc()
}, {
name: "fromDate",
label: "_fromDate".loc(),
attr: "dueDate",
operator: ">=",
defaultKind: "XV.DateWidget"
}, {
name: "toDate",
label: "_toDate".loc(),
attr: "dueDate",
operator: "<=",
defaultKind: "XV.DateWidget"
}, {
kind: "onyx.GroupboxHeader",
content: "_documentDate".loc()
}, {
name: "fromDocDate",
label: "_fromDate".loc(),
attr: "documentDate",
operator: ">=",
defaultKind: "XV.DateWidget"
}, {
name: "toDocDate",
label: "_toDate".loc(),
attr: "documentDate",
operator: "<=",
defaultKind: "XV.DateWidget"
} ],
parameterChanged: function(e, t) {
if (e.name === "showClosed" || e.name === "showUnposted") {
var n = this.$.showClosed.getValue() || this.$.showUnposted.getValue();
this.$.asOfDate.$.input.setDisabled(n);
}
}
}), enyo.kind({
name: "XV.CashReceiptListParameters",
kind: "XV.ParameterWidget",
defaultParameters: function() {
return {
showPosted: !0
};
}
});
};
})();

// relation.js

XT.extensions.billing.initRelationWidgets = function() {
enyo.kind({
name: "XV.BankAccountWidget",
kind: "XV.RelationWidget",
collection: "XM.BankAccountRelationCollection",
list: "XV.BankAccountList",
keyAttribute: "name",
nameAttribute: "description"
});
};

// postbooks.js

(function() {
XT.extensions.billing.initPostbooks = function() {
var e = {
name: XT.extensions.billing.name,
label: "_billing".loc(),
panels: [ {
name: "billing_customerList",
kind: "XV.CustomerList"
}, {
name: "invoiceList",
kind: "XV.InvoiceList"
}, {
name: "returnList",
kind: "XV.ReturnList"
}, {
name: "receivableList",
kind: "XV.ReceivableList"
} ]
}, t = [ "ApplyARMemos", "ConfigureAR", "CreateNewCurrency", "DeleteItemMasters", "EditAROpenItem", "MaintainBankAccounts", "MaintainCashReceipts", "MaintainCreditMemos", "MaintainCurrencies", "MaintainCustomerEmailProfiles", "MaintainCustomerMasters", "MaintainCustomerGroups", "MaintainIncidentCategories", "MaintainItemMasters", "MaintainItemGroups", "MaintainMiscInvoices", "MaintainReasonCodes", "MaintainSalesCategories", "MaintainShipVias", "MaintainTerms", "OverrideTax", "PostARDocuments", "PostCashReceipts", "PostMiscInvoices", "PrintCreditMemos", "PrintInvoices", "ViewAROpenItems", "ViewCashReceipts", "ViewCreditMemos", "ViewCustomerMasters", "ViewCustomerGroups", "ViewItemMasters", "ViewMiscInvoices", "ViewSalesCategories", "ViewShipVias", "VoidPostedARCreditMemos", "VoidPostedCashReceipts", "VoidPostedInvoices" ], n = {
model: "XM.billing",
name: "_billing".loc(),
description: "_billingDescription".loc(),
workspace: "XV.BillingWorkspace"
}, r, i = [ {
name: "bankAccountList",
kind: "XV.BankAccountList"
}, {
name: "customerEmailProfileList",
kind: "XV.CustomerEmailProfileList"
}, {
name: "fileList",
kind: "XV.FileList"
}, {
name: "itemList",
kind: "XV.ItemList"
}, {
name: "itemGroupList",
kind: "XV.ItemGroupList"
}, {
name: "reasonCodeList",
kind: "XV.ReasonCodeList"
}, {
name: "salesCategoryList",
kind: "XV.SalesCategoryList"
}, {
name: "termsList",
kind: "XV.TermsList"
} ];
XT.app.$.postbooks.appendPanels("setup", i), XT.extensions.sales && (r = [ {
name: "sales_invoiceList",
kind: "XV.InvoiceList"
} ], XT.app.$.postbooks.appendPanels("sales", r)), XM.configurations.add(new XM.ConfigurationModel(n)), XT.app.$.postbooks.insertModule(e, 0), XT.session.addRelevantPrivileges(XT.extensions.billing.name, t);
};
})();
