// Generated by CoffeeScript 1.6.3
(function() {
  var Data, PostTable, Table, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  Table = require('../table');

  Data = require('../../data');

  PostTable = (function(_super) {
    var POSTSCRIPT_GLYPHS;

    __extends(PostTable, _super);

    function PostTable() {
      _ref = PostTable.__super__.constructor.apply(this, arguments);
      return _ref;
    }

    PostTable.prototype.parse = function(data) {
      var i, length, numberOfGlyphs, _i, _results;
      data.pos = this.offset;
      this.format = data.readInt();
      this.italicAngle = data.readInt();
      this.underlinePosition = data.readShort();
      this.underlineThickness = data.readShort();
      this.isFixedPitch = data.readInt();
      this.minMemType42 = data.readInt();
      this.maxMemType42 = data.readInt();
      this.minMemType1 = data.readInt();
      this.maxMemType1 = data.readInt();
      switch (this.format) {
        case 0x00010000:
          break;
        case 0x00020000:
          numberOfGlyphs = data.readUInt16();
          this.glyphNameIndex = [];
          for (i = _i = 0; 0 <= numberOfGlyphs ? _i < numberOfGlyphs : _i > numberOfGlyphs; i = 0 <= numberOfGlyphs ? ++_i : --_i) {
            this.glyphNameIndex.push(data.readUInt16());
          }
          this.names = [];
          _results = [];
          while (data.pos < this.offset + this.length) {
            length = data.readByte();
            _results.push(this.names.push(data.readString(length)));
          }
          return _results;
          break;
        case 0x00025000:
          numberOfGlyphs = data.readUInt16();
          return this.offsets = data.read(numberOfGlyphs);
        case 0x00030000:
          break;
        case 0x00040000:
          return this.map = (function() {
            var _j, _ref1, _results1;
            _results1 = [];
            for (i = _j = 0, _ref1 = this.file.maxp.numGlyphs; 0 <= _ref1 ? _j < _ref1 : _j > _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
              _results1.push(data.readUInt32());
            }
            return _results1;
          }).call(this);
      }
    };

    PostTable.prototype.glyphFor = function(code) {
      var index;
      switch (this.format) {
        case 0x00010000:
          return POSTSCRIPT_GLYPHS[code] || '.notdef';
        case 0x00020000:
          index = this.glyphNameIndex[code];
          if (index <= 257) {
            return POSTSCRIPT_GLYPHS[index];
          } else {
            return this.names[index - 258] || '.notdef';
          }
          break;
        case 0x00025000:
          return POSTSCRIPT_GLYPHS[code + this.offsets[code]] || '.notdef';
        case 0x00030000:
          return '.notdef';
        case 0x00040000:
          return this.map[code] || 0xFFFF;
      }
    };

    PostTable.prototype.encode = function(mapping) {
      var id, index, indexes, position, post, raw, string, strings, table, _i, _j, _k, _len, _len1, _len2;
      if (!this.exists) {
        return null;
      }
      raw = this.raw();
      if (this.format === 0x00030000) {
        return raw;
      }
      table = new Data(raw.slice(0, 32));
      table.writeUInt32(0x00020000);
      table.pos = 32;
      indexes = [];
      strings = [];
      for (_i = 0, _len = mapping.length; _i < _len; _i++) {
        id = mapping[_i];
        post = this.glyphFor(id);
        position = POSTSCRIPT_GLYPHS.indexOf(post);
        if (position !== -1) {
          indexes.push(position);
        } else {
          indexes.push(257 + strings.length);
          strings.push(post);
        }
      }
      table.writeUInt16(Object.keys(mapping).length);
      for (_j = 0, _len1 = indexes.length; _j < _len1; _j++) {
        index = indexes[_j];
        table.writeUInt16(index);
      }
      for (_k = 0, _len2 = strings.length; _k < _len2; _k++) {
        string = strings[_k];
        table.writeByte(string.length);
        table.writeString(string);
      }
      return table.data;
    };

    POSTSCRIPT_GLYPHS = '.notdef .null nonmarkingreturn space exclam quotedbl numbersign dollar percent\nampersand quotesingle parenleft parenright asterisk plus comma hyphen period slash\nzero one two three four five six seven eight nine colon semicolon less equal greater\nquestion at A B C D E F G H I J K L M N O P Q R S T U V W X Y Z\nbracketleft backslash bracketright asciicircum underscore grave\na b c d e f g h i j k l m n o p q r s t u v w x y z\nbraceleft bar braceright asciitilde Adieresis Aring Ccedilla Eacute Ntilde Odieresis\nUdieresis aacute agrave acircumflex adieresis atilde aring ccedilla eacute egrave\necircumflex edieresis iacute igrave icircumflex idieresis ntilde oacute ograve\nocircumflex odieresis otilde uacute ugrave ucircumflex udieresis dagger degree cent\nsterling section bullet paragraph germandbls registered copyright trademark acute\ndieresis notequal AE Oslash infinity plusminus lessequal greaterequal yen mu\npartialdiff summation product pi integral ordfeminine ordmasculine Omega ae oslash\nquestiondown exclamdown logicalnot radical florin approxequal Delta guillemotleft\nguillemotright ellipsis nonbreakingspace Agrave Atilde Otilde OE oe endash emdash\nquotedblleft quotedblright quoteleft quoteright divide lozenge ydieresis Ydieresis\nfraction currency guilsinglleft guilsinglright fi fl daggerdbl periodcentered\nquotesinglbase quotedblbase perthousand Acircumflex Ecircumflex Aacute Edieresis\nEgrave Iacute Icircumflex Idieresis Igrave Oacute Ocircumflex apple Ograve Uacute\nUcircumflex Ugrave dotlessi circumflex tilde macron breve dotaccent ring cedilla\nhungarumlaut ogonek caron Lslash lslash Scaron scaron Zcaron zcaron brokenbar Eth\neth Yacute yacute Thorn thorn minus multiply onesuperior twosuperior threesuperior\nonehalf onequarter threequarters franc Gbreve gbreve Idotaccent Scedilla scedilla\nCacute cacute Ccaron ccaron dcroat'.split(/\s+/g);

    return PostTable;

  })(Table);

  module.exports = PostTable;

}).call(this);
