
// core.js

(function() {
"use strict";
XT.extensions.project = {
setVersion: function() {
XT.setVersion("", "project");
}
};
})();

// account.js

(function() {
"use strict";
XT.extensions.project.initListAccountModels = function() {
XM.AccountProject = XM.Model.extend({
recordType: "XM.AccountProject",
isDocumentAssignment: !0
});
};
})();

// characteristic.js

(function() {
"use strict";
XT.extensions.project.initCharacteristicModels = function() {
var e = XM.Characteristic.prototype.contextAttributes;
e.push("isProjects"), e.push("isTasks");
};
})();

// configure.js

(function() {
"use strict";
XT.extensions.project.initSettings = function() {
XM.ProjectManagement = XM.Settings.extend({
recordType: "XM.ProjectManagement",
privileges: !0,
handlers: {
"change:UseProjects": "useProjectsChanged"
},
useProjectsChanged: function() {
var e = this.get("UseProjects");
e || this.set("RequireProjectAssignment", !1);
}
}), XM.projectManagement = new XM.ProjectManagement;
};
})();

// contact.js

(function() {
"use strict";
XT.extensions.project.initContactModels = function() {
XM.ContactProject = XM.Model.extend({
recordType: "XM.ContactProject",
isDocumentAssignment: !0
});
};
})();

// customer.js

(function() {
"use strict";
XT.extensions.project.initCustomerModels = function() {
XM.CustomerProject = XM.Model.extend({
recordType: "XM.CustomerProject",
isDocumentAssignment: !0
});
};
})();

// incident.js

(function() {
"use strict";
XT.extensions.project.initIncidentModels = function() {
XM.IncidentProject = XM.Model.extend({
recordType: "XM.IncidentProject",
isDocumentAssignment: !0
});
};
})();

// invoice.js

(function() {
"use strict";
XT.extensions.project.initInvoiceModels = function() {
XM.InvoiceProject = XM.Model.extend({
recordType: "XM.InvoiceProject",
isDocumentAssignment: !0
});
var e = XM.Invoice.prototype.applyIsPostedRules;
XM.Invoice = XM.Invoice.extend({
applyIsPostedRules: function() {
e.apply(this, arguments), this.setReadOnly("project", this.get("isPosted"));
}
});
};
})();

// opportunity.js

(function() {
"use strict";
XT.extensions.project.initOpportunityModels = function() {
XM.OpportunityProject = XM.Model.extend({
recordType: "XM.OpportunityProject",
isDocumentAssignment: !0
});
};
})();

// project.js

(function() {
"use strict";
XT.extensions.project.initProjectModels = function() {
XM.ProjectEmailProfile = XM.Document.extend({
recordType: "XM.ProjectEmailProfile",
documentKey: "name"
}), XM.ProjectBase = XM.Document.extend({
defaults: function() {
var e = XM.Project, t = {
status: e.CONCEPT,
priority: XT.session.settings.get("DefaultPriority"),
percentComplete: 0
};
return t;
},
bindEvents: function() {
XM.Document.prototype.bindEvents.apply(this, arguments), this.on("change:status", this.projectStatusDidChange), this.on("change:percentComplete", this.percentCompleteDidChange), this.statusDidChange();
},
statusDidChange: function() {
var e = XM.Model, t = this.getStatus() !== e.READY_NEW;
this.setReadOnly("number", t);
},
percentCompleteDidChange: function() {
var e = this.get("percentComplete");
e >= 1 && this.set("status", XM.Project.COMPLETED);
},
projectStatusDidChange: function() {
var e = this.get("status"), t = new Date, n = XM.Project;
e === n.IN_PROCESS && !this.get("assignDate") ? this.set("assignDate", t) : e === n.COMPLETED && (this.get("completeDate") || this.set("completeDate", t), this.off("change:percentComplete", this.percentCompleteDidChange), this.set("percentComplete", 1), this.on("change:percentComplete", this.percentCompleteDidChange));
}
}), XM.ProjectBase = XM.ProjectBase.extend(XM.ProjectStatus), XM.Project = XM.ProjectBase.extend({
recordType: "XM.Project",
defaults: function() {
var e = XM.ProjectBase.prototype.defaults.call(this);
return e.owner = e.assignedTo = XM.currentUser, _.extend(e, {
assignedTo: XM.currentUser,
owner: XM.currentUser,
budgetedHoursTotal: 0,
actualHoursTotal: 0,
balanceHoursTotal: 0,
budgetedExpensesTotal: 0,
actualExpensesTotal: 0,
balanceExpensesTotal: 0
});
},
readOnlyAttributes: [ "actualExpensesTotal", "actualHoursTotal", "balanceExpensesTotal", "balanceHoursTotal", "budgetedExpensesTotal", "budgetedHoursTotal" ],
bindEvents: function() {
XM.ProjectBase.prototype.bindEvents.apply(this, arguments), this.on("add:tasks remove:tasks", this.tasksDidChange), this.on("change:projectType", this.projectTypeDidChange);
},
copy: function(e) {
return XM.Project.copy(this, e);
},
projectTypeDidChange: function() {
this.inheritWorkflowSource(this.get("projectType"), "XM.ProjectCharacteristic", "XM.ProjectWorkflow");
},
tasksDidChange: function() {
var e = this, t, n = 0, r = 0, i = 0, s = 0, o, u;
_.each(this.get("tasks").models, function(e) {
n = XT.math.add(n, e.get("budgetedHours"), XT.QTY_SCALE), r = XT.math.add(r, e.get("actualHours"), XT.QTY_SCALE), i = XT.math.add(i, e.get("budgetedExpenses"), XT.MONEY_SCALE), s = XT.math.add(s, e.get("actualExpenses"), XT.MONEY_SCALE);
}), o = XT.math.subtract(n, r, XT.QTY_SCALE), u = XT.math.subtract(i, s, XT.QTY_SCALE), this.set({
budgetedHoursTotal: n,
actualHoursTotal: r,
budgetedExpensesTotal: i,
actualExpensesTotal: s,
balanceHoursTotal: o,
balanceExpensesTotal: u
});
}
}), XM.Project = XM.Project.extend(XM.EmailSendMixin), XM.Project = XM.Project.extend({
emailDocumentName: "_project".loc(),
emailProfileAttribute: "projectType.emailProfile",
emailStatusMethod: "getProjectStatusString",
buildToString: function(e) {
var t = this.get("tasks"), n = XM.EmailSendMixin, r = this;
return _.each(t.models, function(t) {
t.isDirty() && (e = n.buildToString.call(t, e));
}), n.buildToString.call(this, e);
}
}), _.extend(XM.Project.prototype, XM.WorkflowMixin), _.extend(XM.Project, XM.ProjectStatusMixin, {
copy: function(e, t) {
var n = t.number, r = t.offset;
if (e instanceof XM.Project == 0) return console.log("Passed object must be an instance of 'XM.Project'"), !1;
if (n === undefined) return console.log("Number is required"), !1;
var i, s, o, u = new Date(e.get("dueDate").valueOf()), a = XM.Project.prototype.idAttribute, f;
r = r || 0, u.setDate(u.getDate() + r), i = e.parse(JSON.parse(JSON.stringify(e.toJSON()))), _.extend(i, {
number: n,
dueDate: u
}), delete i[a], delete i.status, delete i.comments, delete i.recurrences, a = XM.ProjectTask.prototype.idAttribute, i.tasks && _.each(i.tasks, function(e) {
delete e[a], delete e.status, delete e.comments, delete e.alarms, u = new Date(e.dueDate.valueOf()), u.setDate(u.getDate() + r);
});
for (s in i) if (i.hasOwnProperty(s) && s !== "tasks" && _.isArray(i[s])) {
a = e.get(s).model.prototype.idAttribute;
for (o = 0; o < i[s].length; o += 1) delete i[s][o][a];
}
return f = new XM.Project(i, {
isNew: !0
}), f.documentKeyDidChange(), f;
}
}), XM.ProjectRelation.prototype.editableModel = "XM.Project", XM.ProjectTask = XM.ProjectBase.extend({
recordType: "XM.ProjectTask",
enforceUpperKey: !1,
defaults: function() {
var e = XM.ProjectBase.prototype.defaults.call(this);
return _.extend(e, {
actualExpenses: 0,
actualHours: 0,
budgetedExpenses: 0,
budgetedHours: 0
}), e;
},
bindEvents: function() {
XM.ProjectBase.prototype.bindEvents.apply(this, arguments);
var e = "change:budgetedHours change:actualHours change:budgetedExpenses change:actualExpenses";
this.on(e, this.valuesDidChange), this.on("change:project", this.projectDidChange);
},
getProjectTaskStatusString: function() {
return XM.ProjectStatus.getProjectStatusString.call(this);
},
projectDidChange: function() {
var e = this.get("project"), t = XM.Model, n = this.getStatus();
e && n === t.READY_NEW && (this.set("owner", this.get("owner") || e.get("owner")), this.set("assignedTo", this.get("owner") || e.get("assignedTo")), this.set("startDate", this.get("startDate") || e.get("startDate")), this.set("assignDate", this.get("assignDate") || e.get("assignDate")), this.set("dueDate", this.get("dueDate") || e.get("dueDate")), this.set("completeDate", this.get("completeDate") || e.get("completeDate")));
},
valuesDidChange: function() {
var e = this.get("project");
e && e.tasksDidChange && e.tasksDidChange();
}
}), XM.ProjectComment = XM.Comment.extend({
recordType: "XM.ProjectComment",
sourceName: "J"
}), XM.ProjectAccount = XM.Model.extend({
recordType: "XM.ProjectAccount",
isDocumentAssignment: !0
}), XM.ProjectContact = XM.Model.extend({
recordType: "XM.ProjectContact",
isDocumentAssignment: !0
}), XM.ProjectItem = XM.Model.extend({
recordType: "XM.ProjectItem",
isDocumentAssignment: !0
}), XM.ProjectFile = XM.Model.extend({
recordType: "XM.ProjectFile",
isDocumentAssignment: !0
}), XM.ProjectUrl = XM.Model.extend({
recordType: "XM.ProjectUrl"
}), XM.ProjectProject = XM.Model.extend({
recordType: "XM.ProjectProject",
isDocumentAssignment: !0
}), XM.ProjectCustomer = XM.Model.extend({
recordType: "XM.ProjectCustomer",
isDocumentAssignment: !0
}), XM.ProjectRecurrence = XM.Model.extend({
recordType: "XM.ProjectRecurrence"
}), XM.ProjectTaskComment = XM.Comment.extend({
recordType: "XM.ProjectTaskComment",
sourceName: "TA"
}), XM.ProjectTaskAlarm = XM.Alarm.extend({
recordType: "XM.ProjectTaskAlarm"
}), XM.ProjectTaskRelation = XM.Info.extend({
recordType: "XM.ProjectTaskRelation",
editableModel: "XM.ProjectTask"
}), XM.TaskRelation = XM.Info.extend({
recordType: "XM.TaskRelation",
editableModel: "XM.Task"
}), XM.TaskProjectRelation = XM.Info.extend({
recordType: "XM.TaskProjectRelation"
}), XM.ProjectWorkflow = XM.Workflow.extend({
recordType: "XM.ProjectWorkflow",
getProjectWorkflowStatusString: function() {
return XM.ProjectWorkflow.prototype.getWorkflowStatusString.call(this);
}
}), XM.ProjectWorkflowRelation = XM.Info.extend({
recordType: "XM.ProjectWorkflowRelation",
editableModel: "XM.ProjectWorkflow"
}), XM.ProjectIncident = XM.Model.extend({
recordType: "XM.ProjectIncident",
isDocumentAssignment: !0
}), XM.ProjectOpportunity = XM.Model.extend({
recordType: "XM.ProjectOpportunity",
isDocumentAssignment: !0
}), XM.ProjectToDo = XM.Model.extend({
recordType: "XM.ProjectToDo",
isDocumentAssignment: !0
}), XM.ProjectCharacteristic = XM.CharacteristicAssignment.extend({
recordType: "XM.ProjectCharacteristic",
which: "isProjects"
}), XM.ProjectTaskCharacteristic = XM.CharacteristicAssignment.extend({
recordType: "XM.ProjectTaskCharacteristic",
which: "isTasks"
}), XM.TaskCharacteristic = XM.CharacteristicAssignment.extend({
recordType: "XM.TaskCharacteristic",
which: "isTasks"
}), XM.Resource = XM.Model.extend({
recordType: "XM.Resource"
}), XM.TaskResource = XM.Document.extend({
recordType: "XM.TaskResource",
idAttribute: "uuid",
documentKey: "uuid",
defaults: {
percent: 1
}
}), XM.TaskResourceAnalysis = XM.Model.extend({
recordType: "XM.TaskResourceAnalysis",
idAttribute: "id"
}), XM.ProjectEmailProfileCollection = XM.Collection.extend({
model: XM.ProjectEmailProfile
}), XM.ResourceCollection = XM.Collection.extend({
model: XM.Resource
}), XM.TaskResourceCollection = XM.Collection.extend({
model: XM.TaskResource
}), XM.TaskResourceAnalysisCollection = XM.Collection.extend({
model: XM.TaskResourceAnalysis
}), XM.TaskListItemCollection = XM.Collection.extend({
model: XM.TaskListItem
});
};
})();

// quote.js

(function() {
"use strict";
XT.extensions.project.quoteModels = function() {
XM.QuoteProject = XM.Model.extend({
recordType: "XM.QuoteProject",
isDocumentAssignment: !0
});
};
})();

// sales_order.js

(function() {
"use strict";
XT.extensions.project.salesOrderModels = function() {
XM.SalesOrderProject = XM.Model.extend({
recordType: "XM.SalesOrderProject",
isDocumentAssignment: !0
});
};
})();

// to_do.js

(function() {
"use strict";
XT.extensions.project.toDoModels = function() {
XM.ToDoProject = XM.Model.extend({
recordType: "XM.ToDoProject",
isDocumentAssignment: !0
});
};
})();

// startup.js

(function() {
"use strict";
XT.extensions.project.initStartup = function() {
XT.cacheCollection("XM.projectEmailProfiles", "XM.ProjectEmailProfileCollection", "name"), XT.cacheCollection("XM.resources", "XM.ResourceCollection", "code");
};
})();

// characteristics.js

(function() {
XT.extensions.project.initCharacteristicWidgets = function() {
enyo.kind({
name: "XV.ProjectCharacteristicsWidget",
kind: "XV.CharacteristicsWidget",
model: "XM.ProjectCharacteristic",
which: "isProjects"
}), enyo.kind({
name: "XV.ProjectTypeCharacteristicsWidget",
kind: "XV.CharacteristicsWidget",
model: "XM.ProjectTypeCharacteristic",
which: "isProjects"
}), enyo.kind({
name: "XV.TaskCharacteristicsWidget",
kind: "XV.CharacteristicsWidget",
model: "XM.ProjectTaskCharacteristic",
which: "isTasks"
});
};
})();

// chart.js

(function() {
enyo.kind({
name: "XV.ResourceBudgetedHoursBarChart",
kind: "XV.DrilldownBarChart",
collection: "XM.TaskResourceAnalysisCollection",
chartTitle: "_resource".loc() + " " + "_budgetedHours".loc(),
groupByOptions: [ {
name: "name"
} ],
totalField: "budgetedHours"
}), enyo.kind({
name: "XV.ResourceActualHoursBarChart",
kind: "XV.DrilldownBarChart",
collection: "XM.TaskResourceAnalysisCollection",
chartTitle: "_resource".loc() + " " + "_actualHours".loc(),
groupByOptions: [ {
name: "name"
} ],
totalField: "actualHours"
}), enyo.kind({
name: "XV.ResourceBalanceHoursBarChart",
kind: "XV.DrilldownBarChart",
collection: "XM.TaskResourceAnalysisCollection",
chartTitle: "_resource".loc() + " " + "_balanceHours".loc(),
groupByOptions: [ {
name: "name"
} ],
totalField: "balanceHours"
}), enyo.kind({
name: "XV.ProjectBudgetedHoursBarChart",
kind: "XV.DrilldownBarChart",
collection: "XM.ProjectListItemCollection",
chartTitle: "_project".loc() + " " + "_budgeted".loc() + " " + "_hours".loc(),
groupByOptions: [ {
name: "status",
content: "_status".loc()
}, {
name: "account",
content: "_account".loc()
}, {
name: "owner"
}, {
name: "assignedTo"
} ],
totalField: "budgetedHours"
}), enyo.kind({
name: "XV.ProjectActualHoursBarChart",
kind: "XV.DrilldownBarChart",
collection: "XM.ProjectListItemCollection",
chartTitle: "_project".loc() + " " + "_actual".loc() + " " + "_hours".loc(),
groupByOptions: [ {
name: "status",
content: "_status".loc()
}, {
name: "account",
content: "_account".loc()
}, {
name: "owner"
}, {
name: "assignedTo"
} ],
totalField: "actualHours"
}), enyo.kind({
name: "XV.ProjectBudgetedExpensesBarChart",
kind: "XV.DrilldownBarChart",
collection: "XM.ProjectListItemCollection",
chartTitle: "_project".loc() + " " + "_budgeted".loc() + " " + "_expenses".loc(),
groupByOptions: [ {
name: "status",
content: "_status".loc()
}, {
name: "account",
content: "_account".loc()
}, {
name: "owner"
}, {
name: "assignedTo"
} ],
totalField: "budgetedExpenses"
}), enyo.kind({
name: "XV.ProjectActualExpensesBarChart",
kind: "XV.DrilldownBarChart",
collection: "XM.ProjectListItemCollection",
chartTitle: "_project".loc() + " " + "_actual".loc() + " " + "_expenses".loc(),
groupByOptions: [ {
name: "status",
content: "_status".loc()
}, {
name: "account",
content: "_account".loc()
}, {
name: "owner"
}, {
name: "assignedTo"
} ],
totalField: "actualExpenses"
}), enyo.kind({
name: "XV.ProjectBarChart",
kind: "XV.DrilldownBarChart",
collection: "XM.ProjectListItemCollection",
chartTitle: "_projects".loc(),
groupByOptions: [ {
name: "status"
}, {
name: "account"
}, {
name: "owner"
}, {
name: "assignedTo"
} ]
}), enyo.kind({
name: "XV.TaskBarChart",
kind: "XV.DrilldownBarChart",
collection: "XM.TaskListItemCollection",
chartTitle: "_tasks".loc(),
groupByOptions: [ {
name: "status"
}, {
name: "project"
}, {
name: "owner"
}, {
name: "assignedTo"
} ]
}), enyo.kind({
name: "XV.TaskBudgetedHoursTimeSeriesChart",
kind: "XV.TimeSeriesChart",
collection: "XM.TaskListItemCollection",
chartTitle: "_task".loc() + " " + "_budgetedHours".loc() + " " + "_dueDate".loc(),
groupByOptions: [ {
name: "status"
}, {
name: "project"
}, {
name: "owner"
}, {
name: "assignedTo"
} ],
dateField: "dueDate",
totalField: "budgetedHours"
}), enyo.kind({
name: "XV.TaskActualHoursTimeSeriesChart",
kind: "XV.TimeSeriesChart",
collection: "XM.TaskListItemCollection",
chartTitle: "_task".loc() + " " + "_actualHours".loc() + " " + "_dueDate".loc(),
groupByOptions: [ {
name: "status"
}, {
name: "project"
}, {
name: "owner"
}, {
name: "assignedTo"
} ],
dateField: "dueDate",
totalField: "actualHours"
}), enyo.kind({
name: "XV.TaskBudgetedExpensesTimeSeriesChart",
kind: "XV.TimeSeriesChart",
collection: "XM.TaskListItemCollection",
chartTitle: "_task".loc() + " " + "_budgetedExpenses".loc() + " " + "_dueDate".loc(),
groupByOptions: [ {
name: "status"
}, {
name: "project"
}, {
name: "owner"
}, {
name: "assignedTo"
} ],
dateField: "dueDate",
totalField: "budgetedExpenses"
}), enyo.kind({
name: "XV.TaskActualExpensesTimeSeriesChart",
kind: "XV.TimeSeriesChart",
collection: "XM.TaskListItemCollection",
chartTitle: "_task".loc() + " " + "_actualExpenses".loc() + " " + "_dueDate".loc(),
groupByOptions: [ {
name: "status"
}, {
name: "project"
}, {
name: "owner"
}, {
name: "assignedTo"
} ],
dateField: "dueDate",
totalField: "actualExpenses"
});
})();

// dependencies.js

(function() {
XT.extensions.project.initDependenciesWidgets = function() {
enyo.kind({
name: "XV.ProjectWorkflowSuccessorsWidget",
kind: "XV.DependenciesWidget",
model: "XM.ProjectWorkflowSuccessor"
});
};
})();

// parameter.js

(function() {
XT.extensions.project.initParameters = function() {
var e;
XV.ActivityListParameters.prototype.activityTypes.project = [ {
type: "Project"
}, {
type: "ProjectTask",
label: "_tasks".loc()
}, {
type: "ProjectWorkflow",
label: "_workflow".loc()
} ], e = [ {
kind: "onyx.GroupboxHeader",
content: "_project".loc()
}, {
name: "project",
label: "_project".loc(),
attr: "project",
defaultKind: "XV.ProjectWidget"
} ], XV.appendExtension("XV.IncidentListParameters", e), enyo.kind({
name: "XV.ProjectTaskListParameters",
kind: "XV.ParameterWidget",
characteristicsRole: "isTasks",
defaultParameters: function() {
return {
user: XM.currentUser
};
},
components: [ {
kind: "onyx.GroupboxHeader",
content: "_project".loc()
}, {
name: "showCompleted",
label: "_showCompleted".loc(),
attr: "status",
defaultKind: "XV.CheckboxWidget",
getParameter: function() {
var e;
return this.getValue() || (e = {
attribute: this.getAttr(),
operator: "!=",
value: "C"
}), e;
}
}, {
name: "project",
label: "_project".loc(),
attr: "project",
defaultKind: "XV.ProjectWidget"
}, {
name: "number",
label: "_number".loc(),
attr: "number"
}, {
name: "name",
label: "_name".loc(),
attr: "name"
}, {
kind: "onyx.GroupboxHeader",
content: "_status".loc()
}, {
name: "status",
label: "_status".loc(),
attr: "status",
defaultKind: "XV.ProjectStatusPicker"
}, {
kind: "onyx.GroupboxHeader",
content: "_userAccounts".loc()
}, {
name: "owner",
label: "_owner".loc(),
attr: "owner",
defaultKind: "XV.UserAccountWidget"
}, {
name: "assignedTo",
label: "_assignedTo".loc(),
attr: "assignedTo",
defaultKind: "XV.UserAccountWidget"
}, {
name: "user",
label: "_user".loc(),
attr: [ "owner.username", "assignedTo.username" ],
defaultKind: "XV.UserAccountWidget"
}, {
kind: "onyx.GroupboxHeader",
content: "_dueDate".loc()
}, {
name: "fromDueDate",
label: "_fromDate".loc(),
attr: "dueDate",
operator: ">=",
filterLabel: "_from".loc() + " " + "_dueDate".loc() + " " + "_date".loc(),
defaultKind: "XV.DateWidget"
}, {
name: "toDueDate",
label: "_toDate".loc(),
attr: "dueDate",
operator: "<=",
filterLabel: "_to".loc() + " " + "_dueDate".loc() + " " + "_date".loc(),
defaultKind: "XV.DateWidget"
} ]
});
};
})();

// picker.js

(function() {
XT.extensions.project.initPickers = function() {
enyo.kind({
name: "XV.ProjectEmailProfilePicker",
kind: "XV.PickerWidget",
label: "_emailProfile".loc(),
collection: "XM.projectEmailProfiles"
}), enyo.kind({
name: "XV.ResourcePicker",
kind: "XV.PickerWidget",
collection: "XM.resources",
showNone: !1,
nameAttribute: "code"
});
};
})();

// relation.js

(function() {
XT.extensions.project.initRelationWidgets = function() {
enyo.kind({
name: "XV.ResourceWidget",
kind: "XV.RelationWidget",
collection: "XM.ResourceCollection",
nameAttribute: "code",
descriptionAttribute: "name"
});
};
})();

// documents_box.js

(function() {
XT.extensions.project.initDocumentsBox = function() {};
})();

// grid_box.js

(function() {
XT.extensions.project.initGridBox = function() {
enyo.kind({
name: "XV.ProjectSummaryPanel",
classes: "xv-sales-summary-panel",
kind: "XV.RelationsEditor",
style: "margin-top: 10px;",
components: [ {
kind: "XV.Groupbox",
name: "totalGroup",
classes: "xv-sales-summary-total-group",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_summary".loc()
}, {
kind: "FittableColumns",
name: "totalBox",
classes: "xv-totals-panel",
components: [ {
kind: "FittableRows",
name: "summaryColumnOne",
components: [ {
content: "_hours".loc(),
style: "text-align: right; padding-right: 10px;"
}, {
kind: "XV.NumberWidget",
attr: "budgetedHoursTotal",
label: "_budgeted".loc(),
scale: XT.HOURS_SCALE
}, {
kind: "XV.NumberWidget",
attr: "actualHoursTotal",
label: "_actual".loc(),
scale: XT.HOURS_SCALE
}, {
kind: "XV.NumberWidget",
attr: "balanceHoursTotal",
label: "_balance".loc(),
scale: XT.HOURS_SCALE
} ]
}, {
kind: "FittableRows",
name: "summaryColumnTwo",
components: [ {
content: "_expenses".loc(),
style: "text-align: right; padding-right: 10px;"
}, {
kind: "XV.NumberWidget",
attr: "budgetedExpensesTotal",
label: "_budgeted".loc(),
scale: XT.MONEY_SCALE,
showLabel: !0
}, {
kind: "XV.NumberWidget",
attr: "actualExpensesTotal",
label: "_actual".loc(),
scale: XT.MONEY_SCALE,
showLabel: !0
}, {
kind: "XV.NumberWidget",
attr: "balanceExpensesTotal",
label: "_balance".loc(),
scale: XT.MONEY_SCALE,
showLabel: !0
} ]
} ]
} ]
} ]
}), enyo.kind({
name: "XV.ProjectTasksGridBox",
kind: "XV.GridBox",
classes: "large-panel",
workspace: "XV.ProjectTaskWorkspace",
parentKey: "project",
orderBy: [ {
attribute: "number"
} ],
title: "_tasks".loc(),
summary: "XV.ProjectSummaryPanel",
columns: [ {
classes: "grid-item",
header: [ "_number".loc(), "_description".loc() ],
rows: [ {
readOnlyAttr: "number",
editor: {
kind: "XV.InputWidget",
attr: "number",
placeholder: "_number".loc()
}
}, {
readOnlyAttr: "name",
editor: {
kind: "XV.InputWidget",
attr: "name",
placeholder: "_name".loc()
}
}, {
readOnlyAttr: "getProjectStatusString",
editor: {
kind: "XV.ProjectStatusPicker",
attr: "status"
}
} ]
}, {
classes: "user",
header: [ "_owner".loc(), "_assignedTo".loc() ],
rows: [ {
readOnlyAttr: "owner.username",
editor: {
kind: "XV.UserAccountWidget",
attr: "owner"
}
}, {
readOnlyAttr: "assignedTo.username",
editor: {
kind: "XV.UserAccountWidget",
attr: "assignedTo"
}
} ]
}, {
classes: "quantity",
header: [ "_budgetedHrs".loc(), "_actualHrs".loc() ],
rows: [ {
readOnlyAttr: "budgetedHours",
editor: {
kind: "XV.HoursWidget",
attr: "budgetedHours"
}
}, {
readOnlyAttr: "actualHours",
editor: {
kind: "XV.HoursWidget",
attr: "actualHours"
}
} ]
}, {
classes: "price",
header: [ "_budgeted$".loc(), "_actual$".loc() ],
rows: [ {
readOnlyAttr: "budgetedExpenses",
editor: {
kind: "XV.MoneyWidget",
attr: {
localValue: "budgetedExpenses",
currency: ""
},
currencyDisabled: !0,
currencyShowing: !1
}
}, {
readOnlyAttr: "actualExpenses",
editor: {
kind: "XV.MoneyWidget",
attr: {
localValue: "actualExpenses",
currency: ""
},
currencyDisabled: !0,
currencyShowing: !1
}
} ]
}, {
classes: "date",
header: [ "_start".loc(), "_due".loc() ],
rows: [ {
readOnlyAttr: "startDate",
placeholder: "_noStartDate".loc(),
editor: {
kind: "XV.DateWidget",
attr: "startDate"
}
}, {
readOnlyAttr: "dueDate",
editor: {
kind: "XV.DateWidget",
attr: "dueDate"
}
} ]
}, {
classes: "date",
header: [ "_assigned".loc(), "_completed".loc() ],
rows: [ {
readOnlyAttr: "assignDate",
placeholder: "_noAssignDate".loc(),
editor: {
kind: "XV.DateWidget",
attr: "assignDate"
}
}, {
readOnlyAttr: "completeDate",
placeholder: "_noCompleteDate".loc(),
editor: {
kind: "XV.DateWidget",
attr: "completeDate"
}
}, {
readOnlyAttr: "percentComplete",
editor: {
kind: "XV.PercentWidget",
attr: "percentComplete"
}
} ]
} ]
}), enyo.kind({
name: "XV.ProjectWorkflowGridBox",
kind: "XV.WorkflowGridBox",
workspace: "XV.ProjectWorkflowWorkspace"
});
};
})();

// list.js

(function() {
XT.extensions.project.initLists = function() {
enyo.kind({
name: "XV.ProjectEmailProfileList",
kind: "XV.EmailProfileList",
label: "_projectEmailProfiles".loc(),
collection: "XM.ProjectEmailProfileCollection"
}), enyo.kind({
name: "XV.ProjectTypeList",
kind: "XV.List",
label: "_projectTypes".loc(),
collection: "XM.ProjectTypeCollection",
query: {
orderBy: [ {
attribute: "code"
} ]
},
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListColumn",
classes: "short",
components: [ {
kind: "XV.ListAttr",
attr: "code",
isKey: !0
} ]
}, {
kind: "XV.ListColumn",
classes: "last",
fit: !0,
components: [ {
kind: "XV.ListAttr",
attr: "description"
} ]
} ]
} ]
} ]
});
};
})();

// list_relations.js

(function() {
XT.extensions.project.initListRelations = function() {
enyo.kind({
name: "XV.AccountProjectListRelations",
kind: "XV.ListRelations",
orderBy: [ {
attribute: "dueDate",
descending: !0
}, {
attribute: "number"
} ],
parentKey: "account",
workspace: "XV.ProjectWorkspace",
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListColumn",
classes: "first",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListAttr",
attr: "number",
classes: "bold"
}, {
kind: "XV.ListAttr",
attr: "getProjectStatusString",
fit: !0
}, {
kind: "XV.ListAttr",
attr: "dueDate",
formatter: "formatDueDate",
placeholder: "_noCloseTarget".loc(),
classes: "right"
} ]
}, {
kind: "XV.ListAttr",
attr: "name"
} ]
} ]
} ]
} ],
formatDueDate: XV.ProjectList.prototype.formatDueDate
}), enyo.kind({
name: "XV.ContactProjectListRelations",
kind: "XV.AccountProjectListRelations",
parentKey: "contact"
}), enyo.kind({
name: "XV.ProjectTaskListRelations",
kind: "XV.ListRelations",
orderBy: [ {
attribute: "number"
} ],
parentKey: "project",
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListColumn",
classes: "first",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListAttr",
attr: "number",
classes: "bold"
}, {
kind: "XV.ListAttr",
attr: "dueDate",
fit: !0,
formatter: "formatDueDate",
classes: "right"
} ]
}, {
kind: "XV.ListAttr",
attr: "name"
} ]
}, {
kind: "XV.ListColumn",
classes: "third",
components: [ {
kind: "XV.ListAttr",
attr: "getProjectStatusString"
}, {
kind: "XV.ListAttr",
attr: "owner.username"
} ]
}, {
kind: "XV.ListColumn",
style: "width: 80;",
components: [ {
content: "_budgeted".loc() + ":",
classes: "xv-list-attr",
style: "text-align: right;"
}, {
content: "_actual".loc() + ":",
classes: "xv-list-attr",
style: "text-align: right;"
}, {
content: "_balance".loc() + ":",
classes: "xv-list-attr",
style: "text-align: right;"
} ]
}, {
kind: "XV.ListColumn",
classes: "money",
components: [ {
kind: "XV.ListAttr",
attr: "budgetedExpenses",
classes: "text-align-right",
formatter: "formatExpenses"
}, {
kind: "XV.ListAttr",
attr: "actualExpenses",
classes: "text-align-right",
formatter: "formatExpenses"
}, {
kind: "XV.ListAttr",
attr: "balanceExpenses",
classes: "text-align-right",
formatter: "formatBalanceExpenses"
} ]
}, {
kind: "XV.ListColumn",
classes: "money",
fit: !0,
components: [ {
kind: "XV.ListAttr",
attr: "budgetedHours",
classes: "text-align-right",
formatter: "formatHours"
}, {
kind: "XV.ListAttr",
attr: "actualHours",
classes: "text-align-right",
formatter: "formatHours"
}, {
kind: "XV.ListAttr",
attr: "balanceHours",
classes: "text-align-right",
formatter: "formatBalanceHours"
} ]
} ]
} ]
} ],
formatBalanceExpenses: function(e, t, n) {
var r = n.get("actualExpenses"), i = n.get("budgetedExpenses");
return this.formatExpenses(i - r, t);
},
formatBalanceHours: function(e, t, n) {
var r = n.get("actualHours"), i = n.get("budgetedHours");
return this.formatHours(i - r, t);
},
formatDueDate: XV.ProjectList.prototype.formatDueDate,
formatHours: XV.ProjectList.prototype.formatHours,
formatExpenses: XV.ProjectList.prototype.formatExpenses
}), enyo.kind({
name: "XV.ProjectWorkflowListRelations",
kind: "XV.WorkflowListRelations",
parentKey: "project"
}), enyo.kind({
name: "XV.ProjectTypeWorkflowListRelations",
kind: "XV.WorkflowListRelations",
parentKey: "project"
}), enyo.kind({
name: "XV.TaskResourceListRelations",
kind: "XV.ListRelations",
orderBy: [ {
attribute: "percent"
} ],
parentKey: "task",
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListColumn",
classes: "first",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListAttr",
attr: "resource.code",
classes: "bold"
}, {
kind: "XV.ListAttr",
attr: "percent",
fit: !0,
formatter: "formatPercent",
classes: "right"
} ]
}, {
kind: "XV.ListAttr",
attr: "resource.name"
} ]
} ]
} ]
} ],
formatPercent: function(e) {
return Globalize.format(e, "p" + XT.locale.percentScale);
}
});
};
})();

// list_relations_box.js

(function() {
XT.extensions.project.initListRelationsBox = function() {
enyo.kind({
name: "XV.AccountProjectsBox",
kind: "XV.ListRelationsBox",
title: "_projects".loc(),
parentKey: "account",
listRelations: "XV.AccountProjectListRelations",
searchList: "XV.ProjectList"
}), enyo.kind({
name: "XV.ContactProjectsBox",
kind: "XV.ListRelationsBox",
title: "_projects".loc(),
parentKey: "contact",
listRelations: "XV.ContactProjectListRelations",
searchList: "XV.ProjectList"
});
};
})();

// list_relations_editor_box.js

(function() {
XT.extensions.project.initListRelationsEditorBoxes = function() {
var e;
enyo.kind({
name: "XV.ProjectTaskEditor",
kind: "XV.RelationsEditor",
components: [ {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.InputWidget",
attr: "number"
}, {
kind: "XV.InputWidget",
attr: "name"
}, {
kind: "XV.ProjectStatusPicker",
attr: "status"
}, {
kind: "XV.PriorityPicker",
attr: "priority"
}, {
kind: "XV.PercentWidget",
attr: "percentComplete"
}, {
kind: "onyx.GroupboxHeader",
content: "_schedule".loc()
}, {
kind: "XV.DateWidget",
attr: "dueDate"
}, {
kind: "XV.DateWidget",
attr: "startDate"
}, {
kind: "XV.DateWidget",
attr: "assignDate"
}, {
kind: "XV.DateWidget",
attr: "completeDate"
}, {
kind: "onyx.GroupboxHeader",
content: "_hours".loc()
}, {
kind: "XV.QuantityWidget",
attr: "budgetedHours",
label: "_budgeted".loc()
}, {
kind: "XV.QuantityWidget",
attr: "actualHours",
label: "_actual".loc()
}, {
kind: "onyx.GroupboxHeader",
content: "_expenses".loc()
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "budgetedExpenses"
},
label: "_budgeted".loc(),
currencyShowing: !1
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "actualExpenses"
},
label: "_actual".loc(),
currencyShowing: !1
}, {
kind: "onyx.GroupboxHeader",
content: "_userAccounts".loc()
}, {
kind: "XV.UserAccountWidget",
attr: "owner"
}, {
kind: "XV.UserAccountWidget",
attr: "assignedTo"
}, {
kind: "XV.TaskCharacteristicsWidget",
attr: "characteristics"
}, {
kind: "onyx.GroupboxHeader",
content: "_notes".loc()
}, {
kind: "XV.TextArea",
attr: "notes",
fit: !0
} ]
} ]
}), enyo.kind({
name: "XV.ProjectTasksBox",
kind: "XV.ListRelationsEditorBox",
classes: "xv-list-relations-box",
title: "_tasks".loc(),
editor: "XV.ProjectTaskEditor",
parentKey: "project",
listRelations: "XV.ProjectTaskListRelations",
fitButtons: !1
}), enyo.kind({
name: "XV.ProjectWorkflowEditor",
kind: "XV.RelationsEditor",
components: [ {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.InputWidget",
attr: "name"
}, {
kind: "XV.InputWidget",
attr: "description"
}, {
kind: "XV.WorkflowStatusPicker",
attr: "status"
}, {
kind: "XV.PriorityPicker",
attr: "priority",
showNone: !1
}, {
kind: "XV.NumberSpinnerWidget",
attr: "sequence"
}, {
kind: "onyx.GroupboxHeader",
content: "_schedule".loc()
}, {
kind: "XV.DateWidget",
attr: "dueDate"
}, {
kind: "XV.DateWidget",
attr: "startDate"
}, {
kind: "XV.DateWidget",
attr: "assignDate"
}, {
kind: "XV.DateWidget",
attr: "completeDate"
}, {
kind: "onyx.GroupboxHeader",
content: "_userAccounts".loc()
}, {
kind: "XV.UserAccountWidget",
attr: "owner"
}, {
kind: "XV.UserAccountWidget",
attr: "assignedTo"
}, {
kind: "onyx.GroupboxHeader",
content: "_onCompletion".loc()
}, {
kind: "XV.ProjectStatusPicker",
attr: "completedParentStatus",
noneText: "_noChange".loc(),
label: "_nextProjectStatus".loc()
}, {
kind: "XV.ProjectWorkflowSuccessorsWidget",
attr: {
workflow: "parent.workflow",
successors: "completedSuccessors"
}
}, {
kind: "onyx.GroupboxHeader",
content: "_onDeferred".loc()
}, {
kind: "XV.ProjectStatusPicker",
attr: "deferredParentStatus",
noneText: "_noChange".loc(),
label: "_nextProjectStatus".loc()
}, {
kind: "XV.ProjectWorkflowSuccessorsWidget",
attr: {
workflow: "parent.workflow",
successors: "deferredSuccessors"
}
}, {
kind: "onyx.GroupboxHeader",
content: "_notes".loc()
}, {
kind: "XV.TextArea",
attr: "notes",
fit: !0
} ]
} ]
}), enyo.kind({
name: "XV.ProjectWorkflowBox",
kind: "XV.ListRelationsEditorBox",
title: "_workflow".loc(),
editor: "XV.ProjectWorkflowEditor",
parentKey: "project",
listRelations: "XV.ProjectWorkflowListRelations",
fitButtons: !1
}), enyo.kind({
name: "XV.ProjectTypeWorkflowEditor",
kind: "XV.RelationsEditor",
components: [ {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.InputWidget",
attr: "name"
}, {
kind: "XV.InputWidget",
attr: "description"
}, {
kind: "XV.WorkflowStatusPicker",
attr: "status"
}, {
kind: "XV.PriorityPicker",
attr: "priority",
showNone: !1
}, {
kind: "XV.NumberSpinnerWidget",
attr: "sequence"
}, {
kind: "onyx.GroupboxHeader",
content: "_startDate".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "startSet"
}, {
kind: "XV.NumberSpinnerWidget",
attr: "startOffset"
}, {
kind: "onyx.GroupboxHeader",
content: "_dueDate".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "dueSet"
}, {
kind: "XV.NumberSpinnerWidget",
attr: "dueOffset"
}, {
kind: "onyx.GroupboxHeader",
content: "_userAccounts".loc()
}, {
kind: "XV.UserAccountWidget",
attr: "owner"
}, {
kind: "XV.UserAccountWidget",
attr: "assignedTo"
}, {
kind: "onyx.GroupboxHeader",
content: "_onCompletion".loc()
}, {
kind: "XV.ProjectStatusPicker",
attr: "completedParentStatus",
noneText: "_noChange".loc(),
label: "_nextProjectStatus".loc()
}, {
kind: "XV.ProjectWorkflowSuccessorsWidget",
attr: {
workflow: "parent.workflow",
successors: "completedSuccessors"
}
}, {
kind: "onyx.GroupboxHeader",
content: "_onDeferred".loc()
}, {
kind: "XV.ProjectStatusPicker",
attr: "deferredParentStatus",
noneText: "_noChange".loc(),
label: "_nextProjectStatus".loc()
}, {
kind: "XV.ProjectWorkflowSuccessorsWidget",
attr: {
workflow: "parent.workflow",
successors: "deferredSuccessors"
}
}, {
kind: "onyx.GroupboxHeader",
content: "_notes".loc()
}, {
kind: "XV.TextArea",
attr: "notes",
fit: !0
} ]
} ]
}), enyo.kind({
name: "XV.ProjectTypeWorkflowBox",
kind: "XV.ListRelationsEditorBox",
title: "_workflow".loc(),
editor: "XV.ProjectTypeWorkflowEditor",
parentKey: "projectType",
listRelations: "XV.ProjectTypeWorkflowListRelations",
fitButtons: !1
}), enyo.kind({
name: "XV.TaskResourcesEditor",
kind: "XV.RelationsEditor",
components: [ {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.ResourcePicker",
attr: "resource"
}, {
kind: "XV.PercentWidget",
attr: "percent"
} ]
} ]
}), enyo.kind({
name: "XV.TaskResourcesBox",
kind: "XV.ListRelationsEditorBox",
title: "_resources".loc(),
editor: "XV.TaskResourcesEditor",
parentKey: "task",
listRelations: "XV.TaskResourceListRelations",
fitButtons: !1
});
};
})();

// workspace.js

(function() {
XT.extensions.project.initWorkspaces = function() {
var e;
e = [ {
kind: "XV.AccountProjectsBox",
container: "panels",
attr: "projectRelations"
} ], XV.appendExtension("XV.AccountWorkspace", e), e = [ {
kind: "XV.ToggleButtonWidget",
attr: "isProjects",
label: "_projects".loc(),
container: "rolesGroup"
} ], XV.appendExtension("XV.CharacteristicWorkspace", e), enyo.kind({
name: "XV.ProjectManagementWorkspace",
kind: "XV.Workspace",
title: "_configure".loc() + " " + "_project".loc(),
model: "XM.ProjectManagement",
components: [ {
kind: "Panels",
arrangerKind: "CarouselArranger",
fit: !0,
components: [ {
kind: "XV.Groupbox",
name: "mainPanel",
components: [ {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
classes: "in-panel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_setup".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "UseProjects",
label: "_useProjects".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "RequireProjectAssignment",
label: "_requireProjectAssignment".loc()
} ]
} ]
} ]
} ]
}), e = [ {
kind: "XV.ContactProjectsBox",
container: "panels",
attr: "projectRelations"
} ], XV.appendExtension("XV.ContactWorkspace", e), e = [ {
kind: "XV.ProjectWidget",
container: "mainGroup",
attr: "project"
} ], XV.appendExtension("XV.IncidentWorkspace", e), XT.session.settings.get("UseProjects") === "true" && (e = [ {
kind: "XV.ProjectWidget",
container: "mainGroup",
attr: "project"
} ], XV.appendExtension("XV.InvoiceWorkspace", e));
var t = {
name: "XV.ProjectWorkspace",
kind: "XV.Workspace",
title: "_project".loc(),
headerAttrs: [ "number", "-", "name" ],
model: "XM.Project",
components: [ {
kind: "Panels",
arrangerKind: "CarouselArranger",
fit: !0,
components: [ {
kind: "XV.Groupbox",
name: "mainPanel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_overview".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.InputWidget",
attr: "number"
}, {
kind: "XV.InputWidget",
attr: "name"
}, {
kind: "XV.DepartmentWidget",
attr: "department"
}, {
kind: "XV.ProjectTypePicker",
attr: "projectType"
}, {
kind: "XV.ProjectStatusPicker",
attr: "status"
}, {
kind: "XV.PriorityPicker",
attr: "priority"
}, {
kind: "XV.PercentWidget",
attr: "percentComplete"
}, {
kind: "onyx.GroupboxHeader",
content: "_schedule".loc()
}, {
kind: "XV.DateWidget",
attr: "dueDate"
}, {
kind: "XV.DateWidget",
attr: "startDate"
}, {
kind: "XV.DateWidget",
attr: "assignDate"
}, {
kind: "XV.DateWidget",
attr: "completeDate"
}, {
kind: "onyx.GroupboxHeader",
content: "_userAccounts".loc()
}, {
kind: "XV.UserAccountWidget",
attr: "owner"
}, {
kind: "XV.UserAccountWidget",
attr: "assignedTo"
}, {
kind: "XV.ProjectCharacteristicsWidget",
attr: "characteristics"
}, {
kind: "onyx.GroupboxHeader",
content: "_notes".loc()
}, {
kind: "XV.TextArea",
attr: "notes",
fit: !0
}, {
kind: "onyx.GroupboxHeader",
content: "_relationships".loc()
}, {
kind: "XV.AccountWidget",
attr: "account"
}, {
kind: "XV.ContactWidget",
attr: "contact"
} ]
} ]
}, {
kind: "XV.ProjectCommentBox",
attr: "comments"
}, {
kind: "XV.ContactDocumentsBox",
attr: "documents"
} ]
} ],
create: function() {
this.inherited(arguments);
var e = this.$.panels;
enyo.platform.touch ? e.createComponents([ {
kind: "XV.ProjectTasksBox",
attr: "tasks",
addBefore: this.$.projectCommentBox,
classes: "medium-panel"
}, {
kind: "XV.ProjectWorkflowBox",
attr: "workflow",
addBefore: this.$.projectCommentBox,
classes: "medium-panel"
} ], {
owner: this
}) : e.createComponents([ {
kind: "XV.ProjectTasksGridBox",
attr: "tasks",
addBefore: this.$.projectCommentBox
}, {
kind: "XV.ProjectWorkflowGridBox",
attr: "workflow",
addBefore: this.$.projectCommentBox
} ], {
owner: this
});
}
};
t = enyo.mixin(t, XV.accountNotifyContactMixin), enyo.kind(t), XV.registerModelWorkspace("XM.Project", "XV.ProjectWorkspace"), XV.registerModelWorkspace("XM.ProjectRelation", "XV.ProjectWorkspace"), XV.registerModelWorkspace("XM.ProjectListItem", "XV.ProjectWorkspace"), XV.registerModelWorkspace("XM.ProjectTask", "XV.ProjectWorkspace"), XV.registerModelWorkspace("XM.ProjectWorkflow", "XV.ProjectWorkspace"), enyo.kind({
name: "XV.ProjectTaskWorkspace",
kind: "XV.ChildWorkspace",
title: "_projectTask".loc(),
model: "XM.ProjectTask",
components: [ {
kind: "Panels",
arrangerKind: "CarouselArranger",
classes: "xv-top-panel",
fit: !0,
components: [ {
kind: "XV.Groupbox",
name: "mainPanel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_overview".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.InputWidget",
attr: "number"
}, {
kind: "XV.InputWidget",
attr: "name"
}, {
kind: "XV.ProjectStatusPicker",
attr: "status"
}, {
kind: "XV.PriorityPicker",
attr: "priority"
}, {
kind: "XV.PercentWidget",
attr: "percentComplete"
}, {
kind: "onyx.GroupboxHeader",
content: "_schedule".loc()
}, {
kind: "XV.DateWidget",
attr: "dueDate"
}, {
kind: "XV.DateWidget",
attr: "startDate"
}, {
kind: "XV.DateWidget",
attr: "assignDate"
}, {
kind: "XV.DateWidget",
attr: "completeDate"
}, {
kind: "onyx.GroupboxHeader",
content: "_hours".loc()
}, {
kind: "XV.HoursWidget",
attr: "budgetedHours",
label: "_budgeted".loc()
}, {
kind: "XV.HoursWidget",
attr: "actualHours",
label: "_actual".loc()
}, {
kind: "onyx.GroupboxHeader",
content: "_expenses".loc()
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "budgetedExpenses"
},
label: "_budgeted".loc(),
currencyShowing: !1
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "actualExpenses"
},
label: "_actual".loc(),
currencyShowing: !1
}, {
kind: "onyx.GroupboxHeader",
content: "_userAccounts".loc()
}, {
kind: "XV.UserAccountWidget",
attr: "owner"
}, {
kind: "XV.UserAccountWidget",
attr: "assignedTo"
}, {
kind: "onyx.GroupboxHeader",
content: "_notes".loc()
}, {
kind: "XV.TextArea",
attr: "notes",
fit: !0
} ]
} ]
}, {
kind: "XV.TaskResourcesBox",
attr: "resources"
}, {
kind: "XV.TaskCommentBox",
attr: "comments"
} ]
} ]
}), enyo.kind({
name: "XV.ProjectWorkflowWorkspace",
kind: "XV.ChildWorkspace",
title: "_projectWorkflow".loc(),
model: "XM.ProjectWorkflow",
components: [ {
kind: "Panels",
arrangerKind: "CarouselArranger",
classes: "xv-top-panel",
fit: !0,
components: [ {
kind: "XV.Groupbox",
name: "mainPanel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_overview".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.InputWidget",
attr: "name"
}, {
kind: "XV.InputWidget",
attr: "description"
}, {
kind: "XV.WorkflowStatusPicker",
attr: "status"
}, {
kind: "XV.PriorityPicker",
attr: "priority",
showNone: !1
}, {
kind: "XV.NumberSpinnerWidget",
attr: "sequence"
}, {
kind: "onyx.GroupboxHeader",
content: "_schedule".loc()
}, {
kind: "XV.DateWidget",
attr: "dueDate"
}, {
kind: "XV.DateWidget",
attr: "startDate"
}, {
kind: "XV.DateWidget",
attr: "assignDate"
}, {
kind: "XV.DateWidget",
attr: "completeDate"
}, {
kind: "onyx.GroupboxHeader",
content: "_userAccounts".loc()
}, {
kind: "XV.UserAccountWidget",
attr: "owner"
}, {
kind: "XV.UserAccountWidget",
attr: "assignedTo"
}, {
kind: "onyx.GroupboxHeader",
content: "_notes".loc()
}, {
kind: "XV.TextArea",
attr: "notes",
fit: !0
} ]
} ]
}, {
kind: "XV.Groupbox",
name: "onCompletedPanel",
title: "_completionActions".loc(),
components: [ {
kind: "onyx.GroupboxHeader",
content: "_onCompletion".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "completionGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.ProjectStatusPicker",
attr: "completedParentStatus",
noneText: "_noChange".loc(),
label: "_nextProjectStatus".loc()
}, {
kind: "XV.ProjectWorkflowSuccessorsWidget",
attr: {
workflow: "parent.workflow",
successors: "completedSuccessors"
}
} ]
} ]
}, {
kind: "XV.Groupbox",
name: "onDeferredPanel",
title: "_deferredActions".loc(),
components: [ {
kind: "onyx.GroupboxHeader",
content: "_onDeferred".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "deferredGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.ProjectStatusPicker",
attr: "deferredParentStatus",
noneText: "_noChange".loc(),
label: "_nextProjectStatus".loc()
}, {
kind: "XV.ProjectWorkflowSuccessorsWidget",
attr: {
workflow: "parent.workflow",
successors: "deferredSuccessors"
}
} ]
} ]
} ]
} ]
}), enyo.kind({
name: "XV.ProjectEmailProfileWorkspace",
kind: "XV.EmailProfileWorkspace",
title: "_projectEmailProfile".loc(),
model: "XM.ProjectEmailProfile"
}), XV.registerModelWorkspace("XM.ProjectEmailProfile", "XV.ProjectEmailProfileWorkspace"), enyo.kind({
name: "XV.ProjectTypeWorkspace",
kind: "XV.Workspace",
title: "_projectType".loc(),
model: "XM.ProjectType",
components: [ {
kind: "Panels",
arrangerKind: "CarouselArranger",
fit: !0,
components: [ {
kind: "XV.Groupbox",
name: "mainPanel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_overview".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
classes: "in-panel",
fit: !0,
components: [ {
kind: "XV.InputWidget",
attr: "code"
}, {
kind: "XV.CheckboxWidget",
attr: "isActive"
}, {
kind: "XV.InputWidget",
attr: "description"
}, {
kind: "XV.ProjectEmailProfilePicker",
attr: "emailProfile"
}, {
kind: "XV.ProjectCharacteristicsWidget",
attr: "characteristics"
} ]
} ]
}, {
kind: "XV.ProjectTypeWorkflowBox",
attr: "workflow"
} ]
} ]
}), XV.registerModelWorkspace("XM.ProjectType", "XV.ProjectTypeWorkspace"), e = [ {
kind: "XV.ProjectWidget",
container: "settingsGroup",
attr: "project"
} ], XV.appendExtension("XV.QuoteWorkspace", e), e = [ {
kind: "XV.ProjectWidget",
container: "settingsGroup",
attr: "project"
} ], XV.appendExtension("XV.SalesOrderWorkspace", e);
};
})();

// dashboard.js

(function() {
enyo.kind({
name: "XV.ProjectDashboard",
kind: "XV.Dashboard",
collection: "XM.UserChartCollection",
extension: "project",
newActions: [ {
name: "projects",
label: "_projects".loc(),
item: "XV.ProjectBarChart"
}, {
name: "tasks",
label: "_tasks".loc(),
item: "XV.TaskBarChart"
}, {
name: "resourceBudgetedHours",
label: "_resources".loc() + " " + "_budgetedHours".loc(),
item: "XV.ResourceBudgetedHoursBarChart"
}, {
name: "resourceActualHours",
label: "_resources".loc() + " " + "_actualHours".loc(),
item: "XV.ResourceActualHoursBarChart"
}, {
name: "resourceBalanceHours",
label: "_resources".loc() + " " + "_balanceHours".loc(),
item: "XV.ResourceBalanceHoursBarChart"
}, {
name: "taskBudgetedHours",
label: "_task".loc() + " " + "_budgetedHours".loc(),
item: "XV.TaskBudgetedHoursTimeSeriesChart"
}, {
name: "taskActualHours",
label: "_task".loc() + " " + "_actualHours".loc(),
item: "XV.TaskActualHoursTimeSeriesChart"
}, {
name: "taskBudgetedExpenses",
label: "_task".loc() + " " + "_budgetedExpenses".loc(),
item: "XV.TaskBudgetedExpensesTimeSeriesChart"
}, {
name: "taskActualExpenses",
label: "_task".loc() + " " + "_actualExpenses".loc(),
item: "XV.TaskActualExpensesTimeSeriesChart"
}, {
name: "projectBudgetedHours",
label: "_budgeted".loc() + " " + "_hours".loc(),
item: "XV.ProjectBudgetedHoursBarChart"
}, {
name: "projectActualHours",
label: "_actual".loc() + " " + "_hours".loc(),
item: "XV.ProjectActualHoursBarChart"
}, {
name: "projectBudgetedExpenses",
label: "_budgeted".loc() + " " + "_expenses".loc(),
item: "XV.ProjectBudgetedExpensesBarChart"
}, {
name: "projectActualExpenses",
label: "_actual".loc() + " " + "_expenses".loc(),
item: "XV.ProjectActualExpensesBarChart"
} ]
});
})();

// postbooks.js

(function() {
XT.extensions.project.initPostbooks = function() {
var e, t, n, r;
n = [ {
name: "honorificList",
kind: "XV.HonorificList"
}, {
name: "itemList",
kind: "XV.ItemList"
}, {
name: "itemGroupList",
kind: "XV.ItemGroupList"
}, {
name: "classCodeList",
kind: "XV.ClassCodeList"
}, {
name: "unitList",
kind: "XV.UnitList"
}, {
name: "stateList",
kind: "XV.StateList"
}, {
name: "countryList",
kind: "XV.CountryList"
}, {
name: "projectEmailProfileList",
kind: "XV.ProjectEmailProfileList"
}, {
name: "projectTypeList",
kind: "XV.ProjectTypeList"
} ], XT.app.$.postbooks.appendPanels("setup", n), t = {
name: "projectDashboard",
hasSubmenu: !1,
label: "_dashboard".loc(),
panels: [ {
name: "projectDashboard",
kind: "XV.ProjectDashboard"
} ]
}, e = {
name: "project",
label: "_project".loc(),
panels: [ {
name: "projectList",
kind: "XV.ProjectList"
}, {
name: "project_activityList",
kind: "XV.ActivityList"
} ]
}, XT.app.$.postbooks.insertModule(e, 0), r = [ "MaintainAddresses", "MaintainAllContacts", "MaintainAllCRMAccounts", "MaintainAllIncidents", "MaintainAllProjects", "MaintainClassCodes", "MaintainPersonalContacts", "MaintainPersonalCRMAccounts", "MaintainPersonalIncidents", "MaintainPersonalProjects", "MaintainPersonalToDoItems", "MaintainProjectEmailProfiles", "MaintainProjectTypes", "MaintainTitles", "ViewAllContacts", "ViewAllCRMAccounts", "ViewAllIncidentHistory", "ViewAllIncidents", "ViewAllProjects", "ViewPersonalContacts", "ViewPersonalCRMAccounts", "ViewPersonalIncidents", "ViewPersonalProjects", "ViewTitles", "DeleteItemMasters", "MaintainItemMasters", "MaintainItemGroups", "MaintainUOMs", "ViewClassCodes", "ViewItemMasters", "ConfigurePM", "EditOthersComments", "EditOwnComments", "MaintainCommentTypes", "MaintainCountries", "MaintainStates" ], XT.session.addRelevantPrivileges(e.name, r), XM.configurations.add(new XM.ConfigurationModel({
model: "XM.projectManagement",
name: "_project".loc(),
description: "_projectManagement".loc(),
workspace: "XV.ProjectManagementWorkspace"
}));
};
})();
