
// core.js

(function() {
"use strict";
XT.extensions.sales = {
setVersion: function() {
XT.setVersion("", "sales");
}
};
})();

// account.js

(function() {
"use strict";
XT.extensions.sales.initAccountModels = function() {
var e = XM.Account.prototype;
e.roleAttributes.push("customer"), e.roleAttributes.push("prospect");
var t = e.initialize;
e.initialize = function() {
t.apply(this, arguments), this.on("change:customer", this.customerChanged);
}, e.customerChanged = function() {
var e = this.get("customer") ? !0 : !1;
this.setReadOnly("prospect", e);
}, XM.AccountCustomer = XM.Model.extend({
recordType: "XM.AccountCustomer",
isDocumentAssignment: !0
});
};
})();

// configure.js

(function() {
"use strict";
XT.extensions.sales.initSettings = function() {
XM.Sales = XM.Settings.extend({
recordType: "XM.Sales",
privileges: "ConfigureSO",
bindEvents: function() {
XM.Settings.prototype.bindEvents.apply(this, arguments), this.on("statusChange", this.statusDidChange);
},
statusDidChange: function() {},
validate: function(e, t) {
var n = {
type: "_number".loc()
};
if (e.NextSalesOrderNumber !== undefined && isNaN(e.NextSalesOrderNumber)) return n.attr = "_salesOrder".loc() + " " + "_number".loc(), XT.Error.clone("xt1003", {
params: n
});
if (e.NextQuoteNumber && isNaN(e.NextQuoteNumber)) return n.attr = "_quote".loc() + " " + "_number".loc(), XT.Error.clone("xt1003", {
params: n
});
if (e.NextCreditMemoNumber && isNaN(e.NextCreditMemoNumber)) return n.attr = "_creditMemo".loc() + " " + "_number".loc(), XT.Error.clone("xt1003", {
params: n
});
if (e.NextInvoiceNumber && isNaN(e.NextInvoiceNumber)) return n.attr = "_invoice".loc() + " " + "_number".loc(), XT.Error.clone("xt1003", {
params: n
});
}
}), XM.sales = new XM.Sales;
};
})();

// contact.js

(function() {
"use strict";
XT.extensions.sales.initContactModels = function() {
XM.ContactCustomer = XM.Model.extend({
recordType: "XM.ContactCustomer",
isDocumentAssignment: !0
});
};
})();

// incident.js

(function() {
"use strict";
XT.extensions.sales.initIncidentModels = function() {
XM.IncidentCustomer = XM.Model.extend({
recordType: "XM.IncidentCustomer",
isDocumentAssignment: !0
});
};
})();

// item.js

(function() {
"use strict";
XT.extensions.sales.initItemModels = function() {
XM.ItemCustomer = XM.Model.extend({
recordType: "XM.ItemCustomer",
isDocumentAssignment: !0
});
};
})();

// invoice.js

(function() {
"use strict";
XT.extensions.sales.initInvoiceModels = function() {
XM.InvoiceSalesOrder = XM.Model.extend({
recordType: "XM.InvoiceSalesOrder",
isDocumentAssignment: !0
});
var e = XM.Invoice.prototype.defaults;
_.extend(XM.Invoice.prototype, {
defaults: function() {
var t = e.apply(this, arguments);
return t.orderDate = new Date, t;
}
});
};
})();

// opportunity.js

(function() {
"use strict";
XT.extensions.sales.initOpportunityModels = function() {
XM.OpportunityCustomer = XM.Model.extend({
recordType: "XM.OpportunityCustomer",
isDocumentAssignment: !0
});
};
})();

// to_do.js

(function() {
"use strict";
XT.extensions.sales.initToDoModels = function() {
XM.ToDoCustomer = XM.Model.extend({
recordType: "XM.ToDoCustomer",
isDocumentAssignment: !0
});
};
})();

// startup.js

(function() {
"use strict";
XT.extensions.sales.initStartup = function() {
XT.cacheCollection("XM.classCodes", "XM.ClassCodeCollection", "code"), XT.cacheCollection("XM.costCategories", "XM.CostCategoryCollection", "code"), XT.cacheCollection("XM.customerEmailProfiles", "XM.CustomerEmailProfileCollection"), XT.cacheCollection("XM.customerTypes", "XM.CustomerTypeCollection"), XT.cacheCollection("XM.freightClasses", "XM.FreightClassCollection", "code"), XT.cacheCollection("XM.plannerCodes", "XM.PlannerCodeCollection", "code"), XT.cacheCollection("XM.productCategories", "XM.ProductCategoryCollection"), XT.cacheCollection("XM.salesEmailProfiles", "XM.SalesEmailProfileCollection"), XT.cacheCollection("XM.salesReps", "XM.SalesRepCollection"), XT.cacheCollection("XM.saleTypes", "XM.SaleTypeCollection", "code"), XT.cacheCollection("XM.shipCharges", "XM.ShipChargeCollection"), XT.cacheCollection("XM.shipVias", "XM.ShipViaCollection", "code"), XT.cacheCollection("XM.shipZones", "XM.ShipZoneCollection"), XT.cacheCollection("XM.siteTypes", "XM.SiteTypeCollection", "name"), XT.cacheCollection("XM.terms", "XM.TermsCollection"), XT.cacheCollection("XM.bankAccountRelations", "XM.BankAccountRelationCollection");
};
})();

// static.js

(function() {
"use strict";
XT.extensions.sales.initStaticModels = function() {
var e, t = [ {
id: "currdate",
name: "_currentDate".loc()
}, {
id: "shipdate",
name: "_shipDate".loc()
}, {
id: "scheddate",
name: "_scheduledDate".loc()
} ];
XM.InvoiceDateSourceModel = Backbone.Model.extend({}), XM.InvoiceDateSourceCollection = Backbone.Collection.extend({
model: XM.InvoiceDateSourceModel
}), XM.invoiceDateSources = new XM.InvoiceDateSourceCollection;
for (e = 0; e < t.length; e++) {
var n = new XM.InvoiceDateSourceModel(t[e]);
XM.invoiceDateSources.add(n);
}
var r = [ {
id: 3,
name: "_update".loc()
}, {
id: 1,
name: "_doNotUpdate".loc()
}, {
id: 2,
name: "_prompt".loc()
} ];
XM.LineItemEditBehaviorModel = Backbone.Model.extend({}), XM.LineItemEditBehaviorCollection = Backbone.Collection.extend({
model: XM.LineItemEditBehaviorModel
}), XM.lineItemEditBehaviors = new XM.LineItemEditBehaviorCollection;
for (e = 0; e < r.length; e++) {
var i = new XM.LineItemEditBehaviorModel(r[e]);
XM.lineItemEditBehaviors.add(i);
}
var s = [ {
id: "CurrentDate",
name: "_current".loc()
}, {
id: "OrderDate",
name: "_order".loc()
}, {
id: "ScheduleDate",
name: "_scheduled".loc()
} ];
XM.PriceEffectiveDateModel = Backbone.Model.extend({}), XM.PriceEffectiveDateCollection = Backbone.Collection.extend({
model: XM.PriceEffectiveDateModel
}), XM.priceEffectiveDates = new XM.PriceEffectiveDateCollection;
for (e = 0; e < s.length; e++) {
var o = new XM.PriceEffectiveDateModel(s[e]);
XM.priceEffectiveDates.add(o);
}
};
})();

// parameter.js

(function() {
XT.extensions.sales.initParameters = function() {
XV.ActivityListParameters.prototype.activityTypes.sales = [ {
type: "SalesOrder",
label: "_salesOrders".loc()
}, {
type: "SalesOrderWorkflow",
label: "_orderWorkflow".loc()
} ], enyo.kind({
name: "XV.SalesHistoryListParameters",
kind: "XV.ParameterWidget",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_salesHistory".loc()
}, {
name: "customer",
attr: "customer",
label: "_customer".loc(),
defaultKind: "XV.CustomerProspectWidget"
}, {
name: "salesRep",
attr: "salesRep",
label: "_salesRep".loc(),
defaultKind: "XV.SalesRepPicker"
} ]
});
};
})();

// chart.js

(function() {
enyo.kind({
name: "XV.SalesHistoryTimeSeriesChart",
kind: "XV.TimeSeriesChart",
collection: "XM.SalesHistoryCollection",
chartTitle: "_salesHistory".loc(),
groupByOptions: [ {
name: ""
}, {
name: "customer"
}, {
name: "salesRep"
} ],
dateField: "shipDate",
totalField: "totalPrice"
}), enyo.kind({
name: "XV.SalesOrderTimeSeriesChart",
kind: "XV.TimeSeriesChart",
collection: "XM.SalesOrderListItemCollection",
chartTitle: "_bookings".loc(),
groupByOptions: [ {
name: ""
}, {
name: "customer"
}, {
name: "salesRep"
} ],
dateField: "orderDate",
totalField: "total"
});
})();

// list.js

(function() {
XT.extensions.sales.initLists = function() {
enyo.kind({
name: "XV.SalesHistoryList",
kind: "XV.List",
label: "_salesHistory".loc(),
collection: "XM.SalesHistoryCollection",
parameterWidget: "XV.SalesHistoryListParameters",
query: {
orderBy: [ {
attribute: "id"
} ]
},
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListColumn",
classes: "first",
components: [ {
kind: "XV.ListAttr",
attr: "customer.number",
isKey: !0
}, {
kind: "XV.ListAttr",
attr: "salesRep.name"
} ]
}, {
kind: "XV.ListColumn",
classes: "first",
components: [ {
kind: "XV.ListAttr",
attr: "orderNumber"
}, {
kind: "XV.ListAttr",
attr: "shipDate"
} ]
} ]
}, {
kind: "FittableColumns",
components: [ {
kind: "XV.ListColumn",
classes: "last",
fit: !0,
components: [ {
kind: "XV.ListAttr",
attr: "quantityShipped"
}, {
kind: "XV.ListAttr",
attr: "unitPrice"
} ]
} ]
} ]
} ]
}), XV.registerModelList("XM.SalesHistory", "XV.SalesHistoryList");
};
})();

// list_relations.js

(function() {
XT.extensions.sales.initListRelations = function() {
enyo.kind({
name: "XV.CustomerSalesOrderListRelations",
kind: "XV.ListRelations",
orderBy: [ {
attribute: "number",
descending: !0
} ],
parentKey: "customer",
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableRows",
components: [ {
kind: "XV.ListColumn",
classes: "first",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListAttr",
attr: "number",
classes: "bold"
}, {
kind: "XV.ListAttr",
attr: "orderDate",
classes: "right"
} ]
} ]
}, {
kind: "XV.ListColumn",
classes: "first",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListAttr",
attr: "shipVia"
}, {
kind: "XV.ListAttr",
attr: "total",
classes: "right",
formatter: "formatMoney"
} ]
} ]
} ]
} ]
} ],
formatMoney: function(e) {
return Globalize.format(e, "c" + XT.locale.currencyScale);
}
}), enyo.kind({
name: "XV.CustomerQuoteListRelations",
kind: "XV.CustomerSalesOrderListRelations",
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableRows",
components: [ {
kind: "XV.ListColumn",
classes: "first",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListAttr",
attr: "number",
classes: "bold"
}, {
kind: "XV.ListAttr",
attr: "quoteDate",
classes: "right"
} ]
} ]
}, {
kind: "XV.ListColumn",
classes: "first",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListAttr",
attr: "shipVia"
}, {
kind: "XV.ListAttr",
attr: "total",
classes: "right",
formatter: "formatMoney"
} ]
} ]
} ]
} ]
} ]
}), enyo.kind({
name: "XV.OpportunityQuoteListRelations",
kind: "XV.CustomerQuoteListRelations",
parentKey: "opportunity"
}), enyo.kind({
name: "XV.OpportunitySalesListRelations",
kind: "XV.CustomerSalesOrderListRelations",
parentKey: "opportunity"
});
};
})();

// list_relations_box.js

(function() {
XT.extensions.sales.initListRelationsBoxes = function() {
var e = function(e, t) {
var n = this, r, i, s, o;
if (t.attributes && !t.attributes.customer) return r = this.$.list.getParent(), o = r.getValue("account.number"), s = {
id: o,
success: function() {
t.attributes.customer = i, n.doWorkspace(t);
}
}, i = new e, i.fetch(s), !0;
}, t = function(e) {
var t = this.$.newButton, n = this.$.attachButton, r, i;
t.disabled || (r = this.$.list.getParent(), i = r.get("account"), !i.get("customer") && (e || !i.get("prospect")) && (t.setDisabled(!0), n.setDisabled(!0)));
}, n = function(e, t) {
var n = XV.ListRelationsBox.prototype.attachItem, r = this.$.list.getParent(), i = r.getValue("account.number");
t.conditions = [ {
attribute: "customer",
value: i
} ], n.call(this, e, t);
};
enyo.kind({
name: "XV.OpportunityQuoteListRelationsBox",
kind: "XV.ListRelationsBox",
title: "_quotes".loc(),
parentKey: "opportunity",
listRelations: "XV.OpportunityQuoteListRelations",
searchList: "XV.QuoteList",
handlers: {
onWorkspace: "appendWorkspace"
},
appendWorkspace: function(t, n) {
return e.call(this, XM.CustomerProspectRelation, n);
},
attachItem: function(e, t) {
n.call(this, e, t);
},
updateButtons: function() {
this.inherited(arguments), t.call(this);
}
}), enyo.kind({
name: "XV.OpportunitySalesOrderListRelationsBox",
kind: "XV.ListRelationsBox",
title: "_salesOrders".loc(),
parentKey: "opportunity",
listRelations: "XV.OpportunitySalesListRelations",
searchList: "XV.SalesOrderList",
handlers: {
onWorkspace: "appendWorkspace"
},
appendWorkspace: function(t, n) {
return e.call(this, XM.SalesCustomer, n);
},
attachItem: function(e, t) {
n.call(this, e, t);
},
updateButtons: function() {
this.inherited(arguments), t.call(this, !0);
}
}), enyo.kind({
name: "XV.ProspectQuoteListRelationsBox",
kind: "XV.ListRelationsBox",
title: "_quotes".loc(),
parentKey: "customer",
listRelations: "XV.CustomerQuoteListRelations"
});
};
})();

// dashboard.js

(function() {
enyo.kind({
name: "XV.SalesDashboard",
kind: "XV.Dashboard",
collection: "XM.UserChartCollection",
extension: "sales",
newActions: [ {
name: "salesHistory",
label: "_salesHistory".loc(),
item: "XV.SalesHistoryTimeSeriesChart"
}, {
name: "bookings",
label: "_bookings".loc(),
item: "XV.SalesOrderTimeSeriesChart"
} ]
});
})();

// workspace.js

(function() {
XT.extensions.sales.initWorkspaces = function() {
var e, t = XV.AccountWorkspace.prototype;
t.kindHandlers.onWorkspace = "workspace", t.workspace = function(e, t) {
var n = this.getValue(), r = n ? n.get("prospect") : !1;
if (t.workspace === "XV.CustomerWorkspace" && r && !this._passThrough) return t.success = function() {
this.getValue().convertFromProspect(r.id);
}, this._passThrough = !0, this.bubble("onWorkspace", t, this), !0;
this._passThrough = !1;
}, enyo.kind({
name: "XV.SalesWorkspace",
kind: "XV.Workspace",
title: "_configure".loc() + " " + "_sales".loc(),
model: "XM.Sales",
components: [ {
kind: "Panels",
arrangerKind: "CarouselArranger",
fit: !0,
components: [ {
kind: "XV.Groupbox",
name: "mainPanel",
components: [ {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_salesOrder".loc()
}, {
kind: "XV.NumberPolicyPicker",
attr: "CONumberGeneration",
label: "_number".loc() + " " + "_policy".loc()
}, {
kind: "XV.NumberWidget",
attr: "NextSalesOrderNumber",
label: "_nextNumber".loc(),
formatting: !1
}, {
kind: "XV.ToggleButtonWidget",
attr: "DefaultPrintSOOnSave",
label: "_printOnSave".loc()
}, {
kind: "onyx.GroupboxHeader",
content: "_quote".loc()
}, {
kind: "XV.NumberPolicyPicker",
attr: "QUNumberGeneration",
label: "_number".loc() + " " + "_policy".loc()
}, {
kind: "XV.NumberWidget",
attr: "NextQuoteNumber",
label: "_nextNumber".loc(),
formatting: !1
}, {
kind: "XV.ToggleButtonWidget",
attr: "ShowQuotesAfterSO",
label: "_showQuotesAfterConverted".loc()
}, {
kind: "onyx.GroupboxHeader",
content: "_creditMemo".loc()
}, {
kind: "XV.NumberPolicyPicker",
attr: "CMNumberGeneration",
label: "_number".loc() + " " + "_policy".loc()
}, {
kind: "XV.NumberWidget",
attr: "NextCreditMemoNumber",
label: "_nextNumber".loc(),
formatting: !1
}, {
kind: "onyx.GroupboxHeader",
content: "_invoice".loc()
}, {
kind: "XV.NumberPolicyPicker",
attr: "InvcNumberGeneration",
label: "_number".loc() + " " + "_policy".loc()
}, {
kind: "XV.NumberWidget",
attr: "NextInvoiceNumber",
label: "_nextNumber".loc(),
formatting: !1
}, {
kind: "XV.PickerWidget",
attr: "InvoiceDateSource",
label: "_invoiceDateSource".loc(),
collection: "XM.invoiceDateSources"
}, {
kind: "onyx.GroupboxHeader",
content: "_dateControl".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "AllowASAPShipSchedules",
label: "_allowASAPShipSchedules".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "UsePromiseDate",
label: "_usePromiseDates".loc()
}, {
kind: "onyx.GroupboxHeader",
content: "_changeLog".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "CustomerChangeLog",
label: "_postCustomerChanges".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "SalesOrderChangeLog",
label: "_postSalesOrderChanges".loc()
}, {
kind: "onyx.GroupboxHeader",
content: "_shipControl".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "AlwaysShowSaveAndAdd",
label: "_showSaveAndAddbutton".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "FirmSalesOrderPackingList",
label: "_firmSalesOrdersWhenAddedToPackingList".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "EnableSOShipping",
label: "_enableSOShipping".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "AutoSelectForBilling",
label: "_autoSelectForBilling".loc()
}, {
kind: "onyx.GroupboxHeader",
content: "_creditControl".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "RestrictCreditMemos",
label: "_restrictCreditMemos".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "AutoAllocateCreditMemos",
label: "_autoAllocateCreditMemos".loc()
} ]
} ]
}, {
kind: "XV.Groupbox",
name: "pricePanel",
title: "_pricing".loc(),
components: [ {
kind: "XV.ScrollableGroupbox",
name: "priceGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_priceControl".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "AllowDiscounts",
label: "_allowDiscounts".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "DisableSalesOrderPriceOverride",
label: "_disableSalesOrderPriceOverride".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "HideSOMiscCharge",
label: "_hideSOMiscCharge".loc()
}, {
kind: "XV.PickerWidget",
attr: "soPriceEffective",
label: "_priceEffectiveDate".loc(),
collection: "XM.priceEffectiveDates"
}, {
kind: "onyx.GroupboxHeader",
content: "_freightPricing".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "CalculateFreight",
label: "_useCalculatedFreightPricing".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "IncludePackageWeight",
label: "_includePackageWeight".loc()
}, {
kind: "XV.PickerWidget",
attr: "UpdatePriceLineEdit",
label: "_pricingOnLineItemEdits".loc(),
collection: "XM.lineItemEditBehaviors"
}, {
kind: "XV.ToggleButtonWidget",
attr: "IgnoreCustDisc",
label: "_ignoreIfDiscounted".loc()
} ]
} ]
}, {
kind: "XV.Groupbox",
name: "defaultsPanel",
title: "_customerDefaults".loc(),
components: [ {
kind: "XV.ScrollableGroupbox",
name: "defaultsGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_customerDefaults".loc()
}, {
kind: "XV.CustomerTypePicker",
attr: "DefaultCustType",
label: "_customerType".loc()
}, {
kind: "XV.SalesRepPicker",
attr: "DefaultSalesRep",
label: "_salesRep".loc()
}, {
kind: "XV.ShipViaPicker",
attr: "DefaultShipViaId",
label: "_shipVia".loc()
}, {
kind: "XV.TermsPicker",
attr: "DefaultTerms",
label: "_terms".loc()
}, {
kind: "XV.BalanceMethodPicker",
attr: "DefaultBalanceMethod",
label: "_balanceMethod".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "DefaultPartialShipments",
label: "_acceptsPartialShipments".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "DefaultBackOrders",
label: "_acceptsBackOrders".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "DefaultFreeFormShiptos",
label: "_allowFreeFormShiptos".loc()
}, {
kind: "XV.NumberWidget",
attr: "SOCreditLimit",
label: "_creditLimit".loc()
}, {
kind: "XV.InputWidget",
attr: "SOCreditRate",
label: "_creditRating".loc()
} ]
} ]
} ]
} ]
}), e = [ {
kind: "XV.MoneyWidget",
attr: {
localValue: "authorizedCredit",
currency: "currency"
},
label: "_authorizedCredit".loc(),
currencyShowing: !1,
container: "invoiceLineItemBox.summaryPanel.summaryColumnOne",
defer: !0
}, {
kind: "XV.InputWidget",
container: "mainSubgroup",
addBefore: "isPosted",
attr: "orderNumber"
}, {
kind: "XV.DateWidget",
container: "mainSubgroup",
addBefore: "isPosted",
attr: "orderDate"
} ], XV.appendExtension("XV.InvoiceWorkspace", e), e = [ {
kind: "XV.OpportunityQuoteListRelationsBox",
container: "panels",
attr: "quoteRelations"
}, {
kind: "XV.OpportunitySalesOrderListRelationsBox",
container: "panels",
attr: "salesOrderRelations"
} ], XV.appendExtension("XV.OpportunityWorkspace", e);
};
})();

// postbooks.js

(function() {
XT.extensions.sales.initPostbooks = function() {
var e, t, n, r, i, s;
t = [ {
name: "bankAccountList",
kind: "XV.BankAccountList"
}, {
name: "customerEmailProfileList",
kind: "XV.CustomerEmailProfileList"
}, {
name: "siteList",
kind: "XV.SiteList"
}, {
name: "siteTypeList",
kind: "XV.SiteTypeList"
}, {
name: "saleTypeList",
kind: "XV.SaleTypeList"
}, {
name: "salesEmailProfileList",
kind: "XV.SalesEmailProfileList"
}, {
name: "shipViaList",
kind: "XV.ShipViaList"
}, {
name: "shipZoneList",
kind: "XV.ShipZoneList"
}, {
name: "salesRepList",
kind: "XV.SalesRepList"
}, {
name: "taxAssignmentList",
kind: "XV.TaxAssignmentList"
}, {
name: "taxAuthorityList",
kind: "XV.TaxAuthorityList"
}, {
name: "taxCodeList",
kind: "XV.TaxCodeList"
}, {
name: "taxClassList",
kind: "XV.TaxClassList"
}, {
name: "taxRateList",
kind: "XV.TaxRateList"
}, {
name: "taxTypeList",
kind: "XV.TaxTypeList"
}, {
name: "taxZoneList",
kind: "XV.TaxZoneList"
}, {
name: "termsList",
kind: "XV.TermsList"
}, {
name: "customerGroupList",
kind: "XV.CustomerGroupList"
}, {
name: "freightClassList",
kind: "XV.FreightClassList"
}, {
name: "itemList",
kind: "XV.ItemList"
}, {
name: "itemGroupList",
kind: "XV.ItemGroupList"
}, {
name: "itemSiteList",
kind: "XV.ItemSiteList"
}, {
name: "costCategoryList",
kind: "XV.CostCategoryList"
}, {
name: "plannerCodeList",
kind: "XV.PlannerCodeList"
}, {
name: "customerTypeList",
kind: "XV.CustomerTypeList"
} ], XT.app.$.postbooks.appendPanels("setup", t), r = {
model: "XM.sales",
name: "_sales".loc(),
description: "_salesDescription".loc(),
workspace: "XV.SalesWorkspace"
}, i = new XM.ConfigurationModel(r), XM.configurations.add(i), e = {
name: "sales",
label: "_sales".loc(),
panels: [ {
name: "customerList",
kind: "XV.CustomerList"
}, {
name: "prospectList",
kind: "XV.ProspectList"
}, {
name: "quoteList",
kind: "XV.QuoteList"
}, {
name: "salesOrderList",
kind: "XV.SalesOrderList"
}, {
name: "sales_activityList",
kind: "XV.ActivityList"
} ]
}, s = XT.session.config.biAvailable && XT.session.privileges.get("ViewSalesHistory"), s && e.panels.push({
name: "salesAnalysisPage",
kind: "analysisFrame"
}), XT.app.$.postbooks.insertModule(e, 0), n = [ "AlterPackDate", "ConfigureSO", "ConfigureCC", "DeleteItemSites", "DeleteItemMasters", "MaintainBankAccounts", "MaintainCustomerGroups", "CreateSOForHoldCustomer", "CreateSOForWarnCustomer", "MaintainCostCategories", "MaintainCustomerEmailProfiles", "MaintainCustomerMasters", "MaintainCustomerTypes", "MaintainFreightClasses", "MaintainItemGroups", "MaintainItemMasters", "MaintainItemSites", "MaintainProspectMasters", "MaintainQuotes", "MaintainSalesEmailProfiles", "MaintainSalesOrders", "MaintainSalesReps", "MaintainShipVias", "MaintainShippingZones", "MaintainTaxAssignments", "MaintainTaxClasses", "MaintainTaxCodes", "MaintainTaxRates", "MaintainTaxReconciliations", "MaintainTaxRegistrations", "MaintainTaxTypes", "MaintainTaxZones", "MaintainTerms", "MaintainSaleTypes", "OverridePrice", "OverrideSODate", "OverrideTax", "ProcessCreditCards", "SelectBilling", "ShowMarginsOnSalesOrder", "UpdateCustomerCreditStatus", "ViewCosts", "ViewCustomerMasters", "ViewFreightClasses", "ViewCostCategories", "ViewCustomerGroups", "ViewCustomerTypes", "ViewItemMasters", "ViewItemSites", "ViewProspectMasters", "ViewQuotes", "ViewTaxAssignments", "ViewTaxClasses", "ViewTaxCodes", "ViewTaxRates", "ViewTaxReconciliations", "ViewTaxRegistrations", "ViewTaxTypes", "ViewTaxZones", "ViewSalesHistory", "ViewSalesOrders", "ViewSalesReps", "ViewSaleTypes", "ViewShipVias", "ViewShippingZones", "ViewTerms" ], XT.session.addRelevantPrivileges(e.name, n), enyo.kind({
name: "analysisFrame",
label: "_analysis".loc(),
tag: "iframe",
style: "border: none;",
attributes: {
src: ""
},
events: {
onMessage: ""
},
published: {
source: ""
},
create: function() {
this.inherited(arguments), XT.session.config.freeDemo && this.doMessage({
message: "_staleAnalysisWarning".loc()
});
var e, t = new enyo.Ajax({
url: XT.getOrganizationPath() + "/analysis",
handleAs: "text"
});
t.response(this, function(e, t) {
this.setSource(t);
}), t.error(this, function(e, t) {
console.log("There was a problem generating the iFrame");
}), t.go({
reportUrl: "content/saiku-ui/index.html?biplugin=true"
});
},
sourceChanged: function() {
this.inherited(arguments), this.setAttributes({
src: this.getSource()
});
}
});
};
})();
