
// core.js

(function() {
"use strict";
XT.extensions.oauth2 = {
setVersion: function() {
XT.setVersion("4.4.0", "oauth2");
}
};
})();

// oauth2.js

(function() {
"use strict";
XT.extensions.oauth2.initModels = function() {
XM.Oauth2client = XM.Model.extend({
recordType: "XM.Oauth2client",
autoFetchId: !0,
defaults: function() {
return {
isActive: !0
};
},
readOnlyAttributes: [ "clientID", "clientSecret", "issued", "organization" ],
bindEvents: function() {
XM.Model.prototype.bindEvents.apply(this, arguments), this.on("statusChange", this.statusDidChange);
},
statusDidChange: function() {
this.setReadOnly("clientType", this.getStatus() !== XM.Model.READY_NEW), this.getStatus() === XM.Model.READY_NEW && (this.set("clientID", XT.getOrganizationPath().substring(1) + "_" + XT.generateUUID()), this.set("clientSecret", XT.generateUUID()), this.set("issued", new Date));
},
save: function(e, t, n) {
if (_.isObject(e) || _.isEmpty(e)) n = t;
n = n ? _.clone(n) : {};
var r = n.success, i = this.getStatus(), s = this;
n.success = function(e, t, n) {
i === XM.Model.READY_NEW && s.get("clientType") === "jwt bearer" && window.open(XT.getOrganizationPath() + "/oauth/generate-key?id=" + s.id, "_newtab"), r && r(e, t, n);
};
if (_.isObject(e) || _.isEmpty(e)) t = n;
i === XM.Model.READY_NEW && s.get("clientType") === "jwt bearer" ? s.notify("_generatingPrivateKey".loc(), {
callback: function() {
XM.Model.prototype.save.call(s, e, t, n);
}
}) : XM.Model.prototype.save.call(this, e, t, n);
}
}), XM.Oauth2clientRedirs = XM.Model.extend({
recordType: "XM.Oauth2clientRedirs",
autoFetchId: !0
}), XM.Oauth2clientCollection = XM.Collection.extend({
model: XM.Oauth2client
}), XM.Oauth2clientRedirsCollection = XM.Collection.extend({
model: XM.Oauth2clientRedirs
});
};
})();

// static.js

(function() {
"use strict";
var e, t = [ {
id: "web server",
name: "_webServer".loc()
}, {
id: "jwt bearer",
name: "_serviceAccount".loc()
} ];
XM.Oauth2clientTypeModel = Backbone.Model.extend({}), XM.Oauth2clientTypeCollection = Backbone.Collection.extend({
model: XM.Oauth2clientTypeModel
}), XM.oauth2clientTypes = new XM.Oauth2clientTypeCollection;
for (e = 0; e < t.length; e++) {
var n = new XM.Oauth2clientTypeModel(t[e]);
XM.oauth2clientTypes.add(n);
}
})();

// picker.js

(function() {
"use strict";
XT.extensions.oauth2.initPickers = function() {
enyo.kind({
name: "XV.Oauth2clientTypePicker",
kind: "XV.PickerWidget",
collection: "XM.oauth2clientTypes"
});
};
})();

// list.js

(function() {
"use strict";
XT.extensions.oauth2.initList = function() {
enyo.kind({
name: "XV.Oauth2clientList",
kind: "XV.List",
label: "_oauth2Clients".loc(),
collection: "XM.Oauth2clientCollection",
query: {
orderBy: [ {
attribute: "id"
} ]
},
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListColumn",
classes: "short",
components: [ {
kind: "XV.ListAttr",
attr: "clientID",
isKey: !0
}, {
kind: "XV.ListAttr",
attr: "clientType"
} ]
}, {
kind: "XV.ListColumn",
classes: "last",
fit: !0,
components: [ {
kind: "XV.ListAttr",
attr: "clientName"
} ]
} ]
} ]
} ]
});
};
})();

// list_relations_editor_box.js

(function() {
"use strict";
XT.extensions.oauth2.initListRelationsEditorBox = function() {
enyo.kind({
name: "XV.Oauth2clientRedirectListRelations",
kind: "XV.ListRelations",
orderBy: [ {
attribute: "redirectURI"
} ],
parentKey: "clientID",
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListColumn",
classes: "first",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListAttr",
attr: "redirectURI"
} ]
} ]
} ]
} ]
} ]
}), enyo.kind({
name: "XV.Oauth2clientRedirectEditor",
kind: "XV.RelationsEditor",
components: [ {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.InputWidget",
attr: "redirectURI"
} ]
} ]
}), enyo.kind({
name: "XV.Oauth2clientRedirectBox",
kind: "XV.ListRelationsEditorBox",
title: "_redirects".loc(),
editor: "XV.Oauth2clientRedirectEditor",
parentKey: "clientID",
listRelations: "XV.Oauth2clientRedirectListRelations"
});
};
})();

// workspace.js

(function() {
XT.extensions.oauth2.initWorkspace = function() {
enyo.kind({
name: "XV.Oauth2clientWorkspace",
kind: "XV.Workspace",
title: "_oauth2Client".loc(),
model: "XM.Oauth2client",
components: [ {
kind: "Panels",
arrangerKind: "CarouselArranger",
fit: !0,
components: [ {
kind: "XV.Groupbox",
name: "mainPanel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_overview".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_id".loc()
}, {
kind: "XV.TextArea",
attr: "clientID",
classes: "xv-short-textarea"
}, {
kind: "onyx.GroupboxHeader",
content: "_secret".loc()
}, {
kind: "XV.TextArea",
attr: "clientSecret",
classes: "xv-short-textarea"
}, {
kind: "onyx.GroupboxHeader",
content: "_details".loc()
}, {
kind: "XV.InputWidget",
attr: "clientName",
label: "_name".loc()
}, {
kind: "XV.InputWidget",
attr: "clientEmail",
label: "_email".loc()
}, {
kind: "XV.InputWidget",
attr: "clientWebSite",
label: "_website".loc()
}, {
kind: "XV.InputWidget",
attr: "clientLogo",
label: "_logoURL".loc()
}, {
kind: "XV.Oauth2clientTypePicker",
attr: "clientType"
}, {
kind: "XV.CheckboxWidget",
attr: "isActive"
}, {
kind: "XV.DateWidget",
attr: "issued"
}, {
kind: "XV.InputWidget",
attr: "organization"
}, {
kind: "XV.CheckboxWidget",
name: "delegatedAccess",
attr: "delegatedAccess"
}, {
kind: "XV.InputWidget",
name: "clientX509PubCert",
attr: "clientX509PubCert",
label: "_x509PubCert".loc()
}, {
kind: "onyx.GroupboxHeader",
content: "_fullListUrl".loc()
}, {
kind: "XV.TextArea",
name: "fullListUrl",
classes: "xv-short-textarea",
disabled: !0
}, {
kind: "onyx.GroupboxHeader",
content: "_singleResourceUrl".loc()
}, {
kind: "XV.TextArea",
name: "singleResourceUrl",
classes: "xv-short-textarea",
disabled: !0
}, {
kind: "onyx.GroupboxHeader",
content: "_authURI".loc()
}, {
kind: "XV.TextArea",
name: "authURI",
classes: "xv-short-textarea",
disabled: !0
}, {
kind: "onyx.GroupboxHeader",
content: "_tokenURI".loc()
}, {
kind: "XV.TextArea",
name: "tokenURI",
classes: "xv-short-textarea",
disabled: !0
}, {
kind: "onyx.GroupboxHeader",
content: "_tokenRevocationURI".loc()
}, {
kind: "XV.TextArea",
name: "tokenRevocationURI",
classes: "xv-short-textarea",
disabled: !0
} ]
} ]
}, {
kind: "XV.Oauth2clientRedirectBox",
name: "redirectBox",
attr: "redirectURIs"
} ]
} ],
create: function() {
var e = XT.getBaseUrl() + XT.getOrganizationPath();
this.inherited(arguments), this.$.fullListUrl.setValue(e + "/discovery/v1alpha1/apis/v1alpha1/rest"), this.$.singleResourceUrl.setValue(e + "/discovery/v1alpha1/apis/:model/v1alpha1/rest"), this.$.authURI.setValue(e + "/dialog/authorize"), this.$.tokenURI.setValue(e + "/oauth/token"), this.$.tokenRevocationURI.setValue(e + "/oauth/revoke-token");
},
attributesChanged: function(e, t) {
this.inherited(arguments), this.$.delegatedAccess.setShowing(e.get("clientType") === "jwt bearer"), this.$.clientX509PubCert.setShowing(e.get("clientType") === "jwt bearer"), e.get("clientType") === "web server" ? this.$.redirectBox.applyStyle("visibility", "showing") : this.$.redirectBox.applyStyle("visibility", "hidden");
}
}), XV.registerModelWorkspace("XM.Oauth2client", "XV.Oauth2clientWorkspace");
};
})();

// postbooks.js

(function() {
"use strict";
XT.extensions.oauth2.initPostbooks = function() {
var e = {
name: "oauth2",
label: "_oauth2".loc(),
panels: [ {
name: "oauth2ClientList",
kind: "XV.Oauth2clientList"
} ]
};
XT.app.$.postbooks.insertModule(e, 2);
var t = [ "MaintainOauth2clients" ];
XT.session.addRelevantPrivileges(e.name, t);
};
})();
