
// core.js

(function() {
"use strict";
XT.extensions.purchasing = {
setVersion: function() {
XT.setVersion("", "purchasing");
}
};
})();

// error.js

(function() {
XT.extensions.purchasing.initErrors = function() {
var e = [ {
code: "pur1001",
messageKey: "_itemSourceItemInactive"
} ];
_.each(e, XT.Error.addError);
};
})();

// characteristic.js

(function() {
"use strict";
XT.extensions.purchasing.initCharacteristicModels = function() {
XM.Characteristic.prototype.augment({
contextAttributes: [ "isPurchaseOrders" ]
});
};
})();

// configure.js

(function() {
"use strict";
XT.extensions.purchasing.initSettings = function() {
XM.Purchasing = XM.Settings.extend({
recordType: "XM.Purchasing",
privileges: "ConfigurePO"
}), XM.purchasing = new XM.Purchasing;
};
})();

// item_site.js

(function() {
"use strict";
XT.extensions.purchasing.initItemSiteModels = function() {
XM.ItemSite.prototype.augment({
defaults: function() {
return {
isPurchased: !1
};
}
});
};
})();

// item_source.js

(function() {
"use strict";
XT.extensions.purchasing.initItemSourceModels = function() {
var e = function(e, t) {
var n = "quantityBreak", r = e.get(n), i = t.get(n);
return r !== i ? i > r ? 1 : -1 : 0;
};
XM.ItemSource = XM.Model.extend({
recordType: "XM.ItemSource",
defaults: function() {
return {
isActive: !0,
isDefault: !1,
effective: XT.date.startOfTime(),
expires: XT.date.endOfTime(),
leadTime: 0,
ranking: 1
};
},
handlers: {
"change:item change:vendor change:effective change:expires": "checkDuplicate",
"change:vendor": "vendorChanged",
"status:READY_CLEAN": "statusReadyClean"
},
nameAttribute: "vendorItemNumber",
readOnlyAttributes: [ "prices" ],
findPrice: function(t, n) {
n = n || {}, t = t || 0;
var r = this.get("prices"), i = r.comparator, s;
return r.comparator = e, r.sort(), s = _.find(r.models, function(e) {
var r = e.get("site");
return e.get("quantityBreak") <= t && (!r || r.id === n.id);
}), r.comparator = i, i && r.sort(), s;
},
calculatePrice: function(e, t) {
var n = this.get("item"), r = XM.ItemSourcePrice, i, s, o, u, a = 0;
i = this.findPrice(e, t);
if (i) switch (i.get("priceType")) {
case r.TYPE_NOMINAL:
a = i.get("price");
break;
case r.TYPE_DISCOUNT:
s = n.get("wholesalePrice"), o = this.get("percentDiscount"), u = this.get("fixedDiscount"), a = s - s * o - u;
}
return a >= 0 ? a : 0;
},
checkDuplicate: function(e) {
var t = this, n = this.get("item"), r = this.get("vendor"), i = this.get("effective"), s = this.get("expires"), o = {}, u;
if (!n || !r || !i || !s) {
typeof e == "function" && e.call(t);
return;
}
o.success = function(n) {
var r, i = {};
n ? (i.attr = "_item".loc() + " " + "_and".loc() + " " + "_vendor".loc(), i.value = [ t.getValue("item.number"), t.getValue("vendor.number") ], i.response = n, r = XT.Error.clone("xt1008", {
params: i
}), t.trigger("invalid", t, r, o), typeof e == "function" && e.call(t, r)) : typeof e == "function" && e.call(t);
}, o.error = function(n) {
console.log("Error searching for duplicate item source", n), typeof e == "function" && e.call(t, !0);
}, u = [ this.id, n.id, r.id, i, s ], this.dispatch("XM.ItemSource", "hasDuplicate", u, o);
},
statusReadyClean: function() {
this.setReadOnly([ "vendor", "item" ]), this.setReadOnly("prices", !1);
},
save: function(e, t, n) {
var r = this, i = XM.Model, s = this.getStatus(), o = function() {
XM.Model.prototype.save.call(this, e, t, n);
};
s === i.READY_NEW || this.get("effective") !== this.original("effective") || this.get("expires") !== this.original("expires") ? this.checkDuplicate(o) : o();
},
validate: function() {
var e = XM.Model.prototype.validate.apply(this, arguments), t = this.get("effective"), n = this.get("expires"), r = {};
return e || (XT.date.compare(t, n) > -1 ? (r.start = Globalize.format(t, "d"), r.end = Globalize.format(n, "d"), e = XT.Error.clone("xt2015", {
params: r
})) : this.get("isActive") && !this.getValue("item.isActive") && (e = XT.Error.clone("pur1001"))), e;
},
vendorChanged: function() {
this.setReadOnly("prices", !_.isObject(this.get("vendor")));
}
}), XM.ItemSourcePrice = XM.Model.extend({
recordType: "XM.ItemSourcePrice",
defaults: function() {
return {
currency: XT.baseCurrency(),
priceType: XM.ItemSourcePrice.TYPE_NOMINAL
};
},
handlers: {
"change:itemSource": "itemSourceChanged",
"change:priceType": "priceTypeChanged"
},
canView: function(e) {
var t = this.attributes ? this.get("priceType") === XM.ItemSourcePrice.TYPE_NOMINAL : !1;
return e === "price" ? t : e === "percentDiscount" || e === "fixedDiscount" ? !t : XM.Model.prototype.canView.apply(this, arguments);
},
itemSourceChanged: function() {
var e = this.get("itemSource"), t;
e && (t = e.getValue("vendor.currency") || XT.baseCurrency(), this.set("currency", t));
},
priceTypeChanged: function() {
var e = this.get("priceType"), t = e === XM.ItemSourcePrice.TYPE_NOMINAL;
t ? (this.unset("percentDiscount"), this.unset("fixedDiscount")) : this.unset("price");
}
}), _.extend(XM.ItemSourcePrice, {
TYPE_NOMINAL: "N",
TYPE_DISCOUNT: "D"
}), XM.ItemSourceManufacturer = XM.Model.extend({
recordType: "XM.ItemSourceManufacturer"
}), XM.ItemSourceCollection = XM.Collection.extend({
model: XM.ItemSource
}), XM.ItemSourceManufacturerCollection = XM.Collection.extend({
model: XM.ItemSourceManufacturer
});
};
})();

// purchase_order.js

(function() {
"use strict";
XT.extensions.purchasing.initPurchaseOrderModels = function() {
XM.PurchaseType = XM.Model.extend({
recordType: "XM.PurchaseType",
defaults: {
isActive: !0
}
}), XM.PurchaseTypeCharacteristic = XM.CharacteristicAssignment.extend({
recordType: "XM.PurchaseTypeCharacteristic",
which: "isPurchaseOrders"
}), XM.PurchaseTypeWorkflow = XM.WorkflowSource.extend({
recordType: "XM.PurchaseTypeWorkflow"
}), XM.PurchaseEmailProfile = XM.Model.extend({
recordType: "XM.PurchaseEmailProfile"
}), XM.PurchaseOrderMixin = {
formatStatus: function() {
var e = XM.PurchaseOrder, t = this.get("status");
switch (t) {
case e.UNRELEASED_STATUS:
return "_unreleased".loc();
case e.OPEN_STATUS:
return "_open".loc();
case e.CLOSED_STATUS:
return "_closed".loc();
}
}
}, XM.PurchaseOrder = XM.Document.extend({
recordType: "XM.PurchaseOrder",
documentKey: "number",
numberPolicySetting: "PONumberGeneration",
defaults: function() {
var e = XM.agents.find(function(e) {
return e.id === XM.currentUser.id;
});
return {
orderDate: XT.date.today(),
status: XM.PurchaseOrder.UNRELEASED_STATUS,
currency: XT.baseCurrency(),
site: XT.defaultSite(),
agent: e ? e.id : null
};
},
readOnlyAttributes: [ "freightSubtotal", "lineItems", "releaseDate", "subtotal", "taxTotal", "total" ],
handlers: {
"add:lineItems remove:lineItems": "lineItemsChanged",
"change:currency": "handleLineItems",
"change:freight": "calculateFreightTax",
"change:purchaseType": "purchaseTypeChanged",
"change:site": "siteChanged",
"change:status": "purchaseOrderStatusChanged",
"change:taxZone": "recalculateTaxes",
"change:vendor": "vendorChanged",
"change:vendorAddress": "vendorAddressChanged",
"status:READY_CLEAN": "statusReadyClean",
"status:READY_NEW": "statusReadyNew"
},
taxDetail: undefined,
freightTaxDetail: undefined,
calculateFreightTax: function() {
var e = this.get("freight"), t = _.where(_.pluck(XM.taxTypes.models, "attributes"), {
name: "Freight"
})[0], n = t.id, r = this.getValue("taxZone.id"), i = this.get("orderDate"), s = this.get("currency"), o = this, u = {}, a;
return i && s && e && (a = [ r, n, i, s.id, e ], u.success = function(e) {
o.freightTaxDetail = e, o.calculateTotals();
}, this.dispatch("XM.Tax", "taxDetail", a, u)), this;
},
calculateTotals: function() {
var e = this.get("freight") || 0, t = XT.MONEY_SCALE, n = XT.math.add, r = XT.math.subtract, i = [], s = [], o = [], u = [], a, f, l = 0, c, h, p = function(e) {
var t = e.get("extendedPrice") || 0, n = e.get("quantity") || 0, r = e.get("freight") || 0, o = e.get("item"), a = e.get("quantityUnitRatio");
i.push(t), u.push(r), s = s.concat(e.taxDetail);
};
_.each(this.get("lineItems").models, p), s = s.concat(this.freightTaxDetail), h = _.groupBy(s, function(e) {
return e.taxCode.id;
}), _.each(h, function(e) {
var r = [], i;
_.each(e, function(e) {
r.push(e.tax);
}), i = n(r, 6), l = n(l, i, t);
}), f = n(u, t), a = n(i, t), i = i.concat([ f, e, l ]), c = n(i, t), this.set("freightSubtotal", f), this.set("subtotal", a), this.set("taxTotal", l), this.set("total", c);
},
handleLineItems: function() {
var e = this.get("vendor"), t = this.get("currency"), n = this.get("site");
this.setReadOnly("lineItems", !e || !t || !n);
},
initialize: function(e, t) {
XM.Document.prototype.initialize.apply(this, arguments), XT.session.settings.get("RequirePOTax") && this.requiredAttributes.push("taxZone"), this.taxDetail = [], this.freightTaxDetail = [];
},
lineItemsChanged: function() {
if (!this.isReady()) return;
var e = this.get("lineItems").length > 0;
this.setReadOnly([ "vendor", "currency" ], e), this.setReadOnly("status", !e), e || this.set("status", XM.PurchaseOrder.UNRELEASED_STATUS), this.calculateTotals();
},
purchaseOrderStatusChanged: function() {
var e = this.get("status"), t = this.get("lineItems"), n = function(e) {
return e.get("received") + e.get("toReceive");
}, r = XM.Model, i = this, s, o, u;
if (e === XM.PurchaseOrder.UNRELEASED_STATUS && _.some(t.models, n)) {
u = "_transactedPoNotUnreleased".loc(), s = this.previous("status"), this.notify(u, {
type: r.CRITICAL,
callback: function() {
i.set("status", s);
}
});
return;
}
t.each(function(t) {
var n = t.get("quantity");
(e === XM.PurchaseOrder.CLOSED_STATUS || t.get("received") < n) && t.set("status", e);
});
},
purchaseTypeChanged: function() {
this.inheritWorkflowSource(this.get("purchaseType"), "XM.PurchaseOrderCharacteristic", "XM.PurchaseOrderWorkflow");
},
recalculateTaxes: function() {
_.each(this.get("lineItems").models, function(e) {
e.calculateTax();
}), this.calculateFreightTax();
},
siteChanged: function() {
var e = this.get("site"), t = e ? e.get("address") : !1, n = e ? e.get("contact") : !1, r = {
shiptoAddress: null,
shiptoAddress1: "",
shiptoAddress2: "",
shiptoAddress3: "",
shiptoCity: "",
shiptoState: "",
shiptoPostalCode: "",
shiptoCountry: "",
shiptoContact: null,
shiptoContactHonorific: "",
shiptoContactFirstName: "",
shiptoContactLastName: "",
shiptoContactMiddleName: "",
shiptoContactSuffix: "",
shiptoContactTitle: "",
shiptoContactPhone: "",
shiptoContactFax: "",
shiptoContactEmail: ""
};
t && (r.shiptoAddress = t, r.shiptoAddress1 = t.get("line1"), r.shiptoAddress2 = t.get("line2"), r.shiptoAddress3 = t.get("line3"), r.shiptoCity = t.get("city"), r.shiptoState = t.get("state"), r.shiptoPostalCode = t.get("postalCode"), r.shiptoCountry = t.get("country")), n && (r.shiptoContact = n, r.shiptoContactHonorific = n.get("honorific"), r.shiptoContactFirstName = n.get("firstName"), r.shiptoContactLastName = n.get("lastName"), r.shiptoContactMiddleName = n.get("middleName"), r.shiptoContactSuffix = n.get("suffix"), r.shiptoContactTitle = n.get("title"), r.shiptoContactPhone = n.get("phone"), r.shiptoContactFax = n.get("fax"), r.shiptoContactEmail = n.get("primaryEmail")), this.set(r), this.handleLineItems();
},
statusReadyClean: function() {
var e = this.get("status");
e === XM.PurchaseOrder.CLOSED_STATUS ? this.setReadOnly(!0) : (this.setReadOnly("lineItems", !1), this.setReadOnly([ "number", "orderDate", "site", "vendor" ]));
},
statusReadyNew: function() {
this.siteChanged();
},
validate: function() {
var e = XM.Document.prototype.validate.apply(this, arguments), t = this.get("lineItems"), n = this.get("status"), r = XM.PurchaseOrder, i;
if (!e && this.previousStatus() !== XM.Model.DESTROYED_DIRTY) {
i = _.filter(t.models, function(e) {
return e.previousStatus() !== r.DESTROYED_DIRTY;
});
if (!i.length) return XT.Error.clone("xt2012");
}
return n === r.UNRELEASED_STATUS && t.each(function(t) {
if (t.get("toReceive") || t.get("received") || t.get("vouchered")) e = XT.Error.clone("xt2025");
}), e;
},
vendorChanged: function() {
var e = this.get("vendor"), t = e ? e.get("vendorAddress") : !1, n = t ? t.getValue("address") : !1, r = e ? e.get("primaryContact") : !1, i = {
vendorAddress: null,
vendorCountry: ""
}, s = XM.Vendor, o;
e && (o = e.get("incotermsSource") === s.INCOTERMS_VENDOR ? e : this.get("site"), i.incoterms = o.get("incoterms"), i.currency = e.get("currency"), i.terms = e.get("terms"), i.taxZone = e.get("taxZone"), i.shipVia = e.get("shipVia"), i.vendorAddress = t), this.set(i), this.handleLineItems();
},
vendorAddressChanged: function() {
var e = this.get("vendorAddress"), t = e ? e.get("address") : !1, n = e ? e.get("contact") : !1, r = {
vendorAddress1: "",
vendorAddress2: "",
vendorAddress3: "",
vendorCity: "",
vendorState: "",
vendorPostalCode: "",
vendorCountry: "",
vendorContact: null,
vendorContactHonorific: "",
vendorContactFirstName: "",
vendorContactLastName: "",
vendorContactMiddleName: "",
vendorContactSuffix: "",
vendorContactTitle: "",
vendorContactPhone: "",
vendorContactFax: "",
vendorContactEmail: ""
};
t && (r.vendorAddress1 = t.get("line1"), r.vendorAddress2 = t.get("line2"), r.vendorAddress3 = t.get("line3"), r.vendorCity = t.get("city"), r.vendorState = t.get("state"), r.vendorPostalCode = t.get("postalCode"), r.vendorCountry = t.get("country")), n && (r.vendorContact = n, r.vendorContactHonorific = n.get("honorific"), r.vendorContactFirstName = n.get("firstName"), r.vendorContactLastName = n.get("lastName"), r.vendorContactMiddleName = n.get("middleName"), r.vendorContactSuffix = n.get("suffix"), r.vendorContactTitle = n.get("title"), r.vendorContactPhone = n.get("phone"), r.vendorContactFax = n.get("fax"), r.vendorContactEmail = n.get("primaryEmail")), this.set(r);
}
}), XM.PurchaseOrder = XM.PurchaseOrder.extend(XM.PurchaseOrderMixin), XM.PurchaseOrder = XM.PurchaseOrder.extend(XM.WorkflowMixin), XM.PurchaseOrder = XM.PurchaseOrder.extend(XM.EmailSendMixin), XM.PurchaseOrder = XM.PurchaseOrder.extend({
emailDocumentName: "_purchaseOrder".loc(),
emailProfileAttribute: "purchaseType.emailProfile",
emailStatusMethod: "formatStatus"
}), _.extend(XM.PurchaseOrder, {
used: function(e, t) {
return XM.ModelMixin.dispatch("XM.PurchaseOrder", "used", [ e ], t);
},
UNRELEASED_STATUS: "U",
OPEN_STATUS: "O",
CLOSED_STATUS: "C"
}), XM.PurchaseOrderCharacteristic = XM.CharacteristicAssignment.extend({
recordType: "XM.PurchaseOrderCharacteristic",
which: "isPurchaseOrders"
}), XM.PurchaseOrderComment = XM.Comment.extend({
recordType: "XM.PurchaseOrderComment",
sourceName: "P"
}), XM.PurchaseOrderWorkflow = XM.Workflow.extend({
recordType: "XM.PurchaseOrderWorkflow",
getPurchaseOrderWorkflowStatusString: function() {
return XM.PurchaseOrderWorkflow.prototype.getWorkflowStatusString.call(this);
}
}), _.extend(XM.PurchaseOrderWorkflow, {
TYPE_POST_RECEIPTS: "T",
TYPE_RECEIVE: "R",
TYPE_OTHER: "O"
}), XM.PurchaseOrderLine = XM.Model.extend({
recordType: "XM.PurchaseOrderLine",
defaults: function() {
return {
isMiscellaneous: !1,
received: 0,
toReceive: 0,
unitCost: 0,
status: XM.PurchaseOrder.UNRELEASED_STATUS,
vouchered: 0
};
},
readOnlyAttributes: [ "expenseCategory", "extendedPrice", "lineNumber", "received", "returned", "status", "tax", "toReceive", "unitCost", "vendorUnit", "vendorUnitRatio", "vouchered" ],
handlers: {
"change:dueDate": "dueDateChanged",
"change:expenseCategory": "isMiscellaneousChanged",
"change:extendedPrice change:freight change:taxType": "calculateTax",
"change:item": "itemChanged",
"change:itemSource": "itemSourceChanged",
"change:isMiscellaneous": "isMiscellaneousChanged",
"change:price": "priceChanged",
"change:purchaseOrder": "purchaseOrderChanged",
"change:site": "calculatePrice",
"change:quantity": "quantityChanged",
"status:READY_CLEAN": "statusReadyClean",
"status:DESTROYED_DIRTY": "statusDestroyedDirty"
},
taxDetail: null,
calculateExtendedPrice: function() {
var e = this.get("quantity") || 0, t = this.get("price") || 0, n = this.get("purchaseOrder"), r = this.get("extendedPrice"), i = e * t;
i !== r && (this.set("extendedPrice", e * t), n && n.calculateTotals());
},
calculatePrice: function() {
var e = this.get("itemSource"), t = this.get("item"), n = this.get("site"), r = this.get("quantity") || 0, i = this.get("price"), s = i || 0;
e && (s = e.calculatePrice(r, n)), s !== i && this.set("price", s);
},
calculateTax: function() {
var e = this.get("purchaseOrder"), t = this.get("extendedPrice"), n = this.get("freight"), r = this.getValue("taxType.id"), i, s, o, u = this, a = {}, f, l = 0, c = 0;
if (!e) return;
i = e.getValue("taxZone.id"), s = e.get("orderDate"), o = e.getValue("currency.id"), s && o && (t || n) ? (this.taxDetail = [], a.success = function(t) {
l--, u.taxDetail = u.taxDetail.concat(t), t.length && (c = XT.math.add(_.pluck(t, "tax"), 6)), l === 0 && (u.set("tax", XT.math.round(c, XT.PURCHASE_PRICE_SCALE)), e.calculateTotals());
}, t && l++, n && l++, t && (f = [ i, r, s, o, t ], this.dispatch("XM.Tax", "taxDetail", f, a)), n && (r = _.where(_.pluck(XM.taxTypes.models, "attributes"), {
name: "Freight"
})[0].id, f = [ i, r, s, o, n ], this.dispatch("XM.Tax", "taxDetail", f, a))) : this.set("tax", c);
},
dueDateChanged: function(e, t, n) {
n = n || {};
var r = this.get("itemSource"), i = this.get("dueDate"), s = this, o = XM.Model, u, a = n.success;
if (r && i) {
u = r.get("earliestDate");
if (XT.date.compareDate(i, u) < 0) {
this.notify("_correctToEarliestDate?".loc(), {
type: o.QUESTION,
callback: function(e) {
e.answer && s.set("dueDate", u), a && a(this, t, n);
}
});
return;
}
}
a && a(this, t, n);
},
destroy: function(e) {
var t = this.getParent().get("status"), n = XM.PurchaseOrder, r = this, i = {
type: n.QUESTION
}, s = arguments, o, u;
if (t === n.UNRELEASED_STATUS) {
u = function(e) {
e.answer && XM.Model.prototype.destroy.apply(r, s);
};
if (e.validate === !1) {
u({
answer: !0
});
return;
}
o = "_deleteLine?".loc();
} else {
if (t !== n.OPEN_STATUS) return;
u = function(t) {
t.answer && (r.set("status", n.CLOSED_STATUS), e && e.success && e.success(r, t, e));
};
if (e.validate === !1) {
u({
answer: !0
});
return;
}
o = "_closeLine?".loc();
}
i.callback = u, this.notify(o, i);
},
initialize: function(e, t) {
XM.Model.prototype.initialize.apply(this, arguments), XT.session.settings.get("RequireProjectAssignment") && this.requiredAttributes.push("project"), this.taxDetail = [];
},
isActive: function() {
return this.get("status") !== XM.PurchaseOrder.CLOSED_STATUS;
},
isMiscellaneousChanged: function() {
var e = this.get("isMiscellaneous");
e ? (this.unset("item"), this.unset("site")) : this.unset("expenseCategory"), this.setReadOnly("isMiscellaneous", !_.isNull(this.get("item")) || !_.isNull(this.get("expenseCategory"))), this.setReadOnly([ "item", "site" ], e), this.setReadOnly("expenseCategory", !e);
},
itemChanged: function() {
var e = this.get("item"), t = this.get("itemSource"), n = this.get("purchaseOrder"), r = n ? n.get("taxZone") : null, i = n ? n.get("orderDate") : !1, s = this.getValue("purchaseOrder.vendor"), o = this.get("characteristics"), u = XM.Model, a, f = this, l = {}, c = {}, h, p, d, v, m, g, y, b, w;
if (e && XT.session.settings.get("RequireStdCostForPOItem")) {
h = e.get("standardCost") || 0;
if (!h) {
g = "_errorStandardCostRequired".loc(), g = g.replace("{number}", e.get("number")), this.notify(g, {
type: u.CRITICAL,
callback: function() {
f.unset("item");
}
});
return;
}
}
this.isMiscellaneousChanged(), this.unset("taxType"), this.set("vendorUnit", e ? e.getValue("inventoryUnit.name") : ""), this.set("unitCost", e ? e.get("standardCost") : 0), e ? n && i && e && (!t || t.get("item").id !== e.id) && (this._isCount = this._isCount ? this._isCount + 1 : 1, y = this._isCount, v = new Date, v.setDate(i.getDate() + 1), l.query = {
parameters: [ {
attribute: "vendor",
value: s
}, {
attribute: "item",
value: e
}, {
attribute: "isActive",
value: !0
}, {
attribute: "effective",
operator: "<=",
value: i
}, {
attribute: "expires",
operator: ">=",
value: v
} ]
}, l.success = function() {
y === f._isCount && a.length && (f.off("change:price", f.priceChanged), f.set("itemSource", a.at(0)), f.calculateExtendedPrice(), f.on("change:price", f.priceChanged));
}, a = new XM.ItemSourceCollection, a.fetch(l)) : this.unset("itemSource"), l.success = function(e) {
var t = XM.taxTypes.get(e);
t ? f.set("taxType", t) : f.unset("taxType");
}, e.taxType(r, l), b = o.length;
for (w = 0; w < b; w++) o.at(0).destroy();
o.comparator || (o.comparator = function(e, t) {
var n = e.getValue("characteristic.order"), r = e.getValue("characteristic.name"), i = t.getValue("characteristic.order"), s = t.getValue("characteristic.name");
return n === i ? r === s ? 0 : r > s ? 1 : -1 : n > i ? 1 : -1;
}), p = _.pluck(e.get("characteristics").models, "attributes"), d = _.unique(_.pluck(p, "characteristic")), _.each(d, function(e) {
var t = new XM.PurchaseOrderLineCharacteristic(null, {
isNew: !0
}), n = _.find(p, function(t) {
return t.isDefault === !0 && t.characteristic.id === e.id;
});
t.set("characteristic", e), t.set("value", n ? n.value : ""), o.add(t);
});
},
itemSourceChanged: function() {
var e = this.get("itemSource"), t = this.get("item"), n = this.get("quantity"), r = this, i = {
vendorUnit: "",
vendorUnitRatio: 1
}, s, o;
e ? i = {
isMiscellaneous: !1,
item: e.get("item"),
vendorItemNumber: e.get("vendorItemNumber"),
vendorItemDescription: e.get("vendorItemDescription"),
vendorUnit: e.get("vendorUnit"),
vendorUnitRatio: e.get("vendorUnitRatio"),
manufacturerName: e.get("manufacturerName"),
manufacturerItemNumber: e.get("manufacturerItemNumber"),
manufacturerItemDescription: e.get("manufacturerItemDescription")
} : t && (i.vendorItemNumber = "", i.vendorItemDescription = "", i.manufacturerName = "", i.manufacturerItemNumber = "", i.manufacturerItemDescription = ""), this.set(i), e && (o = function() {
r.quantityChanged();
}, this.dueDateChanged(this, null, {
success: o
}));
},
priceChanged: function() {
var e = this.get("price"), t = this.get("item"), n = XM.Model, r = this, i, s, o, u;
this.calculateExtendedPrice(), t && _.isNumber(e) && (i = this.get("vendorUnitRatio") || 1, s = e / i, o = t.get("maximumDesiredCost"), o < s && (u = "_warnMaxCostExceeded".loc(), o = Globalize.format(o, "c" + XT.COST_SCALE), u = u.replace("{maximumDesiredCost}", o), this.notify(u, {
type: n.WARNING
})));
},
purchaseOrderChanged: function() {
var e = this.get("purchaseOrder"), t = this.get("lineNumber"), n = e ? e.get("currency") : !1, r = e ? e.get("status") : !1, i = this.get("site"), s, o;
if (!this.isReady()) return;
e && !t && (s = _.compact(_.map(e.get("lineItems").models, function(e) {
return e.isDestroyed() ? null : e.get("lineNumber");
})), o = s.length > 0 ? Math.max.apply(null, s) : 0, this.set("lineNumber", o + 1)), r && this.set("status", r), n && this.set("currency", n), i || this.set("site", e.get("site"));
},
quantityChanged: function() {
var e = this.get("itemSource"), t = this.get("quantity"), n = this, r = XM.Model, i, s, o;
e && t && (i = e.get("minimumOrderQuantity"), t < i ? this.notify("_correctToMinimumQuantity?".loc(), {
type: r.QUESTION,
callback: function(e) {
e.answer && n.set("quantity", i);
}
}) : (s = e.get("multipleOrderQuantity"), o = t / s, o !== Math.round(o) && this.notify("_correctToMultipleQuantity?".loc(), {
type: r.QUESTION,
callback: function(e) {
e.answer && (t = Math.ceil(o) * s, n.set("quantity", t));
}
}))), this.calculatePrice();
},
statusReadyClean: function() {
this.setReadOnly([ "isMiscellaneous", "item", "expenseCategory" ]);
},
statusDestroyedDirty: function() {
this.get("purchaseOrder").isDestroyed() || this.get("purchaseOrder").calculateTotals();
},
validate: function() {
var e = XM.Document.prototype.validate.apply(this, arguments), t = this.get("isMiscellaneous"), n = {};
if (t && !this.get("expenseCategory")) return n.attr = "_expenseCategory".loc(), XT.Error.clone("xt1004", {
params: n
});
if (!t) {
if (!this.get("item")) return n.attr = "_item".loc(), XT.Error.clone("xt1004", {
params: n
});
if (!this.get("site")) return n.attr = "_site".loc(), XT.Error.clone("xt1004", {
params: n
});
}
return e;
}
}), XM.PurchaseOrderLine = XM.PurchaseOrderLine.extend(XM.PurchaseOrderMixin), XM.PurchaseOrderLineCharacteristic = XM.CharacteristicAssignment.extend({
recordType: "XM.PurchaseOrderLineCharacteristic",
canView: function() {
return !0;
}
}), XM.PurchaseOrderLineComment = XM.Comment.extend({
recordType: "XM.PurchaseOrderLineComment",
sourceName: "PI"
});
var e = function(e, t, n) {
var r = this, i = {};
return n = n || [], n.unshift(this.id), i.success = function(e) {
var n = {};
n.success = function() {
t && t(e);
}, e && r.fetch(n);
}, i.error = function(e) {
t && t(e);
}, this.dispatch("XM.PurchaseOrder", e, n, i), this;
};
XM.PurchaseOrderListItem = XM.Info.extend({
recordType: "XM.PurchaseOrderListItem",
editableModel: "XM.PurchaseOrder",
canRelease: function(e) {
var t = this.get("status");
return e && e(t === XM.PurchaseOrder.UNRELEASED_STATUS), this;
},
canUnrelease: function(e) {
var t = this.get("status"), n = t === XM.PurchaseOrder.OPEN_STATUS, r = {}, i;
if (!n) return e && e(n), n;
i = [ this.id, !0 ], r.success = function(t) {
e && e(!t);
}, this.dispatch("XM.PurchaseOrder", "used", i, r);
},
doRelease: function(t) {
return e.call(this, "release", t);
},
doUnrelease: function(t) {
return e.call(this, "unrelease", t);
}
}), XM.PurchaseOrderCharacteristic = XM.Model.extend({
recordType: "XM.PurchaseOrderListItemCharacteristic"
}), XM.PurchaseOrderListItemCharacteristic = XM.Model.extend({
recordType: "XM.PurchaseOrderListItemCharacteristic"
}), XM.PurchaseOrderListItem = XM.PurchaseOrderListItem.extend(XM.PurchaseOrderMixin), XM.PurchaseOrderListItemCollection = XM.Collection.extend({
model: XM.PurchaseOrderListItem
}), XM.PurchaseTypeCollection = XM.Collection.extend({
model: XM.PurchaseType
}), XM.PurchaseEmailProfileCollection = XM.Collection.extend({
model: XM.PurchaseEmailProfile
});
};
})();

// vendor.js

(function() {
"use strict";
XT.extensions.purchasing.initVendorModels = function() {
XM.PurchaseVendorRelation = XM.Model.extend({
recordType: "XM.PurchaseVendorRelation"
}), XM.PurchaseVendorAddress = XM.Model.extend({
recordType: "XM.PurchaseVendorAddress"
}), XM.PurchaseVendorRelationCollection = XM.Collection.extend({
model: XM.PurchaseVendorRelation
});
};
})();

// static.js

(function() {
"use strict";
XT.extensions.purchasing.initStaticModels = function() {
var e = XM.ItemSourcePrice, t, n = [ {
id: e.TYPE_NOMINAL,
name: "_nominal".loc()
}, {
id: e.TYPE_DISCOUNT,
name: "_discount".loc()
} ];
XM.ItemSourcePriceTypeModel = Backbone.Model.extend({}), XM.ItemSourcePriceTypeCollection = Backbone.Collection.extend({
model: XM.ItemSourcePriceTypeModel
}), XM.itemSourcePriceTypes = new XM.ItemSourcePriceTypeCollection;
for (t = 0; t < n.length; t++) {
var r = new XM.ItemSourcePriceTypeModel(n[t]);
XM.itemSourcePriceTypes.add(r);
}
e = XM.PurchaseOrder;
var i = [ {
id: e.UNRELEASED_STATUS,
name: "_unreleased".loc()
}, {
id: e.OPEN_STATUS,
name: "_open".loc()
}, {
id: e.CLOSED_STATUS,
name: "_closed".loc()
} ];
XM.PurchaseOrderStatusModel = Backbone.Model.extend({}), XM.PurchaseOrderStatusCollection = Backbone.Collection.extend({
model: XM.PurchaseOrderStatusModel
}), XM.purchaseOrderStatuses = new XM.PurchaseOrderStatusCollection;
for (t = 0; t < i.length; t++) {
var s = new XM.PurchaseOrderStatusModel(i[t]);
XM.purchaseOrderStatuses.add(s);
}
e = XM.PurchaseOrderWorkflow;
var o = [ {
id: e.TYPE_OTHER,
name: "_other".loc()
} ];
XM.PurchaseOrderWorkflowTypeModel = Backbone.Model.extend({}), XM.PurchaseOrderWorkflowTypeCollection = Backbone.Collection.extend({
model: XM.PurchaseOrderWorkflowTypeModel
}), XM.purchaseOrderWorkflowTypes = new XM.PurchaseOrderWorkflowTypeCollection, _.each(o, function(e) {
XM.purchaseOrderWorkflowTypes.add(new XM.PurchaseOrderWorkflowTypeModel(e));
});
};
})();

// startup.js

(function() {
"use strict";
XT.extensions.purchasing.initStartup = function() {
XT.cacheCollection("XM.purchaseEmailProfiles", "XM.PurchaseEmailProfileCollection", "name"), XT.cacheCollection("XM.purchaseTypes", "XM.PurchaseTypeCollection", "code");
};
})();

// characteristics.js

(function() {
XT.extensions.purchasing.initCharacteristicWidgets = function() {
enyo.kind({
name: "XV.PurchaseOrderCharacteristicsWidget",
kind: "XV.CharacteristicsWidget",
model: "XM.PurchaseOrderCharacteristic",
which: "isPurchaseOrders"
}), enyo.kind({
name: "XV.PurchaseOrderLineCharacteristicsWidget",
kind: "XV.OrderCharacteristicsWidget",
parentKey: "purchaseOrderLine",
model: "XM.PurchaseOrderLineCharacteristic"
}), enyo.kind({
name: "XV.PurchaseTypeCharacteristicsWidget",
kind: "XV.CharacteristicsWidget",
model: "XM.PurchaseTypeCharacteristic",
which: "isPurchaseOrders"
});
};
})();

// parameter.js

(function() {
XT.extensions.purchasing.initParameters = function() {
XV.ActivityListParameters.prototype.activityTypes.purchasing = [ {
type: "PurchaseOrder",
label: "_orders".loc()
}, {
type: "PurchaseOrderWorkflow",
label: "_workflow".loc()
} ], enyo.kind({
name: "XV.ItemSourceListParameters",
kind: "XV.ParameterWidget",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_itemSource".loc()
}, {
name: "item",
label: "_item".loc(),
attr: "item",
defaultKind: "XV.ItemWidget"
}, {
name: "vendor",
label: "_vendor".loc(),
attr: "vendor",
defaultKind: "XV.VendorWidget"
}, {
kind: "onyx.GroupboxHeader",
content: "_show".loc()
}, {
name: "showInactive",
label: "_inactive".loc(),
attr: "isActive",
defaultKind: "XV.CheckboxWidget",
getParameter: function() {
var e;
return this.getValue() || (e = {
attribute: this.getAttr(),
value: !0
}), e;
}
}, {
name: "showFuture",
label: "_future".loc(),
attr: "effective",
defaultKind: "XV.CheckboxWidget",
getParameter: function() {
var e;
return this.getValue() || (e = {
attribute: this.getAttr(),
operator: "<=",
value: XT.date.today()
}), e;
}
}, {
name: "showExpired",
label: "_expired".loc(),
attr: "expires",
defaultKind: "XV.CheckboxWidget",
getParameter: function() {
var e, t = XT.date.today(), n = new Date;
return n.setDate(t.getDate() + 1), this.getValue() || (e = {
attribute: this.getAttr(),
operator: ">=",
value: n
}), e;
}
} ]
}), enyo.kind({
name: "XV.PurchaseOrderListParameters",
kind: "XV.ParameterWidget",
characteristicsRole: "isPurchaseOrders",
defaultParameters: function() {
return {
user: XM.currentUser,
isUnreleased: !0,
isOpen: !0
};
},
components: [ {
kind: "onyx.GroupboxHeader",
content: "_purchaseOrder".loc()
}, {
name: "number",
label: "_number".loc(),
attr: "number"
}, {
name: "vendor",
label: "_vendor".loc(),
attr: "vendor",
defaultKind: "XV.VendorWidget"
}, {
kind: "onyx.GroupboxHeader",
content: "_show".loc()
}, {
name: "isUnreleased",
label: "_unreleased".loc(),
defaultKind: "XV.CheckboxWidget"
}, {
name: "isOpen",
label: "_open".loc(),
defaultKind: "XV.CheckboxWidget"
}, {
name: "isClosed",
label: "_closed".loc(),
defaultKind: "XV.CheckboxWidget"
}, {
kind: "onyx.GroupboxHeader",
content: "_orderDate".loc()
}, {
name: "fromOrderDate",
label: "_fromDate".loc(),
attr: "orderDate",
operator: ">=",
filterLabel: "_from".loc() + " " + "_orderDate".loc() + " " + "_date".loc(),
defaultKind: "XV.DateWidget"
}, {
name: "toDueDate",
label: "_toDate".loc(),
attr: "orderDate",
operator: "<=",
filterLabel: "_to".loc() + " " + "_orderDate".loc() + " " + "_date".loc(),
defaultKind: "XV.DateWidget"
} ],
getParameters: function() {
var e = this.inherited(arguments), t = XM.PurchaseOrder, n = {}, r = [];
return this.$.isUnreleased.getValue() && r.push(t.UNRELEASED_STATUS), this.$.isOpen.getValue() && r.push(t.OPEN_STATUS), this.$.isClosed.getValue() && r.push(t.CLOSED_STATUS), r.length && (n.attribute = "status", n.operator = "ANY", n.value = r, e.push(n)), e;
}
});
};
})();

// picker.js

(function() {
XT.extensions.purchasing.initPickers = function() {
enyo.kind({
name: "XV.ItemSourcePriceTypePicker",
kind: "XV.PickerWidget",
collection: "XM.itemSourcePriceTypes",
valueAttribute: "id",
showNone: !1
}), enyo.kind({
name: "XV.PurchaseEmailProfilePicker",
kind: "XV.PickerWidget",
label: "_emailProfile".loc(),
collection: "XM.purchaseEmailProfiles"
}), enyo.kind({
name: "XV.PurchaseOrderStatusPicker",
kind: "XV.PickerWidget",
collection: "XM.purchaseOrderStatuses",
showNone: !1
}), enyo.kind({
name: "XV.PurchaseOrderWorkflowTypePicker",
kind: "XV.PickerWidget",
collection: "XM.purchaseOrderWorkflowTypes",
valueAttribute: "id",
showNone: !1
}), enyo.kind({
name: "XV.PurchaseTypePicker",
kind: "XV.PickerWidget",
collection: "XM.purchaseTypes",
nameAttribute: "code"
});
};
})();

// relation.js

(function() {
XT.extensions.purchasing.initRelationWidgets = function() {
enyo.kind({
name: "XV.ItemSourceWidget",
kind: "XV.RelationWidget",
label: "_itemSource".loc(),
collection: "XM.ItemSourceCollection",
list: "XV.ItemSourceList",
keyAttribute: "vendorItemNumber",
nameAttribute: "contract.number",
published: {
showDetail: !0,
vendorItemNumber: null
},
components: [ {
kind: "FittableColumns",
components: [ {
name: "label",
content: "",
fit: !0,
classes: "xv-flexible-label"
}, {
kind: "onyx.InputDecorator",
name: "decorator",
classes: "xv-input-decorator",
components: [ {
name: "input",
kind: "onyx.Input",
classes: "xv-subinput",
onkeyup: "keyUp",
onkeydown: "keyDown",
onblur: "receiveBlur",
onfocus: "receiveFocus"
}, {
kind: "onyx.MenuDecorator",
onSelect: "itemSelected",
components: [ {
kind: "onyx.IconButton",
classes: "icon-folder-open-alt"
}, {
name: "popupMenu",
floating: !0,
kind: "onyx.Menu",
components: [ {
kind: "XV.MenuItem",
name: "searchItem",
content: "_search".loc()
}, {
kind: "XV.MenuItem",
name: "openItem",
content: "_open".loc(),
disabled: !0
}, {
kind: "XV.MenuItem",
name: "newItem",
content: "_new".loc(),
disabled: !0
} ]
} ]
}, {
name: "completer",
kind: "XV.Completer",
onSelect: "itemSelected"
} ]
} ]
}, {
kind: "FittableColumns",
name: "detailColumns",
components: [ {
name: "labels",
classes: "xv-relationwidget-column left",
components: [ {
name: "contractLabel",
content: "_contract".loc() + ":",
classes: "xv-relationwidget-description label",
showing: !1
}, {
name: "minimumQtyLabel",
content: "_minimumOrderQuantity".loc() + ":",
classes: "xv-relationwidget-description label",
showing: !1
}, {
name: "multipleQtyLabel",
content: "_multipleOrderQuantity".loc() + ":",
classes: "xv-relationwidget-description label",
showing: !1
}, {
name: "earliestDateLabel",
content: "_earliestDate".loc() + ":",
classes: "xv-relationwidget-description label",
showing: !1
} ]
}, {
name: "data",
fit: !0,
components: [ {
name: "name",
classes: "xv-relationwidget-description hasLabel",
showing: !1
}, {
name: "description",
classes: "xv-relationwidget-description hasLabel",
showing: !1
}, {
name: "minimumQty",
classes: "xv-relationwidget-description hasLabel",
showing: !1
}, {
name: "multipleQty",
classes: "xv-relationwidget-description hasLabel",
showing: !1
}, {
name: "earliestDate",
classes: "xv-relationwidget-description hasLabel",
showing: !1
} ]
} ]
} ],
create: function() {
this.inherited(arguments), this.getShowDetail() || this.$.detailColumns.setStyle("display: none");
},
disabledChanged: function() {
this.inherited(arguments);
var e = this.getDisabled();
this.$.minimumQty.addRemoveClass("disabled", e), this.$.multipleQty.addRemoveClass("disabled", e), this.$.earliestDate.addRemoveClass("disabled", e);
},
setValue: function(t, n) {
n = n || {};
var r = this, i = t instanceof XM.ItemSource || _.isNull(t) ? t : t.itemSource, s = i ? i.id : null, o = this.value ? this.value.id : null, u = this.getVendorItemNumber(), a = this.getFirstKey(), f = this.getNameAttribute(), l = "", c = "", h = this._collection.model, p, d, v = function() {
i && s && (i.couldRead ? r.$.openItem.setDisabled(!i.couldRead()) : r.$.openItem.setDisabled(!i.getClass().canRead()));
};
t instanceof XM.ItemSource && !_.isNull(t) ? l = t.get("vendorItemNumber") : _.isObject(t) && (l = t.vendorItemNumber || "");
if (_.isString(i)) {
if (this.value === i || o === i) return;
p = _.isObject(i) ? i.id : i, d = new h, n = {
id: p,
success: function() {
r.setValue({
itemSource: d,
vendorItemNumber: d.get("vendorItemNumber")
});
},
error: function() {
XT.log("Error setting relational widget value");
}
}, d.fetch(n);
return;
}
this.value = i, i && i.getValue && (l = i.getValue(a) || "", c = i.getValue(f) || ""), this.setVendorItemNumber(l), this.$.input.setValue(l), this.$.name.setShowing(c), this.$.name.setContent(c), (s !== o || u !== l) && !n.silent && this.doValueChange({
originator: this,
value: {
itemSource: i,
vendorItemNumber: l
}
}), r.$.openItem.setShowing(!0), r.$.newItem.setShowing(!0), r.$.openItem.setDisabled(!0), r.$.newItem.setDisabled(e.apply(this) || this.disabled), h && v();
if (this.getShowDetail()) {
var m = i ? i.getValue("contract.number") : "", g = i ? i.get("minimumOrderQuantity") : 0, y = i ? i.get("multipleOrderQuantity") : 0, b = i ? XT.date.applyTimezoneOffset(i.get("earliestDate"), !0) : null, w = XT.QTY_SCALE;
this.$.contractLabel.setShowing(m), this.$.minimumQtyLabel.setShowing(g), this.$.minimumQty.setShowing(g), this.$.minimumQty.setContent(Globalize.format(g, "n" + w)), this.$.multipleQtyLabel.setShowing(y), this.$.multipleQty.setShowing(y), this.$.multipleQty.setContent(Globalize.format(y, "n" + w)), this.$.earliestDateLabel.setShowing(b), this.$.earliestDate.setShowing(b), this.$.earliestDate.setContent(Globalize.format(b, "d"));
}
},
_fetchSuccess: function() {
if (this._relationSelected) return;
var e = this._collection.length ? this._collection.models[0] : null, t = e ? e.get("vendorItemSource") : this.$.input.getValue(), n = enyo.dispatcher.captureTarget;
this.setValue({
itemSource: e,
vendorItemNumber: t
}), enyo.dispatcher.captureTarget = n;
}
});
var e = function() {
var e = this._Workspace, t = this._collection.model, n = !0;
return t && t.couldCreate ? n = !t.couldCreate() : t && (n = !t.canCreate()), n;
};
enyo.kind({
name: "XV.PurchaseVendorWidget",
kind: "XV.VendorWidget",
collection: "XM.PurchaseVendorRelationCollection"
}), enyo.kind({
name: "XV.VendorAddressWidget",
kind: "XV.RelationWidget",
collection: "XM.VendorAddressRelationCollection",
list: "XV.VendorAddressList",
keyAttribute: "code",
nameAttribute: ""
});
};
})();

// comment_box.js

(function() {
XT.extensions.purchasing.initCommentBox = function() {
enyo.kind({
name: "XV.PurchaseOrderCommentBox",
kind: "XV.CommentBox",
model: "XM.PurchaseOrderComment"
}), enyo.kind({
name: "XV.PurchaseOrderLineCommentBox",
kind: "XV.CommentBox",
model: "XM.PurchaseOrderLineComment"
});
};
})();

// list.js

(function() {
XT.extensions.purchasing.initLists = function() {
enyo.kind({
name: "XV.ItemSourceList",
kind: "XV.List",
label: "_itemSources".loc(),
collection: "XM.ItemSourceCollection",
query: {
orderBy: [ {
attribute: "vendorItemNumber"
}, {
attribute: "vendor.name"
} ]
},
parameterWidget: "XV.ItemSourceListParameters",
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListColumn",
classes: "name-column",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListAttr",
attr: "vendorItemNumber",
isKey: !0,
placeholder: "_noVendorNumber".loc()
} ]
}, {
kind: "XV.ListAttr",
attr: "vendor.name"
} ]
}, {
kind: "XV.ListColumn",
classes: "right-column",
components: [ {
kind: "XV.ListAttr",
attr: "vendorUnit"
}, {
kind: "XV.ListAttr",
attr: "isDefault",
formatter: "formatDefault"
} ]
}, {
kind: "XV.ListColumn",
classes: "first",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListAttr",
attr: "item.number",
classes: "italic"
}, {
kind: "XV.ListAttr",
attr: "item.inventoryUnit.name",
fit: !0,
classes: "right"
} ]
}, {
kind: "XV.ListAttr",
formatter: "formatDescription"
} ]
}, {
kind: "XV.ListColumn",
classes: "last",
components: [ {
kind: "XV.ListAttr",
attr: "effective"
}, {
kind: "XV.ListAttr",
attr: "expires"
} ]
} ]
} ]
} ],
formatDefault: function(e) {
return e ? "_default".loc() : "";
},
formatDescription: function(e, t, n) {
var r = n.get("item"), i = r.get("description1") || "", s = r.get("description2") || "", o = s ? " - " : "";
return i + o + s;
}
}), XV.registerModelList("XM.ItemSource", "XV.ItemSourceList"), enyo.kind({
name: "XV.PurchaseEmailProfileList",
kind: "XV.EmailProfileList",
label: "_purchaseEmailProfiles".loc(),
collection: "XM.PurchaseEmailProfileCollection"
}), enyo.kind({
name: "XV.PurchaseOrderList",
kind: "XV.List",
label: "_purchaseOrders".loc(),
collection: "XM.PurchaseOrderListItemCollection",
parameterWidget: "XV.PurchaseOrderListParameters",
multiSelect: !0,
actions: [ {
name: "release",
privilege: "ReleasePurchaseOrders",
prerequisite: "canRelease",
method: "doRelease",
notify: !1
}, {
name: "unrelease",
privilege: "ReleasePurchaseOrders",
prerequisite: "canUnrelease",
method: "doUnrelease",
notify: !1
}, {
name: "print",
privilege: "ViewPurchaseOrders",
method: "doPrint",
isViewMethod: !0
}, {
name: "email",
privilege: "ViewPurchaseOrders",
method: "doEmail",
isViewMethod: !0
} ],
query: {
orderBy: [ {
attribute: "number"
} ]
},
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListColumn",
classes: "first",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListAttr",
attr: "number",
isKey: !0,
fit: !0
}, {
kind: "XV.ListAttr",
attr: "formatStatus",
style: "padding-left: 24px"
}, {
kind: "XV.ListAttr",
attr: "orderDate",
classes: "right"
} ]
}, {
kind: "FittableColumns",
components: [ {
kind: "XV.ListAttr",
attr: "vendor.name"
}, {
kind: "XV.ListAttr",
attr: "total",
formatter: "formatTotal",
classes: "right"
} ]
} ]
}, {
kind: "XV.ListColumn",
classes: "last",
components: [ {
kind: "XV.ListAttr",
attr: "site.code"
}, {
kind: "XV.ListAttr",
formatter: "formatShipto"
} ]
} ]
} ]
} ],
formatTotal: function(e, t, n) {
var r = n ? n.get("currency") : !1, i = XT.locale.moneyScale;
return r ? r.format(e, i) : "";
},
formatShipto: function(e, t, n) {
var r = n.get("shiptoCity"), i = n.get("shiptoState"), s = n.get("shiptoCountry");
return XM.Address.formatShort(r, i, s);
}
}), enyo.kind({
name: "XV.PurchaseTypeList",
kind: "XV.List",
label: "_purchaseTypes".loc(),
collection: "XM.PurchaseTypeCollection",
query: {
orderBy: [ {
attribute: "code"
} ]
},
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListColumn",
classes: "short",
components: [ {
kind: "XV.ListAttr",
attr: "code",
isKey: !0
} ]
}, {
kind: "XV.ListColumn",
classes: "last",
fit: !0,
components: [ {
kind: "XV.ListAttr",
attr: "description"
} ]
} ]
} ]
} ]
});
};
})();

// list_relations.js

(function() {
XT.extensions.purchasing.initListRelations = function() {
enyo.kind({
name: "XV.ItemSourcePriceListRelations",
kind: "XV.ListRelations",
parentKey: "itemSource",
orderBy: [ {
attribute: "quantityBreak"
} ],
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListColumn",
classes: "first",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListAttr",
attr: "quantityBreak"
}, {
kind: "XV.ListAttr",
formatter: "formatUnit"
}, {
kind: "XV.ListAttr",
attr: "site.code",
classes: "right"
} ]
}, {
kind: "FittableColumns",
components: [ {
kind: "XV.ListAttr",
attr: "priceType",
formatter: "formatPriceType"
}, {
kind: "XV.ListAttr",
formatter: "formatValue"
} ]
} ]
} ]
} ]
} ],
formatPriceType: function(e) {
return e === XM.ItemSourcePrice.TYPE_NOMINAL ? "_nominal".loc() : "_discount".loc();
},
formatUnit: function(e, t, n) {
return n.getValue("itemSource.vendorUnit");
},
formatValue: function(e, t, n) {
var r = n.get("priceType"), i = n.get("currency"), s = n.get("percentDiscount"), o = n.get("fixedDiscount"), u = n.getValue("itemSource.item.wholesalePrice"), a = XT.locale.purchasePriceScale, f = XT.locale.percentScale;
return r === XM.ItemSourcePrice.TYPE_NOMINAL ? e = i.format(n.get("price"), a) : o && s ? e = Globalize.format(s, "p" + f) + " " + i.format(o, a) : s ? e = Globalize.format(s, "p" + f) : e = i.format(o, a), e;
}
}), enyo.kind({
name: "XV.PurchaseOrderWorkflowListRelations",
kind: "XV.WorkflowListRelations",
parentKey: "purchaseOrder"
}), enyo.kind({
name: "XV.PurchaseOrderLineListRelations",
kind: "XV.ListRelations",
parentKey: "purchaseOrder",
orderBy: [ {
attribute: "lineNumber"
} ],
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListColumn",
classes: "second",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListAttr",
attr: "lineNumber",
classes: "bold"
}, {
kind: "XV.ListAttr",
attr: "item.number",
fit: !0
} ]
}, {
kind: "XV.ListAttr",
attr: "item.description1",
fit: !0,
style: "text-indent: 18px;"
}, {
kind: "XV.ListAttr",
attr: "site.code",
style: "text-indent: 18px;"
} ]
}, {
kind: "XV.ListColumn",
classes: "money",
components: [ {
kind: "XV.ListAttr",
attr: "quantity",
style: "text-align: right"
}, {
kind: "XV.ListAttr",
attr: "vendorUnit",
style: "text-align: right"
}, {
kind: "XV.ListAttr",
attr: "dueDate",
style: "text-align: right"
} ]
}, {
kind: "XV.ListColumn",
classes: "money",
components: [ {
kind: "XV.ListAttr",
attr: "price",
style: "text-align: right"
}, {
kind: "XV.ListAttr",
attr: "extendedPrice",
style: "text-align: right"
} ]
}, {
kind: "XV.ListColumn",
classes: "second",
components: [ {
kind: "XV.ListAttr",
attr: "vendorItemNumber",
placeholder: "_noVendorNumber".loc()
}, {
kind: "XV.ListAttr",
attr: "manufacturerItemNumber",
placeholder: "_noManufacturerNumber".loc()
}, {
kind: "XV.ListAttr",
attr: "project.number",
placeholder: "_noProject".loc()
} ]
}, {
kind: "XV.ListColumn",
classes: "money",
components: [ {
kind: "XV.ListAttr",
attr: "received"
}, {
kind: "XV.ListAttr",
attr: "vouchered"
}, {
kind: "XV.ListAttr",
attr: "formatStatus"
} ]
} ]
} ]
} ]
}), enyo.kind({
name: "XV.PurchaseTypeWorkflowListRelations",
kind: "XV.WorkflowListRelations",
parentKey: "purchaseType"
});
};
})();

// list_relations_editor_box.js

(function() {
XT.extensions.purchasing.initListRelationsEditorBox = function() {
enyo.kind({
name: "XV.ItemSourcePriceEditor",
kind: "XV.RelationsEditor",
components: [ {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.QuantityWidget",
attr: "quantityBreak"
}, {
kind: "XV.SitePicker",
attr: "site",
showNone: !0,
noneText: "_any".loc()
}, {
kind: "XV.ItemSourcePriceTypePicker",
attr: "priceType"
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "price",
currency: "currency"
},
label: "_price".loc(),
currencyShowing: !0,
scale: XT.PURCHASE_PRICE_SCALE,
currencyDisabled: !1
}, {
kind: "XV.PercentWidget",
attr: "percentDiscount",
label: "percent".loc()
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "fixedDiscount",
currency: "currency"
},
label: "_fixed".loc(),
currencyShowing: !0,
scale: XT.PURCHASE_PRICE_SCALE,
currencyDisabled: !1
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "itemSource.item.wholesalePrice"
},
label: "_wholesalePrice".loc(),
currencyShowing: !0,
currencyDisabled: !0
} ]
} ]
}), enyo.kind({
name: "XV.ItemSourcePriceBox",
kind: "XV.ListRelationsEditorBox",
title: "_prices".loc(),
editor: "XV.ItemSourcePriceEditor",
parentKey: "itemSource",
listRelations: "XV.ItemSourcePriceListRelations",
fitButtons: !1
}), XV.PurchaseOrderLineMixin = {
setValue: function(e) {
XV.RelationsEditor.prototype.setValue.apply(this, arguments);
var t = XM.Item, n = {
attribute: "item.itemType",
operator: "ANY",
value: [ t.PURCHASED, t.OUTSIDE_PROCESS, t.TOOLING, t.MANUFACTURED ]
}, r = this.$.itemSourceWidget, i, s, o, u, a;
this.value && (i = e.getParent(), s = i ? i.get("site") : !1, o = this.$.itemSiteWidget.getSite(), s && !o && this.$.itemSiteWidget.setSite(s), u = i ? i.get("vendor") : !1, u && (a = u ? u.get("itemSourceRequired") : !1, n = {
attribute: "vendor",
value: u.id
}, this.changeItemSiteParameter("vendor", "vendor", a), r && r.addParameter(n)), n = {
attribute: "item.itemType",
operator: "ANY",
value: [ t.PURCHASED, t.OUTSIDE_PROCESS, t.TOOLING, t.MANUFACTURED ]
}, a ? this.$.itemSiteWidget.removeParameter(n) : this.$.itemSiteWidget.addParameter(n));
},
changeItemSiteParameter: XV.LineMixin.changeItemSiteParameter
};
var e = {
name: "XV.PurchaseOrderLineEditor",
kind: "XV.RelationsEditor",
components: [ {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.InputWidget",
attr: "lineNumber"
}, {
kind: "XV.CheckboxWidget",
attr: "isMisc"
}, {
kind: "XV.ItemSiteWidget",
attr: {
item: "item",
site: "site"
},
query: {
parameters: [ {
attribute: "isActive",
value: !0
} ]
}
}, {
kind: "XV.ExpenseCategoryWidget",
attr: "expenseCategory"
}, {
kind: "XV.QuantityWidget",
attr: "quantity",
label: "_ordered".loc()
}, {
kind: "onyx.GroupboxHeader",
content: "_schedule".loc()
}, {
kind: "XV.DateWidget",
attr: "dueDate"
}, {
kind: "onyx.GroupboxHeader",
content: "_price".loc()
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "price",
currency: "currency"
},
scale: XT.PURCHASE_PRICE_SCALE,
label: "_unitPrice".loc(),
currencyShowing: !0,
currencyDisabled: !0
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "extendedPrice",
currency: "currency"
},
label: "_extendedPrice".loc(),
currencyShowing: !0,
currencyDisabled: !0
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "freight",
currency: "currency"
},
label: "_extendedPrice".loc(),
currencyShowing: !0,
currencyDisabled: !0
}, {
kind: "onyx.GroupboxHeader",
content: "_tax".loc()
}, {
kind: "XV.TaxTypePicker",
attr: "taxType"
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "tax",
currency: "currency"
},
scale: XT.PURCHASE_PRICE_SCALE,
label: "_extendedPrice".loc(),
currencyShowing: !0,
currencyDisabled: !0
}, {
kind: "onyx.GroupboxHeader",
content: "_notes".loc()
}, {
kind: "XV.TextArea",
attr: "notes",
fit: !0
} ]
} ]
};
enyo.mixin(e, XV.PurchaseOrderLineMixin), enyo.kind(e), enyo.kind({
name: "XV.PurchaseOrderLineBox",
kind: "XV.ListRelationsEditorBox",
classes: "xv-list-relations-box",
title: "_lines".loc(),
editor: "XV.PurchaseOrderLineEditor",
parentKey: "purchaseOrder",
listRelations: "XV.PurchaseOrderLineListRelations",
fitButtons: !1
}), enyo.kind({
name: "XV.PurchaseOrderWorkflowEditor",
kind: "XV.RelationsEditor",
components: [ {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.InputWidget",
attr: "name"
}, {
kind: "XV.InputWidget",
attr: "description"
}, {
kind: "XV.WorkflowStatusPicker",
attr: "status"
}, {
kind: "XV.PriorityPicker",
attr: "priority",
showNone: !1
}, {
kind: "XV.NumberSpinnerWidget",
attr: "sequence"
}, {
kind: "onyx.GroupboxHeader",
content: "_schedule".loc()
}, {
kind: "XV.DateWidget",
attr: "dueDate"
}, {
kind: "XV.DateWidget",
attr: "startDate"
}, {
kind: "XV.DateWidget",
attr: "assignDate"
}, {
kind: "XV.DateWidget",
attr: "completeDate"
}, {
kind: "onyx.GroupboxHeader",
content: "_userAccounts".loc()
}, {
kind: "XV.UserAccountWidget",
attr: "owner"
}, {
kind: "XV.UserAccountWidget",
attr: "assignedTo"
}, {
kind: "onyx.GroupboxHeader",
content: "_onCompletion".loc()
}, {
kind: "XV.PurchaseOrderStatusPicker",
attr: "completedParentStatus",
noneText: "_noChange".loc(),
label: "_nextStatus".loc()
}, {
kind: "XV.DependenciesWidget",
attr: {
workflow: "parent.workflow",
successors: "completedSuccessors"
}
}, {
kind: "onyx.GroupboxHeader",
content: "_onDeferred".loc()
}, {
kind: "XV.PurchaseOrderStatusPicker",
attr: "deferredParentStatus",
noneText: "_noChange".loc(),
label: "_nextStatus".loc()
}, {
kind: "XV.DependenciesWidget",
attr: {
workflow: "parent.workflow",
successors: "deferredSuccessors"
}
}, {
kind: "onyx.GroupboxHeader",
content: "_notes".loc()
}, {
kind: "XV.TextArea",
attr: "notes",
fit: !0
} ]
} ]
}), enyo.kind({
name: "XV.PurchaseOrderWorkflowBox",
kind: "XV.ListRelationsEditorBox",
title: "_workflow".loc(),
editor: "XV.PurchaseOrderWorkflowEditor",
parentKey: "purchaseOrder",
listRelations: "XV.PurchaseOrderWorkflowListRelations",
fitButtons: !1
}), enyo.kind({
name: "XV.PurchaseTypeWorkflowEditor",
kind: "XV.RelationsEditor",
components: [ {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.InputWidget",
attr: "name"
}, {
kind: "XV.InputWidget",
attr: "description"
}, {
kind: "XV.WorkflowStatusPicker",
attr: "status"
}, {
kind: "XV.PurchaseOrderWorkflowTypePicker",
attr: "workflowType",
label: "_type".loc()
}, {
kind: "XV.PriorityPicker",
attr: "priority",
showNone: !1
}, {
kind: "XV.NumberSpinnerWidget",
attr: "sequence"
}, {
kind: "onyx.GroupboxHeader",
content: "_startDate".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "startSet"
}, {
kind: "XV.NumberSpinnerWidget",
attr: "startOffset"
}, {
kind: "onyx.GroupboxHeader",
content: "_dueDate".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "dueSet"
}, {
kind: "XV.NumberSpinnerWidget",
attr: "dueOffset"
}, {
kind: "onyx.GroupboxHeader",
content: "_userAccounts".loc()
}, {
kind: "XV.UserAccountWidget",
attr: "owner"
}, {
kind: "XV.UserAccountWidget",
attr: "assignedTo"
}, {
kind: "onyx.GroupboxHeader",
content: "_onCompletion".loc()
}, {
kind: "XV.PurchaseOrderStatusPicker",
attr: "completedParentStatus",
noneText: "_noChange".loc(),
label: "_nextStatus".loc(),
showNone: !0
}, {
kind: "XV.DependenciesWidget",
attr: {
workflow: "parent.workflow",
successors: "completedSuccessors"
}
}, {
kind: "onyx.GroupboxHeader",
content: "_onDeferred".loc()
}, {
kind: "XV.PurchaseOrderStatusPicker",
attr: "deferredParentStatus",
noneText: "_noChange".loc(),
label: "_nextStatus".loc(),
showNone: !0
}, {
kind: "XV.DependenciesWidget",
attr: {
workflow: "parent.workflow",
successors: "deferredSuccessors"
}
}, {
kind: "onyx.GroupboxHeader",
content: "_notes".loc()
}, {
kind: "XV.TextArea",
attr: "notes",
fit: !0
} ]
} ]
}), enyo.kind({
name: "XV.PurchaseTypeWorkflowBox",
kind: "XV.ListRelationsEditorBox",
title: "_workflow".loc(),
editor: "XV.PurchaseTypeWorkflowEditor",
parentKey: "purchaseType",
listRelations: "XV.PurchaseTypeWorkflowListRelations",
fitButtons: !1
}), enyo.kind({
name: "XV.PurchaseOrderSummaryPanel",
classes: "xv-sales-summary-panel",
kind: "XV.RelationsEditor",
style: "margin-top: 10px;",
components: [ {
kind: "XV.Groupbox",
name: "totalGroup",
classes: "xv-sales-summary-total-group",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_summary".loc()
}, {
kind: "FittableColumns",
name: "totalBox",
classes: "xv-totals-panel",
components: [ {
kind: "FittableRows",
name: "summaryColumnOne",
components: [ {
kind: "XV.CurrencyPicker",
attr: "currency"
} ]
}, {
kind: "FittableRows",
name: "summaryColumnTwo",
components: [ {
kind: "XV.MoneyWidget",
attr: {
localValue: "subtotal",
currency: "currency"
},
label: "_subtotal".loc(),
currencyShowing: !1
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "freightSubtotal",
currency: "currency"
},
label: "_freightSubtotal".loc(),
currencyShowing: !1
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "freight",
currency: "currency"
},
label: "_freight".loc(),
currencyShowing: !1
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "taxTotal",
currency: "currency"
},
label: "_tax".loc(),
currencyShowing: !1
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "total",
currency: "currency"
},
label: "_total".loc(),
currencyShowing: !1
} ]
} ]
} ]
} ]
});
};
})();

// grid_box.js

(function() {
XT.extensions.purchasing.initGridBox = function() {
enyo.kind({
name: "XV.PurchaseOrderLineRow",
kind: "XV.GridRow",
formatDescription: function(e, t, n) {
var r = n.get("item"), i = n.get("expenseCategory");
return r ? r.get("description1") : i ? i.get("description") : "";
},
formatNumber: function(e, t, n) {
var r = n.get("item"), i = n.get("expenseCategory");
return r ? r.get("number") : i ? i.get("code") : "";
},
formatSite: function(e, t, n) {
var r = n.get("site"), i = n.get("expenseCategory");
return r ? r.get("code") : i ? "(" + "_miscellaneous".loc() + ")" : "";
}
}), enyo.kind({
name: "XV.PurchaseOrderLineGridBox",
kind: "XV.GridBox",
classes: "large-panel",
title: "_lineItems".loc(),
gridRowKind: "XV.PurchaseOrderLineRow",
editorMixin: XV.PurchaseOrderLineMixin,
workspace: "XV.PurchaseOrderLineWorkspace",
summary: "XV.PurchaseOrderSummaryPanel",
parentKey: "purchaseOrder",
orderBy: [ {
attribute: "lineNumber"
} ],
columns: [ {
classes: "line-number",
header: "#",
rows: [ {
readOnlyAttr: "lineNumber",
editor: {
kind: "XV.NumberWidget",
attr: "lineNumber"
}
} ]
}, {
classes: "grid-item",
header: "_item".loc(),
rows: [ {
formatter: "formatNumber",
editor: {
kind: "XV.ItemSiteWidget",
attr: {
item: "item",
site: "site"
},
name: "itemSiteWidget",
query: {
parameters: [ {
attribute: "isActive",
value: !0
} ]
}
}
}, {
formatter: "formatDescription"
}, {
formatter: "formatSite"
} ]
}, {
classes: "quantity",
header: [ "_quantity".loc(), "_unit".loc(), "_dueDate".loc() ],
rows: [ {
readOnlyAttr: "quantity",
editor: {
kind: "XV.QuantityWidget",
attr: "quantity",
name: "quantityWidget"
}
}, {
readOnlyAttr: "vendorUnit",
placeholder: "_na".loc(),
editor: {
kind: "XV.InputWidget",
attr: "vendorUnit"
}
}, {
readOnlyAttr: "dueDate",
editor: {
kind: "XV.DateWidget",
attr: "dueDate"
}
} ]
}, {
classes: "price",
header: [ "_price".loc(), "_extended".loc() ],
rows: [ {
readOnlyAttr: "price",
editor: {
kind: "XV.MoneyWidget",
attr: {
localValue: "price",
currency: "currency"
},
currencyDisabled: !0,
currencyShowing: !1,
scale: XT.PURCHASE_PRICE_SCALE
}
}, {
readOnlyAttr: "extendedPrice",
editor: {
kind: "XV.MoneyWidget",
attr: {
localValue: "extendedPrice",
currency: "currency"
},
currencyDisabled: !0,
currencyShowing: !1,
scale: XT.EXTENDED_PRICE_SCALE
}
} ]
}, {
classes: "grid-item",
header: [ "_vendorItem".loc(), "_manufacturerItem".loc(), "_project".loc() ],
rows: [ {
readOnlyAttr: "vendorItemNumber",
placeholder: "_noVendorNumber".loc(),
editor: {
kind: "XV.ItemSourceWidget",
showDetail: !1,
attr: {
itemSource: "itemSource",
vendorItemNumber: "vendorItemNumber"
}
}
}, {
readOnlyAttr: "manufacturerItemNumber",
placeholder: "_noManufacturerNumber".loc(),
editor: {
kind: "XV.InputWidget",
attr: "manufacturerItemNumber"
}
}, {
readOnlyAttr: "project.number",
placeholder: "_noProject".loc(),
editor: {
kind: "XV.ProjectWidget",
attr: "project"
}
} ]
}, {
classes: "date",
header: [ "_received".loc(), "_vouchered".loc(), "_status".loc() ],
rows: [ {
readOnlyAttr: "received",
editor: {
kind: "XV.QuantityWidget",
attr: "received",
name: "shippedWidget"
}
}, {
readOnlyAttr: "vouchered",
editor: {
kind: "XV.QuantityWidget",
attr: "vouchered",
name: "voucheredWidget"
}
}, {
readOnlyAttr: "formatStatus",
editor: {
kind: "XV.PurchaseOrderStatusPicker",
attr: "status"
}
} ]
} ]
}), enyo.kind({
name: "XV.PurchaseOrderWorkflowGridBox",
kind: "XV.WorkflowGridBox",
workspace: "XV.PurchaseOrderWorkflowWorkspace"
});
};
})();

// workspace.js

(function() {
XT.extensions.purchasing.initWorkspaces = function() {
var e = [ {
kind: "XV.SitePicker",
container: "mainGroup",
attr: "PreferredWarehouse",
label: "_defaultSite".loc()
} ];
XV.appendExtension("XV.UserPreferenceWorkspace", e);
var t = [ {
kind: "XV.ToggleButtonWidget",
attr: "isPurchaseOrders",
label: "_purchaseOrders".loc(),
container: "rolesGroup"
} ];
XV.appendExtension("XV.CharacteristicWorkspace", t), enyo.kind({
name: "XV.PurchasingWorkspace",
kind: "XV.Workspace",
title: "_configure".loc() + " " + "_purchasing".loc(),
model: "XM.Purchasing",
components: [ {
kind: "Panels",
arrangerKind: "CarouselArranger",
fit: !0,
components: [ {
kind: "XV.Groupbox",
name: "mainPanel",
components: [ {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_vendor".loc()
}, {
kind: "XV.InputWidget",
attr: "DefaultPOShipVia",
label: "_defaultShipVia".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "VendorChangeLog",
label: "_changeLog".loc()
}, {
kind: "onyx.GroupboxHeader",
content: "_purchaseOrder".loc()
}, {
kind: "XV.NumberPolicyPicker",
attr: "PONumberGeneration",
label: "_number".loc() + " " + "_policy".loc()
}, {
kind: "XV.NumberWidget",
attr: "NextPurchaseOrderNumber",
label: "_nextNumber".loc(),
formatting: !1
}, {
kind: "XV.ToggleButtonWidget",
attr: "POChangeLog",
label: "_changeLog".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "RequireStdCostForPOItem"
}, {
kind: "XV.ToggleButtonWidget",
attr: "DefaultPrintPOOnSave"
}, {
kind: "XV.ToggleButtonWidget",
attr: "UseEarliestAvailDateOnPOItem"
}, {
kind: "XV.ToggleButtonWidget",
attr: "RequirePOTax"
}, {
kind: "onyx.GroupboxHeader",
content: "_purchaseRequest".loc()
}, {
kind: "XV.NumberPolicyPicker",
attr: "PrNumberGeneration",
label: "_number".loc() + " " + "_policy".loc()
}, {
kind: "XV.NumberWidget",
attr: "NextPurchaseRequestNumber",
label: "_nextNumber".loc(),
formatting: !1
}, {
kind: "XV.ToggleButtonWidget",
attr: "CopyPRtoPOItem"
} ]
} ]
} ]
} ]
}), t = [ {
kind: "onyx.GroupboxHeader",
content: "_purchasing".loc(),
container: "settingsGroup"
}, {
kind: "XV.PurchasePriceWidget",
attr: "maximumDesiredCost",
container: "settingsGroup"
} ], XV.appendExtension("XV.ItemWorkspace", t), t = [ {
kind: "XV.Groupbox",
name: "supplyPanel",
title: "_supply".loc(),
components: [ {
kind: "onyx.GroupboxHeader",
content: "_supply".loc()
}, {
kind: "XV.CheckboxWidget",
attr: "isPurchased",
name: "isPurchased"
} ],
container: "panels"
} ], XV.appendExtension("XV.ItemSiteWorkspace", t), enyo.kind({
name: "XV.ItemSourceWorkspace",
kind: "XV.Workspace",
title: "_itemSource".loc(),
model: "XM.ItemSource",
components: [ {
kind: "Panels",
arrangerKind: "CarouselArranger",
fit: !0,
components: [ {
kind: "XV.Groupbox",
name: "mainPanel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_overview".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
classes: "in-panel",
fit: !0,
components: [ {
kind: "XV.ItemWidget",
attr: "item"
}, {
kind: "XV.VendorWidget",
attr: "vendor"
}, {
kind: "XV.CheckboxWidget",
attr: "isActive"
}, {
kind: "XV.CheckboxWidget",
attr: "isDefault"
}, {
kind: "XV.QuantityWidget",
attr: "multipleOrderQuantity"
}, {
kind: "XV.QuantityWidget",
attr: "minimumOrderQuantity"
}, {
kind: "XV.NumberSpinnerWidget",
attr: "leadTime"
}, {
kind: "XV.NumberSpinnerWidget",
attr: "ranking"
}, {
kind: "XV.DateWidget",
attr: "effective",
nullValue: XT.date.startOfTime(),
nullText: "_always".loc()
}, {
kind: "XV.DateWidget",
attr: "expires",
nullValue: XT.date.endOfTime(),
nullText: "_never".loc()
}, {
kind: "onyx.GroupboxHeader",
content: "_notes".loc()
}, {
kind: "XV.TextArea",
attr: "notes",
label: "_notes".loc()
} ]
} ]
}, {
kind: "XV.Groupbox",
name: "vendorPanel",
title: "_vendor".loc(),
components: [ {
kind: "onyx.GroupboxHeader",
content: "_vendor".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "vendorGroup",
classes: "in-panel",
fit: !0,
components: [ {
kind: "XV.InputWidget",
attr: "vendorItemNumber",
label: "_number".loc()
}, {
kind: "XV.UnitCombobox",
attr: "vendorUnit",
label: "_unit".loc(),
showLabel: !0
}, {
kind: "XV.UnitRatioWidget",
attr: "vendorUnitRatio",
label: "_unitRatio".loc()
}, {
kind: "XV.InputWidget",
attr: "barcode"
}, {
kind: "onyx.GroupboxHeader",
content: "_description".loc()
}, {
kind: "XV.TextArea",
attr: "vendorItemDescription",
label: "_description".loc()
}, {
kind: "onyx.GroupboxHeader",
content: "_manufacturer".loc()
}, {
kind: "XV.InputWidget",
attr: "manufacturerName",
label: "_name".loc()
}, {
kind: "XV.InputWidget",
attr: "manufacturerItemNumber",
label: "_number".loc()
}, {
kind: "onyx.GroupboxHeader",
content: "_description".loc()
}, {
kind: "XV.TextArea",
attr: "manufacturerItemDescription",
fit: !0
} ]
} ]
}, {
kind: "XV.ItemSourcePriceBox",
attr: "prices"
} ]
} ]
}), XV.registerModelWorkspace("XM.ItemSource", "XV.ItemSourceWorkspace"), enyo.kind({
name: "XV.PurchaseEmailProfileWorkspace",
kind: "XV.EmailProfileWorkspace",
title: "_purchaseEmailProfile".loc(),
model: "XM.PurchaseEmailProfile"
}), XV.registerModelWorkspace("XM.PurchaseEmailProfile", "XV.PurchaseEmailProfileWorkspace"), enyo.kind({
name: "XV.PurchaseTypeWorkspace",
kind: "XV.Workspace",
title: "_purchaseType".loc(),
model: "XM.PurchaseType",
components: [ {
kind: "Panels",
arrangerKind: "CarouselArranger",
fit: !0,
components: [ {
kind: "XV.Groupbox",
name: "mainPanel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_overview".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
classes: "in-panel",
fit: !0,
components: [ {
kind: "XV.InputWidget",
attr: "code"
}, {
kind: "XV.CheckboxWidget",
attr: "isActive"
}, {
kind: "XV.InputWidget",
attr: "description"
}, {
kind: "XV.PurchaseEmailProfilePicker",
attr: "emailProfile"
}, {
kind: "XV.PurchaseTypeCharacteristicsWidget",
attr: "characteristics"
} ]
} ]
}, {
kind: "XV.PurchaseTypeWorkflowBox",
attr: "workflow"
} ]
} ]
}), XV.registerModelWorkspace("XM.PurchaseType", "XV.PurchaseTypeWorkspace"), enyo.kind({
name: "XV.PurchaseOrderWorkspace",
kind: "XV.Workspace",
title: "_purchaseOrder".loc(),
model: "XM.PurchaseOrder",
printOnSaveSetting: "DefaultPrintPOOnSave",
actions: [ {
name: "print",
isViewMethod: !0,
label: "_print".loc(),
privilege: "ViewPurchaseOrders",
prerequisite: "isReadyClean"
}, {
name: "email",
isViewMethod: !0,
label: "_email".loc(),
privilege: "ViewPurchaseOrders",
prerequisite: "isReadyClean"
} ],
headerAttrs: [ "number", "-", "vendor.name" ],
components: [ {
kind: "Panels",
arrangerKind: "CarouselArranger",
fit: !0,
components: [ {
kind: "XV.Groupbox",
name: "mainPanel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_overview".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.InputWidget",
attr: "number"
}, {
kind: "XV.DateWidget",
attr: "orderDate"
}, {
kind: "XV.DateWidget",
attr: "releaseDate"
}, {
kind: "XV.PurchaseOrderStatusPicker",
attr: "status"
}, {
kind: "onyx.GroupboxHeader",
content: "_source".loc()
}, {
kind: "XV.PurchaseVendorWidget",
attr: "vendor"
}, {
kind: "XV.VendorAddressWidget",
attr: "vendorAddress",
label: "_address".loc()
}, {
kind: "XV.AddressFieldsWidget",
name: "vendorAddressFieldsWidget",
attr: {
name: "vendorAddressCode",
line1: "vendorAddress1",
line2: "vendorAddress2",
line3: "vendorAddress3",
city: "vendorCity",
state: "vendorState",
postalCode: "vendorPostalCode",
country: "vendorCountry"
}
}, {
kind: "XV.ContactWidget",
attr: "vendorContact",
name: "vendorContactWidget"
}, {
kind: "onyx.GroupboxHeader",
content: "_shipTo".loc()
}, {
kind: "XV.SitePicker",
attr: "site",
showNone: !1
}, {
kind: "XV.AddressFieldsWidget",
name: "destinationAddressWidget",
attr: {
line1: "shiptoAddress1",
line2: "shiptoAddress2",
line3: "shiptoAddress3",
city: "shiptoCity",
state: "shiptoState",
postalCode: "shiptoPostalCode",
country: "shiptoCountry"
}
}, {
kind: "XV.ContactWidget",
attr: "shiptoContact",
name: "shiptoContactWidget"
}, {
kind: "onyx.GroupboxHeader",
content: "_notes".loc()
}, {
kind: "XV.TextArea",
attr: "notes",
fit: !0
} ]
} ]
}, {
kind: "XV.Groupbox",
name: "settingsPanel",
title: "_settings".loc(),
components: [ {
kind: "onyx.GroupboxHeader",
content: "_settings".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "settingsGroup",
classes: "in-panel",
fit: !0,
components: [ {
name: "settingsControl",
components: [ {
kind: "XV.PurchaseOrderStatusPicker",
attr: "status"
}, {
kind: "XV.PurchaseTypePicker",
attr: "purchaseType"
}, {
kind: "XV.TermsPicker",
attr: "terms"
}, {
kind: "XV.TaxZonePicker",
attr: "taxZone"
}, {
kind: "XV.AgentPicker",
attr: "agent"
}, {
kind: "XV.InputWidget",
attr: "incoterms"
}, {
kind: "XV.ShipViaCombobox",
attr: "shipVia"
}, {
kind: "XV.PurchaseOrderCharacteristicsWidget",
attr: "characteristics"
} ]
} ]
} ]
}, {
kind: "XV.PurchaseOrderCommentBox",
name: "commentsPanel",
attr: "comments"
} ]
} ],
attributesChanged: function(e, t) {
this.inherited(arguments), this.vendorChanged();
},
controlValueChanged: function(e, t) {
this.inherited(arguments), t.originator.name === "vendorWidget" && this.vendorChanged();
},
create: function() {
this.inherited(arguments), enyo.platform.touch ? (this.$.panels.createComponents([ {
kind: "XV.PurchaseOrderLineBox",
name: "purchaseOrderLineItemBox",
attr: "lineItems",
addBefore: this.$.settingsPanel
} ], {
owner: this
}), this.$.panels.createComponents([ {
kind: "XV.PurchaseOrderWorkflowBox",
attr: "workflow",
addBefore: this.$.commentsPanel
} ], {
owner: this
})) : (this.$.panels.createComponents([ {
kind: "XV.PurchaseOrderLineGridBox",
name: "purchaseOrderLineItemBox",
attr: "lineItems",
addBefore: this.$.settingsPanel
} ], {
owner: this
}), this.$.panels.createComponents([ {
kind: "XV.PurchaseOrderWorkflowGridBox",
attr: "workflow",
addBefore: this.$.commentsPanel
} ], {
owner: this
})), this.processExtensions(!0);
},
vendorChanged: function() {
var e = this.$.purchaseVendorWidget.getValue();
e ? (this.$.vendorContactWidget.addParameter({
attribute: [ "account", "accountParent" ],
value: e.id
}, !0), this.$.vendorAddressWidget.setDisabled(!1), this.$.vendorAddressWidget.addParameter({
attribute: "vendor",
value: e.id
})) : (this.$.vendorContactWidget.removeParameter("account"), this.$.vendorAddressWidget.setDisabled(!0));
}
}), XV.registerModelWorkspace("XM.PurchaseOrder", "XV.PurchaseOrderWorkspace"), XV.registerModelWorkspace("XM.PurchaseOrderWorkflow", "XV.PurchaseOrderWorkspace"), XV.registerModelWorkspace("XM.PurchaseOrderRelation", "XV.PurchaseOrderWorkspace"), XV.registerModelWorkspace("XM.PurchaseOrderListItem", "XV.PurchaseOrderWorkspace"), enyo.kind({
name: "XV.PurchaseOrderWorkflowWorkspace",
kind: "XV.ChildWorkspace",
title: "_purchaseOrderWorkflow".loc(),
model: "XM.PurchaseOrderWorkflow",
components: [ {
kind: "Panels",
arrangerKind: "CarouselArranger",
classes: "xv-top-panel",
fit: !0,
components: [ {
kind: "XV.Groupbox",
name: "mainPanel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_overview".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.InputWidget",
attr: "name"
}, {
kind: "XV.InputWidget",
attr: "description"
}, {
kind: "XV.PurchaseOrderWorkflowTypePicker",
attr: "workflowType"
}, {
kind: "XV.WorkflowStatusPicker",
attr: "status"
}, {
kind: "XV.PriorityPicker",
attr: "priority",
showNone: !1
}, {
kind: "XV.NumberSpinnerWidget",
attr: "sequence"
}, {
kind: "onyx.GroupboxHeader",
content: "_schedule".loc()
}, {
kind: "XV.DateWidget",
attr: "dueDate"
}, {
kind: "XV.DateWidget",
attr: "startDate"
}, {
kind: "XV.DateWidget",
attr: "assignDate"
}, {
kind: "XV.DateWidget",
attr: "completeDate"
}, {
kind: "onyx.GroupboxHeader",
content: "_userAccounts".loc()
}, {
kind: "XV.UserAccountWidget",
attr: "owner"
}, {
kind: "XV.UserAccountWidget",
attr: "assignedTo"
}, {
kind: "onyx.GroupboxHeader",
content: "_notes".loc()
}, {
kind: "XV.TextArea",
attr: "notes",
fit: !0
} ]
} ]
}, {
kind: "XV.Groupbox",
name: "onCompletedPanel",
title: "_completionActions".loc(),
components: [ {
kind: "onyx.GroupboxHeader",
content: "_onCompletion".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "completionGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.PurchaseOrderStatusPicker",
attr: "completedParentStatus",
noneText: "_noChange".loc(),
label: "_nextStatus".loc()
}, {
kind: "XV.DependenciesWidget",
attr: {
workflow: "parent.workflow",
successors: "completedSuccessors"
}
} ]
} ]
}, {
kind: "XV.Groupbox",
name: "onDeferredPanel",
title: "_deferredActions".loc(),
components: [ {
kind: "onyx.GroupboxHeader",
content: "_onDeferred".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "deferredGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.PurchaseOrderStatusPicker",
attr: "completedParentStatus",
noneText: "_noChange".loc(),
label: "_nextStatus".loc()
}, {
kind: "XV.DependenciesWidget",
attr: {
workflow: "parent.workflow",
successors: "deferredSuccessors"
}
} ]
} ]
} ]
} ]
}), enyo.kind({
name: "XV.PurchaseOrderLineWorkspace",
kind: "XV.ChildWorkspace",
title: "_purchaseOrderLine".loc(),
model: "XM.PurchaseOrderLine",
components: [ {
kind: "Panels",
arrangerKind: "CarouselArranger",
classes: "xv-top-panel",
fit: !0,
components: [ {
kind: "XV.Groupbox",
name: "mainPanel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_overview".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.InputWidget",
attr: "lineNumber"
}, {
kind: "XV.ItemSiteWidget",
attr: {
item: "item",
site: "site"
}
}, {
kind: "XV.CheckboxWidget",
attr: "isMiscellaneous"
}, {
kind: "XV.ExpenseCategoryWidget",
attr: "expenseCategory"
}, {
kind: "XV.ProjectWidget",
attr: "project"
}, {
kind: "onyx.GroupboxHeader",
content: "_quantity".loc()
}, {
kind: "XV.QuantityWidget",
attr: "quantity",
label: "_ordered".loc()
}, {
kind: "XV.QuantityWidget",
attr: "toReceive"
}, {
kind: "XV.QuantityWidget",
attr: "received"
}, {
kind: "XV.QuantityWidget",
attr: "returned"
}, {
kind: "XV.QuantityWidget",
attr: "vouchered"
}, {
kind: "onyx.GroupboxHeader",
content: "_schedule".loc()
}, {
kind: "XV.DateWidget",
attr: "dueDate"
}, {
kind: "onyx.GroupboxHeader",
content: "_notes".loc()
}, {
kind: "XV.TextArea",
attr: "notes",
fit: !0
} ]
} ]
}, {
kind: "XV.Groupbox",
name: "pricePanel",
title: "_price".loc(),
components: [ {
kind: "onyx.GroupboxHeader",
content: "_price".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "priceGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.MoneyWidget",
attr: {
localValue: "price",
currency: "currency"
},
scale: XT.PURCHASE_PRICE_SCALE,
label: "_unitPrice".loc(),
currencyShowing: !0,
currencyDisabled: !0
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "extendedPrice",
currency: "currency"
},
label: "_extendedPrice".loc(),
currencyShowing: !0,
currencyDisabled: !0
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "freight",
currency: "currency"
},
label: "_freight".loc(),
currencyShowing: !0,
currencyDisabled: !0
}, {
kind: "onyx.GroupboxHeader",
content: "_tax".loc()
}, {
kind: "XV.TaxTypePicker",
attr: "taxType"
}, {
kind: "XV.MoneyWidget",
attr: {
localValue: "tax",
currency: "currency"
},
scale: XT.PURCHASE_PRICE_SCALE,
label: "_tax".loc(),
currencyShowing: !0,
currencyDisabled: !0
}, {
kind: "XV.PurchaseOrderLineCharacteristicsWidget",
attr: "characteristics"
} ]
} ]
}, {
kind: "XV.Groupbox",
name: "vendorPanel",
title: "_itemSource".loc(),
components: [ {
kind: "onyx.GroupboxHeader",
content: "_vendor".loc()
}, {
kind: "XV.ScrollableGroupbox",
name: "itemSourceGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "XV.ItemSourceWidget",
label: "_number".loc(),
attr: {
itemSource: "itemSource",
vendorItemNumber: "vendorItemNumber"
}
}, {
kind: "XV.InputWidget",
attr: "vendorUnit",
label: "_unit".loc()
}, {
kind: "XV.InputWidget",
attr: "vendorUnitRatio",
label: "_unitRatio".loc()
}, {
kind: "onyx.GroupboxHeader",
content: "_description".loc()
}, {
kind: "XV.TextArea",
attr: "vendorItemDescription",
label: "_description".loc()
}, {
kind: "onyx.GroupboxHeader",
content: "_manufacturer".loc()
}, {
kind: "XV.InputWidget",
attr: "manufacturerName",
label: "_name".loc()
}, {
kind: "XV.InputWidget",
attr: "manufacturerItemNumber",
label: "_itemNumber".loc()
}, {
kind: "onyx.GroupboxHeader",
content: "_description".loc()
}, {
kind: "XV.TextArea",
attr: "manufacturerItemDescription",
fit: !0
} ]
} ]
}, {
kind: "XV.PurchaseOrderLineCommentBox",
attr: "comments"
} ]
} ]
});
};
})();

// postbooks.js

(function() {
XT.extensions.purchasing.initPostbooks = function() {
var e, t, n;
t = [ {
name: "honorificList",
kind: "XV.HonorificList"
}, {
name: "expenseCategoryList",
kind: "XV.ExpenseCategoryList"
}, {
name: "itemList",
kind: "XV.ItemList"
}, {
name: "itemGroupList",
kind: "XV.ItemGroupList"
}, {
name: "classCodeList",
kind: "XV.ClassCodeList"
}, {
name: "unitList",
kind: "XV.UnitList"
}, {
name: "stateList",
kind: "XV.StateList"
}, {
name: "countryList",
kind: "XV.CountryList"
}, {
name: "purchaseEmailProfileList",
kind: "XV.PurchaseEmailProfileList"
}, {
name: "purchaseTypeList",
kind: "XV.PurchaseTypeList"
} ], XT.app.$.postbooks.appendPanels("setup", t), e = {
name: "purchasing",
label: "_purchasing".loc(),
panels: [ {
name: "ItemSourceList",
kind: "XV.ItemSourceList"
}, {
name: "purchaseOrderList",
kind: "XV.PurchaseOrderList"
}, {
name: "purchasing_activityList",
kind: "XV.ActivityList"
} ]
}, XT.app.$.postbooks.insertModule(e, 0), n = [ "EditOthersComments", "EditOwnComments", "DeleteItemMasters", "MaintainAddresses", "MaintainCommentTypes", "MaintainCountries", "MaintainClassCodes", "MaintainExpenseCategories", "MaintainTitles", "MaintainItemGroups", "MaintainItemMasters", "MaintainPurchaseEmailProfiles", "MaintainPurchaseTypes", "MaintainPurchaseOrders", "MaintainStates", "MaintainUOMs", "ViewClassCodes", "ViewItemMasters", "ViewPurchaseOrders", "ViewTitles" ], XT.session.addRelevantPrivileges(e.name, n), XM.configurations.add(new XM.ConfigurationModel({
model: "XM.purchasing",
name: "_purchasing".loc(),
description: "_purchasing".loc(),
workspace: "XV.PurchasingWorkspace"
}));
};
})();
