
// core.js

(function() {
"use strict";
XT.extensions.crm = {
setVersion: function() {
XT.setVersion("", "crm");
}
};
})();

// configure.js

(function() {
"use strict";
XT.extensions.crm.initSettings = function() {
XM.Crm = XM.Settings.extend({
recordType: "XM.Crm",
privileges: "ConfigureCRM",
validate: function(e, t) {
var n = {
type: "_number".loc()
};
if (e.NextCRMAccountNumber !== undefined && isNaN(e.NextCRMAccountNumber)) return n.attr = "_account".loc() + " " + "_number".loc(), XT.Error.clone("xt1003", {
params: n
});
if (e.NextIncidentNumber && isNaN(e.NextIncidentNumber)) return n.attr = "_incident".loc() + " " + "_number".loc(), XT.Error.clone("xt1003", {
params: n
});
}
}), XM.crm = new XM.Crm;
};
})();

// account.js

(function() {
"use strict";
XT.extensions.crm.initAccountModels = function() {
XM.AccountToDo = XM.Model.extend({
recordType: "XM.AccountToDo",
isDocumentAssignment: !0
}), XM.AccountIncident = XM.Model.extend({
recordType: "XM.AccountIncident",
isDocumentAssignment: !0
}), XM.AccountIncident = XM.Model.extend({
recordType: "XM.AccountIncident",
isDocumentAssignment: !0
}), XM.AccountOpportunity = XM.Model.extend({
recordType: "XM.AccountOpportunity",
isDocumentAssignment: !0
});
};
})();

// contact.js

(function() {
"use strict";
XT.extensions.crm.contactModels = function() {
XM.ContactToDo = XM.Model.extend({
recordType: "XM.ContactToDo",
isDocumentAssignment: !0
}), XM.ContactIncident = XM.Model.extend({
recordType: "XM.ContactIncident",
isDocumentAssignment: !0
}), XM.ContactOpportunity = XM.Model.extend({
recordType: "XM.ContactOpportunity",
isDocumentAssignment: !0
});
};
})();

// customer.js

(function() {
"use strict";
XT.extensions.crm.initCustomerModels = function() {
XM.CustomerContactRelation = XM.Info.extend({
recordType: "XM.CustomerContactRelation",
editableModel: "XM.Contact"
}), XM.CustomerToDoRelation = XM.Info.extend({
recordType: "XM.CustomerToDoRelation",
editableModel: "XM.ToDo"
}), XM.CustomerIncidentRelation = XM.Info.extend({
recordType: "XM.CustomerIncidentRelation",
editableModel: "XM.Incident"
}), XM.CustomerOpportunityRelation = XM.Info.extend({
recordType: "XM.CustomerOpportunityRelation",
editableModel: "XM.Opportunity"
});
};
})();

// incident.js

(function() {
"use strict";
XT.extensions.crm.incidentModels = function() {
XM.IncidentOpportunity = XM.Model.extend({
recordType: "XM.IncidentOpportunity",
isDocumentAssignment: !0
}), XM.IncidentToDo = XM.Model.extend({
recordType: "XM.IncidentToDo",
isDocumentAssignment: !0
});
};
})();

// invoice.js

(function() {
"use strict";
XT.extensions.crm.initInvoiceModels = function() {
XM.InvoiceIncident = XM.Model.extend({
recordType: "XM.InvoiceIncident",
isDocumentAssignment: !0
}), XM.InvoiceOpportunity = XM.Model.extend({
recordType: "XM.InvoiceOpportunity",
isDocumentAssignment: !0
});
};
})();

// opportunity.js

(function() {
"use strict";
XT.extensions.crm.opportunityModels = function() {
XM.OpportunityIncident = XM.Model.extend({
recordType: "XM.OpportunityIncident",
isDocumentAssignment: !0
}), XM.OpportunityToDo = XM.Model.extend({
recordType: "XM.OpportunityToDo",
isDocumentAssignment: !0
});
};
})();

// quote.js

(function() {
"use strict";
XT.extensions.crm.initQuoteModels = function() {
XM.QuoteToDoRelation = XM.Info.extend({
recordType: "XM.QuoteToDoRelation",
editableModel: "XM.ToDo"
}), XM.QuoteIncidentRelation = XM.Info.extend({
recordType: "XM.QuoteIncidentRelation",
editableModel: "XM.Incident"
}), XM.QuoteOpportunityRelation = XM.Info.extend({
recordType: "XM.QuoteOpportunityRelation",
editableModel: "XM.Opportunity"
});
};
})();

// sales_order.js

(function() {
"use strict";
XT.extensions.crm.initSalesOrderModels = function() {
XM.SalesOrderToDoRelation = XM.Info.extend({
recordType: "XM.SalesOrderToDoRelation",
editableModel: "XM.ToDo"
}), XM.SalesOrderIncidentRelation = XM.Info.extend({
recordType: "XM.SalesOrderIncidentRelation",
editableModel: "XM.Incident"
}), XM.SalesOrderOpportunityRelation = XM.Info.extend({
recordType: "XM.SalesOrderOpportunityRelation",
editableModel: "XM.Opportunity"
});
};
})();

// to_do.js

(function() {
"use strict";
XT.extensions.crm.toDoModels = function() {
XM.ToDoIncident = XM.Model.extend({
recordType: "XM.ToDoIncident",
isDocumentAssignment: !0
}), XM.ToDoOpportunity = XM.Model.extend({
recordType: "XM.ToDoOpportunity",
isDocumentAssignment: !0
});
};
})();

// startup.js

(function() {
"use strict";
XT.extensions.crm.initStartup = function() {
XT.cacheCollection("XM.incidentCategories", "XM.IncidentCategoryCollection"), XT.cacheCollection("XM.incidentEmailProfiles", "XM.IncidentEmailProfileCollection"), XT.cacheCollection("XM.incidentResolutions", "XM.IncidentResolutionCollection"), XT.cacheCollection("XM.incidentSeverities", "XM.IncidentSeverityCollection"), XT.cacheCollection("XM.opportunitySources", "XM.OpportunitySourceCollection"), XT.cacheCollection("XM.opportunityStages", "XM.OpportunityStageCollection"), XT.cacheCollection("XM.opportunityTypes", "XM.OpportunityTypeCollection"), XT.cacheCollection("XM.classCodes", "XM.ClassCodeCollection", "code"), XT.cacheCollection("XM.freightClasses", "XM.FreightClassCollection", "code"), XT.cacheCollection("XM.productCategories", "XM.ProductCategoryCollection");
};
})();

// list_relations.js

(function() {
XT.extensions.crm.initListRelations = function() {
enyo.kind({
name: "XV.AccountIncidentListRelations",
kind: "XV.IncidentListRelations",
parentKey: "account"
}), enyo.kind({
name: "XV.AccountOpportunityListRelations",
kind: "XV.ListRelations",
orderBy: [ {
attribute: "number",
descending: !0
} ],
parentKey: "account",
workspace: "XV.OpportunityWorkspace",
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListColumn",
classes: "first",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListAttr",
attr: "number",
classes: "bold"
}, {
kind: "XV.ListAttr",
attr: "opportunityStage.name",
fit: !0
}, {
kind: "XV.ListAttr",
attr: "targetClose",
placeholder: "_noCloseTarget".loc(),
classes: "right"
} ]
}, {
kind: "XV.ListAttr",
attr: "name"
} ]
} ]
} ]
} ]
}), enyo.kind({
name: "XV.AccountToDoListRelations",
kind: "XV.ListRelations",
orderBy: [ {
attribute: "dueDate",
descending: !0
}, {
attribute: "name"
} ],
parentKey: "account",
workspace: "XV.ToDoWorkspace",
components: [ {
kind: "XV.ListItem",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListColumn",
classes: "first",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "XV.ListAttr",
attr: "name",
classes: "bold"
}, {
kind: "XV.ListAttr",
attr: "dueDate",
fit: !0,
formatter: "formatDueDate",
placeholder: "_noDueDate".loc(),
classes: "right"
} ]
}, {
kind: "XV.ListAttr",
attr: "description",
placeholder: "_noDescription".loc()
} ]
} ]
} ]
} ],
formatDueDate: XV.ToDoList.prototype.formatDueDate
}), enyo.kind({
name: "XV.ContactIncidentListRelations",
kind: "XV.AccountIncidentListRelations",
parentKey: "contact"
}), enyo.kind({
name: "XV.ContactOpportunityListRelations",
kind: "XV.AccountOpportunityListRelations",
parentKey: "contact"
}), enyo.kind({
name: "XV.ContactToDoListRelations",
kind: "XV.AccountToDoListRelations",
parentKey: "contact"
}), enyo.kind({
name: "XV.IncidentToDoListRelations",
kind: "XV.AccountToDoListRelations",
parentKey: "incident"
}), enyo.kind({
name: "XV.OpportunityToDoListRelations",
kind: "XV.AccountToDoListRelations",
parentKey: "opportunity"
});
};
})();

// list_relations_box.js

(function() {
XT.extensions.crm.initListRelationsBox = function() {
enyo.kind({
name: "XV.AccountIncidentsBox",
kind: "XV.ListRelationsBox",
title: "_incidents".loc(),
parentKey: "account",
listRelations: "XV.AccountIncidentListRelations"
}), enyo.kind({
name: "XV.AccountOpportunitiesBox",
kind: "XV.ListRelationsBox",
title: "_opportunities".loc(),
parentKey: "account",
listRelations: "XV.AccountOpportunityListRelations"
}), enyo.kind({
name: "XV.AccountToDosBox",
kind: "XV.ListRelationsBox",
title: "_toDo".loc(),
parentKey: "account",
listRelations: "XV.AccountToDoListRelations",
searchList: "XV.ToDoList"
}), enyo.kind({
name: "XV.ContactIncidentsBox",
kind: "XV.ListRelationsBox",
title: "_incidents".loc(),
parentKey: "contact",
listRelations: "XV.ContactIncidentListRelations"
}), enyo.kind({
name: "XV.ContactOpportunitiesBox",
kind: "XV.ListRelationsBox",
title: "_opportunities".loc(),
parentKey: "contact",
listRelations: "XV.ContactOpportunityListRelations",
searchList: "XV.OpportunityList"
}), enyo.kind({
name: "XV.ContactToDosBox",
kind: "XV.ListRelationsBox",
title: "_toDo".loc(),
parentKey: "contact",
listRelations: "XV.ContactToDoListRelations",
searchList: "XV.ToDoList"
}), enyo.kind({
name: "XV.IncidentToDosBox",
kind: "XV.AccountToDosBox",
parentKey: "incident",
listRelations: "XV.IncidentToDoListRelations"
}), enyo.kind({
name: "XV.OpportunityToDosBox",
kind: "XV.AccountToDosBox",
parentKey: "opportunity",
listRelations: "XV.OpportunityToDoListRelations"
});
};
})();

// workspace.js

(function() {
XT.extensions.crm.initWorkspaces = function() {
var e;
e = [ {
kind: "XV.AccountToDosBox",
container: "panels",
attr: "toDoRelations"
}, {
kind: "XV.AccountOpportunitiesBox",
container: "panels",
attr: "opportunityRelations"
}, {
kind: "XV.AccountIncidentsBox",
container: "panels",
attr: "incidentRelations"
} ], XV.appendExtension("XV.AccountWorkspace", e), enyo.kind({
name: "XV.CrmWorkspace",
kind: "XV.Workspace",
title: "_configure".loc() + " " + "_crm".loc(),
model: "XM.Crm",
components: [ {
kind: "Panels",
arrangerKind: "CarouselArranger",
fit: !0,
components: [ {
kind: "XV.Groupbox",
name: "mainPanel",
components: [ {
kind: "XV.ScrollableGroupbox",
name: "mainGroup",
fit: !0,
classes: "in-panel",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_account".loc()
}, {
kind: "XV.NumberPolicyPicker",
attr: "CRMAccountNumberGeneration",
label: "_number".loc() + " " + "_policy".loc()
}, {
kind: "XV.InputWidget",
attr: "NextCRMAccountNumber",
label: "_nextNumber".loc()
}, {
kind: "onyx.GroupboxHeader",
content: "_country".loc()
}, {
kind: "XV.CountryPicker",
attr: "DefaultAddressCountry",
label: "_default".loc(),
idAttribute: "name"
}, {
kind: "XV.ToggleButtonWidget",
attr: "StrictAddressCountry",
label: "_limitToList".loc()
}, {
kind: "onyx.GroupboxHeader",
content: "_incident".loc()
}, {
kind: "XV.InputWidget",
attr: "NextIncidentNumber",
label: "_nextNumber".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "IncidentsPublicPrivate",
label: "_public".loc() + " " + "_flag".loc()
}, {
kind: "XV.CheckboxWidget",
attr: "IncidentPublicDefault",
label: "_incidentDefaultPublic".loc()
}, {
kind: "onyx.GroupboxHeader",
content: "_incidentStatusColors".loc()
}, {
kind: "XV.InputWidget",
attr: "IncidentNewColor",
label: "_new".loc()
}, {
kind: "XV.InputWidget",
attr: "IncidentFeedbackColor",
label: "_feedback".loc()
}, {
kind: "XV.InputWidget",
attr: "IncidentConfirmedColor",
label: "_confirmed".loc()
}, {
kind: "XV.InputWidget",
attr: "IncidentAssignedColor",
label: "_assigned".loc()
}, {
kind: "XV.InputWidget",
attr: "IncidentResolvedColor",
label: "_resolved".loc()
}, {
kind: "XV.InputWidget",
attr: "IncidentClosedColor",
label: "_closed".loc()
}, {
kind: "onyx.GroupboxHeader",
content: "_opportunity".loc()
}, {
kind: "XV.ToggleButtonWidget",
attr: "OpportunityChangeLog",
label: "_changeLog".loc()
} ]
} ]
} ]
} ]
}), e = [ {
kind: "XV.ContactToDosBox",
container: "panels",
attr: "toDoRelations"
}, {
kind: "XV.ContactOpportunitiesBox",
container: "panels",
attr: "opportunityRelations"
}, {
kind: "XV.ContactIncidentsBox",
container: "panels",
attr: "incidentRelations"
} ], XV.appendExtension("XV.ContactWorkspace", e), e = [ {
kind: "XV.AccountContactsBox",
container: "panels",
attr: "contactRelations",
parentAttr: "account"
}, {
kind: "XV.AccountToDosBox",
container: "panels",
attr: "toDoRelations",
parentAttr: "account"
}, {
kind: "XV.AccountOpportunitiesBox",
container: "panels",
attr: "opportunityRelations",
parentAttr: "account"
}, {
kind: "XV.AccountIncidentsBox",
container: "panels",
attr: "incidentRelations",
parentAttr: "account"
} ], XV.appendExtension("XV.CustomerWorkspace", e), XV.registerModelWorkspace("XM.CustomerContactRelation", "XV.ContactWorkspace"), XV.registerModelWorkspace("XM.CustomerIncidentRelation", "XV.IncidentWorkspace"), XV.registerModelWorkspace("XM.CustomerOpportunityRelation", "XV.OpportunityWorkspace"), XV.registerModelWorkspace("XM.CustomerToDoRelation", "XV.ToDoWorkspace"), e = [ {
kind: "XV.IncidentToDosBox",
container: "panels",
attr: "toDoRelations"
} ], XV.appendExtension("XV.IncidentWorkspace", e), e = [ {
kind: "XV.OpportunityToDosBox",
container: "panels",
attr: "toDoRelations"
} ], XV.appendExtension("XV.OpportunityWorkspace", e), e = [ {
kind: "XV.OpportunityWidget",
container: "settingsGroup",
attr: "opportunity"
} ], XV.appendExtension("XV.QuoteWorkspace", e), e = [ {
kind: "XV.OpportunityWidget",
container: "settingsGroup",
attr: "opportunity"
} ], XV.appendExtension("XV.SalesOrderWorkspace", e), e = [ {
kind: "XV.IncidentWidget",
container: "mainGroup",
attr: "incident"
}, {
kind: "XV.OpportunityWidget",
container: "mainGroup",
attr: "opportunity"
} ], XV.appendExtension("XV.ToDoWorkspace", e);
};
})();

// chart.js

(function() {
XT.extensions.crm.initCharts = function() {
enyo.kind({
name: "XV.AssignedIncidentBarChart",
kind: "XV.DrilldownBarChart",
collection: "XM.IncidentListItemCollection",
chartTitle: "_assignedIncidents".loc(),
filterOptions: [ {
name: "all",
parameters: []
}, {
name: "highPriority",
parameters: [ {
attribute: "priorityOrder",
operator: "<",
value: 2
} ]
} ],
groupByOptions: [ {
name: "assignedTo"
}, {
name: "category"
}, {
name: "priority"
}, {
name: "project"
} ],
query: {
parameters: [ {
attribute: "status",
operator: "=",
value: "A"
} ]
}
}), enyo.kind({
name: "XV.OpportunityBarChart",
kind: "XV.DrilldownBarChart",
collection: "XM.OpportunityListItemCollection",
chartTitle: "_opportunitiesNext30Days".loc(),
groupByOptions: [ {
name: "opportunityStage",
content: "_stage".loc()
}, {
name: "opportunitySource",
content: "_source".loc()
}, {
name: "opportunityType",
content: "_type".loc()
}, {
name: "owner"
}, {
name: "assignedTo"
}, {
name: "priority"
} ],
query: {
parameters: [ {
attribute: "targetClose",
operator: ">=",
value: XT.date.applyTimezoneOffset(XV.Date.prototype.textToDate("0"), !0)
}, {
attribute: "targetClose",
operator: "<=",
value: XT.date.applyTimezoneOffset(XV.Date.prototype.textToDate("+30"), !0)
} ]
},
totalField: "amount"
});
};
})();

// parameter.js

(function() {
XT.extensions.crm.initParameterWidgets = function() {
XV.ActivityListParameters.prototype.activityTypes.crm = [ {
type: "Incident"
}, {
type: "Opportunity",
label: "_opportunities".loc()
}, {
type: "ToDo",
label: "_toDo".loc()
} ];
};
})();

// postbooks.js

(function() {
XT.extensions.crm.initPostbooks = function() {
var e, t, n, r, i, s;
r = {
model: "XM.crm",
name: "_crm".loc(),
description: "_crmDescription".loc(),
workspace: "XV.CrmWorkspace"
}, i = new XM.ConfigurationModel(r), XM.configurations.add(i), e = [ {
name: "itemList",
kind: "XV.ItemList"
}, {
name: "itemGroupList",
kind: "XV.ItemGroupList"
}, {
name: "currencyList",
kind: "XV.CurrencyList"
}, {
name: "stateList",
kind: "XV.StateList"
}, {
name: "countryList",
kind: "XV.CountryList"
}, {
name: "priorityList",
kind: "XV.PriorityList"
}, {
name: "honorificList",
kind: "XV.HonorificList"
}, {
name: "incidentCategoryList",
kind: "XV.IncidentCategoryList"
}, {
name: "incidentResolutionList",
kind: "XV.IncidentResolutionList"
}, {
name: "incidentSeverityList",
kind: "XV.IncidentSeverityList"
}, {
name: "incidentEmailProfileList",
kind: "XV.IncidentEmailProfileList"
}, {
name: "opportunitySourceList",
kind: "XV.OpportunitySourceList"
}, {
name: "opportunityStageList",
kind: "XV.OpportunityStageList"
}, {
name: "opportunityTypeList",
kind: "XV.OpportunityTypeList"
}, {
name: "classCodeList",
kind: "XV.ClassCodeList"
}, {
name: "unitList",
kind: "XV.UnitList"
}, {
name: "productCategoryList",
kind: "XV.ProductCategoryList"
}, {
name: "characteristicList",
kind: "XV.CharacteristicList"
} ], XT.app.$.postbooks.appendPanels("setup", e), t = {
name: "crm",
label: "_crm".loc(),
panels: [ {
name: "accountList",
kind: "XV.AccountList"
}, {
name: "contactList",
kind: "XV.ContactList"
}, {
name: "crm_activityList",
kind: "XV.ActivityList"
}, {
name: "toDoList",
kind: "XV.ToDoList"
}, {
name: "opportunityList",
kind: "XV.OpportunityList"
}, {
name: "incidentList",
kind: "XV.IncidentList",
toggleSelected: !1
} ]
};
if (XT.session.settings.get("DashboardLite")) {
var o = {
name: "dashboardLite",
label: "_dashboard".loc(),
panels: [ {
name: "dashboardLite",
kind: "XV.DashboardLite",
newActions: [ {
name: "assignedIncidents",
label: "_assignedIncidents".loc(),
item: "XV.AssignedIncidentBarChart"
}, {
name: "opportunities",
label: "_opportunities".loc(),
item: "XV.OpportunityBarChart"
} ]
} ]
};
XT.app.$.postbooks.insertModule(o, 0);
}
s = XT.session.config.biAvailable && XT.session.privileges.get("ViewSalesHistory"), s && t.panels.push({
name: "analysisPage",
kind: "analysisFrame"
}), XT.app.$.postbooks.insertModule(t, 0), n = [ "CreateNewCurrency", "MaintainCurrencies", "MaintainCurrencyRates", "ViewCurrencyRates", "EditOwner", "MaintainAddresses", "MaintainAllContacts", "MaintainAllCRMAccounts", "MaintainAllIncidents", "MaintainAllOpportunities", "MaintainAllToDoItems", "MaintainCharacteristics", "MaintainIncidentCategories", "MaintainIncidentPriorities", "MaintainIncidentResolutions", "MaintainIncidentSeverities", "MaintainItemGroups", "MaintainOpportunitySources", "MaintainOpportunityStages", "MaintainOpportunityTypes", "MaintainPersonalContacts", "MaintainPersonalCRMAccounts", "MaintainPersonalIncidents", "MaintainPersonalOpportunities", "MaintainPersonalProjects", "MaintainPersonalToDoItems", "MaintainTitles", "ReassignToDoItems", "ViewAddresses", "ViewAllContacts", "ViewAllCRMAccounts", "ViewAllIncidentHistory", "ViewAllIncidents", "ViewAllOpportunities", "ViewAllProjects", "ViewAllToDoItems", "ViewCharacteristics", "ViewPersonalContacts", "ViewPersonalCRMAccounts", "ViewPersonalIncidents", "ViewPersonalOpportunities", "ViewPersonalToDoItems", "ViewTitles", "DeleteItemMasters", "MaintainClassCodes", "MaintainItemMasters", "MaintainProductCategories", "MaintainUOMs", "ViewClassCodes", "ViewItemMasters", "ViewProductCategories", "ConfigureCRM", "EditOthersComments", "EditOwnComments", "MaintainCommentTypes", "MaintainCountries", "MaintainStates", "ViewEmailProfiles", "MaintainEmailProfiles" ], XT.session.addRelevantPrivileges(t.name, n), enyo.kind({
name: "analysisFrame",
label: "_analysis".loc(),
tag: "iframe",
style: "border: none;",
attributes: {
src: ""
},
events: {
onMessage: ""
},
published: {
source: ""
},
create: function() {
this.inherited(arguments), XT.session.config.freeDemo && this.doMessage({
message: "_staleAnalysisWarning".loc()
});
var e, t = new enyo.Ajax({
url: XT.getOrganizationPath() + "/analysis",
handleAs: "text"
});
t.response(this, function(e, t) {
this.setSource(t);
}), t.error(this, function(e, t) {
console.log("There was a problem generating the iFrame");
}), t.go({
reportUrl: "content/saiku-ui/index.html?biplugin=true"
});
},
sourceChanged: function() {
this.inherited(arguments), this.setAttributes({
src: this.getSource()
});
}
});
};
})();
