xTuple
======

[![Build Status](https://travis-ci.org/xtuple/xtuple.png)](https://travis-ci.org/xtuple/xtuple)

### What we're about

xTuple is open-source business management software. The code is managed by an eponymous
company in Norfolk, VA, and our community stretches around the world. Our web application
is implemented as an [HTML5 node.js app](https://github.com/xtuple/xtuple/wiki/Overview).
The other client to our server is a [desktop app](https://github.com/xtuple/qt-client) written
in the cross-platform Qt framework.

Most of our commercial customers are inventory-based manufacturers or distributors, and we have a 
fair amount of commercially-licensed code to specifically support these use-cases. That said,
businesses of all sorts, even services-based companies, run their operations on our open-source 
core.

We're always happy when people use xTuple as a launching point for their own projects,
whether or not you have a commercial relationship with us. 

### Why you might be interested in hacking on our software

The xTuple platform provides a great starting point for business software in practically
any industry. What you get for free is an entire stack to work on top of, and a lot
of business objects that you might want, like `Invoices`, `Currencies`, `Tasks` and 
`Contacts` (and about a hundred more) are already implemented.

Moreover, one of the great strengths of the framework is extensibility and privilege
control. Our extension system allows for a high level of modularity, and keeps you
from having to rewrite the core. Fine-grained, centrally-managed privilege 
control is also an important feature that businesses typically want, and
we've taken special care to implement it reliably across the application.

### Getting involved

Fork us, take a test drive with our [free trial](http://www.xtuple.com/free-trial), 
file a github issue. 
If you want to be a contributor and are looking for a place to
make your mark, we're keeping a list of issues that are 
[fair game](https://github.com/xtuple/xtuple/issues?labels=fair+game) 
to pick off and provide
a convenient, well-documented starting point into our project.

In the month of August, we will be running haxTuple 2014. As in previous incarnations, 
we will open up our bug-shooting derby for the Qt client to our community, with prizes 
for the most effective bugsquashers! In this year's event, we will also introduce our 
new technologies by opening up our webapp for haxxing. Those who write the best 
JavaScript extensions or REST clients will get prizes. More details to follow.

Also, don't miss the xTuple event of the year! 
[xTupleCon 2014](http://www.xtuple.com/xtuple-conference-2014)
is going to be held October 13-18 in Norfolk, VA. With six days of events and a kickoff
speech by Steve Wozniak, it promises to the be the biggest xTupleCon yet.

### Installing this project

The best way to start coding on our stack is to use our
[Vagrant setup](https://github.com/xtuple/xtuple/wiki/Become-an-xTuple-Developer!).

### Release Notes

View the [Release Notes](RELEASE.md) to see a change log.

### Additional Resources

  * [Setting up a non-development demo environment](https://github.com/xtuple/xtuple/wiki/How-to-set-up-xTuple)
  * [Building an Extension Tutorial](https://github.com/xtuple/xtuple-extensions/blob/master/docs/TUTORIAL.md)
  * [API documentation](http://xtuple.com/jsdoc)
  * [Developer Wiki](https://github.com/xtuple/xtuple/wiki)
