--
-- PostgreSQL database dump
--

-- Dumped from database version 9.1.12
-- Dumped by pg_dump version 9.1.12
-- Started on 2014-03-27 12:36:04 EDT

SET statement_timeout = 0;
SET client_encoding = 'SQL_ASCII';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

SET search_path = fixcountry, pg_catalog;

--
-- TOC entry 9004 (class 0 OID 146618626)
-- Dependencies: 399 9464
-- Data for Name: pkgcmd; Type: TABLE DATA; Schema: fixcountry; Owner: admin
--

SET SESSION AUTHORIZATION DEFAULT;

ALTER TABLE pkgcmd DISABLE TRIGGER ALL;



ALTER TABLE pkgcmd ENABLE TRIGGER ALL;

--
-- TOC entry 9007 (class 0 OID 146618642)
-- Dependencies: 402 9004 9464
-- Data for Name: pkgcmdarg; Type: TABLE DATA; Schema: fixcountry; Owner: admin
--

ALTER TABLE pkgcmdarg DISABLE TRIGGER ALL;



ALTER TABLE pkgcmdarg ENABLE TRIGGER ALL;

--
-- TOC entry 9009 (class 0 OID 146618651)
-- Dependencies: 404 9464
-- Data for Name: pkgimage; Type: TABLE DATA; Schema: fixcountry; Owner: admin
--

ALTER TABLE pkgimage DISABLE TRIGGER ALL;



ALTER TABLE pkgimage ENABLE TRIGGER ALL;

--
-- TOC entry 9012 (class 0 OID 146618668)
-- Dependencies: 407 9464
-- Data for Name: pkgmetasql; Type: TABLE DATA; Schema: fixcountry; Owner: admin
--

ALTER TABLE pkgmetasql DISABLE TRIGGER ALL;

INSERT INTO pkgmetasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (449, 'fixcountry', 'strictcountrycheck', 'select details about countries used throughout the database that do not match country.country_name a copy of crm_strictcountrycheck to avoid problems later if someone disables or removes the fixCountry package', '-- Group: fixcountry
-- Name:  strictcountrycheck
-- Notes: select details about countries used throughout the database
--        that do not match country.country_name
--        a copy of crm_strictcountrycheck to avoid problems later if
--        someone disables or removes the fixCountry package
<? if exists("count") ?>
SELECT SUM(counter) AS counter FROM (
<? endif ?>
  SELECT <? if exists("count") ?> COUNT(*) AS counter
         <? else ?> addr_id, ''Address'' AS type, addr_number AS number, addr_country AS country, '''' AS detail
         <? endif ?>
    FROM addr
   WHERE addr_country != ''''
     AND addr_country NOT IN (SELECT country_name
                                FROM country
                               WHERE country_name IS NOT NULL)
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> cmhead_id, ''Credit Memo'', cmhead_number, cmhead_billtocountry, ''Bill-To''
         <? endif ?>
    FROM cmhead
   WHERE cmhead_billtocountry != ''''
     AND cmhead_billtocountry NOT IN (SELECT country_name
                                        FROM country
                                       WHERE country_name IS NOT NULL)
     <? if not exists("showAll") ?> AND (NOT cmhead_posted) <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> cmhead_id, ''Credit Memo'', cmhead_number, cmhead_billtocountry, ''Ship-To''
         <? endif ?>
    FROM cmhead
    WHERE cmhead_shipto_country != ''''
      AND cmhead_shipto_country NOT IN (SELECT country_name
                                          FROM country
                                         WHERE country_name IS NOT NULL)
      <? if not exists("showAll") ?> AND (NOT cmhead_posted) <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> invchead_id, ''Invoice'', invchead_invcnumber, invchead_billto_country, ''Bill-To''
         <? endif ?>
    FROM invchead
   WHERE invchead_billto_country != ''''
     AND invchead_billto_country NOT IN (SELECT country_name
                                           FROM country
                                          WHERE country_name IS NOT NULL)
     <? if not exists("showAll") ?> AND (NOT invchead_posted) <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> invchead_id, ''Invoice'', invchead_invcnumber, invchead_shipto_country, ''Ship-To''
         <? endif ?>
    FROM invchead
   WHERE invchead_shipto_country != ''''
     AND invchead_shipto_country NOT IN (SELECT country_name
                                           FROM country
                                          WHERE country_name IS NOT NULL)
     <? if not exists("showAll") ?> AND (NOT invchead_posted) <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> quhead_id, ''Quote'', CAST(quhead_number AS TEXT), quhead_billtocountry, ''Bill-To''
         <? endif ?>
    FROM quhead
   WHERE quhead_billtocountry != ''''
     AND quhead_billtocountry NOT IN (SELECT country_name
                                        FROM country
                                       WHERE country_name IS NOT NULL)
     <? if not exists("showAll") ?> AND (quhead_expire>=CURRENT_DATE) <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> quhead_id, ''Quote'', CAST(quhead_number AS TEXT), quhead_shiptocountry, ''Ship-To''
         <? endif ?>
    FROM quhead
   WHERE quhead_shiptocountry != ''''
     AND quhead_shiptocountry NOT IN (SELECT country_name
                                        FROM country
                                       WHERE country_name IS NOT NULL)
     <? if not exists("showAll") ?> AND (quhead_expire>=CURRENT_DATE) <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> cohead_id, ''Sales Order'', cohead_number, cohead_billtocountry, ''Bill-To''
         <? endif ?>
    FROM cohead
   WHERE cohead_billtocountry != ''''
     AND cohead_billtocountry NOT IN (SELECT country_name
                                        FROM country
                                       WHERE country_name IS NOT NULL)
    <? if not exists("showAll") ?>
     AND cohead_id IN (SELECT coitem_cohead_id
                         FROM coitem
                        WHERE COALESCE(coitem_status, ''O'')=''O'')
    <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> cohead_id, ''Sales Order'', cohead_number, cohead_shiptocountry, ''Ship-To''
         <? endif ?>
    FROM cohead
   WHERE cohead_shiptocountry != ''''
     AND cohead_shiptocountry NOT IN (SELECT country_name
                                       FROM country
                                      WHERE country_name IS NOT NULL)
    <? if not exists("showAll") ?>
     AND cohead_id IN (SELECT coitem_cohead_id
                         FROM coitem
                        WHERE COALESCE(coitem_status, ''O'')=''O'')
    <? endif ?>

<? if exists("count") ?>
) AS dummy;
<? endif ?>
', NULL, NULL, 0);


ALTER TABLE pkgmetasql ENABLE TRIGGER ALL;

--
-- TOC entry 9015 (class 0 OID 146618685)
-- Dependencies: 410 9464
-- Data for Name: pkgpriv; Type: TABLE DATA; Schema: fixcountry; Owner: admin
--

ALTER TABLE pkgpriv DISABLE TRIGGER ALL;



ALTER TABLE pkgpriv ENABLE TRIGGER ALL;

--
-- TOC entry 9018 (class 0 OID 146618701)
-- Dependencies: 413 9464
-- Data for Name: pkgreport; Type: TABLE DATA; Schema: fixcountry; Owner: admin
--

ALTER TABLE pkgreport DISABLE TRIGGER ALL;



ALTER TABLE pkgreport ENABLE TRIGGER ALL;

--
-- TOC entry 9021 (class 0 OID 146618718)
-- Dependencies: 416 9464
-- Data for Name: pkgscript; Type: TABLE DATA; Schema: fixcountry; Owner: admin
--

ALTER TABLE pkgscript DISABLE TRIGGER ALL;

INSERT INTO pkgscript (script_id, script_name, script_order, script_enabled, script_source, script_notes) VALUES (124, 'initMenu', 0, true, 'function sFixCountries()
{
  try {
  var newdlg = toolbox.openWindow("fixCountries", 0, Qt.Window, Qt.NonModal);
  } catch(e) { print("sFixCountries exception: " + e); }
}

var _crmutilsmenu = mainwindow.findChild("menu.crm.utilities");
var fixCountriesAction = _crmutilsmenu.addAction(
                  qsTr("Fix Countries before setting Strict Countries option"));
fixCountriesAction.enabled = privileges.value("MaintainAddresses")   &&
                             privileges.value("MaintainCreditMemos") &&
                             privileges.value("MaintainMiscInvoices")&&
                             privileges.value("MaintainSalesOrders") &&
                             privileges.value("MaintainQuotes");

fixCountriesAction.triggered.connect(sFixCountries);
', '');
INSERT INTO pkgscript (script_id, script_name, script_order, script_enabled, script_source, script_notes) VALUES (125, 'fixCountries', 0, true, 'var _addCountry = mywindow.findChild("_addCountry");
var _edit       = mywindow.findChild("_edit");
var _fixAbbr    = mywindow.findChild("_fixAbbr");
var _fixBulk    = mywindow.findChild("_fixBulk");
var _fixCase    = mywindow.findChild("_fixCase");
var _list       = mywindow.findChild("_list");
var _query      = mywindow.findChild("_query");
var _showAll    = mywindow.findChild("_showAll");

_list.addColumn("Record Type", -1, Qt.AlignLeft, true, "type");
_list.addColumn("Number",      -1, Qt.AlignLeft, true, "number");
_list.addColumn("Country",     -1, Qt.AlignLeft, true, "country");
_list.addColumn("Details",     -1, Qt.AlignLeft, true, "detail");

function sAddCountry()
{
  try {
  var params = new Object;;
  params.mode = "new";

  var newdlg = toolbox.openWindow("country", mywindow, Qt.Dialog, Qt.WindowModal);
  toolbox.lastWindow().set(params);
  newdlg.exec();
  } catch (e) { print("sAddCountry exception: " + e); }
}

function openEditorWindow(pwindow, pidname, pparent)
{
  try {
  var params = new Object;
  params[pidname] = _list.id();
  if (pidname == ''quhead_id'')
    params.mode = "editQuote";
  else
    params.mode = "edit";

  var newdlg = toolbox.openWindow(pwindow, pparent, Qt.Dialog, Qt.WindowModal);
  toolbox.lastWindow().set(params);
  newdlg.exec();
  } catch(e) { print("openEditorWindow exception (" + e.lineNumber + "): " + e); }
}

function sEdit()
{
  try {
  var currentItem = _list.currentItem();

  switch (currentItem.text(0))
  {
    case ''Address'':
      openEditorWindow("address", "addr_id", mywindow);
      break;

    case ''Credit Memo'':
      openEditorWindow("creditMemo", "cmhead_id", 0);
      break;

    case ''Invoice'':
      openEditorWindow("invoice", "invchead_id", mywindow);
      break;

    case ''Quote'':
      openEditorWindow("salesOrder", "quhead_id", 0);
      break;

    case ''Sales Order'':
      openEditorWindow("salesOrder", "sohead_id", 0);
      break;
  }
  sFillList();
  } catch (e) { print("sEdit() exception: " + e); }
}

function sFixBulk()
{
  print("sFixBulk() entered");
  try {
    var params = new Object;
    if (_showAll.checked)
      params.showAll = true;

    var newdlg = toolbox.openWindow("bulkFixCountry", mywindow,
                                    Qt.WindowModal, Qt.Dialog);
    toolbox.lastWindow().set(params);

    sFillList();
  } catch (e) { print("sFixBulk() exception: " + e); }
}

function sFixCase()
{
  try {
  if (QMessageBox.question(mywindow, qsTr("Are you sure?"),
                           qsTr("<p>Are you sure that you want to change all "
                              + "countries that appear to be correct except "
                              + "for upper- and lower-case differences in a "
                              + "batch?<p>(This change will obey the status "
                              + "of the ''Show closed records'' check box."),
                           QMessageBox.Yes, QMessageBox.No) == QMessageBox.No)
    return;

  var params = new Object;
  if (_showAll.checked)
    params.showAll = true;

  var qry = toolbox.executeQuery(
      "UPDATE addr SET addr_country = country_name"
    + "  FROM country "
    + " WHERE addr_country != ''''"
    + "   AND UPPER(addr_country) = UPPER(country_name)"
    + "   AND addr_country != country_name;", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Address: " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE cmhead SET cmhead_billtocountry = country_name"
    + "  FROM country "
    + " WHERE cmhead_billtocountry != ''''"
    + "   AND UPPER(cmhead_billtocountry) = UPPER(country_name)"
    + "   AND cmhead_billtocountry != country_name"
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT cmhead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Credit Memo (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE cmhead SET cmhead_shipto_country = country_name"
    + "  FROM country "
    + " WHERE cmhead_shipto_country != ''''"
    + "   AND UPPER(cmhead_shipto_country) = UPPER(country_name)"
    + "   AND cmhead_shipto_country != country_name"
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT cmhead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Credit Memo (Ship-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE invchead SET invchead_billto_country = country_name"
    + "  FROM country "
    + " WHERE invchead_billto_country != ''''"
    + "   AND UPPER(invchead_billto_country) = UPPER(country_name)"
    + "   AND invchead_billto_country != country_name"
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT invchead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Invoice (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE invchead SET invchead_shipto_country = country_name"
    + "  FROM country "
    + " WHERE invchead_shipto_country != ''''"
    + "   AND UPPER(invchead_shipto_country) = UPPER(country_name)"
    + "   AND invchead_shipto_country != country_name"
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT invchead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Invoice (Ship-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE quhead SET quhead_billtocountry = country_name"
    + "  FROM country"
    + " WHERE quhead_billtocountry != ''''"
    + "   AND UPPER(quhead_billtocountry) = UPPER(country_name)"
    + "   AND quhead_billtocountry != country_name"
    + ''  <? if not exists("showAll") ?>''
    + "   AND quhead_expire >= CURRENT_DATE"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Quote (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE quhead SET quhead_shiptocountry = country_name"
    + "  FROM country"
    + " WHERE quhead_shiptocountry != ''''"
    + "   AND UPPER(quhead_shiptocountry) = UPPER(country_name)"
    + "   AND quhead_shiptocountry != country_name"
    + ''  <? if not exists("showAll") ?>''
    + "   AND quhead_expire >= CURRENT_DATE"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Quote (Ship-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE cohead SET cohead_billtocountry = country_name"
    + ''  FROM country <? if not exists("showAll") ?>, coitem<? endif ?>''
    + " WHERE cohead_billtocountry != ''''"
    + "   AND UPPER(cohead_billtocountry) = UPPER(country_name)"
    + "   AND cohead_billtocountry != country_name"
    + ''   <? if not exists("showAll") ?>''
    + "   AND cohead_id=coitem_cohead_id AND COALESCE(coitem_status, ''O'')=''O''"
    + "   <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Sales Order (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE cohead SET cohead_shiptocountry = country_name"
    + ''  FROM country <? if not exists("showAll") ?>, coitem<? endif ?>''
    + " WHERE cohead_shiptocountry != ''''"
    + "   AND UPPER(cohead_shiptocountry) = UPPER(country_name)"
    + "   AND cohead_shiptocountry != country_name"
    + ''   <? if not exists("showAll") ?>''
    + "   AND cohead_id=coitem_cohead_id AND COALESCE(coitem_status, ''O'')=''O''"
    + "   <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Sales Order (Ship-To): " + qry.lastError().text);

  } catch (e) { QMessageBox.critical(mywindow, "sFixCase() exception", e); }

  sFillList();
}

function sFixAbbr()
{
  try {
  if (QMessageBox.question(mywindow, qsTr("Are you sure?"),
                           qsTr("<p>Are you sure that you want to replace all "
                              + "country abbreviations to the corresponding "
                              + "full country names?<p>(This change will obey "
                              + "the status of the ''Show closed records'' "
                              + "check box."),
                       QMessageBox.Yes, QMessageBox.No) == QMessageBox.No)
    return;

  var params = new Object;
  if (_showAll.checked)
    params.showAll = true;

  var qry = toolbox.executeQuery(
      "UPDATE addr SET addr_country = country_name"
    + "  FROM country "
    + " WHERE addr_country != ''''"
    + "   AND UPPER(addr_country) = UPPER(country_abbr);", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Address: " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE cmhead SET cmhead_billtocountry = country_name"
    + "  FROM country "
    + " WHERE cmhead_billtocountry != ''''"
    + "   AND UPPER(cmhead_billtocountry) = UPPER(country_abbr)"
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT cmhead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Credit Memo (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE cmhead SET cmhead_shipto_country = country_name"
    + "  FROM country "
    + " WHERE cmhead_shipto_country != ''''"
    + "   AND UPPER(cmhead_shipto_country) = UPPER(country_abbr)"
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT cmhead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Credit Memo (Ship-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE invchead SET invchead_billto_country = country_name"
    + "  FROM country "
    + " WHERE invchead_billto_country != ''''"
    + "   AND UPPER(invchead_billto_country) = UPPER(country_abbr)"
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT invchead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Invoice (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE invchead SET invchead_shipto_country = country_name"
    + "  FROM country "
    + " WHERE invchead_shipto_country != ''''"
    + "   AND UPPER(invchead_shipto_country) = UPPER(country_abbr)"
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT invchead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Invoice (Ship-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE quhead SET quhead_billtocountry = country_name"
    + "  FROM country"
    + " WHERE quhead_billtocountry != ''''"
    + "   AND UPPER(quhead_billtocountry) = UPPER(country_abbr)"
    + ''  <? if not exists("showAll") ?>''
    + "   AND quhead_expire >= CURRENT_DATE"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Quote (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE quhead SET quhead_shiptocountry = country_name"
    + "  FROM country"
    + " WHERE quhead_shiptocountry != ''''"
    + "   AND UPPER(quhead_shiptocountry) = UPPER(country_abbr)"
    + ''  <? if not exists("showAll") ?>''
    + "   AND quhead_expire >= CURRENT_DATE"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Quote (Ship-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE cohead SET cohead_billtocountry = country_name"
    + ''  FROM country <? if not exists("showAll") ?>, coitem<? endif ?>''
    + " WHERE cohead_billtocountry != ''''"
    + "   AND UPPER(cohead_billtocountry) = UPPER(country_abbr)"
    + ''   <? if not exists("showAll") ?>''
    + "   AND cohead_id=coitem_cohead_id AND COALESCE(coitem_status, ''O'')=''O''"
    + "   <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Sales Order (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE cohead SET cohead_shiptocountry = country_name"
    + ''  FROM country <? if not exists("showAll") ?>, coitem<? endif ?>''
    + " WHERE cohead_shiptocountry != ''''"
    + "   AND UPPER(cohead_shiptocountry) = UPPER(country_abbr)"
    + ''   <? if not exists("showAll") ?>''
    + "   AND cohead_id=coitem_cohead_id AND COALESCE(coitem_status, ''O'')=''O''"
    + "   <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Sales Order (Ship-To): " + qry.lastError().text);

  } catch (e)
  {
    QMessageBox.critical(mywindow, "sFixAbbr() exception", e);
  }
  sFillList();
}

function sFillList()
{
  try {
  var params = new Object;
  if (_showAll.checked)
    params.showAll = true;

  var qry = toolbox.executeDbQuery(''fixcountry'', ''strictcountrycheck'', params);
  _list.populate(qry);
  if (qry.lastError().type != 0)
  {
    QMessageBox.critical(mywindow, qsTr("Database Error"),
                         qry.lastError().text);
    return;
  }
  } catch (e) { print("sFillList exception: " + e); }
}

_addCountry.clicked.connect(sAddCountry);
_edit.clicked.connect(sEdit);
_fixAbbr.clicked.connect(sFixAbbr);
_fixBulk.clicked.connect(sFixBulk);
_fixCase.clicked.connect(sFixCase);
_query.clicked.connect(sFillList);
_showAll.toggled.connect(sFillList);

sFillList();

if (QMessageBox.question(mywindow, qsTr("Backed Up?"),
                         qsTr("<p>Have you backed up your database? "
                            + "You really should back up your database "
                            + "before running this utility."),
                         QMessageBox.Yes, QMessageBox.No) == QMessageBox.No)
  mywindow.close()

', '');
INSERT INTO pkgscript (script_id, script_name, script_order, script_enabled, script_source, script_notes) VALUES (126, 'bulkFixCountry', 0, true, 'var _buttons    = mywindow.findChild("_buttons");
var _oldCountry = mywindow.findChild("_oldCountry");
var _newCountry = mywindow.findChild("_newCountry");
var _params;

function set(params)
{
  _params = params;
  var qry = toolbox.executeQuery(
      "SELECT MIN(id), country, country AS code "
    + "  FROM ("
    + "  SELECT addr_id AS id, addr_country AS country"
    + "    FROM addr"
    + "   WHERE addr_country != ''''"
    + "     AND addr_country NOT IN (SELECT country_name"
    + "                                FROM country"
    + "                               WHERE country_name IS NOT NULL)"
    + "  UNION ALL"
    + "  SELECT cmhead_id, cmhead_billtocountry"
    + "    FROM cmhead"
    + "   WHERE cmhead_billtocountry != ''''"
    + "     AND cmhead_billtocountry NOT IN (SELECT country_name"
    + "                                        FROM country"
    + "                                       WHERE country_name IS NOT NULL)"
    + ''     <? if not exists("showAll") ?> AND (NOT cmhead_posted) <? endif ?>''
    + "  UNION ALL"
    + "  SELECT cmhead_id, cmhead_shipto_country"
    + "    FROM cmhead"
    + "    WHERE cmhead_shipto_country != ''''"
    + "      AND cmhead_shipto_country NOT IN (SELECT country_name"
    + "                                          FROM country"
    + "                                         WHERE country_name IS NOT NULL)"
    + ''      <? if not exists("showAll") ?> AND (NOT cmhead_posted) <? endif ?>''
    + "  UNION ALL"
    + "  SELECT invchead_id, invchead_billto_country"
    + "    FROM invchead"
    + "   WHERE invchead_billto_country != ''''"
    + "     AND invchead_billto_country NOT IN (SELECT country_name"
    + "                                           FROM country"
    + "                                          WHERE country_name IS NOT NULL)"
    + ''     <? if not exists("showAll") ?> AND (NOT invchead_posted) <? endif ?>''
    + "  UNION ALL"
    + "  SELECT invchead_id, invchead_shipto_country"
    + "    FROM invchead"
    + "   WHERE invchead_shipto_country != ''''"
    + "     AND invchead_shipto_country NOT IN (SELECT country_name"
    + "                                           FROM country"
    + "                                          WHERE country_name IS NOT NULL)"
    + ''     <? if not exists("showAll") ?> AND (NOT invchead_posted) <? endif ?>''
    + "  UNION ALL"
    + "  SELECT quhead_id, quhead_billtocountry"
    + "    FROM quhead"
    + "   WHERE quhead_billtocountry != ''''"
    + "     AND quhead_billtocountry NOT IN (SELECT country_name"
    + "                                        FROM country"
    + "                                       WHERE country_name IS NOT NULL)"
    + ''     <? if not exists("showAll") ?> AND (quhead_expire>=CURRENT_DATE) <? endif ?>''
    + "  UNION ALL"
    + "  SELECT quhead_id, quhead_shiptocountry"
    + "    FROM quhead"
    + "   WHERE quhead_shiptocountry != ''''"
    + "     AND quhead_shiptocountry NOT IN (SELECT country_name"
    + "                                        FROM country"
    + "                                       WHERE country_name IS NOT NULL)"
    + ''     <? if not exists("showAll") ?> AND (quhead_expire>=CURRENT_DATE) <? endif ?>''
    + "  UNION ALL"
    + "  SELECT cohead_id, cohead_billtocountry"
    + "    FROM cohead"
    + "   WHERE cohead_billtocountry != ''''"
    + "     AND cohead_billtocountry NOT IN (SELECT country_name"
    + "                                        FROM country"
    + "                                       WHERE country_name IS NOT NULL)"
    + ''    <? if not exists("showAll") ?>''
    + "     AND cohead_id IN (SELECT coitem_cohead_id"
    + "                         FROM coitem"
    + "                        WHERE COALESCE(coitem_status, ''O'')=''O'')"
    + ''    <? endif ?>''
    + "  UNION ALL"
    + "  SELECT cohead_id, cohead_shiptocountry"
    + "    FROM cohead"
    + "   WHERE cohead_shiptocountry != ''''"
    + "     AND cohead_shiptocountry NOT IN (SELECT country_name"
    + "                                       FROM country"
    + "                                      WHERE country_name IS NOT NULL)"
    + ''    <? if not exists("showAll") ?>''
    + "     AND cohead_id IN (SELECT coitem_cohead_id"
    + "                         FROM coitem"
    + "                        WHERE COALESCE(coitem_status, ''O'')=''O'')"
    + ''    <? endif ?>''
    + ") AS dummy "
    + "GROUP BY country "
    + "ORDER BY country;",

                                 params);
  _oldCountry.populate(qry);
  if (qry.lastError().type != 0)
    toolbox.messageBox("warning", mywindow, qsTr("Database Error"),
                       qry.lastError().text);
}

function sSave()
{
  try {
  var params = _params;
  params.oldCountry = _oldCountry.currentText;
  params.newCountry = _newCountry.currentText;

  var qry = toolbox.executeQuery(
      ''UPDATE addr SET addr_country = <? value("newCountry") ?>''
    + '' WHERE addr_country = <? value("oldCountry") ?>;'', params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Address: " + qry.lastError().text);

  qry = toolbox.executeQuery(
      ''UPDATE cmhead SET cmhead_billtocountry = <? value("newCountry") ?>''
    + '' WHERE cmhead_billtocountry = <? value("oldCountry") ?>''
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT cmhead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Credit Memo (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      ''UPDATE cmhead SET cmhead_shipto_country = <? value("newCountry") ?>''
    + '' WHERE cmhead_shipto_country = <? value("oldCountry") ?>''
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT cmhead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Credit Memo (Ship-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      ''UPDATE invchead SET invchead_billto_country = <? value("newCountry") ?>''
    + '' WHERE invchead_billto_country = <? value("oldCountry") ?>''
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT invchead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Invoice (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      ''UPDATE invchead SET invchead_shipto_country = <? value("newCountry") ?>''
    + '' WHERE invchead_shipto_country = <? value("oldCountry") ?>''
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT invchead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Invoice (Ship-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      ''UPDATE quhead SET quhead_billtocountry = <? value("newCountry") ?>''
    + '' WHERE quhead_billtocountry = <? value("oldCountry") ?>''
    + ''  <? if not exists("showAll") ?>''
    + "   AND quhead_expire >= CURRENT_DATE"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Quote (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      ''UPDATE quhead SET quhead_shiptocountry = <? value("newCountry") ?>''
    + '' WHERE quhead_shiptocountry = <? value("oldCountry") ?>''
    + ''  <? if not exists("showAll") ?>''
    + "   AND quhead_expire >= CURRENT_DATE"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Quote (Ship-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      ''UPDATE cohead SET cohead_billtocountry = <? value("newCountry") ?>''
    + '' WHERE cohead_billtocountry = <? value("oldCountry") ?>''
    + ''   <? if not exists("showAll") ?>''
    + "   AND cohead_id IN (SELECT coitem_cohead_id"
    + "                     FROM coitem"
    + "                     WHERE COALESCE(coitem_status, ''O'')=''O'')"
    + "   <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Sales Order (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      ''UPDATE cohead SET cohead_shiptocountry = <? value("newCountry") ?>''
    + '' WHERE cohead_shiptocountry = <? value("oldCountry") ?>''
    + ''   <? if not exists("showAll") ?>''
    + "   AND cohead_id IN (SELECT coitem_cohead_id"
    + "                     FROM coitem"
    + "                     WHERE COALESCE(coitem_status, ''O'')=''O'')"
    + "   <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Sales Order (Ship-To): " + qry.lastError().text);

  }
  catch (e)
  {
     toolbox.messageBox("critical", mywindow,
                        "bulkFixCountry::sSave() exception", e);

  }
  mywindow.close();
}

_buttons.accepted.connect(sSave);
_buttons.rejected.connect(mywindow, "close()");
', '');


ALTER TABLE pkgscript ENABLE TRIGGER ALL;

--
-- TOC entry 9024 (class 0 OID 146618736)
-- Dependencies: 419 9464
-- Data for Name: pkguiform; Type: TABLE DATA; Schema: fixcountry; Owner: admin
--

ALTER TABLE pkguiform DISABLE TRIGGER ALL;

INSERT INTO pkguiform (uiform_id, uiform_name, uiform_order, uiform_enabled, uiform_source, uiform_notes) VALUES (58, 'fixCountries', 0, true, '<?xml version="1.0" encoding="UTF-8"?>
<ui version="4.0">
 <class>fixCountries</class>
 <widget class="QWidget" name="fixCountries">
  <property name="geometry">
   <rect>
    <x>0</x>
    <y>0</y>
    <width>800</width>
    <height>600</height>
   </rect>
  </property>
  <property name="maximumSize">
   <size>
    <width>1000</width>
    <height>16777215</height>
   </size>
  </property>
  <property name="windowTitle">
   <string>fixCountries</string>
  </property>
  <layout class="QGridLayout" name="gridLayout">
   <item row="1" column="1">
    <layout class="QVBoxLayout" name="verticalLayout">
     <item>
      <widget class="QPushButton" name="_query">
       <property name="text">
        <string>Query</string>
       </property>
      </widget>
     </item>
     <item>
      <spacer name="verticalSpacer">
       <property name="orientation">
        <enum>Qt::Vertical</enum>
       </property>
       <property name="sizeType">
        <enum>QSizePolicy::Fixed</enum>
       </property>
       <property name="sizeHint" stdset="0">
        <size>
         <width>20</width>
         <height>15</height>
        </size>
       </property>
      </spacer>
     </item>
     <item>
      <widget class="QPushButton" name="_fixCase">
       <property name="text">
        <string>Fix Case Differences</string>
       </property>
      </widget>
     </item>
     <item>
      <widget class="QPushButton" name="_fixAbbr">
       <property name="text">
        <string>Replace Abbreviations</string>
       </property>
      </widget>
     </item>
     <item>
      <widget class="QPushButton" name="_fixBulk">
       <property name="text">
        <string>Bulk Replace</string>
       </property>
      </widget>
     </item>
     <item>
      <spacer name="verticalSpacer_3">
       <property name="orientation">
        <enum>Qt::Vertical</enum>
       </property>
       <property name="sizeType">
        <enum>QSizePolicy::Fixed</enum>
       </property>
       <property name="sizeHint" stdset="0">
        <size>
         <width>20</width>
         <height>15</height>
        </size>
       </property>
      </spacer>
     </item>
     <item>
      <widget class="QPushButton" name="_edit">
       <property name="enabled">
        <bool>false</bool>
       </property>
       <property name="text">
        <string>Edit Selection</string>
       </property>
      </widget>
     </item>
     <item>
      <widget class="QPushButton" name="_addCountry">
       <property name="text">
        <string>Add Country</string>
       </property>
      </widget>
     </item>
     <item>
      <spacer name="verticalSpacer_2">
       <property name="orientation">
        <enum>Qt::Vertical</enum>
       </property>
       <property name="sizeHint" stdset="0">
        <size>
         <width>20</width>
         <height>40</height>
        </size>
       </property>
      </spacer>
     </item>
    </layout>
   </item>
   <item row="1" column="0">
    <widget class="XTreeWidget" name="_list">
     <property name="sizePolicy">
      <sizepolicy hsizetype="Expanding" vsizetype="Expanding">
       <horstretch>0</horstretch>
       <verstretch>3</verstretch>
      </sizepolicy>
     </property>
    </widget>
   </item>
   <item row="2" column="0">
    <widget class="XCheckBox" name="_showAll">
     <property name="text">
      <string>Show closed records</string>
     </property>
     <property name="forgetful">
      <bool>true</bool>
     </property>
    </widget>
   </item>
   <item row="0" column="0" colspan="2">
    <widget class="QLabel" name="label">
     <property name="text">
      <string>&lt;!DOCTYPE HTML PUBLIC &quot;-//W3C//DTD HTML 4.0//EN&quot; &quot;http://www.w3.org/TR/REC-html40/strict.dtd&quot;&gt;
&lt;html&gt;&lt;head&gt;&lt;meta name=&quot;qrichtext&quot; content=&quot;1&quot; /&gt;&lt;style type=&quot;text/css&quot;&gt;
p, li { white-space: pre-wrap; }
&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot; font-family:''Lucida Grande''; font-size:13pt; font-weight:400; font-style:normal;&quot;&gt;
&lt;p style=&quot; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;You must fix the countries in the following records before turning on Strict Country Checking (System &amp;gt; Configure Modules &amp;gt; CRM...).&lt;/p&gt;
&lt;p style=&quot;-qt-paragraph-type:empty; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;&lt;/p&gt;
&lt;p style=&quot; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;Here is a short description of your options (assume the &lt;span style=&quot; font-style:italic;&quot;&gt;country&lt;/span&gt; table has a country named ''Homeland'' with the abbreviation ''HL''):&lt;/p&gt;
&lt;ul style=&quot;-qt-list-indent: 1;&quot;&gt;&lt;li style=&quot; margin-top:12px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;&lt;span style=&quot; font-weight:600;&quot;&gt;Query&lt;/span&gt; will requery the database for records with invalid countries.&lt;/li&gt;
&lt;li style=&quot; font-weight:600;&quot; style=&quot; margin-top:1px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;Fix Case Differences&lt;span style=&quot; font-weight:400;&quot;&gt; will change all occurrences of ''HOMELAND'' or ''HomeLand'' to ''Homeland''.&lt;/span&gt;&lt;/li&gt;
&lt;li style=&quot; margin-top:1px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;&lt;span style=&quot; font-weight:600;&quot;&gt;Replace Abbreviations&lt;/span&gt; will change all occurrences of ''HL'' to ''Homeland''.&lt;/li&gt;
&lt;li style=&quot; margin-top:1px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;&lt;span style=&quot; font-weight:600;&quot;&gt;Bulk Replace&lt;/span&gt; will replace all occurrences of an invalid country that you choose with a valid country that you choose.&lt;/li&gt;
&lt;li style=&quot; margin-top:1px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;&lt;span style=&quot; font-weight:600;&quot;&gt;Edit Selection&lt;/span&gt; will open the selected record for you to fix. If a changed address remains on the list, delete duplicates with CRM &amp;gt; Address &amp;gt; List....&lt;/li&gt;
&lt;li style=&quot; margin-top:1px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;&lt;span style=&quot; font-weight:600;&quot;&gt;Add Country&lt;/span&gt; is for the rare case where you must add a new country. Try not to use this.&lt;/li&gt;
&lt;li style=&quot; margin-top:1px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;&lt;span style=&quot; font-weight:600;&quot;&gt;Show closed records&lt;/span&gt; will show historical data, such as closed sales orders and posted credit memos &amp;amp; invoices. These will continue to print properly if you don''t fix them, but you will have to change the country if you edit and save them with Strict Country Checking turned on.&lt;/li&gt;&lt;/ul&gt;&lt;/body&gt;&lt;/html&gt;</string>
     </property>
     <property name="textFormat">
      <enum>Qt::RichText</enum>
     </property>
     <property name="wordWrap">
      <bool>true</bool>
     </property>
    </widget>
   </item>
  </layout>
 </widget>
 <customwidgets>
  <customwidget>
   <class>XCheckBox</class>
   <extends>QCheckBox</extends>
   <header>xcheckbox.h</header>
  </customwidget>
  <customwidget>
   <class>XTreeWidget</class>
   <extends>QTreeWidget</extends>
   <header>xtreewidget.h</header>
  </customwidget>
 </customwidgets>
 <tabstops>
  <tabstop>_list</tabstop>
  <tabstop>_showAll</tabstop>
  <tabstop>_query</tabstop>
  <tabstop>_fixCase</tabstop>
  <tabstop>_fixAbbr</tabstop>
  <tabstop>_edit</tabstop>
  <tabstop>_addCountry</tabstop>
 </tabstops>
 <resources/>
 <connections>
  <connection>
   <sender>_list</sender>
   <signal>valid(bool)</signal>
   <receiver>_edit</receiver>
   <slot>setEnabled(bool)</slot>
   <hints>
    <hint type="sourcelabel">
     <x>551</x>
     <y>512</y>
    </hint>
    <hint type="destinationlabel">
     <x>616</x>
     <y>503</y>
    </hint>
   </hints>
  </connection>
 </connections>
</ui>
', '');
INSERT INTO pkguiform (uiform_id, uiform_name, uiform_order, uiform_enabled, uiform_source, uiform_notes) VALUES (59, 'bulkFixCountry', 0, true, '<?xml version="1.0" encoding="UTF-8"?>
<ui version="4.0">
 <class>bulkFixCountry</class>
 <widget class="QWidget" name="bulkFixCountry">
  <property name="geometry">
   <rect>
    <x>0</x>
    <y>0</y>
    <width>427</width>
    <height>162</height>
   </rect>
  </property>
  <property name="windowTitle">
   <string>Bulk Fix Invalid Country</string>
  </property>
  <layout class="QHBoxLayout" name="horizontalLayout">
   <item>
    <layout class="QFormLayout" name="formLayout">
     <item row="0" column="0">
      <widget class="QLabel" name="_oldCountryLit">
       <property name="text">
        <string>Replace all instances of this:</string>
       </property>
       <property name="buddy">
        <cstring>_oldCountry</cstring>
       </property>
      </widget>
     </item>
     <item row="1" column="0">
      <widget class="QLabel" name="_newCountryLit">
       <property name="text">
        <string>with this country:</string>
       </property>
       <property name="buddy">
        <cstring>_newCountry</cstring>
       </property>
      </widget>
     </item>
     <item row="1" column="1">
      <widget class="XComboBox" name="_newCountry">
       <property name="allowNull">
        <bool>true</bool>
       </property>
       <property name="type">
        <enum>XComboBox::Countries</enum>
       </property>
      </widget>
     </item>
     <item row="0" column="1">
      <widget class="XComboBox" name="_oldCountry"/>
     </item>
    </layout>
   </item>
   <item>
    <widget class="QDialogButtonBox" name="_buttons">
     <property name="orientation">
      <enum>Qt::Vertical</enum>
     </property>
     <property name="standardButtons">
      <set>QDialogButtonBox::Cancel|QDialogButtonBox::SaveAll</set>
     </property>
     <property name="centerButtons">
      <bool>false</bool>
     </property>
    </widget>
   </item>
  </layout>
 </widget>
 <customwidgets>
  <customwidget>
   <class>XComboBox</class>
   <extends>QComboBox</extends>
   <header>xcombobox.h</header>
  </customwidget>
 </customwidgets>
 <resources/>
 <connections/>
</ui>
', '');


ALTER TABLE pkguiform ENABLE TRIGGER ALL;

SET search_path = public, pg_catalog;

--
-- TOC entry 9025 (class 0 OID 146618744)
-- Dependencies: 420 9464
-- Data for Name: acalitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE acalitem DISABLE TRIGGER ALL;



ALTER TABLE acalitem ENABLE TRIGGER ALL;

--
-- TOC entry 8909 (class 0 OID 146616824)
-- Dependencies: 208 9464
-- Data for Name: curr_symbol; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE curr_symbol DISABLE TRIGGER ALL;

INSERT INTO curr_symbol (curr_id, curr_base, curr_name, curr_symbol, curr_abbr) VALUES (1, false, 'Base Currency - Change As Necessary', '$', 'USD');


ALTER TABLE curr_symbol ENABLE TRIGGER ALL;

--
-- TOC entry 8943 (class 0 OID 146617805)
-- Dependencies: 262 8909 9464
-- Data for Name: accnt; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE accnt DISABLE TRIGGER ALL;

INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (83, '1950', 'Unassigned Inv Transactions', '', '01', '01', 'A', '', '01', true, 'IN', 1, true, '01-01-1950-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (89, '1930', 'Transform Clearing', '', '01', '01', 'A', '', '01', true, 'IN', 1, true, '01-01-1930-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (91, '8910', 'Inventory Adjustment', '', '01', '01', 'E', '', '01', true, 'EXP', 1, true, '01-01-8910-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (92, '8920', 'Inventory Scrap', '', '01', '01', 'E', '', '01', true, 'EXP', 1, true, '01-01-8920-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (93, '8930', 'Manufacturing Scrap', '', '01', '01', 'E', '', '01', true, 'EXP', 1, true, '01-01-8930-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (94, '2320', 'Accrued Labor and Overhead Costs', '', '01', '01', 'L', '', '01', true, 'CL', 1, true, '01-01-2320-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (96, '1260', 'Shipping Asset', '', '01', '01', 'A', '', '01', true, 'IN', 1, true, '01-01-1260-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (98, '6550', 'P/O Line Item Freight Expense', '', '01', '01', 'E', '', '01', true, 'EXP', 1, true, '01-01-6550-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (99, '2000', 'Accounts Payable', '', '01', '01', 'L', '', '01', true, 'AP', 1, true, '01-01-2000-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (101, '4900', 'Promotions and Discounts Taken', '', '01', '01', 'R', '', '01', true, 'SI', 1, true, '01-01-4900-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (103, '4000', 'Revenue', '', '01', '01', 'R', '', '01', true, 'SI', 1, true, '01-01-4000-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (104, '2440', 'Prepaid Receivables', '', '01', '01', 'L', '', '01', true, 'CL', 1, true, '01-01-2440-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (105, '2490', 'Freight Liability - Sales', '', '01', '01', 'L', '', '01', true, 'CL', 1, true, '01-01-2490-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (107, '2450', 'Credit Memo', '', '01', '01', 'L', '', '01', true, 'CL', 1, true, '01-01-2450-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (108, '5000', 'Cost of Goods Sold', '', '01', '01', 'E', '', '01', true, 'COGS', 1, true, '01-01-5000-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (110, '6750', 'Finance Fees and Expenses', '', '01', '01', 'E', '', '01', true, 'EXP', 1, true, '01-01-6750-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (111, '1500', 'Fixed Assets', '', '01', '01', 'A', '', '01', true, 'FA', 1, true, '01-01-1500-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (116, '2700', 'Long Term Note Payable', '', '01', '01', 'L', '', '01', true, 'LTL', 1, true, '01-01-2700-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (88, '1470', 'Material Usage Variance', '', '01', '01', 'A', '', '01', true, 'IN', 1, true, '01-01-1470-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (117, '4050', 'State Sales Tax Revenue', '', '01', '01', 'R', '', '01', true, 'SI', 1, true, '01-01-4050-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (118, '4060', 'Shipping Charges Revenue', '', '01', '01', 'R', '', '01', true, 'SI', 1, true, '01-01-4060-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (119, '6050', 'State Sales Tax Expense', '', '01', '01', 'E', '', '01', true, 'EXP', 1, true, '01-01-6050-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (122, '5500', 'Currency Gain Loss', '', '01', '01', 'E', '', '01', true, 'EXP', 1, true, '01-01-5500-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (97, '6000', 'Office Supplies', '', '01', '01', 'E', '', '01', true, 'EXP', 1, true, '01-01-6000-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (123, '5550', 'G/L Discrepancy', 'Holds tiny amounts caused by rounding errors.', '01', '01', 'E', '', '01', true, 'EXP', 1, true, '01-01-5550-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (102, '2360', 'State Sales Tax Liability', '', '01', '01', 'L', '', '01', true, 'CL', 1, true, '01-01-2360-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (124, '2100', 'Customer Deposits', '', '01', '01', 'L', '', '01', true, 'CL', 1, true, '01-01-2100-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (95, '2480', 'P/O Liability Clearing', '', '01', '01', 'L', '', '01', true, 'CL', 1, true, '01-01-2480-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (84, '3030', 'Retained Earnings Year End', '', '01', '01', 'Q', '', '01', true, 'ERE', 1, true, '01-01-3030-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (113, '3010', 'Paid-In Capital', '', '01', '01', 'Q', '', '01', true, 'EDC', 1, true, '01-01-3010-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (86, '1210', 'Inventory Asset', '
', '01', '01', 'A', '', '01', true, 'IN', 1, true, '01-01-1210-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (85, '1250', 'WIP Asset', '', '01', '01', 'A', '', '01', true, 'IN', 1, true, '01-01-1250-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (109, '1000', 'Cash at Bank', '', '01', '01', 'A', '', '01', true, 'CA', 1, true, '01-01-1000-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (125, '1600', 'Accumulated Depreciation', '', '01', '01', 'A', '01-01-1600-01', '01', false, 'AD', 1, true, '01-01-1600-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (106, '1100', 'Accounts Receivable', '', '01', '01', 'A', '', '01', true, 'AR', 1, true, '01-01-1100-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (127, '6020', 'Shop Supplies', '', '01', '01', 'E', '01-01-6020-01', '01', false, 'EXP', 1, true, '01-01-6020-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (120, '6060', 'Inbound Freight Expense', '', '01', '01', 'E', '01-01-6060-01', '01', true, 'EXP', 1, true, '01-01-6060-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (128, '6070', 'Outbound Freight Expense', '', '01', '01', 'E', '01-01-6070-01', '01', false, 'EXP', 1, true, '01-01-6070-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (112, '6400', 'Depreciation Expense', '', '01', '01', 'E', '', '01', true, 'DEP', 1, true, '01-01-6400-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (129, '4010', 'Service Revenue', '', '01', '01', 'R', '01-01-4010-01', '01', false, 'SI', 1, true, '01-01-4010-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (121, '4800', 'Customer Credits', '', '01', '01', 'R', '01-01-4800-01', '01', true, 'SI', 1, true, '01-01-4800-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (130, '4810', 'Customer Discounts', '', '01', '01', 'R', '01-01-4810-01', '01', false, 'SI', 1, true, '01-01-4810-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (131, '6100', 'Expensed Inventory', '', '01', '01', 'E', '', '01', false, 'EXP', 1, true, '01-01-6100-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (132, '6200', 'Prepaid Expense', '', '01', '01', 'E', '', '01', false, 'EXP', 1, true, '01-01-6200-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (133, '5010', 'Inventory Cost Variance', '', '01', '01', 'E', '', '01', false, 'COGS', 1, true, '01-01-5010-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (134, '5030', 'Transform Clearing Expense', '', '01', '01', 'E', '', '01', false, 'COGS', 1, true, '01-01-5030-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (135, '5020', 'Purchase Price Variance', '', '01', '01', 'E', '', '01', false, 'COGS', 1, true, '01-01-5020-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (126, '8980', 'Purchase Expense Variance', '', '01', '01', 'E', '01-01-8980-01', '01', false, 'COGS', 1, true, '01-01-8980-01');
INSERT INTO accnt (accnt_id, accnt_number, accnt_descrip, accnt_comments, accnt_profit, accnt_sub, accnt_type, accnt_extref, accnt_company, accnt_forwardupdate, accnt_subaccnttype_code, accnt_curr_id, accnt_active, accnt_name) VALUES (136, '2600', 'Project Labor and Overhead', '', '01', '01', 'L', '', '01', false, 'CL', 1, true, '01-01-2600-01');


ALTER TABLE accnt ENABLE TRIGGER ALL;

--
-- TOC entry 9468 (class 0 OID 0)
-- Dependencies: 421
-- Name: accnt_accnt_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('accnt_accnt_id_seq', 136, true);


--
-- TOC entry 8929 (class 0 OID 146617627)
-- Dependencies: 234 9464
-- Data for Name: addr; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE addr DISABLE TRIGGER ALL;

INSERT INTO addr (addr_id, addr_active, addr_line1, addr_line2, addr_line3, addr_city, addr_state, addr_postalcode, addr_country, addr_notes, addr_number) VALUES (2, true, 'Warehouse Address Line 1', 'Warehouse Address Line 2', 'Warehouse Address Line 3', 'Warehouse Address Line 4', 'VA', '9999-9999', 'United States', '', '2');
INSERT INTO addr (addr_id, addr_active, addr_line1, addr_line2, addr_line3, addr_city, addr_state, addr_postalcode, addr_country, addr_notes, addr_number) VALUES (1, true, 'Warehouse Address Line 1', 'Warehouse Address Line 2', 'Warehouse Address Line 3', 'Warehouse Address Line 4', '', '', 'United States', '', '1');
INSERT INTO addr (addr_id, addr_active, addr_line1, addr_line2, addr_line3, addr_city, addr_state, addr_postalcode, addr_country, addr_notes, addr_number) VALUES (3, true, 'Accounts Receivable', 'Moving Forward Business Park', '12100 Let''s Go', 'Norfolk', 'VA', '23100', 'United States', '', '3');


ALTER TABLE addr ENABLE TRIGGER ALL;

--
-- TOC entry 9469 (class 0 OID 0)
-- Dependencies: 422
-- Name: addr_addr_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('addr_addr_id_seq', 3, true);


--
-- TOC entry 9028 (class 0 OID 146618760)
-- Dependencies: 424 9464
-- Data for Name: alarm; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE alarm DISABLE TRIGGER ALL;



ALTER TABLE alarm ENABLE TRIGGER ALL;

--
-- TOC entry 9470 (class 0 OID 0)
-- Dependencies: 425
-- Name: alarm_alarm_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('alarm_alarm_id_seq', 1, false);


--
-- TOC entry 9030 (class 0 OID 146618771)
-- Dependencies: 426 9464
-- Data for Name: apaccnt; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE apaccnt DISABLE TRIGGER ALL;

INSERT INTO apaccnt (apaccnt_id, apaccnt_vendtype_id, apaccnt_vendtype, apaccnt_ap_accnt_id, apaccnt_prepaid_accnt_id, apaccnt_discount_accnt_id) VALUES (20, -1, '.*', 99, 132, 101);


ALTER TABLE apaccnt ENABLE TRIGGER ALL;

--
-- TOC entry 9471 (class 0 OID 0)
-- Dependencies: 427
-- Name: apaccnt_apaccnt_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('apaccnt_apaccnt_id_seq', 20, true);


--
-- TOC entry 8946 (class 0 OID 146617829)
-- Dependencies: 266 8909 9464
-- Data for Name: bankaccnt; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE bankaccnt DISABLE TRIGGER ALL;

INSERT INTO bankaccnt (bankaccnt_id, bankaccnt_name, bankaccnt_descrip, bankaccnt_bankname, bankaccnt_accntnumber, bankaccnt_ar, bankaccnt_ap, bankaccnt_nextchknum, bankaccnt_type, bankaccnt_accnt_id, bankaccnt_check_form_id, bankaccnt_userec, bankaccnt_rec_accnt_id, bankaccnt_curr_id, bankaccnt_notes, bankaccnt_routing, bankaccnt_ach_enabled, bankaccnt_ach_origin, bankaccnt_ach_genchecknum, bankaccnt_ach_leadtime, bankaccnt_ach_lastdate, bankaccnt_ach_lastfileid, bankaccnt_ach_origintype, bankaccnt_ach_originname, bankaccnt_ach_desttype, bankaccnt_ach_fed_dest, bankaccnt_ach_destname, bankaccnt_ach_dest) VALUES (13, 'Bank', 'Bank', 'Bank', '0000000000', true, true, 5000, 'K', 109, 21, NULL, NULL, 1, NULL, '', false, '', false, NULL, NULL, NULL, 'I', NULL, NULL, NULL, NULL, NULL);


ALTER TABLE bankaccnt ENABLE TRIGGER ALL;

--
-- TOC entry 8988 (class 0 OID 146618387)
-- Dependencies: 358 9464
-- Data for Name: expcat; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE expcat DISABLE TRIGGER ALL;

INSERT INTO expcat (expcat_id, expcat_code, expcat_descrip, expcat_exp_accnt_id, expcat_liability_accnt_id, expcat_active, expcat_purchprice_accnt_id, expcat_freight_accnt_id) VALUES (16, 'SALES_TAX', 'Sales Tax (Clear Liability)', 102, 95, true, 126, 98);
INSERT INTO expcat (expcat_id, expcat_code, expcat_descrip, expcat_exp_accnt_id, expcat_liability_accnt_id, expcat_active, expcat_purchprice_accnt_id, expcat_freight_accnt_id) VALUES (19, 'FREIGHT_OUTBOUND', 'Outbound Freight Expense', 128, 95, true, 126, 98);
INSERT INTO expcat (expcat_id, expcat_code, expcat_descrip, expcat_exp_accnt_id, expcat_liability_accnt_id, expcat_active, expcat_purchprice_accnt_id, expcat_freight_accnt_id) VALUES (15, 'SUPPLIES_OFFICE', 'Office Supplies', 97, 95, true, 126, 98);
INSERT INTO expcat (expcat_id, expcat_code, expcat_descrip, expcat_exp_accnt_id, expcat_liability_accnt_id, expcat_active, expcat_purchprice_accnt_id, expcat_freight_accnt_id) VALUES (17, 'FREIGHT_INBOUND', 'Inbound Freight Expense', 120, 95, true, 126, 98);
INSERT INTO expcat (expcat_id, expcat_code, expcat_descrip, expcat_exp_accnt_id, expcat_liability_accnt_id, expcat_active, expcat_purchprice_accnt_id, expcat_freight_accnt_id) VALUES (18, 'SUPPLIES_SHOP', 'Shop Supplies', 97, 95, true, 126, 98);


ALTER TABLE expcat ENABLE TRIGGER ALL;

--
-- TOC entry 9034 (class 0 OID 146618788)
-- Dependencies: 430 8946 8909 8988 9464
-- Data for Name: checkhead; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE checkhead DISABLE TRIGGER ALL;



ALTER TABLE checkhead ENABLE TRIGGER ALL;

--
-- TOC entry 8905 (class 0 OID 146616178)
-- Dependencies: 204 8929 9464
-- Data for Name: cntct; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cntct DISABLE TRIGGER ALL;

INSERT INTO cntct (cntct_id, cntct_crmacct_id, cntct_addr_id, cntct_first_name, cntct_last_name, cntct_honorific, cntct_initials, cntct_active, cntct_phone, cntct_phone2, cntct_fax, cntct_email, cntct_webaddr, cntct_notes, cntct_title, cntct_number, cntct_middle, cntct_suffix, cntct_owner_username, cntct_name) VALUES (2, NULL, 2, '', 'Main Warehouse', NULL, NULL, true, '', NULL, '', '', NULL, NULL, NULL, '2', NULL, NULL, NULL, 'Main Warehouse');


ALTER TABLE cntct ENABLE TRIGGER ALL;

--
-- TOC entry 8919 (class 0 OID 146616945)
-- Dependencies: 220 9464
-- Data for Name: taxzone; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE taxzone DISABLE TRIGGER ALL;

INSERT INTO taxzone (taxzone_id, taxzone_code, taxzone_descrip) VALUES (1, 'SALES TAX', 'State Sales Tax Authority');


ALTER TABLE taxzone ENABLE TRIGGER ALL;

--
-- TOC entry 9001 (class 0 OID 146618596)
-- Dependencies: 393 9464
-- Data for Name: vendtype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE vendtype DISABLE TRIGGER ALL;

INSERT INTO vendtype (vendtype_id, vendtype_code, vendtype_descrip) VALUES (18, 'NORMAL', 'Normal Vendor');
INSERT INTO vendtype (vendtype_id, vendtype_code, vendtype_descrip) VALUES (19, 'TAX AUTHORITY', 'Tax Authority');
INSERT INTO vendtype (vendtype_id, vendtype_code, vendtype_descrip) VALUES (20, 'EMPLOYEE', 'Employee');


ALTER TABLE vendtype ENABLE TRIGGER ALL;

--
-- TOC entry 8911 (class 0 OID 146616837)
-- Dependencies: 210 8909 8905 8905 8929 8919 9001 9464
-- Data for Name: vendinfo; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE vendinfo DISABLE TRIGGER ALL;

INSERT INTO vendinfo (vend_id, vend_name, vend_lastpurchdate, vend_active, vend_po, vend_comments, vend_pocomments, vend_number, vend_1099, vend_exported, vend_fobsource, vend_fob, vend_terms_id, vend_shipvia, vend_vendtype_id, vend_qualified, vend_ediemail, vend_ediemailbody, vend_edisubject, vend_edifilename, vend_accntnum, vend_emailpodelivery, vend_restrictpurch, vend_edicc, vend_curr_id, vend_cntct1_id, vend_cntct2_id, vend_addr_id, vend_match, vend_ach_enabled, vend_ach_accnttype, vend_ach_use_vendinfo, vend_ach_indiv_number, vend_ach_indiv_name, vend_ediemailhtml, vend_ach_routingnumber, vend_ach_accntnumber, vend_taxzone_id, vend_accnt_id, vend_expcat_id, vend_tax_id) VALUES (78, 'State Sales Tax Authority', NULL, true, false, '', '', 'SALES TAX', false, NULL, 'W', '', 43, 'USPS', 19, false, '', '', '', '', '', false, false, '', 1, NULL, NULL, NULL, false, false, NULL, true, '', '', false, '\x', '\x', NULL, NULL, -1, -1);


ALTER TABLE vendinfo ENABLE TRIGGER ALL;

--
-- TOC entry 9032 (class 0 OID 146618779)
-- Dependencies: 428 9034 8911 8909 9464
-- Data for Name: apapply; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE apapply DISABLE TRIGGER ALL;



ALTER TABLE apapply ENABLE TRIGGER ALL;

--
-- TOC entry 9472 (class 0 OID 0)
-- Dependencies: 429
-- Name: apapply_apapply_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('apapply_apapply_id_seq', 1, false);


--
-- TOC entry 9036 (class 0 OID 146618822)
-- Dependencies: 434 8909 9464
-- Data for Name: apcreditapply; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE apcreditapply DISABLE TRIGGER ALL;



ALTER TABLE apcreditapply ENABLE TRIGGER ALL;

--
-- TOC entry 9473 (class 0 OID 0)
-- Dependencies: 435
-- Name: apcreditapply_apcreditapply_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('apcreditapply_apcreditapply_id_seq', 1, false);


--
-- TOC entry 8908 (class 0 OID 146616809)
-- Dependencies: 207 8911 8909 9464
-- Data for Name: apopen; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE apopen DISABLE TRIGGER ALL;



ALTER TABLE apopen ENABLE TRIGGER ALL;

--
-- TOC entry 9474 (class 0 OID 0)
-- Dependencies: 437
-- Name: apopen_apopen_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('apopen_apopen_id_seq', 70, true);


--
-- TOC entry 8954 (class 0 OID 146617951)
-- Dependencies: 284 8943 8929 8909 9464
-- Data for Name: taxauth; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE taxauth DISABLE TRIGGER ALL;

INSERT INTO taxauth (taxauth_id, taxauth_code, taxauth_name, taxauth_extref, taxauth_addr_id, taxauth_curr_id, taxauth_county, taxauth_accnt_id) VALUES (1, 'SALES TAX', 'State Sales Tax Authority', '', NULL, 1, '', 102);


ALTER TABLE taxauth ENABLE TRIGGER ALL;

--
-- TOC entry 9386 (class 0 OID 146620369)
-- Dependencies: 807 9464
-- Data for Name: taxclass; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE taxclass DISABLE TRIGGER ALL;

INSERT INTO taxclass (taxclass_id, taxclass_code, taxclass_descrip, taxclass_sequence) VALUES (1, '1', 'Legacy Class 1', 0);
INSERT INTO taxclass (taxclass_id, taxclass_code, taxclass_descrip, taxclass_sequence) VALUES (2, '2', 'Legacy Class 2', 0);
INSERT INTO taxclass (taxclass_id, taxclass_code, taxclass_descrip, taxclass_sequence) VALUES (3, '3', 'Legacy Class 3', 0);

ALTER TABLE taxclass ENABLE TRIGGER ALL;

--
-- TOC entry 8990 (class 0 OID 146618421)
-- Dependencies: 363 8943 8954 9386 9464
-- Data for Name: tax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE tax DISABLE TRIGGER ALL;

INSERT INTO tax (tax_id, tax_code, tax_descrip, tax_sales_accnt_id, tax_taxclass_id, tax_taxauth_id, tax_basis_tax_id) VALUES (13, 'Sales Tax', 'Sales Tax', 102, NULL, NULL, NULL);


ALTER TABLE tax ENABLE TRIGGER ALL;

--
-- TOC entry 8901 (class 0 OID 146615814)
-- Dependencies: 199 9464
-- Data for Name: taxtype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE taxtype DISABLE TRIGGER ALL;

INSERT INTO taxtype (taxtype_id, taxtype_name, taxtype_descrip, taxtype_sys) VALUES (1, 'Freight', 'System Defined Freight Tax Type. DO NOT CHANGE.', true);
INSERT INTO taxtype (taxtype_id, taxtype_name, taxtype_descrip, taxtype_sys) VALUES (2, 'Taxable', 'Taxable Item', false);
INSERT INTO taxtype (taxtype_id, taxtype_name, taxtype_descrip, taxtype_sys) VALUES (3, 'Adjustment', 'System Defined Adjustment Tax Type. DO NOT CHANGE.', true);


ALTER TABLE taxtype ENABLE TRIGGER ALL;

--
-- TOC entry 9039 (class 0 OID 146618834)
-- Dependencies: 438 8990 8908 8990 8901 9464
-- Data for Name: apopentax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE apopentax DISABLE TRIGGER ALL;



ALTER TABLE apopentax ENABLE TRIGGER ALL;

--
-- TOC entry 9040 (class 0 OID 146618840)
-- Dependencies: 439 8909 9464
-- Data for Name: apselect; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE apselect DISABLE TRIGGER ALL;



ALTER TABLE apselect ENABLE TRIGGER ALL;

--
-- TOC entry 9475 (class 0 OID 0)
-- Dependencies: 440
-- Name: apselect_apselect_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('apselect_apselect_id_seq', 501, true);


--
-- TOC entry 9042 (class 0 OID 146618847)
-- Dependencies: 441 9464
-- Data for Name: araccnt; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE araccnt DISABLE TRIGGER ALL;

INSERT INTO araccnt (araccnt_id, araccnt_custtype_id, araccnt_custtype, araccnt_freight_accnt_id, araccnt_ar_accnt_id, araccnt_prepaid_accnt_id, araccnt_deferred_accnt_id, araccnt_discount_accnt_id) VALUES (39, -1, '.*', 118, 106, 121, 124, 130);


ALTER TABLE araccnt ENABLE TRIGGER ALL;

--
-- TOC entry 9476 (class 0 OID 0)
-- Dependencies: 442
-- Name: araccnt_araccnt_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('araccnt_araccnt_id_seq', 39, true);


--
-- TOC entry 9044 (class 0 OID 146618856)
-- Dependencies: 443 8909 9464
-- Data for Name: arapply; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE arapply DISABLE TRIGGER ALL;



ALTER TABLE arapply ENABLE TRIGGER ALL;

--
-- TOC entry 9477 (class 0 OID 0)
-- Dependencies: 444
-- Name: arapply_arapply_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('arapply_arapply_id_seq', 1, false);


--
-- TOC entry 9047 (class 0 OID 146618867)
-- Dependencies: 446 8909 9464
-- Data for Name: arcreditapply; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE arcreditapply DISABLE TRIGGER ALL;



ALTER TABLE arcreditapply ENABLE TRIGGER ALL;

--
-- TOC entry 9478 (class 0 OID 0)
-- Dependencies: 447
-- Name: arcreditapply_arcreditapply_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('arcreditapply_arcreditapply_id_seq', 1, false);


--
-- TOC entry 8972 (class 0 OID 146618199)
-- Dependencies: 325 9464
-- Data for Name: costcat; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE costcat DISABLE TRIGGER ALL;

INSERT INTO costcat (costcat_id, costcat_code, costcat_descrip, costcat_asset_accnt_id, costcat_liability_accnt_id, costcat_adjustment_accnt_id, costcat_matusage_accnt_id, costcat_purchprice_accnt_id, costcat_laboroverhead_accnt_id, costcat_scrap_accnt_id, costcat_invcost_accnt_id, costcat_wip_accnt_id, costcat_shipasset_accnt_id, costcat_mfgscrap_accnt_id, costcat_transform_accnt_id, costcat_freight_accnt_id, costcat_toliability_accnt_id, costcat_exp_accnt_id) VALUES (30, 'CATEGORY1', 'Cost Category 1', 86, 95, 91, 88, 135, 94, 92, 133, 85, 96, 93, 89, 98, NULL, 131);


ALTER TABLE costcat ENABLE TRIGGER ALL;

--
-- TOC entry 8951 (class 0 OID 146617922)
-- Dependencies: 280 9464
-- Data for Name: custtype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE custtype DISABLE TRIGGER ALL;

INSERT INTO custtype (custtype_id, custtype_code, custtype_descrip, custtype_char) VALUES (18, 'NORMAL', 'Normal Customer', false);


ALTER TABLE custtype ENABLE TRIGGER ALL;

--
-- TOC entry 8956 (class 0 OID 146617990)
-- Dependencies: 291 9464
-- Data for Name: dept; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE dept DISABLE TRIGGER ALL;

INSERT INTO dept (dept_id, dept_number, dept_name) VALUES (1, 'MFG', 'Manufacturing');
INSERT INTO dept (dept_id, dept_number, dept_name) VALUES (2, 'ADM', 'Administration');


ALTER TABLE dept ENABLE TRIGGER ALL;

--
-- TOC entry 8938 (class 0 OID 146617732)
-- Dependencies: 248 9464
-- Data for Name: image; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE image DISABLE TRIGGER ALL;

INSERT INTO image (image_id, image_name, image_descrip, image_data) VALUES (14, 'Blue Pinstripe Background', 'Blue Pinstripe Background', 'begin 644 internal
MB5!.1PT*&@H````-24A$4@````(````""`(```#]U)IS````"7!(67,```L2
M```+$@''2W7[\````%DE$050(F6-DLNUD8&!@\?+R8F!@```-9P&L)F@250``
*``!)14Y$KD)@@@``
`
end
');
INSERT INTO image (image_id, image_name, image_descrip, image_data) VALUES (15, 'logo', 'logo', 'begin 644 internal
MB5!.1PT*&@H````-24A$4@```3T```!D"`,```##LQ<D```#`%!,5$4```"`
M````@`"`@````("``(``@(#`P,#`W,"FRO!`(`!@(`"`(`"@(`#`(`#@(```
M0``@0`!`0`!@0`"`0`"@0`#`0`#@0```8``@8`!`8`!@8`"`8`"@8`#`8`#@
M8```@``@@`!`@`!@@`"`@`"@@`#`@`#@@```H``@H`!`H`!@H`"`H`"@H`#`
MH`#@H```P``@P`!`P`!@P`"`P`"@P`#`P`#@P```X``@X`!`X`!@X`"`X`"@
MX`#`X`#@X````$`@`$!``$!@`$"``$"@`$#``$#@`$``($`@($!`($!@($"`
M($"@($#`($#@($``0$`@0$!`0$!@0$"`0$"@0$#`0$#@0$``8$`@8$!`8$!@
M8$"`8$"@8$#`8$#@8$``@$`@@$!`@$!@@$"`@$"@@$#`@$#@@$``H$`@H$!`
MH$!@H$"`H$"@H$#`H$#@H$``P$`@P$!`P$!@P$"`P$"@P$#`P$#@P$``X$`@
MX$!`X$!@X$"`X$"@X$#`X$#@X$```(`@`(!``(!@`("``("@`(#``(#@`(``
M((`@((!`((!@(("`(("@((#`((#@((``0(`@0(!`0(!@0("`0("@0(#`0(#@
M0(``8(`@8(!`8(!@8("`8("@8(#`8(#@8(``@(`@@(!`@(!@@("`@("@@(#`
M@(#@@(``H(`@H(!`H(!@H("`H("@H(#`H(#@H(``P(`@P(!`P(!@P("`P("@
MP(#`P(#@P(``X(`@X(!`X(!@X("`X("@X(#`X(#@X(```,`@`,!``,!@`,"`
M`,"@`,#``,#@`,``(,`@(,!`(,!@(,"`(,"@(,#`(,#@(,``0,`@0,!`0,!@
M0,"`0,"@0,#`0,#@0,``8,`@8,!`8,!@8,"`8,"@8,#`8,#@8,``@,`@@,!`
M@,!@@,"`@,"@@,#`@,#@@,``H,`@H,!`H,!@H,"`H,"@H,#`H,#@H,``P,`@
MP,!`P,!@P,"`P,"@P,#_^_"@H*2`@(#_````_P#__P```/__`/\`______]8
MTC1$````"7!(67,```[$```.Q`&5*PX;```&HTE$051XG.V;/7+C.@S''MW!N
MI-;*%5+L`3QO=AL=(&UF<@=?0:U*''4[-6Y$B/DA`E@)*6;^''?Y%Q:`H`?Z(H
M?L`_+JZOZ\=W!_#4<GH6.3V+G)Y%3L\BIV>1T[/(Z5GD]"QR>A81>M>)JM]C
MY>UU[Q5''&ZIL2Y%*;YKNVZTXO8+>Q\MF*TZOH#>-FZW\E?1.4$8O`6OV=3ZG
MQ^A%?)M''/J?''Z76$7F@2?M6&;T*%X4)J].3[N>=^HNDF+\E,\G*@%WR`$R@9
M@@]X,LI:F:U;]-W`5*+E#U89L.!&C%BC=T4'';1H''!W1V3X7WO-%D]$P-ZHJ1
M-#<ITL/+`"=XQ68)M41Z_TR)4</K"P$+;N2(5\>]3W9=NI(4)./8Z(9^V5_R
MHC&WD.$C]+JIJ"5X%FJ)]"3=E8`%-TK$:^]<Q''%?PNS14K\4C2S0\&%($8?O
MX-,U62A-"O3"9?/]:W@H0WJ(0K.$6AJ],5TXFX!Q1PA8<*-%O$)O@!#NZ2Z''
MWMB""1@<29>Y+5WVFJICEVY)&[A)@1Y<''T(''QWBS0K.$6@J]\%T#B,!6&7#I
M1HU8IX?/S_(XMXN)%BS`C1->E:DUZ/E/T:B8+%M,+DMEMXE8RILEA,#I#<EU
MK,\&>1:PX$:-6*$WT,(!/_:+`5(T2J''''AR4%PR>.@LFRQ1VY[(I/VW+?.]*L
MK)9&K[\PJWE7Q8`%-VK$PEOC.A''+;`2--@B]1J*''=P&"8?0$DV6+:>L6+Z0H
MW1*AED8/''[R"''@]8<*-&++US*;Z]]):!^7GH%0%;Z<7:PO0D?K]&+\720Q`/
MZ<DM/HM>&?!C>NA%I!<G43"Z9O,H?%V5XQXN\(1!F/@I5P99B[5Q#Z?(.\<]
MA5X9L.!&C5B>+>.S6]Q1^LX-''Z''+\3<*N[DPF7F13:ZU6''KGII604&LGO3)@
MP8T:L4SOMO1FJ>NLSO<@F#A72O,],J-ZD4R6+5Z=[\4)W+[YWB-Z&''#I1HWX
MX0[5-5W9\"6?O-9(ZPF<`&3+@5$T*=!;66LLQO>M-11Z0L""&RUB;9<`7AS\
MG?1RR<;0;)W+EY3E4C24E"8%>FP!JJ]SA5J[Z$D!EVZTB%=WJ*++5C`^-,R2
ML$O0XZP<\96SR*SS;=MC^?B%5V[<8U%G+%+`@ALY8HU>[*PCAL&;/N`J+6MT
MK#SPH;;)_68F17KJ_E[/%S";]O?TV;(4L.!&C/@+Y[FM&.NINDGDO\''-$]''[
M<_=3KR3+]F]U\T3TXM@S/X&X[/]F-\]$C[Z\#WQP=[AY)GIT>K+CJ/Y`-T]%
M#S>3=F2)''.G&<Z@L<GH6.3V+G)Y%3L\BIV>1T[/(Z5FTA5ZV;82Y4D<MU%>\
M_UW:3:^=G!YH)[T./CF]R]YQ+\MR=''J[:CL]+J=G$=!KIOQ0''9*Q4ORX;3@`
MO2R!>A;9P:+''*MGA#=:"E*\FN(&MW44U$\%K"^CA"0@"6?(W=''H-_H\BI_IX
M3%4<''&KTVGQ3LF8B>&T!O3E(<O(+)[GW%7HHNHU(\A92GHN0G*W0*^]&S43P
MVL)Q+V5%8J]/W3''+SJ._+$B9T&P$A)0CN"-"PH1*3SW4KI`(7EM(KUN:$]LP
MDA*=''K2`''9X`#CC14U)Z)''I%;ZF9"%Y;2"]TE)@7\XX9,CPC/J/''WBU9>^\7
M[,Y2<K9&KSA*J)D(7EM9)L8]N/S]FCYA<JI$#U\(8EXW/+A2DJ)"KSS$JID(
M7EN$7ER%W6;GUY3%P?/+MM);!DPP("7(:O2*)ZUF,FYM$7ISF./L$?_DS#;2
M6U[68.#_0"_,-S^O<Z.ZY5/^*[2M].+4&V9@Z_2:_P:]V=D\Z0Q#WL?/5Y:!
MMHL>_"JQK%&.>UOI54@$KRU*;V[S^Y1R[-\!U''YZ@0T:D)*S\?KK1GH5$L%K
MB^T2Q(G[>,G2%;]`;YGOTTZ0S<&@"-.M'']"KD`A>6XQ>9#;W]0XXLOC)\[9.
M;\FT3(/.XU7"%GKV1/#:8O3PAP:Q37T>?UK=#H_HX4(NJDS.9HG4V^C9$\%K
MB^_OX?8*W7EB/UA)?>H!O0Z8D/_AYM"2\''K:1L^<"%Y;G![&3UM"XX]=YC$]
MEA0.U7C1\K.9M^WTK(G@M778>6[QP^6#=5(B.-=1],H?S1^ADQ+!51U$[W;.
MDW-6(KBF(^CQWQ$=JI,2P34=2.^4GG!2(KBB(^CELY5C=5(BN"C/H;+(Z5GD
M]"QR>A8Y/8N<GD5.SR*G9Y''3L\CI6>3T+'')Z%CD]BYR>14[/(J=GD=.SR.E9
EY/0L<GH6.3V+G)Y%3L^B?P$*T4@_;<-^G`````!)14Y$KD)@@J=G
`
end
');


ALTER TABLE image ENABLE TRIGGER ALL;

--
-- TOC entry 8958 (class 0 OID 146618010)
-- Dependencies: 293 9464
-- Data for Name: shift; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE shift DISABLE TRIGGER ALL;

INSERT INTO shift (shift_id, shift_number, shift_name) VALUES (1, '1ST', 'First Shift');


ALTER TABLE shift ENABLE TRIGGER ALL;

--
-- TOC entry 8953 (class 0 OID 146617938)
-- Dependencies: 282 9464
-- Data for Name: shipform; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE shipform DISABLE TRIGGER ALL;

INSERT INTO shipform (shipform_id, shipform_name, shipform_report_id, shipform_report_name) VALUES (12, 'STD-PACKING-LIST', 80, 'PackingList');


ALTER TABLE shipform ENABLE TRIGGER ALL;

--
-- TOC entry 8999 (class 0 OID 146618557)
-- Dependencies: 386 9464
-- Data for Name: shipvia; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE shipvia DISABLE TRIGGER ALL;

INSERT INTO shipvia (shipvia_id, shipvia_code, shipvia_descrip) VALUES (13, 'UPS-Ground', 'UPS Ground');
INSERT INTO shipvia (shipvia_id, shipvia_code, shipvia_descrip) VALUES (14, 'UPS-Next Day', 'UPS-Next Day');
INSERT INTO shipvia (shipvia_id, shipvia_code, shipvia_descrip) VALUES (15, 'SAIA', 'SAIA');
INSERT INTO shipvia (shipvia_id, shipvia_code, shipvia_descrip) VALUES (17, 'AVERITT', 'Averitt');
INSERT INTO shipvia (shipvia_id, shipvia_code, shipvia_descrip) VALUES (18, 'DHL', 'DHL');
INSERT INTO shipvia (shipvia_id, shipvia_code, shipvia_descrip) VALUES (19, 'FEDEX-Ground', 'FEDEX-Ground');
INSERT INTO shipvia (shipvia_id, shipvia_code, shipvia_descrip) VALUES (20, 'FEDEX-Next Day', 'FEDEX-Next Day');
INSERT INTO shipvia (shipvia_id, shipvia_code, shipvia_descrip) VALUES (21, 'ROADWAY', 'ROADWAY');
INSERT INTO shipvia (shipvia_id, shipvia_code, shipvia_descrip) VALUES (22, 'USF', 'USF');
INSERT INTO shipvia (shipvia_id, shipvia_code, shipvia_descrip) VALUES (23, 'WATKINS', 'Watkins');
INSERT INTO shipvia (shipvia_id, shipvia_code, shipvia_descrip) VALUES (24, 'YELLOW', 'Yellow');


ALTER TABLE shipvia ENABLE TRIGGER ALL;

--
-- TOC entry 9000 (class 0 OID 146618565)
-- Dependencies: 387 9464
-- Data for Name: sitetype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE sitetype DISABLE TRIGGER ALL;

INSERT INTO sitetype (sitetype_id, sitetype_name, sitetype_descrip) VALUES (1, 'WHSE', 'Warehouse');


ALTER TABLE sitetype ENABLE TRIGGER ALL;

--
-- TOC entry 8896 (class 0 OID 146615725)
-- Dependencies: 193 8943 8929 8972 8953 8999 9000 8919 9464
-- Data for Name: whsinfo; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE whsinfo DISABLE TRIGGER ALL;

INSERT INTO whsinfo (warehous_id, warehous_code, warehous_descrip, warehous_fob, warehous_active, warehous_counttag_prefix, warehous_counttag_number, warehous_bol_prefix, warehous_bol_number, warehous_shipping, warehous_useslips, warehous_usezones, warehous_aislesize, warehous_aislealpha, warehous_racksize, warehous_rackalpha, warehous_binsize, warehous_binalpha, warehous_locationsize, warehous_locationalpha, warehous_enforcearbl, warehous_default_accnt_id, warehous_shipping_commission, warehous_cntct_id, warehous_addr_id, warehous_transit, warehous_shipform_id, warehous_shipvia_id, warehous_shipcomments, warehous_costcat_id, warehous_sitetype_id, warehous_taxzone_id, warehous_sequence) VALUES (35, 'WH1', 'Main Warehouse', '', true, 'WH1', 90000, 'WH1', 10000, true, true, false, 2, true, 2, true, 2, true, 2, true, true, 83, 0.0000, 2, 2, false, NULL, NULL, NULL, NULL, 1, NULL, 0);


ALTER TABLE whsinfo ENABLE TRIGGER ALL;

--
-- TOC entry 8957 (class 0 OID 146617997)
-- Dependencies: 292 8905 8956 8938 8958 8909 8896 9464
-- Data for Name: emp; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE emp DISABLE TRIGGER ALL;

INSERT INTO emp (emp_id, emp_code, emp_number, emp_active, emp_cntct_id, emp_warehous_id, emp_mgr_emp_id, emp_wage_type, emp_wage, emp_wage_curr_id, emp_wage_period, emp_dept_id, emp_shift_id, emp_notes, emp_image_id, emp_username, emp_extrate, emp_extrate_period, emp_startdate, emp_name) VALUES (2, 'ADMIN', 'admin', true, NULL, NULL, NULL, 'H', NULL, 1, 'H', 2, 1, NULL, NULL, 'admin', NULL, 'H', NULL, 'Administrator');
INSERT INTO emp (emp_id, emp_code, emp_number, emp_active, emp_cntct_id, emp_warehous_id, emp_mgr_emp_id, emp_wage_type, emp_wage, emp_wage_curr_id, emp_wage_period, emp_dept_id, emp_shift_id, emp_notes, emp_image_id, emp_username, emp_extrate, emp_extrate_period, emp_startdate, emp_name) VALUES (1, 'MFGADMIN', 'mfgadmin', true, NULL, NULL, NULL, 'H', NULL, 1, 'H', 2, 1, NULL, NULL, 'mfgadmin', NULL, 'H', NULL, 'OpenMFG Administrator');


ALTER TABLE emp ENABLE TRIGGER ALL;

--
-- TOC entry 8916 (class 0 OID 146616911)
-- Dependencies: 216 8957 9464
-- Data for Name: salesrep; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE salesrep DISABLE TRIGGER ALL;

INSERT INTO salesrep (salesrep_id, salesrep_active, salesrep_number, salesrep_name, salesrep_commission, salesrep_method, salesrep_emp_id) VALUES (29, true, '10', 'Inside Sales', 0.0000, NULL, NULL);


ALTER TABLE salesrep ENABLE TRIGGER ALL;

--
-- TOC entry 8910 (class 0 OID 146616828)
-- Dependencies: 209 9464
-- Data for Name: terms; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE terms DISABLE TRIGGER ALL;

INSERT INTO terms (terms_id, terms_code, terms_descrip, terms_type, terms_duedays, terms_discdays, terms_discprcnt, terms_cutoffday, terms_ap, terms_ar, terms_fincharg) VALUES (42, '2-10-NET-30', '2-10-NET-30', 'D', 30, 10, 0.020000, 1, true, true, true);
INSERT INTO terms (terms_id, terms_code, terms_descrip, terms_type, terms_duedays, terms_discdays, terms_discprcnt, terms_cutoffday, terms_ap, terms_ar, terms_fincharg) VALUES (43, 'NET30', 'Net 30 Days', 'D', 30, 0, 0.000000, 1, true, true, true);


ALTER TABLE terms ENABLE TRIGGER ALL;

--
-- TOC entry 8913 (class 0 OID 146616878)
-- Dependencies: 213 8909 8909 8905 8905 8951 8916 8953 8919 8910 9464
-- Data for Name: custinfo; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE custinfo DISABLE TRIGGER ALL;



ALTER TABLE custinfo ENABLE TRIGGER ALL;

--
-- TOC entry 8912 (class 0 OID 146616863)
-- Dependencies: 212 8913 8916 8909 9464
-- Data for Name: aropen; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE aropen DISABLE TRIGGER ALL;



ALTER TABLE aropen ENABLE TRIGGER ALL;

--
-- TOC entry 9479 (class 0 OID 0)
-- Dependencies: 449
-- Name: aropen_aropen_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('aropen_aropen_id_seq', 292, true);


--
-- TOC entry 8994 (class 0 OID 146618494)
-- Dependencies: 374 9464
-- Data for Name: aropenalloc; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE aropenalloc DISABLE TRIGGER ALL;



ALTER TABLE aropenalloc ENABLE TRIGGER ALL;

--
-- TOC entry 9050 (class 0 OID 146618883)
-- Dependencies: 450 8990 8912 8990 8901 9464
-- Data for Name: aropentax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE aropentax DISABLE TRIGGER ALL;



ALTER TABLE aropentax ENABLE TRIGGER ALL;

--
-- TOC entry 9051 (class 0 OID 146618889)
-- Dependencies: 451 8901 8919 8909 9464
-- Data for Name: asohist; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE asohist DISABLE TRIGGER ALL;



ALTER TABLE asohist ENABLE TRIGGER ALL;

--
-- TOC entry 9480 (class 0 OID 0)
-- Dependencies: 452
-- Name: asohist_asohist_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('asohist_asohist_id_seq', 1, false);


--
-- TOC entry 9053 (class 0 OID 146618898)
-- Dependencies: 453 8990 9051 8990 8901 9464
-- Data for Name: asohisttax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE asohisttax DISABLE TRIGGER ALL;



ALTER TABLE asohisttax ENABLE TRIGGER ALL;

--
-- TOC entry 9054 (class 0 OID 146618904)
-- Dependencies: 454 9464
-- Data for Name: atlasmap; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE atlasmap DISABLE TRIGGER ALL;



ALTER TABLE atlasmap ENABLE TRIGGER ALL;

--
-- TOC entry 9481 (class 0 OID 0)
-- Dependencies: 455
-- Name: atlasmap_atlasmap_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('atlasmap_atlasmap_id_seq', 1, false);


--
-- TOC entry 9056 (class 0 OID 146618914)
-- Dependencies: 456 9464
-- Data for Name: backup_usr; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE backup_usr DISABLE TRIGGER ALL;

INSERT INTO backup_usr (usr_id, usr_username, usr_propername, usr_passwd, usr_locale_id, usr_initials, usr_agent, usr_active, usr_email, usr_dept_id, usr_shift_id, usr_window) VALUES (1, 'mfgadmin', 'OpenMFG Administrator', NULL, 3, 'ADMIN', true, true, 'matherton@openmfg.com', 2, 1, '');
INSERT INTO backup_usr (usr_id, usr_username, usr_propername, usr_passwd, usr_locale_id, usr_initials, usr_agent, usr_active, usr_email, usr_dept_id, usr_shift_id, usr_window) VALUES (2, 'admin', 'Administrator', '', 3, 'ADMIN', true, true, 'admin@xtuple.com', 2, 1, NULL);


ALTER TABLE backup_usr ENABLE TRIGGER ALL;

--
-- TOC entry 9482 (class 0 OID 0)
-- Dependencies: 457
-- Name: bankaccnt_bankaccnt_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('bankaccnt_bankaccnt_id_seq', 13, true);


--
-- TOC entry 9058 (class 0 OID 146618922)
-- Dependencies: 458 8909 9464
-- Data for Name: bankadj; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE bankadj DISABLE TRIGGER ALL;



ALTER TABLE bankadj ENABLE TRIGGER ALL;

--
-- TOC entry 9483 (class 0 OID 0)
-- Dependencies: 459
-- Name: bankadj_bankadj_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('bankadj_bankadj_id_seq', 1, false);


--
-- TOC entry 9060 (class 0 OID 146618934)
-- Dependencies: 460 9464
-- Data for Name: bankadjtype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE bankadjtype DISABLE TRIGGER ALL;



ALTER TABLE bankadjtype ENABLE TRIGGER ALL;

--
-- TOC entry 9484 (class 0 OID 0)
-- Dependencies: 461
-- Name: bankadjtype_bankadjtype_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('bankadjtype_bankadjtype_id_seq', 1, false);


--
-- TOC entry 9062 (class 0 OID 146618944)
-- Dependencies: 462 9464
-- Data for Name: bankrec; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE bankrec DISABLE TRIGGER ALL;



ALTER TABLE bankrec ENABLE TRIGGER ALL;

--
-- TOC entry 9485 (class 0 OID 0)
-- Dependencies: 463
-- Name: bankrec_bankrec_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('bankrec_bankrec_id_seq', 1, false);


--
-- TOC entry 9064 (class 0 OID 146618955)
-- Dependencies: 464 9464
-- Data for Name: bankrecitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE bankrecitem DISABLE TRIGGER ALL;



ALTER TABLE bankrecitem ENABLE TRIGGER ALL;

--
-- TOC entry 9486 (class 0 OID 0)
-- Dependencies: 465
-- Name: bankrecitem_bankrecitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('bankrecitem_bankrecitem_id_seq', 1, false);


--
-- TOC entry 8967 (class 0 OID 146618128)
-- Dependencies: 313 9464
-- Data for Name: classcode; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE classcode DISABLE TRIGGER ALL;

INSERT INTO classcode (classcode_id, classcode_code, classcode_descrip, classcode_mfg, classcode_creator, classcode_created, classcode_modifier, classcode_modified, classcode_type) VALUES (35, 'SOLD', 'Sold Items', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO classcode (classcode_id, classcode_code, classcode_descrip, classcode_mfg, classcode_creator, classcode_created, classcode_modifier, classcode_modified, classcode_type) VALUES (34, 'OUTSIDE PROCESS', 'Outside Process', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO classcode (classcode_id, classcode_code, classcode_descrip, classcode_mfg, classcode_creator, classcode_created, classcode_modifier, classcode_modified, classcode_type) VALUES (36, 'SUB ASSEMBLY', 'Sub Assembly', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO classcode (classcode_id, classcode_code, classcode_descrip, classcode_mfg, classcode_creator, classcode_created, classcode_modifier, classcode_modified, classcode_type) VALUES (33, 'COMPONENT', 'Component', NULL, NULL, NULL, NULL, NULL, NULL);


ALTER TABLE classcode ENABLE TRIGGER ALL;

--
-- TOC entry 8960 (class 0 OID 146618045)
-- Dependencies: 299 9464
-- Data for Name: freightclass; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE freightclass DISABLE TRIGGER ALL;



ALTER TABLE freightclass ENABLE TRIGGER ALL;

--
-- TOC entry 8902 (class 0 OID 146615822)
-- Dependencies: 200 9464
-- Data for Name: uom; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE uom DISABLE TRIGGER ALL;

INSERT INTO uom (uom_id, uom_name, uom_descrip, uom_item_weight) VALUES (7, 'LB', 'Pounds', true);
INSERT INTO uom (uom_id, uom_name, uom_descrip, uom_item_weight) VALUES (5, 'CS', 'Case', false);
INSERT INTO uom (uom_id, uom_name, uom_descrip, uom_item_weight) VALUES (4, 'EA', 'Each', false);
INSERT INTO uom (uom_id, uom_name, uom_descrip, uom_item_weight) VALUES (6, 'PL', 'Pallet', false);
INSERT INTO uom (uom_id, uom_name, uom_descrip, uom_item_weight) VALUES (8, 'KG', 'Kilos', false);


ALTER TABLE uom ENABLE TRIGGER ALL;

--
-- TOC entry 8894 (class 0 OID 146615672)
-- Dependencies: 191 8967 8960 8902 8902 9464
-- Data for Name: item; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE item DISABLE TRIGGER ALL;



ALTER TABLE item ENABLE TRIGGER ALL;

--
-- TOC entry 8940 (class 0 OID 146617763)
-- Dependencies: 254 8894 9464
-- Data for Name: bomhead; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE bomhead DISABLE TRIGGER ALL;



ALTER TABLE bomhead ENABLE TRIGGER ALL;

--
-- TOC entry 9487 (class 0 OID 0)
-- Dependencies: 466
-- Name: bomhead_bomhead_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('bomhead_bomhead_id_seq', 54, true);


--
-- TOC entry 8930 (class 0 OID 146617648)
-- Dependencies: 236 9464
-- Data for Name: char; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE "char" DISABLE TRIGGER ALL;

INSERT INTO "char" (char_id, char_name, char_items, char_options, char_attributes, char_lotserial, char_notes, char_customers, char_crmaccounts, char_addresses, char_contacts, char_opportunity, char_employees, char_mask, char_validator, char_incidents, char_type, char_order, char_search, char_quotes, char_salesorders, char_invoices, char_vendors, char_purchaseorders, char_vouchers, char_projects, char_tasks) VALUES (14, 'Lot Test Results', false, false, false, true, 'Lot Test Results', false, false, false, false, false, false, NULL, NULL, false, 0, 10, true, false, false, false, false, false, false, false, false);
INSERT INTO "char" (char_id, char_name, char_items, char_options, char_attributes, char_lotserial, char_notes, char_customers, char_crmaccounts, char_addresses, char_contacts, char_opportunity, char_employees, char_mask, char_validator, char_incidents, char_type, char_order, char_search, char_quotes, char_salesorders, char_invoices, char_vendors, char_purchaseorders, char_vouchers, char_projects, char_tasks) VALUES (13, 'Cusotmer Feedback', false, false, false, false, 'Feedback From Customer', true, false, false, false, false, false, NULL, NULL, false, 0, 10, true, false, false, false, false, false, false, false, false);
INSERT INTO "char" (char_id, char_name, char_items, char_options, char_attributes, char_lotserial, char_notes, char_customers, char_crmaccounts, char_addresses, char_contacts, char_opportunity, char_employees, char_mask, char_validator, char_incidents, char_type, char_order, char_search, char_quotes, char_salesorders, char_invoices, char_vendors, char_purchaseorders, char_vouchers, char_projects, char_tasks) VALUES (15, 'Item Color', true, false, false, false, 'Item Color', false, false, false, false, false, false, NULL, NULL, false, 1, 10, true, false, false, false, false, false, false, false, false);


ALTER TABLE "char" ENABLE TRIGGER ALL;

--
-- TOC entry 8904 (class 0 OID 146616085)
-- Dependencies: 203 8930 8894 8894 8902 9464
-- Data for Name: bomitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE bomitem DISABLE TRIGGER ALL;



ALTER TABLE bomitem ENABLE TRIGGER ALL;

--
-- TOC entry 9488 (class 0 OID 0)
-- Dependencies: 467
-- Name: bomitem_bomitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('bomitem_bomitem_id_seq', 167, true);


--
-- TOC entry 8970 (class 0 OID 146618169)
-- Dependencies: 320 9464
-- Data for Name: costelem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE costelem DISABLE TRIGGER ALL;

INSERT INTO costelem (costelem_id, costelem_type, costelem_sys, costelem_po, costelem_active, costelem_exp_accnt_id, costelem_cost_item_id) VALUES (3, 'Material', true, true, true, NULL, -1);
INSERT INTO costelem (costelem_id, costelem_type, costelem_sys, costelem_po, costelem_active, costelem_exp_accnt_id, costelem_cost_item_id) VALUES (4, 'Direct Labor', true, false, true, NULL, -1);
INSERT INTO costelem (costelem_id, costelem_type, costelem_sys, costelem_po, costelem_active, costelem_exp_accnt_id, costelem_cost_item_id) VALUES (6, 'Machine Overhead', true, false, true, NULL, -1);
INSERT INTO costelem (costelem_id, costelem_type, costelem_sys, costelem_po, costelem_active, costelem_exp_accnt_id, costelem_cost_item_id) VALUES (5, 'Overhead', true, false, true, NULL, -1);


ALTER TABLE costelem ENABLE TRIGGER ALL;

--
-- TOC entry 9068 (class 0 OID 146618968)
-- Dependencies: 468 8904 8970 8909 9464
-- Data for Name: bomitemcost; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE bomitemcost DISABLE TRIGGER ALL;



ALTER TABLE bomitemcost ENABLE TRIGGER ALL;

--
-- TOC entry 9489 (class 0 OID 0)
-- Dependencies: 469
-- Name: bomitemcost_bomitemcost_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('bomitemcost_bomitemcost_id_seq', 1, false);


--
-- TOC entry 8941 (class 0 OID 146617786)
-- Dependencies: 258 8904 8894 9464
-- Data for Name: bomitemsub; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE bomitemsub DISABLE TRIGGER ALL;



ALTER TABLE bomitemsub ENABLE TRIGGER ALL;

--
-- TOC entry 9490 (class 0 OID 0)
-- Dependencies: 470
-- Name: bomitemsub_bomitemsub_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('bomitemsub_bomitemsub_id_seq', 1, false);


--
-- TOC entry 9071 (class 0 OID 146618979)
-- Dependencies: 471 8930 9464
-- Data for Name: bomwork; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE bomwork DISABLE TRIGGER ALL;



ALTER TABLE bomwork ENABLE TRIGGER ALL;

--
-- TOC entry 9491 (class 0 OID 0)
-- Dependencies: 472
-- Name: bomwork_bomwork_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('bomwork_bomwork_id_seq', 1, false);


--
-- TOC entry 8942 (class 0 OID 146617794)
-- Dependencies: 260 9464
-- Data for Name: budghead; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE budghead DISABLE TRIGGER ALL;

INSERT INTO budghead (budghead_id, budghead_name, budghead_descrip) VALUES (1, 'Default', 'Default budget for conversion');


ALTER TABLE budghead ENABLE TRIGGER ALL;

--
-- TOC entry 9492 (class 0 OID 0)
-- Dependencies: 474
-- Name: budghead_budghead_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('budghead_budghead_id_seq', 2, true);


--
-- TOC entry 8945 (class 0 OID 146617818)
-- Dependencies: 264 9464
-- Data for Name: period; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE period DISABLE TRIGGER ALL;

INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (52, '2008-01-01', '2008-01-31', false, false, true, '2008 - Jan ', 3, 1, 1);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (53, '2008-02-01', '2008-02-29', false, false, false, '2008 - Feb', 3, 1, 2);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (54, '2008-03-01', '2008-03-31', false, false, false, '2008 - Mar', 3, 1, 3);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (55, '2008-04-01', '2008-04-30', false, false, false, '2008 - Apr', 3, 2, 4);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (56, '2008-05-01', '2008-05-31', false, false, false, '2008 - May', 3, 2, 5);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (57, '2008-06-01', '2008-06-30', false, false, false, '2008 - Jun ', 3, 2, 6);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (58, '2008-07-01', '2008-07-31', false, false, false, '2008 - Jul', 3, 3, 7);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (59, '2008-08-01', '2008-08-31', false, false, false, '2008 - Aug', 3, 3, 8);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (60, '2008-09-01', '2008-09-30', false, false, false, '2008 - Sep', 3, 3, 9);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (61, '2008-10-01', '2008-10-31', false, false, false, '2008 - Oct', 3, 4, 10);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (62, '2008-11-01', '2008-11-30', false, false, false, '2008 - Nov', 3, 4, 11);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (63, '2008-12-01', '2008-12-31', false, false, false, '2008 - Dec', 3, 4, 12);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (64, '2009-01-01', '2009-01-31', false, false, false, '2009 - Jan', 4, 1, 1);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (65, '2009-02-01', '2009-02-28', false, false, false, '2009 - Feb', 4, 1, 2);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (66, '2009-03-01', '2009-03-31', false, false, false, '2009 - Mar', 4, 1, 3);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (67, '2009-04-01', '2009-04-30', false, false, false, '2009 - Apr', 4, 2, 4);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (68, '2009-05-01', '2009-05-31', false, false, false, '2009 - May', 4, 2, 5);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (69, '2009-06-01', '2009-06-30', false, false, false, '2009 - Jun', 4, 2, 6);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (70, '2009-07-01', '2009-07-31', false, false, false, '2009 - Jul', 4, 3, 7);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (71, '2009-08-01', '2009-08-31', false, false, false, '2009 - Aug', 4, 3, 8);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (72, '2009-09-01', '2009-09-30', false, false, false, '2009 - Sep', 4, 3, 9);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (73, '2009-10-01', '2009-10-31', false, false, false, '2009 - Oct', 4, 4, 10);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (74, '2009-11-01', '2009-11-30', false, false, false, '2009 - Nov', 4, 4, 11);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (75, '2009-12-01', '2009-12-31', false, false, false, '2009 - Dec', 4, 4, 12);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (76, '2010-01-01', '2010-01-31', false, false, false, '2010 - Jan', 6, 1, 1);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (77, '2010-02-01', '2010-02-28', false, false, false, '2010 - Feb', 6, 1, 2);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (78, '2010-03-01', '2010-03-31', false, false, false, '2010 - Mar', 6, 1, 3);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (79, '2010-04-01', '2010-04-30', false, false, false, '2010 - Apr', 6, 2, 4);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (80, '2010-05-01', '2010-05-31', false, false, false, '2010 - May', 6, 2, 5);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (81, '2010-06-01', '2010-06-30', false, false, false, '2010 - Jun', 6, 2, 6);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (82, '2010-07-01', '2010-07-31', false, false, false, '2010 - Jul', 6, 3, 7);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (83, '2010-08-01', '2010-08-31', false, false, false, '2010 - Aug', 6, 3, 8);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (84, '2010-09-01', '2010-09-30', false, false, false, '2010 - Sep', 6, 3, 9);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (85, '2010-10-01', '2010-10-31', false, false, false, '2010 - Oct', 6, 4, 10);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (86, '2010-11-01', '2010-11-30', false, false, false, '2010 - Nov', 6, 4, 11);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (87, '2010-12-01', '2010-12-31', false, false, false, '2010 - Dec', 6, 4, 12);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (88, '2011-01-01', '2011-01-31', false, false, false, '2011 - Jan', 7, 1, 1);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (89, '2011-02-01', '2011-02-28', false, false, false, '2011 - Feb', 7, 1, 2);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (90, '2011-03-01', '2011-03-31', false, false, false, '2011 - Mar', 7, 1, 3);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (91, '2011-04-01', '2011-04-30', false, false, false, '2011 - Apr', 7, 2, 4);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (92, '2011-05-01', '2011-05-31', false, false, false, '2011 - May', 7, 2, 5);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (93, '2011-06-01', '2011-06-30', false, false, false, '2011 - Jun', 7, 2, 6);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (94, '2011-07-01', '2011-07-31', false, false, false, '2011 - Jul', 7, 3, 7);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (95, '2011-08-01', '2011-08-31', false, false, false, '2011 - Aug', 7, 3, 8);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (96, '2011-09-01', '2011-09-30', false, false, false, '2011 - Sep', 7, 3, 9);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (97, '2011-10-01', '2011-10-31', false, false, false, '2011 - Oct', 7, 4, 10);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (98, '2011-11-01', '2011-11-30', false, false, false, '2011 - Nov', 7, 4, 11);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (99, '2011-12-01', '2011-12-31', false, false, false, '2011 - Dec', 7, 4, 12);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (100, '2012-01-01', '2012-01-31', false, false, false, '2012 - Jan', 8, 1, 1);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (101, '2012-02-01', '2012-02-29', false, false, false, '2012 - Feb', 8, 1, 2);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (102, '2012-03-01', '2012-03-31', false, false, false, '2012 - Mar', 8, 1, 3);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (103, '2012-04-01', '2012-04-30', false, false, false, '2012 - Apr', 8, 2, 4);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (104, '2012-05-01', '2012-05-31', false, false, false, '2012 - May', 8, 2, 5);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (105, '2012-06-01', '2012-06-30', false, false, false, '2012 - Jun', 8, 2, 6);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (106, '2012-07-01', '2012-07-31', false, false, false, '2012 - Jul', 8, 3, 7);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (107, '2012-08-01', '2012-08-31', false, false, false, '2012 - Aug', 8, 3, 8);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (108, '2012-09-01', '2012-09-30', false, false, false, '2012 - Sep', 8, 3, 9);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (109, '2012-10-01', '2012-10-31', false, false, false, '2012 - Oct', 8, 4, 10);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (110, '2012-11-01', '2012-11-30', false, false, false, '2012 - Nov', 8, 4, 11);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (111, '2012-12-01', '2012-12-31', false, false, false, '2012 - Dec', 8, 4, 12);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (112, '2013-01-01', '2013-01-31', false, false, false, '2013 - Jan', 9, 1, 1);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (113, '2013-02-01', '2013-02-28', false, false, false, '2013 - Feb', 9, 1, 2);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (114, '2013-03-01', '2013-03-31', false, false, false, '2013 - Mar', 9, 1, 3);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (115, '2013-04-01', '2013-04-30', false, false, false, '2013 - Apr', 9, 2, 4);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (116, '2013-05-01', '2013-05-31', false, false, false, '2013 - May', 9, 2, 5);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (117, '2013-06-01', '2013-06-30', false, false, false, '2013 - Jun', 9, 2, 6);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (118, '2013-07-01', '2013-07-31', false, false, false, '2013 - Jul', 9, 3, 7);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (119, '2013-08-01', '2013-08-31', false, false, false, '2013 - Aug', 9, 3, 8);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (120, '2013-09-01', '2013-09-30', false, false, false, '2013 - Sep', 9, 3, 9);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (121, '2013-10-01', '2013-10-31', false, false, false, '2013 - Oct', 9, 4, 10);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (122, '2013-11-01', '2013-11-30', false, false, false, '2013 - Nov', 9, 4, 11);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (123, '2013-12-01', '2013-12-31', false, false, false, '2013 - Dec', 9, 4, 12);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (124, '2014-01-01', '2014-01-31', false, false, false, '2014 - Jan', 10, 1, 1);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (125, '2014-02-01', '2014-02-28', false, false, false, '2014 - Feb', 10, 1, 2);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (126, '2014-03-01', '2014-03-31', false, false, false, '2014 - Mar', 10, 1, 3);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (127, '2014-04-01', '2014-04-30', false, false, false, '2014 - Apr', 10, 2, 4);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (128, '2014-05-01', '2014-05-31', false, false, false, '2014 - May', 10, 2, 5);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (129, '2014-06-01', '2014-06-30', false, false, false, '2014 - Jun', 10, 2, 6);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (130, '2014-07-01', '2014-07-31', false, false, false, '2014 - Jul', 10, 3, 7);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (131, '2014-08-01', '2014-08-31', false, false, false, '2014 - Aug', 10, 3, 8);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (132, '2014-09-01', '2014-09-30', false, false, false, '2014 - Sep', 10, 3, 9);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (133, '2014-10-01', '2014-10-31', false, false, false, '2014 - Oct', 10, 4, 10);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (134, '2014-11-01', '2014-11-30', false, false, false, '2014 - Nov', 10, 4, 11);
INSERT INTO period (period_id, period_start, period_end, period_closed, period_freeze, period_initial, period_name, period_yearperiod_id, period_quarter, period_number) VALUES (135, '2014-12-01', '2014-12-31', false, false, false, '2014 - Dec', 10, 4, 12);


ALTER TABLE period ENABLE TRIGGER ALL;

--
-- TOC entry 8944 (class 0 OID 146617815)
-- Dependencies: 263 8942 8945 9464
-- Data for Name: budgitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE budgitem DISABLE TRIGGER ALL;



ALTER TABLE budgitem ENABLE TRIGGER ALL;

--
-- TOC entry 9493 (class 0 OID 0)
-- Dependencies: 475
-- Name: budgitem_budgitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('budgitem_budgitem_id_seq', 1, true);


--
-- TOC entry 9075 (class 0 OID 146618997)
-- Dependencies: 476 9464
-- Data for Name: calhead; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE calhead DISABLE TRIGGER ALL;

INSERT INTO calhead (calhead_id, calhead_type, calhead_name, calhead_descrip, calhead_origin) VALUES (47, 'R', '8WEEK_FORWARD', '8 Week Forward  Calendar', 'D');
INSERT INTO calhead (calhead_id, calhead_type, calhead_name, calhead_descrip, calhead_origin) VALUES (48, 'R', '3MONTH_BACK', '3 Months Back Calendar', 'D');


ALTER TABLE calhead ENABLE TRIGGER ALL;

--
-- TOC entry 9494 (class 0 OID 0)
-- Dependencies: 477
-- Name: calhead_calhead_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('calhead_calhead_id_seq', 48, true);


--
-- TOC entry 9495 (class 0 OID 0)
-- Dependencies: 478
-- Name: carrier_carrier_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('carrier_carrier_id_seq', 15, true);


--
-- TOC entry 8947 (class 0 OID 146617841)
-- Dependencies: 267 8946 8913 8909 9464
-- Data for Name: cashrcpt; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cashrcpt DISABLE TRIGGER ALL;



ALTER TABLE cashrcpt ENABLE TRIGGER ALL;

--
-- TOC entry 9496 (class 0 OID 0)
-- Dependencies: 479
-- Name: cashrcpt_cashrcpt_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cashrcpt_cashrcpt_id_seq', 112, true);


--
-- TOC entry 8948 (class 0 OID 146617860)
-- Dependencies: 269 8912 8947 9464
-- Data for Name: cashrcptitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cashrcptitem DISABLE TRIGGER ALL;



ALTER TABLE cashrcptitem ENABLE TRIGGER ALL;

--
-- TOC entry 9497 (class 0 OID 0)
-- Dependencies: 445
-- Name: cashrcptitem_cashrcptitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cashrcptitem_cashrcptitem_id_seq', 170, true);


--
-- TOC entry 8949 (class 0 OID 146617870)
-- Dependencies: 271 8943 8947 9464
-- Data for Name: cashrcptmisc; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cashrcptmisc DISABLE TRIGGER ALL;



ALTER TABLE cashrcptmisc ENABLE TRIGGER ALL;

--
-- TOC entry 9498 (class 0 OID 0)
-- Dependencies: 480
-- Name: cashrcptmisc_cashrcptmisc_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cashrcptmisc_cashrcptmisc_id_seq', 26, true);


--
-- TOC entry 8950 (class 0 OID 146617904)
-- Dependencies: 278 8913 9464
-- Data for Name: ccard; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE ccard DISABLE TRIGGER ALL;



ALTER TABLE ccard ENABLE TRIGGER ALL;

--
-- TOC entry 9499 (class 0 OID 0)
-- Dependencies: 481
-- Name: ccard_ccard_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('ccard_ccard_id_seq', 1, false);


--
-- TOC entry 9081 (class 0 OID 146619015)
-- Dependencies: 482 9464
-- Data for Name: ccardaud; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE ccardaud DISABLE TRIGGER ALL;



ALTER TABLE ccardaud ENABLE TRIGGER ALL;

--
-- TOC entry 9500 (class 0 OID 0)
-- Dependencies: 483
-- Name: ccardaud_ccardaud_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('ccardaud_ccardaud_id_seq', 1, false);


--
-- TOC entry 9083 (class 0 OID 146619025)
-- Dependencies: 484 8946 9464
-- Data for Name: ccbank; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE ccbank DISABLE TRIGGER ALL;

INSERT INTO ccbank (ccbank_id, ccbank_ccard_type, ccbank_bankaccnt_id) VALUES (4, 'P', NULL);
INSERT INTO ccbank (ccbank_id, ccbank_ccard_type, ccbank_bankaccnt_id) VALUES (1, 'A', NULL);
INSERT INTO ccbank (ccbank_id, ccbank_ccard_type, ccbank_bankaccnt_id) VALUES (2, 'D', NULL);
INSERT INTO ccbank (ccbank_id, ccbank_ccard_type, ccbank_bankaccnt_id) VALUES (3, 'M', NULL);
INSERT INTO ccbank (ccbank_id, ccbank_ccard_type, ccbank_bankaccnt_id) VALUES (5, 'V', NULL);


ALTER TABLE ccbank ENABLE TRIGGER ALL;

--
-- TOC entry 9501 (class 0 OID 0)
-- Dependencies: 485
-- Name: ccbank_ccbank_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('ccbank_ccbank_id_seq', 5, true);


--
-- TOC entry 9085 (class 0 OID 146619034)
-- Dependencies: 486 9464
-- Data for Name: ccpay; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE ccpay DISABLE TRIGGER ALL;



ALTER TABLE ccpay ENABLE TRIGGER ALL;

--
-- TOC entry 9502 (class 0 OID 0)
-- Dependencies: 487
-- Name: ccpay_ccpay_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('ccpay_ccpay_id_seq', 1, false);


--
-- TOC entry 9503 (class 0 OID 0)
-- Dependencies: 488
-- Name: char_char_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('char_char_id_seq', 15, true);


--
-- TOC entry 8931 (class 0 OID 146617668)
-- Dependencies: 237 9464
-- Data for Name: charass; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE charass DISABLE TRIGGER ALL;



ALTER TABLE charass ENABLE TRIGGER ALL;

--
-- TOC entry 9504 (class 0 OID 0)
-- Dependencies: 489
-- Name: charass_charass_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('charass_charass_id_seq', 1, false);


--
-- TOC entry 9089 (class 0 OID 146619051)
-- Dependencies: 490 8930 9464
-- Data for Name: charopt; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE charopt DISABLE TRIGGER ALL;

INSERT INTO charopt (charopt_id, charopt_char_id, charopt_value, charopt_order) VALUES (1, 15, 'Red', 10);
INSERT INTO charopt (charopt_id, charopt_char_id, charopt_value, charopt_order) VALUES (2, 15, 'Green', 20);
INSERT INTO charopt (charopt_id, charopt_char_id, charopt_value, charopt_order) VALUES (3, 15, 'Blue', 30);


ALTER TABLE charopt ENABLE TRIGGER ALL;

--
-- TOC entry 9505 (class 0 OID 0)
-- Dependencies: 491
-- Name: charopt_charopt_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('charopt_charopt_id_seq', 3, true);


--
-- TOC entry 9506 (class 0 OID 0)
-- Dependencies: 492
-- Name: checkhead_checkhead_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('checkhead_checkhead_id_seq', 1, false);


--
-- TOC entry 9035 (class 0 OID 146618808)
-- Dependencies: 432 8908 8912 9034 8909 9464
-- Data for Name: checkitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE checkitem DISABLE TRIGGER ALL;



ALTER TABLE checkitem ENABLE TRIGGER ALL;

--
-- TOC entry 9507 (class 0 OID 0)
-- Dependencies: 493
-- Name: checkitem_checkitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('checkitem_checkitem_id_seq', 1, false);


--
-- TOC entry 9508 (class 0 OID 0)
-- Dependencies: 495
-- Name: classcode_classcode_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('classcode_classcode_id_seq', 36, true);


--
-- TOC entry 9002 (class 0 OID 146618617)
-- Dependencies: 397 9464
-- Data for Name: cmd; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cmd DISABLE TRIGGER ALL;



ALTER TABLE cmd ENABLE TRIGGER ALL;

--
-- TOC entry 9509 (class 0 OID 0)
-- Dependencies: 398
-- Name: cmd_cmd_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cmd_cmd_id_seq', 6, true);


--
-- TOC entry 9005 (class 0 OID 146618633)
-- Dependencies: 400 9002 9464
-- Data for Name: cmdarg; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cmdarg DISABLE TRIGGER ALL;



ALTER TABLE cmdarg ENABLE TRIGGER ALL;

--
-- TOC entry 9510 (class 0 OID 0)
-- Dependencies: 401
-- Name: cmdarg_cmdarg_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cmdarg_cmdarg_id_seq', 6, true);


--
-- TOC entry 8987 (class 0 OID 146618372)
-- Dependencies: 356 8905 8916 8919 8896 9464
-- Data for Name: prospect; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE prospect DISABLE TRIGGER ALL;



ALTER TABLE prospect ENABLE TRIGGER ALL;

--
-- TOC entry 8906 (class 0 OID 146616343)
-- Dependencies: 205 8905 8905 8913 8957 8987 8916 8954 8911 9464
-- Data for Name: crmacct; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE crmacct DISABLE TRIGGER ALL;

INSERT INTO crmacct (crmacct_id, crmacct_number, crmacct_name, crmacct_active, crmacct_type, crmacct_cust_id, crmacct_competitor_id, crmacct_partner_id, crmacct_prospect_id, crmacct_vend_id, crmacct_cntct_id_1, crmacct_cntct_id_2, crmacct_parent_id, crmacct_notes, crmacct_taxauth_id, crmacct_owner_username, crmacct_emp_id, crmacct_salesrep_id, crmacct_usr_username) VALUES (2, '10', 'Inside Sales', true, 'I', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 29, NULL);
INSERT INTO crmacct (crmacct_id, crmacct_number, crmacct_name, crmacct_active, crmacct_type, crmacct_cust_id, crmacct_competitor_id, crmacct_partner_id, crmacct_prospect_id, crmacct_vend_id, crmacct_cntct_id_1, crmacct_cntct_id_2, crmacct_parent_id, crmacct_notes, crmacct_taxauth_id, crmacct_owner_username, crmacct_emp_id, crmacct_salesrep_id, crmacct_usr_username) VALUES (4, 'MFGADMIN', 'OpenMFG Administrator', true, 'I', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, 'mfgadmin');
INSERT INTO crmacct (crmacct_id, crmacct_number, crmacct_name, crmacct_active, crmacct_type, crmacct_cust_id, crmacct_competitor_id, crmacct_partner_id, crmacct_prospect_id, crmacct_vend_id, crmacct_cntct_id_1, crmacct_cntct_id_2, crmacct_parent_id, crmacct_notes, crmacct_taxauth_id, crmacct_owner_username, crmacct_emp_id, crmacct_salesrep_id, crmacct_usr_username) VALUES (3, 'ADMIN', 'Administrator', true, 'I', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'admin', 2, NULL, 'admin');
INSERT INTO crmacct (crmacct_id, crmacct_number, crmacct_name, crmacct_active, crmacct_type, crmacct_cust_id, crmacct_competitor_id, crmacct_partner_id, crmacct_prospect_id, crmacct_vend_id, crmacct_cntct_id_1, crmacct_cntct_id_2, crmacct_parent_id, crmacct_notes, crmacct_taxauth_id, crmacct_owner_username, crmacct_emp_id, crmacct_salesrep_id, crmacct_usr_username) VALUES (1, 'SALES TAX', 'State Sales Tax Authority', true, 'O', NULL, NULL, NULL, NULL, 78, NULL, NULL, NULL, '', 1, 'admin', NULL, NULL, NULL);


ALTER TABLE crmacct ENABLE TRIGGER ALL;

--
-- TOC entry 9323 (class 0 OID 146620107)
-- Dependencies: 739 9464
-- Data for Name: prjtype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE prjtype DISABLE TRIGGER ALL;

INSERT INTO prjtype (prjtype_id, prjtype_code, prjtype_descr, prjtype_active) VALUES (1, 'Standard', 'Standard Projects', true);


ALTER TABLE prjtype ENABLE TRIGGER ALL;

--
-- TOC entry 8922 (class 0 OID 146616996)
-- Dependencies: 225 8905 8906 9323 9464
-- Data for Name: prj; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE prj DISABLE TRIGGER ALL;



ALTER TABLE prj ENABLE TRIGGER ALL;

--
-- TOC entry 8923 (class 0 OID 146617004)
-- Dependencies: 226 9464
-- Data for Name: saletype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE saletype DISABLE TRIGGER ALL;

INSERT INTO saletype (saletype_id, saletype_code, saletype_descr, saletype_active) VALUES (1, 'CUST', 'Customer', true);
INSERT INTO saletype (saletype_id, saletype_code, saletype_descr, saletype_active) VALUES (2, 'INT', 'Internet', true);
INSERT INTO saletype (saletype_id, saletype_code, saletype_descr, saletype_active) VALUES (3, 'REP', 'Sales Rep', true);


ALTER TABLE saletype ENABLE TRIGGER ALL;

--
-- TOC entry 8924 (class 0 OID 146617011)
-- Dependencies: 227 9464
-- Data for Name: shipzone; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE shipzone DISABLE TRIGGER ALL;

INSERT INTO shipzone (shipzone_id, shipzone_name, shipzone_descrip) VALUES (35, 'ZONE1', 'Zone 1');
INSERT INTO shipzone (shipzone_id, shipzone_name, shipzone_descrip) VALUES (43, 'ZONE9', 'Zone 9');
INSERT INTO shipzone (shipzone_id, shipzone_name, shipzone_descrip) VALUES (41, 'ZONE7', 'Zone 7');
INSERT INTO shipzone (shipzone_id, shipzone_name, shipzone_descrip) VALUES (40, 'ZONE6', 'Zone 6');
INSERT INTO shipzone (shipzone_id, shipzone_name, shipzone_descrip) VALUES (42, 'ZONE8', 'Zone 8');
INSERT INTO shipzone (shipzone_id, shipzone_name, shipzone_descrip) VALUES (39, 'ZONE5', 'Zone 5');
INSERT INTO shipzone (shipzone_id, shipzone_name, shipzone_descrip) VALUES (38, 'ZONE4', 'Zone 4');
INSERT INTO shipzone (shipzone_id, shipzone_name, shipzone_descrip) VALUES (37, 'ZONE3', 'Zone 3');
INSERT INTO shipzone (shipzone_id, shipzone_name, shipzone_descrip) VALUES (36, 'ZONE2', 'Zone 2');
INSERT INTO shipzone (shipzone_id, shipzone_name, shipzone_descrip) VALUES (45, 'ZONE0', 'Zone 0');


ALTER TABLE shipzone ENABLE TRIGGER ALL;

--
-- TOC entry 8917 (class 0 OID 146616927)
-- Dependencies: 218 8913 8901 8922 8916 8923 8924 8919 8909 9464
-- Data for Name: cmhead; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cmhead DISABLE TRIGGER ALL;



ALTER TABLE cmhead ENABLE TRIGGER ALL;

--
-- TOC entry 9511 (class 0 OID 0)
-- Dependencies: 496
-- Name: cmhead_cmhead_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cmhead_cmhead_id_seq', 206, true);


--
-- TOC entry 9095 (class 0 OID 146619073)
-- Dependencies: 497 8990 8917 8990 8901 9464
-- Data for Name: cmheadtax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cmheadtax DISABLE TRIGGER ALL;



ALTER TABLE cmheadtax ENABLE TRIGGER ALL;

--
-- TOC entry 8920 (class 0 OID 146616958)
-- Dependencies: 222 8917 8902 8902 8901 9464
-- Data for Name: cmitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cmitem DISABLE TRIGGER ALL;



ALTER TABLE cmitem ENABLE TRIGGER ALL;

--
-- TOC entry 9512 (class 0 OID 0)
-- Dependencies: 498
-- Name: cmitem_cmitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cmitem_cmitem_id_seq', 83, true);


--
-- TOC entry 9097 (class 0 OID 146619081)
-- Dependencies: 499 8990 8920 8990 8901 9464
-- Data for Name: cmitemtax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cmitemtax DISABLE TRIGGER ALL;



ALTER TABLE cmitemtax ENABLE TRIGGER ALL;

--
-- TOC entry 8932 (class 0 OID 146617680)
-- Dependencies: 239 9464
-- Data for Name: cmnttype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cmnttype DISABLE TRIGGER ALL;

INSERT INTO cmnttype (cmnttype_id, cmnttype_name, cmnttype_descrip, cmnttype_usedin, cmnttype_sys, cmnttype_editable, cmnttype_order) VALUES (1, 'General', 'General Comment', 'ICVPL', true, false, NULL);
INSERT INTO cmnttype (cmnttype_id, cmnttype_name, cmnttype_descrip, cmnttype_usedin, cmnttype_sys, cmnttype_editable, cmnttype_order) VALUES (2, 'ChangeLog', 'Change Log', 'ICVP', true, false, NULL);
INSERT INTO cmnttype (cmnttype_id, cmnttype_name, cmnttype_descrip, cmnttype_usedin, cmnttype_sys, cmnttype_editable, cmnttype_order) VALUES (3, 'Notes to Comment', 'Used by certain triggers to automatically create/update comment with content of notes.', NULL, true, false, NULL);


ALTER TABLE cmnttype ENABLE TRIGGER ALL;

--
-- TOC entry 9513 (class 0 OID 0)
-- Dependencies: 500
-- Name: cmnttype_cmnttype_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cmnttype_cmnttype_id_seq', 3, true);


--
-- TOC entry 9099 (class 0 OID 146619089)
-- Dependencies: 501 9464
-- Data for Name: cmnttypesource; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cmnttypesource DISABLE TRIGGER ALL;

INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (8, 1, 1);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (9, 2, 1);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (10, 1, 2);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (11, 2, 2);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (12, 1, 3);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (13, 2, 3);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (14, 1, 4);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (15, 2, 4);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (16, 1, 5);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (17, 2, 5);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (18, 1, 6);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (19, 2, 6);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (20, 1, 7);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (21, 2, 7);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (22, 1, 8);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (23, 2, 8);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (24, 1, 9);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (25, 2, 9);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (26, 1, 10);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (27, 2, 10);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (28, 1, 11);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (29, 2, 11);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (30, 1, 12);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (31, 2, 12);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (32, 1, 13);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (33, 2, 13);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (34, 1, 14);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (35, 2, 14);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (36, 1, 15);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (37, 2, 15);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (38, 1, 16);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (39, 2, 16);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (40, 1, 17);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (41, 2, 17);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (42, 1, 18);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (43, 2, 18);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (44, 1, 19);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (45, 2, 19);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (46, 1, 20);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (47, 2, 20);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (48, 1, 21);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (49, 2, 21);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (50, 1, 22);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (51, 2, 22);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (52, 1, 23);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (53, 2, 23);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (54, 1, 24);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (55, 2, 24);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (56, 1, 25);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (57, 2, 25);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (58, 1, 26);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (59, 2, 26);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (60, 1, 27);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (61, 2, 27);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (62, 1, 28);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (63, 2, 28);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (64, 1, 29);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (65, 2, 29);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (66, 1, 30);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (67, 2, 30);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (68, 1, 31);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (69, 2, 31);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (70, 1, 32);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (71, 2, 32);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (72, 1, 33);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (73, 2, 33);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (74, 1, 34);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (75, 2, 34);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (76, 3, 12);


ALTER TABLE cmnttypesource ENABLE TRIGGER ALL;

--
-- TOC entry 9514 (class 0 OID 0)
-- Dependencies: 502
-- Name: cmnttypesource_cmnttypesource_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cmnttypesource_cmnttypesource_id_seq', 76, true);


--
-- TOC entry 9515 (class 0 OID 0)
-- Dependencies: 503
-- Name: cntct_cntct_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cntct_cntct_id_seq', 2, true);


--
-- TOC entry 9102 (class 0 OID 146619096)
-- Dependencies: 504 8929 8905 9464
-- Data for Name: cntctaddr; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cntctaddr DISABLE TRIGGER ALL;



ALTER TABLE cntctaddr ENABLE TRIGGER ALL;

--
-- TOC entry 9516 (class 0 OID 0)
-- Dependencies: 505
-- Name: cntctaddr_cntctaddr_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cntctaddr_cntctaddr_id_seq', 1, false);


--
-- TOC entry 9104 (class 0 OID 146619101)
-- Dependencies: 506 8905 9464
-- Data for Name: cntctdata; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cntctdata DISABLE TRIGGER ALL;



ALTER TABLE cntctdata ENABLE TRIGGER ALL;

--
-- TOC entry 9517 (class 0 OID 0)
-- Dependencies: 507
-- Name: cntctdata_cntctdata_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cntctdata_cntctdata_id_seq', 1, false);


--
-- TOC entry 9106 (class 0 OID 146619109)
-- Dependencies: 508 8905 9464
-- Data for Name: cntcteml; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cntcteml DISABLE TRIGGER ALL;



ALTER TABLE cntcteml ENABLE TRIGGER ALL;

--
-- TOC entry 9518 (class 0 OID 0)
-- Dependencies: 509
-- Name: cntcteml_cntcteml_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cntcteml_cntcteml_id_seq', 1, false);


--
-- TOC entry 9108 (class 0 OID 146619118)
-- Dependencies: 510 8905 9464
-- Data for Name: cntctmrgd; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cntctmrgd DISABLE TRIGGER ALL;



ALTER TABLE cntctmrgd ENABLE TRIGGER ALL;

--
-- TOC entry 9109 (class 0 OID 146619122)
-- Dependencies: 511 8905 9464
-- Data for Name: cntctsel; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cntctsel DISABLE TRIGGER ALL;



ALTER TABLE cntctsel ENABLE TRIGGER ALL;

--
-- TOC entry 8892 (class 0 OID 146615658)
-- Dependencies: 189 9464
-- Data for Name: cntslip; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cntslip DISABLE TRIGGER ALL;



ALTER TABLE cntslip ENABLE TRIGGER ALL;

--
-- TOC entry 9519 (class 0 OID 0)
-- Dependencies: 512
-- Name: cntslip_cntslip_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cntslip_cntslip_id_seq', 97, true);


--
-- TOC entry 8921 (class 0 OID 146616986)
-- Dependencies: 224 8923 8924 8919 8909 9464
-- Data for Name: invchead; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE invchead DISABLE TRIGGER ALL;



ALTER TABLE invchead ENABLE TRIGGER ALL;

--
-- TOC entry 8925 (class 0 OID 146617025)
-- Dependencies: 229 8921 8902 8902 8943 8901 9464
-- Data for Name: invcitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE invcitem DISABLE TRIGGER ALL;



ALTER TABLE invcitem ENABLE TRIGGER ALL;

--
-- TOC entry 9111 (class 0 OID 146619143)
-- Dependencies: 513 8925 8901 9464
-- Data for Name: cobill; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cobill DISABLE TRIGGER ALL;



ALTER TABLE cobill ENABLE TRIGGER ALL;

--
-- TOC entry 9520 (class 0 OID 0)
-- Dependencies: 514
-- Name: cobill_cobill_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cobill_cobill_id_seq', 528, true);


--
-- TOC entry 9113 (class 0 OID 146619152)
-- Dependencies: 515 8990 9111 8990 8901 9464
-- Data for Name: cobilltax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cobilltax DISABLE TRIGGER ALL;



ALTER TABLE cobilltax ENABLE TRIGGER ALL;

--
-- TOC entry 9114 (class 0 OID 146619159)
-- Dependencies: 516 8921 8901 8919 8909 9464
-- Data for Name: cobmisc; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cobmisc DISABLE TRIGGER ALL;



ALTER TABLE cobmisc ENABLE TRIGGER ALL;

--
-- TOC entry 9521 (class 0 OID 0)
-- Dependencies: 517
-- Name: cobmisc_cobmisc_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cobmisc_cobmisc_id_seq', 204, true);


--
-- TOC entry 9116 (class 0 OID 146619169)
-- Dependencies: 518 8990 9114 8990 8901 9464
-- Data for Name: cobmisctax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cobmisctax DISABLE TRIGGER ALL;



ALTER TABLE cobmisctax ENABLE TRIGGER ALL;

--
-- TOC entry 8964 (class 0 OID 146618086)
-- Dependencies: 305 9464
-- Data for Name: incdtpriority; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE incdtpriority DISABLE TRIGGER ALL;

INSERT INTO incdtpriority (incdtpriority_id, incdtpriority_name, incdtpriority_order, incdtpriority_descrip) VALUES (2, 'High', 1, NULL);
INSERT INTO incdtpriority (incdtpriority_id, incdtpriority_name, incdtpriority_order, incdtpriority_descrip) VALUES (3, 'Normal', 2, NULL);
INSERT INTO incdtpriority (incdtpriority_id, incdtpriority_name, incdtpriority_order, incdtpriority_descrip) VALUES (4, 'Low', 3, NULL);
INSERT INTO incdtpriority (incdtpriority_id, incdtpriority_name, incdtpriority_order, incdtpriority_descrip) VALUES (5, 'Very Low', 4, NULL);
INSERT INTO incdtpriority (incdtpriority_id, incdtpriority_name, incdtpriority_order, incdtpriority_descrip) VALUES (1, 'Very High', 0, NULL);


ALTER TABLE incdtpriority ENABLE TRIGGER ALL;

--
-- TOC entry 9284 (class 0 OID 146619921)
-- Dependencies: 696 9464
-- Data for Name: opsource; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE opsource DISABLE TRIGGER ALL;



ALTER TABLE opsource ENABLE TRIGGER ALL;

--
-- TOC entry 9286 (class 0 OID 146619930)
-- Dependencies: 698 9464
-- Data for Name: opstage; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE opstage DISABLE TRIGGER ALL;



ALTER TABLE opstage ENABLE TRIGGER ALL;

--
-- TOC entry 9288 (class 0 OID 146619941)
-- Dependencies: 700 9464
-- Data for Name: optype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE optype DISABLE TRIGGER ALL;



ALTER TABLE optype ENABLE TRIGGER ALL;

--
-- TOC entry 8926 (class 0 OID 146617152)
-- Dependencies: 231 8905 8906 9284 9286 9288 8964 9464
-- Data for Name: ophead; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE ophead DISABLE TRIGGER ALL;



ALTER TABLE ophead ENABLE TRIGGER ALL;

--
-- TOC entry 8918 (class 0 OID 146616937)
-- Dependencies: 219 8929 8905 8913 8916 8916 8953 8953 8924 8919 9464
-- Data for Name: shiptoinfo; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE shiptoinfo DISABLE TRIGGER ALL;



ALTER TABLE shiptoinfo ENABLE TRIGGER ALL;

--
-- TOC entry 8897 (class 0 OID 146615748)
-- Dependencies: 195 8905 8913 8943 8926 8922 8916 8923 8953 8905 8918 8924 8901 8919 8910 8896 8909 9464
-- Data for Name: cohead; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cohead DISABLE TRIGGER ALL;



ALTER TABLE cohead ENABLE TRIGGER ALL;

--
-- TOC entry 9522 (class 0 OID 0)
-- Dependencies: 519
-- Name: cohead_cohead_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cohead_cohead_id_seq', 2952, true);


--
-- TOC entry 8995 (class 0 OID 146618504)
-- Dependencies: 376 9085 8913 8916 8901 8919 8909 9464
-- Data for Name: cohist; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cohist DISABLE TRIGGER ALL;



ALTER TABLE cohist ENABLE TRIGGER ALL;

--
-- TOC entry 9523 (class 0 OID 0)
-- Dependencies: 520
-- Name: cohist_cohist_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cohist_cohist_id_seq', 493, true);


--
-- TOC entry 8998 (class 0 OID 146618521)
-- Dependencies: 379 8990 8995 8990 8901 9464
-- Data for Name: cohisttax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cohisttax DISABLE TRIGGER ALL;



ALTER TABLE cohisttax ENABLE TRIGGER ALL;

--
-- TOC entry 8973 (class 0 OID 146618207)
-- Dependencies: 326 9464
-- Data for Name: plancode; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE plancode DISABLE TRIGGER ALL;

INSERT INTO plancode (plancode_id, plancode_code, plancode_name, plancode_mpsexplosion, plancode_consumefcst, plancode_mrpexcp_resched, plancode_mrpexcp_delete) VALUES (24, 'RM1', 'Raw Materials - 1', 'M', false, NULL, NULL);
INSERT INTO plancode (plancode_id, plancode_code, plancode_name, plancode_mpsexplosion, plancode_consumefcst, plancode_mrpexcp_resched, plancode_mrpexcp_delete) VALUES (25, 'AS1', 'Assemblies - 1', 'M', false, NULL, NULL);
INSERT INTO plancode (plancode_id, plancode_code, plancode_name, plancode_mpsexplosion, plancode_consumefcst, plancode_mrpexcp_resched, plancode_mrpexcp_delete) VALUES (26, 'FG1', 'Finished Product - 1', 'M', false, NULL, NULL);


ALTER TABLE plancode ENABLE TRIGGER ALL;

--
-- TOC entry 8895 (class 0 OID 146615692)
-- Dependencies: 192 8972 8894 8973 8896 9464
-- Data for Name: itemsite; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE itemsite DISABLE TRIGGER ALL;



ALTER TABLE itemsite ENABLE TRIGGER ALL;

--
-- TOC entry 8898 (class 0 OID 146615767)
-- Dependencies: 196 8897 8943 8895 8902 8902 8943 8894 8901 9464
-- Data for Name: coitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE coitem DISABLE TRIGGER ALL;



ALTER TABLE coitem ENABLE TRIGGER ALL;

--
-- TOC entry 9524 (class 0 OID 0)
-- Dependencies: 521
-- Name: coitem_coitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('coitem_coitem_id_seq', 564, true);


--
-- TOC entry 8933 (class 0 OID 146617689)
-- Dependencies: 240 8932 9464
-- Data for Name: comment; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE comment DISABLE TRIGGER ALL;

INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (39, 2, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (40, 3, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (41, 4, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (42, 5, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (43, 6, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (44, 7, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (45, 8, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (46, 9, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (47, 10, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (48, 11, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (49, 12, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (50, 13, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (51, 14, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (52, 15, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (53, 16, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (54, 17, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (55, 18, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (56, 19, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (57, 20, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (58, 21, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (59, 22, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (60, 23, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (61, 24, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (62, 25, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (63, 26, '2011-08-19 11:27:57.826966-04', 'admin', 'Created by admin', 2, 'CRMA', false);


ALTER TABLE comment ENABLE TRIGGER ALL;

--
-- TOC entry 9525 (class 0 OID 0)
-- Dependencies: 522
-- Name: comment_comment_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('comment_comment_id_seq', 63, true);


--
-- TOC entry 9121 (class 0 OID 146619188)
-- Dependencies: 523 8909 8943 8943 8943 8943 9464
-- Data for Name: company; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE company DISABLE TRIGGER ALL;

INSERT INTO company (company_id, company_number, company_descrip, company_external, company_server, company_port, company_database, company_curr_id, company_yearend_accnt_id, company_gainloss_accnt_id, company_dscrp_accnt_id, company_unrlzgainloss_accnt_id) VALUES (1, '01', 'Company 01', false, NULL, NULL, NULL, NULL, 84, 122, 123, NULL);


ALTER TABLE company ENABLE TRIGGER ALL;

--
-- TOC entry 9526 (class 0 OID 0)
-- Dependencies: 524
-- Name: company_company_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('company_company_id_seq', 1, true);


--
-- TOC entry 8974 (class 0 OID 146618225)
-- Dependencies: 329 8911 9464
-- Data for Name: contrct; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE contrct DISABLE TRIGGER ALL;



ALTER TABLE contrct ENABLE TRIGGER ALL;

--
-- TOC entry 9527 (class 0 OID 0)
-- Dependencies: 525
-- Name: contrct_contrct_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('contrct_contrct_id_seq', 1, false);


--
-- TOC entry 9528 (class 0 OID 0)
-- Dependencies: 529
-- Name: coship_coship_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('coship_coship_id_seq', 441, true);


--
-- TOC entry 9529 (class 0 OID 0)
-- Dependencies: 531
-- Name: cosmisc_cosmisc_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cosmisc_cosmisc_id_seq', 202, true);


--
-- TOC entry 9530 (class 0 OID 0)
-- Dependencies: 532
-- Name: cosrc_cosrc_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cosrc_cosrc_id_seq', 1, false);


--
-- TOC entry 9531 (class 0 OID 0)
-- Dependencies: 533
-- Name: costcat_costcat_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('costcat_costcat_id_seq', 30, true);


--
-- TOC entry 9532 (class 0 OID 0)
-- Dependencies: 534
-- Name: costelem_costelem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('costelem_costelem_id_seq', 23, true);


--
-- TOC entry 9131 (class 0 OID 146619240)
-- Dependencies: 535 8909 8909 9464
-- Data for Name: costhist; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE costhist DISABLE TRIGGER ALL;

INSERT INTO costhist (costhist_id, costhist_item_id, costhist_costelem_id, costhist_type, costhist_date, costhist_oldcost, costhist_newcost, costhist_lowlevel, costhist_oldcurr_id, costhist_newcurr_id, costhist_username) VALUES (979, 295, 19, 'D', '2004-03-19 15:23:23.224219-05', 1.500000, 0.000000, false, 1, 1, NULL);
INSERT INTO costhist (costhist_id, costhist_item_id, costhist_costelem_id, costhist_type, costhist_date, costhist_oldcost, costhist_newcost, costhist_lowlevel, costhist_oldcurr_id, costhist_newcurr_id, costhist_username) VALUES (980, 296, 20, 'D', '2004-03-19 15:23:23.224219-05', 0.300000, 0.000000, false, 1, 1, NULL);
INSERT INTO costhist (costhist_id, costhist_item_id, costhist_costelem_id, costhist_type, costhist_date, costhist_oldcost, costhist_newcost, costhist_lowlevel, costhist_oldcurr_id, costhist_newcurr_id, costhist_username) VALUES (981, 297, 20, 'D', '2004-03-19 15:23:23.224219-05', 0.250000, 0.000000, false, 1, 1, NULL);
INSERT INTO costhist (costhist_id, costhist_item_id, costhist_costelem_id, costhist_type, costhist_date, costhist_oldcost, costhist_newcost, costhist_lowlevel, costhist_oldcurr_id, costhist_newcurr_id, costhist_username) VALUES (982, 294, 20, 'D', '2004-03-19 15:23:23.224219-05', 0.100000, 0.000000, false, 1, 1, NULL);
INSERT INTO costhist (costhist_id, costhist_item_id, costhist_costelem_id, costhist_type, costhist_date, costhist_oldcost, costhist_newcost, costhist_lowlevel, costhist_oldcurr_id, costhist_newcurr_id, costhist_username) VALUES (983, 293, 20, 'D', '2004-03-19 15:23:23.224219-05', 0.100000, 0.000000, false, 1, 1, NULL);
INSERT INTO costhist (costhist_id, costhist_item_id, costhist_costelem_id, costhist_type, costhist_date, costhist_oldcost, costhist_newcost, costhist_lowlevel, costhist_oldcurr_id, costhist_newcurr_id, costhist_username) VALUES (984, 298, 4, 'D', '2004-03-19 15:23:23.224219-05', 0.333300, 0.000000, false, 1, 1, NULL);
INSERT INTO costhist (costhist_id, costhist_item_id, costhist_costelem_id, costhist_type, costhist_date, costhist_oldcost, costhist_newcost, costhist_lowlevel, costhist_oldcurr_id, costhist_newcurr_id, costhist_username) VALUES (985, 298, 5, 'D', '2004-03-19 15:23:23.224219-05', 0.333300, 0.000000, false, 1, 1, NULL);
INSERT INTO costhist (costhist_id, costhist_item_id, costhist_costelem_id, costhist_type, costhist_date, costhist_oldcost, costhist_newcost, costhist_lowlevel, costhist_oldcurr_id, costhist_newcurr_id, costhist_username) VALUES (986, 298, 20, 'D', '2004-03-19 15:23:23.224219-05', 0.550000, 0.000000, true, 1, 1, NULL);
INSERT INTO costhist (costhist_id, costhist_item_id, costhist_costelem_id, costhist_type, costhist_date, costhist_oldcost, costhist_newcost, costhist_lowlevel, costhist_oldcurr_id, costhist_newcurr_id, costhist_username) VALUES (987, 292, 4, 'D', '2004-03-19 15:23:23.224219-05', 0.850000, 0.000000, false, 1, 1, NULL);
INSERT INTO costhist (costhist_id, costhist_item_id, costhist_costelem_id, costhist_type, costhist_date, costhist_oldcost, costhist_newcost, costhist_lowlevel, costhist_oldcurr_id, costhist_newcurr_id, costhist_username) VALUES (988, 292, 5, 'D', '2004-03-19 15:23:23.224219-05', 0.850000, 0.000000, false, 1, 1, NULL);
INSERT INTO costhist (costhist_id, costhist_item_id, costhist_costelem_id, costhist_type, costhist_date, costhist_oldcost, costhist_newcost, costhist_lowlevel, costhist_oldcurr_id, costhist_newcurr_id, costhist_username) VALUES (989, 292, 4, 'D', '2004-03-19 15:23:23.224219-05', 0.333300, 0.000000, true, 1, 1, NULL);
INSERT INTO costhist (costhist_id, costhist_item_id, costhist_costelem_id, costhist_type, costhist_date, costhist_oldcost, costhist_newcost, costhist_lowlevel, costhist_oldcurr_id, costhist_newcurr_id, costhist_username) VALUES (990, 292, 19, 'D', '2004-03-19 15:23:23.224219-05', 0.015000, 0.000000, true, 1, 1, NULL);
INSERT INTO costhist (costhist_id, costhist_item_id, costhist_costelem_id, costhist_type, costhist_date, costhist_oldcost, costhist_newcost, costhist_lowlevel, costhist_oldcurr_id, costhist_newcurr_id, costhist_username) VALUES (991, 292, 5, 'D', '2004-03-19 15:23:23.224219-05', 0.333300, 0.000000, true, 1, 1, NULL);
INSERT INTO costhist (costhist_id, costhist_item_id, costhist_costelem_id, costhist_type, costhist_date, costhist_oldcost, costhist_newcost, costhist_lowlevel, costhist_oldcurr_id, costhist_newcurr_id, costhist_username) VALUES (992, 292, 20, 'D', '2004-03-19 15:23:23.224219-05', 1.050000, 0.000000, true, 1, 1, NULL);


ALTER TABLE costhist ENABLE TRIGGER ALL;

--
-- TOC entry 9533 (class 0 OID 0)
-- Dependencies: 536
-- Name: costhist_costhist_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('costhist_costhist_id_seq', 992, true);


--
-- TOC entry 9133 (class 0 OID 146619251)
-- Dependencies: 537 9464
-- Data for Name: costupdate; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE costupdate DISABLE TRIGGER ALL;



ALTER TABLE costupdate ENABLE TRIGGER ALL;

--
-- TOC entry 9134 (class 0 OID 146619255)
-- Dependencies: 538 9464
-- Data for Name: country; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE country DISABLE TRIGGER ALL;

INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (214, NULL, NULL, 'XTS', 'Code reserved for testing', '963', NULL, NULL);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (5, 'AD', 'Andorra', 'EUR', 'Euro', '978', 'â¬', 5);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (228, 'AE', 'United Arab Emirates', 'AED', 'UAE Dirham', '784', NULL, 223);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (1, 'AF', 'Afghanistan', 'AFN', 'Afghani', '971', NULL, 1);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (9, 'AG', 'Antigua And Barbuda', 'XCD', 'East Caribbean Dollar', '951', '$', 9);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (7, 'AI', 'Anguilla', 'XCD', 'East Caribbean Dollar', '951', '$', 7);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (2, 'AL', 'Albania', 'ALL', 'Lek', '8  ', NULL, 2);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (11, 'AM', 'Armenia', 'AMD', 'Armenian Dram', '51 ', NULL, 11);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (154, 'AN', 'Netherlands Antilles', 'ANG', 'Netherlands Antillian Guilder', '532', 'Æ', 152);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (6, 'AO', 'Angola', 'AOA', 'Kwanza', '973', NULL, 6);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (8, 'AQ', 'Antarctica', NULL, NULL, NULL, NULL, 8);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (10, 'AR', 'Argentina', 'ARS', 'Argentine Peso', '32 ', '$', 10);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (4, 'AS', 'American Samoa', 'USD', 'US Dollar', '840', '$', 4);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (14, 'AT', 'Austria', 'EUR', 'Euro', '978', 'â¬', 14);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (13, 'AU', 'Australia', 'AUD', 'Australian Dollar', '36 ', '$', 13);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (12, 'AW', 'Aruba', 'AWG', 'Aruban Guilder', '533', 'Æ', 12);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (15, 'AZ', 'Azerbaijan', 'AZN', 'Azerbaijanian Manat', '944', NULL, 15);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (27, 'BA', 'Bosnia And Herzegovina', 'BAM', 'Convertible Marks', '977', NULL, 27);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (19, 'BB', 'Barbados', 'BBD', 'Barbados Dollar', '52 ', '$', 19);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (18, 'BD', 'Bangladesh', 'BDT', 'Taka', '50 ', NULL, 18);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (21, 'BE', 'Belgium', 'EUR', 'Euro', '978', 'â¬', 21);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (35, 'BF', 'Burkina Faso', 'XOF', 'CFA Franc BCEAO', '952', NULL, 34);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (34, 'BG', 'Bulgaria', 'BGN', 'Bulgarian Lev', '975', NULL, 33);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (17, 'BH', 'Bahrain', 'BHD', 'Bahraini Dinar', '48 ', NULL, 17);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (36, 'BI', 'Burundi', 'BIF', 'Burundi Franc', '108', NULL, 35);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (23, 'BJ', 'Benin', 'XOF', 'CFA Franc BCEAO', '952', NULL, 23);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (24, 'BM', 'Bermuda', 'BMD', 'Bermudian Dollar', '60 ', '$', 24);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (33, 'BN', 'Brunei Darussalam', 'BND', 'Brunei Dollar', '96 ', '$', 32);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (26, 'BO', 'Bolivia', 'BOB', 'Boliviano', '68 ', '$', 26);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (30, 'BR', 'Brazil', 'BRL', 'Brazilian Real', '986', 'R$', 30);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (16, 'BS', 'Bahamas', 'BSD', 'Bahamian Dollar', '44 ', '$', 16);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (25, 'BT', 'Bhutan', 'BTN', 'Ngultrum', '64 ', NULL, 25);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (29, 'BV', 'Bouvet Island', 'NOK', 'Norwegian Krone', '578', NULL, 29);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (28, 'BW', 'Botswana', 'BWP', 'Pula', '72 ', NULL, 28);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (20, 'BY', 'Belarus', 'BYR', 'Belarussian Ruble', '974', NULL, 20);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (22, 'BZ', 'Belize', 'BZD', 'Belize Dollar', '84 ', '$', 22);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (39, 'CA', 'Canada', 'CAD', 'Canadian Dollar', '124', '$', 38);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (47, 'CC', 'Cocos (Keeling) Islands', 'AUD', 'Australian Dollar', '36 ', '$', 46);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (51, 'CD', 'Congo, The Democratic Republic Of', 'CDF', 'Franc Congolais', '976', NULL, 49);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (42, 'CF', 'Central African Republic', 'XAF', 'CFA Franc BEAC', '950', NULL, 41);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (50, 'CG', 'Congo', 'XAF', 'CFA Franc BEAC', '950', NULL, 50);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (209, 'CH', 'Switzerland', 'CHF', 'Swiss Franc', '756', NULL, 206);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (107, 'CI', 'Ivory Coast', 'XOF', 'CFA Frank BCEA', '952', NULL, 53);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (52, 'CK', 'Cook Islands', 'NZD', 'New Zealand Dollar', '554', '$', 51);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (44, 'CL', 'Chile', 'CLP', 'Chilean Peso', '152', '$', 43);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (38, 'CM', 'Cameroon', 'XAF', 'CFA Franc BEAC', '950', NULL, 37);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (45, 'CN', 'China', 'CNY', 'Yuan Renminbi', '156', NULL, 44);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (48, 'CO', 'Colombia', 'COP', 'Colombian Peso', '170', 'â±', 47);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (53, 'CR', 'Costa Rica', 'CRC', 'Costa Rican Colon', '188', 'â¡', 52);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (55, 'CU', 'Cuba', 'CUP', 'Cuban Peso', '192', 'â±', 55);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (40, 'CV', 'Cape Verde', 'CVE', 'Cape Verde Escudo', '132', NULL, 39);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (46, 'CX', 'Christmas Island', 'AUD', 'Australian Dollar', '36 ', '$', 45);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (56, 'CY', 'Cyprus', 'CYP', 'Cyprus Pound', '196', 'Â£', 56);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (57, 'CZ', 'Czech Republic', 'CZK', 'Czech Koruna', '203', NULL, 57);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (81, 'DE', 'Germany', 'EUR', 'Euro', '978', 'â¬', 82);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (59, 'DJ', 'Djibouti', 'DJF', 'Djibouti Franc', '262', NULL, 59);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (58, 'DK', 'Denmark', 'DKK', 'Danish Krone', '208', 'kr', 58);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (60, 'DM', 'Dominica', 'XCD', 'East Caribbean Dollar', '951', '$', 60);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (61, 'DO', 'Dominican Republic', 'DOP', 'Dominican Peso', '214', 'â±', 61);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (3, 'DZ', 'Algeria', 'DZD', 'Algerian Dinar', '12 ', NULL, 3);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (63, 'EC', 'Ecuador', 'USD', 'US Dollar', '840', '$', 63);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (68, 'EE', 'Estonia', 'EEK', 'Kroon', '233', NULL, 68);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (64, 'EG', 'Egypt', 'EGP', 'Egyptian Pound', '818', 'Â£', 64);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (239, 'EH', 'Western Sahara', 'MAD', 'Moroccan Dirham', '504', NULL, 236);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (67, 'ER', 'Eritrea', 'ERN', 'Nakfa', '232', NULL, 67);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (202, 'ES', 'Spain', 'EUR', 'Euro', '978', 'â¬', 197);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (69, 'ET', 'Ethiopia', 'ETB', 'Ethiopian Birr', '230', NULL, 69);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (73, 'FI', 'Finland', 'EUR', 'Euro', '978', 'â¬', 73);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (72, 'FJ', 'Fiji', 'FJD', 'Fiji Dollar', '242', '$', 72);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (70, 'FK', 'Falkland Islands (Malvinas)', 'FKP', 'Falkland Islands Pound', '238', 'Â£', 70);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (141, 'FM', 'Micronesia, Federated States Of', 'USD', 'US Dollar', '840', '$', 140);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (71, 'FO', 'Faroe Islands', 'DKK', 'Danish Krone', '208', NULL, 71);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (74, 'FR', 'France', 'EUR', 'Euro', '978', 'â¬', 74);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (78, 'GA', 'Gabon', 'XAF', 'CFA Franc BEAC', '950', NULL, 79);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (86, 'GD', 'Grenada', 'XCD', 'East Caribbean Dollar', '951', '$', 87);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (80, 'GE', 'Georgia', 'GEL', 'Lari', '981', NULL, 81);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (75, 'GF', 'French Guiana', 'EUR', 'Euro', '978', 'â¬', 76);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (82, 'GH', 'Ghana', 'GHC', 'Cedi', '288', NULL, 83);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (83, 'GI', 'Gibraltar', 'GIP', 'Gibraltar Pound', '292', 'Â£', 84);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (85, 'GL', 'Greenland', 'DKK', 'Danish Krone', '208', NULL, 86);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (79, 'GM', 'Gambia', 'GMD', 'Dalasi', '270', NULL, 80);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (90, 'GN', 'Guinea', 'GNF', 'Guinea Franc', '324', NULL, 91);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (87, 'GP', 'Guadeloupe', 'EUR', 'Euro', '978', 'â¬', 88);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (66, 'GQ', 'Equatorial Guinea', 'XAF', 'CFA Franc BEAC', '950', NULL, 66);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (84, 'GR', 'Greece', 'EUR', 'Euro', '978', 'â¬', 85);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (201, 'GS', 'South Georgia And The South Sandwich Islands ', 'GBP', 'Pound Sterling', '826', NULL, 196);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (89, 'GT', 'Guatemala', 'GTQ', 'Quetzal', '320', NULL, 90);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (88, 'GU', 'Guam', 'USD', 'US Dollar', '840', '$', 89);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (91, 'GW', 'Guinea-Bissau', 'XOF', 'CFA Franc BCEAO', '952', NULL, 92);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (92, 'GY', 'Guyana', 'GYD', 'Guyana Dollar', '328', '$', 93);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (97, 'HK', 'Hong Kong', 'HKD', 'Hong Kong Dollar', '344', '$', 97);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (94, 'HM', 'Heard Island And Mcdonald Islands', 'AUD', 'Australian Dollar', '36 ', '$', 95);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (96, 'HN', 'Honduras', 'HNL', 'Lempira', '340', NULL, 96);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (54, 'HR', 'Croatia', 'HRK', 'Croatian Kuna', '191', NULL, 54);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (93, 'HT', 'Haiti', 'HTG', 'Gourde', '332', NULL, 94);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (98, 'HU', 'Hungary', 'HUF', 'Forint', '348', NULL, 98);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (101, 'ID', 'Indonesia', 'IDR', 'Indonesia Rupiah', '360', NULL, 101);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (104, 'IE', 'Ireland', 'EUR', 'Euro', '978', 'â¬', 104);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (105, 'IL', 'Israel', 'ILS', 'New Israeli Sheqel', '376', 'âª', 105);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (100, 'IN', 'India', 'INR', 'Indian Rupee', '356', 'â¨', 100);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (31, 'IO', 'British Indian Ocean Territory', 'USD', 'US Dollar', '840', '$', 31);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (103, 'IQ', 'Iraq', 'IQD', 'Iraqi Dinar', '368', NULL, 103);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (102, 'IR', 'Iran', 'IRR', 'Iranian Rial', '364', 'ï·¼', 102);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (99, 'IS', 'Iceland', 'ISK', 'Iceland Krona', '352', NULL, 99);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (106, 'IT', 'Italy', 'EUR', 'Euro', '978', 'â¬', 106);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (108, 'JM', 'Jamaica', 'JMD', 'Jamaican Dollar', '388', '$', 107);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (110, 'JO', 'Jordan', 'JOD', 'Jordanian Dinar', '400', NULL, 109);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (109, 'JP', 'Japan', 'JPY', 'Yen', '392', 'Â¥', 108);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (112, 'KE', 'Kenya', 'KES', 'Kenyan Shilling', '404', NULL, 111);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (117, 'KG', 'Kyrgyzstan', 'KGS', 'Som', '417', NULL, 116);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (37, 'KH', 'Cambodia', 'KHR', 'Riel', '116', 'á', 36);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (113, 'KI', 'Kiribati', 'AUD', 'Australian Dollar', '36 ', '$', 112);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (49, 'KM', 'Comoros', 'KMF', 'Comoro Franc', '174', NULL, 48);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (183, 'KN', 'Saint Kitts And Nevis', 'XCD', 'East Caribbean Dollar', '951', '$', 180);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (114, 'KP', 'Korea, Democratic Peoples Republic Of', 'KPW', 'North Korean Won', '408', 'â©', 113);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (115, 'KR', 'Korea, Republic Of', 'KRW', 'South Korean Won', '410', 'â©', 114);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (116, 'KW', 'Kuwait', 'KWD', 'Kuwaiti Dinar', '414', NULL, 115);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (41, 'KY', 'Cayman Islands', 'KYD', 'Cayman Islands Dollar', '136', '$', 40);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (111, 'KZ', 'Kazakhstan', 'KZT', 'Tenge', '398', NULL, 110);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (118, 'LA', 'Laos', 'LAK', 'Kip', '418', 'â­', 117);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (120, 'LB', 'Lebanon', 'LBP', 'Lebanese Pound', '422', 'Â£', 119);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (184, 'LC', 'Saint Lucia', 'XCD', 'East Caribbean Dollar', '951', '$', 181);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (124, 'LI', 'Liechtenstein', 'CHF', 'Swiss Franc', '756', NULL, 123);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (203, 'LK', 'Sri Lanka', 'LKR', 'Sri Lanka Rupee', '144', 'à¯¹', 198);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (122, 'LR', 'Liberia', 'LRD', 'Liberian Dollar', '430', '$', 121);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (121, 'LS', 'Lesotho', 'LSL', 'Loti', '426', NULL, 120);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (125, 'LT', 'Lithuania', 'LTL', 'Lithuanian Litas', '440', NULL, 124);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (126, 'LU', 'Luxembourg', 'EUR', 'Euro', '978', 'â¬', 125);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (119, 'LV', 'Latvia', 'LVL', 'Latvian Lats', '428', NULL, 118);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (123, 'LY', 'Libyan Arab Jamahiriya', 'LYD', 'Libyan Dinar', '434', NULL, 122);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (147, 'MA', 'Morocco', 'MAD', 'Moroccan Dirham', '504', NULL, 145);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (143, 'MC', 'Monaco', 'EUR', 'Euro', '978', 'â¬', 142);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (142, 'MD', 'Moldova', 'MDL', 'Moldovan Leu', '498', NULL, 141);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (145, 'ME', 'Montenegro', 'EUR', 'Euro', '978', 'â¬', 241);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (129, 'MG', 'Madagascar', 'MGA', 'Malagascy Ariary', '969', NULL, 128);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (135, 'MH', 'Marshall Islands', 'USD', 'US Dollar', '840', '$', 134);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (128, 'MK', 'Macedonia, Former Yugoslav Republic Of', 'MKD', 'Denar', '807', NULL, 127);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (133, 'ML', 'Mali', 'XOF', 'CFA Franc BCEAO', '952', NULL, 132);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (149, 'MM', 'Myanmar', 'MMK', 'Kyat', '104', NULL, 147);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (144, 'MN', 'Mongolia', 'MNT', 'Tugrik', '496', 'â®', 143);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (127, 'MO', 'Macao', 'MOP', 'Pataca', '446', NULL, 126);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (162, 'MP', 'Northern Mariana Islands', 'USD', 'US Dollar', '840', '$', 160);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (136, 'MQ', 'Martinique', 'EUR', 'Euro', '978', 'â¬', 135);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (137, 'MR', 'Mauritania', 'MRO', 'Ouguiya', '478', NULL, 136);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (146, 'MS', 'Montserrat', 'XCD', 'East Caribbean Dollar', '951', '$', 144);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (134, 'MT', 'Malta', 'MTL', 'Maltese Lira', '470', 'â¤', 133);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (138, 'MU', 'Mauritius', 'MUR', 'Mauritius Rupee', '480', 'â¨', 137);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (132, 'MV', 'Maldives', 'MVR', 'Rufiyaa', '462', NULL, 131);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (130, 'MW', 'Malawi', 'MWK', 'Malawi Kwacha', '454', NULL, 129);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (140, 'MX', 'Mexico', 'MXN', 'Mexican Peso', '484', '$', 139);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (131, 'MY', 'Malaysia', 'MYR', 'Malaysian Ringgit', '458', NULL, 130);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (148, 'MZ', 'Mozambique', 'MZN', 'Metical', '943', NULL, 146);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (150, 'NA', 'Namibia', 'NAD', 'Namibian Dollar', '516', '$', 148);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (155, 'NC', 'New Caledonia', 'XPF', 'CFP Franc', '953', NULL, 153);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (158, 'NE', 'Niger', 'XOF', 'CFA Franc BCEAO', '952', NULL, 156);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (161, 'NF', 'Norfolk Island', 'AUD', 'Australian Dollar', '36 ', '$', 159);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (159, 'NG', 'Nigeria', 'NGN', 'Naira', '566', 'â¦', 157);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (157, 'NI', 'Nicaragua', 'NIO', 'Cordoba Oro', '558', NULL, 155);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (153, 'NL', 'Netherlands', 'EUR', 'Euro', '978', 'â¬', 151);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (163, 'NO', 'Norway', 'NOK', 'Norwegian Krone', '578', NULL, 161);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (152, 'NP', 'Nepal', 'NPR', 'Nepalese Rupee', '524', 'â¨', 150);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (151, 'NR', 'Nauru', 'AUD', 'Australian Dollar', '36 ', '$', 149);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (160, 'NU', 'Niue', 'NZD', 'New Zealand Dollar', '554', '$', 158);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (156, 'NZ', 'New Zealand', 'NZD', 'New Zealand Dollar', '554', '$', 154);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (164, 'OM', 'Oman', 'OMR', 'Rial Omani', '512', 'ï·¼', 162);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (168, 'PA', 'Panama', 'PAB', 'Balboa', '590', NULL, 166);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (171, 'PE', 'Peru', 'PEN', 'Nuevo Sol', '604', 'S/.', 169);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (76, 'PF', 'French Polynesia', 'XPF', 'CFP Franc', '953', NULL, 77);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (169, 'PG', 'Papua New Guinea', 'PGK', 'Kina', '598', NULL, 167);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (172, 'PH', 'Philippines', 'PHP', 'Philippine Peso', '608', 'â±', 170);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (165, 'PK', 'Pakistan', 'PKR', 'Pakistan Rupee', '586', 'â¨', 163);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (174, 'PL', 'Poland', 'PLN', 'Zloty', '985', NULL, 172);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (185, 'PM', 'Saint Pierre And Miquelon', 'EUR', 'Euro', '978', 'â¬', 200);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (173, 'PN', 'Pitcairn', 'NZD', 'New Zealand Dollar', '554', '$', 171);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (176, 'PR', 'Puerto Rico', 'USD', 'US Dollar', '840', '$', 174);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (167, 'PS', 'Palestinian Territories', NULL, NULL, NULL, NULL, 165);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (175, 'PT', 'Portugal', 'EUR', 'Euro', '978', 'â¬', 173);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (166, 'PW', 'Palau', 'USD', 'US Dollar', '840', '$', 164);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (170, 'PY', 'Paraguay', 'PYG', 'Guarani', '600', NULL, 168);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (177, 'QA', 'Qatar', 'QAR', 'Qatari Rial', '634', NULL, 175);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (178, 'RE', 'Reunion', 'EUR', 'Euro', '978', 'â¬', 176);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (179, 'RO', 'Romania', 'RON', 'New Leu', '946', NULL, 177);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (192, 'RS', 'Serbia', 'RSD', 'Serbian Dinar', '941', NULL, 241);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (180, 'RU', 'Russian Federation', 'RUB', 'Russian Ruble', '643', NULL, 178);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (181, 'RW', 'Rwanda', 'RWF', 'Rwanda Franc', '646', NULL, 179);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (190, 'SA', 'Saudi Arabia', 'SAR', 'Saudi Riyal', '682', 'ï·¼', 186);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (198, 'SB', 'Solomon Islands', 'SBD', 'Solomon Islands Dollar', '90 ', '$', 193);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (193, 'SC', 'Seychelles', 'SCR', 'Seychelles Rupee', '690', 'â¨', 188);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (204, 'SD', 'Sudan', 'SDD', 'Sudanese Dinar', '736', NULL, 201);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (208, 'SE', 'Sweden', 'SEK', 'Swedish Krona', '752', 'kr', 205);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (195, 'SG', 'Singapore', 'SGD', 'Singapore Dollar', '702', '$', 190);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (182, 'SH', 'Saint Helena', 'SHP', 'Saint Helena Pound', '654', 'Â£', 199);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (197, 'SI', 'Slovenia', 'SIT', 'Tolar', '705', NULL, 192);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (206, 'SJ', 'Svalbard And Jan Mayen', 'NOK', 'Norwegian Krone', '578', NULL, 203);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (196, 'SK', 'Slovakia', 'SKK', 'Slovak Koruna', '703', NULL, 191);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (194, 'SL', 'Sierra Leone', 'SLL', 'Leone', '694', NULL, 189);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (188, 'SM', 'San Marino', 'EUR', 'Euro', '978', 'â¬', 184);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (191, 'SN', 'Senegal', 'XOF', 'CFA Franc BCEAO', '952', NULL, 187);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (199, 'SO', 'Somalia', 'SOS', 'Somali Shilling', '706', NULL, 194);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (205, 'SR', 'Suriname', 'SRD', 'Surinam Dollar', '968', '$', 202);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (189, 'ST', 'Sao Tome And Principe', 'STD', 'Dobra', '678', NULL, 185);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (65, 'SV', 'El Salvador', 'SVC', 'El Salvador Colon', '222', 'â¡', 65);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (210, 'SY', 'Syria', 'SYP', 'Syrian Pound', '760', 'Â£', 207);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (207, 'SZ', 'Swaziland', 'SZL', 'Lilangeni', '748', NULL, 204);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (224, 'TC', 'Turks And Caicos Islands', 'USD', 'US Dollar', '840', '$', 219);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (43, 'TD', 'Chad', 'XAF', 'CFA Franc BEAC', '950', NULL, 42);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (77, 'TF', 'French Southern Territories', 'EUR', 'Euro', '978', 'â¬', 78);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (217, 'TG', 'Togo', 'XOF', 'CFA Franc BCEAO', '952', NULL, 212);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (215, 'TH', 'Thailand', 'THB', 'Baht', '764', 'à¸¿', 211);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (212, 'TJ', 'Tajikistan', 'TJS', 'Somoni', '972', NULL, 209);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (218, 'TK', 'Tokelau', 'NZD', 'New Zealand Dollar', '554', '$', 213);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (216, 'TL', 'Timor-Leste', 'USD', 'US Dollar', '840', '$', 62);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (223, 'TM', 'Turkmenistan', 'TMM', 'Turkmenistan Manat', '795', NULL, 218);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (221, 'TN', 'Tunisia', 'TND', 'Tunisian Dinar', '788', NULL, 216);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (219, 'TO', 'Tonga', 'TOP', 'Paanga', '776', NULL, 214);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (62, 'TP', 'East Timor', 'IDR', 'Indonesia Rupiah', '360', NULL, 62);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (222, 'TR', 'Turkey', 'TRY', 'New Turkish Lira', '949', 'â¤', 217);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (220, 'TT', 'Trinidad And Tobago', 'TTD', 'Trinidad and Tobago Dollar', '780', '$', 215);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (225, 'TV', 'Tuvalu', 'AUD', 'Australian Dollar', '36 ', '$', 220);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (211, 'TW', 'Taiwan', 'TWD', 'New Taiwan Dollar', '901', '$', 208);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (213, 'TZ', 'Tanzania', 'TZS', 'Tanzanian Shilling', '834', NULL, 210);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (227, 'UA', 'Ukraine', 'UAH', 'Hryvnia', '980', NULL, 222);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (226, 'UG', 'Uganda', 'UGX', 'Uganda Shilling', '800', NULL, 221);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (229, 'UK', 'United Kingdom', 'GBP', 'Pound Sterling', '826', 'Â£', 224);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (232, 'UM', 'U.S. Minor Outlying Islands', 'USD', 'US Dollar', '840', '$', 226);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (230, 'US', 'United States', 'USD', 'US Dollar', '840', '$', 225);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (231, 'UY', 'Uruguay', 'UYU', 'Peso Uruguayo', '858', 'â±', 227);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (234, 'UZ', 'Uzbekistan', 'UZS', 'Uzbekistan Sum', '860', NULL, 228);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (95, 'VA', 'Holy See (Vatican City State)', 'EUR', 'Euro', '978', 'â¬', 230);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (186, 'VC', 'Saint Vincent And The Grenadines', 'XCD', 'East Caribbean Dollar', '951', '$', 182);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (236, 'VE', 'Venezuela', 'VEB', 'Bolivar', '862', NULL, 231);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (32, 'VG', 'British Virgin Islands', 'USD', 'US Dollar', '840', '$', 233);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (233, 'VI', 'U.S. Virgin Islands', 'USD', 'US Dollar', '840', '$', 234);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (237, 'VN', 'Viet Nam', 'VND', 'Dong', '704', 'â«', 232);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (235, 'VU', 'Vanuatu', 'VUV', 'Vatu', '548', NULL, 229);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (238, 'WF', 'Wallis And Futuna', 'XPF', 'CFP Franc', '953', NULL, 235);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (187, 'WS', 'Samoa', 'WST', 'Tala', '882', NULL, 183);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (240, 'YE', 'Yemen', 'YER', 'Yemeni Rial', '886', 'ï·¼', 237);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (139, 'YT', 'Mayotte', 'EUR', 'Euro', '978', 'â¬', 138);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (200, 'ZA', 'South Africa', 'ZAR', 'Rand', '710', 'R', 195);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (241, 'ZM', 'Zambia', 'ZMK', 'Zambian Kwacha', '894', NULL, 239);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (242, 'ZW', 'Zimbabwe', 'ZWD', 'Zimbabwe Dollar', '716', '$', 240);


ALTER TABLE country ENABLE TRIGGER ALL;

--
-- TOC entry 9534 (class 0 OID 0)
-- Dependencies: 539
-- Name: country_country_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('country_country_id_seq', 242, true);


--
-- TOC entry 9535 (class 0 OID 0)
-- Dependencies: 543
-- Name: crmacct_crmacct_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('crmacct_crmacct_id_seq', 26, true);


--
-- TOC entry 9138 (class 0 OID 146619284)
-- Dependencies: 544 8906 8906 9464
-- Data for Name: crmacctsel; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE crmacctsel DISABLE TRIGGER ALL;



ALTER TABLE crmacctsel ENABLE TRIGGER ALL;

--
-- TOC entry 9139 (class 0 OID 146619305)
-- Dependencies: 545 8909 9464
-- Data for Name: curr_rate; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE curr_rate DISABLE TRIGGER ALL;

INSERT INTO curr_rate (curr_rate_id, curr_id, curr_rate, curr_effective, curr_expires) VALUES (1, 1, 1.00000000, '1970-01-01', '2100-01-01');


ALTER TABLE curr_rate ENABLE TRIGGER ALL;

--
-- TOC entry 9536 (class 0 OID 0)
-- Dependencies: 546
-- Name: curr_rate_curr_rate_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('curr_rate_curr_rate_id_seq', 1, true);


--
-- TOC entry 9537 (class 0 OID 0)
-- Dependencies: 547
-- Name: curr_symbol_curr_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('curr_symbol_curr_id_seq', 1, true);


--
-- TOC entry 9538 (class 0 OID 0)
-- Dependencies: 355
-- Name: cust_cust_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cust_cust_id_seq', 96, true);


--
-- TOC entry 9539 (class 0 OID 0)
-- Dependencies: 549
-- Name: cust_serial_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cust_serial_seq', 1, false);


--
-- TOC entry 9143 (class 0 OID 146619320)
-- Dependencies: 550 9464
-- Data for Name: custform; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE custform DISABLE TRIGGER ALL;

INSERT INTO custform (custform_id, custform_custtype_id, custform_custtype, custform_invoice_report_id, custform_creditmemo_report_id, custform_quote_report_id, custform_packinglist_report_id, custform_statement_report_id, custform_sopicklist_report_id, custform_invoice_report_name, custform_creditmemo_report_name, custform_quote_report_name, custform_packinglist_report_name, custform_statement_report_name, custform_sopicklist_report_name) VALUES (8, -1, '.*', 1, 3, 172, 80, 261, 346, 'Invoice', 'CreditMemo', 'Quote', 'PackingList', 'Statement', 'PickingListSOClosedLines');


ALTER TABLE custform ENABLE TRIGGER ALL;

--
-- TOC entry 9540 (class 0 OID 0)
-- Dependencies: 551
-- Name: custform_custform_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('custform_custform_id_seq', 8, true);


--
-- TOC entry 9145 (class 0 OID 146619329)
-- Dependencies: 552 9464
-- Data for Name: custgrp; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE custgrp DISABLE TRIGGER ALL;



ALTER TABLE custgrp ENABLE TRIGGER ALL;

--
-- TOC entry 9541 (class 0 OID 0)
-- Dependencies: 553
-- Name: custgrp_custgrp_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('custgrp_custgrp_id_seq', 24, true);


--
-- TOC entry 9147 (class 0 OID 146619339)
-- Dependencies: 554 9464
-- Data for Name: custgrpitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE custgrpitem DISABLE TRIGGER ALL;



ALTER TABLE custgrpitem ENABLE TRIGGER ALL;

--
-- TOC entry 9542 (class 0 OID 0)
-- Dependencies: 555
-- Name: custgrpitem_custgrpitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('custgrpitem_custgrpitem_id_seq', 47, true);


--
-- TOC entry 9543 (class 0 OID 0)
-- Dependencies: 556
-- Name: custtype_custtype_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('custtype_custtype_id_seq', 18, true);


--
-- TOC entry 9544 (class 0 OID 0)
-- Dependencies: 557
-- Name: dept_dept_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('dept_dept_id_seq', 2, true);


--
-- TOC entry 9151 (class 0 OID 146619349)
-- Dependencies: 558 9464
-- Data for Name: destination; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE destination DISABLE TRIGGER ALL;



ALTER TABLE destination ENABLE TRIGGER ALL;

--
-- TOC entry 9545 (class 0 OID 0)
-- Dependencies: 559
-- Name: destination_destination_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('destination_destination_id_seq', 12, true);


--
-- TOC entry 8934 (class 0 OID 146617700)
-- Dependencies: 242 9464
-- Data for Name: docass; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE docass DISABLE TRIGGER ALL;



ALTER TABLE docass ENABLE TRIGGER ALL;

--
-- TOC entry 9546 (class 0 OID 0)
-- Dependencies: 247
-- Name: docass_docass_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('docass_docass_id_seq', 1, true);


--
-- TOC entry 9547 (class 0 OID 0)
-- Dependencies: 562
-- Name: emp_emp_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('emp_emp_id_seq', 2, true);


--
-- TOC entry 9155 (class 0 OID 146619380)
-- Dependencies: 563 9464
-- Data for Name: empgrp; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE empgrp DISABLE TRIGGER ALL;



ALTER TABLE empgrp ENABLE TRIGGER ALL;

--
-- TOC entry 9548 (class 0 OID 0)
-- Dependencies: 564
-- Name: empgrp_empgrp_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('empgrp_empgrp_id_seq', 1, false);


--
-- TOC entry 9157 (class 0 OID 146619389)
-- Dependencies: 565 8957 9155 9464
-- Data for Name: empgrpitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE empgrpitem DISABLE TRIGGER ALL;



ALTER TABLE empgrpitem ENABLE TRIGGER ALL;

--
-- TOC entry 9549 (class 0 OID 0)
-- Dependencies: 566
-- Name: empgrpitem_empgrpitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('empgrpitem_empgrpitem_id_seq', 1, false);


--
-- TOC entry 9159 (class 0 OID 146619394)
-- Dependencies: 567 9464
-- Data for Name: evntlog; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE evntlog DISABLE TRIGGER ALL;



ALTER TABLE evntlog ENABLE TRIGGER ALL;

--
-- TOC entry 9550 (class 0 OID 0)
-- Dependencies: 568
-- Name: evntlog_evntlog_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('evntlog_evntlog_id_seq', 262, true);


--
-- TOC entry 9161 (class 0 OID 146619403)
-- Dependencies: 569 9464
-- Data for Name: evntnot; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE evntnot DISABLE TRIGGER ALL;

INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (782, -1, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (783, 4, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (784, 15, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (785, 13, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (786, 11, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (787, 10, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (788, 12, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (789, 14, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (790, 5, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (791, 6, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (792, 7, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (793, 8, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (795, 3, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (796, 1, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (798, 2, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (801, 24, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (802, 22, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (803, 25, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (804, 23, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (805, 9, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (806, 26, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (807, 28, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (808, 27, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (809, 31, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (810, 32, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (812, 29, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (813, 30, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (814, 16, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (815, 17, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (816, 21, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (817, 18, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (818, 19, 35, 'mfgadmin');
INSERT INTO evntnot (evntnot_id, evntnot_evnttype_id, evntnot_warehous_id, evntnot_username) VALUES (819, 20, 35, 'mfgadmin');


ALTER TABLE evntnot ENABLE TRIGGER ALL;

--
-- TOC entry 9551 (class 0 OID 0)
-- Dependencies: 570
-- Name: evntnot_evntnot_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('evntnot_evntnot_id_seq', 819, true);


--
-- TOC entry 9163 (class 0 OID 146619412)
-- Dependencies: 571 9464
-- Data for Name: evnttype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE evnttype DISABLE TRIGGER ALL;

INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (1, 'WoDueDateChanged', 'Work Order Due Date Changed', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (2, 'WoQtyChanged', 'Work Order Qty. Changed', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (3, 'WoCreated', 'Work Order Created', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (4, 'QOHBelowZero', 'QOH Dropped to a Negative Value', 'I/M');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (5, 'RWoDueDateRequestChange', 'Request to Change Released Due Date', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (6, 'RWoQtyRequestChange', 'Request to Change Released W/O Qty.', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (7, 'RWoRequestCancel', 'Request to Cancel Released W/O', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (8, 'WoCancelled', 'Work Order Canceled', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (9, 'CannotDistributeTransToGL', 'Cannot Distribute an Inventory Transaction to the G/L', 'G/L');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (10, 'SoitemQtyChanged', 'Sales Order Qty. Changed', 'S/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (11, 'SoitemCreated', 'Sales Order Item Added', 'S/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (12, 'SoitemSchedDateChanged', 'Sales Order Item Ship Date Changed', 'S/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (13, 'SoitemCancelled', 'Sales Order Item Cancelled', 'S/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (14, 'SoReleased', 'Sales Order Released', 'S/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (16, 'CannotConvertQuote', 'Cannot Convert a Quote to a Sales Order', 'S/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (17, 'DetachCCPayFromSO', 'Detached Credit Card payment from S/O', 'S/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (18, 'WODoubleClockIn', 'User clocked in to a Work Order without having previously clocked out', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (19, 'WODoubleClockOut', 'User clocked out of a Work Order without having previously clocked in', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (20, 'WOClockInOnClosedJob', 'User clocked in to a closed Work Order', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (21, 'WOClockOutWNoClockIn', 'User clocked out of a Work Order on which s/he was not clocked in', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (22, 'NewIncident', 'New Incident Created', 'CRM');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (23, 'UpdatedIncident', 'Incident Modified', 'CRM');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (24, 'ClosedIncident', 'Incident Closed', 'CRM');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (25, 'ReopenedIncident', 'Incident Which had been closed previously is being reopened', 'CRM');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (27, 'ToitemCreated', 'Transfer Order Item Created', 'I/M');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (29, 'ToitemQtyChanged', 'Transfer Order Item Qty. Changed', 'I/M');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (30, 'ToitemSchedDateChanged', 'Transfer Order Item Ship Date Changed', 'I/M');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (31, 'ToitemNoDestItemSite', 'Transfer Order Item created without an Item Site at the Destination Warehouse.', 'I/M');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (32, 'ToitemNoTransitItemSite', 'Transfer Order Item created without an Item Site at the Transit Warehouse.', 'I/M');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (28, 'ToitemCancelled', 'Transfer Order Item Cancelled', 'I/M');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (15, 'SoNotesChanged', 'Sales Order Order Comments Changed', 'S/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (33, 'POitemCreate', 'Purchase Order Purchased Item Line Added', 'P/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (34, 'TodoAlarm', 'To-Do Item Alarm', 'CRM');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (35, 'IncidentAlarm', 'Incident Alarm', 'CRM');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (36, 'TaskAlarm', 'Project Task Alarm', 'CRM');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (37, 'CostExceedsMaxDesired', 'Cost Exceeds Max Desired', 'P/D');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (38, 'PoItemCreatedBySo', 'Purchase Order Item Created by a Sales Order', 'P/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (39, 'PoItemUpdatedBySo', 'Purchase Order Item Updated by a Sales Order', 'P/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (40, 'PoItemSoCancelled', 'The Sales Order item has been cancelled for a linked Purchase Item', 'P/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (41, 'PoItemDropShipped', 'A Purchase Order Item has been Drop Shipped', 'P/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (42, 'CashReceiptPosted', 'A Cash Receipt has been posted', 'G/L');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (45, 'NewCustomer', 'A new Customer has been created', 'S/O');


ALTER TABLE evnttype ENABLE TRIGGER ALL;

--
-- TOC entry 9552 (class 0 OID 0)
-- Dependencies: 572
-- Name: evnttype_evnttype_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('evnttype_evnttype_id_seq', 45, true);


--
-- TOC entry 9553 (class 0 OID 0)
-- Dependencies: 573
-- Name: expcat_expcat_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('expcat_expcat_id_seq', 19, true);


--
-- TOC entry 8935 (class 0 OID 146617709)
-- Dependencies: 243 9464
-- Data for Name: file; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE file DISABLE TRIGGER ALL;



ALTER TABLE file ENABLE TRIGGER ALL;

--
-- TOC entry 9554 (class 0 OID 0)
-- Dependencies: 574
-- Name: file_file_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('file_file_id_seq', 1, false);


--
-- TOC entry 9167 (class 0 OID 146619426)
-- Dependencies: 575 9464
-- Data for Name: filter; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE filter DISABLE TRIGGER ALL;



ALTER TABLE filter ENABLE TRIGGER ALL;

--
-- TOC entry 9555 (class 0 OID 0)
-- Dependencies: 576
-- Name: filter_filter_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('filter_filter_id_seq', 1, false);


--
-- TOC entry 9169 (class 0 OID 146619435)
-- Dependencies: 577 9464
-- Data for Name: fincharg; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE fincharg DISABLE TRIGGER ALL;



ALTER TABLE fincharg ENABLE TRIGGER ALL;

--
-- TOC entry 9556 (class 0 OID 0)
-- Dependencies: 578
-- Name: fincharg_fincharg_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('fincharg_fincharg_id_seq', 1, false);


--
-- TOC entry 9173 (class 0 OID 146619490)
-- Dependencies: 582 9464
-- Data for Name: flcol; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE flcol DISABLE TRIGGER ALL;

INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (1, 14, 'Current', 'Current Month', 331, true, false, false, false, true, 'P', false, false, 'N', false, false, false, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (2, 14, 'Current, Budget', 'Current to Budget', 332, true, false, false, false, false, 'P', false, false, 'N', false, false, false, true, false, true, true);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (3, 14, 'Current, Prior Month', 'Current to Prior Month End', 333, true, false, false, false, false, 'P', true, false, 'N', false, true, true, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (4, 14, 'Current, Prior Quarter', 'Current to Prior Quarter End', 342, true, false, false, false, false, 'P', false, true, 'N', false, true, true, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (5, 14, 'Current, Prior Year', 'Current to Prior Year End', 334, true, false, false, false, false, 'P', false, false, 'F', false, true, true, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (6, 14, 'Current, Year Ago', 'Current to Month Prior Year', 333, true, false, false, false, false, 'Y', true, false, 'N', false, true, true, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (7, 15, 'Month', 'Current Month', 331, true, false, false, false, true, 'P', false, false, 'N', false, false, false, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (8, 15, 'Month, Budget', 'Current Month to Budget', 332, true, false, false, false, false, 'P', false, false, 'N', false, false, false, true, false, true, true);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (9, 15, 'Month, Prior Month', 'Current Month to Prior Month', 333, true, false, false, false, false, 'P', true, false, 'N', false, true, true, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (10, 15, 'Month, YTD', 'Month and Year to Date', 330, true, false, true, false, true, 'P', false, false, 'N', false, false, false, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (11, 15, 'Month, QTD', 'Month and Quarter to Date', 335, true, true, false, false, true, 'P', false, false, 'N', false, false, false, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (12, 15, 'QTD, Budget', 'Quarter to Date to Budget', 337, false, true, false, false, false, 'P', false, false, 'N', false, false, false, true, false, true, true);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (13, 15, 'QTD, Prior Quarter', 'Quarter to Date to Prior Quarter', 338, false, true, false, false, false, 'P', false, true, 'N', false, true, true, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (14, 15, 'YTD', 'Year To Date', 339, false, false, true, false, true, 'P', false, false, 'N', false, false, false, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (15, 15, 'YTD, Budget', 'Year to Date to Budget', 340, false, false, true, false, false, 'P', false, false, 'N', false, false, false, true, false, true, true);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (16, 15, 'YTD, Prior Full Year', 'Year to Date to Prior Full Year', 341, false, false, true, false, false, 'P', false, false, 'F', false, true, true, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (17, 15, 'Month, Prior Year Month', 'Current Month to Same Month Prior Year', 333, true, false, false, false, false, 'Y', true, false, 'N', false, true, true, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (19, 15, 'YTD, Prior Year YTD', 'Year to Date to Year to Date Prior Year', 341, false, false, true, false, false, 'P', false, false, 'D', false, true, true, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (20, 15, 'QTD', 'Quarter to Date', 336, false, true, false, false, true, 'P', false, false, 'N', false, false, false, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (18, 15, 'QTD, Prior Year Quarter', 'Quarter to Date to Same Quarter Prior Year', 338, false, true, false, false, false, 'Y', false, true, 'N', false, true, true, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (21, 16, 'Current', 'Current Period', 331, true, false, false, false, true, 'P', false, false, 'N', false, false, false, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (22, 16, 'Current Period, YTD', 'Current Period, YTD', 330, true, false, true, false, false, 'Y', false, false, 'N', false, false, false, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (23, 16, 'Current, Prior Period', 'Current, Prior Period', 333, true, false, false, false, true, 'P', true, false, 'N', false, false, false, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (24, 16, 'Current Quarter, Prior Year Quarter', 'Current Quarter, Prior Year Quarter', 338, false, true, false, false, false, 'Y', false, true, 'N', false, false, false, false, false, false, false);


ALTER TABLE flcol ENABLE TRIGGER ALL;

--
-- TOC entry 9557 (class 0 OID 0)
-- Dependencies: 583
-- Name: flcol_flcol_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('flcol_flcol_id_seq', 24, true);


--
-- TOC entry 9175 (class 0 OID 146619498)
-- Dependencies: 584 9464
-- Data for Name: flgrp; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE flgrp DISABLE TRIGGER ALL;

INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (87, 14, -1, 1, 'ASSETS', 'ASSETS', true, false, false, false, true, false, true, false, false, false, false, -1, false, false, false, false, true, 'Total Assets');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (88, 14, -1, 2, 'LIABILITIES AND OWNERS EQUITY', 'LIABILITIES AND OWNERS EQUITY', true, false, true, false, true, false, true, false, false, false, false, -1, false, false, false, false, true, 'Total Liabilities and Owners Equity');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (89, 14, 88, 1, 'LIABILITIES', 'LIABILITIES', true, false, false, false, true, false, true, false, true, false, true, -1, false, false, false, false, true, 'Total Liabilities');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (90, 14, 88, 2, 'OWNERS EQUITY', 'OWNERS EQUITY', true, false, false, false, true, false, true, false, true, false, true, -1, false, false, false, false, true, 'Total Owners Equity');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (91, 14, 90, 2, 'Net Income', '', false, true, false, false, true, false, true, false, true, false, true, -1, false, false, false, false, false, '');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (92, 15, -1, 1, 'INCOME', 'INCOME', true, false, false, false, false, false, true, false, false, false, false, -1, true, false, false, false, true, 'Net Income');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (93, 15, 92, 2, 'REVENUE', 'REVENUE', true, false, false, false, false, false, true, false, false, false, false, -1, true, false, false, false, true, 'Total Net Revenue');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (94, 15, 92, 3, 'EXPENSES', 'EXPENSES', true, false, true, false, false, false, true, false, false, false, false, -1, true, false, false, false, true, 'Total Net Expenses');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (96, 16, -1, 2, 'CASH POSITION', 'CASH POSITION', true, false, true, false, false, true, true, false, false, true, true, -1, true, true, false, false, true, 'TOTAL CASH POSITION');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (98, 16, 95, 2, 'Cash Flow From Investing Activities', 'Cash Flow From Investing Activities', true, false, true, false, false, true, true, false, false, true, true, -1, true, true, false, false, true, 'Total Cash Flow From Investing Activities');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (99, 16, 95, 3, 'Cash Flow from Financing Activities', 'Cash Flow from Financing Activities', true, false, false, false, false, true, true, false, false, true, true, -1, true, true, false, false, true, 'Total Cash Flow from Financing Activities');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (105, 16, 97, 6, 'Change in Current Liability', 'Change in Current Liability', true, false, false, false, false, true, true, false, false, true, true, -1, true, true, false, false, true, 'Total Change in Current Liability');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (106, 16, 97, 7, 'Accounts Payable', 'Accounts Payable', true, false, false, false, false, true, true, false, false, true, true, -1, true, true, false, false, true, 'Total Accounts Payable');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (107, 16, 98, 1, 'Property Plant and Equipment', 'Property Plant and Equipment', true, false, false, false, false, true, true, false, false, true, true, -1, true, true, false, false, true, 'Total Property Plant and Equipment');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (108, 16, 98, 2, 'Other Assets', 'Other Assets', true, false, false, false, false, true, true, false, false, true, true, -1, true, true, false, false, true, 'Total Other Assets');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (109, 16, 99, 1, 'Long Term Debt', 'Long Term Debt', true, false, false, false, false, true, true, false, false, true, true, -1, true, true, false, false, true, 'Total Long Term Debt');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (110, 16, 99, 2, 'Common Stock and Equity', '', true, false, false, false, false, true, true, false, false, true, true, -1, true, true, false, false, true, 'Total Common Stock and Equity');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (97, 16, 95, 1, 'Cash Flow From Operating Activities', 'Cash Flow From Operating Activities', true, false, false, false, false, true, true, false, false, true, true, -1, true, true, false, false, true, 'Total Cash Flow From Operating Activities');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (95, 16, -1, 1, 'STATEMENT OF CASH FLOWS', 'STATEMENT OF CASH FLOWS', true, false, false, false, false, true, true, false, false, true, true, -1, true, true, false, false, true, 'TOTAL STATEMENT OF CASH FLOWS');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (111, 16, 100, 1, 'Net Income', 'Net Income', true, true, false, false, false, true, true, false, false, true, true, -1, true, true, false, false, false, '');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (100, 16, 97, 1, 'Cash Flow From Operating Activities', 'Cash Flow From Operating Activities', true, false, false, false, false, true, true, false, false, true, true, -1, true, true, false, false, true, 'Total Cash Flow From Operating Activities');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (101, 16, 97, 2, 'Charges Not Using Cash', 'Charges Not Using Cash', true, false, false, false, false, true, true, false, false, true, true, -1, true, true, false, false, true, 'Total Charges Not Using Cash');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (102, 16, 97, 3, 'Changes in Current Assets', 'Changes in Current Assets', true, false, true, false, false, true, true, false, false, true, true, -1, true, true, false, false, true, 'Total Changes in Current Assets');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (103, 16, 97, 4, 'Net Receivables', 'Net Receivables', true, false, true, false, false, true, true, false, false, true, true, -1, true, true, false, false, true, 'Total Net Receivables');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (104, 16, 97, 5, 'Inventory', 'Inventory', true, false, true, false, false, true, true, false, false, true, true, -1, true, true, false, false, true, 'Total Inventory');


ALTER TABLE flgrp ENABLE TRIGGER ALL;

--
-- TOC entry 9558 (class 0 OID 0)
-- Dependencies: 585
-- Name: flgrp_flgrp_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('flgrp_flgrp_id_seq', 111, true);


--
-- TOC entry 9171 (class 0 OID 146619443)
-- Dependencies: 579 9464
-- Data for Name: flhead; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE flhead DISABLE TRIGGER ALL;

INSERT INTO flhead (flhead_id, flhead_name, flhead_descrip, flhead_showtotal, flhead_showstart, flhead_showend, flhead_showdelta, flhead_showbudget, flhead_showdiff, flhead_showcustom, flhead_custom_label, flhead_usealttotal, flhead_alttotal, flhead_usealtbegin, flhead_altbegin, flhead_usealtend, flhead_altend, flhead_usealtdebits, flhead_altdebits, flhead_usealtcredits, flhead_altcredits, flhead_usealtbudget, flhead_altbudget, flhead_usealtdiff, flhead_altdiff, flhead_type, flhead_active, flhead_sys, flhead_notes) VALUES (14, 'Basic Balance Sheet', 'Balance Sheet Template', false, false, false, false, false, false, false, NULL, false, NULL, false, NULL, false, NULL, false, NULL, false, NULL, false, NULL, false, NULL, 'B', true, true, '');
INSERT INTO flhead (flhead_id, flhead_name, flhead_descrip, flhead_showtotal, flhead_showstart, flhead_showend, flhead_showdelta, flhead_showbudget, flhead_showdiff, flhead_showcustom, flhead_custom_label, flhead_usealttotal, flhead_alttotal, flhead_usealtbegin, flhead_altbegin, flhead_usealtend, flhead_altend, flhead_usealtdebits, flhead_altdebits, flhead_usealtcredits, flhead_altcredits, flhead_usealtbudget, flhead_altbudget, flhead_usealtdiff, flhead_altdiff, flhead_type, flhead_active, flhead_sys, flhead_notes) VALUES (15, 'Basic Income Statement', 'Income Statement Template', false, false, false, false, false, false, false, '', false, '', false, '', false, '', false, '', false, '', false, '', false, '', 'I', true, true, '');
INSERT INTO flhead (flhead_id, flhead_name, flhead_descrip, flhead_showtotal, flhead_showstart, flhead_showend, flhead_showdelta, flhead_showbudget, flhead_showdiff, flhead_showcustom, flhead_custom_label, flhead_usealttotal, flhead_alttotal, flhead_usealtbegin, flhead_altbegin, flhead_usealtend, flhead_altend, flhead_usealtdebits, flhead_altdebits, flhead_usealtcredits, flhead_altcredits, flhead_usealtbudget, flhead_altbudget, flhead_usealtdiff, flhead_altdiff, flhead_type, flhead_active, flhead_sys, flhead_notes) VALUES (16, 'Basic Statement of Cash Flows', 'Basic Statement of Cash Flows', true, false, false, true, true, true, false, '', true, 'CHECKSUM (TOTAL STA. OF CASH FLOWS - TOTAL CASH)', false, '', false, '', false, '', false, '', false, '', false, '', 'C', true, true, '');


ALTER TABLE flhead ENABLE TRIGGER ALL;

--
-- TOC entry 9559 (class 0 OID 0)
-- Dependencies: 586
-- Name: flhead_flhead_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('flhead_flhead_id_seq', 16, true);


--
-- TOC entry 9172 (class 0 OID 146619468)
-- Dependencies: 580 9464
-- Data for Name: flitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE flitem DISABLE TRIGGER ALL;

INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (237, 14, 87, 1, -1, false, true, false, true, false, false, true, false, true, -1, true, false, false, false, 'S', 'All', 'All', 'All', 'All', 'A', 'All');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (238, 14, 89, 1, -1, false, true, false, true, false, false, true, false, true, -1, true, false, false, false, 'S', 'All', 'All', 'All', 'All', 'L', 'All');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (239, 14, 90, 1, -1, false, true, false, true, false, false, true, false, true, -1, true, false, false, false, 'S', 'All', 'All', 'All', 'All', 'Q', 'All');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (240, 14, 91, 1, -1, false, true, false, true, false, false, false, false, false, -1, true, false, false, false, 'S', 'All', 'All', 'All', 'All', 'R', 'All');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (241, 14, 91, 2, -1, false, true, false, true, true, false, false, false, false, -1, true, false, false, false, 'S', 'All', 'All', 'All', 'All', 'E', 'All');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (242, 15, 93, 1, -1, false, false, false, true, false, false, false, false, true, -1, true, true, false, false, 'S', 'All', 'All', 'All', 'All', 'R', 'All');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (243, 15, 94, 1, -1, false, false, false, true, false, false, false, false, true, -1, true, true, false, false, 'S', 'All', 'All', 'All', 'All', 'E', 'All');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (245, 16, 111, 2, -1, false, false, true, true, true, false, false, true, true, -1, true, true, false, false, 'S', 'All', 'All', 'All', 'All', 'E', 'All');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (244, 16, 111, 1, -1, false, false, true, true, false, false, false, true, true, -1, true, true, false, false, 'S', 'All', 'All', 'All', 'All', 'R', 'All');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (246, 16, 101, 1, -1, false, false, true, true, false, false, false, true, true, -1, true, true, false, false, 'S', 'All', 'All', 'All', 'All', 'E', 'DEP');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (247, 16, 102, 1, -1, false, false, true, true, false, false, false, true, true, -1, true, true, false, false, 'S', 'All', 'All', 'All', 'All', 'A', 'CAS');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (248, 16, 103, 1, -1, false, false, true, true, false, false, false, true, true, -1, true, true, false, false, 'S', 'All', 'All', 'All', 'All', 'A', 'AR');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (249, 16, 104, 1, -1, false, false, true, true, false, false, false, true, true, -1, true, true, false, false, 'S', 'All', 'All', 'All', 'All', 'A', 'IN');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (250, 16, 105, 1, -1, false, false, true, true, false, false, false, true, true, -1, true, true, false, false, 'S', 'All', 'All', 'All', 'All', 'L', 'CL');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (251, 16, 106, 1, -1, false, false, true, true, false, false, false, true, true, -1, true, true, false, false, 'S', 'All', 'All', 'All', 'All', 'L', 'AP');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (252, 16, 107, 1, -1, false, false, true, true, false, false, false, true, true, -1, true, true, false, false, 'S', 'All', 'All', 'All', 'All', 'A', 'FA');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (253, 16, 109, 1, -1, false, false, true, true, false, false, false, true, true, -1, true, true, false, false, 'S', 'All', 'All', 'All', 'All', 'L', 'LTL');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (254, 16, 110, 1, -1, false, false, true, true, false, false, false, true, true, -1, true, true, false, false, 'S', 'All', 'All', 'All', 'All', 'Q', 'All');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (255, 16, 96, 1, -1, false, false, true, true, false, false, false, true, true, -1, true, true, false, false, 'S', 'All', 'All', 'All', 'All', 'A', 'CA');


ALTER TABLE flitem ENABLE TRIGGER ALL;

--
-- TOC entry 9560 (class 0 OID 0)
-- Dependencies: 587
-- Name: flitem_flitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('flitem_flitem_id_seq', 255, true);


--
-- TOC entry 9179 (class 0 OID 146619527)
-- Dependencies: 588 9171 8945 9464
-- Data for Name: flnotes; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE flnotes DISABLE TRIGGER ALL;



ALTER TABLE flnotes ENABLE TRIGGER ALL;

--
-- TOC entry 9561 (class 0 OID 0)
-- Dependencies: 589
-- Name: flnotes_flnotes_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('flnotes_flnotes_id_seq', 1, false);


--
-- TOC entry 9181 (class 0 OID 146619536)
-- Dependencies: 590 9464
-- Data for Name: flrpt; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE flrpt DISABLE TRIGGER ALL;

INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 4, 2, 'I', 12, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 2, 0, 'G', 12, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 3, 1, 'G', 13, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 5, 2, 'I', 13, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 6, 2, 'I', 14, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 7, 2, 'I', 15, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 8, 2, 'I', 16, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 7);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 9, 2, 'I', 17, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 10, 2, 'I', 18, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 11, 2, 'I', 19, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 10);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 12, 2, 'I', 20, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 11);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 13, 2, 'I', 21, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 12);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 14, 2, 'I', 22, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 16, 1, 'G', 14, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 14);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 17, 2, 'I', 23, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 19, 1, 'G', 15, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 16);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 22, 0, 'G', 16, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 17);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 23, 1, 'G', 17, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 24, 2, 'G', 18, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 19);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 25, 3, 'I', 24, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 20);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 26, 3, 'I', 25, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 21);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 27, 3, 'I', 26, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 22);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 28, 3, 'I', 27, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 23);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 29, 3, 'I', 28, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 30, 3, 'I', 29, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 25);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 32, 2, 'G', 20, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 26);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 35, 1, 'G', 21, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 27);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 36, 2, 'G', 22, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 28);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 37, 3, 'I', 30, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 29);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 39, 2, 'G', 23, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 30);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 40, 2, 'G', 24, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 31);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 41, 3, 'I', 31, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 32);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 42, 3, 'I', 45, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 33);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 21, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 34);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 15, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 35);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 18, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 36);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 20, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 15, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 37);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 45, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 34, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 39);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 31, 3, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 40);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 33, 3, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 20, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 41);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 44, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 42);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 38, 3, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 32, 'jsmith', 43, 3, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 44);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 2, 0, 'G', 12, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 3, 1, 'G', 13, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 46);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 4, 2, 'I', 12, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 47);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 5, 2, 'I', 13, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 48);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 6, 2, 'I', 14, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 49);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 7, 2, 'I', 15, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 50);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 8, 2, 'I', 16, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 51);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 9, 2, 'I', 17, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 52);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 10, 2, 'I', 18, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 53);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 11, 2, 'I', 19, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 54);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 12, 2, 'I', 20, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 55);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 13, 2, 'I', 21, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 56);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 14, 2, 'I', 22, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 57);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 16, 1, 'G', 14, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 58);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 17, 2, 'I', 23, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 59);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 19, 1, 'G', 15, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 60);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 22, 0, 'G', 16, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 61);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 23, 1, 'G', 17, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 62);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 24, 2, 'G', 18, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 63);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 25, 3, 'I', 24, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 64);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 26, 3, 'I', 25, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 65);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 27, 3, 'I', 26, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 66);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 28, 3, 'I', 27, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 67);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 29, 3, 'I', 28, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 68);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 30, 3, 'I', 29, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 69);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 32, 2, 'G', 20, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 70);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 35, 1, 'G', 21, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 71);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 36, 2, 'G', 22, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 72);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 37, 3, 'I', 30, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 73);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 39, 2, 'G', 23, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 74);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 40, 2, 'G', 24, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 75);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 41, 3, 'I', 31, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 76);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 42, 3, 'I', 45, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 77);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 21, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 78);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 15, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 79);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 18, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 80);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 20, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 15, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 81);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 45, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 82);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 34, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 83);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 31, 3, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 84);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 33, 3, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 20, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 85);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 44, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 86);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 38, 3, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 87);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 33, 'jsmith', 43, 3, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 88);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 2, 0, 'G', 12, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 89);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 3, 1, 'G', 13, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 90);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 4, 2, 'I', 12, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 91);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 5, 2, 'I', 13, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 92);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 6, 2, 'I', 14, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 93);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 7, 2, 'I', 15, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 94);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 8, 2, 'I', 16, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 95);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 9, 2, 'I', 17, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 96);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 10, 2, 'I', 18, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 97);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 11, 2, 'I', 19, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 98);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 12, 2, 'I', 20, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 99);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 13, 2, 'I', 21, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 100);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 14, 2, 'I', 22, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 101);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 16, 1, 'G', 14, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 102);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 17, 2, 'I', 23, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 103);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 19, 1, 'G', 15, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 104);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 22, 0, 'G', 16, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 105);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 23, 1, 'G', 17, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 106);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 24, 2, 'G', 18, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 107);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 25, 3, 'I', 24, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 108);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 26, 3, 'I', 25, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 109);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 27, 3, 'I', 26, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 110);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 28, 3, 'I', 27, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 111);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 29, 3, 'I', 28, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 112);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 30, 3, 'I', 29, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 113);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 32, 2, 'G', 20, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 114);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 35, 1, 'G', 21, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 115);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 36, 2, 'G', 22, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 116);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 37, 3, 'I', 30, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 117);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 39, 2, 'G', 23, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 118);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 40, 2, 'G', 24, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 119);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 41, 3, 'I', 31, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 120);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 42, 3, 'I', 45, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 121);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 21, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 122);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 15, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 123);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 18, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 124);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 20, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 15, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 125);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 45, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 126);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 34, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 127);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 31, 3, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 128);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 33, 3, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 20, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 129);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 44, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 130);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 38, 3, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 131);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 34, 'jsmith', 43, 3, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 132);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 2, 0, 'G', 12, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 133);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 3, 1, 'G', 13, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 134);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 4, 2, 'I', 12, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 135);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 5, 2, 'I', 13, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 136);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 6, 2, 'I', 14, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 137);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 7, 2, 'I', 15, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 138);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 8, 2, 'I', 16, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 139);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 9, 2, 'I', 17, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 140);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 10, 2, 'I', 18, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 141);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 11, 2, 'I', 19, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 142);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 12, 2, 'I', 20, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 143);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 13, 2, 'I', 21, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 144);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 14, 2, 'I', 22, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 145);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 16, 1, 'G', 14, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 146);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 17, 2, 'I', 23, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 147);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 19, 1, 'G', 15, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 148);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 22, 0, 'G', 16, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 149);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 23, 1, 'G', 17, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 150);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 24, 2, 'G', 18, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 151);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 25, 3, 'I', 24, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 152);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 26, 3, 'I', 25, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 153);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 27, 3, 'I', 26, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 154);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 28, 3, 'I', 27, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 155);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 29, 3, 'I', 28, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 156);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 30, 3, 'I', 29, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 157);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 32, 2, 'G', 20, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 158);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 35, 1, 'G', 21, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 159);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 36, 2, 'G', 22, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 160);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 37, 3, 'I', 30, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 161);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 39, 2, 'G', 23, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 162);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 40, 2, 'G', 24, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 163);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 41, 3, 'I', 31, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 164);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 42, 3, 'I', 45, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 165);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 21, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 166);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 15, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 167);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 18, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 168);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 20, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 15, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 169);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 45, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 170);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 34, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 171);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 31, 3, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 172);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 33, 3, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 20, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 173);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 44, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 174);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 38, 3, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 175);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 35, 'jsmith', 43, 3, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 176);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 2, 0, 'G', 12, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 177);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 3, 1, 'G', 13, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 178);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 4, 2, 'I', 12, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 179);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 5, 2, 'I', 13, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 180);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 6, 2, 'I', 14, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 181);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 7, 2, 'I', 15, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 182);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 8, 2, 'I', 16, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 183);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 9, 2, 'I', 17, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 184);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 10, 2, 'I', 18, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 185);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 11, 2, 'I', 19, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 186);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 12, 2, 'I', 20, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 187);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 13, 2, 'I', 21, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 188);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 14, 2, 'I', 22, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 189);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 16, 1, 'G', 14, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 190);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 17, 2, 'I', 23, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 191);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 19, 1, 'G', 15, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 192);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 22, 0, 'G', 16, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 193);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 23, 1, 'G', 17, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 194);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 24, 2, 'G', 18, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 195);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 25, 3, 'I', 24, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 196);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 26, 3, 'I', 25, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 197);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 27, 3, 'I', 26, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 198);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 28, 3, 'I', 27, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 199);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 29, 3, 'I', 28, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 200);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 30, 3, 'I', 29, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 201);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 32, 2, 'G', 20, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 202);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 35, 1, 'G', 21, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 203);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 36, 2, 'G', 22, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 204);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 37, 3, 'I', 30, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 205);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 39, 2, 'G', 23, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 206);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 40, 2, 'G', 24, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 207);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 41, 3, 'I', 31, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 208);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 42, 3, 'I', 45, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 209);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 21, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 210);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 15, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 211);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 18, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 212);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 20, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 15, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 213);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 45, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 214);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 34, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 215);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 31, 3, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 216);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 33, 3, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 20, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 217);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 44, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 218);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 38, 3, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 219);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 36, 'jsmith', 43, 3, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 220);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 1, 0, 'G', 3, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 221);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 2, 1, 'G', 4, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 222);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 3, 2, 'I', 2, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 223);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 4, 2, 'I', 3, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 224);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 6, 1, 'G', 5, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 225);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 7, 2, 'I', 4, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 226);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 8, 1, 'G', 6, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 227);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 10, 0, 'G', 7, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 228);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 11, 1, 'G', 8, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 229);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 12, 2, 'I', 5, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 230);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 13, 2, 'I', 6, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 231);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 14, 2, 'I', 7, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 232);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 15, 2, 'I', 8, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 233);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 16, 2, 'I', 9, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 234);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 17, 2, 'I', 10, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 235);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 18, 2, 'I', 11, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 236);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 21, 0, 'G', 9, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 237);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 5, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 238);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 9, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 239);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 240);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 20, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 241);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 34, 'jsmith', 22, 0, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 242);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 1, 0, 'G', 3, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 243);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 2, 1, 'G', 4, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 244);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 3, 2, 'I', 2, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 245);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 4, 2, 'I', 3, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 246);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 6, 1, 'G', 5, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 247);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 7, 2, 'I', 4, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 248);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 8, 1, 'G', 6, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 249);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 10, 0, 'G', 7, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 250);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 11, 1, 'G', 8, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 251);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 12, 2, 'I', 5, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 252);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 13, 2, 'I', 6, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 253);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 14, 2, 'I', 7, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 254);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 15, 2, 'I', 8, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 255);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 16, 2, 'I', 9, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 256);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 17, 2, 'I', 10, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 257);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 18, 2, 'I', 11, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 258);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 21, 0, 'G', 9, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 259);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 5, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 260);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 9, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 261);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 262);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 20, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 263);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 35, 'jsmith', 22, 0, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 264);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 1, 0, 'G', 3, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 265);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 2, 1, 'G', 4, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 266);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 3, 2, 'I', 2, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 267);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 4, 2, 'I', 3, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 268);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 6, 1, 'G', 5, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 269);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 7, 2, 'I', 4, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 270);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 8, 1, 'G', 6, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 271);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 10, 0, 'G', 7, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 272);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 11, 1, 'G', 8, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 273);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 12, 2, 'I', 5, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 274);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 13, 2, 'I', 6, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 275);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 14, 2, 'I', 7, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 276);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 15, 2, 'I', 8, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 277);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 16, 2, 'I', 9, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 278);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 17, 2, 'I', 10, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 279);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 18, 2, 'I', 11, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 280);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 21, 0, 'G', 9, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 281);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 5, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 282);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 9, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 283);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 284);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 20, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 285);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 36, 'jsmith', 22, 0, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 286);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 1, 0, 'G', 3, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 287);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 2, 1, 'G', 4, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 288);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 3, 2, 'I', 2, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 289);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 4, 2, 'I', 3, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 290);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 6, 1, 'G', 5, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 291);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 7, 2, 'I', 4, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 292);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 8, 1, 'G', 6, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 293);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 10, 0, 'G', 7, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 294);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 11, 1, 'G', 8, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 295);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 12, 2, 'I', 5, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 296);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 13, 2, 'I', 6, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 297);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 14, 2, 'I', 7, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 298);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 15, 2, 'I', 8, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 299);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 16, 2, 'I', 9, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 300);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 17, 2, 'I', 10, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 301);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 18, 2, 'I', 11, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 302);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 21, 0, 'G', 9, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 303);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 5, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 304);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 9, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 305);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 306);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 20, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 307);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 37, 'jsmith', 22, 0, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 308);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 1, 0, 'G', 3, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 309);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 2, 1, 'G', 4, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 310);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 3, 2, 'I', 2, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 311);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 4, 2, 'I', 3, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 312);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 6, 1, 'G', 5, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 313);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 7, 2, 'I', 4, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 314);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 8, 1, 'G', 6, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 315);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 10, 0, 'G', 7, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 316);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 11, 1, 'G', 8, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 317);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 12, 2, 'I', 5, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 318);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 13, 2, 'I', 6, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 319);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 14, 2, 'I', 7, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 320);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 15, 2, 'I', 8, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 321);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 16, 2, 'I', 9, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 322);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 17, 2, 'I', 10, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 323);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 18, 2, 'I', 11, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 324);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 21, 0, 'G', 9, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 325);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 5, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 326);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 9, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 327);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 328);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 20, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 329);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 38, 'jsmith', 22, 0, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 330);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 1, 0, 'G', 3, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 331);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 2, 1, 'G', 4, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 332);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 3, 2, 'I', 2, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 333);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 4, 2, 'I', 3, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 334);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 6, 1, 'G', 5, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 335);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 7, 2, 'I', 4, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 336);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 8, 1, 'G', 6, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 337);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 10, 0, 'G', 7, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 338);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 11, 1, 'G', 8, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 339);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 12, 2, 'I', 5, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 340);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 13, 2, 'I', 6, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 341);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 14, 2, 'I', 7, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 342);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 15, 2, 'I', 8, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 343);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 16, 2, 'I', 9, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 344);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 17, 2, 'I', 10, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 345);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 18, 2, 'I', 11, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 346);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 21, 0, 'G', 9, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 347);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 5, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 348);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 9, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 349);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 350);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 20, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 351);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 39, 'jsmith', 22, 0, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 352);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 1, 0, 'G', 3, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 353);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 2, 1, 'G', 4, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 354);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 3, 2, 'I', 2, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 355);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 4, 2, 'I', 3, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 356);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 6, 1, 'G', 5, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 357);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 7, 2, 'I', 4, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 358);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 8, 1, 'G', 6, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 359);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 10, 0, 'G', 7, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 360);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 11, 1, 'G', 8, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 361);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 12, 2, 'I', 5, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 362);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 13, 2, 'I', 6, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 363);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 14, 2, 'I', 7, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 364);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 15, 2, 'I', 8, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 365);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 16, 2, 'I', 9, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 366);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 17, 2, 'I', 10, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 367);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 18, 2, 'I', 11, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 368);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 21, 0, 'G', 9, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 369);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 5, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 370);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 9, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 371);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 372);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 20, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 373);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 40, 'jsmith', 22, 0, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 374);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 1, 0, 'G', 3, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 375);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 2, 1, 'G', 4, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 376);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 3, 2, 'I', 2, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 377);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 4, 2, 'I', 3, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 378);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 6, 1, 'G', 5, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 379);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 7, 2, 'I', 4, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 380);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 8, 1, 'G', 6, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 381);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 10, 0, 'G', 7, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 382);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 11, 1, 'G', 8, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 383);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 12, 2, 'I', 5, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 384);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 13, 2, 'I', 6, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 385);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 14, 2, 'I', 7, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 386);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 15, 2, 'I', 8, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 387);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 16, 2, 'I', 9, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 388);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 17, 2, 'I', 10, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 389);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 18, 2, 'I', 11, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 390);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 21, 0, 'G', 9, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 391);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 5, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 392);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 9, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 393);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 394);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 20, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 395);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 41, 'jsmith', 22, 0, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 396);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 1, 0, 'G', 3, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 397);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 2, 1, 'G', 4, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 398);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 3, 2, 'I', 2, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 399);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 4, 2, 'I', 3, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 400);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 6, 1, 'G', 5, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 401);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 7, 2, 'I', 4, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 402);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 8, 1, 'G', 6, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 403);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 10, 0, 'G', 7, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 404);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 11, 1, 'G', 8, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 405);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 12, 2, 'I', 5, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 406);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 13, 2, 'I', 6, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 407);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 14, 2, 'I', 7, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 408);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 15, 2, 'I', 8, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 409);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 16, 2, 'I', 9, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 410);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 17, 2, 'I', 10, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 411);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 18, 2, 'I', 11, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 412);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 21, 0, 'G', 9, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 413);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 5, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 414);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 9, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 415);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 416);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 20, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 417);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 32, 'jsmith', 22, 0, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 418);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 1, 0, 'G', 3, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 419);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 2, 1, 'G', 4, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 420);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 3, 2, 'I', 2, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 421);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 4, 2, 'I', 3, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 422);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 6, 1, 'G', 5, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 423);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 7, 2, 'I', 4, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 424);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 8, 1, 'G', 6, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 425);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 10, 0, 'G', 7, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 426);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 11, 1, 'G', 8, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 427);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 12, 2, 'I', 5, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 428);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 13, 2, 'I', 6, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 429);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 14, 2, 'I', 7, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 430);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 15, 2, 'I', 8, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 431);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 16, 2, 'I', 9, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 432);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 17, 2, 'I', 10, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 433);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 18, 2, 'I', 11, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 434);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 21, 0, 'G', 9, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 435);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 5, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 436);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 9, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 437);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 438);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 20, 1, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 439);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 33, 'jsmith', 22, 0, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 440);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 30, 'jsmith', 1, 0, 'G', 26, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 441);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 30, 'jsmith', 2, 1, 'G', 28, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 26, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 442);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 30, 'jsmith', 3, 2, 'I', 42, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 443);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 30, 'jsmith', 5, 1, 'G', 30, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 26, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 444);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 30, 'jsmith', 6, 2, 'G', 31, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 445);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 30, 'jsmith', 7, 3, 'I', 43, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 31, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 446);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 30, 'jsmith', 9, 2, 'G', 32, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 447);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 30, 'jsmith', 10, 3, 'I', 44, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 32, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 448);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 30, 'jsmith', 12, 2, 'G', 34, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 449);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 30, 'jsmith', 14, 0, 'G', 35, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 450);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 30, 'jsmith', 4, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 451);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 30, 'jsmith', 8, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 31, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 452);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 30, 'jsmith', 11, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 32, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 453);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 30, 'jsmith', 13, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 454);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 30, 'jsmith', 15, 0, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 455);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 46, 'jsmith', 1, 0, 'G', 26, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 456);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 46, 'jsmith', 2, 1, 'G', 28, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 26, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 457);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 46, 'jsmith', 3, 2, 'I', 42, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 458);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 46, 'jsmith', 5, 1, 'G', 30, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 26, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 459);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 46, 'jsmith', 6, 2, 'G', 31, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 460);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 46, 'jsmith', 7, 3, 'I', 43, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 31, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 461);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 46, 'jsmith', 9, 2, 'G', 32, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 462);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 46, 'jsmith', 10, 3, 'I', 44, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 32, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 463);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 46, 'jsmith', 12, 2, 'G', 34, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 464);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 46, 'jsmith', 14, 0, 'G', 35, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 465);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 46, 'jsmith', 4, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 466);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 46, 'jsmith', 13, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 467);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 46, 'jsmith', 8, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 31, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 468);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 46, 'jsmith', 11, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 32, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 469);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 46, 'jsmith', 15, 0, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 470);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 29, 'jsmith', 1, 0, 'G', 26, 0.00, 500.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 471);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 29, 'jsmith', 2, 1, 'G', 28, 0.00, 500.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 26, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 472);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 29, 'jsmith', 3, 2, 'I', 42, NULL, 500.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 473);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 29, 'jsmith', 5, 1, 'G', 30, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 26, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 474);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 29, 'jsmith', 6, 2, 'G', 31, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 475);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 29, 'jsmith', 7, 3, 'I', 43, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 31, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 476);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 29, 'jsmith', 9, 2, 'G', 32, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 477);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 29, 'jsmith', 10, 3, 'I', 44, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 32, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 478);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 29, 'jsmith', 12, 2, 'G', 34, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 479);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 29, 'jsmith', 14, 0, 'G', 35, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 480);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 29, 'jsmith', 4, 2, 'T', -1, NULL, 500.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 481);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 29, 'jsmith', 13, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 482);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 29, 'jsmith', 8, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 31, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 483);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 29, 'jsmith', 11, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 32, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 484);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 29, 'jsmith', 15, 0, 'T', -1, NULL, 500.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 485);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 28, 'jsmith', 1, 0, 'G', 26, 0.00, 206.07, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 486);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 28, 'jsmith', 2, 1, 'G', 28, 0.00, 200.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 26, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 487);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 28, 'jsmith', 3, 2, 'I', 42, NULL, 200.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 488);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 28, 'jsmith', 5, 1, 'G', 30, 0.00, 6.07, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 26, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 489);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 28, 'jsmith', 6, 2, 'G', 31, 0.00, 1.07, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 490);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 28, 'jsmith', 7, 3, 'I', 43, NULL, 1.07, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 31, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 491);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 28, 'jsmith', 9, 2, 'G', 32, 0.00, 5.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 492);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 28, 'jsmith', 10, 3, 'I', 44, NULL, 5.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 32, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 493);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 28, 'jsmith', 12, 2, 'G', 34, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 494);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 28, 'jsmith', 14, 0, 'G', 35, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 495);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 28, 'jsmith', 4, 2, 'T', -1, NULL, 200.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 496);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 28, 'jsmith', 13, 2, 'T', -1, NULL, 6.07, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 497);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 28, 'jsmith', 8, 3, 'T', -1, NULL, 1.07, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 31, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 498);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 28, 'jsmith', 11, 3, 'T', -1, NULL, 5.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 32, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 499);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (9, 28, 'jsmith', 15, 0, 'T', -1, NULL, 206.07, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 500);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 1, 0, 'G', 12, 0.00, 1000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 1000.00, NULL, NULL, NULL, NULL, 501);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 2, 1, 'G', 13, 0.00, 1000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 1000.00, NULL, NULL, NULL, NULL, 502);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 3, 2, 'I', 12, NULL, 2000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 2000.00, NULL, NULL, NULL, NULL, 503);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 4, 2, 'I', 13, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 504);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 5, 2, 'I', 14, NULL, -1000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, -1000.00, NULL, NULL, NULL, NULL, 505);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 6, 2, 'I', 15, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 506);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 7, 2, 'I', 16, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 507);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 8, 2, 'I', 17, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 508);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 9, 2, 'I', 18, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 509);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 10, 2, 'I', 19, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 510);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 11, 2, 'I', 20, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 511);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 12, 2, 'I', 21, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 512);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 13, 2, 'I', 22, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 513);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 15, 1, 'G', 14, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 514);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 16, 2, 'I', 23, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 515);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 18, 1, 'G', 15, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 516);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 21, 0, 'G', 16, 0.00, 1000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 1000.00, NULL, NULL, NULL, NULL, 517);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 22, 1, 'G', 17, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 518);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 23, 2, 'G', 18, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 519);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 24, 3, 'I', 24, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 520);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 25, 3, 'I', 25, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 521);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 26, 3, 'I', 26, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 522);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 27, 3, 'I', 27, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 523);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 28, 3, 'I', 28, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 524);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 29, 3, 'I', 29, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 525);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 31, 2, 'G', 20, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 526);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 34, 1, 'G', 21, 0.00, 1000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, 0.00, NULL, 1000.00, NULL, NULL, NULL, NULL, 527);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 35, 2, 'G', 22, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 528);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 36, 3, 'I', 30, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 529);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 38, 2, 'G', 23, NULL, 1000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, 1000.00, NULL, NULL, NULL, NULL, 530);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 39, 2, 'G', 24, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 531);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 40, 3, 'I', 31, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 532);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 41, 3, 'I', 45, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 533);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 14, 2, 'T', -1, NULL, 1000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 1000.00, NULL, NULL, NULL, NULL, 534);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 17, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 535);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 536);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 20, 1, 'T', -1, NULL, 1000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, 1000.00, NULL, NULL, NULL, NULL, 537);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 30, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 538);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 32, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 20, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 539);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 33, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 540);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 37, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 541);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 42, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 542);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 43, 2, 'T', -1, NULL, 1000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, 1000.00, NULL, NULL, NULL, NULL, 543);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 44, 1, 'T', -1, NULL, 1000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, 1000.00, NULL, NULL, NULL, NULL, 544);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 31, 'jsmith', 45, 0, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 545);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 1, 0, 'G', 44, 0.00, 1000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 1000.00, NULL, NULL, NULL, NULL, 546);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 2, 1, 'G', 45, 0.00, 1000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 1000.00, NULL, NULL, NULL, NULL, 547);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 3, 2, 'I', 65, NULL, 2000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 2000.00, NULL, NULL, NULL, NULL, 548);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 4, 2, 'I', 66, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 549);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 5, 2, 'I', 67, NULL, -1000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, -1000.00, NULL, NULL, NULL, NULL, 550);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 6, 2, 'I', 68, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 551);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 7, 2, 'I', 69, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 552);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 8, 2, 'I', 70, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 553);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 9, 2, 'I', 71, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 554);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 10, 2, 'I', 72, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 555);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 11, 2, 'I', 73, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 556);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 12, 2, 'I', 74, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 557);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 13, 2, 'I', 75, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 558);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 15, 1, 'G', 46, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 559);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 16, 2, 'I', 76, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 46, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 560);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 18, 1, 'G', 47, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 561);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 21, 0, 'G', 36, 0.00, 1000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 1000.00, NULL, NULL, NULL, NULL, 562);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 22, 1, 'G', 37, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 36, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 563);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 23, 2, 'G', 38, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 37, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 564);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 24, 3, 'I', 47, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 565);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 25, 3, 'I', 46, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 566);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 26, 3, 'I', 48, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 567);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 27, 3, 'I', 49, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 568);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 28, 3, 'I', 50, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 569);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 29, 3, 'I', 51, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 570);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 31, 2, 'G', 39, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 37, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 571);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 34, 1, 'G', 40, 0.00, 1000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 36, 0.00, NULL, 1000.00, NULL, NULL, NULL, NULL, 572);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 35, 2, 'G', 41, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 40, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 573);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 36, 3, 'I', 52, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 41, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 574);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 38, 2, 'G', 42, NULL, 1000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 40, NULL, NULL, 1000.00, NULL, NULL, NULL, NULL, 575);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 39, 2, 'G', 43, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 40, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 576);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 40, 3, 'I', 63, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 577);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 41, 3, 'I', 64, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 578);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 14, 2, 'T', -1, NULL, 1000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 1000.00, NULL, NULL, NULL, NULL, 579);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 17, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 46, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 580);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 47, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 581);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 20, 1, 'T', -1, NULL, 1000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 44, NULL, NULL, 1000.00, NULL, NULL, NULL, NULL, 582);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 30, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 583);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 32, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 39, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 584);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 33, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 37, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 585);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 37, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 41, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 586);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 42, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 587);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 43, 2, 'T', -1, NULL, 1000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 40, NULL, NULL, 1000.00, NULL, NULL, NULL, NULL, 588);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 44, 1, 'T', -1, NULL, 1000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 36, NULL, NULL, 1000.00, NULL, NULL, NULL, NULL, 589);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 31, 'jsmith', 45, 0, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 590);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 1, 0, 'G', 3, 0.00, 1000.00, 0.00, 0.00, 0.00, NULL, 0.50000000000000000000, NULL, NULL, 0.00000000000000000000, -1, 1000.00, 0.50000000000000000000, 1000.00, 0.50000000000000000000, NULL, NULL, NULL, 591);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 2, 1, 'G', 4, 0.00, 2000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, 2000.00, 1.00000000000000000000, 2000.00, 1.00000000000000000000, NULL, NULL, NULL, 592);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 3, 2, 'I', 2, 0.00, 2000.00, NULL, NULL, 0.00, NULL, 1.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, 2000.00, 1.00000000000000000000, 2000.00, 1.00000000000000000000, NULL, NULL, NULL, 593);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 4, 2, 'I', 3, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 4, 0.00, 0.00000000000000000000, 0.00, 0.00000000000000000000, NULL, NULL, NULL, 594);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 6, 1, 'G', 5, 0.00, -1000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, -1000.00, NULL, -1000.00, NULL, NULL, NULL, NULL, 595);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 7, 2, 'I', 4, NULL, 1000.00, NULL, NULL, 0.00, NULL, 0.50000000000000000000, NULL, NULL, 0.00000000000000000000, 5, 1000.00, 0.50000000000000000000, 1000.00, 0.50000000000000000000, NULL, NULL, NULL, 596);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 8, 1, 'G', 6, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 3, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 597);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 10, 0, 'G', 7, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 598);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 11, 1, 'G', 8, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 7, 0.00, 0.00000000000000000000, 0.00, 0.00000000000000000000, NULL, NULL, NULL, 599);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 12, 2, 'I', 5, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, 0.00, 0.00000000000000000000, 0.00, 0.00000000000000000000, NULL, NULL, NULL, 600);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 13, 2, 'I', 6, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, 0.00, 0.00000000000000000000, 0.00, 0.00000000000000000000, NULL, NULL, NULL, 601);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 14, 2, 'I', 7, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, 0.00, 0.00000000000000000000, 0.00, 0.00000000000000000000, NULL, NULL, NULL, 602);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 15, 2, 'I', 8, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, 0.00, 0.00000000000000000000, 0.00, 0.00000000000000000000, NULL, NULL, NULL, 603);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 16, 2, 'I', 9, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, 0.00, 0.00000000000000000000, 0.00, 0.00000000000000000000, NULL, NULL, NULL, 604);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 17, 2, 'I', 10, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, 0.00, 0.00000000000000000000, 0.00, 0.00000000000000000000, NULL, NULL, NULL, 605);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 18, 2, 'I', 11, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, 0.00, 0.00000000000000000000, 0.00, 0.00000000000000000000, NULL, NULL, NULL, 606);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 20, 0, 'G', 9, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 607);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 5, 2, 'T', -1, NULL, 2000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4, 2000.00, 1.00000000000000000000, 2000.00, 1.00000000000000000000, NULL, NULL, NULL, 608);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 9, 1, 'T', -1, NULL, 1000.00, NULL, NULL, 0.00, NULL, 0.50000000000000000000, NULL, NULL, 0.00000000000000000000, 3, 1000.00, 0.50000000000000000000, 1000.00, 0.50000000000000000000, NULL, NULL, NULL, 609);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, 0.00, NULL, 0.00000000000000000000, NULL, NULL, 0.00000000000000000000, 8, 0.00, 0.00000000000000000000, 0.00, 0.00000000000000000000, NULL, NULL, NULL, 610);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (4, 31, 'jsmith', 21, 0, 'T', -1, 0.00, 1000.00, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, 1000.00, NULL, 1000.00, NULL, NULL, NULL, NULL, 611);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 1, 0, 'G', 12, 0.00, 15000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 15000.00, NULL, NULL, NULL, NULL, 612);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 2, 1, 'G', 13, 0.00, 15000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 15000.00, NULL, NULL, NULL, NULL, 613);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 3, 2, 'I', 12, NULL, 8000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 8000.00, NULL, NULL, NULL, NULL, 614);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 4, 2, 'I', 13, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 615);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 5, 2, 'I', 14, NULL, 7000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 7000.00, NULL, NULL, NULL, NULL, 616);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 6, 2, 'I', 15, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 617);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 7, 2, 'I', 16, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 618);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 8, 2, 'I', 17, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 619);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 9, 2, 'I', 18, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 620);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 10, 2, 'I', 19, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 621);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 11, 2, 'I', 20, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 622);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 12, 2, 'I', 21, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 623);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 13, 2, 'I', 22, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 624);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 15, 1, 'G', 14, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 625);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 16, 2, 'I', 23, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 626);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 18, 1, 'G', 15, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 627);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 21, 0, 'G', 16, 0.00, 15000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 15000.00, NULL, NULL, NULL, NULL, 628);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 22, 1, 'G', 17, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 629);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 23, 2, 'G', 18, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 630);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 24, 3, 'I', 24, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 631);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 25, 3, 'I', 25, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 632);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 26, 3, 'I', 26, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 633);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 27, 3, 'I', 27, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 634);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 28, 3, 'I', 28, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 635);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 29, 3, 'I', 29, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 636);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 31, 2, 'G', 20, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 637);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 34, 1, 'G', 21, 0.00, 15000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, 0.00, NULL, 15000.00, NULL, NULL, NULL, NULL, 638);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 35, 2, 'G', 22, 0.00, 10000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, 0.00, NULL, 10000.00, NULL, NULL, NULL, NULL, 639);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 36, 3, 'I', 30, NULL, 10000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, 10000.00, NULL, NULL, NULL, NULL, 640);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 38, 2, 'G', 23, NULL, 5000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, 5000.00, NULL, NULL, NULL, NULL, 641);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 39, 2, 'G', 24, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 642);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 40, 3, 'I', 31, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 643);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 41, 3, 'I', 45, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 644);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 14, 2, 'T', -1, NULL, 15000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 15000.00, NULL, NULL, NULL, NULL, 645);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 17, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 646);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 647);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 20, 1, 'T', -1, NULL, 15000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, 15000.00, NULL, NULL, NULL, NULL, 648);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 30, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 649);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 32, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 20, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 650);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 33, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 651);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 37, 3, 'T', -1, NULL, 10000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, 10000.00, NULL, NULL, NULL, NULL, 652);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 42, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 653);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 43, 2, 'T', -1, NULL, 15000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, 15000.00, NULL, NULL, NULL, NULL, 654);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 44, 1, 'T', -1, NULL, 15000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, 15000.00, NULL, NULL, NULL, NULL, 655);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 47, 'jsmith', 45, 0, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 656);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 4, 2, 'I', 13, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 657);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 1, 0, 'G', 12, 0.00, 18000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 18000.00, NULL, NULL, NULL, NULL, 658);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 2, 1, 'G', 13, 0.00, 18000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 18000.00, NULL, NULL, NULL, NULL, 659);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 3, 2, 'I', 12, NULL, 14000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 14000.00, NULL, NULL, NULL, NULL, 660);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 5, 2, 'I', 14, NULL, 4000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 4000.00, NULL, NULL, NULL, NULL, 661);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 6, 2, 'I', 15, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 662);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 7, 2, 'I', 16, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 663);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 8, 2, 'I', 17, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 664);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 9, 2, 'I', 18, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 665);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 10, 2, 'I', 19, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 666);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 11, 2, 'I', 20, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 667);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 12, 2, 'I', 21, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 668);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 13, 2, 'I', 22, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 669);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 15, 1, 'G', 14, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 670);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 16, 2, 'I', 23, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 671);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 18, 1, 'G', 15, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 672);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 21, 0, 'G', 16, 0.00, 18000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 18000.00, NULL, NULL, NULL, NULL, 673);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 22, 1, 'G', 17, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 674);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 23, 2, 'G', 18, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 675);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 24, 3, 'I', 24, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 676);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 25, 3, 'I', 25, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 677);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 26, 3, 'I', 26, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 678);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 27, 3, 'I', 27, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 679);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 28, 3, 'I', 28, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 680);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 29, 3, 'I', 29, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 681);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 31, 2, 'G', 20, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 682);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 34, 1, 'G', 21, 0.00, 18000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, 0.00, NULL, 18000.00, NULL, NULL, NULL, NULL, 683);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 35, 2, 'G', 22, 0.00, 10000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, 0.00, NULL, 10000.00, NULL, NULL, NULL, NULL, 684);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 36, 3, 'I', 30, NULL, 10000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, 10000.00, NULL, NULL, NULL, NULL, 685);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 38, 2, 'G', 23, NULL, 3000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, 3000.00, NULL, NULL, NULL, NULL, 686);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 39, 2, 'G', 24, 0.00, 5000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, 0.00, NULL, 5000.00, NULL, NULL, NULL, NULL, 687);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 40, 3, 'I', 31, NULL, 5000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 5000.00, NULL, NULL, NULL, NULL, 688);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 41, 3, 'I', 45, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 689);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 14, 2, 'T', -1, NULL, 18000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 18000.00, NULL, NULL, NULL, NULL, 690);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 17, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 691);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 692);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 20, 1, 'T', -1, NULL, 18000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, 18000.00, NULL, NULL, NULL, NULL, 693);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 30, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 694);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 32, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 20, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 695);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 33, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 696);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 37, 3, 'T', -1, NULL, 10000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, 10000.00, NULL, NULL, NULL, NULL, 697);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 42, 3, 'T', -1, NULL, 5000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 5000.00, NULL, NULL, NULL, NULL, 698);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 43, 2, 'T', -1, NULL, 18000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, 18000.00, NULL, NULL, NULL, NULL, 699);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 44, 1, 'T', -1, NULL, 18000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, 18000.00, NULL, NULL, NULL, NULL, 700);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 48, 'jsmith', 45, 0, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 701);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 1, 0, 'G', 12, 0.00, 39000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 39000.00, NULL, NULL, NULL, NULL, 702);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 2, 1, 'G', 13, 0.00, 39000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 39000.00, NULL, NULL, NULL, NULL, 703);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 3, 2, 'I', 12, NULL, 36000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 36000.00, NULL, NULL, NULL, NULL, 704);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 4, 2, 'I', 13, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 705);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 5, 2, 'I', 14, NULL, 3000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 3000.00, NULL, NULL, NULL, NULL, 706);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 6, 2, 'I', 15, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 707);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 7, 2, 'I', 16, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 708);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 8, 2, 'I', 17, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 709);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 9, 2, 'I', 18, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 710);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 10, 2, 'I', 19, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 711);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 11, 2, 'I', 20, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 712);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 12, 2, 'I', 21, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 713);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 13, 2, 'I', 22, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 714);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 15, 1, 'G', 14, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 715);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 16, 2, 'I', 23, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 716);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 18, 1, 'G', 15, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 717);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 21, 0, 'G', 16, 0.00, 39000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 36000.00, NULL, NULL, NULL, NULL, 718);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 22, 1, 'G', 17, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 719);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 23, 2, 'G', 18, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 720);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 24, 3, 'I', 24, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 721);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 25, 3, 'I', 25, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 722);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 26, 3, 'I', 26, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 723);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 27, 3, 'I', 27, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 724);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 28, 3, 'I', 28, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 725);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 29, 3, 'I', 29, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 726);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 31, 2, 'G', 20, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 727);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 34, 1, 'G', 21, 0.00, 39000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, 0.00, NULL, 36000.00, NULL, NULL, NULL, NULL, 728);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 35, 2, 'G', 22, 0.00, 20000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, 0.00, NULL, 20000.00, NULL, NULL, NULL, NULL, 729);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 36, 3, 'I', 30, NULL, 20000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, 20000.00, NULL, NULL, NULL, NULL, 730);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 38, 2, 'G', 23, NULL, 14000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, 11000.00, NULL, NULL, NULL, NULL, 731);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 39, 2, 'G', 24, 0.00, 5000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, 0.00, NULL, 5000.00, NULL, NULL, NULL, NULL, 732);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 40, 3, 'I', 31, NULL, 5000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 5000.00, NULL, NULL, NULL, NULL, 733);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 41, 3, 'I', 45, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 734);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 14, 2, 'T', -1, NULL, 39000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 39000.00, NULL, NULL, NULL, NULL, 735);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 17, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 736);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 737);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 20, 1, 'T', -1, NULL, 39000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, 39000.00, NULL, NULL, NULL, NULL, 738);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 30, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 739);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 32, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 20, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 740);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 33, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 741);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 37, 3, 'T', -1, NULL, 20000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, 20000.00, NULL, NULL, NULL, NULL, 742);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 42, 3, 'T', -1, NULL, 5000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 5000.00, NULL, NULL, NULL, NULL, 743);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 43, 2, 'T', -1, NULL, 39000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, 36000.00, NULL, NULL, NULL, NULL, 744);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 44, 1, 'T', -1, NULL, 39000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, 36000.00, NULL, NULL, NULL, NULL, 745);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 46, 'jsmith', 45, 0, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0.00, NULL, 3000.00, NULL, NULL, NULL, NULL, 746);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 10, 2, 'I', 19, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 747);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 1, 0, 'G', 12, 0.00, 39000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 39000.00, NULL, NULL, NULL, NULL, 748);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 2, 1, 'G', 13, 0.00, 39000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 39000.00, NULL, NULL, NULL, NULL, 749);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 3, 2, 'I', 12, NULL, 36000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 36000.00, NULL, NULL, NULL, NULL, 750);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 4, 2, 'I', 13, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 751);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 5, 2, 'I', 14, NULL, 3000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 3000.00, NULL, NULL, NULL, NULL, 752);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 6, 2, 'I', 15, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 753);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 7, 2, 'I', 16, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 754);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 8, 2, 'I', 17, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 755);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 9, 2, 'I', 18, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 756);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 11, 2, 'I', 20, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 757);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 12, 2, 'I', 21, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 758);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 13, 2, 'I', 22, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 759);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 15, 1, 'G', 14, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 760);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 16, 2, 'I', 23, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 761);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 18, 1, 'G', 15, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 762);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 21, 0, 'G', 16, 0.00, 39000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 25000.00, NULL, NULL, NULL, NULL, 763);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 22, 1, 'G', 17, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 764);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 23, 2, 'G', 18, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 765);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 24, 3, 'I', 24, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 766);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 25, 3, 'I', 25, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 767);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 26, 3, 'I', 26, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 768);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 27, 3, 'I', 27, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 769);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 28, 3, 'I', 28, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 770);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 29, 3, 'I', 29, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 771);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 31, 2, 'G', 20, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 772);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 34, 1, 'G', 21, 0.00, 39000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, 0.00, NULL, 25000.00, NULL, NULL, NULL, NULL, 773);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 35, 2, 'G', 22, 0.00, 20000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, 0.00, NULL, 20000.00, NULL, NULL, NULL, NULL, 774);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 36, 3, 'I', 30, NULL, 20000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, 20000.00, NULL, NULL, NULL, NULL, 775);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 38, 2, 'G', 23, NULL, 14000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 776);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 39, 2, 'G', 24, 0.00, 5000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, 0.00, NULL, 5000.00, NULL, NULL, NULL, NULL, 777);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 40, 3, 'I', 31, NULL, 5000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 5000.00, NULL, NULL, NULL, NULL, 778);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 41, 3, 'I', 45, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 779);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 14, 2, 'T', -1, NULL, 39000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 39000.00, NULL, NULL, NULL, NULL, 780);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 17, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 781);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 782);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 20, 1, 'T', -1, NULL, 39000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, 39000.00, NULL, NULL, NULL, NULL, 783);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 30, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 784);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 32, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 20, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 785);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 33, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 786);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 37, 3, 'T', -1, NULL, 20000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, 20000.00, NULL, NULL, NULL, NULL, 787);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 42, 3, 'T', -1, NULL, 5000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 5000.00, NULL, NULL, NULL, NULL, 788);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 43, 2, 'T', -1, NULL, 39000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, 25000.00, NULL, NULL, NULL, NULL, 789);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 44, 1, 'T', -1, NULL, 39000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, 25000.00, NULL, NULL, NULL, NULL, 790);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 29, 'jsmith', 45, 0, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0.00, NULL, 14000.00, NULL, NULL, NULL, NULL, 791);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 1, 0, 'G', 12, 0.00, 1043286.24, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 1043286.24, NULL, NULL, NULL, NULL, 792);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 2, 1, 'G', 13, 0.00, 1043286.24, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 1043286.24, NULL, NULL, NULL, NULL, 793);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 3, 2, 'I', 12, NULL, 1027222.11, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 1027222.11, NULL, NULL, NULL, NULL, 794);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 4, 2, 'I', 13, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 795);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 5, 2, 'I', 14, NULL, 22195.81, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 22195.81, NULL, NULL, NULL, NULL, 796);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 6, 2, 'I', 15, NULL, -1.06, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, -1.06, NULL, NULL, NULL, NULL, 797);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 7, 2, 'I', 16, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 798);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 8, 2, 'I', 17, NULL, -76.85, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, -76.85, NULL, NULL, NULL, NULL, 799);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 9, 2, 'I', 18, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 800);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 10, 2, 'I', 19, NULL, -6053.79, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, -6053.79, NULL, NULL, NULL, NULL, 801);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 11, 2, 'I', 20, NULL, 0.02, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.02, NULL, NULL, NULL, NULL, 802);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 12, 2, 'I', 21, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 803);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 13, 2, 'I', 22, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 804);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 15, 1, 'G', 14, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 805);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 16, 2, 'I', 23, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 806);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 18, 1, 'G', 15, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 807);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 21, 0, 'G', 16, 0.00, 1043286.24, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 1029286.24, NULL, NULL, NULL, NULL, 808);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 13, 2, 'I', 75, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 895);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 22, 1, 'G', 17, 0.00, 829.11, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, 0.00, NULL, 829.11, NULL, NULL, NULL, NULL, 809);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 23, 2, 'G', 18, 0.00, 829.11, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, 0.00, NULL, 829.11, NULL, NULL, NULL, NULL, 810);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 24, 3, 'I', 24, NULL, 250.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 250.00, NULL, NULL, NULL, NULL, 811);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 25, 3, 'I', 25, NULL, 151.99, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 151.99, NULL, NULL, NULL, NULL, 812);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 26, 3, 'I', 26, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 813);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 27, 3, 'I', 27, NULL, 216.74, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 216.74, NULL, NULL, NULL, NULL, 814);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 28, 3, 'I', 28, NULL, 238.77, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 238.77, NULL, NULL, NULL, NULL, 815);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 29, 3, 'I', 29, NULL, -28.39, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, -28.39, NULL, NULL, NULL, NULL, 816);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 31, 2, 'G', 20, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 817);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 34, 1, 'G', 21, 0.00, 1042457.13, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, 0.00, NULL, 1028457.13, NULL, NULL, NULL, NULL, 818);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 35, 2, 'G', 22, 0.00, 1020000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, 0.00, NULL, 1020000.00, NULL, NULL, NULL, NULL, 819);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 36, 3, 'I', 30, NULL, 1020000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, 1020000.00, NULL, NULL, NULL, NULL, 820);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 38, 2, 'G', 23, NULL, 17457.13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, 3457.13, NULL, NULL, NULL, NULL, 821);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 39, 2, 'G', 24, 0.00, 5000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, 0.00, NULL, 5000.00, NULL, NULL, NULL, NULL, 822);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 40, 3, 'I', 31, NULL, 5000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 5000.00, NULL, NULL, NULL, NULL, 823);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 41, 3, 'I', 45, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 824);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 14, 2, 'T', -1, NULL, 1043286.24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 1043286.24, NULL, NULL, NULL, NULL, 825);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 17, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 826);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 827);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 20, 1, 'T', -1, NULL, 1043286.24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, 1043286.24, NULL, NULL, NULL, NULL, 828);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 30, 3, 'T', -1, NULL, 829.11, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 829.11, NULL, NULL, NULL, NULL, 829);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 32, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 20, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 830);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 33, 2, 'T', -1, NULL, 829.11, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, 829.11, NULL, NULL, NULL, NULL, 831);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 37, 3, 'T', -1, NULL, 1020000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, 1020000.00, NULL, NULL, NULL, NULL, 832);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 42, 3, 'T', -1, NULL, 5000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 5000.00, NULL, NULL, NULL, NULL, 833);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 43, 2, 'T', -1, NULL, 1042457.13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, 1028457.13, NULL, NULL, NULL, NULL, 834);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 44, 1, 'T', -1, NULL, 1043286.24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, 1029286.24, NULL, NULL, NULL, NULL, 835);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 28, 'jsmith', 45, 0, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0.00, NULL, 14000.00, NULL, NULL, NULL, NULL, 836);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 4, 2, 'I', 13, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 837);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 1, 0, 'G', 12, 0.00, 1046057.66, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 1046057.66, NULL, NULL, NULL, NULL, 838);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 2, 1, 'G', 13, 0.00, 1046057.66, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 1046057.66, NULL, NULL, NULL, NULL, 839);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 3, 2, 'I', 12, NULL, 1030080.94, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 1030080.94, NULL, NULL, NULL, NULL, 840);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 5, 2, 'I', 14, NULL, 70516.91, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 70516.91, NULL, NULL, NULL, NULL, 841);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 6, 2, 'I', 15, NULL, -1.03, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, -1.03, NULL, NULL, NULL, NULL, 842);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 7, 2, 'I', 16, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 843);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 8, 2, 'I', 17, NULL, -48695.01, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, -48695.01, NULL, NULL, NULL, NULL, 844);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 9, 2, 'I', 18, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 845);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 10, 2, 'I', 19, NULL, -5868.79, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, -5868.79, NULL, NULL, NULL, NULL, 846);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 11, 2, 'I', 20, NULL, 24.64, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 24.64, NULL, NULL, NULL, NULL, 847);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 12, 2, 'I', 21, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 848);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 13, 2, 'I', 22, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 849);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 15, 1, 'G', 14, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 850);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 16, 2, 'I', 23, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 851);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 18, 1, 'G', 15, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 12, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 852);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 21, 0, 'G', 16, 0.00, 1046057.66, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 1046057.66, NULL, NULL, NULL, NULL, 853);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 22, 1, 'G', 17, 0.00, 726.06, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, 0.00, NULL, 726.06, NULL, NULL, NULL, NULL, 854);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 23, 2, 'G', 18, 0.00, 726.06, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, 0.00, NULL, 726.06, NULL, NULL, NULL, NULL, 855);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 24, 3, 'I', 24, NULL, -0.40, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, -0.40, NULL, NULL, NULL, NULL, 856);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 25, 3, 'I', 25, NULL, 215.73, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 215.73, NULL, NULL, NULL, NULL, 857);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 26, 3, 'I', 26, NULL, -125.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, -125.00, NULL, NULL, NULL, NULL, 858);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 27, 3, 'I', 27, NULL, 335.48, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 335.48, NULL, NULL, NULL, NULL, 859);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 28, 3, 'I', 28, NULL, 351.14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 351.14, NULL, NULL, NULL, NULL, 860);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 29, 3, 'I', 29, NULL, -50.89, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, -50.89, NULL, NULL, NULL, NULL, 861);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 31, 2, 'G', 20, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 17, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 862);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 34, 1, 'G', 21, 0.00, 1045331.60, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 16, 0.00, NULL, 1045331.60, NULL, NULL, NULL, NULL, 863);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 35, 2, 'G', 22, 0.00, 1020000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, 0.00, NULL, 1020000.00, NULL, NULL, NULL, NULL, 864);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 36, 3, 'I', 30, NULL, 1020000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, 1020000.00, NULL, NULL, NULL, NULL, 865);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 38, 2, 'G', 23, NULL, 2874.47, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, 2874.47, NULL, NULL, NULL, NULL, 866);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 38, 'mfgadmin', 34, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 39, NULL, NULL, 0.00, NULL, 'Total Long Term Liabilities', NULL, NULL, 867);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 39, 2, 'G', 24, 0.00, 22457.13, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 21, 0.00, NULL, 22457.13, NULL, NULL, NULL, NULL, 868);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 40, 3, 'I', 31, NULL, 22457.13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 22457.13, NULL, NULL, NULL, NULL, 869);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 41, 3, 'I', 45, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 870);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 14, 2, 'T', -1, NULL, 1046057.66, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13, NULL, NULL, 1046057.66, NULL, NULL, NULL, NULL, 871);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 17, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 14, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 872);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 15, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 873);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 20, 1, 'T', -1, NULL, 1046057.66, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 12, NULL, NULL, 1046057.66, NULL, NULL, NULL, NULL, 874);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 30, 3, 'T', -1, NULL, 726.06, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 18, NULL, NULL, 726.06, NULL, NULL, NULL, NULL, 875);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 32, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 20, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 876);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 33, 2, 'T', -1, NULL, 726.06, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 17, NULL, NULL, 726.06, NULL, NULL, NULL, NULL, 877);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 37, 3, 'T', -1, NULL, 1020000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 22, NULL, NULL, 1020000.00, NULL, NULL, NULL, NULL, 878);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 42, 3, 'T', -1, NULL, 22457.13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 24, NULL, NULL, 22457.13, NULL, NULL, NULL, NULL, 879);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 43, 2, 'T', -1, NULL, 1045331.60, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 21, NULL, NULL, 1045331.60, NULL, NULL, NULL, NULL, 880);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 44, 1, 'T', -1, NULL, 1046057.66, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 16, NULL, NULL, 1046057.66, NULL, NULL, NULL, NULL, 881);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (7, 30, 'jsmith', 45, 0, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 882);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 1, 0, 'G', 44, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 883);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 2, 1, 'G', 45, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 884);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 3, 2, 'I', 65, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 885);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 4, 2, 'I', 66, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 886);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 5, 2, 'I', 67, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 887);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 6, 2, 'I', 68, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 888);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 7, 2, 'I', 69, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 889);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 8, 2, 'I', 70, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 890);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 9, 2, 'I', 71, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 891);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 10, 2, 'I', 72, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 892);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 11, 2, 'I', 73, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 893);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 12, 2, 'I', 74, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 894);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 15, 1, 'G', 46, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 896);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 16, 2, 'I', 76, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 46, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 897);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 18, 1, 'G', 47, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 898);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 21, 0, 'G', 36, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 899);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 22, 1, 'G', 37, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 36, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 900);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 23, 2, 'G', 38, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 37, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 901);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 24, 3, 'I', 47, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 902);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 25, 3, 'I', 46, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 903);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 26, 3, 'I', 48, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 904);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 27, 3, 'I', 49, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 905);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 28, 3, 'I', 50, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 906);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 29, 3, 'I', 51, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 907);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 31, 2, 'G', 39, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 37, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 908);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 32, 3, 'I', 140, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 39, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 909);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 35, 1, 'G', 40, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 36, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 910);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 36, 2, 'G', 41, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 40, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 911);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 37, 3, 'I', 52, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 41, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 912);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 39, 2, 'G', 42, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 40, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 913);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 40, 2, 'G', 43, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 40, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 914);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 41, 3, 'I', 63, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 915);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 42, 3, 'I', 64, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 916);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 20, 1, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 44, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 917);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 14, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 918);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 17, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 46, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 919);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 47, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 920);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 45, 1, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 36, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 921);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 34, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 37, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 922);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 30, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 923);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 33, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 39, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 924);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 44, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 40, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 925);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 38, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 41, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 926);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 43, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 927);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 39, 'jsmith', 46, 0, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 928);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 1, 0, 'G', 44, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 929);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 2, 1, 'G', 45, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 930);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 3, 2, 'I', 65, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 931);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 4, 2, 'I', 66, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 932);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 5, 2, 'I', 67, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 933);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 6, 2, 'I', 68, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 934);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 7, 2, 'I', 69, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 935);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 8, 2, 'I', 70, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 936);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 9, 2, 'I', 71, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 937);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 10, 2, 'I', 72, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 938);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 11, 2, 'I', 73, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 939);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 12, 2, 'I', 74, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 940);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 13, 2, 'I', 75, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 941);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 15, 1, 'G', 46, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 942);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 16, 2, 'I', 76, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 46, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 943);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 18, 1, 'G', 47, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 944);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 21, 0, 'G', 36, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 945);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 22, 1, 'G', 37, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 36, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 946);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 23, 2, 'G', 38, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 37, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 947);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 24, 3, 'I', 47, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 948);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 25, 3, 'I', 46, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 949);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 26, 3, 'I', 48, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 950);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 27, 3, 'I', 49, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 951);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 28, 3, 'I', 50, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 952);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 29, 3, 'I', 51, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 953);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 31, 2, 'G', 39, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 37, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 954);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 32, 3, 'I', 140, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 39, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 955);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 35, 1, 'G', 40, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 36, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 956);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 36, 2, 'G', 41, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 40, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 957);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 37, 3, 'I', 52, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 41, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 958);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 39, 2, 'G', 42, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 40, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 959);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 40, 2, 'G', 43, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 40, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 960);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 41, 3, 'I', 63, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 961);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 42, 3, 'I', 64, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 962);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 14, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 963);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 17, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 46, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 964);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 47, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 965);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 20, 1, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 44, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 966);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 30, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 967);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 33, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 39, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 968);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 34, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 37, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 969);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 38, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 41, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 970);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 43, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 971);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 44, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 40, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 972);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 45, 1, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 36, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 973);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 34, 'jsmith', 46, 0, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 974);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 1, 0, 'G', 44, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 975);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 2, 1, 'G', 45, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 976);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 3, 2, 'I', 65, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 977);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 4, 2, 'I', 66, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 978);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 5, 2, 'I', 67, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 979);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 6, 2, 'I', 68, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 980);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 7, 2, 'I', 69, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 981);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 8, 2, 'I', 70, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 982);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 9, 2, 'I', 71, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 983);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 10, 2, 'I', 72, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 984);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 11, 2, 'I', 73, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 985);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 12, 2, 'I', 74, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 986);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 13, 2, 'I', 75, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 987);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 15, 1, 'G', 46, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 988);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 16, 2, 'I', 76, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 46, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 989);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 18, 1, 'G', 47, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 990);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 21, 0, 'G', 36, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 991);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 22, 1, 'G', 37, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 36, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 992);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 23, 2, 'G', 38, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 37, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 993);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 24, 3, 'I', 47, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 994);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 25, 3, 'I', 46, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 995);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 26, 3, 'I', 48, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 996);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 27, 3, 'I', 49, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 997);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 28, 3, 'I', 50, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 998);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 29, 3, 'I', 51, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 999);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 31, 2, 'G', 39, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 37, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1000);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 32, 3, 'I', 140, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 39, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1001);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 35, 1, 'G', 40, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 36, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1002);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 36, 2, 'G', 41, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 40, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1003);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 37, 3, 'I', 52, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 41, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1004);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 39, 2, 'G', 42, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 40, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1005);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 40, 2, 'G', 43, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 40, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1006);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 41, 3, 'I', 63, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1007);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 42, 3, 'I', 64, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1008);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 14, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1009);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 17, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 46, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1010);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 47, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1011);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 20, 1, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 44, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1012);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 30, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1013);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 33, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 39, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1014);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 34, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 37, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1015);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 38, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 41, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1016);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 43, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1017);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 44, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 40, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1018);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 45, 1, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 36, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1019);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 35, 'jsmith', 46, 0, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1020);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 1, 0, 'G', 44, 0.00, 15000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 15000.00, NULL, NULL, NULL, NULL, 1021);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 2, 1, 'G', 45, 0.00, 15000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 15000.00, NULL, NULL, NULL, NULL, 1022);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 3, 2, 'I', 65, NULL, 8000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 8000.00, NULL, NULL, NULL, NULL, 1023);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 4, 2, 'I', 66, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1024);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 5, 2, 'I', 67, NULL, 7000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 7000.00, NULL, NULL, NULL, NULL, 1025);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 6, 2, 'I', 68, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1026);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 7, 2, 'I', 69, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1027);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 8, 2, 'I', 70, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1028);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 9, 2, 'I', 71, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1029);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 10, 2, 'I', 72, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1030);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 11, 2, 'I', 73, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1031);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 12, 2, 'I', 74, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1032);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 13, 2, 'I', 75, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1033);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 15, 1, 'G', 46, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1034);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 16, 2, 'I', 76, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 46, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1035);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 18, 1, 'G', 47, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1036);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 21, 0, 'G', 36, 0.00, 15000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 15000.00, NULL, NULL, NULL, NULL, 1037);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 22, 1, 'G', 37, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 36, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1038);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 23, 2, 'G', 38, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 37, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1039);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 24, 3, 'I', 47, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1040);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 25, 3, 'I', 46, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1041);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 26, 3, 'I', 48, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1042);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 27, 3, 'I', 49, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1043);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 28, 3, 'I', 50, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1044);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 29, 3, 'I', 51, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1045);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 30, 3, 'I', 215, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1046);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 32, 2, 'G', 39, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 37, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1047);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 33, 3, 'I', 140, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 39, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1048);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 36, 1, 'G', 40, 0.00, 15000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 36, 0.00, NULL, 15000.00, NULL, NULL, NULL, NULL, 1049);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 37, 2, 'G', 41, 0.00, 10000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 40, 0.00, NULL, 10000.00, NULL, NULL, NULL, NULL, 1050);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 38, 3, 'I', 52, NULL, 10000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 41, NULL, NULL, 10000.00, NULL, NULL, NULL, NULL, 1051);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 40, 2, 'G', 42, NULL, 5000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 40, NULL, NULL, 5000.00, NULL, NULL, NULL, NULL, 1052);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 41, 2, 'G', 43, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 40, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1053);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 42, 3, 'I', 63, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1054);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 43, 3, 'I', 64, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1055);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 14, 2, 'T', -1, NULL, 15000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 15000.00, NULL, NULL, NULL, NULL, 1056);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 17, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 46, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1057);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 47, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1058);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 20, 1, 'T', -1, NULL, 15000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 44, NULL, NULL, 15000.00, NULL, NULL, NULL, NULL, 1059);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 31, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1060);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 34, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 39, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1061);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 35, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 37, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1062);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 39, 3, 'T', -1, NULL, 10000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 41, NULL, NULL, 10000.00, NULL, NULL, NULL, NULL, 1063);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 44, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1064);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 45, 2, 'T', -1, NULL, 15000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 40, NULL, NULL, 15000.00, NULL, NULL, NULL, NULL, 1065);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 46, 1, 'T', -1, NULL, 15000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 36, NULL, NULL, 15000.00, NULL, NULL, NULL, NULL, 1066);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 47, 'jsmith', 47, 0, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1067);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 1, 0, 'G', 44, 0.00, 18000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 18000.00, NULL, NULL, NULL, NULL, 1068);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 2, 1, 'G', 45, 0.00, 18000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 18000.00, NULL, NULL, NULL, NULL, 1069);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 3, 2, 'I', 65, NULL, 14000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 14000.00, NULL, NULL, NULL, NULL, 1070);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 4, 2, 'I', 66, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1071);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 5, 2, 'I', 67, NULL, 4000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 4000.00, NULL, NULL, NULL, NULL, 1072);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 6, 2, 'I', 68, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1073);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 7, 2, 'I', 69, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1074);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 8, 2, 'I', 70, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1075);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 9, 2, 'I', 71, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1076);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 10, 2, 'I', 72, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1077);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 11, 2, 'I', 73, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1078);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 12, 2, 'I', 74, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1079);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 13, 2, 'I', 75, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1080);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 15, 1, 'G', 46, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1081);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 16, 2, 'I', 76, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 46, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1082);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 18, 1, 'G', 47, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1083);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 21, 0, 'G', 36, 0.00, 18000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 18000.00, NULL, NULL, NULL, NULL, 1084);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 22, 1, 'G', 37, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 36, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1085);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 23, 2, 'G', 38, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 37, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1086);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 24, 3, 'I', 47, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1087);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 25, 3, 'I', 46, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1088);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 26, 3, 'I', 48, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1089);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 27, 3, 'I', 49, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1090);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 28, 3, 'I', 50, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1091);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 29, 3, 'I', 51, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1092);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 30, 3, 'I', 215, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1093);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 32, 2, 'G', 39, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 37, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1094);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 33, 3, 'I', 140, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 39, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1095);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 36, 1, 'G', 40, 0.00, 18000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 36, 0.00, NULL, 18000.00, NULL, NULL, NULL, NULL, 1096);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 37, 2, 'G', 41, 0.00, 10000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 40, 0.00, NULL, 10000.00, NULL, NULL, NULL, NULL, 1097);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 38, 3, 'I', 52, NULL, 10000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 41, NULL, NULL, 10000.00, NULL, NULL, NULL, NULL, 1098);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 40, 2, 'G', 42, NULL, 3000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 40, NULL, NULL, 3000.00, NULL, NULL, NULL, NULL, 1099);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 41, 2, 'G', 43, 0.00, 5000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 40, 0.00, NULL, 5000.00, NULL, NULL, NULL, NULL, 1100);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 42, 3, 'I', 63, NULL, 5000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 5000.00, NULL, NULL, NULL, NULL, 1101);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 43, 3, 'I', 64, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1102);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 14, 2, 'T', -1, NULL, 18000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 18000.00, NULL, NULL, NULL, NULL, 1103);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 17, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 46, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1104);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 47, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1105);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 20, 1, 'T', -1, NULL, 18000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 44, NULL, NULL, 18000.00, NULL, NULL, NULL, NULL, 1106);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 31, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1107);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 34, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 39, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1108);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 35, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 37, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1109);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 39, 3, 'T', -1, NULL, 10000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 41, NULL, NULL, 10000.00, NULL, NULL, NULL, NULL, 1110);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 44, 3, 'T', -1, NULL, 5000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 5000.00, NULL, NULL, NULL, NULL, 1111);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 45, 2, 'T', -1, NULL, 18000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 40, NULL, NULL, 18000.00, NULL, NULL, NULL, NULL, 1112);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 46, 1, 'T', -1, NULL, 18000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 36, NULL, NULL, 18000.00, NULL, NULL, NULL, NULL, 1113);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 48, 'jsmith', 47, 0, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1114);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 1, 0, 'G', 44, 0.00, 39000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 39000.00, NULL, NULL, NULL, NULL, 1115);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 2, 1, 'G', 45, 0.00, 39000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 39000.00, NULL, NULL, NULL, NULL, 1116);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 3, 2, 'I', 65, NULL, 36000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 36000.00, NULL, NULL, NULL, NULL, 1117);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 4, 2, 'I', 66, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1118);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 5, 2, 'I', 67, NULL, 3000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 3000.00, NULL, NULL, NULL, NULL, 1119);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 6, 2, 'I', 68, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1120);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 7, 2, 'I', 69, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1121);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 8, 2, 'I', 70, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1122);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 9, 2, 'I', 71, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1123);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 10, 2, 'I', 72, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1124);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 11, 2, 'I', 73, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1125);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 12, 2, 'I', 74, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1126);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 13, 2, 'I', 75, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1127);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 15, 1, 'G', 46, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1128);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 16, 2, 'I', 76, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 46, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1129);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 18, 1, 'G', 47, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1130);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 21, 0, 'G', 36, 0.00, 39000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 39000.00, NULL, NULL, NULL, NULL, 1131);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 22, 1, 'G', 37, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 36, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1132);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 23, 2, 'G', 38, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 37, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1133);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 24, 3, 'I', 47, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1134);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 25, 3, 'I', 46, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1135);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 26, 3, 'I', 48, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1136);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 27, 3, 'I', 49, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1137);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 28, 3, 'I', 50, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1138);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 29, 3, 'I', 51, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1139);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 30, 3, 'I', 215, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1140);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 32, 2, 'G', 39, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 37, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1141);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 33, 3, 'I', 140, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 39, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1142);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 36, 1, 'G', 40, 0.00, 39000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 36, 0.00, NULL, 39000.00, NULL, NULL, NULL, NULL, 1143);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 37, 2, 'G', 41, 0.00, 20000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 40, 0.00, NULL, 20000.00, NULL, NULL, NULL, NULL, 1144);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 38, 3, 'I', 52, NULL, 20000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 41, NULL, NULL, 20000.00, NULL, NULL, NULL, NULL, 1145);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 40, 2, 'G', 42, NULL, 14000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 40, NULL, NULL, 14000.00, NULL, NULL, NULL, NULL, 1146);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 41, 2, 'G', 43, 0.00, 5000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 40, 0.00, NULL, 5000.00, NULL, NULL, NULL, NULL, 1147);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 42, 3, 'I', 63, NULL, 5000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 5000.00, NULL, NULL, NULL, NULL, 1148);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 43, 3, 'I', 64, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1149);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 14, 2, 'T', -1, NULL, 39000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 39000.00, NULL, NULL, NULL, NULL, 1150);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 17, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 46, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1151);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 19, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 47, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1152);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 20, 1, 'T', -1, NULL, 39000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 44, NULL, NULL, 39000.00, NULL, NULL, NULL, NULL, 1153);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 31, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1154);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 34, 3, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 39, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1155);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 35, 2, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 37, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1156);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 39, 3, 'T', -1, NULL, 20000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 41, NULL, NULL, 20000.00, NULL, NULL, NULL, NULL, 1157);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 44, 3, 'T', -1, NULL, 5000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 43, NULL, NULL, 5000.00, NULL, NULL, NULL, NULL, 1158);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 45, 2, 'T', -1, NULL, 39000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 40, NULL, NULL, 39000.00, NULL, NULL, NULL, NULL, 1159);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 46, 1, 'T', -1, NULL, 39000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 36, NULL, NULL, 39000.00, NULL, NULL, NULL, NULL, 1160);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 46, 'jsmith', 47, 0, 'T', -1, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1161);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 1, 0, 'G', 44, 0.00, 40000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 40000.00, NULL, NULL, NULL, NULL, 1162);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 2, 1, 'G', 45, 0.00, 40000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 40000.00, NULL, NULL, NULL, NULL, 1163);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 3, 2, 'I', 65, NULL, 38000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 38000.00, NULL, NULL, NULL, NULL, 1164);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 4, 2, 'I', 66, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1165);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 5, 2, 'I', 67, NULL, 2000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 2000.00, NULL, NULL, NULL, NULL, 1166);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 6, 2, 'I', 68, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1167);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 7, 2, 'I', 69, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1168);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 8, 2, 'I', 70, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1169);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 9, 2, 'I', 71, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1170);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 10, 2, 'I', 72, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1171);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 11, 2, 'I', 73, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1172);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 12, 2, 'I', 74, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1173);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 13, 2, 'I', 75, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 45, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1174);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 15, 1, 'G', 46, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1175);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 16, 2, 'I', 76, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 46, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1176);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 18, 1, 'G', 47, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 44, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1177);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 21, 0, 'G', 36, 0.00, 40000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, -1, 0.00, NULL, 40000.00, NULL, NULL, NULL, NULL, 1178);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 22, 1, 'G', 37, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 36, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1179);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 23, 2, 'G', 38, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 37, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1180);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 24, 3, 'I', 47, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1181);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 25, 3, 'I', 46, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1182);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 26, 3, 'I', 48, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1183);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 27, 3, 'I', 49, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1184);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 28, 3, 'I', 50, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1185);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 29, 3, 'I', 51, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1186);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 30, 3, 'I', 215, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1187);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 32, 2, 'G', 39, 0.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 37, 0.00, NULL, 0.00, NULL, NULL, NULL, NULL, 1188);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 33, 3, 'I', 140, NULL, 0.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 39, NULL, NULL, 0.00, NULL, NULL, NULL, NULL, 1189);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 36, 1, 'G', 40, 0.00, 40000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 36, 0.00, NULL, 40000.00, NULL, NULL, NULL, NULL, 1190);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 37, 2, 'G', 41, 0.00, 20000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 40, 0.00, NULL, 20000.00, NULL, NULL, NULL, NULL, 1191);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 38, 3, 'I', 52, NULL, 20000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 41, NULL, NULL, 20000.00, NULL, NULL, NULL, NULL, 1192);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 40, 2, 'G', 42, NULL, 15000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 40, NULL, NULL, 15000.00, NULL, NULL, NULL, NULL, 1193);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 41, 2, 'G', 43, 0.00, 5000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, NULL, NULL, 40, 0.00, NULL, 5000.00, NULL, NULL, NULL, NULL, 1194);
INSERT INTO flrpt (flrpt_flhead_id, flrpt_period_id, flrpt_username, flrpt_order, flrpt_level, flrpt_type, flrpt_type_id, flrpt_beginning, flrpt_ending, flrpt_debits, flrpt_credits, flrpt_budget, flrpt_beginningprcnt, flrpt_endingprcnt, flrpt_debitsprcnt, flrpt_creditsprcnt, flrpt_budgetprcnt, flrpt_parent_id, flrpt_diff, flrpt_diffprcnt, flrpt_custom, flrpt_customprcnt, flrpt_altname, flrpt_accnt_id, flrpt_interval, flrpt_id) VALUES (11, 29, 'jsmith', 42, 3, 'I', 63, NULL, 5000.00, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4