// Generated by CoffeeScript 1.6.3
(function() {
  var AFMFont, fs;

  fs = require('fs');

  AFMFont = (function() {
    var characters;

    AFMFont.open = function(filename) {
      return new AFMFont(filename);
    };

    function AFMFont(filename) {
      var e, i;
      this.contents = fs.readFileSync(filename, 'utf8');
      this.attributes = {};
      this.glyphWidths = {};
      this.boundingBoxes = {};
      this.parse();
      this.charWidths = (function() {
        var _i, _results;
        _results = [];
        for (i = _i = 0; _i <= 255; i = ++_i) {
          _results.push(this.glyphWidths[characters[i]]);
        }
        return _results;
      }).call(this);
      this.bbox = (function() {
        var _i, _len, _ref, _results;
        _ref = this.attributes['FontBBox'].split(/\s+/);
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          e = _ref[_i];
          _results.push(+e);
        }
        return _results;
      }).call(this);
      this.ascender = +this.attributes['Ascender'];
      this.decender = +this.attributes['Descender'];
      this.lineGap = (this.bbox[3] - this.bbox[1]) - (this.ascender - this.decender);
    }

    AFMFont.prototype.parse = function() {
      var a, key, line, match, name, section, value, _i, _len, _ref, _results;
      section = '';
      _ref = this.contents.split('\n');
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        line = _ref[_i];
        if (match = line.match(/^Start(\w+)/)) {
          section = match[1];
          continue;
        } else if (match = line.match(/^End(\w+)/)) {
          section = '';
          continue;
        }
        switch (section) {
          case 'FontMetrics':
            match = line.match(/(^\w+)\s+(.*)/);
            key = match[1];
            value = match[2];
            if (a = this.attributes[key]) {
              if (!Array.isArray(a)) {
                a = this.attributes[key] = [a];
              }
              _results.push(a.push(value));
            } else {
              _results.push(this.attributes[key] = value);
            }
            break;
          case 'CharMetrics':
            if (!/^CH?\s/.test(line)) {
              continue;
            }
            name = line.match(/\bN\s+(\.?\w+)\s*;/)[1];
            _results.push(this.glyphWidths[name] = +line.match(/\bWX\s+(\d+)\s*;/)[1]);
            break;
          default:
            _results.push(void 0);
        }
      }
      return _results;
    };

    characters = '.notdef       .notdef        .notdef        .notdef\n.notdef       .notdef        .notdef        .notdef\n.notdef       .notdef        .notdef        .notdef\n.notdef       .notdef        .notdef        .notdef\n.notdef       .notdef        .notdef        .notdef\n.notdef       .notdef        .notdef        .notdef\n.notdef       .notdef        .notdef        .notdef\n.notdef       .notdef        .notdef        .notdef\n\nspace         exclam         quotedbl       numbersign\ndollar        percent        ampersand      quotesingle\nparenleft     parenright     asterisk       plus\ncomma         hyphen         period         slash\nzero          one            two            three\nfour          five           six            seven\neight         nine           colon          semicolon\nless          equal          greater        question\n\nat            A              B              C\nD             E              F              G\nH             I              J              K\nL             M              N              O\nP             Q              R              S\nT             U              V              W\nX             Y              Z              bracketleft\nbackslash     bracketright   asciicircum    underscore\n\ngrave         a              b              c\nd             e              f              g\nh             i              j              k\nl             m              n              o\np             q              r              s\nt             u              v              w\nx             y              z              braceleft\nbar           braceright     asciitilde     .notdef\n\nEuro          .notdef        quotesinglbase florin\nquotedblbase  ellipsis       dagger         daggerdbl\ncircumflex    perthousand    Scaron         guilsinglleft\nOE            .notdef        Zcaron         .notdef\n.notdef       quoteleft      quoteright     quotedblleft\nquotedblright bullet         endash         emdash\ntilde         trademark      scaron         guilsinglright\noe            .notdef        zcaron         ydieresis\n\nspace         exclamdown     cent           sterling\ncurrency      yen            brokenbar      section\ndieresis      copyright      ordfeminine    guillemotleft\nlogicalnot    hyphen         registered     macron\ndegree        plusminus      twosuperior    threesuperior\nacute         mu             paragraph      periodcentered\ncedilla       onesuperior    ordmasculine   guillemotright\nonequarter    onehalf        threequarters  questiondown\n\nAgrave        Aacute         Acircumflex    Atilde\nAdieresis     Aring          AE             Ccedilla\nEgrave        Eacute         Ecircumflex    Edieresis\nIgrave        Iacute         Icircumflex    Idieresis\nEth           Ntilde         Ograve         Oacute\nOcircumflex   Otilde         Odieresis      multiply\nOslash        Ugrave         Uacute         Ucircumflex\nUdieresis     Yacute         Thorn          germandbls\n\nagrave        aacute         acircumflex    atilde\nadieresis     aring          ae             ccedilla\negrave        eacute         ecircumflex    edieresis\nigrave        iacute         icircumflex    idieresis\neth           ntilde         ograve         oacute\nocircumflex   otilde         odieresis      divide\noslash        ugrave         uacute         ucircumflex\nudieresis     yacute         thorn          ydieresis'.split(/\s+/);

    return AFMFont;

  })();

  module.exports = AFMFont;

}).call(this);
