
// enyo.js

(function() {
var e = "enyo.js";
enyo = window.enyo || {}, enyo.locateScript = function(e) {
var t = document.getElementsByTagName("script");
for (var n = t.length - 1, r, i, s = e.length; n >= 0 && (r = t[n]); n--) if (!r.located) {
i = r.getAttribute("src") || "";
if (i.slice(-s) == e) return r.located = !0, {
path: i.slice(0, Math.max(0, i.lastIndexOf("/"))),
node: r
};
}
}, enyo.args = enyo.args || {};
var t = enyo.locateScript(e);
if (t) {
enyo.args.root = (enyo.args.root || t.path).replace("/source", "");
for (var n = 0, r = t.node.attributes.length, i; n < r && (i = t.node.attributes.item(n)); n++) enyo.args[i.nodeName] = i.value;
}
})();

// ../../loader.js

(function() {
enyo = window.enyo || {}, enyo.pathResolverFactory = function() {
this.paths = {};
}, enyo.pathResolverFactory.prototype = {
addPath: function(e, t) {
return this.paths[e] = t;
},
addPaths: function(e) {
if (e) for (var t in e) this.addPath(t, e[t]);
},
includeTrailingSlash: function(e) {
return e && e.slice(-1) !== "/" ? e + "/" : e;
},
rewritePattern: /\$([^\/\\]*)(\/)?/g,
rewrite: function(e) {
var t, n = this.includeTrailingSlash, r = this.paths, i = function(e, i) {
return t = !0, n(r[i]) || "";
}, s = e;
do t = !1, s = s.replace(this.rewritePattern, i); while (t);
return s;
}
}, enyo.path = new enyo.pathResolverFactory, enyo.loaderFactory = function(e, t) {
this.machine = e, this.packages = [], this.modules = [], this.sheets = [], this.stack = [], this.pathResolver = t || enyo.path, this.packageName = "", this.packageFolder = "", this.finishCallbacks = {};
}, enyo.loaderFactory.prototype = {
verbose: !1,
loadScript: function(e) {
this.machine.script(e);
},
loadSheet: function(e) {
this.machine.sheet(e);
},
loadPackage: function(e) {
this.machine.script(e);
},
report: function() {},
load: function() {
this.more({
index: 0,
depends: arguments || []
});
},
more: function(e) {
if (e && this.continueBlock(e)) return;
var t = this.stack.pop();
t ? (this.verbose && console.groupEnd("* finish package (" + (t.packageName || "anon") + ")"), this.packageFolder = t.folder, this.packageName = "", this.more(t)) : this.finish();
},
finish: function() {
this.packageFolder = "", this.verbose && console.log("-------------- fini");
for (var e in this.finishCallbacks) this.finishCallbacks[e] && (this.finishCallbacks[e](), this.finishCallbacks[e] = null);
},
continueBlock: function(e) {
while (e.index < e.depends.length) {
var t = e.depends[e.index++];
if (t) if (typeof t == "string") {
if (this.require(t, e)) return !0;
} else this.pathResolver.addPaths(t);
}
},
require: function(e, t) {
var n = this.pathResolver.rewrite(e), r = this.getPathPrefix(e);
n = r + n;
if (n.slice(-4) == ".css" || n.slice(-5) == ".less") this.verbose && console.log("+ stylesheet: [" + r + "][" + e + "]"), this.requireStylesheet(n); else {
if (n.slice(-3) != ".js" || n.slice(-10) == "package.js") return this.requirePackage(n, t), !0;
this.verbose && console.log("+ module: [" + r + "][" + e + "]"), this.requireScript(e, n);
}
},
getPathPrefix: function(e) {
var t = e.slice(0, 1);
return t != "/" && t != "\\" && t != "$" && !/^https?:/i.test(e) ? this.packageFolder : "";
},
requireStylesheet: function(e) {
this.sheets.push(e), this.loadSheet(e);
},
requireScript: function(e, t) {
this.modules.push({
packageName: this.packageName,
rawPath: e,
path: t
}), this.loadScript(t);
},
decodePackagePath: function(e) {
var t = "", n = "", r = "", i = "package.js", s = e.replace(/\\/g, "/").replace(/\/\//g, "/").replace(/:\//, "://").split("/"), o, u;
if (s.length) {
var a = s.pop() || s.pop() || "";
a.slice(-i.length) !== i ? s.push(a) : i = a, r = s.join("/"), r = r ? r + "/" : "", i = r + i;
for (o = s.length - 1; o >= 0; o--) if (s[o] == "source") {
s.splice(o, 1);
break;
}
n = s.join("/");
for (o = s.length - 1; u = s[o]; o--) if (u == "lib" || u == "enyo") {
s = s.slice(o + 1);
break;
}
for (o = s.length - 1; u = s[o]; o--) (u == ".." || u == ".") && s.splice(o, 1);
t = s.join("-");
}
return {
alias: t,
target: n,
folder: r,
manifest: i
};
},
aliasPackage: function(e) {
var t = this.decodePackagePath(e);
this.manifest = t.manifest, t.alias && (this.pathResolver.addPath(t.alias, t.target), this.packageName = t.alias, this.packages.push({
name: t.alias,
folder: t.folder
})), this.packageFolder = t.folder;
},
requirePackage: function(e, t) {
t.folder = this.packageFolder, this.aliasPackage(e), t.packageName = this.packageName, this.stack.push(t), this.report("loading package", this.packageName), this.verbose && console.group("* start package [" + this.packageName + "]"), this.loadPackage(this.manifest);
}
};
})();

// boot.js

enyo.execUnsafeLocalFunction = function(e) {
typeof MSApp == "undefined" ? e() : MSApp.execUnsafeLocalFunction(e);
}, enyo.machine = {
sheet: function(e) {
var t = "text/css", n = "stylesheet", r = e.slice(-5) == ".less";
r && (window.less ? (t = "text/less", n = "stylesheet/less") : e = e.slice(0, e.length - 4) + "css");
var i;
enyo.runtimeLoading || r ? (i = document.createElement("link"), i.href = e, i.media = "screen", i.rel = n, i.type = t, document.getElementsByTagName("head")[0].appendChild(i)) : (i = function() {
document.write('<link href="' + e + '" media="screen" rel="' + n + '" type="' + t + '" />');
}, enyo.execUnsafeLocalFunction(i)), r && window.less && (less.sheets.push(i), enyo.loader.finishCallbacks.lessRefresh || (enyo.loader.finishCallbacks.lessRefresh = function() {
less.refresh(!0);
}));
},
script: function(e, t, n) {
if (!enyo.runtimeLoading) document.write('<script src="' + e + '"' + (t ? ' onload="' + t + '"' : "") + (n ? ' onerror="' + n + '"' : "") + "></scri" + "pt>"); else {
var r = document.createElement("script");
r.src = e, r.onload = t, r.onerror = n, document.getElementsByTagName("head")[0].appendChild(r);
}
},
inject: function(e) {
document.write('<script type="text/javascript">' + e + "</scri" + "pt>");
}
}, enyo.loader = new enyo.loaderFactory(enyo.machine), enyo.depends = function() {
var e = enyo.loader;
if (!e.packageFolder) {
var t = enyo.locateScript("package.js");
t && t.path && (e.aliasPackage(t.path), e.packageFolder = t.path + "/");
}
e.load.apply(e, arguments);
}, function() {
function n(r) {
r && r();
if (t.length) {
var i = t.shift(), s = i[0], o = e.isArray(s) ? s : [ s ], u = i[1];
e.loader.finishCallbacks.runtimeLoader = function() {
n(function() {
u && u(s);
});
}, e.loader.packageFolder = "./", e.depends.apply(this, o);
} else e.runtimeLoading = !1, e.loader.packageFolder = "";
}
var e = window.enyo, t = [];
e.load = function(r, i) {
t.push(arguments), e.runtimeLoading || (e.runtimeLoading = !0, n());
};
}(), enyo.path.addPaths({
enyo: enyo.args.root,
lib: "$enyo/../lib"
});

// log.js

enyo.logging = {
level: 99,
levels: {
log: 20,
warn: 10,
error: 0
},
shouldLog: function(e) {
var t = parseInt(this.levels[e], 0);
return t <= this.level;
},
_log: function(e, t) {
if (typeof console == "undefined") return;
var n = enyo.isArray(t) ? t : enyo.cloneArray(t);
enyo.dumbConsole && (n = [ n.join(" ") ]);
var r = console[e];
r && r.apply ? r.apply(console, n) : console.log.apply ? console.log.apply(console, n) : console.log(n.join(" "));
},
log: function(e, t) {
typeof console != "undefined" && this.shouldLog(e) && this._log(e, t);
}
}, enyo.setLogLevel = function(e) {
var t = parseInt(e, 0);
isFinite(t) && (enyo.logging.level = t);
}, enyo.log = function() {
enyo.logging.log("log", arguments);
}, enyo.warn = function() {
enyo.logging.log("warn", arguments);
}, enyo.error = function() {
enyo.logging.log("error", arguments);
};

// lang.js

(function() {
enyo.global = this, enyo._getProp = function(e, t, n) {
var r = n || enyo.global;
for (var i = 0, s; r && (s = e[i]); i++) r = s in r ? r[s] : t ? r[s] = {} : undefined;
return r;
}, enyo.setObject = function(e, t, n) {
var r = e.split("."), i = r.pop(), s = enyo._getProp(r, !0, n);
return s && i ? s[i] = t : undefined;
}, enyo.getObject = function(e, t, n) {
return enyo._getProp(e.split("."), t, n);
}, enyo.irand = function(e) {
return Math.floor(Math.random() * e);
}, enyo.cap = function(e) {
return e.slice(0, 1).toUpperCase() + e.slice(1);
}, enyo.uncap = function(e) {
return e.slice(0, 1).toLowerCase() + e.slice(1);
}, enyo.format = function(e) {
var t = /\%./g, n = 0, r = e, i = arguments, s = function(e) {
return i[++n];
};
return r.replace(t, s);
};
var e = Object.prototype.toString;
enyo.isString = function(t) {
return e.call(t) === "[object String]";
}, enyo.isFunction = function(t) {
return e.call(t) === "[object Function]";
}, enyo.isArray = Array.isArray || function(t) {
return e.call(t) === "[object Array]";
}, enyo.isTrue = function(e) {
return e !== "false" && e !== !1 && e !== 0 && e !== null && e !== undefined;
}, enyo.indexOf = function(e, t, n) {
if (t.indexOf) return t.indexOf(e, n);
if (n) {
n < 0 && (n = 0);
if (n > t.length) return -1;
}
for (var r = n || 0, i = t.length, s; (s = t[r]) || r < i; r++) if (s == e) return r;
return -1;
}, enyo.remove = function(e, t) {
var n = enyo.indexOf(e, t);
n >= 0 && t.splice(n, 1);
}, enyo.forEach = function(e, t, n) {
if (e) {
var r = n || this;
if (enyo.isArray(e) && e.forEach) e.forEach(t, r); else {
var i = Object(e), s = i.length >>> 0;
for (var o = 0; o < s; o++) o in i && t.call(r, i[o], o, i);
}
}
}, enyo.map = function(e, t, n) {
var r = n || this;
if (enyo.isArray(e) && e.map) return e.map(t, r);
var i = [], s = function(e, n, s) {
i.push(t.call(r, e, n, s));
};
return enyo.forEach(e, s, r), i;
}, enyo.filter = function(e, t, n) {
var r = n || this;
if (enyo.isArray(e) && e.filter) return e.filter(t, r);
var i = [], s = function(e, n, s) {
var o = e;
t.call(r, e, n, s) && i.push(o);
};
return enyo.forEach(e, s, r), i;
}, enyo.keys = Object.keys || function(e) {
var t = [], n = Object.prototype.hasOwnProperty;
for (var r in e) n.call(e, r) && t.push(r);
if (!{
toString: null
}.propertyIsEnumerable("toString")) {
var i = [ "toString", "toLocaleString", "valueOf", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "constructor" ];
for (var s = 0, o; o = i[s]; s++) n.call(e, o) && t.push(o);
}
return t;
}, enyo.cloneArray = function(e, t, n) {
var r = n || [];
for (var i = t || 0, s = e.length; i < s; i++) r.push(e[i]);
return r;
}, enyo.toArray = enyo.cloneArray, enyo.clone = function(e) {
return enyo.isArray(e) ? enyo.cloneArray(e) : enyo.mixin({}, e);
};
var t = {};
enyo.mixin = function(e, n) {
e = e || {};
if (n) {
var r, i, s;
for (r in n) i = n[r], t[r] !== i && (e[r] = i);
}
return e;
}, enyo.bind = function(e, t) {
t || (t = e, e = null), e = e || enyo.global;
if (enyo.isString(t)) {
if (!e[t]) throw [ 'enyo.bind: scope["', t, '"] is null (scope="', e, '")' ].join("");
t = e[t];
}
if (enyo.isFunction(t)) {
var n = enyo.cloneArray(arguments, 2);
return t.bind ? t.bind.apply(t, [ e ].concat(n)) : function() {
var r = enyo.cloneArray(arguments);
return t.apply(e, n.concat(r));
};
}
throw [ 'enyo.bind: scope["', t, '"] is not a function (scope="', e, '")' ].join("");
}, enyo.asyncMethod = function(e, t) {
return setTimeout(enyo.bind.apply(enyo, arguments), 1);
}, enyo.call = function(e, t, n) {
var r = e || this;
if (t) {
var i = r[t] || t;
if (i && i.apply) return i.apply(r, n || []);
}
}, enyo.now = Date.now || function() {
return (new Date).getTime();
}, enyo.nop = function() {}, enyo.nob = {}, enyo.nar = [], enyo.instance = function() {}, enyo.setPrototype || (enyo.setPrototype = function(e, t) {
e.prototype = t;
}), enyo.delegate = function(e) {
return enyo.setPrototype(enyo.instance, e), new enyo.instance;
}, $L = function(e) {
return e;
};
})();

// job.js

enyo.job = function(e, t, n) {
enyo.job.stop(e), enyo.job._jobs[e] = setTimeout(function() {
enyo.job.stop(e), t();
}, n);
}, enyo.job.stop = function(e) {
enyo.job._jobs[e] && (clearTimeout(enyo.job._jobs[e]), delete enyo.job._jobs[e]);
}, enyo.job._jobs = {};

// macroize.js

enyo.macroize = function(e, t, n) {
var r, i, s = e, o = n || enyo.macroize.pattern, u = function(e, n) {
return r = enyo.getObject(n, !1, t), r === undefined || r === null ? "{$" + n + "}" : (i = !0, r);
}, a = 0;
do {
i = !1, s = s.replace(o, u);
if (++a >= 20) throw "enyo.macroize: recursion too deep";
} while (i);
return s;
}, enyo.quickMacroize = function(e, t, n) {
var r, i, s = e, o = n || enyo.macroize.pattern, u = function(e, n) {
return n in t ? r = t[n] : r = enyo.getObject(n, !1, t), r === undefined || r === null ? "{$" + n + "}" : r;
};
return s = s.replace(o, u), s;
}, enyo.macroize.pattern = /\{\$([^{}]*)\}/g;

// Oop.js

enyo.kind = function(e) {
enyo._kindCtors = {};
var t = e.name || "";
delete e.name;
var n = "kind" in e, r = e.kind;
delete e.kind;
var i = enyo.constructorForKind(r), s = i && i.prototype || null;
if (n && r === undefined || i === undefined) {
var o = r === undefined ? "undefined kind" : "unknown kind (" + r + ")";
throw "enyo.kind: Attempt to subclass an " + o + ". Check dependencies for [" + (t || "<unnamed>") + "].";
}
var u = enyo.kind.makeCtor();
return e.hasOwnProperty("constructor") && (e._constructor = e.constructor, delete e.constructor), enyo.setPrototype(u, s ? enyo.delegate(s) : {}), enyo.mixin(u.prototype, e), u.prototype.kindName = t, u.prototype.base = i, u.prototype.ctor = u, enyo.forEach(enyo.kind.features, function(t) {
t(u, e);
}), enyo.setObject(t, u), u;
}, enyo.singleton = function(e, t) {
var n = e.name;
delete e.name;
var r = enyo.kind(e);
enyo.setObject(n, new r, t);
}, enyo.kind.makeCtor = function() {
return function() {
if (!(this instanceof arguments.callee)) throw "enyo.kind: constructor called directly, not using 'new'";
var e;
this._constructor && (e = this._constructor.apply(this, arguments)), this.constructed && this.constructed.apply(this, arguments);
if (e) return e;
};
}, enyo.kind.defaultNamespace = "enyo", enyo.kind.features = [], enyo.kind.features.push(function(e, t) {
var n = e.prototype;
n.inherited || (n.inherited = enyo.kind.inherited);
if (n.base) for (var r in t) {
var i = t[r];
enyo.isFunction(i) && (i._inherited = n.base.prototype[r] || enyo.nop, i.nom = n.kindName + "." + r + "()");
}
}), enyo.kind.inherited = function(e, t) {
return e.callee._inherited.apply(this, t || e);
}, enyo.kind.features.push(function(e, t) {
enyo.mixin(e, enyo.kind.statics), t.statics && (enyo.mixin(e, t.statics), delete e.prototype.statics);
var n = e.prototype.base;
while (n) n.subclass(e, t), n = n.prototype.base;
}), enyo.kind.statics = {
subclass: function(e, t) {},
extend: function(e) {
enyo.mixin(this.prototype, e);
var t = this;
enyo.forEach(enyo.kind.features, function(n) {
n(t, e);
});
}
}, enyo._kindCtors = {}, enyo.constructorForKind = function(e) {
if (e === null || enyo.isFunction(e)) return e;
if (e) {
var t = enyo._kindCtors[e];
return t ? t : enyo._kindCtors[e] = enyo.Theme[e] || enyo[e] || enyo.getObject(e, !1, enyo) || window[e] || enyo.getObject(e);
}
return enyo.defaultCtor;
}, enyo.Theme = {}, enyo.registerTheme = function(e) {
enyo.mixin(enyo.Theme, e);
};

// Object.js

enyo.kind({
name: "enyo.Object",
kind: null,
constructor: function() {
enyo._objectCount++;
},
setPropertyValue: function(e, t, n) {
if (this[n]) {
var r = this[e];
this[e] = t, this[n](r);
} else this[e] = t;
},
_setProperty: function(e, t, n) {
this.setPropertyValue(e, t, this.getProperty(e) !== t && n);
},
destroyObject: function(e) {
this[e] && this[e].destroy && this[e].destroy(), this[e] = null;
},
getProperty: function(e) {
var t = "get" + enyo.cap(e);
return this[t] ? this[t]() : this[e];
},
setProperty: function(e, t) {
var n = "set" + enyo.cap(e);
this[n] ? this[n](t) : this._setProperty(e, t, e + "Changed");
},
log: function() {
var e = arguments.callee.caller, t = ((e ? e.nom : "") || "(instance method)") + ":";
enyo.logging.log("log", [ t ].concat(enyo.cloneArray(arguments)));
},
warn: function() {
this._log("warn", arguments);
},
error: function() {
this._log("error", arguments);
},
_log: function(e, t) {
if (enyo.logging.shouldLog(e)) try {
throw new Error;
} catch (n) {
enyo.logging._log(e, [ t.callee.caller.nom + ": " ].concat(enyo.cloneArray(t))), enyo.log(n.stack);
}
}
}), enyo._objectCount = 0, enyo.Object.subclass = function(e, t) {
this.publish(e, t);
}, enyo.Object.publish = function(e, t) {
var n = t.published;
if (n) {
var r = e.prototype;
for (var i in n) enyo.Object.addGetterSetter(i, n[i], r);
}
}, enyo.Object.addGetterSetter = function(e, t, n) {
var r = e;
n[r] = t;
var i = enyo.cap(r), s = "get" + i;
n[s] || (n[s] = function() {
return this[r];
});
var o = "set" + i, u = r + "Changed";
n[o] || (n[o] = function(e) {
this._setProperty(r, e, u);
});
};

// Component.js

enyo.kind({
name: "enyo.Component",
kind: enyo.Object,
published: {
name: "",
id: "",
owner: null
},
statics: {
_kindPrefixi: {},
_unnamedKindNumber: 0
},
defaultKind: "Component",
handlers: {},
toString: function() {
return this.kindName;
},
constructor: function() {
this._componentNameMap = {}, this.$ = {}, this.inherited(arguments);
},
constructed: function(e) {
this.importProps(e), this.create();
},
importProps: function(e) {
if (e) for (var t in e) this[t] = e[t];
this.handlers = enyo.mixin(enyo.clone(this.kindHandlers), this.handlers);
},
create: function() {
this.ownerChanged(), this.initComponents();
},
initComponents: function() {
this.createChrome(this.kindComponents), this.createClientComponents(this.components);
},
createChrome: function(e) {
this.createComponents(e, {
isChrome: !0
});
},
createClientComponents: function(e) {
this.createComponents(e, {
owner: this.getInstanceOwner()
});
},
getInstanceOwner: function() {
return !this.owner || this.owner.notInstanceOwner ? this : this.owner;
},
destroy: function() {
this.destroyComponents(), this.setOwner(null), this.destroyed = !0;
},
destroyComponents: function() {
enyo.forEach(this.getComponents(), function(e) {
e.destroyed || e.destroy();
});
},
makeId: function() {
var e = "_", t = this.owner && this.owner.getId(), n = this.name || "@@" + ++enyo.Component._unnamedKindNumber;
return (t ? t + e : "") + n;
},
ownerChanged: function(e) {
e && e.removeComponent(this), this.owner && this.owner.addComponent(this), this.id || (this.id = this.makeId());
},
nameComponent: function(e) {
var t = enyo.Component.prefixFromKindName(e.kindName), n, r = this._componentNameMap[t] || 0;
do n = t + (++r > 1 ? String(r) : ""); while (this.$[n]);
return this._componentNameMap[t] = Number(r), e.name = n;
},
addComponent: function(e) {
var t = e.getName();
t || (t = this.nameComponent(e)), this.$[t] && this.warn('Duplicate component name "' + t + '" in owner "' + this.id + '" violates ' + "unique-name-under-owner rule, replacing existing component in the hash and continuing, " + "but this is an error condition and should be fixed."), this.$[t] = e;
},
removeComponent: function(e) {
delete this.$[e.getName()];
},
getComponents: function() {
var e = [];
for (var t in this.$) e.push(this.$[t]);
return e;
},
adjustComponentProps: function(e) {
this.defaultProps && enyo.mixin(e, this.defaultProps), e.kind = e.kind || e.isa || this.defaultKind, e.owner = e.owner || this;
},
_createComponent: function(e, t) {
if (!e.kind && "kind" in e) throw "enyo.create: Attempt to create a null kind. Check dependencies for [" + e.name + "].";
var n = enyo.mixin(enyo.clone(t), e);
return this.adjustComponentProps(n), enyo.Component.create(n);
},
createComponent: function(e, t) {
return this._createComponent(e, t);
},
createComponents: function(e, t) {
if (e) {
var n = [];
for (var r = 0, i; i = e[r]; r++) n.push(this._createComponent(i, t));
return n;
}
},
getBubbleTarget: function() {
return this.owner;
},
bubble: function(e, t, n) {
var r = t || {};
return "originator" in r || (r.originator = n || this), this.dispatchBubble(e, r, n);
},
bubbleUp: function(e, t, n) {
var r = this.getBubbleTarget();
return r ? r.dispatchBubble(e, t, this) : !1;
},
dispatchEvent: function(e, t, n) {
this.decorateEvent(e, t, n);
if (this.handlers[e] && this.dispatch(this.handlers[e], t, n)) return !0;
if (this[e]) return this.bubbleDelegation(this.owner, this[e], e, t, this);
},
dispatchBubble: function(e, t, n) {
return this.dispatchEvent(e, t, n) ? !0 : this.bubbleUp(e, t, n);
},
decorateEvent: function(e, t, n) {},
bubbleDelegation: function(e, t, n, r, i) {
var s = this.getBubbleTarget();
if (s) return s.delegateEvent(e, t, n, r, i);
},
delegateEvent: function(e, t, n, r, i) {
return this.decorateEvent(n, r, i), e == this ? this.dispatch(t, r, i) : this.bubbleDelegation(e, t, n, r, i);
},
dispatch: function(e, t, n) {
var r = e && this[e];
if (r) return r.call(this, n || this, t);
},
waterfall: function(e, t, n) {
if (this.dispatchEvent(e, t, n)) return !0;
this.waterfallDown(e, t, n || this);
},
waterfallDown: function(e, t, n) {
for (var r in this.$) this.$[r].waterfall(e, t, n);
}
}), enyo.defaultCtor = enyo.Component, enyo.create = enyo.Component.create = function(e) {
if (!e.kind && "kind" in e) throw "enyo.create: Attempt to create a null kind. Check dependencies for [" + (e.name || "") + "].";
var t = e.kind || e.isa || enyo.defaultCtor, n = enyo.constructorForKind(t);
return n || (enyo.error('no constructor found for kind "' + t + '"'), n = enyo.Component), new n(e);
}, enyo.Component.subclass = function(e, t) {
var n = e.prototype;
t.components && (n.kindComponents = t.components, delete n.components);
if (t.handlers) {
var r = n.kindHandlers;
n.kindHandlers = enyo.mixin(enyo.clone(r), n.handlers), n.handlers = null;
}
t.events && this.publishEvents(e, t);
}, enyo.Component.publishEvents = function(e, t) {
var n = t.events;
if (n) {
var r = e.prototype;
for (var i in n) this.addEvent(i, n[i], r);
}
}, enyo.Component.addEvent = function(e, t, n) {
var r, i;
enyo.isString(t) ? (e.slice(0, 2) != "on" && (enyo.warn("enyo.Component.addEvent: event names must start with 'on'. " + n.kindName + " event '" + e + "' was auto-corrected to 'on" + e + "'."), e = "on" + e), r = t, i = "do" + enyo.cap(e.slice(2))) : (r = t.value, i = t.caller), n[e] = r, n[i] || (n[i] = function(t) {
return this.bubble(e, t);
});
}, enyo.Component.prefixFromKindName = function(e) {
var t = enyo.Component._kindPrefixi[e];
if (!t) {
var n = e.lastIndexOf(".");
t = n >= 0 ? e.slice(n + 1) : e, t = t.charAt(0).toLowerCase() + t.slice(1), enyo.Component._kindPrefixi[e] = t;
}
return t;
};

// UiComponent.js

enyo.kind({
name: "enyo.UiComponent",
kind: enyo.Component,
published: {
container: null,
parent: null,
controlParentName: "client",
layoutKind: ""
},
handlers: {
onresize: "resizeHandler"
},
addBefore: undefined,
statics: {
_resizeFlags: {
showingOnly: !0
}
},
create: function() {
this.controls = [], this.children = [], this.containerChanged(), this.inherited(arguments), this.layoutKindChanged();
},
destroy: function() {
this.destroyClientControls(), this.setContainer(null), this.inherited(arguments);
},
importProps: function(e) {
this.inherited(arguments), this.owner || (this.owner = enyo.master);
},
createComponents: function() {
var e = this.inherited(arguments);
return this.discoverControlParent(), e;
},
discoverControlParent: function() {
this.controlParent = this.$[this.controlParentName] || this.controlParent;
},
adjustComponentProps: function(e) {
e.container = e.container || this, this.inherited(arguments);
},
containerChanged: function(e) {
e && e.removeControl(this), this.container && this.container.addControl(this, this.addBefore);
},
parentChanged: function(e) {
e && e != this.parent && e.removeChild(this);
},
isDescendantOf: function(e) {
var t = this;
while (t && t != e) t = t.parent;
return e && t == e;
},
getControls: function() {
return this.controls;
},
getClientControls: function() {
var e = [];
for (var t = 0, n = this.controls, r; r = n[t]; t++) r.isChrome || e.push(r);
return e;
},
destroyClientControls: function() {
var e = this.getClientControls();
for (var t = 0, n; n = e[t]; t++) n.destroy();
},
addControl: function(e, t) {
this.controls.push(e), this.addChild(e, t);
},
removeControl: function(e) {
return e.setParent(null), enyo.remove(e, this.controls);
},
indexOfControl: function(e) {
return enyo.indexOf(e, this.controls);
},
indexOfClientControl: function(e) {
return enyo.indexOf(e, this.getClientControls());
},
indexInContainer: function() {
return this.container.indexOfControl(this);
},
clientIndexInContainer: function() {
return this.container.indexOfClientControl(this);
},
controlAtIndex: function(e) {
return this.controls[e];
},
addChild: function(e, t) {
if (this.controlParent) this.controlParent.addChild(e); else {
e.setParent(this);
if (t !== undefined) {
var n = t === null ? 0 : this.indexOfChild(t);
this.children.splice(n, 0, e);
} else this.children.push(e);
}
},
removeChild: function(e) {
return enyo.remove(e, this.children);
},
indexOfChild: function(e) {
return enyo.indexOf(e, this.children);
},
layoutKindChanged: function() {
this.layout && this.layout.destroy(), this.layout = enyo.createFromKind(this.layoutKind, this), this.generated && this.render();
},
flow: function() {
this.layout && this.layout.flow();
},
reflow: function() {
this.layout && this.layout.reflow();
},
resized: function() {
this.waterfall("onresize", enyo.UiComponent._resizeFlags), this.waterfall("onpostresize", enyo.UiComponent._resizeFlags);
},
resizeHandler: function() {
this.reflow();
},
waterfallDown: function(e, t, n) {
for (var r in this.$) this.$[r] instanceof enyo.UiComponent || this.$[r].waterfall(e, t, n);
for (var i = 0, s = this.children, o; o = s[i]; i++) (o.showing || !t || !t.showingOnly) && o.waterfall(e, t, n);
},
getBubbleTarget: function() {
return this.parent;
}
}), enyo.createFromKind = function(e, t) {
var n = e && enyo.constructorForKind(e);
if (n) return new n(t);
}, enyo.master = new enyo.Component({
name: "master",
notInstanceOwner: !0,
eventFlags: {
showingOnly: !0
},
getId: function() {
return "";
},
isDescendantOf: enyo.nop,
bubble: function(e, t, n) {
e == "onresize" ? (enyo.master.waterfallDown("onresize", this.eventFlags), enyo.master.waterfallDown("onpostresize", this.eventFlags)) : enyo.Signals.send(e, t);
}
});

// Layout.js

enyo.kind({
name: "enyo.Layout",
kind: null,
layoutClass: "",
constructor: function(e) {
this.container = e, e && e.addClass(this.layoutClass);
},
destroy: function() {
this.container && this.container.removeClass(this.layoutClass);
},
flow: function() {},
reflow: function() {}
});

// Signals.js

enyo.kind({
name: "enyo.Signals",
kind: enyo.Component,
create: function() {
this.inherited(arguments), enyo.Signals.addListener(this);
},
destroy: function() {
enyo.Signals.removeListener(this), this.inherited(arguments);
},
notify: function(e, t) {
this.dispatchEvent(e, t);
},
statics: {
listeners: [],
addListener: function(e) {
this.listeners.push(e);
},
removeListener: function(e) {
enyo.remove(e, this.listeners);
},
send: function(e, t) {
enyo.forEach(this.listeners, function(n) {
n.notify(e, t);
});
}
}
});

// Async.js

enyo.kind({
name: "enyo.Async",
kind: enyo.Object,
published: {
timeout: 0
},
failed: !1,
context: null,
constructor: function() {
this.responders = [], this.errorHandlers = [];
},
accumulate: function(e, t) {
var n = t.length < 2 ? t[0] : enyo.bind(t[0], t[1]);
e.push(n);
},
response: function() {
return this.accumulate(this.responders, arguments), this;
},
error: function() {
return this.accumulate(this.errorHandlers, arguments), this;
},
route: function(e, t) {
var n = enyo.bind(this, "respond");
e.response(function(e, t) {
n(t);
});
var r = enyo.bind(this, "fail");
e.error(function(e, t) {
r(t);
}), e.go(t);
},
handle: function(e, t) {
var n = t.shift();
if (n) if (n instanceof enyo.Async) this.route(n, e); else {
var r = enyo.call(this.context || this, n, [ this, e ]);
r = r !== undefined ? r : e, (this.failed ? this.fail : this.respond).call(this, r);
}
},
startTimer: function() {
this.startTime = enyo.now(), this.timeout && (this.timeoutJob = setTimeout(enyo.bind(this, "timeoutComplete"), this.timeout));
},
endTimer: function() {
this.timeoutJob && (this.endTime = enyo.now(), clearTimeout(this.timeoutJob), this.timeoutJob = null, this.latency = this.endTime - this.startTime);
},
timeoutComplete: function() {
this.timedout = !0, this.fail("timeout");
},
respond: function(e) {
this.failed = !1, this.endTimer(), this.handle(e, this.responders);
},
fail: function(e) {
this.failed = !0, this.endTimer(), this.handle(e, this.errorHandlers);
},
recover: function() {
this.failed = !1;
},
go: function(e) {
return enyo.asyncMethod(this, function() {
this.respond(e);
}), this;
}
});

// json.js

enyo.json = {
stringify: function(e, t, n) {
return JSON.stringify(e, t, n);
},
parse: function(e, t) {
return e ? JSON.parse(e, t) : null;
}
};

// cookie.js

enyo.getCookie = function(e) {
var t = document.cookie.match(new RegExp("(?:^|; )" + e + "=([^;]*)"));
return t ? decodeURIComponent(t[1]) : undefined;
}, enyo.setCookie = function(e, t, n) {
var r = e + "=" + encodeURIComponent(t), i = n || {}, s = i.expires;
if (typeof s == "number") {
var o = new Date;
o.setTime(o.getTime() + s * 24 * 60 * 60 * 1e3), s = o;
}
s && s.toUTCString && (i.expires = s.toUTCString());
var u, a;
for (u in i) r += "; " + u, a = i[u], a !== !0 && (r += "=" + a);
document.cookie = r;
};

// xhr.js

enyo.xhr = {
request: function(e) {
var t = this.getXMLHttpRequest(e), n = enyo.path.rewrite(this.simplifyFileURL(e.url)), r = e.method || "GET", i = !e.sync;
e.username ? t.open(r, n, i, e.username, e.password) : t.open(r, n, i), enyo.mixin(t, e.xhrFields), e.callback && this.makeReadyStateHandler(t, e.callback), e.headers = e.headers || {}, r !== "GET" && enyo.platform.ios && enyo.platform.ios >= 6 && e.headers["cache-control"] !== null && (e.headers["cache-control"] = e.headers["cache-control"] || "no-cache");
if (t.setRequestHeader) for (var s in e.headers) e.headers[s] && t.setRequestHeader(s, e.headers[s]);
return typeof t.overrideMimeType == "function" && e.mimeType && t.overrideMimeType(e.mimeType), t.send(e.body || null), !i && e.callback && t.onreadystatechange(t), t;
},
cancel: function(e) {
e.onload && (e.onload = null), e.onreadystatechange && (e.onreadystatechange = null), e.abort && e.abort();
},
makeReadyStateHandler: function(e, t) {
window.XDomainRequest && e instanceof XDomainRequest && (e.onload = function() {
var n;
typeof e.responseText == "string" && (n = e.responseText), t.apply(null, [ n, e ]);
}), e.onreadystatechange = function() {
if (e.readyState == 4) {
var n;
typeof e.responseText == "string" && (n = e.responseText), t.apply(null, [ n, e ]);
}
};
},
inOrigin: function(e) {
var t = document.createElement("a"), n = !1;
t.href = e;
if (t.protocol === ":" || t.protocol === window.location.protocol && t.hostname === window.location.hostname && t.port === (window.location.port || (window.location.protocol === "https:" ? "443" : "80"))) n = !0;
return n;
},
simplifyFileURL: function(e) {
var t = document.createElement("a"), n = !1;
return t.href = e, t.protocol === "file:" || t.protocol === ":" && window.location.protocol === "file:" ? t.protocol + "//" + t.host + t.pathname : t.protocol === ":" && window.location.protocol === "x-wmapp0:" ? window.location.protocol + "//" + window.location.pathname.split("/")[0] + "/" + t.host + t.pathname : e;
},
getXMLHttpRequest: function(e) {
try {
if (enyo.platform.ie < 10 && window.XDomainRequest && !e.headers && !this.inOrigin(e.url) && !/^file:\/\//.test(window.location.href)) return new XDomainRequest;
} catch (t) {}
try {
return new XMLHttpRequest;
} catch (t) {}
return null;
}
};

// formdata.js

(function(e) {
function i() {
this.fake = !0, this._fields = [], this.boundary = "--------------------------";
for (var e = 0; e < 24; e++) this.boundary += Math.floor(Math.random() * 10).toString(16);
}
function s(e, t) {
this.name = t.name, this.type = t.type || "application/octet-stream";
if (!enyo.isArray(e)) throw new Error("enyo.Blob only handles Arrays of Strings");
if (e.length > 0 && typeof e[0] != "string") throw new Error("enyo.Blob only handles Arrays of Strings");
this._bufs = e;
}
if (e.FormData) try {
var t = new e.FormData, n = new e.Blob;
enyo.FormData = e.FormData, enyo.Blob = e.Blob;
return;
} catch (r) {}
i.prototype.getContentType = function() {
return "multipart/form-data; boundary=" + this.boundary;
}, i.prototype.append = function(e, t, n) {
this._fields.push([ e, t, n ]);
}, i.prototype.toString = function() {
var e = this.boundary, t = "";
return enyo.forEach(this._fields, function(n) {
t += "--" + e + "\r\n";
if (n[2] || n[1].name) {
var r = n[1], i = n[2] || r.name;
t += 'Content-Disposition: form-data; name="' + n[0] + '"; filename="' + i + '"\r\n', t += "Content-Type: " + r.type + "\r\n\r\n", t += r.getAsBinary() + "\r\n";
} else t += 'Content-Disposition: form-data; name="' + n[0] + '";\r\n\r\n', t += n[1] + "\r\n";
}), t += "--" + e + "--", t;
}, enyo.FormData = i, s.prototype.getAsBinary = function() {
var e = "", t = e.concat.apply(e, this._bufs);
return t;
}, enyo.Blob = s;
})(window);

// AjaxProperties.js

enyo.AjaxProperties = {
cacheBust: !0,
url: "",
method: "GET",
handleAs: "json",
contentType: "application/x-www-form-urlencoded",
sync: !1,
headers: null,
postBody: "",
username: "",
password: "",
xhrFields: null,
mimeType: null
};

// Ajax.js

enyo.kind({
name: "enyo.Ajax",
kind: enyo.Async,
published: enyo.AjaxProperties,
constructor: function(e) {
enyo.mixin(this, e), this.inherited(arguments);
},
go: function(e) {
return this.startTimer(), this.request(e), this;
},
request: function(e) {
var t = this.url.split("?"), n = t.shift() || "", r = t.length ? t.join("?").split("&") : [], i = null;
enyo.isString(e) ? i = e : e && (i = enyo.Ajax.objectToQuery(e)), i && (r.push(i), i = null), this.cacheBust && r.push(Math.random());
var s = r.length ? [ n, r.join("&") ].join("?") : n, o = {}, u;
this.method != "GET" && (u = this.postBody, this.method === "POST" && u instanceof enyo.FormData ? u.fake && (o["Content-Type"] = u.getContentType(), u = u.toString()) : (o["Content-Type"] = this.contentType, u instanceof Object && (this.contentType === "application/json" ? u = JSON.stringify(u) : this.contentType === "application/x-www-form-urlencoded" ? u = enyo.Ajax.objectToQuery(u) : u = u.toString()))), enyo.mixin(o, this.headers), enyo.keys(o).length === 0 && (o = undefined);
try {
this.xhr = enyo.xhr.request({
url: s,
method: this.method,
callback: enyo.bind(this, "receive"),
body: u,
headers: o,
sync: window.PalmSystem ? !1 : this.sync,
username: this.username,
password: this.password,
xhrFields: this.xhrFields,
mimeType: this.mimeType
});
} catch (a) {
this.fail(a);
}
},
receive: function(e, t) {
if (!this.failed && !this.destroyed) {
var n;
typeof t.responseText == "string" ? n = t.responseText : n = t.responseBody, this.xhrResponse = {
status: t.status,
headers: enyo.Ajax.parseResponseHeaders(t),
body: n
}, this.isFailure(t) ? this.fail(t.status) : this.respond(this.xhrToResponse(t));
}
},
fail: function(e) {
this.xhr && (enyo.xhr.cancel(this.xhr), this.xhr = null), this.inherited(arguments);
},
xhrToResponse: function(e) {
if (e) return this[(this.handleAs || "text") + "Handler"](e);
},
isFailure: function(e) {
try {
var t = "";
return typeof e.responseText == "string" && (t = e.responseText), e.status === 0 && t === "" ? !0 : e.status !== 0 && (e.status < 200 || e.status >= 300);
} catch (n) {
return !0;
}
},
xmlHandler: function(e) {
return e.responseXML;
},
textHandler: function(e) {
return e.responseText;
},
jsonHandler: function(e) {
var t = e.responseText;
try {
return t && enyo.json.parse(t);
} catch (n) {
return enyo.warn("Ajax request set to handleAs JSON but data was not in JSON format"), t;
}
},
statics: {
objectToQuery: function(e) {
var t = encodeURIComponent, n = [], r = {};
for (var i in e) {
var s = e[i];
if (s != r[i]) {
var o = t(i) + "=";
if (enyo.isArray(s)) for (var u = 0; u < s.length; u++) n.push(o + t(s[u])); else n.push(o + t(s));
}
}
return n.join("&");
},
parseResponseHeaders: function(e) {
var t = {}, n = [];
e.getAllResponseHeaders && (n = e.getAllResponseHeaders().split(/\r?\n/));
for (var r = 0; r < n.length; r++) {
var i = n[r], s = i.indexOf(": ");
if (s > 0) {
var o = i.substring(0, s).toLowerCase(), u = i.substring(s + 2);
t[o] = u;
}
}
return t;
}
}
});

// Jsonp.js

enyo.kind({
name: "enyo.JsonpRequest",
kind: enyo.Async,
published: {
url: "",
charset: null,
callbackName: "callback",
cacheBust: !0
},
statics: {
nextCallbackID: 0
},
addScriptElement: function() {
var e = document.createElement("script");
e.src = this.src, e.async = "async", this.charset && (e.charset = this.charset), e.onerror = enyo.bind(this, function() {
this.fail(400);
});
var t = document.getElementsByTagName("script")[0];
t.parentNode.insertBefore(e, t), this.scriptTag = e;
},
removeScriptElement: function() {
var e = this.scriptTag;
this.scriptTag = null, e.onerror = null, e.parentNode && e.parentNode.removeChild(e);
},
constructor: function(e) {
enyo.mixin(this, e), this.inherited(arguments);
},
go: function(e) {
return this.startTimer(), this.jsonp(e), this;
},
jsonp: function(e) {
var t = "enyo_jsonp_callback_" + enyo.JsonpRequest.nextCallbackID++;
this.src = this.buildUrl(e, t), this.addScriptElement(), window[t] = enyo.bind(this, this.respond);
var n = enyo.bind(this, function() {
this.removeScriptElement(), window[t] = null;
});
this.response(n), this.error(n);
},
buildUrl: function(e, t) {
var n = this.url.split("?"), r = n.shift() || "", i = n.join("?").split("&"), s = this.bodyArgsFromParams(e, t);
return i.push(s), this.cacheBust && i.push(Math.random()), [ r, i.join("&") ].join("?");
},
bodyArgsFromParams: function(e, t) {
if (enyo.isString(e)) return e.replace("=?", "=" + t);
var n = enyo.mixin({}, e);
return n[this.callbackName] = t, enyo.Ajax.objectToQuery(n);
}
});

// WebService.js

enyo.kind({
name: "enyo._AjaxComponent",
kind: enyo.Component,
published: enyo.AjaxProperties
}), enyo.kind({
name: "enyo.WebService",
kind: enyo._AjaxComponent,
published: {
jsonp: !1,
callbackName: "callback",
charset: null,
timeout: 0
},
events: {
onResponse: "",
onError: ""
},
constructor: function(e) {
this.inherited(arguments);
},
send: function(e, t) {
return this.jsonp ? this.sendJsonp(e, t) : this.sendAjax(e, t);
},
sendJsonp: function(e, t) {
var n = new enyo.JsonpRequest;
for (var r in {
url: 1,
callbackName: 1,
charset: 1,
timeout: 1
}) n[r] = this[r];
return enyo.mixin(n, t), this.sendAsync(n, e);
},
sendAjax: function(e, t) {
var n = new enyo.Ajax(t);
for (var r in enyo.AjaxProperties) n[r] = this[r];
return n.timeout = this.timeout, enyo.mixin(n, t), this.sendAsync(n, e);
},
sendAsync: function(e, t) {
return e.go(t).response(this, "response").error(this, "error");
},
response: function(e, t) {
this.doResponse({
ajax: e,
data: t
});
},
error: function(e, t) {
this.doError({
ajax: e,
data: t
});
}
});

// dom.js

enyo.requiresWindow = function(e) {
e();
}, enyo.dom = {
byId: function(e, t) {
return typeof e == "string" ? (t || document).getElementById(e) : e;
},
escape: function(e) {
return e !== null ? String(e).replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;") : "";
},
getBounds: function(e) {
return e ? {
left: e.offsetLeft,
top: e.offsetTop,
width: e.offsetWidth,
height: e.offsetHeight
} : null;
},
getComputedStyle: function(e) {
return window.getComputedStyle && e && window.getComputedStyle(e, null);
},
getComputedStyleValue: function(e, t, n) {
var r = n || this.getComputedStyle(e);
return r ? r.getPropertyValue(t) : null;
},
getFirstElementByTagName: function(e) {
var t = document.getElementsByTagName(e);
return t && t[0];
},
applyBodyFit: function() {
var e = this.getFirstElementByTagName("html");
e && (e.className += " enyo-document-fit");
var t = this.getFirstElementByTagName("body");
t && (t.className += " enyo-body-fit"), enyo.bodyIsFitting = !0;
},
getWindowWidth: function() {
return window.innerWidth ? window.innerWidth : document.body && document.body.offsetWidth ? document.body.offsetWidth : document.compatMode == "CSS1Compat" && document.documentElement && document.documentElement.offsetWidth ? document.documentElement.offsetWidth : 320;
},
getWindowHeight: function() {
return window.innerHeight ? window.innerHeight : document.body && document.body.offsetHeight ? document.body.offsetHeight : document.compatMode == "CSS1Compat" && document.documentElement && document.documentElement.offsetHeight ? document.documentElement.offsetHeight : 480;
},
_ieCssToPixelValue: function(e, t) {
var n = t, r = e.style, i = r.left, s = e.runtimeStyle && e.runtimeStyle.left;
return s && (e.runtimeStyle.left = e.currentStyle.left), r.left = n, n = r.pixelLeft, r.left = i, s && (r.runtimeStyle.left = s), n;
},
_pxMatch: /px/i,
getComputedBoxValue: function(e, t, n, r) {
var i = r || this.getComputedStyle(e);
if (i) return parseInt(i.getPropertyValue(t + "-" + n), 0);
if (e && e.currentStyle) {
var s = e.currentStyle[t + enyo.cap(n)];
return s.match(this._pxMatch) || (s = this._ieCssToPixelValue(e, s)), parseInt(s, 0);
}
return 0;
},
calcBoxExtents: function(e, t) {
var n = this.getComputedStyle(e);
return {
top: this.getComputedBoxValue(e, t, "top", n),
right: this.getComputedBoxValue(e, t, "right", n),
bottom: this.getComputedBoxValue(e, t, "bottom", n),
left: this.getComputedBoxValue(e, t, "left", n)
};
},
calcPaddingExtents: function(e) {
return this.calcBoxExtents(e, "padding");
},
calcMarginExtents: function(e) {
return this.calcBoxExtents(e, "margin");
},
calcNodePosition: function(e, t) {
var n = 0, r = 0, i = e, s = i.offsetWidth, o = i.offsetHeight, u = enyo.dom.getStyleTransformProp(), a = /translateX\((-?\d+)px\)/i, f = /translateY\((-?\d+)px\)/i, l = 0, c = 0, h = 0, p = 0;
t ? (h = t.offsetHeight, p = t.offsetWidth) : (h = document.body.parentNode.offsetHeight > this.getWindowHeight() ? this.getWindowHeight() - document.body.parentNode.scrollTop : document.body.parentNode.offsetHeight, p = document.body.parentNode.offsetWidth > this.getWindowWidth() ? this.getWindowWidth() - document.body.parentNode.scrollLeft : document.body.parentNode.offsetWidth);
if (i.offsetParent) do r += i.offsetLeft - (i.offsetParent ? i.offsetParent.scrollLeft : 0), u && a.test(i.style[u]) && (r += parseInt(i.style[u].replace(a, "$1"), 10)), n += i.offsetTop - (i.offsetParent ? i.offsetParent.scrollTop : 0), u && f.test(i.style[u]) && (n += parseInt(i.style[u].replace(f, "$1"), 10)), i !== e && (i.currentStyle ? (l = parseInt(i.currentStyle.borderLeftWidth, 10), c = parseInt(i.currentStyle.borderTopWidth, 10)) : window.getComputedStyle ? (l = parseInt(window.getComputedStyle(i, "").getPropertyValue("border-left-width"), 10), c = parseInt(window.getComputedStyle(i, "").getPropertyValue("border-top-width"), 10)) : (l = parseInt(i.style.borderLeftWidth, 10), c = parseInt(i.style.borderTopWidth, 10)), l && (r += l), c && (n += c)); while ((i = i.offsetParent) && i !== t);
return {
top: n,
left: r,
bottom: h - n - o,
right: p - r - s,
height: o,
width: s
};
},
setInnerHtml: function(e, t) {
enyo.execUnsafeLocalFunction(function() {
e.innerHTML = t;
});
}
};

// transform.js

(function() {
enyo.dom.calcCanAccelerate = function() {
if (enyo.platform.android <= 2) return !1;
var e = [ "perspective", "WebkitPerspective", "MozPerspective", "msPerspective", "OPerspective" ];
for (var t = 0, n; n = e[t]; t++) if (typeof document.body.style[n] != "undefined") return !0;
return !1;
};
var e = [ "transform", "-webkit-transform", "-moz-transform", "-ms-transform", "-o-transform" ], t = [ "transform", "webkitTransform", "MozTransform", "msTransform", "OTransform" ];
enyo.dom.getCssTransformProp = function() {
if (this._cssTransformProp) return this._cssTransformProp;
var n = enyo.indexOf(this.getStyleTransformProp(), t);
return this._cssTransformProp = e[n];
}, enyo.dom.getStyleTransformProp = function() {
if (this._styleTransformProp || !document.body) return this._styleTransformProp;
for (var e = 0, n; n = t[e]; e++) if (typeof document.body.style[n] != "undefined") return this._styleTransformProp = n;
}, enyo.dom.domTransformsToCss = function(e) {
var t, n, r = "";
for (t in e) n = e[t], n !== null && n !== undefined && n !== "" && (r += t + "(" + n + ") ");
return r;
}, enyo.dom.transformsToDom = function(e) {
var t = this.domTransformsToCss(e.domTransforms), n = e.hasNode() ? e.node.style : null, r = e.domStyles, i = this.getStyleTransformProp(), s = this.getCssTransformProp();
i && s && (r[s] = t, n ? n[i] = t : e.domStylesChanged());
}, enyo.dom.canTransform = function() {
return Boolean(this.getStyleTransformProp());
}, enyo.dom.canAccelerate = function() {
return this.accelerando !== undefined ? this.accelerando : document.body && (this.accelerando = this.calcCanAccelerate());
}, enyo.dom.transform = function(e, t) {
var n = e.domTransforms = e.domTransforms || {};
enyo.mixin(n, t), this.transformsToDom(e);
}, enyo.dom.transformValue = function(e, t, n) {
var r = e.domTransforms = e.domTransforms || {};
r[t] = n, this.transformsToDom(e);
}, enyo.dom.accelerate = function(e, t) {
var n = t == "auto" ? this.canAccelerate() : t;
this.transformValue(e, "translateZ", n ? 0 : null);
};
})();

// Control.js

enyo.kind({
name: "enyo.Control",
kind: enyo.UiComponent,
published: {
tag: "div",
attributes: null,
classes: "",
style: "",
content: "",
showing: !0,
allowHtml: !1,
src: "",
canGenerate: !0,
fit: !1,
isContainer: !1
},
handlers: {
ontap: "tap"
},
defaultKind: "Control",
controlClasses: "",
node: null,
generated: !1,
create: function() {
this.initStyles(), this.inherited(arguments), this.showingChanged(), this.addClass(this.kindClasses), this.addClass(this.classes), this.initProps([ "id", "content", "src" ]);
},
destroy: function() {
this.removeNodeFromDom(), enyo.Control.unregisterDomEvents(this.id), this.inherited(arguments);
},
importProps: function(e) {
this.inherited(arguments), this.attributes = enyo.mixin(enyo.clone(this.kindAttributes), this.attributes);
},
initProps: function(e) {
for (var t = 0, n, r; n = e[t]; t++) this[n] && (r = n + "Changed", this[r] && this[r]());
},
classesChanged: function(e) {
this.removeClass(e), this.addClass(this.classes);
},
addChild: function(e) {
e.addClass(this.controlClasses), this.inherited(arguments);
},
removeChild: function(e) {
this.inherited(arguments), e.removeClass(this.controlClasses);
},
strictlyInternalEvents: {
onenter: 1,
onleave: 1
},
dispatchEvent: function(e, t, n) {
return this.strictlyInternalEvents[e] && this.isInternalEvent(t) ? !0 : this.inherited(arguments);
},
isInternalEvent: function(e) {
var t = enyo.dispatcher.findDispatchTarget(e.relatedTarget);
return t && t.isDescendantOf(this);
},
hasNode: function() {
return this.generated && (this.node || this.findNodeById());
},
addContent: function(e) {
this.setContent(this.content + e);
},
getAttribute: function(e) {
return this.hasNode() ? this.node.getAttribute(e) : this.attributes[e];
},
setAttribute: function(e, t) {
this.attributes[e] = t, this.hasNode() && this.attributeToNode(e, t), this.invalidateTags();
},
getNodeProperty: function(e, t) {
return this.hasNode() ? this.node[e] : t;
},
setNodeProperty: function(e, t) {
this.hasNode() && (this.node[e] = t);
},
setClassAttribute: function(e) {
this.setAttribute("class", e);
},
getClassAttribute: function() {
return this.attributes["class"] || "";
},
hasClass: function(e) {
return e && (" " + this.getClassAttribute() + " ").indexOf(" " + e + " ") >= 0;
},
addClass: function(e) {
if (e && !this.hasClass(e)) {
var t = this.getClassAttribute();
this.setClassAttribute(t + (t ? " " : "") + e);
}
},
removeClass: function(e) {
if (e && this.hasClass(e)) {
var t = this.getClassAttribute();
t = (" " + t + " ").replace(" " + e + " ", " ").slice(1, -1), this.setClassAttribute(t);
}
},
addRemoveClass: function(e, t) {
this[t ? "addClass" : "removeClass"](e);
},
initStyles: function() {
this.domStyles = this.domStyles || {}, enyo.Control.cssTextToDomStyles(this.kindStyle, this.domStyles), this.domCssText = enyo.Control.domStylesToCssText(this.domStyles);
},
styleChanged: function() {
this.invalidateTags(), this.renderStyles();
},
applyStyle: function(e, t) {
this.domStyles[e] = t, this.domStylesChanged();
},
addStyles: function(e) {
enyo.Control.cssTextToDomStyles(e, this.domStyles), this.domStylesChanged();
},
getComputedStyleValue: function(e, t) {
return this.hasNode() ? enyo.dom.getComputedStyleValue(this.node, e) : t;
},
domStylesChanged: function() {
this.domCssText = enyo.Control.domStylesToCssText(this.domStyles), this.invalidateTags(), this.renderStyles();
},
stylesToNode: function() {
this.node.style.cssText = this.style + (this.style[this.style.length - 1] == ";" ? " " : "; ") + this.domCssText;
},
setupBodyFitting: function() {
enyo.dom.applyBodyFit(), this.addClass("enyo-fit enyo-clip");
},
setupOverflowScrolling: function() {
if (enyo.platform.android || enyo.platform.androidChrome || enyo.platform.blackberry) return;
document.getElementsByTagName("body")[0].className += " webkitOverflowScrolling";
},
render: function() {
if (this.parent) {
this.parent.beforeChildRender(this);
if (!this.parent.generated) return this;
}
return this.hasNode() || this.renderNode(), this.hasNode() && (this.renderDom(), this.generated && this.rendered()), this;
},
renderInto: function(e) {
this.teardownRender();
var t = enyo.dom.byId(e);
return t == document.body ? this.setupBodyFitting() : this.fit && this.addClass("enyo-fit enyo-clip"), this.addClass("enyo-no-touch-action"), this.setupOverflowScrolling(), enyo.dom.setInnerHtml(t, this.generateHtml()), this.generated && this.rendered(), this;
},
write: function() {
return this.fit && this.setupBodyFitting(), this.addClass("enyo-no-touch-action"), this.setupOverflowScrolling(), document.write(this.generateHtml()), this.generated && this.rendered(), this;
},
rendered: function() {
this.reflow();
for (var e = 0, t; t = this.children[e]; e++) t.generated && t.rendered();
},
show: function() {
this.setShowing(!0);
},
hide: function() {
this.setShowing(!1);
},
getBounds: function() {
var e = this.node || this.hasNode(), t = enyo.dom.getBounds(e);
return t || {
left: undefined,
top: undefined,
width: undefined,
height: undefined
};
},
setBounds: function(e, t) {
var n = this.domStyles, r = t || "px", i = [ "width", "height", "left", "top", "right", "bottom" ];
for (var s = 0, o, u; u = i[s]; s++) {
o = e[u];
if (o || o === 0) n[u] = o + (enyo.isString(o) ? "" : r);
}
this.domStylesChanged();
},
findNodeById: function() {
return this.id && (this.node = enyo.dom.byId(this.id));
},
idChanged: function(e) {
e && enyo.Control.unregisterDomEvents(e), this.setAttribute("id", this.id), this.id && enyo.Control.registerDomEvents(this.id, this);
},
contentChanged: function() {
this.hasNode() && this.renderContent();
},
getSrc: function() {
return this.getAttribute("src");
},
srcChanged: function() {
this.setAttribute("src", enyo.path.rewrite(this.src));
},
attributesChanged: function() {
this.invalidateTags(), this.renderAttributes();
},
generateHtml: function() {
if (this.canGenerate === !1) return "";
var e = this.generateInnerHtml(), t = this.generateOuterHtml(e);
return this.generated = !0, t;
},
generateInnerHtml: function() {
return this.flow(), this.children.length ? this.generateChildHtml() : this.allowHtml ? this.content : enyo.Control.escapeHtml(this.content);
},
generateChildHtml: function() {
var e = "";
for (var t = 0, n; n = this.children[t]; t++) {
var r = n.generateHtml();
e += r;
}
return e;
},
generateOuterHtml: function(e) {
return this.tag ? (this.tagsValid || this.prepareTags(), this._openTag + e + this._closeTag) : e;
},
invalidateTags: function() {
this.tagsValid = !1;
},
prepareTags: function() {
var e = this.domCssText + this.style;
this._openTag = "<" + this.tag + (e ? ' style="' + e + '"' : "") + enyo.Control.attributesToHtml(this.attributes), enyo.Control.selfClosing[this.tag] ? (this._openTag += "/>", this._closeTag = "") : (this._openTag += ">", this._closeTag = "</" + this.tag + ">"), this.tagsValid = !0;
},
attributeToNode: function(e, t) {
t === null || t === !1 || t === "" ? this.node.removeAttribute(e) : this.node.setAttribute(e, t);
},
attributesToNode: function() {
for (var e in this.attributes) this.attributeToNode(e, this.attributes[e]);
},
getParentNode: function() {
return this.parentNode || this.parent && (this.parent.hasNode() || this.parent.getParentNode());
},
addNodeToParent: function() {
if (this.node) {
var e = this.getParentNode();
e && (this.addBefore !== undefined ? this.insertNodeInParent(e, this.addBefore && this.addBefore.hasNode()) : this.appendNodeToParent(e));
}
},
appendNodeToParent: function(e) {
e.appendChild(this.node);
},
insertNodeInParent: function(e, t) {
e.insertBefore(this.node, t || e.firstChild);
},
removeNodeFromDom: function() {
this.hasNode() && this.node.parentNode && this.node.parentNode.removeChild(this.node);
},
teardownRender: function() {
this.generated && this.teardownChildren(), this.node = null, this.generated = !1;
},
teardownChildren: function() {
for (var e = 0, t; t = this.children[e]; e++) t.teardownRender();
},
renderNode: function() {
this.teardownRender(), this.node = document.createElement(this.tag), this.addNodeToParent(), this.generated = !0;
},
renderDom: function() {
this.renderAttributes(), this.renderStyles(), this.renderContent();
},
renderContent: function() {
this.generated && this.teardownChildren(), enyo.dom.setInnerHtml(this.node, this.generateInnerHtml());
},
renderStyles: function() {
this.hasNode() && this.stylesToNode();
},
renderAttributes: function() {
this.hasNode() && this.attributesToNode();
},
beforeChildRender: function() {
this.generated && this.flow();
},
syncDisplayToShowing: function() {
var e = this.domStyles;
this.showing ? e.display == "none" && this.applyStyle("display", this._displayStyle || "") : (this._displayStyle = e.display == "none" ? "" : e.display, this.applyStyle("display", "none"));
},
showingChanged: function() {
this.syncDisplayToShowing();
},
getShowing: function() {
return this.showing = this.domStyles.display != "none";
},
fitChanged: function(e) {
this.parent.reflow();
},
statics: {
escapeHtml: function(e) {
return e != null ? String(e).replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;") : "";
},
registerDomEvents: function(e, t) {
enyo.$[e] = t;
},
unregisterDomEvents: function(e) {
enyo.$[e] = null;
},
selfClosing: {
img: 1,
hr: 1,
br: 1,
area: 1,
base: 1,
basefont: 1,
input: 1,
link: 1,
meta: 1,
command: 1,
embed: 1,
keygen: 1,
wbr: 1,
param: 1,
source: 1,
track: 1,
col: 1
},
cssTextToDomStyles: function(e, t) {
if (e) {
var n = e.replace(/; /g, ";").split(";");
for (var r = 0, i, s, o, u; u = n[r]; r++) i = u.split(":"), s = i.shift(), o = i.join(":"), t[s] = o;
}
},
domStylesToCssText: function(e) {
var t, n, r = "";
for (t in e) n = e[t], n !== null && n !== undefined && n !== "" && (r += t + ":" + n + ";");
return r;
},
stylesToHtml: function(e) {
var t = enyo.Control.domStylesToCssText(e);
return t ? ' style="' + t + '"' : "";
},
escapeAttribute: function(e) {
return enyo.isString(e) ? String(e).replace(/&/g, "&amp;").replace(/\"/g, "&quot;") : e;
},
attributesToHtml: function(e) {
var t, n, r = "";
for (t in e) n = e[t], n !== null && n !== !1 && n !== "" && (r += " " + t + '="' + enyo.Control.escapeAttribute(n) + '"');
return r;
}
}
}), enyo.defaultCtor = enyo.Control, enyo.Control.subclass = function(e, t) {
var n = e.prototype;
if (n.classes) {
var r = n.kindClasses;
n.kindClasses = (r ? r + " " : "") + n.classes, n.classes = "";
}
if (n.style) {
var i = n.kindStyle;
n.kindStyle = (i ? i + ";" : "") + n.style, n.style = "";
}
if (t.attributes) {
var s = n.kindAttributes;
n.kindAttributes = enyo.mixin(enyo.clone(s), n.attributes), n.attributes = null;
}
};

// platform.js

enyo.platform = {
touch: Boolean("ontouchstart" in window || window.navigator.msMaxTouchPoints),
gesture: Boolean("ongesturestart" in window || window.navigator.msMaxTouchPoints)
}, function() {
var e = navigator.userAgent, t = enyo.platform, n = [ {
platform: "androidChrome",
regex: /Android .* Chrome\/(\d+)[.\d]+/
}, {
platform: "android",
regex: /Android (\d+)/
}, {
platform: "android",
regex: /Silk\/1./,
forceVersion: 2,
extra: {
silk: 1
}
}, {
platform: "android",
regex: /Silk\/2./,
forceVersion: 4,
extra: {
silk: 2
}
}, {
platform: "windowsPhone",
regex: /Windows Phone (?:OS )?(\d+)[.\d]+/
}, {
platform: "ie",
regex: /MSIE (\d+)/
}, {
platform: "ie",
regex: /Trident\/.*; rv:(\d+)/
}, {
platform: "ios",
regex: /iP(?:hone|ad;(?: U;)? CPU) OS (\d+)/
}, {
platform: "webos",
regex: /(?:web|hpw)OS\/(\d+)/
}, {
platform: "safari",
regex: /Version\/(\d+)[.\d]+\s+Safari/
}, {
platform: "chrome",
regex: /Chrome\/(\d+)[.\d]+/
}, {
platform: "androidFirefox",
regex: /Android;.*Firefox\/(\d+)/
}, {
platform: "firefoxOS",
regex: /Mobile;.*Firefox\/(\d+)/
}, {
platform: "firefox",
regex: /Firefox\/(\d+)/
}, {
platform: "blackberry",
regex: /BB1\d;.*Version\/(\d+\.\d+)/
} ];
for (var r = 0, i, s, o; i = n[r]; r++) {
s = i.regex.exec(e);
if (s) {
i.forceVersion ? o = i.forceVersion : o = Number(s[1]), t[i.platform] = o, i.extra && enyo.mixin(t, i.extra);
break;
}
}
enyo.dumbConsole = Boolean(t.android || t.ios || t.webos);
}();

// animation.js

(function() {
var e = Math.round(1e3 / 60), t = [ "webkit", "moz", "ms", "o", "" ], n = "requestAnimationFrame", r = "cancel" + enyo.cap(n), i = function(t) {
return window.setTimeout(t, e);
}, s = function(e) {
return window.clearTimeout(e);
};
for (var o = 0, u = t.length, a, f, l; (a = t[o]) || o < u; o++) {
if (enyo.platform.ios >= 6) break;
f = a ? a + enyo.cap(r) : r, l = a ? a + enyo.cap(n) : n;
if (window[f]) {
s = window[f], i = window[l], a == "webkit" && s(i(enyo.nop));
break;
}
}
enyo.requestAnimationFrame = function(e, t) {
return i(e, t);
}, enyo.cancelRequestAnimationFrame = function(e) {
return s(e);
};
})(), enyo.easing = {
cubicIn: function(e) {
return Math.pow(e, 3);
},
cubicOut: function(e) {
return Math.pow(e - 1, 3) + 1;
},
expoOut: function(e) {
return e == 1 ? 1 : -1 * Math.pow(2, -10 * e) + 1;
},
quadInOut: function(e) {
return e *= 2, e < 1 ? Math.pow(e, 2) / 2 : -1 * (--e * (e - 2) - 1) / 2;
},
linear: function(e) {
return e;
}
}, enyo.easedLerp = function(e, t, n, r) {
var i = (enyo.now() - e) / t;
return r ? i >= 1 ? 0 : 1 - n(1 - i) : i >= 1 ? 1 : n(i);
};

// phonegap.js

(function() {
if (window.cordova || window.PhoneGap) {
var e = [ "deviceready", "pause", "resume", "online", "offline", "backbutton", "batterycritical", "batterylow", "batterystatus", "menubutton", "searchbutton", "startcallbutton", "endcallbutton", "volumedownbutton", "volumeupbutton" ];
for (var t = 0, n; n = e[t]; t++) document.addEventListener(n, enyo.bind(enyo.Signals, "send", "on" + n), !1);
}
})();

// dispatcher.js

enyo.$ = {}, enyo.dispatcher = {
events: [ "mousedown", "mouseup", "mouseover", "mouseout", "mousemove", "mousewheel", "click", "dblclick", "change", "keydown", "keyup", "keypress", "input" ],
windowEvents: [ "resize", "load", "unload", "message" ],
cssEvents: [ "webkitTransitionEnd", "transitionend" ],
features: [],
connect: function() {
var e = enyo.dispatcher, t, n;
for (t = 0; n = e.events[t]; t++) e.listen(document, n);
for (t = 0; n = e.cssEvents[t]; t++) e.listen(document, n);
for (t = 0; n = e.windowEvents[t]; t++) {
if (n === "unload" && typeof window.chrome == "object" && window.chrome.app) continue;
e.listen(window, n);
}
for (t = 0; n = e.cssEvents[t]; t++) e.listen(document, n);
},
listen: function(e, t, n) {
var r = enyo.dispatch;
e.addEventListener ? this.listen = function(e, t, n) {
e.addEventListener(t, n || r, !1);
} : this.listen = function(e, t, n) {
e.attachEvent("on" + t, function(e) {
return e.target = e.srcElement, e.preventDefault || (e.preventDefault = enyo.iePreventDefault), (n || r)(e);
});
}, this.listen(e, t, n);
},
dispatch: function(e) {
var t = this.findDispatchTarget(e.target) || this.findDefaultTarget(e);
e.dispatchTarget = t;
for (var n = 0, r; r = this.features[n]; n++) if (r.call(this, e) === !0) return;
t && !e.preventDispatch && this.dispatchBubble(e, t);
},
findDispatchTarget: function(e) {
var t, n = e;
try {
while (n) {
if (t = enyo.$[n.id]) {
t.eventNode = n;
break;
}
n = n.parentNode;
}
} catch (r) {
enyo.log(r, n);
}
return t;
},
findDefaultTarget: function(e) {
return enyo.master;
},
dispatchBubble: function(e, t) {
return t.bubble("on" + e.type, e, t);
}
}, enyo.iePreventDefault = function() {
try {
this.returnValue = !1;
} catch (e) {}
}, enyo.dispatch = function(e) {
return enyo.dispatcher.dispatch(e);
}, enyo.bubble = function(e) {
var t = e || window.event;
t && (t.target || (t.target = t.srcElement), enyo.dispatch(t));
}, enyo.bubbler = "enyo.bubble(arguments[0])", function() {
var e = function() {
enyo.bubble(arguments[0]);
};
enyo.makeBubble = function() {
var t = Array.prototype.slice.call(arguments, 0), n = t.shift();
typeof n == "object" && typeof n.hasNode == "function" && enyo.forEach(t, function(t) {
this.hasNode() && enyo.dispatcher.listen(this.node, t, e);
}, n);
};
}(), enyo.requiresWindow(enyo.dispatcher.connect), enyo.dispatcher.features.push(function(e) {
if ("click" === e.type && e.clientX === 0 && e.clientY === 0) {
var t = enyo.clone(e);
t.type = "tap", enyo.dispatch(t);
}
});

// preview.js

(function() {
var e = "previewDomEvent", t = {
feature: function(e) {
t.dispatch(e, e.dispatchTarget);
},
dispatch: function(t, n) {
var r = this.buildLineage(n);
for (var i = 0, s; s = r[i]; i++) if (s[e] && s[e](t) === !0) {
t.preventDispatch = !0;
return;
}
},
buildLineage: function(e) {
var t = [], n = e;
while (n) t.unshift(n), n = n.parent;
return t;
}
};
enyo.dispatcher.features.push(t.feature);
})();

// modal.js

enyo.dispatcher.features.push(function(e) {
var t = e.dispatchTarget, n = this.captureTarget && !this.noCaptureEvents[e.type], r = n && !(t && t.isDescendantOf && t.isDescendantOf(this.captureTarget));
if (r) {
var i = e.captureTarget = this.captureTarget, s = this.autoForwardEvents[e.type] || this.forwardEvents;
this.dispatchBubble(e, i), s || (e.preventDispatch = !0);
}
}), enyo.mixin(enyo.dispatcher, {
noCaptureEvents: {
load: 1,
unload: 1,
error: 1
},
autoForwardEvents: {
leave: 1,
resize: 1
},
captures: [],
capture: function(e, t) {
var n = {
target: e,
forward: t
};
this.captures.push(n), this.setCaptureInfo(n);
},
release: function() {
this.captures.pop(), this.setCaptureInfo(this.captures[this.captures.length - 1]);
},
setCaptureInfo: function(e) {
this.captureTarget = e && e.target, this.forwardEvents = e && e.forward;
}
});

// gesture.js

enyo.gesture = {
eventProps: [ "target", "relatedTarget", "clientX", "clientY", "pageX", "pageY", "screenX", "screenY", "altKey", "ctrlKey", "metaKey", "shiftKey", "detail", "identifier", "dispatchTarget", "which", "srcEvent" ],
makeEvent: function(e, t) {
var n = {
type: e
};
for (var r = 0, i; i = this.eventProps[r]; r++) n[i] = t[i];
n.srcEvent = n.srcEvent || t, n.preventDefault = this.preventDefault, n.disablePrevention = this.disablePrevention;
if (enyo.platform.ie < 10) {
enyo.platform.ie == 8 && n.target && (n.pageX = n.clientX + n.target.scrollLeft, n.pageY = n.clientY + n.target.scrollTop);
var s = window.event && window.event.button;
n.which = s & 1 ? 1 : s & 2 ? 2 : s & 4 ? 3 : 0;
} else (enyo.platform.webos || window.PalmSystem) && n.which === 0 && (n.which = 1);
return n;
},
down: function(e) {
var t = this.makeEvent("down", e);
enyo.dispatch(t), this.downEvent = t;
},
move: function(e) {
var t = this.makeEvent("move", e);
t.dx = t.dy = t.horizontal = t.vertical = 0, t.which && this.downEvent && (t.dx = e.clientX - this.downEvent.clientX, t.dy = e.clientY - this.downEvent.clientY, t.horizontal = Math.abs(t.dx) > Math.abs(t.dy), t.vertical = !t.horizontal), enyo.dispatch(t);
},
up: function(e) {
var t = this.makeEvent("up", e), n = !1;
t.preventTap = function() {
n = !0;
}, enyo.dispatch(t), !n && this.downEvent && this.downEvent.which == 1 && this.sendTap(t), this.downEvent = null;
},
over: function(e) {
enyo.dispatch(this.makeEvent("enter", e));
},
out: function(e) {
enyo.dispatch(this.makeEvent("leave", e));
},
sendTap: function(e) {
var t = this.findCommonAncestor(this.downEvent.target, e.target);
if (t) {
var n = this.makeEvent("tap", e);
n.target = t, enyo.dispatch(n);
}
},
findCommonAncestor: function(e, t) {
var n = t;
while (n) {
if (this.isTargetDescendantOf(e, n)) return n;
n = n.parentNode;
}
},
isTargetDescendantOf: function(e, t) {
var n = e;
while (n) {
if (n == t) return !0;
n = n.parentNode;
}
}
}, enyo.gesture.preventDefault = function() {
this.srcEvent && this.srcEvent.preventDefault();
}, enyo.gesture.disablePrevention = function() {
this.preventDefault = enyo.nop, this.srcEvent && (this.srcEvent.preventDefault = enyo.nop);
}, enyo.dispatcher.features.push(function(e) {
if (enyo.gesture.events[e.type]) return enyo.gesture.events[e.type](e);
}), enyo.gesture.events = {
mousedown: function(e) {
enyo.gesture.down(e);
},
mouseup: function(e) {
enyo.gesture.up(e);
},
mousemove: function(e) {
enyo.gesture.move(e);
},
mouseover: function(e) {
enyo.gesture.over(e);
},
mouseout: function(e) {
enyo.gesture.out(e);
}
}, enyo.requiresWindow(function() {
document.addEventListener && document.addEventListener("DOMMouseScroll", function(e) {
var t = enyo.clone(e);
t.preventDefault = function() {
e.preventDefault();
}, t.type = "mousewheel";
var n = t.VERTICAL_AXIS == t.axis ? "wheelDeltaY" : "wheelDeltaX";
t[n] = t.detail * -40, enyo.dispatch(t);
}, !1);
});

// drag.js

enyo.dispatcher.features.push(function(e) {
if (enyo.gesture.drag[e.type]) return enyo.gesture.drag[e.type](e);
}), enyo.gesture.drag = {
hysteresisSquared: 16,
holdPulseDelay: 200,
trackCount: 5,
minFlick: .1,
minTrack: 8,
down: function(e) {
this.stopDragging(e), this.cancelHold(), this.target = e.target, this.startTracking(e), this.beginHold(e);
},
move: function(e) {
if (this.tracking) {
this.track(e);
if (!e.which) {
this.stopDragging(e), this.cancelHold(), this.tracking = !1;
return;
}
this.dragEvent ? this.sendDrag(e) : this.dy * this.dy + this.dx * this.dx >= this.hysteresisSquared && (this.sendDragStart(e), this.cancelHold());
}
},
up: function(e) {
this.endTracking(e), this.stopDragging(e), this.cancelHold();
},
leave: function(e) {
this.dragEvent && this.sendDragOut(e);
},
stopDragging: function(e) {
if (this.dragEvent) {
this.sendDrop(e);
var t = this.sendDragFinish(e);
return this.dragEvent = null, t;
}
},
makeDragEvent: function(e, t, n, r) {
var i = Math.abs(this.dx), s = Math.abs(this.dy), o = i > s, u = (o ? s / i : i / s) < .414, a = {
type: e,
dx: this.dx,
dy: this.dy,
ddx: this.dx - this.lastDx,
ddy: this.dy - this.lastDy,
xDirection: this.xDirection,
yDirection: this.yDirection,
pageX: n.pageX,
pageY: n.pageY,
clientX: n.clientX,
clientY: n.clientY,
horizontal: o,
vertical: !o,
lockable: u,
target: t,
dragInfo: r,
ctrlKey: n.ctrlKey,
altKey: n.altKey,
metaKey: n.metaKey,
shiftKey: n.shiftKey,
srcEvent: n.srcEvent
};
return enyo.platform.ie == 8 && a.target && (a.pageX = a.clientX + a.target.scrollLeft, a.pageY = a.clientY + a.target.scrollTop), a.preventDefault = enyo.gesture.preventDefault, a.disablePrevention = enyo.gesture.disablePrevention, a;
},
sendDragStart: function(e) {
this.dragEvent = this.makeDragEvent("dragstart", this.target, e), enyo.dispatch(this.dragEvent);
},
sendDrag: function(e) {
var t = this.makeDragEvent("dragover", e.target, e, this.dragEvent.dragInfo);
enyo.dispatch(t), t.type = "drag", t.target = this.dragEvent.target, enyo.dispatch(t);
},
sendDragFinish: function(e) {
var t = this.makeDragEvent("dragfinish", this.dragEvent.target, e, this.dragEvent.dragInfo);
t.preventTap = function() {
e.preventTap && e.preventTap();
}, enyo.dispatch(t);
},
sendDragOut: function(e) {
var t = this.makeDragEvent("dragout", e.target, e, this.dragEvent.dragInfo);
enyo.dispatch(t);
},
sendDrop: function(e) {
var t = this.makeDragEvent("drop", e.target, e, this.dragEvent.dragInfo);
t.preventTap = function() {
e.preventTap && e.preventTap();
}, enyo.dispatch(t);
},
startTracking: function(e) {
this.tracking = !0, this.px0 = e.clientX, this.py0 = e.clientY, this.flickInfo = {
startEvent: e,
moves: []
}, this.track(e);
},
track: function(e) {
this.lastDx = this.dx, this.lastDy = this.dy, this.dx = e.clientX - this.px0, this.dy = e.clientY - this.py0, this.xDirection = this.calcDirection(this.dx - this.lastDx, 0), this.yDirection = this.calcDirection(this.dy - this.lastDy, 0);
var t = this.flickInfo;
t.moves.push({
x: e.clientX,
y: e.clientY,
t: enyo.now()
}), t.moves.length > this.trackCount && t.moves.shift();
},
endTracking: function(e) {
this.tracking = !1;
var t = this.flickInfo, n = t && t.moves;
if (n && n.length > 1) {
var r = n[n.length - 1], i = enyo.now();
for (var s = n.length - 2, o = 0, u = 0, a = 0, f = 0, l = 0, c = 0, h = 0, p; p = n[s]; s--) {
o = i - p.t, u = (r.x - p.x) / o, a = (r.y - p.y) / o, c = c || (u < 0 ? -1 : u > 0 ? 1 : 0), h = h || (a < 0 ? -1 : a > 0 ? 1 : 0);
if (u * c > f * c || a * h > l * h) f = u, l = a;
}
var d = Math.sqrt(f * f + l * l);
d > this.minFlick && this.sendFlick(t.startEvent, f, l, d);
}
this.flickInfo = null;
},
calcDirection: function(e, t) {
return e > 0 ? 1 : e < 0 ? -1 : t;
},
beginHold: function(e) {
this.holdStart = enyo.now(), this.holdJob = setInterval(enyo.bind(this, "sendHoldPulse", e), this.holdPulseDelay);
},
cancelHold: function() {
clearInterval(this.holdJob), this.holdJob = null, this.sentHold && (this.sentHold = !1, this.sendRelease(this.holdEvent));
},
sendHoldPulse: function(e) {
this.sentHold || (this.sentHold = !0, this.sendHold(e));
var t = enyo.gesture.makeEvent("holdpulse", e);
t.holdTime = enyo.now() - this.holdStart, enyo.dispatch(t);
},
sendHold: function(e) {
this.holdEvent = e;
var t = enyo.gesture.makeEvent("hold", e);
enyo.dispatch(t);
},
sendRelease: function(e) {
var t = enyo.gesture.makeEvent("release", e);
enyo.dispatch(t);
},
sendFlick: function(e, t, n, r) {
var i = enyo.gesture.makeEvent("flick", e);
i.xVelocity = t, i.yVelocity = n, i.velocity = r, enyo.dispatch(i);
}
};

// transition.js

enyo.dom.transition = enyo.platform.ios || enyo.platform.android || enyo.platform.chrome || enyo.platform.androidChrome || enyo.platform.safari ? "-webkit-transition" : enyo.platform.firefox || enyo.platform.firefoxOS || enyo.platform.androidFirefox ? "-moz-transition" : "transition";

// touch.js

enyo.requiresWindow(function() {
var e = enyo.gesture, t = e.events;
e.events.touchstart = function(t) {
e.events = n, e.events.touchstart(t);
};
var n = {
_touchCount: 0,
touchstart: function(t) {
this._touchCount += t.changedTouches.length, this.excludedTarget = null;
var n = this.makeEvent(t);
e.down(n), n = this.makeEvent(t), this.overEvent = n, e.over(n);
},
touchmove: function(t) {
enyo.job.stop("resetGestureEvents");
var n = e.drag.dragEvent;
this.excludedTarget = n && n.dragInfo && n.dragInfo.node;
var r = this.makeEvent(t);
e.move(r), enyo.bodyIsFitting && t.preventDefault(), this.overEvent && this.overEvent.target != r.target && (this.overEvent.relatedTarget = r.target, r.relatedTarget = this.overEvent.target, e.out(this.overEvent), e.over(r)), this.overEvent = r;
},
touchend: function(t) {
e.up(this.makeEvent(t)), e.out(this.overEvent), this._touchCount -= t.changedTouches.length;
},
mouseup: function(n) {
this._touchCount === 0 && (this.sawMousedown = !1, e.events = t);
},
makeEvent: function(e) {
var t = enyo.clone(e.changedTouches[0]);
return t.srcEvent = e, t.target = this.findTarget(t), t.which = 1, t;
},
calcNodeOffset: function(e) {
if (e.getBoundingClientRect) {
var t = e.getBoundingClientRect();
return {
left: t.left,
top: t.top,
width: t.width,
height: t.height
};
}
},
findTarget: function(e) {
return document.elementFromPoint(e.clientX, e.clientY);
},
findTargetTraverse: function(e, t, n) {
var r = e || document.body, i = this.calcNodeOffset(r);
if (i && r != this.excludedTarget) {
var s = t - i.left, o = n - i.top;
if (s > 0 && o > 0 && s <= i.width && o <= i.height) {
var u;
for (var a = r.childNodes, f = a.length - 1, l; l = a[f]; f--) {
u = this.findTargetTraverse(l, t, n);
if (u) return u;
}
return r;
}
}
},
connect: function() {
enyo.forEach([ "ontouchstart", "ontouchmove", "ontouchend", "ongesturestart", "ongesturechange", "ongestureend" ], function(e) {
document[e] = enyo.dispatch;
}), enyo.platform.androidChrome <= 18 || enyo.platform.silk === 2 ? this.findTarget = function(e) {
return document.elementFromPoint(e.screenX, e.screenY);
} : document.elementFromPoint || (this.findTarget = function(e) {
return this.findTargetTraverse(null, e.clientX, e.clientY);
});
}
};
n.connect();
});

// msevents.js

(function() {
var e;
window.navigator.pointerEnabled ? e = [ "pointerdown", "pointerup", "pointermove", "pointerover", "pointerout", "pointercancel" ] : window.navigator.msPointerEnabled && (e = [ "MSPointerDown", "MSPointerUp", "MSPointerMove", "MSPointerOver", "MSPointerOut", "MSPointerCancel" ]);
if (e) {
var t = function(e) {
var t = enyo.clone(e);
return t.srcEvent = e, t.which = e.buttons, t;
}, n = enyo.gesture;
enyo.gesture.events = {};
var r = {
pointerdown: function(e) {
var r = t(e);
n.down(r);
},
pointerup: function(e) {
var r = t(e);
n.up(r);
},
pointermove: function(e) {
var r = t(e);
n.move(r);
},
pointercancel: function(e) {
var r = t(e);
n.up(r);
},
pointerover: function(e) {
var r = t(e);
n.over(r);
},
pointerout: function(e) {
var r = t(e);
n.out(r);
}
};
!window.navigator.pointerEnabled && window.navigator.msPointerEnabled && (r.MSPointerDown = r.pointerdown, r.MSPointerUp = r.pointerup, r.MSPointerMove = r.pointermove, r.MSPointerCancel = r.pointercancel, r.MSPointerOver = r.pointerover, r.MSPointerOut = r.pointerout), enyo.forEach(e, function(e) {
enyo.dispatcher.listen(document, e);
}), enyo.dispatcher.features.push(function(e) {
r[e.type] && e.isPrimary && r[e.type](e);
});
}
})();

// gesture.js

(function() {
!enyo.platform.gesture && enyo.platform.touch && enyo.dispatcher.features.push(function(n) {
e[n.type] && t[n.type](n);
});
var e = {
touchstart: !0,
touchmove: !0,
touchend: !0
}, t = {
orderedTouches: [],
gesture: null,
touchstart: function(e) {
enyo.forEach(e.changedTouches, function(e) {
var t = e.identifier;
enyo.indexOf(t, this.orderedTouches) < 0 && this.orderedTouches.push(t);
}, this);
if (e.touches.length >= 2 && !this.gesture) {
var t = this.gesturePositions(e);
this.gesture = this.gestureVector(t), this.gesture.angle = this.gestureAngle(t), this.gesture.scale = 1, this.gesture.rotation = 0;
var n = this.makeGesture("gesturestart", e, {
vector: this.gesture,
scale: 1,
rotation: 0
});
enyo.dispatch(n);
}
},
touchend: function(e) {
enyo.forEach(e.changedTouches, function(e) {
enyo.remove(e.identifier, this.orderedTouches);
}, this);
if (e.touches.length <= 1 && this.gesture) {
var t = e.touches[0] || e.changedTouches[e.changedTouches.length - 1];
enyo.dispatch(this.makeGesture("gestureend", e, {
vector: {
xcenter: t.pageX,
ycenter: t.pageY
},
scale: this.gesture.scale,
rotation: this.gesture.rotation
})), this.gesture = null;
}
},
touchmove: function(e) {
if (this.gesture) {
var t = this.makeGesture("gesturechange", e);
this.gesture.scale = t.scale, this.gesture.rotation = t.rotation, enyo.dispatch(t);
}
},
findIdentifiedTouch: function(e, t) {
for (var n = 0, r; r = e[n]; n++) if (r.identifier === t) return r;
},
gesturePositions: function(e) {
var t = this.findIdentifiedTouch(e.touches, this.orderedTouches[0]), n = this.findIdentifiedTouch(e.touches, this.orderedTouches[this.orderedTouches.length - 1]), r = t.pageX, i = n.pageX, s = t.pageY, o = n.pageY, u = i - r, a = o - s, f = Math.sqrt(u * u + a * a);
return {
x: u,
y: a,
h: f,
fx: r,
lx: i,
fy: s,
ly: o
};
},
gestureAngle: function(e) {
var t = e, n = Math.asin(t.y / t.h) * (180 / Math.PI);
return t.x < 0 && (n = 180 - n), t.x > 0 && t.y < 0 && (n += 360), n;
},
gestureVector: function(e) {
var t = e;
return {
magnitude: t.h,
xcenter: Math.abs(Math.round(t.fx + t.x / 2)),
ycenter: Math.abs(Math.round(t.fy + t.y / 2))
};
},
makeGesture: function(e, t, n) {
var r, i, s;
if (n) r = n.vector, i = n.scale, s = n.rotation; else {
var o = this.gesturePositions(t);
r = this.gestureVector(o), i = r.magnitude / this.gesture.magnitude, s = (360 + this.gestureAngle(o) - this.gesture.angle) % 360;
}
var u = enyo.clone(t);
return enyo.mixin(u, {
type: e,
scale: i,
pageX: r.xcenter,
pageY: r.ycenter,
rotation: s
});
}
};
})();

// ScrollMath.js

enyo.kind({
name: "enyo.ScrollMath",
kind: enyo.Component,
published: {
vertical: !0,
horizontal: !0
},
events: {
onScrollStart: "",
onScroll: "",
onScrollStop: ""
},
kSpringDamping: .93,
kDragDamping: .5,
kFrictionDamping: .97,
kSnapFriction: .9,
kFlickScalar: 15,
kMaxFlick: enyo.platform.android > 2 ? 2 : 1e9,
kFrictionEpsilon: .01,
topBoundary: 0,
rightBoundary: 0,
bottomBoundary: 0,
leftBoundary: 0,
interval: 20,
fixedTime: !0,
x0: 0,
x: 0,
y0: 0,
y: 0,
destroy: function() {
this.stop(), this.inherited(arguments);
},
verlet: function(e) {
var t = this.x;
this.x += t - this.x0, this.x0 = t;
var n = this.y;
this.y += n - this.y0, this.y0 = n;
},
damping: function(e, t, n, r) {
var i = .5, s = e - t;
return Math.abs(s) < i ? t : e * r > t * r ? n * s + t : e;
},
boundaryDamping: function(e, t, n, r) {
return this.damping(this.damping(e, t, r, 1), n, r, -1);
},
constrain: function() {
var e = this.boundaryDamping(this.y, this.topBoundary, this.bottomBoundary, this.kSpringDamping);
e != this.y && (this.y0 = e - (this.y - this.y0) * this.kSnapFriction, this.y = e);
var t = this.boundaryDamping(this.x, this.leftBoundary, this.rightBoundary, this.kSpringDamping);
t != this.x && (this.x0 = t - (this.x - this.x0) * this.kSnapFriction, this.x = t);
},
friction: function(e, t, n) {
var r = this[e] - this[t], i = Math.abs(r) > this.kFrictionEpsilon ? n : 0;
this[e] = this[t] + i * r;
},
frame: 10,
simulate: function(e) {
while (e >= this.frame) e -= this.frame, this.dragging || this.constrain(), this.verlet(), this.friction("y", "y0", this.kFrictionDamping), this.friction("x", "x0", this.kFrictionDamping);
return e;
},
animate: function() {
this.stop();
var e = enyo.now(), t = 0, n, r, i = enyo.bind(this, function() {
var s = enyo.now();
this.job = enyo.requestAnimationFrame(i);
var o = s - e;
e = s, this.dragging && (this.y0 = this.y = this.uy, this.x0 = this.x = this.ux), t += Math.max(16, o), this.fixedTime && !this.isInOverScroll() && (t = this.interval), t = this.simulate(t), r != this.y || n != this.x ? this.scroll() : this.dragging || (this.stop(!0), this.scroll()), r = this.y, n = this.x;
});
this.job = enyo.requestAnimationFrame(i);
},
start: function() {
this.job || (this.animate(), this.doScrollStart());
},
stop: function(e) {
this.job = enyo.cancelRequestAnimationFrame(this.job), e && this.doScrollStop();
},
stabilize: function() {
this.start();
var e = Math.min(this.topBoundary, Math.max(this.bottomBoundary, this.y)), t = Math.min(this.leftBoundary, Math.max(this.rightBoundary, this.x));
this.y = this.y0 = e, this.x = this.x0 = t, this.scroll(), this.stop(!0);
},
startDrag: function(e) {
this.dragging = !0, this.my = e.pageY, this.py = this.uy = this.y, this.mx = e.pageX, this.px = this.ux = this.x;
},
drag: function(e) {
if (this.dragging) {
var t = this.vertical ? e.pageY - this.my : 0;
this.uy = t + this.py, this.uy = this.boundaryDamping(this.uy, this.topBoundary, this.bottomBoundary, this.kDragDamping);
var n = this.horizontal ? e.pageX - this.mx : 0;
return this.ux = n + this.px, this.ux = this.boundaryDamping(this.ux, this.leftBoundary, this.rightBoundary, this.kDragDamping), this.start(), !0;
}
},
dragDrop: function(e) {
if (this.dragging && !window.PalmSystem) {
var t = .5;
this.y = this.uy, this.y0 = this.y - (this.y - this.y0) * t, this.x = this.ux, this.x0 = this.x - (this.x - this.x0) * t;
}
this.dragFinish();
},
dragFinish: function() {
this.dragging = !1;
},
flick: function(e) {
var t;
this.vertical && (t = e.yVelocity > 0 ? Math.min(this.kMaxFlick, e.yVelocity) : Math.max(-this.kMaxFlick, e.yVelocity), this.y = this.y0 + t * this.kFlickScalar), this.horizontal && (t = e.xVelocity > 0 ? Math.min(this.kMaxFlick, e.xVelocity) : Math.max(-this.kMaxFlick, e.xVelocity), this.x = this.x0 + t * this.kFlickScalar), this.start();
},
mousewheel: function(e) {
var t = this.vertical ? e.wheelDeltaY || e.wheelDelta : 0;
if (t > 0 && this.y < this.topBoundary || t < 0 && this.y > this.bottomBoundary) return this.stop(!0), this.y = this.y0 = this.y0 + t, this.start(), !0;
},
scroll: function() {
this.doScroll();
},
scrollTo: function(e, t) {
t !== null && (this.y = this.y0 - (t + this.y0) * (1 - this.kFrictionDamping)), e !== null && (this.x = this.x0 - (e + this.x0) * (1 - this.kFrictionDamping)), this.start();
},
setScrollX: function(e) {
this.x = this.x0 = e;
},
setScrollY: function(e) {
this.y = this.y0 = e;
},
setScrollPosition: function(e) {
this.setScrollY(e);
},
isScrolling: function() {
return Boolean(this.job);
},
isInOverScroll: function() {
return this.job && (this.x > this.leftBoundary || this.x < this.rightBoundary || this.y > this.topBoundary || this.y < this.bottomBoundary);
}
});

// ScrollStrategy.js

enyo.kind({
name: "enyo.ScrollStrategy",
tag: null,
published: {
vertical: "default",
horizontal: "default",
scrollLeft: 0,
scrollTop: 0,
maxHeight: null
},
handlers: {
ondragstart: "dragstart",
ondragfinish: "dragfinish",
ondown: "down",
onmove: "move"
},
create: function() {
this.inherited(arguments), this.horizontalChanged(), this.verticalChanged(), this.maxHeightChanged();
},
rendered: function() {
this.inherited(arguments), enyo.makeBubble(this.container, "scroll"), this.scrollNode = this.calcScrollNode();
},
teardownRender: function() {
this.inherited(arguments), this.scrollNode = null;
},
calcScrollNode: function() {
return this.container.hasNode();
},
horizontalChanged: function() {
this.container.applyStyle("overflow-x", this.horizontal == "default" ? "auto" : this.horizontal);
},
verticalChanged: function() {
this.container.applyStyle("overflow-y", this.vertical == "default" ? "auto" : this.vertical);
},
maxHeightChanged: function() {
this.container.applyStyle("max-height", this.maxHeight);
},
scrollTo: function(e, t) {
this.scrollNode && (this.setScrollLeft(e), this.setScrollTop(t));
},
scrollToNode: function(e, t) {
if (this.scrollNode) {
var n = this.getScrollBounds(), r = e, i = {
height: r.offsetHeight,
width: r.offsetWidth,
top: 0,
left: 0
};
while (r && r.parentNode && r.id != this.scrollNode.id) i.top += r.offsetTop, i.left += r.offsetLeft, r = r.parentNode;
this.setScrollTop(Math.min(n.maxTop, t === !1 ? i.top - n.clientHeight + i.height : i.top)), this.setScrollLeft(Math.min(n.maxLeft, t === !1 ? i.left - n.clientWidth + i.width : i.left));
}
},
scrollIntoView: function(e, t) {
e.hasNode() && e.node.scrollIntoView(t);
},
isInView: function(e) {
var t = this.getScrollBounds(), n = e.offsetTop, r = e.offsetHeight, i = e.offsetLeft, s = e.offsetWidth;
return n >= t.top && n + r <= t.top + t.clientHeight && i >= t.left && i + s <= t.left + t.clientWidth;
},
setScrollTop: function(e) {
this.scrollTop = e, this.scrollNode && (this.scrollNode.scrollTop = this.scrollTop);
},
setScrollLeft: function(e) {
this.scrollLeft = e, this.scrollNode && (this.scrollNode.scrollLeft = this.scrollLeft);
},
getScrollLeft: function() {
return this.scrollNode ? this.scrollNode.scrollLeft : this.scrollLeft;
},
getScrollTop: function() {
return this.scrollNode ? this.scrollNode.scrollTop : this.scrollTop;
},
_getScrollBounds: function() {
var e = this.getScrollSize(), t = this.container.hasNode(), n = {
left: this.getScrollLeft(),
top: this.getScrollTop(),
clientHeight: t ? t.clientHeight : 0,
clientWidth: t ? t.clientWidth : 0,
height: e.height,
width: e.width
};
return n.maxLeft = Math.max(0, n.width - n.clientWidth), n.maxTop = Math.max(0, n.height - n.clientHeight), n;
},
getScrollSize: function() {
var e = this.scrollNode;
return {
width: e ? e.scrollWidth : 0,
height: e ? e.scrollHeight : 0
};
},
getScrollBounds: function() {
return this._getScrollBounds();
},
calcStartInfo: function() {
var e = this.getScrollBounds(), t = this.getScrollTop(), n = this.getScrollLeft();
this.canVertical = e.maxTop > 0 && this.vertical != "hidden", this.canHorizontal = e.maxLeft > 0 && this.horizontal != "hidden", this.startEdges = {
top: t === 0,
bottom: t === e.maxTop,
left: n === 0,
right: n === e.maxLeft
};
},
shouldDrag: function(e) {
var t = e.vertical;
return t && this.canVertical || !t && this.canHorizontal;
},
dragstart: function(e, t) {
this.dragging = this.shouldDrag(t);
if (this.dragging) return this.preventDragPropagation;
},
dragfinish: function(e, t) {
this.dragging && (this.dragging = !1, t.preventTap());
},
down: function(e, t) {
this.calcStartInfo();
},
move: function(e, t) {
t.which && (this.canVertical && t.vertical || this.canHorizontal && t.horizontal) && t.disablePrevention();
}
});

// Thumb.js

enyo.kind({
name: "enyo.ScrollThumb",
axis: "v",
minSize: 4,
cornerSize: 6,
classes: "enyo-thumb",
create: function() {
this.inherited(arguments);
var e = this.axis == "v";
this.dimension = e ? "height" : "width", this.offset = e ? "top" : "left", this.translation = e ? "translateY" : "translateX", this.positionMethod = e ? "getScrollTop" : "getScrollLeft", this.sizeDimension = e ? "clientHeight" : "clientWidth", this.addClass("enyo-" + this.axis + "thumb"), this.transform = enyo.dom.canTransform(), enyo.dom.canAccelerate() && enyo.dom.transformValue(this, "translateZ", 0);
},
sync: function(e) {
this.scrollBounds = e._getScrollBounds(), this.update(e);
},
update: function(e) {
if (this.showing) {
var t = this.dimension, n = this.offset, r = this.scrollBounds[this.sizeDimension], i = this.scrollBounds[t], s = 0, o = 0, u = 0;
if (r >= i) {
this.hide();
return;
}
e.isOverscrolling() && (u = e.getOverScrollBounds()["over" + n], s = Math.abs(u), o = Math.max(u, 0));
var a = e[this.positionMethod]() - u, f = r - this.cornerSize, l = Math.floor(r * r / i - s);
l = Math.max(this.minSize, l);
var c = Math.floor(f * a / i + o);
c = Math.max(0, Math.min(f - this.minSize, c)), this.needed = l < r, this.needed && this.hasNode() ? (this._pos !== c && (this._pos = c, this.transform ? enyo.dom.transformValue(this, this.translation, c + "px") : this.axis == "v" ? this.setBounds({
top: c + "px"
}) : this.setBounds({
left: c + "px"
})), this._size !== l && (this._size = l, this.node.style[t] = this.domStyles[t] = l + "px")) : this.hide();
}
},
setShowing: function(e) {
if (e && e != this.showing && this.scrollBounds[this.sizeDimension] >= this.scrollBounds[this.dimension]) return;
this.hasNode() && this.cancelDelayHide();
if (e != this.showing) {
var t = this.showing;
this.showing = e, this.showingChanged(t);
}
},
delayHide: function(e) {
this.showing && enyo.job(this.id + "hide", enyo.bind(this, "hide"), e || 0);
},
cancelDelayHide: function() {
enyo.job.stop(this.id + "hide");
}
});

// TouchScrollStrategy.js

enyo.kind({
name: "enyo.TouchScrollStrategy",
kind: "ScrollStrategy",
overscroll: !0,
preventDragPropagation: !0,
published: {
vertical: "default",
horizontal: "default",
thumb: !0,
scrim: !1,
dragDuringGesture: !0
},
events: {
onShouldDrag: ""
},
handlers: {
onscroll: "domScroll",
onflick: "flick",
onhold: "hold",
ondragstart: "dragstart",
onShouldDrag: "shouldDrag",
ondrag: "drag",
ondragfinish: "dragfinish",
onmousewheel: "mousewheel"
},
tools: [ {
kind: "ScrollMath",
onScrollStart: "scrollMathStart",
onScroll: "scrollMathScroll",
onScrollStop: "scrollMathStop"
}, {
name: "vthumb",
kind: "ScrollThumb",
axis: "v",
showing: !1
}, {
name: "hthumb",
kind: "ScrollThumb",
axis: "h",
showing: !1
} ],
scrimTools: [ {
name: "scrim",
classes: "enyo-fit",
style: "z-index: 1;",
showing: !1
} ],
components: [ {
name: "client",
classes: "enyo-touch-scroller"
} ],
listReordering: !1,
create: function() {
this.inherited(arguments), this.transform = enyo.dom.canTransform(), this.transform || this.overscroll && this.$.client.applyStyle("position", "relative"), this.accel = enyo.dom.canAccelerate();
var e = "enyo-touch-strategy-container";
enyo.platform.ios && this.accel && (e += " enyo-composite"), this.scrimChanged(), this.container.addClass(e), this.translation = this.accel ? "translate3d" : "translate";
},
initComponents: function() {
this.createChrome(this.tools), this.inherited(arguments);
},
destroy: function() {
this.container.removeClass("enyo-touch-strategy-container"), this.inherited(arguments);
},
rendered: function() {
this.inherited(arguments), enyo.makeBubble(this.$.client, "scroll"), this.calcBoundaries(), this.syncScrollMath(), this.thumb && this.alertThumbs();
},
scrimChanged: function() {
this.scrim && !this.$.scrim && this.makeScrim(), !this.scrim && this.$.scrim && this.$.scrim.destroy();
},
makeScrim: function() {
var e = this.controlParent;
this.controlParent = null, this.createChrome(this.scrimTools), this.controlParent = e;
var t = this.container.hasNode();
t && (this.$.scrim.parentNode = t, this.$.scrim.render());
},
isScrolling: function() {
var e = this.$.scrollMath;
return e ? e.isScrolling() : this.scrolling;
},
isOverscrolling: function() {
var e = this.$.scrollMath || this;
return this.overscroll ? e.isInOverScroll() : !1;
},
domScroll: function() {
this.isScrolling() || (this.calcBoundaries(), this.syncScrollMath(), this.thumb && this.alertThumbs());
},
horizontalChanged: function() {
this.$.scrollMath.horizontal = this.horizontal != "hidden";
},
verticalChanged: function() {
this.$.scrollMath.vertical = this.vertical != "hidden";
},
maxHeightChanged: function() {
this.$.client.applyStyle("max-height", this.maxHeight), this.$.client.addRemoveClass("enyo-scrollee-fit", !this.maxHeight);
},
thumbChanged: function() {
this.hideThumbs();
},
stop: function() {
this.isScrolling() && this.$.scrollMath.stop(!0);
},
stabilize: function() {
this.$.scrollMath && this.$.scrollMath.stabilize();
},
scrollTo: function(e, t) {
this.stop(), this.$.scrollMath.scrollTo(e, t || t === 0 ? t : null);
},
scrollIntoView: function() {
this.stop(), this.inherited(arguments);
},
setScrollLeft: function() {
this.stop(), this.inherited(arguments);
},
setScrollTop: function() {
this.stop(), this.inherited(arguments);
},
getScrollLeft: function() {
return this.isScrolling() ? this.scrollLeft : this.inherited(arguments);
},
getScrollTop: function() {
return this.isScrolling() ? this.scrollTop : this.inherited(arguments);
},
calcScrollNode: function() {
return this.$.client.hasNode();
},
calcAutoScrolling: function() {
var e = this.vertical == "auto", t = this.horizontal == "auto" || this.horizontal == "default";
if ((e || t) && this.scrollNode) {
var n = this.getScrollBounds();
e && (this.$.scrollMath.vertical = n.height > n.clientHeight), t && (this.$.scrollMath.horizontal = n.width > n.clientWidth);
}
},
shouldDrag: function(e, t) {
this.calcAutoScrolling();
var n = t.vertical, r = this.$.scrollMath.horizontal && !n, i = this.$.scrollMath.vertical && n, s = t.dy < 0, o = t.dx < 0, u = !s && this.startEdges.top || s && this.startEdges.bottom, a = !o && this.startEdges.left || o && this.startEdges.right;
!t.boundaryDragger && (r || i) && (t.boundaryDragger = this);
if (!u && i || !a && r) return t.dragger = this, !0;
},
flick: function(e, t) {
var n = Math.abs(t.xVelocity) > Math.abs(t.yVelocity) ? this.$.scrollMath.horizontal : this.$.scrollMath.vertical;
if (n && this.dragging) return this.$.scrollMath.flick(t), this.preventDragPropagation;
},
hold: function(e, t) {
if (this.isScrolling() && !this.isOverscrolling()) {
var n = this.$.scrollMath || this;
return n.stop(t), !0;
}
},
move: function(e, t) {},
dragstart: function(e, t) {
if (!this.dragDuringGesture && t.srcEvent.touches && t.srcEvent.touches.length > 1) return !0;
this.doShouldDrag(t), this.dragging = t.dragger == this || !t.dragger && t.boundaryDragger == this;
if (this.dragging) {
t.preventDefault(), this.syncScrollMath(), this.$.scrollMath.startDrag(t);
if (this.preventDragPropagation) return !0;
}
},
drag: function(e, t) {
if (this.listReordering) return !1;
this.dragging && (t.preventDefault(), this.$.scrollMath.drag(t), this.scrim && this.$.scrim.show());
},
dragfinish: function(e, t) {
this.dragging && (t.preventTap(), this.$.scrollMath.dragFinish(), this.dragging = !1, this.scrim && this.$.scrim.hide());
},
mousewheel: function(e, t) {
if (!this.dragging) {
this.calcBoundaries(), this.syncScrollMath(), this.stabilize();
if (this.$.scrollMath.mousewheel(t)) return t.preventDefault(), !0;
}
},
scrollMathStart: function(e) {
this.scrollNode && (this.calcBoundaries(), this.thumb && this.showThumbs());
},
scrollMathScroll: function(e) {
this.overscroll ? this.effectScroll(-e.x, -e.y) : this.effectScroll(-Math.min(e.leftBoundary, Math.max(e.rightBoundary, e.x)), -Math.min(e.topBoundary, Math.max(e.bottomBoundary, e.y))), this.thumb && this.updateThumbs();
},
scrollMathStop: function(e) {
this.effectScrollStop(), this.thumb && this.delayHideThumbs(100);
},
calcBoundaries: function() {
var e = this.$.scrollMath || this, t = this._getScrollBounds();
e.bottomBoundary = t.clientHeight - t.height, e.rightBoundary = t.clientWidth - t.width;
},
syncScrollMath: function() {
var e = this.$.scrollMath;
e && (e.setScrollX(-this.getScrollLeft()), e.setScrollY(-this.getScrollTop()));
},
effectScroll: function(e, t) {
this.scrollNode && (this.scrollLeft = this.scrollNode.scrollLeft = e, this.scrollTop = this.scrollNode.scrollTop = t, this.effectOverscroll(Math.round(e), Math.round(t)));
},
effectScrollStop: function() {
this.effectOverscroll(null, null);
},
effectOverscroll: function(e, t) {
var n = this.scrollNode, r = "0", i = "0", s = this.accel ? ",0" : "";
t !== null && Math.abs(t - n.scrollTop) > 1 && (i = n.scrollTop - t), e !== null && Math.abs(e - n.scrollLeft) > 1 && (r = n.scrollLeft - e), this.transform ? enyo.dom.transformValue(this.$.client, this.translation, r + "px, " + i + "px" + s) : this.$.client.setBounds({
left: r + "px",
top: i + "px"
});
},
getOverScrollBounds: function() {
var e = this.$.scrollMath || this;
return {
overleft: Math.min(e.leftBoundary - e.x, 0) || Math.max(e.rightBoundary - e.x, 0),
overtop: Math.min(e.topBoundary - e.y, 0) || Math.max(e.bottomBoundary - e.y, 0)
};
},
_getScrollBounds: function() {
var e = this.inherited(arguments);
return enyo.mixin(e, this.getOverScrollBounds()), e;
},
getScrollBounds: function() {
return this.stop(), this.inherited(arguments);
},
alertThumbs: function() {
this.showThumbs(), this.delayHideThumbs(500);
},
syncThumbs: function() {
this.$.vthumb.sync(this), this.$.hthumb.sync(this);
},
updateThumbs: function() {
this.$.vthumb.update(this), this.$.hthumb.update(this);
},
showThumbs: function() {
this.syncThumbs(), this.horizontal != "hidden" && this.$.hthumb.show(), this.vertical != "hidden" && this.$.vthumb.show();
},
hideThumbs: function() {
this.$.vthumb.hide(), this.$.hthumb.hide();
},
delayHideThumbs: function(e) {
this.$.vthumb.delayHide(e), this.$.hthumb.delayHide(e);
}
});

// TranslateScrollStrategy.js

enyo.kind({
name: "enyo.TranslateScrollStrategy",
kind: "TouchScrollStrategy",
translateOptimized: !1,
components: [ {
name: "clientContainer",
classes: "enyo-touch-scroller",
components: [ {
name: "client"
} ]
} ],
rendered: function() {
this.inherited(arguments), enyo.makeBubble(this.$.clientContainer, "scroll");
},
getScrollSize: function() {
var e = this.$.client.hasNode();
return {
width: e ? e.scrollWidth : 0,
height: e ? e.scrollHeight : 0
};
},
create: function() {
this.inherited(arguments), enyo.dom.transformValue(this.$.client, this.translation, "0,0,0");
},
calcScrollNode: function() {
return this.$.clientContainer.hasNode();
},
maxHeightChanged: function() {
this.$.client.applyStyle("min-height", this.maxHeight ? null : "100%"), this.$.client.applyStyle("max-height", this.maxHeight), this.$.clientContainer.addRemoveClass("enyo-scrollee-fit", !this.maxHeight);
},
shouldDrag: function(e, t) {
return this.stop(), this.calcStartInfo(), this.inherited(arguments);
},
syncScrollMath: function() {
this.translateOptimized || this.inherited(arguments);
},
setScrollLeft: function(e) {
this.stop();
if (this.translateOptimized) {
var t = this.$.scrollMath;
t.setScrollX(-e), t.stabilize();
} else this.inherited(arguments);
},
setScrollTop: function(e) {
this.stop();
if (this.translateOptimized) {
var t = this.$.scrollMath;
t.setScrollY(-e), t.stabilize();
} else this.inherited(arguments);
},
getScrollLeft: function() {
return this.translateOptimized ? this.scrollLeft : this.inherited(arguments);
},
getScrollTop: function() {
return this.translateOptimized ? this.scrollTop : this.inherited(arguments);
},
scrollMathStart: function(e) {
this.inherited(arguments), this.scrollStarting = !0, this.startX = 0, this.startY = 0, !this.translateOptimized && this.scrollNode && (this.startX = this.getScrollLeft(), this.startY = this.getScrollTop());
},
scrollMathScroll: function(e) {
this.overscroll ? (this.scrollLeft = -e.x, this.scrollTop = -e.y) : (this.scrollLeft = -Math.min(e.leftBoundary, Math.max(e.rightBoundary, e.x)), this.scrollTop = -Math.min(e.topBoundary, Math.max(e.bottomBoundary, e.y))), this.isScrolling() && (this.$.scrollMath.isScrolling() && this.effectScroll(this.startX - this.scrollLeft, this.startY - this.scrollTop), this.thumb && this.updateThumbs());
},
effectScroll: function(e, t) {
var n = e + "px, " + t + "px" + (this.accel ? ",0" : "");
enyo.dom.transformValue(this.$.client, this.translation, n);
},
effectScrollStop: function() {
if (!this.translateOptimized) {
var e = "0,0" + (this.accel ? ",0" : ""), t = this.$.scrollMath, n = this._getScrollBounds(), r = Boolean(n.maxTop + t.bottomBoundary || n.maxLeft + t.rightBoundary);
enyo.dom.transformValue(this.$.client, this.translation, r ? null : e), this.setScrollLeft(this.scrollLeft), this.setScrollTop(this.scrollTop), r && enyo.dom.transformValue(this.$.client, this.translation, e);
}
},
twiddle: function() {
this.translateOptimized && this.scrollNode && (this.scrollNode.scrollTop = 1, this.scrollNode.scrollTop = 0);
},
down: enyo.nop
});

// TransitionScrollStrategy.js

enyo.kind({
name: "enyo.TransitionScrollStrategy",
kind: "enyo.TouchScrollStrategy",
components: [ {
name: "clientContainer",
classes: "enyo-touch-scroller",
components: [ {
name: "client"
} ]
} ],
events: {
onScrollStart: "",
onScroll: "",
onScrollStop: ""
},
handlers: {
ondown: "down",
ondragfinish: "dragfinish",
onwebkitTransitionEnd: "transitionComplete"
},
tools: [ {
name: "vthumb",
kind: "ScrollThumb",
axis: "v",
showing: !0
}, {
name: "hthumb",
kind: "ScrollThumb",
axis: "h",
showing: !1
} ],
kFlickScalar: 600,
topBoundary: 0,
rightBoundary: 0,
bottomBoundary: 0,
leftBoundary: 0,
scrolling: !1,
listener: null,
boundaryX: 0,
boundaryY: 0,
stopTimeout: null,
stopTimeoutMS: 80,
scrollInterval: null,
scrollIntervalMS: 50,
transitions: {
none: "",
scroll: "3.8s cubic-bezier(.19,1,.28,1.0) 0s",
bounce: "0.5s cubic-bezier(0.06,.5,.5,.94) 0s"
},
setScrollLeft: function(e) {
var t = this.scrollLeft;
this.stop(), this.scrollLeft = e;
if (this.isInLeftOverScroll() || this.isInRightOverScroll()) this.scrollLeft = t;
this.effectScroll();
},
setScrollTop: function(e) {
var t = this.scrollTop;
this.stop(), this.scrollTop = e;
if (this.isInTopOverScroll() || this.isInBottomOverScroll()) this.scrollTop = t;
this.effectScroll();
},
setScrollX: function(e) {
this.scrollLeft = -1 * e;
},
setScrollY: function(e) {
this.scrollTop = -1 * e;
},
getScrollLeft: function() {
return this.scrollLeft;
},
getScrollTop: function() {
return this.scrollTop;
},
create: function() {
this.inherited(arguments), enyo.dom.transformValue(this.$.client, this.translation, "0,0,0");
},
destroy: function() {
this.clearCSSTransitionInterval(), this.inherited(arguments);
},
getScrollSize: function() {
var e = this.$.client.hasNode();
return {
width: e ? e.scrollWidth : 0,
height: e ? e.scrollHeight : 0
};
},
horizontalChanged: function() {
this.horizontal == "hidden" && (this.scrollHorizontal = !1);
},
verticalChanged: function() {
this.vertical == "hidden" && (this.scrollVertical = !1);
},
calcScrollNode: function() {
return this.$.clientContainer.hasNode();
},
calcBoundaries: function() {
var e = this._getScrollBounds();
this.bottomBoundary = e.clientHeight - e.height, this.rightBoundary = e.clientWidth - e.width;
},
maxHeightChanged: function() {
this.$.client.applyStyle("min-height", this.maxHeight ? null : "100%"), this.$.client.applyStyle("max-height", this.maxHeight), this.$.clientContainer.addRemoveClass("enyo-scrollee-fit", !this.maxHeight);
},
calcAutoScrolling: function() {
var e = this.getScrollBounds();
this.vertical && (this.scrollVertical = e.height > e.clientHeight), this.horizontal && (this.scrollHorizontal = e.width > e.clientWidth);
},
isInOverScroll: function() {
return this.isInTopOverScroll() || this.isInBottomOverScroll() || this.isInLeftOverScroll() || this.isInRightOverScroll();
},
isInLeftOverScroll: function() {
return this.getScrollLeft() < this.leftBoundary;
},
isInRightOverScroll: function() {
return this.getScrollLeft <= 0 ? !1 : this.getScrollLeft() * -1 < this.rightBoundary;
},
isInTopOverScroll: function() {
return this.getScrollTop() < this.topBoundary;
},
isInBottomOverScroll: function() {
return this.getScrollTop() <= 0 ? !1 : this.getScrollTop() * -1 < this.bottomBoundary;
},
calcStartInfo: function() {
var e = this.getScrollBounds(), t = this.getScrollTop(), n = this.getScrollLeft();
this.startEdges = {
top: t === 0,
bottom: t === e.maxTop,
left: n === 0,
right: n === e.maxLeft
};
},
mousewheel: function(e, t) {
if (!this.dragging) {
this.calcBoundaries(), this.syncScrollMath(), this.stabilize();
var n = this.vertical ? t.wheelDeltaY || t.wheelDelta : 0, r = parseFloat(this.getScrollTop()) + -1 * parseFloat(n);
return r = r * -1 < this.bottomBoundary ? -1 * this.bottomBoundary : r < this.topBoundary ? this.topBoundary : r, this.setScrollTop(r), this.doScroll(), t.preventDefault(), !0;
}
},
scroll: function(e, t) {
this.thumb && this.updateThumbs(), this.calcBoundaries(), this.doScroll();
},
start: function() {
this.startScrolling(), this.doScrollStart();
},
stop: function() {
this.isScrolling() && this.stopScrolling(), this.thumb && this.delayHideThumbs(100), this.doScrollStop();
},
updateX: function() {
var e = window.getComputedStyle(this.$.client.node, null).getPropertyValue(enyo.dom.getCssTransformProp()).split("(")[1];
return e = e == undefined ? 0 : e.split(")")[0].split(",")[4], -1 * parseFloat(e) === this.scrollLeft ? !1 : (this.scrollLeft = -1 * parseFloat(e), !0);
},
updateY: function() {
var e = window.getComputedStyle(this.$.client.node, null).getPropertyValue(enyo.dom.getCssTransformProp()).split("(")[1];
return e = e == undefined ? 0 : e.split(")")[0].split(",")[5], -1 * parseFloat(e) === this.scrollTop ? !1 : (this.scrollTop = -1 * parseFloat(e), !0);
},
effectScroll: function() {
var e = -1 * this.scrollLeft + "px, " + -1 * this.scrollTop + "px" + (this.accel ? ", 0" : "");
enyo.dom.transformValue(this.$.client, this.translation, e);
},
down: function(e, t) {
var n = this;
if (this.isScrolling() && !this.isOverscrolling()) return this.stopTimeout = setTimeout(function() {
n.stop();
}, this.stopTimeoutMS), !0;
},
dragstart: function(e, t) {
this.stopTimeout && clearTimeout(this.stopTimeout);
if (!this.dragDuringGesture && t.srcEvent.touches && t.srcEvent.touches.length > 1) return !0;
this.shouldDrag(t), this.dragging = t.dragger == this || !t.dragger && t.boundaryDragger == this;
if (this.dragging) {
this.isScrolling() && this.stopScrolling(), this.thumb && this.showThumbs(), t.preventDefault(), this.prevY = t.pageY, this.prevX = t.pageX;
if (this.preventDragPropagation) return !0;
}
},
shouldDrag: function(e) {
return this.calcStartInfo(), this.calcBoundaries(), this.calcAutoScrolling(), this.scrollHorizontal ? this.scrollVertical ? this.shouldDragVertical(e) || this.shouldDragHorizontal(e) : this.shouldDragHorizontal(e) : this.shouldDragVertical(e);
},
shouldDragVertical: function(e) {
var t = this.canDragVertical(e), n = this.oobVertical(e);
!e.boundaryDragger && t && (e.boundaryDragger = this);
if (!n && t) return e.dragger = this, !0;
},
shouldDragHorizontal: function(e) {
var t = this.canDragHorizontal(e), n = this.oobHorizontal(e);
!e.boundaryDragger && t && (e.boundaryDragger = this);
if (!n && t) return e.dragger = this, !0;
},
canDragVertical: function(e) {
return this.scrollVertical && e.vertical;
},
canDragHorizontal: function(e) {
return this.scrollHorizontal && !e.vertical;
},
oobVertical: function(e) {
var t = e.dy < 0;
return !t && this.startEdges.top || t && this.startEdges.bottom;
},
oobHorizontal: function(e) {
var t = e.dx < 0;
return !t && this.startEdges.left || t && this.startEdges.right;
},
drag: function(e, t) {
if (this.listReordering) return !1;
this.dragging && (t.preventDefault(), this.scrollLeft = this.scrollHorizontal ? this.calculateDragDistance(parseInt(this.getScrollLeft(), 10), -1 * (t.pageX - this.prevX), this.leftBoundary, this.rightBoundary) : this.getScrollLeft(), this.scrollTop = this.scrollVertical ? this.calculateDragDistance(this.getScrollTop(), -1 * (t.pageY - this.prevY), this.topBoundary, this.bottomBoundary) : this.getScrollTop(), this.effectScroll(), this.scroll(), this.prevY = t.pageY, this.prevX = t.pageX, this.resetBoundaryX(), this.resetBoundaryY());
},
calculateDragDistance: function(e, t, n, r) {
var i = e + t;
return this.overscrollDragDamping(e, i, t, n, r);
},
overscrollDragDamping: function(e, t, n, r, i) {
if (t < r || t * -1 < i) n /= 2, t = e + n;
return t;
},
resetBoundaryX: function() {
this.boundaryX = 0;
},
resetBoundaryY: function() {
this.boundaryY = 0;
},
dragfinish: function(e, t) {
this.dragging && (t.preventTap(), this.dragging = !1, this.isScrolling() || this.correctOverflow(), this.scrim && this.$.scrim.hide());
},
correctOverflow: function() {
if (this.isInOverScroll()) {
var e = this.scrollHorizontal ? this.correctOverflowX() : !1, t = this.scrollVertical ? this.correctOverflowY() : !1;
e !== !1 && t !== !1 ? (this.scrollLeft = e !== !1 ? e : this.getScrollLeft(), this.scrollTop = t !== !1 ? t : this.getScrollTop(), this.startOverflowScrolling()) : e !== !1 ? (this.scrollLeft = e, this.scrollTop = this.targetScrollTop || this.scrollTop, this.targetScrollLeft = this.getScrollLeft(), this.vertical ? this.startScrolling() : this.startOverflowScrolling()) : t !== !1 && (this.scrollTop = t, this.scrollLeft = this.targetScrollLeft || this.scrollLeft, this.targetScrollTop = this.getScrollTop(), this.scrollHorizontal ? this.startScrolling() : this.startOverflowScrolling());
}
},
correctOverflowX: function() {
if (this.isInLeftOverScroll()) {
if (this.beyondBoundary(this.getScrollLeft(), this.leftBoundary, this.boundaryX)) return this.leftBoundary;
} else if (this.isInRightOverScroll() && this.beyondBoundary(this.getScrollLeft(), this.rightBoundary, this.boundaryX)) return -1 * this.rightBoundary;
return !1;
},
correctOverflowY: function() {
if (this.isInTopOverScroll()) {
if (this.beyondBoundary(this.getScrollTop(), this.topBoundary, this.boundaryY)) return this.topBoundary;
} else if (this.isInBottomOverScroll() && this.beyondBoundary(this.getScrollTop(), this.bottomBoundary, this.boundaryY)) return -1 * this.bottomBoundary;
return !1;
},
beyondBoundary: function(e, t, n) {
return Math.abs(Math.abs(t) - Math.abs(e)) > Math.abs(n);
},
flick: function(e, t) {
if (this.dragging && this.flickOnEnabledAxis(t)) return this.scrollLeft = this.scrollHorizontal ? this.calculateFlickDistance(this.scrollLeft, -1 * t.xVelocity) : this.getScrollLeft(), this.scrollTop = this.scrollVertical ? this.calculateFlickDistance(this.scrollTop, -1 * t.yVelocity) : this.getScrollTop(), this.targetScrollLeft = this.scrollLeft, this.targetScrollTop = this.scrollTop, this.boundaryX = null, this.boundaryY = null, this.isInLeftOverScroll() ? this.boundaryX = this.figureBoundary(this.getScrollLeft()) : this.isInRightOverScroll() && (this.boundaryX = this.figureBoundary(-1 * this.bottomBoundary - this.getScrollLeft())), this.isInTopOverScroll() ? this.boundaryY = this.figureBoundary(this.getScrollTop()) : this.isInBottomOverScroll() && (this.boundaryY = this.figureBoundary(-1 * this.bottomBoundary - this.getScrollTop())), this.startScrolling(), this.preventDragPropagation;
},
flickOnEnabledAxis: function(e) {
return Math.abs(e.xVelocity) > Math.abs(e.yVelocity) ? this.scrollHorizontal : this.scrollVertical;
},
calculateFlickDistance: function(e, t) {
return e + t * this.kFlickScalar;
},
startScrolling: function() {
this.applyTransition("scroll"), this.effectScroll(), this.setCSSTransitionInterval(), this.scrolling = !0;
},
startOverflowScrolling: function() {
this.applyTransition("bounce"), this.effectScroll(), this.setOverflowTransitionInterval(), this.scrolling = !0;
},
applyTransition: function(e) {
var t = this.translation + ": " + this.transitions[e];
this.$.client.applyStyle("-webkit-transition", this.transitions[e]);
},
stopScrolling: function() {
this.resetCSSTranslationVals(), this.clearCSSTransitionInterval(), this.scrolling = !1;
},
setCSSTransitionInterval: function() {
this.clearCSSTransitionInterval(), this.scrollInterval = setInterval(enyo.bind(this, function() {
this.updateScrollPosition(), this.correctOverflow();
}), this.scrollIntervalMS);
},
setOverflowTransitionInterval: function() {
this.clearCSSTransitionInterval(), this.scrollInterval = setInterval(enyo.bind(this, function() {
this.updateScrollPosition();
}), this.scrollIntervalMS);
},
updateScrollPosition: function() {
var e = this.updateY(), t = this.updateX();
this.scroll(), !e && !t && this.stop();
},
clearCSSTransitionInterval: function() {
this.scrollInterval && (clearInterval(this.scrollInterval), this.scrollInterval = null);
},
resetCSSTranslationVals: function() {
var e = enyo.dom.getCssTransformProp(), t = window.getComputedStyle(this.$.client.node, null).getPropertyValue(e).split("(")[1].split(")")[0].split(",");
this.applyTransition("none"), this.scrollLeft = -1 * t[4], this.scrollTop = -1 * t[5], this.effectScroll();
},
figureBoundary: function(e) {
var t = Math.abs(e), n = t - t / Math.pow(t, .02);
return n = e < 0 ? -1 * n : n, n;
},
transitionComplete: function(e, t) {
if (t.originator !== this.$.client) return;
var n = !1;
this.isInTopOverScroll() ? (n = !0, this.scrollTop = this.topBoundary) : this.isInBottomOverScroll() && (n = !0, this.scrollTop = -1 * this.bottomBoundary), this.isInLeftOverScroll() ? (n = !0, this.scrollLeft = this.leftBoundary) : this.isInRightOverScroll() && (n = !0, this.scrollLeft = -1 * this.rightBoundary), n ? this.startOverflowScrolling() : this.stop();
},
scrollTo: function(e, t) {
this.setScrollTop(t), this.setScrollLeft(e), this.start();
},
getOverScrollBounds: function() {
return {
overleft: Math.min(this.leftBoundary + this.scrollLeft, 0) || Math.max(this.rightBoundary + this.scrollLeft, 0),
overtop: Math.min(this.topBoundary + this.scrollTop, 0) || Math.max(this.bottomBoundary + this.scrollTop, 0)
};
}
});

// Scroller.js

enyo.kind({
name: "enyo.Scroller",
published: {
horizontal: "default",
vertical: "default",
scrollTop: 0,
scrollLeft: 0,
maxHeight: null,
touch: !1,
strategyKind: "ScrollStrategy",
thumb: !0
},
events: {
onScrollStart: "",
onScroll: "",
onScrollStop: ""
},
touchOverscroll: !0,
preventDragPropagation: !0,
preventScrollPropagation: !0,
handlers: {
onscroll: "domScroll",
onScrollStart: "scrollStart",
onScroll: "scroll",
onScrollStop: "scrollStop"
},
classes: "enyo-scroller",
statics: {
osInfo: [ {
os: "android",
version: 3
}, {
os: "androidChrome",
version: 18
}, {
os: "androidFirefox",
version: 16
}, {
os: "firefoxOS",
version: 16
}, {
os: "ios",
version: 5
}, {
os: "webos",
version: 1e9
}, {
os: "blackberry",
version: 1e9
} ],
hasTouchScrolling: function() {
for (var e = 0, t, n; t = this.osInfo[e]; e++) if (enyo.platform[t.os]) return !0;
if ((enyo.platform.ie >= 10 || enyo.platform.windowsPhone >= 8) && enyo.platform.touch) return !0;
},
hasNativeScrolling: function() {
for (var e = 0, t, n; t = this.osInfo[e]; e++) if (enyo.platform[t.os] < t.version) return !1;
return !0;
},
getTouchStrategy: function() {
return enyo.platform.android >= 3 || enyo.platform.windowsPhone === 8 ? "TranslateScrollStrategy" : "TouchScrollStrategy";
}
},
controlParentName: "strategy",
create: function() {
this.inherited(arguments), this.horizontalChanged(), this.verticalChanged();
},
importProps: function(e) {
this.inherited(arguments), e && e.strategyKind === undefined && (enyo.Scroller.touchScrolling || this.touch) && (this.strategyKind = enyo.Scroller.getTouchStrategy());
},
initComponents: function() {
this.strategyKindChanged(), this.inherited(arguments);
},
teardownChildren: function() {
this.cacheScrollPosition(), this.inherited(arguments);
},
rendered: function() {
this.inherited(arguments), this.restoreScrollPosition();
},
strategyKindChanged: function() {
this.$.strategy && (this.$.strategy.destroy(), this.controlParent = null), this.createStrategy(), this.hasNode() && this.render();
},
createStrategy: function() {
this.createComponents([ {
name: "strategy",
maxHeight: this.maxHeight,
kind: this.strategyKind,
thumb: this.thumb,
preventDragPropagation: this.preventDragPropagation,
overscroll: this.touchOverscroll,
isChrome: !0
} ]);
},
getStrategy: function() {
return this.$.strategy;
},
maxHeightChanged: function() {
this.$.strategy.setMaxHeight(this.maxHeight);
},
showingChanged: function() {
this.showing || (this.cacheScrollPosition(), this.setScrollLeft(0), this.setScrollTop(0)), this.inherited(arguments), this.showing && this.restoreScrollPosition();
},
thumbChanged: function() {
this.$.strategy.setThumb(this.thumb);
},
cacheScrollPosition: function() {
this.cachedPosition = {
left: this.getScrollLeft(),
top: this.getScrollTop()
};
},
restoreScrollPosition: function() {
this.cachedPosition && (this.setScrollLeft(this.cachedPosition.left), this.setScrollTop(this.cachedPosition.top), this.cachedPosition = null);
},
horizontalChanged: function() {
this.$.strategy.setHorizontal(this.horizontal);
},
verticalChanged: function() {
this.$.strategy.setVertical(this.vertical);
},
setScrollLeft: function(e) {
this.scrollLeft = e, this.$.strategy.setScrollLeft(this.scrollLeft);
},
setScrollTop: function(e) {
this.scrollTop = e, this.$.strategy.setScrollTop(e);
},
getScrollLeft: function() {
return this.$.strategy.getScrollLeft();
},
getScrollTop: function() {
return this.$.strategy.getScrollTop();
},
getScrollBounds: function() {
return this.$.strategy.getScrollBounds();
},
scrollIntoView: function(e, t) {
this.$.strategy.scrollIntoView(e, t);
},
scrollTo: function(e, t) {
this.$.strategy.scrollTo(e, t);
},
scrollToControl: function(e, t) {
this.scrollToNode(e.hasNode(), t);
},
scrollToNode: function(e, t) {
this.$.strategy.scrollToNode(e, t);
},
domScroll: function(e, t) {
return this.$.strategy.domScroll && t.originator == this && this.$.strategy.scroll(e, t), this.doScroll(t), !0;
},
shouldStopScrollEvent: function(e) {
return this.preventScrollPropagation && e.originator.owner != this.$.strategy;
},
scrollStart: function(e, t) {
return this.shouldStopScrollEvent(t);
},
scroll: function(e, t) {
return t.dispatchTarget ? this.preventScrollPropagation && t.originator != this && t.originator.owner != this.$.strategy : this.shouldStopScrollEvent(t);
},
scrollStop: function(e, t) {
return this.shouldStopScrollEvent(t);
},
scrollToTop: function() {
this.setScrollTop(0);
},
scrollToBottom: function() {
this.setScrollTop(this.getScrollBounds().maxTop);
},
scrollToRight: function() {
this.setScrollLeft(this.getScrollBounds().maxLeft);
},
scrollToLeft: function() {
this.setScrollLeft(0);
},
stabilize: function() {
var e = this.getStrategy();
e.stabilize && e.stabilize();
}
}), enyo.Scroller.hasTouchScrolling() && (enyo.Scroller.prototype.strategyKind = enyo.Scroller.getTouchStrategy());

// Animator.js

enyo.kind({
name: "enyo.Animator",
kind: "Component",
published: {
duration: 350,
startValue: 0,
endValue: 1,
node: null,
easingFunction: enyo.easing.cubicOut
},
events: {
onStep: "",
onEnd: "",
onStop: ""
},
constructed: function() {
this.inherited(arguments), this._next = enyo.bind(this, "next");
},
destroy: function() {
this.stop(), this.inherited(arguments);
},
play: function(e) {
return this.stop(), this.reversed = !1, e && enyo.mixin(this, e), this.t0 = this.t1 = enyo.now(), this.value = this.startValue, this.job = !0, this.next(), this;
},
stop: function() {
if (this.isAnimating()) return this.cancel(), this.fire("onStop"), this;
},
reverse: function() {
if (this.isAnimating()) {
this.reversed = !this.reversed;
var e = this.t1 = enyo.now(), t = e - this.t0;
this.t0 = e + t - this.duration;
var n = this.startValue;
return this.startValue = this.endValue, this.endValue = n, this;
}
},
isAnimating: function() {
return Boolean(this.job);
},
requestNext: function() {
this.job = enyo.requestAnimationFrame(this._next, this.node);
},
cancel: function() {
enyo.cancelRequestAnimationFrame(this.job), this.node = null, this.job = null;
},
shouldEnd: function() {
return this.dt >= this.duration;
},
next: function() {
this.t1 = enyo.now(), this.dt = this.t1 - this.t0;
var e = this.fraction = enyo.easedLerp(this.t0, this.duration, this.easingFunction, this.reversed);
this.value = this.startValue + e * (this.endValue - this.startValue), e >= 1 || this.shouldEnd() ? (this.value = this.endValue, this.fraction = 1, this.fire("onStep"), this.fire("onEnd"), this.cancel()) : (this.fire("onStep"), this.requestNext());
},
fire: function(e) {
var t = this[e];
enyo.isString(t) ? this.bubble(e) : t && t.call(this.context || window, this);
}
});

// BaseLayout.js

enyo.kind({
name: "enyo.BaseLayout",
kind: enyo.Layout,
layoutClass: "enyo-positioned",
reflow: function() {
enyo.forEach(this.container.children, function(e) {
e.fit !== null && e.addRemoveClass("enyo-fit", e.fit);
}, this);
}
});

// Image.js

enyo.kind({
name: "enyo.Image",
noEvents: !1,
tag: "img",
attributes: {
draggable: "false"
},
create: function() {
this.noEvents && (delete this.attributes.onload, delete this.attributes.onerror), this.inherited(arguments);
},
rendered: function() {
this.inherited(arguments), enyo.makeBubble(this, "load", "error");
}
});

// Input.js

enyo.kind({
name: "enyo.Input",
published: {
value: "",
placeholder: "",
type: "",
disabled: !1,
selectOnFocus: !1
},
events: {
onDisabledChange: ""
},
defaultFocus: !1,
tag: "input",
classes: "enyo-input",
handlers: {
onfocus: "focused",
oninput: "input",
onclear: "clear",
ondragstart: "dragstart"
},
create: function() {
enyo.platform.ie && (this.handlers.onkeyup = "iekeyup"), enyo.platform.windowsPhone && (this.handlers.onkeydown = "iekeydown"), this.inherited(arguments), this.placeholderChanged(), this.type && this.typeChanged(), this.valueChanged();
},
rendered: function() {
this.inherited(arguments), enyo.makeBubble(this, "focus", "blur"), enyo.platform.ie == 8 && this.setAttribute("onchange", enyo.bubbler), this.disabledChanged(), this.defaultFocus && this.focus();
},
typeChanged: function() {
this.setAttribute("type", this.type);
},
placeholderChanged: function() {
this.setAttribute("placeholder", this.placeholder);
},
disabledChanged: function() {
this.setAttribute("disabled", this.disabled), this.bubble("onDisabledChange");
},
getValue: function() {
return this.getNodeProperty("value", this.value);
},
valueChanged: function() {
this.setAttribute("value", this.value), this.setNodeProperty("value", this.value);
},
iekeyup: function(e, t) {
var n = enyo.platform.ie, r = t.keyCode;
(n <= 8 || n == 9 && (r == 8 || r == 46)) && this.bubble("oninput", t);
},
iekeydown: function(e, t) {
var n = enyo.platform.windowsPhone, r = t.keyCode, i = t.dispatchTarget;
n <= 8 && r == 13 && this.tag == "input" && i.hasNode() && i.node.blur();
},
clear: function() {
this.setValue("");
},
focus: function() {
this.hasNode() && this.node.focus();
},
hasFocus: function() {
if (this.hasNode()) return document.activeElement === this.node;
},
dragstart: function() {
return this.hasFocus();
},
focused: function() {
this.selectOnFocus && enyo.asyncMethod(this, "selectContents");
},
selectContents: function() {
var e = this.hasNode();
if (e && e.setSelectionRange) e.setSelectionRange(0, e.value.length); else if (e && e.createTextRange) {
var t = e.createTextRange();
t.expand("textedit"), t.select();
}
}
});

// RichText.js

enyo.kind({
name: "enyo.RichText",
classes: "enyo-richtext enyo-selectable",
published: {
allowHtml: !0,
disabled: !1,
value: ""
},
defaultFocus: !1,
statics: {
osInfo: [ {
os: "android",
version: 3
}, {
os: "ios",
version: 5
} ],
hasContentEditable: function() {
for (var e = 0, t, n; t = enyo.RichText.osInfo[e]; e++) if (enyo.platform[t.os] < t.version) return !1;
return !0;
}
},
kind: enyo.Input,
attributes: {
contenteditable: !0
},
handlers: {
onfocus: "focusHandler",
onblur: "blurHandler"
},
create: function() {
this.setTag(enyo.RichText.hasContentEditable() ? "div" : "textarea"), this.inherited(arguments);
},
focusHandler: function() {
this._value = this.getValue();
},
blurHandler: function() {
this._value !== this.getValue() && this.bubble("onchange");
},
valueChanged: function() {
this.hasFocus() ? (this.selectAll(), this.insertAtCursor(this.value)) : this.setPropertyValue("content", this.value, "contentChanged");
},
getValue: function() {
if (this.hasNode()) return this.node.innerHTML;
},
hasFocus: function() {
if (this.hasNode()) return document.activeElement === this.node;
},
getSelection: function() {
if (this.hasFocus()) return window.getSelection();
},
removeSelection: function(e) {
var t = this.getSelection();
t && t[e ? "collapseToStart" : "collapseToEnd"]();
},
modifySelection: function(e, t, n) {
var r = this.getSelection();
r && r.modify(e || "move", t, n);
},
moveCursor: function(e, t) {
this.modifySelection("move", e, t);
},
moveCursorToEnd: function() {
this.moveCursor("forward", "documentboundary");
},
moveCursorToStart: function() {
this.moveCursor("backward", "documentboundary");
},
selectAll: function() {
this.hasFocus() && document.execCommand("selectAll");
},
insertAtCursor: function(e) {
if (this.hasFocus()) {
var t = this.allowHtml ? e : enyo.Control.escapeHtml(e).replace(/\n/g, "<br/>");
document.execCommand("insertHTML", !1, t);
}
}
});

// TextArea.js

enyo.kind({
name: "enyo.TextArea",
kind: enyo.Input,
tag: "textarea",
classes: "enyo-textarea",
rendered: function() {
this.inherited(arguments), this.valueChanged();
}
});

// Select.js

enyo.kind({
name: "enyo.Select",
published: {
selected: 0
},
handlers: {
onchange: "change"
},
tag: "select",
defaultKind: "enyo.Option",
rendered: function() {
this.inherited(arguments), enyo.platform.ie == 8 && this.setAttribute("onchange", enyo.bubbler), this.selectedChanged();
},
getSelected: function() {
return Number(this.getNodeProperty("selectedIndex", this.selected));
},
setSelected: function(e) {
this.setPropertyValue("selected", Number(e), "selectedChanged");
},
selectedChanged: function() {
this.setNodeProperty("selectedIndex", this.selected);
},
change: function() {
this.selected = this.getSelected();
},
render: function() {
enyo.platform.ie ? this.parent.render() : this.inherited(arguments);
},
getValue: function() {
if (this.hasNode()) return this.node.value;
}
}), enyo.kind({
name: "enyo.Option",
published: {
value: ""
},
tag: "option",
create: function() {
this.inherited(arguments), this.valueChanged();
},
valueChanged: function() {
this.setAttribute("value", this.value);
}
}), enyo.kind({
name: "enyo.OptionGroup",
published: {
label: ""
},
tag: "optgroup",
defaultKind: "enyo.Option",
create: function() {
this.inherited(arguments), this.labelChanged();
},
labelChanged: function() {
this.setAttribute("label", this.label);
}
});

// Group.js

enyo.kind({
name: "enyo.Group",
published: {
highlander: !0,
active: null
},
handlers: {
onActivate: "activate"
},
activate: function(e, t) {
this.highlander && (t.originator.active ? this.setActive(t.originator) : t.originator == this.active && this.active.setActive(!0));
},
activeChanged: function(e) {
e && (e.setActive(!1), e.removeClass("active")), this.active && this.active.addClass("active");
}
});

// GroupItem.js

enyo.kind({
name: "enyo.GroupItem",
published: {
active: !1
},
rendered: function() {
this.inherited(arguments), this.activeChanged();
},
activeChanged: function() {
this.bubble("onActivate");
}
});

// ToolDecorator.js

enyo.kind({
name: "enyo.ToolDecorator",
kind: enyo.GroupItem,
classes: "enyo-tool-decorator"
});

// Button.js

enyo.kind({
name: "enyo.Button",
kind: enyo.ToolDecorator,
tag: "button",
attributes: {
type: "button"
},
published: {
disabled: !1
},
create: function() {
this.inherited(arguments), this.disabledChanged();
},
disabledChanged: function() {
this.setAttribute("disabled", this.disabled);
},
tap: function() {
if (this.disabled) return !0;
this.setActive(!0);
}
});

// Checkbox.js

enyo.kind({
name: "enyo.Checkbox",
kind: enyo.Input,
classes: "enyo-checkbox",
events: {
onActivate: ""
},
published: {
checked: !1,
active: !1,
type: "checkbox"
},
kindClasses: "",
handlers: {
onchange: "change",
onclick: "click"
},
create: function() {
this.inherited(arguments);
},
rendered: function() {
this.inherited(arguments), this.active && this.activeChanged(), this.checkedChanged();
},
getChecked: function() {
return enyo.isTrue(this.getNodeProperty("checked", this.checked));
},
checkedChanged: function() {
this.setNodeProperty("checked", this.checked), this.setAttribute("checked", this.checked ? "checked" : ""), this.setActive(this.checked);
},
activeChanged: function() {
this.active = enyo.isTrue(this.active), this.setChecked(this.active), this.bubble("onActivate");
},
setValue: function(e) {
this.setChecked(enyo.isTrue(e));
},
getValue: function() {
return this.getChecked();
},
valueChanged: function() {},
change: function() {
this.setActive(this.getChecked());
},
click: function(e, t) {
enyo.platform.ie <= 8 && this.bubble("onchange", t);
}
});

// Repeater.js

enyo.kind({
name: "enyo.Repeater",
published: {
count: 0
},
events: {
onSetupItem: ""
},
create: function() {
this.inherited(arguments), this.countChanged();
},
initComponents: function() {
this.itemComponents = this.components || this.kindComponents, this.components = this.kindComponents = null, this.inherited(arguments);
},
setCount: function(e) {
this.setPropertyValue("count", e, "countChanged");
},
countChanged: function() {
this.build();
},
itemAtIndex: function(e) {
return this.controlAtIndex(e);
},
build: function() {
this.destroyClientControls();
for (var e = 0, t; e < this.count; e++) t = this.createComponent({
kind: "enyo.OwnerProxy",
index: e
}), t.createComponents(this.itemComponents), this.doSetupItem({
index: e,
item: t
});
this.render();
},
renderRow: function(e) {
var t = this.itemAtIndex(e);
this.doSetupItem({
index: e,
item: t
});
}
}), enyo.kind({
name: "enyo.OwnerProxy",
tag: null,
decorateEvent: function(e, t, n) {
t && (t.index = this.index), this.inherited(arguments);
},
delegateEvent: function(e, t, n, r, i) {
return e == this && (e = this.owner.owner), this.inherited(arguments, [ e, t, n, r, i ]);
}
});

// DragAvatar.js

enyo.kind({
name: "enyo._DragAvatar",
style: "position: absolute; z-index: 10; pointer-events: none; cursor: move;",
showing: !1,
showingChanged: function() {
this.inherited(arguments), document.body.style.cursor = this.showing ? "move" : null;
}
}), enyo.kind({
name: "enyo.DragAvatar",
kind: enyo.Component,
published: {
showing: !1,
offsetX: 20,
offsetY: 30
},
initComponents: function() {
this.avatarComponents = this.components, this.components = null, this.inherited(arguments);
},
requireAvatar: function() {
this.avatar || (this.avatar = this.createComponent({
kind: enyo._DragAvatar,
parentNode: document.body,
showing: !1,
components: this.avatarComponents
}).render());
},
showingChanged: function() {
this.avatar.setShowing(this.showing), document.body.style.cursor = this.showing ? "move" : null;
},
drag: function(e) {
this.requireAvatar(), this.avatar.setBounds({
top: e.pageY - this.offsetY,
left: e.pageX + this.offsetX
}), this.show();
},
show: function() {
this.setShowing(!0);
},
hide: function() {
this.setShowing(!1);
}
});

// FloatingLayer.js

enyo.kind({
name: "enyo.FloatingLayer",
create: function() {
this.inherited(arguments), this.setParent(null);
},
render: function() {
return this.parentNode = document.body, this.inherited(arguments);
},
generateInnerHtml: function() {
return "";
},
beforeChildRender: function() {
this.hasNode() || this.render();
},
teardownChildren: function() {}
}), enyo.floatingLayer = new enyo.FloatingLayer;

// Popup.js

enyo.kind({
name: "enyo.Popup",
classes: "enyo-popup enyo-no-touch-action",
published: {
modal: !1,
autoDismiss: !0,
floating: !1,
centered: !1
},
showing: !1,
handlers: {
ondown: "down",
onkeydown: "keydown",
ondragstart: "dragstart",
onfocus: "focus",
onblur: "blur",
onRequestShow: "requestShow",
onRequestHide: "requestHide"
},
captureEvents: !0,
events: {
onShow: "",
onHide: ""
},
tools: [ {
kind: "Signals",
onKeydown: "keydown"
} ],
create: function() {
this.inherited(arguments), this.canGenerate = !this.floating;
},
render: function() {
this.floating && (enyo.floatingLayer.hasNode() || enyo.floatingLayer.render(), this.parentNode = enyo.floatingLayer.hasNode()), this.inherited(arguments);
},
destroy: function() {
this.showing && this.release(), this.inherited(arguments);
},
reflow: function() {
this.updatePosition(), this.inherited(arguments);
},
calcViewportSize: function() {
if (window.innerWidth) return {
width: window.innerWidth,
height: window.innerHeight
};
var e = document.documentElement;
return {
width: e.offsetWidth,
height: e.offsetHeight
};
},
updatePosition: function() {
var e = this.calcViewportSize(), t = this.getBounds();
if (this.targetPosition) {
var n = this.targetPosition;
typeof n.left == "number" ? n.left + t.width > e.width ? (n.left - t.width >= 0 ? n.right = e.width - n.left : n.right = 0, n.left = null) : n.right = null : typeof n.right == "number" && (n.right + t.width > e.width ? (n.right - t.width >= 0 ? n.left = e.width - n.right : n.left = 0, n.right = null) : n.left = null), typeof n.top == "number" ? n.top + t.height > e.height ? (n.top - t.height >= 0 ? n.bottom = e.height - n.top : n.bottom = 0, n.top = null) : n.bottom = null : typeof n.bottom == "number" && (n.bottom + t.height > e.height ? (n.bottom - t.height >= 0 ? n.top = e.height - n.bottom : n.top = 0, n.bottom = null) : n.top = null), this.addStyles("left: " + (n.left !== null ? n.left + "px" : "initial") + "; right: " + (n.right !== null ? n.right + "px" : "initial") + "; top: " + (n.top !== null ? n.top + "px" : "initial") + "; bottom: " + (n.bottom !== null ? n.bottom + "px" : "initial") + ";");
} else this.centered && this.addStyles("top: " + Math.max((e.height - t.height) / 2, 0) + "px; left: " + Math.max((e.width - t.width) / 2, 0) + "px;");
},
showingChanged: function() {
this.floating && this.showing && !this.hasNode() && this.render();
if (this.centered || this.targetPosition) this.applyStyle("visibility", "hidden"), this.addStyles("top: 0px; left: 0px; right: initial; bottom: initial;");
this.inherited(arguments), this.showing ? (this.resized(), this.captureEvents && this.capture()) : this.captureEvents && this.release(), (this.centered || this.targetPosition) && this.applyStyle("visibility", null), this.hasNode() && this[this.showing ? "doShow" : "doHide"]();
},
capture: function() {
enyo.dispatcher.capture(this, !this.modal);
},
release: function() {
enyo.dispatcher.release();
},
down: function(e, t) {
this.downEvent = t, this.modal && !t.dispatchTarget.isDescendantOf(this) && t.preventDefault();
},
tap: function(e, t) {
if (this.autoDismiss && !t.dispatchTarget.isDescendantOf(this) && this.downEvent && !this.downEvent.dispatchTarget.isDescendantOf(this)) return this.downEvent = null, this.hide(), !0;
},
dragstart: function(e, t) {
var n = t.dispatchTarget === this || t.dispatchTarget.isDescendantOf(this);
return e.autoDismiss && !n && e.setShowing(!1), !0;
},
keydown: function(e, t) {
this.showing && this.autoDismiss && t.keyCode == 27 && this.hide();
},
blur: function(e, t) {
t.dispatchTarget.isDescendantOf(this) && (this.lastFocus = t.originator);
},
focus: function(e, t) {
var n = t.dispatchTarget;
if (this.modal && !n.isDescendantOf(this)) {
n.hasNode() && n.node.blur();
var r = this.lastFocus && this.lastFocus.hasNode() || this.hasNode();
r && r.focus();
}
},
requestShow: function(e, t) {
return this.show(), !0;
},
requestHide: function(e, t) {
return this.hide(), !0;
},
showAtEvent: function(e, t) {
var n = {
left: e.centerX || e.clientX || e.pageX,
top: e.centerY || e.clientY || e.pageY
};
t && (n.left += t.left || 0, n.top += t.top || 0), this.showAtPosition(n);
},
showAtPosition: function(e) {
this.targetPosition = e, this.show();
}
});

// Selection.js

enyo.kind({
name: "enyo.Selection",
kind: enyo.Component,
published: {
multi: !1
},
events: {
onSelect: "",
onDeselect: "",
onChange: ""
},
create: function() {
this.clear(), this.inherited(arguments);
},
multiChanged: function() {
this.multi || this.clear(), this.doChange();
},
highlander: function(e) {
this.multi || this.deselect(this.lastSelected);
},
clear: function() {
this.selected = {};
},
isSelected: function(e) {
return this.selected[e];
},
setByKey: function(e, t, n) {
if (t) this.selected[e] = n || !0, this.lastSelected = e, this.doSelect({
key: e,
data: this.selected[e]
}); else {
var r = this.isSelected(e);
delete this.selected[e], this.doDeselect({
key: e,
data: r
});
}
this.doChange();
},
deselect: function(e) {
this.isSelected(e) && this.setByKey(e, !1);
},
select: function(e, t) {
this.multi ? this.setByKey(e, !this.isSelected(e), t) : this.isSelected(e) || (this.highlander(), this.setByKey(e, !0, t));
},
toggle: function(e, t) {
!this.multi && this.lastSelected != e && this.deselect(this.lastSelected), this.setByKey(e, !this.isSelected(e), t);
},
getSelected: function() {
return this.selected;
},
remove: function(e) {
var t = {};
for (var n in this.selected) n < e ? t[n] = this.selected[n] : n > e && (t[n - 1] = this.selected[n]);
this.selected = t;
}
});

// minifier: path aliases

enyo.path.addPaths({tools: "../source/../lib/tools/", tools: "../source/../lib/tools/source/", layout: "/home/tjwebb/workspace/xtuple/xtuple/enyo-client/application/enyo/tools/../../lib/layout/", onyx: "/home/tjwebb/workspace/xtuple/xtuple/enyo-client/application/enyo/tools/../../lib/onyx/", onyx: "/home/tjwebb/workspace/xtuple/xtuple/enyo-client/application/enyo/tools/../../lib/onyx/source/", ext: "../source/ext/", models: "../source/models/", widgets: "../source/widgets/", views: "../source/views/"});

// preliminaries.js

XT = typeof XT != "undefined" ? XT : {}, function() {
XT.getBaseUrl = function() {
return location.protocol + "//" + location.hostname + (location.port && ":" + location.port);
}, XT.getOrganizationPath = function() {
return "/" + window.location.pathname.split("/")[1];
}, XT.logout = function() {
window.onbeforeunload && (window.onbeforeunload = undefined), window.location = XT.getOrganizationPath() + "/logout";
}, XT.setVersion = function(e, t) {
e = e || XT.session.config.version;
var n = XT.app.$.postbooks.$.navigator.$.aboutVersion, r = "_version".loc() + " " + e;
t && (r = ("_" + t).loc() + " " + r), n.getContent() && (r = n.getContent() + "<br>" + r), n.setContent(r);
};
}();

// underscore/underscore.js

(function() {
var e = this, t = e._, n = {}, r = Array.prototype, i = Object.prototype, s = Function.prototype, o = r.push, u = r.slice, a = r.concat, f = i.toString, l = i.hasOwnProperty, c = r.forEach, h = r.map, p = r.reduce, d = r.reduceRight, v = r.filter, m = r.every, g = r.some, y = r.indexOf, b = r.lastIndexOf, w = Array.isArray, E = Object.keys, S = s.bind, x = function(e) {
if (e instanceof x) return e;
if (!(this instanceof x)) return new x(e);
this._wrapped = e;
};
typeof exports != "undefined" ? (typeof module != "undefined" && module.exports && (exports = module.exports = x), exports._ = x) : e._ = x, x.VERSION = "1.4.4";
var T = x.each = x.forEach = function(e, t, r) {
if (e == null) return;
if (c && e.forEach === c) e.forEach(t, r); else if (e.length === +e.length) {
for (var i = 0, s = e.length; i < s; i++) if (t.call(r, e[i], i, e) === n) return;
} else for (var o in e) if (x.has(e, o) && t.call(r, e[o], o, e) === n) return;
};
x.map = x.collect = function(e, t, n) {
var r = [];
return e == null ? r : h && e.map === h ? e.map(t, n) : (T(e, function(e, i, s) {
r[r.length] = t.call(n, e, i, s);
}), r);
};
var N = "Reduce of empty array with no initial value";
x.reduce = x.foldl = x.inject = function(e, t, n, r) {
var i = arguments.length > 2;
e == null && (e = []);
if (p && e.reduce === p) return r && (t = x.bind(t, r)), i ? e.reduce(t, n) : e.reduce(t);
T(e, function(e, s, o) {
i ? n = t.call(r, n, e, s, o) : (n = e, i = !0);
});
if (!i) throw new TypeError(N);
return n;
}, x.reduceRight = x.foldr = function(e, t, n, r) {
var i = arguments.length > 2;
e == null && (e = []);
if (d && e.reduceRight === d) return r && (t = x.bind(t, r)), i ? e.reduceRight(t, n) : e.reduceRight(t);
var s = e.length;
if (s !== +s) {
var o = x.keys(e);
s = o.length;
}
T(e, function(u, a, f) {
a = o ? o[--s] : --s, i ? n = t.call(r, n, e[a], a, f) : (n = e[a], i = !0);
});
if (!i) throw new TypeError(N);
return n;
}, x.find = x.detect = function(e, t, n) {
var r;
return C(e, function(e, i, s) {
if (t.call(n, e, i, s)) return r = e, !0;
}), r;
}, x.filter = x.select = function(e, t, n) {
var r = [];
return e == null ? r : v && e.filter === v ? e.filter(t, n) : (T(e, function(e, i, s) {
t.call(n, e, i, s) && (r[r.length] = e);
}), r);
}, x.reject = function(e, t, n) {
return x.filter(e, function(e, r, i) {
return !t.call(n, e, r, i);
}, n);
}, x.every = x.all = function(e, t, r) {
t || (t = x.identity);
var i = !0;
return e == null ? i : m && e.every === m ? e.every(t, r) : (T(e, function(e, s, o) {
if (!(i = i && t.call(r, e, s, o))) return n;
}), !!i);
};
var C = x.some = x.any = function(e, t, r) {
t || (t = x.identity);
var i = !1;
return e == null ? i : g && e.some === g ? e.some(t, r) : (T(e, function(e, s, o) {
if (i || (i = t.call(r, e, s, o))) return n;
}), !!i);
};
x.contains = x.include = function(e, t) {
return e == null ? !1 : y && e.indexOf === y ? e.indexOf(t) != -1 : C(e, function(e) {
return e === t;
});
}, x.invoke = function(e, t) {
var n = u.call(arguments, 2), r = x.isFunction(t);
return x.map(e, function(e) {
return (r ? t : e[t]).apply(e, n);
});
}, x.pluck = function(e, t) {
return x.map(e, function(e) {
return e[t];
});
}, x.where = function(e, t, n) {
return x.isEmpty(t) ? n ? null : [] : x[n ? "find" : "filter"](e, function(e) {
for (var n in t) if (t[n] !== e[n]) return !1;
return !0;
});
}, x.findWhere = function(e, t) {
return x.where(e, t, !0);
}, x.max = function(e, t, n) {
if (!t && x.isArray(e) && e[0] === +e[0] && e.length < 65535) return Math.max.apply(Math, e);
if (!t && x.isEmpty(e)) return -Infinity;
var r = {
computed: -Infinity,
value: -Infinity
};
return T(e, function(e, i, s) {
var o = t ? t.call(n, e, i, s) : e;
o >= r.computed && (r = {
value: e,
computed: o
});
}), r.value;
}, x.min = function(e, t, n) {
if (!t && x.isArray(e) && e[0] === +e[0] && e.length < 65535) return Math.min.apply(Math, e);
if (!t && x.isEmpty(e)) return Infinity;
var r = {
computed: Infinity,
value: Infinity
};
return T(e, function(e, i, s) {
var o = t ? t.call(n, e, i, s) : e;
o < r.computed && (r = {
value: e,
computed: o
});
}), r.value;
}, x.shuffle = function(e) {
var t, n = 0, r = [];
return T(e, function(e) {
t = x.random(n++), r[n - 1] = r[t], r[t] = e;
}), r;
};
var k = function(e) {
return x.isFunction(e) ? e : function(t) {
return t[e];
};
};
x.sortBy = function(e, t, n) {
var r = k(t);
return x.pluck(x.map(e, function(e, t, i) {
return {
value: e,
index: t,
criteria: r.call(n, e, t, i)
};
}).sort(function(e, t) {
var n = e.criteria, r = t.criteria;
if (n !== r) {
if (n > r || n === void 0) return 1;
if (n < r || r === void 0) return -1;
}
return e.index < t.index ? -1 : 1;
}), "value");
};
var L = function(e, t, n, r) {
var i = {}, s = k(t || x.identity);
return T(e, function(t, o) {
var u = s.call(n, t, o, e);
r(i, u, t);
}), i;
};
x.groupBy = function(e, t, n) {
return L(e, t, n, function(e, t, n) {
(x.has(e, t) ? e[t] : e[t] = []).push(n);
});
}, x.countBy = function(e, t, n) {
return L(e, t, n, function(e, t) {
x.has(e, t) || (e[t] = 0), e[t]++;
});
}, x.sortedIndex = function(e, t, n, r) {
n = n == null ? x.identity : k(n);
var i = n.call(r, t), s = 0, o = e.length;
while (s < o) {
var u = s + o >>> 1;
n.call(r, e[u]) < i ? s = u + 1 : o = u;
}
return s;
}, x.toArray = function(e) {
return e ? x.isArray(e) ? u.call(e) : e.length === +e.length ? x.map(e, x.identity) : x.values(e) : [];
}, x.size = function(e) {
return e == null ? 0 : e.length === +e.length ? e.length : x.keys(e).length;
}, x.first = x.head = x.take = function(e, t, n) {
return e == null ? void 0 : t != null && !n ? u.call(e, 0, t) : e[0];
}, x.initial = function(e, t, n) {
return u.call(e, 0, e.length - (t == null || n ? 1 : t));
}, x.last = function(e, t, n) {
return e == null ? void 0 : t != null && !n ? u.call(e, Math.max(e.length - t, 0)) : e[e.length - 1];
}, x.rest = x.tail = x.drop = function(e, t, n) {
return u.call(e, t == null || n ? 1 : t);
}, x.compact = function(e) {
return x.filter(e, x.identity);
};
var A = function(e, t, n) {
return T(e, function(e) {
x.isArray(e) ? t ? o.apply(n, e) : A(e, t, n) : n.push(e);
}), n;
};
x.flatten = function(e, t) {
return A(e, t, []);
}, x.without = function(e) {
return x.difference(e, u.call(arguments, 1));
}, x.uniq = x.unique = function(e, t, n, r) {
x.isFunction(t) && (r = n, n = t, t = !1);
var i = n ? x.map(e, n, r) : e, s = [], o = [];
return T(i, function(n, r) {
if (t ? !r || o[o.length - 1] !== n : !x.contains(o, n)) o.push(n), s.push(e[r]);
}), s;
}, x.union = function() {
return x.uniq(a.apply(r, arguments));
}, x.intersection = function(e) {
var t = u.call(arguments, 1);
return x.filter(x.uniq(e), function(e) {
return x.every(t, function(t) {
return x.indexOf(t, e) >= 0;
});
});
}, x.difference = function(e) {
var t = a.apply(r, u.call(arguments, 1));
return x.filter(e, function(e) {
return !x.contains(t, e);
});
}, x.zip = function() {
var e = u.call(arguments), t = x.max(x.pluck(e, "length")), n = new Array(t);
for (var r = 0; r < t; r++) n[r] = x.pluck(e, "" + r);
return n;
}, x.object = function(e, t) {
if (e == null) return {};
var n = {};
for (var r = 0, i = e.length; r < i; r++) t ? n[e[r]] = t[r] : n[e[r][0]] = e[r][1];
return n;
}, x.indexOf = function(e, t, n) {
if (e == null) return -1;
var r = 0, i = e.length;
if (n) {
if (typeof n != "number") return r = x.sortedIndex(e, t), e[r] === t ? r : -1;
r = n < 0 ? Math.max(0, i + n) : n;
}
if (y && e.indexOf === y) return e.indexOf(t, n);
for (; r < i; r++) if (e[r] === t) return r;
return -1;
}, x.lastIndexOf = function(e, t, n) {
if (e == null) return -1;
var r = n != null;
if (b && e.lastIndexOf === b) return r ? e.lastIndexOf(t, n) : e.lastIndexOf(t);
var i = r ? n : e.length;
while (i--) if (e[i] === t) return i;
return -1;
}, x.range = function(e, t, n) {
arguments.length <= 1 && (t = e || 0, e = 0), n = arguments[2] || 1;
var r = Math.max(Math.ceil((t - e) / n), 0), i = 0, s = new Array(r);
while (i < r) s[i++] = e, e += n;
return s;
}, x.bind = function(e, t) {
if (e.bind === S && S) return S.apply(e, u.call(arguments, 1));
var n = u.call(arguments, 2);
return function() {
return e.apply(t, n.concat(u.call(arguments)));
};
}, x.partial = function(e) {
var t = u.call(arguments, 1);
return function() {
return e.apply(this, t.concat(u.call(arguments)));
};
}, x.bindAll = function(e) {
var t = u.call(arguments, 1);
return t.length === 0 && (t = x.functions(e)), T(t, function(t) {
e[t] = x.bind(e[t], e);
}), e;
}, x.memoize = function(e, t) {
var n = {};
return t || (t = x.identity), function() {
var r = t.apply(this, arguments);
return x.has(n, r) ? n[r] : n[r] = e.apply(this, arguments);
};
}, x.delay = function(e, t) {
var n = u.call(arguments, 2);
return setTimeout(function() {
return e.apply(null, n);
}, t);
}, x.defer = function(e) {
return x.delay.apply(x, [ e, 1 ].concat(u.call(arguments, 1)));
}, x.throttle = function(e, t) {
var n, r, i, s, o = 0, u = function() {
o = new Date, i = null, s = e.apply(n, r);
};
return function() {
var a = new Date, f = t - (a - o);
return n = this, r = arguments, f <= 0 ? (clearTimeout(i), i = null, o = a, s = e.apply(n, r)) : i || (i = setTimeout(u, f)), s;
};
}, x.debounce = function(e, t, n) {
var r, i;
return function() {
var s = this, o = arguments, u = function() {
r = null, n || (i = e.apply(s, o));
}, a = n && !r;
return clearTimeout(r), r = setTimeout(u, t), a && (i = e.apply(s, o)), i;
};
}, x.once = function(e) {
var t = !1, n;
return function() {
return t ? n : (t = !0, n = e.apply(this, arguments), e = null, n);
};
}, x.wrap = function(e, t) {
return function() {
var n = [ e ];
return o.apply(n, arguments), t.apply(this, n);
};
}, x.compose = function() {
var e = arguments;
return function() {
var t = arguments;
for (var n = e.length - 1; n >= 0; n--) t = [ e[n].apply(this, t) ];
return t[0];
};
}, x.after = function(e, t) {
return e <= 0 ? t() : function() {
if (--e < 1) return t.apply(this, arguments);
};
}, x.keys = E || function(e) {
if (e !== Object(e)) throw new TypeError("Invalid object");
var t = [];
for (var n in e) x.has(e, n) && (t[t.length] = n);
return t;
}, x.values = function(e) {
var t = [];
for (var n in e) x.has(e, n) && t.push(e[n]);
return t;
}, x.pairs = function(e) {
var t = [];
for (var n in e) x.has(e, n) && t.push([ n, e[n] ]);
return t;
}, x.invert = function(e) {
var t = {};
for (var n in e) x.has(e, n) && (t[e[n]] = n);
return t;
}, x.functions = x.methods = function(e) {
var t = [];
for (var n in e) x.isFunction(e[n]) && t.push(n);
return t.sort();
}, x.extend = function(e) {
return T(u.call(arguments, 1), function(t) {
if (t) for (var n in t) e[n] = t[n];
}), e;
}, x.pick = function(e) {
var t = {}, n = a.apply(r, u.call(arguments, 1));
return T(n, function(n) {
n in e && (t[n] = e[n]);
}), t;
}, x.omit = function(e) {
var t = {}, n = a.apply(r, u.call(arguments, 1));
for (var i in e) x.contains(n, i) || (t[i] = e[i]);
return t;
}, x.defaults = function(e) {
return T(u.call(arguments, 1), function(t) {
if (t) for (var n in t) e[n] == null && (e[n] = t[n]);
}), e;
}, x.clone = function(e) {
return x.isObject(e) ? x.isArray(e) ? e.slice() : x.extend({}, e) : e;
}, x.tap = function(e, t) {
return t(e), e;
};
var O = function(e, t, n, r) {
if (e === t) return e !== 0 || 1 / e == 1 / t;
if (e == null || t == null) return e === t;
e instanceof x && (e = e._wrapped), t instanceof x && (t = t._wrapped);
var i = f.call(e);
if (i != f.call(t)) return !1;
switch (i) {
case "[object String]":
return e == String(t);
case "[object Number]":
return e != +e ? t != +t : e == 0 ? 1 / e == 1 / t : e == +t;
case "[object Date]":
case "[object Boolean]":
return +e == +t;
case "[object RegExp]":
return e.source == t.source && e.global == t.global && e.multiline == t.multiline && e.ignoreCase == t.ignoreCase;
}
if (typeof e != "object" || typeof t != "object") return !1;
var s = n.length;
while (s--) if (n[s] == e) return r[s] == t;
n.push(e), r.push(t);
var o = 0, u = !0;
if (i == "[object Array]") {
o = e.length, u = o == t.length;
if (u) while (o--) if (!(u = O(e[o], t[o], n, r))) break;
} else {
var a = e.constructor, l = t.constructor;
if (a !== l && !(x.isFunction(a) && a instanceof a && x.isFunction(l) && l instanceof l)) return !1;
for (var c in e) if (x.has(e, c)) {
o++;
if (!(u = x.has(t, c) && O(e[c], t[c], n, r))) break;
}
if (u) {
for (c in t) if (x.has(t, c) && !(o--)) break;
u = !o;
}
}
return n.pop(), r.pop(), u;
};
x.isEqual = function(e, t) {
return O(e, t, [], []);
}, x.isEmpty = function(e) {
if (e == null) return !0;
if (x.isArray(e) || x.isString(e)) return e.length === 0;
for (var t in e) if (x.has(e, t)) return !1;
return !0;
}, x.isElement = function(e) {
return !!e && e.nodeType === 1;
}, x.isArray = w || function(e) {
return f.call(e) == "[object Array]";
}, x.isObject = function(e) {
return e === Object(e);
}, T([ "Arguments", "Function", "String", "Number", "Date", "RegExp" ], function(e) {
x["is" + e] = function(t) {
return f.call(t) == "[object " + e + "]";
};
}), x.isArguments(arguments) || (x.isArguments = function(e) {
return !!e && !!x.has(e, "callee");
}), typeof /./ != "function" && (x.isFunction = function(e) {
return typeof e == "function";
}), x.isFinite = function(e) {
return isFinite(e) && !isNaN(parseFloat(e));
}, x.isNaN = function(e) {
return x.isNumber(e) && e != +e;
}, x.isBoolean = function(e) {
return e === !0 || e === !1 || f.call(e) == "[object Boolean]";
}, x.isNull = function(e) {
return e === null;
}, x.isUndefined = function(e) {
return e === void 0;
}, x.has = function(e, t) {
return l.call(e, t);
}, x.noConflict = function() {
return e._ = t, this;
}, x.identity = function(e) {
return e;
}, x.times = function(e, t, n) {
var r = Array(e);
for (var i = 0; i < e; i++) r[i] = t.call(n, i);
return r;
}, x.random = function(e, t) {
return t == null && (t = e, e = 0), e + Math.floor(Math.random() * (t - e + 1));
};
var M = {
escape: {
"&": "&amp;",
"<": "&lt;",
">": "&gt;",
'"': "&quot;",
"'": "&#x27;",
"/": "&#x2F;"
}
};
M.unescape = x.invert(M.escape);
var _ = {
escape: new RegExp("[" + x.keys(M.escape).join("") + "]", "g"),
unescape: new RegExp("(" + x.keys(M.unescape).join("|") + ")", "g")
};
x.each([ "escape", "unescape" ], function(e) {
x[e] = function(t) {
return t == null ? "" : ("" + t).replace(_[e], function(t) {
return M[e][t];
});
};
}), x.result = function(e, t) {
if (e == null) return null;
var n = e[t];
return x.isFunction(n) ? n.call(e) : n;
}, x.mixin = function(e) {
T(x.functions(e), function(t) {
var n = x[t] = e[t];
x.prototype[t] = function() {
var e = [ this._wrapped ];
return o.apply(e, arguments), j.call(this, n.apply(x, e));
};
});
};
var D = 0;
x.uniqueId = function(e) {
var t = ++D + "";
return e ? e + t : t;
}, x.templateSettings = {
evaluate: /<%([\s\S]+?)%>/g,
interpolate: /<%=([\s\S]+?)%>/g,
escape: /<%-([\s\S]+?)%>/g
};
var P = /(.)^/, H = {
"'": "'",
"\\": "\\",
"\r": "r",
"\n": "n",
"	": "t",
"\u2028": "u2028",
"\u2029": "u2029"
}, B = /\\|'|\r|\n|\t|\u2028|\u2029/g;
x.template = function(e, t, n) {
var r;
n = x.defaults({}, n, x.templateSettings);
var i = new RegExp([ (n.escape || P).source, (n.interpolate || P).source, (n.evaluate || P).source ].join("|") + "|$", "g"), s = 0, o = "__p+='";
e.replace(i, function(t, n, r, i, u) {
return o += e.slice(s, u).replace(B, function(e) {
return "\\" + H[e];
}), n && (o += "'+\n((__t=(" + n + "))==null?'':_.escape(__t))+\n'"), r && (o += "'+\n((__t=(" + r + "))==null?'':__t)+\n'"), i && (o += "';\n" + i + "\n__p+='"), s = u + t.length, t;
}), o += "';\n", n.variable || (o = "with(obj||{}){\n" + o + "}\n"), o = "var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};\n" + o + "return __p;\n";
try {
r = new Function(n.variable || "obj", "_", o);
} catch (u) {
throw u.source = o, u;
}
if (t) return r(t, x);
var a = function(e) {
return r.call(this, e, x);
};
return a.source = "function(" + (n.variable || "obj") + "){\n" + o + "}", a;
}, x.chain = function(e) {
return x(e).chain();
};
var j = function(e) {
return this._chain ? x(e).chain() : e;
};
x.mixin(x), T([ "pop", "push", "reverse", "shift", "sort", "splice", "unshift" ], function(e) {
var t = r[e];
x.prototype[e] = function() {
var n = this._wrapped;
return t.apply(n, arguments), (e == "shift" || e == "splice") && n.length === 0 && delete n[0], j.call(this, n);
};
}), T([ "concat", "join", "slice" ], function(e) {
var t = r[e];
x.prototype[e] = function() {
return j.call(this, t.apply(this._wrapped, arguments));
};
}), x.extend(x.prototype, {
chain: function() {
return this._chain = !0, this;
},
value: function() {
return this._wrapped;
}
});
}).call(this);

// async/lib/async.js

(function() {
function r(e) {
var n = !1;
return function() {
if (n) throw new Error("Callback was already called.");
n = !0, e.apply(t, arguments);
};
}
var e = {}, t, n;
t = this, t != null && (n = t.async), e.noConflict = function() {
return t.async = n, e;
};
var i = function(e, t) {
if (e.forEach) return e.forEach(t);
for (var n = 0; n < e.length; n += 1) t(e[n], n, e);
}, s = function(e, t) {
if (e.map) return e.map(t);
var n = [];
return i(e, function(e, r, i) {
n.push(t(e, r, i));
}), n;
}, o = function(e, t, n) {
return e.reduce ? e.reduce(t, n) : (i(e, function(e, r, i) {
n = t(n, e, r, i);
}), n);
}, u = function(e) {
if (Object.keys) return Object.keys(e);
var t = [];
for (var n in e) e.hasOwnProperty(n) && t.push(n);
return t;
};
typeof process == "undefined" || !process.nextTick ? typeof setImmediate == "function" ? (e.nextTick = function(e) {
setImmediate(e);
}, e.setImmediate = e.nextTick) : (e.nextTick = function(e) {
setTimeout(e, 0);
}, e.setImmediate = e.nextTick) : (e.nextTick = process.nextTick, typeof setImmediate != "undefined" ? e.setImmediate = setImmediate : e.setImmediate = e.nextTick), e.each = function(e, t, n) {
n = n || function() {};
if (!e.length) return n();
var s = 0;
i(e, function(i) {
t(i, r(function(t) {
t ? (n(t), n = function() {}) : (s += 1, s >= e.length && n(null));
}));
});
}, e.forEach = e.each, e.eachSeries = function(e, t, n) {
n = n || function() {};
if (!e.length) return n();
var r = 0, i = function() {
t(e[r], function(t) {
t ? (n(t), n = function() {}) : (r += 1, r >= e.length ? n(null) : i());
});
};
i();
}, e.forEachSeries = e.eachSeries, e.eachLimit = function(e, t, n, r) {
var i = a(t);
i.apply(null, [ e, n, r ]);
}, e.forEachLimit = e.eachLimit;
var a = function(e) {
return function(t, n, r) {
r = r || function() {};
if (!t.length || e <= 0) return r();
var i = 0, s = 0, o = 0;
(function u() {
if (i >= t.length) return r();
while (o < e && s < t.length) s += 1, o += 1, n(t[s - 1], function(e) {
e ? (r(e), r = function() {}) : (i += 1, o -= 1, i >= t.length ? r() : u());
});
})();
};
}, f = function(t) {
return function() {
var n = Array.prototype.slice.call(arguments);
return t.apply(null, [ e.each ].concat(n));
};
}, l = function(e, t) {
return function() {
var n = Array.prototype.slice.call(arguments);
return t.apply(null, [ a(e) ].concat(n));
};
}, c = function(t) {
return function() {
var n = Array.prototype.slice.call(arguments);
return t.apply(null, [ e.eachSeries ].concat(n));
};
}, h = function(e, t, n, r) {
var i = [];
t = s(t, function(e, t) {
return {
index: t,
value: e
};
}), e(t, function(e, t) {
n(e.value, function(n, r) {
i[e.index] = r, t(n);
});
}, function(e) {
r(e, i);
});
};
e.map = f(h), e.mapSeries = c(h), e.mapLimit = function(e, t, n, r) {
return p(t)(e, n, r);
};
var p = function(e) {
return l(e, h);
};
e.reduce = function(t, n, r, i) {
e.eachSeries(t, function(e, t) {
r(n, e, function(e, r) {
n = r, t(e);
});
}, function(e) {
i(e, n);
});
}, e.inject = e.reduce, e.foldl = e.reduce, e.reduceRight = function(t, n, r, i) {
var o = s(t, function(e) {
return e;
}).reverse();
e.reduce(o, n, r, i);
}, e.foldr = e.reduceRight;
var d = function(e, t, n, r) {
var i = [];
t = s(t, function(e, t) {
return {
index: t,
value: e
};
}), e(t, function(e, t) {
n(e.value, function(n) {
n && i.push(e), t();
});
}, function(e) {
r(s(i.sort(function(e, t) {
return e.index - t.index;
}), function(e) {
return e.value;
}));
});
};
e.filter = f(d), e.filterSeries = c(d), e.select = e.filter, e.selectSeries = e.filterSeries;
var v = function(e, t, n, r) {
var i = [];
t = s(t, function(e, t) {
return {
index: t,
value: e
};
}), e(t, function(e, t) {
n(e.value, function(n) {
n || i.push(e), t();
});
}, function(e) {
r(s(i.sort(function(e, t) {
return e.index - t.index;
}), function(e) {
return e.value;
}));
});
};
e.reject = f(v), e.rejectSeries = c(v);
var m = function(e, t, n, r) {
e(t, function(e, t) {
n(e, function(n) {
n ? (r(e), r = function() {}) : t();
});
}, function(e) {
r();
});
};
e.detect = f(m), e.detectSeries = c(m), e.some = function(t, n, r) {
e.each(t, function(e, t) {
n(e, function(e) {
e && (r(!0), r = function() {}), t();
});
}, function(e) {
r(!1);
});
}, e.any = e.some, e.every = function(t, n, r) {
e.each(t, function(e, t) {
n(e, function(e) {
e || (r(!1), r = function() {}), t();
});
}, function(e) {
r(!0);
});
}, e.all = e.every, e.sortBy = function(t, n, r) {
e.map(t, function(e, t) {
n(e, function(n, r) {
n ? t(n) : t(null, {
value: e,
criteria: r
});
});
}, function(e, t) {
if (e) return r(e);
var n = function(e, t) {
var n = e.criteria, r = t.criteria;
return n < r ? -1 : n > r ? 1 : 0;
};
r(null, s(t.sort(n), function(e) {
return e.value;
}));
});
}, e.auto = function(t, n) {
n = n || function() {};
var r = u(t);
if (!r.length) return n(null);
var s = {}, a = [], f = function(e) {
a.unshift(e);
}, l = function(e) {
for (var t = 0; t < a.length; t += 1) if (a[t] === e) {
a.splice(t, 1);
return;
}
}, c = function() {
i(a.slice(0), function(e) {
e();
});
};
f(function() {
u(s).length === r.length && (n(null, s), n = function() {});
}), i(r, function(r) {
var a = t[r] instanceof Function ? [ t[r] ] : t[r], h = function(t) {
var o = Array.prototype.slice.call(arguments, 1);
o.length <= 1 && (o = o[0]);
if (t) {
var a = {};
i(u(s), function(e) {
a[e] = s[e];
}), a[r] = o, n(t, a), n = function() {};
} else s[r] = o, e.setImmediate(c);
}, p = a.slice(0, Math.abs(a.length - 1)) || [], d = function() {
return o(p, function(e, t) {
return e && s.hasOwnProperty(t);
}, !0) && !s.hasOwnProperty(r);
};
if (d()) a[a.length - 1](h, s); else {
var v = function() {
d() && (l(v), a[a.length - 1](h, s));
};
f(v);
}
});
}, e.waterfall = function(t, n) {
n = n || function() {};
if (t.constructor !== Array) {
var r = new Error("First argument to waterfall must be an array of functions");
return n(r);
}
if (!t.length) return n();
var i = function(t) {
return function(r) {
if (r) n.apply(null, arguments), n = function() {}; else {
var s = Array.prototype.slice.call(arguments, 1), o = t.next();
o ? s.push(i(o)) : s.push(n), e.setImmediate(function() {
t.apply(null, s);
});
}
};
};
i(e.iterator(t))();
};
var g = function(e, t, n) {
n = n || function() {};
if (t.constructor === Array) e.map(t, function(e, t) {
e && e(function(e) {
var n = Array.prototype.slice.call(arguments, 1);
n.length <= 1 && (n = n[0]), t.call(null, e, n);
});
}, n); else {
var r = {};
e.each(u(t), function(e, n) {
t[e](function(t) {
var i = Array.prototype.slice.call(arguments, 1);
i.length <= 1 && (i = i[0]), r[e] = i, n(t);
});
}, function(e) {
n(e, r);
});
}
};
e.parallel = function(t, n) {
g({
map: e.map,
each: e.each
}, t, n);
}, e.parallelLimit = function(e, t, n) {
g({
map: p(t),
each: a(t)
}, e, n);
}, e.series = function(t, n) {
n = n || function() {};
if (t.constructor === Array) e.mapSeries(t, function(e, t) {
e && e(function(e) {
var n = Array.prototype.slice.call(arguments, 1);
n.length <= 1 && (n = n[0]), t.call(null, e, n);
});
}, n); else {
var r = {};
e.eachSeries(u(t), function(e, n) {
t[e](function(t) {
var i = Array.prototype.slice.call(arguments, 1);
i.length <= 1 && (i = i[0]), r[e] = i, n(t);
});
}, function(e) {
n(e, r);
});
}
}, e.iterator = function(e) {
var t = function(n) {
var r = function() {
return e.length && e[n].apply(null, arguments), r.next();
};
return r.next = function() {
return n < e.length - 1 ? t(n + 1) : null;
}, r;
};
return t(0);
}, e.apply = function(e) {
var t = Array.prototype.slice.call(arguments, 1);
return function() {
return e.apply(null, t.concat(Array.prototype.slice.call(arguments)));
};
};
var y = function(e, t, n, r) {
var i = [];
e(t, function(e, t) {
n(e, function(e, n) {
i = i.concat(n || []), t(e);
});
}, function(e) {
r(e, i);
});
};
e.concat = f(y), e.concatSeries = c(y), e.whilst = function(t, n, r) {
t() ? n(function(i) {
if (i) return r(i);
e.whilst(t, n, r);
}) : r();
}, e.doWhilst = function(t, n, r) {
t(function(i) {
if (i) return r(i);
n() ? e.doWhilst(t, n, r) : r();
});
}, e.until = function(t, n, r) {
t() ? r() : n(function(i) {
if (i) return r(i);
e.until(t, n, r);
});
}, e.doUntil = function(t, n, r) {
t(function(i) {
if (i) return r(i);
n() ? r() : e.doUntil(t, n, r);
});
}, e.queue = function(t, n) {
function s(t, r, s, o) {
r.constructor !== Array && (r = [ r ]), i(r, function(r) {
var i = {
data: r,
callback: typeof o == "function" ? o : null
};
s ? t.tasks.unshift(i) : t.tasks.push(i), t.saturated && t.tasks.length === n && t.saturated(), e.setImmediate(t.process);
});
}
n === undefined && (n = 1);
var o = 0, u = {
tasks: [],
concurrency: n,
saturated: null,
empty: null,
drain: null,
push: function(e, t) {
s(u, e, !1, t);
},
unshift: function(e, t) {
s(u, e, !0, t);
},
process: function() {
if (o < u.concurrency && u.tasks.length) {
var e = u.tasks.shift();
u.empty && u.tasks.length === 0 && u.empty(), o += 1;
var n = function() {
o -= 1, e.callback && e.callback.apply(e, arguments), u.drain && u.tasks.length + o === 0 && u.drain(), u.process();
}, i = r(n);
t(e.data, i);
}
},
length: function() {
return u.tasks.length;
},
running: function() {
return o;
}
};
return u;
}, e.cargo = function(t, n) {
var r = !1, o = [], u = {
tasks: o,
payload: n,
saturated: null,
empty: null,
drain: null,
push: function(t, r) {
t.constructor !== Array && (t = [ t ]), i(t, function(e) {
o.push({
data: e,
callback: typeof r == "function" ? r : null
}), u.saturated && o.length === n && u.saturated();
}), e.setImmediate(u.process);
},
process: function a() {
if (r) return;
if (o.length === 0) {
u.drain && u.drain();
return;
}
var e = typeof n == "number" ? o.splice(0, n) : o.splice(0), f = s(e, function(e) {
return e.data;
});
u.empty && u.empty(), r = !0, t(f, function() {
r = !1;
var t = arguments;
i(e, function(e) {
e.callback && e.callback.apply(null, t);
}), a();
});
},
length: function() {
return o.length;
},
running: function() {
return r;
}
};
return u;
};
var b = function(e) {
return function(t) {
var n = Array.prototype.slice.call(arguments, 1);
t.apply(null, n.concat([ function(t) {
var n = Array.prototype.slice.call(arguments, 1);
typeof console != "undefined" && (t ? console.error && console.error(t) : console[e] && i(n, function(t) {
console[e](t);
}));
} ]));
};
};
e.log = b("log"), e.dir = b("dir"), e.memoize = function(e, t) {
var n = {}, r = {};
t = t || function(e) {
return e;
};
var i = function() {
var i = Array.prototype.slice.call(arguments), s = i.pop(), o = t.apply(null, i);
o in n ? s.apply(null, n[o]) : o in r ? r[o].push(s) : (r[o] = [ s ], e.apply(null, i.concat([ function() {
n[o] = arguments;
var e = r[o];
delete r[o];
for (var t = 0, i = e.length; t < i; t++) e[t].apply(null, arguments);
} ])));
};
return i.memo = n, i.unmemoized = e, i;
}, e.unmemoize = function(e) {
return function() {
return (e.unmemoized || e).apply(null, arguments);
};
}, e.times = function(t, n, r) {
var i = [];
for (var s = 0; s < t; s++) i.push(s);
return e.map(i, n, r);
}, e.timesSeries = function(t, n, r) {
var i = [];
for (var s = 0; s < t; s++) i.push(s);
return e.mapSeries(i, n, r);
}, e.compose = function() {
var t = Array.prototype.reverse.call(arguments);
return function() {
var n = this, r = Array.prototype.slice.call(arguments), i = r.pop();
e.reduce(t, r, function(e, t, r) {
t.apply(n, e.concat([ function() {
var e = arguments[0], t = Array.prototype.slice.call(arguments, 1);
r(e, t);
} ]));
}, function(e, t) {
i.apply(n, [ e ].concat(t));
});
};
};
var w = function(e, t) {
var n = function() {
var n = this, r = Array.prototype.slice.call(arguments), i = r.pop();
return e(t, function(e, t) {
e.apply(n, r.concat([ t ]));
}, i);
};
if (arguments.length > 2) {
var r = Array.prototype.slice.call(arguments, 2);
return n.apply(this, r);
}
return n;
};
e.applyEach = f(w), e.applyEachSeries = c(w), e.forever = function(e, t) {
function n(r) {
if (r) {
if (t) return t(r);
throw r;
}
e(n);
}
n();
}, typeof define != "undefined" && define.amd ? define([], function() {
return e;
}) : typeof module != "undefined" && module.exports ? module.exports = e : t.async = e;
})();

// ../../module/globalize/lib/globalize.js

(function(e, t) {
var n, r, i, s, o, u, a, f, l, c, h, p, d, v, m, g, y, b, w, E, S, x, T, N;
n = function(e) {
return new n.prototype.init(e);
}, typeof require != "undefined" && typeof exports != "undefined" && typeof module != "undefined" ? module.exports = n : e.Globalize = n, n.cultures = {}, n.prototype = {
constructor: n,
init: function(e) {
return this.cultures = n.cultures, this.cultureSelector = e, this;
}
}, n.prototype.init.prototype = n.prototype, n.cultures["default"] = {
name: "en",
englishName: "English",
nativeName: "English",
isRTL: !1,
language: "en",
numberFormat: {
pattern: [ "-n" ],
decimals: 2,
",": ",",
".": ".",
groupSizes: [ 3 ],
"+": "+",
"-": "-",
NaN: "NaN",
negativeInfinity: "-Infinity",
positiveInfinity: "Infinity",
percent: {
pattern: [ "-n %", "n %" ],
decimals: 2,
groupSizes: [ 3 ],
",": ",",
".": ".",
symbol: "%"
},
currency: {
pattern: [ "($n)", "$n" ],
decimals: 2,
groupSizes: [ 3 ],
",": ",",
".": ".",
symbol: "$"
}
},
calendars: {
standard: {
name: "Gregorian_USEnglish",
"/": "/",
":": ":",
firstDay: 0,
days: {
names: [ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ],
namesAbbr: [ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" ],
namesShort: [ "Su", "Mo", "Tu", "We", "Th", "Fr", "Sa" ]
},
months: {
names: [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", "" ],
namesAbbr: [ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "" ]
},
AM: [ "AM", "am", "AM" ],
PM: [ "PM", "pm", "PM" ],
eras: [ {
name: "A.D.",
start: null,
offset: 0
} ],
twoDigitYearMax: 2029,
patterns: {
d: "M/d/yyyy",
D: "dddd, MMMM dd, yyyy",
t: "h:mm tt",
T: "h:mm:ss tt",
f: "dddd, MMMM dd, yyyy h:mm tt",
F: "dddd, MMMM dd, yyyy h:mm:ss tt",
M: "MMMM dd",
Y: "yyyy MMMM",
S: "yyyy'-'MM'-'dd'T'HH':'mm':'ss"
}
}
},
messages: {}
}, n.cultures["default"].calendar = n.cultures["default"].calendars.standard, n.cultures.en = n.cultures["default"], n.cultureSelector = "en", r = /^0x[a-f0-9]+$/i, i = /^[+\-]?infinity$/i, s = /^[+\-]?\d*\.?\d*(e[+\-]?\d+)?$/, o = /^\s+|\s+$/g, u = function(e, t) {
if (e.indexOf) return e.indexOf(t);
for (var n = 0, r = e.length; n < r; n++) if (e[n] === t) return n;
return -1;
}, a = function(e, t) {
return e.substr(e.length - t.length) === t;
}, f = function() {
var e, n, r, i, s, o, u = arguments[0] || {}, a = 1, p = arguments.length, d = !1;
typeof u == "boolean" && (d = u, u = arguments[1] || {}, a = 2), typeof u != "object" && !c(u) && (u = {});
for (; a < p; a++) if ((e = arguments[a]) != null) for (n in e) {
r = u[n], i = e[n];
if (u === i) continue;
d && i && (h(i) || (s = l(i))) ? (s ? (s = !1, o = r && l(r) ? r : []) : o = r && h(r) ? r : {}, u[n] = f(d, o, i)) : i !== t && (u[n] = i);
}
return u;
}, l = Array.isArray || function(e) {
return Object.prototype.toString.call(e) === "[object Array]";
}, c = function(e) {
return Object.prototype.toString.call(e) === "[object Function]";
}, h = function(e) {
return Object.prototype.toString.call(e) === "[object Object]";
}, p = function(e, t) {
return e.indexOf(t) === 0;
}, d = function(e) {
return (e + "").replace(o, "");
}, v = function(e) {
return isNaN(e) ? NaN : Math[e < 0 ? "ceil" : "floor"](e);
}, m = function(e, t, n) {
var r;
for (r = e.length; r < t; r += 1) e = n ? "0" + e : e + "0";
return e;
}, g = function(e, t) {
var n = 0, r = !1;
for (var i = 0, s = e.length; i < s; i++) {
var o = e.charAt(i);
switch (o) {
case "'":
r ? t.push("'") : n++, r = !1;
break;
case "\\":
r && t.push("\\"), r = !r;
break;
default:
t.push(o), r = !1;
}
}
return n;
}, y = function(e, t) {
t = t || "F";
var n, r = e.patterns, i = t.length;
if (i === 1) {
n = r[t];
if (!n) throw "Invalid date format string '" + t + "'.";
t = n;
} else i === 2 && t.charAt(0) === "%" && (t = t.charAt(1));
return t;
}, b = function(e, t, n) {
function T(e, t) {
var n, r = e + "";
return t > 1 && r.length < t ? (n = c[t - 2] + r, n.substr(n.length - t, t)) : (n = r, n);
}
function N() {
return h || p ? h : (h = d.test(t), p = !0, h);
}
function C(e, t) {
if (w) return w[t];
switch (t) {
case 0:
return e.getFullYear();
case 1:
return e.getMonth();
case 2:
return e.getDate();
default:
throw "Invalid part value " + t;
}
}
var r = n.calendar, i = r.convert, s;
if (!t || !t.length || t === "i") {
if (n && n.name.length) if (i) s = b(e, r.patterns.F, n); else {
var o = new Date(e.getTime()), u = S(e, r.eras);
o.setFullYear(x(e, r, u)), s = o.toLocaleString();
} else s = e.toString();
return s;
}
var a = r.eras, f = t === "s";
t = y(r, t), s = [];
var l, c = [ "0", "00", "000" ], h, p, d = /([^d]|^)(d|dd)([^d]|$)/g, v = 0, m = E(), w;
!f && i && (w = i.fromGregorian(e));
for (;;) {
var k = m.lastIndex, L = m.exec(t), A = t.slice(k, L ? L.index : t.length);
v += g(A, s);
if (!L) break;
if (v % 2) {
s.push(L[0]);
continue;
}
var O = L[0], M = O.length;
switch (O) {
case "ddd":
case "dddd":
var _ = M === 3 ? r.days.namesAbbr : r.days.names;
s.push(_[e.getDay()]);
break;
case "d":
case "dd":
h = !0, s.push(T(C(e, 2), M));
break;
case "MMM":
case "MMMM":
var D = C(e, 1);
s.push(r.monthsGenitive && N() ? r.monthsGenitive[M === 3 ? "namesAbbr" : "names"][D] : r.months[M === 3 ? "namesAbbr" : "names"][D]);
break;
case "M":
case "MM":
s.push(T(C(e, 1) + 1, M));
break;
case "y":
case "yy":
case "yyyy":
D = w ? w[0] : x(e, r, S(e, a), f), M < 4 && (D %= 100), s.push(T(D, M));
break;
case "h":
case "hh":
l = e.getHours() % 12, l === 0 && (l = 12), s.push(T(l, M));
break;
case "H":
case "HH":
s.push(T(e.getHours(), M));
break;
case "m":
case "mm":
s.push(T(e.getMinutes(), M));
break;
case "s":
case "ss":
s.push(T(e.getSeconds(), M));
break;
case "t":
case "tt":
D = e.getHours() < 12 ? r.AM ? r.AM[0] : " " : r.PM ? r.PM[0] : " ", s.push(M === 1 ? D.charAt(0) : D);
break;
case "f":
case "ff":
case "fff":
s.push(T(e.getMilliseconds(), 3).substr(0, M));
break;
case "z":
case "zz":
l = e.getTimezoneOffset() / 60, s.push((l <= 0 ? "+" : "-") + T(Math.floor(Math.abs(l)), M));
break;
case "zzz":
l = e.getTimezoneOffset() / 60, s.push((l <= 0 ? "+" : "-") + T(Math.floor(Math.abs(l)), 2) + ":" + T(Math.abs(e.getTimezoneOffset() % 60), 2));
break;
case "g":
case "gg":
r.eras && s.push(r.eras[S(e, a)].name);
break;
case "/":
s.push(r["/"]);
break;
default:
throw "Invalid date format pattern '" + O + "'.";
}
}
return s.join("");
}, function() {
var e;
e = function(e, t, n) {
var r = n.groupSizes, i = r[0], s = 1, o = Math.pow(10, t), u = Math.round(e * o) / o;
isFinite(u) || (u = e), e = u;
var a = e + "", f = "", l = a.split(/e/i), c = l.length > 1 ? parseInt(l[1], 10) : 0;
a = l[0], l = a.split("."), a = l[0], f = l.length > 1 ? l[1] : "";
var h;
c > 0 ? (f = m(f, c, !1), a += f.slice(0, c), f = f.substr(c)) : c < 0 && (c = -c, a = m(a, c + 1, !0), f = a.slice(-c, a.length) + f, a = a.slice(0, -c)), t > 0 ? f = n["."] + (f.length > t ? f.slice(0, t) : m(f, t)) : f = "";
var p = a.length - 1, d = n[","], v = "";
while (p >= 0) {
if (i === 0 || i > p) return a.slice(0, p + 1) + (v.length ? d + v + f : f);
v = a.slice(p - i + 1, p + 1) + (v.length ? d + v : ""), p -= i, s < r.length && (i = r[s], s++);
}
return a.slice(0, p + 1) + d + v + f;
}, w = function(t, n, r) {
if (!isFinite(t)) return t === Infinity ? r.numberFormat.positiveInfinity : t === -Infinity ? r.numberFormat.negativeInfinity : r.numberFormat.NaN;
if (!n || n === "i") return r.name.length ? t.toLocaleString() : t.toString();
n = n || "D";
var i = r.numberFormat, s = Math.abs(t), o = -1, u;
n.length > 1 && (o = parseInt(n.slice(1), 10));
var a = n.charAt(0).toUpperCase(), f;
switch (a) {
case "D":
u = "n", s = v(s), o !== -1 && (s = m("" + s, o, !0)), t < 0 && (s = "-" + s);
break;
case "N":
f = i;
case "C":
f = f || i.currency;
case "P":
f = f || i.percent, u = t < 0 ? f.pattern[0] : f.pattern[1] || "n", o === -1 && (o = f.decimals), s = e(s * (a === "P" ? 100 : 1), o, f);
break;
default:
throw "Bad number format specifier: " + a;
}
var l = /n|\$|-|%/g, c = "";
for (;;) {
var h = l.lastIndex, p = l.exec(u);
c += u.slice(h, p ? p.index : u.length);
if (!p) break;
switch (p[0]) {
case "n":
c += s;
break;
case "$":
c += i.currency.symbol;
break;
case "-":
/[1-9]/.test(s) && (c += i["-"]);
break;
case "%":
c += i.percent.symbol;
}
}
return c;
};
}(), E = function() {
return /\/|dddd|ddd|dd|d|MMMM|MMM|MM|M|yyyy|yy|y|hh|h|HH|H|mm|m|ss|s|tt|t|fff|ff|f|zzz|zz|z|gg|g/g;
}, S = function(e, t) {
if (!t) return 0;
var n, r = e.getTime();
for (var i = 0, s = t.length; i < s; i++) {
n = t[i].start;
if (n === null || r >= n) return i;
}
return 0;
}, x = function(e, t, n, r) {
var i = e.getFullYear();
return !r && t.eras && (i -= t.eras[n].offset), i;
}, function() {
var e, t, n, r, i, s, o;
e = function(e, t) {
if (t < 100) {
var n = new Date, r = S(n), i = x(n, e, r), s = e.twoDigitYearMax;
s = typeof s == "string" ? (new Date).getFullYear() % 100 + parseInt(s, 10) : s, t += i - i % 100, t > s && (t -= 100);
}
return t;
}, t = function(e, t, n) {
var r, i = e.days, a = e._upperDays;
return a || (e._upperDays = a = [ o(i.names), o(i.namesAbbr), o(i.namesShort) ]), t = s(t), n ? (r = u(a[1], t), r === -1 && (r = u(a[2], t))) : r = u(a[0], t), r;
}, n = function(e, t, n) {
var r = e.months, i = e.monthsGenitive || e.months, a = e._upperMonths, f = e._upperMonthsGen;
a || (e._upperMonths = a = [ o(r.names), o(r.namesAbbr) ], e._upperMonthsGen = f = [ o(i.names), o(i.namesAbbr) ]), t = s(t);
var l = u(n ? a[1] : a[0], t);
return l < 0 && (l = u(n ? f[1] : f[0], t)), l;
}, r = function(e, t) {
var n = e._parseRegExp;
if (!n) e._parseRegExp = n = {}; else {
var r = n[t];
if (r) return r;
}
var i = y(e, t).replace(/([\^\$\.\*\+\?\|\[\]\(\)\{\}])/g, "\\\\$1"), s = [ "^" ], o = [], u = 0, a = 0, f = E(), l;
while ((l = f.exec(i)) !== null) {
var c = i.slice(u, l.index);
u = f.lastIndex, a += g(c, s);
if (a % 2) {
s.push(l[0]);
continue;
}
var h = l[0], p = h.length, d;
switch (h) {
case "dddd":
case "ddd":
case "MMMM":
case "MMM":
case "gg":
case "g":
d = "(\\D+)";
break;
case "tt":
case "t":
d = "(\\D*)";
break;
case "yyyy":
case "fff":
case "ff":
case "f":
d = "(\\d{" + p + "})";
break;
case "dd":
case "d":
case "MM":
case "M":
case "yy":
case "y":
case "HH":
case "H":
case "hh":
case "h":
case "mm":
case "m":
case "ss":
case "s":
d = "(\\d\\d?)";
break;
case "zzz":
d = "([+-]?\\d\\d?:\\d{2})";
break;
case "zz":
case "z":
d = "([+-]?\\d\\d?)";
break;
case "/":
d = "(\\/)";
break;
default:
throw "Invalid date format pattern '" + h + "'.";
}
d && s.push(d), o.push(l[0]);
}
g(i.slice(u), s), s.push("$");
var v = s.join("").replace(/\s+/g, "\\s+"), m = {
regExp: v,
groups: o
};
return n[t] = m;
}, i = function(e, t, n) {
return e < t || e > n;
}, s = function(e) {
return e.split("\u00a0").join(" ").toUpperCase();
}, o = function(e) {
var t = [];
for (var n = 0, r = e.length; n < r; n++) t[n] = s(e[n]);
return t;
}, T = function(s, o, u) {
s = d(s);
var a = u.calendar, f = r(a, o), l = (new RegExp(f.regExp)).exec(s);
if (l === null) return null;
var c = f.groups, h = null, v = null, m = null, g = null, y = null, b = 0, w, E = 0, S = 0, x = 0, T = null, N = !1;
for (var C = 0, k = c.length; C < k; C++) {
var L = l[C + 1];
if (L) {
var A = c[C], O = A.length, M = parseInt(L, 10);
switch (A) {
case "dd":
case "d":
g = M;
if (i(g, 1, 31)) return null;
break;
case "MMM":
case "MMMM":
m = n(a, L, O === 3);
if (i(m, 0, 11)) return null;
break;
case "M":
case "MM":
m = M - 1;
if (i(m, 0, 11)) return null;
break;
case "y":
case "yy":
case "yyyy":
v = O < 4 ? e(a, M) : M;
if (i(v, 0, 9999)) return null;
break;
case "h":
case "hh":
b = M, b === 12 && (b = 0);
if (i(b, 0, 11)) return null;
break;
case "H":
case "HH":
b = M;
if (i(b, 0, 23)) return null;
break;
case "m":
case "mm":
E = M;
if (i(E, 0, 59)) return null;
break;
case "s":
case "ss":
S = M;
if (i(S, 0, 59)) return null;
break;
case "tt":
case "t":
N = a.PM && (L === a.PM[0] || L === a.PM[1] || L === a.PM[2]);
if (!N && (!a.AM || L !== a.AM[0] && L !== a.AM[1] && L !== a.AM[2])) return null;
break;
case "f":
case "ff":
case "fff":
x = M * Math.pow(10, 3 - O);
if (i(x, 0, 999)) return null;
break;
case "ddd":
case "dddd":
y = t(a, L, O === 3);
if (i(y, 0, 6)) return null;
break;
case "zzz":
var _ = L.split(/:/);
if (_.length !== 2) return null;
w = parseInt(_[0], 10);
if (i(w, -12, 13)) return null;
var D = parseInt(_[1], 10);
if (i(D, 0, 59)) return null;
T = w * 60 + (p(L, "-") ? -D : D);
break;
case "z":
case "zz":
w = M;
if (i(w, -12, 13)) return null;
T = w * 60;
break;
case "g":
case "gg":
var P = L;
if (!P || !a.eras) return null;
P = d(P.toLowerCase());
for (var H = 0, B = a.eras.length; H < B; H++) if (P === a.eras[H].name.toLowerCase()) {
h = H;
break;
}
if (h === null) return null;
}
}
}
var j = new Date, F, I = a.convert;
F = I ? I.fromGregorian(j)[0] : j.getFullYear(), v === null ? v = F : a.eras && (v += a.eras[h || 0].offset), m === null && (m = 0), g === null && (g = 1);
if (I) {
j = I.toGregorian(v, m, g);
if (j === null) return null;
} else {
j.setFullYear(v, m, g);
if (j.getDate() !== g) return null;
if (y !== null && j.getDay() !== y) return null;
}
N && b < 12 && (b += 12), j.setHours(b, E, S, x);
if (T !== null) {
var q = j.getMinutes() - (T + j.getTimezoneOffset());
j.setHours(j.getHours() + parseInt(q / 60, 10), q % 60);
}
return j;
};
}(), N = function(e, t, n) {
var r = t["-"], i = t["+"], s;
switch (n) {
case "n -":
r = " " + r, i = " " + i;
case "n-":
a(e, r) ? s = [ "-", e.substr(0, e.length - r.length) ] : a(e, i) && (s = [ "+", e.substr(0, e.length - i.length) ]);
break;
case "- n":
r += " ", i += " ";
case "-n":
p(e, r) ? s = [ "-", e.substr(r.length) ] : p(e, i) && (s = [ "+", e.substr(i.length) ]);
break;
case "(n)":
p(e, "(") && a(e, ")") && (s = [ "-", e.substr(1, e.length - 2) ]);
}
return s || [ "", e ];
}, n.prototype.findClosestCulture = function(e) {
return n.findClosestCulture.call(this, e);
}, n.prototype.format = function(e, t, r) {
return n.format.call(this, e, t, r);
}, n.prototype.localize = function(e, t) {
return n.localize.call(this, e, t);
}, n.prototype.parseInt = function(e, t, r) {
return n.parseInt.call(this, e, t, r);
}, n.prototype.parseFloat = function(e, t, r) {
return n.parseFloat.call(this, e, t, r);
}, n.prototype.culture = function(e) {
return n.culture.call(this, e);
}, n.addCultureInfo = function(e, t, n) {
var r = {}, i = !1;
typeof e != "string" ? (n = e, e = this.culture().name, r = this.cultures[e]) : typeof t != "string" ? (n = t, i = this.cultures[e] == null, r = this.cultures[e] || this.cultures["default"]) : (i = !0, r = this.cultures[t]), this.cultures[e] = f(!0, {}, r, n), i && (this.cultures[e].calendar = this.cultures[e].calendars.standard);
}, n.findClosestCulture = function(e) {
var t;
if (!e) return this.findClosestCulture(this.cultureSelector) || this.cultures["default"];
typeof e == "string" && (e = e.split(","));
if (l(e)) {
var n, r = this.cultures, i = e, s, o = i.length, u = [];
for (s = 0; s < o; s++) {
e = d(i[s]);
var a, f = e.split(";");
n = d(f[0]), f.length === 1 ? a = 1 : (e = d(f[1]), e.indexOf("q=") === 0 ? (e = e.substr(2), a = parseFloat(e), a = isNaN(a) ? 0 : a) : a = 1), u.push({
lang: n,
pri: a
});
}
u.sort(function(e, t) {
return e.pri < t.pri ? 1 : e.pri > t.pri ? -1 : 0;
});
for (s = 0; s < o; s++) {
n = u[s].lang, t = r[n];
if (t) return t;
}
for (s = 0; s < o; s++) {
n = u[s].lang;
do {
var c = n.lastIndexOf("-");
if (c === -1) break;
n = n.substr(0, c), t = r[n];
if (t) return t;
} while (1);
}
for (s = 0; s < o; s++) {
n = u[s].lang;
for (var h in r) {
var p = r[h];
if (p.language == n) return p;
}
}
} else if (typeof e == "object") return e;
return t || null;
}, n.format = function(e, t, n) {
var r = this.findClosestCulture(n);
return e instanceof Date ? e = b(e, t, r) : typeof e == "number" && (e = w(e, t, r)), e;
}, n.localize = function(e, t) {
return this.findClosestCulture(t).messages[e] || this.cultures["default"].messages[e];
}, n.parseDate = function(e, t, n) {
n = this.findClosestCulture(n);
var r, i, s;
if (t) {
typeof t == "string" && (t = [ t ]);
if (t.length) for (var o = 0, u = t.length; o < u; o++) {
var a = t[o];
if (a) {
r = T(e, a, n);
if (r) break;
}
}
} else {
s = n.calendar.patterns;
for (i in s) {
r = T(e, s[i], n);
if (r) break;
}
}
return r || null;
}, n.parseInt = function(e, t, r) {
return v(n.parseFloat(e, t, r));
}, n.parseFloat = function(e, t, n) {
typeof t != "number" && (n = t, t = 10);
var o = this.findClosestCulture(n), u = NaN, a = o.numberFormat;
e.indexOf(o.numberFormat.currency.symbol) > -1 && (e = e.replace(o.numberFormat.currency.symbol, ""), e = e.replace(o.numberFormat.currency["."], o.numberFormat["."])), e.indexOf(o.numberFormat.percent.symbol) > -1 && (e = e.replace(o.numberFormat.percent.symbol, "")), e = e.replace(/ /g, "");
if (i.test(e)) u = parseFloat(e); else if (!t && r.test(e)) u = parseInt(e, 16); else {
var f = N(e, a, a.pattern[0]), l = f[0], c = f[1];
l === "" && a.pattern[0] !== "(n)" && (f = N(e, a, "(n)"), l = f[0], c = f[1]), l === "" && a.pattern[0] !== "-n" && (f = N(e, a, "-n"), l = f[0], c = f[1]), l = l || "+";
var h, p, d = c.indexOf("e");
d < 0 && (d = c.indexOf("E")), d < 0 ? (p = c, h = null) : (p = c.substr(0, d), h = c.substr(d + 1));
var v, m, g = a["."], y = p.indexOf(g);
y < 0 ? (v = p, m = null) : (v = p.substr(0, y), m = p.substr(y + g.length));
var b = a[","];
v = v.split(b).join("");
var w = b.replace(/\u00A0/g, " ");
b !== w && (v = v.split(w).join(""));
var E = l + v;
m !== null && (E += "." + m);
if (h !== null) {
var S = N(h, a, "-n");
E += "e" + (S[0] || "+") + S[1];
}
s.test(E) && (u = parseFloat(E));
}
return u;
}, n.culture = function(e) {
return typeof e != "undefined" && (this.cultureSelector = e), this.findClosestCulture(e) || this.cultures["default"];
};
})(this);

// ../../module/moment/moment.js

(function(e) {
function z(e, t) {
return function(n) {
return Q(e.call(this, n), t);
};
}
function W(e, t) {
return function(n) {
return this.lang().ordinal(e.call(this, n), t);
};
}
function X() {}
function V(e) {
at(e), J(this, e);
}
function $(e) {
var t = nt(e), n = t.year || 0, r = t.month || 0, i = t.week || 0, s = t.day || 0, o = t.hour || 0, u = t.minute || 0, a = t.second || 0, f = t.millisecond || 0;
this._input = e, this._milliseconds = +f + a * 1e3 + u * 6e4 + o * 36e5, this._days = +s + i * 7, this._months = +r + n * 12, this._data = {}, this._bubble();
}
function J(e, t) {
for (var n in t) t.hasOwnProperty(n) && (e[n] = t[n]);
return t.hasOwnProperty("toString") && (e.toString = t.toString), t.hasOwnProperty("valueOf") && (e.valueOf = t.valueOf), e;
}
function K(e) {
return e < 0 ? Math.ceil(e) : Math.floor(e);
}
function Q(e, t) {
var n = e + "";
while (n.length < t) n = "0" + n;
return n;
}
function G(e, n, r, i) {
var s = n._milliseconds, o = n._days, u = n._months, a, f;
s && e._d.setTime(+e._d + s * r);
if (o || u) a = e.minute(), f = e.hour();
o && e.date(e.date() + o * r), u && e.month(e.month() + u * r), s && !i && t.updateOffset(e);
if (o || u) e.minute(a), e.hour(f);
}
function Y(e) {
return Object.prototype.toString.call(e) === "[object Array]";
}
function Z(e) {
return Object.prototype.toString.call(e) === "[object Date]" || e instanceof Date;
}
function et(e, t, n) {
var r = Math.min(e.length, t.length), i = Math.abs(e.length - t.length), s = 0, o;
for (o = 0; o < r; o++) (n && e[o] !== t[o] || !n && it(e[o]) !== it(t[o])) && s++;
return s + i;
}
function tt(e) {
if (e) {
var t = e.toLowerCase().replace(/(.)s$/, "$1");
e = B[e] || j[t] || t;
}
return e;
}
function nt(e) {
var t = {}, n, r, i;
for (r in e) e.hasOwnProperty(r) && (n = tt(r), n && (t[n] = e[r]));
return t;
}
function rt(n) {
var r, i;
if (n.indexOf("week") === 0) r = 7, i = "day"; else {
if (n.indexOf("month") !== 0) return;
r = 12, i = "month";
}
t[n] = function(s, o) {
var u, a, f = t.fn._lang[n], l = [];
typeof s == "number" && (o = s, s = e), a = function(e) {
var n = t().utc().set(i, e);
return f.call(t.fn._lang, n, s || "");
};
if (o != null) return a(o);
for (u = 0; u < r; u++) l.push(a(u));
return l;
};
}
function it(e) {
var t = +e, n = 0;
return t !== 0 && isFinite(t) && (t >= 0 ? n = Math.floor(t) : n = Math.ceil(t)), n;
}
function st(e, t) {
return (new Date(Date.UTC(e, t + 1, 0))).getUTCDate();
}
function ot(e) {
return ut(e) ? 366 : 365;
}
function ut(e) {
return e % 4 === 0 && e % 100 !== 0 || e % 400 === 0;
}
function at(e) {
var t;
e._a && e._pf.overflow === -2 && (t = e._a[o] < 0 || e._a[o] > 11 ? o : e._a[u] < 1 || e._a[u] > st(e._a[s], e._a[o]) ? u : e._a[a] < 0 || e._a[a] > 23 ? a : e._a[f] < 0 || e._a[f] > 59 ? f : e._a[l] < 0 || e._a[l] > 59 ? l : e._a[c] < 0 || e._a[c] > 999 ? c : -1, e._pf._overflowDayOfYear && (t < s || t > u) && (t = u), e._pf.overflow = t);
}
function ft(e) {
e._pf = {
empty: !1,
unusedTokens: [],
unusedInput: [],
overflow: -2,
charsLeftOver: 0,
nullInput: !1,
invalidMonth: null,
invalidFormat: !1,
userInvalidated: !1,
iso: !1
};
}
function lt(e) {
return e._isValid == null && (e._isValid = !isNaN(e._d.getTime()) && e._pf.overflow < 0 && !e._pf.empty && !e._pf.invalidMonth && !e._pf.nullInput && !e._pf.invalidFormat && !e._pf.userInvalidated, e._strict && (e._isValid = e._isValid && e._pf.charsLeftOver === 0 && e._pf.unusedTokens.length === 0)), e._isValid;
}
function ct(e) {
return e ? e.toLowerCase().replace("_", "-") : e;
}
function ht(e, t) {
return t.abbr = e, h[e] || (h[e] = new X), h[e].set(t), h[e];
}
function pt(e) {
delete h[e];
}
function dt(e) {
var n = 0, r, i, s, o, u = function(e) {
if (!h[e] && p) try {
require("./lang/" + e);
} catch (t) {}
return h[e];
};
if (!e) return t.fn._lang;
if (!Y(e)) {
i = u(e);
if (i) return i;
e = [ e ];
}
while (n < e.length) {
o = ct(e[n]).split("-"), r = o.length, s = ct(e[n + 1]), s = s ? s.split("-") : null;
while (r > 0) {
i = u(o.slice(0, r).join("-"));
if (i) return i;
if (s && s.length >= r && et(o, s, !0) >= r - 1) break;
r--;
}
n++;
}
return t.fn._lang;
}
function vt(e) {
return e.match(/\[[\s\S]/) ? e.replace(/^\[|\]$/g, "") : e.replace(/\\/g, "");
}
function mt(e) {
var t = e.match(g), n, r;
for (n = 0, r = t.length; n < r; n++) R[t[n]] ? t[n] = R[t[n]] : t[n] = vt(t[n]);
return function(i) {
var s = "";
for (n = 0; n < r; n++) s += t[n] instanceof Function ? t[n].call(i, e) : t[n];
return s;
};
}
function gt(e, t) {
return e.isValid() ? (t = yt(t, e.lang()), F[t] || (F[t] = mt(t)), F[t](e)) : e.lang().invalidDate();
}
function yt(e, t) {
function r(e) {
return t.longDateFormat(e) || e;
}
var n = 5;
y.lastIndex = 0;
while (n >= 0 && y.test(e)) e = e.replace(y, r), y.lastIndex = 0, n -= 1;
return e;
}
function bt(e, t) {
var n;
switch (e) {
case "DDDD":
return E;
case "YYYY":
case "GGGG":
case "gggg":
return S;
case "YYYYY":
case "GGGGG":
case "ggggg":
return x;
case "S":
case "SS":
case "SSS":
case "DDD":
return w;
case "MMM":
case "MMMM":
case "dd":
case "ddd":
case "dddd":
return N;
case "a":
case "A":
return dt(t._l)._meridiemParse;
case "X":
return L;
case "Z":
case "ZZ":
return C;
case "T":
return k;
case "SSSS":
return T;
case "MM":
case "DD":
case "YY":
case "GG":
case "gg":
case "HH":
case "hh":
case "mm":
case "ss":
case "M":
case "D":
case "d":
case "H":
case "h":
case "m":
case "s":
case "w":
case "ww":
case "W":
case "WW":
case "e":
case "E":
return b;
default:
return n = new RegExp(kt(Ct(e.replace("\\", "")), "i")), n;
}
}
function wt(e) {
var t = (C.exec(e) || [])[0], n = (t + "").match(D) || [ "-", 0, 0 ], r = +(n[1] * 60) + it(n[2]);
return n[0] === "+" ? -r : r;
}
function Et(e, t, n) {
var r, i = n._a;
switch (e) {
case "M":
case "MM":
t != null && (i[o] = it(t) - 1);
break;
case "MMM":
case "MMMM":
r = dt(n._l).monthsParse(t), r != null ? i[o] = r : n._pf.invalidMonth = t;
break;
case "D":
case "DD":
t != null && (i[u] = it(t));
break;
case "DDD":
case "DDDD":
t != null && (n._dayOfYear = it(t));
break;
case "YY":
i[s] = it(t) + (it(t) > 68 ? 1900 : 2e3);
break;
case "YYYY":
case "YYYYY":
i[s] = it(t);
break;
case "a":
case "A":
n._isPm = dt(n._l).isPM(t);
break;
case "H":
case "HH":
case "h":
case "hh":
i[a] = it(t);
break;
case "m":
case "mm":
i[f] = it(t);
break;
case "s":
case "ss":
i[l] = it(t);
break;
case "S":
case "SS":
case "SSS":
case "SSSS":
i[c] = it(("0." + t) * 1e3);
break;
case "X":
n._d = new Date(parseFloat(t) * 1e3);
break;
case "Z":
case "ZZ":
n._useUTC = !0, n._tzm = wt(t);
break;
case "w":
case "ww":
case "W":
case "WW":
case "d":
case "dd":
case "ddd":
case "dddd":
case "e":
case "E":
e = e.substr(0, 1);
case "gg":
case "gggg":
case "GG":
case "GGGG":
case "GGGGG":
e = e.substr(0, 2), t && (n._w = n._w || {}, n._w[e] = t);
}
}
function St(e) {
var n, r, i = [], l, c, h, p, d, v, m, g;
if (e._d) return;
l = Tt(e), e._w && e._a[u] == null && e._a[o] == null && (h = function(n) {
return n ? n.length < 3 ? parseInt(n, 10) > 68 ? "19" + n : "20" + n : n : e._a[s] == null ? t().weekYear() : e._a[s];
}, p = e._w, p.GG != null || p.W != null || p.E != null ? d = jt(h(p.GG), p.W || 1, p.E, 4, 1) : (v = dt(e._l), m = p.d != null ? Dt(p.d, v) : p.e != null ? parseInt(p.e, 10) + v._week.dow : 0, g = parseInt(p.w, 10) || 1, p.d != null && m < v._week.dow && g++, d = jt(h(p.gg), g, m, v._week.doy, v._week.dow)), e._a[s] = d.year, e._dayOfYear = d.dayOfYear), e._dayOfYear && (c = e._a[s] == null ? l[s] : e._a[s], e._dayOfYear > ot(c) && (e._pf._overflowDayOfYear = !0), r = _t(c, 0, e._dayOfYear), e._a[o] = r.getUTCMonth(), e._a[u] = r.getUTCDate());
for (n = 0; n < 3 && e._a[n] == null; ++n) e._a[n] = i[n] = l[n];
for (; n < 7; n++) e._a[n] = i[n] = e._a[n] == null ? n === 2 ? 1 : 0 : e._a[n];
i[a] += it((e._tzm || 0) / 60), i[f] += it((e._tzm || 0) % 60), e._d = (e._useUTC ? _t : Mt).apply(null, i);
}
function xt(e) {
var t;
if (e._d) return;
t = nt(e._i), e._a = [ t.year, t.month, t.day, t.hour, t.minute, t.second, t.millisecond ], St(e);
}
function Tt(e) {
var t = new Date;
return e._useUTC ? [ t.getUTCFullYear(), t.getUTCMonth(), t.getUTCDate() ] : [ t.getFullYear(), t.getMonth(), t.getDate() ];
}
function Nt(e) {
e._a = [], e._pf.empty = !0;
var t = dt(e._l), n = "" + e._i, r, i, s, o, u, f = n.length, l = 0;
s = yt(e._f, t).match(g) || [];
for (r = 0; r < s.length; r++) o = s[r], i = (bt(o, e).exec(n) || [])[0], i && (u = n.substr(0, n.indexOf(i)), u.length > 0 && e._pf.unusedInput.push(u), n = n.slice(n.indexOf(i) + i.length), l += i.length), R[o] ? (i ? e._pf.empty = !1 : e._pf.unusedTokens.push(o), Et(o, i, e)) : e._strict && !i && e._pf.unusedTokens.push(o);
e._pf.charsLeftOver = f - l, n.length > 0 && e._pf.unusedInput.push(n), e._isPm && e._a[a] < 12 && (e._a[a] += 12), e._isPm === !1 && e._a[a] === 12 && (e._a[a] = 0), St(e), at(e);
}
function Ct(e) {
return e.replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g, function(e, t, n, r, i) {
return t || n || r || i;
});
}
function kt(e) {
return e.replace(/[-\/\\^$*+?.()|[\]{}]/g, "\\$&");
}
function Lt(e) {
var t, n, r, i, s;
if (e._f.length === 0) {
e._pf.invalidFormat = !0, e._d = new Date(NaN);
return;
}
for (i = 0; i < e._f.length; i++) {
s = 0, t = J({}, e), ft(t), t._f = e._f[i], Nt(t);
if (!lt(t)) continue;
s += t._pf.charsLeftOver, s += t._pf.unusedTokens.length * 10, t._pf.score = s;
if (r == null || s < r) r = s, n = t;
}
J(e, n || t);
}
function At(e) {
var t, n = e._i, r = A.exec(n);
if (r) {
e._pf.iso = !0;
for (t = 4; t > 0; t--) if (r[t]) {
e._f = M[t - 1] + (r[6] || " ");
break;
}
for (t = 0; t < 4; t++) if (_[t][1].exec(n)) {
e._f += _[t][0];
break;
}
C.exec(n) && (e._f += "Z"), Nt(e);
} else e._d = new Date(n);
}
function Ot(t) {
var n = t._i, r = d.exec(n);
n === e ? t._d = new Date : r ? t._d = new Date(+r[1]) : typeof n == "string" ? At(t) : Y(n) ? (t._a = n.slice(0), St(t)) : Z(n) ? t._d = new Date(+n) : typeof n == "object" ? xt(t) : t._d = new Date(n);
}
function Mt(e, t, n, r, i, s, o) {
var u = new Date(e, t, n, r, i, s, o);
return e < 1970 && u.setFullYear(e), u;
}
function _t(e) {
var t = new Date(Date.UTC.apply(null, arguments));
return e < 1970 && t.setUTCFullYear(e), t;
}
function Dt(e, t) {
if (typeof e == "string") if (!isNaN(e)) e = parseInt(e, 10); else {
e = t.weekdaysParse(e);
if (typeof e != "number") return null;
}
return e;
}
function Pt(e, t, n, r, i) {
return i.relativeTime(t || 1, !!n, e, r);
}
function Ht(e, t, n) {
var i = r(Math.abs(e) / 1e3), s = r(i / 60), o = r(s / 60), u = r(o / 24), a = r(u / 365), f = i < 45 && [ "s", i ] || s === 1 && [ "m" ] || s < 45 && [ "mm", s ] || o === 1 && [ "h" ] || o < 22 && [ "hh", o ] || u === 1 && [ "d" ] || u <= 25 && [ "dd", u ] || u <= 45 && [ "M" ] || u < 345 && [ "MM", r(u / 30) ] || a === 1 && [ "y" ] || [ "yy", a ];
return f[2] = t, f[3] = e > 0, f[4] = n, Pt.apply({}, f);
}
function Bt(e, n, r) {
var i = r - n, s = r - e.day(), o;
return s > i && (s -= 7), s < i - 7 && (s += 7), o = t(e).add("d", s), {
week: Math.ceil(o.dayOfYear() / 7),
year: o.year()
};
}
function jt(e, t, n, r, i) {
var s = (new Date(Date.UTC(e, 0))).getUTCDay(), o, u;
return n = n != null ? n : i, o = i - s + (s > r ? 7 : 0), u = 7 * (t - 1) + (n - i) + o + 1, {
year: u > 0 ? e : e - 1,
dayOfYear: u > 0 ? u : ot(e - 1) + u
};
}
function Ft(e) {
var n = e._i, r = e._f;
return typeof e._pf == "undefined" && ft(e), n === null ? t.invalid({
nullInput: !0
}) : (typeof n == "string" && (e._i = n = dt().preparse(n)), t.isMoment(n) ? (e = J({}, n), e._d = new Date(+n._d)) : r ? Y(r) ? Lt(e) : Nt(e) : Ot(e), new V(e));
}
function It(e, n) {
t.fn[e] = t.fn[e + "s"] = function(e) {
var r = this._isUTC ? "UTC" : "";
return e != null ? (this._d["set" + r + n](e), t.updateOffset(this), this) : this._d["get" + r + n]();
};
}
function qt(e) {
t.duration.fn[e] = function() {
return this._data[e];
};
}
function Rt(e, n) {
t.duration.fn["as" + e] = function() {
return +this / n;
};
}
function Ut(e) {
var n = !1, r = t;
if (typeof ender != "undefined") return;
e ? this.moment = function() {
return !n && console && console.warn && (n = !0, console.warn("Accessing Moment through the global scope is deprecated, and will be removed in an upcoming release.")), r.apply(null, arguments);
} : this.moment = t;
}
var t, n = "2.4.0", r = Math.round, i, s = 0, o = 1, u = 2, a = 3, f = 4, l = 5, c = 6, h = {}, p = typeof module != "undefined" && module.exports, d = /^\/?Date\((\-?\d+)/i, v = /(\-)?(?:(\d*)\.)?(\d+)\:(\d+)(?:\:(\d+)\.?(\d{3})?)?/, m = /^(-)?P(?:(?:([0-9,.]*)Y)?(?:([0-9,.]*)M)?(?:([0-9,.]*)D)?(?:T(?:([0-9,.]*)H)?(?:([0-9,.]*)M)?(?:([0-9,.]*)S)?)?|([0-9,.]*)W)$/, g = /(\[[^\[]*\])|(\\)?(Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|mm?|ss?|S{1,4}|X|zz?|ZZ?|.)/g, y = /(\[[^\[]*\])|(\\)?(LT|LL?L?L?|l{1,4})/g, b = /\d\d?/, w = /\d{1,3}/, E = /\d{3}/, S = /\d{1,4}/, x = /[+\-]?\d{1,6}/, T = /\d+/, N = /[0-9]*['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+|[\u0600-\u06FF\/]+(\s*?[\u0600-\u06FF]+){1,2}/i, C = /Z|[\+\-]\d\d:?\d\d/i, k = /T/i, L = /[\+\-]?\d+(\.\d{1,3})?/, A = /^\s*\d{4}-(?:(\d\d-\d\d)|(W\d\d$)|(W\d\d-\d)|(\d\d\d))((T| )(\d\d(:\d\d(:\d\d(\.\d+)?)?)?)?([\+\-]\d\d:?\d\d|Z)?)?$/, O = "YYYY-MM-DDTHH:mm:ssZ", M = [ "YYYY-MM-DD", "GGGG-[W]WW", "GGGG-[W]WW-E", "YYYY-DDD" ], _ = [ [ "HH:mm:ss.SSSS", /(T| )\d\d:\d\d:\d\d\.\d{1,3}/ ], [ "HH:mm:ss", /(T| )\d\d:\d\d:\d\d/ ], [ "HH:mm", /(T| )\d\d:\d\d/ ], [ "HH", /(T| )\d\d/ ] ], D = /([\+\-]|\d\d)/gi, P = "Date|Hours|Minutes|Seconds|Milliseconds".split("|"), H = {
Milliseconds: 1,
Seconds: 1e3,
Minutes: 6e4,
Hours: 36e5,
Days: 864e5,
Months: 2592e6,
Years: 31536e6
}, B = {
ms: "millisecond",
s: "second",
m: "minute",
h: "hour",
d: "day",
D: "date",
w: "week",
W: "isoWeek",
M: "month",
y: "year",
DDD: "dayOfYear",
e: "weekday",
E: "isoWeekday",
gg: "weekYear",
GG: "isoWeekYear"
}, j = {
dayofyear: "dayOfYear",
isoweekday: "isoWeekday",
isoweek: "isoWeek",
weekyear: "weekYear",
isoweekyear: "isoWeekYear"
}, F = {}, I = "DDD w W M D d".split(" "), q = "M D H h m s w W".split(" "), R = {
M: function() {
return this.month() + 1;
},
MMM: function(e) {
return this.lang().monthsShort(this, e);
},
MMMM: function(e) {
return this.lang().months(this, e);
},
D: function() {
return this.date();
},
DDD: function() {
return this.dayOfYear();
},
d: function() {
return this.day();
},
dd: function(e) {
return this.lang().weekdaysMin(this, e);
},
ddd: function(e) {
return this.lang().weekdaysShort(this, e);
},
dddd: function(e) {
return this.lang().weekdays(this, e);
},
w: function() {
return this.week();
},
W: function() {
return this.isoWeek();
},
YY: function() {
return Q(this.year() % 100, 2);
},
YYYY: function() {
return Q(this.year(), 4);
},
YYYYY: function() {
return Q(this.year(), 5);
},
gg: function() {
return Q(this.weekYear() % 100, 2);
},
gggg: function() {
return this.weekYear();
},
ggggg: function() {
return Q(this.weekYear(), 5);
},
GG: function() {
return Q(this.isoWeekYear() % 100, 2);
},
GGGG: function() {
return this.isoWeekYear();
},
GGGGG: function() {
return Q(this.isoWeekYear(), 5);
},
e: function() {
return this.weekday();
},
E: function() {
return this.isoWeekday();
},
a: function() {
return this.lang().meridiem(this.hours(), this.minutes(), !0);
},
A: function() {
return this.lang().meridiem(this.hours(), this.minutes(), !1);
},
H: function() {
return this.hours();
},
h: function() {
return this.hours() % 12 || 12;
},
m: function() {
return this.minutes();
},
s: function() {
return this.seconds();
},
S: function() {
return it(this.milliseconds() / 100);
},
SS: function() {
return Q(it(this.milliseconds() / 10), 2);
},
SSS: function() {
return Q(this.milliseconds(), 3);
},
SSSS: function() {
return Q(this.milliseconds(), 3);
},
Z: function() {
var e = -this.zone(), t = "+";
return e < 0 && (e = -e, t = "-"), t + Q(it(e / 60), 2) + ":" + Q(it(e) % 60, 2);
},
ZZ: function() {
var e = -this.zone(), t = "+";
return e < 0 && (e = -e, t = "-"), t + Q(it(10 * e / 6), 4);
},
z: function() {
return this.zoneAbbr();
},
zz: function() {
return this.zoneName();
},
X: function() {
return this.unix();
}
}, U = [ "months", "monthsShort", "weekdays", "weekdaysShort", "weekdaysMin" ];
while (I.length) i = I.pop(), R[i + "o"] = W(R[i], i);
while (q.length) i = q.pop(), R[i + i] = z(R[i], 2);
R.DDDD = z(R.DDD, 3), J(X.prototype, {
set: function(e) {
var t, n;
for (n in e) t = e[n], typeof t == "function" ? this[n] = t : this["_" + n] = t;
},
_months: "January_February_March_April_May_June_July_August_September_October_November_December".split("_"),
months: function(e) {
return this._months[e.month()];
},
_monthsShort: "Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),
monthsShort: function(e) {
return this._monthsShort[e.month()];
},
monthsParse: function(e) {
var n, r, i;
this._monthsParse || (this._monthsParse = []);
for (n = 0; n < 12; n++) {
this._monthsParse[n] || (r = t.utc([ 2e3, n ]), i = "^" + this.months(r, "") + "|^" + this.monthsShort(r, ""), this._monthsParse[n] = new RegExp(i.replace(".", ""), "i"));
if (this._monthsParse[n].test(e)) return n;
}
},
_weekdays: "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),
weekdays: function(e) {
return this._weekdays[e.day()];
},
_weekdaysShort: "Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),
weekdaysShort: function(e) {
return this._weekdaysShort[e.day()];
},
_weekdaysMin: "Su_Mo_Tu_We_Th_Fr_Sa".split("_"),
weekdaysMin: function(e) {
return this._weekdaysMin[e.day()];
},
weekdaysParse: function(e) {
var n, r, i;
this._weekdaysParse || (this._weekdaysParse = []);
for (n = 0; n < 7; n++) {
this._weekdaysParse[n] || (r = t([ 2e3, 1 ]).day(n), i = "^" + this.weekdays(r, "") + "|^" + this.weekdaysShort(r, "") + "|^" + this.weekdaysMin(r, ""), this._weekdaysParse[n] = new RegExp(i.replace(".", ""), "i"));
if (this._weekdaysParse[n].test(e)) return n;
}
},
_longDateFormat: {
LT: "h:mm A",
L: "MM/DD/YYYY",
LL: "MMMM D YYYY",
LLL: "MMMM D YYYY LT",
LLLL: "dddd, MMMM D YYYY LT"
},
longDateFormat: function(e) {
var t = this._longDateFormat[e];
return !t && this._longDateFormat[e.toUpperCase()] && (t = this._longDateFormat[e.toUpperCase()].replace(/MMMM|MM|DD|dddd/g, function(e) {
return e.slice(1);
}), this._longDateFormat[e] = t), t;
},
isPM: function(e) {
return (e + "").toLowerCase().charAt(0) === "p";
},
_meridiemParse: /[ap]\.?m?\.?/i,
meridiem: function(e, t, n) {
return e > 11 ? n ? "pm" : "PM" : n ? "am" : "AM";
},
_calendar: {
sameDay: "[Today at] LT",
nextDay: "[Tomorrow at] LT",
nextWeek: "dddd [at] LT",
lastDay: "[Yesterday at] LT",
lastWeek: "[Last] dddd [at] LT",
sameElse: "L"
},
calendar: function(e, t) {
var n = this._calendar[e];
return typeof n == "function" ? n.apply(t) : n;
},
_relativeTime: {
future: "in %s",
past: "%s ago",
s: "a few seconds",
m: "a minute",
mm: "%d minutes",
h: "an hour",
hh: "%d hours",
d: "a day",
dd: "%d days",
M: "a month",
MM: "%d months",
y: "a year",
yy: "%d years"
},
relativeTime: function(e, t, n, r) {
var i = this._relativeTime[n];
return typeof i == "function" ? i(e, t, n, r) : i.replace(/%d/i, e);
},
pastFuture: function(e, t) {
var n = this._relativeTime[e > 0 ? "future" : "past"];
return typeof n == "function" ? n(t) : n.replace(/%s/i, t);
},
ordinal: function(e) {
return this._ordinal.replace("%d", e);
},
_ordinal: "%d",
preparse: function(e) {
return e;
},
postformat: function(e) {
return e;
},
week: function(e) {
return Bt(e, this._week.dow, this._week.doy).week;
},
_week: {
dow: 0,
doy: 6
},
_invalidDate: "Invalid date",
invalidDate: function() {
return this._invalidDate;
}
}), t = function(t, n, r, i) {
return typeof r == "boolean" && (i = r, r = e), Ft({
_i: t,
_f: n,
_l: r,
_strict: i,
_isUTC: !1
});
}, t.utc = function(t, n, r, i) {
var s;
return typeof r == "boolean" && (i = r, r = e), s = Ft({
_useUTC: !0,
_isUTC: !0,
_l: r,
_i: t,
_f: n,
_strict: i
}).utc(), s;
}, t.unix = function(e) {
return t(e * 1e3);
}, t.duration = function(e, n) {
var r = t.isDuration(e), i = typeof e == "number", s = r ? e._input : i ? {} : e, o = null, h, p, d, g, y;
return i ? n ? s[n] = e : s.milliseconds = e : (o = v.exec(e)) ? (h = o[1] === "-" ? -1 : 1, s = {
y: 0,
d: it(o[u]) * h,
h: it(o[a]) * h,
m: it(o[f]) * h,
s: it(o[l]) * h,
ms: it(o[c]) * h
}) : !(o = m.exec(e)) || (h = o[1] === "-" ? -1 : 1, d = function(e) {
var t = e && parseFloat(e.replace(",", "."));
return (isNaN(t) ? 0 : t) * h;
}, s = {
y: d(o[2]),
M: d(o[3]),
d: d(o[4]),
h: d(o[5]),
m: d(o[6]),
s: d(o[7]),
w: d(o[8])
}), p = new $(s), r && e.hasOwnProperty("_lang") && (p._lang = e._lang), p;
}, t.version = n, t.defaultFormat = O, t.updateOffset = function() {}, t.lang = function(e, n) {
var r;
return e ? (n ? ht(ct(e), n) : n === null ? (pt(e), e = "en") : h[e] || dt(e), r = t.duration.fn._lang = t.fn._lang = dt(e), r._abbr) : t.fn._lang._abbr;
}, t.langData = function(e) {
return e && e._lang && e._lang._abbr && (e = e._lang._abbr), dt(e);
}, t.isMoment = function(e) {
return e instanceof V;
}, t.isDuration = function(e) {
return e instanceof $;
};
for (i = U.length - 1; i >= 0; --i) rt(U[i]);
t.normalizeUnits = function(e) {
return tt(e);
}, t.invalid = function(e) {
var n = t.utc(NaN);
return e != null ? J(n._pf, e) : n._pf.userInvalidated = !0, n;
}, t.parseZone = function(e) {
return t(e).parseZone();
}, J(t.fn = V.prototype, {
clone: function() {
return t(this);
},
valueOf: function() {
return +this._d + (this._offset || 0) * 6e4;
},
unix: function() {
return Math.floor(+this / 1e3);
},
toString: function() {
return this.clone().lang("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ");
},
toDate: function() {
return this._offset ? new Date(+this) : this._d;
},
toISOString: function() {
return gt(t(this).utc(), "YYYY-MM-DD[T]HH:mm:ss.SSS[Z]");
},
toArray: function() {
var e = this;
return [ e.year(), e.month(), e.date(), e.hours(), e.minutes(), e.seconds(), e.milliseconds() ];
},
isValid: function() {
return lt(this);
},
isDSTShifted: function() {
return this._a ? this.isValid() && et(this._a, (this._isUTC ? t.utc(this._a) : t(this._a)).toArray()) > 0 : !1;
},
parsingFlags: function() {
return J({}, this._pf);
},
invalidAt: function() {
return this._pf.overflow;
},
utc: function() {
return this.zone(0);
},
local: function() {
return this.zone(0), this._isUTC = !1, this;
},
format: function(e) {
var n = gt(this, e || t.defaultFormat);
return this.lang().postformat(n);
},
add: function(e, n) {
var r;
return typeof e == "string" ? r = t.duration(+n, e) : r = t.duration(e, n), G(this, r, 1), this;
},
subtract: function(e, n) {
var r;
return typeof e == "string" ? r = t.duration(+n, e) : r = t.duration(e, n), G(this, r, -1), this;
},
diff: function(e, n, r) {
var i = this._isUTC ? t(e).zone(this._offset || 0) : t(e).local(), s = (this.zone() - i.zone()) * 6e4, o, u;
return n = tt(n), n === "year" || n === "month" ? (o = (this.daysInMonth() + i.daysInMonth()) * 432e5, u = (this.year() - i.year()) * 12 + (this.month() - i.month()), u += (this - t(this).startOf("month") - (i - t(i).startOf("month"))) / o, u -= (this.zone() - t(this).startOf("month").zone() - (i.zone() - t(i).startOf("month").zone())) * 6e4 / o, n === "year" && (u /= 12)) : (o = this - i, u = n === "second" ? o / 1e3 : n === "minute" ? o / 6e4 : n === "hour" ? o / 36e5 : n === "day" ? (o - s) / 864e5 : n === "week" ? (o - s) / 6048e5 : o), r ? u : K(u);
},
from: function(e, n) {
return t.duration(this.diff(e)).lang(this.lang()._abbr).humanize(!n);
},
fromNow: function(e) {
return this.from(t(), e);
},
calendar: function() {
var e = this.diff(t().zone(this.zone()).startOf("day"), "days", !0), n = e < -6 ? "sameElse" : e < -1 ? "lastWeek" : e < 0 ? "lastDay" : e < 1 ? "sameDay" : e < 2 ? "nextDay" : e < 7 ? "nextWeek" : "sameElse";
return this.format(this.lang().calendar(n, this));
},
isLeapYear: function() {
return ut(this.year());
},
isDST: function() {
return this.zone() < this.clone().month(0).zone() || this.zone() < this.clone().month(5).zone();
},
day: function(e) {
var t = this._isUTC ? this._d.getUTCDay() : this._d.getDay();
return e != null ? (e = Dt(e, this.lang()), this.add({
d: e - t
})) : t;
},
month: function(e) {
var n = this._isUTC ? "UTC" : "", r;
if (e != null) {
if (typeof e == "string") {
e = this.lang().monthsParse(e);
if (typeof e != "number") return this;
}
return r = this.date(), this.date(1), this._d["set" + n + "Month"](e), this.date(Math.min(r, this.daysInMonth())), t.updateOffset(this), this;
}
return this._d["get" + n + "Month"]();
},
startOf: function(e) {
e = tt(e);
switch (e) {
case "year":
this.month(0);
case "month":
this.date(1);
case "week":
case "isoWeek":
case "day":
this.hours(0);
case "hour":
this.minutes(0);
case "minute":
this.seconds(0);
case "second":
this.milliseconds(0);
}
return e === "week" ? this.weekday(0) : e === "isoWeek" && this.isoWeekday(1), this;
},
endOf: function(e) {
return e = tt(e), this.startOf(e).add(e === "isoWeek" ? "week" : e, 1).subtract("ms", 1);
},
isAfter: function(e, n) {
return n = typeof n != "undefined" ? n : "millisecond", +this.clone().startOf(n) > +t(e).startOf(n);
},
isBefore: function(e, n) {
return n = typeof n != "undefined" ? n : "millisecond", +this.clone().startOf(n) < +t(e).startOf(n);
},
isSame: function(e, n) {
return n = typeof n != "undefined" ? n : "millisecond", +this.clone().startOf(n) === +t(e).startOf(n);
},
min: function(e) {
return e = t.apply(null, arguments), e < this ? this : e;
},
max: function(e) {
return e = t.apply(null, arguments), e > this ? this : e;
},
zone: function(e) {
var n = this._offset || 0;
return e == null ? this._isUTC ? n : this._d.getTimezoneOffset() : (typeof e == "string" && (e = wt(e)), Math.abs(e) < 16 && (e *= 60), this._offset = e, this._isUTC = !0, n !== e && G(this, t.duration(n - e, "m"), 1, !0), this);
},
zoneAbbr: function() {
return this._isUTC ? "UTC" : "";
},
zoneName: function() {
return this._isUTC ? "Coordinated Universal Time" : "";
},
parseZone: function() {
return typeof this._i == "string" && this.zone(this._i), this;
},
hasAlignedHourOffset: function(e) {
return e ? e = t(e).zone() : e = 0, (this.zone() - e) % 60 === 0;
},
daysInMonth: function() {
return st(this.year(), this.month());
},
dayOfYear: function(e) {
var n = r((t(this).startOf("day") - t(this).startOf("year")) / 864e5) + 1;
return e == null ? n : this.add("d", e - n);
},
weekYear: function(e) {
var t = Bt(this, this.lang()._week.dow, this.lang()._week.doy).year;
return e == null ? t : this.add("y", e - t);
},
isoWeekYear: function(e) {
var t = Bt(this, 1, 4).year;
return e == null ? t : this.add("y", e - t);
},
week: function(e) {
var t = this.lang().week(this);
return e == null ? t : this.add("d", (e - t) * 7);
},
isoWeek: function(e) {
var t = Bt(this, 1, 4).week;
return e == null ? t : this.add("d", (e - t) * 7);
},
weekday: function(e) {
var t = (this.day() + 7 - this.lang()._week.dow) % 7;
return e == null ? t : this.add("d", e - t);
},
isoWeekday: function(e) {
return e == null ? this.day() || 7 : this.day(this.day() % 7 ? e : e - 7);
},
get: function(e) {
return e = tt(e), this[e]();
},
set: function(e, t) {
return e = tt(e), typeof this[e] == "function" && this[e](t), this;
},
lang: function(t) {
return t === e ? this._lang : (this._lang = dt(t), this);
}
});
for (i = 0; i < P.length; i++) It(P[i].toLowerCase().replace(/s$/, ""), P[i]);
It("year", "FullYear"), t.fn.days = t.fn.day, t.fn.months = t.fn.month, t.fn.weeks = t.fn.week, t.fn.isoWeeks = t.fn.isoWeek, t.fn.toJSON = t.fn.toISOString, J(t.duration.fn = $.prototype, {
_bubble: function() {
var e = this._milliseconds, t = this._days, n = this._months, r = this._data, i, s, o, u;
r.milliseconds = e % 1e3, i = K(e / 1e3), r.seconds = i % 60, s = K(i / 60), r.minutes = s % 60, o = K(s / 60), r.hours = o % 24, t += K(o / 24), r.days = t % 30, n += K(t / 30), r.months = n % 12, u = K(n / 12), r.years = u;
},
weeks: function() {
return K(this.days() / 7);
},
valueOf: function() {
return this._milliseconds + this._days * 864e5 + this._months % 12 * 2592e6 + it(this._months / 12) * 31536e6;
},
humanize: function(e) {
var t = +this, n = Ht(t, !e, this.lang());
return e && (n = this.lang().pastFuture(t, n)), this.lang().postformat(n);
},
add: function(e, n) {
var r = t.duration(e, n);
return this._milliseconds += r._milliseconds, this._days += r._days, this._months += r._months, this._bubble(), this;
},
subtract: function(e, n) {
var r = t.duration(e, n);
return this._milliseconds -= r._milliseconds, this._days -= r._days, this._months -= r._months, this._bubble(), this;
},
get: function(e) {
return e = tt(e), this[e.toLowerCase() + "s"]();
},
as: function(e) {
return e = tt(e), this["as" + e.charAt(0).toUpperCase() + e.slice(1) + "s"]();
},
lang: t.fn.lang,
toIsoString: function() {
var e = Math.abs(this.years()), t = Math.abs(this.months()), n = Math.abs(this.days()), r = Math.abs(this.hours()), i = Math.abs(this.minutes()), s = Math.abs(this.seconds() + this.milliseconds() / 1e3);
return this.asSeconds() ? (this.asSeconds() < 0 ? "-" : "") + "P" + (e ? e + "Y" : "") + (t ? t + "M" : "") + (n ? n + "D" : "") + (r || i || s ? "T" : "") + (r ? r + "H" : "") + (i ? i + "M" : "") + (s ? s + "S" : "") : "P0D";
}
});
for (i in H) H.hasOwnProperty(i) && (Rt(i, H[i]), qt(i.toLowerCase()));
Rt("Weeks", 6048e5), t.duration.fn.asMonths = function() {
return (+this - this.years() * 31536e6) / 2592e6 + this.years() * 12;
}, t.lang("en", {
ordinal: function(e) {
var t = e % 10, n = it(e % 100 / 10) === 1 ? "th" : t === 1 ? "st" : t === 2 ? "nd" : t === 3 ? "rd" : "th";
return e + n;
}
}), p ? (module.exports = t, Ut(!0)) : typeof define == "function" && define.amd ? define("moment", function(n, r, i) {
return i.config().noGlobal !== !0 && Ut(i.config().noGlobal === e), t;
}) : Ut();
}).call(this);

// foundation.js

XT = typeof XT != "undefined" ? XT : {}, _.extend(XT, {
ASCII: {
CARRIAGE_RETURN: 13,
N_DASH: 45,
ZERO: 48,
NINE: 57,
VULGAR_HALF: 189
},
debugging: !1,
_date: new Date,
toReadableTimestamp: function(e) {
var t = XT._date || (XT._date = new Date);
return t.setTime(e), t.toLocaleTimeString();
},
generateUUID: function() {
var e = (new Date).getTime(), t = "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(t) {
var n = (e + Math.random() * 16) % 16 | 0;
return e = Math.floor(e / 16), (t === "x" ? n : n & 7 | 8).toString(16);
});
return t;
},
getObjectByName: function(e) {
if (!e.split) return null;
var t = e.split("."), n, r, i = 0;
for (; i < t.length; ++i) {
r = t[i], n = n ? n[r] : typeof window != "undefined" ? window[r] : global[r];
if (n === null || n === undefined) return null;
}
return n;
},
A: function(e) {
if (e === null || e === undefined) return [];
if (e.slice instanceof Function) return typeof e == "string" ? [ e ] : e.slice();
var t = [];
if (e.length) {
var n = e.length;
while (--n >= 0) t[n] = e[n];
return t;
}
return _.values(e);
}
}), XT.$A = XT.A;

// error.js

(function() {
"use strict";
XT.Error = function() {}, XT.Error.prototype = {
code: null,
messageKey: null,
params: {},
message: function() {
var e = (this.messageKey || "").loc(), t, n;
for (t in this.params) if (this.params.hasOwnProperty(t)) {
var r = this.params[t];
_.isString(r) || (r = JSON.stringify(r)), n = (r || "_unknown").loc(), e = e.replace("{" + t + "}", n);
}
return e;
}
}, _.extend(XT.Error, {
clone: function(e, t) {
var n;
t = t || {};
if (e) {
n = _.find(XT.errors, function(t) {
return t.code === e;
});
if (!n) return !1;
}
return n = _.clone(n), n.params && (n.params = _.clone(n.params)), _.extend(n, t), XT.Error.create(n);
},
create: function(e) {
var t;
return e = e || {}, t = new XT.Error, _.extend(t, e), t;
}
});
var e = [ {
code: "xt1001",
params: {
error: null
},
messageKey: "_datasourceError"
}, {
code: "xt1002",
params: {
attr: null
},
messageKey: "_attributeNotInSchema"
}, {
code: "xt1003",
params: {
attr: null,
type: null
},
messageKey: "_attributeTypeMismatch"
}, {
code: "xt1004",
params: {
attr: null
},
messageKey: "_attributeIsRequired"
}, {
code: "xt1005",
messageKey: "_attributeReadOnly"
}, {
code: "xt1006",
params: {
attr: null,
length: null
},
messageKey: "_lengthInvalid"
}, {
code: "xt1007",
messageKey: "_recordNotFound"
}, {
code: "xt1008",
params: {
attr: null,
value: null
},
messageKey: "_valueExists"
}, {
code: "xt1009",
params: {
status: null
},
messageKey: "_recordStatusNotEditable"
}, {
code: "xt1010",
messageKey: "_canNotUpdate"
}, {
code: "xt1011",
messageKey: "_localResourceNotAllowed"
}, {
code: "xt1012",
messageKey: "_saveFirst"
}, {
code: "xt1013",
params: {
attr: null,
value: null
},
messageKey: "_invalidValue"
}, {
code: "xt2001",
messageKey: "_assignedToRequiredAssigned"
}, {
code: "xt2002",
messageKey: "_characteristicContextRequired"
}, {
code: "xt2003",
messageKey: "_duplicateValues"
}, {
code: "xt2004",
messageKey: "_nameRequired"
}, {
code: "xt2005",
messageKey: "_productCategoryRequiredOnSold"
}, {
code: "xt2006",
messageKey: "_recursiveParentDisallowed"
}, {
code: "xt2007",
messageKey: "_addressShared"
}, {
code: "xt2008",
messageKey: "_countryInvalid"
}, {
code: "xt2009",
messageKey: "_invalidAddress"
}, {
code: "xt2010",
messageKey: "_currencyRateNotFound"
}, {
code: "xt2011",
messageKey: "_totalMustBePositive"
}, {
code: "xt2012",
messageKey: "_lineItemsRequired"
}, {
code: "xt2013",
messageKey: "_quantityMustBePositive"
}, {
code: "xt2014",
messageKey: "_notFractional"
}, {
code: "xt2015",
params: {
start: null,
end: null
},
messageKey: "_endPriorToStart"
}, {
code: "xt2016",
messageKey: "_passwordsDoNotMatch"
}, {
code: "xt2017",
messageKey: "_incompleteDistribution"
}, {
code: "xt2018",
messageKey: "_missingExtensionDependency"
}, {
code: "xt2019",
messageKey: "_negativeQuantityNoAverage"
}, {
code: "xt2020",
messageKey: "_stockedMustReorder"
}, {
code: "xt2021",
messageKey: "_itemSiteActiveItemInactive"
}, {
code: "xt2022",
messageKey: "_canNotCreateOrderOnCreditWarn"
}, {
code: "xt2023",
messageKey: "_canNotCreateOrderOnCreditHold"
}, {
code: "xt2024",
messageKey: "_taxesMustNotBeGreater"
}, {
code: "xt2025",
messageKey: "_orderWithActivityNoUnrelease"
}, {
code: "xt2026",
messageKey: "_distributionMustNotBeGreater"
} ];
XT.errors = [], XT.Error.addError = function(e) {
var t = XT.Error.create(e);
XT.errors.push(t);
}, _.each(e, XT.Error.addError);
})();

// log.js

XT.log = function() {
var e = XT.$A(arguments);
console.log.apply ? console.log.apply(console, e) : console.log(e.join(" "));
};

// datasource.js

(function() {
"use strict";
XT.DataSource = {
datasourceUrl: null,
datasourcePort: null,
isConnected: !1,
request: function(e, t, n, r) {}
};
})();

// date.js

(function() {
"use strict";
XT.date = {
applyTimezoneOffset: function(e, t) {
var n = t ? 1 : -1;
return new Date(e.valueOf() + n * 6e4 * e.getTimezoneOffset());
},
convert: function(e) {
return e.constructor === Date ? e : e.constructor === Array ? new Date(e[0], e[1], e[2]) : e.constructor === Number ? new Date(e) : e.constructor === String ? new Date(e) : typeof e == "object" ? new Date(e.year, e.month, e.date) : NaN;
},
compare: function(e, t) {
return isFinite(e = this.convert(e).valueOf()) && isFinite(t = this.convert(t).valueOf()) ? (e > t) - (e < t) : NaN;
},
compareDate: function(e, t) {
if (!e || !t) return NaN;
var n = new Date(e.valueOf()), r = new Date(t.valueOf());
return n.setHours(0, 0, 0, 0), r.setHours(0, 0, 0, 0), this.compare(n, r);
},
daysBetween: function(e, t) {
var n = 864e5, r = e.getTime() - t.getTime();
return Math.round(r / n);
},
inRange: function(e, t, n) {
return isFinite(e = this.convert(e).valueOf()) && isFinite(t = this.convert(t).valueOf()) && isFinite(n = this.convert(n).valueOf()) ? t <= e && e <= n : NaN;
},
toMidnight: function(e) {
return e.setHours(0), e.setMinutes(0), e.setSeconds(0), e.setMilliseconds(0), e;
},
today: function() {
var e = new Date;
return this.toMidnight(e);
},
endOfTime: function() {
return new Date("2100-01-01T00:00:00.000Z");
},
startOfTime: function() {
return new Date("1970-01-01T00:00:00.000Z");
},
isEndOfTime: function(e) {
return e instanceof Date ? this.compare(this.endOfTime(), e) === 0 : !1;
},
isStartOfTime: function(e) {
return e instanceof Date ? this.compare(this.startOfTime(), e) === 0 : !1;
}
};
})();

// math.js

(function() {
"use strict";
XT.math = {
add: function(e, t, n) {
var r = 0, i;
return typeof e == "object" ? (n = t || 0, i = Math.pow(10, n), _.each(e, function(e) {
r += e * i;
})) : (n = n || 0, i = Math.pow(10, n), r = e * i + t * i), r !== 0 ? Math.round(r) / i : r;
},
round: function(e, t) {
t = t || 0;
var n = Math.pow(10, t);
return Math.round(e * n) / n;
},
subtract: function(e, t, n) {
n = n || 0;
var r = Math.pow(10, n), i = Math.round(e * r - t * r);
return i !== 0 ? i / r : 0;
}
};
})();

// session.js

(function() {
"use strict";
XT.Session = {
details: {},
config: {},
availableSessions: [],
privileges: {},
settings: {},
schema: {},
extensions: {},
getAvailableSessions: function() {
return this.availableSessions;
},
getConfig: function() {
return this.config;
},
getDetails: function() {
return this.details;
},
setAvailableSessions: function(e) {
return this.availableSessions = e, this;
},
setConfig: function(e) {
return this.config = e, this;
},
setDetails: function(e) {
return this.details = e, this;
}
};
})();

// locale.js

(function() {
"use strict";
XT.localizeString = function(e) {
if (!XT.locale || !XT.getLanguage(XT.locale.culture)) return e.toString();
var t = XT.getLanguage(XT.locale.culture).strings;
return t[e] || e.toString();
}, XT.getLanguage = function(e) {
return _.find(XT.languages, function(t) {
return t.lang === e;
});
}, XT.stringsFor = function(e, t) {
var n;
return XT.languages || (XT.languages = []), n = XT.getLanguage(e), n ? n.strings = _.extend(n.strings, t) : (n = {
lang: e,
strings: t
}, XT.languages.push(n)), {
lang: e,
strings: t
};
}, typeof exports != "undefined" && (exports.getLanguage = XT.getLanguage, exports.stringsFor = XT.stringsFor), !XT.languages && XT.locale && XT.locale.strings && _.each(XT.locale.strings, function(e) {
XT.stringsFor(XT.locale.culture, e);
});
})();

// string.js

_.extend(String.prototype, {
camelize: function() {
var e = XT.$A(arguments);
return XT.String.camelize(this, e);
},
camelToHyphen: function() {
var e = XT.$A(arguments);
return XT.String.camelToHyphen(this, e);
},
decamelize: function() {
var e = XT.$A(arguments);
return XT.String.decamelize(this, e);
},
f: function() {
var e = XT.$A(arguments);
return XT.String.format(this, e);
},
loc: function() {
var e = XT.$A(arguments);
return e.unshift(this), XT.String.loc.apply(XT.String, e);
},
trim: function() {
return XT.String.trim(this);
},
pluralize: function() {
return owl.pluralize(this);
},
prefix: function() {
var e = XT.$A(arguments);
return XT.String.prefix(this, e);
},
suffix: function() {
var e = XT.$A(arguments);
return XT.String.suffix(this, e);
},
leftPad: function() {
var e = XT.$A(arguments);
return XT.String.leftPad(this.toString(), e[0], e[1]);
},
rightPad: function() {
var e = XT.$A(arguments);
return XT.String.rightPad(this.toString(), e[0], e[1]);
}
});

// pluralize.js

typeof owl == "undefined" && (owl = {}), owl.pluralize = function() {
function t(e, t) {
return t.match(/^[A-Z]/) ? e.charAt(0).toUpperCase() + e.slice(1) : e;
}
function n(e) {
e = e.split(",");
var t = e.length, n = {};
for (var r = 0; r < t; r++) n[e[r]] = 1;
return n;
}
function o(n, o, u) {
if (n === "") return "";
if (o === 1) return n;
if (typeof u == "string") return u;
var a = n.toLowerCase();
if (a in e) return t(e[a], n);
if (n.match(/^[A-Z]$/)) return n + "'s";
if (n.match(/fish$|ois$|sheep$|deer$|pox$|itis$/i)) return n;
if (n.match(/^[A-Z][a-z]*ese$/)) return n;
if (a in r) return n;
if (a in i) return t(i[a], n);
var f = s.length;
for (var l = 0; l < f; l++) {
var c = s[l];
if (n.match(c[0])) return n.replace(c[0], c[1]);
}
return n + "s";
}
var e = {}, r = n("aircraft,advice,blues,corn,molasses,equipment,gold,information,cotton,jewelry,kin,legislation,luck,luggage,moose,music,offspring,rice,silver,trousers,wheat,bison,bream,breeches,britches,carp,chassis,clippers,cod,contretemps,corps,debris,diabetes,djinn,eland,elk,flounder,gallows,graffiti,headquarters,herpes,high,homework,innings,jackanapes,mackerel,measles,mews,mumps,news,pincers,pliers,proceedings,rabies,salmon,scissors,sea,series,shears,species,swine,trout,tuna,whiting,wildebeest,pike,oats,tongs,dregs,snuffers,victuals,tweezers,vespers,pinchers,bellows,cattle"), i = {
I: "we",
he: "they",
it: "they",
me: "us",
you: "you",
him: "them",
them: "them",
myself: "ourselves",
yourself: "yourselves",
himself: "themselves",
herself: "themselves",
itself: "themselves",
themself: "themselves",
oneself: "oneselves",
child: "children",
dwarf: "dwarfs",
mongoose: "mongooses",
mythos: "mythoi",
ox: "oxen",
soliloquy: "soliloquies",
trilby: "trilbys",
person: "people",
forum: "forums",
syllabus: "syllabi",
alumnus: "alumni",
genus: "genera",
viscus: "viscera",
stigma: "stigmata"
}, s = [ [ /man$/i, "men" ], [ /([lm])ouse$/i, "$1ice" ], [ /tooth$/i, "teeth" ], [ /goose$/i, "geese" ], [ /foot$/i, "feet" ], [ /zoon$/i, "zoa" ], [ /([tcsx])is$/i, "$1es" ], [ /ix$/i, "ices" ], [ /^(cod|mur|sil|vert)ex$/i, "$1ices" ], [ /^(agend|addend|memorand|millenni|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi)um$/i, "$1a" ], [ /^(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|\w+hedr)on$/i, "$1a" ], [ /^(alumn|alg|vertebr)a$/i, "$1ae" ], [ /([cs]h|ss|x)$/i, "$1es" ], [ /([aeo]l|[^d]ea|ar)f$/i, "$1ves" ], [ /([nlw]i)fe$/i, "$1ves" ], [ /([aeiou])y$/i, "$1ys" ], [ /(^[A-Z][a-z]*)y$/, "$1ys" ], [ /y$/i, "ies" ], [ /([aeiou])o$/i, "$1os" ], [ /^(pian|portic|albin|generalissim|manifest|archipelag|ghett|medic|armadill|guan|octav|command|infern|phot|ditt|jumb|pr|dynam|ling|quart|embry|lumbag|rhin|fiasc|magnet|styl|alt|contralt|sopran|bass|crescend|temp|cant|sol|kimon)o$/i, "$1os" ], [ /o$/i, "oes" ], [ /s$/i, "ses" ] ];
return o.define = function(t, n) {
e[t.toLowerCase()] = n;
}, o;
}();

// string.js

XT.String = {
camelize: function(e) {
var t = e.replace(/([\s|\-|\_|\n])([^\s|\-|\_|\n]?)/g, function(e, t, n) {
return n ? n.toUpperCase() : "";
}), n = t.charAt(0), r = n.toLowerCase();
return n !== r ? r + t.slice(1) : t;
},
decamelize: function(e) {
return e.replace(/([a-z])([A-Z])/g, "$1_$2").toLowerCase();
},
camelToHyphen: function(e) {
return e.replace(/([a-z])([A-Z])/g, "$1-$2").toLowerCase();
},
loc: function(e) {
var t = XT.$A(arguments), n = XT.localizeString(e);
t.shift();
if (!(t.length > 0)) return n;
try {
return XT.String.format(n, t);
} catch (r) {
XT.error("could not localize string, %@".f(e), r);
}
},
format: function(e, t) {
if (arguments.length === 0) return "";
if (arguments.length === 1) return e;
var n = 0, r, i;
for (; n < t.length; ++n) {
i = t[n];
if (!i) continue;
r = typeof i;
if (r === "object") e = XT.String.replaceKeys(e, i); else {
if (r !== "string" && r !== "number") continue;
e = e.replace(/\%@/, i);
}
}
return e;
},
formatBraces: function(e, t) {
t = t || "";
var n = /\{([^}]+)\}/g, r = this, i, s;
return i = t.match(n), _.each(i, function(n) {
s = n.slice(1, n.indexOf("}")), t = t.replace(n, r.traverseDots(e, s));
}), t;
},
replaceKeys: function(e, t) {
if (typeof e != "string") return "";
if (typeof t != "object") return e;
var n, r, i, s;
for (r in t) t.hasOwnProperty(r) && (i = "{" + r + "}", n = new RegExp(i, "g"), s = t[r], e = e.replace(n, s));
return e;
},
traverseDots: function(e, t) {
while (t.indexOf(".") >= 0) e = e[this.prefix(t)], t = t.substring(t.indexOf(".") + 1);
return e[t];
},
trim: function(t) {
return !!t && t instanceof String ? t.replace(/^\s\s*/, "").replace(/\s\s*$/, "") : "";
},
prefix: function(e) {
return e = e.substring(0, e.indexOf(".")), e;
},
suffix: function(e) {
while (e.indexOf(".") > 0) e = e.substring(e.indexOf(".") + 1);
return e.substring(0);
},
leftPad: function(e, t, n) {
while (e.length < n) e = t + e;
return e;
},
rightPad: function(e, t, n) {
while (e.length < n) e += t;
return e;
}
};

// startup_task.js

(function() {
"use strict";
var e = XT.StartupTask = function(e) {
var t;
this._properties = {
taskName: "",
waitingList: [],
isComplete: !1,
task: null
};
for (t in e) e.hasOwnProperty(t) && (this._properties[t] = e[t]);
(!this.get("taskName") || this.get("taskName") === "") && this.set("taskName", _.uniqueId("xt_task_")), XT.getStartupManager().registerTask(this);
};
e.prototype.get = function(e) {
var t = this._properties, n = t[e];
return n;
}, e.prototype.set = function(e, t) {
var n = this._properties, r;
if (typeof e == "string" && t) n[e] = t; else if (e && !t) {
t = e;
for (r in t) t.hasOwnProperty(r) && this.set(r, t[r]);
}
return this;
}, e.prototype.checkWaitingList = function(e) {
var t = this.get("waitingList");
t && t.length > 0 && t.indexOf(e) > -1 && this.set("waitingList", t = _.without(t, e));
}, e.prototype.exec = function() {
if (this.get("isComplete")) return !0;
var e = this.get("task");
return !!e && e instanceof Function ? this.get("waitingList").length > 0 ? !1 : (e.call(this), !0) : (this.error("Could not execute without an actual task"), !1);
}, e.prototype.didCompleteCache = function(e, t) {
var n, r;
n = e.model.prototype.recordType, r = _.find(Backbone.Relational.store._collections, function(e) {
return e.model && e.model.prototype.recordType === n;
}), XV.registerModelCache(n, t), r || (r = Backbone.Relational.store._createCollection(e.model)), r.on("statusChange", e.autoSync, e), this.set("isComplete", !0), XT.getStartupManager().taskDidComplete(this);
}, e.prototype.didComplete = function() {
this.set("isComplete", !0), XT.getStartupManager().taskDidComplete(this);
}, e.create = function(e) {
return new XT.StartupTask(e);
};
})(), function() {
"use strict";
var e = XT.StartupTaskManager = function() {
XT.getStartupManager = _.bind(function() {
return this;
}, this), this._properties = {
queue: [],
tasks: {},
completed: [],
isStarted: !1,
callbacks: [],
eachCallbacks: []
};
}, t;
e.prototype.get = function(e) {
var t = this._properties, n = t[e];
return n;
}, e.prototype.set = function(e, t) {
var n = this._properties, r;
if (typeof e == "string" && t) n[e] = t; else if (e && !t) {
t = e;
for (r in t) t.hasOwnProperty(r) && this.set(r, t[r]);
}
return this;
}, e.prototype.registerTask = function(e) {
var t = e.get("taskName"), n = this.get("tasks"), r = this.get("queue");
n[t] || (n[t] = {
task: e
}), this.get("isStarted") ? e.exec() : r.push(e);
}, e.prototype.taskDidComplete = function(e) {
var t = e.get("taskName"), n = this.get("completed"), r = this.get("eachCallbacks") || [], i, s, o = this.get("tasks"), u, a, f = Object.keys(o).length;
n.push(t);
for (i = 0; i < r.length; i++) s = r[i], s && s instanceof Function && s();
for (u in o) o.hasOwnProperty(u) && (a = o[u], u = a.task, u.get("isComplete") || u.checkWaitingList(t));
f > n.length ? this.start() : this.allDone();
}, e.prototype.start = function() {
if (this.get("isStarted")) return !1;
var e = this.get("queue"), t = [], n, r, i = e.length;
if (!e || e.length <= 0) {
this.set("isStarted", !0);
return;
}
for (n = 0; n < i; n += 1) r = e.shift(), r.exec() || t.push(r);
t.length > 0 ? this.set("queue", t) : this.start();
}, e.prototype.registerCallback = function(e, t) {
var n = t ? this.get("eachCallbacks") : this.get("callbacks");
n.push(e);
}, e.prototype.allDone = function() {
var e = this.get("callbacks") || [], t;
while (e.length > 0) t = e.shift(), t && t instanceof Function && t();
}, t = new XT.StartupTaskManager;
}();

// backbone/backbone.js

(function() {
var e = this, t = e.Backbone, n = [], r = n.push, i = n.slice, s = n.splice, o;
typeof exports != "undefined" ? o = exports : o = e.Backbone = {}, o.VERSION = "0.9.10";
var u = e._;
!u && typeof require != "undefined" && (u = require("underscore")), o.$ = e.jQuery || e.Zepto || e.ender, o.noConflict = function() {
return e.Backbone = t, this;
}, o.emulateHTTP = !1, o.emulateJSON = !1;
var a = /\s+/, f = function(e, t, n, r) {
if (!n) return !0;
if (typeof n == "object") for (var i in n) e[t].apply(e, [ i, n[i] ].concat(r)); else {
if (!a.test(n)) return !0;
var s = n.split(a);
for (var o = 0, u = s.length; o < u; o++) e[t].apply(e, [ s[o] ].concat(r));
}
}, l = function(e, t) {
var n, r = -1, i = e.length;
switch (t.length) {
case 0:
while (++r < i) (n = e[r]).callback.call(n.ctx);
return;
case 1:
while (++r < i) (n = e[r]).callback.call(n.ctx, t[0]);
return;
case 2:
while (++r < i) (n = e[r]).callback.call(n.ctx, t[0], t[1]);
return;
case 3:
while (++r < i) (n = e[r]).callback.call(n.ctx, t[0], t[1], t[2]);
return;
default:
while (++r < i) (n = e[r]).callback.apply(n.ctx, t);
}
}, c = o.Events = {
on: function(e, t, n) {
if (!f(this, "on", e, [ t, n ]) || !t) return this;
this._events || (this._events = {});
var r = this._events[e] || (this._events[e] = []);
return r.push({
callback: t,
context: n,
ctx: n || this
}), this;
},
once: function(e, t, n) {
if (!f(this, "once", e, [ t, n ]) || !t) return this;
var r = this, i = u.once(function() {
r.off(e, i), t.apply(this, arguments);
});
return i._callback = t, this.on(e, i, n), this;
},
off: function(e, t, n) {
var r, i, s, o, a, l, c, h;
if (!this._events || !f(this, "off", e, [ t, n ])) return this;
if (!e && !t && !n) return this._events = {}, this;
o = e ? [ e ] : u.keys(this._events);
for (a = 0, l = o.length; a < l; a++) {
e = o[a];
if (r = this._events[e]) {
s = [];
if (t || n) for (c = 0, h = r.length; c < h; c++) i = r[c], (t && t !== i.callback && t !== i.callback._callback || n && n !== i.context) && s.push(i);
this._events[e] = s;
}
}
return this;
},
trigger: function(e) {
if (!this._events) return this;
var t = i.call(arguments, 1);
if (!f(this, "trigger", e, t)) return this;
var n = this._events[e], r = this._events.all;
return n && l(n, t), r && l(r, arguments), this;
},
listenTo: function(e, t, n) {
var r = this._listeners || (this._listeners = {}), i = e._listenerId || (e._listenerId = u.uniqueId("l"));
return r[i] = e, e.on(t, typeof t == "object" ? this : n, this), this;
},
stopListening: function(e, t, n) {
var r = this._listeners;
if (!r) return;
if (e) e.off(t, typeof t == "object" ? this : n, this), !t && !n && delete r[e._listenerId]; else {
typeof t == "object" && (n = this);
for (var i in r) r[i].off(t, n, this);
this._listeners = {};
}
return this;
}
};
c.bind = c.on, c.unbind = c.off, u.extend(o, c);
var h = o.Model = function(e, t) {
var n, r = e || {};
this.cid = u.uniqueId("c"), this.attributes = {}, t && t.collection && (this.collection = t.collection), t && t.parse && (r = this.parse(r, t) || {});
if (n = u.result(this, "defaults")) r = u.defaults({}, r, n);
this.set(r, t), this.changed = {}, this.initialize.apply(this, arguments);
};
u.extend(h.prototype, c, {
changed: null,
idAttribute: "id",
initialize: function() {},
toJSON: function(e) {
return u.clone(this.attributes);
},
sync: function() {
return o.sync.apply(this, arguments);
},
get: function(e) {
return this.attributes[e];
},
escape: function(e) {
return u.escape(this.get(e));
},
has: function(e) {
return this.get(e) != null;
},
set: function(e, t, n) {
var r, i, s, o, a, f, l, c;
if (e == null) return this;
typeof e == "object" ? (i = e, n = t) : (i = {})[e] = t, n || (n = {});
if (!this._validate(i, n)) return !1;
s = n.unset, a = n.silent, o = [], f = this._changing, this._changing = !0, f || (this._previousAttributes = u.clone(this.attributes), this.changed = {}), c = this.attributes, l = this._previousAttributes, this.idAttribute in i && (this.id = i[this.idAttribute]);
for (r in i) t = i[r], u.isEqual(c[r], t) || o.push(r), u.isEqual(l[r], t) ? delete this.changed[r] : this.changed[r] = t, s ? delete c[r] : c[r] = t;
if (!a) {
o.length && (this._pending = !0);
for (var h = 0, p = o.length; h < p; h++) this.trigger("change:" + o[h], this, c[o[h]], n);
}
if (f) return this;
if (!a) while (this._pending) this._pending = !1, this.trigger("change", this, n);
return this._pending = !1, this._changing = !1, this;
},
unset: function(e, t) {
return this.set(e, void 0, u.extend({}, t, {
unset: !0
}));
},
clear: function(e) {
var t = {};
for (var n in this.attributes) t[n] = void 0;
return this.set(t, u.extend({}, e, {
unset: !0
}));
},
hasChanged: function(e) {
return e == null ? !u.isEmpty(this.changed) : u.has(this.changed, e);
},
changedAttributes: function(e) {
if (!e) return this.hasChanged() ? u.clone(this.changed) : !1;
var t, n = !1, r = this._changing ? this._previousAttributes : this.attributes;
for (var i in e) {
if (u.isEqual(r[i], t = e[i])) continue;
(n || (n = {}))[i] = t;
}
return n;
},
previous: function(e) {
return e == null || !this._previousAttributes ? null : this._previousAttributes[e];
},
previousAttributes: function() {
return u.clone(this._previousAttributes);
},
fetch: function(e) {
e = e ? u.clone(e) : {}, e.parse === void 0 && (e.parse = !0);
var t = e.success;
return e.success = function(e, n, r) {
if (!e.set(e.parse(n, r), r)) return !1;
t && t(e, n, r);
}, this.sync("read", this, e);
},
save: function(e, t, n) {
var r, i, s, o, a = this.attributes;
return e == null || typeof e == "object" ? (r = e, n = t) : (r = {})[e] = t, r && (!n || !n.wait) && !this.set(r, n) ? !1 : (n = u.extend({
validate: !0
}, n), this._validate(r, n) ? (r && n.wait && (this.attributes = u.extend({}, a, r)), n.parse === void 0 && (n.parse = !0), i = n.success, n.success = function(e, t, n) {
e.attributes = a;
var s = e.parse(t, n);
n.wait && (s = u.extend(r || {}, s));
if (u.isObject(s) && !e.set(s, n)) return !1;
i && i(e, t, n);
}, s = this.isNew() ? "create" : n.patch ? "patch" : "update", s === "patch" && (n.attrs = r), o = this.sync(s, this, n), r && n.wait && (this.attributes = a), o) : !1);
},
destroy: function(e) {
e = e ? u.clone(e) : {};
var t = this, n = e.success, r = function() {
t.trigger("destroy", t, t.collection, e);
};
e.success = function(e, t, i) {
(i.wait || e.isNew()) && r(), n && n(e, t, i);
};
if (this.isNew()) return e.success(this, null, e), !1;
var i = this.sync("delete", this, e);
return e.wait || r(), i;
},
url: function() {
var e = u.result(this, "urlRoot") || u.result(this.collection, "url") || M();
return this.isNew() ? e : e + (e.charAt(e.length - 1) === "/" ? "" : "/") + encodeURIComponent(this.id);
},
parse: function(e, t) {
return e;
},
clone: function() {
return new this.constructor(this.attributes);
},
isNew: function() {
return this.id == null;
},
isValid: function(e) {
return !this.validate || !this.validate(this.attributes, e);
},
_validate: function(e, t) {
if (!t.validate || !this.validate) return !0;
e = u.extend({}, this.attributes, e);
var n = this.validationError = this.validate(e, t) || null;
return n ? (this.trigger("invalid", this, n, t || {}), !1) : !0;
}
});
var p = o.Collection = function(e, t) {
t || (t = {}), t.model && (this.model = t.model), t.comparator !== void 0 && (this.comparator = t.comparator), this.models = [], this._reset(), this.initialize.apply(this, arguments), e && this.reset(e, u.extend({
silent: !0
}, t));
};
u.extend(p.prototype, c, {
model: h,
initialize: function() {},
toJSON: function(e) {
return this.map(function(t) {
return t.toJSON(e);
});
},
sync: function() {
return o.sync.apply(this, arguments);
},
add: function(e, t) {
e = u.isArray(e) ? e.slice() : [ e ], t || (t = {});
var n, i, o, a, f, l, c, h, p, d;
c = [], h = t.at, p = this.comparator && h == null && t.sort != 0, d = u.isString(this.comparator) ? this.comparator : null;
for (n = 0, i = e.length; n < i; n++) {
if (!(o = this._prepareModel(a = e[n], t))) {
this.trigger("invalid", this, a, t);
continue;
}
if (f = this.get(o)) {
t.merge && (f.set(a === o ? o.attributes : a, t), p && !l && f.hasChanged(d) && (l = !0));
continue;
}
c.push(o), o.on("all", this._onModelEvent, this), this._byId[o.cid] = o, o.id != null && (this._byId[o.id] = o);
}
c.length && (p && (l = !0), this.length += c.length, h != null ? s.apply(this.models, [ h, 0 ].concat(c)) : r.apply(this.models, c)), l && this.sort({
silent: !0
});
if (t.silent) return this;
for (n = 0, i = c.length; n < i; n++) (o = c[n]).trigger("add", o, this, t);
return l && this.trigger("sort", this, t), this;
},
remove: function(e, t) {
e = u.isArray(e) ? e.slice() : [ e ], t || (t = {});
var n, r, i, s;
for (n = 0, r = e.length; n < r; n++) {
s = this.get(e[n]);
if (!s) continue;
delete this._byId[s.id], delete this._byId[s.cid], i = this.indexOf(s), this.models.splice(i, 1), this.length--, t.silent || (t.index = i, s.trigger("remove", s, this, t)), this._removeReference(s);
}
return this;
},
push: function(e, t) {
return e = this._prepareModel(e, t), this.add(e, u.extend({
at: this.length
}, t)), e;
},
pop: function(e) {
var t = this.at(this.length - 1);
return this.remove(t, e), t;
},
unshift: function(e, t) {
return e = this._prepareModel(e, t), this.add(e, u.extend({
at: 0
}, t)), e;
},
shift: function(e) {
var t = this.at(0);
return this.remove(t, e), t;
},
slice: function(e, t) {
return this.models.slice(e, t);
},
get: function(e) {
return e == null ? void 0 : (this._idAttr || (this._idAttr = this.model.prototype.idAttribute), this._byId[e.id || e.cid || e[this._idAttr] || e]);
},
at: function(e) {
return this.models[e];
},
where: function(e) {
return u.isEmpty(e) ? [] : this.filter(function(t) {
for (var n in e) if (e[n] !== t.get(n)) return !1;
return !0;
});
},
sort: function(e) {
if (!this.comparator) throw new Error("Cannot sort a set without a comparator");
return e || (e = {}), u.isString(this.comparator) || this.comparator.length === 1 ? this.models = this.sortBy(this.comparator, this) : this.models.sort(u.bind(this.comparator, this)), e.silent || this.trigger("sort", this, e), this;
},
pluck: function(e) {
return u.invoke(this.models, "get", e);
},
update: function(e, t) {
t = u.extend({
add: !0,
merge: !0,
remove: !0
}, t), t.parse && (e = this.parse(e, t));
var n, r, i, s, o = [], a = [], f = {};
u.isArray(e) || (e = e ? [ e ] : []);
if (t.add && !t.remove) return this.add(e, t);
for (r = 0, i = e.length; r < i; r++) n = e[r], s = this.get(n), t.remove && s && (f[s.cid] = !0), (t.add && !s || t.merge && s) && o.push(n);
if (t.remove) for (r = 0, i = this.models.length; r < i; r++) n = this.models[r], f[n.cid] || a.push(n);
return a.length && this.remove(a, t), o.length && this.add(o, t), this;
},
reset: function(e, t) {
t || (t = {}), t.parse && (e = this.parse(e, t));
for (var n = 0, r = this.models.length; n < r; n++) this._removeReference(this.models[n]);
return t.previousModels = this.models.slice(), this._reset(), e && this.add(e, u.extend({
silent: !0
}, t)), t.silent || this.trigger("reset", this, t), this;
},
fetch: function(e) {
e = e ? u.clone(e) : {}, e.parse === void 0 && (e.parse = !0);
var t = e.success;
return e.success = function(e, n, r) {
var i = r.update ? "update" : "reset";
e[i](n, r), t && t(e, n, r);
}, this.sync("read", this, e);
},
create: function(e, t) {
t = t ? u.clone(t) : {};
if (!(e = this._prepareModel(e, t))) return !1;
t.wait || this.add(e, t);
var n = this, r = t.success;
return t.success = function(e, t, i) {
i.wait && n.add(e, i), r && r(e, t, i);
}, e.save(null, t), e;
},
parse: function(e, t) {
return e;
},
clone: function() {
return new this.constructor(this.models);
},
_reset: function() {
this.length = 0, this.models.length = 0, this._byId = {};
},
_prepareModel: function(e, t) {
if (e instanceof h) return e.collection || (e.collection = this), e;
t || (t = {}), t.collection = this;
var n = new this.model(e, t);
return n._validate(e, t) ? n : !1;
},
_removeReference: function(e) {
this === e.collection && delete e.collection, e.off("all", this._onModelEvent, this);
},
_onModelEvent: function(e, t, n, r) {
if ((e === "add" || e === "remove") && n !== this) return;
e === "destroy" && this.remove(t, r), t && e === "change:" + t.idAttribute && (delete this._byId[t.previous(t.idAttribute)], t.id != null && (this._byId[t.id] = t)), this.trigger.apply(this, arguments);
},
sortedIndex: function(e, t, n) {
t || (t = this.comparator);
var r = u.isFunction(t) ? t : function(e) {
return e.get(t);
};
return u.sortedIndex(this.models, e, r, n);
}
});
var d = [ "forEach", "each", "map", "collect", "reduce", "foldl", "inject", "reduceRight", "foldr", "find", "detect", "filter", "select", "reject", "every", "all", "some", "any", "include", "contains", "invoke", "max", "min", "toArray", "size", "first", "head", "take", "initial", "rest", "tail", "drop", "last", "without", "indexOf", "shuffle", "lastIndexOf", "isEmpty", "chain" ];
u.each(d, function(e) {
p.prototype[e] = function() {
var t = i.call(arguments);
return t.unshift(this.models), u[e].apply(u, t);
};
});
var v = [ "groupBy", "countBy", "sortBy" ];
u.each(v, function(e) {
p.prototype[e] = function(t, n) {
var r = u.isFunction(t) ? t : function(e) {
return e.get(t);
};
return u[e](this.models, r, n);
};
});
var m = o.Router = function(e) {
e || (e = {}), e.routes && (this.routes = e.routes), this._bindRoutes(), this.initialize.apply(this, arguments);
}, g = /\((.*?)\)/g, y = /(\(\?)?:\w+/g, b = /\*\w+/g, w = /[\-{}\[\]+?.,\\\^$|#\s]/g;
u.extend(m.prototype, c, {
initialize: function() {},
route: function(e, t, n) {
return u.isRegExp(e) || (e = this._routeToRegExp(e)), n || (n = this[t]), o.history.route(e, u.bind(function(r) {
var i = this._extractParameters(e, r);
n && n.apply(this, i), this.trigger.apply(this, [ "route:" + t ].concat(i)), this.trigger("route", t, i), o.history.trigger("route", this, t, i);
}, this)), this;
},
navigate: function(e, t) {
return o.history.navigate(e, t), this;
},
_bindRoutes: function() {
if (!this.routes) return;
var e, t = u.keys(this.routes);
while ((e = t.pop()) != null) this.route(e, this.routes[e]);
},
_routeToRegExp: function(e) {
return e = e.replace(w, "\\$&").replace(g, "(?:$1)?").replace(y, function(e, t) {
return t ? e : "([^/]+)";
}).replace(b, "(.*?)"), new RegExp("^" + e + "$");
},
_extractParameters: function(e, t) {
return e.exec(t).slice(1);
}
});
var E = o.History = function() {
this.handlers = [], u.bindAll(this, "checkUrl"), typeof window != "undefined" && (this.location = window.location, this.history = window.history);
}, S = /^[#\/]|\s+$/g, x = /^\/+|\/+$/g, T = /msie [\w.]+/, N = /\/$/;
E.started = !1, u.extend(E.prototype, c, {
interval: 50,
getHash: function(e) {
var t = (e || this).location.href.match(/#(.*)$/);
return t ? t[1] : "";
},
getFragment: function(e, t) {
if (e == null) if (this._hasPushState || !this._wantsHashChange || t) {
e = this.location.pathname;
var n = this.root.replace(N, "");
e.indexOf(n) || (e = e.substr(n.length));
} else e = this.getHash();
return e.replace(S, "");
},
start: function(e) {
if (E.started) throw new Error("Backbone.history has already been started");
E.started = !0, this.options = u.extend({}, {
root: "/"
}, this.options, e), this.root = this.options.root, this._wantsHashChange = this.options.hashChange !== !1, this._wantsPushState = !!this.options.pushState, this._hasPushState = !!(this.options.pushState && this.history && this.history.pushState);
var t = this.getFragment(), n = document.documentMode, r = T.exec(navigator.userAgent.toLowerCase()) && (!n || n <= 7);
this.root = ("/" + this.root + "/").replace(x, "/"), r && this._wantsHashChange && (this.iframe = o.$('<iframe src="javascript:0" tabindex="-1" />').hide().appendTo("body")[0].contentWindow, this.navigate(t)), this._hasPushState ? o.$(window).on("popstate", this.checkUrl) : this._wantsHashChange && "onhashchange" in window && !r ? o.$(window).on("hashchange", this.checkUrl) : this._wantsHashChange && (this._checkUrlInterval = setInterval(this.checkUrl, this.interval)), this.fragment = t;
var i = this.location, s = i.pathname.replace(/[^\/]$/, "$&/") === this.root;
if (this._wantsHashChange && this._wantsPushState && !this._hasPushState && !s) return this.fragment = this.getFragment(null, !0), this.location.replace(this.root + this.location.search + "#" + this.fragment), !0;
this._wantsPushState && this._hasPushState && s && i.hash && (this.fragment = this.getHash().replace(S, ""), this.history.replaceState({}, document.title, this.root + this.fragment + i.search));
if (!this.options.silent) return this.loadUrl();
},
stop: function() {
o.$(window).off("popstate", this.checkUrl).off("hashchange", this.checkUrl), clearInterval(this._checkUrlInterval), E.started = !1;
},
route: function(e, t) {
this.handlers.unshift({
route: e,
callback: t
});
},
checkUrl: function(e) {
var t = this.getFragment();
t === this.fragment && this.iframe && (t = this.getFragment(this.getHash(this.iframe)));
if (t === this.fragment) return !1;
this.iframe && this.navigate(t), this.loadUrl() || this.loadUrl(this.getHash());
},
loadUrl: function(e) {
var t = this.fragment = this.getFragment(e), n = u.any(this.handlers, function(e) {
if (e.route.test(t)) return e.callback(t), !0;
});
return n;
},
navigate: function(e, t) {
if (!E.started) return !1;
if (!t || t === !0) t = {
trigger: t
};
e = this.getFragment(e || "");
if (this.fragment === e) return;
this.fragment = e;
var n = this.root + e;
if (this._hasPushState) this.history[t.replace ? "replaceState" : "pushState"]({}, document.title, n); else {
if (!this._wantsHashChange) return this.location.assign(n);
this._updateHash(this.location, e, t.replace), this.iframe && e !== this.getFragment(this.getHash(this.iframe)) && (t.replace || this.iframe.document.open().close(), this._updateHash(this.iframe.location, e, t.replace));
}
t.trigger && this.loadUrl(e);
},
_updateHash: function(e, t, n) {
if (n) {
var r = e.href.replace(/(javascript:|#).*$/, "");
e.replace(r + "#" + t);
} else e.hash = "#" + t;
}
}), o.history = new E;
var C = o.View = function(e) {
this.cid = u.uniqueId("view"), this._configure(e || {}), this._ensureElement(), this.initialize.apply(this, arguments), this.delegateEvents();
}, k = /^(\S+)\s*(.*)$/, L = [ "model", "collection", "el", "id", "attributes", "className", "tagName", "events" ];
u.extend(C.prototype, c, {
tagName: "div",
$: function(e) {
return this.$el.find(e);
},
initialize: function() {},
render: function() {
return this;
},
remove: function() {
return this.$el.remove(), this.stopListening(), this;
},
setElement: function(e, t) {
return this.$el && this.undelegateEvents(), this.$el = e instanceof o.$ ? e : o.$(e), this.el = this.$el[0], t !== !1 && this.delegateEvents(), this;
},
delegateEvents: function(e) {
if (!e && !(e = u.result(this, "events"))) return;
this.undelegateEvents();
for (var t in e) {
var n = e[t];
u.isFunction(n) || (n = this[e[t]]);
if (!n) throw new Error('Method "' + e[t] + '" does not exist');
var r = t.match(k), i = r[1], s = r[2];
n = u.bind(n, this), i += ".delegateEvents" + this.cid, s === "" ? this.$el.on(i, n) : this.$el.on(i, s, n);
}
},
undelegateEvents: function() {
this.$el.off(".delegateEvents" + this.cid);
},
_configure: function(e) {
this.options && (e = u.extend({}, u.result(this, "options"), e)), u.extend(this, u.pick(e, L)), this.options = e;
},
_ensureElement: function() {
if (!this.el) {
var e = u.extend({}, u.result(this, "attributes"));
this.id && (e.id = u.result(this, "id")), this.className && (e["class"] = u.result(this, "className"));
var t = o.$("<" + u.result(this, "tagName") + ">").attr(e);
this.setElement(t, !1);
} else this.setElement(u.result(this, "el"), !1);
}
});
var A = {
create: "POST",
update: "PUT",
patch: "PATCH",
"delete": "DELETE",
read: "GET"
};
o.sync = function(e, t, n) {
var r = A[e];
u.defaults(n || (n = {}), {
emulateHTTP: o.emulateHTTP,
emulateJSON: o.emulateJSON
});
var i = {
type: r,
dataType: "json"
};
n.url || (i.url = u.result(t, "url") || M()), n.data == null && t && (e === "create" || e === "update" || e === "patch") && (i.contentType = "application/json", i.data = JSON.stringify(n.attrs || t.toJSON(n))), n.emulateJSON && (i.contentType = "application/x-www-form-urlencoded", i.data = i.data ? {
model: i.data
} : {});
if (n.emulateHTTP && (r === "PUT" || r === "DELETE" || r === "PATCH")) {
i.type = "POST", n.emulateJSON && (i.data._method = r);
var s = n.beforeSend;
n.beforeSend = function(e) {
e.setRequestHeader("X-HTTP-Method-Override", r);
if (s) return s.apply(this, arguments);
};
}
i.type !== "GET" && !n.emulateJSON && (i.processData = !1);
var a = n.success;
n.success = function(e) {
a && a(t, e, n), t.trigger("sync", t, e, n);
};
var f = n.error;
n.error = function(e) {
f && f(t, e, n), t.trigger("error", t, e, n);
};
var l = n.xhr = o.ajax(u.extend(i, n));
return t.trigger("request", t, l, n), l;
}, o.ajax = function() {
return o.$.ajax.apply(o.$, arguments);
};
var O = function(e, t) {
var n = this, r;
e && u.has(e, "constructor") ? r = e.constructor : r = function() {
return n.apply(this, arguments);
}, u.extend(r, n, t);
var i = function() {
this.constructor = r;
};
return i.prototype = n.prototype, r.prototype = new i, e && u.extend(r.prototype, e), r.__super__ = n.prototype, r;
};
h.extend = p.extend = m.extend = C.extend = E.extend = O;
var M = function() {
throw new Error('A "url" property or function must be specified');
};
}).call(this);

// Backbone-relational/backbone-relational.js

(function(e) {
"use strict";
var t, n, r;
typeof window == "undefined" ? (t = require("underscore"), n = require("backbone"), r = module.exports = n) : (t = window._, n = window.Backbone, r = window), n.Relational = {
showWarnings: !0
}, n.Semaphore = {
_permitsAvailable: null,
_permitsUsed: 0,
acquire: function() {
if (this._permitsAvailable && this._permitsUsed >= this._permitsAvailable) throw new Error("Max permits acquired");
this._permitsUsed++;
},
release: function() {
if (this._permitsUsed === 0) throw new Error("All permits released");
this._permitsUsed--;
},
isLocked: function() {
return this._permitsUsed > 0;
},
setAvailablePermits: function(e) {
if (this._permitsUsed > e) throw new Error("Available permits cannot be less than used permits");
this._permitsAvailable = e;
}
}, n.BlockingQueue = function() {
this._queue = [];
}, t.extend(n.BlockingQueue.prototype, n.Semaphore, {
_queue: null,
add: function(e) {
this.isBlocked() ? this._queue.push(e) : e();
},
process: function() {
while (this._queue && this._queue.length) this._queue.shift()();
},
block: function() {
this.acquire();
},
unblock: function() {
this.release(), this.isBlocked() || this.process();
},
isBlocked: function() {
return this.isLocked();
}
}), n.Relational.eventQueue = new n.BlockingQueue, n.Store = function() {
this._collections = [], this._reverseRelations = [], this._orphanRelations = [], this._subModels = [], this._modelScopes = [ r ];
}, t.extend(n.Store.prototype, n.Events, {
initializeRelation: function(e, r, i) {
var s = t.isString(r.type) ? n[r.type] || this.getObjectByName(r.type) : r.type;
s && s.prototype instanceof n.Relation ? new s(e, r, i) : n.Relational.showWarnings && typeof console != "undefined" && console.warn("Relation=%o; missing or invalid relation type!", r);
},
addModelScope: function(e) {
this._modelScopes.push(e);
},
addSubModels: function(e, t) {
this._subModels.push({
superModelType: t,
subModels: e
});
},
setupSuperModel: function(e) {
t.find(this._subModels, function(n) {
return t.find(n.subModels || [], function(t, r) {
var i = this.getObjectByName(t);
if (e === i) return n.superModelType._subModels[r] = e, e._superModel = n.superModelType, e._subModelTypeValue = r, e._subModelTypeAttribute = n.superModelType.prototype.subModelTypeAttribute, !0;
}, this);
}, this);
},
addReverseRelation: function(e) {
var n = t.any(this._reverseRelations, function(n) {
return t.all(e || [], function(e, t) {
return e === n[t];
});
});
!n && e.model && e.type && (this._reverseRelations.push(e), this._addRelation(e.model, e), this.retroFitRelation(e));
},
addOrphanRelation: function(e) {
var n = t.any(this._orphanRelations, function(n) {
return t.all(e || [], function(e, t) {
return e === n[t];
});
});
!n && e.model && e.type && this._orphanRelations.push(e);
},
processOrphanRelations: function() {
t.each(this._orphanRelations.slice(0), function(e) {
var r = n.Relational.store.getObjectByName(e.relatedModel);
r && (this.initializeRelation(null, e), this._orphanRelations = t.without(this._orphanRelations, e));
}, this);
},
_addRelation: function(e, n) {
e.prototype.relations || (e.prototype.relations = []), e.prototype.relations.push(n), t.each(e._subModels || [], function(e) {
this._addRelation(e, n);
}, this);
},
retroFitRelation: function(e) {
var t = this.getCollection(e.model, !1);
t && t.each(function(t) {
if (!(t instanceof e.model)) return;
new e.type(t, e);
}, this);
},
getCollection: function(e, r) {
e instanceof n.RelationalModel && (e = e.constructor);
var i = e;
while (i._superModel) i = i._superModel;
var s = t.findWhere(this._collections, {
model: i
});
return !s && r !== !1 && (s = this._createCollection(i)), s;
},
getObjectByName: function(n) {
var r = n.split("."), i = null;
return t.find(this._modelScopes, function(n) {
i = t.reduce(r || [], function(t, n) {
return t ? t[n] : e;
}, n);
if (i && i !== n) return !0;
}, this), i;
},
_createCollection: function(e) {
var t;
return e instanceof n.RelationalModel && (e = e.constructor), e.prototype instanceof n.RelationalModel && (t = new n.Collection, t.model = e, this._collections.push(t)), t;
},
resolveIdForItem: function(e, r) {
var i = t.isString(r) || t.isNumber(r) ? r : null;
return i === null && (r instanceof n.RelationalModel ? i = r.id : t.isObject(r) && (i = r[e.prototype.idAttribute])), !i && i !== 0 && (i = null), i;
},
find: function(e, t) {
var n = this.resolveIdForItem(e, t), r = this.getCollection(e);
if (r) {
var i = r.get(n);
if (i instanceof e) return i;
}
return null;
},
register: function(e) {
var t = this.getCollection(e);
if (t) {
if (t.get(e)) throw n.Relational.showWarnings && typeof console != "undefined" && console.warn("Duplicate id! Old RelationalModel=%o, new RelationalModel=%o", t.get(e), e), new Error("Cannot instantiate more than one Backbone.RelationalModel with the same id per type!");
var r = e.collection;
t.add(e), this.listenTo(e, "destroy", this.unregister, this), e.collection = r;
}
},
update: function(e) {
var t = this.getCollection(e);
t._onModelEvent("change:" + e.idAttribute, e, t);
},
unregister: function(e) {
this.stopListening(e, "destroy", this.unregister);
var t = this.getCollection(e);
t && t.remove(e);
},
reset: function() {
this.stopListening(), this._collections = [], this._subModels = [], this._modelScopes = [ r ];
}
}), n.Relational.store = new n.Store, n.Relation = function(e, r, i) {
this.instance = e, r = t.isObject(r) ? r : {}, this.reverseRelation = t.defaults(r.reverseRelation || {}, this.options.reverseRelation), this.options = t.defaults(r, this.options, n.Relation.prototype.options), this.reverseRelation.type = t.isString(this.reverseRelation.type) ? n[this.reverseRelation.type] || n.Relational.store.getObjectByName(this.reverseRelation.type) : this.reverseRelation.type, this.key = this.options.key, this.keySource = this.options.keySource || this.key, this.keyDestination = this.options.keyDestination || this.keySource || this.key, this.model = this.options.model || this.instance.constructor, this.relatedModel = this.options.relatedModel, t.isString(this.relatedModel) && (this.relatedModel = n.Relational.store.getObjectByName(this.relatedModel));
if (!this.checkPreconditions()) return;
!this.options.isAutoRelation && this.reverseRelation.type && this.reverseRelation.key && n.Relational.store.addReverseRelation(t.defaults({
isAutoRelation: !0,
model: this.relatedModel,
relatedModel: this.model,
reverseRelation: this.options
}, this.reverseRelation));
if (e) {
var s = this.keySource;
s !== this.key && typeof this.instance.get(this.key) == "object" && (s = this.key), this.setKeyContents(this.instance.get(s)), this.relatedCollection = n.Relational.store.getCollection(this.relatedModel), this.keySource !== this.key && this.instance.unset(this.keySource, {
silent: !0
}), this.instance._relations[this.key] = this, this.initialize(i), this.options.autoFetch && this.instance.fetchRelated(this.key, t.isObject(this.options.autoFetch) ? this.options.autoFetch : {}), this.listenTo(this.instance, "destroy", this.destroy).listenTo(this.relatedCollection, "relational:add", this.tryAddRelated).listenTo(this.relatedCollection, "relational:remove", this.removeRelated);
}
}, n.Relation.extend = n.Model.extend, t.extend(n.Relation.prototype, n.Events, n.Semaphore, {
options: {
createModels: !0,
includeInJSON: !0,
isAutoRelation: !1,
autoFetch: !1,
parse: !1
},
instance: null,
key: null,
keyContents: null,
relatedModel: null,
relatedCollection: null,
reverseRelation: null,
related: null,
checkPreconditions: function() {
var e = this.instance, r = this.key, i = this.model, s = this.relatedModel, o = n.Relational.showWarnings && typeof console != "undefined";
if (!i || !r || !s) return o && console.warn("Relation=%o: missing model, key or relatedModel (%o, %o, %o).", this, i, r, s), !1;
if (i.prototype instanceof n.RelationalModel) {
if (s.prototype instanceof n.RelationalModel) {
if (this instanceof n.HasMany && this.reverseRelation.type === n.HasMany) return o && console.warn("Relation=%o: relation is a HasMany, and the reverseRelation is HasMany as well.", this), !1;
if (e && t.keys(e._relations).length) {
var u = t.find(e._relations, function(e) {
return e.key === r;
}, this);
if (u) return o && console.warn("Cannot create relation=%o on %o for model=%o: already taken by relation=%o.", this, r, e, u), !1;
}
return !0;
}
return o && console.warn("Relation=%o: relatedModel does not inherit from Backbone.RelationalModel (%o).", this, s), !1;
}
return o && console.warn("Relation=%o: model does not inherit from Backbone.RelationalModel (%o).", this, e), !1;
},
setRelated: function(e) {
this.related = e, this.instance.acquire(), this.instance.attributes[this.key] = e, this.instance.release();
},
_isReverseRelation: function(e) {
return e.instance instanceof this.relatedModel && this.reverseRelation.key === e.key && this.key === e.reverseRelation.key;
},
getReverseRelations: function(e) {
var n = [], r = t.isUndefined(e) ? this.related && (this.related.models || [ this.related ]) : [ e ];
return t.each(r || [], function(e) {
t.each(e.getRelations() || [], function(e) {
this._isReverseRelation(e) && n.push(e);
}, this);
}, this), n;
},
destroy: function() {
this.stopListening(), this instanceof n.HasOne ? this.setRelated(null) : this instanceof n.HasMany && this.setRelated(this._prepareCollection()), t.each(this.getReverseRelations(), function(e) {
e.removeRelated(this.instance);
}, this);
}
}), n.HasOne = n.Relation.extend({
options: {
reverseRelation: {
type: "HasMany"
}
},
initialize: function(e) {
this.listenTo(this.instance, "relational:change:" + this.key, this.onChange);
var n = this.findRelated(e);
this.setRelated(n), t.each(this.getReverseRelations(), function(t) {
t.addRelated(this.instance, e);
}, this);
},
findRelated: function(e) {
var n = null;
e = t.defaults({
parse: this.options.parse
}, e);
if (this.keyContents instanceof this.relatedModel) n = this.keyContents; else if (this.keyContents || this.keyContents === 0) {
var r = t.defaults({
create: this.options.createModels
}, e);
n = this.relatedModel.findOrCreate(this.keyContents, r);
}
return n;
},
setKeyContents: function(e) {
this.keyContents = e, this.keyId = n.Relational.store.resolveIdForItem(this.relatedModel, this.keyContents);
},
onChange: function(e, r, i) {
if (this.isLocked()) return;
this.acquire(), i = i ? t.clone(i) : {};
var s = t.isUndefined(i.__related), o = s ? this.related : i.__related;
if (s) {
this.setKeyContents(r);
var u = this.findRelated(i);
this.setRelated(u);
}
o && this.related !== o && t.each(this.getReverseRelations(o), function(e) {
e.removeRelated(this.instance, null, i);
}, this), t.each(this.getReverseRelations(), function(e) {
e.addRelated(this.instance, i);
}, this);
if (!i.silent && this.related !== o) {
var a = this;
this.changed = !0, n.Relational.eventQueue.add(function() {
a.instance.trigger("change:" + a.key, a.instance, a.related, i, !0), a.changed = !1;
});
}
this.release();
},
tryAddRelated: function(e, t, n) {
(this.keyId || this.keyId === 0) && e.id === this.keyId && (this.addRelated(e, n), this.keyId = null);
},
addRelated: function(e, n) {
var r = this;
e.queue(function() {
if (e !== r.related) {
var i = r.related || null;
r.setRelated(e), r.onChange(r.instance, e, t.defaults({
__related: i
}, n));
}
});
},
removeRelated: function(e, n, r) {
if (!this.related) return;
if (e === this.related) {
var i = this.related || null;
this.setRelated(null), this.onChange(this.instance, e, t.defaults({
__related: i
}, r));
}
}
}), n.HasMany = n.Relation.extend({
collectionType: null,
options: {
reverseRelation: {
type: "HasOne"
},
collectionType: n.Collection,
collectionKey: !0,
collectionOptions: {}
},
initialize: function(e) {
this.listenTo(this.instance, "relational:change:" + this.key, this.onChange), this.collectionType = this.options.collectionType, t.isString(this.collectionType) && (this.collectionType = n.Relational.store.getObjectByName(this.collectionType));
if (!this.collectionType.prototype instanceof n.Collection) throw new Error("`collectionType` must inherit from Backbone.Collection");
var r = this.findRelated(e);
this.setRelated(r);
},
_prepareCollection: function(e) {
this.related && this.stopListening(this.related);
if (!e || !(e instanceof n.Collection)) {
var r = t.isFunction(this.options.collectionOptions) ? this.options.collectionOptions(this.instance) : this.options.collectionOptions;
e = new this.collectionType(null, r);
}
e.model = this.relatedModel;
if (this.options.collectionKey) {
var i = this.options.collectionKey === !0 ? this.options.reverseRelation.key : this.options.collectionKey;
e[i] && e[i] !== this.instance ? n.Relational.showWarnings && typeof console != "undefined" && console.warn("Relation=%o; collectionKey=%s already exists on collection=%o", this, i, this.options.collectionKey) : i && (e[i] = this.instance);
}
return this.listenTo(e, "relational:add", this.handleAddition).listenTo(e, "relational:remove", this.handleRemoval).listenTo(e, "relational:reset", this.handleReset), e;
},
findRelated: function(e) {
var r = null;
e = t.defaults({
parse: this.options.parse
}, e);
if (this.keyContents instanceof n.Collection) this._prepareCollection(this.keyContents), r = this.keyContents; else {
var i = [];
t.each(this.keyContents, function(n) {
if (n instanceof this.relatedModel) var r = n; else r = this.relatedModel.findOrCreate(n, t.extend({
merge: !0
}, e, {
create: this.options.createModels
}));
r && i.push(r);
}, this), this.related instanceof n.Collection ? r = this.related : r = this._prepareCollection(), r.update(i, t.defaults({
merge: !1,
parse: !1
}, e));
}
return r;
},
setKeyContents: function(e) {
this.keyContents = e instanceof n.Collection ? e : null, this.keyIds = [], !this.keyContents && (e || e === 0) && (this.keyContents = t.isArray(e) ? e : [ e ], t.each(this.keyContents, function(e) {
var t = n.Relational.store.resolveIdForItem(this.relatedModel, e);
(t || t === 0) && this.keyIds.push(t);
}, this));
},
onChange: function(e, r, i) {
i = i ? t.clone(i) : {}, this.setKeyContents(r), this.changed = !1;
var s = this.findRelated(i);
this.setRelated(s);
if (!i.silent) {
var o = this;
n.Relational.eventQueue.add(function() {
o.changed && (o.instance.trigger("change:" + o.key, o.instance, o.related, i, !0), o.changed = !1);
});
}
},
handleAddition: function(e, r, i) {
i = i ? t.clone(i) : {}, this.changed = !0, t.each(this.getReverseRelations(e), function(e) {
e.addRelated(this.instance, i);
}, this);
var s = this;
!i.silent && n.Relational.eventQueue.add(function() {
s.instance.trigger("add:" + s.key, e, s.related, i);
});
},
handleRemoval: function(e, r, i) {
i = i ? t.clone(i) : {}, this.changed = !0, t.each(this.getReverseRelations(e), function(e) {
e.removeRelated(this.instance, null, i);
}, this);
var s = this;
!i.silent && n.Relational.eventQueue.add(function() {
s.instance.trigger("remove:" + s.key, e, s.related, i);
});
},
handleReset: function(e, r) {
var i = this;
r = r ? t.clone(r) : {}, !r.silent && n.Relational.eventQueue.add(function() {
i.instance.trigger("reset:" + i.key, i.related, r);
});
},
tryAddRelated: function(e, n, r) {
var i = t.contains(this.keyIds, e.id);
i && (this.addRelated(e, r), this.keyIds = t.without(this.keyIds, e.id));
},
addRelated: function(e, t) {
var n = this;
e.queue(function() {
n.related && !n.related.get(e) && n.related.add(e, t);
});
},
removeRelated: function(e, t, n) {
this.related.get(e) && this.related.remove(e, n);
}
}), n.RelationalModel = n.Model.extend({
relations: null,
_relations: null,
_isInitialized: !1,
_deferProcessing: !1,
_queue: null,
subModelTypeAttribute: "type",
subModelTypes: null,
constructor: function(e, r) {
if (r && r.collection) {
var i = this, s = this.collection = r.collection;
delete r.collection, this._deferProcessing = !0;
var o = function(e) {
e === i && (i._deferProcessing = !1, i.processQueue(), s.off("relational:add", o));
};
s.on("relational:add", o), t.defer(function() {
o(i);
});
}
n.Relational.store.processOrphanRelations(), this._queue = new n.BlockingQueue, this._queue.block(), n.Relational.eventQueue.block();
try {
n.Model.apply(this, arguments);
} finally {
n.Relational.eventQueue.unblock();
}
},
trigger: function(e) {
if (e.length > 5 && e.indexOf("change") === 0) {
var t = this, r = arguments;
n.Relational.eventQueue.add(function() {
if (!t._isInitialized) return;
var i = !0;
if (e === "change") i = t.hasChanged(); else {
var s = e.slice(7), o = t.getRelation(s);
o && (i = r[4] === !0, i ? t.changed[s] = r[2] : o.changed || delete t.changed[s]);
}
i && n.Model.prototype.trigger.apply(t, r);
});
} else n.Model.prototype.trigger.apply(this, arguments);
return this;
},
initializeRelations: function(e) {
this.acquire(), this._relations = {}, t.each(this.relations || [], function(t) {
n.Relational.store.initializeRelation(this, t, e);
}, this), this._isInitialized = !0, this.release(), this.processQueue();
},
updateRelations: function(e) {
this._isInitialized && !this.isLocked() && t.each(this._relations, function(t) {
var n = this.attributes[t.keySource] || this.attributes[t.key];
t.related !== n && this.trigger("relational:change:" + t.key, this, n, e || {});
}, this);
},
queue: function(e) {
this._queue.add(e);
},
processQueue: function() {
this._isInitialized && !this._deferProcessing && this._queue.isBlocked() && this._queue.unblock();
},
getRelation: function(e) {
return this._relations[e];
},
getRelations: function() {
return t.values(this._relations);
},
fetchRelated: function(e, r, i) {
r = t.extend({
update: !0,
remove: !1
}, r);
var s, o = [], u = this.getRelation(e), a = u && (u.keyIds || [ u.keyId ]), f = a && t.select(a || [], function(e) {
return (e || e === 0) && (i || !n.Relational.store.find(u.relatedModel, e));
}, this);
if (f && f.length) {
var l = [], c = t.map(f, function(e) {
var t = n.Relational.store.find(u.relatedModel, e);
if (!t) {
var i = {};
i[u.relatedModel.prototype.idAttribute] = e, t = u.relatedModel.findOrCreate(i, r), l.push(t);
}
return t;
}, this);
u.related instanceof n.Collection && t.isFunction(u.related.url) && (s = u.related.url(c));
if (s && s !== u.related.url()) {
var h = t.defaults({
error: function() {
var e = arguments;
t.each(l, function(t) {
t.trigger("destroy", t, t.collection, r), r.error && r.error.apply(t, e);
});
},
url: s
}, r);
o = [ u.related.fetch(h) ];
} else o = t.map(c, function(e) {
var n = t.defaults({
error: function() {
t.contains(l, e) && (e.trigger("destroy", e, e.collection, r), r.error && r.error.apply(e, arguments));
}
}, r);
return e.fetch(n);
}, this);
}
return o;
},
get: function(r) {
var i = n.Model.prototype.get.call(this, r);
if (!this.dotNotation || r.indexOf(".") === -1) return i;
var s = r.split("."), o = t.reduce(s, function(e, t) {
if (e instanceof n.Model) return n.Model.prototype.get.call(e, t);
throw new Error("Attribute must be an instanceof Backbone.Model. Is: " + e + ", currentSplit: " + t);
}, this);
if (i !== e && o !== e) throw new Error("Ambiguous result for '" + r + "'. direct result: " + i + ", dotNotation: " + o);
return i || o;
},
set: function(e, r, i) {
n.Relational.eventQueue.block();
var s;
t.isObject(e) || e == null ? (s = e, i = r) : (s = {}, s[e] = r);
var o = n.Model.prototype.set.apply(this, arguments);
try {
!this._isInitialized && !this.isLocked() ? (this.constructor.initializeModelHierarchy(), n.Relational.store.register(this), this.initializeRelations(i)) : s && this.idAttribute in s && n.Relational.store.update(this), s && this.updateRelations(i);
} finally {
n.Relational.eventQueue.unblock();
}
return o;
},
unset: function(e, t) {
n.Relational.eventQueue.block();
var r = n.Model.prototype.unset.apply(this, arguments);
return this.updateRelations(t), n.Relational.eventQueue.unblock(), r;
},
clear: function(e) {
n.Relational.eventQueue.block();
var t = n.Model.prototype.clear.apply(this, arguments);
return this.updateRelations(e), n.Relational.eventQueue.unblock(), t;
},
clone: function() {
var e = t.clone(this.attributes);
return t.isUndefined(e[this.idAttribute]) || (e[this.idAttribute] = null), t.each(this.getRelations(), function(t) {
delete e[t.key];
}), new this.constructor(e);
},
toJSON: function(e) {
if (this.isLocked()) return this.id;
this.acquire();
var r = n.Model.prototype.toJSON.call(this, e);
return this.constructor._superModel && !(this.constructor._subModelTypeAttribute in r) && (r[this.constructor._subModelTypeAttribute] = this.constructor._subModelTypeValue), t.each(this._relations, function(i) {
var s = r[i.key];
if (i.options.includeInJSON === !0) s && t.isFunction(s.toJSON) ? r[i.keyDestination] = s.toJSON(e) : r[i.keyDestination] = null; else if (t.isString(i.options.includeInJSON)) s instanceof n.Collection ? r[i.keyDestination] = s.pluck(i.options.includeInJSON) : s instanceof n.Model ? r[i.keyDestination] = s.get(i.options.includeInJSON) : r[i.keyDestination] = null; else if (t.isArray(i.options.includeInJSON)) if (s instanceof n.Collection) {
var o = [];
s.each(function(e) {
var n = {};
t.each(i.options.includeInJSON, function(t) {
n[t] = e.get(t);
}), o.push(n);
}), r[i.keyDestination] = o;
} else if (s instanceof n.Model) {
var o = {};
t.each(i.options.includeInJSON, function(e) {
o[e] = s.get(e);
}), r[i.keyDestination] = o;
} else r[i.keyDestination] = null; else delete r[i.key];
i.keyDestination !== i.key && delete r[i.key];
}), this.release(), r;
}
}, {
setup: function(e) {
return this.prototype.relations = (this.prototype.relations || []).slice(0), this._subModels = {}, this._superModel = null, this.prototype.hasOwnProperty("subModelTypes") ? n.Relational.store.addSubModels(this.prototype.subModelTypes, this) : this.prototype.subModelTypes = null, t.each(this.prototype.relations || [], function(e) {
e.model || (e.model = this);
if (e.reverseRelation && e.model === this) {
var r = !0;
if (t.isString(e.relatedModel)) {
var i = n.Relational.store.getObjectByName(e.relatedModel);
r = i && i.prototype instanceof n.RelationalModel;
}
r ? n.Relational.store.initializeRelation(null, e) : t.isString(e.relatedModel) && n.Relational.store.addOrphanRelation(e);
}
}, this), this;
},
build: function(e, t) {
var n = this;
this.initializeModelHierarchy();
if (this._subModels && this.prototype.subModelTypeAttribute in e) {
var r = e[this.prototype.subModelTypeAttribute], i = this._subModels[r];
i && (n = i);
}
return new n(e, t);
},
initializeModelHierarchy: function() {
if (t.isUndefined(this._superModel) || t.isNull(this._superModel)) {
n.Relational.store.setupSuperModel(this);
if (this._superModel) {
if (this._superModel.prototype.relations) {
var e = t.any(this.prototype.relations || [], function(e) {
return e.model && e.model !== this;
}, this);
e || (this.prototype.relations = this._superModel.prototype.relations.concat(this.prototype.relations));
}
} else this._superModel = !1;
}
this.prototype.subModelTypes && t.keys(this.prototype.subModelTypes).length !== t.keys(this._subModels).length && t.each(this.prototype.subModelTypes || [], function(e) {
var t = n.Relational.store.getObjectByName(e);
t && t.initializeModelHierarchy();
});
},
findOrCreate: function(e, r) {
r || (r = {});
var i = t.isObject(e) && r.parse && this.prototype.parse ? this.prototype.parse(e) : e, s = n.Relational.store.find(this, i);
return t.isObject(e) && (s && r.merge !== !1 ? s.set(i, r) : !s && r.create !== !1 && (s = this.build(e, r))), s;
}
}), t.extend(n.RelationalModel.prototype, n.Semaphore), n.Collection.prototype.__prepareModel = n.Collection.prototype._prepareModel, n.Collection.prototype._prepareModel = function(e, t) {
var r;
return e instanceof n.Model ? (e.collection || (e.collection = this), r = e) : (t || (t = {}), t.collection = this, typeof this.model.findOrCreate != "undefined" ? r = this.model.findOrCreate(e, t) : r = new this.model(e, t), r && r.isNew() && !r._validate(e, t) && (this.trigger("invalid", this, e, t), r = !1)), r;
};
var i = n.Collection.prototype.__add = n.Collection.prototype.add;
n.Collection.prototype.add = function(e, r) {
if (this.model.prototype instanceof n.RelationalModel) {
e = t.isArray(e) ? e.slice() : [ e ], r = t.extend({
merge: !1
}, r);
var s = [], o = [];
return t.each(e, function(e) {
e instanceof n.Model || (e = n.Collection.prototype._prepareModel.call(this, e, r)), e && (o.push(e), !this.get(e) && !this.get(e.cid) ? s.push(e) : e.id != null && (this._byId[e.id] = e));
}, this), i.call(this, o, r), t.each(s, function(e) {
(this.get(e) || this.get(e.cid)) && this.trigger("relational:add", e, this, r);
}, this), this;
}
return i.apply(this, arguments);
};
var s = n.Collection.prototype.__remove = n.Collection.prototype.remove;
n.Collection.prototype.remove = function(e, r) {
if (this.model.prototype instanceof n.RelationalModel) {
e = t.isArray(e) ? e.slice() : [ e ], r || (r = {});
var i = [];
return t.each(e, function(e) {
e = this.get(e) || this.get(e.cid), e && i.push(e);
}, this), i.length && (s.call(this, i, r), t.each(i, function(e) {
this.trigger("relational:remove", e, this, r);
}, this)), this;
}
return s.apply(this, arguments);
};
var o = n.Collection.prototype.__reset = n.Collection.prototype.reset;
n.Collection.prototype.reset = function(e, t) {
return o.call(this, e, t), this.model.prototype instanceof n.RelationalModel && this.trigger("relational:reset", this, t), this;
};
var u = n.Collection.prototype.__sort = n.Collection.prototype.sort;
n.Collection.prototype.sort = function(e) {
return u.call(this, e), this.model.prototype instanceof n.RelationalModel && this.trigger("relational:reset", this, e), this;
};
var a = n.Collection.prototype.__trigger = n.Collection.prototype.trigger;
n.Collection.prototype.trigger = function(e) {
if (this.model.prototype instanceof n.RelationalModel) {
if (e === "add" || e === "remove" || e === "reset") {
var r = this, i = arguments;
t.isObject(i[3]) && (i = t.toArray(i), i[3] = t.clone(i[3])), n.Relational.eventQueue.add(function() {
a.apply(r, i);
});
} else a.apply(this, arguments);
return this;
}
return a.apply(this, arguments);
}, n.RelationalModel.extend = function(e, t) {
var r = n.Model.extend.apply(this, arguments);
return r.setup(this), r;
};
})();

// JSON-Patch/src/json-patch-duplex.js

var jsonpatch;

(function(e) {
function i(e, t) {
for (var n in t) {
var r = t[n];
r instanceof Object && (Object.unobserve(r, e), r.____Path = t.____Path + "/" + n, i(e, r));
}
}
function s(e, t) {
delete t.____Path, Object.observe(t, e);
for (var n in t) {
var r = t[n];
r instanceof Object && s(e, r);
}
}
function a(e, t) {
var n = [], a = e;
if (Object.observe) var c = function(e) {
a.___Path || (Object.unobserve(a, c), a.____Path = "", i(c, a), e.forEach(function(e) {
e.name != "____Path" && r[e.type].call(e, n, e.object.____Path);
}), s(c, a)), t && t.call(n);
}; else {
c = {}, o[e] = JSON.parse(JSON.stringify(e));
if (t) {
u.push(t);
var h, p = [ 100, 1e3, 1e4, 6e4 ], d = 0, v = function() {
var e = l(c);
e.length > 0 && (c.patches = [], t.call(null, e));
}, m = function(e) {
clearTimeout(h), h = setTimeout(function() {
v(), d = 0, h = setTimeout(g, p[d++]);
}, 0);
}, g = function() {
v(), d == p.length && (d = p.length - 1), h = setTimeout(g, p[d++]);
};
[ "mousedown", "mouseup", "keydown" ].forEach(function(e) {
window.addEventListener(e, m);
}), h = setTimeout(g, p[d++]);
}
}
return c.patches = n, c.object = e, f(c, e, n);
}
function f(e, t, n) {
Object.observe && Object.observe(t, e);
for (var r in t) if (t.hasOwnProperty(r)) {
var i = t[r];
i && typeof i == "object" && f(e, i, n);
}
return e;
}
function l(e) {
if (Object.observe) Object.deliverChangeRecords(e); else {
var t = o[e.object];
c(t, e.object, e.patches, "");
}
return e.patches;
}
function c(e, t, n, r) {
var i = Object.keys(t), s = Object.keys(e), o = !1, u = !1, a = !1;
for (var f = 0; f < s.length; f++) {
var l = s[f], h = e[l];
if (t.hasOwnProperty(l)) {
var p = t[l];
h instanceof Object ? c(h, p, n, r + "/" + l) : h != p && (o = !0, n.push({
op: "replace",
path: r + "/" + l,
value: p
}), e[l] = p);
} else n.push({
op: "remove",
path: r + "/" + l
}), u = !0;
}
if (!u && i.length == s.length) return;
for (var f = 0; f < i.length; f++) {
var l = i[f];
e.hasOwnProperty(l) || n.push({
op: "add",
path: r + "/" + l,
value: t[l]
});
}
}
function h(e, r, i) {
try {
r.forEach(function(r) {
var i = r.path.split("/");
i.shift();
var s = e, o = 0, u = i.length;
for (;;) if (s instanceof Array) {
var a = parseInt(i[o], 10);
o++;
if (o >= u) {
n[r.op].call(r, s, a, e);
break;
}
s = s[a];
} else {
var f = i[o];
f.indexOf("~") != -1 && (f = f.replace("~1", "/").replace("~0", "~")), o++;
if (o >= u) {
t[r.op].call(r, s, f, e);
break;
}
s = s[f];
}
});
} catch (s) {
return !1;
}
return !0;
}
var t = {
add: function(e, t) {
e[t] = this.value;
},
remove: function(e, t) {
delete e[t];
},
replace: function(e, t) {
e[t] = this.value;
},
move: function(e, t, n) {
var r = {
op: "_get",
path: this.from
};
h(n, [ r ], undefined), h(n, [ {
op: "remove",
path: this.from
} ], undefined), h(n, [ {
op: "add",
path: this.path,
value: r.value
} ]);
},
copy: function(e, t, n) {
var r = {
op: "_get",
path: this.from
};
h(n, [ r ], undefined), h(n, [ {
op: "add",
path: this.path,
value: r.value
} ]);
},
test: function(e, t) {
if (JSON.stringify(e[t]) != JSON.stringify(this.value)) throw "";
},
_get: function(e, t) {
this.value = e[t];
}
}, n = {
add: function(e, t) {
e.splice(t, 0, this.value);
},
remove: function(e, t) {
e.splice(t, 1);
},
replace: function(e, t) {
e[t] = this.value;
},
move: t.move,
copy: t.copy,
test: t.test,
_get: t._get
}, r = {
"new": function(e, t) {
var n = {
op: "add",
path: t + "/" + this.name,
value: this.object[this.name]
};
e.push(n);
},
deleted: function(e, t) {
var n = {
op: "remove",
path: t + "/" + this.name
};
e.push(n);
},
updated: function(e, t) {
var n = {
op: "replace",
path: t + "/" + this.name,
value: this.object[this.name]
};
e.push(n);
}
}, o = {}, u = [];
e.observe = a, e.generate = l, e.apply = h;
})(jsonpatch || (jsonpatch = {}));

// session.js

(function() {
"use strict";
_.extend(XT.Session, {
privileges: {},
relevantPrivileges: [],
privilegeSegments: {
Account: [ "MaintainBankAccounts", "MaintainAccountingPeriods", "ViewAccountingPeriods", "MaintainSalesAccount", "ViewSalesAccount", "MaintainChartOfAccounts", "MaintainVendorAccounts", "ViewVendorAccounts", "MaintainAllCRMAccounts", "ViewAllCRMAccounts", "MaintainPersonalCRMAccounts", "ViewPersonalCRMAccounts", "ViewBankAccountsDock", "ViewGLAccountsDock", "ViewMyAccountsDock", "ViewAccountingDesktop" ],
Contact: [ "MergeContacts", "MaintainAllContacts", "ViewAllContacts", "MaintainPersonalContacts", "ViewPersonalContacts", "ViewMyContactsDock", "MaintainTitles", "ViewTitles" ],
ToDo: [ "ReassignToDoItems", "ViewAllToDoItems", "MaintainAllToDoItems", "MaintainPersonalToDoItems", "ViewPersonalToDoItems" ],
Opportunity: [ "MaintainOpportunitySources", "MaintainOpportunityStages", "MaintainOpportunityTypes", "MaintainAllOpportunities", "ViewAllOpportunities", "MaintainPersonalOpportunities", "ViewPersonalOpportunities" ],
Incident: [ "MaintainIncidentCategories", "MaintainIncidentPriorities", "MaintainIncidentSeverities", "MaintainIncidentResolutions", "CloseAllIncidents", "ClosePersonalIncidents", "MaintainAllIncidents", "ViewAllIncidents", "MaintainPersonalIncidents", "ViewPersonalIncidents", "ViewPersonalIncidentHistory", "MaintainEmailProfiles" ],
Project: [ "MaintainAllProjects", "ViewAllProjects", "MaintainPersonalProjects", "ViewPersonalProjects", "ViewProjectBudget", "ViewProjectFinancialReport" ],
Customer: [ "ViewCustomerMasters", "ViewCustomerTypes", "MaintainCustomerTypes", "UpdateCustomerCreditStatus", "ViewCustomerPrices", "MaintainCustomerGroups", "ViewCustomerGroups", "CreateSOForHoldCustomer", "CreateSOForWarnCustomer", "UpdateCustomerCreditStatus", "MaintainCustomerMastersCustomerType", "MaintainCustomerMastersCustomerTypeOnCreate", "MaintainCustomerMasters" ],
Quote: [ "MaintainQuotes", "ViewQuotes" ],
SalesOrder: [ "MaintainSalesOrders", "ViewSalesOrders", "ShowMarginsOnSalesOrder", "FirmSalesOrder", "ViewSalesOrdersDock", "OverridePrice", "CreateSOForHoldCustomer", "CreateSOForWarnCustomer", "OverrideSODate", "AlterPackDate" ],
Tax: [ "MaintainTaxAuthorities", "ViewTaxAuthorities", "MaintainTaxTypes", "ViewTaxTypes", "OverrideTax", "MaintainTaxReconciliations", "ViewTaxReconciliations", "MaintainTaxCodes", "ViewTaxCodes", "ViewTaxZones", "MaintainTaxZones", "ViewTaxClasses", "MaintainTaxClasses", "MaintainTaxAssignments", "ViewTaxAssignments", "MaintainTaxRegistrations", "ViewTaxRegistrations" ],
Currency: [ "CreateNewCurrency", "MaintainCurrencies", "MaintainCurrencyRates", "ViewCurrencyRates" ],
Address: [ "ViewVendorAddresses", "MaintainVendorAddresses", "MaintainAddresses", "ViewAddresses", "MaintainStates" ],
Item: [ "ViewItemMasters", "MaintainItemMasters", "DeleteItemMasters" ],
ItemSite: [ "ViewItemSites", "MaintainItemSites", "DeleteItemSites" ],
Inventory: [ "MaintainCarriers", "ViewShipping", "ViewLocations", "ViewInventoryAvailability", "CreateAdjustmentTrans", "CreateScrapTrans", "CreateReceiptTrans", "CreateInterWarehouseTrans", "MaintainItemSites", "ViewItemSites", "PostCountSlips", "EnterCountSlips", "DeleteCountTags", "ZeroCountTags", "ViewCountTags", "PostCountTags", "PurgeCountSlips", "PurgeCountTags", "ViewInventoryValue", "RelocateInventory", "ReassignLotSerial", "ViewQOH", "UpdateCycleCountFreq", "UpdateLeadTime", "SummarizeInventoryTransactions", "ThawInventory", "MaintainCostCategories", "ViewCostCategories", "DeleteCountSlips", "PrintBillsOfLading", "ShipOrders", "ReturnStockFromShipping", "IssueStockToShipping", "PurgeShippingRecords", "ViewDestinations", "MaintainDestinations", "EnterShippingInformation", "RecallOrders", "ViewCarriers", "EnterReceipts", "EnterReturns", "UpdateOUTLevels", "UpdateReorderLevels", "MaintainPackingListBatch", "ViewPackingListBatch", "MaintainCharacteristics", "ViewCharacteristics", "DeleteItemSites", "CreateExpenseTrans", "CreateTransformTrans", "RecallInvoicedShipment", "ViewItemAvailabilityWorkbench", "MaintainTransferOrders", "ViewTransferOrders", "OverrideTODate", "ViewInventoryHistory", "ViewWarehouses", "MaintainWarehouses", "UpdateABCClass", "FreezeInventory", "EnterMiscCounts", "IssueCountTags", "EnterCountTags", "MaintainLocations", "AlterTransactionDates", "MaintainExternalShipping", "MaintainSiteTypes", "ViewSiteTypes", "ReleaseTransferOrders" ]
},
settings: {},
schemas: {
XM: !1
},
SETTINGS: 1,
PRIVILEGES: 2,
SCHEMA: 4,
LOCALE: 8,
PREFERENCES: 16,
ALL: 31,
loadSessionObjects: function(e, t) {
var n = this, r, i, s, o, u, a, f, l = 0, c = 0, h;
return t && t.success && t.success instanceof Function ? f = t.success : f = function() {}, e === undefined && (e = this.ALL), e & this.PRIVILEGES && (r = t ? _.clone(t) : {}, r.success = function(e) {
var t, r;
n.getPrivileges().attributes ? t = n.getPrivileges() : (t = new Backbone.Model, t.get = function(e) {
return _.isBoolean(e) ? e : Backbone.Model.prototype.get.call(this, e);
});
for (r = 0; r < e.length; r++) t.set(e[r].privilege, e[r].isGranted);
n.setPrivileges(t), f();
}, XM.ModelMixin.dispatch("XT.Session", "privileges", null, r)), e & this.SETTINGS && (i = t ? _.clone(t) : {}, i.success = function(e) {
s = new Backbone.Model(e), n.setSettings(s), f();
}, XM.ModelMixin.dispatch("XT.Session", "settings", null, i)), e & this.SCHEMA && (o = t ? _.clone(t) : {}, o.success = function(e, t) {
var r, i, s, o, u, a, h, p;
n.getSchemas()[t.schemaName].attributes ? (r = n.getSchemas()[t.schemaName], r.set(e)) : (r = new Backbone.Model(e), n.setSchema(t.schemaName, r)), c++, c === l && (_.each(n.getSchemas(), function(e, t) {
for (var n in e.attributes) if (e.attributes.hasOwnProperty(n)) {
s = XM.Model.getObjectByName(t + "." + n);
if (s) {
h = s.prototype, a = e.attributes[n], o = a.relations || [];
if (o.length) {
h.relations = [];
for (p = 0; p < o.length; p++) {
u = o[p];
if (u.type === "Backbone.HasOne") u.type = Backbone.HasOne; else {
if (u.type !== "Backbone.HasMany") continue;
u.type = Backbone.HasMany;
}
h.relations.push(u);
}
}
h.idAttribute = a.idAttribute, h.lockable = a.lockable, a.privileges && (h.privileges = a.privileges), h.requiredAttributes = a.requiredAttributes;
}
}
}), f());
}, o.error = function() {
console.log("schema error", arguments);
}, _.each(this.schemas, function(e, t) {
o.schemaName = t, XM.ModelMixin.dispatch("XT.Session", "schema", t.toLowerCase(), o), l++;
})), e & this.PREFERENCES && (u = t ? _.clone(t) : {}, u.success = function(e) {
var t = new XM.UserPreference(e);
n.setPreferences(t), f();
}, XM.ModelMixin.dispatch("XT.Session", "preferences", null, u)), !0;
},
getPreferences: function() {
return this.preferences;
},
getSchemas: function() {
return this.schemas;
},
getSettings: function() {
return this.settings;
},
getPrivileges: function() {
return this.privileges;
},
setPreferences: function(e) {
return this.preferences = e, this;
},
setSchema: function(e, t) {
return this.schemas[e] = t, this;
},
setSettings: function(e) {
return this.settings = e, this;
},
setPrivileges: function(e) {
return this.privileges = e, this;
},
addRelevantPrivileges: function(e, t) {
var n = _.map(t, function(t) {
return {
module: e,
privilege: t
};
});
this.relevantPrivileges = _.union(this.relevantPrivileges, n);
},
DB_BOOLEAN: "B",
DB_STRING: "S",
DB_COMPOUND: "C",
DB_DATE: "D",
DB_NUMBER: "N",
DB_ARRAY: "A",
DB_BYTEA: "U",
DB_UNKNOWN: "X"
});
})();

// core.js

(function() {
XM = {}, XM.jsonpatch = jsonpatch;
})();

// model_mixin.js

(function() {
"use strict";
var e = function(e, t) {
var n = this.privileges && this.privileges.attribute && this.privileges.attribute[t] && !_.isUndefined(this.privileges.attribute[t][e]) ? this.privileges.attribute[t][e] : undefined, r = _.isUndefined(n) ? !0 : XT.session.getPrivileges().get(n), i = !0;
return e === "view" && t && this.get(t) instanceof Backbone.Collection ? i = this.get(t).model.prototype.canView() : e === "view" && t && this.get(t) instanceof Backbone.Model && (i = this.get(t).canView()), r && i;
};
XM.ModelMixin = {
handlers: {},
meta: null,
autoFetchId: !0,
binaryField: null,
lastError: null,
lock: null,
lockable: !1,
keepInHistory: !0,
privileges: null,
readOnly: !1,
readOnlyAttributes: null,
nameAttribute: "name",
recordType: null,
requiredAttributes: null,
status: null,
etag: null,
augment: function(e) {
var t = this;
_.each(e, function(e, n) {
var r = t[n];
if (_.isUndefined(r)) t[n] = e; else {
if (typeof e != typeof r) throw new Error("Type mismatch in augment: " + n);
if (_.isArray(e)) t[n] = _.union(r, e); else if (_.isFunction(e) && n === "defaults") t[n] = function() {
var t = r.apply(this, arguments), n = e.apply(this, arguments);
return _.extend(t, n);
}; else if (_.isFunction(e)) t[n] = function() {
r.apply(this, arguments), e.apply(this, arguments);
}; else {
if (_.isObject(e) && _.intersection(Object.keys(r), Object.keys(e)).length > 0) throw new Error("Illegal overwrite in augment: " + n);
if (!_.isObject(e)) throw new Error("Do not know how to augment: " + n);
t[n] = _.extend({}, r, e);
}
}
});
},
bindEvents: function() {
if (this._eventsBound) throw new Error("Events have already been bound.");
this.on("change", this.didChange), this.on("error", this.didError), this.on("destroy", this.didDestroy), this._eventsBound = !0;
},
getAttributeType: function(e) {
var t = _.findWhere(XT.session.schemas.XM.get(this.recordType.suffix()).columns, {
name: e
});
return t && t.type;
},
canEdit: function(t) {
return e.call(this, "update", t);
},
canUpdate: function() {
return this.getClass().canUpdate(this);
},
canDelete: function() {
return this.getClass().canDelete(this);
},
canDestroy: function(e) {
this.getClass().canDestroy(this, e);
},
canView: function(t) {
return e.call(this, "view", t);
},
destroy: function(e) {
e = e ? _.clone(e) : {};
var t = this, n, r = e.success, i = XM.ModelClassMixin;
return this.setStatus(i.DESTROYED_DIRTY), this.setStatus(i.BUSY_DESTROYING), this._wasNew = this.isNew(), e.wait = !0, e.success = function(n) {
r && r(t, n, e);
}, n = Backbone.Model.prototype.destroy.call(this, e), delete this._wasNew, n;
},
didChange: function(e, t) {
t = t || {};
var n = XM.ModelClassMixin, r = this.getStatus();
if (this.isBusy()) return;
r === n.READY_CLEAN && this.setStatus(n.READY_DIRTY);
},
didDestroy: function() {
var e = XM.ModelClassMixin;
this.clear({
silent: !0
}), this.setStatus(e.DESTROYED_CLEAN);
},
didError: function(e, t) {
e = e || {}, this.lastError = t, XT.log(t);
},
generatePatches: function() {
if (!this._cache) return [];
var e = XM.jsonpatch.observe(this._cache);
return e.object = this.toJSON(), XM.jsonpatch.generate(e);
},
initialize: function(e, t) {
e = e || {}, t = t || {};
var n, r = XM.ModelClassMixin, i = this.getStatus(), s = this.idAttribute;
this.privileges = this.privileges || {}, this.readOnlyAttributes = this.readOnlyAttributes ? this.readOnlyAttributes.slice(0) : [], this.requiredAttributes = this.requiredAttributes ? this.requiredAttributes.slice(0) : [];
if (_.isEmpty(this.recordType)) throw new Error("No record type defined");
_.isNull(i) && (this.setStatus(r.EMPTY), this.bindEvents());
if (t.isNew) {
n = this.getClass();
if (!n.canCreate()) throw new Error("Insufficent privileges to create a record.");
this.setStatus(r.READY_NEW), s === "uuid" && !this.get(s) && !e[s] && this.set(s, XT.generateUUID()), this.autoFetchId && (t.database ? this.fetchId({
database: t.database
}) : this.fetchId());
}
s && !_.contains(this.requiredAttributes, s) && this.requiredAttributes.push(s);
},
lockDidChange: function(e, t) {
var n = this, r = {};
this._keyRefresherInterval && (clearInterval(this._keyRefresherInterval), n._keyRefresherInterval = undefined), t && t.key && !this._keyRefresherInterval && (r.automatedRefresh = !0, r.success = function(e) {
var t = n.lock;
t && !e && (t = _.clone(t), delete t.key, n.lock = t);
}, this._keyRefresherInterval = setInterval(function() {
n.dispatch("XM.Model", "renewLock", [ t.key ], r);
}, 25e3)), this.trigger("lockChange", n);
},
dispatch: function(e, t, n, r) {
r = _.extend({}, r);
var i = r.dataSource || XT.dataSource, s = {
nameSpace: e.replace(/\.\w+/i, ""),
type: e.suffix(),
dispatch: {
functionName: t,
parameters: n
}
};
return i.request(null, "post", s, r);
},
fetch: function(e) {
e = e ? _.clone(e) : {};
var t = this, n = XM.ModelClassMixin, r = e.success, i = this.getClass();
return i.canRead() ? (this.setStatus(n.BUSY_FETCHING), e.success = function(i) {
t.setStatus(n.READY_CLEAN, e), XT.session.config.debugging && XT.log("Fetch successful"), r && r(t, i, e);
}, Backbone.Model.prototype.fetch.call(this, e)) : (XT.log("Insufficient privileges to fetch"), !1);
},
fetchId: function(e) {
e = _.defaults(e ? _.clone(e) : {}, {});
var t = this;
this.id || (e.success = function(n) {
t.set(t.idAttribute, n, e);
}, this.dispatch("XM.Model", "fetchId", this.recordType, e));
},
findExisting: function(e, t, n) {
return n = n || {}, this.getClass().findExisting.call(this, e, t, n);
},
getAttributeNames: function() {
return this.getClass().getAttributeNames.call(this);
},
getClass: function() {
return Object.getPrototypeOf(this).constructor;
},
getStatus: function() {
return this.status;
},
getStatusString: function() {
var e = [], t = this.getStatus(), n;
for (n in XM.ModelClassMixin) XM.ModelClassMixin.hasOwnProperty(n) && n.match(/[A-Z_]$/) && XM.ModelClassMixin[n] === t && e.push(n);
return e.join(" ");
},
getType: function(e) {
return this.getClass().getType(e);
},
getValue: function(e) {
var t, n;
return e.indexOf(".") !== -1 ? (t = e.split("."), n = this, _.each(t, function(e) {
n = n instanceof Backbone.Model ? n.getValue(e) : n;
}), n || (_.isBoolean(n) || _.isNumber(n) ? n : "")) : _.has(this.attributes, e) ? this.attributes[e] : this.meta && _.has(this.meta.attributes, e) ? this.meta.get(e) : _.isFunction(this[e]) ? this[e]() : this[e];
},
isBusy: function() {
var e = this.getStatus(), t = XM.ModelClassMixin;
return e === t.BUSY_FETCHING || e === t.BUSY_COMMITTING || e === t.BUSY_DESTROYING;
},
isNew: function() {
var e = XM.ModelClassMixin;
return this.getStatus() === e.READY_NEW || this._wasNew || !1;
},
isDestroyed: function() {
var e = this.getStatus(), t = XM.ModelClassMixin;
return e === t.DESTROYED_CLEAN || e === t.DESTROYED_DIRTY;
},
isDirty: function() {
var e = this.getStatus(), t = XM.ModelClassMixin;
return e === t.READY_NEW || e === t.READY_DIRTY || e === t.DESTROYED_DIRTY;
},
isReady: function() {
var e = this.getStatus(), t = XM.ModelClassMixin;
return e === t.READY_NEW || e === t.READY_CLEAN || e === t.READY_DIRTY;
},
isReadyClean: function() {
return this.getStatus() === XM.Model.READY_CLEAN;
},
hasLockKey: function() {
return !this.lock || this.lock.key ? !0 : !1;
},
getLockKey: function() {
return this.lock ? this.lock.key : !1;
},
isReadOnly: function(e) {
var t, n, r = !this.hasLockKey();
return _.isString(e) && e.indexOf(".") !== -1 ? (n = e.split("."), t = this, _.each(n, function(e) {
if (t instanceof Backbone.Model) t = t.getValue(e); else {
if (_.isNull(t)) return t;
_.isUndefined(t) || (t = t.isReadOnly(e) || !t.hasLockKey());
}
}), t) : (!_.isString(e) && !_.isObject(e) || this.readOnly ? t = this.readOnly : t = _.contains(this.readOnlyAttributes, e), t || r);
},
isRequired: function(e) {
return _.contains(this.requiredAttributes, e);
},
notify: function(e, t) {
t = t ? _.clone(t) : {}, t.type === undefined && (t.type = XM.ModelClassMixin.NOTICE), this.trigger("notify", this, e, t);
},
original: function(e) {
var t, n;
return e.indexOf(".") !== -1 ? (t = e.split("."), n = this, _.each(t, function(e) {
n = n instanceof Backbone.Model ? n.original(e) : n;
}), n || (_.isBoolean(n) || _.isNumber(n) ? n : "")) : this._cache ? this._cache[e] : this.attributes[e];
},
originalAttributes: function() {
return this._cache;
},
parse: function(e) {
var t = XT.Session, n = XT.session.getSchemas(), r, i;
return i = function(e, i, s) {
var o = n[e].get(i), u;
if (!o) throw new Error(i + " not found in schema " + e + ".");
for (u in s) s.hasOwnProperty(u) && s[u] !== null && (r = _.findWhere(o.columns, {
name: u
}) || {}, r.category === t.DB_DATE && (s[u] = new Date(s[u])));
return s;
}, i(this.recordType.prefix(), this.recordType.suffix(), e);
},
previousStatus: function() {
return this._prevStatus;
},
_reentrantLockHelper: function(e, t, n) {
var r = this, i = _.extend({}, n), s = i.success, o = e + "Lock", u = "lock:" + e;
this.dispatch("XM.Model", o, t, _.extend(i, {
success: function(e) {
r.lock = e, r.lockDidChange(r, e), r.trigger(u, r, {
lock: e
}), _.isFunction(s) && s();
},
error: function() {
r.trigger("lock:error", r);
}
}));
},
revertStatus: function(e) {
var t = XM.ModelClassMixin, n = this._prevStatus;
this.setStatus(this._prevStatus || t.EMPTY), this._prevStatus = n;
},
save: function(e, t, n) {
n = n ? _.clone(n) : {};
var r = {}, i = XM.ModelClassMixin, s, o;
_.isObject(e) || _.isEmpty(e) ? (r = e, n = t ? _.clone(t) : {}) : _.isString(e) && (r[e] = t);
if (this.isDirty() || r) {
this._wasNew = this.isNew(), s = n.success, n.wait = !0, n.success = function(e, t, n) {
e.setStatus(i.READY_CLEAN, n), XT.session.config.debugging && XT.log("Save successful"), s && s(e, t, n);
};
if (_.isObject(e) || _.isEmpty(e)) t = n;
return this.setStatus(i.BUSY_COMMITTING, {
cascade: !0
}), o = Backbone.Model.prototype.save.call(this, e, t, n), delete this._wasNew, o || this.revertStatus(!0), o;
}
return XT.log("No changes to save"), !1;
},
set: function(e, t, n) {
var r = XM.ModelClassMixin, i = _.isObject(e), s = this.getStatus(), o;
i && (n = t), n = n ? n : {};
switch (s) {
case r.READY_CLEAN:
this.canUpdate() || (o = XT.Error.clone("xt1010"));
break;
case r.READY_DIRTY:
case r.READY_NEW:
break;
case r.ERROR:
case r.DESTROYED_CLEAN:
case r.DESTROYED_DIRTY:
o = XT.Error.clone("xt1009", {
params: {
status: s
}
});
break;
default:
_.isBoolean(n.silent) || (n.silent = !0);
}
return o ? (this.trigger("invalid", this, o, n), !1) : (i && (t = n), Backbone.Model.prototype.set.call(this, e, t, n));
},
setIfExists: function(e, t, n) {
var r = XM.ModelClassMixin, i = _.isObject(e), s = this.getAttributeNames();
i && (n = t), n = n ? n : {};
if (i) {
_.each(e, function(t, n) {
_.contains(s, n) || delete e[n];
});
if (_.isEmpty(e)) return !1;
} else if (!_.contains(s, e)) return !1;
return i && (t = n), this.set.call(this, e, t, n);
},
setValue: function(e, t, n) {
var r = _.isObject(e), i = this.getAttributeNames(), s = this, o;
return this.meta ? (r && (n = t), n = n ? n : {}, r ? (_.each(e, function(t, r) {
_.contains(i, r) || (s.meta.set(r, t, n), delete e[r]);
}), _.isEmpty(e) || s.set(e, n)) : _.contains(i, e) ? this.set(e, t, n) : this.meta.set(e, t, n), this) : this.setIfExists(e, t, n);
},
setReadOnly: function(e, t) {
t = _.isBoolean(t) ? t : !0;
var n = this, r = {}, i, s = function(e, t) {
t && !_.contains(n.readOnlyAttributes, e) ? (n.readOnlyAttributes.push(e), r[e] = !0) : !t && _.contains(n.readOnlyAttributes, e) && (n.readOnlyAttributes = _.without(n.readOnlyAttributes, e), r[e] = !0);
};
return _.isObject(e) ? _.each(e, function(e) {
s(e, t), r[e] = !0;
}) : _.isString(e) ? s(e, t) : (e = _.isBoolean(e) ? e : !0, this.readOnly = e, i = _.difference(this.getAttributeNames(), this.readOnlyAttributes), _.each(i, function(e) {
r[e] = !0;
})), _.isEmpty(r) || this.trigger("readOnlyChange", this, {
changes: r,
isReadOnly: t
}), this;
},
setStatus: function(e, t) {
var n = XM.ModelClassMixin;
if (this.status === e) return;
return this._prevStatus = this.status, this.status = e, e === n.READY_CLEAN && !this.readOnly && (this._cache = this.toJSON()), this.trigger("statusChange", this, e, t), this;
},
sync: function(e, t, n) {
n = n ? _.clone(n) : {};
var r = n.dataSource || XT.dataSource, i = this.idAttribute, s = n.error, o = XM.ModelClassMixin, u = this, a, f, l = n.success;
n.error = function(e) {
u.setStatus(o.ERROR), s && s(t, e, n);
}, n.success = function(e, t, n) {
_.isFunction(l) && l(e, t, n), u.trigger("sync", e, t, n);
};
if (n.collection) delete n.validate, a = [], n.collection.each(function(e) {
var t = {
nameSpace: e.recordType.replace(/\.\w+/i, ""),
type: e.recordType.suffix()
};
t.id = e.id;
if (e.binaryField) throw "Processing of for arrays of models with binary fields is not supported.";
switch (e.previousStatus()) {
case o.READY_NEW:
t.method = "post", t.data = e.toJSON(), t.requery = n.requery;
break;
case o.READY_DIRTY:
t.method = "patch", t.etag = e.etag, t.lock = e.lock, t.patches = e.generatePatches(), t.requery = n.requery;
break;
case o.DESTROYED_DIRTY:
t.method = "delete", t.etag = e.etag, t.lock = e.lock;
break;
default:
throw "Model in collection syncing from an unsupported state";
}
a.push(t);
}), e = "post"; else {
a = {}, a.nameSpace = this.recordType.replace(/\.\w+/i, ""), a.type = this.recordType.suffix();
if (n.id) a.id = n.id; else if (n[i]) a.id = n[i]; else if (t._cache) a.id = t._cache[i]; else if (t.id) a.id = t.id; else {
if (!t.attributes) {
n.error("Cannot find id");
return;
}
a.id = t.attributes[i];
}
switch (e) {
case "create":
a.data = t.toJSON(), a.binaryField = t.binaryField, a.requery = n.requery;
break;
case "read":
e = "get", n.context && (a.context = n.context);
break;
case "patch":
case "update":
a.etag = t.etag, a.lock = t.lock, a.patches = t.generatePatches(), a.binaryField = t.binaryField, a.requery = n.requery;
break;
case "delete":
a.etag = t.etag, a.lock = t.lock;
}
switch (e) {
case "create":
e = "post";
break;
case "read":
e = "get";
break;
case "update":
e = "patch";
}
}
return f = r.request(t, e, a, n), f || !1;
},
toJSON: function(e) {
var t, n = Backbone.Model.prototype.toJSON.apply(this, arguments);
for (t in n) n.hasOwnProperty(t) && n[t] instanceof Date && (n[t] = n[t].toJSON());
return n;
},
used: function(e) {
return this.getClass().used(this.id, e);
},
validate: function(e, t) {
e = e || {}, t = t || {}, XT.session.getSchemas()[this.recordType.prefix()].get(this.recordType.suffix()) || XT.log("Cannot find schema", this.recordType);
var n, r = XT.Session, i, s, o, u, a = {}, f = this.recordType.suffix(), l = this.recordType.prefix(), c = XT.session.getSchemas()[l].get(f).columns, h = function(e) {
return _.find(c, function(t) {
return t.name === e;
});
};
for (i in e) if (e.hasOwnProperty(i) && !_.isNull(e[i]) && !_.isUndefined(e[i])) {
a.attr = ("_" + i).loc(), s = e[i], u = h(i), o = u ? u.category : !1;
switch (o) {
case r.DB_BYTEA:
if (!_.isObject(s) && !_.isString(s)) return a.type = "_binary".loc(), XT.Error.clone("xt1003", {
params: a
});
break;
case r.DB_UNKNOWN:
case r.DB_STRING:
if (!_.isString(s)) return a.type = "_string".loc(), XT.Error.clone("xt1003", {
params: a
});
break;
case r.DB_NUMBER:
if (!_.isNumber(s)) return a.type = "_number".loc(), XT.Error.clone("xt1003", {
params: a
});
break;
case r.DB_DATE:
if (!_.isDate(s)) return a.type = "_date".loc(), XT.Error.clone("xt1003", {
params: a
});
break;
case r.DB_BOOLEAN:
if (!_.isBoolean(s)) return a.type = "_boolean".loc(), XT.Error.clone("xt1003", {
params: a
});
break;
case r.DB_ARRAY:
if (!_.isArray(s)) return a.type = "_array".loc(), XT.Error.clone("xt1003", {
params: a
});
break;
case r.DB_COMPOUND:
if (!_.isObject(s) && !_.isNumber(s)) return a.type = "_object".loc(), XT.Error.clone("xt1003", {
params: a
});
break;
default:
return XT.Error.clone("xt1002", {
params: a
});
}
}
for (n = 0; n < this.requiredAttributes.length; n += 1) {
s = e[this.requiredAttributes[n]];
if (s === undefined || s === null || s === "") return a.attr = ("_" + this.requiredAttributes[n]).loc(), XT.Error.clone("xt1004", {
params: a
});
}
return;
}
}, XM.ModelClassMixin = {
getReportUrl: function(e, t, n) {
var r = "/generate-report?nameSpace=%@&type=%@&id=%@".f(t.prefix(), t.suffix(), n);
return e && (r = r + "&action=" + e), r;
},
canCreate: function() {
return XM.ModelClassMixin.canDo.call(this, "create");
},
canRead: function(e, t) {
return XM.ModelClassMixin.canDo.call(this, "read", e, t);
},
canUpdate: function(e) {
return XM.ModelClassMixin.canDo.call(this, "update", e);
},
canDelete: function(e) {
return XM.ModelClassMixin.canDo.call(this, "delete", e);
},
canDestroy: function(e, t) {
var n = {};
if (!XM.ModelClassMixin.canDelete.call(this, e)) {
t(!1);
return;
}
n.success = function(e) {
t(!e);
}, this.used.call(this, e.id, n);
},
canDo: function(e, t, n) {
var r = this.prototype.privileges, i = XT.session.privileges, s = !1, o = !1, u = XT.session.details.username, a, f, l, c = XM.ModelClassMixin, h = t && t.getStatus ? t.getStatus() : c.READY;
if (!(h & c.READY)) return !1;
if (_.isEmpty(r)) return !0;
i && i.get && (r.all && r.all[e] && (s = this.checkCompoundPrivs(i, r.all[e])), !s && r.all && e === "read" && r.all.update && (s = this.checkCompoundPrivs(i, r.all.update)), !s && r.personal && r.personal[e] && (o = this.checkCompoundPrivs(i, r.personal[e])), !o && r.personal && e === "read" && r.personal.update && (o = this.checkCompoundPrivs(i, r.personal.update)));
if (!s && o && e !== "create" && t && t.originalAttributes()) {
f = 0, l = r.personal && r.personal.properties ? r.personal.properties : [], o = !1;
while (!o && f < l.length) a = t.original(l[f]).toLowerCase(), o = a === u, f += 1;
}
return s || o;
},
checkCompoundPrivs: function(e, t) {
if (typeof t != "string") return t;
var n = _.find(t.split(" "), function(t) {
return e.get(t);
});
return !!n;
},
getAttributeNames: function() {
var e = this.recordType || this.prototype.recordType, t = e.prefix(), n = e.suffix();
return _.pluck(XT.session.getSchemas()[t].get(n).columns, "name");
},
getType: function(e) {
var t = 0, n, r, i = function(e, t) {
var n = e.prototype.recordType.prefix(), r = e.prototype.recordType.suffix(), i = XT.session.schemas[n].get(r), s = _.findWhere(i.columns, {
name: t
});
return s ? s.type : undefined;
};
return _.isString(e) && e.indexOf(".") !== -1 ? (r = e.split("."), n = this, _.each(r, function(e) {
var s;
t++;
if (t < r.length) {
s = _.findWhere(n.prototype.relations, {
key: e
});
if (!s) return;
n = _.isString(s.relatedModel) ? XT.getObjectByName(s.relatedModel) : s.relatedModel;
} else n = i(n, e);
}), n) : i(this, e);
},
getObjectByName: function(e) {
return Backbone.Relational.store.getObjectByName(e);
},
getSearchableAttributes: function() {
var e = this.prototype.recordType, t = e.prefix(), n = e.suffix(), r = XT.session.getSchemas()[t].get(n), i = [], s, o;
for (o = 0; o < r.columns.length; o++) s = r.columns[o].name, r.columns[o].category === "S" && i.push(s);
return i;
},
findExisting: function(e, t, n) {
var r = this.recordType || this.prototype.recordType, i = [ r, e, t ];
return e !== this.idAttribute && i.push(this.id || ""), XM.ModelMixin.dispatch("XM.Model", "findExisting", i, n), this;
},
used: function(e, t) {
return XM.ModelMixin.dispatch("XM.Model", "used", [ this.prototype.recordType, e ], t);
},
CLEAN: 1,
DIRTY: 2,
EMPTY: 256,
ERROR: 4096,
READY: 512,
READY_CLEAN: 513,
READY_DIRTY: 514,
READY_NEW: 515,
DESTROYED: 1024,
DESTROYED_CLEAN: 1025,
DESTROYED_DIRTY: 1026,
BUSY: 2048,
BUSY_FETCHING: 2052,
BUSY_COMMITTING: 2064,
BUSY_DESTROYING: 2112,
NOTICE: 0,
WARNING: 1,
CRITICAL: 2,
QUESTION: 3,
YES_NO_CANCEL: 4,
OK_CANCEL: 5,
_status: {
CLEAN: 1,
DIRTY: 2,
EMPTY: 256,
ERROR: 4096,
READY: 512,
READY_CLEAN: 513,
READY_DIRTY: 514,
READY_NEW: 515,
DESTROYED: 1024,
DESTROYED_CLEAN: 1025,
DESTROYED_DIRTY: 1026,
BUSY: 2048,
BUSY_FETCHING: 2052,
BUSY_COMMITTING: 2064,
BUSY_DESTROYING: 2112,
NOTICE: 0,
WARNING: 1,
CRITICAL: 2,
QUESTION: 3,
YES_NO_CANCEL: 4,
1: "CLEAN",
2: "DIRTY",
256: "EMPTY",
4096: "ERROR",
512: "READY",
513: "READY_CLEAN",
514: "READY_DIRTY",
515: "READY_NEW",
1024: "DESTROYED",
1025: "DESTROYED_CLEAN",
1026: "DESTROYED_DIRTY",
2048: "BUSY",
2052: "BUSY_FETCHING",
2064: "BUSY_COMMITTING",
2112: "BUSY_DESTROYING"
}
};
})();

// model.js

(function() {
"use strict";
XM.Tuplespace = _.clone(Backbone.Events), XM.Model = Backbone.RelationalModel.extend(XM.ModelMixin), XM.Model = XM.Model.extend({
autoFetchId: !1,
obtainLock: function(e) {
if (this.getLockKey() && _.isFunction(e.success)) return this.trigger("lock:obtain", this, this.lock), e.success();
var t = [ this.recordType.prefix(), this.recordType.suffix(), this.id, this.etag ];
this._reentrantLockHelper("obtain", t, e);
},
renewLock: function(e) {
this._reentrantLockHelper("renew", [ this.lock.key ], e);
},
releaseLock: function(e) {
e = e || {};
var t = e.success;
this.getLockKey() ? (this._reentrantLockHelper("release", {
key: this.getLockKey()
}, e), this.lockDidChange(this, _.omit(this.lock, "key"))) : _.isFunction(t) && t();
},
bindEvents: function() {
var e = this;
if (this._eventsBound) throw new Error("Events have already been bound.");
_.each(this.handlers, function(t, n) {
if (!_.isFunction(e[t])) {
console.warn("Handler " + t + " not found: not binding");
return;
}
e.on(n, e[t]);
}), this.on("change", this.didChange), this.on("error", this.didError), this.on("destroy", this.didDestroy), _.each(_.where(this.relations, {
type: Backbone.HasMany,
includeInJSON: !0
}), function(t) {
e.on("add:" + t.key, e.didChange), e.isReadOnly() || e.on("add:" + t.key, e.relationAdded);
}), this._idx = {}, this._eventsBound = !0;
},
destroy: function(e) {
e = e ? _.clone(e) : {};
var t = this.getClass(), n = t.canDelete(this), r = e.success, i = this.isNew(), s = this, o, u = XM.Model, a = this.getParent(!0), f = [], l = function(e) {
_.each(e.relations, function(t) {
var n, r = e.attributes[t.key];
if (r && r.models && t.type === Backbone.HasMany) {
for (n = 0; n < r.models.length; n += 1) l(r.models[n]);
f = _.union(f, r.models);
}
});
};
return a && a.canUpdate(this) || !a && n || this.getStatus() === u.READY_NEW ? (this._wasNew = i, this.setStatus(u.DESTROYED_DIRTY, {
cascade: !0
}), !a && n || i ? (l(this), this.setStatus(u.BUSY_DESTROYING, {
cascade: !0
}), e.wait = !0, e.success = function(t) {
var n;
for (n = 0; n < f.length; n += 1) f[n].didDestroy();
XT.session.config.debugging && XT.log("Destroy successful"), r && r(s, t, e);
}, o = Backbone.Model.prototype.destroy.call(this, e), delete this._wasNew, o) : (r && r(this, null, e), !0)) : (XT.log("Insufficient privileges to destroy"), !1);
},
doEmail: function() {
XT.dataSource.callRoute("generate-report", this.getReportPayload("email"), {
error: function(e) {
console.log("email error", e);
},
success: function() {
console.log("email success");
}
});
},
doPrint: function(e) {
XT.dataSource.callRoute("generate-report", this.getReportPayload("print", e), {
success: function() {
console.log("print success");
}
});
},
_fetchHelper: function(e) {
if (!this.getClass().canRead()) return XT.log("Error: insufficient privileges to fetch"), !1;
var t = this, n = _.extend({}, e), r = n.success, i = function(e) {
t.setStatus(XM.Model.READY_CLEAN, n), _.isFunction(r) && r(t, e, n);
}, s = function(e) {
var r = XT.session.getSchemas()[t.recordType.prefix()], s = r.get(t.recordType.suffix()).lockable;
i = _.partial(i, e), s && n.obtainLock !== !1 ? t.obtainLock({
success: i
}) : i();
};
return _.extend(n, {
propagate: !0,
success: s
});
},
fetch: function(e) {
var t = this._fetchHelper(e);
return _.isObject(t) ? (this.setStatus(XM.Model.BUSY_FETCHING, {
cascade: !0
}), Backbone.Model.prototype.fetch.call(this, t)) : !1;
},
fetchId: function(e) {
e = _.defaults(e ? _.clone(e) : {});
var t = this, n;
this.id || (e.success = function(n) {
t.set(t.idAttribute, n, e);
}, this.dispatch("XM.Model", "fetchId", this.recordType, e)), e && e.cascade && _.each(this.relations, function(r) {
n = t.attributes[r.key], n && r.type === Backbone.HasMany && n.models && _.each(n.models, function(t) {
t.fetchId && t.fetchId(e);
});
});
},
fetchRelated: function(e, t, n) {
t = t || {};
var r = [], i, s = [], o = this.getStatus(), u = XM.Model, a = this.getRelation(e), f = a && (a.keyIds || [ a.keyId ]), l = f && _.select(f || [], function(e) {
return (e || e === 0) && (n || !Backbone.Relational.store.find(a.relatedModel, e));
}, this);
return l && l.length ? (t.max && l.length > t.max && (l.length = t.max), i = _.map(l, function(e) {
var n = Backbone.Relational.store.find(a.relatedModel, e), r;
return n || (r = {}, r[a.relatedModel.prototype.idAttribute] = e, n = a.relatedModel.findOrCreate(r, t), s.push(n)), n;
}, this), r = _.map(i, function(n) {
var r = _.defaults({
error: function() {
_.contains(s, n) && (n.trigger("destroy", n, n.collection, t), t.error && t.error.apply(n, arguments));
}
}, t);
if (o === u.READY_CLEAN || o === u.READY_DIRTY) r.context = {
recordType: this.recordType,
value: this.id,
relation: e
};
return n.fetch(r);
}, this)) : t.success && t.success(), r;
},
toJSON: function(e) {
var t = e && e.includeNested, n = this, r = {}, i, s, o, u, a, f, l, c = function(e, t) {
return u.indexOf(e[a]) - u.indexOf(t[a]);
}, h = function(e, t) {
return u.indexOf(e.attributes[a]) - u.indexOf(t.attributes[a]);
};
t && (i = _.filter(this._relations, function(e) {
return e.options.isNested;
}), _.each(i, function(e) {
r[e.key] = e.options.includeInJSON, e.options.includeInJSON = !0;
})), s = Backbone.RelationalModel.prototype.toJSON.apply(this, arguments);
for (f in s) s.hasOwnProperty(f) && s[f] instanceof Date && (s[f] = s[f].toJSON());
return this.isLocked() ? this.id : (this.acquire(), l = _.filter(this.relations, function(e) {
return e.includeInJSON;
}), _.each(l, function(e) {
var t = XM.ModelClassMixin, r = e.key, i, f, l, p;
if (e.type === Backbone.HasMany) {
l = n.get(r);
if (l && l.length) {
u = n._idx[e.relatedModel.suffix()], u && (o = Backbone.Relational.store.getObjectByName(e.relatedModel), a = o.prototype.idAttribute, s[r].sort(c), i = l.comparator, l.comparator = h, l.sort());
for (p = 0; p < l.models.length; p++) f = l.models[p].getStatus(), f === t.BUSY_COMMITTING && (f = l.models[p]._prevStatus), f === t.DESTROYED_DIRTY ? delete s[r][p] : f === t.DESTROYED_CLEAN ? s[r].splice(p, 1) : e.isNested && delete s[r][p][e.reverseRelation.key];
}
u && (l.comparator = i);
}
}), this.release(), t && _.each(i, function(e) {
e.options.includeInJSON = r[e.key], delete e.options.oldIncludeInJSON;
}), s);
},
getClass: function() {
return Backbone.Relational.store.getObjectByName(this.recordType);
},
getParent: function(e) {
var t, n, r = _.find(this.relations, function(e) {
if (e.reverseRelation && e.isAutoRelation) return !0;
});
return t = r && r.key ? this.get(r.key) : !1, t && e && (n = t.getParent(e)), n || t;
},
getReportUrl: function(e) {
var t = this.reportRecordType || this.editableModel || this.recordType;
return XM.Model.getReportUrl(e, t, this.id);
},
getReportPayload: function(e, t) {
var n = this.reportRecordType || this.editableModel || this.recordType;
return {
nameSpace: n.prefix(),
type: n.suffix(),
id: this.id,
auxilliaryInfo: t,
action: e
};
},
initialize: function(e, t) {
e = e || {}, t = t || {};
var n = this, r, i = XM.Model, s = this.getStatus(), o = this.idAttribute;
this.privileges = this.privileges || {}, this.readOnlyAttributes = this.readOnlyAttributes ? this.readOnlyAttributes.slice(0) : [], this.requiredAttributes = this.requiredAttributes ? this.requiredAttributes.slice(0) : [];
if (_.isEmpty(this.recordType)) throw new Error("No record type defined");
t.status ? this.setStatus(t.status) : _.isNull(s) && (this.setStatus(i.EMPTY), this.bindEvents());
if (t.isNew) {
r = this.getClass();
if (!r.canCreate()) throw new Error("Insufficient privileges to create a record of class " + this.recordType);
this.setStatus(i.READY_NEW, {
cascade: !0
}), o === "uuid" && !this.get(o) && !e[o] && this.set(o, XT.generateUUID()), this.autoFetchId && this.fetchId();
}
this.idAttribute && !_.contains(this.requiredAttributes, o) && this.requiredAttributes.push(this.idAttribute), XM.Tuplespace.listenTo(this, "all", XM.Tuplespace.trigger);
},
isReadOnly: function(e) {
var t = this.getParent(!0), n = t ? !t.hasLockKey() : !this.hasLockKey(), r, i, s, o;
if (_.isString(e) && e.indexOf(".") !== -1) {
i = e.split("."), r = this;
for (o = 0; o < i.length; o++) {
s = i[o];
if (_.isObject(r) && r.readOnlyAttributes && _.contains(r.readOnlyAttributes, s)) r = !0, o = i.length; else if (r instanceof Backbone.Model && o + 1 < i.length) r = r.getValue(s); else {
if (_.isNull(r)) return r;
_.isUndefined(r) || (r = r.isReadOnly(s) || !r.hasLockKey());
}
}
return r;
}
return !_.isString(e) && !_.isObject(e) || this.readOnly ? r = this.readOnly : r = _.contains(this.readOnlyAttributes, e), r || n;
},
parse: function(e, t) {
var n = XT.Session, r = XT.session.getSchemas(), i;
return t && t.fixAttributes && (this.attributes = t.fixAttributes), i = function(e, t, s) {
var o = r[e].get(t), u, a, f, l;
if (!o) throw new Error(t + " not found in schema.");
for (f in s) if (s.hasOwnProperty(f) && s[f] !== null) if (_.isObject(s[f])) {
a = _.findWhere(o.relations, {
key: f
}), t = a ? a.relatedModel.suffix() : !1;
if (t) if (_.isArray(s[f])) for (l = 0; l < s[f].length; l++) s[f][l] = i(e, t, s[f][l]); else s[f] = i(e, t, s[f]);
} else u = _.findWhere(o.columns, {
name: f
}) || {}, u.category === n.DB_DATE && (s[f] = new Date(s[f]));
return s;
}, this._lastParse = i(this.recordType.prefix(), this.recordType.suffix(), e), this._lastParse;
},
relationAdded: function(e, t, n) {
var r = e.recordType.suffix(), i = e.id, s, o, u = function(e) {
o.splice(o.indexOf(i), 1, e.id), e.off(s, u);
};
this._idx[r] || (this._idx[r] = []), o = this._idx[r];
if (i) {
_.contains(o, i) || o.push(i);
return;
}
i = XT.generateUUID(), o.push(e.id), s = "change:" + e.idAttribute, e.on(s, u);
},
revert: function() {
var e = XM.Model;
this.clear({
silent: !0
}), this.setStatus(e.BUSY_FETCHING), this.set(this._lastParse, {
silent: !0
}), this.setStatus(e.READY_CLEAN, {
cascade: !0
});
},
revertStatus: function(e) {
var t = XM.Model, n = this._prevStatus, r = this, i;
this.setStatus(this._prevStatus || t.EMPTY), this._prevStatus = n, e && _.each(this.relations, function(t) {
i = r.attributes[t.key], i && i.models && t.type === Backbone.HasMany && _.each(i.models, function(t) {
t.revertStatus && t.revertStatus(e);
});
});
},
set: function(e, t, n) {
var r = XM.Model, i = _.isObject(e), s = this.getStatus(), o;
i && (n = t), n = n ? n : {};
switch (s) {
case r.READY_CLEAN:
this.canUpdate() || (o = XT.Error.clone("xt1010"));
break;
case r.READY_DIRTY:
case r.READY_NEW:
break;
case r.ERROR:
case r.DESTROYED_CLEAN:
case r.DESTROYED_DIRTY:
o = XT.Error.clone("xt1009", {
params: {
status: s
}
});
break;
default:
_.isBoolean(n.silent) || (n.silent = !0);
}
return o ? (this.trigger("invalid", this, o, n), !1) : (i && (t = n), Backbone.RelationalModel.prototype.set.call(this, e, t, n));
},
setStatus: function(e, n) {
var r = XM.Model, i, s = this, o, u;
n = n || {};
if (this.isLocked() || this.status === e) return;
return e === r.READY_CLEAN && !this.readOnly && (this._idx = {}, this._cache = this.toJSON()), this.acquire(), this._prevStatus = this.status, this.status = e, o = this.getParent(), n && (n.cascade || n.propagate) && _.each(this.relations, function(t) {
i = s.attributes[t.key], i && i.models && t.type === Backbone.HasMany ? _.each(i.models, function(t) {
t.setStatus && t.setStatus(e, n);
}) : i && n.propagate && t.type === Backbone.HasOne && i.setStatus(e, n);
}), o && (this.isDirty() || e === r.DESTROYED_DIRTY) && (u = _.find(this.relations, function(e) {
return e.isAutoRelation;
}), u && (o.changed[u.reverseRelation.key] = !0, o.trigger("change", o, n))), this.release(), e === r.READY_CLEAN && t(this), (n || {}).ignoreStatusChange !== !0 && (this.trigger("statusChange", this, e, n), this.trigger("status:" + r._status[e], this, e, n)), this;
},
setValue: function(e, t, n) {
var r = XM.ModelMixin, i = _.isObject(e), s = this, o = {}, u = function(e, t, r) {
var i, o, u, a;
if (e.indexOf(".") !== -1) {
o = e.split("."), i = s;
for (a = 0; a < o.length; a++) u = o[a], a + 1 < o.length ? i = i.getValue(u) : i.setValue(u, t, n);
return !0;
}
return !1;
};
if (i) return i && (n = t), n = n ? n : {}, _.each(_.keys(e), function(t) {
u(t, e[t], n) || (o[t] = e[t]);
}), r.setValue.call(this, o, n);
if (!u(e, t, n)) return r.setValue.apply(this, arguments);
},
save: function(e, t, n) {
n = n ? _.clone(n) : {};
var r = {}, i = XM.ModelClassMixin, s, o;
if (this.getParent()) return XT.log("You must save on the root level model of this relation"), !1;
_.isObject(e) || _.isEmpty(e) ? (r = e, n = t ? _.clone(t) : {}) : _.isString(e) && (r[e] = t);
if (this.isDirty() || r) {
this._wasNew = this.isNew(), s = n.success, n.wait = !0, n.propagate = !0, n.success = function(e, t, n) {
var r = e.recordType.prefix(), o = XT.session.getSchemas()[r], u = e.recordType.suffix(), a = o.get(u), f, l = {};
a.lockable ? (f = [ r, u, e.id, e.etag ], l.success = function(r) {
e.lock = r, e.lockDidChange(e, r), e.setStatus(i.READY_CLEAN, n), s && s(e, t, n);
}, e.dispatch("XM.Model", "obtainLock", f, l), XT.session.config.debugging && XT.log("Save successful")) : (e.setStatus(i.READY_CLEAN, n), s && s(e, t, n));
};
if (_.isObject(e) || _.isEmpty(e)) t = n;
return n.collection ? n.collection.each(function(e) {
e.setStatus(i.BUSY_COMMITTING, n);
}) : this.setStatus(i.BUSY_COMMITTING, n), o = n.prototypeSave ? n.prototypeSave.call(this, e, t, n) : Backbone.Model.prototype.save.call(this, e, t, n), delete this._wasNew, o || this.revertStatus(!0), o;
}
return XT.log("No changes to save"), !1;
},
validate: function(e, t) {
e = e || {}, t = t || {};
var n = this, r, i, s = XT.Session, o, u, a, f, l = {
recordType: this.recordType
}, c = this.recordType.prefix(), h = this.recordType.suffix(), p = XT.session.getSchemas()[c].get(h).columns, d = t.collection, v, m, g = function(e, t, r, i) {
i = i || {};
var s;
return s = _.find(n.relations, function(t) {
return t.key === e && t.type === r && (!i.nestedOnly || t.isNested);
}), s ? _.isObject(t) : !1;
}, y = function(e) {
return _.find(p, function(t) {
return t.name === e;
});
};
if (d) {
for (r = 0; r < d.length; r++) {
m = d.at(r), i = m.validate(m.attributes);
if (i) return i;
}
return;
}
for (o in e) if (e.hasOwnProperty(o) && !_.isNull(e[o]) && !_.isUndefined(e[o])) {
l.attr = ("_" + o).loc() || "_" + o, u = e[o], f = y(o), a = f ? f.category : !1;
switch (a) {
case s.DB_BYTEA:
if (!_.isObject(u) && !_.isString(u)) return l.type = "_binary".loc(), XT.Error.clone("xt1003", {
params: l
});
break;
case s.DB_UNKNOWN:
case s.DB_STRING:
if (!_.isString(u) && !_.isNumber(u) && !g(o, u, Backbone.HasOne)) return l.type = "_string".loc(), XT.Error.clone("xt1003", {
params: l
});
break;
case s.DB_NUMBER:
if (!_.isNumber(u) && !g(o, u, Backbone.HasOne)) return l.type = "_number".loc(), XT.Error.clone("xt1003", {
params: l
});
break;
case s.DB_DATE:
if (!_.isDate(u)) return l.type = "_date".loc(), XT.Error.clone("xt1003", {
params: l
});
break;
case s.DB_BOOLEAN:
if (!_.isBoolean(u)) return l.type = "_boolean".loc(), XT.Error.clone("xt1003", {
params: l
});
break;
case s.DB_ARRAY:
v = g(o, u, Backbone.HasMany);
if (!_.isArray(u) && !v) return l.type = "_array".loc(), XT.Error.clone("xt1003", {
params: l
});
v = g(o, u, Backbone.HasMany, {
nestedOnly: !0
});
if (v && u.models) for (r = 0; r < u.models.length; r++) {
m = u.models[r];
if (!(m._prevStatus & XM.Model.DESTROYED)) {
i = m.validate(m.attributes, t);
if (i) return i;
}
}
break;
case s.DB_COMPOUND:
if (!_.isObject(u) && !_.isNumber(u)) return l.type = "_object".loc(), XT.Error.clone("xt1003", {
params: l
});
break;
default:
return XT.Error.clone("xt1002", {
params: l
});
}
}
for (r = 0; r < this.requiredAttributes.length; r += 1) {
u = e[this.requiredAttributes[r]];
if (u === undefined || u === null || u === "") return l.attr = ("_" + this.requiredAttributes[r]).loc() || "_" + this.requiredAttributes[r], XT.Error.clone("xt1004", {
params: l
});
}
return;
}
}), _.extend(XM.Model.prototype, {
_attributeChangeFired: !1,
trigger: function(e) {
if (e.length > 5 && e.indexOf("change") === 0) {
var t = this, n = arguments;
Backbone.Relational.eventQueue.add(function() {
if (!t._isInitialized) return;
var r = !0;
if (e === "change") r = t.hasChanged() || t._attributeChangeFired, t._attributeChangeFired = !1; else {
var i = e.slice(7), s = t.getRelation(i);
s ? (r = n[4] === !0, r ? t.changed[i] = n[2] : s.changed || delete t.changed[i]) : r && (t._attributeChangeFired = !0);
}
r && Backbone.Model.prototype.trigger.apply(t, n);
});
} else Backbone.Model.prototype.trigger.apply(this, arguments);
return this;
}
}), _.extend(XM.Model, XM.ModelClassMixin), _.extend(XM.Model, {
findOrCreate: function(e, t) {
t = t ? t : {};
var n = _.isObject(e) && t.parse && this.prototype.parse ? this.prototype.parse(e) : e, r = Backbone.Relational.store.find(this, n);
return _.isObject(e) && (r && t.merge !== !1 ? (r.setStatus(XM.Model.BUSY_FETCHING), r.set(e, t)) : !r && t.create !== !1 && (r = this.build(e, t))), r;
},
build: function(e, t) {
return t = t ? _.clone(t) : {}, t.isFetching = t.isFetching !== !1 ? !0 : !1, t.validate = !1, Backbone.RelationalModel.build.call(this, e, t);
}
});
var e = Backbone.RelationalModel.constructor;
Backbone.RelationalModel.constructor = function(t, n) {
e.apply(this, arguments), n && n.isFetching && (this.status = XM.Model.BUSY_FETCHING);
};
var t = function(e) {
_.each(e.relations, function(n) {
var r;
n.type === Backbone.HasMany && (r = e.get(n.key), r && r.length && _.each(r.models, function(n) {
e.relationAdded(n), t(n);
}));
});
};
})();

// view.js

(function() {
"use strict";
XM.View = Backbone.View.extend(), XM.View.setPresenter = function(e, t) {
if (!e.view) return;
return new (XM[e.view.suffix()])({
presenter: e,
type: t
});
}, XM.EnyoView = XM.View.extend({
item: {
template: {},
decorations: {}
},
list: {
actions: [],
query: {}
},
workspace: {
template: {}
},
events: {},
$: undefined,
$el: undefined,
el: undefined,
initialize: function(e) {
this.presenter = e.presenter, this.type = e.type, this.presenter.viewInstance = this, this.model = this.presenter.value, this._mixin();
},
render: function() {
return this.presenter.render(), this;
},
remove: function() {
return this.presenter.destroy(), this;
},
delegateEvents: function() {
if (!this.model) return;
var e = this;
_.each(this.events, function(t, n) {
e.listenTo(e.model, n, function(n, r, i) {
if (!e.presenter.value) return;
e.presenter.bubble(t, {
model: n,
params: r,
options: i
});
});
});
},
setElement: function(e, t) {
this.presenter = e;
},
_ensureElement: function() {
return !!this.presenter;
},
undelegateEvents: function() {
_(this.events).each(function(e, t) {
this.stopListening(this[this.backing], t);
});
},
_mixin: function() {
var e = this, t = e.presenter, n = t.valueChanged;
_.each(e[e.type], function(e, n) {
_.isObject(t[n]) && _.isObject(e) ? _.extend(t[n], e) : _.isArray(t[n]) && _.isArray(e) ? _.union(t[n], e) : n === "model" ? t[n] = e : t.setProperty(n, e);
}), t.valueChanged = function() {
e.model = t.value, e.delegateEvents(), _.isFunction(n) && n.call(t);
};
}
});
})();

// simple_model.js

(function() {
"use strict";
XM.SimpleModel = Backbone.Model.extend(XM.ModelMixin), _.extend(XM.SimpleModel, XM.ModelClassMixin);
})();

// collection.js

(function() {
"use strict";
XM.Collection = Backbone.Collection.extend({
dispatch: !1,
fetchCount: 0,
add: function(e, t) {
t = t = _.extend({
merge: !0
}, t);
var n = Backbone.Collection.prototype.add.call(this, e, t), r, i = XM.Model;
return _.each(n.models, function(e) {
e.setStatus(t.status || i.READY_CLEAN, {
cascade: !0,
ignoreStatusChange: !0
});
}), n;
},
autoSync: function(e, t) {
var n;
t === XM.Model.BUSY_COMMITTING && (this._busyCommittingIds = this._busyCommittingIds || [], this._busyCommittingIds.push(e.id));
if (t === XM.Model.READY_CLEAN && _.contains(this._busyCommittingIds, e.id) || t === XM.Model.DESTROYED_DIRTY) this._busyCommittingIds = _.without(this._busyCommittingIds, e.id), n = _.find(this.models, function(t) {
return t.id === e.id;
}), n && this.remove(n), t !== XM.Model.DESTROYED_DIRTY && !this.get(e.id) && this.add(e);
},
getObjectByName: function(e) {
return Backbone.Relational.store.getObjectByName(e);
},
getStatus: function() {
return this.status;
},
fetch: function(e) {
e = e ? _.clone(e) : this.orderAttribute ? {
query: this.orderAttribute
} : {};
var t = this.fetchCount + 1, n = e.success, r = this;
return this.fetchCount = t, e.parse === void 0 && (e.parse = !0), e.success = function(e, i, s) {
var o = i;
if (t < r.fetchCount) return;
r.dispatch && (o = e, s = i, e = r);
var u = s.update ? "update" : "reset";
e[u](o, s), r.setStatus(XM.ModelClassMixin.READY_CLEAN), n && n(e, o, s);
}, this.setStatus(XM.ModelClassMixin.BUSY_FETCHING), this.sync("read", this, e);
},
initialize: function(e, t) {
var n = this.getStatus();
_.isNull(n) && this.setStatus(XM.ModelClassMixin.EMPTY);
},
setStatus: function(e, t) {
if (this.status === e) return;
return this._prevStatus = this.status, this.status = e, this.trigger("statusChange", this, e, t), this.trigger("status:" + XM.Model._status[e], this, e, t), this;
},
sync: function(e, t, n) {
var r = t.model.prototype, i = n.query || {}, s = {
nameSpace: r.recordType.replace(/\.\w+/i, ""),
type: r.recordType.suffix()
}, o = i.parameters;
return o && o.length && XM.Collection.formatParameters(r.recordType, o), e === "read" && n.success ? (this.dispatch ? (e = "post", s.dispatch = {
functionName: "fetch",
parameters: i
}) : (e = "get", s.query = i), XT.dataSource.request(this, e, s, n)) : !1;
},
orderAttribute: null
}), XM.Collection.formatParameters = function(e, t) {
_.each(t, function(t) {
var n = e ? XT.getObjectByName(e) : null, r = n ? n.prototype.relations : [], i = _.find(r, function(e) {
return e.key === t.attribute;
}), s;
t.value instanceof Date ? t.value = t.value.toJSON() : _.isObject(t.value) && !_.isArray(t.value) && (t.value = t.value.id), i && i.type === Backbone.HasOne && i.isNested && (n = XT.getObjectByName(i.relatedModel), s = n.prototype.idAttribute, t.attribute = t.attribute + "." + s);
});
};
})();

// static.js

(function() {
"use strict";
XM.StaticCollection = Backbone.Collection.extend({}, {
_disabled: [ "sync", "fetch", "trigger", "shift", "pop", "set", "slice" ],
_noop: function(e) {
return function() {
console.warn("function [" + e + "] disabled on XM.StaticCollection");
};
}
}), XM.StaticCollection = XM.StaticCollection.extend(_.object(XM.StaticCollection._disabled, _.map(_.range(XM.StaticCollection._disabled.length), XM.StaticCollection._noop))), XM.StaticModel = Backbone.Model.extend({
idAttribute: "key",
getStatus: function() {
return XM.Model.READY_CLEAN;
},
getStatusString: function() {
return "READY_CLEAN";
},
getValue: function(e) {
return this.get(e);
},
parse: function(e, t) {
return {
key: e.key,
value: e.value,
label: ("_" + e.value.toLowerCase().camelize()).loc()
};
}
}), XM.EnumMapCollection = XM.StaticCollection.extend({
model: XM.StaticModel,
constructor: function(e, t) {
Backbone.Collection.call(this, e, _.extend({
parse: !0
}, t));
},
parse: function(e) {
return _.map(e, function(e, t) {
return {
value: e,
key: t
};
});
}
});
})();

// document.js

(function() {
"use strict";
XM.DocumentAssignmentsMixin = {
attributeDelegates: null,
documents: null,
bindDocuments: function() {
var e = this, t = e.getRelations(), n;
e.attributeDelegates = e.attributeDelegates || {}, e.documents = new Backbone.Collection, e.documents.parent = this, _.each(t, function(t) {
t.relatedModel.prototype.isDocumentAssignment && (e.attributeDelegates[t.key] = "documents", n = e.get(t.key), n.on("relational:add", e.documentAdded, e), n.on("relational:remove", e.documentRemoved, e));
});
},
documentAdded: function(e) {
this.documents.add(e);
},
documentRemoved: function(e) {
this.documents.remove(e);
}
}, XM.Document = XM.Model.extend({
documentKey: "number",
enforceUpperKey: !0,
keyIsString: !0,
numberPolicy: null,
numberPolicySetting: null,
checkConflicts: !0,
conversionMap: {
name: "name"
},
bindEvents: function() {
XM.Model.prototype.bindEvents.apply(this, arguments), this.on("change:" + this.documentKey, this.documentKeyDidChange), this.on("statusChange", this.statusDidChange), this.bindDocuments();
},
destroy: function() {
var e = XM.Model, t = this.getStatus();
t === e.READY_NEW && this._number && this.releaseNumber(), XM.Model.prototype.destroy.apply(this, arguments);
},
documentKeyDidChange: function(e, t, n) {
var r = XM.Model, i = this, s = this.getStatus(), o = t;
n = n || {}, this.keyIsString && t && t.toUpperCase && (o = o.toUpperCase());
if (this.enforceUpperKey && t !== o) {
this.set(this.documentKey, o);
return;
}
s === r.READY_NEW && this._number && this._number !== t && this.releaseNumber(), t && this.isDirty() && !this._number && this.checkConflicts && (n.success = function(e) {
var r, s = {};
e && (s.attr = ("_" + i.documentKey).loc(), s.value = t, s.response = e, r = XT.Error.clone("xt1008", {
params: s
}), i.trigger("invalid", i, r, n));
}, this.findExisting(this.documentKey, t, n));
},
initialize: function(e, t) {
XM.Model.prototype.initialize.call(this, e, t);
var n = XM.Document, r;
e = e || {}, this.numberPolicy || (this.numberPolicySetting && (r = XT.session.getSettings().get(this.numberPolicySetting)), this.numberPolicy = r || n.MANUAL_NUMBER), t && t.isNew && _.isEmpty(e[this.documentKey]) && (this.numberPolicy === n.AUTO_NUMBER || this.numberPolicy === n.AUTO_OVERRIDE_NUMBER) && this.fetchNumber(), _.contains(this.requiredAttributes, this.documentKey) || this.requiredAttributes.push(this.documentKey);
},
fetchNumber: function() {
var e = this, t = {}, n = XM.Document;
return t.success = function(t) {
_.isEmpty(e.get(e.documentKey)) && (e._number = e.keyIsString && t.toString() ? t.toString() : !e.keyIsString && !_.isNaN(t) ? t - 0 : t, e.set(e.documentKey, e._number)), e.numberPolicy === n.AUTO_NUMBER && e.setReadOnly(e.documentKey);
}, this.dispatch("XM.Model", "fetchNumber", this.recordType, t), this;
},
releaseNumber: function() {
return this.dispatch("XM.Model", "releaseNumber", [ this.recordType, this._number ]), this._number = null, this;
},
save: function(e, t, n) {
var r = this, i = XM.Model, s = this.get(this.documentKey), o = this.original(this.documentKey), u = this.getStatus(), a = {};
this.checkConflicts && u === i.READY_NEW && s && !this._number || u === i.READY_DIRTY && s !== o ? (a.success = function(i) {
var o, u = {};
i === 0 ? XM.Model.prototype.save.call(r, e, t, n) : (u.attr = ("_" + r.documentKey).loc(), u.value = s, u.response = i, o = XT.Error.clone("xt1008", {
params: u
}), r.trigger("error", r, o, n));
}, this.findExisting(this.documentKey, s, a)) : XM.Model.prototype.save.call(this, e, t, n);
},
statusDidChange: function() {
var e = XM.Model, t = XM.Document;
this.numberPolicy === t.AUTO_NUMBER && this.getStatus() === e.READY_CLEAN && this.setReadOnly(this.documentKey);
}
}), XM.Document = XM.Document.extend(XM.DocumentAssignmentsMixin), _.extend(XM.Document, {
MANUAL_NUMBER: "M",
AUTO_NUMBER: "A",
AUTO_OVERRIDE_NUMBER: "O"
});
})();

// info.js

(function() {
"use strict";
XM.Info = XM.Model.extend({
editableModel: "",
descriptionKey: "description",
numberKey: "number",
readOnly: !0,
couldCreate: function() {
return this.getClass().couldCreate();
},
couldRead: function() {
return this.getClass().couldRead(this);
},
couldUpdate: function() {
return this.getClass().couldUpdate(this);
},
couldDelete: function() {
return this.getClass().couldDelete(this);
},
couldDestroy: function(e) {
return this.getClass().couldDestroy(this, e), this;
}
}, {
couldCreate: function() {
var e = Backbone.Relational.store.getObjectByName(this.prototype.editableModel);
return e ? e.canCreate() : !1;
},
couldRead: function(e) {
var t = Backbone.Relational.store.getObjectByName(this.prototype.editableModel);
return t ? t.canRead(e || this) : !1;
},
couldUpdate: function(e) {
var t = Backbone.Relational.store.getObjectByName(this.prototype.editableModel);
return t ? t.canUpdate(e || this) : !1;
},
couldDelete: function(e) {
var t = Backbone.Relational.store.getObjectByName(this.prototype.editableModel);
return t ? t.canDelete(e || this) : !1;
},
couldDestroy: function(e, t) {
var n = Backbone.Relational.store.getObjectByName(this.prototype.editableModel);
return n ? n.canDestroy(e || this, t) : !1;
}
});
})();

// comment.js

(function() {
"use strict";
XM.CommentType = XM.Model.extend({
recordType: "XM.CommentType",
defaults: {
commentsEditable: !1
}
}), XM.CommentTypeSource = XM.Model.extend({
recordType: "XM.CommentTypeSource"
}), XM.Source = XM.Model.extend({
recordType: "XM.Source"
}), XM.Comment = XM.Model.extend({
sourceName: "",
readOnlyAttributes: [ "created", "createdBy" ],
defaults: function() {
var e = {};
return e.created = new Date, e.createdBy = XM.currentUser.get("username"), e.text = "", e;
},
bindEvents: function() {
XM.Model.prototype.bindEvents.apply(this, arguments), this.on("statusChange", this.statusChanged), this.statusChanged();
},
isReadOnly: function() {
var e = this.get("commentType"), t = this.getStatus() === XM.Model.READY_NEW, n = t || e && e.get("commentsEditable");
return !n || XM.Model.prototype.isReadOnly.apply(this, arguments);
},
statusChanged: function() {
var e = this.getStatus(), t = XM.Model;
e === t.READY_CLEAN && this.setReadOnly("commentType");
}
}), XM.CommentTypeCollection = XM.Collection.extend({
model: XM.CommentType
}), XM.SourceCollection = XM.Collection.extend({
model: XM.Source
});
})();

// characteristic.js

(function() {
"use strict";
XM.Characteristic = XM.Document.extend({
recordType: "XM.Characteristic",
documentKey: "name",
enforceUpperKey: !1,
defaults: function() {
return {
characteristicType: 0,
isAddresses: !1,
isContacts: !1,
isCustomers: !1,
isItems: !1,
isEmployees: !1,
isInvoices: !1,
order: 0,
isSearchable: !0
};
},
contextAttributes: [ "isAddresses", "isContacts", "isCustomers", "isAccounts", "isItems", "isIncidents", "isInvoices", "isOpportunities", "isSalesOrders" ],
bindEvents: function() {
XM.Document.prototype.bindEvents.apply(this, arguments), this.on("change:characteristicType", this.characteristicTypeDidChange), this.characteristicTypeDidChange();
},
characteristicTypeDidChange: function() {
var e = this.get("characteristicType");
switch (e) {
case XM.Characteristic.TEXT:
this.setReadOnly("options", !0), this.setReadOnly("mask", !1), this.setReadOnly("validator", !1);
break;
case XM.Characteristic.LIST:
this.setReadOnly("options", !1), this.setReadOnly("mask", !0), this.setReadOnly("validator", !0);
break;
default:
this.setReadOnly("options", !0), this.setReadOnly("mask", !0), this.setReadOnly("validator", !0);
}
},
statusDidChange: function() {
var e = this.getStatus(), t = XM.Model;
e !== t.READY_NEW && this.setReadOnly("characteristicType", !0), XM.Document.prototype.statusDidChange.apply(this, arguments);
},
validate: function() {
var e = this.get("options").models, t = [], n, r = !1;
for (n = 0; n < this.contextAttributes.length; n++) {
var i = this.contextAttributes[n];
if (this.get(i)) {
r = !0;
break;
}
}
if (!r) return XT.Error.clone("xt2002");
for (n = 0; n < e.length; n += 1) t.push(e[n].get("value"));
return _.isEqual(t, _.unique(t)) ? XM.Document.prototype.validate.apply(this, arguments) : XT.Error.clone("xt2003");
}
}), _.extend(XM.Characteristic, {
TEXT: 0,
LIST: 1,
DATE: 2
}), XM.CharacteristicOption = XM.Model.extend({
recordType: "XM.CharacteristicOption",
defaults: {
order: 0
}
}), XM.CharacteristicAssignment = XM.Model.extend({
bindEvents: function() {
XM.Model.prototype.bindEvents.apply(this, arguments), this.on("change:characteristic", this.characteristicDidChange);
},
canView: function() {
var e = this, t = XM.Document.prototype.canView.apply(this, arguments), n = _.filter(XM.characteristics.models, function(t) {
return t.get(e.which);
}), r = n.length > 0;
return t && r;
},
characteristicDidChange: function(e, t, n) {
this.set("value", "");
}
}), XM.CharacteristicCollection = XM.Collection.extend({
model: XM.Characteristic
});
})();

// alarm.js

(function() {
"use strict";
XM.Alarm = XM.Document.extend({
numberPolicy: XM.Document.AUTO_NUMBER,
bindEvents: function() {
XM.Document.prototype.bindEvents.apply(this, arguments), this.on("change:offset change:qualifier change:time", this.alarmDidChange);
},
alarmDidChange: function(e, t, n) {
var r, i, s, o;
r = this.get("offset"), i = this.get("qualifier"), s = this.get("time"), o = this.get("trigger");
if (r) switch (i) {
case "MB":
case "MA":
i.indexOf("B") !== -1 ? o.setMinutes(s.getMinutes() - r) : o.setMinutes(s.getMinutes() + r);
break;
case "HB":
case "HA":
i.indexOf("B") !== -1 ? o.setHours(s.getHours() - r) : o.setHours(s.getHours() + r);
break;
default:
i.indexOf("B") !== -1 ? o.setDate(s.getDate() - r) : o.setDate(s.getDate() + r);
} else o.setMinutes(s.getMinutes());
}
});
})();

// settings.js

(function() {
"use strict";
XM.Settings = XM.Model.extend({
recordType: "XM.Settings",
autoFetchId: !1,
fetch: function(e) {
var t = _.extend({}, e), n = t.success, r = function(e, t, r) {
e.set(t, r), e.setStatus(XM.Model.READY_CLEAN, r), _.isFunction(n) && n(e, t, r);
}, i = this._fetchHelper(_.extend(t, {
success: r
}));
return i && this.sync("read", this, i);
},
prototypeSave: function(e, t, n) {
var r = this, i = this.attributes, s, o, u, a;
return e === null || typeof e == "object" ? (s = e, n = t) : (s = {})[e] = t, s && (!n || !n.wait) && !this.set(s, n) ? !1 : (n = _.extend({
validate: !0
}, n), this._validate(s, n) ? (s && n.wait && (this.attributes = _.extend({}, i, s)), n.parse === void 0 && (n.parse = !0), o = n.success, n.success = function(e, t) {
var n = r;
n.attributes = i;
var u = n.parse(e, t);
t.wait && (u = _.extend(s || {}, u));
if (_.isObject(u) && !n.set(u, t)) return !1;
o && o(n, e, t);
}, u = this.isNew() ? "create" : n.patch ? "patch" : "update", u === "patch" && (n.attrs = s), a = this.sync(u, this, n), s && n.wait && (this.attributes = i), a) : !1);
},
save: function(e, t, n) {
n = n ? _.clone(n) : {};
var r = this, i;
_.isObject(e) || _.isEmpty(e) ? n = t ? _.clone(t) : {} : n = n ? _.clone(n) : {}, i = n.success, n.success = function(e) {
XT.session.settings.set(r.attributes), i && i(r, e, n);
}, n.prototypeSave = this.prototypeSave;
if (_.isObject(e) || _.isEmpty(e)) t = n;
return XM.Model.prototype.save.call(this, e, t, n);
},
setStatus: function(e, t) {
XM.Model.prototype.setStatus.apply(this, arguments), delete this.attributes.dataState;
},
sync: function(e, t, n) {
n = n ? _.clone(n) : {};
var r = this, i = this.recordType, s, o = n.error;
return n.error = function(e) {
var i = XM.Model;
r.setStatus(i.ERROR), o && o(t, e, n);
}, e === "read" && i && n.success ? s = this.dispatch(this.dispatchRecordType || this.recordType, this.dispatchFetchFunction || "settings", this.dispatchRecordType || this.recordType, n) : e === "update" && (s = this.dispatch(this.dispatchRecordType || this.recordType, this.dispatchCommitFunction || "commitSettings", [ this.generatePatches() ], n)), s || !1;
},
validate: function() {}
}), _.extend(XM.Settings, {
canCreate: function() {
return !1;
},
canDelete: function() {
return !1;
},
canRead: function() {
return XM.Settings.canUpdate.call(this);
},
canUpdate: function() {
return XT.session.privileges.get(this.prototype.privileges);
}
});
})();

// workflow.js

(function() {
"use strict";
XM.Workflow = XM.Model.extend({
parentStatusAttribute: "status",
defaults: function() {
return {
owner: XM.currentUser,
assignedTo: XM.currentUser,
status: XM.Workflow.PENDING,
priority: XT.session.settings.get("DefaultPriority"),
sequence: 0
};
},
bindEvents: function() {
XM.Model.prototype.bindEvents.apply(this, arguments), this.on("change:completeDate", this.completeDateDidChange), this.on("change:status", this.workflowStatusDidChange);
},
completeDateDidChange: function(e, t, n) {
var r = this.get("completeDate"), i = XM.Workflow;
r && this.set("status", i.COMPLETED);
},
getWorkflowStatusString: function() {
var e = XM.Workflow, t = this.get("status");
switch (t) {
case e.PENDING:
return "_pending".loc();
case e.IN_PROCESS:
return "_inProcess".loc();
case e.COMPLETED:
return "_completed".loc();
case e.DEFERRED:
return "_deferred".loc();
}
},
isActive: function() {
var e = this.get("status"), t = XM.Workflow;
return e === t.PENDING || e === t.IN_PROCESS;
},
workflowStatusDidChange: function(e, t, n) {
var r = this.get("status"), i = XM.Workflow, s, o, u, a, f;
r === i.IN_PROCESS ? this.get("startDate") || this.set("startDate", XT.date.today()) : r === i.COMPLETED ? (this.get("completeDate") || this.set("completeDate", XT.date.today()), s = this.get("parent"), u = s.get("workflow"), o = this.get("completedParentStatus"), a = u.model.prototype.parentStatusAttribute, o && s.set(a, o), f = this.get("completedSuccessors") ? this.get("completedSuccessors").split(",") : [], _.each(f, function(e) {
var t = u.get(e), n = t && t.get("status");
n === i.PENDING && t.set("status", i.IN_PROCESS);
})) : r === i.DEFERRED && (s = this.get("parent"), u = s.get("workflow"), o = this.get("deferredParentStatus"), a = u.model.prototype.parentStatusAttribute, o && s.set(a, o), f = this.get("deferredSuccessors") ? this.get("deferredSuccessors").split(",") : [], _.each(f, function(e) {
var t = u.get(e), n = t.get("status");
n === i.PENDING && t.set("status", i.IN_PROCESS);
}));
}
}), XM.Workflow = XM.Workflow.extend(XM.WorkflowStatus), _.extend(XM.Workflow, {
PENDING: "P",
DEFERRED: "D",
IN_PROCESS: "I",
COMPLETED: "C"
}), XM.WorkflowSource = XM.Model.extend({
defaults: function() {
return {
status: XM.Workflow.PENDING,
startSet: !1,
startOffset: 0,
dueSet: !1,
dueOffset: 0,
priority: XT.session.settings.get("DefaultPriority"),
sequence: 0
};
},
readOnlyAttributes: [ "dueOffset", "startOffset" ],
bindEvents: function() {
XM.Model.prototype.bindEvents.apply(this, arguments), this.on("change:dueSet", this.dueSetDidChange), this.on("change:startSet", this.startSetDidChange), this.on("statusChange", this.statusDidChange);
},
dueSetDidChange: function() {
this.setReadOnly("dueOffset", !this.get("dueSet"));
},
statusDidChange: function() {
this.getStatus() === XM.Model.READY_CLEAN && (this.dueSetDidChange(), this.startSetDidChange());
},
startSetDidChange: function() {
this.setReadOnly("startOffset", !this.get("startSet"));
}
}), XM.WorkflowMixin = {
inheritWorkflowSource: function(e, t, n) {
var r = e && t ? e.get("characteristics") : !1, i = e && n ? e.get("workflow") : !1, s = this.get("characteristics"), o = this.get("workflow"), u = this, a = XT.getObjectByName(t), f = XT.getObjectByName(n), l = function() {
s.reset(), _.each(r.models, function(e) {
var t = new a(null, {
isNew: !0
});
t.set("characteristic", e.get("characteristic")), t.set("value", e.get("value")), s.add(t);
});
}, c = function() {
var e = {};
o.reset(), _.each(i.models, function(t) {
var n = new f(null, {
isNew: !0
}), r = XT.generateUUID(), i = t.get("dueOffset"), s = t.get("startOffset"), u, a;
e[t.id] = r, t.get("dueSet") && (u = XT.date.today(), u.setDate(u.getDate() + t.get("dueOffset"))), t.get("startSet") && (a = XT.date.today(), a.setDate(a.getDate() + t.get("startOffset"))), n.set({
uuid: r,
name: t.get("name"),
description: t.get("description"),
status: t.get("status"),
workflowType: t.get("workflowType"),
priority: t.get("priority"),
startDate: a,
dueDate: u,
owner: t.get("owner") || n.get("owner"),
assignedTo: t.get("assignedTo") || n.get("assignedTo"),
sequence: t.get("sequence"),
notes: t.get("notes"),
completedParentStatus: t.get("completedParentStatus"),
deferredParentStatus: t.get("deferredParentStatus"),
completedSuccessors: t.get("completedSuccessors"),
deferredSuccessors: t.get("deferredSuccessors")
}), o.add(n);
}), _.each(_.keys(e), function(t) {
_.each(o.models, function(n) {
var r = n.get("completedSuccessors");
_.isString(r) && n.set("completedSuccessors", r.replace(t, e[t])), r = n.get("deferredSuccessors"), _.isString(r) && n.set("deferredSuccessors", r.replace(t, e[t]));
});
});
}, h = function() {
i && i.length && (o.length ? u.notify("_copyWorkflow?".loc(), {
type: XM.Model.QUESTION,
callback: function(e) {
e.answer && c();
}
}) : c());
};
if (r && r.length) {
if (!!s.length) {
this.notify("_copyCharacteristics?".loc(), {
type: XM.Model.QUESTION,
callback: function(e) {
e.answer && l(), h();
}
});
return;
}
l();
}
h();
}
};
})();

// FittableLayout.js

enyo.kind({
name: "enyo.FittableLayout",
kind: "Layout",
calcFitIndex: function() {
for (var e = 0, t = this.container.children, n; n = t[e]; e++) if (n.fit && n.showing) return e;
},
getFitControl: function() {
var e = this.container.children, t = e[this.fitIndex];
return t && t.fit && t.showing || (this.fitIndex = this.calcFitIndex(), t = e[this.fitIndex]), t;
},
getLastControl: function() {
var e = this.container.children, t = e.length - 1, n = e[t];
while ((n = e[t]) && !n.showing) t--;
return n;
},
_reflow: function(e, t, n, r) {
this.container.addRemoveClass("enyo-stretch", !this.container.noStretch);
var i = this.getFitControl();
if (!i) return;
var s = 0, o = 0, u = 0, a, f = this.container.hasNode();
f && (a = enyo.dom.calcPaddingExtents(f), s = f[t] - (a[n] + a[r]));
var l = i.getBounds();
o = l[n] - (a && a[n] || 0);
var c = this.getLastControl();
if (c) {
var h = enyo.dom.getComputedBoxValue(c.hasNode(), "margin", r) || 0;
if (c != i) {
var p = c.getBounds(), d = l[n] + l[e], v = p[n] + p[e] + h;
u = v - d;
} else u = h;
}
var m = s - (o + u);
i.applyStyle(e, m + "px");
},
reflow: function() {
this.orient == "h" ? this._reflow("width", "clientWidth", "left", "right") : this._reflow("height", "clientHeight", "top", "bottom");
}
}), enyo.kind({
name: "enyo.FittableColumnsLayout",
kind: "FittableLayout",
orient: "h",
layoutClass: "enyo-fittable-columns-layout"
}), enyo.kind({
name: "enyo.FittableRowsLayout",
kind: "FittableLayout",
layoutClass: "enyo-fittable-rows-layout",
orient: "v"
});

// FittableRows.js

enyo.kind({
name: "enyo.FittableRows",
layoutKind: "FittableRowsLayout",
noStretch: !1
});

// FittableColumns.js

enyo.kind({
name: "enyo.FittableColumns",
layoutKind: "FittableColumnsLayout",
noStretch: !1
});

// FlyweightRepeater.js

enyo.kind({
name: "enyo.FlyweightRepeater",
published: {
count: 0,
noSelect: !1,
multiSelect: !1,
toggleSelected: !1,
clientClasses: "",
clientStyle: "",
rowOffset: 0
},
events: {
onSetupItem: "",
onRenderRow: ""
},
bottomUp: !1,
components: [ {
kind: "Selection",
onSelect: "selectDeselect",
onDeselect: "selectDeselect"
}, {
name: "client"
} ],
create: function() {
this.inherited(arguments), this.noSelectChanged(), this.multiSelectChanged(), this.clientClassesChanged(), this.clientStyleChanged();
},
noSelectChanged: function() {
this.noSelect && this.$.selection.clear();
},
multiSelectChanged: function() {
this.$.selection.setMulti(this.multiSelect);
},
clientClassesChanged: function() {
this.$.client.setClasses(this.clientClasses);
},
clientStyleChanged: function() {
this.$.client.setStyle(this.clientStyle);
},
setupItem: function(e) {
this.doSetupItem({
index: e,
selected: this.isSelected(e)
});
},
generateChildHtml: function() {
var e = "";
this.index = null;
for (var t = 0, n = 0; t < this.count; t++) n = this.rowOffset + (this.bottomUp ? this.count - t - 1 : t), this.setupItem(n), this.$.client.setAttribute("data-enyo-index", n), e += this.inherited(arguments), this.$.client.teardownRender();
return e;
},
previewDomEvent: function(e) {
var t = this.index = this.rowForEvent(e);
e.rowIndex = e.index = t, e.flyweight = this;
},
decorateEvent: function(e, t, n) {
var r = t && t.index != null ? t.index : this.index;
t && r != null && (t.index = r, t.flyweight = this), this.inherited(arguments);
},
tap: function(e, t) {
if (this.noSelect || t.index === -1) return;
this.toggleSelected ? this.$.selection.toggle(t.index) : this.$.selection.select(t.index);
},
selectDeselect: function(e, t) {
this.renderRow(t.key);
},
getSelection: function() {
return this.$.selection;
},
isSelected: function(e) {
return this.getSelection().isSelected(e);
},
renderRow: function(e) {
if (e < this.rowOffset || e >= this.count + this.rowOffset) return;
this.setupItem(e);
var t = this.fetchRowNode(e);
t && (enyo.dom.setInnerHtml(t, this.$.client.generateChildHtml()), this.$.client.teardownChildren(), this.doRenderRow({
rowIndex: e
}));
},
fetchRowNode: function(e) {
if (this.hasNode()) return this.node.querySelector('[data-enyo-index="' + e + '"]');
},
rowForEvent: function(e) {
if (!this.hasNode()) return -1;
var t = e.target;
while (t && t !== this.node) {
var n = t.getAttribute && t.getAttribute("data-enyo-index");
if (n !== null) return Number(n);
t = t.parentNode;
}
return -1;
},
prepareRow: function(e) {
if (e < 0 || e >= this.count) return;
this.setupItem(e);
var t = this.fetchRowNode(e);
enyo.FlyweightRepeater.claimNode(this.$.client, t);
},
lockRow: function() {
this.$.client.teardownChildren();
},
performOnRow: function(e, t, n) {
if (e < 0 || e >= this.count) return;
t && (this.prepareRow(e), enyo.call(n || null, t), this.lockRow());
},
statics: {
claimNode: function(e, t) {
var n;
t && (t.id !== e.id ? n = t.querySelector("#" + e.id) : n = t), e.generated = Boolean(n || !e.tag), e.node = n, e.node && e.rendered();
for (var r = 0, i = e.children, s; s = i[r]; r++) this.claimNode(s, t);
}
}
});

// List.js

enyo.kind({
name: "enyo.List",
kind: "Scroller",
classes: "enyo-list",
published: {
count: 0,
rowsPerPage: 50,
bottomUp: !1,
noSelect: !1,
multiSelect: !1,
toggleSelected: !1,
fixedHeight: !1,
reorderable: !1,
centerReorderContainer: !0,
reorderComponents: [],
pinnedReorderComponents: [],
swipeableComponents: [],
enableSwipe: !1,
persistSwipeableItem: !1
},
events: {
onSetupItem: "",
onSetupReorderComponents: "",
onSetupPinnedReorderComponents: "",
onReorder: "",
onSetupSwipeItem: "",
onSwipeDrag: "",
onSwipe: "",
onSwipeComplete: ""
},
handlers: {
onAnimateFinish: "animateFinish",
onRenderRow: "rowRendered",
ondragstart: "dragstart",
ondrag: "drag",
ondragfinish: "dragfinish",
onup: "up",
onholdpulse: "holdpulse"
},
rowHeight: 0,
listTools: [ {
name: "port",
classes: "enyo-list-port enyo-border-box",
components: [ {
name: "generator",
kind: "FlyweightRepeater",
canGenerate: !1,
components: [ {
tag: null,
name: "client"
} ]
}, {
name: "holdingarea",
allowHtml: !0,
classes: "enyo-list-holdingarea"
}, {
name: "page0",
allowHtml: !0,
classes: "enyo-list-page"
}, {
name: "page1",
allowHtml: !0,
classes: "enyo-list-page"
}, {
name: "placeholder"
}, {
name: "swipeableComponents",
style: "position:absolute; display:block; top:-1000px; left:0;"
} ]
} ],
reorderHoldTimeMS: 600,
draggingRowIndex: -1,
draggingRowNode: null,
placeholderRowIndex: -1,
dragToScrollThreshold: .1,
prevScrollTop: 0,
autoScrollTimeoutMS: 20,
autoScrollTimeout: null,
autoscrollPageY: 0,
pinnedReorderMode: !1,
initialPinPosition: -1,
itemMoved: !1,
currentPageNumber: -1,
completeReorderTimeout: null,
swipeIndex: null,
swipeDirection: null,
persistentItemVisible: !1,
persistentItemOrigin: null,
swipeComplete: !1,
completeSwipeTimeout: null,
completeSwipeDelayMS: 500,
normalSwipeSpeedMS: 200,
fastSwipeSpeedMS: 100,
percentageDraggedThreshold: .2,
importProps: function(e) {
e && e.reorderable && (this.touch = !0), this.inherited(arguments);
},
create: function() {
this.pageHeights = [], this.inherited(arguments), this.getStrategy().translateOptimized = !0, this.bottomUpChanged(), this.noSelectChanged(), this.multiSelectChanged(), this.toggleSelectedChanged(), this.$.generator.setRowOffset(0), this.$.generator.setCount(this.count);
},
initComponents: function() {
this.createReorderTools(), this.inherited(arguments), this.createSwipeableComponents();
},
createReorderTools: function() {
this.createComponent({
name: "reorderContainer",
classes: "enyo-list-reorder-container",
ondown: "sendToStrategy",
ondrag: "sendToStrategy",
ondragstart: "sendToStrategy",
ondragfinish: "sendToStrategy",
onflick: "sendToStrategy"
});
},
createStrategy: function() {
this.controlParentName = "strategy", this.inherited(arguments), this.createChrome(this.listTools), this.controlParentName = "client", this.discoverControlParent();
},
createSwipeableComponents: function() {
for (var e = 0; e < this.swipeableComponents.length; e++) this.$.swipeableComponents.createComponent(this.swipeableComponents[e], {
owner: this.owner
});
},
rendered: function() {
this.inherited(arguments), this.$.generator.node = this.$.port.hasNode(), this.$.generator.generated = !0, this.reset();
},
resizeHandler: function() {
this.inherited(arguments), this.refresh();
},
bottomUpChanged: function() {
this.$.generator.bottomUp = this.bottomUp, this.$.page0.applyStyle(this.pageBound, null), this.$.page1.applyStyle(this.pageBound, null), this.pageBound = this.bottomUp ? "bottom" : "top", this.hasNode() && this.reset();
},
noSelectChanged: function() {
this.$.generator.setNoSelect(this.noSelect);
},
multiSelectChanged: function() {
this.$.generator.setMultiSelect(this.multiSelect);
},
toggleSelectedChanged: function() {
this.$.generator.setToggleSelected(this.toggleSelected);
},
countChanged: function() {
this.hasNode() && this.updateMetrics();
},
sendToStrategy: function(e, t) {
this.$.strategy.dispatchEvent("on" + t.type, t, e);
},
updateMetrics: function() {
this.defaultPageHeight = this.rowsPerPage * (this.rowHeight || 100), this.pageCount = Math.ceil(this.count / this.rowsPerPage), this.portSize = 0;
for (var e = 0; e < this.pageCount; e++) this.portSize += this.getPageHeight(e);
this.adjustPortSize();
},
holdpulse: function(e, t) {
if (!this.getReorderable() || this.isReordering()) return;
if (t.holdTime >= this.reorderHoldTimeMS && this.shouldStartReordering(e, t)) return t.preventDefault(), this.startReordering(t), !1;
},
dragstart: function(e, t) {
if (this.isReordering()) return !0;
if (this.isSwipeable()) return this.swipeDragStart(e, t);
},
drag: function(e, t) {
if (this.shouldDoReorderDrag(t)) return t.preventDefault(), this.reorderDrag(t), !0;
if (this.isSwipeable()) return t.preventDefault(), this.swipeDrag(e, t), !0;
},
dragfinish: function(e, t) {
this.isReordering() ? this.finishReordering(e, t) : this.isSwipeable() && this.swipeDragFinish(e, t);
},
up: function(e, t) {
this.isReordering() && this.finishReordering(e, t);
},
generatePage: function(e, t) {
this.page = e;
var n = this.rowsPerPage * this.page;
this.$.generator.setRowOffset(n);
var r = Math.min(this.count - n, this.rowsPerPage);
this.$.generator.setCount(r);
var i = this.$.generator.generateChildHtml();
t.setContent(i), this.getReorderable() && this.draggingRowIndex > -1 && this.hideReorderingRow();
var s = t.getBounds().height;
!this.rowHeight && s > 0 && (this.rowHeight = Math.floor(s / r), this.updateMetrics());
if (!this.fixedHeight) {
var o = this.getPageHeight(e);
this.pageHeights[e] = s, this.portSize += s - o;
}
},
pageForRow: function(e) {
return Math.floor(e / this.rowsPerPage);
},
preserveDraggingRowNode: function(e) {
this.draggingRowNode && this.pageForRow(this.draggingRowIndex) === e && (this.$.holdingarea.hasNode().appendChild(this.draggingRowNode), this.draggingRowNode = null, this.removedInitialPage = !0);
},
update: function(e) {
var t = !1, n = this.positionToPageInfo(e), r = n.pos + this.scrollerHeight / 2, i = Math.floor(r / Math.max(n.height, this.scrollerHeight) + .5) + n.no, s = i % 2 === 0 ? i : i - 1;
this.p0 != s && this.isPageInRange(s) && (this.preserveDraggingRowNode(this.p0), this.generatePage(s, this.$.page0), this.positionPage(s, this.$.page0), this.p0 = s, t = !0, this.p0RowBounds = this.getPageRowHeights(this.$.page0)), s = i % 2 === 0 ? Math.max(1, i - 1) : i, this.p1 != s && this.isPageInRange(s) && (this.preserveDraggingRowNode(this.p1), this.generatePage(s, this.$.page1), this.positionPage(s, this.$.page1), this.p1 = s, t = !0, this.p1RowBounds = this.getPageRowHeights(this.$.page1)), t && (this.$.generator.setRowOffset(0), this.$.generator.setCount(this.count), this.fixedHeight || (this.adjustBottomPage(), this.adjustPortSize()));
},
getPageRowHeights: function(e) {
var t = {}, n = e.hasNode().querySelectorAll("div[data-enyo-index]");
for (var r = 0, i, s; r < n.length; r++) i = n[r].getAttribute("data-enyo-index"), i !== null && (s = enyo.dom.getBounds(n[r]), t[parseInt(i, 10)] = {
height: s.height,
width: s.width
});
return t;
},
updateRowBounds: function(e) {
this.p0RowBounds[e] ? this.updateRowBoundsAtIndex(e, this.p0RowBounds, this.$.page0) : this.p1RowBounds[e] && this.updateRowBoundsAtIndex(e, this.p1RowBounds, this.$.page1);
},
updateRowBoundsAtIndex: function(e, t, n) {
var r = n.hasNode().querySelector('div[data-enyo-index="' + e + '"]'), i = enyo.dom.getBounds(r);
t[e].height = i.height, t[e].width = i.width;
},
updateForPosition: function(e) {
this.update(this.calcPos(e));
},
calcPos: function(e) {
return this.bottomUp ? this.portSize - this.scrollerHeight - e : e;
},
adjustBottomPage: function() {
var e = this.p0 >= this.p1 ? this.$.page0 : this.$.page1;
this.positionPage(e.pageNo, e);
},
adjustPortSize: function() {
this.scrollerHeight = this.getBounds().height;
var e = Math.max(this.scrollerHeight, this.portSize);
this.$.port.applyStyle("height", e + "px");
},
positionPage: function(e, t) {
t.pageNo = e;
var n = this.pageToPosition(e);
t.applyStyle(this.pageBound, n + "px");
},
pageToPosition: function(e) {
var t = 0, n = e;
while (n > 0) n--, t += this.getPageHeight(n);
return t;
},
positionToPageInfo: function(e) {
var t = -1, n = this.calcPos(e), r = this.defaultPageHeight;
while (n >= 0) t++, r = this.getPageHeight(t), n -= r;
return t = Math.max(t, 0), {
no: t,
height: r,
pos: n + r,
startRow: t * this.rowsPerPage,
endRow: Math.min((t + 1) * this.rowsPerPage - 1, this.count - 1)
};
},
isPageInRange: function(e) {
return e == Math.max(0, Math.min(this.pageCount - 1, e));
},
getPageHeight: function(e) {
var t = this.pageHeights[e];
if (!t) {
var n = this.rowsPerPage * e, r = Math.min(this.count - n, this.rowsPerPage);
t = this.defaultPageHeight * (r / this.rowsPerPage);
}
return Math.max(1, t);
},
invalidatePages: function() {
this.p0 = this.p1 = null, this.p0RowBounds = {}, this.p1RowBounds = {}, this.$.page0.setContent(""), this.$.page1.setContent("");
},
invalidateMetrics: function() {
this.pageHeights = [], this.rowHeight = 0, this.updateMetrics();
},
scroll: function(e, t) {
var n = this.inherited(arguments), r = this.getScrollTop();
return this.lastPos === r ? n : (this.lastPos = r, this.update(r), this.pinnedReorderMode && this.reorderScroll(e, t), n);
},
setScrollTop: function(e) {
this.update(e), this.inherited(arguments), this.twiddle();
},
getScrollPosition: function() {
return this.calcPos(this.getScrollTop());
},
setScrollPosition: function(e) {
this.setScrollTop(this.calcPos(e));
},
scrollToBottom: function() {
this.update(this.getScrollBounds().maxTop), this.inherited(arguments);
},
scrollToRow: function(e) {
var t = this.pageForRow(e), n = e % this.rowsPerPage, r = this.pageToPosition(t);
this.updateForPosition(r), r = this.pageToPosition(t), this.setScrollPosition(r);
if (t == this.p0 || t == this.p1) {
var i = this.$.generator.fetchRowNode(e);
if (i) {
var s = i.offsetTop;
this.bottomUp && (s = this.getPageHeight(t) - i.offsetHeight - s);
var o = this.getScrollPosition() + s;
this.setScrollPosition(o);
}
}
},
scrollToStart: function() {
this[this.bottomUp ? "scrollToBottom" : "scrollToTop"]();
},
scrollToEnd: function() {
this[this.bottomUp ? "scrollToTop" : "scrollToBottom"]();
},
refresh: function() {
this.invalidatePages(), this.update(this.getScrollTop()), this.stabilize(), enyo.platform.android === 4 && this.twiddle();
},
reset: function() {
this.getSelection().clear(), this.invalidateMetrics(), this.invalidatePages(), this.stabilize(), this.scrollToStart();
},
getSelection: function() {
return this.$.generator.getSelection();
},
select: function(e, t) {
return this.getSelection().select(e, t);
},
deselect: function(e) {
return this.getSelection().deselect(e);
},
isSelected: function(e) {
return this.$.generator.isSelected(e);
},
renderRow: function(e) {
this.$.generator.renderRow(e);
},
rowRendered: function(e, t) {
this.updateRowBounds(t.rowIndex);
},
prepareRow: function(e) {
this.$.generator.prepareRow(e);
},
lockRow: function() {
this.$.generator.lockRow();
},
performOnRow: function(e, t, n) {
this.$.generator.performOnRow(e, t, n);
},
animateFinish: function(e) {
return this.twiddle(), !0;
},
twiddle: function() {
var e = this.getStrategy();
enyo.call(e, "twiddle");
},
pageForPageNumber: function(e, t) {
return e % 2 === 0 ? !t || e === this.p0 ? this.$.page0 : null : !t || e === this.p1 ? this.$.page1 : null;
},
shouldStartReordering: function(e, t) {
return !!this.getReorderable() && t.rowIndex >= 0 && !this.pinnedReorderMode && e === this.$.strategy && t.index >= 0 ? !0 : !1;
},
startReordering: function(e) {
this.$.strategy.listReordering = !0, this.buildReorderContainer(), this.doSetupReorderComponents(e), this.styleReorderContainer(e), this.draggingRowIndex = this.placeholderRowIndex = e.rowIndex, this.draggingRowNode = e.target, this.removedInitialPage = !1, this.itemMoved = !1, this.initialPageNumber = this.currentPageNumber = this.pageForRow(e.rowIndex), this.prevScrollTop = this.getScrollTop(), this.replaceNodeWithPlaceholder(e.rowIndex);
},
buildReorderContainer: function() {
this.$.reorderContainer.destroyClientControls();
for (var e = 0; e < this.reorderComponents.length; e++) this.$.reorderContainer.createComponent(this.reorderComponents[e], {
owner: this.owner
});
this.$.reorderContainer.render();
},
styleReorderContainer: function(e) {
this.setItemPosition(this.$.reorderContainer, e.rowIndex), this.setItemBounds(this.$.reorderContainer, e.rowIndex), this.$.reorderContainer.setShowing(!0), this.centerReorderContainer && this.centerReorderContainerOnPointer(e);
},
appendNodeToReorderContainer: function(e) {
this.$.reorderContainer.createComponent({
allowHtml: !0,
content: e.innerHTML
}).render();
},
centerReorderContainerOnPointer: function(e) {
var t = enyo.dom.calcNodePosition(this.hasNode()), n = e.pageX - t.left - parseInt(this.$.reorderContainer.domStyles.width, 10) / 2, r = e.pageY - t.top + this.getScrollTop() - parseInt(this.$.reorderContainer.domStyles.height, 10) / 2;
this.getStrategyKind() != "ScrollStrategy" && (n -= this.getScrollLeft(), r -= this.getScrollTop()), this.positionReorderContainer(n, r);
},
positionReorderContainer: function(e, t) {
this.$.reorderContainer.addClass("enyo-animatedTopAndLeft"), this.$.reorderContainer.addStyles("left:" + e + "px;top:" + t + "px;"), this.setPositionReorderContainerTimeout();
},
setPositionReorderContainerTimeout: function() {
this.clearPositionReorderContainerTimeout(), this.positionReorderContainerTimeout = setTimeout(enyo.bind(this, function() {
this.$.reorderContainer.removeClass("enyo-animatedTopAndLeft"), this.clearPositionReorderContainerTimeout();
}), 100);
},
clearPositionReorderContainerTimeout: function() {
this.positionReorderContainerTimeout && (clearTimeout(this.positionReorderContainerTimeout), this.positionReorderContainerTimeout = null);
},
shouldDoReorderDrag: function() {
return !this.getReorderable() || this.draggingRowIndex < 0 || this.pinnedReorderMode ? !1 : !0;
},
reorderDrag: function(e) {
this.positionReorderNode(e), this.checkForAutoScroll(e), this.updatePlaceholderPosition(e.pageY);
},
updatePlaceholderPosition: function(e) {
var t = this.getRowIndexFromCoordinate(e);
t !== -1 && (t >= this.placeholderRowIndex ? this.movePlaceholderToIndex(Math.min(this.count, t + 1)) : this.movePlaceholderToIndex(t));
},
positionReorderNode: function(e) {
var t = this.$.reorderContainer.getBounds(), n = t.left + e.ddx, r = t.top + e.ddy;
r = this.getStrategyKind() == "ScrollStrategy" ? r + (this.getScrollTop() - this.prevScrollTop) : r, this.$.reorderContainer.addStyles("top: " + r + "px ; left: " + n + "px"), this.prevScrollTop = this.getScrollTop();
},
checkForAutoScroll: function(e) {
var t = enyo.dom.calcNodePosition(this.hasNode()), n = this.getBounds(), r;
this.autoscrollPageY = e.pageY, e.pageY - t.top < n.height * this.dragToScrollThreshold ? (r = 100 * (1 - (e.pageY - t.top) / (n.height * this.dragToScrollThreshold)), this.scrollDistance = -1 * r) : e.pageY - t.top > n.height * (1 - this.dragToScrollThreshold) ? (r = 100 * ((e.pageY - t.top - n.height * (1 - this.dragToScrollThreshold)) / (n.height - n.height * (1 - this.dragToScrollThreshold))), this.scrollDistance = 1 * r) : this.scrollDistance = 0, this.scrollDistance === 0 ? this.stopAutoScrolling() : this.autoScrollTimeout || this.startAutoScrolling();
},
stopAutoScrolling: function() {
this.autoScrollTimeout && (clearTimeout(this.autoScrollTimeout), this.autoScrollTimeout = null);
},
startAutoScrolling: function() {
this.autoScrollTimeout = setInterval(enyo.bind(this, this.autoScroll), this.autoScrollTimeoutMS);
},
autoScroll: function() {
this.scrollDistance === 0 ? this.stopAutoScrolling() : this.autoScrollTimeout || this.startAutoScrolling(), this.setScrollPosition(this.getScrollPosition() + this.scrollDistance), this.positionReorderNode({
ddx: 0,
ddy: 0
}), this.updatePlaceholderPosition(this.autoscrollPageY);
},
movePlaceholderToIndex: function(e) {
var t, n;
if (e < 0) return;
e >= this.count ? (t = null, n = this.pageForPageNumber(this.pageForRow(this.count - 1)).hasNode()) : (t = this.$.generator.fetchRowNode(e), n = t.parentNode);
var r = this.pageForRow(e);
r >= this.pageCount && (r = this.currentPageNumber), n.insertBefore(this.placeholderNode, t), this.currentPageNumber !== r && (this.updatePageHeight(this.currentPageNumber), this.updatePageHeight(r), this.updatePagePositions(r)), this.placeholderRowIndex = e, this.currentPageNumber = r, this.itemMoved = !0;
},
finishReordering: function(e, t) {
if (!this.isReordering() || this.pinnedReorderMode || this.completeReorderTimeout) return;
return this.stopAutoScrolling(), this.$.strategy.listReordering = !1, this.moveReorderedContainerToDroppedPosition(t), this.completeReorderTimeout = setTimeout(enyo.bind(this, this.completeFinishReordering, t), 100), t.preventDefault(), !0;
},
moveReorderedContainerToDroppedPosition: function() {
var e = this.getRelativeOffset(this.placeholderNode, this.hasNode()), t = this.getStrategyKind() == "ScrollStrategy" ? e.top : e.top - this.getScrollTop(), n = e.left - this.getScrollLeft();
this.positionReorderContainer(n, t);
},
completeFinishReordering: function(e) {
this.completeReorderTimeout = null, this.placeholderRowIndex > this.draggingRowIndex && (this.placeholderRowIndex = Math.max(0, this.placeholderRowIndex - 1));
if (this.draggingRowIndex == this.placeholderRowIndex && this.pinnedReorderComponents.length && !this.pinnedReorderMode && !this.itemMoved) {
this.beginPinnedReorder(e);
return;
}
this.removeDraggingRowNode(), this.removePlaceholderNode(), this.emptyAndHideReorderContainer(), this.pinnedReorderMode = !1, this.reorderRows(e), this.draggingRowIndex = this.placeholderRowIndex = -1, this.refresh();
},
beginPinnedReorder: function(e) {
this.buildPinnedReorderContainer(), this.doSetupPinnedReorderComponents(enyo.mixin(e, {
index: this.draggingRowIndex
})), this.pinnedReorderMode = !0, this.initialPinPosition = e.pageY;
},
emptyAndHideReorderContainer: function() {
this.$.reorderContainer.destroyComponents(), this.$.reorderContainer.setShowing(!1);
},
buildPinnedReorderContainer: function() {
this.$.reorderContainer.destroyClientControls();
for (var e = 0; e < this.pinnedReorderComponents.length; e++) this.$.reorderContainer.createComponent(this.pinnedReorderComponents[e], {
owner: this.owner
});
this.$.reorderContainer.render();
},
reorderRows: function(e) {
this.doReorder(this.makeReorderEvent(e)), this.positionReorderedNode(), this.updateListIndices();
},
makeReorderEvent: function(e) {
return e.reorderFrom = this.draggingRowIndex, e.reorderTo = this.placeholderRowIndex, e;
},
positionReorderedNode: function() {
if (!this.removedInitialPage) {
var e = this.$.generator.fetchRowNode(this.placeholderRowIndex);
e && (e.parentNode.insertBefore(this.hiddenNode, e), this.showNode(this.hiddenNode)), this.hiddenNode = null;
if (this.currentPageNumber != this.initialPageNumber) {
var t, n, r = this.pageForPageNumber(this.currentPageNumber), i = this.pageForPageNumber(this.currentPageNumber + 1);
this.initialPageNumber < this.currentPageNumber ? (t = r.hasNode().firstChild, i.hasNode().appendChild(t)) : (t = r.hasNode().lastChild, n = i.hasNode().firstChild, i.hasNode().insertBefore(t, n)), this.correctPageHeights(), this.updatePagePositions(this.initialPageNumber);
}
}
},
updateListIndices: function() {
if (this.shouldDoRefresh()) {
this.refresh(), this.correctPageHeights();
return;
}
var e = Math.min(this.draggingRowIndex, this.placeholderRowIndex), t = Math.max(this.draggingRowIndex, this.placeholderRowIndex), n = this.draggingRowIndex - this.placeholderRowIndex > 0 ? 1 : -1, r, i, s, o;
if (n === 1) {
r = this.$.generator.fetchRowNode(this.draggingRowIndex), r && r.setAttribute("data-enyo-index", "reordered");
for (i = t - 1, s = t; i >= e; i--) {
r = this.$.generator.fetchRowNode(i);
if (!r) continue;
o = parseInt(r.getAttribute("data-enyo-index"), 10), s = o + 1, r.setAttribute("data-enyo-index", s);
}
r = this.hasNode().querySelector('[data-enyo-index="reordered"]'), r.setAttribute("data-enyo-index", this.placeholderRowIndex);
} else {
r = this.$.generator.fetchRowNode(this.draggingRowIndex), r && r.setAttribute("data-enyo-index", this.placeholderRowIndex);
for (i = e + 1, s = e; i <= t; i++) {
r = this.$.generator.fetchRowNode(i);
if (!r) continue;
o = parseInt(r.getAttribute("data-enyo-index"), 10), s = o - 1, r.setAttribute("data-enyo-index", s);
}
}
},
shouldDoRefresh: function() {
return Math.abs(this.initialPageNumber - this.currentPageNumber) > 1;
},
getNodeStyle: function(e) {
var t = this.$.generator.fetchRowNode(e);
if (!t) return;
var n = this.getRelativeOffset(t, this.hasNode()), r = enyo.dom.getBounds(t);
return {
h: r.height,
w: r.width,
left: n.left,
top: n.top
};
},
getRelativeOffset: function(e, t) {
var n = {
top: 0,
left: 0
};
if (e !== t && e.parentNode) do n.top += e.offsetTop || 0, n.left += e.offsetLeft || 0, e = e.offsetParent; while (e && e !== t);
return n;
},
replaceNodeWithPlaceholder: function(e) {
var t = this.$.generator.fetchRowNode(e);
if (!t) {
enyo.log("No node - " + e);
return;
}
this.placeholderNode = this.createPlaceholderNode(t), this.hiddenNode = this.hideNode(t);
var n = this.pageForPageNumber(this.currentPageNumber);
n.hasNode().insertBefore(this.placeholderNode, this.hiddenNode);
},
createPlaceholderNode: function(e) {
var t = this.$.placeholder.hasNode().cloneNode(!0), n = enyo.dom.getBounds(e);
return t.style.height = n.height + "px", t.style.width = n.width + "px", t;
},
removePlaceholderNode: function() {
this.removeNode(this.placeholderNode), this.placeholderNode = null;
},
removeDraggingRowNode: function() {
this.draggingRowNode = null;
var e = this.$.holdingarea.hasNode();
e.innerHTML = "";
},
removeNode: function(e) {
if (!e || !e.parentNode) return;
e.parentNode.removeChild(e);
},
updatePageHeight: function(e) {
if (e < 0) return;
var t = this.pageForPageNumber(e, !0);
if (t) {
var n = this.pageHeights[e], r = Math.max(1, t.getBounds().height);
this.pageHeights[e] = r, this.portSize += r - n;
}
},
updatePagePositions: function(e) {
this.positionPage(this.currentPageNumber, this.pageForPageNumber(this.currentPageNumber)), this.positionPage(e, this.pageForPageNumber(e));
},
correctPageHeights: function() {
this.updatePageHeight(this.currentPageNumber), this.initialPageNumber != this.currentPageNumber && this.updatePageHeight(this.initialPageNumber);
},
hideNode: function(e) {
return e.style.display = "none", e;
},
showNode: function(e) {
return e.style.display = "block", e;
},
dropPinnedRow: function(e) {
this.moveReorderedContainerToDroppedPosition(e), this.completeReorderTimeout = setTimeout(enyo.bind(this, this.completeFinishReordering, e), 100);
return;
},
cancelPinnedMode: function(e) {
this.placeholderRowIndex = this.draggingRowIndex, this.dropPinnedRow(e);
},
getRowIndexFromCoordinate: function(e) {
var t = this.getScrollTop() + e - enyo.dom.calcNodePosition(this.hasNode()).top;
if (t < 0) return -1;
var n = this.positionToPageInfo(t), r = n.no == this.p0 ? this.p0RowBounds : this.p1RowBounds;
if (!r) return this.count;
var i = n.pos, s = this.placeholderNode ? enyo.dom.getBounds(this.placeholderNode).height : 0, o = 0;
for (var u = n.startRow; u <= n.endRow; ++u) {
if (u === this.placeholderRowIndex) {
o += s;
if (o >= i) return -1;
}
if (u !== this.draggingRowIndex) {
o += r[u].height;
if (o >= i) return u;
}
}
return u;
},
getIndexPosition: function(e) {
return enyo.dom.calcNodePosition(this.$.generator.fetchRowNode(e));
},
setItemPosition: function(e, t) {
var n = this.getNodeStyle(t), r = this.getStrategyKind() == "ScrollStrategy" ? n.top : n.top - this.getScrollTop(), i = "top:" + r + "px; left:" + n.left + "px;";
e.addStyles(i);
},
setItemBounds: function(e, t) {
var n = this.getNodeStyle(t), r = "width:" + n.w + "px; height:" + n.h + "px;";
e.addStyles(r);
},
reorderScroll: function(e, t) {
this.getStrategyKind() == "ScrollStrategy" && this.$.reorderContainer.addStyles("top:" + (this.initialPinPosition + this.getScrollTop() - this.rowHeight) + "px;"), this.updatePlaceholderPosition(this.initialPinPosition);
},
hideReorderingRow: function() {
var e = this.hasNode().querySelector('[data-enyo-index="' + this.draggingRowIndex + '"]');
e && (this.hiddenNode = this.hideNode(e));
},
isReordering: function() {
return this.draggingRowIndex > -1;
},
isSwiping: function() {
return this.swipeIndex != null && !this.swipeComplete && this.swipeDirection != null;
},
swipeDragStart: function(e, t) {
return t.index == null || t.vertical ? !0 : (this.completeSwipeTimeout && this.completeSwipe(t), this.swipeComplete = !1, this.swipeIndex != t.index && (this.clearSwipeables(), this.swipeIndex = t.index), this.swipeDirection = t.xDirection, this.persistentItemVisible || this.startSwipe(t), this.draggedXDistance = 0, this.draggedYDistance = 0, !0);
},
swipeDrag: function(e, t) {
return this.persistentItemVisible ? (this.dragPersistentItem(t), this.preventDragPropagation) : this.isSwiping() ? (this.dragSwipeableComponents(this.calcNewDragPosition(t.ddx)), this.draggedXDistance = t.dx, this.draggedYDistance = t.dy, !0) : !1;
},
swipeDragFinish: function(e, t) {
if (this.persistentItemVisible) this.dragFinishPersistentItem(t); else {
if (!this.isSwiping()) return !1;
var n = this.calcPercentageDragged(this.draggedXDistance);
n > this.percentageDraggedThreshold && t.xDirection === this.swipeDirection ? this.swipe(this.fastSwipeSpeedMS) : this.backOutSwipe(t);
}
return this.preventDragPropagation;
},
isSwipeable: function() {
return this.enableSwipe && this.$.swipeableComponents.controls.length !== 0 && !this.isReordering() && !this.pinnedReorderMode;
},
positionSwipeableContainer: function(e, t) {
var n = this.$.generator.fetchRowNode(e);
if (!n) return;
var r = this.getRelativeOffset(n, this.hasNode()), i = enyo.dom.getBounds(n), s = t == 1 ? -1 * i.width : i.width;
this.$.swipeableComponents.addStyles("top: " + r.top + "px; left: " + s + "px; height: " + i.height + "px; width: " + i.width + "px;");
},
calcNewDragPosition: function(e) {
var t = this.$.swipeableComponents.getBounds(), n = t.left, r = this.$.swipeableComponents.getBounds(), i = this.swipeDirection == 1 ? 0 : -1 * r.width, s = this.swipeDirection == 1 ? n + e > i ? i : n + e : n + e < i ? i : n + e;
return s;
},
dragSwipeableComponents: function(e) {
this.$.swipeableComponents.applyStyle("left", e + "px");
},
startSwipe: function(e) {
e.index = this.swipeIndex, this.positionSwipeableContainer(this.swipeIndex, e.xDirection), this.$.swipeableComponents.setShowing(!0), this.setPersistentItemOrigin(e.xDirection), this.doSetupSwipeItem(e);
},
dragPersistentItem: function(e) {
var t = 0, n = this.persistentItemOrigin == "right" ? Math.max(t, t + e.dx) : Math.min(t, t + e.dx);
this.$.swipeableComponents.applyStyle("left", n + "px");
},
dragFinishPersistentItem: function(e) {
var t = this.calcPercentageDragged(e.dx) > .2, n = e.dx > 0 ? "right" : e.dx < 0 ? "left" : null;
this.persistentItemOrigin == n ? t ? this.slideAwayItem() : this.bounceItem(e) : this.bounceItem(e);
},
setPersistentItemOrigin: function(e) {
this.persistentItemOrigin = e == 1 ? "left" : "right";
},
calcPercentageDragged: function(e) {
return Math.abs(e / this.$.swipeableComponents.getBounds().width);
},
swipe: function(e) {
this.swipeComplete = !0, this.animateSwipe(0, e);
},
backOutSwipe: function(e) {
var t = this.$.swipeableComponents.getBounds(), n = this.swipeDirection == 1 ? -1 * t.width : t.width;
this.animateSwipe(n, this.fastSwipeSpeedMS), this.swipeDirection = null;
},
bounceItem: function(e) {
var t = this.$.swipeableComponents.getBounds();
t.left != t.width && this.animateSwipe(0, this.normalSwipeSpeedMS);
},
slideAwayItem: function() {
var e = this.$.swipeableComponents, t = e.getBounds().width, n = this.persistentItemOrigin == "left" ? -1 * t : t;
this.animateSwipe(n, this.normalSwipeSpeedMS), this.persistentItemVisible = !1, this.setPersistSwipeableItem(!1);
},
clearSwipeables: function() {
this.$.swipeableComponents.setShowing(!1), this.persistentItemVisible = !1, this.setPersistSwipeableItem(!1);
},
completeSwipe: function(e) {
this.completeSwipeTimeout && (clearTimeout(this.completeSwipeTimeout), this.completeSwipeTimeout = null), this.getPersistSwipeableItem() ? this.persistentItemVisible = !0 : (this.$.swipeableComponents.setShowing(!1), this.swipeComplete && this.doSwipeComplete({
index: this.swipeIndex,
xDirection: this.swipeDirection
})), this.swipeIndex = null, this.swipeDirection = null;
},
animateSwipe: function(e, t) {
var n = enyo.now(), r = 0, i = this.$.swipeableComponents, s = parseInt(i.domStyles.left, 10), o = e - s;
this.stopAnimateSwipe();
var u = enyo.bind(this, function() {
var e = enyo.now() - n, r = e / t, a = s + o * Math.min(r, 1);
i.applyStyle("left", a + "px"), this.job = enyo.requestAnimationFrame(u), e / t >= 1 && (this.stopAnimateSwipe(), this.completeSwipeTimeout = setTimeout(enyo.bind(this, function() {
this.completeSwipe();
}), this.completeSwipeDelayMS));
});
this.job = enyo.requestAnimationFrame(u);
},
stopAnimateSwipe: function() {
this.job && (this.job = enyo.cancelRequestAnimationFrame(this.job));
}
});

// PulldownList.js

enyo.kind({
name: "enyo.PulldownList",
kind: "List",
touch: !0,
pully: null,
pulldownTools: [ {
name: "pulldown",
classes: "enyo-list-pulldown",
components: [ {
name: "puller",
kind: "Puller"
} ]
} ],
events: {
onPullStart: "",
onPullCancel: "",
onPull: "",
onPullRelease: "",
onPullComplete: ""
},
handlers: {
onScrollStart: "scrollStartHandler",
onScrollStop: "scrollStopHandler",
ondragfinish: "dragfinish"
},
pullingMessage: "Pull down to refresh...",
pulledMessage: "Release to refresh...",
loadingMessage: "Loading...",
pullingIconClass: "enyo-puller-arrow enyo-puller-arrow-down",
pulledIconClass: "enyo-puller-arrow enyo-puller-arrow-up",
loadingIconClass: "",
create: function() {
var e = {
kind: "Puller",
showing: !1,
text: this.loadingMessage,
iconClass: this.loadingIconClass,
onCreate: "setPully"
};
this.listTools.splice(0, 0, e), this.inherited(arguments), this.setPulling();
},
initComponents: function() {
this.createChrome(this.pulldownTools), this.accel = enyo.dom.canAccelerate(), this.translation = this.accel ? "translate3d" : "translate", this.strategyKind = this.resetStrategyKind(), this.inherited(arguments);
},
resetStrategyKind: function() {
return enyo.platform.android >= 3 ? "TranslateScrollStrategy" : "TouchScrollStrategy";
},
setPully: function(e, t) {
this.pully = t.originator;
},
scrollStartHandler: function() {
this.firedPullStart = !1, this.firedPull = !1, this.firedPullCancel = !1;
},
scroll: function(e, t) {
var n = this.inherited(arguments);
this.completingPull && this.pully.setShowing(!1);
var r = this.getStrategy().$.scrollMath || this.getStrategy(), i = -1 * this.getScrollTop();
return r.isInOverScroll() && i > 0 && (enyo.dom.transformValue(this.$.pulldown, this.translation, "0," + i + "px" + (this.accel ? ",0" : "")), this.firedPullStart || (this.firedPullStart = !0, this.pullStart(), this.pullHeight = this.$.pulldown.getBounds().height), i > this.pullHeight && !this.firedPull && (this.firedPull = !0, this.firedPullCancel = !1, this.pull()), this.firedPull && !this.firedPullCancel && i < this.pullHeight && (this.firedPullCancel = !0, this.firedPull = !1, this.pullCancel())), n;
},
scrollStopHandler: function() {
this.completingPull && (this.completingPull = !1, this.doPullComplete());
},
dragfinish: function() {
if (this.firedPull) {
var e = this.getStrategy().$.scrollMath || this.getStrategy();
e.setScrollY(-1 * this.getScrollTop() - this.pullHeight), this.pullRelease();
}
},
completePull: function() {
this.completingPull = !0;
var e = this.getStrategy().$.scrollMath || this.getStrategy();
e.setScrollY(this.pullHeight), e.start();
},
pullStart: function() {
this.setPulling(), this.pully.setShowing(!1), this.$.puller.setShowing(!0), this.doPullStart();
},
pull: function() {
this.setPulled(), this.doPull();
},
pullCancel: function() {
this.setPulling(), this.doPullCancel();
},
pullRelease: function() {
this.$.puller.setShowing(!1), this.pully.setShowing(!0), this.doPullRelease();
},
setPulling: function() {
this.$.puller.setText(this.pullingMessage), this.$.puller.setIconClass(this.pullingIconClass);
},
setPulled: function() {
this.$.puller.setText(this.pulledMessage), this.$.puller.setIconClass(this.pulledIconClass);
}
}), enyo.kind({
name: "enyo.Puller",
classes: "enyo-puller",
published: {
text: "",
iconClass: ""
},
events: {
onCreate: ""
},
components: [ {
name: "icon"
}, {
name: "text",
tag: "span",
classes: "enyo-puller-text"
} ],
create: function() {
this.inherited(arguments), this.doCreate(), this.textChanged(), this.iconClassChanged();
},
textChanged: function() {
this.$.text.setContent(this.text);
},
iconClassChanged: function() {
this.$.icon.setClasses(this.iconClass);
}
});

// AroundList.js

enyo.kind({
name: "enyo.AroundList",
kind: "enyo.List",
listTools: [ {
name: "port",
classes: "enyo-list-port enyo-border-box",
components: [ {
name: "aboveClient"
}, {
name: "generator",
kind: "FlyweightRepeater",
canGenerate: !1,
components: [ {
tag: null,
name: "client"
} ]
}, {
name: "holdingarea",
allowHtml: !0,
classes: "enyo-list-holdingarea"
}, {
name: "page0",
allowHtml: !0,
classes: "enyo-list-page"
}, {
name: "page1",
allowHtml: !0,
classes: "enyo-list-page"
}, {
name: "belowClient"
}, {
name: "placeholder"
}, {
name: "swipeableComponents",
style: "position:absolute; display:block; top:-1000px; left:0px;"
} ]
} ],
aboveComponents: null,
initComponents: function() {
this.inherited(arguments), this.aboveComponents && this.$.aboveClient.createComponents(this.aboveComponents, {
owner: this.owner
}), this.belowComponents && this.$.belowClient.createComponents(this.belowComponents, {
owner: this.owner
});
},
updateMetrics: function() {
this.defaultPageHeight = this.rowsPerPage * (this.rowHeight || 100), this.pageCount = Math.ceil(this.count / this.rowsPerPage), this.aboveHeight = this.$.aboveClient.getBounds().height, this.belowHeight = this.$.belowClient.getBounds().height, this.portSize = this.aboveHeight + this.belowHeight;
for (var e = 0; e < this.pageCount; e++) this.portSize += this.getPageHeight(e);
this.adjustPortSize();
},
positionPage: function(e, t) {
t.pageNo = e;
var n = this.pageToPosition(e), r = this.bottomUp ? this.belowHeight : this.aboveHeight;
n += r, t.applyStyle(this.pageBound, n + "px");
},
scrollToContentStart: function() {
var e = this.bottomUp ? this.belowHeight : this.aboveHeight;
this.setScrollPosition(e);
}
});

// Slideable.js

enyo.kind({
name: "enyo.Slideable",
kind: "Control",
published: {
axis: "h",
value: 0,
unit: "px",
min: 0,
max: 0,
accelerated: "auto",
overMoving: !0,
draggable: !0
},
events: {
onAnimateFinish: "",
onChange: ""
},
preventDragPropagation: !1,
tools: [ {
kind: "Animator",
onStep: "animatorStep",
onEnd: "animatorComplete"
} ],
handlers: {
ondragstart: "dragstart",
ondrag: "drag",
ondragfinish: "dragfinish"
},
kDragScalar: 1,
dragEventProp: "dx",
unitModifier: !1,
canTransform: !1,
create: function() {
this.inherited(arguments), this.acceleratedChanged(), this.transformChanged(), this.axisChanged(), this.valueChanged(), this.addClass("enyo-slideable");
},
initComponents: function() {
this.createComponents(this.tools), this.inherited(arguments);
},
rendered: function() {
this.inherited(arguments), this.canModifyUnit(), this.updateDragScalar();
},
resizeHandler: function() {
this.inherited(arguments), this.updateDragScalar();
},
canModifyUnit: function() {
if (!this.canTransform) {
var e = this.getInitialStyleValue(this.hasNode(), this.boundary);
e.match(/px/i) && this.unit === "%" && (this.unitModifier = this.getBounds()[this.dimension]);
}
},
getInitialStyleValue: function(e, t) {
var n = enyo.dom.getComputedStyle(e);
return n ? n.getPropertyValue(t) : e && e.currentStyle ? e.currentStyle[t] : "0";
},
updateBounds: function(e, t) {
var n = {};
n[this.boundary] = e, this.setBounds(n, this.unit), this.setInlineStyles(e, t);
},
updateDragScalar: function() {
if (this.unit == "%") {
var e = this.getBounds()[this.dimension];
this.kDragScalar = e ? 100 / e : 1, this.canTransform || this.updateBounds(this.value, 100);
}
},
transformChanged: function() {
this.canTransform = enyo.dom.canTransform();
},
acceleratedChanged: function() {
enyo.platform.android > 2 || enyo.dom.accelerate(this, this.accelerated);
},
axisChanged: function() {
var e = this.axis == "h";
this.dragMoveProp = e ? "dx" : "dy", this.shouldDragProp = e ? "horizontal" : "vertical", this.transform = e ? "translateX" : "translateY", this.dimension = e ? "width" : "height", this.boundary = e ? "left" : "top";
},
setInlineStyles: function(e, t) {
var n = {};
this.unitModifier ? (n[this.boundary] = this.percentToPixels(e, this.unitModifier), n[this.dimension] = this.unitModifier, this.setBounds(n)) : (t ? n[this.dimension] = t : n[this.boundary] = e, this.setBounds(n, this.unit));
},
valueChanged: function(e) {
var t = this.value;
this.isOob(t) && !this.isAnimating() && (this.value = this.overMoving ? this.dampValue(t) : this.clampValue(t)), enyo.platform.android > 2 && (this.value ? (e === 0 || e === undefined) && enyo.dom.accelerate(this, this.accelerated) : enyo.dom.accelerate(this, !1)), this.canTransform ? enyo.dom.transformValue(this, this.transform, this.value + this.unit) : this.setInlineStyles(this.value, !1), this.doChange();
},
getAnimator: function() {
return this.$.animator;
},
isAtMin: function() {
return this.value <= this.calcMin();
},
isAtMax: function() {
return this.value >= this.calcMax();
},
calcMin: function() {
return this.min;
},
calcMax: function() {
return this.max;
},
clampValue: function(e) {
var t = this.calcMin(), n = this.calcMax();
return Math.max(t, Math.min(e, n));
},
dampValue: function(e) {
return this.dampBound(this.dampBound(e, this.min, 1), this.max, -1);
},
dampBound: function(e, t, n) {
var r = e;
return r * n < t * n && (r = t + (r - t) / 4), r;
},
percentToPixels: function(e, t) {
return Math.floor(t / 100 * e);
},
pixelsToPercent: function(e) {
var t = this.unitModifier ? this.getBounds()[this.dimension] : this.container.getBounds()[this.dimension];
return e / t * 100;
},
shouldDrag: function(e) {
return this.draggable && e[this.shouldDragProp];
},
isOob: function(e) {
return e > this.calcMax() || e < this.calcMin();
},
dragstart: function(e, t) {
if (this.shouldDrag(t)) return t.preventDefault(), this.$.animator.stop(), t.dragInfo = {}, this.dragging = !0, this.drag0 = this.value, this.dragd0 = 0, this.preventDragPropagation;
},
drag: function(e, t) {
if (this.dragging) {
t.preventDefault();
var n = this.canTransform ? t[this.dragMoveProp] * this.kDragScalar : this.pixelsToPercent(t[this.dragMoveProp]), r = this.drag0 + n, i = n - this.dragd0;
return this.dragd0 = n, i && (t.dragInfo.minimizing = i < 0), this.setValue(r), this.preventDragPropagation;
}
},
dragfinish: function(e, t) {
if (this.dragging) return this.dragging = !1, this.completeDrag(t), t.preventTap(), this.preventDragPropagation;
},
completeDrag: function(e) {
this.value !== this.calcMax() && this.value != this.calcMin() && this.animateToMinMax(e.dragInfo.minimizing);
},
isAnimating: function() {
return this.$.animator.isAnimating();
},
play: function(e, t) {
this.$.animator.play({
startValue: e,
endValue: t,
node: this.hasNode()
});
},
animateTo: function(e) {
this.play(this.value, e);
},
animateToMin: function() {
this.animateTo(this.calcMin());
},
animateToMax: function() {
this.animateTo(this.calcMax());
},
animateToMinMax: function(e) {
e ? this.animateToMin() : this.animateToMax();
},
animatorStep: function(e) {
return this.setValue(e.value), !0;
},
animatorComplete: function(e) {
return this.doAnimateFinish(e), !0;
},
toggleMinMax: function() {
this.animateToMinMax(!this.isAtMin());
}
});

// Arranger.js

enyo.kind({
name: "enyo.Arranger",
kind: "Layout",
layoutClass: "enyo-arranger",
accelerated: "auto",
dragProp: "ddx",
dragDirectionProp: "xDirection",
canDragProp: "horizontal",
incrementalPoints: !1,
destroy: function() {
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) n._arranger = null;
this.inherited(arguments);
},
arrange: function(e, t) {},
size: function() {},
start: function() {
var e = this.container.fromIndex, t = this.container.toIndex, n = this.container.transitionPoints = [ e ];
if (this.incrementalPoints) {
var r = Math.abs(t - e) - 2, i = e;
while (r >= 0) i += t < e ? -1 : 1, n.push(i), r--;
}
n.push(this.container.toIndex);
},
finish: function() {},
calcArrangementDifference: function(e, t, n, r) {},
canDragEvent: function(e) {
return e[this.canDragProp];
},
calcDragDirection: function(e) {
return e[this.dragDirectionProp];
},
calcDrag: function(e) {
return e[this.dragProp];
},
drag: function(e, t, n, r, i) {
var s = this.measureArrangementDelta(-e, t, n, r, i);
return s;
},
measureArrangementDelta: function(e, t, n, r, i) {
var s = this.calcArrangementDifference(t, n, r, i), o = s ? e / Math.abs(s) : 0;
return o *= this.container.fromIndex > this.container.toIndex ? -1 : 1, o;
},
_arrange: function(e) {
this.containerBounds || this.reflow();
var t = this.getOrderedControls(e);
this.arrange(t, e);
},
arrangeControl: function(e, t) {
e._arranger = enyo.mixin(e._arranger || {}, t);
},
flow: function() {
this.c$ = [].concat(this.container.getPanels()), this.controlsIndex = 0;
for (var e = 0, t = this.container.getPanels(), n; n = t[e]; e++) {
enyo.dom.accelerate(n, this.accelerated);
if (enyo.platform.safari) {
var r = n.children;
for (var i = 0, s; s = r[i]; i++) enyo.dom.accelerate(s, this.accelerated);
}
}
},
reflow: function() {
var e = this.container.hasNode();
this.containerBounds = e ? {
width: e.clientWidth,
height: e.clientHeight
} : {}, this.size();
},
flowArrangement: function() {
var e = this.container.arrangement;
if (e) for (var t = 0, n = this.container.getPanels(), r; r = n[t]; t++) this.flowControl(r, e[t]);
},
flowControl: function(e, t) {
enyo.Arranger.positionControl(e, t);
var n = t.opacity;
n != null && enyo.Arranger.opacifyControl(e, n);
},
getOrderedControls: function(e) {
var t = Math.floor(e), n = t - this.controlsIndex, r = n > 0, i = this.c$ || [];
for (var s = 0; s < Math.abs(n); s++) r ? i.push(i.shift()) : i.unshift(i.pop());
return this.controlsIndex = t, i;
},
statics: {
positionControl: function(e, t, n) {
var r = n || "px";
if (!this.updating) if (enyo.dom.canTransform() && !enyo.platform.android && enyo.platform.ie !== 10) {
var i = t.left, s = t.top;
i = enyo.isString(i) ? i : i && i + r, s = enyo.isString(s) ? s : s && s + r, enyo.dom.transform(e, {
translateX: i || null,
translateY: s || null
});
} else e.setBounds(t, n);
},
opacifyControl: function(e, t) {
var n = t;
n = n > .99 ? 1 : n < .01 ? 0 : n, enyo.platform.ie < 9 ? e.applyStyle("filter", "progid:DXImageTransform.Microsoft.Alpha(Opacity=" + n * 100 + ")") : e.applyStyle("opacity", n);
}
}
});

// CardArranger.js

enyo.kind({
name: "enyo.CardArranger",
kind: "Arranger",
layoutClass: "enyo-arranger enyo-arranger-fit",
calcArrangementDifference: function(e, t, n, r) {
return this.containerBounds.width;
},
arrange: function(e, t) {
for (var n = 0, r, i, s; r = e[n]; n++) s = n === 0 ? 1 : 0, this.arrangeControl(r, {
opacity: s
});
},
start: function() {
this.inherited(arguments);
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) {
var r = n.showing;
n.setShowing(t == this.container.fromIndex || t == this.container.toIndex), n.showing && !r && n.resized();
}
},
finish: function() {
this.inherited(arguments);
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) n.setShowing(t == this.container.toIndex);
},
destroy: function() {
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) enyo.Arranger.opacifyControl(n, 1), n.showing || n.setShowing(!0);
this.inherited(arguments);
}
});

// CardSlideInArranger.js

enyo.kind({
name: "enyo.CardSlideInArranger",
kind: "CardArranger",
start: function() {
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) {
var r = n.showing;
n.setShowing(t == this.container.fromIndex || t == this.container.toIndex), n.showing && !r && n.resized();
}
var i = this.container.fromIndex;
t = this.container.toIndex, this.container.transitionPoints = [ t + "." + i + ".s", t + "." + i + ".f" ];
},
finish: function() {
this.inherited(arguments);
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) n.setShowing(t == this.container.toIndex);
},
arrange: function(e, t) {
var n = t.split("."), r = n[0], i = n[1], s = n[2] == "s", o = this.containerBounds.width;
for (var u = 0, a = this.container.getPanels(), f, l; f = a[u]; u++) l = o, i == u && (l = s ? 0 : -o), r == u && (l = s ? o : 0), i == u && i == r && (l = 0), this.arrangeControl(f, {
left: l
});
},
destroy: function() {
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) enyo.Arranger.positionControl(n, {
left: null
});
this.inherited(arguments);
}
});

// CarouselArranger.js

enyo.kind({
name: "enyo.CarouselArranger",
kind: "Arranger",
size: function() {
var e = this.container.getPanels(), t = this.containerPadding = this.container.hasNode() ? enyo.dom.calcPaddingExtents(this.container.node) : {}, n = this.containerBounds, r, i, s, o, u;
n.height -= t.top + t.bottom, n.width -= t.left + t.right;
var a;
for (r = 0, s = 0; u = e[r]; r++) o = enyo.dom.calcMarginExtents(u.hasNode()), u.width = u.getBounds().width, u.marginWidth = o.right + o.left, s += (u.fit ? 0 : u.width) + u.marginWidth, u.fit && (a = u);
if (a) {
var f = n.width - s;
a.width = f >= 0 ? f : a.width;
}
for (r = 0, i = t.left; u = e[r]; r++) u.setBounds({
top: t.top,
bottom: t.bottom,
width: u.fit ? u.width : null
});
},
arrange: function(e, t) {
this.container.wrap ? this.arrangeWrap(e, t) : this.arrangeNoWrap(e, t);
},
arrangeNoWrap: function(e, t) {
var n, r, i, s, o = this.container.getPanels(), u = this.container.clamp(t), a = this.containerBounds.width;
for (n = u, i = 0; s = o[n]; n++) {
i += s.width + s.marginWidth;
if (i > a) break;
}
var f = a - i, l = 0;
if (f > 0) {
var c = u;
for (n = u - 1, r = 0; s = o[n]; n--) {
r += s.width + s.marginWidth;
if (f - r <= 0) {
l = f - r, u = n;
break;
}
}
}
var h, p;
for (n = 0, p = this.containerPadding.left + l; s = o[n]; n++) h = s.width + s.marginWidth, n < u ? this.arrangeControl(s, {
left: -h
}) : (this.arrangeControl(s, {
left: Math.floor(p)
}), p += h);
},
arrangeWrap: function(e, t) {
for (var n = 0, r = this.containerPadding.left, i, s; s = e[n]; n++) this.arrangeControl(s, {
left: r
}), r += s.width + s.marginWidth;
},
calcArrangementDifference: function(e, t, n, r) {
var i = Math.abs(e % this.c$.length);
return t[i].left - r[i].left;
},
destroy: function() {
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) enyo.Arranger.positionControl(n, {
left: null,
top: null
}), n.applyStyle("top", null), n.applyStyle("bottom", null), n.applyStyle("left", null), n.applyStyle("width", null);
this.inherited(arguments);
}
});

// CollapsingArranger.js

enyo.kind({
name: "enyo.CollapsingArranger",
kind: "CarouselArranger",
peekWidth: 0,
size: function() {
this.clearLastSize(), this.inherited(arguments);
},
clearLastSize: function() {
for (var e = 0, t = this.container.getPanels(), n; n = t[e]; e++) n._fit && e != t.length - 1 && (n.applyStyle("width", null), n._fit = null);
},
constructor: function() {
this.inherited(arguments), this.peekWidth = this.container.peekWidth != null ? this.container.peekWidth : this.peekWidth;
},
arrange: function(e, t) {
var n = this.container.getPanels();
for (var r = 0, i = this.containerPadding.left, s, o, u = 0; o = n[r]; r++) o.getShowing() ? (this.arrangeControl(o, {
left: i + u * this.peekWidth
}), r >= t && (i += o.width + o.marginWidth - this.peekWidth), u++) : (this.arrangeControl(o, {
left: i
}), r >= t && (i += o.width + o.marginWidth)), r == n.length - 1 && t < 0 && this.arrangeControl(o, {
left: i - t
});
},
calcArrangementDifference: function(e, t, n, r) {
var i = this.container.getPanels().length - 1;
return Math.abs(r[i].left - t[i].left);
},
flowControl: function(e, t) {
this.inherited(arguments);
if (this.container.realtimeFit) {
var n = this.container.getPanels(), r = n.length - 1, i = n[r];
e == i && this.fitControl(e, t.left);
}
},
finish: function() {
this.inherited(arguments);
if (!this.container.realtimeFit && this.containerBounds) {
var e = this.container.getPanels(), t = this.container.arrangement, n = e.length - 1, r = e[n];
this.fitControl(r, t[n].left);
}
},
fitControl: function(e, t) {
e._fit = !0, e.applyStyle("width", this.containerBounds.width - t + "px"), e.resized();
}
});

// DockRightArranger.js

enyo.kind({
name: "enyo.DockRightArranger",
kind: "Arranger",
basePanel: !1,
overlap: 0,
layoutWidth: 0,
constructor: function() {
this.inherited(arguments), this.overlap = this.container.overlap != null ? this.container.overlap : this.overlap, this.layoutWidth = this.container.layoutWidth != null ? this.container.layoutWidth : this.layoutWidth;
},
size: function() {
var e = this.container.getPanels(), t = this.containerPadding = this.container.hasNode() ? enyo.dom.calcPaddingExtents(this.container.node) : {}, n = this.containerBounds, r, i, s;
n.width -= t.left + t.right;
var o = n.width, u = e.length;
this.container.transitionPositions = {};
for (r = 0; s = e[r]; r++) s.width = r === 0 && this.container.basePanel ? o : s.getBounds().width;
for (r = 0; s = e[r]; r++) {
r === 0 && this.container.basePanel && s.setBounds({
width: o
}), s.setBounds({
top: t.top,
bottom: t.bottom
});
for (j = 0; s = e[j]; j++) {
var a;
if (r === 0 && this.container.basePanel) a = 0; else if (j < r) a = o; else {
if (r !== j) break;
var f = o > this.layoutWidth ? this.overlap : 0;
a = o - e[r].width + f;
}
this.container.transitionPositions[r + "." + j] = a;
}
if (j < u) {
var l = !1;
for (k = r + 1; k < u; k++) {
var f = 0;
if (l) f = 0; else if (e[r].width + e[k].width - this.overlap > o) f = 0, l = !0; else {
f = e[r].width - this.overlap;
for (i = r; i < k; i++) {
var c = f + e[i + 1].width - this.overlap;
if (!(c < o)) {
f = o;
break;
}
f = c;
}
f = o - f;
}
this.container.transitionPositions[r + "." + k] = f;
}
}
}
},
arrange: function(e, t) {
var n, r, i = this.container.getPanels(), s = this.container.clamp(t);
for (n = 0; r = i[n]; n++) {
var o = this.container.transitionPositions[n + "." + s];
this.arrangeControl(r, {
left: o
});
}
},
calcArrangementDifference: function(e, t, n, r) {
var i = this.container.getPanels(), s = e < n ? i[n].width : i[e].width;
return s;
},
destroy: function() {
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) enyo.Arranger.positionControl(n, {
left: null,
top: null
}), n.applyStyle("top", null), n.applyStyle("bottom", null), n.applyStyle("left", null), n.applyStyle("width", null);
this.inherited(arguments);
}
});

// OtherArrangers.js

enyo.kind({
name: "enyo.LeftRightArranger",
kind: "Arranger",
margin: 40,
axisSize: "width",
offAxisSize: "height",
axisPosition: "left",
constructor: function() {
this.inherited(arguments), this.margin = this.container.margin != null ? this.container.margin : this.margin;
},
size: function() {
var e = this.container.getPanels(), t = this.containerBounds[this.axisSize], n = t - this.margin - this.margin;
for (var r = 0, i, s; s = e[r]; r++) i = {}, i[this.axisSize] = n, i[this.offAxisSize] = "100%", s.setBounds(i);
},
start: function() {
this.inherited(arguments);
var e = this.container.fromIndex, t = this.container.toIndex, n = this.getOrderedControls(t), r = Math.floor(n.length / 2);
for (var i = 0, s; s = n[i]; i++) e > t ? i == n.length - r ? s.applyStyle("z-index", 0) : s.applyStyle("z-index", 1) : i == n.length - 1 - r ? s.applyStyle("z-index", 0) : s.applyStyle("z-index", 1);
},
arrange: function(e, t) {
var n, r, i, s;
if (this.container.getPanels().length == 1) {
s = {}, s[this.axisPosition] = this.margin, this.arrangeControl(this.container.getPanels()[0], s);
return;
}
var o = Math.floor(this.container.getPanels().length / 2), u = this.getOrderedControls(Math.floor(t) - o), a = this.containerBounds[this.axisSize] - this.margin - this.margin, f = this.margin - a * o;
for (n = 0; r = u[n]; n++) s = {}, s[this.axisPosition] = f, this.arrangeControl(r, s), f += a;
},
calcArrangementDifference: function(e, t, n, r) {
if (this.container.getPanels().length == 1) return 0;
var i = Math.abs(e % this.c$.length);
return t[i][this.axisPosition] - r[i][this.axisPosition];
},
destroy: function() {
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) enyo.Arranger.positionControl(n, {
left: null,
top: null
}), enyo.Arranger.opacifyControl(n, 1), n.applyStyle("left", null), n.applyStyle("top", null), n.applyStyle("height", null), n.applyStyle("width", null);
this.inherited(arguments);
}
}), enyo.kind({
name: "enyo.TopBottomArranger",
kind: "LeftRightArranger",
dragProp: "ddy",
dragDirectionProp: "yDirection",
canDragProp: "vertical",
axisSize: "height",
offAxisSize: "width",
axisPosition: "top"
}), enyo.kind({
name: "enyo.SpiralArranger",
kind: "Arranger",
incrementalPoints: !0,
inc: 20,
size: function() {
var e = this.container.getPanels(), t = this.containerBounds, n = this.controlWidth = t.width / 3, r = this.controlHeight = t.height / 3;
for (var i = 0, s; s = e[i]; i++) s.setBounds({
width: n,
height: r
});
},
arrange: function(e, t) {
var n = this.inc;
for (var r = 0, i = e.length, s; s = e[r]; r++) {
var o = Math.cos(r / i * 2 * Math.PI) * r * n + this.controlWidth, u = Math.sin(r / i * 2 * Math.PI) * r * n + this.controlHeight;
this.arrangeControl(s, {
left: o,
top: u
});
}
},
start: function() {
this.inherited(arguments);
var e = this.getOrderedControls(this.container.toIndex);
for (var t = 0, n; n = e[t]; t++) n.applyStyle("z-index", e.length - t);
},
calcArrangementDifference: function(e, t, n, r) {
return this.controlWidth;
},
destroy: function() {
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) n.applyStyle("z-index", null), enyo.Arranger.positionControl(n, {
left: null,
top: null
}), n.applyStyle("left", null), n.applyStyle("top", null), n.applyStyle("height", null), n.applyStyle("width", null);
this.inherited(arguments);
}
}), enyo.kind({
name: "enyo.GridArranger",
kind: "Arranger",
incrementalPoints: !0,
colWidth: 100,
colHeight: 100,
size: function() {
var e = this.container.getPanels(), t = this.colWidth, n = this.colHeight;
for (var r = 0, i; i = e[r]; r++) i.setBounds({
width: t,
height: n
});
},
arrange: function(e, t) {
var n = this.colWidth, r = this.colHeight, i = Math.max(1, Math.floor(this.containerBounds.width / n)), s;
for (var o = 0, u = 0; u < e.length; o++) for (var a = 0; a < i && (s = e[u]); a++, u++) this.arrangeControl(s, {
left: n * a,
top: r * o
});
},
flowControl: function(e, t) {
this.inherited(arguments), enyo.Arranger.opacifyControl(e, t.top % this.colHeight !== 0 ? .25 : 1);
},
calcArrangementDifference: function(e, t, n, r) {
return this.colWidth;
},
destroy: function() {
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) enyo.Arranger.positionControl(n, {
left: null,
top: null
}), n.applyStyle("left", null), n.applyStyle("top", null), n.applyStyle("height", null), n.applyStyle("width", null);
this.inherited(arguments);
}
});

// Panels.js

enyo.kind({
name: "enyo.Panels",
classes: "enyo-panels",
published: {
index: 0,
draggable: !0,
animate: !0,
wrap: !1,
arrangerKind: "CardArranger",
narrowFit: !0
},
events: {
onTransitionStart: "",
onTransitionFinish: ""
},
handlers: {
ondragstart: "dragstart",
ondrag: "drag",
ondragfinish: "dragfinish",
onscroll: "domScroll"
},
tools: [ {
kind: "Animator",
onStep: "step",
onEnd: "completed"
} ],
fraction: 0,
create: function() {
this.transitionPoints = [], this.inherited(arguments), this.arrangerKindChanged(), this.narrowFitChanged(), this.indexChanged();
},
rendered: function() {
this.inherited(arguments), enyo.makeBubble(this, "scroll");
},
domScroll: function(e, t) {
this.hasNode() && this.node.scrollLeft > 0 && (this.node.scrollLeft = 0);
},
initComponents: function() {
this.createChrome(this.tools), this.inherited(arguments);
},
arrangerKindChanged: function() {
this.setLayoutKind(this.arrangerKind);
},
narrowFitChanged: function() {
this.addRemoveClass("enyo-panels-fit-narrow", this.narrowFit);
},
destroy: function() {
this.destroying = !0, this.inherited(arguments);
},
removeControl: function(e) {
this.inherited(arguments), this.destroying && this.controls.length > 0 && this.isPanel(e) && (this.setIndex(Math.max(this.index - 1, 0)), this.flow(), this.reflow());
},
isPanel: function() {
return !0;
},
flow: function() {
this.arrangements = [], this.inherited(arguments);
},
reflow: function() {
this.arrangements = [], this.inherited(arguments), this.refresh();
},
getPanels: function() {
var e = this.controlParent || this;
return e.children;
},
getActive: function() {
var e = this.getPanels(), t = this.index % e.length;
return t < 0 && (t += e.length), e[t];
},
getAnimator: function() {
return this.$.animator;
},
setIndex: function(e) {
this.setPropertyValue("index", e, "indexChanged");
},
setIndexDirect: function(e) {
this.setIndex(e), this.completed();
},
previous: function() {
this.setIndex(this.index - 1);
},
next: function() {
this.setIndex(this.index + 1);
},
clamp: function(e) {
var t = this.getPanels().length - 1;
return this.wrap ? e : Math.max(0, Math.min(e, t));
},
indexChanged: function(e) {
this.lastIndex = e, this.index = this.clamp(this.index), !this.dragging && this.$.animator && (this.$.animator.isAnimating() && this.completed(), this.$.animator.stop(), this.hasNode() && (this.animate ? (this.startTransition(), this.$.animator.play({
startValue: this.fraction
})) : this.refresh()));
},
step: function(e) {
this.fraction = e.value, this.stepTransition();
},
completed: function() {
this.$.animator.isAnimating() && this.$.animator.stop(), this.fraction = 1, this.stepTransition(), this.finishTransition();
},
dragstart: function(e, t) {
if (this.draggable && this.layout && this.layout.canDragEvent(t)) return t.preventDefault(), this.dragstartTransition(t), this.dragging = !0, this.$.animator.stop(), !0;
},
drag: function(e, t) {
this.dragging && (t.preventDefault(), this.dragTransition(t));
},
dragfinish: function(e, t) {
this.dragging && (this.dragging = !1, t.preventTap(), this.dragfinishTransition(t));
},
dragstartTransition: function(e) {
if (!this.$.animator.isAnimating()) {
var t = this.fromIndex = this.index;
this.toIndex = t - (this.layout ? this.layout.calcDragDirection(e) : 0);
} else this.verifyDragTransition(e);
this.fromIndex = this.clamp(this.fromIndex), this.toIndex = this.clamp(this.toIndex), this.fireTransitionStart(), this.layout && this.layout.start();
},
dragTransition: function(e) {
var t = this.layout ? this.layout.calcDrag(e) : 0, n = this.transitionPoints, r = n[0], i = n[n.length - 1], s = this.fetchArrangement(r), o = this.fetchArrangement(i), u = this.layout ? this.layout.drag(t, r, s, i, o) : 0, a = t && !u;
a, this.fraction += u;
var f = this.fraction;
if (f > 1 || f < 0 || a) (f > 0 || a) && this.dragfinishTransition(e), this.dragstartTransition(e), this.fraction = 0;
this.stepTransition();
},
dragfinishTransition: function(e) {
this.verifyDragTransition(e), this.setIndex(this.toIndex), this.dragging && this.fireTransitionFinish();
},
verifyDragTransition: function(e) {
var t = this.layout ? this.layout.calcDragDirection(e) : 0, n = Math.min(this.fromIndex, this.toIndex), r = Math.max(this.fromIndex, this.toIndex);
if (t > 0) {
var i = n;
n = r, r = i;
}
n != this.fromIndex && (this.fraction = 1 - this.fraction), this.fromIndex = n, this.toIndex = r;
},
refresh: function() {
this.$.animator && this.$.animator.isAnimating() && this.$.animator.stop(), this.startTransition(), this.fraction = 1, this.stepTransition(), this.finishTransition();
},
startTransition: function() {
this.fromIndex = this.fromIndex != null ? this.fromIndex : this.lastIndex || 0, this.toIndex = this.toIndex != null ? this.toIndex : this.index, this.layout && this.layout.start(), this.fireTransitionStart();
},
finishTransition: function() {
this.layout && this.layout.finish(), this.transitionPoints = [], this.fraction = 0, this.fromIndex = this.toIndex = null, this.fireTransitionFinish();
},
fireTransitionStart: function() {
var e = this.startTransitionInfo;
this.hasNode() && (!e || e.fromIndex != this.fromIndex || e.toIndex != this.toIndex) && (this.startTransitionInfo = {
fromIndex: this.fromIndex,
toIndex: this.toIndex
}, this.doTransitionStart(enyo.clone(this.startTransitionInfo)));
},
fireTransitionFinish: function() {
var e = this.finishTransitionInfo;
this.hasNode() && (!e || e.fromIndex != this.lastIndex || e.toIndex != this.index) && (this.finishTransitionInfo = {
fromIndex: this.lastIndex,
toIndex: this.index
}, this.doTransitionFinish(enyo.clone(this.finishTransitionInfo))), this.lastIndex = this.index;
},
stepTransition: function() {
if (this.hasNode()) {
var e = this.transitionPoints, t = (this.fraction || 0) * (e.length - 1), n = Math.floor(t);
t -= n;
var r = e[n], i = e[n + 1], s = this.fetchArrangement(r), o = this.fetchArrangement(i);
this.arrangement = s && o ? enyo.Panels.lerp(s, o, t) : s || o, this.arrangement && this.layout && this.layout.flowArrangement();
}
},
fetchArrangement: function(e) {
return e != null && !this.arrangements[e] && this.layout && (this.layout._arrange(e), this.arrangements[e] = this.readArrangement(this.getPanels())), this.arrangements[e];
},
readArrangement: function(e) {
var t = [];
for (var n = 0, r = e, i; i = r[n]; n++) t.push(enyo.clone(i._arranger));
return t;
},
statics: {
isScreenNarrow: function() {
return enyo.dom.getWindowWidth() <= 800;
},
lerp: function(e, t, n) {
var r = [];
for (var i = 0, s = enyo.keys(e), o; o = s[i]; i++) r.push(this.lerpObject(e[o], t[o], n));
return r;
},
lerpObject: function(e, t, n) {
var r = enyo.clone(e), i, s;
if (t) for (var o in e) i = e[o], s = t[o], i != s && (r[o] = i - (i - s) * n);
return r;
}
}
});

// Node.js

enyo.kind({
name: "enyo.Node",
published: {
expandable: !1,
expanded: !1,
icon: "",
onlyIconExpands: !1,
selected: !1
},
style: "padding: 0 0 0 16px;",
content: "Node",
defaultKind: "Node",
classes: "enyo-node",
components: [ {
name: "icon",
kind: "Image",
showing: !1
}, {
kind: "Control",
name: "caption",
Xtag: "span",
style: "display: inline-block; padding: 4px;",
allowHtml: !0
}, {
kind: "Control",
name: "extra",
tag: "span",
allowHtml: !0
} ],
childClient: [ {
kind: "Control",
name: "box",
classes: "enyo-node-box",
Xstyle: "border: 1px solid orange;",
components: [ {
kind: "Control",
name: "client",
classes: "enyo-node-client",
Xstyle: "border: 1px solid lightblue;"
} ]
} ],
handlers: {
ondblclick: "dblclick"
},
events: {
onNodeTap: "nodeTap",
onNodeDblClick: "nodeDblClick",
onExpand: "nodeExpand",
onDestroyed: "nodeDestroyed"
},
create: function() {
this.inherited(arguments), this.selectedChanged(), this.iconChanged();
},
destroy: function() {
this.doDestroyed(), this.inherited(arguments);
},
initComponents: function() {
this.expandable && (this.kindComponents = this.kindComponents.concat(this.childClient)), this.inherited(arguments);
},
contentChanged: function() {
this.$.caption.setContent(this.content);
},
iconChanged: function() {
this.$.icon.setSrc(this.icon), this.$.icon.setShowing(Boolean(this.icon));
},
selectedChanged: function() {
this.addRemoveClass("enyo-selected", this.selected);
},
rendered: function() {
this.inherited(arguments), this.expandable && !this.expanded && this.quickCollapse();
},
addNodes: function(e) {
this.destroyClientControls();
for (var t = 0, n; n = e[t]; t++) this.createComponent(n);
this.$.client.render();
},
addTextNodes: function(e) {
this.destroyClientControls();
for (var t = 0, n; n = e[t]; t++) this.createComponent({
content: n
});
this.$.client.render();
},
tap: function(e, t) {
return this.onlyIconExpands ? t.target == this.$.icon.hasNode() ? this.toggleExpanded() : this.doNodeTap() : (this.toggleExpanded(), this.doNodeTap()), !0;
},
dblclick: function(e, t) {
return this.doNodeDblClick(), !0;
},
toggleExpanded: function() {
this.setExpanded(!this.expanded);
},
quickCollapse: function() {
this.removeClass("enyo-animate"), this.$.box.applyStyle("height", "0");
var e = this.$.client.getBounds().height;
this.$.client.setBounds({
top: -e
});
},
_expand: function() {
this.addClass("enyo-animate");
var e = this.$.client.getBounds().height;
this.$.box.setBounds({
height: e
}), this.$.client.setBounds({
top: 0
}), setTimeout(enyo.bind(this, function() {
this.expanded && (this.removeClass("enyo-animate"), this.$.box.applyStyle("height", "auto"));
}), 225);
},
_collapse: function() {
this.removeClass("enyo-animate");
var e = this.$.client.getBounds().height;
this.$.box.setBounds({
height: e
}), setTimeout(enyo.bind(this, function() {
this.addClass("enyo-animate"), this.$.box.applyStyle("height", "0"), this.$.client.setBounds({
top: -e
});
}), 25);
},
expandedChanged: function(e) {
if (!this.expandable) this.expanded = !1; else {
var t = {
expanded: this.expanded
};
this.doExpand(t), t.wait || this.effectExpanded();
}
},
effectExpanded: function() {
this.$.client && (this.expanded ? this._expand() : this._collapse());
}
});

// ImageViewPin.js

enyo.kind({
name: "enyo.ImageViewPin",
kind: "enyo.Control",
published: {
highlightAnchorPoint: !1,
anchor: {
top: 0,
left: 0
},
position: {
top: 0,
left: 0
}
},
style: "position:absolute;z-index:1000;width:0px;height:0px;",
handlers: {
onPositionPin: "reAnchor"
},
create: function() {
this.inherited(arguments), this.styleClientControls(), this.positionClientControls(), this.highlightAnchorPointChanged(), this.anchorChanged();
},
styleClientControls: function() {
var e = this.getClientControls();
for (var t = 0; t < e.length; t++) e[t].applyStyle("position", "absolute");
},
positionClientControls: function() {
var e = this.getClientControls();
for (var t = 0; t < e.length; t++) for (var n in this.position) e[t].applyStyle(n, this.position[n] + "px");
},
highlightAnchorPointChanged: function() {
this.addRemoveClass("pinDebug", this.highlightAnchorPoint);
},
anchorChanged: function() {
var e = null, t = null;
for (t in this.anchor) {
e = this.anchor[t].toString().match(/^(\d+(?:\.\d+)?)(.*)$/);
if (!e) continue;
this.anchor[t + "Coords"] = {
value: e[1],
units: e[2] || "px"
};
}
},
reAnchor: function(e, t) {
var n = t.scale, r = t.bounds, i = this.anchor.right ? this.anchor.rightCoords.units == "px" ? r.width + r.x - this.anchor.rightCoords.value * n : r.width * (100 - this.anchor.rightCoords.value) / 100 + r.x : this.anchor.leftCoords.units == "px" ? this.anchor.leftCoords.value * n + r.x : r.width * this.anchor.leftCoords.value / 100 + r.x, s = this.anchor.bottom ? this.anchor.bottomCoords.units == "px" ? r.height + r.y - this.anchor.bottomCoords.value * n : r.height * (100 - this.anchor.bottomCoords.value) / 100 + r.y : this.anchor.topCoords.units == "px" ? this.anchor.topCoords.value * n + r.y : r.height * this.anchor.topCoords.value / 100 + r.y;
this.applyStyle("left", i + "px"), this.applyStyle("top", s + "px");
}
});

// ImageView.js

enyo.kind({
name: "enyo.ImageView",
kind: enyo.Scroller,
touchOverscroll: !1,
thumb: !1,
animate: !0,
verticalDragPropagation: !0,
horizontalDragPropagation: !0,
published: {
scale: "auto",
disableZoom: !1,
src: undefined
},
events: {
onZoom: ""
},
touch: !0,
preventDragPropagation: !1,
handlers: {
ondragstart: "dragPropagation"
},
components: [ {
name: "animator",
kind: "Animator",
onStep: "zoomAnimationStep",
onEnd: "zoomAnimationEnd"
}, {
name: "viewport",
style: "overflow:hidden;min-height:100%;min-width:100%;",
classes: "enyo-fit",
ongesturechange: "gestureTransform",
ongestureend: "saveState",
ontap: "singleTap",
ondblclick: "doubleClick",
onmousewheel: "mousewheel",
components: [ {
kind: "Image",
ondown: "down"
} ]
} ],
create: function() {
this.inherited(arguments), this.canTransform = enyo.dom.canTransform(), this.canTransform || this.$.image.applyStyle("position", "relative"), this.canAccelerate = enyo.dom.canAccelerate(), this.bufferImage = new Image, this.bufferImage.onload = enyo.bind(this, "imageLoaded"), this.bufferImage.onerror = enyo.bind(this, "imageError"), this.srcChanged(), this.getStrategy().setDragDuringGesture(!1), this.getStrategy().$.scrollMath && this.getStrategy().$.scrollMath.start();
},
down: function(e, t) {
t.preventDefault();
},
dragPropagation: function(e, t) {
var n = this.getStrategy().getScrollBounds(), r = n.top === 0 && t.dy > 0 || n.top >= n.maxTop - 2 && t.dy < 0, i = n.left === 0 && t.dx > 0 || n.left >= n.maxLeft - 2 && t.dx < 0;
return !(r && this.verticalDragPropagation || i && this.horizontalDragPropagation);
},
mousewheel: function(e, t) {
t.pageX |= t.clientX + t.target.scrollLeft, t.pageY |= t.clientY + t.target.scrollTop;
var n = (this.maxScale - this.minScale) / 10, r = this.scale;
if (t.wheelDelta > 0 || t.detail < 0) this.scale = this.limitScale(this.scale + n); else if (t.wheelDelta < 0 || t.detail > 0) this.scale = this.limitScale(this.scale - n);
return this.eventPt = this.calcEventLocation(t), this.transformImage(this.scale), r != this.scale && this.doZoom({
scale: this.scale
}), this.ratioX = this.ratioY = null, t.preventDefault(), !0;
},
srcChanged: function() {
this.src && this.src.length > 0 && this.bufferImage && this.src != this.bufferImage.src && (this.bufferImage.src = this.src);
},
imageLoaded: function(e) {
this.originalWidth = this.bufferImage.width, this.originalHeight = this.bufferImage.height, this.scaleChanged(), this.$.image.setSrc(this.bufferImage.src), enyo.dom.transformValue(this.getStrategy().$.client, "translate3d", "0px, 0px, 0"), this.positionClientControls(this.scale), this.alignImage();
},
resizeHandler: function() {
this.inherited(arguments), this.$.image.src && this.scaleChanged();
},
scaleChanged: function() {
var e = this.hasNode();
if (e) {
this.containerWidth = e.clientWidth, this.containerHeight = e.clientHeight;
var t = this.containerWidth / this.originalWidth, n = this.containerHeight / this.originalHeight;
this.minScale = Math.min(t, n), this.maxScale = this.minScale * 3 < 1 ? 1 : this.minScale * 3, this.scale == "auto" ? this.scale = this.minScale : this.scale == "width" ? this.scale = t : this.scale == "height" ? this.scale = n : this.scale == "fit" ? (this.fitAlignment = "center", this.scale = Math.max(t, n)) : (this.maxScale = Math.max(this.maxScale, this.scale), this.scale = this.limitScale(this.scale));
}
this.eventPt = this.calcEventLocation(), this.transformImage(this.scale);
},
imageError: function(e) {
enyo.error("Error loading image: " + this.src), this.bubble("onerror", e);
},
alignImage: function() {
if (this.fitAlignment && this.fitAlignment === "center") {
var e = this.getScrollBounds();
this.setScrollLeft(e.maxLeft / 2), this.setScrollTop(e.maxTop / 2);
}
},
gestureTransform: function(e, t) {
this.eventPt = this.calcEventLocation(t), this.transformImage(this.limitScale(this.scale * t.scale));
},
calcEventLocation: function(e) {
var t = {
x: 0,
y: 0
};
if (e && this.hasNode()) {
var n = this.node.getBoundingClientRect();
t.x = Math.round(e.pageX - n.left - this.imageBounds.x), t.x = Math.max(0, Math.min(this.imageBounds.width, t.x)), t.y = Math.round(e.pageY - n.top - this.imageBounds.y), t.y = Math.max(0, Math.min(this.imageBounds.height, t.y));
}
return t;
},
transformImage: function(e) {
this.tapped = !1;
var t = this.imageBounds || this.innerImageBounds(e);
this.imageBounds = this.innerImageBounds(e), this.scale > this.minScale ? this.$.viewport.applyStyle("cursor", "move") : this.$.viewport.applyStyle("cursor", null), this.$.viewport.setBounds({
width: this.imageBounds.width + "px",
height: this.imageBounds.height + "px"
}), this.ratioX = this.ratioX || (this.eventPt.x + this.getScrollLeft()) / t.width, this.ratioY = this.ratioY || (this.eventPt.y + this.getScrollTop()) / t.height;
var n, r;
this.$.animator.ratioLock ? (n = this.$.animator.ratioLock.x * this.imageBounds.width - this.containerWidth / 2, r = this.$.animator.ratioLock.y * this.imageBounds.height - this.containerHeight / 2) : (n = this.ratioX * this.imageBounds.width - this.eventPt.x, r = this.ratioY * this.imageBounds.height - this.eventPt.y), n = Math.max(0, Math.min(this.imageBounds.width - this.containerWidth, n)), r = Math.max(0, Math.min(this.imageBounds.height - this.containerHeight, r));
if (this.canTransform) {
var i = {
scale: e
};
this.canAccelerate ? i = enyo.mixin({
translate3d: Math.round(this.imageBounds.left) + "px, " + Math.round(this.imageBounds.top) + "px, 0px"
}, i) : i = enyo.mixin({
translate: this.imageBounds.left + "px, " + this.imageBounds.top + "px"
}, i), enyo.dom.transform(this.$.image, i);
} else this.$.image.setBounds({
width: this.imageBounds.width + "px",
height: this.imageBounds.height + "px",
left: this.imageBounds.left + "px",
top: this.imageBounds.top + "px"
});
this.setScrollLeft(n), this.setScrollTop(r), this.positionClientControls(e);
},
limitScale: function(e) {
return this.disableZoom ? e = this.scale : e > this.maxScale ? e = this.maxScale : e < this.minScale && (e = this.minScale), e;
},
innerImageBounds: function(e) {
var t = this.originalWidth * e, n = this.originalHeight * e, r = {
x: 0,
y: 0,
transX: 0,
transY: 0
};
return t < this.containerWidth && (r.x += (this.containerWidth - t) / 2), n < this.containerHeight && (r.y += (this.containerHeight - n) / 2), this.canTransform && (r.transX -= (this.originalWidth - t) / 2, r.transY -= (this.originalHeight - n) / 2), {
left: r.x + r.transX,
top: r.y + r.transY,
width: t,
height: n,
x: r.x,
y: r.y
};
},
saveState: function(e, t) {
var n = this.scale;
this.scale *= t.scale, this.scale = this.limitScale(this.scale), n != this.scale && this.doZoom({
scale: this.scale
}), this.ratioX = this.ratioY = null;
},
doubleClick: function(e, t) {
enyo.platform.ie == 8 && (this.tapped = !0, t.pageX = t.clientX + t.target.scrollLeft, t.pageY = t.clientY + t.target.scrollTop, this.singleTap(e, t), t.preventDefault());
},
singleTap: function(e, t) {
setTimeout(enyo.bind(this, function() {
this.tapped = !1;
}), 300), this.tapped ? (this.tapped = !1, this.smartZoom(e, t)) : this.tapped = !0;
},
smartZoom: function(e, t) {
var n = this.hasNode(), r = this.$.image.hasNode();
if (n && r && this.hasNode() && !this.disableZoom) {
var i = this.scale;
this.scale != this.minScale ? this.scale = this.minScale : this.scale = this.maxScale, this.eventPt = this.calcEventLocation(t);
if (this.animate) {
var s = {
x: (this.eventPt.x + this.getScrollLeft()) / this.imageBounds.width,
y: (this.eventPt.y + this.getScrollTop()) / this.imageBounds.height
};
this.$.animator.play({
duration: 350,
ratioLock: s,
baseScale: i,
deltaScale: this.scale - i
});
} else this.transformImage(this.scale), this.doZoom({
scale: this.scale
});
}
},
zoomAnimationStep: function(e, t) {
var n = this.$.animator.baseScale + this.$.animator.deltaScale * this.$.animator.value;
this.transformImage(n);
},
zoomAnimationEnd: function(e, t) {
this.doZoom({
scale: this.scale
}), this.$.animator.ratioLock = undefined;
},
positionClientControls: function(e) {
this.waterfallDown("onPositionPin", {
scale: e,
bounds: this.imageBounds
});
}
});

// ImageCarousel.js

enyo.kind({
name: "enyo.ImageCarousel",
kind: enyo.Panels,
arrangerKind: "enyo.CarouselArranger",
defaultScale: "auto",
disableZoom: !1,
lowMemory: !1,
published: {
images: []
},
handlers: {
onTransitionStart: "transitionStart",
onTransitionFinish: "transitionFinish"
},
create: function() {
this.inherited(arguments), this.imageCount = this.images.length, this.images.length > 0 && (this.initContainers(), this.loadNearby());
},
initContainers: function() {
for (var e = 0; e < this.images.length; e++) this.$["container" + e] || (this.createComponent({
name: "container" + e,
style: "height:100%; width:100%;"
}), this.$["container" + e].render());
for (e = this.images.length; e < this.imageCount; e++) this.$["image" + e] && this.$["image" + e].destroy(), this.$["container" + e].destroy();
this.imageCount = this.images.length;
},
loadNearby: function() {
var e = this.getBufferRange();
for (var t in e) this.loadImageView(e[t]);
},
getBufferRange: function() {
var e = [];
if (this.layout.containerBounds) {
var t = 1, n = this.layout.containerBounds, r, i, s, o, u, a;
o = this.index - 1, u = 0, a = n.width * t;
while (o >= 0 && u <= a) s = this.$["container" + o], u += s.width + s.marginWidth, e.unshift(o), o--;
o = this.index, u = 0, a = n.width * (t + 1);
while (o < this.images.length && u <= a) s = this.$["container" + o], u += s.width + s.marginWidth, e.push(o), o++;
}
return e;
},
reflow: function() {
this.inherited(arguments), this.loadNearby();
},
loadImageView: function(e) {
return this.wrap && (e = (e % this.images.length + this.images.length) % this.images.length), e >= 0 && e <= this.images.length - 1 && (this.$["image" + e] ? this.$["image" + e].src != this.images[e] && (this.$["image" + e].setSrc(this.images[e]), this.$["image" + e].setScale(this.defaultScale), this.$["image" + e].setDisableZoom(this.disableZoom)) : (this.$["container" + e].createComponent({
name: "image" + e,
kind: "ImageView",
scale: this.defaultScale,
disableZoom: this.disableZoom,
src: this.images[e],
verticalDragPropagation: !1,
style: "height:100%; width:100%;"
}, {
owner: this
}), this.$["image" + e].render())), this.$["image" + e];
},
setImages: function(e) {
this.setPropertyValue("images", e, "imagesChanged");
},
imagesChanged: function() {
this.initContainers(), this.loadNearby();
},
indexChanged: function() {
this.loadNearby(), this.lowMemory && this.cleanupMemory(), this.inherited(arguments);
},
transitionStart: function(e, t) {
if (t.fromIndex == t.toIndex) return !0;
},
transitionFinish: function(e, t) {
this.loadNearby(), this.lowMemory && this.cleanupMemory();
},
getActiveImage: function() {
return this.getImageByIndex(this.index);
},
getImageByIndex: function(e) {
return this.$["image" + e] || this.loadImageView(e);
},
cleanupMemory: function() {
var e = getBufferRange();
for (var t = 0; t < this.images.length; t++) enyo.indexOf(t, e) === -1 && this.$["image" + t] && this.$["image" + t].destroy();
}
});

// Icon.js

enyo.kind({
name: "onyx.Icon",
published: {
src: "",
disabled: !1
},
classes: "onyx-icon",
create: function() {
this.inherited(arguments), this.src && this.srcChanged(), this.disabledChanged();
},
disabledChanged: function() {
this.addRemoveClass("disabled", this.disabled);
},
srcChanged: function() {
this.applyStyle("background-image", "url(" + enyo.path.rewrite(this.src) + ")");
}
});

// Button.js

enyo.kind({
name: "onyx.Button",
kind: "enyo.Button",
classes: "onyx-button enyo-unselectable",
create: function() {
enyo.platform.firefoxOS && (this.handlers.ondown = "down", this.handlers.onleave = "leave"), this.inherited(arguments);
},
down: function(e, t) {
this.addClass("pressed");
},
leave: function(e, t) {
this.removeClass("pressed");
}
});

// IconButton.js

enyo.kind({
name: "onyx.IconButton",
kind: "onyx.Icon",
published: {
active: !1
},
classes: "onyx-icon-button",
create: function() {
enyo.platform.firefoxOS && (this.handlers.ondown = "down", this.handlers.onleave = "leave"), this.inherited(arguments);
},
down: function(e, t) {
this.addClass("pressed");
},
leave: function(e, t) {
this.removeClass("pressed");
},
rendered: function() {
this.inherited(arguments), this.activeChanged();
},
tap: function() {
if (this.disabled) return !0;
this.setActive(!0);
},
activeChanged: function() {
this.bubble("onActivate");
}
});

// Checkbox.js

enyo.kind({
name: "onyx.Checkbox",
classes: "onyx-checkbox",
kind: enyo.Checkbox,
tag: "div",
handlers: {
onclick: ""
},
tap: function(e, t) {
return this.disabled || (this.setChecked(!this.getChecked()), this.bubble("onchange")), !this.disabled;
},
dragstart: function() {}
});

// Drawer.js

enyo.kind({
name: "onyx.Drawer",
published: {
open: !0,
orient: "v",
animated: !0
},
style: "overflow: hidden; position: relative;",
tools: [ {
kind: "Animator",
onStep: "animatorStep",
onEnd: "animatorEnd"
}, {
name: "client",
style: "position: relative;",
classes: "enyo-border-box"
} ],
create: function() {
this.inherited(arguments), this.animatedChanged(), this.openChanged();
},
initComponents: function() {
this.createChrome(this.tools), this.inherited(arguments);
},
animatedChanged: function() {
!this.animated && this.hasNode() && this.$.animator.isAnimating() && (this.$.animator.stop(), this.animatorEnd());
},
openChanged: function() {
this.$.client.show();
if (this.hasNode()) if (this.$.animator.isAnimating()) this.$.animator.reverse(); else {
var e = this.orient == "v", t = e ? "height" : "width", n = e ? "top" : "left";
this.applyStyle(t, null);
var r = this.hasNode()[e ? "scrollHeight" : "scrollWidth"];
this.animated ? this.$.animator.play({
startValue: this.open ? 0 : r,
endValue: this.open ? r : 0,
dimension: t,
position: n
}) : this.animatorEnd();
} else this.$.client.setShowing(this.open);
},
animatorStep: function(e) {
if (this.hasNode()) {
var t = e.dimension;
this.node.style[t] = this.domStyles[t] = e.value + "px";
}
var n = this.$.client.hasNode();
if (n) {
var r = e.position, i = this.open ? e.endValue : e.startValue;
n.style[r] = this.$.client.domStyles[r] = e.value - i + "px";
}
this.container && this.container.resized();
},
animatorEnd: function() {
if (!this.open) this.$.client.hide(); else {
this.$.client.domCssText = enyo.Control.domStylesToCssText(this.$.client.domStyles);
var e = this.orient == "v", t = e ? "height" : "width", n = e ? "top" : "left", r = this.$.client.hasNode();
r && (r.style[n] = this.$.client.domStyles[n] = null), this.node && (this.node.style[t] = this.domStyles[t] = null);
}
this.container && this.container.resized();
}
});

// Grabber.js

enyo.kind({
name: "onyx.Grabber",
classes: "onyx-grabber"
});

// Groupbox.js

enyo.kind({
name: "onyx.Groupbox",
classes: "onyx-groupbox"
}), enyo.kind({
name: "onyx.GroupboxHeader",
classes: "onyx-groupbox-header"
});

// Input.js

enyo.kind({
name: "onyx.Input",
kind: "enyo.Input",
classes: "onyx-input"
});

// Popup.js

enyo.kind({
name: "onyx.Popup",
kind: "Popup",
classes: "onyx-popup",
published: {
scrimWhenModal: !0,
scrim: !1,
scrimClassName: ""
},
statics: {
count: 0
},
defaultZ: 120,
showingChanged: function() {
this.showing ? (onyx.Popup.count++, this.applyZIndex()) : onyx.Popup.count > 0 && onyx.Popup.count--, this.showHideScrim(this.showing), this.inherited(arguments);
},
showHideScrim: function(e) {
if (this.floating && (this.scrim || this.modal && this.scrimWhenModal)) {
var t = this.getScrim();
if (e) {
var n = this.getScrimZIndex();
this._scrimZ = n, t.showAtZIndex(n);
} else t.hideAtZIndex(this._scrimZ);
enyo.call(t, "addRemoveClass", [ this.scrimClassName, t.showing ]);
}
},
getScrimZIndex: function() {
return this.findZIndex() - 1;
},
getScrim: function() {
return this.modal && this.scrimWhenModal && !this.scrim ? onyx.scrimTransparent.make() : onyx.scrim.make();
},
applyZIndex: function() {
this._zIndex = onyx.Popup.count * 2 + this.findZIndex() + 1, this.applyStyle("z-index", this._zIndex);
},
findZIndex: function() {
var e = this.defaultZ;
return this._zIndex ? e = this._zIndex : this.hasNode() && (e = Number(enyo.dom.getComputedStyleValue(this.node, "z-index")) || e), this._zIndex = e;
}
});

// TextArea.js

enyo.kind({
name: "onyx.TextArea",
kind: "enyo.TextArea",
classes: "onyx-textarea"
});

// RichText.js

enyo.kind({
name: "onyx.RichText",
kind: "enyo.RichText",
classes: "onyx-richtext"
});

// InputDecorator.js

enyo.kind({
name: "onyx.InputDecorator",
kind: "enyo.ToolDecorator",
tag: "label",
classes: "onyx-input-decorator",
published: {
alwaysLooksFocused: !1
},
handlers: {
onDisabledChange: "disabledChange",
onfocus: "receiveFocus",
onblur: "receiveBlur"
},
create: function() {
this.inherited(arguments), this.updateFocus(!1);
},
alwaysLooksFocusedChanged: function(e) {
this.updateFocus(this.focus);
},
updateFocus: function(e) {
this.focused = e, this.addRemoveClass("onyx-focused", this.alwaysLooksFocused || this.focused);
},
receiveFocus: function() {
this.updateFocus(!0);
},
receiveBlur: function() {
this.updateFocus(!1);
},
disabledChange: function(e, t) {
this.addRemoveClass("onyx-disabled", t.originator.disabled);
}
});

// Tooltip.js

enyo.kind({
name: "onyx.Tooltip",
kind: "onyx.Popup",
classes: "onyx-tooltip below left-arrow",
autoDismiss: !1,
showDelay: 500,
defaultLeft: -6,
handlers: {
onRequestShowTooltip: "requestShow",
onRequestHideTooltip: "requestHide"
},
requestShow: function() {
return this.showJob = setTimeout(enyo.bind(this, "show"), this.showDelay), !0;
},
cancelShow: function() {
clearTimeout(this.showJob);
},
requestHide: function() {
return this.cancelShow(), this.inherited(arguments);
},
showingChanged: function() {
this.cancelShow(), this.adjustPosition(!0), this.inherited(arguments);
},
applyPosition: function(e) {
var t = "";
for (var n in e) t += n + ":" + e[n] + (isNaN(e[n]) ? "; " : "px; ");
this.addStyles(t);
},
adjustPosition: function(e) {
if (this.showing && this.hasNode()) {
var t = this.node.getBoundingClientRect();
t.top + t.height > window.innerHeight ? (this.addRemoveClass("below", !1), this.addRemoveClass("above", !0)) : (this.addRemoveClass("above", !1), this.addRemoveClass("below", !0)), t.left + t.width > window.innerWidth && (this.applyPosition({
"margin-left": -t.width,
bottom: "auto"
}), this.addRemoveClass("left-arrow", !1), this.addRemoveClass("right-arrow", !0));
}
},
resizeHandler: function() {
this.applyPosition({
"margin-left": this.defaultLeft,
bottom: "auto"
}), this.addRemoveClass("left-arrow", !0), this.addRemoveClass("right-arrow", !1), this.adjustPosition(!0), this.inherited(arguments);
}
});

// TooltipDecorator.js

enyo.kind({
name: "onyx.TooltipDecorator",
defaultKind: "onyx.Button",
classes: "onyx-popup-decorator",
handlers: {
onenter: "enter",
onleave: "leave"
},
enter: function() {
this.requestShowTooltip();
},
leave: function() {
this.requestHideTooltip();
},
tap: function() {
this.requestHideTooltip();
},
requestShowTooltip: function() {
this.waterfallDown("onRequestShowTooltip");
},
requestHideTooltip: function() {
this.waterfallDown("onRequestHideTooltip");
}
});

// MenuDecorator.js

enyo.kind({
name: "onyx.MenuDecorator",
kind: "onyx.TooltipDecorator",
defaultKind: "onyx.Button",
classes: "onyx-popup-decorator enyo-unselectable",
handlers: {
onActivate: "activated",
onHide: "menuHidden"
},
activated: function(e, t) {
this.requestHideTooltip(), t.originator.active && (this.menuActive = !0, this.activator = t.originator, this.activator.addClass("active"), this.requestShowMenu());
},
requestShowMenu: function() {
this.waterfallDown("onRequestShowMenu", {
activator: this.activator
});
},
requestHideMenu: function() {
this.waterfallDown("onRequestHideMenu");
},
menuHidden: function() {
this.menuActive = !1, this.activator && (this.activator.setActive(!1), this.activator.removeClass("active"));
},
enter: function(e) {
this.menuActive || this.inherited(arguments);
},
leave: function(e, t) {
this.menuActive || this.inherited(arguments);
}
});

// Menu.js

enyo.kind({
name: "onyx.Menu",
kind: "onyx.Popup",
modal: !0,
defaultKind: "onyx.MenuItem",
classes: "onyx-menu",
published: {
maxHeight: 200,
scrolling: !0
},
handlers: {
onActivate: "itemActivated",
onRequestShowMenu: "requestMenuShow",
onRequestHideMenu: "requestHide"
},
childComponents: [ {
name: "client",
kind: "enyo.Scroller",
strategyKind: "TouchScrollStrategy"
} ],
showOnTop: !1,
scrollerName: "client",
create: function() {
this.inherited(arguments), this.maxHeightChanged();
},
initComponents: function() {
this.scrolling && this.createComponents(this.childComponents, {
isChrome: !0
}), this.inherited(arguments);
},
getScroller: function() {
return this.$[this.scrollerName];
},
maxHeightChanged: function() {
this.scrolling && this.getScroller().setMaxHeight(this.maxHeight + "px");
},
itemActivated: function(e, t) {
return t.originator.setActive(!1), !0;
},
showingChanged: function() {
this.inherited(arguments), this.scrolling && this.getScroller().setShowing(this.showing), this.adjustPosition(!0);
},
requestMenuShow: function(e, t) {
if (this.floating) {
var n = t.activator.hasNode();
if (n) {
var r = this.activatorOffset = this.getPageOffset(n);
this.applyPosition({
top: r.top + (this.showOnTop ? 0 : r.height),
left: r.left,
width: r.width
});
}
}
return this.show(), !0;
},
applyPosition: function(e) {
var t = "";
for (var n in e) t += n + ":" + e[n] + (isNaN(e[n]) ? "; " : "px; ");
this.addStyles(t);
},
getPageOffset: function(e) {
var t = e.getBoundingClientRect(), n = window.pageYOffset === undefined ? document.documentElement.scrollTop : window.pageYOffset, r = window.pageXOffset === undefined ? document.documentElement.scrollLeft : window.pageXOffset, i = t.height === undefined ? t.bottom - t.top : t.height, s = t.width === undefined ? t.right - t.left : t.width;
return {
top: t.top + n,
left: t.left + r,
height: i,
width: s
};
},
adjustPosition: function() {
if (this.showing && this.hasNode()) {
this.scrolling && !this.showOnTop && this.getScroller().setMaxHeight(this.maxHeight + "px"), this.removeClass("onyx-menu-up"), this.floating || this.applyPosition({
left: "auto"
});
var e = this.node.getBoundingClientRect(), t = e.height === undefined ? e.bottom - e.top : e.height, n = window.innerHeight === undefined ? document.documentElement.clientHeight : window.innerHeight, r = window.innerWidth === undefined ? document.documentElement.clientWidth : window.innerWidth;
this.menuUp = e.top + t > n && n - e.bottom < e.top - t, this.addRemoveClass("onyx-menu-up", this.menuUp);
if (this.floating) {
var i = this.activatorOffset;
this.menuUp ? this.applyPosition({
top: i.top - t + (this.showOnTop ? i.height : 0),
bottom: "auto"
}) : e.top < i.top && i.top + (this.showOnTop ? 0 : i.height) + t < n && this.applyPosition({
top: i.top + (this.showOnTop ? 0 : i.height),
bottom: "auto"
});
}
e.right > r && (this.floating ? this.applyPosition({
left: r - e.width
}) : this.applyPosition({
left: -(e.right - r)
})), e.left < 0 && (this.floating ? this.applyPosition({
left: 0,
right: "auto"
}) : this.getComputedStyleValue("right") == "auto" ? this.applyPosition({
left: -e.left
}) : this.applyPosition({
right: e.left
}));
if (this.scrolling && !this.showOnTop) {
e = this.node.getBoundingClientRect();
var s;
this.menuUp ? s = this.maxHeight < e.bottom ? this.maxHeight : e.bottom : s = e.top + this.maxHeight < n ? this.maxHeight : n - e.top, this.getScroller().setMaxHeight(s + "px");
}
}
},
resizeHandler: function() {
this.inherited(arguments), this.adjustPosition();
},
requestHide: function() {
this.setShowing(!1);
}
});

// MenuItem.js

enyo.kind({
name: "onyx.MenuItem",
kind: "enyo.Button",
events: {
onSelect: "",
onItemContentChange: ""
},
classes: "onyx-menu-item",
tag: "div",
create: function() {
this.inherited(arguments), this.active && this.bubble("onActivate");
},
tap: function(e) {
this.inherited(arguments), this.bubble("onRequestHideMenu"), this.doSelect({
selected: this,
content: this.content
});
},
contentChanged: function(e) {
this.inherited(arguments), this.doItemContentChange({
content: this.content
});
}
});

// PickerDecorator.js

enyo.kind({
name: "onyx.PickerDecorator",
kind: "onyx.MenuDecorator",
classes: "onyx-picker-decorator",
defaultKind: "onyx.PickerButton",
handlers: {
onChange: "change"
},
change: function(e, t) {
this.waterfallDown("onChange", t);
}
});

// PickerButton.js

enyo.kind({
name: "onyx.PickerButton",
kind: "onyx.Button",
handlers: {
onChange: "change"
},
change: function(e, t) {
t.content !== undefined && this.setContent(t.content);
}
});

// Picker.js

enyo.kind({
name: "onyx.Picker",
kind: "onyx.Menu",
classes: "onyx-picker enyo-unselectable",
published: {
selected: null
},
events: {
onChange: ""
},
handlers: {
onItemContentChange: "itemContentChange"
},
floating: !0,
showOnTop: !0,
initComponents: function() {
this.setScrolling(!0), this.inherited(arguments);
},
showingChanged: function() {
this.getScroller().setShowing(this.showing), this.inherited(arguments), this.showing && this.selected && this.scrollToSelected();
},
scrollToSelected: function() {
this.getScroller().scrollToControl(this.selected, !this.menuUp);
},
itemActivated: function(e, t) {
return this.processActivatedItem(t.originator), this.inherited(arguments);
},
processActivatedItem: function(e) {
e.active && this.setSelected(e);
},
selectedChanged: function(e) {
e && e.removeClass("selected"), this.selected && (this.selected.addClass("selected"), this.doChange({
selected: this.selected,
content: this.selected.content
}));
},
itemContentChange: function(e, t) {
t.originator == this.selected && this.doChange({
selected: this.selected,
content: this.selected.content
});
},
resizeHandler: function() {
this.inherited(arguments), this.adjustPosition();
}
});

// FlyweightPicker.js

enyo.kind({
name: "onyx.FlyweightPicker",
kind: "onyx.Picker",
classes: "onyx-flyweight-picker",
published: {
count: 0
},
events: {
onSetupItem: "",
onSelect: ""
},
handlers: {
onSelect: "itemSelect"
},
components: [ {
name: "scroller",
kind: "enyo.Scroller",
strategyKind: "TouchScrollStrategy",
components: [ {
name: "flyweight",
kind: "FlyweightRepeater",
noSelect: !0,
ontap: "itemTap"
} ]
} ],
scrollerName: "scroller",
initComponents: function() {
this.controlParentName = "flyweight", this.inherited(arguments), this.$.flyweight.$.client.children[0].setActive(!0);
},
create: function() {
this.inherited(arguments), this.countChanged();
},
rendered: function() {
this.inherited(arguments), this.selectedChanged();
},
scrollToSelected: function() {
var e = this.$.flyweight.fetchRowNode(this.selected);
this.getScroller().scrollToNode(e, !this.menuUp);
},
countChanged: function() {
this.$.flyweight.count = this.count;
},
processActivatedItem: function(e) {
this.item = e;
},
selectedChanged: function(e) {
if (!this.item) return;
e != null && (this.item.removeClass("selected"), this.$.flyweight.renderRow(e));
var t;
this.selected != null && (this.item.addClass("selected"), this.$.flyweight.renderRow(this.selected), this.item.removeClass("selected"), t = this.$.flyweight.fetchRowNode(this.selected)), this.doChange({
selected: this.selected,
content: t && t.textContent || this.item.content
});
},
itemTap: function(e, t) {
this.setSelected(t.rowIndex), this.doSelect({
selected: this.item,
content: this.item.content
});
},
itemSelect: function(e, t) {
if (t.originator != this) return !0;
}
});

// DatePicker.js

enyo.kind({
name: "onyx.DatePicker",
classes: "onyx-toolbar-inline",
published: {
disabled: !1,
locale: "en_us",
dayHidden: !1,
monthHidden: !1,
yearHidden: !1,
minYear: 1900,
maxYear: 2099,
value: null
},
events: {
onSelect: ""
},
create: function() {
this.inherited(arguments), enyo.g11n && (this.locale = enyo.g11n.currentLocale().getLocale()), this.initDefaults();
},
initDefaults: function() {
var e = [ "JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC" ];
enyo.g11n && (this._tf = new enyo.g11n.Fmts({
locale: this.locale
}), e = this._tf.getMonthFields()), this.setupPickers(this._tf ? this._tf.getDateFieldOrder() : "mdy"), this.dayHiddenChanged(), this.monthHiddenChanged(), this.yearHiddenChanged();
var t = this.value = this.value || new Date;
for (var n = 0, r; r = e[n]; n++) this.$.monthPicker.createComponent({
content: r,
value: n,
active: n == t.getMonth()
});
var i = t.getFullYear();
this.$.yearPicker.setSelected(i - this.minYear);
for (n = 1; n <= this.monthLength(t.getYear(), t.getMonth()); n++) this.$.dayPicker.createComponent({
content: n,
value: n,
active: n == t.getDate()
});
},
monthLength: function(e, t) {
return 32 - (new Date(e, t, 32)).getDate();
},
setupYear: function(e, t) {
this.$.year.setContent(this.minYear + t.index);
},
setupPickers: function(e) {
var t = e.split(""), n, r, i;
for (r = 0, i = t.length; r < i; r++) {
n = t[r];
switch (n) {
case "d":
this.createDay();
break;
case "m":
this.createMonth();
break;
case "y":
this.createYear();
break;
default:
}
}
},
createYear: function() {
var e = this.maxYear - this.minYear;
this.createComponent({
kind: "onyx.PickerDecorator",
onSelect: "updateYear",
components: [ {
classes: "onyx-datepicker-year",
name: "yearPickerButton",
disabled: this.disabled
}, {
name: "yearPicker",
kind: "onyx.FlyweightPicker",
count: ++e,
onSetupItem: "setupYear",
components: [ {
name: "year"
} ]
} ]
});
},
createMonth: function() {
this.createComponent({
kind: "onyx.PickerDecorator",
onSelect: "updateMonth",
components: [ {
classes: "onyx-datepicker-month",
name: "monthPickerButton",
disabled: this.disabled
}, {
name: "monthPicker",
kind: "onyx.Picker"
} ]
});
},
createDay: function() {
this.createComponent({
kind: "onyx.PickerDecorator",
onSelect: "updateDay",
components: [ {
classes: "onyx-datepicker-day",
name: "dayPickerButton",
disabled: this.disabled
}, {
name: "dayPicker",
kind: "onyx.Picker"
} ]
});
},
localeChanged: function() {
this.refresh();
},
dayHiddenChanged: function() {
this.$.dayPicker.getParent().setShowing(this.dayHidden ? !1 : !0);
},
monthHiddenChanged: function() {
this.$.monthPicker.getParent().setShowing(this.monthHidden ? !1 : !0);
},
yearHiddenChanged: function() {
this.$.yearPicker.getParent().setShowing(this.yearHidden ? !1 : !0);
},
minYearChanged: function() {
this.refresh();
},
maxYearChanged: function() {
this.refresh();
},
valueChanged: function() {
this.refresh();
},
disabledChanged: function() {
this.$.yearPickerButton.setDisabled(this.disabled), this.$.monthPickerButton.setDisabled(this.disabled), this.$.dayPickerButton.setDisabled(this.disabled);
},
updateDay: function(e, t) {
var n = this.calcDate(this.value.getFullYear(), this.value.getMonth(), t.selected.value);
return this.doSelect({
name: this.name,
value: n
}), this.setValue(n), !0;
},
updateMonth: function(e, t) {
var n = this.calcDate(this.value.getFullYear(), t.selected.value, this.value.getDate());
return this.doSelect({
name: this.name,
value: n
}), this.setValue(n), !0;
},
updateYear: function(e, t) {
if (t.originator.selected != -1) {
var n = this.calcDate(this.minYear + t.originator.selected, this.value.getMonth(), this.value.getDate());
this.doSelect({
name: this.name,
value: n
}), this.setValue(n);
}
return !0;
},
calcDate: function(e, t, n) {
return new Date(e, t, n, this.value.getHours(), this.value.getMinutes(), this.value.getSeconds(), this.value.getMilliseconds());
},
refresh: function() {
this.destroyClientControls(), this.initDefaults(), this.render();
}
});

// TimePicker.js

enyo.kind({
name: "onyx.TimePicker",
classes: "onyx-toolbar-inline",
published: {
disabled: !1,
locale: "en_us",
is24HrMode: null,
value: null
},
events: {
onSelect: ""
},
create: function() {
this.inherited(arguments), enyo.g11n && (this.locale = enyo.g11n.currentLocale().getLocale()), this.initDefaults();
},
initDefaults: function() {
var e = "AM", t = "PM";
this.is24HrMode == null && (this.is24HrMode = !1), enyo.g11n && (this._tf = new enyo.g11n.Fmts({
locale: this.locale
}), e = this._tf.getAmCaption(), t = this._tf.getPmCaption(), this.is24HrMode == null && (this.is24HrMode = !this._tf.isAmPm())), this.setupPickers(this._tf ? this._tf.getTimeFieldOrder() : "hma");
var n = this.value = this.value || new Date, r;
if (!this.is24HrMode) {
var i = n.getHours();
i = i === 0 ? 12 : i;
for (r = 1; r <= 12; r++) this.$.hourPicker.createComponent({
content: r,
value: r,
active: r == (i > 12 ? i % 12 : i)
});
} else for (r = 0; r < 24; r++) this.$.hourPicker.createComponent({
content: r,
value: r,
active: r == n.getHours()
});
for (r = 0; r <= 59; r++) this.$.minutePicker.createComponent({
content: r < 10 ? "0" + r : r,
value: r,
active: r == n.getMinutes()
});
n.getHours() >= 12 ? this.$.ampmPicker.createComponents([ {
content: e
}, {
content: t,
active: !0
} ]) : this.$.ampmPicker.createComponents([ {
content: e,
active: !0
}, {
content: t
} ]), this.$.ampmPicker.getParent().setShowing(!this.is24HrMode);
},
setupPickers: function(e) {
var t = e.split(""), n, r, i;
for (r = 0, i = t.length; r < i; r++) {
n = t[r];
switch (n) {
case "h":
this.createHour();
break;
case "m":
this.createMinute();
break;
case "a":
this.createAmPm();
break;
default:
}
}
},
createHour: function() {
this.createComponent({
kind: "onyx.PickerDecorator",
onSelect: "updateHour",
components: [ {
classes: "onyx-timepicker-hour",
name: "hourPickerButton",
disabled: this.disabled
}, {
name: "hourPicker",
kind: "onyx.Picker"
} ]
});
},
createMinute: function() {
this.createComponent({
kind: "onyx.PickerDecorator",
onSelect: "updateMinute",
components: [ {
classes: "onyx-timepicker-minute",
name: "minutePickerButton",
disabled: this.disabled
}, {
name: "minutePicker",
kind: "onyx.Picker"
} ]
});
},
createAmPm: function() {
this.createComponent({
kind: "onyx.PickerDecorator",
onSelect: "updateAmPm",
components: [ {
classes: "onyx-timepicker-ampm",
name: "ampmPickerButton",
disabled: this.disabled
}, {
name: "ampmPicker",
kind: "onyx.Picker"
} ]
});
},
disabledChanged: function() {
this.$.hourPickerButton.setDisabled(this.disabled), this.$.minutePickerButton.setDisabled(this.disabled), this.$.ampmPickerButton.setDisabled(this.disabled);
},
localeChanged: function() {
this.is24HrMode = null, this.refresh();
},
is24HrModeChanged: function() {
this.refresh();
},
valueChanged: function() {
this.refresh();
},
updateHour: function(e, t) {
var n = t.selected.value;
if (!this.is24HrMode) {
var r = this.$.ampmPicker.getParent().controlAtIndex(0).content;
n = n + (n == 12 ? -12 : 0) + (this.isAm(r) ? 0 : 12);
}
return this.value = this.calcTime(n, this.value.getMinutes()), this.doSelect({
name: this.name,
value: this.value
}), !0;
},
updateMinute: function(e, t) {
return this.value = this.calcTime(this.value.getHours(), t.selected.value), this.doSelect({
name: this.name,
value: this.value
}), !0;
},
updateAmPm: function(e, t) {
var n = this.value.getHours();
return this.is24HrMode || (n += n > 11 ? this.isAm(t.content) ? -12 : 0 : this.isAm(t.content) ? 0 : 12), this.value = this.calcTime(n, this.value.getMinutes()), this.doSelect({
name: this.name,
value: this.value
}), !0;
},
calcTime: function(e, t) {
return new Date(this.value.getFullYear(), this.value.getMonth(), this.value.getDate(), e, t, this.value.getSeconds(), this.value.getMilliseconds());
},
isAm: function(e) {
var t, n, r;
try {
t = this._tf.getAmCaption(), n = this._tf.getPmCaption();
} catch (i) {
t = "AM", n = "PM";
}
return e == t ? !0 : !1;
},
refresh: function() {
this.destroyClientControls(), this.initDefaults(), this.render();
}
});

// RadioButton.js

enyo.kind({
name: "onyx.RadioButton",
kind: "Button",
classes: "onyx-radiobutton"
});

// RadioGroup.js

enyo.kind({
name: "onyx.RadioGroup",
kind: "Group",
defaultKind: "onyx.RadioButton",
highlander: !0
});

// ToggleButton.js

enyo.kind({
name: "onyx.ToggleButton",
classes: "onyx-toggle-button",
published: {
active: !1,
value: !1,
onContent: "On",
offContent: "Off",
disabled: !1
},
events: {
onChange: ""
},
handlers: {
ondragstart: "dragstart",
ondrag: "drag",
ondragfinish: "dragfinish"
},
components: [ {
name: "contentOn",
classes: "onyx-toggle-content on"
}, {
name: "contentOff",
classes: "onyx-toggle-content off"
}, {
classes: "onyx-toggle-button-knob"
} ],
create: function() {
this.inherited(arguments), this.value = Boolean(this.value || this.active), this.onContentChanged(), this.offContentChanged(), this.disabledChanged();
},
rendered: function() {
this.inherited(arguments), this.updateVisualState();
},
updateVisualState: function() {
this.addRemoveClass("off", !this.value), this.$.contentOn.setShowing(this.value), this.$.contentOff.setShowing(!this.value), this.setActive(this.value);
},
valueChanged: function() {
this.updateVisualState(), this.doChange({
value: this.value
});
},
activeChanged: function() {
this.setValue(this.active), this.bubble("onActivate");
},
onContentChanged: function() {
this.$.contentOn.setContent(this.onContent || ""), this.$.contentOn.addRemoveClass("empty", !this.onContent);
},
offContentChanged: function() {
this.$.contentOff.setContent(this.offContent || ""), this.$.contentOff.addRemoveClass("empty", !this.onContent);
},
disabledChanged: function() {
this.addRemoveClass("disabled", this.disabled);
},
updateValue: function(e) {
this.disabled || this.setValue(e);
},
tap: function() {
this.updateValue(!this.value);
},
dragstart: function(e, t) {
if (t.horizontal) return t.preventDefault(), this.dragging = !0, this.dragged = !1, !0;
},
drag: function(e, t) {
if (this.dragging) {
var n = t.dx;
return Math.abs(n) > 10 && (this.updateValue(n > 0), this.dragged = !0), !0;
}
},
dragfinish: function(e, t) {
this.dragging = !1, this.dragged && t.preventTap();
}
});

// ToggleIconButton.js

enyo.kind({
name: "onyx.ToggleIconButton",
kind: "onyx.Icon",
published: {
active: !1,
value: !1
},
events: {
onChange: ""
},
classes: "onyx-icon-button onyx-icon-toggle",
activeChanged: function() {
this.addRemoveClass("active", this.value), this.bubble("onActivate");
},
updateValue: function(e) {
this.disabled || (this.setValue(e), this.doChange({
value: this.value
}));
},
tap: function() {
this.updateValue(!this.value);
},
valueChanged: function() {
this.setActive(this.value);
},
create: function() {
this.inherited(arguments), this.value = Boolean(this.value || this.active);
},
rendered: function() {
this.inherited(arguments), this.valueChanged(), this.removeClass("onyx-icon");
}
});

// Toolbar.js

enyo.kind({
name: "onyx.Toolbar",
classes: "onyx onyx-toolbar onyx-toolbar-inline",
create: function() {
this.inherited(arguments), this.hasClass("onyx-menu-toolbar") && enyo.platform.android >= 4 && this.applyStyle("position", "static");
}
});

// Tooltip.js

enyo.kind({
name: "onyx.Tooltip",
kind: "onyx.Popup",
classes: "onyx-tooltip below left-arrow",
autoDismiss: !1,
showDelay: 500,
defaultLeft: -6,
handlers: {
onRequestShowTooltip: "requestShow",
onRequestHideTooltip: "requestHide"
},
requestShow: function() {
return this.showJob = setTimeout(enyo.bind(this, "show"), this.showDelay), !0;
},
cancelShow: function() {
clearTimeout(this.showJob);
},
requestHide: function() {
return this.cancelShow(), this.inherited(arguments);
},
showingChanged: function() {
this.cancelShow(), this.adjustPosition(!0), this.inherited(arguments);
},
applyPosition: function(e) {
var t = "";
for (var n in e) t += n + ":" + e[n] + (isNaN(e[n]) ? "; " : "px; ");
this.addStyles(t);
},
adjustPosition: function(e) {
if (this.showing && this.hasNode()) {
var t = this.node.getBoundingClientRect();
t.top + t.height > window.innerHeight ? (this.addRemoveClass("below", !1), this.addRemoveClass("above", !0)) : (this.addRemoveClass("above", !1), this.addRemoveClass("below", !0)), t.left + t.width > window.innerWidth && (this.applyPosition({
"margin-left": -t.width,
bottom: "auto"
}), this.addRemoveClass("left-arrow", !1), this.addRemoveClass("right-arrow", !0));
}
},
resizeHandler: function() {
this.applyPosition({
"margin-left": this.defaultLeft,
bottom: "auto"
}), this.addRemoveClass("left-arrow", !0), this.addRemoveClass("right-arrow", !1), this.adjustPosition(!0), this.inherited(arguments);
}
});

// TooltipDecorator.js

enyo.kind({
name: "onyx.TooltipDecorator",
defaultKind: "onyx.Button",
classes: "onyx-popup-decorator",
handlers: {
onenter: "enter",
onleave: "leave"
},
enter: function() {
this.requestShowTooltip();
},
leave: function() {
this.requestHideTooltip();
},
tap: function() {
this.requestHideTooltip();
},
requestShowTooltip: function() {
this.waterfallDown("onRequestShowTooltip");
},
requestHideTooltip: function() {
this.waterfallDown("onRequestHideTooltip");
}
});

// ProgressBar.js

enyo.kind({
name: "onyx.ProgressBar",
classes: "onyx-progress-bar",
published: {
progress: 0,
min: 0,
max: 100,
barClasses: "",
showStripes: !0,
animateStripes: !0,
increment: 0
},
events: {
onAnimateProgressFinish: ""
},
components: [ {
name: "progressAnimator",
kind: "Animator",
onStep: "progressAnimatorStep",
onEnd: "progressAnimatorComplete"
}, {
name: "bar",
classes: "onyx-progress-bar-bar"
} ],
create: function() {
this.inherited(arguments), this.progressChanged(), this.barClassesChanged(), this.showStripesChanged(), this.animateStripesChanged();
},
barClassesChanged: function(e) {
this.$.bar.removeClass(e), this.$.bar.addClass(this.barClasses);
},
showStripesChanged: function() {
this.$.bar.addRemoveClass("striped", this.showStripes);
},
animateStripesChanged: function() {
this.$.bar.addRemoveClass("animated", this.animateStripes);
},
progressChanged: function() {
this.progress = this.clampValue(this.min, this.max, this.progress);
var e = this.calcPercent(this.progress);
this.updateBarPosition(e);
},
calcIncrement: function(e) {
return Math.round(e / this.increment) * this.increment;
},
clampValue: function(e, t, n) {
return Math.max(e, Math.min(n, t));
},
calcRatio: function(e) {
return (e - this.min) / (this.max - this.min);
},
calcPercent: function(e) {
return this.calcRatio(e) * 100;
},
updateBarPosition: function(e) {
this.$.bar.applyStyle("width", e + "%");
},
animateProgressTo: function(e) {
this.$.progressAnimator.play({
startValue: this.progress,
endValue: e,
node: this.hasNode()
});
},
progressAnimatorStep: function(e) {
return this.setProgress(e.value), !0;
},
progressAnimatorComplete: function(e) {
return this.doAnimateProgressFinish(e), !0;
}
});

// ProgressButton.js

enyo.kind({
name: "onyx.ProgressButton",
kind: "onyx.ProgressBar",
classes: "onyx-progress-button",
events: {
onCancel: ""
},
components: [ {
name: "progressAnimator",
kind: "Animator",
onStep: "progressAnimatorStep",
onEnd: "progressAnimatorComplete"
}, {
name: "bar",
classes: "onyx-progress-bar-bar onyx-progress-button-bar"
}, {
name: "client",
classes: "onyx-progress-button-client"
}, {
kind: "onyx.Icon",
src: "$lib/onyx/images/progress-button-cancel.png",
classes: "onyx-progress-button-icon",
ontap: "cancelTap"
} ],
cancelTap: function() {
this.doCancel();
}
});

// Scrim.js

enyo.kind({
name: "onyx.Scrim",
showing: !1,
classes: "onyx-scrim enyo-fit",
floating: !1,
create: function() {
this.inherited(arguments), this.zStack = [], this.floating && this.setParent(enyo.floatingLayer);
},
showingChanged: function() {
this.floating && this.showing && !this.hasNode() && this.render(), this.inherited(arguments);
},
addZIndex: function(e) {
enyo.indexOf(e, this.zStack) < 0 && this.zStack.push(e);
},
removeZIndex: function(e) {
enyo.remove(e, this.zStack);
},
showAtZIndex: function(e) {
this.addZIndex(e), e !== undefined && this.setZIndex(e), this.show();
},
hideAtZIndex: function(e) {
this.removeZIndex(e);
if (!this.zStack.length) this.hide(); else {
var t = this.zStack[this.zStack.length - 1];
this.setZIndex(t);
}
},
setZIndex: function(e) {
this.zIndex = e, this.applyStyle("z-index", e);
},
make: function() {
return this;
}
}), enyo.kind({
name: "onyx.scrimSingleton",
kind: null,
constructor: function(e, t) {
this.instanceName = e, enyo.setObject(this.instanceName, this), this.props = t || {};
},
make: function() {
var e = new onyx.Scrim(this.props);
return enyo.setObject(this.instanceName, e), e;
},
showAtZIndex: function(e) {
var t = this.make();
t.showAtZIndex(e);
},
hideAtZIndex: enyo.nop,
show: function() {
var e = this.make();
e.show();
}
}), new onyx.scrimSingleton("onyx.scrim", {
floating: !0,
classes: "onyx-scrim-translucent"
}), new onyx.scrimSingleton("onyx.scrimTransparent", {
floating: !0,
classes: "onyx-scrim-transparent"
});

// Slider.js

enyo.kind({
name: "onyx.Slider",
kind: "onyx.ProgressBar",
classes: "onyx-slider",
published: {
value: 0,
lockBar: !0,
tappable: !0
},
events: {
onChange: "",
onChanging: "",
onAnimateFinish: ""
},
showStripes: !1,
handlers: {
ondragstart: "dragstart",
ondrag: "drag",
ondragfinish: "dragfinish"
},
moreComponents: [ {
kind: "Animator",
onStep: "animatorStep",
onEnd: "animatorComplete"
}, {
classes: "onyx-slider-taparea"
}, {
name: "knob",
classes: "onyx-slider-knob"
} ],
create: function() {
this.inherited(arguments), enyo.platform.firefoxOS && (this.moreComponents[2].ondown = "down", this.moreComponents[2].onleave = "leave"), this.createComponents(this.moreComponents), this.valueChanged();
},
valueChanged: function() {
this.value = this.clampValue(this.min, this.max, this.value);
var e = this.calcPercent(this.value);
this.updateKnobPosition(e), this.lockBar && this.setProgress(this.value);
},
updateKnobPosition: function(e) {
this.$.knob.applyStyle("left", e + "%");
},
calcKnobPosition: function(e) {
var t = e.clientX - this.hasNode().getBoundingClientRect().left;
return t / this.getBounds().width * (this.max - this.min) + this.min;
},
dragstart: function(e, t) {
if (t.horizontal) return t.preventDefault(), this.dragging = !0, !0;
},
drag: function(e, t) {
if (this.dragging) {
var n = this.calcKnobPosition(t);
return n = this.increment ? this.calcIncrement(n) : n, this.setValue(n), this.doChanging({
value: this.value
}), !0;
}
},
dragfinish: function(e, t) {
return this.dragging = !1, t.preventTap(), this.doChange({
value: this.value
}), !0;
},
tap: function(e, t) {
if (this.tappable) {
var n = this.calcKnobPosition(t);
return n = this.increment ? this.calcIncrement(n) : n, this.tapped = !0, this.animateTo(n), !0;
}
},
down: function(e, t) {
this.addClass("pressed");
},
leave: function(e, t) {
this.removeClass("pressed");
},
animateTo: function(e) {
this.$.animator.play({
startValue: this.value,
endValue: e,
node: this.hasNode()
});
},
animatorStep: function(e) {
return this.setValue(e.value), !0;
},
animatorComplete: function(e) {
return this.tapped && (this.tapped = !1, this.doChange({
value: this.value
})), this.doAnimateFinish(e), !0;
}
});

// RangeSlider.js

enyo.kind({
name: "onyx.RangeSlider",
kind: "onyx.ProgressBar",
classes: "onyx-slider",
published: {
rangeMin: 0,
rangeMax: 100,
rangeStart: 0,
rangeEnd: 100,
beginValue: 0,
endValue: 0
},
events: {
onChange: "",
onChanging: ""
},
showStripes: !1,
showLabels: !1,
handlers: {
ondragstart: "dragstart",
ondrag: "drag",
ondragfinish: "dragfinish",
ondown: "down"
},
moreComponents: [ {
name: "startKnob",
classes: "onyx-slider-knob"
}, {
name: "endKnob",
classes: "onyx-slider-knob onyx-range-slider-knob"
} ],
create: function() {
this.inherited(arguments), this.createComponents(this.moreComponents), this.initControls();
},
rendered: function() {
this.inherited(arguments);
var e = this.calcPercent(this.beginValue);
this.updateBarPosition(e);
},
initControls: function() {
this.$.bar.applyStyle("position", "relative"), this.refreshRangeSlider(), this.showLabels && (this.$.startKnob.createComponent({
name: "startLabel",
kind: "onyx.RangeSliderKnobLabel"
}), this.$.endKnob.createComponent({
name: "endLabel",
kind: "onyx.RangeSliderKnobLabel"
}));
},
refreshRangeSlider: function() {
this.beginValue = this.calcKnobPercent(this.rangeStart), this.endValue = this.calcKnobPercent(this.rangeEnd), this.beginValueChanged(), this.endValueChanged();
},
calcKnobRatio: function(e) {
return (e - this.rangeMin) / (this.rangeMax - this.rangeMin);
},
calcKnobPercent: function(e) {
return this.calcKnobRatio(e) * 100;
},
beginValueChanged: function(e) {
if (e === undefined) {
var t = this.calcPercent(this.beginValue);
this.updateKnobPosition(t, this.$.startKnob);
}
},
endValueChanged: function(e) {
if (e === undefined) {
var t = this.calcPercent(this.endValue);
this.updateKnobPosition(t, this.$.endKnob);
}
},
calcKnobPosition: function(e) {
var t = e.clientX - this.hasNode().getBoundingClientRect().left;
return t / this.getBounds().width * (this.max - this.min) + this.min;
},
updateKnobPosition: function(e, t) {
t.applyStyle("left", e + "%"), this.updateBarPosition();
},
updateBarPosition: function() {
if (this.$.startKnob !== undefined && this.$.endKnob !== undefined) {
var e = this.calcKnobPercent(this.rangeStart), t = this.calcKnobPercent(this.rangeEnd) - e;
this.$.bar.applyStyle("left", e + "%"), this.$.bar.applyStyle("width", t + "%");
}
},
calcRangeRatio: function(e) {
return e / 100 * (this.rangeMax - this.rangeMin) + this.rangeMin - this.increment / 2;
},
swapZIndex: function(e) {
e === "startKnob" ? (this.$.startKnob.applyStyle("z-index", 1), this.$.endKnob.applyStyle("z-index", 0)) : e === "endKnob" && (this.$.startKnob.applyStyle("z-index", 0), this.$.endKnob.applyStyle("z-index", 1));
},
down: function(e, t) {
this.swapZIndex(e.name);
},
dragstart: function(e, t) {
if (t.horizontal) return t.preventDefault(), this.dragging = !0, !0;
},
drag: function(e, t) {
if (this.dragging) {
var n = this.calcKnobPosition(t), r, i, s;
if (e.name === "startKnob" && n >= 0) {
if (!(n <= this.endValue && t.xDirection === -1 || n <= this.endValue)) return this.drag(this.$.endKnob, t);
this.setBeginValue(n), r = this.calcRangeRatio(this.beginValue), i = this.increment ? this.calcIncrement(r + .5 * this.increment) : r, s = this.calcKnobPercent(i), this.updateKnobPosition(s, this.$.startKnob), this.setRangeStart(i), this.doChanging({
value: i
});
} else if (e.name === "endKnob" && n <= 100) {
if (!(n >= this.beginValue && t.xDirection === 1 || n >= this.beginValue)) return this.drag(this.$.startKnob, t);
this.setEndValue(n), r = this.calcRangeRatio(this.endValue), i = this.increment ? this.calcIncrement(r + .5 * this.increment) : r, s = this.calcKnobPercent(i), this.updateKnobPosition(s, this.$.endKnob), this.setRangeEnd(i), this.doChanging({
value: i
});
}
return !0;
}
},
dragfinish: function(e, t) {
this.dragging = !1, t.preventTap();
var n;
return e.name === "startKnob" ? (n = this.calcRangeRatio(this.beginValue), this.doChange({
value: n,
startChanged: !0
})) : e.name === "endKnob" && (n = this.calcRangeRatio(this.endValue), this.doChange({
value: n,
startChanged: !1
})), !0;
},
rangeMinChanged: function() {
this.refreshRangeSlider();
},
rangeMaxChanged: function() {
this.refreshRangeSlider();
},
rangeStartChanged: function() {
this.refreshRangeSlider();
},
rangeEndChanged: function() {
this.refreshRangeSlider();
},
setStartLabel: function(e) {
this.$.startKnob.waterfallDown("onSetLabel", e);
},
setEndLabel: function(e) {
this.$.endKnob.waterfallDown("onSetLabel", e);
}
}), enyo.kind({
name: "onyx.RangeSliderKnobLabel",
classes: "onyx-range-slider-label",
handlers: {
onSetLabel: "setLabel"
},
setLabel: function(e, t) {
this.setContent(t);
}
});

// Item.js

enyo.kind({
name: "onyx.Item",
classes: "onyx-item",
tapHighlight: !0,
handlers: {
onhold: "hold",
onrelease: "release"
},
hold: function(e, t) {
this.tapHighlight && onyx.Item.addRemoveFlyweightClass(this.controlParent || this, "onyx-highlight", !0, t);
},
release: function(e, t) {
this.tapHighlight && onyx.Item.addRemoveFlyweightClass(this.controlParent || this, "onyx-highlight", !1, t);
},
statics: {
addRemoveFlyweightClass: function(e, t, n, r, i) {
var s = r.flyweight;
if (s) {
var o = i !== undefined ? i : r.index;
s.performOnRow(o, function() {
e.addRemoveClass(t, n);
});
}
}
}
});

// Spinner.js

enyo.kind({
name: "onyx.Spinner",
classes: "onyx-spinner",
stop: function() {
this.setShowing(!1);
},
start: function() {
this.setShowing(!0);
},
toggle: function() {
this.setShowing(!this.getShowing());
}
});

// MoreToolbar.js

enyo.kind({
name: "onyx.MoreToolbar",
classes: "onyx-toolbar onyx-more-toolbar",
menuClass: "",
movedClass: "",
layoutKind: "FittableColumnsLayout",
noStretch: !0,
handlers: {
onHide: "reflow"
},
published: {
clientLayoutKind: "FittableColumnsLayout"
},
tools: [ {
name: "client",
noStretch: !0,
fit: !0,
classes: "onyx-toolbar-inline"
}, {
name: "nard",
kind: "onyx.MenuDecorator",
showing: !1,
onActivate: "activated",
components: [ {
kind: "onyx.IconButton",
classes: "onyx-more-button"
}, {
name: "menu",
kind: "onyx.Menu",
scrolling: !1,
classes: "onyx-more-menu"
} ]
} ],
initComponents: function() {
this.menuClass && this.menuClass.length > 0 && !this.$.menu.hasClass(this.menuClass) && this.$.menu.addClass(this.menuClass), this.createChrome(this.tools), this.inherited(arguments), this.$.client.setLayoutKind(this.clientLayoutKind);
},
clientLayoutKindChanged: function() {
this.$.client.setLayoutKind(this.clientLayoutKind);
},
reflow: function() {
this.inherited(arguments), this.isContentOverflowing() ? (this.$.nard.show(), this.popItem() && this.reflow()) : this.tryPushItem() ? this.reflow() : this.$.menu.children.length || (this.$.nard.hide(), this.$.menu.hide());
},
activated: function(e, t) {
this.addRemoveClass("active", t.originator.active);
},
popItem: function() {
var e = this.findCollapsibleItem();
if (e) {
this.movedClass && this.movedClass.length > 0 && !e.hasClass(this.movedClass) && e.addClass(this.movedClass), this.$.menu.addChild(e, null);
var t = this.$.menu.hasNode();
return t && e.hasNode() && e.insertNodeInParent(t), !0;
}
},
pushItem: function() {
var e = this.$.menu.children, t = e[0];
if (t) {
this.movedClass && this.movedClass.length > 0 && t.hasClass(this.movedClass) && t.removeClass(this.movedClass), this.$.client.addChild(t);
var n = this.$.client.hasNode();
if (n && t.hasNode()) {
var r, i;
for (var s = 0; s < this.$.client.children.length; s++) {
var o = this.$.client.children[s];
if (o.toolbarIndex !== undefined && o.toolbarIndex != s) {
r = o, i = s;
break;
}
}
if (r && r.hasNode()) {
t.insertNodeInParent(n, r.node);
var u = this.$.client.children.pop();
this.$.client.children.splice(i, 0, u);
} else t.appendNodeToParent(n);
}
return !0;
}
},
tryPushItem: function() {
if (this.pushItem()) {
if (!this.isContentOverflowing()) return !0;
this.popItem();
}
},
isContentOverflowing: function() {
if (this.$.client.hasNode()) {
var e = this.$.client.children, t = e[e.length - 1].hasNode();
if (t) return this.$.client.reflow(), t.offsetLeft + t.offsetWidth > this.$.client.node.clientWidth;
}
},
findCollapsibleItem: function() {
var e = this.$.client.children;
for (var t = e.length - 1; c = e[t]; t--) {
if (!c.unmoveable) return c;
c.toolbarIndex === undefined && (c.toolbarIndex = t);
}
}
});

// IntegerPicker.js

enyo.kind({
name: "onyx.IntegerPicker",
kind: "onyx.Picker",
published: {
value: 0,
min: 0,
max: 9
},
create: function() {
this.inherited(arguments), this.rangeChanged();
},
minChanged: function() {
this.destroyClientControls(), this.rangeChanged(), this.render();
},
maxChanged: function() {
this.destroyClientControls(), this.rangeChanged(), this.render();
},
rangeChanged: function() {
for (var e = this.min; e <= this.max; e++) this.createComponent({
content: e,
active: e === this.value ? !0 : !1
});
},
valueChanged: function(e) {
var t = this.getClientControls(), n = t.length;
this.value = this.value >= this.min && this.value <= this.max ? this.value : this.min;
for (var r = 0; r < n; r++) if (this.value === parseInt(t[r].content)) {
this.setSelected(t[r]);
break;
}
},
selectedChanged: function(e) {
e && e.removeClass("selected"), this.selected && (this.selected.addClass("selected"), this.doChange({
selected: this.selected,
content: this.selected.content
})), this.value = parseInt(this.selected.content);
}
});

// ContextualPopup.js

enyo.kind({
name: "onyx.ContextualPopup",
kind: "enyo.Popup",
modal: !0,
autoDismiss: !0,
floating: !1,
classes: "onyx-contextual-popup enyo-unselectable",
published: {
maxHeight: 100,
scrolling: !0,
title: undefined,
actionButtons: []
},
vertFlushMargin: 60,
horizFlushMargin: 50,
widePopup: 200,
longPopup: 200,
horizBuffer: 16,
events: {
onTap: ""
},
handlers: {
onActivate: "itemActivated",
onRequestShowMenu: "requestShow",
onRequestHideMenu: "requestHide"
},
components: [ {
name: "title",
classes: "onyx-contextual-popup-title"
}, {
classes: "onyx-contextual-popup-scroller",
components: [ {
name: "client",
kind: "enyo.Scroller",
vertical: "auto",
classes: "enyo-unselectable",
thumb: !1,
strategyKind: "TouchScrollStrategy"
} ]
}, {
name: "actionButtons",
classes: "onyx-contextual-popup-action-buttons"
} ],
scrollerName: "client",
create: function() {
this.inherited(arguments), this.maxHeightChanged(), this.titleChanged(), this.actionButtonsChanged();
},
getScroller: function() {
return this.$[this.scrollerName];
},
titleChanged: function() {
this.$.title.setContent(this.title);
},
actionButtonsChanged: function() {
for (var e = 0; e < this.actionButtons.length; e++) this.$.actionButtons.createComponent({
kind: "onyx.Button",
content: this.actionButtons[e].content,
classes: this.actionButtons[e].classes + " onyx-contextual-popup-action-button",
name: this.actionButtons[e].name ? this.actionButtons[e].name : "ActionButton" + e,
index: e,
tap: enyo.bind(this, this.tapHandler)
});
},
tapHandler: function(e, t) {
return t.actionButton = !0, t.popup = this, this.bubble("ontap", t), !0;
},
maxHeightChanged: function() {
this.scrolling && this.getScroller().setMaxHeight(this.maxHeight + "px");
},
itemActivated: function(e, t) {
return t.originator.setActive(!1), !0;
},
showingChanged: function() {
this.inherited(arguments), this.scrolling && this.getScroller().setShowing(this.showing), this.adjustPosition();
},
requestShow: function(e, t) {
var n = t.activator.hasNode();
return n && (this.activatorOffset = this.getPageOffset(n)), this.show(), !0;
},
applyPosition: function(e) {
var t = "";
for (var n in e) t += n + ":" + e[n] + (isNaN(e[n]) ? "; " : "px; ");
this.addStyles(t);
},
getPageOffset: function(e) {
var t = this.getBoundingRect(e), n = window.pageYOffset === undefined ? document.documentElement.scrollTop : window.pageYOffset, r = window.pageXOffset === undefined ? document.documentElement.scrollLeft : window.pageXOffset, i = t.height === undefined ? t.bottom - t.top : t.height, s = t.width === undefined ? t.right - t.left : t.width;
return {
top: t.top + n,
left: t.left + r,
height: i,
width: s
};
},
adjustPosition: function() {
if (this.showing && this.hasNode()) {
this.resetPositioning();
var e = this.getViewWidth(), t = this.getViewHeight(), n = this.vertFlushMargin, r = t - this.vertFlushMargin, i = this.horizFlushMargin, s = e - this.horizFlushMargin;
if (this.activatorOffset.top + this.activatorOffset.height < n || this.activatorOffset.top > r) {
if (this.applyVerticalFlushPositioning(i, s)) return;
if (this.applyHorizontalFlushPositioning(i, s)) return;
if (this.applyVerticalPositioning()) return;
} else if (this.activatorOffset.left + this.activatorOffset.width < i || this.activatorOffset.left > s) if (this.applyHorizontalPositioning()) return;
var o = this.getBoundingRect(this.node);
if (o.width > this.widePopup) {
if (this.applyVerticalPositioning()) return;
} else if (o.height > this.longPopup && this.applyHorizontalPositioning()) return;
if (this.applyVerticalPositioning()) return;
if (this.applyHorizontalPositioning()) return;
}
},
initVerticalPositioning: function() {
this.resetPositioning(), this.addClass("vertical");
var e = this.getBoundingRect(this.node), t = this.getViewHeight();
return this.floating ? this.activatorOffset.top < t / 2 ? (this.applyPosition({
top: this.activatorOffset.top + this.activatorOffset.height,
bottom: "auto"
}), this.addClass("below")) : (this.applyPosition({
top: this.activatorOffset.top - e.height,
bottom: "auto"
}), this.addClass("above")) : e.top + e.height > t && t - e.bottom < e.top - e.height ? this.addClass("above") : this.addClass("below"), e = this.getBoundingRect(this.node), e.top + e.height > t || e.top < 0 ? !1 : !0;
},
applyVerticalPositioning: function() {
if (!this.initVerticalPositioning()) return !1;
var e = this.getBoundingRect(this.node), t = this.getViewWidth();
if (this.floating) {
var n = this.activatorOffset.left + this.activatorOffset.width / 2 - e.width / 2;
n + e.width > t ? (this.applyPosition({
left: this.activatorOffset.left + this.activatorOffset.width - e.width
}), this.addClass("left")) : n < 0 ? (this.applyPosition({
left: this.activatorOffset.left
}), this.addClass("right")) : this.applyPosition({
left: n
});
} else {
var r = this.activatorOffset.left + this.activatorOffset.width / 2 - e.left - e.width / 2;
e.right + r > t ? (this.applyPosition({
left: this.activatorOffset.left + this.activatorOffset.width - e.right
}), this.addRemoveClass("left", !0)) : e.left + r < 0 ? this.addRemoveClass("right", !0) : this.applyPosition({
left: r
});
}
return !0;
},
applyVerticalFlushPositioning: function(e, t) {
if (!this.initVerticalPositioning()) return !1;
var n = this.getBoundingRect(this.node), r = this.getViewWidth();
return this.activatorOffset.left + this.activatorOffset.width / 2 < e ? (this.activatorOffset.left + this.activatorOffset.width / 2 < this.horizBuffer ? this.applyPosition({
left: this.horizBuffer + (this.floating ? 0 : -n.left)
}) : this.applyPosition({
left: this.activatorOffset.width / 2 + (this.floating ? this.activatorOffset.left : 0)
}), this.addClass("right"), this.addClass("corner"), !0) : this.activatorOffset.left + this.activatorOffset.width / 2 > t ? (this.activatorOffset.left + this.activatorOffset.width / 2 > r - this.horizBuffer ? this.applyPosition({
left: r - this.horizBuffer - n.right
}) : this.applyPosition({
left: this.activatorOffset.left + this.activatorOffset.width / 2 - n.right
}), this.addClass("left"), this.addClass("corner"), !0) : !1;
},
initHorizontalPositioning: function() {
this.resetPositioning();
var e = this.getBoundingRect(this.node), t = this.getViewWidth();
return this.floating ? this.activatorOffset.left + this.activatorOffset.width < t / 2 ? (this.applyPosition({
left: this.activatorOffset.left + this.activatorOffset.width
}), this.addRemoveClass("left", !0)) : (this.applyPosition({
left: this.activatorOffset.left - e.width
}), this.addRemoveClass("right", !0)) : this.activatorOffset.left - e.width > 0 ? (this.applyPosition({
left: this.activatorOffset.left - e.left - e.width
}), this.addRemoveClass("right", !0)) : (this.applyPosition({
left: this.activatorOffset.width
}), this.addRemoveClass("left", !0)), this.addRemoveClass("horizontal", !0), e = this.getBoundingRect(this.node), e.left < 0 || e.left + e.width > t ? !1 : !0;
},
applyHorizontalPositioning: function() {
if (!this.initHorizontalPositioning()) return !1;
var e = this.getBoundingRect(this.node), t = this.getViewHeight(), n = this.activatorOffset.top + this.activatorOffset.height / 2;
return this.floating ? n >= t / 2 - .05 * t && n <= t / 2 + .05 * t ? this.applyPosition({
top: this.activatorOffset.top + this.activatorOffset.height / 2 - e.height / 2,
bottom: "auto"
}) : this.activatorOffset.top + this.activatorOffset.height < t / 2 ? (this.applyPosition({
top: this.activatorOffset.top - this.activatorOffset.height,
bottom: "auto"
}), this.addRemoveClass("high", !0)) : (this.applyPosition({
top: this.activatorOffset.top - e.height + this.activatorOffset.height * 2,
bottom: "auto"
}), this.addRemoveClass("low", !0)) : n >= t / 2 - .05 * t && n <= t / 2 + .05 * t ? this.applyPosition({
top: (this.activatorOffset.height - e.height) / 2
}) : this.activatorOffset.top + this.activatorOffset.height < t / 2 ? (this.applyPosition({
top: -this.activatorOffset.height
}), this.addRemoveClass("high", !0)) : (this.applyPosition({
top: e.top - e.height - this.activatorOffset.top + this.activatorOffset.height
}), this.addRemoveClass("low", !0)), !0;
},
applyHorizontalFlushPositioning: function(e, t) {
if (!this.initHorizontalPositioning()) return !1;
var n = this.getBoundingRect(this.node), r = this.getViewWidth();
return this.floating ? this.activatorOffset.top < innerHeight / 2 ? (this.applyPosition({
top: this.activatorOffset.top + this.activatorOffset.height / 2
}), this.addRemoveClass("high", !0)) : (this.applyPosition({
top: this.activatorOffset.top + this.activatorOffset.height / 2 - n.height
}), this.addRemoveClass("low", !0)) : n.top + n.height > innerHeight && innerHeight - n.bottom < n.top - n.height ? (this.applyPosition({
top: n.top - n.height - this.activatorOffset.top - this.activatorOffset.height / 2
}), this.addRemoveClass("low", !0)) : (this.applyPosition({
top: this.activatorOffset.height / 2
}), this.addRemoveClass("high", !0)), this.activatorOffset.left + this.activatorOffset.width < e ? (this.addClass("left"), this.addClass("corner"), !0) : this.activatorOffset.left > t ? (this.addClass("right"), this.addClass("corner"), !0) : !1;
},
getBoundingRect: function(e) {
var t = e.getBoundingClientRect();
return !t.width || !t.height ? {
left: t.left,
right: t.right,
top: t.top,
bottom: t.bottom,
width: t.right - t.left,
height: t.bottom - t.top
} : t;
},
getViewHeight: function() {
return window.innerHeight === undefined ? document.documentElement.clientHeight : window.innerHeight;
},
getViewWidth: function() {
return window.innerWidth === undefined ? document.documentElement.clientWidth : window.innerWidth;
},
resetPositioning: function() {
this.removeClass("right"), this.removeClass("left"), this.removeClass("high"), this.removeClass("low"), this.removeClass("corner"), this.removeClass("below"), this.removeClass("above"), this.removeClass("vertical"), this.removeClass("horizontal"), this.applyPosition({
left: "auto"
}), this.applyPosition({
top: "auto"
});
},
resizeHandler: function() {
this.inherited(arguments), this.adjustPosition();
},
requestHide: function() {
this.setShowing(!1);
}
});

// date_format/date_format.js

var dateFormat = function() {
var e = /d{1,4}|m{1,4}|yy(?:yy)?|([HhMsTt])\1?|[LloSZ]|"[^"]*"|'[^']*'/g, t = /\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g, n = /[^-+\dA-Z]/g, r = function(e, t) {
e = String(e), t = t || 2;
while (e.length < t) e = "0" + e;
return e;
};
return function(i, s, o) {
var u = dateFormat;
arguments.length == 1 && Object.prototype.toString.call(i) == "[object String]" && !/\d/.test(i) && (s = i, i = undefined), i = i ? new Date(i) : new Date;
if (isNaN(i)) throw SyntaxError("invalid date");
s = String(u.masks[s] || s || u.masks["default"]), s.slice(0, 4) == "UTC:" && (s = s.slice(4), o = !0);
var a = o ? "getUTC" : "get", f = i[a + "Date"](), l = i[a + "Day"](), c = i[a + "Month"](), h = i[a + "FullYear"](), p = i[a + "Hours"](), d = i[a + "Minutes"](), v = i[a + "Seconds"](), m = i[a + "Milliseconds"](), g = o ? 0 : i.getTimezoneOffset(), y = {
d: f,
dd: r(f),
ddd: u.i18n.dayNames[l],
dddd: u.i18n.dayNames[l + 7],
m: c + 1,
mm: r(c + 1),
mmm: u.i18n.monthNames[c],
mmmm: u.i18n.monthNames[c + 12],
yy: String(h).slice(2),
yyyy: h,
h: p % 12 || 12,
hh: r(p % 12 || 12),
H: p,
HH: r(p),
M: d,
MM: r(d),
s: v,
ss: r(v),
l: r(m, 3),
L: r(m > 99 ? Math.round(m / 10) : m),
t: p < 12 ? "a" : "p",
tt: p < 12 ? "am" : "pm",
T: p < 12 ? "A" : "P",
TT: p < 12 ? "AM" : "PM",
Z: o ? "UTC" : (String(i).match(t) || [ "" ]).pop().replace(n, ""),
o: (g > 0 ? "-" : "+") + r(Math.floor(Math.abs(g) / 60) * 100 + Math.abs(g) % 60, 4),
S: [ "th", "st", "nd", "rd" ][f % 10 > 3 ? 0 : (f % 100 - f % 10 != 10) * f % 10]
};
return s.replace(e, function(e) {
return e in y ? y[e] : e.slice(1, e.length - 1);
});
};
}();

dateFormat.masks = {
"default": "ddd mmm dd yyyy HH:MM:ss",
shortDate: "m/d/yy",
mediumDate: "mmm d, yyyy",
longDate: "mmmm d, yyyy",
fullDate: "dddd, mmmm d, yyyy",
shortTime: "h:MM TT",
mediumTime: "h:MM:ss TT",
longTime: "h:MM:ss TT Z",
isoDate: "yyyy-mm-dd",
isoTime: "HH:MM:ss",
isoDateTime: "yyyy-mm-dd'T'HH:MM:ss",
isoUtcDateTime: "UTC:yyyy-mm-dd'T'HH:MM:ss'Z'"
}, dateFormat.i18n = {
dayNames: [ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ],
monthNames: [ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ]
}, Date.prototype.format = function(e, t) {
return dateFormat(this, e, t);
};

// DatePicker.js

enyo.kind({
name: "GTS.DatePicker",
kind: "enyo.Control",
classes: "gts-calendar",
published: {
value: null,
viewDate: null,
dowFormat: "ddd",
monthFormat: "mmmm yyyy"
},
events: {
onChange: ""
},
components: [ {
kind: "FittableColumns",
components: [ {
kind: "onyx.Button",
content: "<<",
ontap: "monthBack"
}, {
name: "monthLabel",
tag: "strong",
classes: "month-label",
fit: !0
}, {
kind: "onyx.Button",
content: ">>",
ontap: "monthForward"
} ]
}, {
kind: "FittableColumns",
components: [ {
name: "sunday",
content: "Sun",
classes: "week-label"
}, {
name: "monday",
content: "Mon",
classes: "week-label"
}, {
name: "tuesday",
content: "Tue",
classes: "week-label"
}, {
name: "wednesday",
content: "Wed",
classes: "week-label"
}, {
name: "thursday",
content: "Thu",
classes: "week-label"
}, {
name: "friday",
content: "Fri",
classes: "week-label"
}, {
name: "saturday",
content: "Sat",
classes: "week-label"
} ]
}, {
kind: "FittableColumns",
components: [ {
name: "row0col0",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row0col1",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row0col2",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row0col3",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row0col4",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row0col5",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row0col6",
kind: "onyx.Button",
ontap: "dateHandler"
} ]
}, {
kind: "FittableColumns",
components: [ {
name: "row1col0",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row1col1",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row1col2",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row1col3",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row1col4",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row1col5",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row1col6",
kind: "onyx.Button",
ontap: "dateHandler"
} ]
}, {
kind: "FittableColumns",
components: [ {
name: "row2col0",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row2col1",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row2col2",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row2col3",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row2col4",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row2col5",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row2col6",
kind: "onyx.Button",
ontap: "dateHandler"
} ]
}, {
kind: "FittableColumns",
components: [ {
name: "row3col0",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row3col1",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row3col2",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row3col3",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row3col4",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row3col5",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row3col6",
kind: "onyx.Button",
ontap: "dateHandler"
} ]
}, {
kind: "FittableColumns",
components: [ {
name: "row4col0",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row4col1",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row4col2",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row4col3",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row4col4",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row4col5",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row4col6",
kind: "onyx.Button",
ontap: "dateHandler"
} ]
}, {
kind: "FittableColumns",
components: [ {
name: "row5col0",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row5col1",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row5col2",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row5col3",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row5col4",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row5col5",
kind: "onyx.Button",
ontap: "dateHandler"
}, {
name: "row5col6",
kind: "onyx.Button",
ontap: "dateHandler"
} ]
}, {
kind: "FittableColumns",
style: "margin-top: 1em;",
components: [ {
name: "client",
fit: !0
}, {
kind: "onyx.Button",
content: "Today",
ontap: "resetDate"
} ]
} ],
constructor: function() {
this.inherited(arguments), this.viewDate = this.viewDate || new Date, this.value = this.value || new Date;
},
rendered: function() {
this.inherited(arguments);
if (dateFormat) {
var e = new Date(2011, 4, 1);
this.$.sunday.setContent(dateFormat(e, this.dowFormat)), e.setDate(e.getDate() + 1), this.$.monday.setContent(dateFormat(e, this.dowFormat)), e.setDate(e.getDate() + 1), this.$.tuesday.setContent(dateFormat(e, this.dowFormat)), e.setDate(e.getDate() + 1), this.$.wednesday.setContent(dateFormat(e, this.dowFormat)), e.setDate(e.getDate() + 1), this.$.thursday.setContent(dateFormat(e, this.dowFormat)), e.setDate(e.getDate() + 1), this.$.friday.setContent(dateFormat(e, this.dowFormat)), e.setDate(e.getDate() + 1), this.$.saturday.setContent(dateFormat(e, this.dowFormat));
}
var t = Math.round(10 * this.getBounds().width / 7) / 10;
this.$.sunday.applyStyle("width", t + "px"), this.$.monday.applyStyle("width", t + "px"), this.$.tuesday.applyStyle("width", t + "px"), this.$.wednesday.applyStyle("width", t + "px"), this.$.thursday.applyStyle("width", t + "px"), this.$.friday.applyStyle("width", t + "px"), this.$.saturday.applyStyle("width", t + "px"), this.valueChanged();
},
valueChanged: function() {
if (Object.prototype.toString.call(this.value) !== "[object Date]" || isNaN(this.value.getTime())) this.value = new Date;
this.viewDate.setTime(this.value.getTime()), this.renderCalendar();
},
viewDateChanged: function() {
this.renderCalendar();
},
renderCalendar: function() {
var e = Math.round(10 * this.getBounds().width / 7) / 10, t = new Date;
this.viewDate = new Date(this.viewDate.getFullYear(), this.viewDate.getMonth(), 1);
var n = new Date(this.viewDate.getFullYear(), this.viewDate.getMonth(), 0), r = new Date(this.viewDate.getFullYear(), this.viewDate.getMonth(), 1);
n.setDate(n.getDate() - r.getDay() + 1), n.getTime() === r.getTime() && n.setDate(n.getDate() - 7);
var i = 0, s;
while (i < 6) n.getDate() === this.value.getDate() && n.getMonth() === this.value.getMonth() && n.getFullYear() === this.value.getFullYear() ? s = "onyx-blue" : n.getDate() === t.getDate() && n.getMonth() === t.getMonth() && n.getFullYear() === t.getFullYear() ? s = "onyx-affirmative" : n.getMonth() !== r.getMonth() ? s = "onyx-dark" : s = "", this.$["row" + i + "col" + n.getDay()].applyStyle("width", e + "px"), this.$["row" + i + "col" + n.getDay()].removeClass("onyx-affirmative"), this.$["row" + i + "col" + n.getDay()].removeClass("onyx-blue"), this.$["row" + i + "col" + n.getDay()].removeClass("onyx-dark"), this.$["row" + i + "col" + n.getDay()].addClass(s), this.$["row" + i + "col" + n.getDay()].setContent(n.getDate()), this.$["row" + i + "col" + n.getDay()].ts = n.getTime(), n.setDate(n.getDate() + 1), n.getDay() === 0 && i < 6 && i++;
dateFormat ? this.$.monthLabel.setContent(dateFormat(r, this.monthFormat)) : this.$.monthLabel.setContent(this.getMonthString(r.getMonth()));
},
monthBack: function() {
this.viewDate.setMonth(this.viewDate.getMonth() - 1), this.renderCalendar();
},
monthForward: function() {
this.viewDate.setMonth(this.viewDate.getMonth() + 1), this.renderCalendar();
},
resetDate: function() {
this.viewDate = new Date, this.value = new Date, this.renderCalendar(), this.doChange(this.value);
},
dateHandler: function(e, t) {
var n = new Date;
n.setTime(e.ts), this.value.setDate(n.getDate()), this.value.setMonth(n.getMonth()), this.value.setFullYear(n.getFullYear()), this.value.getMonth() != this.viewDate.getMonth() && (this.viewDate = new Date(this.value.getFullYear(), this.value.getMonth(), 1)), this.doChange(this.value), this.renderCalendar();
},
getMonthString: function(e) {
return [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ][e];
},
getDayString: function(e) {
return [ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ][e];
}
});

// nvd3/lib/d3.v3.js

d3 = function() {
function o(e) {
return e != null && !isNaN(e);
}
function a(e) {
return e.length;
}
function f(e) {
var t = 1;
while (e * t % 1) t *= 10;
return t;
}
function l(e, t) {
try {
for (var n in t) Object.defineProperty(e.prototype, n, {
value: t[n],
enumerable: !1
});
} catch (r) {
e.prototype = t;
}
}
function c() {}
function d() {}
function v(e, t, n) {
return function() {
var r = n.apply(t, arguments);
return r === t ? e : r;
};
}
function m() {}
function g(e) {
function r() {
var n = t, r = -1, i = n.length, s;
while (++r < i) (s = n[r].on) && s.apply(this, arguments);
return e;
}
var t = [], n = new c;
return r.on = function(r, i) {
var s = n.get(r), o;
return arguments.length < 2 ? s && s.on : (s && (s.on = null, t = t.slice(0, o = t.indexOf(s)).concat(t.slice(o + 1)), n.remove(r)), i && t.push(n.set(r, {
on: i
})), e);
}, r;
}
function y() {
e.event.stopPropagation(), e.event.preventDefault();
}
function w() {
var t = e.event, n;
while (n = t.sourceEvent) t = n;
return t;
}
function E(e, t) {
function n() {
e.on(t, null);
}
e.on(t, function() {
y(), n();
}, !0), setTimeout(n, 0);
}
function S(t) {
var n = new m, r = 0, i = arguments.length;
while (++r < i) n[arguments[r]] = g(n);
return n.of = function(r, i) {
return function(s) {
try {
var o = s.sourceEvent = e.event;
s.target = t, e.event = s, n[s.type].apply(r, i);
} finally {
e.event = o;
}
};
}, n;
}
function T(r, i) {
var s = r.ownerSVGElement || r;
if (s.createSVGPoint) {
var o = s.createSVGPoint();
if (x < 0 && (n.scrollX || n.scrollY)) {
s = e.select(t.body).append("svg").style("position", "absolute").style("top", 0).style("left", 0);
var u = s[0][0].getScreenCTM();
x = !u.f && !u.e, s.remove();
}
return x ? (o.x = i.pageX, o.y = i.pageY) : (o.x = i.clientX, o.y = i.clientY), o = o.matrixTransform(r.getScreenCTM().inverse()), [ o.x, o.y ];
}
var a = r.getBoundingClientRect();
return [ i.clientX - a.left - r.clientLeft, i.clientY - a.top - r.clientTop ];
}
function C(e) {
var t = -1, n = e.length, r = [];
while (++t < n) r.push(e[t]);
return r;
}
function k(e) {
return Array.prototype.slice.call(e);
}
function O(e) {
return A(e, B), e;
}
function j(e) {
return function() {
return M(e, this);
};
}
function F(e) {
return function() {
return _(e, this);
};
}
function q(t, n) {
function r() {
this.removeAttribute(t);
}
function i() {
this.removeAttributeNS(t.space, t.local);
}
function s() {
this.setAttribute(t, n);
}
function o() {
this.setAttributeNS(t.space, t.local, n);
}
function u() {
var e = n.apply(this, arguments);
e == null ? this.removeAttribute(t) : this.setAttribute(t, e);
}
function a() {
var e = n.apply(this, arguments);
e == null ? this.removeAttributeNS(t.space, t.local) : this.setAttributeNS(t.space, t.local, e);
}
return t = e.ns.qualify(t), n == null ? t.local ? i : r : typeof n == "function" ? t.local ? a : u : t.local ? o : s;
}
function R(e) {
return e.trim().replace(/\s+/g, " ");
}
function z(t) {
return new RegExp("(?:^|\\s+)" + e.requote(t) + "(?:\\s+|$)", "g");
}
function W(e, t) {
function r() {
var r = -1;
while (++r < n) e[r](this, t);
}
function i() {
var r = -1, i = t.apply(this, arguments);
while (++r < n) e[r](this, i);
}
e = e.trim().split(/\s+/).map(X);
var n = e.length;
return typeof t == "function" ? i : r;
}
function X(e) {
var t = z(e);
return function(n, r) {
if (i = n.classList) return r ? i.add(e) : i.remove(e);
var i = n.getAttribute("class") || "";
r ? (t.lastIndex = 0, t.test(i) || n.setAttribute("class", R(i + " " + e))) : n.setAttribute("class", R(i.replace(t, " ")));
};
}
function V(e, t, n) {
function r() {
this.style.removeProperty(e);
}
function i() {
this.style.setProperty(e, t, n);
}
function s() {
var r = t.apply(this, arguments);
r == null ? this.style.removeProperty(e) : this.style.setProperty(e, r, n);
}
return t == null ? r : typeof t == "function" ? s : i;
}
function $(e, t) {
function n() {
delete this[e];
}
function r() {
this[e] = t;
}
function i() {
var n = t.apply(this, arguments);
n == null ? delete this[e] : this[e] = n;
}
return t == null ? n : typeof t == "function" ? i : r;
}
function J(e) {
return {
__data__: e
};
}
function K(e) {
return function() {
return H(this, e);
};
}
function Q(t) {
return arguments.length || (t = e.ascending), function(e, n) {
return !e - !n || t(e.__data__, n.__data__);
};
}
function G() {}
function Y(t, n, r) {
function a() {
var e = this[i];
e && (this.removeEventListener(t, e, e.$), delete this[i]);
}
function f() {
var e = o(n, N(arguments));
a.call(this), this.addEventListener(t, this[i] = e, e.$ = r), e._ = n;
}
function l() {
var n = new RegExp("^__on([^.]+)" + e.requote(t) + "$"), r;
for (var i in this) if (r = i.match(n)) {
var s = this[i];
this.removeEventListener(r[1], s, s.$), delete this[i];
}
}
var i = "__on" + t, s = t.indexOf("."), o = et;
s > 0 && (t = t.substring(0, s));
var u = Z.get(t);
return u && (t = u, o = tt), s ? n ? f : a : n ? G : l;
}
function et(t, n) {
return function(r) {
var i = e.event;
e.event = r, n[0] = this.__data__;
try {
t.apply(this, n);
} finally {
e.event = i;
}
};
}
function tt(e, t) {
var n = et(e, t);
return function(e) {
var t = this, r = e.relatedTarget;
(!r || r !== t && !(r.compareDocumentPosition(t) & 8)) && n.call(t, e);
};
}
function nt(e, t) {
for (var n = 0, r = e.length; n < r; n++) for (var i = e[n], s = 0, o = i.length, u; s < o; s++) (u = i[s]) && t(u, s, n);
return e;
}
function rt(e) {
return A(e, it), e;
}
function ft() {}
function lt(e, t, n) {
return new ct(e, t, n);
}
function ct(e, t, n) {
this.h = e, this.s = t, this.l = n;
}
function pt(e, t, n) {
function s(e) {
return e > 360 ? e -= 360 : e < 0 && (e += 360), e < 60 ? r + (i - r) * e / 60 : e < 180 ? i : e < 240 ? r + (i - r) * (240 - e) / 60 : r;
}
function o(e) {
return Math.round(s(e) * 255);
}
var r, i;
return e %= 360, e < 0 && (e += 360), t = t < 0 ? 0 : t > 1 ? 1 : t, n = n < 0 ? 0 : n > 1 ? 1 : n, i = n <= .5 ? n * (1 + t) : n + t - n * t, r = 2 * n - i, qt(o(e + 120), o(e), o(e - 120));
}
function yt(e) {
return e > 0 ? 1 : e < 0 ? -1 : 0;
}
function bt(e) {
return Math.acos(Math.max(-1, Math.min(1, e)));
}
function wt(e) {
return e > 1 ? dt / 2 : e < -1 ? -dt / 2 : Math.asin(e);
}
function Et(e) {
return (Math.exp(e) - Math.exp(-e)) / 2;
}
function St(e) {
return (Math.exp(e) + Math.exp(-e)) / 2;
}
function xt(e) {
return (e = Math.sin(e / 2)) * e;
}
function Tt(e, t, n) {
return new Nt(e, t, n);
}
function Nt(e, t, n) {
this.h = e, this.c = t, this.l = n;
}
function kt(e, t, n) {
return Lt(n, Math.cos(e *= mt) * t, Math.sin(e) * t);
}
function Lt(e, t, n) {
return new At(e, t, n);
}
function At(e, t, n) {
this.l = e, this.a = t, this.b = n;
}
function Ht(e, t, n) {
var r = (e + 16) / 116, i = r + t / 500, s = r - n / 200;
return i = jt(i) * Mt, r = jt(r) * _t, s = jt(s) * Dt, qt(It(3.2404542 * i - 1.5371385 * r - .4985314 * s), It(-0.969266 * i + 1.8760108 * r + .041556 * s), It(.0556434 * i - .2040259 * r + 1.0572252 * s));
}
function Bt(e, t, n) {
return Tt(Math.atan2(n, t) * gt, Math.sqrt(t * t + n * n), e);
}
function jt(e) {
return e > .206893034 ? e * e * e : (e - 4 / 29) / 7.787037;
}
function Ft(e) {
return e > .008856 ? Math.pow(e, 1 / 3) : 7.787037 * e + 4 / 29;
}
function It(e) {
return Math.round(255 * (e <= .00304 ? 12.92 * e : 1.055 * Math.pow(e, 1 / 2.4) - .055));
}
function qt(e, t, n) {
return new Rt(e, t, n);
}
function Rt(e, t, n) {
this.r = e, this.g = t, this.b = n;
}
function zt(e) {
return e < 16 ? "0" + Math.max(0, e).toString(16) : Math.min(255, e).toString(16);
}
function Wt(e, t, n) {
var r = 0, i = 0, s = 0, o, u, a;
o = /([a-z]+)\((.*)\)/i.exec(e);
if (o) {
u = o[2].split(",");
switch (o[1]) {
case "hsl":
return n(parseFloat(u[0]), parseFloat(u[1]) / 100, parseFloat(u[2]) / 100);
case "rgb":
return t(Jt(u[0]), Jt(u[1]), Jt(u[2]));
}
}
return (a = Kt.get(e)) ? t(a.r, a.g, a.b) : (e != null && e.charAt(0) === "#" && (e.length === 4 ? (r = e.charAt(1), r += r, i = e.charAt(2), i += i, s = e.charAt(3), s += s) : e.length === 7 && (r = e.substring(1, 3), i = e.substring(3, 5), s = e.substring(5, 7)), r = parseInt(r, 16), i = parseInt(i, 16), s = parseInt(s, 16)), t(r, i, s));
}
function Xt(e, t, n) {
var r = Math.min(e /= 255, t /= 255, n /= 255), i = Math.max(e, t, n), s = i - r, o, u, a = (i + r) / 2;
return s ? (u = a < .5 ? s / (i + r) : s / (2 - i - r), e == i ? o = (t - n) / s + (t < n ? 6 : 0) : t == i ? o = (n - e) / s + 2 : o = (e - t) / s + 4, o *= 60) : u = o = 0, lt(o, u, a);
}
function Vt(e, t, n) {
e = $t(e), t = $t(t), n = $t(n);
var r = Ft((.4124564 * e + .3575761 * t + .1804375 * n) / Mt), i = Ft((.2126729 * e + .7151522 * t + .072175 * n) / _t), s = Ft((.0193339 * e + .119192 * t + .9503041 * n) / Dt);
return Lt(116 * i - 16, 500 * (r - i), 200 * (i - s));
}
function $t(e) {
return (e /= 255) <= .04045 ? e / 12.92 : Math.pow((e + .055) / 1.055, 2.4);
}
function Jt(e) {
var t = parseFloat(e);
return e.charAt(e.length - 1) === "%" ? Math.round(t * 2.55) : t;
}
function Qt(e) {
return typeof e == "function" ? e : function() {
return e;
};
}
function Gt(e) {
return e;
}
function Yt(e) {
return e.length === 1 ? function(t, n) {
e(t == null ? n : null);
} : e;
}
function Zt(t, n) {
function s(t, r, i) {
arguments.length < 3 && (i = r, r = null);
var s = e.xhr(t, n, i);
return s.row = function(e) {
return arguments.length ? s.response((r = e) == null ? o : u(e)) : r;
}, s.row(r);
}
function o(e) {
return s.parse(e.responseText);
}
function u(e) {
return function(t) {
return s.parse(t.responseText, e);
};
}
function a(e) {
return e.map(f).join(t);
}
function f(e) {
return r.test(e) ? '"' + e.replace(/\"/g, '""') + '"' : e;
}
var r = new RegExp('["' + t + "\n]"), i = t.charCodeAt(0);
return s.parse = function(e, t) {
var n;
return s.parseRows(e, function(e, r) {
if (n) return n(e, r - 1);
var i = new Function("d", "return {" + e.map(function(e, t) {
return JSON.stringify(e) + ": d[" + t + "]";
}).join(",") + "}");
n = t ? function(e, n) {
return t(i(e), n);
} : i;
});
}, s.parseRows = function(e, t) {
function c() {
if (u >= o) return r;
if (l) return l = !1, n;
var t = u;
if (e.charCodeAt(t) === 34) {
var s = t;
while (s++ < o) if (e.charCodeAt(s) === 34) {
if (e.charCodeAt(s + 1) !== 34) break;
++s;
}
u = s + 2;
var a = e.charCodeAt(s + 1);
return a === 13 ? (l = !0, e.charCodeAt(s + 2) === 10 && ++u) : a === 10 && (l = !0), e.substring(t + 1, s).replace(/""/g, '"');
}
while (u < o) {
var a = e.charCodeAt(u++), f = 1;
if (a === 10) l = !0; else if (a === 13) l = !0, e.charCodeAt(u) === 10 && (++u, ++f); else if (a !== i) continue;
return e.substring(t, u - f);
}
return e.substring(t);
}
var n = {}, r = {}, s = [], o = e.length, u = 0, a = 0, f, l;
while ((f = c()) !== r) {
var h = [];
while (f !== n && f !== r) h.push(f), f = c();
if (t && !(h = t(h, a++))) continue;
s.push(h);
}
return s;
}, s.format = function(e) {
if (Array.isArray(e[0])) return s.formatRows(e);
var n = new d, r = [];
return e.forEach(function(e) {
for (var t in e) n.has(t) || r.push(n.add(t));
}), [ r.map(f).join(t) ].concat(e.map(function(e) {
return r.map(function(t) {
return f(e[t]);
}).join(t);
})).join("\n");
}, s.formatRows = function(e) {
return e.map(a).join("\n");
}, s;
}
function on() {
var e, t = Date.now(), n = nn;
while (n) e = t - n.then, e >= n.delay && (n.flush = n.callback(e)), n = n.next;
var r = un() - t;
r > 24 ? (isFinite(r) && (clearTimeout(sn), sn = setTimeout(on, r)), rn = 0) : (rn = 1, an(on));
}
function un() {
var e = null, t = nn, n = Infinity;
while (t) t.flush ? (delete tn[t.callback.id], t = e ? e.next = t.next : nn = t.next) : (n = Math.min(n, t.then + t.delay), t = (e = t).next);
return n;
}
function pn(e, t) {
var n = Math.pow(10, Math.abs(8 - t) * 3);
return {
scale: t > 8 ? function(e) {
return e / n;
} : function(e) {
return e * n;
},
symbol: e
};
}
function mn(e, t) {
return t - (e ? Math.ceil(Math.log(e) / Math.LN10) : 1);
}
function gn(e) {
return e + "";
}
function wn(e, t) {
e && Sn.hasOwnProperty(e.type) && Sn[e.type](e, t);
}
function xn(e, t, n) {
var r = -1, i = e.length - n, s;
t.lineStart();
while (++r < i) s = e[r], t.point(s[0], s[1]);
t.lineEnd();
}
function Tn(e, t) {
var n = -1, r = e.length;
t.polygonStart();
while (++n < r) xn(e[n], t, 1);
t.polygonEnd();
}
function An() {
function s(e, t) {
e *= mt, t = t * mt / 2 + dt / 4;
var s = e - n, o = Math.cos(t), u = Math.sin(t), a = i * u, f = Cn, l = kn, c = r * o + a * Math.cos(s), h = a * Math.sin(s);
Cn = f * c - l * h, kn = l * c + f * h, n = e, r = o, i = u;
}
var e, t, n, r, i;
Ln.point = function(o, u) {
Ln.point = s, n = (e = o) * mt, r = Math.cos(u = (t = u) * mt / 2 + dt / 4), i = Math.sin(u);
}, Ln.lineEnd = function() {
s(e, t);
};
}
function On(t) {
function u(e, t) {
e < n && (n = e), e > i && (i = e), t < r && (r = t), t > s && (s = t);
}
function a() {
o.point = o.lineEnd = G;
}
var n, r, i, s, o = {
point: u,
lineStart: G,
lineEnd: G,
polygonStart: function() {
o.lineEnd = a;
},
polygonEnd: function() {
o.point = u;
}
};
return function(u) {
return s = i = -(n = r = Infinity), e.geo.stream(u, t(o)), [ [ n, r ], [ i, s ] ];
};
}
function jn(e, t) {
if (Mn) return;
++_n, e *= mt;
var n = Math.cos(t *= mt);
Dn += (n * Math.cos(e) - Dn) / _n, Pn += (n * Math.sin(e) - Pn) / _n, Hn += (Math.sin(t) - Hn) / _n;
}
function Fn() {
var e, t;
Mn = 1, In(), Mn = 2;
var n = Bn.point;
Bn.point = function(r, i) {
n(e = r, t = i);
}, Bn.lineEnd = function() {
Bn.point(e, t), qn(), Bn.lineEnd = qn;
};
}
function In() {
function r(r, i) {
r *= mt;
var s = Math.cos(i *= mt), o = s * Math.cos(r), u = s * Math.sin(r), a = Math.sin(i), f = Math.atan2(Math.sqrt((f = t * a - n * u) * f + (f = n * o - e * a) * f + (f = e * u - t * o) * f), e * o + t * u + n * a);
_n += f, Dn += f * (e + (e = o)), Pn += f * (t + (t = u)), Hn += f * (n + (n = a));
}
var e, t, n;
if (Mn > 1) return;
Mn < 1 && (Mn = 1, _n = Dn = Pn = Hn = 0), Bn.point = function(i, s) {
i *= mt;
var o = Math.cos(s *= mt);
e = o * Math.cos(i), t = o * Math.sin(i), n = Math.sin(s), Bn.point = r;
};
}
function qn() {
Bn.point = jn;
}
function Rn(e) {
var t = e[0], n = e[1], r = Math.cos(n);
return [ r * Math.cos(t), r * Math.sin(t), Math.sin(n) ];
}
function Un(e, t) {
return e[0] * t[0] + e[1] * t[1] + e[2] * t[2];
}
function zn(e, t) {
return [ e[1] * t[2] - e[2] * t[1], e[2] * t[0] - e[0] * t[2], e[0] * t[1] - e[1] * t[0] ];
}
function Wn(e, t) {
e[0] += t[0], e[1] += t[1], e[2] += t[2];
}
function Xn(e, t) {
return [ e[0] * t, e[1] * t, e[2] * t ];
}
function Vn(e) {
var t = Math.sqrt(e[0] * e[0] + e[1] * e[1] + e[2] * e[2]);
e[0] /= t, e[1] /= t, e[2] /= t;
}
function $n() {
return !0;
}
function Jn(e) {
return [ Math.atan2(e[1], e[0]), Math.asin(Math.max(-1, Math.min(1, e[2]))) ];
}
function Kn(e, t) {
return Math.abs(e[0] - t[0]) < vt && Math.abs(e[1] - t[1]) < vt;
}
function Qn(e, t, n, r, i) {
var s = [], o = [];
e.forEach(function(e) {
if ((t = e.length - 1) <= 0) return;
var t, n = e[0], r = e[t];
if (Kn(n, r)) {
i.lineStart();
for (var u = 0; u < t; ++u) i.point((n = e[u])[0], n[1]);
i.lineEnd();
return;
}
var a = {
point: n,
points: e,
other: null,
visited: !1,
entry: !0,
subject: !0
}, f = {
point: n,
points: [ n ],
other: a,
visited: !1,
entry: !1,
subject: !1
};
a.other = f, s.push(a), o.push(f), a = {
point: r,
points: [ r ],
other: null,
visited: !1,
entry: !1,
subject: !0
}, f = {
point: r,
points: [ r ],
other: a,
visited: !1,
entry: !0,
subject: !1
}, a.other = f, s.push(a), o.push(f);
}), o.sort(t), Gn(s), Gn(o);
if (!s.length) return;
if (n) for (var u = 1, a = !n(o[0].point), f = o.length; u < f; ++u) o[u].entry = a = !a;
var l = s[0], c, h, p;
for (;;) {
c = l;
while (c.visited) if ((c = c.next) === l) return;
h = c.points, i.lineStart();
do {
c.visited = c.other.visited = !0;
if (c.entry) {
if (c.subject) for (var u = 0; u < h.length; u++) i.point((p = h[u])[0], p[1]); else r(c.point, c.next.point, 1, i);
c = c.next;
} else {
if (c.subject) {
h = c.prev.points;
for (var u = h.length; --u >= 0; ) i.point((p = h[u])[0], p[1]);
} else r(c.point, c.prev.point, -1, i);
c = c.prev;
}
c = c.other, h = c.points;
} while (!c.visited);
i.lineEnd();
}
}
function Gn(e) {
if (!(t = e.length)) return;
var t, n = 0, r = e[0], i;
while (++n < t) r.next = i = e[n], i.prev = r, r = i;
r.next = i = e[0], i.prev = r;
}
function Yn(t, n, r) {
return function(i) {
function u(e, n) {
t(e, n) && i.point(e, n);
}
function a(e, t) {
s.point(e, t);
}
function f() {
o.point = a, s.lineStart();
}
function l() {
o.point = u, s.lineEnd();
}
function y(e, t) {
m.point(e, t), g.push([ e, t ]);
}
function b() {
m.lineStart(), g = [];
}
function w() {
y(g[0][0], g[0][1]), m.lineEnd();
var e = m.clean(), t = v.buffer(), n, r = t.length;
if (!r) {
d = !0, p += tr(g, -1), g = null;
return;
}
g = null;
if (e & 1) {
n = t[0], h += tr(n, 1);
var r = n.length - 1, s = -1, o;
i.lineStart();
while (++s < r) i.point((o = n[s])[0], o[1]);
i.lineEnd();
return;
}
r > 1 && e & 2 && t.push(t.pop().concat(t.shift())), c.push(t.filter(Zn));
}
var s = n(i), o = {
point: u,
lineStart: f,
lineEnd: l,
polygonStart: function() {
o.point = y, o.lineStart = b, o.lineEnd = w, d = !1, p = h = 0, c = [], i.polygonStart();
},
polygonEnd: function() {
o.point = u, o.lineStart = f, o.lineEnd = l, c = e.merge(c);
if (c.length) Qn(c, nr, null, r, i); else if (h < -vt || d && p < -vt) i.lineStart(), r(null, null, 1, i), i.lineEnd();
i.polygonEnd(), c = null;
},
sphere: function() {
i.polygonStart(), i.lineStart(), r(null, null, 1, i), i.lineEnd(), i.polygonEnd();
}
}, c, h, p, d, v = er(), m = n(v), g;
return o;
};
}
function Zn(e) {
return e.length > 1;
}
function er() {
var e = [], t;
return {
lineStart: function() {
e.push(t = []);
},
point: function(e, n) {
t.push([ e, n ]);
},
lineEnd: G,
buffer: function() {
var n = e;
return e = [], t = null, n;
},
rejoin: function() {
e.length > 1 && e.push(e.pop().concat(e.shift()));
}
};
}
function tr(e, t) {
if (!(n = e.length)) return 0;
var n, r = 0, i = 0, s = e[0], o = s[0], u = s[1], a = Math.cos(u), f = Math.atan2(t * Math.sin(o) * a, Math.sin(u)), l = 1 - t * Math.cos(o) * a, c = f, h, p;
while (++r < n) {
s = e[r], a = Math.cos(u = s[1]), h = Math.atan2(t * Math.sin(o = s[0]) * a, Math.sin(u)), p = 1 - t * Math.cos(o) * a;
if (Math.abs(l - 2) < vt && Math.abs(p - 2) < vt) continue;
Math.abs(p) < vt || Math.abs(l) < vt || (Math.abs(Math.abs(h - f) - dt) < vt ? p + l > 2 && (i += 4 * (h - f)) : Math.abs(l - 2) < vt ? i += 4 * (h - c) : i += ((3 * dt + h - f) % (2 * dt) - dt) * (l + p)), c = f, f = h, l = p;
}
return i;
}
function nr(e, t) {
return ((e = e.point)[0] < 0 ? e[1] - dt / 2 - vt : dt / 2 - e[1]) - ((t = t.point)[0] < 0 ? t[1] - dt / 2 - vt : dt / 2 - t[1]);
}
function ir(e) {
var t = NaN, n = NaN, r = NaN, i;
return {
lineStart: function() {
e.lineStart(), i = 1;
},
point: function(s, o) {
var u = s > 0 ? dt : -dt, a = Math.abs(s - t);
Math.abs(a - dt) < vt ? (e.point(t, n = (n + o) / 2 > 0 ? dt / 2 : -dt / 2), e.point(r, n), e.lineEnd(), e.lineStart(), e.point(u, n), e.point(s, n), i = 0) : r !== u && a >= dt && (Math.abs(t - r) < vt && (t -= r * vt), Math.abs(s - u) < vt && (s -= u * vt), n = sr(t, n, s, o), e.point(r, n), e.lineEnd(), e.lineStart(), e.point(u, n), i = 0), e.point(t = s, n = o), r = u;
},
lineEnd: function() {
e.lineEnd(), t = n = NaN;
},
clean: function() {
return 2 - i;
}
};
}
function sr(e, t, n, r) {
var i, s, o = Math.sin(e - n);
return Math.abs(o) > vt ? Math.atan((Math.sin(t) * (s = Math.cos(r)) * Math.sin(n) - Math.sin(r) * (i = Math.cos(t)) * Math.sin(e)) / (i * s * o)) : (t + r) / 2;
}
function or(e, t, n, r) {
var i;
if (e == null) i = n * dt / 2, r.point(-dt, i), r.point(0, i), r.point(dt, i), r.point(dt, 0), r.point(dt, -i), r.point(0, -i), r.point(-dt, -i), r.point(-dt, 0), r.point(-dt, i); else if (Math.abs(e[0] - t[0]) > vt) {
var s = (e[0] < t[0] ? 1 : -1) * dt;
i = n * s / 2, r.point(-s, i), r.point(0, i), r.point(s, i);
} else r.point(t[0], t[1]);
}
function ur(e) {
function s(e, n) {
return Math.cos(e) * Math.cos(n) > t;
}
function o(e) {
var t, i, o, f, l;
return {
lineStart: function() {
f = o = !1, l = 1;
},
point: function(c, h) {
var p = [ c, h ], d, v = s(c, h), m = n ? v ? 0 : a(c, h) : v ? a(c + (c < 0 ? dt : -dt), h) : 0;
!t && (f = o = v) && e.lineStart();
if (v !== o) {
d = u(t, p);
if (Kn(t, d) || Kn(p, d)) p[0] += vt, p[1] += vt, v = s(p[0], p[1]);
}
if (v !== o) l = 0, v ? (e.lineStart(), d = u(p, t), e.point(d[0], d[1])) : (d = u(t, p), e.point(d[0], d[1]), e.lineEnd()), t = d; else if (r && t && n ^ v) {
var g;
!(m & i) && (g = u(p, t, !0)) && (l = 0, n ? (e.lineStart(), e.point(g[0][0], g[0][1]), e.point(g[1][0], g[1][1]), e.lineEnd()) : (e.point(g[1][0], g[1][1]), e.lineEnd(), e.lineStart(), e.point(g[0][0], g[0][1])));
}
v && (!t || !Kn(t, p)) && e.point(p[0], p[1]), t = p, o = v, i = m;
},
lineEnd: function() {
o && e.lineEnd(), t = null;
},
clean: function() {
return l | (f && o) << 1;
}
};
}
function u(e, n, r) {
var i = Rn(e), s = Rn(n), o = [ 1, 0, 0 ], u = zn(i, s), a = Un(u, u), f = u[0], l = a - f * f;
if (!l) return !r && e;
var c = t * a / l, h = -t * f / l, p = zn(o, u), d = Xn(o, c), v = Xn(u, h);
Wn(d, v);
var m = p, g = Un(d, m), y = Un(m, m), b = g * g - y * (Un(d, d) - 1);
if (b < 0) return;
var w = Math.sqrt(b), E = Xn(m, (-g - w) / y);
Wn(E, d), E = Jn(E);
if (!r) return E;
var S = e[0], x = n[0], T = e[1], N = n[1], C;
x < S && (C = S, S = x, x = C);
var k = x - S, L = Math.abs(k - dt) < vt, A = L || k < vt;
!L && N < T && (C = T, T = N, N = C);
if (A ? L ? T + N > 0 ^ E[1] < (Math.abs(E[0] - S) < vt ? T : N) : T <= E[1] && E[1] <= N : k > dt ^ (S <= E[0] && E[0] <= x)) {
var O = Xn(m, (-g + w) / y);
return Wn(O, d), [ E, Jn(O) ];
}
}
function a(t, r) {
var i = n ? e : dt - e, s = 0;
return t < -i ? s |= 1 : t > i && (s |= 2), r < -i ? s |= 4 : r > i && (s |= 8), s;
}
var t = Math.cos(e), n = t > 0, r = Math.abs(t) > vt, i = Er(e, 6 * mt);
return Yn(s, o, i);
}
function fr(t, n, r, i) {
function s(e, i) {
return Math.abs(e[0] - t) < vt ? i > 0 ? 0 : 3 : Math.abs(e[0] - r) < vt ? i > 0 ? 2 : 1 : Math.abs(e[1] - n) < vt ? i > 0 ? 1 : 0 : i > 0 ? 3 : 2;
}
function o(e, t) {
return u(e.point, t.point);
}
function u(e, t) {
var n = s(e, 1), r = s(t, 1);
return n !== r ? n - r : n === 0 ? t[1] - e[1] : n === 1 ? e[0] - t[0] : n === 2 ? e[1] - t[1] : t[0] - e[0];
}
function a(e, s) {
var o = s[0] - e[0], u = s[1] - e[1], a = [ 0, 1 ];
return Math.abs(o) < vt && Math.abs(u) < vt ? t <= e[0] && e[0] <= r && n <= e[1] && e[1] <= i : lr(t - e[0], o, a) && lr(e[0] - r, -o, a) && lr(n - e[1], u, a) && lr(e[1] - i, -u, a) ? (a[1] < 1 && (s[0] = e[0] + a[1] * o, s[1] = e[1] + a[1] * u), a[0] > 0 && (e[0] += a[0] * o, e[1] += a[0] * u), !0) : !1;
}
return function(f) {
function m(e) {
var o = s(e, -1), u = g([ o === 0 || o === 3 ? t : r, o > 1 ? i : n ]);
return u;
}
function g(e) {
var t = 0, n = p.length, r = e[1];
for (var i = 0; i < n; ++i) for (var s = 1, o = p[i], u = o.length, a = o[0]; s < u; ++s) b = o[s], a[1] <= r ? b[1] > r && y(a, b, e) > 0 && ++t : b[1] <= r && y(a, b, e) < 0 && --t, a = b;
return t !== 0;
}
function y(e, t, n) {
return (t[0] - e[0]) * (n[1] - e[1]) - (n[0] - e[0]) * (t[1] - e[1]);
}
function w(e, o, a, f) {
var l = 0, c = 0;
if (e == null || (l = s(e, a)) !== (c = s(o, a)) || u(e, o) < 0 ^ a > 0) {
do f.point(l === 0 || l === 3 ? t : r, l > 1 ? i : n); while ((l = (l + a + 4) % 4) !== c);
} else f.point(o[0], o[1]);
}
function E(e, s) {
return t <= e && e <= r && n <= s && s <= i;
}
function S(e, t) {
E(e, t) && f.point(e, t);
}
function O() {
v.point = _, p && p.push(d = []), A = !0, L = !1, C = k = NaN;
}
function M() {
h && (_(x, T), N && L && c.rejoin(), h.push(c.buffer())), v.point = S, L && f.lineEnd();
}
function _(e, t) {
e = Math.max(-ar, Math.min(ar, e)), t = Math.max(-ar, Math.min(ar, t));
var n = E(e, t);
p && d.push([ e, t ]);
if (A) x = e, T = t, N = n, A = !1, n && (f.lineStart(), f.point(e, t)); else if (n && L) f.point(e, t); else {
var r = [ C, k ], i = [ e, t ];
a(r, i) ? (L || (f.lineStart(), f.point(r[0], r[1])), f.point(i[0], i[1]), n || f.lineEnd()) : (f.lineStart(), f.point(e, t));
}
C = e, k = t, L = n;
}
var l = f, c = er(), h, p, d, v = {
point: S,
lineStart: O,
lineEnd: M,
polygonStart: function() {
f = c, h = [], p = [];
},
polygonEnd: function() {
f = l, (h = e.merge(h)).length ? (f.polygonStart(), Qn(h, o, m, w, f), f.polygonEnd()) : g([ t, n ]) && (f.polygonStart(), f.lineStart(), w(null, null, 1, f), f.lineEnd(), f.polygonEnd()), h = p = d = null;
}
}, x, T, N, C, k, L, A;
return v;
};
}
function lr(e, t, n) {
if (Math.abs(t) < vt) return e <= 0;
var r = e / t;
if (t > 0) {
if (r > n[1]) return !1;
r > n[0] && (n[0] = r);
} else {
if (r < n[0]) return !1;
r < n[1] && (n[1] = r);
}
return !0;
}
function cr(e, t) {
function n(n, r) {
return n = e(n, r), t(n[0], n[1]);
}
return e.invert && t.invert && (n.invert = function(n, r) {
return n = t.invert(n, r), n && e.invert(n[0], n[1]);
}), n;
}
function hr(e) {
function r(t) {
function c(n, r) {
n = e(n, r), t.point(n[0], n[1]);
}
function h() {
s = NaN, l.point = p, t.lineStart();
}
function p(l, c) {
var h = Rn([ l, c ]), p = e(l, c);
i(s, o, r, u, a, f, s = p[0], o = p[1], r = l, u = h[0], a = h[1], f = h[2], n, t), t.point(s, o);
}
function d() {
l.point = c, t.lineEnd();
}
function v() {
var e, c, v, m, g, y, b;
h(), l.point = function(t, n) {
p(e = t, c = n), v = s, m = o, g = u, y = a, b = f, l.point = p;
}, l.lineEnd = function() {
i(s, o, r, u, a, f, v, m, e, g, y, b, n, t), l.lineEnd = d, d();
};
}
var r, s, o, u, a, f, l = {
point: c,
lineStart: h,
lineEnd: d,
polygonStart: function() {
t.polygonStart(), l.lineStart = v;
},
polygonEnd: function() {
t.polygonEnd(), l.lineStart = h;
}
};
return l;
}
function i(n, r, s, o, u, a, f, l, c, h, p, d, v, m) {
var g = f - n, y = l - r, b = g * g + y * y;
if (b > 4 * t && v--) {
var w = o + h, E = u + p, S = a + d, x = Math.sqrt(w * w + E * E + S * S), T = Math.asin(S /= x), N = Math.abs(Math.abs(S) - 1) < vt ? (s + c) / 2 : Math.atan2(E, w), C = e(N, T), k = C[0], L = C[1], A = k - n, O = L - r, M = y * A - g * O;
if (M * M / b > t || Math.abs((g * A + y * O) / b - .5) > .3) i(n, r, s, o, u, a, k, L, N, w /= x, E /= x, S, v, m), m.point(k, L), i(k, L, N, w, E, S, f, l, c, h, p, d, v, m);
}
}
var t = .5, n = 16;
return r.precision = function(e) {
return arguments.length ? (n = (t = e * e) > 0 && 16, r) : Math.sqrt(t);
}, r;
}
function pr(e) {
return dr(function() {
return e;
})();
}
function dr(t) {
function w(e) {
return e = i(e[0] * mt, e[1] * mt), [ e[0] * o + d, v - e[1] * o ];
}
function E(e) {
return e = i.invert((e[0] - d) / o, (v - e[1]) / o), e && [ e[0] * gt, e[1] * gt ];
}
function S() {
i = cr(r = gr(c, h, p), n);
var e = n(f, l);
return d = u - e[0] * o, v = a + e[1] * o, w;
}
var n, r, i, s = hr(function(e, t) {
return e = n(e, t), [ e[0] * o + d, v - e[1] * o ];
}), o = 150, u = 480, a = 250, f = 0, l = 0, c = 0, h = 0, p = 0, d, v, m = rr, g = Gt, y = null, b = null;
return w.stream = function(e) {
return vr(r, m(s(g(e))));
}, w.clipAngle = function(e) {
return arguments.length ? (m = e == null ? (y = e, rr) : ur((y = +e) * mt), w) : y;
}, w.clipExtent = function(e) {
return arguments.length ? (b = e, g = e == null ? Gt : fr(e[0][0], e[0][1], e[1][0], e[1][1]), w) : b;
}, w.scale = function(e) {
return arguments.length ? (o = +e, S()) : o;
}, w.translate = function(e) {
return arguments.length ? (u = +e[0], a = +e[1], S()) : [ u, a ];
}, w.center = function(e) {
return arguments.length ? (f = e[0] % 360 * mt, l = e[1] % 360 * mt, S()) : [ f * gt, l * gt ];
}, w.rotate = function(e) {
return arguments.length ? (c = e[0] % 360 * mt, h = e[1] % 360 * mt, p = e.length > 2 ? e[2] % 360 * mt : 0, S()) : [ c * gt, h * gt, p * gt ];
}, e.rebind(w, s, "precision"), function() {
return n = t.apply(this, arguments), w.invert = n.invert && E, S();
};
}
function vr(e, t) {
return {
point: function(n, r) {
r = e(n * mt, r * mt), n = r[0], t.point(n > dt ? n - 2 * dt : n < -dt ? n + 2 * dt : n, r[1]);
},
sphere: function() {
t.sphere();
},
lineStart: function() {
t.lineStart();
},
lineEnd: function() {
t.lineEnd();
},
polygonStart: function() {
t.polygonStart();
},
polygonEnd: function() {
t.polygonEnd();
}
};
}
function mr(e, t) {
return [ e, t ];
}
function gr(e, t, n) {
return e ? t || n ? cr(br(e), wr(t, n)) : br(e) : t || n ? wr(t, n) : mr;
}
function yr(e) {
return function(t, n) {
return t += e, [ t > dt ? t - 2 * dt : t < -dt ? t + 2 * dt : t, n ];
};
}
function br(e) {
var t = yr(e);
return t.invert = yr(-e), t;
}
function wr(e, t) {
function o(e, t) {
var o = Math.cos(t), u = Math.cos(e) * o, a = Math.sin(e) * o, f = Math.sin(t), l = f * n + u * r;
return [ Math.atan2(a * i - l * s, u * n - f * r), Math.asin(Math.max(-1, Math.min(1, l * i + a * s))) ];
}
var n = Math.cos(e), r = Math.sin(e), i = Math.cos(t), s = Math.sin(t);
return o.invert = function(e, t) {
var o = Math.cos(t), u = Math.cos(e) * o, a = Math.sin(e) * o, f = Math.sin(t), l = f * i - a * s;
return [ Math.atan2(a * i + f * s, u * n + l * r), Math.asin(Math.max(-1, Math.min(1, l * n - u * r))) ];
}, o;
}
function Er(e, t) {
var n = Math.cos(e), r = Math.sin(e);
return function(i, s, o, u) {
if (i != null) {
i = Sr(n, i), s = Sr(n, s);
if (o > 0 ? i < s : i > s) i += o * 2 * dt;
} else i = e + o * 2 * dt, s = e;
var a;
for (var f = o * t, l = i; o > 0 ? l > s : l < s; l -= f) u.point((a = Jn([ n, -r * Math.cos(l), -r * Math.sin(l) ]))[0], a[1]);
};
}
function Sr(e, t) {
var n = Rn(t);
n[0] -= e, Vn(n);
var r = bt(-n[1]);
return ((-n[2] < 0 ? -r : r) + 2 * Math.PI - vt) % (2 * Math.PI);
}
function xr(t, n, r) {
var i = e.range(t, n - vt, r).concat(n);
return function(e) {
return i.map(function(t) {
return [ e, t ];
});
};
}
function Tr(t, n, r) {
var i = e.range(t, n - vt, r).concat(n);
return function(e) {
return i.map(function(t) {
return [ t, e ];
});
};
}
function Nr(e) {
return e.source;
}
function Cr(e) {
return e.target;
}
function kr(e, t, n, r) {
var i = Math.cos(t), s = Math.sin(t), o = Math.cos(r), u = Math.sin(r), a = i * Math.cos(e), f = i * Math.sin(e), l = o * Math.cos(n), c = o * Math.sin(n), h = 2 * Math.asin(Math.sqrt(xt(r - t) + i * o * xt(n - e))), p = 1 / Math.sin(h), d = h ? function(e) {
var t = Math.sin(e *= h) * p, n = Math.sin(h - e) * p, r = n * a + t * l, i = n * f + t * c, o = n * s + t * u;
return [ Math.atan2(i, r) * gt, Math.atan2(o, Math.sqrt(r * r + i * i)) * gt ];
} : function() {
return [ e * gt, t * gt ];
};
return d.distance = h, d;
}
function Or() {
function r(r, i) {
var s = Math.sin(i *= mt), o = Math.cos(i), u = Math.abs((r *= mt) - e), a = Math.cos(u);
Lr += Math.atan2(Math.sqrt((u = o * Math.sin(u)) * u + (u = n * s - t * o * a) * u), t * s + n * o * a), e = r, t = s, n = o;
}
var e, t, n;
Ar.point = function(i, s) {
e = i * mt, t = Math.sin(s *= mt), n = Math.cos(s), Ar.point = r;
}, Ar.lineEnd = function() {
Ar.point = Ar.lineEnd = G;
};
}
function Mr(e) {
var t = 0, n = dt / 3, r = dr(e), i = r(t, n);
return i.parallels = function(e) {
return arguments.length ? r(t = e[0] * dt / 180, n = e[1] * dt / 180) : [ t / dt * 180, n / dt * 180 ];
}, i;
}
function _r(e, t) {
function o(e, t) {
var n = Math.sqrt(i - 2 * r * Math.sin(t)) / r;
return [ n * Math.sin(e *= r), s - n * Math.cos(e) ];
}
var n = Math.sin(e), r = (n + Math.sin(t)) / 2, i = 1 + n * (2 * r - n), s = Math.sqrt(i) / r;
return o.invert = function(e, t) {
var n = s - t;
return [ Math.atan2(e, n) / r, Math.asin((i - (e * e + n * n) * r * r) / (2 * r)) ];
}, o;
}
function Dr(e, t) {
var n = e(t[0]), r = e([ .5 * (t[0][0] + t[1][0]), t[0][1] ]), i = e([ t[1][0], t[0][1] ]), s = e(t[1]), o = r[1] - n[1], u = r[0] - n[0], a = i[1] - r[1], f = i[0] - r[0], l = o / u, c = a / f, h = .5 * (l * c * (n[1] - i[1]) + c * (n[0] + r[0]) - l * (r[0] + i[0])) / (c - l), p = (.5 * (n[0] + r[0]) - h) / l + .5 * (n[1] + r[1]), d = s[0] - h, v = s[1] - p, m = n[0] - h, g = n[1] - p, y = d * d + v * v, b = m * m + g * g, w = Math.atan2(v, d), E = Math.atan2(g, m);
return function(t) {
var n = t[0] - h, r = t[1] - p, i = n * n + r * r, s = Math.atan2(r, n);
if (y < i && i < b && w < s && s < E) return e.invert(t);
};
}
function jr() {
function i(e, t) {
Hr += r * e - n * t, n = e, r = t;
}
var e, t, n, r;
Br.point = function(s, o) {
Br.point = i, e = n = s, t = r = o;
}, Br.lineEnd = function() {
i(e, t);
};
}
function Fr() {
function r(n, r) {
t.push("M", n, ",", r, e);
}
function i(e, r) {
t.push("M", e, ",", r), n.point = s;
}
function s(e, n) {
t.push("L", e, ",", n);
}
function o() {
n.point = r;
}
function u() {
t.push("Z");
}
var e = Xr(4.5), t = [], n = {
point: r,
lineStart: function() {
n.point = i;
},
lineEnd: o,
polygonStart: function() {
n.lineEnd = u;
},
polygonEnd: function() {
n.lineEnd = o, n.point = r;
},
pointRadius: function(t) {
return e = Xr(t), n;
},
result: function() {
if (t.length) {
var e = t.join("");
return t = [], e;
}
}
};
return n;
}
function qr(e, t) {
if (Mn) return;
Dn += e, Pn += t, ++Hn;
}
function Rr() {
function n(n, r) {
var i = n - e, s = r - t, o = Math.sqrt(i * i + s * s);
Dn += o * (e + n) / 2, Pn += o * (t + r) / 2, Hn += o, e = n, t = r;
}
var e, t;
if (Mn !== 1) {
if (!(Mn < 1)) return;
Mn = 1, Dn = Pn = Hn = 0;
}
Ir.point = function(r, i) {
Ir.point = n, e = r, t = i;
};
}
function Ur() {
Ir.point = qr;
}
function zr() {
function i(e, t) {
var i = r * e - n * t;
Dn += i * (n + e), Pn += i * (r + t), Hn += i * 3, n = e, r = t;
}
var e, t, n, r;
Mn < 2 && (Mn = 2, Dn = Pn = Hn = 0), Ir.point = function(s, o) {
Ir.point = i, e = n = s, t = r = o;
}, Ir.lineEnd = function() {
i(e, t);
};
}
function Wr(e) {
function r(n, r) {
e.moveTo(n, r), e.arc(n, r, t, 0, 2 * dt);
}
function i(t, r) {
e.moveTo(t, r), n.point = s;
}
function s(t, n) {
e.lineTo(t, n);
}
function o() {
n.point = r;
}
function u() {
e.closePath();
}
var t = 4.5, n = {
point: r,
lineStart: function() {
n.point = i;
},
lineEnd: o,
polygonStart: function() {
n.lineEnd = u;
},
polygonEnd: function() {
n.lineEnd = o, n.point = r;
},
pointRadius: function(e) {
return t = e, n;
},
result: G
};
return n;
}
function Xr(e) {
return "m0," + e + "a" + e + "," + e + " 0 1,1 0," + -2 * e + "a" + e + "," + e + " 0 1,1 0," + 2 * e + "z";
}
function Vr(e) {
var t = hr(function(t, n) {
return e([ t * gt, n * gt ]);
});
return function(e) {
return e = t(e), {
point: function(t, n) {
e.point(t * mt, n * mt);
},
sphere: function() {
e.sphere();
},
lineStart: function() {
e.lineStart();
},
lineEnd: function() {
e.lineEnd();
},
polygonStart: function() {
e.polygonStart();
},
polygonEnd: function() {
e.polygonEnd();
}
};
};
}
function $r(e, t) {
function n(t, n) {
var r = Math.cos(t), i = Math.cos(n), s = e(r * i);
return [ s * i * Math.sin(t), s * Math.sin(n) ];
}
return n.invert = function(e, n) {
var r = Math.sqrt(e * e + n * n), i = t(r), s = Math.sin(i), o = Math.cos(i);
return [ Math.atan2(e * s, r * o), Math.asin(r && n * s / r) ];
}, n;
}
function Qr(e, t) {
function o(e, t) {
var n = Math.abs(Math.abs(t) - dt / 2) < vt ? 0 : s / Math.pow(r(t), i);
return [ n * Math.sin(i * e), s - n * Math.cos(i * e) ];
}
var n = Math.cos(e), r = function(e) {
return Math.tan(dt / 4 + e / 2);
}, i = e === t ? Math.sin(e) : Math.log(n / Math.cos(t)) / Math.log(r(t) / r(e)), s = n * Math.pow(r(e), i) / i;
return i ? (o.invert = function(e, t) {
var n = s - t, r = yt(i) * Math.sqrt(e * e + n * n);
return [ Math.atan2(e, n) / i, 2 * Math.atan(Math.pow(s / r, 1 / i)) - dt / 2 ];
}, o) : Zr;
}
function Gr(e, t) {
function s(e, t) {
var n = i - t;
return [ n * Math.sin(r * e), i - n * Math.cos(r * e) ];
}
var n = Math.cos(e), r = e === t ? Math.sin(e) : (n - Math.cos(t)) / (t - e), i = n / r + e;
return Math.abs(r) < vt ? mr : (s.invert = function(e, t) {
var n = i - t;
return [ Math.atan2(e, n) / r, i - yt(r) * Math.sqrt(e * e + n * n) ];
}, s);
}
function Zr(e, t) {
return [ e, Math.log(Math.tan(dt / 4 + t / 2)) ];
}
function ei(e) {
var t = pr(e), n = t.scale, r = t.translate, i = t.clipExtent, s;
return t.scale = function() {
var e = n.apply(t, arguments);
return e === t ? s ? t.clipExtent(null) : t : e;
}, t.translate = function() {
var e = r.apply(t, arguments);
return e === t ? s ? t.clipExtent(null) : t : e;
}, t.clipExtent = function(e) {
var o = i.apply(t, arguments);
if (o === t) {
if (s = e == null) {
var u = dt * n(), a = r();
i([ [ a[0] - u, a[1] - u ], [ a[0] + u, a[1] + u ] ]);
}
} else s && (o = null);
return o;
}, t.clipExtent(null);
}
function ri(e, t) {
var n = Math.cos(t) * Math.sin(e);
return [ Math.log((1 + n) / (1 - n)) / 2, Math.atan2(Math.tan(t), Math.cos(e)) ];
}
function ii(e) {
function u(s) {
function d() {
u.push("M", i(e(a), o));
}
var u = [], a = [], f = -1, l = s.length, c, h = Qt(t), p = Qt(n);
while (++f < l) r.call(this, c = s[f], f) ? a.push([ +h.call(this, c, f), +p.call(this, c, f) ]) : a.length && (d(), a = []);
return a.length && d(), u.length ? u.join("") : null;
}
var t = si, n = oi, r = $n, i = ai, s = i.key, o = .7;
return u.x = function(e) {
return arguments.length ? (t = e, u) : t;
}, u.y = function(e) {
return arguments.length ? (n = e, u) : n;
}, u.defined = function(e) {
return arguments.length ? (r = e, u) : r;
}, u.interpolate = function(e) {
return arguments.length ? (typeof e == "function" ? s = i = e : s = (i = ui.get(e) || ai).key, u) : s;
}, u.tension = function(e) {
return arguments.length ? (o = e, u) : o;
}, u;
}
function si(e) {
return e[0];
}
function oi(e) {
return e[1];
}
function ai(e) {
return e.join("L");
}
function fi(e) {
return ai(e) + "Z";
}
function li(e) {
var t = 0, n = e.length, r = e[0], i = [ r[0], ",", r[1] ];
while (++t < n) i.push("V", (r = e[t])[1], "H", r[0]);
return i.join("");
}
function ci(e) {
var t = 0, n = e.length, r = e[0], i = [ r[0], ",", r[1] ];
while (++t < n) i.push("H", (r = e[t])[0], "V", r[1]);
return i.join("");
}
function hi(e, t) {
return e.length < 4 ? ai(e) : e[1] + vi(e.slice(1, e.length - 1), mi(e, t));
}
function pi(e, t) {
return e.length < 3 ? ai(e) : e[0] + vi((e.push(e[0]), e), mi([ e[e.length - 2] ].concat(e, [ e[1] ]), t));
}
function di(e, t) {
return e.length < 3 ? ai(e) : e[0] + vi(e, mi(e, t));
}
function vi(e, t) {
if (t.length < 1 || e.length != t.length && e.length != t.length + 2) return ai(e);
var n = e.length != t.length, r = "", i = e[0], s = e[1], o = t[0], u = o, a = 1;
n && (r += "Q" + (s[0] - o[0] * 2 / 3) + "," + (s[1] - o[1] * 2 / 3) + "," + s[0] + "," + s[1], i = e[1], a = 2);
if (t.length > 1) {
u = t[1], s = e[a], a++, r += "C" + (i[0] + o[0]) + "," + (i[1] + o[1]) + "," + (s[0] - u[0]) + "," + (s[1] - u[1]) + "," + s[0] + "," + s[1];
for (var f = 2; f < t.length; f++, a++) s = e[a], u = t[f], r += "S" + (s[0] - u[0]) + "," + (s[1] - u[1]) + "," + s[0] + "," + s[1];
}
if (n) {
var l = e[a];
r += "Q" + (s[0] + u[0] * 2 / 3) + "," + (s[1] + u[1] * 2 / 3) + "," + l[0] + "," + l[1];
}
return r;
}
function mi(e, t) {
var n = [], r = (1 - t) / 2, i, s = e[0], o = e[1], u = 1, a = e.length;
while (++u < a) i = s, s = o, o = e[u], n.push([ r * (o[0] - i[0]), r * (o[1] - i[1]) ]);
return n;
}
function gi(e) {
if (e.length < 3) return ai(e);
var t = 1, n = e.length, r = e[0], i = r[0], s = r[1], o = [ i, i, i, (r = e[1])[0] ], u = [ s, s, s, r[1] ], a = [ i, ",", s ];
Ni(a, o, u);
while (++t < n) r = e[t], o.shift(), o.push(r[0]), u.shift(), u.push(r[1]), Ni(a, o, u);
t = -1;
while (++t < 2) o.shift(), o.push(r[0]), u.shift(), u.push(r[1]), Ni(a, o, u);
return a.join("");
}
function yi(e) {
if (e.length < 4) return ai(e);
var t = [], n = -1, r = e.length, i, s = [ 0 ], o = [ 0 ];
while (++n < 3) i = e[n], s.push(i[0]), o.push(i[1]);
t.push(Ei(Ti, s) + "," + Ei(Ti, o)), --n;
while (++n < r) i = e[n], s.shift(), s.push(i[0]), o.shift(), o.push(i[1]), Ni(t, s, o);
return t.join("");
}
function bi(e) {
var t, n = -1, r = e.length, i = r + 4, s, o = [], u = [];
while (++n < 4) s = e[n % r], o.push(s[0]), u.push(s[1]);
t = [ Ei(Ti, o), ",", Ei(Ti, u) ], --n;
while (++n < i) s = e[n % r], o.shift(), o.push(s[0]), u.shift(), u.push(s[1]), Ni(t, o, u);
return t.join("");
}
function wi(e, t) {
var n = e.length - 1;
if (n) {
var r = e[0][0], i = e[0][1], s = e[n][0] - r, o = e[n][1] - i, u = -1, a, f;
while (++u <= n) a = e[u], f = u / n, a[0] = t * a[0] + (1 - t) * (r + f * s), a[1] = t * a[1] + (1 - t) * (i + f * o);
}
return gi(e);
}
function Ei(e, t) {
return e[0] * t[0] + e[1] * t[1] + e[2] * t[2] + e[3] * t[3];
}
function Ni(e, t, n) {
e.push("C", Ei(Si, t), ",", Ei(Si, n), ",", Ei(xi, t), ",", Ei(xi, n), ",", Ei(Ti, t), ",", Ei(Ti, n));
}
function Ci(e, t) {
return (t[1] - e[1]) / (t[0] - e[0]);
}
function ki(e) {
var t = 0, n = e.length - 1, r = [], i = e[0], s = e[1], o = r[0] = Ci(i, s);
while (++t < n) r[t] = (o + (o = Ci(i = s, s = e[t + 1]))) / 2;
return r[t] = o, r;
}
function Li(e) {
var t = [], n, r, i, s, o = ki(e), u = -1, a = e.length - 1;
while (++u < a) n = Ci(e[u], e[u + 1]), Math.abs(n) < 1e-6 ? o[u] = o[u + 1] = 0 : (r = o[u] / n, i = o[u + 1] / n, s = r * r + i * i, s > 9 && (s = n * 3 / Math.sqrt(s), o[u] = s * r, o[u + 1] = s * i));
u = -1;
while (++u <= a) s = (e[Math.min(a, u + 1)][0] - e[Math.max(0, u - 1)][0]) / (6 * (1 + o[u] * o[u])), t.push([ s || 0, o[u] * s || 0 ]);
return t;
}
function Ai(e) {
return e.length < 3 ? ai(e) : e[0] + vi(e, Li(e));
}
function Oi(e, t, n, r) {
var i, s, o, u, a, f, l;
return i = r[e], s = i[0], o = i[1], i = r[t], u = i[0], a = i[1], i = r[n], f = i[0], l = i[1], (l - o) * (u - s) - (a - o) * (f - s) > 0;
}
function Mi(e, t, n) {
return (n[0] - t[0]) * (e[1] - t[1]) < (n[1] - t[1]) * (e[0] - t[0]);
}
function _i(e, t, n, r) {
var i = e[0], s = n[0], o = t[0] - i, u = r[0] - s, a = e[1], f = n[1], l = t[1] - a, c = r[1] - f, h = (u * (a - f) - c * (i - s)) / (c * o - u * l);
return [ i + h * o, a + h * l ];
}
function Pi(e, t) {
var n = {
list: e.map(function(e, t) {
return {
index: t,
x: e[0],
y: e[1]
};
}).sort(function(e, t) {
return e.y < t.y ? -1 : e.y > t.y ? 1 : e.x < t.x ? -1 : e.x > t.x ? 1 : 0;
}),
bottomSite: null
}, r = {
list: [],
leftEnd: null,
rightEnd: null,
init: function() {
r.leftEnd = r.createHalfEdge(null, "l"), r.rightEnd = r.createHalfEdge(null, "l"), r.leftEnd.r = r.rightEnd, r.rightEnd.l = r.leftEnd, r.list.unshift(r.leftEnd, r.rightEnd);
},
createHalfEdge: function(e, t) {
return {
edge: e,
side: t,
vertex: null,
l: null,
r: null
};
},
insert: function(e, t) {
t.l = e, t.r = e.r, e.r.l = t, e.r = t;
},
leftBound: function(e) {
var t = r.leftEnd;
do t = t.r; while (t != r.rightEnd && i.rightOf(t, e));
return t = t.l, t;
},
del: function(e) {
e.l.r = e.r, e.r.l = e.l, e.edge = null;
},
right: function(e) {
return e.r;
},
left: function(e) {
return e.l;
},
leftRegion: function(e) {
return e.edge == null ? n.bottomSite : e.edge.region[e.side];
},
rightRegion: function(e) {
return e.edge == null ? n.bottomSite : e.edge.region[Di[e.side]];
}
}, i = {
bisect: function(e, t) {
var n = {
region: {
l: e,
r: t
},
ep: {
l: null,
r: null
}
}, r = t.x - e.x, i = t.y - e.y, s = r > 0 ? r : -r, o = i > 0 ? i : -i;
return n.c = e.x * r + e.y * i + (r * r + i * i) * .5, s > o ? (n.a = 1, n.b = i / r, n.c /= r) : (n.b = 1, n.a = r / i, n.c /= i), n;
},
intersect: function(e, t) {
var n = e.edge, r = t.edge;
if (!n || !r || n.region.r == r.region.r) return null;
var i = n.a * r.b - n.b * r.a;
if (Math.abs(i) < 1e-10) return null;
var s = (n.c * r.b - r.c * n.b) / i, o = (r.c * n.a - n.c * r.a) / i, u = n.region.r, a = r.region.r, f, l;
u.y < a.y || u.y == a.y && u.x < a.x ? (f = e, l = n) : (f = t, l = r);
var c = s >= l.region.r.x;
return c && f.side === "l" || !c && f.side === "r" ? null : {
x: s,
y: o
};
},
rightOf: function(e, t) {
var n = e.edge, r = n.region.r, i = t.x > r.x;
if (i && e.side === "l") return 1;
if (!i && e.side === "r") return 0;
if (n.a === 1) {
var s = t.y - r.y, o = t.x - r.x, u = 0, a = 0;
!i && n.b < 0 || i && n.b >= 0 ? a = u = s >= n.b * o : (a = t.x + t.y * n.b > n.c, n.b < 0 && (a = !a), a || (u = 1));
if (!u) {
var f = r.x - n.region.l.x;
a = n.b * (o * o - s * s) < f * s * (1 + 2 * o / f + n.b * n.b), n.b < 0 && (a = !a);
}
} else {
var l = n.c - n.a * t.x, c = t.y - l, h = t.x - r.x, p = l - r.y;
a = c * c > h * h + p * p;
}
return e.side === "l" ? a : !a;
},
endPoint: function(e, n, r) {
e.ep[n] = r;
if (!e.ep[Di[n]]) return;
t(e);
},
distance: function(e, t) {
var n = e.x - t.x, r = e.y - t.y;
return Math.sqrt(n * n + r * r);
}
}, s = {
list: [],
insert: function(e, t, n) {
e.vertex = t, e.ystar = t.y + n;
for (var r = 0, i = s.list, o = i.length; r < o; r++) {
var u = i[r];
if (e.ystar > u.ystar || e.ystar == u.ystar && t.x > u.vertex.x) continue;
break;
}
i.splice(r, 0, e);
},
del: function(e) {
for (var t = 0, n = s.list, r = n.length; t < r && n[t] != e; ++t) ;
n.splice(t, 1);
},
empty: function() {
return s.list.length === 0;
},
nextEvent: function(e) {
for (var t = 0, n = s.list, r = n.length; t < r; ++t) if (n[t] == e) return n[t + 1];
return null;
},
min: function() {
var e = s.list[0];
return {
x: e.vertex.x,
y: e.ystar
};
},
extractMin: function() {
return s.list.shift();
}
};
r.init(), n.bottomSite = n.list.shift();
var o = n.list.shift(), u, a, f, l, c, h, p, d, v, m, g, y, b;
for (;;) {
s.empty() || (u = s.min());
if (o && (s.empty() || o.y < u.y || o.y == u.y && o.x < u.x)) a = r.leftBound(o), f = r.right(a), p = r.rightRegion(a), y = i.bisect(p, o), h = r.createHalfEdge(y, "l"), r.insert(a, h), m = i.intersect(a, h), m && (s.del(a), s.insert(a, m, i.distance(m, o))), a = h, h = r.createHalfEdge(y, "r"), r.insert(a, h), m = i.intersect(h, f), m && s.insert(h, m, i.distance(m, o)), o = n.list.shift(); else {
if (!!s.empty()) break;
a = s.extractMin(), l = r.left(a), f = r.right(a), c = r.right(f), p = r.leftRegion(a), d = r.rightRegion(f), g = a.vertex, i.endPoint(a.edge, a.side, g), i.endPoint(f.edge, f.side, g), r.del(a), s.del(f), r.del(f), b = "l", p.y > d.y && (v = p, p = d, d = v, b = "r"), y = i.bisect(p, d), h = r.createHalfEdge(y, b), r.insert(l, h), i.endPoint(y, Di[b], g), m = i.intersect(l, h), m && (s.del(l), s.insert(l, m, i.distance(m, p))), m = i.intersect(h, c), m && s.insert(h, m, i.distance(m, p));
}
}
for (a = r.right(r.leftEnd); a != r.rightEnd; a = r.right(a)) t(a.edge);
}
function Hi(e) {
return e.x;
}
function Bi(e) {
return e.y;
}
function ji() {
return {
leaf: !0,
nodes: [],
point: null,
x: null,
y: null
};
}
function Fi(e, t, n, r, i, s) {
if (!e(t, n, r, i, s)) {
var o = (n + i) * .5, u = (r + s) * .5, a = t.nodes;
a[0] && Fi(e, a[0], n, r, o, u), a[1] && Fi(e, a[1], o, r, i, u), a[2] && Fi(e, a[2], n, u, o, s), a[3] && Fi(e, a[3], o, u, i, s);
}
}
function Ii(t, n) {
t = e.rgb(t), n = e.rgb(n);
var r = t.r, i = t.g, s = t.b, o = n.r - r, u = n.g - i, a = n.b - s;
return function(e) {
return "#" + zt(Math.round(r + o * e)) + zt(Math.round(i + u * e)) + zt(Math.round(s + a * e));
};
}
function qi(e) {
var t = [ e.a, e.b ], n = [ e.c, e.d ], r = Ui(t), i = Ri(t, n), s = Ui(zi(n, t, -i)) || 0;
t[0] * n[1] < n[0] * t[1] && (t[0] *= -1, t[1] *= -1, r *= -1, i *= -1), this.rotate = (r ? Math.atan2(t[1], t[0]) : Math.atan2(-n[0], n[1])) * gt, this.translate = [ e.e, e.f ], this.scale = [ r, s ], this.skew = s ? Math.atan2(i, s) * gt : 0;
}
function Ri(e, t) {
return e[0] * t[0] + e[1] * t[1];
}
function Ui(e) {
var t = Math.sqrt(Ri(e, e));
return t && (e[0] /= t, e[1] /= t), t;
}
function zi(e, t, n) {
return e[0] += n * t[0], e[1] += n * t[1], e;
}
function Xi(e, t) {
return t -= e = +e, function(n) {
return e + t * n;
};
}
function Vi(t, n) {
var r = [], i = [], s, o = e.transform(t), u = e.transform(n), a = o.translate, f = u.translate, l = o.rotate, c = u.rotate, h = o.skew, p = u.skew, d = o.scale, v = u.scale;
return a[0] != f[0] || a[1] != f[1] ? (r.push("translate(", null, ",", null, ")"), i.push({
i: 1,
x: Xi(a[0], f[0])
}, {
i: 3,
x: Xi(a[1], f[1])
})) : f[0] || f[1] ? r.push("translate(" + f + ")") : r.push(""), l != c ? (l - c > 180 ? c += 360 : c - l > 180 && (l += 360), i.push({
i: r.push(r.pop() + "rotate(", null, ")") - 2,
x: Xi(l, c)
})) : c && r.push(r.pop() + "rotate(" + c + ")"), h != p ? i.push({
i: r.push(r.pop() + "skewX(", null, ")") - 2,
x: Xi(h, p)
}) : p && r.push(r.pop() + "skewX(" + p + ")"), d[0] != v[0] || d[1] != v[1] ? (s = r.push(r.pop() + "scale(", null, ",", null, ")"), i.push({
i: s - 4,
x: Xi(d[0], v[0])
}, {
i: s - 2,
x: Xi(d[1], v[1])
})) : (v[0] != 1 || v[1] != 1) && r.push(r.pop() + "scale(" + v + ")"), s = i.length, function(e) {
var t = -1, n;
while (++t < s) r[(n = i[t]).i] = n.x(e);
return r.join("");
};
}
function $i(e, t) {
var n = {}, r = {}, i;
for (i in e) i in t ? n[i] = Gi(i)(e[i], t[i]) : r[i] = e[i];
for (i in t) i in e || (r[i] = t[i]);
return function(e) {
for (i in n) r[i] = n[i](e);
return r;
};
}
function Ji(e, t) {
var n, r, i, s = 0, o = 0, u = [], a = [], f, l;
e += "", t += "", Ki.lastIndex = 0;
for (r = 0; n = Ki.exec(t); ++r) n.index && u.push(t.substring(s, o = n.index)), a.push({
i: u.length,
x: n[0]
}), u.push(null), s = Ki.lastIndex;
s < t.length && u.push(t.substring(s));
for (r = 0, f = a.length; (n = Ki.exec(e)) && r < f; ++r) {
l = a[r];
if (l.x == n[0]) {
if (l.i) if (u[l.i + 1] == null) {
u[l.i - 1] += l.x, u.splice(l.i, 1);
for (i = r + 1; i < f; ++i) a[i].i--;
} else {
u[l.i - 1] += l.x + u[l.i + 1], u.splice(l.i, 2);
for (i = r + 1; i < f; ++i) a[i].i -= 2;
} else if (u[l.i + 1] == null) u[l.i] = l.x; else {
u[l.i] = l.x + u[l.i + 1], u.splice(l.i + 1, 1);
for (i = r + 1; i < f; ++i) a[i].i--;
}
a.splice(r, 1), f--, r--;
} else l.x = Xi(parseFloat(n[0]), parseFloat(l.x));
}
while (r < f) l = a.pop(), u[l.i + 1] == null ? u[l.i] = l.x : (u[l.i] = l.x + u[l.i + 1], u.splice(l.i + 1, 1)), f--;
return u.length === 1 ? u[0] == null ? a[0].x : function() {
return t;
} : function(e) {
for (r = 0; r < f; ++r) u[(l = a[r]).i] = l.x(e);
return u.join("");
};
}
function Qi(t, n) {
var r = e.interpolators.length, i;
while (--r >= 0 && !(i = e.interpolators[r](t, n))) ;
return i;
}
function Gi(e) {
return e == "transform" ? Vi : Qi;
}
function Yi(e, t) {
var n = [], r = [], i = e.length, s = t.length, o = Math.min(e.length, t.length), u;
for (u = 0; u < o; ++u) n.push(Qi(e[u], t[u]));
for (; u < i; ++u) r[u] = e[u];
for (; u < s; ++u) r[u] = t[u];
return function(e) {
for (u = 0; u < o; ++u) r[u] = n[u](e);
return r;
};
}
function ns(e) {
return function(t) {
return t <= 0 ? 0 : t >= 1 ? 1 : e(t);
};
}
function rs(e) {
return function(t) {
return 1 - e(1 - t);
};
}
function is(e) {
return function(t) {
return .5 * (t < .5 ? e(2 * t) : 2 - e(2 - 2 * t));
};
}
function ss(e) {
return e * e;
}
function os(e) {
return e * e * e;
}
function us(e) {
if (e <= 0) return 0;
if (e >= 1) return 1;
var t = e * e, n = t * e;
return 4 * (e < .5 ? n : 3 * (e - t) + n - .75);
}
function as(e) {
return function(t) {
return Math.pow(t, e);
};
}
function fs(e) {
return 1 - Math.cos(e * dt / 2);
}
function ls(e) {
return Math.pow(2, 10 * (e - 1));
}
function cs(e) {
return 1 - Math.sqrt(1 - e * e);
}
function hs(e, t) {
var n;
return arguments.length < 2 && (t = .45), arguments.length ? n = t / (2 * dt) * Math.asin(1 / e) : (e = 1, n = t / 4), function(r) {
return 1 + e * Math.pow(2, 10 * -r) * Math.sin((r - n) * 2 * dt / t);
};
}
function ps(e) {
return e || (e = 1.70158), function(t) {
return t * t * ((e + 1) * t - e);
};
}
function ds(e) {
return e < 1 / 2.75 ? 7.5625 * e * e : e < 2 / 2.75 ? 7.5625 * (e -= 1.5 / 2.75) * e + .75 : e < 2.5 / 2.75 ? 7.5625 * (e -= 2.25 / 2.75) * e + .9375 : 7.5625 * (e -= 2.625 / 2.75) * e + .984375;
}
function vs(t, n) {
t = e.hcl(t), n = e.hcl(n);
var r = t.h, i = t.c, s = t.l, o = n.h - r, u = n.c - i, a = n.l - s;
return o > 180 ? o -= 360 : o < -180 && (o += 360), function(e) {
return kt(r + o * e, i + u * e, s + a * e) + "";
};
}
function ms(t, n) {
t = e.hsl(t), n = e.hsl(n);
var r = t.h, i = t.s, s = t.l, o = n.h - r, u = n.s - i, a = n.l - s;
return o > 180 ? o -= 360 : o < -180 && (o += 360), function(e) {
return pt(r + o * e, i + u * e, s + a * e) + "";
};
}
function gs(t, n) {
t = e.lab(t), n = e.lab(n);
var r = t.l, i = t.a, s = t.b, o = n.l - r, u = n.a - i, a = n.b - s;
return function(e) {
return Ht(r + o * e, i + u * e, s + a * e) + "";
};
}
function ys(e, t) {
return t -= e, function(n) {
return Math.round(e + t * n);
};
}
function bs(e, t) {
return t = t - (e = +e) ? 1 / (t - e) : 0, function(n) {
return (n - e) * t;
};
}
function ws(e, t) {
return t = t - (e = +e) ? 1 / (t - e) : 0, function(n) {
return Math.max(0, Math.min(1, (n - e) * t));
};
}
function Es(e) {
var t = e.source, n = e.target, r = xs(t, n), i = [ t ];
while (t !== r) t = t.parent, i.push(t);
var s = i.length;
while (n !== r) i.splice(s, 0, n), n = n.parent;
return i;
}
function Ss(e) {
var t = [], n = e.parent;
while (n != null) t.push(e), e = n, n = n.parent;
return t.push(e), t;
}
function xs(e, t) {
if (e === t) return e;
var n = Ss(e), r = Ss(t), i = n.pop(), s = r.pop(), o = null;
while (i === s) o = i, i = n.pop(), s = r.pop();
return o;
}
function Ts(e) {
e.fixed |= 2;
}
function Ns(e) {
e.fixed &= -7;
}
function Cs(e) {
e.fixed |= 4, e.px = e.x, e.py = e.y;
}
function ks(e) {
e.fixed &= -5;
}
function Ls(e, t, n) {
var r = 0, i = 0;
e.charge = 0;
if (!e.leaf) {
var s = e.nodes, o = s.length, u = -1, a;
while (++u < o) {
a = s[u];
if (a == null) continue;
Ls(a, t, n), e.charge += a.charge, r += a.charge * a.cx, i += a.charge * a.cy;
}
}
if (e.point) {
e.leaf || (e.point.x += Math.random() - .5, e.point.y += Math.random() - .5);
var f = t * n[e.point.index];
e.charge += e.pointCharge = f, r += f * e.point.x, i += f * e.point.y;
}
e.cx = r / e.charge, e.cy = i / e.charge;
}
function Ms(t, n) {
return e.rebind(t, n, "sort", "children", "value"), t.nodes = t, t.links = Hs, t;
}
function _s(e) {
return e.children;
}
function Ds(e) {
return e.value;
}
function Ps(e, t) {
return t.value - e.value;
}
function Hs(t) {
return e.merge(t.map(function(e) {
return (e.children || []).map(function(t) {
return {
source: e,
target: t
};
});
}));
}
function js(e) {
return e.x;
}
function Fs(e) {
return e.y;
}
function Is(e, t, n) {
e.y0 = t, e.y = n;
}
function Us(t) {
return e.range(t.length);
}
function zs(e) {
var t = -1, n = e[0].length, r = [];
while (++t < n) r[t] = 0;
return r;
}
function Ws(e) {
var t = 1, n = 0, r = e[0][1], i, s = e.length;
for (; t < s; ++t) (i = e[t][1]) > r && (n = t, r = i);
return n;
}
function Xs(e) {
return e.reduce(Vs, 0);
}
function Vs(e, t) {
return e + t[1];
}
function $s(e, t) {
return Js(e, Math.ceil(Math.log(t.length) / Math.LN2 + 1));
}
function Js(e, t) {
var n = -1, r = +e[0], i = (e[1] - r) / t, s = [];
while (++n <= t) s[n] = i * n + r;
return s;
}
function Ks(t) {
return [ e.min(t), e.max(t) ];
}
function Qs(e, t) {
return e.parent == t.parent ? 1 : 2;
}
function Gs(e) {
var t = e.children;
return t && t.length ? t[0] : e._tree.thread;
}
function Ys(e) {
var t = e.children, n;
return t && (n = t.length) ? t[n - 1] : e._tree.thread;
}
function Zs(e, t) {
var n = e.children;
if (n && (i = n.length)) {
var r, i, s = -1;
while (++s < i) t(r = Zs(n[s], t), e) > 0 && (e = r);
}
return e;
}
function eo(e, t) {
return e.x - t.x;
}
function to(e, t) {
return t.x - e.x;
}
function no(e, t) {
return e.depth - t.depth;
}
function ro(e, t) {
function n(e, r) {
var i = e.children;
if (i && (a = i.length)) {
var s, o = null, u = -1, a;
while (++u < a) s = i[u], n(s, o), o = s;
}
t(e, r);
}
n(e, null);
}
function io(e) {
var t = 0, n = 0, r = e.children, i = r.length, s;
while (--i >= 0) s = r[i]._tree, s.prelim += t, s.mod += t, t += s.shift + (n += s.change);
}
function so(e, t, n) {
e = e._tree, t = t._tree;
var r = n / (t.number - e.number);
e.change += r, t.change -= r, t.shift += n, t.prelim += n, t.mod += n;
}
function oo(e, t, n) {
return e._tree.ancestor.parent == t.parent ? e._tree.ancestor : n;
}
function uo(e, t) {
return e.value - t.value;
}
function ao(e, t) {
var n = e._pack_next;
e._pack_next = t, t._pack_prev = e, t._pack_next = n, n._pack_prev = t;
}
function fo(e, t) {
e._pack_next = t, t._pack_prev = e;
}
function lo(e, t) {
var n = t.x - e.x, r = t.y - e.y, i = e.r + t.r;
return i * i - n * n - r * r > .001;
}
function co(e) {
function p(e) {
n = Math.min(e.x - e.r, n), r = Math.max(e.x + e.r, r), i = Math.min(e.y - e.r, i), s = Math.max(e.y + e.r, s);
}
if (!(t = e.children) || !(h = t.length)) return;
var t, n = Infinity, r = -Infinity, i = Infinity, s = -Infinity, o, u, a, f, l, c, h;
t.forEach(ho), o = t[0], o.x = -o.r, o.y = 0, p(o);
if (h > 1) {
u = t[1], u.x = u.r, u.y = 0, p(u);
if (h > 2) {
a = t[2], mo(o, u, a), p(a), ao(o, a), o._pack_prev = a, ao(a, u), u = o._pack_next;
for (f = 3; f < h; f++) {
mo(o, u, a = t[f]);
var d = 0, v = 1, m = 1;
for (l = u._pack_next; l !== u; l = l._pack_next, v++) if (lo(l, a)) {
d = 1;
break;
}
if (d == 1) for (c = o._pack_prev; c !== l._pack_prev; c = c._pack_prev, m++) if (lo(c, a)) break;
d ? (v < m || v == m && u.r < o.r ? fo(o, u = l) : fo(o = c, u), f--) : (ao(o, a), u = a, p(a));
}
}
}
var g = (n + r) / 2, y = (i + s) / 2, b = 0;
for (f = 0; f < h; f++) a = t[f], a.x -= g, a.y -= y, b = Math.max(b, a.r + Math.sqrt(a.x * a.x + a.y * a.y));
e.r = b, t.forEach(po);
}
function ho(e) {
e._pack_next = e._pack_prev = e;
}
function po(e) {
delete e._pack_next, delete e._pack_prev;
}
function vo(e, t, n, r) {
var i = e.children;
e.x = t += r * e.x, e.y = n += r * e.y, e.r *= r;
if (i) {
var s = -1, o = i.length;
while (++s < o) vo(i[s], t, n, r);
}
}
function mo(e, t, n) {
var r = e.r + n.r, i = t.x - e.x, s = t.y - e.y;
if (r && (i || s)) {
var o = t.r + n.r, u = i * i + s * s;
o *= o, r *= r;
var a = .5 + (r - o) / (2 * u), f = Math.sqrt(Math.max(0, 2 * o * (r + u) - (r -= u) * r - o * o)) / (2 * u);
n.x = e.x + a * i + f * s, n.y = e.y + a * s - f * i;
} else n.x = e.x + r, n.y = e.y;
}
function go(t) {
return 1 + e.max(t, function(e) {
return e.y;
});
}
function yo(e) {
return e.reduce(function(e, t) {
return e + t.x;
}, 0) / e.length;
}
function bo(e) {
var t = e.children;
return t && t.length ? bo(t[0]) : e;
}
function wo(e) {
var t = e.children, n;
return t && (n = t.length) ? wo(t[n - 1]) : e;
}
function Eo(e) {
return {
x: e.x,
y: e.y,
dx: e.dx,
dy: e.dy
};
}
function So(e, t) {
var n = e.x + t[3], r = e.y + t[0], i = e.dx - t[1] - t[3], s = e.dy - t[0] - t[2];
return i < 0 && (n += i / 2, i = 0), s < 0 && (r += s / 2, s = 0), {
x: n,
y: r,
dx: i,
dy: s
};
}
function xo(e) {
var t = e[0], n = e[e.length - 1];
return t < n ? [ t, n ] : [ n, t ];
}
function To(e) {
return e.rangeExtent ? e.rangeExtent() : xo(e.range());
}
function No(e, t, n, r) {
var i = n(e[0], e[1]), s = r(t[0], t[1]);
return function(e) {
return s(i(e));
};
}
function Co(e, t) {
var n = 0, r = e.length - 1, i = e[n], s = e[r], o;
s < i && (o = n, n = r, r = o, o = i, i = s, s = o);
if (t = t(s - i)) e[n] = t.floor(i), e[r] = t.ceil(s);
return e;
}
function ko(t, n, r, i) {
var s = [], o = [], u = 0, a = Math.min(t.length, n.length) - 1;
t[a] < t[0] && (t = t.slice().reverse(), n = n.slice().reverse());
while (++u <= a) s.push(r(t[u - 1], t[u])), o.push(i(n[u - 1], n[u]));
return function(n) {
var r = e.bisect(t, n, 1, a) - 1;
return o[r](s[r](n));
};
}
function Lo(e, t, n, r) {
function o() {
var o = Math.min(e.length, t.length) > 2 ? ko : No, a = r ? ws : bs;
return i = o(e, t, a, n), s = o(t, e, a, Qi), u;
}
function u(e) {
return i(e);
}
var i, s;
return u.invert = function(e) {
return s(e);
}, u.domain = function(t) {
return arguments.length ? (e = t.map(Number), o()) : e;
}, u.range = function(e) {
return arguments.length ? (t = e, o()) : t;
}, u.rangeRound = function(e) {
return u.range(e).interpolate(ys);
}, u.clamp = function(e) {
return arguments.length ? (r = e, o()) : r;
}, u.interpolate = function(e) {
return arguments.length ? (n = e, o()) : n;
}, u.ticks = function(t) {
return _o(e, t);
}, u.tickFormat = function(t, n) {
return Do(e, t, n);
}, u.nice = function() {
return Co(e, Oo), o();
}, u.copy = function() {
return Lo(e, t, n, r);
}, o();
}
function Ao(t, n) {
return e.rebind(t, n, "range", "rangeRound", "interpolate", "clamp");
}
function Oo(e) {
return e = Math.pow(10, Math.round(Math.log(e) / Math.LN10) - 1), e && {
floor: function(t) {
return Math.floor(t / e) * e;
},
ceil: function(t) {
return Math.ceil(t / e) * e;
}
};
}
function Mo(e, t) {
var n = xo(e), r = n[1] - n[0], i = Math.pow(10, Math.floor(Math.log(r / t) / Math.LN10)), s = t / r * i;
return s <= .15 ? i *= 10 : s <= .35 ? i *= 5 : s <= .75 && (i *= 2), n[0] = Math.ceil(n[0] / i) * i, n[1] = Math.floor(n[1] / i) * i + i * .5, n[2] = i, n;
}
function _o(t, n) {
return e.range.apply(e, Mo(t, n));
}
function Do(t, n, r) {
var i = -Math.floor(Math.log(Mo(t, n)[2]) / Math.LN10 + .01);
return e.format(r ? r.replace(dn, function(e, t, n, r, s, o, u, a, f, l) {
return [ t, n, r, s, o, u, a, f || "." + (i - (l === "%") * 2), l ].join("");
}) : ",." + i + "f");
}
function Po(e, t, n, r) {
function i(t) {
return e(n(t));
}
return i.invert = function(t) {
return r(e.invert(t));
}, i.domain = function(t) {
return arguments.length ? (t[0] < 0 ? (n = Fo, r = Io) : (n = Bo, r = jo), e.domain(t.map(n)), i) : e.domain().map(r);
}, i.base = function(e) {
return arguments.length ? (t = +e, i) : t;
}, i.nice = function() {
return e.domain(Co(e.domain(), qo(t))), i;
}, i.ticks = function() {
var i = xo(e.domain()), s = [];
if (i.every(isFinite)) {
var o = Math.log(t), u = Math.floor(i[0] / o), a = Math.ceil(i[1] / o), f = r(i[0]), l = r(i[1]), c = t % 1 ? 2 : t;
if (n === Fo) {
s.push(-Math.pow(t, -u));
for (; u++ < a; ) for (var h = c - 1; h > 0; h--) s.push(-Math.pow(t, -u) * h);
} else {
for (; u < a; u++) for (var h = 1; h < c; h++) s.push(Math.pow(t, u) * h);
s.push(Math.pow(t, u));
}
for (u = 0; s[u] < f; u++) ;
for (a = s.length; s[a - 1] > l; a--) ;
s = s.slice(u, a);
}
return s;
}, i.tickFormat = function(e, s) {
arguments.length < 2 && (s = Ho);
if (!arguments.length) return s;
var o = Math.log(t), u = Math.max(.1, e / i.ticks().length), a = n === Fo ? (f = -1e-12, Math.floor) : (f = 1e-12, Math.ceil), f;
return function(e) {
return e / r(o * a(n(e) / o + f)) <= u ? s(e) : "";
};
}, i.copy = function() {
return Po(e.copy(), t, n, r);
}, Ao(i, e);
}
function Bo(e) {
return Math.log(e < 0 ? 0 : e);
}
function jo(e) {
return Math.exp(e);
}
function Fo(e) {
return -Math.log(e > 0 ? 0 : -e);
}
function Io(e) {
return -Math.exp(-e);
}
function qo(e) {
e = Math.log(e);
var t = {
floor: function(t) {
return Math.floor(t / e) * e;
},
ceil: function(t) {
return Math.ceil(t / e) * e;
}
};
return function() {
return t;
};
}
function Ro(e, t) {
function i(t) {
return e(n(t));
}
var n = Uo(t), r = Uo(1 / t);
return i.invert = function(t) {
return r(e.invert(t));
}, i.domain = function(t) {
return arguments.length ? (e.domain(t.map(n)), i) : e.domain().map(r);
}, i.ticks = function(e) {
return _o(i.domain(), e);
}, i.tickFormat = function(e, t) {
return Do(i.domain(), e, t);
}, i.nice = function() {
return i.domain(Co(i.domain(), Oo));
}, i.exponent = function(e) {
if (!arguments.length) return t;
var s = i.domain();
return n = Uo(t = e), r = Uo(1 / t), i.domain(s);
}, i.copy = function() {
return Ro(e.copy(), t);
}, Ao(i, e);
}
function Uo(e) {
return function(t) {
return t < 0 ? -Math.pow(-t, e) : Math.pow(t, e);
};
}
function zo(t, n) {
function o(e) {
return i[((r.get(e) || r.set(e, t.push(e))) - 1) % i.length];
}
function u(n, r) {
return e.range(t.length).map(function(e) {
return n + r * e;
});
}
var r, i, s;
return o.domain = function(e) {
if (!arguments.length) return t;
t = [], r = new c;
var i = -1, s = e.length, u;
while (++i < s) r.has(u = e[i]) || r.set(u, t.push(u));
return o[n.t].apply(o, n.a);
}, o.range = function(e) {
return arguments.length ? (i = e, s = 0, n = {
t: "range",
a: arguments
}, o) : i;
}, o.rangePoints = function(e, r) {
arguments.length < 2 && (r = 0);
var a = e[0], f = e[1], l = (f - a) / (Math.max(1, t.length - 1) + r);
return i = u(t.length < 2 ? (a + f) / 2 : a + l * r / 2, l), s = 0, n = {
t: "rangePoints",
a: arguments
}, o;
}, o.rangeBands = function(e, r, a) {
arguments.length < 2 && (r = 0), arguments.length < 3 && (a = r);
var f = e[1] < e[0], l = e[f - 0], c = e[1 - f], h = (c - l) / (t.length - r + 2 * a);
return i = u(l + h * a, h), f && i.reverse(), s = h * (1 - r), n = {
t: "rangeBands",
a: arguments
}, o;
}, o.rangeRoundBands = function(e, r, a) {
arguments.length < 2 && (r = 0), arguments.length < 3 && (a = r);
var f = e[1] < e[0], l = e[f - 0], c = e[1 - f], h = Math.floor((c - l) / (t.length - r + 2 * a)), p = c - l - (t.length - r) * h;
return i = u(l + Math.round(p / 2), h), f && i.reverse(), s = Math.round(h * (1 - r)), n = {
t: "rangeRoundBands",
a: arguments
}, o;
}, o.rangeBand = function() {
return s;
}, o.rangeExtent = function() {
return xo(n.a[0]);
}, o.copy = function() {
return zo(t, n);
}, o.domain(t);
}
function Jo(t, n) {
function i() {
var i = 0, o = n.length;
r = [];
while (++i < o) r[i - 1] = e.quantile(t, i / o);
return s;
}
function s(t) {
return isNaN(t = +t) ? NaN : n[e.bisect(r, t)];
}
var r;
return s.domain = function(n) {
return arguments.length ? (t = n.filter(function(e) {
return !isNaN(e);
}).sort(e.ascending), i()) : t;
}, s.range = function(e) {
return arguments.length ? (n = e, i()) : n;
}, s.quantiles = function() {
return r;
}, s.copy = function() {
return Jo(t, n);
}, i();
}
function Ko(e, t, n) {
function s(t) {
return n[Math.max(0, Math.min(i, Math.floor(r * (t - e))))];
}
function o() {
return r = n.length / (t - e), i = n.length - 1, s;
}
var r, i;
return s.domain = function(n) {
return arguments.length ? (e = +n[0], t = +n[n.length - 1], o()) : [ e, t ];
}, s.range = function(e) {
return arguments.length ? (n = e, o()) : n;
}, s.copy = function() {
return Ko(e, t, n);
}, o();
}
function Qo(t, n) {
function r(r) {
return n[e.bisect(t, r)];
}
return r.domain = function(e) {
return arguments.length ? (t = e, r) : t;
}, r.range = function(e) {
return arguments.length ? (n = e, r) : n;
}, r.copy = function() {
return Qo(t, n);
}, r;
}
function Go(e) {
function t(e) {
return +e;
}
return t.invert = t, t.domain = t.range = function(n) {
return arguments.length ? (e = n.map(t), t) : e;
}, t.ticks = function(t) {
return _o(e, t);
}, t.tickFormat = function(t, n) {
return Do(e, t, n);
}, t.copy = function() {
return Go(e);
}, t;
}
function eu(e) {
return e.innerRadius;
}
function tu(e) {
return e.outerRadius;
}
function nu(e) {
return e.startAngle;
}
function ru(e) {
return e.endAngle;
}
function iu(e) {
var t, n = -1, r = e.length, i, s;
while (++n < r) t = e[n], i = t[0], s = t[1] + Yo, t[0] = i * Math.cos(s), t[1] = i * Math.sin(s);
return e;
}
function su(e) {
function c(u) {
function x() {
c.push("M", o(e(p), l), f, a(e(h.reverse()), l), "Z");
}
var c = [], h = [], p = [], d = -1, v = u.length, m, g = Qt(t), y = Qt(r), b = t === n ? function() {
return E;
} : Qt(n), w = r === i ? function() {
return S;
} : Qt(i), E, S;
while (++d < v) s.call(this, m = u[d], d) ? (h.push([ E = +g.call(this, m, d), S = +y.call(this, m, d) ]), p.push([ +b.call(this, m, d), +w.call(this, m, d) ])) : h.length && (x(), h = [], p = []);
return h.length && x(), c.length ? c.join("") : null;
}
var t = si, n = si, r = 0, i = oi, s = $n, o = ai, u = o.key, a = o, f = "L", l = .7;
return c.x = function(e) {
return arguments.length ? (t = n = e, c) : n;
}, c.x0 = function(e) {
return arguments.length ? (t = e, c) : t;
}, c.x1 = function(e) {
return arguments.length ? (n = e, c) : n;
}, c.y = function(e) {
return arguments.length ? (r = i = e, c) : i;
}, c.y0 = function(e) {
return arguments.length ? (r = e, c) : r;
}, c.y1 = function(e) {
return arguments.length ? (i = e, c) : i;
}, c.defined = function(e) {
return arguments.length ? (s = e, c) : s;
}, c.interpolate = function(e) {
return arguments.length ? (typeof e == "function" ? u = o = e : u = (o = ui.get(e) || ai).key, a = o.reverse || o, f = o.closed ? "M" : "L", c) : u;
}, c.tension = function(e) {
return arguments.length ? (l = e, c) : l;
}, c;
}
function ou(e) {
return e.radius;
}
function uu(e) {
return [ e.x, e.y ];
}
function au(e) {
return function() {
var t = e.apply(this, arguments), n = t[0], r = t[1] + Yo;
return [ n * Math.cos(r), n * Math.sin(r) ];
};
}
function fu() {
return 64;
}
function lu() {
return "circle";
}
function cu(e) {
var t = Math.sqrt(e / dt);
return "M0," + t + "A" + t + "," + t + " 0 1,1 0," + -t + "A" + t + "," + t + " 0 1,1 0," + t + "Z";
}
function vu(e, t) {
return A(e, mu), e.id = t, e;
}
function wu(e, t, n, r) {
var i = e.id;
return nt(e, typeof n == "function" ? function(e, s, o) {
e.__transition__[i].tween.set(t, r(n.call(e, e.__data__, s, o)));
} : (n = r(n), function(e) {
e.__transition__[i].tween.set(t, n);
}));
}
function Eu(e) {
return e == null && (e = ""), function() {
this.textContent = e;
};
}
function Su(t, n, r, i) {
var s = t.__transition__ || (t.__transition__ = {
active: 0,
count: 0
}), o = s[r];
if (!o) {
var u = i.time;
return o = s[r] = {
tween: new c,
event: e.dispatch("start", "end"),
time: u,
ease: i.ease,
delay: i.delay,
duration: i.duration
}, ++s.count, e.timer(function(i) {
function d(i) {
return s.active > r ? m() : (s.active = r, l.start.call(t, a, n), o.tween.forEach(function(e, r) {
(r = r.call(t, a, n)) && p.push(r);
}), v(i) || e.timer(v, 0, u), 1);
}
function v(e) {
if (s.active !== r) return m();
var i = (e - c) / h, o = f(i), u = p.length;
while (u > 0) p[--u].call(t, o);
if (i >= 1) return m(), l.end.call(t, a, n), 1;
}
function m() {
return --s.count ? delete s[r] : delete t.__transition__, 1;
}
var a = t.__data__, f = o.ease, l = o.event, c = o.delay, h = o.duration, p = [];
return c <= i ? d(i) : e.timer(d, c, u), 1;
}, 0, u), o;
}
}
function Nu(e, t) {
e.attr("transform", function(e) {
return "translate(" + t(e) + ",0)";
});
}
function Cu(e, t) {
e.attr("transform", function(e) {
return "translate(0," + t(e) + ")";
});
}
function ku(e, t, n) {
i = [];
if (n && t.length > 1) {
var r = xo(e.domain()), i, s = -1, o = t.length, u = (t[1] - t[0]) / ++n, a, f;
while (++s < o) for (a = n; --a > 0; ) (f = +t[s] - a * u) >= r[0] && i.push(f);
for (--s, a = 0; ++a < n && (f = +t[s] + a * u) < r[1]; ) i.push(f);
}
return i;
}
function _u() {
this._ = new Date(arguments.length > 1 ? Date.UTC.apply(this, arguments) : arguments[0]);
}
function Ru(e, t, n) {
function r(t) {
var n = e(t), r = s(n, 1);
return t - n < r - t ? n : r;
}
function i(n) {
return t(n = e(new Ou(n - 1)), 1), n;
}
function s(e, n) {
return t(e = new Ou(+e), n), e;
}
function o(e, r, s) {
var o = i(e), u = [];
if (s > 1) while (o < r) n(o) % s || u.push(new Date(+o)), t(o, 1); else while (o < r) u.push(new Date(+o)), t(o, 1);
return u;
}
function u(e, t, n) {
try {
Ou = _u;
var r = new _u;
return r._ = e, o(r, t, n);
} finally {
Ou = Date;
}
}
e.floor = e, e.round = r, e.ceil = i, e.offset = s, e.range = o;
var a = e.utc = Uu(e);
return a.floor = a, a.round = Uu(r), a.ceil = Uu(i), a.offset = Uu(s), a.range = u, e;
}
function Uu(e) {
return function(t, n) {
try {
Ou = _u;
var r = new _u;
return r._ = t, e(r, n)._;
} finally {
Ou = Date;
}
};
}
function zu(e, t, n, r) {
var i, s, o = 0, u = t.length, a = n.length;
while (o < u) {
if (r >= a) return -1;
i = t.charCodeAt(o++);
if (i === 37) {
s = ta[t.charAt(o++)];
if (!s || (r = s(e, n, r)) < 0) return -1;
} else if (i != n.charCodeAt(r++)) return -1;
}
return r;
}
function Wu(t) {
return new RegExp("^(?:" + t.map(e.requote).join("|") + ")", "i");
}
function Xu(e) {
var t = new c, n = -1, r = e.length;
while (++n < r) t.set(e[n].toLowerCase(), n);
return t;
}
function Vu(e, t, n) {
e += "";
var r = e.length;
return r < n ? (new Array(n - r + 1)).join(t) + e : e;
}
function na(e, t, n) {
Ju.lastIndex = 0;
var r = Ju.exec(t.substring(n));
return r ? n += r[0].length : -1;
}
function ra(e, t, n) {
$u.lastIndex = 0;
var r = $u.exec(t.substring(n));
return r ? n += r[0].length : -1;
}
function ia(e, t, n) {
Gu.lastIndex = 0;
var r = Gu.exec(t.substring(n));
return r ? (e.m = Yu.get(r[0].toLowerCase()), n += r[0].length) : -1;
}
function sa(e, t, n) {
Ku.lastIndex = 0;
var r = Ku.exec(t.substring(n));
return r ? (e.m = Qu.get(r[0].toLowerCase()), n += r[0].length) : -1;
}
function oa(e, t, n) {
return zu(e, ea.c.toString(), t, n);
}
function ua(e, t, n) {
return zu(e, ea.x.toString(), t, n);
}
function aa(e, t, n) {
return zu(e, ea.X.toString(), t, n);
}
function fa(e, t, n) {
ya.lastIndex = 0;
var r = ya.exec(t.substring(n, n + 4));
return r ? (e.y = +r[0], n += r[0].length) : -1;
}
function la(e, t, n) {
ya.lastIndex = 0;
var r = ya.exec(t.substring(n, n + 2));
return r ? (e.y = ca(+r[0]), n += r[0].length) : -1;
}
function ca(e) {
return e + (e > 68 ? 1900 : 2e3);
}
function ha(e, t, n) {
ya.lastIndex = 0;
var r = ya.exec(t.substring(n, n + 2));
return r ? (e.m = r[0] - 1, n += r[0].length) : -1;
}
function pa(e, t, n) {
ya.lastIndex = 0;
var r = ya.exec(t.substring(n, n + 2));
return r ? (e.d = +r[0], n += r[0].length) : -1;
}
function da(e, t, n) {
ya.lastIndex = 0;
var r = ya.exec(t.substring(n, n + 2));
return r ? (e.H = +r[0], n += r[0].length) : -1;
}
function va(e, t, n) {
ya.lastIndex = 0;
var r = ya.exec(t.substring(n, n + 2));
return r ? (e.M = +r[0], n += r[0].length) : -1;
}
function ma(e, t, n) {
ya.lastIndex = 0;
var r = ya.exec(t.substring(n, n + 2));
return r ? (e.S = +r[0], n += r[0].length) : -1;
}
function ga(e, t, n) {
ya.lastIndex = 0;
var r = ya.exec(t.substring(n, n + 3));
return r ? (e.L = +r[0], n += r[0].length) : -1;
}
function ba(e, t, n) {
var r = wa.get(t.substring(n, n += 2).toLowerCase());
return r == null ? -1 : (e.p = r, n);
}
function Ea(e) {
var t = e.getTimezoneOffset(), n = t > 0 ? "-" : "+", r = ~~(Math.abs(t) / 60), i = Math.abs(t) % 60;
return n + Vu(r, "0", 2) + Vu(i, "0", 2);
}
function xa(e) {
return e.toISOString();
}
function Ta(t, n, r) {
function i(e) {
return t(e);
}
return i.invert = function(e) {
return Ca(t.invert(e));
}, i.domain = function(e) {
return arguments.length ? (t.domain(e), i) : t.domain().map(Ca);
}, i.nice = function(e) {
return i.domain(Co(i.domain(), function() {
return e;
}));
}, i.ticks = function(r, s) {
var o = Na(i.domain());
if (typeof r != "function") {
var u = o[1] - o[0], a = u / r, f = e.bisect(Oa, a);
if (f == Oa.length) return n.year(o, r);
if (!f) return t.ticks(r).map(Ca);
Math.log(a / Oa[f - 1]) < Math.log(Oa[f] / a) && --f, r = n[f], s = r[1], r = r[0].range;
}
return r(o[0], new Date(+o[1] + 1), s);
}, i.tickFormat = function() {
return r;
}, i.copy = function() {
return Ta(t.copy(), n, r);
}, e.rebind(i, t, "range", "rangeRound", "interpolate", "clamp");
}
function Na(e) {
var t = e[0], n = e[e.length - 1];
return t < n ? [ t, n ] : [ n, t ];
}
function Ca(e) {
return new Date(e);
}
function ka(e) {
return function(t) {
var n = e.length - 1, r = e[n];
while (!r[1](t)) r = e[--n];
return r[0](t);
};
}
function La(e) {
var t = new Date(e, 0, 1);
return t.setFullYear(e), t;
}
function Aa(e) {
var t = e.getFullYear(), n = La(t), r = La(t + 1);
return t + (e - n) / (r - n);
}
function Fa(e) {
var t = new Date(Date.UTC(e, 0, 1));
return t.setUTCFullYear(e), t;
}
function Ia(e) {
var t = e.getUTCFullYear(), n = Fa(t), r = Fa(t + 1);
return t + (e - n) / (r - n);
}
function qa(e) {
return e.responseText;
}
function Ra(e) {
return JSON.parse(e.responseText);
}
function Ua(e) {
var n = t.createRange();
return n.selectNode(t.body), n.createContextualFragment(e.responseText);
}
function za(e) {
return e.responseXML;
}
var e = {
version: "3.1.5"
};
Date.now || (Date.now = function() {
return +(new Date);
});
var t = document, n = window;
try {
t.createElement("div").style.setProperty("opacity", 0, "");
} catch (r) {
var i = n.CSSStyleDeclaration.prototype, s = i.setProperty;
i.setProperty = function(e, t, n) {
s.call(this, e, t + "", n);
};
}
e.ascending = function(e, t) {
return e < t ? -1 : e > t ? 1 : e >= t ? 0 : NaN;
}, e.descending = function(e, t) {
return t < e ? -1 : t > e ? 1 : t >= e ? 0 : NaN;
}, e.min = function(e, t) {
var n = -1, r = e.length, i, s;
if (arguments.length === 1) {
while (++n < r && ((i = e[n]) == null || i != i)) i = undefined;
while (++n < r) (s = e[n]) != null && i > s && (i = s);
} else {
while (++n < r && ((i = t.call(e, e[n], n)) == null || i != i)) i = undefined;
while (++n < r) (s = t.call(e, e[n], n)) != null && i > s && (i = s);
}
return i;
}, e.max = function(e, t) {
var n = -1, r = e.length, i, s;
if (arguments.length === 1) {
while (++n < r && ((i = e[n]) == null || i != i)) i = undefined;
while (++n < r) (s = e[n]) != null && s > i && (i = s);
} else {
while (++n < r && ((i = t.call(e, e[n], n)) == null || i != i)) i = undefined;
while (++n < r) (s = t.call(e, e[n], n)) != null && s > i && (i = s);
}
return i;
}, e.extent = function(e, t) {
var n = -1, r = e.length, i, s, o;
if (arguments.length === 1) {
while (++n < r && ((i = o = e[n]) == null || i != i)) i = o = undefined;
while (++n < r) (s = e[n]) != null && (i > s && (i = s), o < s && (o = s));
} else {
while (++n < r && ((i = o = t.call(e, e[n], n)) == null || i != i)) i = undefined;
while (++n < r) (s = t.call(e, e[n], n)) != null && (i > s && (i = s), o < s && (o = s));
}
return [ i, o ];
}, e.sum = function(e, t) {
var n = 0, r = e.length, i, s = -1;
if (arguments.length === 1) while (++s < r) isNaN(i = +e[s]) || (n += i); else while (++s < r) isNaN(i = +t.call(e, e[s], s)) || (n += i);
return n;
}, e.mean = function(e, t) {
var n = e.length, r, i = 0, s = -1, u = 0;
if (arguments.length === 1) while (++s < n) o(r = e[s]) && (i += (r - i) / ++u); else while (++s < n) o(r = t.call(e, e[s], s)) && (i += (r - i) / ++u);
return u ? i : undefined;
}, e.quantile = function(e, t) {
var n = (e.length - 1) * t + 1, r = Math.floor(n), i = +e[r - 1], s = n - r;
return s ? i + s * (e[r] - i) : i;
}, e.median = function(t, n) {
return arguments.length > 1 && (t = t.map(n)), t = t.filter(o), t.length ? e.quantile(t.sort(e.ascending), .5) : undefined;
}, e.bisector = function(e) {
return {
left: function(t, n, r, i) {
arguments.length < 3 && (r = 0), arguments.length < 4 && (i = t.length);
while (r < i) {
var s = r + i >>> 1;
e.call(t, t[s], s) < n ? r = s + 1 : i = s;
}
return r;
},
right: function(t, n, r, i) {
arguments.length < 3 && (r = 0), arguments.length < 4 && (i = t.length);
while (r < i) {
var s = r + i >>> 1;
n < e.call(t, t[s], s) ? i = s : r = s + 1;
}
return r;
}
};
};
var u = e.bisector(function(e) {
return e;
});
e.bisectLeft = u.left, e.bisect = e.bisectRight = u.right, e.shuffle = function(e) {
var t = e.length, n, r;
while (t) r = Math.random() * t-- | 0, n = e[t], e[t] = e[r], e[r] = n;
return e;
}, e.permute = function(e, t) {
var n = [], r = -1, i = t.length;
while (++r < i) n[r] = e[t[r]];
return n;
}, e.zip = function() {
if (!(s = arguments.length)) return [];
for (var t = -1, n = e.min(arguments, a), r = new Array(n); ++t < n; ) for (var i = -1, s, o = r[t] = new Array(s); ++i < s; ) o[i] = arguments[i][t];
return r;
}, e.transpose = function(t) {
return e.zip.apply(e, t);
}, e.keys = function(e) {
var t = [];
for (var n in e) t.push(n);
return t;
}, e.values = function(e) {
var t = [];
for (var n in e) t.push(e[n]);
return t;
}, e.entries = function(e) {
var t = [];
for (var n in e) t.push({
key: n,
value: e[n]
});
return t;
}, e.merge = function(e) {
return Array.prototype.concat.apply([], e);
}, e.range = function(e, t, n) {
arguments.length < 3 && (n = 1, arguments.length < 2 && (t = e, e = 0));
if ((t - e) / n === Infinity) throw new Error("infinite range");
var r = [], i = f(Math.abs(n)), s = -1, o;
e *= i, t *= i, n *= i;
if (n < 0) while ((o = e + n * ++s) > t) r.push(o / i); else while ((o = e + n * ++s) < t) r.push(o / i);
return r;
}, e.map = function(e) {
var t = new c;
for (var n in e) t.set(n, e[n]);
return t;
}, l(c, {
has: function(e) {
return h + e in this;
},
get: function(e) {
return this[h + e];
},
set: function(e, t) {
return this[h + e] = t;
},
remove: function(e) {
return e = h + e, e in this && delete this[e];
},
keys: function() {
var e = [];
return this.forEach(function(t) {
e.push(t);
}), e;
},
values: function() {
var e = [];
return this.forEach(function(t, n) {
e.push(n);
}), e;
},
entries: function() {
var e = [];
return this.forEach(function(t, n) {
e.push({
key: t,
value: n
});
}), e;
},
forEach: function(e) {
for (var t in this) t.charCodeAt(0) === p && e.call(this, t.substring(1), this[t]);
}
});
var h = "\0", p = h.charCodeAt(0);
e.nest = function() {
function o(e, r, u) {
if (u >= n.length) return s ? s.call(t, r) : i ? r.sort(i) : r;
var a = -1, f = r.length, l = n[u++], h, p, d, v = new c, m;
while (++a < f) (m = v.get(h = l(p = r[a]))) ? m.push(p) : v.set(h, [ p ]);
return e ? (p = e(), d = function(t, n) {
p.set(t, o(e, n, u));
}) : (p = {}, d = function(t, n) {
p[t] = o(e, n, u);
}), v.forEach(d), p;
}
function u(e, t) {
if (t >= n.length) return e;
var i = [], s = r[t++];
return e.forEach(function(e, n) {
i.push({
key: e,
values: u(n, t)
});
}), s ? i.sort(function(e, t) {
return s(e.key, t.key);
}) : i;
}
var t = {}, n = [], r = [], i, s;
return t.map = function(e, t) {
return o(t, e, 0);
}, t.entries = function(t) {
return u(o(e.map, t, 0), 0);
}, t.key = function(e) {
return n.push(e), t;
}, t.sortKeys = function(e) {
return r[n.length - 1] = e, t;
}, t.sortValues = function(e) {
return i = e, t;
}, t.rollup = function(e) {
return s = e, t;
}, t;
}, e.set = function(e) {
var t = new d;
if (e) for (var n = 0; n < e.length; n++) t.add(e[n]);
return t;
}, l(d, {
has: function(e) {
return h + e in this;
},
add: function(e) {
return this[h + e] = !0, e;
},
remove: function(e) {
return e = h + e, e in this && delete this[e];
},
values: function() {
var e = [];
return this.forEach(function(t) {
e.push(t);
}), e;
},
forEach: function(e) {
for (var t in this) t.charCodeAt(0) === p && e.call(this, t.substring(1));
}
}), e.behavior = {}, e.rebind = function(e, t) {
var n = 1, r = arguments.length, i;
while (++n < r) e[i = arguments[n]] = v(e, t, t[i]);
return e;
}, e.dispatch = function() {
var e = new m, t = -1, n = arguments.length;
while (++t < n) e[arguments[t]] = g(e);
return e;
}, m.prototype.on = function(e, t) {
var n = e.indexOf("."), r = "";
n >= 0 && (r = e.substring(n + 1), e = e.substring(0, n));
if (e) return arguments.length < 2 ? this[e].on(r) : this[e].on(r, t);
if (arguments.length === 2) {
if (t == null) for (e in this) this.hasOwnProperty(e) && this[e].on(r, null);
return this;
}
}, e.event = null, e.mouse = function(e) {
return T(e, w());
};
var x = /WebKit/.test(n.navigator.userAgent) ? -1 : 0, N = k;
try {
N(t.documentElement.childNodes)[0].nodeType;
} catch (L) {
N = C;
}
var A = [].__proto__ ? function(e, t) {
e.__proto__ = t;
} : function(e, t) {
for (var n in t) e[n] = t[n];
};
e.touches = function(e, t) {
return arguments.length < 2 && (t = w().touches), t ? N(t).map(function(t) {
var n = T(e, t);
return n.identifier = t.identifier, n;
}) : [];
}, e.behavior.drag = function() {
function i() {
this.on("mousedown.drag", s).on("touchstart.drag", s);
}
function s() {
function h() {
var t = i.parentNode;
return u != null ? e.touches(t).filter(function(e) {
return e.identifier === u;
})[0] : e.mouse(t);
}
function p() {
if (!i.parentNode) return d();
var e = h(), t = e[0] - f[0], n = e[1] - f[1];
l |= t | n, f = e, y(), s({
type: "drag",
x: e[0] + a[0],
y: e[1] + a[1],
dx: t,
dy: n
});
}
function d() {
s({
type: "dragend"
}), l && (y(), e.event.target === o && E(c, "click")), c.on(u != null ? "touchmove.drag-" + u : "mousemove.drag", null).on(u != null ? "touchend.drag-" + u : "mouseup.drag", null);
}
var i = this, s = t.of(i, arguments), o = e.event.target, u = e.event.touches ? e.event.changedTouches[0].identifier : null, a, f = h(), l = 0, c = e.select(n).on(u != null ? "touchmove.drag-" + u : "mousemove.drag", p).on(u != null ? "touchend.drag-" + u : "mouseup.drag", d, !0);
r ? (a = r.apply(i, arguments), a = [ a.x - f[0], a.y - f[1] ]) : a = [ 0, 0 ], u == null && y(), s({
type: "dragstart"
});
}
var t = S(i, "drag", "dragstart", "dragend"), r = null;
return i.origin = function(e) {
return arguments.length ? (r = e, i) : r;
}, e.rebind(i, t, "on");
};
var M = function(e, t) {
return t.querySelector(e);
}, _ = function(e, t) {
return t.querySelectorAll(e);
}, D = t.documentElement, P = D.matchesSelector || D.webkitMatchesSelector || D.mozMatchesSelector || D.msMatchesSelector || D.oMatchesSelector, H = function(e, t) {
return P.call(e, t);
};
typeof Sizzle == "function" && (M = function(e, t) {
return Sizzle(e, t)[0] || null;
}, _ = function(e, t) {
return Sizzle.uniqueSort(Sizzle(e, t));
}, H = Sizzle.matchesSelector);
var B = [];
e.selection = function() {
return st;
}, e.selection.prototype = B, B.select = function(e) {
var t = [], n, r, i, s;
typeof e != "function" && (e = j(e));
for (var o = -1, u = this.length; ++o < u; ) {
t.push(n = []), n.parentNode = (i = this[o]).parentNode;
for (var a = -1, f = i.length; ++a < f; ) (s = i[a]) ? (n.push(r = e.call(s, s.__data__, a)), r && "__data__" in s && (r.__data__ = s.__data__)) : n.push(null);
}
return O(t);
}, B.selectAll = function(e) {
var t = [], n, r;
typeof e != "function" && (e = F(e));
for (var i = -1, s = this.length; ++i < s; ) for (var o = this[i], u = -1, a = o.length; ++u < a; ) if (r = o[u]) t.push(n = N(e.call(r, r.__data__, u))), n.parentNode = r;
return O(t);
};
var I = {
svg: "http://www.w3.org/2000/svg",
xhtml: "http://www.w3.org/1999/xhtml",
xlink: "http://www.w3.org/1999/xlink",
xml: "http://www.w3.org/XML/1998/namespace",
xmlns: "http://www.w3.org/2000/xmlns/"
};
e.ns = {
prefix: I,
qualify: function(e) {
var t = e.indexOf(":"), n = e;
return t >= 0 && (n = e.substring(0, t), e = e.substring(t + 1)), I.hasOwnProperty(n) ? {
space: I[n],
local: e
} : e;
}
}, B.attr = function(t, n) {
if (arguments.length < 2) {
if (typeof t == "string") {
var r = this.node();
return t = e.ns.qualify(t), t.local ? r.getAttributeNS(t.space, t.local) : r.getAttribute(t);
}
for (n in t) this.each(q(n, t[n]));
return this;
}
return this.each(q(t, n));
}, e.requote = function(e) {
return e.replace(U, "\\$&");
};
var U = /[\\\^\$\*\+\?\|\[\]\(\)\.\{\}]/g;
B.classed = function(e, t) {
if (arguments.length < 2) {
if (typeof e == "string") {
var n = this.node(), r = (e = e.trim().split(/^|\s+/g)).length, i = -1;
if (t = n.classList) {
while (++i < r) if (!t.contains(e[i])) return !1;
} else {
t = n.getAttribute("class");
while (++i < r) if (!z(e[i]).test(t)) return !1;
}
return !0;
}
for (t in e) this.each(W(t, e[t]));
return this;
}
return this.each(W(e, t));
}, B.style = function(e, t, r) {
var i = arguments.length;
if (i < 3) {
if (typeof e != "string") {
i < 2 && (t = "");
for (r in e) this.each(V(r, e[r], t));
return this;
}
if (i < 2) return n.getComputedStyle(this.node(), null).getPropertyValue(e);
r = "";
}
return this.each(V(e, t, r));
}, B.property = function(e, t) {
if (arguments.length < 2) {
if (typeof e == "string") return this.node()[e];
for (t in e) this.each($(t, e[t]));
return this;
}
return this.each($(e, t));
}, B.text = function(e) {
return arguments.length ? this.each(typeof e == "function" ? function() {
var t = e.apply(this, arguments);
this.textContent = t == null ? "" : t;
} : e == null ? function() {
this.textContent = "";
} : function() {
this.textContent = e;
}) : this.node().textContent;
}, B.html = function(e) {
return arguments.length ? this.each(typeof e == "function" ? function() {
var t = e.apply(this, arguments);
this.innerHTML = t == null ? "" : t;
} : e == null ? function() {
this.innerHTML = "";
} : function() {
this.innerHTML = e;
}) : this.node().innerHTML;
}, B.append = function(n) {
function r() {
return this.appendChild(t.createElementNS(this.namespaceURI, n));
}
function i() {
return this.appendChild(t.createElementNS(n.space, n.local));
}
return n = e.ns.qualify(n), this.select(n.local ? i : r);
}, B.insert = function(n, r) {
function i(e, i) {
return this.insertBefore(t.createElementNS(this.namespaceURI, n), r.call(this, e, i));
}
function s(e, i) {
return this.insertBefore(t.createElementNS(n.space, n.local), r.call(this, e, i));
}
return n = e.ns.qualify(n), typeof r != "function" && (r = j(r)), this.select(n.local ? s : i);
}, B.remove = function() {
return this.each(function() {
var e = this.parentNode;
e && e.removeChild(this);
});
}, B.data = function(e, t) {
function o(e, n) {
var r, i = e.length, s = n.length, o = Math.min(i, s), l = new Array(s), h = new Array(s), p = new Array(i), d, v;
if (t) {
var m = new c, g = new c, y = [], b;
for (r = -1; ++r < i; ) b = t.call(d = e[r], d.__data__, r), m.has(b) ? p[r] = d : m.set(b, d), y.push(b);
for (r = -1; ++r < s; ) b = t.call(n, v = n[r], r), (d = m.get(b)) ? (l[r] = d, d.__data__ = v) : g.has(b) || (h[r] = J(v)), g.set(b, v), m.remove(b);
for (r = -1; ++r < i; ) m.has(y[r]) && (p[r] = e[r]);
} else {
for (r = -1; ++r < o; ) d = e[r], v = n[r], d ? (d.__data__ = v, l[r] = d) : h[r] = J(v);
for (; r < s; ++r) h[r] = J(n[r]);
for (; r < i; ++r) p[r] = e[r];
}
h.update = l, h.parentNode = l.parentNode = p.parentNode = e.parentNode, u.push(h), a.push(l), f.push(p);
}
var n = -1, r = this.length, i, s;
if (!arguments.length) {
e = new Array(r = (i = this[0]).length);
while (++n < r) if (s = i[n]) e[n] = s.__data__;
return e;
}
var u = rt([]), a = O([]), f = O([]);
if (typeof e == "function") while (++n < r) o(i = this[n], e.call(i, i.parentNode.__data__, n)); else while (++n < r) o(i = this[n], e);
return a.enter = function() {
return u;
}, a.exit = function() {
return f;
}, a;
}, B.datum = function(e) {
return arguments.length ? this.property("__data__", e) : this.property("__data__");
}, B.filter = function(e) {
var t = [], n, r, i;
typeof e != "function" && (e = K(e));
for (var s = 0, o = this.length; s < o; s++) {
t.push(n = []), n.parentNode = (r = this[s]).parentNode;
for (var u = 0, a = r.length; u < a; u++) (i = r[u]) && e.call(i, i.__data__, u) && n.push(i);
}
return O(t);
}, B.order = function() {
for (var e = -1, t = this.length; ++e < t; ) for (var n = this[e], r = n.length - 1, i = n[r], s; --r >= 0; ) if (s = n[r]) i && i !== s.nextSibling && i.parentNode.insertBefore(s, i), i = s;
return this;
}, B.sort = function(e) {
e = Q.apply(this, arguments);
for (var t = -1, n = this.length; ++t < n; ) this[t].sort(e);
return this.order();
}, B.on = function(e, t, n) {
var r = arguments.length;
if (r < 3) {
if (typeof e != "string") {
r < 2 && (t = !1);
for (n in e) this.each(Y(n, e[n], t));
return this;
}
if (r < 2) return (r = this.node()["__on" + e]) && r._;
n = !1;
}
return this.each(Y(e, t, n));
};
var Z = e.map({
mouseenter: "mouseover",
mouseleave: "mouseout"
});
Z.forEach(function(e) {
"on" + e in t && Z.remove(e);
}), B.each = function(e) {
return nt(this, function(t, n, r) {
e.call(t, t.__data__, n, r);
});
}, B.call = function(e) {
var t = N(arguments);
return e.apply(t[0] = this, t), this;
}, B.empty = function() {
return !this.node();
}, B.node = function() {
for (var e = 0, t = this.length; e < t; e++) for (var n = this[e], r = 0, i = n.length; r < i; r++) {
var s = n[r];
if (s) return s;
}
return null;
};
var it = [];
e.selection.enter = rt, e.selection.enter.prototype = it, it.append = B.append, it.insert = B.insert, it.empty = B.empty, it.node = B.node, it.select = function(e) {
var t = [], n, r, i, s, o;
for (var u = -1, a = this.length; ++u < a; ) {
i = (s = this[u]).update, t.push(n = []), n.parentNode = s.parentNode;
for (var f = -1, l = s.length; ++f < l; ) (o = s[f]) ? (n.push(i[f] = r = e.call(s.parentNode, o.__data__, f)), r.__data__ = o.__data__) : n.push(null);
}
return O(t);
}, B.transition = function() {
var e = yu || ++gu, t = [], n, r, i = Object.create(bu);
i.time = Date.now();
for (var s = -1, o = this.length; ++s < o; ) {
t.push(n = []);
for (var u = this[s], a = -1, f = u.length; ++a < f; ) (r = u[a]) && Su(r, a, e, i), n.push(r);
}
return vu(t, e);
};
var st = O([ [ t ] ]);
st[0].parentNode = D, e.select = function(e) {
return typeof e == "string" ? st.select(e) : O([ [ e ] ]);
}, e.selectAll = function(e) {
return typeof e == "string" ? st.selectAll(e) : O([ N(e) ]);
}, e.behavior.zoom = function() {
function p() {
this.on("mousedown.zoom", x).on("mousemove.zoom", N).on(at + ".zoom", T).on("dblclick.zoom", C).on("touchstart.zoom", k).on("touchmove.zoom", L).on("touchend.zoom", k);
}
function d(e) {
return [ (e[0] - t[0]) / i, (e[1] - t[1]) / i ];
}
function v(e) {
return [ e[0] * i + t[0], e[1] * i + t[1] ];
}
function m(e) {
i = Math.max(o[0], Math.min(o[1], e));
}
function g(e, n) {
n = v(n), t[0] += e[0] - n[0], t[1] += e[1] - n[1];
}
function b() {
f && f.domain(a.range().map(function(e) {
return (e - t[0]) / i;
}).map(a.invert)), c && c.domain(l.range().map(function(e) {
return (e - t[1]) / i;
}).map(l.invert));
}
function w(n) {
b(), e.event.preventDefault(), n({
type: "zoom",
scale: i,
translate: t
});
}
function x() {
function f() {
s = 1, g(e.mouse(t), a), w(r);
}
function l() {
s && y(), o.on("mousemove.zoom", null).on("mouseup.zoom", null), s && e.event.target === i && E(o, "click.zoom");
}
var t = this, r = u.of(t, arguments), i = e.event.target, s = 0, o = e.select(n).on("mousemove.zoom", f).on("mouseup.zoom", l), a = d(e.mouse(t));
n.focus(), y();
}
function T() {
r || (r = d(e.mouse(this))), m(Math.pow(2, ut() * .002) * i), g(e.mouse(this), r), w(u.of(this, arguments));
}
function N() {
r = null;
}
function C() {
var t = e.mouse(this), n = d(t), r = Math.log(i) / Math.LN2;
m(Math.pow(2, e.event.shiftKey ? Math.ceil(r) - 1 : Math.floor(r) + 1)), g(t, n), w(u.of(this, arguments));
}
function k() {
var t = e.touches(this), n = Date.now();
s = i, r = {}, t.forEach(function(e) {
r[e.identifier] = d(e);
}), y();
if (t.length === 1) {
if (n - h < 500) {
var o = t[0], a = d(t[0]);
m(i * 2), g(o, a), w(u.of(this, arguments));
}
h = n;
}
}
function L() {
var t = e.touches(this), n = t[0], i = r[n.identifier];
if (o = t[1]) {
var o, a = r[o.identifier];
n = [ (n[0] + o[0]) / 2, (n[1] + o[1]) / 2 ], i = [ (i[0] + a[0]) / 2, (i[1] + a[1]) / 2 ], m(e.event.scale * s);
}
g(n, i), h = null, w(u.of(this, arguments));
}
var t = [ 0, 0 ], r, i = 1, s, o = ot, u = S(p, "zoom"), a, f, l, c, h;
return p.translate = function(e) {
return arguments.length ? (t = e.map(Number), b(), p) : t;
}, p.scale = function(e) {
return arguments.length ? (i = +e, b(), p) : i;
}, p.scaleExtent = function(e) {
return arguments.length ? (o = e == null ? ot : e.map(Number), p) : o;
}, p.x = function(e) {
return arguments.length ? (f = e, a = e.copy(), t = [ 0, 0 ], i = 1, p) : f;
}, p.y = function(e) {
return arguments.length ? (c = e, l = e.copy(), t = [ 0, 0 ], i = 1, p) : c;
}, e.rebind(p, u, "on");
};
var ot = [ 0, Infinity ], ut, at = "onwheel" in t ? (ut = function() {
return -e.event.deltaY * (e.event.deltaMode ? 120 : 1);
}, "wheel") : "onmousewheel" in t ? (ut = function() {
return e.event.wheelDelta;
}, "mousewheel") : (ut = function() {
return -e.event.detail;
}, "MozMousePixelScroll");
ft.prototype.toString = function() {
return this.rgb() + "";
}, e.hsl = function(e, t, n) {
return arguments.length === 1 ? e instanceof ct ? lt(e.h, e.s, e.l) : Wt("" + e, Xt, lt) : lt(+e, +t, +n);
};
var ht = ct.prototype = new ft;
ht.brighter = function(e) {
return e = Math.pow(.7, arguments.length ? e : 1), lt(this.h, this.s, this.l / e);
}, ht.darker = function(e) {
return e = Math.pow(.7, arguments.length ? e : 1), lt(this.h, this.s, e * this.l);
}, ht.rgb = function() {
return pt(this.h, this.s, this.l);
};
var dt = Math.PI, vt = 1e-6, mt = dt / 180, gt = 180 / dt;
e.hcl = function(t, n, r) {
return arguments.length === 1 ? t instanceof Nt ? Tt(t.h, t.c, t.l) : t instanceof At ? Bt(t.l, t.a, t.b) : Bt((t = Vt((t = e.rgb(t)).r, t.g, t.b)).l, t.a, t.b) : Tt(+t, +n, +r);
};
var Ct = Nt.prototype = new ft;
Ct.brighter = function(e) {
return Tt(this.h, this.c, Math.min(100, this.l + Ot * (arguments.length ? e : 1)));
}, Ct.darker = function(e) {
return Tt(this.h, this.c, Math.max(0, this.l - Ot * (arguments.length ? e : 1)));
}, Ct.rgb = function() {
return kt(this.h, this.c, this.l).rgb();
}, e.lab = function(t, n, r) {
return arguments.length === 1 ? t instanceof At ? Lt(t.l, t.a, t.b) : t instanceof Nt ? kt(t.l, t.c, t.h) : Vt((t = e.rgb(t)).r, t.g, t.b) : Lt(+t, +n, +r);
};
var Ot = 18, Mt = .95047, _t = 1, Dt = 1.08883, Pt = At.prototype = new ft;
Pt.brighter = function(e) {
return Lt(Math.min(100, this.l + Ot * (arguments.length ? e : 1)), this.a, this.b);
}, Pt.darker = function(e) {
return Lt(Math.max(0, this.l - Ot * (arguments.length ? e : 1)), this.a, this.b);
}, Pt.rgb = function() {
return Ht(this.l, this.a, this.b);
}, e.rgb = function(e, t, n) {
return arguments.length === 1 ? e instanceof Rt ? qt(e.r, e.g, e.b) : Wt("" + e, qt, pt) : qt(~~e, ~~t, ~~n);
};
var Ut = Rt.prototype = new ft;
Ut.brighter = function(e) {
e = Math.pow(.7, arguments.length ? e : 1);
var t = this.r, n = this.g, r = this.b, i = 30;
return !t && !n && !r ? qt(i, i, i) : (t && t < i && (t = i), n && n < i && (n = i), r && r < i && (r = i), qt(Math.min(255, Math.floor(t / e)), Math.min(255, Math.floor(n / e)), Math.min(255, Math.floor(r / e))));
}, Ut.darker = function(e) {
return e = Math.pow(.7, arguments.length ? e : 1), qt(Math.floor(e * this.r), Math.floor(e * this.g), Math.floor(e * this.b));
}, Ut.hsl = function() {
return Xt(this.r, this.g, this.b);
}, Ut.toString = function() {
return "#" + zt(this.r) + zt(this.g) + zt(this.b);
};
var Kt = e.map({
aliceblue: "#f0f8ff",
antiquewhite: "#faebd7",
aqua: "#00ffff",
aquamarine: "#7fffd4",
azure: "#f0ffff",
beige: "#f5f5dc",
bisque: "#ffe4c4",
black: "#000000",
blanchedalmond: "#ffebcd",
blue: "#0000ff",
blueviolet: "#8a2be2",
brown: "#a52a2a",
burlywood: "#deb887",
cadetblue: "#5f9ea0",
chartreuse: "#7fff00",
chocolate: "#d2691e",
coral: "#ff7f50",
cornflowerblue: "#6495ed",
cornsilk: "#fff8dc",
crimson: "#dc143c",
cyan: "#00ffff",
darkblue: "#00008b",
darkcyan: "#008b8b",
darkgoldenrod: "#b8860b",
darkgray: "#a9a9a9",
darkgreen: "#006400",
darkgrey: "#a9a9a9",
darkkhaki: "#bdb76b",
darkmagenta: "#8b008b",
darkolivegreen: "#556b2f",
darkorange: "#ff8c00",
darkorchid: "#9932cc",
darkred: "#8b0000",
darksalmon: "#e9967a",
darkseagreen: "#8fbc8f",
darkslateblue: "#483d8b",
darkslategray: "#2f4f4f",
darkslategrey: "#2f4f4f",
darkturquoise: "#00ced1",
darkviolet: "#9400d3",
deeppink: "#ff1493",
deepskyblue: "#00bfff",
dimgray: "#696969",
dimgrey: "#696969",
dodgerblue: "#1e90ff",
firebrick: "#b22222",
floralwhite: "#fffaf0",
forestgreen: "#228b22",
fuchsia: "#ff00ff",
gainsboro: "#dcdcdc",
ghostwhite: "#f8f8ff",
gold: "#ffd700",
goldenrod: "#daa520",
gray: "#808080",
green: "#008000",
greenyellow: "#adff2f",
grey: "#808080",
honeydew: "#f0fff0",
hotpink: "#ff69b4",
indianred: "#cd5c5c",
indigo: "#4b0082",
ivory: "#fffff0",
khaki: "#f0e68c",
lavender: "#e6e6fa",
lavenderblush: "#fff0f5",
lawngreen: "#7cfc00",
lemonchiffon: "#fffacd",
lightblue: "#add8e6",
lightcoral: "#f08080",
lightcyan: "#e0ffff",
lightgoldenrodyellow: "#fafad2",
lightgray: "#d3d3d3",
lightgreen: "#90ee90",
lightgrey: "#d3d3d3",
lightpink: "#ffb6c1",
lightsalmon: "#ffa07a",
lightseagreen: "#20b2aa",
lightskyblue: "#87cefa",
lightslategray: "#778899",
lightslategrey: "#778899",
lightsteelblue: "#b0c4de",
lightyellow: "#ffffe0",
lime: "#00ff00",
limegreen: "#32cd32",
linen: "#faf0e6",
magenta: "#ff00ff",
maroon: "#800000",
mediumaquamarine: "#66cdaa",
mediumblue: "#0000cd",
mediumorchid: "#ba55d3",
mediumpurple: "#9370db",
mediumseagreen: "#3cb371",
mediumslateblue: "#7b68ee",
mediumspringgreen: "#00fa9a",
mediumturquoise: "#48d1cc",
mediumvioletred: "#c71585",
midnightblue: "#191970",
mintcream: "#f5fffa",
mistyrose: "#ffe4e1",
moccasin: "#ffe4b5",
navajowhite: "#ffdead",
navy: "#000080",
oldlace: "#fdf5e6",
olive: "#808000",
olivedrab: "#6b8e23",
orange: "#ffa500",
orangered: "#ff4500",
orchid: "#da70d6",
palegoldenrod: "#eee8aa",
palegreen: "#98fb98",
paleturquoise: "#afeeee",
palevioletred: "#db7093",
papayawhip: "#ffefd5",
peachpuff: "#ffdab9",
peru: "#cd853f",
pink: "#ffc0cb",
plum: "#dda0dd",
powderblue: "#b0e0e6",
purple: "#800080",
red: "#ff0000",
rosybrown: "#bc8f8f",
royalblue: "#4169e1",
saddlebrown: "#8b4513",
salmon: "#fa8072",
sandybrown: "#f4a460",
seagreen: "#2e8b57",
seashell: "#fff5ee",
sienna: "#a0522d",
silver: "#c0c0c0",
skyblue: "#87ceeb",
slateblue: "#6a5acd",
slategray: "#708090",
slategrey: "#708090",
snow: "#fffafa",
springgreen: "#00ff7f",
steelblue: "#4682b4",
tan: "#d2b48c",
teal: "#008080",
thistle: "#d8bfd8",
tomato: "#ff6347",
turquoise: "#40e0d0",
violet: "#ee82ee",
wheat: "#f5deb3",
white: "#ffffff",
whitesmoke: "#f5f5f5",
yellow: "#ffff00",
yellowgreen: "#9acd32"
});
Kt.forEach(function(e, t) {
Kt.set(e, Wt(t, qt, pt));
}), e.functor = Qt, e.xhr = function(t, r, i) {
function l() {
var e = f.status;
!e && f.responseText || e >= 200 && e < 300 || e === 304 ? o.load.call(s, a.call(s, f)) : o.error.call(s, f);
}
var s = {}, o = e.dispatch("progress", "load", "error"), u = {}, a = Gt, f = new (n.XDomainRequest && /^(http(s)?:)?\/\//.test(t) ? XDomainRequest : XMLHttpRequest);
return "onload" in f ? f.onload = f.onerror = l : f.onreadystatechange = function() {
f.readyState > 3 && l();
}, f.onprogress = function(t) {
var n = e.event;
e.event = t;
try {
o.progress.call(s, f);
} finally {
e.event = n;
}
}, s.header = function(e, t) {
return e = (e + "").toLowerCase(), arguments.length < 2 ? u[e] : (t == null ? delete u[e] : u[e] = t + "", s);
}, s.mimeType = function(e) {
return arguments.length ? (r = e == null ? null : e + "", s) : r;
}, s.response = function(e) {
return a = e, s;
}, [ "get", "post" ].forEach(function(e) {
s[e] = function() {
return s.send.apply(s, [ e ].concat(N(arguments)));
};
}), s.send = function(e, n, i) {
arguments.length === 2 && typeof n == "function" && (i = n, n = null), f.open(e, t, !0), r != null && !("accept" in u) && (u.accept = r + ",*/*");
if (f.setRequestHeader) for (var o in u) f.setRequestHeader(o, u[o]);
return r != null && f.overrideMimeType && f.overrideMimeType(r), i != null && s.on("error", i).on("load", function(e) {
i(null, e);
}), f.send(n == null ? null : n), s;
}, s.abort = function() {
return f.abort(), s;
}, e.rebind(s, o, "on"), arguments.length === 2 && typeof r == "function" && (i = r, r = null), i == null ? s : s.get(Yt(i));
}, e.csv = Zt(",", "text/csv"), e.tsv = Zt("	", "text/tab-separated-values");
var en = 0, tn = {}, nn = null, rn, sn;
e.timer = function(e, t, n) {
if (arguments.length < 3) {
if (arguments.length < 2) t = 0; else if (!isFinite(t)) return;
n = Date.now();
}
var r = tn[e.id];
r && r.callback === e ? (r.then = n, r.delay = t) : tn[e.id = ++en] = nn = {
callback: e,
then: n,
delay: t,
next: nn
}, rn || (sn = clearTimeout(sn), rn = 1, an(on));
}, e.timer.flush = function() {
var e, t = Date.now(), n = nn;
while (n) e = t - n.then, n.delay || (n.flush = n.callback(e)), n = n.next;
un();
};
var an = n.requestAnimationFrame || n.webkitRequestAnimationFrame || n.mozRequestAnimationFrame || n.oRequestAnimationFrame || n.msRequestAnimationFrame || function(e) {
setTimeout(e, 17);
}, fn = ".", ln = ",", cn = [ 3, 3 ], hn = [ "y", "z", "a", "f", "p", "n", "\u00b5", "m", "", "k", "M", "G", "T", "P", "E", "Z", "Y" ].map(pn);
e.formatPrefix = function(t, n) {
var r = 0;
return t && (t < 0 && (t *= -1), n && (t = e.round(t, mn(t, n))), r = 1 + Math.floor(1e-12 + Math.log(t) / Math.LN10), r = Math.max(-24, Math.min(24, Math.floor((r <= 0 ? r + 1 : r - 1) / 3) * 3))), hn[8 + r / 3];
}, e.round = function(e, t) {
return t ? Math.round(e * (t = Math.pow(10, t))) / t : Math.round(e);
}, e.format = function(t) {
var n = dn.exec(t), r = n[1] || " ", i = n[2] || ">", s = n[3] || "", o = n[4] || "", u = n[5], a = +n[6], f = n[7], l = n[8], c = n[9], h = 1, p = "", d = !1;
l && (l = +l.substring(1));
if (u || r === "0" && i === "=") u = r = "0", i = "=", f && (a -= Math.floor((a - 1) / 4));
switch (c) {
case "n":
f = !0, c = "g";
break;
case "%":
h = 100, p = "%", c = "f";
break;
case "p":
h = 100, p = "%", c = "r";
break;
case "b":
case "o":
case "x":
case "X":
o && (o = "0" + c.toLowerCase());
case "c":
case "d":
d = !0, l = 0;
break;
case "s":
h = -1, c = "r";
}
o === "#" && (o = ""), c == "r" && !l && (c = "g");
if (l != null) if (c == "g") l = Math.max(1, Math.min(21, l)); else if (c == "e" || c == "f") l = Math.max(0, Math.min(20, l));
c = vn.get(c) || gn;
var v = u && f;
return function(t) {
if (d && t % 1) return "";
var n = t < 0 || t === 0 && 1 / t < 0 ? (t = -t, "-") : s;
if (h < 0) {
var m = e.formatPrefix(t, l);
t = m.scale(t), p = m.symbol;
} else t *= h;
t = c(t, l), !u && f && (t = yn(t));
var g = o.length + t.length + (v ? 0 : n.length), y = g < a ? (new Array(g = a - g + 1)).join(r) : "";
return v && (t = yn(y + t)), fn && t.replace(".", fn), n += o, (i === "<" ? n + t + y : i === ">" ? y + n + t : i === "^" ? y.substring(0, g >>= 1) + n + t + y.substring(g) : n + (v ? t : y + t)) + p;
};
};
var dn = /(?:([^{])?([<>=^]))?([+\- ])?(#)?(0)?(\d+)?(,)?(\.-?\d+)?([a-z%])?/i, vn = e.map({
b: function(e) {
return e.toString(2);
},
c: function(e) {
return String.fromCharCode(e);
},
o: function(e) {
return e.toString(8);
},
x: function(e) {
return e.toString(16);
},
X: function(e) {
return e.toString(16).toUpperCase();
},
g: function(e, t) {
return e.toPrecision(t);
},
e: function(e, t) {
return e.toExponential(t);
},
f: function(e, t) {
return e.toFixed(t);
},
r: function(t, n) {
return (t = e.round(t, mn(t, n))).toFixed(Math.max(0, Math.min(20, mn(t * (1 + 1e-15), n))));
}
}), yn = Gt;
if (cn) {
var bn = cn.length;
yn = function(e) {
var t = e.lastIndexOf("."), n = t >= 0 ? "." + e.substring(t + 1) : (t = e.length, ""), r = [], i = 0, s = cn[0];
while (t > 0 && s > 0) r.push(e.substring(t -= s, t + s)), s = cn[i = (i + 1) % bn];
return r.reverse().join(ln || "") + n;
};
}
e.geo = {}, e.geo.stream = function(e, t) {
e && En.hasOwnProperty(e.type) ? En[e.type](e, t) : wn(e, t);
};
var En = {
Feature: function(e, t) {
wn(e.geometry, t);
},
FeatureCollection: function(e, t) {
var n = e.features, r = -1, i = n.length;
while (++r < i) wn(n[r].geometry, t);
}
}, Sn = {
Sphere: function(e, t) {
t.sphere();
},
Point: function(e, t) {
var n = e.coordinates;
t.point(n[0], n[1]);
},
MultiPoint: function(e, t) {
var n = e.coordinates, r = -1, i = n.length, s;
while (++r < i) s = n[r], t.point(s[0], s[1]);
},
LineString: function(e, t) {
xn(e.coordinates, t, 0);
},
MultiLineString: function(e, t) {
var n = e.coordinates, r = -1, i = n.length;
while (++r < i) xn(n[r], t, 0);
},
Polygon: function(e, t) {
Tn(e.coordinates, t);
},
MultiPolygon: function(e, t) {
var n = e.coordinates, r = -1, i = n.length;
while (++r < i) Tn(n[r], t);
},
GeometryCollection: function(e, t) {
var n = e.geometries, r = -1, i = n.length;
while (++r < i) wn(n[r], t);
}
};
e.geo.area = function(t) {
return Nn = 0, e.geo.stream(t, Ln), Nn;
};
var Nn, Cn, kn, Ln = {
sphere: function() {
Nn += 4 * dt;
},
point: G,
lineStart: G,
lineEnd: G,
polygonStart: function() {
Cn = 1, kn = 0, Ln.lineStart = An;
},
polygonEnd: function() {
var e = 2 * Math.atan2(kn, Cn);
Nn += e < 0 ? 4 * dt + e : e, Ln.lineStart = Ln.lineEnd = Ln.point = G;
}
};
e.geo.bounds = On(Gt), e.geo.centroid = function(t) {
Mn = _n = Dn = Pn = Hn = 0, e.geo.stream(t, Bn);
var n;
if (_n && Math.abs(n = Math.sqrt(Dn * Dn + Pn * Pn + Hn * Hn)) > vt) return [ Math.atan2(Pn, Dn) * gt, Math.asin(Math.max(-1, Math.min(1, Hn / n))) * gt ];
};
var Mn, _n, Dn, Pn, Hn, Bn = {
sphere: function() {
Mn < 2 && (Mn = 2, _n = Dn = Pn = Hn = 0);
},
point: jn,
lineStart: In,
lineEnd: qn,
polygonStart: function() {
Mn < 2 && (Mn = 2, _n = Dn = Pn = Hn = 0), Bn.lineStart = Fn;
},
polygonEnd: function() {
Bn.lineStart = In;
}
}, rr = Yn($n, ir, or), ar = 1e9;
e.geo.projection = pr, e.geo.projectionMutator = dr, (e.geo.equirectangular = function() {
return pr(mr);
}).raw = mr.invert = mr, e.geo.rotation = function(e) {
function t(t) {
return t = e(t[0] * mt, t[1] * mt), t[0] *= gt, t[1] *= gt, t;
}
return e = gr(e[0] % 360 * mt, e[1] * mt, e.length > 2 ? e[2] * mt : 0), t.invert = function(t) {
return t = e.invert(t[0] * mt, t[1] * mt), t[0] *= gt, t[1] *= gt, t;
}, t;
}, e.geo.circle = function() {
function i() {
var t = typeof e == "function" ? e.apply(this, arguments) : e, n = gr(-t[0] * mt, -t[1] * mt, 0).invert, i = [];
return r(null, null, 1, {
point: function(e, t) {
i.push(e = n(e, t)), e[0] *= gt, e[1] *= gt;
}
}), {
type: "Polygon",
coordinates: [ i ]
};
}
var e = [ 0, 0 ], t, n = 6, r;
return i.origin = function(t) {
return arguments.length ? (e = t, i) : e;
}, i.angle = function(e) {
return arguments.length ? (r = Er((t = +e) * mt, n * mt), i) : t;
}, i.precision = function(e) {
return arguments.length ? (r = Er(t * mt, (n = +e) * mt), i) : n;
}, i.angle(90);
}, e.geo.distance = function(e, t) {
var n = (t[0] - e[0]) * mt, r = e[1] * mt, i = t[1] * mt, s = Math.sin(n), o = Math.cos(n), u = Math.sin(r), a = Math.cos(r), f = Math.sin(i), l = Math.cos(i), c;
return Math.atan2(Math.sqrt((c = l * s) * c + (c = a * f - u * l * o) * c), u * f + a * l * o);
}, e.geo.graticule = function() {
function y() {
return {
type: "MultiLineString",
coordinates: b()
};
}
function b() {
return e.range(Math.ceil(i / c) * c, r, c).map(v).concat(e.range(Math.ceil(a / h) * h, u, h).map(m)).concat(e.range(Math.ceil(n / f) * f, t, f).filter(function(e) {
return Math.abs(e % c) > vt;
}).map(p)).concat(e.range(Math.ceil(o / l) * l, s, l).filter(function(e) {
return Math.abs(e % h) > vt;
}).map(d));
}
var t, n, r, i, s, o, u, a, f = 10, l = f, c = 90, h = 360, p, d, v, m, g = 2.5;
return y.lines = function() {
return b().map(function(e) {
return {
type: "LineString",
coordinates: e
};
});
}, y.outline = function() {
return {
type: "Polygon",
coordinates: [ v(i).concat(m(u).slice(1), v(r).reverse().slice(1), m(a).reverse().slice(1)) ]
};
}, y.extent = function(e) {
return arguments.length ? y.majorExtent(e).minorExtent(e) : y.minorExtent();
}, y.majorExtent = function(e) {
return arguments.length ? (i = +e[0][0], r = +e[1][0], a = +e[0][1], u = +e[1][1], i > r && (e = i, i = r, r = e), a > u && (e = a, a = u, u = e), y.precision(g)) : [ [ i, a ], [ r, u ] ];
}, y.minorExtent = function(e) {
return arguments.length ? (n = +e[0][0], t = +e[1][0], o = +e[0][1], s = +e[1][1], n > t && (e = n, n = t, t = e), o > s && (e = o, o = s, s = e), y.precision(g)) : [ [ n, o ], [ t, s ] ];
}, y.step = function(e) {
return arguments.length ? y.majorStep(e).minorStep(e) : y.minorStep();
}, y.majorStep = function(e) {
return arguments.length ? (c = +e[0], h = +e[1], y) : [ c, h ];
}, y.minorStep = function(e) {
return arguments.length ? (f = +e[0], l = +e[1], y) : [ f, l ];
}, y.precision = function(e) {
return arguments.length ? (g = +e, p = xr(o, s, 90), d = Tr(n, t, g), v = xr(a, u, 90), m = Tr(i, r, g), y) : g;
}, y.majorExtent([ [ -180, -90 + vt ], [ 180, 90 - vt ] ]).minorExtent([ [ -180, -80 - vt ], [ 180, 80 + vt ] ]);
}, e.geo.greatArc = function() {
function s() {
return {
type: "LineString",
coordinates: [ n || t.apply(this, arguments), i || r.apply(this, arguments) ]
};
}
var t = Nr, n, r = Cr, i;
return s.distance = function() {
return e.geo.distance(n || t.apply(this, arguments), i || r.apply(this, arguments));
}, s.source = function(e) {
return arguments.length ? (t = e, n = typeof e == "function" ? null : e, s) : t;
}, s.target = function(e) {
return arguments.length ? (r = e, i = typeof e == "function" ? null : e, s) : r;
}, s.precision = function() {
return arguments.length ? s : 0;
}, s;
}, e.geo.interpolate = function(e, t) {
return kr(e[0] * mt, e[1] * mt, t[0] * mt, t[1] * mt);
}, e.geo.length = function(t) {
return Lr = 0, e.geo.stream(t, Ar), Lr;
};
var Lr, Ar = {
sphere: G,
point: G,
lineStart: Or,
lineEnd: G,
polygonStart: G,
polygonEnd: G
};
(e.geo.conicEqualArea = function() {
return Mr(_r);
}).raw = _r, e.geo.albersUsa = function() {
function a(e) {
return f(e)(e);
}
function f(e) {
var s = e[0], o = e[1];
return o > 50 ? n : s < -140 ? r : o < 21 ? i : t;
}
var t = e.geo.conicEqualArea().rotate([ 98, 0 ]).center([ 0, 38 ]).parallels([ 29.5, 45.5 ]), n = e.geo.conicEqualArea().rotate([ 160, 0 ]).center([ 0, 60 ]).parallels([ 55, 65 ]), r = e.geo.conicEqualArea().rotate([ 160, 0 ]).center([ 0, 20 ]).parallels([ 8, 18 ]), i = e.geo.conicEqualArea().rotate([ 60, 0 ]).center([ 0, 10 ]).parallels([ 8, 18 ]), s, o, u;
return a.invert = function(e) {
return s(e) || o(e) || u(e) || t.invert(e);
}, a.scale = function(e) {
return arguments.length ? (t.scale(e), n.scale(e * .6), r.scale(e), i.scale(e * 1.5), a.translate(t.translate())) : t.scale();
}, a.translate = function(e) {
if (!arguments.length) return t.translate();
var f = t.scale(), l = e[0], c = e[1];
return t.translate(e), n.translate([ l - .4 * f, c + .17 * f ]), r.translate([ l - .19 * f, c + .2 * f ]), i.translate([ l + .58 * f, c + .43 * f ]), s = Dr(n, [ [ -180, 50 ], [ -130, 72 ] ]), o = Dr(r, [ [ -164, 18 ], [ -154, 24 ] ]), u = Dr(i, [ [ -67.5, 17.5 ], [ -65, 19 ] ]), a;
}, a.scale(1e3);
};
var Pr, Hr, Br = {
point: G,
lineStart: G,
lineEnd: G,
polygonStart: function() {
Hr = 0, Br.lineStart = jr;
},
polygonEnd: function() {
Br.lineStart = Br.lineEnd = Br.point = G, Pr += Math.abs(Hr / 2);
}
}, Ir = {
point: qr,
lineStart: Rr,
lineEnd: Ur,
polygonStart: function() {
Ir.lineStart = zr;
},
polygonEnd: function() {
Ir.point = qr, Ir.lineStart = Rr, Ir.lineEnd = Ur;
}
};
e.geo.path = function() {
function o(n) {
return n && e.geo.stream(n, i(s.pointRadius(typeof t == "function" ? +t.apply(this, arguments) : t))), s.result();
}
var t = 4.5, n, r, i, s;
return o.area = function(t) {
return Pr = 0, e.geo.stream(t, i(Br)), Pr;
}, o.centroid = function(t) {
return Mn = Dn = Pn = Hn = 0, e.geo.stream(t, i(Ir)), Hn ? [ Dn / Hn, Pn / Hn ] : undefined;
}, o.bounds = function(e) {
return On(i)(e);
}, o.projection = function(e) {
return arguments.length ? (i = (n = e) ? e.stream || Vr(e) : Gt, o) : n;
}, o.context = function(e) {
return arguments.length ? (s = (r = e) == null ? new Fr : new Wr(e), o) : r;
}, o.pointRadius = function(e) {
return arguments.length ? (t = typeof e == "function" ? e : +e, o) : t;
}, o.projection(e.geo.albersUsa()).context(null);
}, e.geo.albers = function() {
return e.geo.conicEqualArea().parallels([ 29.5, 45.5 ]).rotate([ 98, 0 ]).center([ 0, 38 ]).scale(1e3);
};
var Jr = $r(function(e) {
return Math.sqrt(2 / (1 + e));
}, function(e) {
return 2 * Math.asin(e / 2);
});
(e.geo.azimuthalEqualArea = function() {
return pr(Jr);
}).raw = Jr;
var Kr = $r(function(e) {
var t = Math.acos(e);
return t && t / Math.sin(t);
}, Gt);
(e.geo.azimuthalEquidistant = function() {
return pr(Kr);
}).raw = Kr, (e.geo.conicConformal = function() {
return Mr(Qr);
}).raw = Qr, (e.geo.conicEquidistant = function() {
return Mr(Gr);
}).raw = Gr;
var Yr = $r(function(e) {
return 1 / e;
}, Math.atan);
(e.geo.gnomonic = function() {
return pr(Yr);
}).raw = Yr, Zr.invert = function(e, t) {
return [ e, 2 * Math.atan(Math.exp(t)) - dt / 2 ];
}, (e.geo.mercator = function() {
return ei(Zr);
}).raw = Zr;
var ti = $r(function() {
return 1;
}, Math.asin);
(e.geo.orthographic = function() {
return pr(ti);
}).raw = ti;
var ni = $r(function(e) {
return 1 / (1 + e);
}, function(e) {
return 2 * Math.atan(e);
});
(e.geo.stereographic = function() {
return pr(ni);
}).raw = ni, ri.invert = function(e, t) {
return [ Math.atan2(Et(e), Math.cos(t)), wt(Math.sin(t) / St(e)) ];
}, (e.geo.transverseMercator = function() {
return ei(ri);
}).raw = ri, e.geom = {}, e.svg = {}, e.svg.line = function() {
return ii(Gt);
};
var ui = e.map({
linear: ai,
"linear-closed": fi,
"step-before": li,
"step-after": ci,
basis: gi,
"basis-open": yi,
"basis-closed": bi,
bundle: wi,
cardinal: di,
"cardinal-open": hi,
"cardinal-closed": pi,
monotone: Ai
});
ui.forEach(function(e, t) {
t.key = e, t.closed = /-closed$/.test(e);
});
var Si = [ 0, 2 / 3, 1 / 3, 0 ], xi = [ 0, 1 / 3, 2 / 3, 0 ], Ti = [ 0, 1 / 6, 2 / 3, 1 / 6 ];
e.geom.hull = function(e) {
function r(e) {
if (e.length < 3) return [];
var r = Qt(t), i = Qt(n), s = e.length, o, u = s - 1, a = [], f = [], l, c, h, p = 0, d, v, m, g, y, b, w, E;
if (r === si && n === oi) o = e; else for (c = 0, o = []; c < s; ++c) o.push([ +r.call(this, l = e[c], c), +i.call(this, l, c) ]);
for (c = 1; c < s; ++c) o[c][1] < o[p][1] ? p = c : o[c][1] == o[p][1] && (p = o[c][0] < o[p][0] ? c : p);
for (c = 0; c < s; ++c) {
if (c === p) continue;
v = o[c][1] - o[p][1], d = o[c][0] - o[p][0], a.push({
angle: Math.atan2(v, d),
index: c
});
}
a.sort(function(e, t) {
return e.angle - t.angle;
}), w = a[0].angle, b = a[0].index, y = 0;
for (c = 1; c < u; ++c) h = a[c].index, w == a[c].angle ? (d = o[b][0] - o[p][0], v = o[b][1] - o[p][1], m = o[h][0] - o[p][0], g = o[h][1] - o[p][1], d * d + v * v >= m * m + g * g ? a[c].index = -1 : (a[y].index = -1, w = a[c].angle, y = c, b = h)) : (w = a[c].angle, y = c, b = h);
f.push(p);
for (c = 0, h = 0; c < 2; ++h) a[h].index !== -1 && (f.push(a[h].index), c++);
E = f.length;
for (; h < u; ++h) {
if (a[h].index === -1) continue;
while (!Oi(f[E - 2], f[E - 1], a[h].index, o)) --E;
f[E++] = a[h].index;
}
var S = [];
for (c = 0; c < E; ++c) S.push(e[f[c]]);
return S;
}
var t = si, n = oi;
return arguments.length ? r(e) : (r.x = function(e) {
return arguments.length ? (t = e, r) : t;
}, r.y = function(e) {
return arguments.length ? (n = e, r) : n;
}, r);
}, e.geom.polygon = function(e) {
return e.area = function() {
var t = 0, n = e.length, r = e[n - 1][1] * e[0][0] - e[n - 1][0] * e[0][1];
while (++t < n) r += e[t - 1][1] * e[t][0] - e[t - 1][0] * e[t][1];
return r * .5;
}, e.centroid = function(t) {
var n = -1, r = e.length, i = 0, s = 0, o, u = e[r - 1], a;
arguments.length || (t = -1 / (6 * e.area()));
while (++n < r) o = u, u = e[n], a = o[0] * u[1] - u[0] * o[1], i += (o[0] + u[0]) * a, s += (o[1] + u[1]) * a;
return [ i * t, s * t ];
}, e.clip = function(t) {
var n, r = -1, i = e.length, s, o, u = e[i - 1], a, f, l;
while (++r < i) {
n = t.slice(), t.length = 0, a = e[r], f = n[(o = n.length) - 1], s = -1;
while (++s < o) l = n[s], Mi(l, u, a) ? (Mi(f, u, a) || t.push(_i(f, l, u, a)), t.push(l)) : Mi(f, u, a) && t.push(_i(f, l, u, a)), f = l;
u = a;
}
return t;
}, e;
}, e.geom.delaunay = function(e) {
var t = e.map(function() {
return [];
}), n = [];
return Pi(e, function(n) {
t[n.region.l.index].push(e[n.region.r.index]);
}), t.forEach(function(t, r) {
var i = e[r], s = i[0], o = i[1];
t.forEach(function(e) {
e.angle = Math.atan2(e[0] - s, e[1] - o);
}), t.sort(function(e, t) {
return e.angle - t.angle;
});
for (var u = 0, a = t.length - 1; u < a; u++) n.push([ i, t[u], t[u + 1] ]);
}), n;
}, e.geom.voronoi = function(t) {
function o(t) {
var n, o = t.map(function() {
return [];
}), u = Qt(r), a = Qt(i), f, l, c = t.length, h = 1e6;
if (u === si && a === oi) n = t; else for (n = [], l = 0; l < c; ++l) n.push([ +u.call(this, f = t[l], l), +a.call(this, f, l) ]);
Pi(n, function(e) {
var t, n, r, i, s, u;
e.a === 1 && e.b >= 0 ? (t = e.ep.r, n = e.ep.l) : (t = e.ep.l, n = e.ep.r), e.a === 1 ? (s = t ? t.y : -h, r = e.c - e.b * s, u = n ? n.y : h, i = e.c - e.b * u) : (r = t ? t.x : -h, s = e.c - e.a * r, i = n ? n.x : h, u = e.c - e.a * i);
var a = [ r, s ], f = [ i, u ];
o[e.region.l.index].push(a, f), o[e.region.r.index].push(a, f);
}), o = o.map(function(t, r) {
var i = n[r][0], s = n[r][1], o = t.map(function(e) {
return Math.atan2(e[0] - i, e[1] - s);
}), u = e.range(t.length).sort(function(e, t) {
return o[e] - o[t];
});
return u.filter(function(e, t) {
return !t || o[e] - o[u[t - 1]] > vt;
}).map(function(e) {
return t[e];
});
}), o.forEach(function(e, t) {
var r = e.length;
if (!r) return e.push([ -h, -h ], [ -h, h ], [ h, h ], [ h, -h ]);
if (r > 2) return;
var i = n[t], s = e[0], o = e[1], u = i[0], a = i[1], f = s[0], l = s[1], c = o[0], p = o[1], d = Math.abs(c - f), v = p - l;
if (Math.abs(v) < vt) {
var m = a < l ? -h : h;
e.push([ -h, m ], [ h, m ]);
} else if (d < vt) {
var g = u < f ? -h : h;
e.push([ g, -h ], [ g, h ]);
} else {
var m = (c - f) * (l - a) < (f - u) * (p - l) ? h : -h, y = Math.abs(v) - d;
Math.abs(y) < vt ? e.push([ v < 0 ? m : -m, m ]) : (y > 0 && (m *= -1), e.push([ -h, m ], [ h, m ]));
}
});
if (s) for (l = 0; l < c; ++l) s(o[l]);
for (l = 0; l < c; ++l) o[l].point = t[l];
return o;
}
var n = null, r = si, i = oi, s;
return arguments.length ? o(t) : (o.x = function(e) {
return arguments.length ? (r = e, o) : r;
}, o.y = function(e) {
return arguments.length ? (i = e, o) : i;
}, o.size = function(t) {
return arguments.length ? (t == null ? s = null : (n = [ +t[0], +t[1] ], s = e.geom.polygon([ [ 0, 0 ], [ 0, n[1] ], n, [ n[0], 0 ] ]).clip), o) : n;
}, o.links = function(e) {
var t, n = e.map(function() {
return [];
}), s = [], o = Qt(r), u = Qt(i), a, f, l = e.length;
if (o === si && u === oi) t = e; else for (f = 0; f < l; ++f) t.push([ +o.call(this, a = e[f], f), +u.call(this, a, f) ]);
return Pi(t, function(t) {
var r = t.region.l.index, i = t.region.r.index;
if (n[r][i]) return;
n[r][i] = n[i][r] = !0, s.push({
source: e[r],
target: e[i]
});
}), s;
}, o.triangles = function(t) {
if (r === si && i === oi) return e.geom.delaunay(t);
var n, s, o = Qt(r), u = Qt(i), a, f, l;
for (f = 0, n = [], l = t.length; f < l; ++f) s = [ +o.call(this, a = t[f], f), +u.call(this, a, f) ], s.data = a, n.push(s);
return e.geom.delaunay(n).map(function(e) {
return e.map(function(e) {
return e.data;
});
});
}, o);
};
var Di = {
l: "r",
r: "l"
};
e.geom.quadtree = function(e, t, n, r, i) {
function a(e) {
function x(e, t, n, r, i, s, o, u) {
if (isNaN(n) || isNaN(r)) return;
if (e.leaf) {
var a = e.x, f = e.y;
if (a != null) if (Math.abs(a - n) + Math.abs(f - r) < .01) T(e, t, n, r, i, s, o, u); else {
var l = e.point;
e.x = e.y = e.point = null, T(e, l, a, f, i, s, o, u), T(e, t, n, r, i, s, o, u);
} else e.x = n, e.y = r, e.point = t;
} else T(e, t, n, r, i, s, o, u);
}
function T(e, t, n, r, i, s, o, u) {
var a = (i + o) * .5, f = (s + u) * .5, l = n >= a, c = r >= f, h = (c << 1) + l;
e.leaf = !1, e = e.nodes[h] || (e.nodes[h] = ji()), l ? i = a : o = a, c ? s = f : u = f, x(e, t, n, r, i, s, o, u);
}
var a, f = Qt(s), l = Qt(o), c, h, p, d, v, m, g, y;
if (t != null) v = t, m = n, g = r, y = i; else {
g = y = -(v = m = Infinity), c = [], h = [], d = e.length;
if (u) for (p = 0; p < d; ++p) a = e[p], a.x < v && (v = a.x), a.y < m && (m = a.y), a.x > g && (g = a.x), a.y > y && (y = a.y), c.push(a.x), h.push(a.y); else for (p = 0; p < d; ++p) {
var b = +f(a = e[p], p), w = +l(a, p);
b < v && (v = b), w < m && (m = w), b > g && (g = b), w > y && (y = w), c.push(b), h.push(w);
}
}
var E = g - v, S = y - m;
E > S ? y = m + E : g = v + S;
var N = ji();
N.add = function(e) {
x(N, e, +f(e, ++p), +l(e, p), v, m, g, y);
}, N.visit = function(e) {
Fi(e, N, v, m, g, y);
}, p = -1;
if (t == null) {
while (++p < d) x(N, e[p], c[p], h[p], v, m, g, y);
--p;
} else e.forEach(N.add);
return c = h = e = a = null, N;
}
var s = si, o = oi, u;
return (u = arguments.length) ? (s = Hi, o = Bi, u === 3 && (i = n, r = t, n = t = 0), a(e)) : (a.x = function(e) {
return arguments.length ? (s = e, a) : s;
}, a.y = function(e) {
return arguments.length ? (o = e, a) : o;
}, a.size = function(e) {
return arguments.length ? (e == null ? t = n = r = i = null : (t = n = 0, r = +e[0], i = +e[1]), a) : t == null ? null : [ r, i ];
}, a);
}, e.interpolateRgb = Ii, e.transform = function(n) {
var r = t.createElementNS(e.ns.prefix.svg, "g");
return (e.transform = function(e) {
r.setAttribute("transform", e);
var t = r.transform.baseVal.consolidate();
return new qi(t ? t.matrix : Wi);
})(n);
}, qi.prototype.toString = function() {
return "translate(" + this.translate + ")rotate(" + this.rotate + ")skewX(" + this.skew + ")scale(" + this.scale + ")";
};
var Wi = {
a: 1,
b: 0,
c: 0,
d: 1,
e: 0,
f: 0
};
e.interpolateNumber = Xi, e.interpolateTransform = Vi, e.interpolateObject = $i, e.interpolateString = Ji;
var Ki = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g;
e.interpolate = Qi, e.interpolators = [ function(e, t) {
var n = typeof t;
return (n === "string" || n !== typeof e ? Kt.has(t) || /^(#|rgb\(|hsl\()/.test(t) ? Ii : Ji : t instanceof ft ? Ii : n === "object" ? Array.isArray(t) ? Yi : $i : Xi)(e, t);
} ], e.interpolateArray = Yi;
var Zi = function() {
return Gt;
}, es = e.map({
linear: Zi,
poly: as,
quad: function() {
return ss;
},
cubic: function() {
return os;
},
sin: function() {
return fs;
},
exp: function() {
return ls;
},
circle: function() {
return cs;
},
elastic: hs,
back: ps,
bounce: function() {
return ds;
}
}), ts = e.map({
"in": Gt,
out: rs,
"in-out": is,
"out-in": function(e) {
return is(rs(e));
}
});
e.ease = function(e) {
var t = e.indexOf("-"), n = t >= 0 ? e.substring(0, t) : e, r = t >= 0 ? e.substring(t + 1) : "in";
return n = es.get(n) || Zi, r = ts.get(r) || Gt, ns(r(n.apply(null, Array.prototype.slice.call(arguments, 1))));
}, e.interpolateHcl = vs, e.interpolateHsl = ms, e.interpolateLab = gs, e.interpolateRound = ys, e.layout = {}, e.layout.bundle = function() {
return function(e) {
var t = [], n = -1, r = e.length;
while (++n < r) t.push(Es(e[n]));
return t;
};
}, e.layout.chord = function() {
function l() {
var t = {}, l = [], h = e.range(s), p = [], d, v, m, g, y;
n = [], r = [], d = 0, g = -1;
while (++g < s) {
v = 0, y = -1;
while (++y < s) v += i[g][y];
l.push(v), p.push(e.range(s)), d += v;
}
u && h.sort(function(e, t) {
return u(l[e], l[t]);
}), a && p.forEach(function(e, t) {
e.sort(function(e, n) {
return a(i[t][e], i[t][n]);
});
}), d = (2 * dt - o * s) / d, v = 0, g = -1;
while (++g < s) {
m = v, y = -1;
while (++y < s) {
var b = h[g], w = p[b][y], E = i[b][w], S = v, x = v += E * d;
t[b + "-" + w] = {
index: b,
subindex: w,
startAngle: S,
endAngle: x,
value: E
};
}
r[b] = {
index: b,
startAngle: m,
endAngle: v,
value: (v - m) / d
}, v += o;
}
g = -1;
while (++g < s) {
y = g - 1;
while (++y < s) {
var T = t[g + "-" + y], N = t[y + "-" + g];
(T.value || N.value) && n.push(T.value < N.value ? {
source: N,
target: T
} : {
source: T,
target: N
});
}
}
f && c();
}
function c() {
n.sort(function(e, t) {
return f((e.source.value + e.target.value) / 2, (t.source.value + t.target.value) / 2);
});
}
var t = {}, n, r, i, s, o = 0, u, a, f;
return t.matrix = function(e) {
return arguments.length ? (s = (i = e) && i.length, n = r = null, t) : i;
}, t.padding = function(e) {
return arguments.length ? (o = e, n = r = null, t) : o;
}, t.sortGroups = function(e) {
return arguments.length ? (u = e, n = r = null, t) : u;
}, t.sortSubgroups = function(e) {
return arguments.length ? (a = e, n = null, t) : a;
}, t.sortChords = function(e) {
return arguments.length ? (f = e, n && c(), t) : f;
}, t.chords = function() {
return n || l(), n;
}, t.groups = function() {
return r || l(), r;
}, t;
}, e.layout.force = function() {
function g(e) {
return function(t, n, r, i) {
if (t.point !== e) {
var s = t.cx - e.x, o = t.cy - e.y, u = 1 / Math.sqrt(s * s + o * o);
if ((i - n) * u < c) {
var a = t.charge * u * u;
return e.px -= s * a, e.py -= o * a, !0;
}
if (t.point && isFinite(u)) {
var a = t.pointCharge * u * u;
e.px -= s * a, e.py -= o * a;
}
}
return !t.charge;
};
}
function y(n) {
n.px = e.event.x, n.py = e.event.y, t.resume();
}
var t = {}, n = e.dispatch("start", "tick", "end"), r = [ 1, 1 ], i, s, o = .9, u = As, a = Os, f = -30, l = .1, c = .8, h = [], p = [], d, v, m;
return t.tick = function() {
if ((s *= .99) < .005) return n.end({
type: "end",
alpha: s = 0
}), !0;
var t = h.length, i = p.length, u, a, c, y, b, w, E, S, x;
for (a = 0; a < i; ++a) {
c = p[a], y = c.source, b = c.target, S = b.x - y.x, x = b.y - y.y;
if (w = S * S + x * x) w = s * v[a] * ((w = Math.sqrt(w)) - d[a]) / w, S *= w, x *= w, b.x -= S * (E = y.weight / (b.weight + y.weight)), b.y -= x * E, y.x += S * (E = 1 - E), y.y += x * E;
}
if (E = s * l) {
S = r[0] / 2, x = r[1] / 2, a = -1;
if (E) while (++a < t) c = h[a], c.x += (S - c.x) * E, c.y += (x - c.y) * E;
}
if (f) {
Ls(u = e.geom.quadtree(h), s, m), a = -1;
while (++a < t) (c = h[a]).fixed || u.visit(g(c));
}
a = -1;
while (++a < t) c = h[a], c.fixed ? (c.x = c.px, c.y = c.py) : (c.x -= (c.px - (c.px = c.x)) * o, c.y -= (c.py - (c.py = c.y)) * o);
n.tick({
type: "tick",
alpha: s
});
}, t.nodes = function(e) {
return arguments.length ? (h = e, t) : h;
}, t.links = function(e) {
return arguments.length ? (p = e, t) : p;
}, t.size = function(e) {
return arguments.length ? (r = e, t) : r;
}, t.linkDistance = function(e) {
return arguments.length ? (u = typeof e == "function" ? e : +e, t) : u;
}, t.distance = t.linkDistance, t.linkStrength = function(e) {
return arguments.length ? (a = typeof e == "function" ? e : +e, t) : a;
}, t.friction = function(e) {
return arguments.length ? (o = +e, t) : o;
}, t.charge = function(e) {
return arguments.length ? (f = typeof e == "function" ? e : +e, t) : f;
}, t.gravity = function(e) {
return arguments.length ? (l = +e, t) : l;
}, t.theta = function(e) {
return arguments.length ? (c = +e, t) : c;
}, t.alpha = function(r) {
return arguments.length ? (r = +r, s ? r > 0 ? s = r : s = 0 : r > 0 && (n.start({
type: "start",
alpha: s = r
}), e.timer(t.tick)), t) : s;
}, t.start = function() {
function y(t, n) {
var r = b(e), i = -1, s = r.length, o;
while (++i < s) if (!isNaN(o = r[i][t])) return o;
return Math.random() * n;
}
function b() {
if (!c) {
c = [];
for (n = 0; n < i; ++n) c[n] = [];
for (n = 0; n < s; ++n) {
var t = p[n];
c[t.source.index].push(t.target), c[t.target.index].push(t.source);
}
}
return c[e];
}
var e, n, i = h.length, s = p.length, o = r[0], l = r[1], c, g;
for (e = 0; e < i; ++e) (g = h[e]).index = e, g.weight = 0;
for (e = 0; e < s; ++e) g = p[e], typeof g.source == "number" && (g.source = h[g.source]), typeof g.target == "number" && (g.target = h[g.target]), ++g.source.weight, ++g.target.weight;
for (e = 0; e < i; ++e) g = h[e], isNaN(g.x) && (g.x = y("x", o)), isNaN(g.y) && (g.y = y("y", l)), isNaN(g.px) && (g.px = g.x), isNaN(g.py) && (g.py = g.y);
d = [];
if (typeof u == "function") for (e = 0; e < s; ++e) d[e] = +u.call(this, p[e], e); else for (e = 0; e < s; ++e) d[e] = u;
v = [];
if (typeof a == "function") for (e = 0; e < s; ++e) v[e] = +a.call(this, p[e], e); else for (e = 0; e < s; ++e) v[e] = a;
m = [];
if (typeof f == "function") for (e = 0; e < i; ++e) m[e] = +f.call(this, h[e], e); else for (e = 0; e < i; ++e) m[e] = f;
return t.resume();
}, t.resume = function() {
return t.alpha(.1);
}, t.stop = function() {
return t.alpha(0);
}, t.drag = function() {
i || (i = e.behavior.drag().origin(Gt).on("dragstart.force", Ts).on("drag.force", y).on("dragend.force", Ns));
if (!arguments.length) return i;
this.on("mouseover.force", Cs).on("mouseout.force", ks).call(i);
}, e.rebind(t, n, "on");
};
var As = 20, Os = 1;
e.layout.hierarchy = function() {
function r(i, o, u) {
var a = t.call(s, i, o);
i.depth = o, u.push(i);
if (a && (l = a.length)) {
var f = -1, l, c = i.children = [], h = 0, p = o + 1, d;
while (++f < l) d = r(a[f], p, u), d.parent = i, c.push(d), h += d.value;
e && c.sort(e), n && (i.value = h);
} else n && (i.value = +n.call(s, i, o) || 0);
return i;
}
function i(e, t) {
var r = e.children, o = 0;
if (r && (a = r.length)) {
var u = -1, a, f = t + 1;
while (++u < a) o += i(r[u], f);
} else n && (o = +n.call(s, e, t) || 0);
return n && (e.value = o), o;
}
function s(e) {
var t = [];
return r(e, 0, t), t;
}
var e = Ps, t = _s, n = Ds;
return s.sort = function(t) {
return arguments.length ? (e = t, s) : e;
}, s.children = function(e) {
return arguments.length ? (t = e, s) : t;
}, s.value = function(e) {
return arguments.length ? (n = e, s) : n;
}, s.revalue = function(e) {
return i(e, 0), e;
}, s;
}, e.layout.partition = function() {
function r(e, t, n, i) {
var s = e.children;
e.x = t, e.y = e.depth * i, e.dx = n, e.dy = i;
if (s && (u = s.length)) {
var o = -1, u, a, f;
n = e.value ? n / e.value : 0;
while (++o < u) r(a = s[o], t, f = a.value * n, i), t += f;
}
}
function i(e) {
var t = e.children, n = 0;
if (t && (s = t.length)) {
var r = -1, s;
while (++r < s) n = Math.max(n, i(t[r]));
}
return 1 + n;
}
function s(e, s) {
var o = t.call(this, e, s);
return r(o[0], 0, n[0], n[1] / i(o[0])), o;
}
var t = e.layout.hierarchy(), n = [ 1, 1 ];
return s.size = function(e) {
return arguments.length ? (n = e, s) : n;
}, Ms(s, t);
}, e.layout.pie = function() {
function s(o) {
var u = o.map(function(e, n) {
return +t.call(s, e, n);
}), a = +(typeof r == "function" ? r.apply(this, arguments) : r), f = ((typeof i == "function" ? i.apply(this, arguments) : i) - a) / e.sum(u), l = e.range(o.length);
n != null && l.sort(n === Bs ? function(e, t) {
return u[t] - u[e];
} : function(e, t) {
return n(o[e], o[t]);
});
var c = [];
return l.forEach(function(e) {
var t;
c[e] = {
data: o[e],
value: t = u[e],
startAngle: a,
endAngle: a += t * f
};
}), c;
}
var t = Number, n = Bs, r = 0, i = 2 * dt;
return s.value = function(e) {
return arguments.length ? (t = e, s) : t;
}, s.sort = function(e) {
return arguments.length ? (n = e, s) : n;
}, s.startAngle = function(e) {
return arguments.length ? (r = e, s) : r;
}, s.endAngle = function(e) {
return arguments.length ? (i = e, s) : i;
}, s;
};
var Bs = {};
e.layout.stack = function() {
function u(a, f) {
var l = a.map(function(e, n) {
return t.call(u, e, n);
}), c = l.map(function(e) {
return e.map(function(e, t) {
return [ s.call(u, e, t), o.call(u, e, t) ];
});
}), h = n.call(u, c, f);
l = e.permute(l, h), c = e.permute(c, h);
var p = r.call(u, c, f), d = l.length, v = l[0].length, m, g, y;
for (g = 0; g < v; ++g) {
i.call(u, l[0][g], y = p[g], c[0][g][1]);
for (m = 1; m < d; ++m) i.call(u, l[m][g], y += c[m - 1][g][1], c[m][g][1]);
}
return a;
}
var t = Gt, n = Us, r = zs, i = Is, s = js, o = Fs;
return u.values = function(e) {
return arguments.length ? (t = e, u) : t;
}, u.order = function(e) {
return arguments.length ? (n = typeof e == "function" ? e : qs.get(e) || Us, u) : n;
}, u.offset = function(e) {
return arguments.length ? (r = typeof e == "function" ? e : Rs.get(e) || zs, u) : r;
}, u.x = function(e) {
return arguments.length ? (s = e, u) : s;
}, u.y = function(e) {
return arguments.length ? (o = e, u) : o;
}, u.out = function(e) {
return arguments.length ? (i = e, u) : i;
}, u;
};
var qs = e.map({
"inside-out": function(t) {
var n = t.length, r, i, s = t.map(Ws), o = t.map(Xs), u = e.range(n).sort(function(e, t) {
return s[e] - s[t];
}), a = 0, f = 0, l = [], c = [];
for (r = 0; r < n; ++r) i = u[r], a < f ? (a += o[i], l.push(i)) : (f += o[i], c.push(i));
return c.reverse().concat(l);
},
reverse: function(t) {
return e.range(t.length).reverse();
},
"default": Us
}), Rs = e.map({
silhouette: function(e) {
var t = e.length, n = e[0].length, r = [], i = 0, s, o, u, a = [];
for (o = 0; o < n; ++o) {
for (s = 0, u = 0; s < t; s++) u += e[s][o][1];
u > i && (i = u), r.push(u);
}
for (o = 0; o < n; ++o) a[o] = (i - r[o]) / 2;
return a;
},
wiggle: function(e) {
var t = e.length, n = e[0], r = n.length, i, s, o, u, a, f, l, c, h, p = [];
p[0] = c = h = 0;
for (s = 1; s < r; ++s) {
for (i = 0, u = 0; i < t; ++i) u += e[i][s][1];
for (i = 0, a = 0, l = n[s][0] - n[s - 1][0]; i < t; ++i) {
for (o = 0, f = (e[i][s][1] - e[i][s - 1][1]) / (2 * l); o < i; ++o) f += (e[o][s][1] - e[o][s - 1][1]) / l;
a += f * e[i][s][1];
}
p[s] = c -= u ? a / u * l : 0, c < h && (h = c);
}
for (s = 0; s < r; ++s) p[s] -= h;
return p;
},
expand: function(e) {
var t = e.length, n = e[0].length, r = 1 / t, i, s, o, u = [];
for (s = 0; s < n; ++s) {
for (i = 0, o = 0; i < t; i++) o += e[i][s][1];
if (o) for (i = 0; i < t; i++) e[i][s][1] /= o; else for (i = 0; i < t; i++) e[i][s][1] = r;
}
for (s = 0; s < n; ++s) u[s] = 0;
return u;
},
zero: zs
});
e.layout.histogram = function() {
function s(s, o) {
var u = [], a = s.map(n, this), f = r.call(this, a, o), l = i.call(this, f, a, o), c, o = -1, h = a.length, p = l.length - 1, d = t ? 1 : 1 / h, v;
while (++o < p) c = u[o] = [], c.dx = l[o + 1] - (c.x = l[o]), c.y = 0;
if (p > 0) {
o = -1;
while (++o < h) v = a[o], v >= f[0] && v <= f[1] && (c = u[e.bisect(l, v, 1, p) - 1], c.y += d, c.push(s[o]));
}
return u;
}
var t = !0, n = Number, r = Ks, i = $s;
return s.value = function(e) {
return arguments.length ? (n = e, s) : n;
}, s.range = function(e) {
return arguments.length ? (r = Qt(e), s) : r;
}, s.bins = function(e) {
return arguments.length ? (i = typeof e == "number" ? function(t) {
return Js(t, e);
} : Qt(e), s) : i;
}, s.frequency = function(e) {
return arguments.length ? (t = !!e, s) : t;
}, s;
}, e.layout.tree = function() {
function i(e, i) {
function u(e, t) {
var r = e.children, i = e._tree;
if (r && (s = r.length)) {
var s, o = r[0], a, l = o, c, h = -1;
while (++h < s) c = r[h], u(c, a), l = f(c, a, l), a = c;
io(e);
var p = .5 * (o._tree.prelim + c._tree.prelim);
t ? (i.prelim = t._tree.prelim + n(e, t), i.mod = i.prelim - p) : i.prelim = p;
} else t && (i.prelim = t._tree.prelim + n(e, t));
}
function a(e, t) {
e.x = e._tree.prelim + t;
var n = e.children;
if (n && (i = n.length)) {
var r = -1, i;
t += e._tree.mod;
while (++r < i) a(n[r], t);
}
}
function f(e, t, r) {
if (t) {
var i = e, s = e, o = t, u = e.parent.children[0], a = i._tree.mod, f = s._tree.mod, l = o._tree.mod, c = u._tree.mod, h;
while (o = Ys(o), i = Gs(i), o && i) u = Gs(u), s = Ys(s), s._tree.ancestor = e, h = o._tree.prelim + l - i._tree.prelim - a + n(o, i), h > 0 && (so(oo(o, e, r), e, h), a += h, f += h), l += o._tree.mod, a += i._tree.mod, c += u._tree.mod, f += s._tree.mod;
o && !Ys(s) && (s._tree.thread = o, s._tree.mod += l - f), i && !Gs(u) && (u._tree.thread = i, u._tree.mod += a - c, r = e);
}
return r;
}
var s = t.call(this, e, i), o = s[0];
ro(o, function(e, t) {
e._tree = {
ancestor: e,
prelim: 0,
mod: 0,
change: 0,
shift: 0,
number: t ? t._tree.number + 1 : 0
};
}), u(o), a(o, -o._tree.prelim);
var l = Zs(o, to), c = Zs(o, eo), h = Zs(o, no), p = l.x - n(l, c) / 2, d = c.x + n(c, l) / 2, v = h.depth || 1;
return ro(o, function(e) {
e.x = (e.x - p) / (d - p) * r[0], e.y = e.depth / v * r[1], delete e._tree;
}), s;
}
var t = e.layout.hierarchy().sort(null).value(null), n = Qs, r = [ 1, 1 ];
return i.separation = function(e) {
return arguments.length ? (n = e, i) : n;
}, i.size = function(e) {
return arguments.length ? (r = e, i) : r;
}, Ms(i, t);
}, e.layout.pack = function() {
function i(e, i) {
var s = t.call(this, e, i), o = s[0];
o.x = 0, o.y = 0, ro(o, function(e) {
e.r = Math.sqrt(e.value);
}), ro(o, co);
var u = r[0], a = r[1], f = Math.max(2 * o.r / u, 2 * o.r / a);
if (n > 0) {
var l = n * f / 2;
ro(o, function(e) {
e.r += l;
}), ro(o, co), ro(o, function(e) {
e.r -= l;
}), f = Math.max(2 * o.r / u, 2 * o.r / a);
}
return vo(o, u / 2, a / 2, 1 / f), s;
}
var t = e.layout.hierarchy().sort(uo), n = 0, r = [ 1, 1 ];
return i.size = function(e) {
return arguments.length ? (r = e, i) : r;
}, i.padding = function(e) {
return arguments.length ? (n = +e, i) : n;
}, Ms(i, t);
}, e.layout.cluster = function() {
function i(e, i) {
var s = t.call(this, e, i), o = s[0], u, a = 0;
ro(o, function(e) {
var t = e.children;
t && t.length ? (e.x = yo(t), e.y = go(t)) : (e.x = u ? a += n(e, u) : 0, e.y = 0, u = e);
});
var f = bo(o), l = wo(o), c = f.x - n(f, l) / 2, h = l.x + n(l, f) / 2;
return ro(o, function(e) {
e.x = (e.x - c) / (h - c) * r[0], e.y = (1 - (o.y ? e.y / o.y : 1)) * r[1];
}), s;
}
var t = e.layout.hierarchy().sort(null).value(null), n = Qs, r = [ 1, 1 ];
return i.separation = function(e) {
return arguments.length ? (n = e, i) : n;
}, i.size = function(e) {
return arguments.length ? (r = e, i) : r;
}, Ms(i, t);
}, e.layout.treemap = function() {
function l(e, t) {
var n = -1, r = e.length, i, s;
while (++n < r) s = (i = e[n]).value * (t < 0 ? 0 : t), i.area = isNaN(s) || s <= 0 ? 0 : s;
}
function c(e) {
var t = e.children;
if (t && t.length) {
var n = s(e), r = [], i = t.slice(), o, u = Infinity, f, h = a === "slice" ? n.dx : a === "dice" ? n.dy : a === "slice-dice" ? e.depth & 1 ? n.dy : n.dx : Math.min(n.dx, n.dy), v;
l(i, n.dx * n.dy / e.value), r.area = 0;
while ((v = i.length) > 0) r.push(o = i[v - 1]), r.area += o.area, a !== "squarify" || (f = p(r, h)) <= u ? (i.pop(), u = f) : (r.area -= r.pop().area, d(r, h, n, !1), h = Math.min(n.dx, n.dy), r.length = r.area = 0, u = Infinity);
r.length && (d(r, h, n, !0), r.length = r.area = 0), t.forEach(c);
}
}
function h(e) {
var t = e.children;
if (t && t.length) {
var n = s(e), r = t.slice(), i, o = [];
l(r, n.dx * n.dy / e.value), o.area = 0;
while (i = r.pop()) o.push(i), o.area += i.area, i.z != null && (d(o, i.z ? n.dx : n.dy, n, !r.length), o.length = o.area = 0);
t.forEach(h);
}
}
function p(e, t) {
var n = e.area, r, i = 0, s = Infinity, o = -1, u = e.length;
while (++o < u) {
if (!(r = e[o].area)) continue;
r < s && (s = r), r > i && (i = r);
}
return n *= n, t *= t, n ? Math.max(t * i * f / n, n / (t * s * f)) : Infinity;
}
function d(e, t, r, i) {
var s = -1, o = e.length, u = r.x, a = r.y, f = t ? n(e.area / t) : 0, l;
if (t == r.dx) {
if (i || f > r.dy) f = r.dy;
while (++s < o) l = e[s], l.x = u, l.y = a, l.dy = f, u += l.dx = Math.min(r.x + r.dx - u, f ? n(l.area / f) : 0);
l.z = !0, l.dx += r.x + r.dx - u, r.y += f, r.dy -= f;
} else {
if (i || f > r.dx) f = r.dx;
while (++s < o) l = e[s], l.x = u, l.y = a, l.dx = f, a += l.dy = Math.min(r.y + r.dy - a, f ? n(l.area / f) : 0);
l.z = !1, l.dy += r.y + r.dy - a, r.x += f, r.dx -= f;
}
}
function v(e) {
var n = u || t(e), i = n[0];
return i.x = 0, i.y = 0, i.dx = r[0], i.dy = r[1], u && t.revalue(i), l([ i ], i.dx * i.dy / i.value), (u ? h : c)(i), o && (u = n), n;
}
var t = e.layout.hierarchy(), n = Math.round, r = [ 1, 1 ], i = null, s = Eo, o = !1, u, a = "squarify", f = .5 * (1 + Math.sqrt(5));
return v.size = function(e) {
return arguments.length ? (r = e, v) : r;
}, v.padding = function(e) {
function t(t) {
var n = e.call(v, t, t.depth);
return n == null ? Eo(t) : So(t, typeof n == "number" ? [ n, n, n, n ] : n);
}
function n(t) {
return So(t, e);
}
if (!arguments.length) return i;
var r;
return s = (i = e) == null ? Eo : (r = typeof e) === "function" ? t : r === "number" ? (e = [ e, e, e, e ], n) : n, v;
}, v.round = function(e) {
return arguments.length ? (n = e ? Math.round : Number, v) : n != Number;
}, v.sticky = function(e) {
return arguments.length ? (o = e, u = null, v) : o;
}, v.ratio = function(e) {
return arguments.length ? (f = e, v) : f;
}, v.mode = function(e) {
return arguments.length ? (a = e + "", v) : a;
}, Ms(v, t);
}, e.random = {
normal: function(e, t) {
var n = arguments.length;
return n < 2 && (t = 1), n < 1 && (e = 0), function() {
var n, r, i;
do n = Math.random() * 2 - 1, r = Math.random() * 2 - 1, i = n * n + r * r; while (!i || i > 1);
return e + t * n * Math.sqrt(-2 * Math.log(i) / i);
};
},
logNormal: function() {
var t = e.random.normal.apply(e, arguments);
return function() {
return Math.exp(t());
};
},
irwinHall: function(e) {
return function() {
for (var t = 0, n = 0; n < e; n++) t += Math.random();
return t / e;
};
}
}, e.scale = {}, e.scale.linear = function() {
return Lo([ 0, 1 ], [ 0, 1 ], Qi, !1);
}, e.scale.log = function() {
return Po(e.scale.linear().domain([ 0, Math.LN10 ]), 10, Bo, jo);
};
var Ho = e.format(".0e");
e.scale.pow = function() {
return Ro(e.scale.linear(), 1);
}, e.scale.sqrt = function() {
return e.scale.pow().exponent(.5);
}, e.scale.ordinal = function() {
return zo([], {
t: "range",
a: [ [] ]
});
}, e.scale.category10 = function() {
return e.scale.ordinal().range(Wo);
}, e.scale.category20 = function() {
return e.scale.ordinal().range(Xo);
}, e.scale.category20b = function() {
return e.scale.ordinal().range(Vo);
}, e.scale.category20c = function() {
return e.scale.ordinal().range($o);
};
var Wo = [ "#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b", "#e377c2", "#7f7f7f", "#bcbd22", "#17becf" ], Xo = [ "#1f77b4", "#aec7e8", "#ff7f0e", "#ffbb78", "#2ca02c", "#98df8a", "#d62728", "#ff9896", "#9467bd", "#c5b0d5", "#8c564b", "#c49c94", "#e377c2", "#f7b6d2", "#7f7f7f", "#c7c7c7", "#bcbd22", "#dbdb8d", "#17becf", "#9edae5" ], Vo = [ "#393b79", "#5254a3", "#6b6ecf", "#9c9ede", "#637939", "#8ca252", "#b5cf6b", "#cedb9c", "#8c6d31", "#bd9e39", "#e7ba52", "#e7cb94", "#843c39", "#ad494a", "#d6616b", "#e7969c", "#7b4173", "#a55194", "#ce6dbd", "#de9ed6" ], $o = [ "#3182bd", "#6baed6", "#9ecae1", "#c6dbef", "#e6550d", "#fd8d3c", "#fdae6b", "#fdd0a2", "#31a354", "#74c476", "#a1d99b", "#c7e9c0", "#756bb1", "#9e9ac8", "#bcbddc", "#dadaeb", "#636363", "#969696", "#bdbdbd", "#d9d9d9" ];
e.scale.quantile = function() {
return Jo([], []);
}, e.scale.quantize = function() {
return Ko(0, 1, [ 0, 1 ]);
}, e.scale.threshold = function() {
return Qo([ .5 ], [ 0, 1 ]);
}, e.scale.identity = function() {
return Go([ 0, 1 ]);
}, e.svg.arc = function() {
function i() {
var i = e.apply(this, arguments), s = t.apply(this, arguments), o = n.apply(this, arguments) + Yo, u = r.apply(this, arguments) + Yo, a = (u < o && (a = o, o = u, u = a), u - o), f = a < dt ? "0" : "1", l = Math.cos(o), c = Math.sin(o), h = Math.cos(u), p = Math.sin(u);
return a >= Zo ? i ? "M0," + s + "A" + s + "," + s + " 0 1,1 0," + -s + "A" + s + "," + s + " 0 1,1 0," + s + "M0," + i + "A" + i + "," + i + " 0 1,0 0," + -i + "A" + i + "," + i + " 0 1,0 0," + i + "Z" : "M0," + s + "A" + s + "," + s + " 0 1,1 0," + -s + "A" + s + "," + s + " 0 1,1 0," + s + "Z" : i ? "M" + s * l + "," + s * c + "A" + s + "," + s + " 0 " + f + ",1 " + s * h + "," + s * p + "L" + i * h + "," + i * p + "A" + i + "," + i + " 0 " + f + ",0 " + i * l + "," + i * c + "Z" : "M" + s * l + "," + s * c + "A" + s + "," + s + " 0 " + f + ",1 " + s * h + "," + s * p + "L0,0" + "Z";
}
var e = eu, t = tu, n = nu, r = ru;
return i.innerRadius = function(t) {
return arguments.length ? (e = Qt(t), i) : e;
}, i.outerRadius = function(e) {
return arguments.length ? (t = Qt(e), i) : t;
}, i.startAngle = function(e) {
return arguments.length ? (n = Qt(e), i) : n;
}, i.endAngle = function(e) {
return arguments.length ? (r = Qt(e), i) : r;
}, i.centroid = function() {
var i = (e.apply(this, arguments) + t.apply(this, arguments)) / 2, s = (n.apply(this, arguments) + r.apply(this, arguments)) / 2 + Yo;
return [ Math.cos(s) * i, Math.sin(s) * i ];
}, i;
};
var Yo = -dt / 2, Zo = 2 * dt - 1e-6;
e.svg.line.radial = function() {
var e = ii(iu);
return e.radius = e.x, delete e.x, e.angle = e.y, delete e.y, e;
}, li.reverse = ci, ci.reverse = li, e.svg.area = function() {
return su(Gt);
}, e.svg.area.radial = function() {
var e = su(iu);
return e.radius = e.x, delete e.x, e.innerRadius = e.x0, delete e.x0, e.outerRadius = e.x1, delete e.x1, e.angle = e.y, delete e.y, e.startAngle = e.y0, delete e.y0, e.endAngle = e.y1, delete e.y1, e;
}, e.svg.chord = function() {
function s(n, r) {
var i = o(this, e, n, r), s = o(this, t, n, r);
return "M" + i.p0 + a(i.r, i.p1, i.a1 - i.a0) + (u(i, s) ? f(i.r, i.p1, i.r, i.p0) : f(i.r, i.p1, s.r, s.p0) + a(s.r, s.p1, s.a1 - s.a0) + f(s.r, s.p1, i.r, i.p0)) + "Z";
}
function o(e, t, s, o) {
var u = t.call(e, s, o), a = n.call(e, u, o), f = r.call(e, u, o) + Yo, l = i.call(e, u, o) + Yo;
return {
r: a,
a0: f,
a1: l,
p0: [ a * Math.cos(f), a * Math.sin(f) ],
p1: [ a * Math.cos(l), a * Math.sin(l) ]
};
}
function u(e, t) {
return e.a0 == t.a0 && e.a1 == t.a1;
}
function a(e, t, n) {
return "A" + e + "," + e + " 0 " + +(n > dt) + ",1 " + t;
}
function f(e, t, n, r) {
return "Q 0,0 " + r;
}
var e = Nr, t = Cr, n = ou, r = nu, i = ru;
return s.radius = function(e) {
return arguments.length ? (n = Qt(e), s) : n;
}, s.source = function(t) {
return arguments.length ? (e = Qt(t), s) : e;
}, s.target = function(e) {
return arguments.length ? (t = Qt(e), s) : t;
}, s.startAngle = function(e) {
return arguments.length ? (r = Qt(e), s) : r;
}, s.endAngle = function(e) {
return arguments.length ? (i = Qt(e), s) : i;
}, s;
}, e.svg.diagonal = function() {
function r(r, i) {
var s = e.call(this, r, i), o = t.call(this, r, i), u = (s.y + o.y) / 2, a = [ s, {
x: s.x,
y: u
}, {
x: o.x,
y: u
}, o ];
return a = a.map(n), "M" + a[0] + "C" + a[1] + " " + a[2] + " " + a[3];
}
var e = Nr, t = Cr, n = uu;
return r.source = function(t) {
return arguments.length ? (e = Qt(t), r) : e;
}, r.target = function(e) {
return arguments.length ? (t = Qt(e), r) : t;
}, r.projection = function(e) {
return arguments.length ? (n = e, r) : n;
}, r;
}, e.svg.diagonal.radial = function() {
var t = e.svg.diagonal(), n = uu, r = t.projection;
return t.projection = function(e) {
return arguments.length ? r(au(n = e)) : n;
}, t;
}, e.svg.symbol = function() {
function n(n, r) {
return (hu.get(e.call(this, n, r)) || cu)(t.call(this, n, r));
}
var e = lu, t = fu;
return n.type = function(t) {
return arguments.length ? (e = Qt(t), n) : e;
}, n.size = function(e) {
return arguments.length ? (t = Qt(e), n) : t;
}, n;
};
var hu = e.map({
circle: cu,
cross: function(e) {
var t = Math.sqrt(e / 5) / 2;
return "M" + -3 * t + "," + -t + "H" + -t + "V" + -3 * t + "H" + t + "V" + -t + "H" + 3 * t + "V" + t + "H" + t + "V" + 3 * t + "H" + -t + "V" + t + "H" + -3 * t + "Z";
},
diamond: function(e) {
var t = Math.sqrt(e / (2 * du)), n = t * du;
return "M0," + -t + "L" + n + ",0" + " 0," + t + " " + -n + ",0" + "Z";
},
square: function(e) {
var t = Math.sqrt(e) / 2;
return "M" + -t + "," + -t + "L" + t + "," + -t + " " + t + "," + t + " " + -t + "," + t + "Z";
},
"triangle-down": function(e) {
var t = Math.sqrt(e / pu), n = t * pu / 2;
return "M0," + n + "L" + t + "," + -n + " " + -t + "," + -n + "Z";
},
"triangle-up": function(e) {
var t = Math.sqrt(e / pu), n = t * pu / 2;
return "M0," + -n + "L" + t + "," + n + " " + -t + "," + n + "Z";
}
});
e.svg.symbolTypes = hu.keys();
var pu = Math.sqrt(3), du = Math.tan(30 * mt), mu = [], gu = 0, yu, bu = {
ease: us,
delay: 0,
duration: 250
};
mu.call = B.call, mu.empty = B.empty, mu.node = B.node, e.transition = function(e) {
return arguments.length ? yu ? e.transition() : e : st.transition();
}, e.transition.prototype = mu, mu.select = function(e) {
var t = this.id, n = [], r, i, s;
typeof e != "function" && (e = j(e));
for (var o = -1, u = this.length; ++o < u; ) {
n.push(r = []);
for (var a = this[o], f = -1, l = a.length; ++f < l; ) (s = a[f]) && (i = e.call(s, s.__data__, f)) ? ("__data__" in s && (i.__data__ = s.__data__), Su(i, f, t, s.__transition__[t]), r.push(i)) : r.push(null);
}
return vu(n, t);
}, mu.selectAll = function(e) {
var t = this.id, n = [], r, i, s, o, u;
typeof e != "function" && (e = F(e));
for (var a = -1, f = this.length; ++a < f; ) for (var l = this[a], c = -1, h = l.length; ++c < h; ) if (s = l[c]) {
u = s.__transition__[t], i = e.call(s, s.__data__, c), n.push(r = []);
for (var p = -1, d = i.length; ++p < d; ) Su(o = i[p], p, t, u), r.push(o);
}
return vu(n, t);
}, mu.filter = function(e) {
var t = [], n, r, i;
typeof e != "function" && (e = K(e));
for (var s = 0, o = this.length; s < o; s++) {
t.push(n = []);
for (var r = this[s], u = 0, a = r.length; u < a; u++) (i = r[u]) && e.call(i, i.__data__, u) && n.push(i);
}
return vu(t, this.id, this.time).ease(this.ease());
}, mu.tween = function(e, t) {
var n = this.id;
return arguments.length < 2 ? this.node().__transition__[n].tween.get(e) : nt(this, t == null ? function(t) {
t.__transition__[n].tween.remove(e);
} : function(r) {
r.__transition__[n].tween.set(e, t);
});
}, mu.attr = function(t, n) {
function s() {
this.removeAttribute(i);
}
function o() {
this.removeAttributeNS(i.space, i.local);
}
if (arguments.length < 2) {
for (n in t) this.attr(n, t[n]);
return this;
}
var r = Gi(t), i = e.ns.qualify(t);
return wu(this, "attr." + t, n, function(e) {
function t() {
var t = this.getAttribute(i), n;
return t !== e && (n = r(t, e), function(e) {
this.setAttribute(i, n(e));
});
}
function n() {
var t = this.getAttributeNS(i.space, i.local), n;
return t !== e && (n = r(t, e), function(e) {
this.setAttributeNS(i.space, i.local, n(e));
});
}
return e == null ? i.local ? o : s : (e += "", i.local ? n : t);
});
}, mu.attrTween = function(t, n) {
function i(e, t) {
var i = n.call(this, e, t, this.getAttribute(r));
return i && function(e) {
this.setAttribute(r, i(e));
};
}
function s(e, t) {
var i = n.call(this, e, t, this.getAttributeNS(r.space, r.local));
return i && function(e) {
this.setAttributeNS(r.space, r.local, i(e));
};
}
var r = e.ns.qualify(t);
return this.tween("attr." + t, r.local ? s : i);
}, mu.style = function(e, t, r) {
function o() {
this.style.removeProperty(e);
}
var i = arguments.length;
if (i < 3) {
if (typeof e != "string") {
i < 2 && (t = "");
for (r in e) this.style(r, e[r], t);
return this;
}
r = "";
}
var s = Gi(e);
return wu(this, "style." + e, t, function(t) {
function i() {
var i = n.getComputedStyle(this, null).getPropertyValue(e), o;
return i !== t && (o = s(i, t), function(t) {
this.style.setProperty(e, o(t), r);
});
}
return t == null ? o : (t += "", i);
});
}, mu.styleTween = function(e, t, r) {
return arguments.length < 3 && (r = ""), this.tween("style." + e, function(i, s) {
var o = t.call(this, i, s, n.getComputedStyle(this, null).getPropertyValue(e));
return o && function(t) {
this.style.setProperty(e, o(t), r);
};
});
}, mu.text = function(e) {
return wu(this, "text", e, Eu);
}, mu.remove = function() {
return this.each("end.transition", function() {
var e;
!this.__transition__ && (e = this.parentNode) && e.removeChild(this);
});
}, mu.ease = function(t) {
var n = this.id;
return arguments.length < 1 ? this.node().__transition__[n].ease : (typeof t != "function" && (t = e.ease.apply(e, arguments)), nt(this, function(e) {
e.__transition__[n].ease = t;
}));
}, mu.delay = function(e) {
var t = this.id;
return nt(this, typeof e == "function" ? function(n, r, i) {
n.__transition__[t].delay = e.call(n, n.__data__, r, i) | 0;
} : (e |= 0, function(n) {
n.__transition__[t].delay = e;
}));
}, mu.duration = function(e) {
var t = this.id;
return nt(this, typeof e == "function" ? function(n, r, i) {
n.__transition__[t].duration = Math.max(1, e.call(n, n.__data__, r, i) | 0);
} : (e = Math.max(1, e | 0), function(n) {
n.__transition__[t].duration = e;
}));
}, mu.each = function(e, t) {
var n = this.id;
if (arguments.length < 2) {
var r = bu, i = yu;
yu = n, nt(this, function(t, r, i) {
bu = t.__transition__[n], e.call(t, t.__data__, r, i);
}), bu = r, yu = i;
} else nt(this, function(r) {
r.__transition__[n].event.on(e, t);
});
return this;
}, mu.transition = function() {
var e = this.id, t = ++gu, n = [], r, i, s, o;
for (var u = 0, a = this.length; u < a; u++) {
n.push(r = []);
for (var i = this[u], f = 0, l = i.length; f < l; f++) {
if (s = i[f]) o = Object.create(s.__transition__[e]), o.delay += o.duration, Su(s, f, t, o);
r.push(s);
}
}
return vu(n, t);
}, e.svg.axis = function() {
function c(c) {
c.each(function() {
var c = e.select(this), h = a == null ? t.ticks ? t.ticks.apply(t, u) : t.domain() : a, p = f == null ? t.tickFormat ? t.tickFormat.apply(t, u) : String : f, d = ku(t, h, l), v = c.selectAll(".tick.minor").data(d, String), m = v.enter().insert("line", ".tick").attr("class", "tick minor").style("opacity", 1e-6), g = e.transition(v.exit()).style("opacity", 1e-6).remove(), y = e.transition(v).style("opacity", 1), b = c.selectAll(".tick.major").data(h, String), w = b.enter().insert("g", "path").attr("class", "tick major").style("opacity", 1e-6), E = e.transition(b.exit()).style("opacity", 1e-6).remove(), S = e.transition(b).style("opacity", 1), x, T = To(t), N = c.selectAll(".domain").data([ 0 ]), C = (N.enter().append("path").attr("class", "domain"), e.transition(N)), k = t.copy(), L = this.__chart__ || k;
this.__chart__ = k, w.append("line"), w.append("text");
var A = w.select("line"), O = S.select("line"), M = b.select("text").text(p), _ = w.select("text"), D = S.select("text");
switch (n) {
case "bottom":
x = Nu, m.attr("y2", i), y.attr("x2", 0).attr("y2", i), A.attr("y2", r), _.attr("y", Math.max(r, 0) + o), O.attr("x2", 0).attr("y2", r), D.attr("x", 0).attr("y", Math.max(r, 0) + o), M.attr("dy", ".71em").style("text-anchor", "middle"), C.attr("d", "M" + T[0] + "," + s + "V0H" + T[1] + "V" + s);
break;
case "top":
x = Nu, m.attr("y2", -i), y.attr("x2", 0).attr("y2", -i), A.attr("y2", -r), _.attr("y", -(Math.max(r, 0) + o)), O.attr("x2", 0).attr("y2", -r), D.attr("x", 0).attr("y", -(Math.max(r, 0) + o)), M.attr("dy", "0em").style("text-anchor", "middle"), C.attr("d", "M" + T[0] + "," + -s + "V0H" + T[1] + "V" + -s);
break;
case "left":
x = Cu, m.attr("x2", -i), y.attr("x2", -i).attr("y2", 0), A.attr("x2", -r), _.attr("x", -(Math.max(r, 0) + o)), O.attr("x2", -r).attr("y2", 0), D.attr("x", -(Math.max(r, 0) + o)).attr("y", 0), M.attr("dy", ".32em").style("text-anchor", "end"), C.attr("d", "M" + -s + "," + T[0] + "H0V" + T[1] + "H" + -s);
break;
case "right":
x = Cu, m.attr("x2", i), y.attr("x2", i).attr("y2", 0), A.attr("x2", r), _.attr("x", Math.max(r, 0) + o), O.attr("x2", r).attr("y2", 0), D.attr("x", Math.max(r, 0) + o).attr("y", 0), M.attr("dy", ".32em").style("text-anchor", "start"), C.attr("d", "M" + s + "," + T[0] + "H0V" + T[1] + "H" + s);
}
if (t.ticks) w.call(x, L), S.call(x, k), E.call(x, k), m.call(x, L), y.call(x, k), g.call(x, k); else {
var P = k.rangeBand() / 2, H = function(e) {
return k(e) + P;
};
w.call(x, H), S.call(x, H);
}
});
}
var t = e.scale.linear(), n = xu, r = 6, i = 6, s = 6, o = 3, u = [ 10 ], a = null, f, l = 0;
return c.scale = function(e) {
return arguments.length ? (t = e, c) : t;
}, c.orient = function(e) {
return arguments.length ? (n = e in Tu ? e + "" : xu, c) : n;
}, c.ticks = function() {
return arguments.length ? (u = arguments, c) : u;
}, c.tickValues = function(e) {
return arguments.length ? (a = e, c) : a;
}, c.tickFormat = function(e) {
return arguments.length ? (f = e, c) : f;
}, c.tickSize = function(e, t) {
if (!arguments.length) return r;
var n = arguments.length - 1;
return r = +e, i = n > 1 ? +t : r, s = n > 0 ? +arguments[n] : r, c;
}, c.tickPadding = function(e) {
return arguments.length ? (o = +e, c) : o;
}, c.tickSubdivide = function(e) {
return arguments.length ? (l = +e, c) : l;
}, c;
};
var xu = "bottom", Tu = {
top: 1,
right: 1,
bottom: 1,
left: 1
};
e.svg.brush = function() {
function a(t) {
t.each(function() {
var t = e.select(this), n = t.selectAll(".background").data([ 0 ]), o = t.selectAll(".extent").data([ 0 ]), u = t.selectAll(".resize").data(s, String), p;
t.style("pointer-events", "all").on("mousedown.brush", h).on("touchstart.brush", h), n.enter().append("rect").attr("class", "background").style("visibility", "hidden").style("cursor", "crosshair"), o.enter().append("rect").attr("class", "extent").style("cursor", "move"), u.enter().append("g").attr("class", function(e) {
return "resize " + e;
}).style("cursor", function(e) {
return Lu[e];
}).append("rect").attr("x", function(e) {
return /[ew]$/.test(e) ? -3 : null;
}).attr("y", function(e) {
return /^[ns]/.test(e) ? -3 : null;
}).attr("width", 6).attr("height", 6).style("visibility", "hidden"), u.style("display", a.empty() ? "none" : null), u.exit().remove(), r && (p = To(r), n.attr("x", p[0]).attr("width", p[1] - p[0]), l(t)), i && (p = To(i), n.attr("y", p[0]).attr("height", p[1] - p[0]), c(t)), f(t);
});
}
function f(e) {
e.selectAll(".resize").attr("transform", function(e) {
return "translate(" + o[+/e$/.test(e)][0] + "," + o[+/^s/.test(e)][1] + ")";
});
}
function l(e) {
e.select(".extent").attr("x", o[0][0]), e.selectAll(".extent,.n>rect,.s>rect").attr("width", o[1][0] - o[0][0]);
}
function c(e) {
e.select(".extent").attr("y", o[0][1]), e.selectAll(".extent,.e>rect,.w>rect").attr("height", o[1][1] - o[0][1]);
}
function h() {
function C() {
var t = e.event.changedTouches;
return t ? e.touches(s, t)[0] : e.mouse(s);
}
function k() {
e.event.keyCode == 32 && (b || (w = null, E[0] -= o[1][0], E[1] -= o[1][1], b = 2), y());
}
function L() {
e.event.keyCode == 32 && b == 2 && (E[0] += o[1][0], E[1] += o[1][1], b = 0, y());
}
function A() {
var t = C(), n = !1;
S && (t[0] += S[0], t[1] += S[1]), b || (e.event.altKey ? (w || (w = [ (o[0][0] + o[1][0]) / 2, (o[0][1] + o[1][1]) / 2 ]), E[0] = o[+(t[0] < w[0])][0], E[1] = o[+(t[1] < w[1])][1]) : w = null), m && O(t, r, 0) && (l(d), n = !0), g && O(t, i, 1) && (c(d), n = !0), n && (f(d), p({
type: "brush",
mode: b ? "move" : "resize"
}));
}
function O(e, t, n) {
var r = To(t), i = r[0], s = r[1], a = E[n], f = o[1][n] - o[0][n], l, c;
b && (i -= a, s -= f + a), l = Math.max(i, Math.min(s, e[n])), b ? c = (l += a) + f : (w && (a = Math.max(i, Math.min(s, 2 * w[n] - l))), a < l ? (c = l, l = a) : c = a);
if (o[0][n] !== l || o[1][n] !== c) return u = null, o[0][n] = l, o[1][n] = c, !0;
}
function M() {
A(), d.style("pointer-events", "all").selectAll(".resize").style("display", a.empty() ? "none" : null), e.select("body").style("cursor", null), x.on("mousemove.brush", null).on("mouseup.brush", null).on("touchmove.brush", null).on("touchend.brush", null).on("keydown.brush", null).on("keyup.brush", null), p({
type: "brushend"
}), y();
}
var s = this, h = e.select(e.event.target), p = t.of(s, arguments), d = e.select(s), v = h.datum(), m = !/^(n|s)$/.test(v) && r, g = !/^(e|w)$/.test(v) && i, b = h.classed("extent"), w, E = C(), S, x = e.select(n).on("mousemove.brush", A).on("mouseup.brush", M).on("touchmove.brush", A).on("touchend.brush", M).on("keydown.brush", k).on("keyup.brush", L);
if (b) E[0] = o[0][0] - E[0], E[1] = o[0][1] - E[1]; else if (v) {
var T = +/w$/.test(v), N = +/^n/.test(v);
S = [ o[1 - T][0] - E[0], o[1 - N][1] - E[1] ], E[0] = o[T][0], E[1] = o[N][1];
} else e.event.altKey && (w = E.slice());
d.style("pointer-events", "none").selectAll(".resize").style("display", null), e.select("body").style("cursor", h.style("cursor")), p({
type: "brushstart"
}), A(), y();
}
var t = S(a, "brushstart", "brush", "brushend"), r = null, i = null, s = Au[0], o = [ [ 0, 0 ], [ 0, 0 ] ], u;
return a.x = function(e) {
return arguments.length ? (r = e, s = Au[!r << 1 | !i], a) : r;
}, a.y = function(e) {
return arguments.length ? (i = e, s = Au[!r << 1 | !i], a) : i;
}, a.extent = function(e) {
var t, n, s, f, l;
return arguments.length ? (u = [ [ 0, 0 ], [ 0, 0 ] ], r && (t = e[0], n = e[1], i && (t = t[0], n = n[0]), u[0][0] = t, u[1][0] = n, r.invert && (t = r(t), n = r(n)), n < t && (l = t, t = n, n = l), o[0][0] = t | 0, o[1][0] = n | 0), i && (s = e[0], f = e[1], r && (s = s[1], f = f[1]), u[0][1] = s, u[1][1] = f, i.invert && (s = i(s), f = i(f)), f < s && (l = s, s = f, f = l), o[0][1] = s | 0, o[1][1] = f | 0), a) : (e = u || o, r && (t = e[0][0], n = e[1][0], u || (t = o[0][0], n = o[1][0], r.invert && (t = r.invert(t), n = r.invert(n)), n < t && (l = t, t = n, n = l))), i && (s = e[0][1], f = e[1][1], u || (s = o[0][1], f = o[1][1], i.invert && (s = i.invert(s), f = i.invert(f)), f < s && (l = s, s = f, f = l))), r && i ? [ [ t, s ], [ n, f ] ] : r ? [ t, n ] : i && [ s, f ]);
}, a.clear = function() {
return u = null, o[0][0] = o[0][1] = o[1][0] = o[1][1] = 0, a;
}, a.empty = function() {
return r && o[0][0] === o[1][0] || i && o[0][1] === o[1][1];
}, e.rebind(a, t, "on");
};
var Lu = {
n: "ns-resize",
e: "ew-resize",
s: "ns-resize",
w: "ew-resize",
nw: "nwse-resize",
ne: "nesw-resize",
se: "nwse-resize",
sw: "nesw-resize"
}, Au = [ [ "n", "e", "s", "w", "nw", "ne", "se", "sw" ], [ "e", "w" ], [ "n", "s" ], [] ];
e.time = {};
var Ou = Date, Mu = [ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ];
_u.prototype = {
getDate: function() {
return this._.getUTCDate();
},
getDay: function() {
return this._.getUTCDay();
},
getFullYear: function() {
return this._.getUTCFullYear();
},
getHours: function() {
return this._.getUTCHours();
},
getMilliseconds: function() {
return this._.getUTCMilliseconds();
},
getMinutes: function() {
return this._.getUTCMinutes();
},
getMonth: function() {
return this._.getUTCMonth();
},
getSeconds: function() {
return this._.getUTCSeconds();
},
getTime: function() {
return this._.getTime();
},
getTimezoneOffset: function() {
return 0;
},
valueOf: function() {
return this._.valueOf();
},
setDate: function() {
Du.setUTCDate.apply(this._, arguments);
},
setDay: function() {
Du.setUTCDay.apply(this._, arguments);
},
setFullYear: function() {
Du.setUTCFullYear.apply(this._, arguments);
},
setHours: function() {
Du.setUTCHours.apply(this._, arguments);
},
setMilliseconds: function() {
Du.setUTCMilliseconds.apply(this._, arguments);
},
setMinutes: function() {
Du.setUTCMinutes.apply(this._, arguments);
},
setMonth: function() {
Du.setUTCMonth.apply(this._, arguments);
},
setSeconds: function() {
Du.setUTCSeconds.apply(this._, arguments);
},
setTime: function() {
Du.setTime.apply(this._, arguments);
}
};
var Du = Date.prototype, Pu = "%a %b %e %X %Y", Hu = "%m/%d/%Y", Bu = "%H:%M:%S", ju = [ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ], Fu = [ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" ], Iu = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ], qu = [ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" ];
e.time.year = Ru(function(t) {
return t = e.time.day(t), t.setMonth(0, 1), t;
}, function(e, t) {
e.setFullYear(e.getFullYear() + t);
}, function(e) {
return e.getFullYear();
}), e.time.years = e.time.year.range, e.time.years.utc = e.time.year.utc.range, e.time.day = Ru(function(e) {
var t = new Ou(1970, 0);
return t.setFullYear(e.getFullYear(), e.getMonth(), e.getDate()), t;
}, function(e, t) {
e.setDate(e.getDate() + t);
}, function(e) {
return e.getDate() - 1;
}), e.time.days = e.time.day.range, e.time.days.utc = e.time.day.utc.range, e.time.dayOfYear = function(t) {
var n = e.time.year(t);
return Math.floor((t - n - (t.getTimezoneOffset() - n.getTimezoneOffset()) * 6e4) / 864e5);
}, Mu.forEach(function(t, n) {
t = t.toLowerCase(), n = 7 - n;
var r = e.time[t] = Ru(function(t) {
return (t = e.time.day(t)).setDate(t.getDate() - (t.getDay() + n) % 7), t;
}, function(e, t) {
e.setDate(e.getDate() + Math.floor(t) * 7);
}, function(t) {
var r = e.time.year(t).getDay();
return Math.floor((e.time.dayOfYear(t) + (r + n) % 7) / 7) - (r !== n);
});
e.time[t + "s"] = r.range, e.time[t + "s"].utc = r.utc.range, e.time[t + "OfYear"] = function(t) {
var r = e.time.year(t).getDay();
return Math.floor((e.time.dayOfYear(t) + (r + n) % 7) / 7);
};
}), e.time.week = e.time.sunday, e.time.weeks = e.time.sunday.range, e.time.weeks.utc = e.time.sunday.utc.range, e.time.weekOfYear = e.time.sundayOfYear, e.time.format = function(e) {
function n(n) {
var r = [], i = -1, s = 0, o, u, a;
while (++i < t) if (e.charCodeAt(i) === 37) {
r.push(e.substring(s, i)), (u = Zu[o = e.charAt(++i)]) != null && (o = e.charAt(++i));
if (a = ea[o]) o = a(n, u == null ? o === "e" ? " " : "0" : u);
r.push(o), s = i + 1;
}
return r.push(e.substring(s, i)), r.join("");
}
var t = e.length;
return n.parse = function(t) {
var n = {
y: 1900,
m: 0,
d: 1,
H: 0,
M: 0,
S: 0,
L: 0
}, r = zu(n, e, t, 0);
if (r != t.length) return null;
"p" in n && (n.H = n.H % 12 + n.p * 12);
var i = new Ou;
return i.setFullYear(n.y, n.m, n.d), i.setHours(n.H, n.M, n.S, n.L), i;
}, n.toString = function() {
return e;
}, n;
};
var $u = Wu(ju), Ju = Wu(Fu), Ku = Wu(Iu), Qu = Xu(Iu), Gu = Wu(qu), Yu = Xu(qu), Zu = {
"-": "",
_: " ",
"0": "0"
}, ea = {
a: function(e) {
return Fu[e.getDay()];
},
A: function(e) {
return ju[e.getDay()];
},
b: function(e) {
return qu[e.getMonth()];
},
B: function(e) {
return Iu[e.getMonth()];
},
c: e.time.format(Pu),
d: function(e, t) {
return Vu(e.getDate(), t, 2);
},
e: function(e, t) {
return Vu(e.getDate(), t, 2);
},
H: function(e, t) {
return Vu(e.getHours(), t, 2);
},
I: function(e, t) {
return Vu(e.getHours() % 12 || 12, t, 2);
},
j: function(t, n) {
return Vu(1 + e.time.dayOfYear(t), n, 3);
},
L: function(e, t) {
return Vu(e.getMilliseconds(), t, 3);
},
m: function(e, t) {
return Vu(e.getMonth() + 1, t, 2);
},
M: function(e, t) {
return Vu(e.getMinutes(), t, 2);
},
p: function(e) {
return e.getHours() >= 12 ? "PM" : "AM";
},
S: function(e, t) {
return Vu(e.getSeconds(), t, 2);
},
U: function(t, n) {
return Vu(e.time.sundayOfYear(t), n, 2);
},
w: function(e) {
return e.getDay();
},
W: function(t, n) {
return Vu(e.time.mondayOfYear(t), n, 2);
},
x: e.time.format(Hu),
X: e.time.format(Bu),
y: function(e, t) {
return Vu(e.getFullYear() % 100, t, 2);
},
Y: function(e, t) {
return Vu(e.getFullYear() % 1e4, t, 4);
},
Z: Ea,
"%": function() {
return "%";
}
}, ta = {
a: na,
A: ra,
b: ia,
B: sa,
c: oa,
d: pa,
e: pa,
H: da,
I: da,
L: ga,
m: ha,
M: va,
p: ba,
S: ma,
x: ua,
X: aa,
y: la,
Y: fa
}, ya = /^\s*\d+/, wa = e.map({
am: 0,
pm: 1
});
e.time.format.utc = function(t) {
function r(e) {
try {
Ou = _u;
var t = new Ou;
return t._ = e, n(t);
} finally {
Ou = Date;
}
}
var n = e.time.format(t);
return r.parse = function(e) {
try {
Ou = _u;
var t = n.parse(e);
return t && t._;
} finally {
Ou = Date;
}
}, r.toString = n.toString, r;
};
var Sa = e.time.format.utc("%Y-%m-%dT%H:%M:%S.%LZ");
e.time.format.iso = Date.prototype.toISOString && +(new Date("2000-01-01T00:00:00.000Z")) ? xa : Sa, xa.parse = function(e) {
var t = new Date(e);
return isNaN(t) ? null : t;
}, xa.toString = Sa.toString, e.time.second = Ru(function(e) {
return new Ou(Math.floor(e / 1e3) * 1e3);
}, function(e, t) {
e.setTime(e.getTime() + Math.floor(t) * 1e3);
}, function(e) {
return e.getSeconds();
}), e.time.seconds = e.time.second.range, e.time.seconds.utc = e.time.second.utc.range, e.time.minute = Ru(function(e) {
return new Ou(Math.floor(e / 6e4) * 6e4);
}, function(e, t) {
e.setTime(e.getTime() + Math.floor(t) * 6e4);
}, function(e) {
return e.getMinutes();
}), e.time.minutes = e.time.minute.range, e.time.minutes.utc = e.time.minute.utc.range, e.time.hour = Ru(function(e) {
var t = e.getTimezoneOffset() / 60;
return new Ou((Math.floor(e / 36e5 - t) + t) * 36e5);
}, function(e, t) {
e.setTime(e.getTime() + Math.floor(t) * 36e5);
}, function(e) {
return e.getHours();
}), e.time.hours = e.time.hour.range, e.time.hours.utc = e.time.hour.utc.range, e.time.month = Ru(function(t) {
return t = e.time.day(t), t.setDate(1), t;
}, function(e, t) {
e.setMonth(e.getMonth() + t);
}, function(e) {
return e.getMonth();
}), e.time.months = e.time.month.range, e.time.months.utc = e.time.month.utc.range;
var Oa = [ 1e3, 5e3, 15e3, 3e4, 6e4, 3e5, 9e5, 18e5, 36e5, 108e5, 216e5, 432e5, 864e5, 1728e5, 6048e5, 2592e6, 7776e6, 31536e6 ], Ma = [ [ e.time.second, 1 ], [ e.time.second, 5 ], [ e.time.second, 15 ], [ e.time.second, 30 ], [ e.time.minute, 1 ], [ e.time.minute, 5 ], [ e.time.minute, 15 ], [ e.time.minute, 30 ], [ e.time.hour, 1 ], [ e.time.hour, 3 ], [ e.time.hour, 6 ], [ e.time.hour, 12 ], [ e.time.day, 1 ], [ e.time.day, 2 ], [ e.time.week, 1 ], [ e.time.month, 1 ], [ e.time.month, 3 ], [ e.time.year, 1 ] ], _a = [ [ e.time.format("%Y"), $n ], [ e.time.format("%B"), function(e) {
return e.getMonth();
} ], [ e.time.format("%b %d"), function(e) {
return e.getDate() != 1;
} ], [ e.time.format("%a %d"), function(e) {
return e.getDay() && e.getDate() != 1;
} ], [ e.time.format("%I %p"), function(e) {
return e.getHours();
} ], [ e.time.format("%I:%M"), function(e) {
return e.getMinutes();
} ], [ e.time.format(":%S"), function(e) {
return e.getSeconds();
} ], [ e.time.format(".%L"), function(e) {
return e.getMilliseconds();
} ] ], Da = e.scale.linear(), Pa = ka(_a);
Ma.year = function(e, t) {
return Da.domain(e.map(Aa)).ticks(t).map(La);
}, e.time.scale = function() {
return Ta(e.scale.linear(), Ma, Pa);
};
var Ha = Ma.map(function(e) {
return [ e[0].utc, e[1] ];
}), Ba = [ [ e.time.format.utc("%Y"), $n ], [ e.time.format.utc("%B"), function(e) {
return e.getUTCMonth();
} ], [ e.time.format.utc("%b %d"), function(e) {
return e.getUTCDate() != 1;
} ], [ e.time.format.utc("%a %d"), function(e) {
return e.getUTCDay() && e.getUTCDate() != 1;
} ], [ e.time.format.utc("%I %p"), function(e) {
return e.getUTCHours();
} ], [ e.time.format.utc("%I:%M"), function(e) {
return e.getUTCMinutes();
} ], [ e.time.format.utc(":%S"), function(e) {
return e.getUTCSeconds();
} ], [ e.time.format.utc(".%L"), function(e) {
return e.getUTCMilliseconds();
} ] ], ja = ka(Ba);
return Ha.year = function(e, t) {
return Da.domain(e.map(Ia)).ticks(t).map(Fa);
}, e.time.scale.utc = function() {
return Ta(e.scale.linear(), Ha, ja);
}, e.text = function() {
return e.xhr.apply(e, arguments).response(qa);
}, e.json = function(t, n) {
return e.xhr(t, "application/json", n).response(Ra);
}, e.html = function(t, n) {
return e.xhr(t, "text/html", n).response(Ua);
}, e.xml = function() {
return e.xhr.apply(e, arguments).response(za);
}, e;
}();

// nvd3/nv.d3.min.js

(function() {
function e(e, t) {
return (new Date(t, e + 1, 0)).getDate();
}
function t(e, t, n) {
return function(r, i, s) {
var o = e(r), u = [];
o < r && t(o);
if (s > 1) while (o < i) {
var a = new Date(+o);
n(a) % s === 0 && u.push(a), t(o);
} else while (o < i) u.push(new Date(+o)), t(o);
return u;
};
}
var n = window.nv || {};
n.version = "0.0.1a", n.dev = !0, window.nv = n, n.tooltip = {}, n.utils = {}, n.models = {}, n.charts = {}, n.graphs = [], n.logs = {}, n.dispatch = d3.dispatch("render_start", "render_end"), n.dev && (n.dispatch.on("render_start", function(e) {
n.logs.startTime = +(new Date);
}), n.dispatch.on("render_end", function(e) {
n.logs.endTime = +(new Date), n.logs.totalTime = n.logs.endTime - n.logs.startTime, n.log("total", n.logs.totalTime);
})), n.log = function() {
if (n.dev && console.log && console.log.apply) console.log.apply(console, arguments); else if (n.dev && console.log && Function.prototype.bind) {
var e = Function.prototype.bind.call(console.log, console);
e.apply(console, arguments);
}
return arguments[arguments.length - 1];
}, n.render = function(e) {
e = e || 1, n.render.active = !0, n.dispatch.render_start(), setTimeout(function() {
var t, r;
for (var i = 0; i < e && (r = n.render.queue[i]); i++) t = r.generate(), typeof r.callback == typeof Function && r.callback(t), n.graphs.push(t);
n.render.queue.splice(0, i), n.render.queue.length ? setTimeout(arguments.callee, 0) : (n.render.active = !1, n.dispatch.render_end());
}, 0);
}, n.render.active = !1, n.render.queue = [], n.addGraph = function(e) {
typeof arguments[0] == typeof Function && (e = {
generate: arguments[0],
callback: arguments[1]
}), n.render.queue.push(e), n.render.active || n.render();
}, n.identity = function(e) {
return e;
}, n.strip = function(e) {
return e.replace(/(\s|&)/g, "");
}, d3.time.monthEnd = function(e) {
return new Date(e.getFullYear(), e.getMonth(), 0);
}, d3.time.monthEnds = t(d3.time.monthEnd, function(t) {
t.setUTCDate(t.getUTCDate() + 1), t.setDate(e(t.getMonth() + 1, t.getFullYear()));
}, function(e) {
return e.getMonth();
}), function() {
var e = window.nv.tooltip = {};
e.show = function(e, t, r, i, s, o) {
var u = document.createElement("div");
u.className = "nvtooltip " + (o ? o : "xy-tooltip"), r = r || "s", i = i || 20;
var a = s;
if (!s || s.tagName.match(/g|svg/i)) a = document.getElementsByTagName("body")[0];
u.innerHTML = t, u.style.left = 0, u.style.top = 0, u.style.opacity = 0, a.appendChild(u);
var f = parseInt(u.offsetHeight), l = parseInt(u.offsetWidth), c = n.utils.windowSize().width, h = n.utils.windowSize().height, p = window.scrollY, d = window.scrollX, v, m;
h = window.innerWidth >= document.body.scrollWidth ? h : h - 16, c = window.innerHeight >= document.body.scrollHeight ? c : c - 16;
var g = function(e) {
var t = m;
do isNaN(e.offsetTop) || (t += e.offsetTop); while (e = e.offsetParent);
return t;
}, y = function(e) {
var t = v;
do isNaN(e.offsetLeft) || (t += e.offsetLeft); while (e = e.offsetParent);
return t;
};
switch (r) {
case "e":
v = e[0] - l - i, m = e[1] - f / 2;
var b = y(u), w = g(u);
b < d && (v = e[0] + i > d ? e[0] + i : d - b + v), w < p && (m = p - w + m), w + f > p + h && (m = p + h - w + m - f);
break;
case "w":
v = e[0] + i, m = e[1] - f / 2, b + l > c && (v = e[0] - l - i), w < p && (m = p + 5), w + f > p + h && (m = p - f - 5);
break;
case "n":
v = e[0] - l / 2 - 5, m = e[1] + i;
var b = y(u), w = g(u);
b < d && (v = d + 5), b + l > c && (v = v - l / 2 + 5), w + f > p + h && (m = p + h - w + m - f);
break;
case "s":
v = e[0] - l / 2, m = e[1] - f - i;
var b = y(u), w = g(u);
b < d && (v = d + 5), b + l > c && (v = v - l / 2 + 5), p > w && (m = p);
}
return u.style.left = v + "px", u.style.top = m + "px", u.style.opacity = 1, u.style.position = "absolute", u.style.pointerEvents = "none", u;
}, e.cleanup = function() {
var e = document.getElementsByClassName("nvtooltip"), t = [];
while (e.length) t.push(e[0]), e[0].style.transitionDelay = "0 !important", e[0].style.opacity = 0, e[0].className = "nvtooltip-pending-removal";
setTimeout(function() {
while (t.length) {
var e = t.pop();
e.parentNode.removeChild(e);
}
}, 500);
};
}(), n.utils.windowSize = function() {
var e = {
width: 640,
height: 480
};
return document.body && document.body.offsetWidth && (e.width = document.body.offsetWidth, e.height = document.body.offsetHeight), document.compatMode == "CSS1Compat" && document.documentElement && document.documentElement.offsetWidth && (e.width = document.documentElement.offsetWidth, e.height = document.documentElement.offsetHeight), window.innerWidth && window.innerHeight && (e.width = window.innerWidth, e.height = window.innerHeight), e;
}, n.utils.windowResize = function(e) {
var t = window.onresize;
window.onresize = function(n) {
typeof t == "function" && t(n), e(n);
};
}, n.utils.getColor = function(e) {
return arguments.length ? Object.prototype.toString.call(e) === "[object Array]" ? function(t, n) {
return t.color || e[n % e.length];
} : e : n.utils.defaultColor();
}, n.utils.defaultColor = function() {
var e = d3.scale.category20().range();
return function(t, n) {
return t.color || e[n % e.length];
};
}, n.utils.customTheme = function(e, t, n) {
t = t || function(e) {
return e.key;
}, n = n || d3.scale.category20().range();
var r = n.length;
return function(i, s) {
var o = t(i);
return r || (r = n.length), typeof e[o] != "undefined" ? typeof e[o] == "function" ? e[o]() : e[o] : n[--r];
};
}, n.utils.pjax = function(e, t) {
function r(r) {
d3.html(r, function(r) {
var i = d3.select(t).node();
i.parentNode.replaceChild(d3.select(r).select(t).node(), i), n.utils.pjax(e, t);
});
}
d3.selectAll(e).on("click", function() {
history.pushState(this.href, this.textContent, this.href), r(this.href), d3.event.preventDefault();
}), d3.select(window).on("popstate", function() {
d3.event.state && r(d3.event.state);
});
}, n.utils.calcApproxTextWidth = function(e) {
if (e instanceof d3.selection) {
var t = parseInt(e.style("font-size").replace("px", "")), n = e.text().length;
return n * t * .5;
}
return 0;
}, n.models.axis = function() {
function e(i) {
return i.each(function(e) {
var i = d3.select(this), v = i.selectAll("g.nv-wrap.nv-axis").data([ e ]), m = v.enter().append("g").attr("class", "nvd3 nv-wrap nv-axis"), g = m.append("g"), y = v.select("g");
p !== null ? t.ticks(p) : (t.orient() == "top" || t.orient() == "bottom") && t.ticks(Math.abs(s.range()[1] - s.range()[0]) / 100), d3.transition(y).call(t), d = d || t.scale();
var b = t.tickFormat();
b == null && (b = d.tickFormat());
var w = y.selectAll("text.nv-axislabel").data([ o || null ]);
w.exit().remove();
switch (t.orient()) {
case "top":
w.enter().append("text").attr("class", "nv-axislabel");
var E = s.range().length == 2 ? s.range()[1] : s.range()[s.range().length - 1] + (s.range()[1] - s.range()[0]);
w.attr("text-anchor", "middle").attr("y", 0).attr("x", E / 2);
if (u) {
var S = v.selectAll("g.nv-axisMaxMin").data(s.domain());
S.enter().append("g").attr("class", "nv-axisMaxMin").append("text"), S.exit().remove(), S.attr("transform", function(e, t) {
return "translate(" + s(e) + ",0)";
}).select("text").attr("dy", "0em").attr("y", -t.tickPadding()).attr("text-anchor", "middle").text(function(e, t) {
var n = b(e);
return ("" + n).match("NaN") ? "" : n;
}), d3.transition(S).attr("transform", function(e, t) {
return "translate(" + s.range()[t] + ",0)";
});
}
break;
case "bottom":
var x = 36, T = 30, N = y.selectAll("g").select("text");
if (f % 360) {
N.each(function(e, t) {
var n = this.getBBox().width;
n > T && (T = n);
});
var C = Math.abs(Math.sin(f * Math.PI / 180)), x = (C ? C * T : T) + 30;
N.attr("transform", function(e, t, n) {
return "rotate(" + f + " 0,0)";
}).attr("text-anchor", f % 360 > 0 ? "start" : "end");
}
w.enter().append("text").attr("class", "nv-axislabel");
var E = s.range().length == 2 ? s.range()[1] : s.range()[s.range().length - 1] + (s.range()[1] - s.range()[0]);
w.attr("text-anchor", "middle").attr("y", x).attr("x", E / 2);
if (u) {
var S = v.selectAll("g.nv-axisMaxMin").data([ s.domain()[0], s.domain()[s.domain().length - 1] ]);
S.enter().append("g").attr("class", "nv-axisMaxMin").append("text"), S.exit().remove(), S.attr("transform", function(e, t) {
return "translate(" + (s(e) + (h ? s.rangeBand() / 2 : 0)) + ",0)";
}).select("text").attr("dy", ".71em").attr("y", t.tickPadding()).attr("transform", function(e, t, n) {
return "rotate(" + f + " 0,0)";
}).attr("text-anchor", f ? f % 360 > 0 ? "start" : "end" : "middle").text(function(e, t) {
var n = b(e);
return ("" + n).match("NaN") ? "" : n;
}), d3.transition(S).attr("transform", function(e, t) {
return "translate(" + (s(e) + (h ? s.rangeBand() / 2 : 0)) + ",0)";
});
}
c && N.attr("transform", function(e, t) {
return "translate(0," + (t % 2 == 0 ? "0" : "12") + ")";
});
break;
case "right":
w.enter().append("text").attr("class", "nv-axislabel"), w.attr("text-anchor", l ? "middle" : "begin").attr("transform", l ? "rotate(90)" : "").attr("y", l ? -Math.max(n.right, r) + 12 : -10).attr("x", l ? s.range()[0] / 2 : t.tickPadding());
if (u) {
var S = v.selectAll("g.nv-axisMaxMin").data(s.domain());
S.enter().append("g").attr("class", "nv-axisMaxMin").append("text").style("opacity", 0), S.exit().remove(), S.attr("transform", function(e, t) {
return "translate(0," + s(e) + ")";
}).select("text").attr("dy", ".32em").attr("y", 0).attr("x", t.tickPadding()).attr("text-anchor", "start").text(function(e, t) {
var n = b(e);
return ("" + n).match("NaN") ? "" : n;
}), d3.transition(S).attr("transform", function(e, t) {
return "translate(0," + s.range()[t] + ")";
}).select("text").style("opacity", 1);
}
break;
case "left":
w.enter().append("text").attr("class", "nv-axislabel"), w.attr("text-anchor", l ? "middle" : "end").attr("transform", l ? "rotate(-90)" : "").attr("y", l ? -Math.max(n.left, r) + 12 : -10).attr("x", l ? -s.range()[0] / 2 : -t.tickPadding());
if (u) {
var S = v.selectAll("g.nv-axisMaxMin").data(s.domain());
S.enter().append("g").attr("class", "nv-axisMaxMin").append("text").style("opacity", 0), S.exit().remove(), S.attr("transform", function(e, t) {
return "translate(0," + d(e) + ")";
}).select("text").attr("dy", ".32em").attr("y", 0).attr("x", -t.tickPadding()).attr("text-anchor", "end").text(function(e, t) {
var n = b(e);
return ("" + n).match("NaN") ? "" : n;
}), d3.transition(S).attr("transform", function(e, t) {
return "translate(0," + s.range()[t] + ")";
}).select("text").style("opacity", 1);
}
}
w.text(function(e) {
return e;
}), u && (t.orient() === "left" || t.orient() === "right") && (y.selectAll("g").each(function(e, t) {
d3.select(this).select("text").attr("opacity", 1);
if (s(e) < s.range()[1] + 10 || s(e) > s.range()[0] - 10) (e > 1e-10 || e < -1e-10) && d3.select(this).attr("opacity", 0), d3.select(this).select("text").attr("opacity", 0);
}), s.domain()[0] == s.domain()[1] && s.domain()[0] == 0 && v.selectAll("g.nv-axisMaxMin").style("opacity", function(e, t) {
return t ? 0 : 1;
}));
if (u && (t.orient() === "top" || t.orient() === "bottom")) {
var k = [];
v.selectAll("g.nv-axisMaxMin").each(function(e, t) {
try {
t ? k.push(s(e) - this.getBBox().width - 4) : k.push(s(e) + this.getBBox().width + 4);
} catch (n) {
t ? k.push(s(e) - 4) : k.push(s(e) + 4);
}
}), y.selectAll("g").each(function(e, t) {
if (s(e) < k[0] || s(e) > k[1]) e > 1e-10 || e < -1e-10 ? d3.select(this).remove() : d3.select(this).select("text").remove();
});
}
a && y.selectAll(".tick").filter(function(e) {
return !parseFloat(Math.round(e.__data__ * 1e5) / 1e6) && e.__data__ !== undefined;
}).classed("zero", !0), d = s.copy();
}), e;
}
var t = d3.svg.axis(), n = {
top: 0,
right: 0,
bottom: 0,
left: 0
}, r = 75, i = 60, s = d3.scale.linear(), o = null, u = !0, a = !0, f = 0, l = !0, c = !1, h = !1, p = null;
t.scale(s).orient("bottom").tickFormat(function(e) {
return e;
});
var d;
return e.axis = t, d3.rebind(e, t, "orient", "tickValues", "tickSubdivide", "tickSize", "tickPadding", "tickFormat"), d3.rebind(e, s, "domain", "range", "rangeBand", "rangeBands"), e.margin = function(t) {
return arguments.length ? (n.top = typeof t.top != "undefined" ? t.top : n.top, n.right = typeof t.right != "undefined" ? t.right : n.right, n.bottom = typeof t.bottom != "undefined" ? t.bottom : n.bottom, n.left = typeof t.left != "undefined" ? t.left : n.left, e) : n;
}, e.width = function(t) {
return arguments.length ? (r = t, e) : r;
}, e.ticks = function(t) {
return arguments.length ? (p = t, e) : p;
}, e.height = function(t) {
return arguments.length ? (i = t, e) : i;
}, e.axisLabel = function(t) {
return arguments.length ? (o = t, e) : o;
}, e.showMaxMin = function(t) {
return arguments.length ? (u = t, e) : u;
}, e.highlightZero = function(t) {
return arguments.length ? (a = t, e) : a;
}, e.scale = function(n) {
return arguments.length ? (s = n, t.scale(s), h = typeof s.rangeBands == "function", d3.rebind(e, s, "domain", "range", "rangeBand", "rangeBands"), e) : s;
}, e.rotateYLabel = function(t) {
return arguments.length ? (l = t, e) : l;
}, e.rotateLabels = function(t) {
return arguments.length ? (f = t, e) : f;
}, e.staggerLabels = function(t) {
return arguments.length ? (c = t, e) : c;
}, e;
}, n.models.bullet = function() {
function e(n) {
return n.each(function(e, n) {
var r = f - t.left - t.right, c = l - t.top - t.bottom, d = d3.select(this), v = s.call(this, e, n).slice().sort(d3.descending), m = o.call(this, e, n).slice().sort(d3.descending), g = u.call(this, e, n).slice().sort(d3.descending), y = d3.scale.linear().domain(d3.extent(d3.merge([ a, v ]))).range(i ? [ r, 0 ] : [ 0, r ]), b = this.__chart__ || d3.scale.linear().domain([ 0, Infinity ]).range(y.range());
this.__chart__ = y;
var w = d3.min(v), E = d3.max(v), S = v[1], x = d.selectAll("g.nv-wrap.nv-bullet").data([ e ]), T = x.enter().append("g").attr("class", "nvd3 nv-wrap nv-bullet"), N = T.append("g"), C = x.select("g");
N.append("rect").attr("class", "nv-range nv-rangeMax"), N.append("rect").attr("class", "nv-range nv-rangeAvg"), N.append("rect").attr("class", "nv-range nv-rangeMin"), N.append("rect").attr("class", "nv-measure"), N.append("path").attr("class", "nv-markerTriangle"), x.attr("transform", "translate(" + t.left + "," + t.top + ")");
var k = function(e) {
return Math.abs(b(e) - b(0));
}, L = function(e) {
return Math.abs(y(e) - y(0));
}, A = function(e) {
return e < 0 ? b(e) : b(0);
}, O = function(e) {
return e < 0 ? y(e) : y(0);
};
C.select("rect.nv-rangeMax").attr("height", c).attr("width", L(E > 0 ? E : w)).attr("x", O(E > 0 ? E : w)).datum(E > 0 ? E : w), C.select("rect.nv-rangeAvg").attr("height", c).attr("width", L(S)).attr("x", O(S)).datum(S), C.select("rect.nv-rangeMin").attr("height", c).attr("width", L(E)).attr("x", O(E)).attr("width", L(E > 0 ? w : E)).attr("x", O(E > 0 ? w : E)).datum(E > 0 ? w : E), C.select("rect.nv-measure").style("fill", h).attr("height", c / 3).attr("y", c / 3).attr("width", g < 0 ? y(0) - y(g[0]) : y(g[0]) - y(0)).attr("x", O(g)).on("mouseover", function() {
p.elementMouseover({
value: g[0],
label: "Current",
pos: [ y(g[0]), c / 2 ]
});
}).on("mouseout", function() {
p.elementMouseout({
value: g[0],
label: "Current"
});
});
var M = c / 6;
m[0] ? C.selectAll("path.nv-markerTriangle").attr("transform", function(e) {
return "translate(" + y(m[0]) + "," + c / 2 + ")";
}).attr("d", "M0," + M + "L" + M + "," + -M + " " + -M + "," + -M + "Z").on("mouseover", function() {
p.elementMouseover({
value: m[0],
label: "Previous",
pos: [ y(m[0]), c / 2 ]
});
}).on("mouseout", function() {
p.elementMouseout({
value: m[0],
label: "Previous"
});
}) : C.selectAll("path.nv-markerTriangle").remove(), x.selectAll(".nv-range").on("mouseover", function(e, t) {
var n = t ? t == 1 ? "Mean" : "Minimum" : "Maximum";
p.elementMouseover({
value: e,
label: n,
pos: [ y(e), c / 2 ]
});
}).on("mouseout", function(e, t) {
var n = t ? t == 1 ? "Mean" : "Minimum" : "Maximum";
p.elementMouseout({
value: e,
label: n
});
});
}), e;
}
var t = {
top: 0,
right: 0,
bottom: 0,
left: 0
}, r = "left", i = !1, s = function(e) {
return e.ranges;
}, o = function(e) {
return e.markers;
}, u = function(e) {
return e.measures;
}, a = [ 0 ], f = 380, l = 30, c = null, h = n.utils.getColor([ "#1f77b4" ]), p = d3.dispatch("elementMouseover", "elementMouseout");
return e.dispatch = p, e.orient = function(t) {
return arguments.length ? (r = t, i = r == "right" || r == "bottom", e) : r;
}, e.ranges = function(t) {
return arguments.length ? (s = t, e) : s;
}, e.markers = function(t) {
return arguments.length ? (o = t, e) : o;
}, e.measures = function(t) {
return arguments.length ? (u = t, e) : u;
}, e.forceX = function(t) {
return arguments.length ? (a = t, e) : a;
}, e.width = function(t) {
return arguments.length ? (f = t, e) : f;
}, e.height = function(t) {
return arguments.length ? (l = t, e) : l;
}, e.margin = function(n) {
return arguments.length ? (t.top = typeof n.top != "undefined" ? n.top : t.top, t.right = typeof n.right != "undefined" ? n.right : t.right, t.bottom = typeof n.bottom != "undefined" ? n.bottom : t.bottom, t.left = typeof n.left != "undefined" ? n.left : t.left, e) : t;
}, e.tickFormat = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.color = function(t) {
return arguments.length ? (h = n.utils.getColor(t), e) : h;
}, e;
}, n.models.bulletChart = function() {
function e(n) {
return n.each(function(r, p) {
var g = d3.select(this), y = (f || parseInt(g.style("width")) || 960) - s.left - s.right, b = l - s.top - s.bottom, w = this;
e.update = function() {
e(n);
}, e.container = this;
if (!r || !o.call(this, r, p)) {
var E = g.selectAll(".nv-noData").data([ d ]);
return E.enter().append("text").attr("class", "nvd3 nv-noData").attr("dy", "-.7em").style("text-anchor", "middle"), E.attr("x", s.left + y / 2).attr("y", 18 + s.top + b / 2).text(function(e) {
return e;
}), e;
}
g.selectAll(".nv-noData").remove();
var S = o.call(this, r, p).slice().sort(d3.descending), x = u.call(this, r, p).slice().sort(d3.descending), T = a.call(this, r, p).slice().sort(d3.descending), N = g.selectAll("g.nv-wrap.nv-bulletChart").data([ r ]), C = N.enter().append("g").attr("class", "nvd3 nv-wrap nv-bulletChart"), k = C.append("g"), L = N.select("g");
k.append("g").attr("class", "nv-bulletWrap"), k.append("g").attr("class", "nv-titles"), N.attr("transform", "translate(" + s.left + "," + s.top + ")");
var A = d3.scale.linear().domain([ 0, Math.max(S[0], x[0], T[0]) ]).range(i ? [ y, 0 ] : [ 0, y ]), O = this.__chart__ || d3.scale.linear().domain([ 0, Infinity ]).range(A.range());
this.__chart__ = A;
var M = function(e) {
return Math.abs(O(e) - O(0));
}, _ = function(e) {
return Math.abs(A(e) - A(0));
}, D = k.select(".nv-titles").append("g").attr("text-anchor", "end").attr("transform", "translate(-6," + (l - s.top - s.bottom) / 2 + ")");
D.append("text").attr("class", "nv-title").text(function(e) {
return e.title;
}), D.append("text").attr("class", "nv-subtitle").attr("dy", "1em").text(function(e) {
return e.subtitle;
}), t.width(y).height(b);
var P = L.select(".nv-bulletWrap");
d3.transition(P).call(t);
var H = c || A.tickFormat(y / 100), B = L.selectAll("g.nv-tick").data(A.ticks(y / 50), function(e) {
return this.textContent || H(e);
}), j = B.enter().append("g").attr("class", "nv-tick").attr("transform", function(e) {
return "translate(" + O(e) + ",0)";
}).style("opacity", 1e-6);
j.append("line").attr("y1", b).attr("y2", b * 7 / 6), j.append("text").attr("text-anchor", "middle").attr("dy", "1em").attr("y", b * 7 / 6).text(H);
var F = d3.transition(B).attr("transform", function(e) {
return "translate(" + A(e) + ",0)";
}).style("opacity", 1);
F.select("line").attr("y1", b).attr("y2", b * 7 / 6), F.select("text").attr("y", b * 7 / 6), d3.transition(B.exit()).attr("transform", function(e) {
return "translate(" + A(e) + ",0)";
}).style("opacity", 1e-6).remove(), v.on("tooltipShow", function(e) {
e.key = r.title, h && m(e, w.parentNode);
});
}), d3.timer.flush(), e;
}
var t = n.models.bullet(), r = "left", i = !1, s = {
top: 5,
right: 40,
bottom: 20,
left: 120
}, o = function(e) {
return e.ranges;
}, u = function(e) {
return e.markers;
}, a = function(e) {
return e.measures;
}, f = null, l = 55, c = null, h = !0, p = function(e, t, n, r, i) {
return "<h3>" + t + "</h3>" + "<p>" + n + "</p>";
}, d = "No Data Available.", v = d3.dispatch("tooltipShow", "tooltipHide"), m = function(t, r) {
var i = t.pos[0] + (r.offsetLeft || 0) + s.left, o = t.pos[1] + (r.offsetTop || 0) + s.top, u = p(t.key, t.label, t.value, t, e);
n.tooltip.show([ i, o ], u, t.value < 0 ? "e" : "w", null, r);
};
return t.dispatch.on("elementMouseover.tooltip", function(e) {
v.tooltipShow(e);
}), t.dispatch.on("elementMouseout.tooltip", function(e) {
v.tooltipHide(e);
}), v.on("tooltipHide", function() {
h && n.tooltip.cleanup();
}), e.dispatch = v, e.bullet = t, d3.rebind(e, t, "color"), e.orient = function(t) {
return arguments.length ? (r = t, i = r == "right" || r == "bottom", e) : r;
}, e.ranges = function(t) {
return arguments.length ? (o = t, e) : o;
}, e.markers = function(t) {
return arguments.length ? (u = t, e) : u;
}, e.measures = function(t) {
return arguments.length ? (a = t, e) : a;
}, e.width = function(t) {
return arguments.length ? (f = t, e) : f;
}, e.height = function(t) {
return arguments.length ? (l = t, e) : l;
}, e.margin = function(t) {
return arguments.length ? (s.top = typeof t.top != "undefined" ? t.top : s.top, s.right = typeof t.right != "undefined" ? t.right : s.right, s.bottom = typeof t.bottom != "undefined" ? t.bottom : s.bottom, s.left = typeof t.left != "undefined" ? t.left : s.left, e) : s;
}, e.tickFormat = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.tooltips = function(t) {
return arguments.length ? (h = t, e) : h;
}, e.tooltipContent = function(t) {
return arguments.length ? (p = t, e) : p;
}, e.noData = function(t) {
return arguments.length ? (d = t, e) : d;
}, e;
}, n.models.cumulativeLineChart = function() {
function e(n) {
return n.each(function(n) {
function m(t, n) {
d3.select(e.container).style("cursor", "ew-resize");
}
function L(e, t) {
C.x = d3.event.x, C.i = Math.round(N.invert(C.x)), O();
}
function A(t, n) {
d3.select(e.container).style("cursor", "auto"), w.index = C.i, T.stateChange(w);
}
function O() {
J.data([ C ]), M.call(e);
}
var M = d3.select(this).classed("nv-chart-" + b, !0), _ = this, D = (l || parseInt(M.style("width")) || 960) - a.left - a.right, P = (c || parseInt(M.style("height")) || 400) - a.top - a.bottom;
e.update = function() {
M.transition().call(e);
}, e.container = this, w.disabled = n.map(function(e) {
return !!e.disabled;
});
if (!E) {
var H;
E = {};
for (H in w) w[H] instanceof Array ? E[H] = w[H].slice(0) : E[H] = w[H];
}
var B = d3.behavior.drag().on("dragstart", m).on("drag", L).on("dragend", A);
if (!n || !n.length || !n.filter(function(e) {
return e.values.length;
}).length) {
var j = M.selectAll(".nv-noData").data([ S ]);
return j.enter().append("text").attr("class", "nvd3 nv-noData").attr("dy", "-.7em").style("text-anchor", "middle"), j.attr("x", a.left + D / 2).attr("y", a.top + P / 2).text(function(e) {
return e;
}), e;
}
M.selectAll(".nv-noData").remove(), g = r.xScale(), y = r.yScale();
if (!v) {
var F = n.filter(function(e) {
return !e.disabled;
}).map(function(e, t) {
var n = d3.extent(e.values, r.y());
return n[0] < -0.95 && (n[0] = -0.95), [ (n[0] - n[1]) / (1 + n[1]), (n[1] - n[0]) / (1 + n[0]) ];
}), I = [ d3.min(F, function(e) {
return e[0];
}), d3.max(F, function(e) {
return e[1];
}) ];
r.yDomain(I);
} else r.yDomain(null);
N.domain([ 0, n[0].values.length - 1 ]).range([ 0, D ]).clamp(!0);
var n = t(C.i, n), q = M.selectAll("g.nv-wrap.nv-cumulativeLine").data([ n ]), R = q.enter().append("g").attr("class", "nvd3 nv-wrap nv-cumulativeLine").append("g"), U = q.select("g");
R.append("g").attr("class", "nv-x nv-axis"), R.append("g").attr("class", "nv-y nv-axis"), R.append("g").attr("class", "nv-background"), R.append("g").attr("class", "nv-linesWrap"), R.append("g").attr("class", "nv-avgLinesWrap"), R.append("g").attr("class", "nv-legendWrap"), R.append("g").attr("class", "nv-controlsWrap"), h && (o.width(D), U.select(".nv-legendWrap").datum(n).call(o), a.top != o.height() && (a.top = o.height(), P = (c || parseInt(M.style("height")) || 400) - a.top - a.bottom), U.select(".nv-legendWrap").attr("transform", "translate(0," + -a.top + ")"));
if (d) {
var z = [ {
key: "Re-scale y-axis",
disabled: !v
} ];
u.width(140).color([ "#444", "#444", "#444" ]), U.select(".nv-controlsWrap").datum(z).attr("transform", "translate(0," + -a.top + ")").call(u);
}
q.attr("transform", "translate(" + a.left + "," + a.top + ")");
var W = n.filter(function(e) {
return e.tempDisabled;
});
q.select(".tempDisabled").remove(), W.length && q.append("text").attr("class", "tempDisabled").attr("x", D / 2).attr("y", "-.71em").style("text-anchor", "end").text(W.map(function(e) {
return e.key;
}).join(", ") + " values cannot be calculated for this time period."), R.select(".nv-background").append("rect"), U.select(".nv-background rect").attr("width", D).attr("height", P), r.y(function(e) {
return e.display.y;
}).width(D).height(P).color(n.map(function(e, t) {
return e.color || f(e, t);
}).filter(function(e, t) {
return !n[t].disabled && !n[t].tempDisabled;
}));
var X = U.select(".nv-linesWrap").datum(n.filter(function(e) {
return !e.disabled && !e.tempDisabled;
}));
X.call(r), n.forEach(function(e, t) {
e.seriesIndex = t;
});
var V = n.filter(function(e) {
return !e.disabled && !!x(e);
}), $ = U.select(".nv-avgLinesWrap").selectAll("line").data(V, function(e) {
return e.key;
});
$.enter().append("line").style("stroke-width", 2).style("stroke-dasharray", "10,10").style("stroke", function(e, t) {
return r.color()(e, e.seriesIndex);
}).attr("x1", 0).attr("x2", D).attr("y1", function(e) {
return y(x(e));
}).attr("y2", function(e) {
return y(x(e));
}), $.attr("x1", 0).attr("x2", D).attr("y1", function(e) {
return y(x(e));
}).attr("y2", function(e) {
return y(x(e));
}), $.exit().remove();
var J = X.selectAll(".nv-indexLine").data([ C ]);
J.enter().append("rect").attr("class", "nv-indexLine").attr("width", 3).attr("x", -2).attr("fill", "red").attr("fill-opacity", .5).call(B), J.attr("transform", function(e) {
return "translate(" + N(e.i) + ",0)";
}).attr("height", P), i.scale(g).ticks(Math.min(n[0].values.length, D / 70)).tickSize(-P, 0), U.select(".nv-x.nv-axis").attr("transform", "translate(0," + y.range()[0] + ")"), d3.transition(U.select(".nv-x.nv-axis")).call(i), s.scale(y).ticks(P / 36).tickSize(-D, 0), d3.transition(U.select(".nv-y.nv-axis")).call(s), U.select(".nv-background rect").on("click", function() {
C.x = d3.mouse(this)[0], C.i = Math.round(N.invert(C.x)), w.index = C.i, T.stateChange(w), O();
}), r.dispatch.on("elementClick", function(e) {
C.i = e.pointIndex, C.x = N(C.i), w.index = C.i, T.stateChange(w), O();
}), u.dispatch.on("legendClick", function(t, n) {
t.disabled = !t.disabled, v = !t.disabled, w.rescaleY = v, T.stateChange(w), e.update();
}), o.dispatch.on("legendClick", function(t, r) {
t.disabled = !t.disabled, n.filter(function(e) {
return !e.disabled;
}).length || n.map(function(e) {
return e.disabled = !1, q.selectAll(".nv-series").classed("disabled", !1), e;
}), w.disabled = n.map(function(e) {
return !!e.disabled;
}), T.stateChange(w), e.update();
}), o.dispatch.on("legendDblclick", function(t) {
n.forEach(function(e) {
e.disabled = !0;
}), t.disabled = !1, w.disabled = n.map(function(e) {
return !!e.disabled;
}), T.stateChange(w), e.update();
}), T.on("tooltipShow", function(e) {
p && k(e, _.parentNode);
}), T.on("changeState", function(t) {
typeof t.disabled != "undefined" && (n.forEach(function(e, n) {
e.disabled = t.disabled[n];
}), w.disabled = t.disabled), typeof t.index != "undefined" && (C.i = t.index, C.x = N(C.i), w.index = t.index, J.data([ C ])), typeof t.rescaleY != "undefined" && (v = t.rescaleY), e.update();
});
}), e;
}
function t(e, t) {
return t.map(function(t, n) {
if (!t.values) return t;
var i = r.y()(t.values[e], e);
return i < -0.95 ? (t.tempDisabled = !0, t) : (t.tempDisabled = !1, t.values = t.values.map(function(e, t) {
return e.display = {
y: (r.y()(e, t) - i) / (1 + i)
}, e;
}), t);
});
}
var r = n.models.line(), i = n.models.axis(), s = n.models.axis(), o = n.models.legend(), u = n.models.legend(), a = {
top: 30,
right: 30,
bottom: 50,
left: 60
}, f = n.utils.defaultColor(), l = null, c = null, h = !0, p = !0, d = !0, v = !0, m = function(e, t, n, r, i) {
return "<h3>" + e + "</h3>" + "<p>" + n + " at " + t + "</p>";
}, g, y, b = r.id(), w = {
index: 0,
rescaleY: v
}, E = null, S = "No Data Available.", x = function(e) {
return e.average;
}, T = d3.dispatch("tooltipShow", "tooltipHide", "stateChange", "changeState");
i.orient("bottom").tickPadding(7), s.orient("left");
var N = d3.scale.linear(), C = {
i: 0,
x: 0
}, k = function(t, o) {
var u = t.pos[0] + (o.offsetLeft || 0), a = t.pos[1] + (o.offsetTop || 0), f = i.tickFormat()(r.x()(t.point, t.pointIndex)), l = s.tickFormat()(r.y()(t.point, t.pointIndex)), c = m(t.series.key, f, l, t, e);
n.tooltip.show([ u, a ], c, null, null, o);
};
return r.dispatch.on("elementMouseover.tooltip", function(e) {
e.pos = [ e.pos[0] + a.left, e.pos[1] + a.top ], T.tooltipShow(e);
}), r.dispatch.on("elementMouseout.tooltip", function(e) {
T.tooltipHide(e);
}), T.on("tooltipHide", function() {
p && n.tooltip.cleanup();
}), e.dispatch = T, e.lines = r, e.legend = o, e.xAxis = i, e.yAxis = s, d3.rebind(e, r, "defined", "isArea", "x", "y", "size", "xDomain", "yDomain", "forceX", "forceY", "interactive", "clipEdge", "clipVoronoi", "id"), e.margin = function(t) {
return arguments.length ? (a.top = typeof t.top != "undefined" ? t.top : a.top, a.right = typeof t.right != "undefined" ? t.right : a.right, a.bottom = typeof t.bottom != "undefined" ? t.bottom : a.bottom, a.left = typeof t.left != "undefined" ? t.left : a.left, e) : a;
}, e.width = function(t) {
return arguments.length ? (l = t, e) : l;
}, e.height = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.color = function(t) {
return arguments.length ? (f = n.utils.getColor(t), o.color(f), e) : f;
}, e.rescaleY = function(e) {
return arguments.length ? (v = e, v) : v;
}, e.showControls = function(t) {
return arguments.length ? (d = t, e) : d;
}, e.showLegend = function(t) {
return arguments.length ? (h = t, e) : h;
}, e.tooltips = function(t) {
return arguments.length ? (p = t, e) : p;
}, e.tooltipContent = function(t) {
return arguments.length ? (m = t, e) : m;
}, e.state = function(t) {
return arguments.length ? (w = t, e) : w;
}, e.defaultState = function(t) {
return arguments.length ? (E = t, e) : E;
}, e.noData = function(t) {
return arguments.length ? (S = t, e) : S;
}, e.average = function(t) {
return arguments.length ? (x = t, e) : x;
}, e;
}, n.models.discreteBar = function() {
function e(n) {
return n.each(function(e) {
var n = r - t.left - t.right, s = i - t.top - t.bottom, w = d3.select(this);
e = e.map(function(e, t) {
return e.values = e.values.map(function(e) {
return e.series = t, e;
}), e;
});
var E = d && v ? [] : e.map(function(e) {
return e.values.map(function(e, t) {
return {
x: a(e, t),
y: f(e, t),
y0: e.y0
};
});
});
o.domain(d || d3.merge(E).map(function(e) {
return e.x;
})).rangeBands([ 0, n ], .1), u.domain(v || d3.extent(d3.merge(E).map(function(e) {
return e.y;
}).concat(l))), h ? u.range([ s - (u.domain()[0] < 0 ? 12 : 0), u.domain()[1] > 0 ? 12 : 0 ]) : u.range([ s, 0 ]), y = y || o, b = b || u.copy().range([ u(0), u(0) ]);
var S = w.selectAll("g.nv-wrap.nv-discretebar").data([ e ]), x = S.enter().append("g").attr("class", "nvd3 nv-wrap nv-discretebar"), T = x.append("g"), N = S.select("g");
T.append("g").attr("class", "nv-groups"), S.attr("transform", "translate(" + t.left + "," + t.top + ")");
var C = S.select(".nv-groups").selectAll(".nv-group").data(function(e) {
return e;
}, function(e) {
return e.key;
});
C.enter().append("g").style("stroke-opacity", 1e-6).style("fill-opacity", 1e-6), d3.transition(C.exit()).style("stroke-opacity", 1e-6).style("fill-opacity", 1e-6).remove(), C.attr("class", function(e, t) {
return "nv-group nv-series-" + t;
}).classed("hover", function(e) {
return e.hover;
}), d3.transition(C).style("stroke-opacity", 1).style("fill-opacity", .75);
var k = C.selectAll("g.nv-bar").data(function(e) {
return e.values;
});
k.exit().remove();
var L = k.enter().append("g").attr("transform", function(e, t, n) {
return "translate(" + (o(a(e, t)) + o.rangeBand() * .05) + ", " + u(0) + ")";
}).on("mouseover", function(t, n) {
d3.select(this).classed("hover", !0), m.elementMouseover({
value: f(t, n),
point: t,
series: e[t.series],
pos: [ o(a(t, n)) + o.rangeBand() * (t.series + .5) / e.length, u(f(t, n)) ],
pointIndex: n,
seriesIndex: t.series,
e: d3.event
});
}).on("mouseout", function(t, n) {
d3.select(this).classed("hover", !1), m.elementMouseout({
value: f(t, n),
point: t,
series: e[t.series],
pointIndex: n,
seriesIndex: t.series,
e: d3.event
});
}).on("click", function(t, n) {
m.elementClick({
value: f(t, n),
point: t,
series: e[t.series],
pos: [ o(a(t, n)) + o.rangeBand() * (t.series + .5) / e.length, u(f(t, n)) ],
pointIndex: n,
seriesIndex: t.series,
e: d3.event
}), d3.event.stopPropagation();
}).on("dblclick", function(t, n) {
m.elementDblClick({
value: f(t, n),
point: t,
series: e[t.series],
pos: [ o(a(t, n)) + o.rangeBand() * (t.series + .5) / e.length, u(f(t, n)) ],
pointIndex: n,
seriesIndex: t.series,
e: d3.event
}), d3.event.stopPropagation();
});
L.append("rect").attr("height", 0).attr("width", o.rangeBand() * .9 / e.length), h ? (L.append("text").attr("text-anchor", "middle"), k.select("text").attr("x", o.rangeBand() * .9 / 2).attr("y", function(e, t) {
return f(e, t) < 0 ? u(f(e, t)) - u(0) + 12 : -4;
}).text(function(e, t) {
return p(f(e, t));
})) : k.selectAll("text").remove(), k.attr("class", function(e, t) {
return f(e, t) < 0 ? "nv-bar negative" : "nv-bar positive";
}).style("fill", function(e, t) {
return e.color || c(e, t);
}).style("stroke", function(e, t) {
return e.color || c(e, t);
}).select("rect").attr("class", g).attr("width", o.rangeBand() * .9 / e.length), d3.transition(k).attr("transform", function(e, t) {
var n = o(a(e, t)) + o.rangeBand() * .05, r = f(e, t) < 0 ? u(0) : u(0) - u(f(e, t)) < 1 ? u(0) - 1 : u(f(e, t));
return "translate(" + n + ", " + r + ")";
}).select("rect").attr("height", function(e, t) {
return Math.max(Math.abs(u(f(e, t)) - u(0)) || 1);
}), y = o.copy(), b = u.copy();
}), e;
}
var t = {
top: 0,
right: 0,
bottom: 0,
left: 0
}, r = 960, i = 500, s = Math.floor(Math.random() * 1e4), o = d3.scale.ordinal(), u = d3.scale.linear(), a = function(e) {
return e.x;
}, f = function(e) {
return e.y;
}, l = [ 0 ], c = n.utils.defaultColor(), h = !1, p = d3.format(",.2f"), d, v, m = d3.dispatch("chartClick", "elementClick", "elementDblClick", "elementMouseover", "elementMouseout"), g = "discreteBar", y, b;
return e.dispatch = m, e.x = function(t) {
return arguments.length ? (a = t, e) : a;
}, e.y = function(t) {
return arguments.length ? (f = t, e) : f;
}, e.margin = function(n) {
return arguments.length ? (t.top = typeof n.top != "undefined" ? n.top : t.top, t.right = typeof n.right != "undefined" ? n.right : t.right, t.bottom = typeof n.bottom != "undefined" ? n.bottom : t.bottom, t.left = typeof n.left != "undefined" ? n.left : t.left, e) : t;
}, e.width = function(t) {
return arguments.length ? (r = t, e) : r;
}, e.height = function(t) {
return arguments.length ? (i = t, e) : i;
}, e.xScale = function(t) {
return arguments.length ? (o = t, e) : o;
}, e.yScale = function(t) {
return arguments.length ? (u = t, e) : u;
}, e.xDomain = function(t) {
return arguments.length ? (d = t, e) : d;
}, e.yDomain = function(t) {
return arguments.length ? (v = t, e) : v;
}, e.forceY = function(t) {
return arguments.length ? (l = t, e) : l;
}, e.color = function(t) {
return arguments.length ? (c = n.utils.getColor(t), e) : c;
}, e.id = function(t) {
return arguments.length ? (s = t, e) : s;
}, e.showValues = function(t) {
return arguments.length ? (h = t, e) : h;
}, e.valueFormat = function(t) {
return arguments.length ? (p = t, e) : p;
}, e.rectClass = function(t) {
return arguments.length ? (g = t, e) : g;
}, e;
}, n.models.discreteBarChart = function() {
function e(n) {
return n.each(function(n) {
var a = d3.select(this), c = this, g = (o || parseInt(a.style("width")) || 960) - s.left - s.right, y = (u || parseInt(a.style("height")) || 400) - s.top - s.bottom;
e.update = function() {
v.beforeUpdate(), a.transition().call(e);
}, e.container = this;
if (!n || !n.length || !n.filter(function(e) {
return e.values.length;
}).length) {
var b = a.selectAll(".nv-noData").data([ d ]);
return b.enter().append("text").attr("class", "nvd3 nv-noData").attr("dy", "-.7em").style("text-anchor", "middle"), b.attr("x", s.left + g / 2).attr("y", s.top + y / 2).text(function(e) {
return e;
}), e;
}
a.selectAll(".nv-noData").remove(), h = t.xScale(), p = t.yScale();
var w = a.selectAll("g.nv-wrap.nv-discreteBarWithAxes").data([ n ]), E = w.enter().append("g").attr("class", "nvd3 nv-wrap nv-discreteBarWithAxes").append("g"), S = E.append("defs"), x = w.select("g");
E.append("g").attr("class", "nv-x nv-axis"), E.append("g").attr("class", "nv-y nv-axis"), E.append("g").attr("class", "nv-barsWrap"), x.attr("transform", "translate(" + s.left + "," + s.top + ")"), t.width(g).height(y);
var T = x.select(".nv-barsWrap").datum(n.filter(function(e) {
return !e.disabled;
}));
d3.transition(T).call(t), S.append("clipPath").attr("id", "nv-x-label-clip-" + t.id()).append("rect"), x.select("#nv-x-label-clip-" + t.id() + " rect").attr("width", h.rangeBand() * (f ? 2 : 1)).attr("height", 16).attr("x", -h.rangeBand() / (f ? 1 : 2)), r.scale(h).ticks(g / 100).tickSize(-y, 0), x.select(".nv-x.nv-axis").attr("transform", "translate(0," + (p.range()[0] + (t.showValues() && p.domain()[0] < 0 ? 16 : 0)) + ")"), x.select(".nv-x.nv-axis").transition().duration(0).call(r);
var N = x.select(".nv-x.nv-axis").selectAll("g");
f && N.selectAll("text").attr("transform", function(e, t, n) {
return "translate(0," + (n % 2 == 0 ? "5" : "17") + ")";
}), i.scale(p).ticks(y / 36).tickSize(-g, 0), d3.transition(x.select(".nv-y.nv-axis")).call(i), v.on("tooltipShow", function(e) {
l && m(e, c.parentNode);
});
}), e;
}
var t = n.models.discreteBar(), r = n.models.axis(), i = n.models.axis(), s = {
top: 15,
right: 10,
bottom: 50,
left: 60
}, o = null, u = null, a = n.utils.getColor(), f = !1, l = !0, c = function(e, t, n, r, i) {
return "<h3>" + t + "</h3>" + "<p>" + n + "</p>";
}, h, p, d = "No Data Available.", v = d3.dispatch("tooltipShow", "tooltipHide", "beforeUpdate");
r.orient("bottom").highlightZero(!1).showMaxMin(!1).tickFormat(function(e) {
return e;
}), i.orient("left").tickFormat(d3.format(",.1f"));
var m = function(s, o) {
var u = s.pos[0] + (o.offsetLeft || 0), a = s.pos[1] + (o.offsetTop || 0), f = r.tickFormat()(t.x()(s.point, s.pointIndex)), l = i.tickFormat()(t.y()(s.point, s.pointIndex)), h = c(s.series.key, f, l, s, e);
n.tooltip.show([ u, a ], h, s.value < 0 ? "n" : "s", null, o);
};
return t.dispatch.on("elementMouseover.tooltip", function(e) {
e.pos = [ e.pos[0] + s.left, e.pos[1] + s.top ], v.tooltipShow(e);
}), t.dispatch.on("elementMouseout.tooltip", function(e) {
v.tooltipHide(e);
}), v.on("tooltipHide", function() {
l && n.tooltip.cleanup();
}), e.dispatch = v, e.discretebar = t, e.xAxis = r, e.yAxis = i, d3.rebind(e, t, "x", "y", "xDomain", "yDomain", "forceX", "forceY", "id", "showValues", "valueFormat"), e.margin = function(t) {
return arguments.length ? (s.top = typeof t.top != "undefined" ? t.top : s.top, s.right = typeof t.right != "undefined" ? t.right : s.right, s.bottom = typeof t.bottom != "undefined" ? t.bottom : s.bottom, s.left = typeof t.left != "undefined" ? t.left : s.left, e) : s;
}, e.width = function(t) {
return arguments.length ? (o = t, e) : o;
}, e.height = function(t) {
return arguments.length ? (u = t, e) : u;
}, e.color = function(r) {
return arguments.length ? (a = n.utils.getColor(r), t.color(a), e) : a;
}, e.staggerLabels = function(t) {
return arguments.length ? (f = t, e) : f;
}, e.tooltips = function(t) {
return arguments.length ? (l = t, e) : l;
}, e.tooltipContent = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.noData = function(t) {
return arguments.length ? (d = t, e) : d;
}, e;
}, n.models.distribution = function() {
function e(n) {
return n.each(function(e) {
var n = r - (s === "x" ? t.left + t.right : t.top + t.bottom), f = s == "x" ? "y" : "x", c = d3.select(this);
l = l || a;
var h = c.selectAll("g.nv-distribution").data([ e ]), p = h.enter().append("g").attr("class", "nvd3 nv-distribution"), d = p.append("g"), v = h.select("g");
h.attr("transform", "translate(" + t.left + "," + t.top + ")");
var m = v.selectAll("g.nv-dist").data(function(e) {
return e;
}, function(e) {
return e.key;
});
m.enter().append("g"), m.attr("class", function(e, t) {
return "nv-dist nv-series-" + t;
}).style("stroke", function(e, t) {
return u(e, t);
});
var g = m.selectAll("line.nv-dist" + s).data(function(e) {
return e.values;
});
g.enter().append("line").attr(s + "1", function(e, t) {
return l(o(e, t));
}).attr(s + "2", function(e, t) {
return l(o(e, t));
}), d3.transition(m.exit().selectAll("line.nv-dist" + s)).attr(s + "1", function(e, t) {
return a(o(e, t));
}).attr(s + "2", function(e, t) {
return a(o(e, t));
}).style("stroke-opacity", 0).remove(), g.attr("class", function(e, t) {
return "nv-dist" + s + " nv-dist" + s + "-" + t;
}).attr(f + "1", 0).attr(f + "2", i), d3.transition(g).attr(s + "1", function(e, t) {
return a(o(e, t));
}).attr(s + "2", function(e, t) {
return a(o(e, t));
}), l = a.copy();
}), e;
}
var t = {
top: 0,
right: 0,
bottom: 0,
left: 0
}, r = 400, i = 8, s = "x", o = function(e) {
return e[s];
}, u = n.utils.defaultColor(), a = d3.scale.linear(), f, l;
return e.margin = function(n) {
return arguments.length ? (t.top = typeof n.top != "undefined" ? n.top : t.top, t.right = typeof n.right != "undefined" ? n.right : t.right, t.bottom = typeof n.bottom != "undefined" ? n.bottom : t.bottom, t.left = typeof n.left != "undefined" ? n.left : t.left, e) : t;
}, e.width = function(t) {
return arguments.length ? (r = t, e) : r;
}, e.axis = function(t) {
return arguments.length ? (s = t, e) : s;
}, e.size = function(t) {
return arguments.length ? (i = t, e) : i;
}, e.getData = function(t) {
return arguments.length ? (o = d3.functor(t), e) : o;
}, e.scale = function(t) {
return arguments.length ? (a = t, e) : a;
}, e.color = function(t) {
return arguments.length ? (u = n.utils.getColor(t), e) : u;
}, e;
}, n.models.historicalBar = function() {
function e(n) {
return n.each(function(e) {
var n = r - t.left - t.right, y = i - t.top - t.bottom, b = d3.select(this);
o.domain(v || d3.extent(e[0].values.map(a).concat(l))), h ? o.range([ n * .5 / e[0].values.length, n * (e[0].values.length - .5) / e[0].values.length ]) : o.range([ 0, n ]), u.domain(m || d3.extent(e[0].values.map(f).concat(c))).range([ y, 0 ]);
if (o.domain()[0] === o.domain()[1] || u.domain()[0] === u.domain()[1]) singlePoint = !0;
o.domain()[0] === o.domain()[1] && (o.domain()[0] ? o.domain([ o.domain()[0] - o.domain()[0] * .01, o.domain()[1] + o.domain()[1] * .01 ]) : o.domain([ -1, 1 ])), u.domain()[0] === u.domain()[1] && (u.domain()[0] ? u.domain([ u.domain()[0] + u.domain()[0] * .01, u.domain()[1] - u.domain()[1] * .01 ]) : u.domain([ -1, 1 ]));
var w = b.selectAll("g.nv-wrap.nv-bar").data([ e[0].values ]), E = w.enter().append("g").attr("class", "nvd3 nv-wrap nv-bar"), S = E.append("defs"), x = E.append("g"), T = w.select("g");
x.append("g").attr("class", "nv-bars"), w.attr("transform", "translate(" + t.left + "," + t.top + ")"), b.on("click", function(e, t) {
g.chartClick({
data: e,
index: t,
pos: d3.event,
id: s
});
}), S.append("clipPath").attr("id", "nv-chart-clip-path-" + s).append("rect"), w.select("#nv-chart-clip-path-" + s + " rect").attr("width", n).attr("height", y), T.attr("clip-path", p ? "url(#nv-chart-clip-path-" + s + ")" : "");
var N = w.select(".nv-bars").selectAll(".nv-bar").data(function(e) {
return e;
});
N.exit().remove();
var C = N.enter().append("rect").attr("x", 0).attr("y", function(e, t) {
return u(Math.max(0, f(e, t)));
}).attr("height", function(e, t) {
return Math.abs(u(f(e, t)) - u(0));
}).on("mouseover", function(t, n) {
d3.select(this).classed("hover", !0), g.elementMouseover({
point: t,
series: e[0],
pos: [ o(a(t, n)), u(f(t, n)) ],
pointIndex: n,
seriesIndex: 0,
e: d3.event
});
}).on("mouseout", function(t, n) {
d3.select(this).classed("hover", !1), g.elementMouseout({
point: t,
series: e[0],
pointIndex: n,
seriesIndex: 0,
e: d3.event
});
}).on("click", function(e, t) {
g.elementClick({
value: f(e, t),
data: e,
index: t,
pos: [ o(a(e, t)), u(f(e, t)) ],
e: d3.event,
id: s
}), d3.event.stopPropagation();
}).on("dblclick", function(e, t) {
g.elementDblClick({
value: f(e, t),
data: e,
index: t,
pos: [ o(a(e, t)), u(f(e, t)) ],
e: d3.event,
id: s
}), d3.event.stopPropagation();
});
N.attr("fill", function(e, t) {
return d(e, t);
}).attr("class", function(e, t, n) {
return (f(e, t) < 0 ? "nv-bar negative" : "nv-bar positive") + " nv-bar-" + n + "-" + t;
}).attr("transform", function(t, r) {
return "translate(" + (o(a(t, r)) - n / e[0].values.length * .45) + ",0)";
}).attr("width", n / e[0].values.length * .9), d3.transition(N).attr("y", function(e, t) {
return f(e, t) < 0 ? u(0) : u(0) - u(f(e, t)) < 1 ? u(0) - 1 : u(f(e, t));
}).attr("height", function(e, t) {
return Math.max(Math.abs(u(f(e, t)) - u(0)), 1);
});
}), e;
}
var t = {
top: 0,
right: 0,
bottom: 0,
left: 0
}, r = 960, i = 500, s = Math.floor(Math.random() * 1e4), o = d3.scale.linear(), u = d3.scale.linear(), a = function(e) {
return e.x;
}, f = function(e) {
return e.y;
}, l = [], c = [ 0 ], h = !1, p = !0, d = n.utils.defaultColor(), v, m, g = d3.dispatch("chartClick", "elementClick", "elementDblClick", "elementMouseover", "elementMouseout");
return e.dispatch = g, e.x = function(t) {
return arguments.length ? (a = t, e) : a;
}, e.y = function(t) {
return arguments.length ? (f = t, e) : f;
}, e.margin = function(n) {
return arguments.length ? (t.top = typeof n.top != "undefined" ? n.top : t.top, t.right = typeof n.right != "undefined" ? n.right : t.right, t.bottom = typeof n.bottom != "undefined" ? n.bottom : t.bottom, t.left = typeof n.left != "undefined" ? n.left : t.left, e) : t;
}, e.width = function(t) {
return arguments.length ? (r = t, e) : r;
}, e.height = function(t) {
return arguments.length ? (i = t, e) : i;
}, e.xScale = function(t) {
return arguments.length ? (o = t, e) : o;
}, e.yScale = function(t) {
return arguments.length ? (u = t, e) : u;
}, e.xDomain = function(t) {
return arguments.length ? (v = t, e) : v;
}, e.yDomain = function(t) {
return arguments.length ? (m = t, e) : m;
}, e.forceX = function(t) {
return arguments.length ? (l = t, e) : l;
}, e.forceY = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.padData = function(t) {
return arguments.length ? (h = t, e) : h;
}, e.clipEdge = function(t) {
return arguments.length ? (p = t, e) : p;
}, e.color = function(t) {
return arguments.length ? (d = n.utils.getColor(t), e) : d;
}, e.id = function(t) {
return arguments.length ? (s = t, e) : s;
}, e;
}, n.models.historicalBarChart = function() {
function e(n) {
return n.each(function(v) {
var x = d3.select(this), T = this, N = (a || parseInt(x.style("width")) || 960) - o.left - o.right, C = (f || parseInt(x.style("height")) || 400) - o.top - o.bottom;
e.update = function() {
e(n);
}, e.container = this, y.disabled = v.map(function(e) {
return !!e.disabled;
});
if (!b) {
var k;
b = {};
for (k in y) y[k] instanceof Array ? b[k] = y[k].slice(0) : b[k] = y[k];
}
if (!v || !v.length || !v.filter(function(e) {
return e.values.length;
}).length) {
var L = x.selectAll(".nv-noData").data([ w ]);
return L.enter().append("text").attr("class", "nvd3 nv-noData").attr("dy", "-.7em").style("text-anchor", "middle"), L.attr("x", o.left + N / 2).attr("y", o.top + C / 2).text(function(e) {
return e;
}), e;
}
x.selectAll(".nv-noData").remove(), m = t.xScale(), g = t.yScale();
var A = x.selectAll("g.nv-wrap.nv-lineChart").data([ v ]), O = A.enter().append("g").attr("class", "nvd3 nv-wrap nv-lineChart").append("g"), M = A.select("g");
O.append("g").attr("class", "nv-x nv-axis"), O.append("g").attr("class", "nv-y nv-axis"), O.append("g").attr("class", "nv-barsWrap"), O.append("g").attr("class", "nv-legendWrap"), l && (s.width(N), M.select(".nv-legendWrap").datum(v).call(s), o.top != s.height() && (o.top = s.height(), C = (f || parseInt(x.style("height")) || 400) - o.top - o.bottom), A.select(".nv-legendWrap").attr("transform", "translate(0," + -o.top + ")")), A.attr("transform", "translate(" + o.left + "," + o.top + ")"), p && M.select(".nv-y.nv-axis").attr("transform", "translate(" + N + ",0)"), t.width(N).height(C).color(v.map(function(e, t) {
return e.color || u(e, t);
}).filter(function(e, t) {
return !v[t].disabled;
}));
var _ = M.select(".nv-barsWrap").datum(v.filter(function(e) {
return !e.disabled;
}));
d3.transition(_).call(t), c && (r.scale(m).tickSize(-C, 0), M.select(".nv-x.nv-axis").attr("transform", "translate(0," + g.range()[0] + ")"), M.select(".nv-x.nv-axis").transition().call(r)), h && (i.scale(g).ticks(C / 36).tickSize(-N, 0), M.select(".nv-y.nv-axis").transition().duration(0).call(i)), s.dispatch.on("legendClick", function(t, r) {
t.disabled = !t.disabled, v.filter(function(e) {
return !e.disabled;
}).length || v.map(function(e) {
return e.disabled = !1, A.selectAll(".nv-series").classed("disabled", !1), e;
}), y.disabled = v.map(function(e) {
return !!e.disabled;
}), E.stateChange(y), n.transition().call(e);
}), s.dispatch.on("legendDblclick", function(t) {
v.forEach(function(e) {
e.disabled = !0;
}), t.disabled = !1, y.disabled = v.map(function(e) {
return !!e.disabled;
}), E.stateChange(y), e.update();
}), E.on("tooltipShow", function(e) {
d && S(e, T.parentNode);
}), E.on("changeState", function(t) {
typeof t.disabled != "undefined" && (v.forEach(function(e, n) {
e.disabled = t.disabled[n];
}), y.disabled = t.disabled), n.call(e);
});
}), e;
}
var t = n.models.historicalBar(), r = n.models.axis(), i = n.models.axis(), s = n.models.legend(), o = {
top: 30,
right: 90,
bottom: 50,
left: 90
}, u = n.utils.defaultColor(), a = null, f = null, l = !1, c = !0, h = !0, p = !1, d = !0, v = function(e, t, n, r, i) {
return "<h3>" + e + "</h3>" + "<p>" + n + " at " + t + "</p>";
}, m, g, y = {}, b = null, w = "No Data Available.", E = d3.dispatch("tooltipShow", "tooltipHide", "stateChange", "changeState");
r.orient("bottom").tickPadding(7), i.orient(p ? "right" : "left");
var S = function(s, o) {
if (o) {
var u = d3.select(o).select("svg"), a = u.node() ? u.attr("viewBox") : null;
if (a) {
a = a.split(" ");
var f = parseInt(u.style("width")) / a[2];
s.pos[0] = s.pos[0] * f, s.pos[1] = s.pos[1] * f;
}
}
var l = s.pos[0] + (o.offsetLeft || 0), c = s.pos[1] + (o.offsetTop || 0), h = r.tickFormat()(t.x()(s.point, s.pointIndex)), p = i.tickFormat()(t.y()(s.point, s.pointIndex)), d = v(s.series.key, h, p, s, e);
n.tooltip.show([ l, c ], d, null, null, o);
};
return t.dispatch.on("elementMouseover.tooltip", function(e) {
e.pos = [ e.pos[0] + o.left, e.pos[1] + o.top ], E.tooltipShow(e);
}), t.dispatch.on("elementMouseout.tooltip", function(e) {
E.tooltipHide(e);
}), E.on("tooltipHide", function() {
d && n.tooltip.cleanup();
}), e.dispatch = E, e.bars = t, e.legend = s, e.xAxis = r, e.yAxis = i, d3.rebind(e, t, "defined", "isArea", "x", "y", "size", "xScale", "yScale", "xDomain", "yDomain", "forceX", "forceY", "interactive", "clipEdge", "clipVoronoi", "id", "interpolate"), e.margin = function(t) {
return arguments.length ? (o.top = typeof t.top != "undefined" ? t.top : o.top, o.right = typeof t.right != "undefined" ? t.right : o.right, o.bottom = typeof t.bottom != "undefined" ? t.bottom : o.bottom, o.left = typeof t.left != "undefined" ? t.left : o.left, e) : o;
}, e.width = function(t) {
return arguments.length ? (a = t, e) : a;
}, e.height = function(t) {
return arguments.length ? (f = t, e) : f;
}, e.color = function(t) {
return arguments.length ? (u = n.utils.getColor(t), s.color(u), e) : u;
}, e.showLegend = function(t) {
return arguments.length ? (l = t, e) : l;
}, e.showXAxis = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.showYAxis = function(t) {
return arguments.length ? (h = t, e) : h;
}, e.rightAlignYAxis = function(t) {
return arguments.length ? (p = t, i.orient(t ? "right" : "left"), e) : p;
}, e.tooltips = function(t) {
return arguments.length ? (d = t, e) : d;
}, e.tooltipContent = function(t) {
return arguments.length ? (v = t, e) : v;
}, e.state = function(t) {
return arguments.length ? (y = t, e) : y;
}, e.defaultState = function(t) {
return arguments.length ? (b = t, e) : b;
}, e.noData = function(t) {
return arguments.length ? (w = t, e) : w;
}, e;
}, n.models.indentedTree = function() {
function e(t) {
return t.each(function(t) {
function n(t, r, i) {
d3.event.stopPropagation();
if (d3.event.shiftKey && !i) return d3.event.shiftKey = !1, t.values && t.values.forEach(function(e) {
(e.values || e._values) && n(e, 0, !0);
}), !0;
if (!o(t)) return !0;
t.values ? (t._values = t.values, t.values = null) : (t.values = t._values, t._values = null), e.update();
}
function r(e) {
return e._values && e._values.length ? p : e.values && e.values.length ? d : "";
}
function s(e) {
return e._values && e._values.length;
}
function o(e) {
var t = e.values || e._values;
return t && t.length;
}
var g = 1, y = d3.select(this), b = d3.layout.tree().children(function(e) {
return e.values;
}).size([ i, l ]);
e.update = function() {
y.transition().duration(600).call(e);
}, t[0] || (t[0] = {
key: f
});
var w = b.nodes(t[0]), E = d3.select(this).selectAll("div").data([ [ w ] ]), S = E.enter().append("div").attr("class", "nvd3 nv-wrap nv-indentedtree"), x = S.append("table"), T = E.select("table").attr("width", "100%").attr("class", h);
if (u) {
var N = x.append("thead"), C = N.append("tr");
c.forEach(function(e) {
C.append("th").attr("width", e.width ? e.width : "10%").style("text-align", e.type == "numeric" ? "right" : "left").append("span").text(e.label);
});
}
var k = T.selectAll("tbody").data(function(e) {
return e;
});
k.enter().append("tbody"), g = d3.max(w, function(e) {
return e.depth;
}), b.size([ i, g * l ]);
var L = k.selectAll("tr").data(function(e) {
return e.filter(function(e) {
return a && !e.children ? a(e) : !0;
});
}, function(e, t) {
return e.id || e.id || ++m;
});
L.exit().remove(), L.select("img.nv-treeicon").attr("src", r).classed("folded", s);
var A = L.enter().append("tr");
c.forEach(function(e, t) {
var i = A.append("td").style("padding-left", function(e) {
return (t ? 0 : e.depth * l + 12 + (r(e) ? 0 : 16)) + "px";
}, "important").style("text-align", e.type == "numeric" ? "right" : "left");
t == 0 && i.append("img").classed("nv-treeicon", !0).classed("nv-folded", s).attr("src", r).style("width", "14px").style("height", "14px").style("padding", "0 1px").style("display", function(e) {
return r(e) ? "inline-block" : "none";
}).on("click", n), i.append("span").attr("class", d3.functor(e.classes)).text(function(t) {
return e.format ? e.format(t) : t[e.key] || "-";
}), e.showCount && (i.append("span").attr("class", "nv-childrenCount"), L.selectAll("span.nv-childrenCount").text(function(e) {
return e.values && e.values.length || e._values && e._values.length ? "(" + (e.values && e.values.filter(function(e) {
return a ? a(e) : !0;
}).length || e._values && e._values.filter(function(e) {
return a ? a(e) : !0;
}).length || 0) + ")" : "";
})), e.click && i.select("span").on("click", e.click);
}), L.order().on("click", function(e) {
v.elementClick({
row: this,
data: e,
pos: [ e.x, e.y ]
});
}).on("dblclick", function(e) {
v.elementDblclick({
row: this,
data: e,
pos: [ e.x, e.y ]
});
}).on("mouseover", function(e) {
v.elementMouseover({
row: this,
data: e,
pos: [ e.x, e.y ]
});
}).on("mouseout", function(e) {
v.elementMouseout({
row: this,
data: e,
pos: [ e.x, e.y ]
});
});
}), e;
}
var t = {
top: 0,
right: 0,
bottom: 0,
left: 0
}, r = 960, i = 500, s = n.utils.defaultColor(), o = Math.floor(Math.random() * 1e4), u = !0, a = !1, f = "No Data Available.", l = 20, c = [ {
key: "key",
label: "Name",
type: "text"
} ], h = null, p = "images/grey-plus.png", d = "images/grey-minus.png", v = d3.dispatch("elementClick", "elementDblclick", "elementMouseover", "elementMouseout"), m = 0;
return e.margin = function(n) {
return arguments.length ? (t.top = typeof n.top != "undefined" ? n.top : t.top, t.right = typeof n.right != "undefined" ? n.right : t.right, t.bottom = typeof n.bottom != "undefined" ? n.bottom : t.bottom, t.left = typeof n.left != "undefined" ? n.left : t.left, e) : t;
}, e.width = function(t) {
return arguments.length ? (r = t, e) : r;
}, e.height = function(t) {
return arguments.length ? (i = t, e) : i;
}, e.color = function(t) {
return arguments.length ? (s = n.utils.getColor(t), scatter.color(s), e) : s;
}, e.id = function(t) {
return arguments.length ? (o = t, e) : o;
}, e.header = function(t) {
return arguments.length ? (u = t, e) : u;
}, e.noData = function(t) {
return arguments.length ? (f = t, e) : f;
}, e.filterZero = function(t) {
return arguments.length ? (a = t, e) : a;
}, e.columns = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.tableClass = function(t) {
return arguments.length ? (h = t, e) : h;
}, e.iconOpen = function(t) {
return arguments.length ? (p = t, e) : p;
}, e.iconClose = function(t) {
return arguments.length ? (d = t, e) : d;
}, e;
}, n.models.legend = function() {
function e(f) {
return f.each(function(e) {
var f = r - t.left - t.right, l = d3.select(this), c = l.selectAll("g.nv-legend").data([ e ]), h = c.enter().append("g").attr("class", "nvd3 nv-legend").append("g"), p = c.select("g");
c.attr("transform", "translate(" + t.left + "," + t.top + ")");
var d = p.selectAll(".nv-series").data(function(e) {
return e;
}), v = d.enter().append("g").attr("class", "nv-series").on("mouseover", function(e, t) {
a.legendMouseover(e, t);
}).on("mouseout", function(e, t) {
a.legendMouseout(e, t);
}).on("click", function(e, t) {
a.legendClick(e, t);
}).on("dblclick", function(e, t) {
a.legendDblclick(e, t);
});
v.append("circle").style("stroke-width", 2).attr("r", 5), v.append("text").attr("text-anchor", "start").attr("dy", ".32em").attr("dx", "8"), d.classed("disabled", function(e) {
return e.disabled;
}), d.exit().remove(), d.select("circle").style("fill", function(e, t) {
return e.color || o(e, t);
}).style("stroke", function(e, t) {
return e.color || o(e, t);
}), d.select("text").text(s);
if (u) {
var m = [];
d.each(function(e, t) {
var r = d3.select(this).select("text"), i = r.node().getComputedTextLength() || n.utils.calcApproxTextWidth(r);
m.push(i + 28);
});
var g = 0, y = 0, b = [];
while (y < f && g < m.length) b[g] = m[g], y += m[g++];
while (y > f && g > 1) {
b = [], g--;
for (k = 0; k < m.length; k++) m[k] > (b[k % g] || 0) && (b[k % g] = m[k]);
y = b.reduce(function(e, t, n, r) {
return e + t;
});
}
var w = [];
for (var E = 0, S = 0; E < g; E++) w[E] = S, S += b[E];
d.attr("transform", function(e, t) {
return "translate(" + w[t % g] + "," + (5 + Math.floor(t / g) * 20) + ")";
}), p.attr("transform", "translate(" + (r - t.right - y) + "," + t.top + ")"), i = t.top + t.bottom + Math.ceil(m.length / g) * 20;
} else {
var x = 5, T = 5, N = 0, C;
d.attr("transform", function(e, n) {
var i = d3.select(this).select("text").node().getComputedTextLength() + 28;
return C = T, r < t.left + t.right + C + i && (T = C = 5, x += 20), T += i, T > N && (N = T), "translate(" + C + "," + x + ")";
}), p.attr("transform", "translate(" + (r - t.right - N) + "," + t.top + ")"), i = t.top + t.bottom + x + 15;
}
}), e;
}
var t = {
top: 5,
right: 0,
bottom: 5,
left: 0
}, r = 400, i = 20, s = function(e) {
return e.key;
}, o = n.utils.defaultColor(), u = !0, a = d3.dispatch("legendClick", "legendDblclick", "legendMouseover", "legendMouseout");
return e.dispatch = a, e.margin = function(n) {
return arguments.length ? (t.top = typeof n.top != "undefined" ? n.top : t.top, t.right = typeof n.right != "undefined" ? n.right : t.right, t.bottom = typeof n.bottom != "undefined" ? n.bottom : t.bottom, t.left = typeof n.left != "undefined" ? n.left : t.left, e) : t;
}, e.width = function(t) {
return arguments.length ? (r = t, e) : r;
}, e.height = function(t) {
return arguments.length ? (i = t, e) : i;
}, e.key = function(t) {
return arguments.length ? (s = t, e) : s;
}, e.color = function(t) {
return arguments.length ? (o = n.utils.getColor(t), e) : o;
}, e.align = function(t) {
return arguments.length ? (u = t, e) : u;
}, e;
}, n.models.line = function() {
function e(n) {
return n.each(function(e) {
var n = i - r.left - r.right, g = s - r.top - r.bottom, y = d3.select(this);
h = t.xScale(), p = t.yScale(), v = v || h, m = m || p;
var b = y.selectAll("g.nv-wrap.nv-line").data([ e ]), w = b.enter().append("g").attr("class", "nvd3 nv-wrap nv-line"), E = w.append("defs"), S = w.append("g"), x = b.select("g");
S.append("g").attr("class", "nv-groups"), S.append("g").attr("class", "nv-scatterWrap"), b.attr("transform", "translate(" + r.left + "," + r.top + ")"), t.width(n).height(g);
var T = b.select(".nv-scatterWrap");
d3.transition(T).call(t), E.append("clipPath").attr("id", "nv-edge-clip-" + t.id()).append("rect"), b.select("#nv-edge-clip-" + t.id() + " rect").attr("width", n).attr("height", g), x.attr("clip-path", c ? "url(#nv-edge-clip-" + t.id() + ")" : ""), T.attr("clip-path", c ? "url(#nv-edge-clip-" + t.id() + ")" : "");
var N = b.select(".nv-groups").selectAll(".nv-group").data(function(e) {
return e;
}, function(e) {
return e.key;
});
N.enter().append("g").style("stroke-opacity", 1e-6).style("fill-opacity", 1e-6), d3.transition(N.exit()).style("stroke-opacity", 1e-6).style("fill-opacity", 1e-6).remove(), N.attr("class", function(e, t) {
return "nv-group nv-series-" + t;
}).classed("hover", function(e) {
return e.hover;
}).style("fill", function(e, t) {
return o(e, t);
}).style("stroke", function(e, t) {
return o(e, t);
}), d3.transition(N).style("stroke-opacity", 1).style("fill-opacity", .5);
var C = N.selectAll("path.nv-area").data(function(e) {
return l(e) ? [ e ] : [];
});
C.enter().append("path").attr("class", "nv-area").attr("d", function(e) {
return d3.svg.area().interpolate(d).defined(f).x(function(e, t) {
return v(u(e, t));
}).y0(function(e, t) {
return m(a(e, t));
}).y1(function(e, t) {
return m(p.domain()[0] <= 0 ? p.domain()[1] >= 0 ? 0 : p.domain()[1] : p.domain()[0]);
}).apply(this, [ e.values ]);
}), d3.transition(N.exit().selectAll("path.nv-area")).attr("d", function(e) {
return d3.svg.area().interpolate(d).defined(f).x(function(e, t) {
return h(u(e, t));
}).y0(function(e, t) {
return p(a(e, t));
}).y1(function(e, t) {
return p(p.domain()[0] <= 0 ? p.domain()[1] >= 0 ? 0 : p.domain()[1] : p.domain()[0]);
}).apply(this, [ e.values ]);
}), d3.transition(C).attr("d", function(e) {
return d3.svg.area().interpolate(d).defined(f).x(function(e, t) {
return h(u(e, t));
}).y0(function(e, t) {
return p(a(e, t));
}).y1(function(e, t) {
return p(p.domain()[0] <= 0 ? p.domain()[1] >= 0 ? 0 : p.domain()[1] : p.domain()[0]);
}).apply(this, [ e.values ]);
});
var k = N.selectAll("path.nv-line").data(function(e) {
return [ e.values ];
});
k.enter().append("path").attr("class", "nv-line").attr("d", d3.svg.line().interpolate(d).defined(f).x(function(e, t) {
return v(u(e, t));
}).y(function(e, t) {
return m(a(e, t));
})), d3.transition(N.exit().selectAll("path.nv-line")).attr("d", d3.svg.line().interpolate(d).defined(f).x(function(e, t) {
return h(u(e, t));
}).y(function(e, t) {
return p(a(e, t));
})), d3.transition(k).attr("d", d3.svg.line().interpolate(d).defined(f).x(function(e, t) {
return h(u(e, t));
}).y(function(e, t) {
return p(a(e, t));
})), v = h.copy(), m = p.copy();
}), e;
}
var t = n.models.scatter(), r = {
top: 0,
right: 0,
bottom: 0,
left: 0
}, i = 960, s = 500, o = n.utils.defaultColor(), u = function(e) {
return e.x;
}, a = function(e) {
return e.y;
}, f = function(e, t) {
return !isNaN(a(e, t)) && a(e, t) !== null;
}, l = function(e) {
return e.area;
}, c = !1, h, p, d = "linear";
t.size(16).sizeDomain([ 16, 256 ]);
var v, m;
return e.dispatch = t.dispatch, e.scatter = t, d3.rebind(e, t, "id", "interactive", "size", "xScale", "yScale", "zScale", "xDomain", "yDomain", "sizeDomain", "forceX", "forceY", "forceSize", "clipVoronoi", "clipRadius", "padData"), e.margin = function(t) {
return arguments.length ? (r.top = typeof t.top != "undefined" ? t.top : r.top, r.right = typeof t.right != "undefined" ? t.right : r.right, r.bottom = typeof t.bottom != "undefined" ? t.bottom : r.bottom, r.left = typeof t.left != "undefined" ? t.left : r.left, e) : r;
}, e.width = function(t) {
return arguments.length ? (i = t, e) : i;
}, e.height = function(t) {
return arguments.length ? (s = t, e) : s;
}, e.x = function(n) {
return arguments.length ? (u = n, t.x(n), e) : u;
}, e.y = function(n) {
return arguments.length ? (a = n, t.y(n), e) : a;
}, e.clipEdge = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.color = function(r) {
return arguments.length ? (o = n.utils.getColor(r), t.color(o), e) : o;
}, e.interpolate = function(t) {
return arguments.length ? (d = t, e) : d;
}, e.defined = function(t) {
return arguments.length ? (f = t, e) : f;
}, e.isArea = function(t) {
return arguments.length ? (l = d3.functor(t), e) : l;
}, e;
}, n.models.lineChart = function() {
function e(n) {
return n.each(function(n) {
var v = d3.select(this), x = this, T = (a || parseInt(v.style("width")) || 960) - o.left - o.right, N = (f || parseInt(v.style("height")) || 400) - o.top - o.bottom;
e.update = function() {
v.transition().call(e);
}, e.container = this, y.disabled = n.map(function(e) {
return !!e.disabled;
});
if (!b) {
var C;
b = {};
for (C in y) y[C] instanceof Array ? b[C] = y[C].slice(0) : b[C] = y[C];
}
if (!n || !n.length || !n.filter(function(e) {
return e.values.length;
}).length) {
var k = v.selectAll(".nv-noData").data([ w ]);
return k.enter().append("text").attr("class", "nvd3 nv-noData").attr("dy", "-.7em").style("text-anchor", "middle"), k.attr("x", o.left + T / 2).attr("y", o.top + N / 2).text(function(e) {
return e;
}), e;
}
v.selectAll(".nv-noData").remove(), m = t.xScale(), g = t.yScale();
var L = v.selectAll("g.nv-wrap.nv-lineChart").data([ n ]), A = L.enter().append("g").attr("class", "nvd3 nv-wrap nv-lineChart").append("g"), O = L.select("g");
A.append("g").attr("class", "nv-x nv-axis"), A.append("g").attr("class", "nv-y nv-axis"), A.append("g").attr("class", "nv-linesWrap"), A.append("g").attr("class", "nv-legendWrap"), l && (s.width(T), O.select(".nv-legendWrap").datum(n).call(s), o.top != s.height() && (o.top = s.height(), N = (f || parseInt(v.style("height")) || 400) - o.top - o.bottom), L.select(".nv-legendWrap").attr("transform", "translate(0," + -o.top + ")")), L.attr("transform", "translate(" + o.left + "," + o.top + ")"), p && O.select(".nv-y.nv-axis").attr("transform", "translate(" + T + ",0)"), t.width(T).height(N).color(n.map(function(e, t) {
return e.color || u(e, t);
}).filter(function(e, t) {
return !n[t].disabled;
}));
var M = O.select(".nv-linesWrap").datum(n.filter(function(e) {
return !e.disabled;
}));
d3.transition(M).call(t), c && (r.scale(m).ticks(T / 100).tickSize(-N, 0), O.select(".nv-x.nv-axis").attr("transform", "translate(0," + g.range()[0] + ")"), d3.transition(O.select(".nv-x.nv-axis")).call(r)), h && (i.scale(g).ticks(N / 36).tickSize(-T, 0), d3.transition(O.select(".nv-y.nv-axis")).call(i)), s.dispatch.on("legendClick", function(t, r) {
t.disabled = !t.disabled, n.filter(function(e) {
return !e.disabled;
}).length || n.map(function(e) {
return e.disabled = !1, L.selectAll(".nv-series").classed("disabled", !1), e;
}), y.disabled = n.map(function(e) {
return !!e.disabled;
}), E.stateChange(y), e.update();
}), s.dispatch.on("legendDblclick", function(t) {
n.forEach(function(e) {
e.disabled = !0;
}), t.disabled = !1, y.disabled = n.map(function(e) {
return !!e.disabled;
}), E.stateChange(y), e.update();
}), E.on("tooltipShow", function(e) {
d && S(e, x.parentNode);
}), E.on("changeState", function(t) {
typeof t.disabled != "undefined" && (n.forEach(function(e, n) {
e.disabled = t.disabled[n];
}), y.disabled = t.disabled), e.update();
});
}), e;
}
var t = n.models.line(), r = n.models.axis(), i = n.models.axis(), s = n.models.legend(), o = {
top: 30,
right: 20,
bottom: 50,
left: 60
}, u = n.utils.defaultColor(), a = null, f = null, l = !0, c = !0, h = !0, p = !1, d = !0, v = function(e, t, n, r, i) {
return "<h3>" + e + "</h3>" + "<p>" + n + " at " + t + "</p>";
}, m, g, y = {}, b = null, w = "No Data Available.", E = d3.dispatch("tooltipShow", "tooltipHide", "stateChange", "changeState");
r.orient("bottom").tickPadding(7), i.orient(p ? "right" : "left");
var S = function(s, o) {
if (o) {
var u = d3.select(o).select("svg"), a = u.node() ? u.attr("viewBox") : null;
if (a) {
a = a.split(" ");
var f = parseInt(u.style("width")) / a[2];
s.pos[0] = s.pos[0] * f, s.pos[1] = s.pos[1] * f;
}
}
var l = s.pos[0] + (o.offsetLeft || 0), c = s.pos[1] + (o.offsetTop || 0), h = r.tickFormat()(t.x()(s.point, s.pointIndex)), p = i.tickFormat()(t.y()(s.point, s.pointIndex)), d = v(s.series.key, h, p, s, e);
n.tooltip.show([ l, c ], d, null, null, o);
};
return t.dispatch.on("elementMouseover.tooltip", function(e) {
e.pos = [ e.pos[0] + o.left, e.pos[1] + o.top ], E.tooltipShow(e);
}), t.dispatch.on("elementMouseout.tooltip", function(e) {
E.tooltipHide(e);
}), E.on("tooltipHide", function() {
d && n.tooltip.cleanup();
}), e.dispatch = E, e.lines = t, e.legend = s, e.xAxis = r, e.yAxis = i, d3.rebind(e, t, "defined", "isArea", "x", "y", "size", "xScale", "yScale", "xDomain", "yDomain", "forceX", "forceY", "interactive", "clipEdge", "clipVoronoi", "id", "interpolate"), e.margin = function(t) {
return arguments.length ? (o.top = typeof t.top != "undefined" ? t.top : o.top, o.right = typeof t.right != "undefined" ? t.right : o.right, o.bottom = typeof t.bottom != "undefined" ? t.bottom : o.bottom, o.left = typeof t.left != "undefined" ? t.left : o.left, e) : o;
}, e.width = function(t) {
return arguments.length ? (a = t, e) : a;
}, e.height = function(t) {
return arguments.length ? (f = t, e) : f;
}, e.color = function(t) {
return arguments.length ? (u = n.utils.getColor(t), s.color(u), e) : u;
}, e.showLegend = function(t) {
return arguments.length ? (l = t, e) : l;
}, e.showXAxis = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.showYAxis = function(t) {
return arguments.length ? (h = t, e) : h;
}, e.rightAlignYAxis = function(t) {
return arguments.length ? (p = t, i.orient(t ? "right" : "left"), e) : p;
}, e.tooltips = function(t) {
return arguments.length ? (d = t, e) : d;
}, e.tooltipContent = function(t) {
return arguments.length ? (v = t, e) : v;
}, e.state = function(t) {
return arguments.length ? (y = t, e) : y;
}, e.defaultState = function(t) {
return arguments.length ? (b = t, e) : b;
}, e.noData = function(t) {
return arguments.length ? (w = t, e) : w;
}, e;
}, n.models.linePlusBarChart = function() {
function e(n) {
return n.each(function(n) {
var c = d3.select(this), h = this, m = (f || parseInt(c.style("width")) || 960) - a.left - a.right, N = (l || parseInt(c.style("height")) || 400) - a.top - a.bottom;
e.update = function() {
c.transition().call(e);
}, w.disabled = n.map(function(e) {
return !!e.disabled;
});
if (!E) {
var C;
E = {};
for (C in w) w[C] instanceof Array ? E[C] = w[C].slice(0) : E[C] = w[C];
}
if (!n || !n.length || !n.filter(function(e) {
return e.values.length;
}).length) {
var k = c.selectAll(".nv-noData").data([ S ]);
return k.enter().append("text").attr("class", "nvd3 nv-noData").attr("dy", "-.7em").style("text-anchor", "middle"), k.attr("x", a.left + m / 2).attr("y", a.top + N / 2).text(function(e) {
return e;
}), e;
}
c.selectAll(".nv-noData").remove();
var L = n.filter(function(e) {
return !e.disabled && e.bar;
}), A = n.filter(function(e) {
return !e.bar;
});
g = A.filter(function(e) {
return !e.disabled;
}).length && A.filter(function(e) {
return !e.disabled;
})[0].values.length ? t.xScale() : r.xScale(), y = r.yScale(), b = t.yScale();
var O = d3.select(this).selectAll("g.nv-wrap.nv-linePlusBar").data([ n ]), M = O.enter().append("g").attr("class", "nvd3 nv-wrap nv-linePlusBar").append("g"), _ = O.select("g");
M.append("g").attr("class", "nv-x nv-axis"), M.append("g").attr("class", "nv-y1 nv-axis"), M.append("g").attr("class", "nv-y2 nv-axis"), M.append("g").attr("class", "nv-barsWrap"), M.append("g").attr("class", "nv-linesWrap"), M.append("g").attr("class", "nv-legendWrap"), d && (u.width(m / 2), _.select(".nv-legendWrap").datum(n.map(function(e) {
return e.originalKey = e.originalKey === undefined ? e.key : e.originalKey, e.key = e.originalKey + (e.bar ? " (left axis)" : " (right axis)"), e;
})).call(u), a.top != u.height() && (a.top = u.height(), N = (l || parseInt(c.style("height")) || 400) - a.top - a.bottom), _.select(".nv-legendWrap").attr("transform", "translate(" + m / 2 + "," + -a.top + ")")), O.attr("transform", "translate(" + a.left + "," + a.top + ")"), t.width(m).height(N).color(n.map(function(e, t) {
return e.color || p(e, t);
}).filter(function(e, t) {
return !n[t].disabled && !n[t].bar;
})), r.width(m).height(N).color(n.map(function(e, t) {
return e.color || p(e, t);
}).filter(function(e, t) {
return !n[t].disabled && n[t].bar;
}));
var D = _.select(".nv-barsWrap").datum(L.length ? L : [ {
values: []
} ]), P = _.select(".nv-linesWrap").datum(A[0] && !A[0].disabled ? A : [ {
values: []
} ]);
d3.transition(D).call(r), d3.transition(P).call(t), i.scale(g).ticks(m / 100).tickSize(-N, 0), _.select(".nv-x.nv-axis").attr("transform", "translate(0," + y.range()[0] + ")"), d3.transition(_.select(".nv-x.nv-axis")).call(i), s.scale(y).ticks(N / 36).tickSize(-m, 0), d3.transition(_.select(".nv-y1.nv-axis")).style("opacity", L.length ? 1 : 0).call(s), o.scale(b).ticks(N / 36).tickSize(L.length ? 0 : -m, 0), _.select(".nv-y2.nv-axis").style("opacity", A.length ? 1 : 0).attr("transform", "translate(" + m + ",0)"), d3.transition(_.select(".nv-y2.nv-axis")).call(o), u.dispatch.on("legendClick", function(t, r) {
t.disabled = !t.disabled, n.filter(function(e) {
return !e.disabled;
}).length || n.map(function(e) {
return e.disabled = !1, O.selectAll(".nv-series").classed("disabled", !1), e;
}), w.disabled = n.map(function(e) {
return !!e.disabled;
}), x.stateChange(w), e.update();
}), u.dispatch.on("legendDblclick", function(t) {
n.forEach(function(e) {
e.disabled = !0;
}), t.disabled = !1, w.disabled = n.map(function(e) {
return !!e.disabled;
}), x.stateChange(w), e.update();
}), x.on("tooltipShow", function(e) {
v && T(e, h.parentNode);
}), x.on("changeState", function(t) {
typeof t.disabled != "undefined" && (n.forEach(function(e, n) {
e.disabled = t.disabled[n];
}), w.disabled = t.disabled), e.update();
});
}), e;
}
var t = n.models.line(), r = n.models.historicalBar(), i = n.models.axis(), s = n.models.axis(), o = n.models.axis(), u = n.models.legend(), a = {
top: 30,
right: 60,
bottom: 50,
left: 60
}, f = null, l = null, c = function(e) {
return e.x;
}, h = function(e) {
return e.y;
}, p = n.utils.defaultColor(), d = !0, v = !0, m = function(e, t, n, r, i) {
return "<h3>" + e + "</h3>" + "<p>" + n + " at " + t + "</p>";
}, g, y, b, w = {}, E = null, S = "No Data Available.", x = d3.dispatch("tooltipShow", "tooltipHide", "stateChange", "changeState");
r.padData(!0), t.clipEdge(!1).padData(!0), i.orient("bottom").tickPadding(7).highlightZero(!1), s.orient("left"), o.orient("right");
var T = function(r, u) {
var a = r.pos[0] + (u.offsetLeft || 0), f = r.pos[1] + (u.offsetTop || 0), l = i.tickFormat()(t.x()(r.point, r.pointIndex)), c = (r.series.bar ? s : o).tickFormat()(t.y()(r.point, r.pointIndex)), h = m(r.series.key, l, c, r, e);
n.tooltip.show([ a, f ], h, r.value < 0 ? "n" : "s", null, u);
};
return t.dispatch.on("elementMouseover.tooltip", function(e) {
e.pos = [ e.pos[0] + a.left, e.pos[1] + a.top ], x.tooltipShow(e);
}), t.dispatch.on("elementMouseout.tooltip", function(e) {
x.tooltipHide(e);
}), r.dispatch.on("elementMouseover.tooltip", function(e) {
e.pos = [ e.pos[0] + a.left, e.pos[1] + a.top ], x.tooltipShow(e);
}), r.dispatch.on("elementMouseout.tooltip", function(e) {
x.tooltipHide(e);
}), x.on("tooltipHide", function() {
v && n.tooltip.cleanup();
}), e.dispatch = x, e.legend = u, e.lines = t, e.bars = r, e.xAxis = i, e.y1Axis = s, e.y2Axis = o, d3.rebind(e, t, "defined", "size", "clipVoronoi", "interpolate"), e.x = function(n) {
return arguments.length ? (c = n, t.x(n), r.x(n), e) : c;
}, e.y = function(n) {
return arguments.length ? (h = n, t.y(n), r.y(n), e) : h;
}, e.margin = function(t) {
return arguments.length ? (a.top = typeof t.top != "undefined" ? t.top : a.top, a.right = typeof t.right != "undefined" ? t.right : a.right, a.bottom = typeof t.bottom != "undefined" ? t.bottom : a.bottom, a.left = typeof t.left != "undefined" ? t.left : a.left, e) : a;
}, e.width = function(t) {
return arguments.length ? (f = t, e) : f;
}, e.height = function(t) {
return arguments.length ? (l = t, e) : l;
}, e.color = function(t) {
return arguments.length ? (p = n.utils.getColor(t), u.color(p), e) : p;
}, e.showLegend = function(t) {
return arguments.length ? (d = t, e) : d;
}, e.tooltips = function(t) {
return arguments.length ? (v = t, e) : v;
}, e.tooltipContent = function(t) {
return arguments.length ? (m = t, e) : m;
}, e.state = function(t) {
return arguments.length ? (w = t, e) : w;
}, e.defaultState = function(t) {
return arguments.length ? (E = t, e) : E;
}, e.noData = function(t) {
return arguments.length ? (S = t, e) : S;
}, e;
}, n.models.lineWithFocusChart = function() {
function e(n) {
return n.each(function(n) {
function x(e) {
var t = +(e == "e"), n = t ? 1 : -1, r = D / 3;
return "M" + .5 * n + "," + r + "A6,6 0 0 " + t + " " + 6.5 * n + "," + (r + 6) + "V" + (2 * r - 6) + "A6,6 0 0 " + t + " " + .5 * n + "," + 2 * r + "Z" + "M" + 2.5 * n + "," + (r + 8) + "V" + (2 * r - 8) + "M" + 4.5 * n + "," + (r + 8) + "V" + (2 * r - 8);
}
function k() {
f.empty() || f.extent(E), R.data([ f.empty() ? y.domain() : E ]).each(function(e, t) {
var n = y(e[0]) - m.range()[0], r = m.range()[1] - y(e[1]);
d3.select(this).select(".left").attr("width", n < 0 ? 0 : n), d3.select(this).select(".right").attr("x", y(e[1])).attr("width", r < 0 ? 0 : r);
});
}
function L() {
E = f.empty() ? null : f.extent(), extent = f.empty() ? y.domain() : f.extent(), N.brush({
extent: extent,
brush: f
}), k();
var e = j.select(".nv-focus .nv-linesWrap").datum(n.filter(function(e) {
return !e.disabled;
}).map(function(e, n) {
return {
key: e.key,
values: e.values.filter(function(e, n) {
return t.x()(e, n) >= extent[0] && t.x()(e, n) <= extent[1];
})
};
}));
d3.transition(e).call(t), d3.transition(j.select(".nv-focus .nv-x.nv-axis")).call(i), d3.transition(j.select(".nv-focus .nv-y.nv-axis")).call(s);
}
var A = d3.select(this), O = this, M = (p || parseInt(A.style("width")) || 960) - l.left - l.right, _ = (d || parseInt(A.style("height")) || 400) - l.top - l.bottom - v, D = v - c.top - c.bottom;
e.update = function() {
A.transition().call(e);
}, e.container = this;
if (!n || !n.length || !n.filter(function(e) {
return e.values.length;
}).length) {
var P = A.selectAll(".nv-noData").data([ T ]);
return P.enter().append("text").attr("class", "nvd3 nv-noData").attr("dy", "-.7em").style("text-anchor", "middle"), P.attr("x", l.left + M / 2).attr("y", l.top + _ / 2).text(function(e) {
return e;
}), e;
}
A.selectAll(".nv-noData").remove(), m = t.xScale(), g = t.yScale(), y = r.xScale(), b = r.yScale();
var H = A.selectAll("g.nv-wrap.nv-lineWithFocusChart").data([ n ]), B = H.enter().append("g").attr("class", "nvd3 nv-wrap nv-lineWithFocusChart").append("g"), j = H.select("g");
B.append("g").attr("class", "nv-legendWrap");
var F = B.append("g").attr("class", "nv-focus");
F.append("g").attr("class", "nv-x nv-axis"), F.append("g").attr("class", "nv-y nv-axis"), F.append("g").attr("class", "nv-linesWrap");
var I = B.append("g").attr("class", "nv-context");
I.append("g").attr("class", "nv-x nv-axis"), I.append("g").attr("class", "nv-y nv-axis"), I.append("g").attr("class", "nv-linesWrap"), I.append("g").attr("class", "nv-brushBackground"), I.append("g").attr("class", "nv-x nv-brush"), w && (a.width(M), j.select(".nv-legendWrap").datum(n).call(a), l.top != a.height() && (l.top = a.height(), _ = (d || parseInt(A.style("height")) || 400) - l.top - l.bottom - v), j.select(".nv-legendWrap").attr("transform", "translate(0," + -l.top + ")")), H.attr("transform", "translate(" + l.left + "," + l.top + ")"), t.width(M).height(_).color(n.map(function(e, t) {
return e.color || h(e, t);
}).filter(function(e, t) {
return !n[t].disabled;
})), r.defined(t.defined()).width(M).height(D).color(n.map(function(e, t) {
return e.color || h(e, t);
}).filter(function(e, t) {
return !n[t].disabled;
})), j.select(".nv-context").attr("transform", "translate(0," + (_ + l.bottom + c.top) + ")");
var q = j.select(".nv-context .nv-linesWrap").datum(n.filter(function(e) {
return !e.disabled;
}));
d3.transition(q).call(r), i.scale(m).ticks(M / 100).tickSize(-_, 0), s.scale(g).ticks(_ / 36).tickSize(-M, 0), j.select(".nv-focus .nv-x.nv-axis").attr("transform", "translate(0," + _ + ")"), f.x(y).on("brush", L), E && f.extent(E);
var R = j.select(".nv-brushBackground").selectAll("g").data([ E || f.extent() ]), U = R.enter().append("g");
U.append("rect").attr("class", "left").attr("x", 0).attr("y", 0).attr("height", D), U.append("rect").attr("class", "right").attr("x", 0).attr("y", 0).attr("height", D), gBrush = j.select(".nv-x.nv-brush").call(f), gBrush.selectAll("rect").attr("height", D), gBrush.selectAll(".resize").append("path").attr("d", x), L(), o.scale(y).ticks(M / 100).tickSize(-D, 0), j.select(".nv-context .nv-x.nv-axis").attr("transform", "translate(0," + b.range()[0] + ")"), d3.transition(j.select(".nv-context .nv-x.nv-axis")).call(o), u.scale(b).ticks(D / 36).tickSize(-M, 0), d3.transition(j.select(".nv-context .nv-y.nv-axis")).call(u), j.select(".nv-context .nv-x.nv-axis").attr("transform", "translate(0," + b.range()[0] + ")"), a.dispatch.on("legendClick", function(t, r) {
t.disabled = !t.disabled, n.filter(function(e) {
return !e.disabled;
}).length || n.map(function(e) {
return e.disabled = !1, H.selectAll(".nv-series").classed("disabled", !1), e;
}), A.transition().call(e);
}), N.on("tooltipShow", function(e) {
S && C(e, O.parentNode);
});
}), e;
}
var t = n.models.line(), r = n.models.line(), i = n.models.axis(), s = n.models.axis(), o = n.models.axis(), u = n.models.axis(), a = n.models.legend(), f = d3.svg.brush(), l = {
top: 30,
right: 30,
bottom: 30,
left: 60
}, c = {
top: 0,
right: 30,
bottom: 20,
left: 60
}, h = n.utils.defaultColor(), p = null, d = null, v = 100, m, g, y, b, w = !0, E = null, S = !0, x = function(e, t, n, r, i) {
return "<h3>" + e + "</h3>" + "<p>" + n + " at " + t + "</p>";
}, T = "No Data Available.", N = d3.dispatch("tooltipShow", "tooltipHide", "brush");
t.clipEdge(!0), r.interactive(!1), i.orient("bottom").tickPadding(5), s.orient("left"), o.orient("bottom").tickPadding(5), u.orient("left");
var C = function(r, o) {
var u = r.pos[0] + (o.offsetLeft || 0), a = r.pos[1] + (o.offsetTop || 0), f = i.tickFormat()(t.x()(r.point, r.pointIndex)), l = s.tickFormat()(t.y()(r.point, r.pointIndex)), c = x(r.series.key, f, l, r, e);
n.tooltip.show([ u, a ], c, null, null, o);
};
return t.dispatch.on("elementMouseover.tooltip", function(e) {
e.pos = [ e.pos[0] + l.left, e.pos[1] + l.top ], N.tooltipShow(e);
}), t.dispatch.on("elementMouseout.tooltip", function(e) {
N.tooltipHide(e);
}), N.on("tooltipHide", function() {
S && n.tooltip.cleanup();
}), e.dispatch = N, e.legend = a, e.lines = t, e.lines2 = r, e.xAxis = i, e.yAxis = s, e.x2Axis = o, e.y2Axis = u, d3.rebind(e, t, "defined", "isArea", "size", "xDomain", "yDomain", "forceX", "forceY", "interactive", "clipEdge", "clipVoronoi", "id"), e.x = function(n) {
return arguments.length ? (t.x(n), r.x(n), e) : t.x;
}, e.y = function(n) {
return arguments.length ? (t.y(n), r.y(n), e) : t.y;
}, e.margin = function(t) {
return arguments.length ? (l.top = typeof t.top != "undefined" ? t.top : l.top, l.right = typeof t.right != "undefined" ? t.right : l.right, l.bottom = typeof t.bottom != "undefined" ? t.bottom : l.bottom, l.left = typeof t.left != "undefined" ? t.left : l.left, e) : l;
}, e.margin2 = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.width = function(t) {
return arguments.length ? (p = t, e) : p;
}, e.height = function(t) {
return arguments.length ? (d = t, e) : d;
}, e.height2 = function(t) {
return arguments.length ? (v = t, e) : v;
}, e.color = function(t) {
return arguments.length ? (h = n.utils.getColor(t), a.color(h), e) : h;
}, e.showLegend = function(t) {
return arguments.length ? (w = t, e) : w;
}, e.tooltips = function(t) {
return arguments.length ? (S = t, e) : S;
}, e.tooltipContent = function(t) {
return arguments.length ? (x = t, e) : x;
}, e.interpolate = function(n) {
return arguments.length ? (t.interpolate(n), r.interpolate(n), e) : t.interpolate();
}, e.noData = function(t) {
return arguments.length ? (T = t, e) : T;
}, e.xTickFormat = function(t) {
return arguments.length ? (i.tickFormat(t), o.tickFormat(t), e) : i.tickFormat();
}, e.yTickFormat = function(t) {
return arguments.length ? (s.tickFormat(t), u.tickFormat(t), e) : s.tickFormat();
}, e;
}, n.models.linePlusBarWithFocusChart = function() {
function e(n) {
return n.each(function(n) {
function C(e) {
var t = +(e == "e"), n = t ? 1 : -1, r = U / 3;
return "M" + .5 * n + "," + r + "A6,6 0 0 " + t + " " + 6.5 * n + "," + (r + 6) + "V" + (2 * r - 6) + "A6,6 0 0 " + t + " " + .5 * n + "," + 2 * r + "Z" + "M" + 2.5 * n + "," + (r + 8) + "V" + (2 * r - 8) + "M" + 4.5 * n + "," + (r + 8) + "V" + (2 * r - 8);
}
function B() {
p.empty() || p.extent(T), tt.data([ p.empty() ? L.domain() : T ]).each(function(e, t) {
var n = L(e[0]) - L.range()[0], r = L.range()[1] - L(e[1]);
d3.select(this).select(".left").attr("width", n < 0 ? 0 : n), d3.select(this).select(".right").attr("x", L(e[1])).attr("width", r < 0 ? 0 : r);
});
}
function j() {
T = p.empty() ? null : p.extent(), x = p.empty() ? L.domain() : p.extent(), P.brush({
extent: x,
brush: p
}), B(), i.width(q).height(R).color(n.map(function(e, t) {
return e.color || E(e, t);
}).filter(function(e, t) {
return !n[t].disabled && n[t].bar;
})), t.width(q).height(R).color(n.map(function(e, t) {
return e.color || E(e, t);
}).filter(function(e, t) {
return !n[t].disabled && !n[t].bar;
}));
var e = Q.select(".nv-focus .nv-barsWrap").datum(W.length ? W.map(function(e, t) {
return {
key: e.key,
values: e.values.filter(function(e, t) {
return i.x()(e, t) >= x[0] && i.x()(e, t) <= x[1];
})
};
}) : [ {
values: []
} ]), r = Q.select(".nv-focus .nv-linesWrap").datum(X[0].disabled ? [ {
values: []
} ] : X.map(function(e, n) {
return {
key: e.key,
values: e.values.filter(function(e, n) {
return t.x()(e, n) >= x[0] && t.x()(e, n) <= x[1];
})
};
}));
W.length ? k = i.xScale() : k = t.xScale(), o.scale(k).ticks(q / 100).tickSize(-R, 0), o.domain([ Math.ceil(x[0]), Math.floor(x[1]) ]), d3.transition(Q.select(".nv-x.nv-axis")).call(o), d3.transition(e).call(i), d3.transition(r).call(t), Q.select(".nv-focus .nv-x.nv-axis").attr("transform", "translate(0," + A.range()[0] + ")"), a.scale(A).ticks(R / 36).tickSize(-q, 0), Q.select(".nv-focus .nv-y1.nv-axis").style("opacity", W.length ? 1 : 0), f.scale(O).ticks(R / 36).tickSize(W.length ? 0 : -q, 0), Q.select(".nv-focus .nv-y2.nv-axis").style("opacity", X.length ? 1 : 0).attr("transform", "translate(" + k.range()[1] + ",0)"), d3.transition(Q.select(".nv-focus .nv-y1.nv-axis")).call(a), d3.transition(Q.select(".nv-focus .nv-y2.nv-axis")).call(f);
}
var F = d3.select(this), I = this, q = (m || parseInt(F.style("width")) || 960) - d.left - d.right, R = (g || parseInt(F.style("height")) || 400) - d.top - d.bottom - y, U = y - v.top - v.bottom;
e.update = function() {
F.transition().call(e);
}, e.container = this;
if (!n || !n.length || !n.filter(function(e) {
return e.values.length;
}).length) {
var z = F.selectAll(".nv-noData").data([ D ]);
return z.enter().append("text").attr("class", "nvd3 nv-noData").attr("dy", "-.7em").style("text-anchor", "middle"), z.attr("x", d.left + q / 2).attr("y", d.top + R / 2).text(function(e) {
return e;
}), e;
}
F.selectAll(".nv-noData").remove();
var W = n.filter(function(e) {
return !e.disabled && e.bar;
}), X = n.filter(function(e) {
return !e.bar;
});
k = i.xScale(), L = u.scale(), A = i.yScale(), O = t.yScale(), M = s.yScale(), _ = r.yScale();
var V = n.filter(function(e) {
return !e.disabled && e.bar;
}).map(function(e) {
return e.values.map(function(e, t) {
return {
x: b(e, t),
y: w(e, t)
};
});
}), $ = n.filter(function(e) {
return !e.disabled && !e.bar;
}).map(function(e) {
return e.values.map(function(e, t) {
return {
x: b(e, t),
y: w(e, t)
};
});
});
k.range([ 0, q ]), L.domain(d3.extent(d3.merge(V.concat($)), function(e) {
return e.x;
})).range([ 0, q ]);
var J = F.selectAll("g.nv-wrap.nv-linePlusBar").data([ n ]), K = J.enter().append("g").attr("class", "nvd3 nv-wrap nv-linePlusBar").append("g"), Q = J.select("g");
K.append("g").attr("class", "nv-legendWrap");
var G = K.append("g").attr("class", "nv-focus");
G.append("g").attr("class", "nv-x nv-axis"), G.append("g").attr("class", "nv-y1 nv-axis"), G.append("g").attr("class", "nv-y2 nv-axis"), G.append("g").attr("class", "nv-barsWrap"), G.append("g").attr("class", "nv-linesWrap");
var Y = K.append("g").attr("class", "nv-context");
Y.append("g").attr("class", "nv-x nv-axis"), Y.append("g").attr("class", "nv-y1 nv-axis"), Y.append("g").attr("class", "nv-y2 nv-axis"), Y.append("g").attr("class", "nv-barsWrap"), Y.append("g").attr("class", "nv-linesWrap"), Y.append("g").attr("class", "nv-brushBackground"), Y.append("g").attr("class", "nv-x nv-brush"), S && (h.width(q / 2), Q.select(".nv-legendWrap").datum(n.map(function(e) {
return e.originalKey = e.originalKey === undefined ? e.key : e.originalKey, e.key = e.originalKey + (e.bar ? " (left axis)" : " (right axis)"), e;
})).call(h), d.top != h.height() && (d.top = h.height(), R = (g || parseInt(F.style("height")) || 400) - d.top - d.bottom - y), Q.select(".nv-legendWrap").attr("transform", "translate(" + q / 2 + "," + -d.top + ")")), J.attr("transform", "translate(" + d.left + "," + d.top + ")"), s.width(q).height(U).color(n.map(function(e, t) {
return e.color || E(e, t);
}).filter(function(e, t) {
return !n[t].disabled && n[t].bar;
})), r.width(q).height(U).color(n.map(function(e, t) {
return e.color || E(e, t);
}).filter(function(e, t) {
return !n[t].disabled && !n[t].bar;
}));
var Z = Q.select(".nv-context .nv-barsWrap").datum(W.length ? W : [ {
values: []
} ]), et = Q.select(".nv-context .nv-linesWrap").datum(X[0].disabled ? [ {
values: []
} ] : X);
Q.select(".nv-context").attr("transform", "translate(0," + (R + d.bottom + v.top) + ")"), d3.transition(Z).call(s), d3.transition(et).call(r), p.x(L).on("brush", j), T && p.extent(T);
var tt = Q.select(".nv-brushBackground").selectAll("g").data([ T || p.extent() ]), nt = tt.enter().append("g");
nt.append("rect").attr("class", "left").attr("x", 0).attr("y", 0).attr("height", U), nt.append("rect").attr("class", "right").attr("x", 0).attr("y", 0).attr("height", U);
var rt = Q.select(".nv-x.nv-brush").call(p);
rt.selectAll("rect").attr("height", U), rt.selectAll(".resize").append("path").attr("d", C), u.ticks(q / 100).tickSize(-U, 0), Q.select(".nv-context .nv-x.nv-axis").attr("transform", "translate(0," + M.range()[0] + ")"), d3.transition(Q.select(".nv-context .nv-x.nv-axis")).call(u), l.scale(M).ticks(U / 36).tickSize(-q, 0), Q.select(".nv-context .nv-y1.nv-axis").style("opacity", W.length ? 1 : 0).attr("transform", "translate(0," + L.range()[0] + ")"), d3.transition(Q.select(".nv-context .nv-y1.nv-axis")).call(l), c.scale(_).ticks(U / 36).tickSize(W.length ? 0 : -q, 0), Q.select(".nv-context .nv-y2.nv-axis").style("opacity", X.length ? 1 : 0).attr("transform", "translate(" + L.range()[1] + ",0)"), d3.transition(Q.select(".nv-context .nv-y2.nv-axis")).call(c), h.dispatch.on("legendClick", function(t, r) {
t.disabled = !t.disabled, n.filter(function(e) {
return !e.disabled;
}).length || n.map(function(e) {
return e.disabled = !1, J.selectAll(".nv-series").classed("disabled", !1), e;
}), e.update();
}), P.on("tooltipShow", function(e) {
N && H(e, I.parentNode);
}), j();
}), e;
}
var t = n.models.line(), r = n.models.line(), i = n.models.historicalBar(), s = n.models.historicalBar(), o = n.models.axis(), u = n.models.axis(), a = n.models.axis(), f = n.models.axis(), l = n.models.axis(), c = n.models.axis(), h = n.models.legend(), p = d3.svg.brush(), d = {
top: 30,
right: 30,
bottom: 30,
left: 60
}, v = {
top: 0,
right: 30,
bottom: 20,
left: 60
}, m = null, g = null, y = 100, b = function(e) {
return e.x;
}, w = function(e) {
return e.y;
}, E = n.utils.defaultColor(), S = !0, x, T = null, N = !0, C = function(e, t, n, r, i) {
return "<h3>" + e + "</h3>" + "<p>" + n + " at " + t + "</p>";
}, k, L, A, O, M, _, D = "No Data Available.", P = d3.dispatch("tooltipShow", "tooltipHide", "brush");
t.clipEdge(!0), r.interactive(!1), o.orient("bottom").tickPadding(5), a.orient("left"), f.orient("right"), u.orient("bottom").tickPadding(5), l.orient("left"), c.orient("right");
var H = function(r, i) {
x && (r.pointIndex += Math.ceil(x[0]));
var s = r.pos[0] + (i.offsetLeft || 0), u = r.pos[1] + (i.offsetTop || 0), l = o.tickFormat()(t.x()(r.point, r.pointIndex)), c = (r.series.bar ? a : f).tickFormat()(t.y()(r.point, r.pointIndex)), h = C(r.series.key, l, c, r, e);
n.tooltip.show([ s, u ], h, r.value < 0 ? "n" : "s", null, i);
};
return t.dispatch.on("elementMouseover.tooltip", function(e) {
e.pos = [ e.pos[0] + d.left, e.pos[1] + d.top ], P.tooltipShow(e);
}), t.dispatch.on("elementMouseout.tooltip", function(e) {
P.tooltipHide(e);
}), i.dispatch.on("elementMouseover.tooltip", function(e) {
e.pos = [ e.pos[0] + d.left, e.pos[1] + d.top ], P.tooltipShow(e);
}), i.dispatch.on("elementMouseout.tooltip", function(e) {
P.tooltipHide(e);
}), P.on("tooltipHide", function() {
N && n.tooltip.cleanup();
}), e.dispatch = P, e.legend = h, e.lines = t, e.lines2 = r, e.bars = i, e.bars2 = s, e.xAxis = o, e.x2Axis = u, e.y1Axis = a, e.y2Axis = f, e.y3Axis = l, e.y4Axis = c, d3.rebind(e, t, "defined", "size", "clipVoronoi", "interpolate"), e.x = function(n) {
return arguments.length ? (b = n, t.x(n), i.x(n), e) : b;
}, e.y = function(n) {
return arguments.length ? (w = n, t.y(n), i.y(n), e) : w;
}, e.margin = function(t) {
return arguments.length ? (d.top = typeof t.top != "undefined" ? t.top : d.top, d.right = typeof t.right != "undefined" ? t.right : d.right, d.bottom = typeof t.bottom != "undefined" ? t.bottom : d.bottom, d.left = typeof t.left != "undefined" ? t.left : d.left, e) : d;
}, e.width = function(t) {
return arguments.length ? (m = t, e) : m;
}, e.height = function(t) {
return arguments.length ? (g = t, e) : g;
}, e.color = function(t) {
return arguments.length ? (E = n.utils.getColor(t), h.color(E), e) : E;
}, e.showLegend = function(t) {
return arguments.length ? (S = t, e) : S;
}, e.tooltips = function(t) {
return arguments.length ? (N = t, e) : N;
}, e.tooltipContent = function(t) {
return arguments.length ? (C = t, e) : C;
}, e.noData = function(t) {
return arguments.length ? (D = t, e) : D;
}, e.brushExtent = function(t) {
return arguments.length ? (T = t, e) : T;
}, e;
}, n.models.multiBar = function() {
function e(n) {
return n.each(function(e) {
var n = r - t.left - t.right, T = i - t.top - t.bottom, N = d3.select(this);
d && e.length && (d = [ {
values: e[0].values.map(function(e) {
return {
x: e.x,
y: 0,
series: e.series,
size: .01
};
})
} ]), h && (e = d3.layout.stack().offset("zero").values(function(e) {
return e.values;
}).y(f)(!e.length && d ? d : e)), e = e.map(function(e, t) {
return e.values = e.values.map(function(e) {
return e.series = t, e;
}), e;
}), h && e[0].values.map(function(t, n) {
var r = 0, i = 0;
e.map(function(e) {
var t = e.values[n];
t.size = Math.abs(t.y), t.y < 0 ? (t.y1 = i, i -= t.size) : (t.y1 = t.size + r, r += t.size);
});
});
var C = b && w ? [] : e.map(function(e) {
return e.values.map(function(e, t) {
return {
x: a(e, t),
y: f(e, t),
y0: e.y0,
y1: e.y1
};
});
});
s.domain(d3.merge(C).map(function(e) {
return e.x;
})).rangeBands([ 0, n ], .1), o.domain(w || d3.extent(d3.merge(C).map(function(e) {
return h ? e.y > 0 ? e.y1 : e.y1 + e.y : e.y;
}).concat(l))).range([ T, 0 ]);
if (s.domain()[0] === s.domain()[1] || o.domain()[0] === o.domain()[1]) singlePoint = !0;
s.domain()[0] === s.domain()[1] && (s.domain()[0] ? s.domain([ s.domain()[0] - s.domain()[0] * .01, s.domain()[1] + s.domain()[1] * .01 ]) : s.domain([ -1, 1 ])), o.domain()[0] === o.domain()[1] && (o.domain()[0] ? o.domain([ o.domain()[0] + o.domain()[0] * .01, o.domain()[1] - o.domain()[1] * .01 ]) : o.domain([ -1, 1 ])), S = S || s, x = x || o;
var k = N.selectAll("g.nv-wrap.nv-multibar").data([ e ]), L = k.enter().append("g").attr("class", "nvd3 nv-wrap nv-multibar"), A = L.append("defs"), O = L.append("g"), M = k.select("g");
O.append("g").attr("class", "nv-groups"), k.attr("transform", "translate(" + t.left + "," + t.top + ")"), A.append("clipPath").attr("id", "nv-edge-clip-" + u).append("rect"), k.select("#nv-edge-clip-" + u + " rect").attr("width", n).attr("height", T), M.attr("clip-path", c ? "url(#nv-edge-clip-" + u + ")" : "");
var _ = k.select(".nv-groups").selectAll(".nv-group").data(function(e) {
return e;
}, function(e) {
return e.key;
});
_.enter().append("g").style("stroke-opacity", 1e-6).style("fill-opacity", 1e-6), _.exit().selectAll("rect.nv-bar").transition().delay(function(t, n) {
return n * g / e[0].values.length;
}).attr("y", function(e) {
return h ? x(e.y0) : x(0);
}).attr("height", 0).remove(), _.attr("class", function(e, t) {
return "nv-group nv-series-" + t;
}).classed("hover", function(e) {
return e.hover;
}).style("fill", function(e, t) {
return p(e, t);
}).style("stroke", function(e, t) {
return p(e, t);
}), d3.transition(_).style("stroke-opacity", 1).style("fill-opacity", .75);
var D = _.selectAll("rect.nv-bar").data(function(t) {
return d && !e.length ? d.values : t.values;
});
D.exit().remove();
var P = D.enter().append("rect").attr("class", function(e, t) {
return f(e, t) < 0 ? "nv-bar negative" : "nv-bar positive";
}).attr("x", function(t, n, r) {
return h ? 0 : r * s.rangeBand() / e.length;
}).attr("y", function(e) {
return x(h ? e.y0 : 0);
}).attr("height", 0).attr("width", s.rangeBand() / (h ? 1 : e.length));
D.style("fill", function(e, t, n) {
return p(e, n, t);
}).style("stroke", function(e, t, n) {
return p(e, n, t);
}).on("mouseover", function(t, n) {
d3.select(this).classed("hover", !0), E.elementMouseover({
value: f(t, n),
point: t,
series: e[t.series],
pos: [ s(a(t, n)) + s.rangeBand() * (h ? e.length / 2 : t.series + .5) / e.length, o(f(t, n) + (h ? t.y0 : 0)) ],
pointIndex: n,
seriesIndex: t.series,
e: d3.event
});
}).on("mouseout", function(t, n) {
d3.select(this).classed("hover", !1), E.elementMouseout({
value: f(t, n),
point: t,
series: e[t.series],
pointIndex: n,
seriesIndex: t.series,
e: d3.event
});
}).on("click", function(t, n) {
E.elementClick({
value: f(t, n),
point: t,
series: e[t.series],
pos: [ s(a(t, n)) + s.rangeBand() * (h ? e.length / 2 : t.series + .5) / e.length, o(f(t, n) + (h ? t.y0 : 0)) ],
pointIndex: n,
seriesIndex: t.series,
e: d3.event
}), d3.event.stopPropagation();
}).on("dblclick", function(t, n) {
E.elementDblClick({
value: f(t, n),
point: t,
series: e[t.series],
pos: [ s(a(t, n)) + s.rangeBand() * (h ? e.length / 2 : t.series + .5) / e.length, o(f(t, n) + (h ? t.y0 : 0)) ],
pointIndex: n,
seriesIndex: t.series,
e: d3.event
}), d3.event.stopPropagation();
}), D.attr("class", function(e, t) {
return f(e, t) < 0 ? "nv-bar negative" : "nv-bar positive";
}).attr("transform", function(e, t) {
return "translate(" + s(a(e, t)) + ",0)";
}), v && (m || (m = e.map(function() {
return !0;
})), D.style("fill", function(e, t, n) {
return d3.rgb(v(e, t)).darker(m.map(function(e, t) {
return t;
}).filter(function(e, t) {
return !m[t];
})[n]).toString();
}).style("stroke", function(e, t, n) {
return d3.rgb(v(e, t)).darker(m.map(function(e, t) {
return t;
}).filter(function(e, t) {
return !m[t];
})[n]).toString();
})), h ? D.transition().delay(function(t, n) {
return n * g / e[0].values.length;
}).attr("y", function(e, t) {
return o(h ? e.y1 : 0);
}).attr("height", function(e, t) {
return Math.max(Math.abs(o(e.y + (h ? e.y0 : 0)) - o(h ? e.y0 : 0)), 1);
}).each("end", function() {
d3.select(this).transition().duration(y).attr("x", function(t, n) {
return h ? 0 : t.series * s.rangeBand() / e.length;
}).attr("width", s.rangeBand() / (h ? 1 : e.length));
}) : d3.transition(D).duration(y).delay(function(t, n) {
return n * g / e[0].values.length;
}).attr("x", function(t, n) {
return t.series * s.rangeBand() / e.length;
}).attr("width", s.rangeBand() / e.length).each("end", function() {
d3.select(this).transition().duration(y).attr("y", function(e, t) {
return f(e, t) < 0 ? o(0) : o(0) - o(f(e, t)) < 1 ? o(0) - 1 : o(f(e, t)) || 0;
}).attr("height", function(e, t) {
return Math.max(Math.abs(o(f(e, t)) - o(0)), 1) || 0;
});
}), S = s.copy(), x = o.copy();
}), e;
}
var t = {
top: 0,
right: 0,
bottom: 0,
left: 0
}, r = 960, i = 500, s = d3.scale.ordinal(), o = d3.scale.linear(), u = Math.floor(Math.random() * 1e4), a = function(e) {
return e.x;
}, f = function(e) {
return e.y;
}, l = [ 0 ], c = !0, h = !1, p = n.utils.defaultColor(), d = !1, v = null, m, g = 1200, y = 500, b, w, E = d3.dispatch("chartClick", "elementClick", "elementDblClick", "elementMouseover", "elementMouseout"), S, x;
return e.dispatch = E, e.x = function(t) {
return arguments.length ? (a = t, e) : a;
}, e.y = function(t) {
return arguments.length ? (f = t, e) : f;
}, e.margin = function(n) {
return arguments.length ? (t.top = typeof n.top != "undefined" ? n.top : t.top, t.right = typeof n.right != "undefined" ? n.right : t.right, t.bottom = typeof n.bottom != "undefined" ? n.bottom : t.bottom, t.left = typeof n.left != "undefined" ? n.left : t.left, e) : t;
}, e.width = function(t) {
return arguments.length ? (r = t, e) : r;
}, e.height = function(t) {
return arguments.length ? (i = t, e) : i;
}, e.xScale = function(t) {
return arguments.length ? (s = t, e) : s;
}, e.yScale = function(t) {
return arguments.length ? (o = t, e) : o;
}, e.xDomain = function(t) {
return arguments.length ? (b = t, e) : b;
}, e.yDomain = function(t) {
return arguments.length ? (w = t, e) : w;
}, e.forceY = function(t) {
return arguments.length ? (l = t, e) : l;
}, e.stacked = function(t) {
return arguments.length ? (h = t, e) : h;
}, e.clipEdge = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.color = function(t) {
return arguments.length ? (p = n.utils.getColor(t), e) : p;
}, e.barColor = function(t) {
return arguments.length ? (v = n.utils.getColor(t), e) : v;
}, e.disabled = function(t) {
return arguments.length ? (m = t, e) : m;
}, e.id = function(t) {
return arguments.length ? (u = t, e) : u;
}, e.hideable = function(t) {
return arguments.length ? (d = t, e) : d;
}, e.delay = function(t) {
return arguments.length ? (g = t, e) : g;
}, e.drawTime = function(t) {
return arguments.length ? (y = t, e) : y;
}, e;
}, n.models.multiBarChart = function() {
function e(n) {
return n.each(function(n) {
var g = d3.select(this), C = this, k = (a || parseInt(g.style("width")) || 960) - u.left - u.right, L = (f || parseInt(g.style("height")) || 400) - u.top - u.bottom;
e.update = function() {
g.transition().call(e);
}, e.container = this, w.disabled = n.map(function(e) {
return !!e.disabled;
});
if (!E) {
var A;
E = {};
for (A in w) w[A] instanceof Array ? E[A] = w[A].slice(0) : E[A] = w[A];
}
if (!n || !n.length || !n.filter(function(e) {
return e.values.length;
}).length) {
var O = g.selectAll(".nv-noData").data([ S ]);
return O.enter().append("text").attr("class", "nvd3 nv-noData").attr("dy", "-.7em").style("text-anchor", "middle"), O.attr("x", u.left + k / 2).attr("y", u.top + L / 2).text(function(e) {
return e;
}), e;
}
g.selectAll(".nv-noData").remove(), y = t.xScale(), b = t.yScale();
var M = g.selectAll("g.nv-wrap.nv-multiBarWithLegend").data([ n ]), _ = M.enter().append("g").attr("class", "nvd3 nv-wrap nv-multiBarWithLegend").append("g"), D = M.select("g");
_.append("g").attr("class", "nv-x nv-axis"), _.append("g").attr("class", "nv-y nv-axis"), _.append("g").attr("class", "nv-barsWrap"), _.append("g").attr("class", "nv-legendWrap"), _.append("g").attr("class", "nv-controlsWrap"), h && (s.width(k - T()), t.barColor() && n.forEach(function(e, t) {
e.color = d3.rgb("#ccc").darker(t * 1.5).toString();
}), D.select(".nv-legendWrap").datum(n).call(s), u.top != s.height() && (u.top = s.height(), L = (f || parseInt(g.style("height")) || 400) - u.top - u.bottom), D.select(".nv-legendWrap").attr("transform", "translate(" + T() + "," + -u.top + ")"));
if (c) {
var P = [ {
key: "Grouped",
disabled: t.stacked()
}, {
key: "Stacked",
disabled: !t.stacked()
} ];
o.width(T()).color([ "#444", "#444", "#444" ]), D.select(".nv-controlsWrap").datum(P).attr("transform", "translate(0," + -u.top + ")").call(o);
}
M.attr("transform", "translate(" + u.left + "," + u.top + ")"), t.disabled(n.map(function(e) {
return e.disabled;
})).width(k).height(L).color(n.map(function(e, t) {
return e.color || l(e, t);
}).filter(function(e, t) {
return !n[t].disabled;
}));
var H = D.select(".nv-barsWrap").datum(n.filter(function(e) {
return !e.disabled;
}));
d3.transition(H).call(t), r.scale(y).ticks(k / 100).tickSize(-L, 0), D.select(".nv-x.nv-axis").attr("transform", "translate(0," + b.range()[0] + ")"), d3.transition(D.select(".nv-x.nv-axis")).call(r);
var B = D.select(".nv-x.nv-axis > g").selectAll("g");
B.selectAll("line, text").style("opacity", 1);
if (d) {
var j = function(e, t) {
return "translate(" + e + "," + t + ")";
}, F = 5, I = 17;
B.selectAll("text").attr("transform", function(e, t, n) {
return j(0, n % 2 == 0 ? F : I);
});
var q = d3.selectAll(".nv-x.nv-axis .nv-wrap g g text")[0].length;
D.selectAll(".nv-x.nv-axis .nv-axisMaxMin text").attr("transform", function(e, t) {
return j(0, t === 0 || q % 2 !== 0 ? I : F);
});
}
p && B.filter(function(e, t) {
return t % Math.ceil(n[0].values.length / (k / 100)) !== 0;
}).selectAll("text, line").style("opacity", 0), v && B.selectAll("text").attr("transform", "rotate(" + v + " 0,0)").attr("text-anchor", v > 0 ? "start" : "end"), D.select(".nv-x.nv-axis").selectAll("g.nv-axisMaxMin text").style("opacity", 1), i.scale(b).ticks(L / 36).tickSize(-k, 0), d3.transition(D.select(".nv-y.nv-axis")).call(i), s.dispatch.on("legendClick", function(t, r) {
t.disabled = !t.disabled, n.filter(function(e) {
return !e.disabled;
}).length || n.map(function(e) {
return e.disabled = !1, M.selectAll(".nv-series").classed("disabled", !1), e;
}), w.disabled = n.map(function(e) {
return !!e.disabled;
}), x.stateChange(w), e.update();
}), s.dispatch.on("legendDblclick", function(t) {
n.forEach(function(e) {
e.disabled = !0;
}), t.disabled = !1, w.disabled = n.map(function(e) {
return !!e.disabled;
}), x.stateChange(w), e.update();
}), o.dispatch.on("legendClick", function(n, r) {
if (!n.disabled) return;
P = P.map(function(e) {
return e.disabled = !0, e;
}), n.disabled = !1;
switch (n.key) {
case "Grouped":
t.stacked(!1);
break;
case "Stacked":
t.stacked(!0);
}
w.stacked = t.stacked(), x.stateChange(w), e.update();
}), x.on("tooltipShow", function(e) {
m && N(e, C.parentNode);
}), x.on("changeState", function(r) {
typeof r.disabled != "undefined" && (n.forEach(function(e, t) {
e.disabled = r.disabled[t];
}), w.disabled = r.disabled), typeof r.stacked != "undefined" && (t.stacked(r.stacked), w.stacked = r.stacked), e.update();
});
}), e;
}
var t = n.models.multiBar(), r = n.models.axis(), i = n.models.axis(), s = n.models.legend(), o = n.models.legend(), u = {
top: 30,
right: 20,
bottom: 50,
left: 60
}, a = null, f = null, l = n.utils.defaultColor(), c = !0, h = !0, p = !0, d = !1, v = 0, m = !0, g = function(e, t, n, r, i) {
return "<h3>" + e + "</h3>" + "<p>" + n + " on " + t + "</p>";
}, y, b, w = {
stacked: !1
}, E = null, S = "No Data Available.", x = d3.dispatch("tooltipShow", "tooltipHide", "stateChange", "changeState"), T = function() {
return c ? 180 : 0;
};
t.stacked(!1), r.orient("bottom").tickPadding(7).highlightZero(!0).showMaxMin(!1).tickFormat(function(e) {
return e;
}), i.orient("left").tickFormat(d3.format(",.1f"));
var N = function(s, o) {
var u = s.pos[0] + (o.offsetLeft || 0), a = s.pos[1] + (o.offsetTop || 0), f = r.tickFormat()(t.x()(s.point, s.pointIndex)), l = i.tickFormat()(t.y()(s.point, s.pointIndex)), c = g(s.series.key, f, l, s, e);
n.tooltip.show([ u, a ], c, s.value < 0 ? "n" : "s", null, o);
};
return t.dispatch.on("elementMouseover.tooltip", function(e) {
e.pos = [ e.pos[0] + u.left, e.pos[1] + u.top ], x.tooltipShow(e);
}), t.dispatch.on("elementMouseout.tooltip", function(e) {
x.tooltipHide(e);
}), x.on("tooltipHide", function() {
m && n.tooltip.cleanup();
}), e.dispatch = x, e.multibar = t, e.legend = s, e.xAxis = r, e.yAxis = i, d3.rebind(e, t, "x", "y", "xDomain", "yDomain", "forceX", "forceY", "clipEdge", "id", "stacked", "delay", "barColor"), e.margin = function(t) {
return arguments.length ? (u.top = typeof t.top != "undefined" ? t.top : u.top, u.right = typeof t.right != "undefined" ? t.right : u.right, u.bottom = typeof t.bottom != "undefined" ? t.bottom : u.bottom, u.left = typeof t.left != "undefined" ? t.left : u.left, e) : u;
}, e.width = function(t) {
return arguments.length ? (a = t, e) : a;
}, e.height = function(t) {
return arguments.length ? (f = t, e) : f;
}, e.color = function(t) {
return arguments.length ? (l = n.utils.getColor(t), s.color(l), e) : l;
}, e.showControls = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.showLegend = function(t) {
return arguments.length ? (h = t, e) : h;
}, e.reduceXTicks = function(t) {
return arguments.length ? (p = t, e) : p;
}, e.rotateLabels = function(t) {
return arguments.length ? (v = t, e) : v;
}, e.staggerLabels = function(t) {
return arguments.length ? (d = t, e) : d;
}, e.tooltip = function(t) {
return arguments.length ? (g = t, e) : g;
}, e.tooltips = function(t) {
return arguments.length ? (m = t, e) : m;
}, e.tooltipContent = function(t) {
return arguments.length ? (g = t, e) : g;
}, e.state = function(t) {
return arguments.length ? (w = t, e) : w;
}, e.defaultState = function(t) {
return arguments.length ? (E = t, e) : E;
}, e.noData = function(t) {
return arguments.length ? (S = t, e) : S;
}, e;
}, n.models.multiBarHorizontal = function() {
function e(n) {
return n.each(function(e) {
var n = r - t.left - t.right, s = i - t.top - t.bottom, y = d3.select(this);
d && (e = d3.layout.stack().offset("zero").values(function(e) {
return e.values;
}).y(f)(e)), e = e.map(function(e, t) {
return e.values = e.values.map(function(e) {
return e.series = t, e;
}), e;
}), d && e[0].values.map(function(t, n) {
var r = 0, i = 0;
e.map(function(e) {
var t = e.values[n];
t.size = Math.abs(t.y), t.y < 0 ? (t.y1 = i - t.size, i -= t.size) : (t.y1 = r, r += t.size);
});
});
var T = b && w ? [] : e.map(function(e) {
return e.values.map(function(e, t) {
return {
x: a(e, t),
y: f(e, t),
y0: e.y0,
y1: e.y1
};
});
});
o.domain(b || d3.merge(T).map(function(e) {
return e.x;
})).rangeBands([ 0, s ], .1), u.domain(w || d3.extent(d3.merge(T).map(function(e) {
return d ? e.y > 0 ? e.y1 + e.y : e.y1 : e.y;
}).concat(l))), v && !d ? u.range([ u.domain()[0] < 0 ? m : 0, n - (u.domain()[1] > 0 ? m : 0) ]) : u.range([ 0, n ]), S = S || o, x = x || d3.scale.linear().domain(u.domain()).range([ u(0), u(0) ]);
var N = d3.select(this).selectAll("g.nv-wrap.nv-multibarHorizontal").data([ e ]), C = N.enter().append("g").attr("class", "nvd3 nv-wrap nv-multibarHorizontal"), k = C.append("defs"), L = C.append("g"), A = N.select("g");
L.append("g").attr("class", "nv-groups"), N.attr("transform", "translate(" + t.left + "," + t.top + ")");
var O = N.select(".nv-groups").selectAll(".nv-group").data(function(e) {
return e;
}, function(e) {
return e.key;
});
O.enter().append("g").style("stroke-opacity", 1e-6).style("fill-opacity", 1e-6), d3.transition(O.exit()).style("stroke-opacity", 1e-6).style("fill-opacity", 1e-6).remove(), O.attr("class", function(e, t) {
return "nv-group nv-series-" + t;
}).classed("hover", function(e) {
return e.hover;
}).style("fill", function(e, t) {
return c(e, t);
}).style("stroke", function(e, t) {
return c(e, t);
}), d3.transition(O).style("stroke-opacity", 1).style("fill-opacity", .75);
var M = O.selectAll("g.nv-bar").data(function(e) {
return e.values;
});
M.exit().remove();
var _ = M.enter().append("g").attr("transform", function(t, n, r) {
return "translate(" + x(d ? t.y0 : 0) + "," + (d ? 0 : r * o.rangeBand() / e.length + o(a(t, n))) + ")";
});
_.append("rect").attr("width", 0).attr("height", o.rangeBand() / (d ? 1 : e.length)), M.on("mouseover", function(t, n) {
d3.select(this).classed("hover", !0), E.elementMouseover({
value: f(t, n),
point: t,
series: e[t.series],
pos: [ u(f(t, n) + (d ? t.y0 : 0)), o(a(t, n)) + o.rangeBand() * (d ? e.length / 2 : t.series + .5) / e.length ],
pointIndex: n,
seriesIndex: t.series,
e: d3.event
});
}).on("mouseout", function(t, n) {
d3.select(this).classed("hover", !1), E.elementMouseout({
value: f(t, n),
point: t,
series: e[t.series],
pointIndex: n,
seriesIndex: t.series,
e: d3.event
});
}).on("click", function(t, n) {
E.elementClick({
value: f(t, n),
point: t,
series: e[t.series],
pos: [ o(a(t, n)) + o.rangeBand() * (d ? e.length / 2 : t.series + .5) / e.length, u(f(t, n) + (d ? t.y0 : 0)) ],
pointIndex: n,
seriesIndex: t.series,
e: d3.event
}), d3.event.stopPropagation();
}).on("dblclick", function(t, n) {
E.elementDblClick({
value: f(t, n),
point: t,
series: e[t.series],
pos: [ o(a(t, n)) + o.rangeBand() * (d ? e.length / 2 : t.series + .5) / e.length, u(f(t, n) + (d ? t.y0 : 0)) ],
pointIndex: n,
seriesIndex: t.series,
e: d3.event
}), d3.event.stopPropagation();
}), _.append("text"), v && !d ? (M.select("text").attr("text-anchor", function(e, t) {
return f(e, t) < 0 ? "end" : "start";
}).attr("y", o.rangeBand() / (e.length * 2)).attr("dy", ".32em").text(function(e, t) {
return g(f(e, t));
}), d3.transition(M).select("text").attr("x", function(e, t) {
return f(e, t) < 0 ? -4 : u(f(e, t)) - u(0) + 4;
})) : M.selectAll("text").text(""), M.attr("class", function(e, t) {
return f(e, t) < 0 ? "nv-bar negative" : "nv-bar positive";
}), h && (p || (p = e.map(function() {
return !0;
})), M.style("fill", function(e, t, n) {
return d3.rgb(h(e, t)).darker(p.map(function(e, t) {
return t;
}).filter(function(e, t) {
return !p[t];
})[n]).toString();
}).style("stroke", function(e, t, n) {
return d3.rgb(h(e, t)).darker(p.map(function(e, t) {
return t;
}).filter(function(e, t) {
return !p[t];
})[n]).toString();
})), d ? d3.transition(M).attr("transform", function(e, t) {
return "translate(" + u(e.y1) + "," + o(a(e, t)) + ")";
}).select("rect").attr("width", function(e, t) {
return Math.abs(u(f(e, t) + e.y0) - u(e.y0));
}).attr("height", o.rangeBand()) : d3.transition(M).attr("transform", function(t, n) {
return "translate(" + (f(t, n) < 0 ? u(f(t, n)) : u(0)) + "," + (t.series * o.rangeBand() / e.length + o(a(t, n))) + ")";
}).select("rect").attr("height", o.rangeBand() / e.length).attr("width", function(e, t) {
return Math.max(Math.abs(u(f(e, t)) - u(0)), 1);
}), S = o.copy(), x = u.copy();
}), e;
}
var t = {
top: 0,
right: 0,
bottom: 0,
left: 0
}, r = 960, i = 500, s = Math.floor(Math.random() * 1e4), o = d3.scale.ordinal(), u = d3.scale.linear(), a = function(e) {
return e.x;
}, f = function(e) {
return e.y;
}, l = [ 0 ], c = n.utils.defaultColor(), h = null, p, d = !1, v = !1, m = 60, g = d3.format(",.2f"), y = 1200, b, w, E = d3.dispatch("chartClick", "elementClick", "elementDblClick", "elementMouseover", "elementMouseout"), S, x;
return e.dispatch = E, e.x = function(t) {
return arguments.length ? (a = t, e) : a;
}, e.y = function(t) {
return arguments.length ? (f = t, e) : f;
}, e.margin = function(n) {
return arguments.length ? (t.top = typeof n.top != "undefined" ? n.top : t.top, t.right = typeof n.right != "undefined" ? n.right : t.right, t.bottom = typeof n.bottom != "undefined" ? n.bottom : t.bottom, t.left = typeof n.left != "undefined" ? n.left : t.left, e) : t;
}, e.width = function(t) {
return arguments.length ? (r = t, e) : r;
}, e.height = function(t) {
return arguments.length ? (i = t, e) : i;
}, e.xScale = function(t) {
return arguments.length ? (o = t, e) : o;
}, e.yScale = function(t) {
return arguments.length ? (u = t, e) : u;
}, e.xDomain = function(t) {
return arguments.length ? (b = t, e) : b;
}, e.yDomain = function(t) {
return arguments.length ? (w = t, e) : w;
}, e.forceY = function(t) {
return arguments.length ? (l = t, e) : l;
}, e.stacked = function(t) {
return arguments.length ? (d = t, e) : d;
}, e.color = function(t) {
return arguments.length ? (c = n.utils.getColor(t), e) : c;
}, e.barColor = function(t) {
return arguments.length ? (h = n.utils.getColor(t), e) : h;
}, e.disabled = function(t) {
return arguments.length ? (p = t, e) : p;
}, e.id = function(t) {
return arguments.length ? (s = t, e) : s;
}, e.delay = function(t) {
return arguments.length ? (y = t, e) : y;
}, e.showValues = function(t) {
return arguments.length ? (v = t, e) : v;
}, e.valueFormat = function(t) {
return arguments.length ? (g = t, e) : g;
}, e.valuePadding = function(t) {
return arguments.length ? (m = t, e) : m;
}, e;
}, n.models.multiBarHorizontalChart = function() {
function e(n) {
return n.each(function(p) {
var v = d3.select(this), T = this, N = (a || parseInt(v.style("width")) || 960) - u.left - u.right, C = (f || parseInt(v.style("height")) || 400) - u.top - u.bottom;
e.update = function() {
v.transition().call(e);
}, e.container = this, y.disabled = p.map(function(e) {
return !!e.disabled;
});
if (!b) {
var k;
b = {};
for (k in y) y[k] instanceof Array ? b[k] = y[k].slice(0) : b[k] = y[k];
}
if (!p || !p.length || !p.filter(function(e) {
return e.values.length;
}).length) {
var L = v.selectAll(".nv-noData").data([ w ]);
return L.enter().append("text").attr("class", "nvd3 nv-noData").attr("dy", "-.7em").style("text-anchor", "middle"), L.attr("x", u.left + N / 2).attr("y", u.top + C / 2).text(function(e) {
return e;
}), e;
}
v.selectAll(".nv-noData").remove(), m = t.xScale(), g = t.yScale();
var A = v.selectAll("g.nv-wrap.nv-multiBarHorizontalChart").data([ p ]), O = A.enter().append("g").attr("class", "nvd3 nv-wrap nv-multiBarHorizontalChart").append("g"), M = A.select("g");
O.append("g").attr("class", "nv-x nv-axis"), O.append("g").attr("class", "nv-y nv-axis"), O.append("g").attr("class", "nv-barsWrap"), O.append("g").attr("class", "nv-legendWrap"), O.append("g").attr("class", "nv-controlsWrap"), h && (s.width(N - S()), t.barColor() && p.forEach(function(e, t) {
e.color = d3.rgb("#ccc").darker(t * 1.5).toString();
}), M.select(".nv-legendWrap").datum(p).call(s), u.top != s.height() && (u.top = s.height(), C = (f || parseInt(v.style("height")) || 400) - u.top - u.bottom), M.select(".nv-legendWrap").attr("transform", "translate(" + S() + "," + -u.top + ")"));
if (c) {
var _ = [ {
key: "Grouped",
disabled: t.stacked()
}, {
key: "Stacked",
disabled: !t.stacked()
} ];
o.width(S()).color([ "#444", "#444", "#444" ]), M.select(".nv-controlsWrap").datum(_).attr("transform", "translate(0," + -u.top + ")").call(o);
}
A.attr("transform", "translate(" + u.left + "," + u.top + ")"), t.disabled(p.map(function(e) {
return e.disabled;
})).width(N).height(C).color(p.map(function(e, t) {
return e.color || l(e, t);
}).filter(function(e, t) {
return !p[t].disabled;
}));
var D = M.select(".nv-barsWrap").datum(p.filter(function(e) {
return !e.disabled;
}));
d3.transition(D).call(t), r.scale(m).ticks(C / 24).tickSize(-N, 0), d3.transition(M.select(".nv-x.nv-axis")).call(r);
var P = M.select(".nv-x.nv-axis").selectAll("g");
P.selectAll("line, text").style("opacity", 1), i.scale(g).ticks(N / 100).tickSize(-C, 0), M.select(".nv-y.nv-axis").attr("transform", "translate(0," + C + ")"), d3.transition(M.select(".nv-y.nv-axis")).call(i), s.dispatch.on("legendClick", function(t, n) {
t.disabled = !t.disabled, p.filter(function(e) {
return !e.disabled;
}).length || p.map(function(e) {
return e.disabled = !1, A.selectAll(".nv-series").classed("disabled", !1), e;
}), y.disabled = p.map(function(e) {
return !!e.disabled;
}), E.stateChange(y), e.update();
}), s.dispatch.on("legendDblclick", function(t) {
p.forEach(function(e) {
e.disabled = !0;
}), t.disabled = !1, y.disabled = p.map(function(e) {
return !!e.disabled;
}), E.stateChange(y), e.update();
}), o.dispatch.on("legendClick", function(n, r) {
if (!n.disabled) return;
_ = _.map(function(e) {
return e.disabled = !0, e;
}), n.disabled = !1;
switch (n.key) {
case "Grouped":
t.stacked(!1);
break;
case "Stacked":
t.stacked(!0);
}
y.stacked = t.stacked(), E.stateChange(y), e.update();
}), E.on("tooltipShow", function(e) {
d && x(e, T.parentNode);
}), E.on("changeState", function(r) {
typeof r.disabled != "undefined" && (p.forEach(function(e, t) {
e.disabled = r.disabled[t];
}), y.disabled = r.disabled), typeof r.stacked != "undefined" && (t.stacked(r.stacked), y.stacked = r.stacked), n.call(e);
});
}), e;
}
var t = n.models.multiBarHorizontal(), r = n.models.axis(), i = n.models.axis(), s = n.models.legend().height(30), o = n.models.legend().height(30), u = {
top: 30,
right: 20,
bottom: 50,
left: 60
}, a = null, f = null, l = n.utils.defaultColor(), c = !0, h = !0, p = !1, d = !0, v = function(e, t, n, r, i) {
return "<h3>" + e + " - " + t + "</h3>" + "<p>" + n + "</p>";
}, m, g, y = {
stacked: p
}, b = null, w = "No Data Available.", E = d3.dispatch("tooltipShow", "tooltipHide", "stateChange", "changeState"), S = function() {
return c ? 180 : 0;
};
t.stacked(p), r.orient("left").tickPadding(5).highlightZero(!1).showMaxMin(!1).tickFormat(function(e) {
return e;
}), i.orient("bottom").tickFormat(d3.format(",.1f"));
var x = function(s, o) {
var u = s.pos[0] + (o.offsetLeft || 0), a = s.pos[1] + (o.offsetTop || 0), f = r.tickFormat()(t.x()(s.point, s.pointIndex)), l = i.tickFormat()(t.y()(s.point, s.pointIndex)), c = v(s.series.key, f, l, s, e);
n.tooltip.show([ u, a ], c, s.value < 0 ? "e" : "w", null, o);
};
return t.dispatch.on("elementMouseover.tooltip", function(e) {
e.pos = [ e.pos[0] + u.left, e.pos[1] + u.top ], E.tooltipShow(e);
}), t.dispatch.on("elementMouseout.tooltip", function(e) {
E.tooltipHide(e);
}), E.on("tooltipHide", function() {
d && n.tooltip.cleanup();
}), e.dispatch = E, e.multibar = t, e.legend = s, e.xAxis = r, e.yAxis = i, d3.rebind(e, t, "x", "y", "xDomain", "yDomain", "forceX", "forceY", "clipEdge", "id", "delay", "showValues", "valueFormat", "stacked", "barColor"), e.margin = function(t) {
return arguments.length ? (u.top = typeof t.top != "undefined" ? t.top : u.top, u.right = typeof t.right != "undefined" ? t.right : u.right, u.bottom = typeof t.bottom != "undefined" ? t.bottom : u.bottom, u.left = typeof t.left != "undefined" ? t.left : u.left, e) : u;
}, e.width = function(t) {
return arguments.length ? (a = t, e) : a;
}, e.height = function(t) {
return arguments.length ? (f = t, e) : f;
}, e.color = function(t) {
return arguments.length ? (l = n.utils.getColor(t), s.color(l), e) : l;
}, e.showControls = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.showLegend = function(t) {
return arguments.length ? (h = t, e) : h;
}, e.tooltip = function(t) {
return arguments.length ? (v = t, e) : v;
}, e.tooltips = function(t) {
return arguments.length ? (d = t, e) : d;
}, e.tooltipContent = function(t) {
return arguments.length ? (v = t, e) : v;
}, e.state = function(t) {
return arguments.length ? (y = t, e) : y;
}, e.defaultState = function(t) {
return arguments.length ? (b = t, e) : b;
}, e.noData = function(t) {
return arguments.length ? (w = t, e) : w;
}, e;
}, n.models.multiChart = function() {
function e(n) {
return n.each(function(n) {
var a = d3.select(this), l = this;
e.update = function() {
a.transition().call(e);
}, e.container = this;
var N = (i || parseInt(a.style("width")) || 960) - t.left - t.right, C = (s || parseInt(a.style("height")) || 400) - t.top - t.bottom, k = n.filter(function(e) {
return !e.disabled && e.type == "line" && e.yAxis == 1;
}), L = n.filter(function(e) {
return !e.disabled && e.type == "line" && e.yAxis == 2;
}), A = n.filter(function(e) {
return !e.disabled && e.type == "bar" && e.yAxis == 1;
}), O = n.filter(function(e) {
return !e.disabled && e.type == "bar" && e.yAxis == 2;
}), M = n.filter(function(e) {
return !e.disabled && e.type == "area" && e.yAxis == 1;
}), _ = n.filter(function(e) {
return !e.disabled && e.type == "area" && e.yAxis == 2;
}), D = n.filter(function(e) {
return !e.disabled && e.yAxis == 1;
}).map(function(e) {
return e.values.map(function(e, t) {
return {
x: e.x,
y: e.y
};
});
}), P = n.filter(function(e) {
return !e.disabled && e.yAxis == 2;
}).map(function(e) {
return e.values.map(function(e, t) {
return {
x: e.x,
y: e.y
};
});
});
f.domain(d3.extent(d3.merge(D.concat(P)), function(e) {
return e.x;
})).range([ 0, N ]);
var H = a.selectAll("g.wrap.multiChart").data([ n ]), B = H.enter().append("g").attr("class", "wrap nvd3 multiChart").append("g");
B.append("g").attr("class", "x axis"), B.append("g").attr("class", "y1 axis"), B.append("g").attr("class", "y2 axis"), B.append("g").attr("class", "lines1Wrap"), B.append("g").attr("class", "lines2Wrap"), B.append("g").attr("class", "bars1Wrap"), B.append("g").attr("class", "bars2Wrap"), B.append("g").attr("class", "stack1Wrap"), B.append("g").attr("class", "stack2Wrap"), B.append("g").attr("class", "legendWrap");
var j = H.select("g");
o && (S.width(N / 2), j.select(".legendWrap").datum(n.map(function(e) {
return e.originalKey = e.originalKey === undefined ? e.key : e.originalKey, e.key = e.originalKey + (e.yAxis == 1 ? "" : " (right axis)"), e;
})).call(S), t.top != S.height() && (t.top = S.height(), C = (s || parseInt(a.style("height")) || 400) - t.top - t.bottom), j.select(".legendWrap").attr("transform", "translate(" + N / 2 + "," + -t.top + ")")), p.width(N).height(C).interpolate("monotone").color(n.map(function(e, t) {
return e.color || r[t % r.length];
}).filter(function(e, t) {
return !n[t].disabled && n[t].yAxis == 1 && n[t].type == "line";
})), d.width(N).height(C).interpolate("monotone").color(n.map(function(e, t) {
return e.color || r[t % r.length];
}).filter(function(e, t) {
return !n[t].disabled && n[t].yAxis == 2 && n[t].type == "line";
})), v.width(N).height(C).color(n.map(function(e, t) {
return e.color || r[t % r.length];
}).filter(function(e, t) {
return !n[t].disabled && n[t].yAxis == 1 && n[t].type == "bar";
})), m.width(N).height(C).color(n.map(function(e, t) {
return e.color || r[t % r.length];
}).filter(function(e, t) {
return !n[t].disabled && n[t].yAxis == 2 && n[t].type == "bar";
})), g.width(N).height(C).color(n.map(function(e, t) {
return e.color || r[t % r.length];
}).filter(function(e, t) {
return !n[t].disabled && n[t].yAxis == 1 && n[t].type == "area";
})), y.width(N).height(C).color(n.map(function(e, t) {
return e.color || r[t % r.length];
}).filter(function(e, t) {
return !n[t].disabled && n[t].yAxis == 2 && n[t].type == "area";
})), j.attr("transform", "translate(" + t.left + "," + t.top + ")");
var F = j.select(".lines1Wrap").datum(k), I = j.select(".bars1Wrap").datum(A), q = j.select(".stack1Wrap").datum(M), R = j.select(".lines2Wrap").datum(L), U = j.select(".bars2Wrap").datum(O), z = j.select(".stack2Wrap").datum(_), W = M.length ? M.map(function(e) {
return e.values;
}).reduce(function(e, t) {
return e.map(function(e, n) {
return {
x: e.x,
y: e.y + t[n].y
};
});
}).concat([ {
x: 0,
y: 0
} ]) : [], X = _.length ? _.map(function(e) {
return e.values;
}).reduce(function(e, t) {
return e.map(function(e, n) {
return {
x: e.x,
y: e.y + t[n].y
};
});
}).concat([ {
x: 0,
y: 0
} ]) : [];
c.domain(d3.extent(d3.merge(D).concat(W), function(e) {
return e.y;
})).range([ 0, C ]), h.domain(d3.extent(d3.merge(P).concat(X), function(e) {
return e.y;
})).range([ 0, C ]), p.yDomain(c.domain()), v.yDomain(c.domain()), g.yDomain(c.domain()), d.yDomain(h.domain()), m.yDomain(h.domain()), y.yDomain(h.domain()), M.length && d3.transition(q).call(g), _.length && d3.transition(z).call(y), A.length && d3.transition(I).call(v), O.length && d3.transition(U).call(m), k.length && d3.transition(F).call(p), L.length && d3.transition(R).call(d), b.ticks(N / 100).tickSize(-C, 0), j.select(".x.axis").attr("transform", "translate(0," + C + ")"), d3.transition(j.select(".x.axis")).call(b), w.ticks(C / 36).tickSize(-N, 0), d3.transition(j.select(".y1.axis")).call(w), E.ticks(C / 36).tickSize(-N, 0), d3.transition(j.select(".y2.axis")).call(E), j.select(".y2.axis").style("opacity", P.length ? 1 : 0).attr("transform", "translate(" + f.range()[1] + ",0)"), S.dispatch.on("legendClick", function(t, r) {
t.disabled = !t.disabled, n.filter(function(e) {
return !e.disabled;
}).length || n.map(function(e) {
return e.disabled = !1, H.selectAll(".series").classed("disabled", !1), e;
}), e.update();
}), x.on("tooltipShow", function(e) {
u && T(e, l.parentNode);
});
}), e;
}
var t = {
top: 30,
right: 20,
bottom: 50,
left: 60
}, r = d3.scale.category20().range(), i = null, s = null, o = !0, u = !0, a = function(e, t, n, r, i) {
return "<h3>" + e + "</h3>" + "<p>" + n + " at " + t + "</p>";
}, f, l, f = d3.scale.linear(), c = d3.scale.linear(), h = d3.scale.linear(), p = n.models.line().yScale(c), d = n.models.line().yScale(h), v = n.models.multiBar().stacked(!1).yScale(c), m = n.models.multiBar().stacked(!1).yScale(h), g = n.models.stackedArea().yScale(c), y = n.models.stackedArea().yScale(h), b = n.models.axis().scale(f).orient("bottom").tickPadding(5), w = n.models.axis().scale(c).orient("left"), E = n.models.axis().scale(h).orient("right"), S = n.models.legend().height(30), x = d3.dispatch("tooltipShow", "tooltipHide"), T = function(t, r) {
var i = t.pos[0] + (r.offsetLeft || 0), s = t.pos[1] + (r.offsetTop || 0), o = b.tickFormat()(p.x()(t.point, t.pointIndex)), u = (t.series.yAxis == 2 ? E : w).tickFormat()(p.y()(t.point, t.pointIndex)), f = a(t.series.key, o, u, t, e);
n.tooltip.show([ i, s ], f, undefined, undefined, r.offsetParent);
};
return p.dispatch.on("elementMouseover.tooltip", function(e) {
e.pos = [ e.pos[0] + t.left, e.pos[1] + t.top ], x.tooltipShow(e);
}), p.dispatch.on("elementMouseout.tooltip", function(e) {
x.tooltipHide(e);
}), d.dispatch.on("elementMouseover.tooltip", function(e) {
e.pos = [ e.pos[0] + t.left, e.pos[1] + t.top ], x.tooltipShow(e);
}), d.dispatch.on("elementMouseout.tooltip", function(e) {
x.tooltipHide(e);
}), v.dispatch.on("elementMouseover.tooltip", function(e) {
e.pos = [ e.pos[0] + t.left, e.pos[1] + t.top ], x.tooltipShow(e);
}), v.dispatch.on("elementMouseout.tooltip", function(e) {
x.tooltipHide(e);
}), m.dispatch.on("elementMouseover.tooltip", function(e) {
e.pos = [ e.pos[0] + t.left, e.pos[1] + t.top ], x.tooltipShow(e);
}), m.dispatch.on("elementMouseout.tooltip", function(e) {
x.tooltipHide(e);
}), g.dispatch.on("tooltipShow", function(e) {
if (!Math.round(g.y()(e.point) * 100)) return setTimeout(function() {
d3.selectAll(".point.hover").classed("hover", !1);
}, 0), !1;
e.pos = [ e.pos[0] + t.left, e.pos[1] + t.top ], x.tooltipShow(e);
}), g.dispatch.on("tooltipHide", function(e) {
x.tooltipHide(e);
}), y.dispatch.on("tooltipShow", function(e) {
if (!Math.round(y.y()(e.point) * 100)) return setTimeout(function() {
d3.selectAll(".point.hover").classed("hover", !1);
}, 0), !1;
e.pos = [ e.pos[0] + t.left, e.pos[1] + t.top ], x.tooltipShow(e);
}), y.dispatch.on("tooltipHide", function(e) {
x.tooltipHide(e);
}), p.dispatch.on("elementMouseover.tooltip", function(e) {
e.pos = [ e.pos[0] + t.left, e.pos[1] + t.top ], x.tooltipShow(e);
}), p.dispatch.on("elementMouseout.tooltip", function(e) {
x.tooltipHide(e);
}), d.dispatch.on("elementMouseover.tooltip", function(e) {
e.pos = [ e.pos[0] + t.left, e.pos[1] + t.top ], x.tooltipShow(e);
}), d.dispatch.on("elementMouseout.tooltip", function(e) {
x.tooltipHide(e);
}), x.on("tooltipHide", function() {
u && n.tooltip.cleanup();
}), e.dispatch = x, e.lines1 = p, e.lines2 = d, e.bars1 = v, e.bars2 = m, e.stack1 = g, e.stack2 = y, e.xAxis = b, e.yAxis1 = w, e.yAxis2 = E, e.x = function(t) {
return arguments.length ? (getX = t, p.x(t), v.x(t), e) : getX;
}, e.y = function(t) {
return arguments.length ? (getY = t, p.y(t), v.y(t), e) : getY;
}, e.margin = function(n) {
return arguments.length ? (t = n, e) : t;
}, e.width = function(t) {
return arguments.length ? (i = t, e) : i;
}, e.height = function(t) {
return arguments.length ? (s = t, e) : s;
}, e.color = function(t) {
return arguments.length ? (r = t, S.color(t), e) : r;
}, e.showLegend = function(t) {
return arguments.length ? (o = t, e) : o;
}, e.tooltips = function(t) {
return arguments.length ? (u = t, e) : u;
}, e.tooltipContent = function(t) {
return arguments.length ? (a = t, e) : a;
}, e;
}, n.models.ohlcBar = function() {
function e(n) {
return n.each(function(e) {
var n = r - t.left - t.right, y = i - t.top - t.bottom, S = d3.select(this);
o.domain(b || d3.extent(e[0].values.map(a).concat(d))), m ? o.range([ n * .5 / e[0].values.length, n * (e[0].values.length - .5) / e[0].values.length ]) : o.range([ 0, n ]), u.domain(w || [ d3.min(e[0].values.map(p).concat(v)), d3.max(e[0].values.map(h).concat(v)) ]).range([ y, 0 ]);
if (o.domain()[0] === o.domain()[1] || u.domain()[0] === u.domain()[1]) singlePoint = !0;
o.domain()[0] === o.domain()[1] && (o.domain()[0] ? o.domain([ o.domain()[0] - o.domain()[0] * .01, o.domain()[1] + o.domain()[1] * .01 ]) : o.domain([ -1, 1 ])), u.domain()[0] === u.domain()[1] && (u.domain()[0] ? u.domain([ u.domain()[0] + u.domain()[0] * .01, u.domain()[1] - u.domain()[1] * .01 ]) : u.domain([ -1, 1 ]));
var x = d3.select(this).selectAll("g.nv-wrap.nv-ohlcBar").data([ e[0].values ]), T = x.enter().append("g").attr("class", "nvd3 nv-wrap nv-ohlcBar"), N = T.append("defs"), C = T.append("g"), k = x.select("g");
C.append("g").attr("class", "nv-ticks"), x.attr("transform", "translate(" + t.left + "," + t.top + ")"), S.on("click", function(e, t) {
E.chartClick({
data: e,
index: t,
pos: d3.event,
id: s
});
}), N.append("clipPath").attr("id", "nv-chart-clip-path-" + s).append("rect"), x.select("#nv-chart-clip-path-" + s + " rect").attr("width", n).attr("height", y), k.attr("clip-path", g ? "url(#nv-chart-clip-path-" + s + ")" : "");
var L = x.select(".nv-ticks").selectAll(".nv-tick").data(function(e) {
return e;
});
L.exit().remove();
var A = L.enter().append("path").attr("class", function(e, t, n) {
return (l(e, t) > c(e, t) ? "nv-tick negative" : "nv-tick positive") + " nv-tick-" + n + "-" + t;
}).attr("d", function(t, r) {
var i = n / e[0].values.length * .9;
return "m0,0l0," + (u(l(t, r)) - u(h(t, r))) + "l" + -i / 2 + ",0l" + i / 2 + ",0l0," + (u(p(t, r)) - u(l(t, r))) + "l0," + (u(c(t, r)) - u(p(t, r))) + "l" + i / 2 + ",0l" + -i / 2 + ",0z";
}).attr("transform", function(e, t) {
return "translate(" + o(a(e, t)) + "," + u(h(e, t)) + ")";
}).on("mouseover", function(t, n) {
d3.select(this).classed("hover", !0), E.elementMouseover({
point: t,
series: e[0],
pos: [ o(a(t, n)), u(f(t, n)) ],
pointIndex: n,
seriesIndex: 0,
e: d3.event
});
}).on("mouseout", function(t, n) {
d3.select(this).classed("hover", !1), E.elementMouseout({
point: t,
series: e[0],
pointIndex: n,
seriesIndex: 0,
e: d3.event
});
}).on("click", function(e, t) {
E.elementClick({
value: f(e, t),
data: e,
index: t,
pos: [ o(a(e, t)), u(f(e, t)) ],
e: d3.event,
id: s
}), d3.event.stopPropagation();
}).on("dblclick", function(e, t) {
E.elementDblClick({
value: f(e, t),
data: e,
index: t,
pos: [ o(a(e, t)), u(f(e, t)) ],
e: d3.event,
id: s
}), d3.event.stopPropagation();
});
L.attr("class", function(e, t, n) {
return (l(e, t) > c(e, t) ? "nv-tick negative" : "nv-tick positive") + " nv-tick-" + n + "-" + t;
}), d3.transition(L).attr("transform", function(e, t) {
return "translate(" + o(a(e, t)) + "," + u(h(e, t)) + ")";
}).attr("d", function(t, r) {
var i = n / e[0].values.length * .9;
return "m0,0l0," + (u(l(t, r)) - u(h(t, r))) + "l" + -i / 2 + ",0l" + i / 2 + ",0l0," + (u(p(t, r)) - u(l(t, r))) + "l0," + (u(c(t, r)) - u(p(t, r))) + "l" + i / 2 + ",0l" + -i / 2 + ",0z";
});
}), e;
}
var t = {
top: 0,
right: 0,
bottom: 0,
left: 0
}, r = 960, i = 500, s = Math.floor(Math.random() * 1e4), o = d3.scale.linear(), u = d3.scale.linear(), a = function(e) {
return e.x;
}, f = function(e) {
return e.y;
}, l = function(e) {
return e.open;
}, c = function(e) {
return e.close;
}, h = function(e) {
return e.high;
}, p = function(e) {
return e.low;
}, d = [], v = [], m = !1, g = !0, y = n.utils.defaultColor(), b, w, E = d3.dispatch("chartClick", "elementClick", "elementDblClick", "elementMouseover", "elementMouseout");
return e.dispatch = E, e.x = function(t) {
return arguments.length ? (a = t, e) : a;
}, e.y = function(t) {
return arguments.length ? (f = t, e) : f;
}, e.open = function(t) {
return arguments.length ? (l = t, e) : l;
}, e.close = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.high = function(t) {
return arguments.length ? (h = t, e) : h;
}, e.low = function(t) {
return arguments.length ? (p = t, e) : p;
}, e.margin = function(n) {
return arguments.length ? (t.top = typeof n.top != "undefined" ? n.top : t.top, t.right = typeof n.right != "undefined" ? n.right : t.right, t.bottom = typeof n.bottom != "undefined" ? n.bottom : t.bottom, t.left = typeof n.left != "undefined" ? n.left : t.left, e) : t;
}, e.width = function(t) {
return arguments.length ? (r = t, e) : r;
}, e.height = function(t) {
return arguments.length ? (i = t, e) : i;
}, e.xScale = function(t) {
return arguments.length ? (o = t, e) : o;
}, e.yScale = function(t) {
return arguments.length ? (u = t, e) : u;
}, e.xDomain = function(t) {
return arguments.length ? (b = t, e) : b;
}, e.yDomain = function(t) {
return arguments.length ? (w = t, e) : w;
}, e.forceX = function(t) {
return arguments.length ? (d = t, e) : d;
}, e.forceY = function(t) {
return arguments.length ? (v = t, e) : v;
}, e.padData = function(t) {
return arguments.length ? (m = t, e) : m;
}, e.clipEdge = function(t) {
return arguments.length ? (g = t, e) : g;
}, e.color = function(t) {
return arguments.length ? (y = n.utils.getColor(t), e) : y;
}, e.id = function(t) {
return arguments.length ? (s = t, e) : s;
}, e;
}, n.models.pie = function() {
function e(n) {
return n.each(function(e) {
function n(e) {
var t = (e.startAngle + e.endAngle) * 90 / Math.PI - 90;
return t > 90 ? t - 180 : t;
}
function a(e) {
e.endAngle = isNaN(e.endAngle) ? 0 : e.endAngle, e.startAngle = isNaN(e.startAngle) ? 0 : e.startAngle, m || (e.innerRadius = 0);
var t = d3.interpolate(this._current, e);
return this._current = t(0), function(e) {
return M(t(e));
};
}
function c(e) {
e.innerRadius = 0;
var t = d3.interpolate({
startAngle: 0,
endAngle: 0
}, e);
return function(e) {
return M(t(e));
};
}
var S = r - t.left - t.right, x = i - t.top - t.bottom, T = Math.min(S, x) / 2, N = T - T / 5, C = d3.select(this), k = C.selectAll(".nv-wrap.nv-pie").data([ s(e[0]) ]), L = k.enter().append("g").attr("class", "nvd3 nv-wrap nv-pie nv-chart-" + f), A = L.append("g"), O = k.select("g");
A.append("g").attr("class", "nv-pie"), k.attr("transform", "translate(" + t.left + "," + t.top + ")"), O.select(".nv-pie").attr("transform", "translate(" + S / 2 + "," + x / 2 + ")"), C.on("click", function(e, t) {
E.chartClick({
data: e,
index: t,
pos: d3.event,
id: f
});
});
var M = d3.svg.arc().outerRadius(N);
y && M.startAngle(y), b && M.endAngle(b), m && M.innerRadius(T * w);
var _ = d3.layout.pie().sort(null).value(function(e) {
return e.disabled ? 0 : u(e);
}), D = k.select(".nv-pie").selectAll(".nv-slice").data(_);
D.exit().remove();
var P = D.enter().append("g").attr("class", "nv-slice").on("mouseover", function(e, t) {
d3.select(this).classed("hover", !0), E.elementMouseover({
label: o(e.data),
value: u(e.data),
point: e.data,
pointIndex: t,
pos: [ d3.event.pageX, d3.event.pageY ],
id: f
});
}).on("mouseout", function(e, t) {
d3.select(this).classed("hover", !1), E.elementMouseout({
label: o(e.data),
value: u(e.data),
point: e.data,
index: t,
id: f
});
}).on("click", function(e, t) {
E.elementClick({
label: o(e.data),
value: u(e.data),
point: e.data,
index: t,
pos: d3.event,
id: f
}), d3.event.stopPropagation();
}).on("dblclick", function(e, t) {
E.elementDblClick({
label: o(e.data),
value: u(e.data),
point: e.data,
index: t,
pos: d3.event,
id: f
}), d3.event.stopPropagation();
});
D.attr("fill", function(e, t) {
return l(e, t);
}).attr("stroke", function(e, t) {
return l(e, t);
});
var H = P.append("path").each(function(e) {
this._current = e;
});
d3.transition(D.select("path")).attr("d", M).attrTween("d", a);
if (h) {
var B = d3.svg.arc().innerRadius(0);
p && (B = M), d && (B = d3.svg.arc().outerRadius(M.outerRadius())), P.append("g").classed("nv-label", !0).each(function(e, t) {
var n = d3.select(this);
n.attr("transform", function(e) {
if (g) {
e.outerRadius = N + 10, e.innerRadius = N + 15;
var t = (e.startAngle + e.endAngle) / 2 * (180 / Math.PI);
return (e.startAngle + e.endAngle) / 2 < Math.PI ? t -= 90 : t += 90, "translate(" + B.centroid(e) + ") rotate(" + t + ")";
}
return e.outerRadius = T + 10, e.innerRadius = T + 15, "translate(" + B.centroid(e) + ")";
}), n.append("rect").style("stroke", "#fff").style("fill", "#fff").attr("rx", 3).attr("ry", 3), n.append("text").style("text-anchor", g ? (e.startAngle + e.endAngle) / 2 < Math.PI ? "start" : "end" : "middle").style("fill", "#000");
}), D.select(".nv-label").transition().attr("transform", function(e) {
if (g) {
e.outerRadius = N + 10, e.innerRadius = N + 15;
var t = (e.startAngle + e.endAngle) / 2 * (180 / Math.PI);
return (e.startAngle + e.endAngle) / 2 < Math.PI ? t -= 90 : t += 90, "translate(" + B.centroid(e) + ") rotate(" + t + ")";
}
return e.outerRadius = T + 10, e.innerRadius = T + 15, "translate(" + B.centroid(e) + ")";
}), D.each(function(e, t) {
var n = d3.select(this);
n.select(".nv-label text").style("text-anchor", g ? (e.startAngle + e.endAngle) / 2 < Math.PI ? "start" : "end" : "middle").text(function(e, t) {
var n = (e.endAngle - e.startAngle) / (2 * Math.PI);
return e.value && n > v ? o(e.data) : "";
});
var r = n.select("text").node().getBBox();
n.select(".nv-label rect").attr("width", r.width + 10).attr("height", r.height + 10).attr("transform", function() {
return "translate(" + [ r.x - 5, r.y - 5 ] + ")";
});
});
}
}), e;
}
var t = {
top: 0,
right: 0,
bottom: 0,
left: 0
}, r = 500, i = 500, s = function(e) {
return e.values;
}, o = function(e) {
return e.x;
}, u = function(e) {
return e.y;
}, a = function(e) {
return e.description;
}, f = Math.floor(Math.random() * 1e4), l = n.utils.defaultColor(), c = d3.format(",.2f"), h = !0, p = !0, d = !1, v = .02, m = !1, g = !1, y = !1, b = !1, w = .5, E = d3.dispatch("chartClick", "elementClick", "elementDblClick", "elementMouseover", "elementMouseout");
return e.dispatch = E, e.margin = function(n) {
return arguments.length ? (t.top = typeof n.top != "undefined" ? n.top : t.top, t.right = typeof n.right != "undefined" ? n.right : t.right, t.bottom = typeof n.bottom != "undefined" ? n.bottom : t.bottom, t.left = typeof n.left != "undefined" ? n.left : t.left, e) : t;
}, e.width = function(t) {
return arguments.length ? (r = t, e) : r;
}, e.height = function(t) {
return arguments.length ? (i = t, e) : i;
}, e.values = function(t) {
return arguments.length ? (s = t, e) : s;
}, e.x = function(t) {
return arguments.length ? (o = t, e) : o;
}, e.y = function(t) {
return arguments.length ? (u = d3.functor(t), e) : u;
}, e.description = function(t) {
return arguments.length ? (a = t, e) : a;
}, e.showLabels = function(t) {
return arguments.length ? (h = t, e) : h;
}, e.labelSunbeamLayout = function(t) {
return arguments.length ? (g = t, e) : g;
}, e.donutLabelsOutside = function(t) {
return arguments.length ? (d = t, e) : d;
}, e.pieLabelsOutside = function(t) {
return arguments.length ? (p = t, e) : p;
}, e.donut = function(t) {
return arguments.length ? (m = t, e) : m;
}, e.donutRatio = function(t) {
return arguments.length ? (w = t, e) : w;
}, e.startAngle = function(t) {
return arguments.length ? (y = t, e) : y;
}, e.endAngle = function(t) {
return arguments.length ? (b = t, e) : b;
}, e.id = function(t) {
return arguments.length ? (f = t, e) : f;
}, e.color = function(t) {
return arguments.length ? (l = n.utils.getColor(t), e) : l;
}, e.valueFormat = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.labelThreshold = function(t) {
return arguments.length ? (v = t, e) : v;
}, e;
}, n.models.pieChart = function() {
function e(n) {
return n.each(function(n) {
var a = d3.select(this), f = this, l = (s || parseInt(a.style("width")) || 960) - i.left - i.right, v = (o || parseInt(a.style("height")) || 400) - i.top - i.bottom;
e.update = function() {
a.transition().call(e);
}, e.container = this, c.disabled = n[0].map(function(e) {
return !!e.disabled;
});
if (!h) {
var m;
h = {};
for (m in c) c[m] instanceof Array ? h[m] = c[m].slice(0) : h[m] = c[m];
}
if (!n[0] || !n[0].length) {
var g = a.selectAll(".nv-noData").data([ p ]);
return g.enter().append("text").attr("class", "nvd3 nv-noData").attr("dy", "-.7em").style("text-anchor", "middle"), g.attr("x", i.left + l / 2).attr("y", i.top + v / 2).text(function(e) {
return e;
}), e;
}
a.selectAll(".nv-noData").remove();
var y = a.selectAll("g.nv-wrap.nv-pieChart").data([ n ]), b = y.enter().append("g").attr("class", "nvd3 nv-wrap nv-pieChart").append("g"), w = y.select("g");
b.append("g").attr("class", "nv-pieWrap"), b.append("g").attr("class", "nv-legendWrap"), u && (r.width(l).key(t.x()), y.select(".nv-legendWrap").datum(t.values()(n[0])).call(r), i.top != r.height() && (i.top = r.height(), v = (o || parseInt(a.style("height")) || 400) - i.top - i.bottom), y.select(".nv-legendWrap").attr("transform", "translate(0," + -i.top + ")")), y.attr("transform", "translate(" + i.left + "," + i.top + ")"), t.width(l).height(v);
var E = w.select(".nv-pieWrap").datum(n);
d3.transition(E).call(t), r.dispatch.on("legendClick", function(r, i, s) {
r.disabled = !r.disabled, t.values()(n[0]).filter(function(e) {
return !e.disabled;
}).length || t.values()(n[0]).map(function(e) {
return e.disabled = !1, y.selectAll(".nv-series").classed("disabled", !1), e;
}), c.disabled = n[0].map(function(e) {
return !!e.disabled;
}), d.stateChange(c), e.update();
}), t.dispatch.on("elementMouseout.tooltip", function(e) {
d.tooltipHide(e);
}), d.on("changeState", function(t) {
typeof t.disabled != "undefined" && (n[0].forEach(function(e, n) {
e.disabled = t.disabled[n];
}), c.disabled = t.disabled), e.update();
});
}), e;
}
var t = n.models.pie(), r = n.models.legend(), i = {
top: 30,
right: 20,
bottom: 20,
left: 20
}, s = null, o = null, u = !0, a = n.utils.defaultColor(), f = !0, l = function(e, t, n, r) {
return "<h3>" + e + "</h3>" + "<p>" + t + "</p>";
}, c = {}, h = null, p = "No Data Available.", d = d3.dispatch("tooltipShow", "tooltipHide", "stateChange", "changeState"), v = function(r, i) {
var s = t.description()(r.point) || t.x()(r.point), o = r.pos[0] + (i && i.offsetLeft || 0), u = r.pos[1] + (i && i.offsetTop || 0), a = t.valueFormat()(t.y()(r.point)), f = l(s, a, r, e);
n.tooltip.show([ o, u ], f, r.value < 0 ? "n" : "s", null, i);
};
return t.dispatch.on("elementMouseover.tooltip", function(e) {
e.pos = [ e.pos[0] + i.left, e.pos[1] + i.top ], d.tooltipShow(e);
}), d.on("tooltipShow", function(e) {
f && v(e);
}), d.on("tooltipHide", function() {
f && n.tooltip.cleanup();
}), e.legend = r, e.dispatch = d, e.pie = t, d3.rebind(e, t, "valueFormat", "values", "x", "y", "description", "id", "showLabels", "donutLabelsOutside", "pieLabelsOutside", "donut", "donutRatio", "labelThreshold"), e.margin = function(t) {
return arguments.length ? (i.top = typeof t.top != "undefined" ? t.top : i.top, i.right = typeof t.right != "undefined" ? t.right : i.right, i.bottom = typeof t.bottom != "undefined" ? t.bottom : i.bottom, i.left = typeof t.left != "undefined" ? t.left : i.left, e) : i;
}, e.width = function(t) {
return arguments.length ? (s = t, e) : s;
}, e.height = function(t) {
return arguments.length ? (o = t, e) : o;
}, e.color = function(i) {
return arguments.length ? (a = n.utils.getColor(i), r.color(a), t.color(a), e) : a;
}, e.showLegend = function(t) {
return arguments.length ? (u = t, e) : u;
}, e.tooltips = function(t) {
return arguments.length ? (f = t, e) : f;
}, e.tooltipContent = function(t) {
return arguments.length ? (l = t, e) : l;
}, e.state = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.defaultState = function(t) {
return arguments.length ? (h = t, e) : h;
}, e.noData = function(t) {
return arguments.length ? (p = t, e) : p;
}, e;
}, n.models.scatter = function() {
function e(n) {
return n.each(function(e) {
function n() {
if (!y) return !1;
var n, s = d3.merge(e.map(function(e, t) {
return e.values.map(function(e, n) {
var r = l(e, n) + Math.random() * 1e-7, i = c(e, n) + Math.random() * 1e-7;
return [ u(r), a(i), t, n, e ];
}).filter(function(e, t) {
return w(e[4], t);
});
}));
if (_ === !0) {
if (T) {
var f = U.select("defs").selectAll(".nv-point-clips").data([ o ]).enter();
f.append("clipPath").attr("class", "nv-point-clips").attr("id", "nv-points-clip-" + o);
var h = U.select("#nv-points-clip-" + o).selectAll("circle").data(s);
h.enter().append("circle").attr("r", N), h.exit().remove(), h.attr("cx", function(e) {
return e[0];
}).attr("cy", function(e) {
return e[1];
}), U.select(".nv-point-paths").attr("clip-path", "url(#nv-points-clip-" + o + ")");
}
s.length && (s.push([ u.range()[0] - 20, a.range()[0] - 20, null, null ]), s.push([ u.range()[1] + 20, a.range()[1] + 20, null, null ]), s.push([ u.range()[0] - 20, a.range()[0] + 20, null, null ]), s.push([ u.range()[1] + 20, a.range()[1] - 20, null, null ]));
var p = d3.geom.polygon([ [ -10, -10 ], [ -10, i + 10 ], [ r + 10, i + 10 ], [ r + 10, -10 ] ]), d = d3.geom.voronoi(s).map(function(e, t) {
return {
data: p.clip(e),
series: s[t][2],
point: s[t][3]
};
}), v = U.select(".nv-point-paths").selectAll("path").data(d);
v.enter().append("path").attr("class", function(e, t) {
return "nv-path-" + t;
}), v.exit().remove(), v.attr("d", function(e) {
return e.data.length === 0 ? "M 0 0" : "M" + e.data.join("L") + "Z";
}), v.on("click", function(n) {
if (j) return 0;
var r = e[n.series], i = r.values[n.point];
M.elementClick({
point: i,
series: r,
pos: [ u(l(i, n.point)) + t.left, a(c(i, n.point)) + t.top ],
seriesIndex: n.series,
pointIndex: n.point
});
}).on("mouseover", function(n) {
if (j) return 0;
var r = e[n.series], i = r.values[n.point];
M.elementMouseover({
point: i,
series: r,
pos: [ u(l(i, n.point)) + t.left, a(c(i, n.point)) + t.top ],
seriesIndex: n.series,
pointIndex: n.point
});
}).on("mouseout", function(t, n) {
if (j) return 0;
var r = e[t.series], i = r.values[t.point];
M.elementMouseout({
point: i,
series: r,
seriesIndex: t.series,
pointIndex: t.point
});
});
} else U.select(".nv-groups").selectAll(".nv-group").selectAll(".nv-point").on("click", function(n, r) {
if (j || !e[n.series]) return 0;
var i = e[n.series], s = i.values[r];
M.elementClick({
point: s,
series: i,
pos: [ u(l(s, r)) + t.left, a(c(s, r)) + t.top ],
seriesIndex: n.series,
pointIndex: r
});
}).on("mouseover", function(n, r) {
if (j || !e[n.series]) return 0;
var i = e[n.series], s = i.values[r];
M.elementMouseover({
point: s,
series: i,
pos: [ u(l(s, r)) + t.left, a(c(s, r)) + t.top ],
seriesIndex: n.series,
pointIndex: r
});
}).on("mouseout", function(t, n) {
if (j || !e[t.series]) return 0;
var r = e[t.series], i = r.values[n];
M.elementMouseout({
point: i,
series: r,
seriesIndex: t.series,
pointIndex: n
});
});
j = !1;
}
var F = r - t.left - t.right, I = i - t.top - t.bottom, q = d3.select(this);
e = e.map(function(e, t) {
return e.values = e.values.map(function(e) {
return e.series = t, e;
}), e;
});
var R = C && k && L ? [] : d3.merge(e.map(function(e) {
return e.values.map(function(e, t) {
return {
x: l(e, t),
y: c(e, t),
size: h(e, t)
};
});
}));
u.domain(C || d3.extent(R.map(function(e) {
return e.x;
}).concat(v))), E && e[0] ? u.range([ (F * S + F) / (2 * e[0].values.length), F - F * (1 + S) / (2 * e[0].values.length) ]) : u.range([ 0, F ]), a.domain(k || d3.extent(R.map(function(e) {
return e.y;
}).concat(m))).range([ I, 0 ]), f.domain(L || d3.extent(R.map(function(e) {
return e.size;
}).concat(g))).range(A || [ 16, 256 ]);
if (u.domain()[0] === u.domain()[1] || a.domain()[0] === a.domain()[1]) O = !0;
u.domain()[0] === u.domain()[1] && (u.domain()[0] ? u.domain([ u.domain()[0] - u.domain()[0] * .01, u.domain()[1] + u.domain()[1] * .01 ]) : u.domain([ -1, 1 ])), a.domain()[0] === a.domain()[1] && (a.domain()[0] ? a.domain([ a.domain()[0] + a.domain()[0] * .01, a.domain()[1] - a.domain()[1] * .01 ]) : a.domain([ -1, 1 ])), isNaN(u.domain()[0]) && u.domain([ -1, 1 ]), isNaN(a.domain()[0]) && a.domain([ -1, 1 ]), D = D || u, P = P || a, H = H || f;
var U = q.selectAll("g.nv-wrap.nv-scatter").data([ e ]), z = U.enter().append("g").attr("class", "nvd3 nv-wrap nv-scatter nv-chart-" + o + (O ? " nv-single-point" : "")), W = z.append("defs"), X = z.append("g"), V = U.select("g");
X.append("g").attr("class", "nv-groups"), X.append("g").attr("class", "nv-point-paths"), U.attr("transform", "translate(" + t.left + "," + t.top + ")"), W.append("clipPath").attr("id", "nv-edge-clip-" + o).append("rect"), U.select("#nv-edge-clip-" + o + " rect").attr("width", F).attr("height", I), V.attr("clip-path", x ? "url(#nv-edge-clip-" + o + ")" : ""), j = !0;
var $ = U.select(".nv-groups").selectAll(".nv-group").data(function(e) {
return e;
}, function(e) {
return e.key;
});
$.enter().append("g").style("stroke-opacity", 1e-6).style("fill-opacity", 1e-6), d3.transition($.exit()).style("stroke-opacity", 1e-6).style("fill-opacity", 1e-6).remove(), $.attr("class", function(e, t) {
return "nv-group nv-series-" + t;
}).classed("hover", function(e) {
return e.hover;
}), d3.transition($).style("fill", function(e, t) {
return s(e, t);
}).style("stroke", function(e, t) {
return s(e, t);
}).style("stroke-opacity", 1).style("fill-opacity", .5);
if (d) {
var J = $.selectAll("circle.nv-point").data(function(e) {
return e.values;
}, b);
J.enter().append("circle").attr("cx", function(e, t) {
return D(l(e, t));
}).attr("cy", function(e, t) {
return P(c(e, t));
}).attr("r", function(e, t) {
return Math.sqrt(f(h(e, t)) / Math.PI);
}), J.exit().remove(), $.exit().selectAll("path.nv-point").transition().attr("cx", function(e, t) {
return u(l(e, t));
}).attr("cy", function(e, t) {
return a(c(e, t));
}).remove(), J.each(function(e, t) {
d3.select(this).classed("nv-point", !0).classed("nv-point-" + t, !0);
}), J.transition().attr("cx", function(e, t) {
return u(l(e, t));
}).attr("cy", function(e, t) {
return a(c(e, t));
}).attr("r", function(e, t) {
return Math.sqrt(f(h(e, t)) / Math.PI);
});
} else {
var J = $.selectAll("path.nv-point").data(function(e) {
return e.values;
});
J.enter().append("path").attr("transform", function(e, t) {
return "translate(" + D(l(e, t)) + "," + P(c(e, t)) + ")";
}).attr("d", d3.svg.symbol().type(p).size(function(e, t) {
return f(h(e, t));
})), J.exit().remove(), d3.transition($.exit().selectAll("path.nv-point")).attr("transform", function(e, t) {
return "translate(" + u(l(e, t)) + "," + a(c(e, t)) + ")";
}).remove(), J.each(function(e, t) {
d3.select(this).classed("nv-point", !0).classed("nv-point-" + t, !0);
}), J.transition().attr("transform", function(e, t) {
return "translate(" + u(l(e, t)) + "," + a(c(e, t)) + ")";
}).attr("d", d3.svg.symbol().type(p).size(function(e, t) {
return f(h(e, t));
}));
}
clearTimeout(B), B = setTimeout(n, 300), D = u.copy(), P = a.copy(), H = f.copy();
}), e;
}
var t = {
top: 0,
right: 0,
bottom: 0,
left: 0
}, r = 960, i = 500, s = n.utils.defaultColor(), o = Math.floor(Math.random() * 1e5), u = d3.scale.linear(), a = d3.scale.linear(), f = d3.scale.linear(), l = function(e) {
return e.x;
}, c = function(e) {
return e.y;
}, h = function(e) {
return e.size || 1;
}, p = function(e) {
return e.shape || "circle";
}, d = !0, v = [], m = [], g = [], y = !0, b = null, w = function(e) {
return !e.notActive;
}, E = !1, S = .1, x = !1, T = !0, N = function() {
return 25;
}, C = null, k = null, L = null, A = null, O = !1, M = d3.dispatch("elementClick", "elementMouseover", "elementMouseout"), _ = !0, D, P, H, B, j = !1;
return M.on("elementMouseover.point", function(e) {
y && d3.select(".nv-chart-" + o + " .nv-series-" + e.seriesIndex + " .nv-point-" + e.pointIndex).classed("hover", !0);
}), M.on("elementMouseout.point", function(e) {
y && d3.select(".nv-chart-" + o + " .nv-series-" + e.seriesIndex + " .nv-point-" + e.pointIndex).classed("hover", !1);
}), e.dispatch = M, e.x = function(t) {
return arguments.length ? (l = d3.functor(t), e) : l;
}, e.y = function(t) {
return arguments.length ? (c = d3.functor(t), e) : c;
}, e.size = function(t) {
return arguments.length ? (h = d3.functor(t), e) : h;
}, e.margin = function(n) {
return arguments.length ? (t.top = typeof n.top != "undefined" ? n.top : t.top, t.right = typeof n.right != "undefined" ? n.right : t.right, t.bottom = typeof n.bottom != "undefined" ? n.bottom : t.bottom, t.left = typeof n.left != "undefined" ? n.left : t.left, e) : t;
}, e.width = function(t) {
return arguments.length ? (r = t, e) : r;
}, e.height = function(t) {
return arguments.length ? (i = t, e) : i;
}, e.xScale = function(t) {
return arguments.length ? (u = t, e) : u;
}, e.yScale = function(t) {
return arguments.length ? (a = t, e) : a;
}, e.zScale = function(t) {
return arguments.length ? (f = t, e) : f;
}, e.xDomain = function(t) {
return arguments.length ? (C = t, e) : C;
}, e.yDomain = function(t) {
return arguments.length ? (k = t, e) : k;
}, e.sizeDomain = function(t) {
return arguments.length ? (L = t, e) : L;
}, e.sizeRange = function(t) {
return arguments.length ? (A = t, e) : A;
}, e.forceX = function(t) {
return arguments.length ? (v = t, e) : v;
}, e.forceY = function(t) {
return arguments.length ? (m = t, e) : m;
}, e.forceSize = function(t) {
return arguments.length ? (g = t, e) : g;
}, e.interactive = function(t) {
return arguments.length ? (y = t, e) : y;
}, e.pointKey = function(t) {
return arguments.length ? (b = t, e) : b;
}, e.pointActive = function(t) {
return arguments.length ? (w = t, e) : w;
}, e.padData = function(t) {
return arguments.length ? (E = t, e) : E;
}, e.padDataOuter = function(t) {
return arguments.length ? (S = t, e) : S;
}, e.clipEdge = function(t) {
return arguments.length ? (x = t, e) : x;
}, e.clipVoronoi = function(t) {
return arguments.length ? (T = t, e) : T;
}, e.useVoronoi = function(t) {
return arguments.length ? (_ = t, _ === !1 && (T = !1), e) : _;
}, e.clipRadius = function(t) {
return arguments.length ? (N = t, e) : N;
}, e.color = function(t) {
return arguments.length ? (s = n.utils.getColor(t), e) : s;
}, e.shape = function(t) {
return arguments.length ? (p = t, e) : p;
}, e.onlyCircles = function(t) {
return arguments.length ? (d = t, e) : d;
}, e.id = function(t) {
return arguments.length ? (o = t, e) : o;
}, e.singlePoint = function(t) {
return arguments.length ? (O = t, e) : O;
}, e;
}, n.models.scatterChart = function() {
function e(n) {
return n.each(function(n) {
function T() {
if (S) return U.select(".nv-point-paths").style("pointer-events", "all"), !1;
U.select(".nv-point-paths").style("pointer-events", "none");
var e = d3.mouse(this);
p.distortion(E).focus(e[0]), d.distortion(E).focus(e[1]), U.select(".nv-scatterWrap").call(t), U.select(".nv-x.nv-axis").call(r), U.select(".nv-y.nv-axis").call(i), U.select(".nv-distributionX").datum(n.filter(function(e) {
return !e.disabled;
})).call(u), U.select(".nv-distributionY").datum(n.filter(function(e) {
return !e.disabled;
})).call(a);
}
var N = d3.select(this), C = this, H = (l || parseInt(N.style("width")) || 960) - f.left - f.right, B = (c || parseInt(N.style("height")) || 400) - f.top - f.bottom;
e.update = function() {
N.transition().call(e);
}, k.disabled = n.map(function(e) {
return !!e.disabled;
});
if (!L) {
var j;
L = {};
for (j in k) k[j] instanceof Array ? L[j] = k[j].slice(0) : L[j] = k[j];
}
if (!n || !n.length || !n.filter(function(e) {
return e.values.length;
}).length) {
var F = N.selectAll(".nv-noData").data([ O ]);
return F.enter().append("text").attr("class", "nvd3 nv-noData").attr("dy", "-.7em").style("text-anchor", "middle"), F.attr("x", f.left + H / 2).attr("y", f.top + B / 2).text(function(e) {
return e;
}), e;
}
N.selectAll(".nv-noData").remove(), M = M || p, _ = _ || d;
var I = N.selectAll("g.nv-wrap.nv-scatterChart").data([ n ]), q = I.enter().append("g").attr("class", "nvd3 nv-wrap nv-scatterChart nv-chart-" + t.id()), R = q.append("g"), U = I.select("g");
R.append("rect").attr("class", "nvd3 nv-background"), R.append("g").attr("class", "nv-x nv-axis"), R.append("g").attr("class", "nv-y nv-axis"), R.append("g").attr("class", "nv-scatterWrap"), R.append("g").attr("class", "nv-distWrap"), R.append("g").attr("class", "nv-legendWrap"), R.append("g").attr("class", "nv-controlsWrap"), b && (s.width(H / 2), I.select(".nv-legendWrap").datum(n).call(s), f.top != s.height() && (f.top = s.height(), B = (c || parseInt(N.style("height")) || 400) - f.top - f.bottom), I.select(".nv-legendWrap").attr("transform", "translate(" + H / 2 + "," + -f.top + ")")), w && (o.width(180).color([ "#444" ]), U.select(".nv-controlsWrap").datum(P).attr("transform", "translate(0," + -f.top + ")").call(o)), I.attr("transform", "translate(" + f.left + "," + f.top + ")"), t.width(H).height(B).color(n.map(function(e, t) {
return e.color || h(e, t);
}).filter(function(e, t) {
return !n[t].disabled;
})).xDomain(null).yDomain(null), I.select(".nv-scatterWrap").datum(n.filter(function(e) {
return !e.disabled;
})).call(t);
if (v) {
var z = p.domain()[1] - p.domain()[0];
t.xDomain([ p.domain()[0] - v * z, p.domain()[1] + v * z ]);
}
if (m) {
var W = d.domain()[1] - d.domain()[0];
t.yDomain([ d.domain()[0] - m * W, d.domain()[1] + m * W ]);
}
I.select(".nv-scatterWrap").datum(n.filter(function(e) {
return !e.disabled;
})).call(t), r.scale(p).ticks(r.ticks() && r.ticks().length ? r.ticks() : H / 100).tickSize(-B, 0), U.select(".nv-x.nv-axis").attr("transform", "translate(0," + d.range()[0] + ")").call(r), i.scale(d).ticks(i.ticks() && i.ticks().length ? i.ticks() : B / 36).tickSize(-H, 0), U.select(".nv-y.nv-axis").call(i), g && (u.getData(t.x()).scale(p).width(H).color(n.map(function(e, t) {
return e.color || h(e, t);
}).filter(function(e, t) {
return !n[t].disabled;
})), R.select(".nv-distWrap").append("g").attr("class", "nv-distributionX"), U.select(".nv-distributionX").attr("transform", "translate(0," + d.range()[0] + ")").datum(n.filter(function(e) {
return !e.disabled;
})).call(u)), y && (a.getData(t.y()).scale(d).width(B).color(n.map(function(e, t) {
return e.color || h(e, t);
}).filter(function(e, t) {
return !n[t].disabled;
})), R.select(".nv-distWrap").append("g").attr("class", "nv-distributionY"), U.select(".nv-distributionY").attr("transform", "translate(-" + a.size() + ",0)").datum(n.filter(function(e) {
return !e.disabled;
})).call(a)), d3.fisheye && (U.select(".nv-background").attr("width", H).attr("height", B), U.select(".nv-background").on("mousemove", T), U.select(".nv-background").on("click", function() {
S = !S;
}), t.dispatch.on("elementClick.freezeFisheye", function() {
S = !S;
})), o.dispatch.on("legendClick", function(n, s) {
n.disabled = !n.disabled, E = n.disabled ? 0 : 2.5, U.select(".nv-background").style("pointer-events", n.disabled ? "none" : "all"), U.select(".nv-point-paths").style("pointer-events", n.disabled ? "all" : "none"), n.disabled ? (p.distortion(E).focus(0), d.distortion(E).focus(0), U.select(".nv-scatterWrap").call(t), U.select(".nv-x.nv-axis").call(r), U.select(".nv-y.nv-axis").call(i)) : S = !1, e.update();
}), s.dispatch.on("legendClick", function(t, r, i) {
t.disabled = !t.disabled, n.filter(function(e) {
return !e.disabled;
}).length || n.map(function(e) {
return e.disabled = !1, I.selectAll(".nv-series").classed("disabled", !1), e;
}), k.disabled = n.map(function(e) {
return !!e.disabled;
}), A.stateChange(k), e.update();
}), s.dispatch.on("legendDblclick", function(t) {
n.forEach(function(e) {
e.disabled = !0;
}), t.disabled = !1, k.disabled = n.map(function(e) {
return !!e.disabled;
}), A.stateChange(k), e.update();
}), t.dispatch.on("elementMouseover.tooltip", function(e) {
d3.select(".nv-chart-" + t.id() + " .nv-series-" + e.seriesIndex + " .nv-distx-" + e.pointIndex).attr("y1", function(t, n) {
return e.pos[1] - B;
}), d3.select(".nv-chart-" + t.id() + " .nv-series-" + e.seriesIndex + " .nv-disty-" + e.pointIndex).attr("x2", e.pos[0] + u.size()), e.pos = [ e.pos[0] + f.left, e.pos[1] + f.top ], A.tooltipShow(e);
}), A.on("tooltipShow", function(e) {
x && D(e, C.parentNode);
}), A.on("changeState", function(t) {
typeof t.disabled != "undefined" && (n.forEach(function(e, n) {
e.disabled = t.disabled[n];
}), k.disabled = t.disabled), e.update();
}), M = p.copy(), _ = d.copy();
}), e;
}
var t = n.models.scatter(), r = n.models.axis(), i = n.models.axis(), s = n.models.legend(), o = n.models.legend(), u = n.models.distribution(), a = n.models.distribution(), f = {
top: 30,
right: 20,
bottom: 50,
left: 75
}, l = null, c = null, h = n.utils.defaultColor(), p = d3.fisheye ? d3.fisheye.scale(d3.scale.linear).distortion(0) : t.xScale(), d = d3.fisheye ? d3.fisheye.scale(d3.scale.linear).distortion(0) : t.yScale(), v = 0, m = 0, g = !1, y = !1, b = !0, w = !!d3.fisheye, E = 0, S = !1, x = !0, T = function(e, t, n) {
return "<strong>" + t + "</strong>";
}, N = function(e, t, n) {
return "<strong>" + n + "</strong>";
}, C = null, k = {}, L = null, A = d3.dispatch("tooltipShow", "tooltipHide", "stateChange", "changeState"), O = "No Data Available.";
t.xScale(p).yScale(d), r.orient("bottom").tickPadding(10), i.orient("left").tickPadding(10), u.axis("x"), a.axis("y");
var M, _, D = function(s, o) {
var u = s.pos[0] + (o.offsetLeft || 0), a = s.pos[1] + (o.offsetTop || 0), l = s.pos[0] + (o.offsetLeft || 0), c = d.range()[0] + f.top + (o.offsetTop || 0), h = p.range()[0] + f.left + (o.offsetLeft || 0), v = s.pos[1] + (o.offsetTop || 0), m = r.tickFormat()(t.x()(s.point, s.pointIndex)), g = i.tickFormat()(t.y()(s.point, s.pointIndex));
T != null && n.tooltip.show([ l, c ], T(s.series.key, m, g, s, e), "n", 1, o, "x-nvtooltip"), N != null && n.tooltip.show([ h, v ], N(s.series.key, m, g, s, e), "e", 1, o, "y-nvtooltip"), C != null && n.tooltip.show([ u, a ], C(s.series.key, m, g, s, e), s.value < 0 ? "n" : "s", null, o);
}, P = [ {
key: "Magnify",
disabled: !0
} ];
return t.dispatch.on("elementMouseout.tooltip", function(e) {
A.tooltipHide(e), d3.select(".nv-chart-" + t.id() + " .nv-series-" + e.seriesIndex + " .nv-distx-" + e.pointIndex).attr("y1", 0), d3.select(".nv-chart-" + t.id() + " .nv-series-" + e.seriesIndex + " .nv-disty-" + e.pointIndex).attr("x2", a.size());
}), A.on("tooltipHide", function() {
x && n.tooltip.cleanup();
}), e.dispatch = A, e.scatter = t, e.legend = s, e.controls = o, e.xAxis = r, e.yAxis = i, e.distX = u, e.distY = a, d3.rebind(e, t, "id", "interactive", "pointActive", "x", "y", "shape", "size", "xScale", "yScale", "zScale", "xDomain", "yDomain", "sizeDomain", "sizeRange", "forceX", "forceY", "forceSize", "clipVoronoi", "clipRadius", "useVoronoi"), e.margin = function(t) {
return arguments.length ? (f.top = typeof t.top != "undefined" ? t.top : f.top, f.right = typeof t.right != "undefined" ? t.right : f.right, f.bottom = typeof t.bottom != "undefined" ? t.bottom : f.bottom, f.left = typeof t.left != "undefined" ? t.left : f.left, e) : f;
}, e.width = function(t) {
return arguments.length ? (l = t, e) : l;
}, e.height = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.color = function(t) {
return arguments.length ? (h = n.utils.getColor(t), s.color(h), u.color(h), a.color(h), e) : h;
}, e.showDistX = function(t) {
return arguments.length ? (g = t, e) : g;
}, e.showDistY = function(t) {
return arguments.length ? (y = t, e) : y;
}, e.showControls = function(t) {
return arguments.length ? (w = t, e) : w;
}, e.showLegend = function(t) {
return arguments.length ? (b = t, e) : b;
}, e.fisheye = function(t) {
return arguments.length ? (E = t, e) : E;
}, e.xPadding = function(t) {
return arguments.length ? (v = t, e) : v;
}, e.yPadding = function(t) {
return arguments.length ? (m = t, e) : m;
}, e.tooltips = function(t) {
return arguments.length ? (x = t, e) : x;
}, e.tooltipContent = function(t) {
return arguments.length ? (C = t, e) : C;
}, e.tooltipXContent = function(t) {
return arguments.length ? (T = t, e) : T;
}, e.tooltipYContent = function(t) {
return arguments.length ? (N = t, e) : N;
}, e.state = function(t) {
return arguments.length ? (k = t, e) : k;
}, e.defaultState = function(t) {
return arguments.length ? (L = t, e) : L;
}, e.noData = function(t) {
return arguments.length ? (O = t, e) : O;
}, e;
}, n.models.scatterPlusLineChart = function() {
function e(n) {
return n.each(function(n) {
function S() {
if (w) return q.select(".nv-point-paths").style("pointer-events", "all"), !1;
q.select(".nv-point-paths").style("pointer-events", "none");
var e = d3.mouse(this);
p.distortion(b).focus(e[0]), d.distortion(b).focus(e[1]), q.select(".nv-scatterWrap").datum(n.filter(function(e) {
return !e.disabled;
})).call(t), q.select(".nv-x.nv-axis").call(r), q.select(".nv-y.nv-axis").call(i), q.select(".nv-distributionX").datum(n.filter(function(e) {
return !e.disabled;
})).call(u), q.select(".nv-distributionY").datum(n.filter(function(e) {
return !e.disabled;
})).call(a);
}
var x = d3.select(this), T = this, D = (l || parseInt(x.style("width")) || 960) - f.left - f.right, P = (c || parseInt(x.style("height")) || 400) - f.top - f.bottom;
e.update = function() {
x.transition().call(e);
}, e.container = this, N.disabled = n.map(function(e) {
return !!e.disabled;
});
if (!C) {
var H;
C = {};
for (H in N) N[H] instanceof Array ? C[H] = N[H].slice(0) : C[H] = N[H];
}
if (!n || !n.length || !n.filter(function(e) {
return e.values.length;
}).length) {
var B = x.selectAll(".nv-noData").data([ L ]);
return B.enter().append("text").attr("class", "nvd3 nv-noData").attr("dy", "-.7em").style("text-anchor", "middle"), B.attr("x", f.left + D / 2).attr("y", f.top + P / 2).text(function(e) {
return e;
}), e;
}
x.selectAll(".nv-noData").remove(), p = t.xScale(), d = t.yScale(), A = A || p, O = O || d;
var j = x.selectAll("g.nv-wrap.nv-scatterChart").data([ n ]), F = j.enter().append("g").attr("class", "nvd3 nv-wrap nv-scatterChart nv-chart-" + t.id()), I = F.append("g"), q = j.select("g");
I.append("rect").attr("class", "nvd3 nv-background"), I.append("g").attr("class", "nv-x nv-axis"), I.append("g").attr("class", "nv-y nv-axis"), I.append("g").attr("class", "nv-scatterWrap"), I.append("g").attr("class", "nv-regressionLinesWrap"), I.append("g").attr("class", "nv-distWrap"), I.append("g").attr("class", "nv-legendWrap"), I.append("g").attr("class", "nv-controlsWrap"), j.attr("transform", "translate(" + f.left + "," + f.top + ")"), g && (s.width(D / 2), j.select(".nv-legendWrap").datum(n).call(s), f.top != s.height() && (f.top = s.height(), P = (c || parseInt(x.style("height")) || 400) - f.top - f.bottom), j.select(".nv-legendWrap").attr("transform", "translate(" + D / 2 + "," + -f.top + ")")), y && (o.width(180).color([ "#444" ]), q.select(".nv-controlsWrap").datum(_).attr("transform", "translate(0," + -f.top + ")").call(o)), t.width(D).height(P).color(n.map(function(e, t) {
return e.color || h(e, t);
}).filter(function(e, t) {
return !n[t].disabled;
})), j.select(".nv-scatterWrap").datum(n.filter(function(e) {
return !e.disabled;
})).call(t), j.select(".nv-regressionLinesWrap").attr("clip-path", "url(#nv-edge-clip-" + t.id() + ")");
var R = j.select(".nv-regressionLinesWrap").selectAll(".nv-regLines").data(function(e) {
return e;
}), U = R.enter().append("g").attr("class", "nv-regLines").append("line").attr("class", "nv-regLine").style("stroke-opacity", 0);
R.selectAll(".nv-regLines line").attr("x1", p.range()[0]).attr("x2", p.range()[1]).attr("y1", function(e, t) {
return d(p.domain()[0] * e.slope + e.intercept);
}).attr("y2", function(e, t) {
return d(p.domain()[1] * e.slope + e.intercept);
}).style("stroke", function(e, t, n) {
return h(e, n);
}).style("stroke-opacity", function(e, t) {
return e.disabled || typeof e.slope == "undefined" || typeof e.intercept == "undefined" ? 0 : 1;
}), r.scale(p).ticks(r.ticks() ? r.ticks() : D / 100).tickSize(-P, 0), q.select(".nv-x.nv-axis").attr("transform", "translate(0," + d.range()[0] + ")").call(r), i.scale(d).ticks(i.ticks() ? i.ticks() : P / 36).tickSize(-D, 0), q.select(".nv-y.nv-axis").call(i), v && (u.getData(t.x()).scale(p).width(D).color(n.map(function(e, t) {
return e.color || h(e, t);
}).filter(function(e, t) {
return !n[t].disabled;
})), I.select(".nv-distWrap").append("g").attr("class", "nv-distributionX"), q.select(".nv-distributionX").attr("transform", "translate(0," + d.range()[0] + ")").datum(n.filter(function(e) {
return !e.disabled;
})).call(u)), m && (a.getData(t.y()).scale(d).width(P).color(n.map(function(e, t) {
return e.color || h(e, t);
}).filter(function(e, t) {
return !n[t].disabled;
})), I.select(".nv-distWrap").append("g").attr("class", "nv-distributionY"), q.select(".nv-distributionY").attr("transform", "translate(-" + a.size() + ",0)").datum(n.filter(function(e) {
return !e.disabled;
})).call(a)), d3.fisheye && (q.select(".nv-background").attr("width", D).attr("height", P), q.select(".nv-background").on("mousemove", S), q.select(".nv-background").on("click", function() {
w = !w;
}), t.dispatch.on("elementClick.freezeFisheye", function() {
w = !w;
})), o.dispatch.on("legendClick", function(n, s) {
n.disabled = !n.disabled, b = n.disabled ? 0 : 2.5, q.select(".nv-background").style("pointer-events", n.disabled ? "none" : "all"), q.select(".nv-point-paths").style("pointer-events", n.disabled ? "all" : "none"), n.disabled ? (p.distortion(b).focus(0), d.distortion(b).focus(0), q.select(".nv-scatterWrap").call(t), q.select(".nv-x.nv-axis").call(r), q.select(".nv-y.nv-axis").call(i)) : w = !1, e.update();
}), s.dispatch.on("legendClick", function(t, r, i) {
t.disabled = !t.disabled, n.filter(function(e) {
return !e.disabled;
}).length || n.map(function(e) {
return e.disabled = !1, j.selectAll(".nv-series").classed("disabled", !1), e;
}), N.disabled = n.map(function(e) {
return !!e.disabled;
}), k.stateChange(N), e.update();
}), s.dispatch.on("legendDblclick", function(t) {
n.forEach(function(e) {
e.disabled = !0;
}), t.disabled = !1, N.disabled = n.map(function(e) {
return !!e.disabled;
}), k.stateChange(N), e.update();
}), t.dispatch.on("elementMouseover.tooltip", function(e) {
d3.select(".nv-chart-" + t.id() + " .nv-series-" + e.seriesIndex + " .nv-distx-" + e.pointIndex).attr("y1", e.pos[1] - P), d3.select(".nv-chart-" + t.id() + " .nv-series-" + e.seriesIndex + " .nv-disty-" + e.pointIndex).attr("x2", e.pos[0] + u.size()), e.pos = [ e.pos[0] + f.left, e.pos[1] + f.top ], k.tooltipShow(e);
}), k.on("tooltipShow", function(e) {
E && M(e, T.parentNode);
}), k.on("changeState", function(t) {
typeof t.disabled != "undefined" && (n.forEach(function(e, n) {
e.disabled = t.disabled[n];
}), N.disabled = t.disabled), e.update();
}), A = p.copy(), O = d.copy();
}), e;
}
var t = n.models.scatter(), r = n.models.axis(), i = n.models.axis(), s = n.models.legend(), o = n.models.legend(), u = n.models.distribution(), a = n.models.distribution(), f = {
top: 30,
right: 20,
bottom: 50,
left: 75
}, l = null, c = null, h = n.utils.defaultColor(), p = d3.fisheye ? d3.fisheye.scale(d3.scale.linear).distortion(0) : t.xScale(), d = d3.fisheye ? d3.fisheye.scale(d3.scale.linear).distortion(0) : t.yScale(), v = !1, m = !1, g = !0, y = !!d3.fisheye, b = 0, w = !1, E = !0, S = function(e, t, n) {
return "<strong>" + t + "</strong>";
}, x = function(e, t, n) {
return "<strong>" + n + "</strong>";
}, T = function(e, t, n, r) {
return "<h3>" + e + "</h3>" + "<p>" + r + "</p>";
}, N = {}, C = null, k = d3.dispatch("tooltipShow", "tooltipHide", "stateChange", "changeState"), L = "No Data Available.";
t.xScale(p).yScale(d), r.orient("bottom").tickPadding(10), i.orient("left").tickPadding(10), u.axis("x"), a.axis("y");
var A, O, M = function(s, o) {
var u = s.pos[0] + (o.offsetLeft || 0), a = s.pos[1] + (o.offsetTop || 0), l = s.pos[0] + (o.offsetLeft || 0), c = d.range()[0] + f.top + (o.offsetTop || 0), h = p.range()[0] + f.left + (o.offsetLeft || 0), v = s.pos[1] + (o.offsetTop || 0), m = r.tickFormat()(t.x()(s.point, s.pointIndex)), g = i.tickFormat()(t.y()(s.point, s.pointIndex));
S != null && n.tooltip.show([ l, c ], S(s.series.key, m, g, s, e), "n", 1, o, "x-nvtooltip"), x != null && n.tooltip.show([ h, v ], x(s.series.key, m, g, s, e), "e", 1, o, "y-nvtooltip"), T != null && n.tooltip.show([ u, a ], T(s.series.key, m, g, s.point.tooltip, s, e), s.value < 0 ? "n" : "s", null, o);
}, _ = [ {
key: "Magnify",
disabled: !0
} ];
return t.dispatch.on("elementMouseout.tooltip", function(e) {
k.tooltipHide(e), d3.select(".nv-chart-" + t.id() + " .nv-series-" + e.seriesIndex + " .nv-distx-" + e.pointIndex).attr("y1", 0), d3.select(".nv-chart-" + t.id() + " .nv-series-" + e.seriesIndex + " .nv-disty-" + e.pointIndex).attr("x2", a.size());
}), k.on("tooltipHide", function() {
E && n.tooltip.cleanup();
}), e.dispatch = k, e.scatter = t, e.legend = s, e.controls = o, e.xAxis = r, e.yAxis = i, e.distX = u, e.distY = a, d3.rebind(e, t, "id", "interactive", "pointActive", "x", "y", "shape", "size", "xScale", "yScale", "zScale", "xDomain", "yDomain", "sizeDomain", "sizeRange", "forceX", "forceY", "forceSize", "clipVoronoi", "clipRadius", "useVoronoi"), e.margin = function(t) {
return arguments.length ? (f.top = typeof t.top != "undefined" ? t.top : f.top, f.right = typeof t.right != "undefined" ? t.right : f.right, f.bottom = typeof t.bottom != "undefined" ? t.bottom : f.bottom, f.left = typeof t.left != "undefined" ? t.left : f.left, e) : f;
}, e.width = function(t) {
return arguments.length ? (l = t, e) : l;
}, e.height = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.color = function(t) {
return arguments.length ? (h = n.utils.getColor(t), s.color(h), u.color(h), a.color(h), e) : h;
}, e.showDistX = function(t) {
return arguments.length ? (v = t, e) : v;
}, e.showDistY = function(t) {
return arguments.length ? (m = t, e) : m;
}, e.showControls = function(t) {
return arguments.length ? (y = t, e) : y;
}, e.showLegend = function(t) {
return arguments.length ? (g = t, e) : g;
}, e.fisheye = function(t) {
return arguments.length ? (b = t, e) : b;
}, e.tooltips = function(t) {
return arguments.length ? (E = t, e) : E;
}, e.tooltipContent = function(t) {
return arguments.length ? (T = t, e) : T;
}, e.tooltipXContent = function(t) {
return arguments.length ? (S = t, e) : S;
}, e.tooltipYContent = function(t) {
return arguments.length ? (x = t, e) : x;
}, e.state = function(t) {
return arguments.length ? (N = t, e) : N;
}, e.defaultState = function(t) {
return arguments.length ? (C = t, e) : C;
}, e.noData = function(t) {
return arguments.length ? (L = t, e) : L;
}, e;
}, n.models.sparkline = function() {
function e(n) {
return n.each(function(e) {
var n = r - t.left - t.right, s = i - t.top - t.bottom, p = d3.select(this);
o.domain(c || d3.extent(e, a)).range([ 0, n ]), u.domain(h || d3.extent(e, f)).range([ s, 0 ]);
var d = p.selectAll("g.nv-wrap.nv-sparkline").data([ e ]), v = d.enter().append("g").attr("class", "nvd3 nv-wrap nv-sparkline"), m = v.append("g"), g = d.select("g");
d.attr("transform", "translate(" + t.left + "," + t.top + ")");
var y = d.selectAll("path").data(function(e) {
return [ e ];
});
y.enter().append("path"), y.exit().remove(), y.style("stroke", function(e, t) {
return e.color || l(e, t);
}).attr("d", d3.svg.line().x(function(e, t) {
return o(a(e, t));
}).y(function(e, t) {
return u(f(e, t));
}));
var b = d.selectAll("circle.nv-point").data(function(e) {
function t(t) {
if (t != -1) {
var n = e[t];
return n.pointIndex = t, n;
}
return null;
}
var n = e.map(function(e, t) {
return f(e, t);
}), r = t(n.lastIndexOf(u.domain()[1])), i = t(n.indexOf(u.domain()[0])), s = t(n.length - 1);
return [ i, r, s ].filter(function(e) {
return e != null;
});
});
b.enter().append("circle"), b.exit().remove(), b.attr("cx", function(e, t) {
return o(a(e, e.pointIndex));
}).attr("cy", function(e, t) {
return u(f(e, e.pointIndex));
}).attr("r", 2).attr("class", function(e, t) {
return a(e, e.pointIndex) == o.domain()[1] ? "nv-point nv-currentValue" : f(e, e.pointIndex) == u.domain()[0] ? "nv-point nv-minValue" : "nv-point nv-maxValue";
});
}), e;
}
var t = {
top: 2,
right: 0,
bottom: 2,
left: 0
}, r = 400, i = 32, s = !0, o = d3.scale.linear(), u = d3.scale.linear(), a = function(e) {
return e.x;
}, f = function(e) {
return e.y;
}, l = n.utils.getColor([ "#000" ]), c, h;
return e.margin = function(n) {
return arguments.length ? (t.top = typeof n.top != "undefined" ? n.top : t.top, t.right = typeof n.right != "undefined" ? n.right : t.right, t.bottom = typeof n.bottom != "undefined" ? n.bottom : t.bottom, t.left = typeof n.left != "undefined" ? n.left : t.left, e) : t;
}, e.width = function(t) {
return arguments.length ? (r = t, e) : r;
}, e.height = function(t) {
return arguments.length ? (i = t, e) : i;
}, e.x = function(t) {
return arguments.length ? (a = d3.functor(t), e) : a;
}, e.y = function(t) {
return arguments.length ? (f = d3.functor(t), e) : f;
}, e.xScale = function(t) {
return arguments.length ? (o = t, e) : o;
}, e.yScale = function(t) {
return arguments.length ? (u = t, e) : u;
}, e.xDomain = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.yDomain = function(t) {
return arguments.length ? (h = t, e) : h;
}, e.animate = function(t) {
return arguments.length ? (s = t, e) : s;
}, e.color = function(t) {
return arguments.length ? (l = n.utils.getColor(t), e) : l;
}, e;
}, n.models.sparklinePlus = function() {
function e(n) {
return n.each(function(h) {
function m() {
if (f) return;
var e = C.selectAll(".nv-hoverValue").data(a), n = e.enter().append("g").attr("class", "nv-hoverValue").style("stroke-opacity", 0).style("fill-opacity", 0);
e.exit().transition().duration(250).style("stroke-opacity", 0).style("fill-opacity", 0).remove(), e.attr("transform", function(e) {
return "translate(" + o(t.x()(h[e], e)) + ",0)";
}).transition().duration(250).style("stroke-opacity", 1).style("fill-opacity", 1);
if (!a.length) return;
n.append("line").attr("x1", 0).attr("y1", -r.top).attr("x2", 0).attr("y2", w), n.append("text").attr("class", "nv-xValue").attr("x", -6).attr("y", -r.top).attr("text-anchor", "end").attr("dy", ".9em"), C.select(".nv-hoverValue .nv-xValue").text(l(t.x()(h[a[0]], a[0]))), n.append("text").attr("class", "nv-yValue").attr("x", 6).attr("y", -r.top).attr("text-anchor", "start").attr("dy", ".9em"), C.select(".nv-hoverValue .nv-yValue").text(c(t.y()(h[a[0]], a[0])));
}
function g() {
function e(e, n) {
var r = Math.abs(t.x()(e[0], 0) - n), i = 0;
for (var s = 0; s < e.length; s++) Math.abs(t.x()(e[s], s) - n) < r && (r = Math.abs(t.x()(e[s], s) - n), i = s);
return i;
}
if (f) return;
var n = d3.mouse(this)[0] - r.left;
a = [ e(h, Math.round(o.invert(n))) ], m();
}
var y = d3.select(this), b = (i || parseInt(y.style("width")) || 960) - r.left - r.right, w = (s || parseInt(y.style("height")) || 400) - r.top - r.bottom;
e.update = function() {
e(n);
}, e.container = this;
if (!h || !h.length) {
var E = y.selectAll(".nv-noData").data([ v ]);
return E.enter().append("text").attr("class", "nvd3 nv-noData").attr("dy", "-.7em").style("text-anchor", "middle"), E.attr("x", r.left + b / 2).attr("y", r.top + w / 2).text(function(e) {
return e;
}), e;
}
y.selectAll(".nv-noData").remove();
var S = t.y()(h[h.length - 1], h.length - 1);
o = t.xScale(), u = t.yScale();
var x = y.selectAll("g.nv-wrap.nv-sparklineplus").data([ h ]), T = x.enter().append("g").attr("class", "nvd3 nv-wrap nv-sparklineplus"), N = T.append("g"), C = x.select("g");
N.append("g").attr("class", "nv-sparklineWrap"), N.append("g").attr("class", "nv-valueWrap"), N.append("g").attr("class", "nv-hoverArea"), x.attr("transform", "translate(" + r.left + "," + r.top + ")");
var k = C.select(".nv-sparklineWrap");
t.width(b).height(w), k.call(t);
var L = C.select(".nv-valueWrap"), A = L.selectAll(".nv-currentValue").data([ S ]);
A.enter().append("text").attr("class", "nv-currentValue").attr("dx", d ? -8 : 8).attr("dy", ".9em").style("text-anchor", d ? "end" : "start"), A.attr("x", b + (d ? r.right : 0)).attr("y", p ? function(e) {
return u(e);
} : 0).style("fill", t.color()(h[h.length - 1], h.length - 1)).text(c(S)), N.select(".nv-hoverArea").append("rect").on("mousemove", g).on("click", function() {
f = !f;
}).on("mouseout", function() {
a = [], m();
}), C.select(".nv-hoverArea rect").attr("transform", function(e) {
return "translate(" + -r.left + "," + -r.top + ")";
}).attr("width", b + r.left + r.right).attr("height", w + r.top);
}), e;
}
var t = n.models.sparkline(), r = {
top: 15,
right: 100,
bottom: 10,
left: 50
}, i = null, s = null, o, u, a = [], f = !1, l = d3.format(",r"), c = d3.format(",.2f"), h = !0, p = !0, d = !1, v = "No Data Available.";
return e.sparkline = t, d3.rebind(e, t, "x", "y", "xScale", "yScale", "color"), e.margin = function(t) {
return arguments.length ? (r.top = typeof t.top != "undefined" ? t.top : r.top, r.right = typeof t.right != "undefined" ? t.right : r.right, r.bottom = typeof t.bottom != "undefined" ? t.bottom : r.bottom, r.left = typeof t.left != "undefined" ? t.left : r.left, e) : r;
}, e.width = function(t) {
return arguments.length ? (i = t, e) : i;
}, e.height = function(t) {
return arguments.length ? (s = t, e) : s;
}, e.xTickFormat = function(t) {
return arguments.length ? (l = t, e) : l;
}, e.yTickFormat = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.showValue = function(t) {
return arguments.length ? (h = t, e) : h;
}, e.alignValue = function(t) {
return arguments.length ? (p = t, e) : p;
}, e.rightAlignValue = function(t) {
return arguments.length ? (d = t, e) : d;
}, e.noData = function(t) {
return arguments.length ? (v = t, e) : v;
}, e;
}, n.models.stackedArea = function() {
function e(n) {
return n.each(function(e) {
var n = r - t.left - t.right, f = i - t.top - t.bottom, y = d3.select(this);
d = m.xScale(), v = m.yScale(), e = e.map(function(e, t) {
return e.values = e.values.map(function(t, n) {
return t.index = n, t.stackedY = e.disabled ? 0 : a(t, n), t;
}), e;
}), e = d3.layout.stack().order(c).offset(l).values(function(e) {
return e.values;
}).x(u).y(function(e) {
return e.stackedY;
}).out(function(e, t, n) {
e.display = {
y: n,
y0: t
};
})(e);
var b = y.selectAll("g.nv-wrap.nv-stackedarea").data([ e ]), w = b.enter().append("g").attr("class", "nvd3 nv-wrap nv-stackedarea"), E = w.append("defs"), S = w.append("g"), x = b.select("g");
S.append("g").attr("class", "nv-areaWrap"), S.append("g").attr("class", "nv-scatterWrap"), b.attr("transform", "translate(" + t.left + "," + t.top + ")"), m.width(n).height(f).x(u).y(function(e) {
return e.display.y + e.display.y0;
}).forceY([ 0 ]).color(e.map(function(e, t) {
return e.color || s(e, t);
}).filter(function(t, n) {
return !e[n].disabled;
}));
var T = x.select(".nv-scatterWrap").datum(e.filter(function(e) {
return !e.disabled;
}));
T.call(m), E.append("clipPath").attr("id", "nv-edge-clip-" + o).append("rect"), b.select("#nv-edge-clip-" + o + " rect").attr("width", n).attr("height", f), x.attr("clip-path", p ? "url(#nv-edge-clip-" + o + ")" : "");
var N = d3.svg.area().x(function(e, t) {
return d(u(e, t));
}).y0(function(e) {
return v(e.display.y0);
}).y1(function(e) {
return v(e.display.y + e.display.y0);
}).interpolate(h), C = d3.svg.area().x(function(e, t) {
return d(u(e, t));
}).y0(function(e) {
return v(e.display.y0);
}).y1(function(e) {
return v(e.display.y0);
}), k = x.select(".nv-areaWrap").selectAll("path.nv-area").data(function(e) {
return e;
});
k.enter().append("path").attr("class", function(e, t) {
return "nv-area nv-area-" + t;
}).on("mouseover", function(e, t) {
d3.select(this).classed("hover", !0), g.areaMouseover({
point: e,
series: e.key,
pos: [ d3.event.pageX, d3.event.pageY ],
seriesIndex: t
});
}).on("mouseout", function(e, t) {
d3.select(this).classed("hover", !1), g.areaMouseout({
point: e,
series: e.key,
pos: [ d3.event.pageX, d3.event.pageY ],
seriesIndex: t
});
}).on("click", function(e, t) {
d3.select(this).classed("hover", !1), g.areaClick({
point: e,
series: e.key,
pos: [ d3.event.pageX, d3.event.pageY ],
seriesIndex: t
});
}), k.exit().attr("d", function(e, t) {
return C(e.values, t);
}).remove(), k.style("fill", function(e, t) {
return e.color || s(e, t);
}).style("stroke", function(e, t) {
return e.color || s(e, t);
}), k.attr("d", function(e, t) {
return N(e.values, t);
}), m.dispatch.on("elementMouseover.area", function(e) {
x.select(".nv-chart-" + o + " .nv-area-" + e.seriesIndex).classed("hover", !0);
}), m.dispatch.on("elementMouseout.area", function(e) {
x.select(".nv-chart-" + o + " .nv-area-" + e.seriesIndex).classed("hover", !1);
});
}), e;
}
var t = {
top: 0,
right: 0,
bottom: 0,
left: 0
}, r = 960, i = 500, s = n.utils.defaultColor(), o = Math.floor(Math.random() * 1e5), u = function(e) {
return e.x;
}, a = function(e) {
return e.y;
}, f = "stack", l = "zero", c = "default", h = "linear", p = !1, d, v, m = n.models.scatter(), g = d3.dispatch("tooltipShow", "tooltipHide", "areaClick", "areaMouseover", "areaMouseout");
return m.size(2.2).sizeDomain([ 2.2, 2.2 ]), m.dispatch.on("elementClick.area", function(e) {
g.areaClick(e);
}), m.dispatch.on("elementMouseover.tooltip", function(e) {
e.pos = [ e.pos[0] + t.left, e.pos[1] + t.top ], g.tooltipShow(e);
}), m.dispatch.on("elementMouseout.tooltip", function(e) {
g.tooltipHide(e);
}), e.dispatch = g, e.scatter = m, d3.rebind(e, m, "interactive", "size", "xScale", "yScale", "zScale", "xDomain", "yDomain", "sizeDomain", "forceX", "forceY", "forceSize", "clipVoronoi", "clipRadius"), e.x = function(t) {
return arguments.length ? (u = d3.functor(t), e) : u;
}, e.y = function(t) {
return arguments.length ? (a = d3.functor(t), e) : a;
}, e.margin = function(n) {
return arguments.length ? (t.top = typeof n.top != "undefined" ? n.top : t.top, t.right = typeof n.right != "undefined" ? n.right : t.right, t.bottom = typeof n.bottom != "undefined" ? n.bottom : t.bottom, t.left = typeof n.left != "undefined" ? n.left : t.left, e) : t;
}, e.width = function(t) {
return arguments.length ? (r = t, e) : r;
}, e.height = function(t) {
return arguments.length ? (i = t, e) : i;
}, e.clipEdge = function(t) {
return arguments.length ? (p = t, e) : p;
}, e.color = function(t) {
return arguments.length ? (s = n.utils.getColor(t), e) : s;
}, e.offset = function(t) {
return arguments.length ? (l = t, e) : l;
}, e.order = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.style = function(t) {
if (!arguments.length) return f;
f = t;
switch (f) {
case "stack":
e.offset("zero"), e.order("default");
break;
case "stream":
e.offset("wiggle"), e.order("inside-out");
break;
case "stream-center":
e.offset("silhouette"), e.order("inside-out");
break;
case "expand":
e.offset("expand"), e.order("default");
}
return e;
}, e.interpolate = function(e) {
return arguments.length ? (h = e, h) : h;
}, e;
}, n.models.stackedAreaChart = function() {
function e(n) {
return n.each(function(n) {
var l = d3.select(this), d = this, T = (a || parseInt(l.style("width")) || 960) - u.left - u.right, N = (f || parseInt(l.style("height")) || 400) - u.top - u.bottom;
e.update = function() {
l.transition().call(e);
}, e.container = this, y.disabled = n.map(function(e) {
return !!e.disabled;
});
if (!b) {
var C;
b = {};
for (C in y) y[C] instanceof Array ? b[C] = y[C].slice(0) : b[C] = y[C];
}
if (!n || !n.length || !n.filter(function(e) {
return e.values.length;
}).length) {
var k = l.selectAll(".nv-noData").data([ w ]);
return k.enter().append("text").attr("class", "nvd3 nv-noData").attr("dy", "-.7em").style("text-anchor", "middle"), k.attr("x", u.left + T / 2).attr("y", u.top + N / 2).text(function(e) {
return e;
}), e;
}
l.selectAll(".nv-noData").remove(), v = t.xScale(), m = t.yScale();
var L = l.selectAll("g.nv-wrap.nv-stackedAreaChart").data([ n ]), A = L.enter().append("g").attr("class", "nvd3 nv-wrap nv-stackedAreaChart").append("g"), O = L.select("g");
A.append("g").attr("class", "nv-x nv-axis"), A.append("g").attr("class", "nv-y nv-axis"), A.append("g").attr("class", "nv-stackedWrap"), A.append("g").attr("class", "nv-legendWrap"), A.append("g").attr("class", "nv-controlsWrap"), h && (s.width(T - S), O.select(".nv-legendWrap").datum(n).call(s), u.top != s.height() && (u.top = s.height(), N = (f || parseInt(l.style("height")) || 400) - u.top - u.bottom), O.select(".nv-legendWrap").attr("transform", "translate(" + S + "," + -u.top + ")"));
if (c) {
var M = [ {
key: "Stacked",
disabled: t.offset() != "zero"
}, {
key: "Stream",
disabled: t.offset() != "wiggle"
}, {
key: "Expanded",
disabled: t.offset() != "expand"
} ];
o.width(S).color([ "#444", "#444", "#444" ]), O.select(".nv-controlsWrap").datum(M).call(o), u.top != Math.max(o.height(), s.height()) && (u.top = Math.max(o.height(), s.height()), N = (f || parseInt(l.style("height")) || 400) - u.top - u.bottom), O.select(".nv-controlsWrap").attr("transform", "translate(0," + -u.top + ")");
}
L.attr("transform", "translate(" + u.left + "," + u.top + ")"), t.width(T).height(N);
var _ = O.select(".nv-stackedWrap").datum(n);
_.call(t), r.scale(v).ticks(T / 100).tickSize(-N, 0), O.select(".nv-x.nv-axis").attr("transform", "translate(0," + N + ")"), O.select(".nv-x.nv-axis").transition().duration(0).call(r), i.scale(m).ticks(t.offset() == "wiggle" ? 0 : N / 36).tickSize(-T, 0).setTickFormat(t.offset() == "expand" ? d3.format("%") : g), O.select(".nv-y.nv-axis").transition().duration(0).call(i), t.dispatch.on("areaClick.toggle", function(t) {
n.filter(function(e) {
return !e.disabled;
}).length === 1 ? n = n.map(function(e) {
return e.disabled = !1, e;
}) : n = n.map(function(e, n) {
return e.disabled = n != t.seriesIndex, e;
}), y.disabled = n.map(function(e) {
return !!e.disabled;
}), E.stateChange(y), e.update();
}), s.dispatch.on("legendClick", function(t, r) {
t.disabled = !t.disabled, n.filter(function(e) {
return !e.disabled;
}).length || n.map(function(e) {
return e.disabled = !1, e;
}), y.disabled = n.map(function(e) {
return !!e.disabled;
}), E.stateChange(y), e.update();
}), s.dispatch.on("legendDblclick", function(t) {
n.forEach(function(e) {
e.disabled = !0;
}), t.disabled = !1, y.disabled = n.map(function(e) {
return !!e.disabled;
}), E.stateChange(y), e.update();
}), o.dispatch.on("legendClick", function(n, r) {
if (!n.disabled) return;
M = M.map(function(e) {
return e.disabled = !0, e;
}), n.disabled = !1;
switch (n.key) {
case "Stacked":
t.style("stack");
break;
case "Stream":
t.style("stream");
break;
case "Expanded":
t.style("expand");
}
y.style = t.style(), E.stateChange(y), e.update();
}), E.on("tooltipShow", function(e) {
p && x(e, d.parentNode);
}), E.on("changeState", function(r) {
typeof r.disabled != "undefined" && (n.forEach(function(e, t) {
e.disabled = r.disabled[t];
}), y.disabled = r.disabled), typeof r.style != "undefined" && t.style(r.style), e.update();
});
}), e;
}
var t = n.models.stackedArea(), r = n.models.axis(), i = n.models.axis(), s = n.models.legend(), o = n.models.legend(), u = {
top: 30,
right: 25,
bottom: 50,
left: 60
}, a = null, f = null, l = n.utils.defaultColor(), c = !0, h = !0, p = !0, d = function(e, t, n, r, i) {
return "<h3>" + e + "</h3>" + "<p>" + n + " on " + t + "</p>";
}, v, m, g = d3.format(",.2f"), y = {
style: t.style()
}, b = null, w = "No Data Available.", E = d3.dispatch("tooltipShow", "tooltipHide", "stateChange", "changeState"), S = 250;
r.orient("bottom").tickPadding(7), i.orient("left"), t.scatter.pointActive(function(e) {
return !!Math.round(t.y()(e) * 100);
});
var x = function(s, o) {
var u = s.pos[0] + (o.offsetLeft || 0), a = s.pos[1] + (o.offsetTop || 0), f = r.tickFormat()(t.x()(s.point, s.pointIndex)), l = i.tickFormat()(t.y()(s.point, s.pointIndex)), c = d(s.series.key, f, l, s, e);
n.tooltip.show([ u, a ], c, s.value < 0 ? "n" : "s", null, o);
};
return t.dispatch.on("tooltipShow", function(e) {
e.pos = [ e.pos[0] + u.left, e.pos[1] + u.top ], E.tooltipShow(e);
}), t.dispatch.on("tooltipHide", function(e) {
E.tooltipHide(e);
}), E.on("tooltipHide", function() {
p && n.tooltip.cleanup();
}), e.dispatch = E, e.stacked = t, e.legend = s, e.controls = o, e.xAxis = r, e.yAxis = i, d3.rebind(e, t, "x", "y", "size", "xScale", "yScale", "xDomain", "yDomain", "sizeDomain", "interactive", "offset", "order", "style", "clipEdge", "forceX", "forceY", "forceSize", "interpolate"), e.margin = function(t) {
return arguments.length ? (u.top = typeof t.top != "undefined" ? t.top : u.top, u.right = typeof t.right != "undefined" ? t.right : u.right, u.bottom = typeof t.bottom != "undefined" ? t.bottom : u.bottom, u.left = typeof t.left != "undefined" ? t.left : u.left, e) : u;
}, e.width = function(t) {
return arguments.length ? (a = t, e) : getWidth;
}, e.height = function(t) {
return arguments.length ? (f = t, e) : getHeight;
}, e.color = function(r) {
return arguments.length ? (l = n.utils.getColor(r), s.color(l), t.color(l), e) : l;
}, e.showControls = function(t) {
return arguments.length ? (c = t, e) : c;
}, e.showLegend = function(t) {
return arguments.length ? (h = t, e) : h;
}, e.tooltip = function(t) {
return arguments.length ? (d = t, e) : d;
}, e.tooltips = function(t) {
return arguments.length ? (p = t, e) : p;
}, e.tooltipContent = function(t) {
return arguments.length ? (d = t, e) : d;
}, e.state = function(t) {
return arguments.length ? (y = t, e) : y;
}, e.defaultState = function(t) {
return arguments.length ? (b = t, e) : b;
}, e.noData = function(t) {
return arguments.length ? (w = t, e) : w;
}, i.setTickFormat = i.tickFormat, i.tickFormat = function(e) {
return arguments.length ? (g = e, i) : g;
}, e;
};
})();

// font-onyx/lib/Icon.js

enyo.kind({
name: "font.Icon",
kind: "onyx.IconButton",
classes: "font-onyx icon",
published: {
icon: null,
options: []
},
components: [ {
name: "icon",
tag: "div"
} ],
create: function() {
this.inherited(arguments), this.iconChanged(), this.optionsChanged();
},
iconChanged: function() {
this.$.icon.attributes.class = null, this.$.icon.setClasses("icon-" + this.icon);
},
optionsChanged: function(e) {
for (var t = 0; t < this.options.length; t++) this.$.icon.addClass("icon-" + this.options[t]);
}
});

// font-onyx/lib/IconButton.js

enyo.kind({
name: "font.IconButton",
kind: "font.Icon",
classes: "button",
events: {
ontap: ""
},
tap: function() {
return this.inherited(arguments), this.disabled;
}
});

// font-onyx/lib/TextIcon.js

enyo.kind({
name: "font.TextIcon",
kind: "font.IconButton",
classes: "text-icon",
components: [ {
name: "icon",
tag: "div"
}, {
name: "text",
classes: "text",
tag: "div"
} ],
contentChanged: function() {
this.$.text.setContent(this.getContent());
}
});

// core.js

(function() {
XV = {}, XV._modelCaches = {}, XV._modelLists = {}, XV._modelWorkspaces = {}, enyo.mixin(XV, {
KEY_UP: 38,
KEY_DOWN: 40,
KEY_TAB: 9,
KEY_ENTER: 13,
widgetTypeMap: {
Cost: "XV.Cost",
Date: "XV.DateWidget",
DueDate: "XV.DateWidget",
ExtendedPrice: {
kind: "XV.MoneyWidget",
scale: XT.EXTENDED_PRICE_SCALE
},
Money: {
kind: "XV.MoneyWidget",
scale: XT.MONEY_SCALE
},
Number: "XV.NumberWidget",
PurchasePrice: {
kind: "XV.MoneyWidget",
scale: XT.PURCHASE_PRICE_SCALE
},
Quantity: "XV.QuantityWidget",
QuantityPer: "XV.QuantityPerWidget",
SalesPrice: {
kind: "XV.MoneyWidget",
scale: XT.SALES_PRICE_SCALE
},
String: "XV.InputWidget",
Unit: "XV.UnitPicker",
UnitRatio: "XV.UnitRatioWidget",
UserAccountRelation: "XV.UserAccountWidget",
Weight: "XV.WeightWidget"
},
getEditor: function(e, t) {
var n = XT.getObjectByName(e), r = n.getType(t), i = this.widgetTypeMap[r];
return _.isString(i) ? i = {
kind: i,
attr: t
} : i.kind === "XV.MoneyWidget" && (i.localValue = t), i;
},
appendExtension: function(e, t) {
var n = XT.getObjectByName(e), r = n.prototype.extensions || [];
_.isArray(t) || (t = [ t ]), n.prototype.extensions = r.concat(t);
},
applyTest: function(e, t, n) {
return e === t ? "" : (n ? n = ". " + n : n = ".", "Expected " + e + ", saw " + t + n);
},
downloadURL: function(e) {
var t = "hiddenDownloader", n = document.getElementById(t);
n === null && (n = document.createElement("iframe"), n.id = t, n.style.display = "none", document.body.appendChild(n)), n.src = e;
},
getCache: function(e) {
return XV._modelCaches[e];
},
getList: function(e) {
return XV._modelLists[e];
},
getWorkspace: function(e) {
return XV._modelWorkspaces[e];
},
inheritsFrom: function(e, t) {
if (!e || !e.ctor) return !1;
while (e.kindName !== "enyo.Object") {
if (e.ctor.prototype.base.prototype.kindName === t) return !0;
e = e.ctor.prototype.base.prototype;
}
},
registerModelCache: function(e, t) {
XV._modelCaches[e] = t;
},
registerModelList: function(e, t) {
XV._modelLists[e] = t;
},
registerModelWorkspace: function(e, t) {
XV._modelWorkspaces[e] = t;
}
}), XV.ExtensionsMixin = {
extensions: null,
processExtensions: function(e) {
var t = this.extensions || [], n, r, i, s;
this._extLength === undefined && (this._extLength = 0);
if (this._extLength === t.length) return;
for (s = 0; s < t.length; s++) {
n = _.clone(this.extensions[s]);
if (n.defer !== e) continue;
if (_.isString(n.container)) {
r = n.container, i = this;
while (r.indexOf(".") >= 0) i = i.$[r.substring(0, r.indexOf("."))], r = r.substring(r.indexOf(".") + 1);
if (!i) {
XT.log("Requested container", n.container, "not found");
return;
}
n.container = i.$[r];
}
_.isString(n.addBefore) && (n.addBefore = this.$[n.addBefore]), this.createComponent(n), this._extLength++;
}
}
}, XV.FormattingMixin = {
formatted: [ "Date", "DueDate", "Cost", "ExtendedPrice", "Hours", "Money", "Percent", "PurchasePrice", "Quantity", "SalesPrice", "UnitRatio", "Weight", "Boolean", "EffectiveDate", "ExpireDate", "AddressInfo" ],
formatAddressInfo: function(e, t, n) {
return XM.Address.formatShort(e);
},
formatBoolean: function(e) {
return e ? "_yes".loc() : "_no".loc();
},
formatCost: function(e) {
return Globalize.format(e, "c" + XT.locale.costScale);
},
formatDate: function(e) {
var t = _.isDate(e) ? XT.date.applyTimezoneOffset(e, !0) : !1;
return t ? Globalize.format(t, "d") : "";
},
formatDueDate: function(e, t, n) {
var r = XT.date.today(), i = _.isDate(e) ? XT.date.applyTimezoneOffset(e, !0) : !1, s = i ? n.getValue("isActive") && XT.date.compareDate(e, r) < 1 : !1;
return t.addRemoveClass("error", s), i ? Globalize.format(i, "d") : "";
},
formatEffectiveDate: function(e, t) {
var n = XT.date.applyTimezoneOffset(e, !0), r = XT.date.compareDate(n, XT.date.today()) === 1;
return t.addRemoveClass("error", r), e.valueOf() === XT.date.startOfTime().valueOf() ? "_always".loc() : Globalize.format(n, "d");
},
formatExpireDate: function(e, t) {
var n = XT.date.applyTimezoneOffset(e, !0), r = XT.date.compareDate(n, XT.date.today()) < 1;
return t.addRemoveClass("error", r), e.valueOf() === XT.date.endOfTime().valueOf() ? "_never".loc() : Globalize.format(n, "d");
},
formatExtendedPrice: function(e) {
return Globalize.format(e, "c" + XT.locale.extendedPriceScale);
},
formatHours: function(e, t) {
return t.addRemoveClass("error", e < 0), Globalize.format(e, "n" + XT.locale.hoursScale);
},
formatMoney: function(e, t) {
return t.addRemoveClass("error", e < 0), Globalize.format(e, "c" + XT.locale.currencyScale);
},
formatPercent: function(e) {
return Globalize.format(e, "p" + XT.locale.percentScale);
},
formatPurchasePrice: function(e) {
return Globalize.format(e, "c" + XT.locale.purchasePriceScale);
},
formatQuantity: function(e, t) {
return t.addRemoveClass("error", e < 0), Globalize.format(e, "n" + XT.locale.quantityScale);
},
formatQuantityPer: function(e) {
return Globalize.format(e, "n" + XT.locale.quantityPerScale);
},
formatSalesPrice: function(e) {
return Globalize.format(e, "c" + XT.locale.salesPriceScale);
},
formatUnitRatio: function(e) {
return Globalize.format(e, "n" + XT.locale.unitRatioScale);
},
formatWeight: function(e) {
return Globalize.format(e, "n" + XT.locale.weightScale);
}
};
})();

// panels.js

(function() {
enyo.kind({
name: "ResponsiveArranger",
kind: "GridArranger",
colWidth: "320",
size: function() {
var e = this.container.getPanels(), t = this.colWidth, n = enyo.Panels.isScreenNarrow() ? this.containerBounds.height / 2 : this.containerBounds.height;
for (var r = 0, i; i = e[r]; r++) i.setBounds({
width: t,
height: n
});
},
arrange: function(e, t) {
var n = this.colWidth, r = this.containerBounds.height, i = Math.max(1, Math.floor(this.containerBounds.width / n)), s;
enyo.Panels.isScreenNarrow() && (r = Math.max(200, this.containerBounds.height / 2), i = 1);
for (var o = 0, u = 0; u < e.length; o++) for (var a = 0; a < i && (s = e[u]); a++, u++) this.arrangeControl(s, {
left: n * a,
top: r * o
});
},
flowControl: function(e, t) {
this.inherited(arguments), enyo.Arranger.opacifyControl(e, 100);
if (this.container.realtimeFit) {
var n = this.container.getPanels(), r = n.length - 1, i = n[r];
this.fitControl(i);
}
},
fitControl: function(e) {
e._fit = !0, e.applyStyle("width", this.containerBounds.width - this.colWidth + "px"), e.resized();
}
}), enyo.kind({
name: "XV.GridPanels",
kind: "Panels",
arrangerKind: "ResponsiveArranger",
classes: "app enyo-unselectable",
draggable: !1,
wrap: !0,
realtimeFit: !0
}), enyo.kind({
name: "CollapsingFitArranger",
kind: "CollapsingArranger",
fitControl: function(e, t) {}
}), enyo.kind({
name: "XV.ContainerPanels",
kind: "Panels",
arrangerKind: "CollapsingArranger",
draggable: !0,
realtimeFit: !0,
controlClasses: "xv-app-panel"
}), enyo.kind({
name: "XV.WorkspacePanels",
kind: "Panels",
arrangerKind: "CollapsingFitArranger",
classes: "xv-workspace-panel-container",
controlClasses: "xv-workspace-panel",
draggable: !0,
realtimeFit: !0
}), enyo.kind({
name: "XV.SearchPanels",
kind: "XV.GridPanels",
classes: "xv-app-panel-container",
controlClasses: "xv-app-panel"
});
})();

// model_decorator.js

(function() {
XV.ModelAttributeFormatters = {
formatters: {
Date: function(e, t, n) {
t.setContent(moment(n).format("MM/DD/YYYY"));
},
Money: function(e, t, n) {
t.setContent(e.get("currency").get("symbol") + n);
}
}
}, enyo.kind({
name: "XV.ModelDecorator",
classes: "xv-model-decorator",
statics: {
getValue: function(e, t) {
return e && _.reduce(e.split("."), function(e, t) {
return e.get(t);
}, t);
},
classFromAttribute: function(e) {
return "xm-attribute-" + e.replace(".", "-");
},
classFromType: function(e) {
return "xm-attributetype-" + e.toLowerCase();
}
},
published: {
control: null
},
create: function() {
this.inherited(arguments);
var e = this.getClientControls();
if (e.length !== 1) {
console.warn("XV.ModelDecorator must parent exactly one child.");
return;
}
this.control = e[0], this.control.decorated = !0;
}
}), enyo.kind(enyo.mixin(XV.ModelAttributeFormatters, {
name: "XV.ListItemDecorator",
kind: "XV.ModelDecorator",
classes: "xv-listitem-decorator",
handlers: {
onSetupCell: "setupCell",
onIsActiveChange: "isActiveChanged"
},
isActiveChanged: function() {
this.control.addRemoveClass("isActive", this.isActive);
},
setupCell: function(e, t) {
var n = this.control.value, r = t.attributes.attr, i = t.attributes.formatter, s = n.getAttributeType(r);
t.addClass("xv-list-column"), t.addClass("xv-list-attr"), t.addClass(XV.ModelDecorator.classFromAttribute(r)), t.addRemoveClass("xm-attribute-id", n.idAttribute === r), t.isKey = n.idAttribute === r, s && t.addClass(XV.ModelDecorator.classFromType(s)), i && _.isFunction(this.control[i]) ? this.control[i](n, t) : s && this.formatters[s] && this.formatters[s](n, t, n.get(r));
}
}));
})();

// list_item.js

(function() {
enyo.kind({
name: "XV.ListItem",
classes: "xv-list-item",
ontap: "itemTap",
controlClasses: "enyo-inline",
published: {
selected: null,
template: null,
value: null
},
events: {
onListItemMenuTap: "",
onActionSelected: ""
},
handlers: {
onSetupCell: "setupCell",
onListMenuReady: "listMenuReady"
},
components: [ {
kind: "XV.SimpleModelTable",
name: "table",
classes: "enyo-inline",
showing: !1
}, {
kind: "font.IconButton",
icon: "spinner",
options: [ "spin" ],
disabled: !0,
showing: !1,
ontap: "gearTap",
classes: "xv-list-item-gear"
} ],
create: function() {
this.inherited(arguments), XM.View.setPresenter(this, "item");
},
templateChanged: function() {
this.$.table.setTemplate(this.template);
},
listMenuReady: function(e, t) {
this.$.iconButton.setIcon("cog"), this.$.iconButton.setDisabled(!1);
},
gearTap: function(e, t) {
return this.inherited(arguments), this.doListItemMenuTap(t), !0;
},
valueChanged: function() {
this.$.table.setup(), this.$.table.setShowing(!0);
},
setupCell: function(e, t) {
t.setContent(XV.ModelDecorator.getValue(t.attributes.attr, this.value));
},
selectedChanged: function() {
this.$.iconButton.setShowing(this.selected), this.addRemoveClass("item-selected", this.selected);
},
getActionIconButton: function() {
return this.$.iconButton;
}
}), enyo.kind({
name: "XV.ListColumn",
classes: "xv-list-column"
}), enyo.kind({
name: "XV.ListAttr",
classes: "xv-list-attr",
published: {
attr: "",
isKey: !1
}
});
})();

// simple_model_table.js

(function() {
enyo.kind({
name: "XV.SimpleModelTable",
published: {
template: null
},
events: {
onSetupCell: ""
},
setup: function() {
_(_(this.getComponents()).where({
tag: "td"
})).each(function(e) {
this.doSetupCell(e);
}, this);
},
cell: function(e, t) {
return this.$[this._cellName(e, t)];
},
row: function(e) {
return this.$[this._rowName(e)];
},
column: function(e) {
return _(this.getComponents()).where({
column: e
});
},
templateChanged: function() {
this._createTable();
},
_createTable: function() {
this.createComponent({
tag: "table",
name: "table",
classes: "xv-table",
components: _(this.template).map(this._createRow, this)
});
},
_createRow: function(e, t) {
return {
tag: "tr",
name: this._rowName(t),
classes: "xv-row",
components: _(e).map(function(e, n) {
return this._createCell(e, t, n);
}, this)
};
},
_createCell: function(e, t, n) {
return {
tag: "td",
name: this._cellName(t, n),
column: n,
classes: "xv-cell",
attributes: _(e).omit("id")
};
},
_cellName: function(e, t) {
return "cell-" + e + "-" + t;
},
_rowName: function(e) {
return "row-" + e;
}
});
})();

// menu.js

(function() {
enyo.kind({
name: "XV.MenuItem",
kind: "onyx.MenuItem",
classes: "xv-menuitem",
disabledChanged: function() {
this.addRemoveClass("disabled", this.disabled);
},
tap: function(e) {
if (!this.disabled) return this.inherited(arguments);
}
}), XV.ListMenuManagerMixin = {
listActionSelected: function(e, t) {
var n = t.originator.list, r = _.keys(n.getSelection().selected), i = t.originator.action, s = i.method, o = function() {
n.resetActions(), _.each(r, function(e) {
n.deselect(e), n.renderRow(e);
});
}, u = function() {
var e, t = n.getModel(r[0]);
i.isViewMethod ? n.$.listItem.doActionSelected({
model: t,
action: i,
callback: o
}) : t instanceof XM.Info && !t[s] ? (e = XT.getObjectByName(t.editableModel), _.each(r, function(r) {
t = n.getModel(r), e[s](t, o);
})) : _.each(r, function(e) {
t = n.getModel(e), t[s](o);
});
};
return i.notify !== !1 ? this.doNotify({
type: XM.Model.QUESTION,
message: i.notifyMessage || "_confirmAction".loc(),
callback: function(e) {
e.answer && u();
}
}) : u(), !0;
},
showListItemMenu: function(e, t) {
var n = this.$.listItemMenu;
n.destroyClientControls(), _.each(t.actions, function(e) {
var r = e.name, i = e.privilege ? e.privilege.split(" ") : [], s = !1, o = _.find(n.$, function(e, t) {
return t === r;
});
i.length && (s = !_.some(i, function(e) {
return XT.session.privileges.get(e);
})), o ? o.setDisabled(s) : t.actionPermissions[r] && n.createComponent({
name: r,
kind: "XV.MenuItem",
content: e.label || ("_" + r).loc(),
action: e,
disabled: s,
list: t.list
});
}), n.getClientControls().length || n.createComponent({
name: "noActions",
kind: "XV.MenuItem",
content: "_noEligibleActions".loc(),
disabled: !0
}), n.render(), t.originator.hasNode() || (t.originator.node = t.originator.eventNode), t.originator.generated = !0, n.requestMenuShow(this, {
activator: t.originator
}), n.adjustPosition();
}
};
})();

// input.js

(function() {
enyo.kind({
name: "XV.Input",
published: {
attr: null,
value: null,
disabled: !1,
placeholder: null,
type: null,
maxlength: null
},
events: {
onValueChange: ""
},
handlers: {
onblur: "receiveBlur"
},
components: [ {
name: "input",
kind: "onyx.Input",
classes: "xv-subinput",
onchange: "inputChanged",
onkeydown: "keyDown"
} ],
clear: function(e) {
this.setValue("", e);
},
create: function() {
this.inherited(arguments), this.placeholderChanged(), this.disabledChanged(), this.typeChanged(), this.maxlengthChanged();
},
disabledChanged: function() {
this.$.input.setDisabled(this.getDisabled());
},
focus: function() {
this.$.input.focus();
},
inputChanged: function(e, t) {
var n = this.$.input.getValue(), r = this.validate(n);
r !== !1 ? this.setValue(r) : this.setValue(null);
},
keyDown: function(e, t) {
var n = t.originator.hasClass("text-shadow-none"), r = t.keyCode;
t.originator.addRemoveClass("text-shadow-none", !n), t.originator.addRemoveClass("text-shadow-0", n), (r === XV.KEY_TAB || r === XV.KEY_DOWN || r === XV.KEY_UP) && this.receiveBlur();
},
placeholderChanged: function() {
var e = this.getPlaceholder();
this.$.input.setPlaceholder(e);
},
receiveBlur: function() {
this.$.input.getValue() !== this.getValue() && this.inputChanged();
},
setValue: function(e, t) {
t = t || {};
var n = this.getValue(), r;
n !== e && (this.value = e, this.valueChanged(e), t.silent || (r = {
value: e,
originator: this
}, this.doValueChange(r)));
},
validate: function(e) {
return e;
},
valueChanged: function(e) {
return this.$.input.setValue(e || ""), e;
},
setInputStyle: function(e) {
this.$.input.setStyle(e);
},
typeChanged: function() {
this.$.input.setType(this.getType());
},
maxlengthChanged: function() {
this.$.input.setAttribute("maxlength", this.maxlength);
}
}), enyo.kind({
name: "XV.InputWidget",
kind: "XV.Input",
classes: "xv-input",
published: {
label: "",
showLabel: !0
},
components: [ {
kind: "FittableColumns",
components: [ {
name: "label",
content: "",
fit: !0,
classes: "xv-flexible-label"
}, {
kind: "onyx.InputDecorator",
classes: "xv-input-decorator",
components: [ {
name: "input",
kind: "onyx.Input",
classes: "xv-subinput",
onchange: "inputChanged",
onkeydown: "keyDown"
} ]
} ]
} ],
create: function() {
this.inherited(arguments), this.labelChanged(), this.placeholderChanged(), this.showLabelChanged();
},
disabledChanged: function() {
this.inherited(arguments);
var e = this.getDisabled();
this.$.label.addRemoveClass("disabled", e);
},
labelChanged: function() {
var e = this.getLabel() || ("_" + this.attr || "").loc();
this.$.label.setContent(e + ":");
},
showLabelChanged: function() {
this.getShowLabel() ? this.$.label.show() : this.$.label.hide();
}
});
})();

// checkbox.js

(function() {
enyo.kind({
name: "XV.Checkbox",
kind: "onyx.Checkbox",
published: {
attr: null
},
events: {
onValueChange: ""
},
handlers: {
onchange: "changed"
},
clear: function(e) {
this.setValue(!1, e);
},
setValue: function(e, t) {
t = t || {}, this._silent = t.silent, this.inherited(arguments), this._silent = !1;
},
changed: function(e, t) {
this._silent || (t.value = this.getValue(), this.doValueChange(t));
}
}), enyo.kind({
name: "XV.CheckboxWidget",
kind: "XV.Input",
classes: "xv-input xv-checkboxwidget",
published: {
label: ""
},
components: [ {
kind: "FittableColumns",
components: [ {
name: "label",
content: "",
classes: "xv-label"
}, {
kind: "onyx.InputDecorator",
classes: "xv-input-decorator",
components: [ {
name: "input",
kind: "onyx.Checkbox",
onchange: "inputChanged"
} ]
} ]
} ],
clear: function(e) {
this.setValue(!1, e);
},
create: function() {
this.inherited(arguments), this.labelChanged();
},
disabledChanged: function() {
this.inherited(arguments), this.$.label.addRemoveClass("disabled", this.getDisabled());
},
inputChanged: function(e, t) {
var n = this.$.input.getValue();
this.setValue(n);
},
labelChanged: function() {
var e = (this.getLabel() || ("_" + this.attr || "").loc()) + ":";
this.$.label.setContent(e);
},
valueChanged: function(e) {
return this.$.input.setValue(e), e;
}
}), enyo.kind({
name: "XV.StickyCheckboxWidget",
classes: "xv-input xv-checkboxwidget",
published: {
label: "",
disabled: !1,
checked: !1
},
events: {
onValueChange: ""
},
components: [ {
kind: "FittableColumns",
components: [ {
name: "label",
content: "",
classes: "xv-label"
}, {
kind: "onyx.InputDecorator",
classes: "xv-input-decorator",
components: [ {
name: "input",
kind: "onyx.Checkbox",
onchange: "inputChanged"
} ]
} ]
} ],
clear: function() {
this.$.input.setValue(!1);
},
create: function() {
var e, t = function(e) {
return _.isString(e) ? e === "true" ? !0 : !1 : e;
};
this.inherited(arguments), this.labelChanged();
if (this.name === "stickyCheckboxWidget") throw this._err = !0, "Sticky Checkbox Widget should have a unique name.";
e = t(enyo.getCookie(this.name)), e = _.isBoolean(e) ? e : this.checked, this.checked = e, this.$.input.setValue(e);
},
disabledChanged: function() {
var e = this.getDisabled();
this.$.input.setDisabled(e), this.$.label.addRemoveClass("disabled", e);
},
focus: function() {
this.$.input.focus();
},
inputChanged: function(e, t) {
this.setChecked(this.$.input.checked);
},
isChecked: function() {
return this.$.input.checked;
},
labelChanged: function() {
var e = (this.getLabel() || ("_" + this.attr || "").loc()) + ":";
this.$.label.setContent(e);
},
checkedChanged: function() {
this.$.input.setChecked(this.checked), this._err || enyo.setCookie(this.name, this.checked), this.doValueChange({
value: this.checked
});
}
});
})();

// number.js

(function() {
enyo.kind({
name: "XV.Number",
kind: "XV.Input",
published: {
scale: 0,
formatting: !0
},
setValue: function(e, t) {
e = e !== null && !isNaN(e) ? XT.math.round(e, this.getScale()) : null, XV.Input.prototype.setValue.call(this, e, t);
},
validate: function(e) {
return e = Globalize.parseFloat(e), isNaN(e) ? !1 : e;
},
valueChanged: function(e) {
return isNaN(e) ? e = "" : e = this.formatting ? Globalize.format(e, "n" + this.getScale()) : e, XV.Input.prototype.valueChanged.call(this, e);
}
}), enyo.kind({
name: "XV.NumberWidget",
kind: "XV.Number",
classes: "xv-numberwidget xv-input",
published: {
label: "",
showLabel: !0,
placeholder: ""
},
components: [ {
kind: "FittableColumns",
components: [ {
name: "label",
content: "",
fit: !0,
classes: "xv-flexible-label"
}, {
kind: "onyx.InputDecorator",
classes: "xv-input-decorator",
components: [ {
name: "input",
kind: "onyx.Input",
onchange: "inputChanged",
onkeydown: "keyDown",
type: "number"
} ]
} ]
} ],
create: function() {
this.inherited(arguments), this.labelChanged(), this.showLabelChanged();
},
disabledChanged: function() {
this.inherited(arguments), this.$.label.addRemoveClass("disabled", this.getDisabled());
},
labelChanged: function() {
var e = (this.getLabel() || ("_" + this.attr + "").loc()) + ":";
this.$.label.setContent(e);
},
showLabelChanged: function() {
this.getShowLabel() ? this.$.label.show() : this.$.label.hide();
}
});
})();

// text_area.js

(function() {
enyo.kind({
name: "XV.TextArea",
kind: "XV.Input",
classes: "xv-textarea",
published: {
attr: null,
placeholder: ""
},
components: [ {
name: "input",
kind: "onyx.TextArea",
classes: "xv-textarea-input",
onchange: "inputChanged",
onkeydown: "keyDown"
} ]
});
})();

// picker.js

(function() {
enyo.kind({
name: "XV.Picker",
kind: "enyo.Control",
classes: "xv-input",
events: {
onValueChange: ""
},
published: {
attr: null,
value: null,
collection: null,
disabled: !1,
nameAttribute: "name",
orderBy: null,
noneText: "_none".loc(),
noneClasses: "",
showNone: !0,
prerender: !0,
defaultValue: null
},
handlers: {
onSelect: "itemSelected"
},
components: [ {
kind: "onyx.PickerDecorator",
components: [ {
kind: "XV.PickerButton",
name: "pickerButton",
content: "_none".loc(),
onkeyup: "keyUp"
}, {
name: "picker",
kind: "onyx.Picker"
} ]
} ],
buildList: function(e) {
var t = this.getNameAttribute(), n = this.filteredList(e), r = this.getNoneText(), i = this.getNoneClasses(), s = this.$.picker, o = this.iconClass, u = this.iconVisible, a, f;
s.destroyClientControls(), this.showNone && s.createComponent({
kind: "XV.PickerMenuItem",
value: null,
content: r,
classes: i
}), _.each(n, function(e) {
var n = e.getValue ? e.getValue(t) : e.get(t), r = e && e.getValue ? e.getValue("isActive") !== !1 : e && _.isBoolean(e.get("isActive")) ? e.get("isActive") : !0;
s.createComponent({
kind: "XV.PickerMenuItem",
value: e,
disabled: !r,
content: n,
iconClass: o,
iconVisible: u
});
}), this.prerender && this.$.picker.render();
},
clear: function(e) {
this.setValue(null, e);
},
collectionChanged: function() {
var e = _.isObject(this.collection) ? this.collection : XT.getObjectByName(this.collection), t = this, n = !1, r;
this._collection && this._collection.off("add remove reset", this.buildList, this);
if (!e) {
if (n) {
XT.log("Could not find collection " + this.getCollection());
return;
}
r = function() {
n = !0, t.collectionChanged();
}, XT.getStartupManager().registerCallback(r);
return;
}
this._collection = e, this._collection.on("add remove reset", this.buildList, this), this.orderByChanged(), this._collection.comparator && this._collection.sort(), this.buildList();
},
create: function() {
var e = this.getDefaultValue();
this.inherited(arguments), this.noneTextChanged(), this.getCollection() && this.collectionChanged(), e && this.setValue(e, {
silent: !0
});
},
destroy: function() {
this._collection && this._collection.off && this._collection.off("add remove reset", this.buildList, this), this.inherited(arguments);
},
disabledChanged: function(e, t) {
var n = this.getDisabled();
this.$.pickerButton.setDisabled(n), this.$.label.addRemoveClass("disabled", n);
},
getValueToString: function() {
return this.$.pickerButton.getContent();
},
itemSelected: function(e, t) {
var n = this.$.picker.getSelected().value;
this.setValue(n);
},
filter: function(e, t) {
return e || [];
},
filteredList: function(e) {
return this._collection ? this.filter(this._collection.models, e) : [];
},
keyUp: function(e, t) {
var n = t.keyCode, r = this.$.picker.getSelected(), i = _.map(this.$.picker.controls, function(e) {
return e.content;
}), s = _.indexOf(i, r && r.content), o, u;
n === 40 ? (u = Math.min(s + 1, this.$.picker.controls.length - 1), this.$.picker.setSelected(this.$.picker.controls[u]), this.itemSelected()) : n === 38 ? (u = Math.max(s - 1, 1), this.$.picker.setSelected(this.$.picker.controls[u]), this.itemSelected()) : n >= 65 && n <= 90 && (o = _.find(this.$.picker.$, function(e) {
return e.content.charCodeAt(0) === n;
}), o && (this.$.picker.setSelected(o), this.itemSelected()));
},
noneTextChanged: function() {
var e = this.getNoneText(), t = this.$.pickerButton;
this.value || t.setContent(e), this.buildList();
},
noneClassesChanged: function() {
this.buildList();
},
orderByChanged: function() {
var e = this.getOrderBy();
this._collection && e && (this._collection.comparator = function(t, n) {
var r, i, s, o, u, a;
for (a = 0; a < e.length; a++) {
u = e[a].attribute, s = t.getValue ? t.getValue(u) : t.get(u), o = n.getValue ? n.getValue(u) : n.get(u), r = e[a].descending ? o : s, i = e[a].descending ? s : o, u === "order" && !_.isNumber(r) && (r = 9999), u === "order" && !_.isNumber(i) && (i = 9999), r = isNaN(r) ? r : r - 0, i = isNaN(r) ? i : i - 0;
if (r !== i) return r > i ? 1 : -1;
}
return 0;
});
},
select: function(e) {
var t = 0, n = _.find(this.$.picker.getComponents(), function(n) {
return n.kind === "onyx.MenuItem" && t++, t > e;
});
n && this.setValue(n.value);
},
selectValue: function(e) {
var t = this._collection, n = this.idAttribute || (t && t.model ? t.model.prototype.idAttribute : !1), r = this.$.picker.getComponents(), i, s;
return s = e && n ? e.get(n) : e, i = _.find(r, function(e) {
if (e.kind === "XV.PickerMenuItem") return (e.value ? e.value.get(n) : null) === s;
}), i ? this.$.picker.setSelected(i) : (s = null, this.$.picker.setSelected(null), this.$.pickerButton.setContent("_none".loc())), s;
},
setValue: function(e, t) {
t = t || {};
var n = this.idAttribute || (this._collection && this._collection.model ? this._collection.model.prototype.idAttribute : null), r = this.getValue(), i = this.getAttr(), s, o, u, a;
if (n !== null && e !== null && typeof e != "object") {
s = _.find(this.$.picker.controls, function(t) {
var r = !1;
return t.value && t.value.get ? r = t.value.get(n) === e : t.value && (r = t.value[n] === e), r;
}), s && (o = s.value, this.setValue(o, t));
return;
}
if (!(!_.isObject(e) || e instanceof Backbone.Model)) {
e.collection && e.collection !== this._collection && this.setCollection(e.collection), this.setValue(e.value, t);
return;
}
e !== r && (a = this.selectValue(e), a !== r && (this.value = e, t.silent || (_.isObject(i) ? (u = {
value: {
collection: this._collection
}
}, u.value[i.value] = a) : u = {
value: a
}, this.doValueChange(u))));
}
}), enyo.kind({
name: "XV.PickerWidget",
kind: "XV.Picker",
published: {
label: "",
showLabel: !0
},
components: [ {
kind: "FittableColumns",
components: [ {
name: "label",
content: "",
classes: "xv-label"
}, {
kind: "onyx.InputDecorator",
name: "inputWrapper",
classes: "xv-input-decorator",
components: [ {
kind: "onyx.PickerDecorator",
components: [ {
kind: "XV.PickerButton",
name: "pickerButton",
content: "_none".loc(),
onkeyup: "keyUp"
}, {
name: "picker",
kind: "onyx.Picker"
} ]
} ]
} ]
} ],
create: function() {
this.inherited(arguments), this.labelChanged(), this.showLabelChanged();
},
labelChanged: function() {
var e = this.attr && _.isString(this.attr) ? this.attr : this.attr ? this.attr.value : !1, t = this.getLabel() || (e ? ("_" + e).loc() : "");
this.$.label.setShowing(!!t), this.$.label.setContent(t + ":");
},
showLabelChanged: function() {
this.$.label.setShowing(this.showLabel);
}
}), enyo.kind({
name: "XV.PickerButton",
kind: "onyx.PickerButton",
classes: "xv-picker-button",
components: [ {
name: "text",
content: "",
classes: "picker-content"
}, {
tag: "i",
classes: "icon-caret-down picker-icon"
} ],
create: function() {
this.inherited(arguments), this.contentChanged();
},
contentChanged: function() {
this.$.text.setContent(this.getContent());
}
}), enyo.kind({
name: "XV.PickerMenuItem",
kind: "onyx.MenuItem",
classes: "xv-picker-button",
value: null,
published: {
iconClass: "",
iconVisible: null,
disabled: !1
},
components: [ {
name: "text",
content: ""
}, {
name: "icon",
tag: "i",
classes: "icon-dark picker-icon"
} ],
create: function() {
this.inherited(arguments), this.contentChanged(), this.iconVisibleChanged(), this.disabledChanged();
},
contentChanged: function() {
this.$.text.setContent(this.getContent());
},
disabledChanged: function() {
this.addRemoveClass("disabled", this.disabled);
},
iconVisibleChanged: function() {
var e = this.iconVisible;
_.isFunction(this.iconVisible) && (e = this.iconVisible(this.value)), this.$.icon.setShowing(e), e ? (this.$.icon.addClass(this.getIconClass()), this.$.text.addClass("picker-content")) : (this.$.icon.removeClass(this.getIconClass()), this.$.text.removeClass("picker-content"));
},
tap: function(e) {
if (!this.disabled) return this.inherited(arguments);
}
});
})();

// characteristics.js

(function() {
var e = 0, t = 1, n = 2;
enyo.kind({
name: "XV.CharacteristicPicker",
kind: "XV.PickerWidget",
classes: "xv-characteristic-picker",
collection: "XM.characteristics",
noneText: "_delete".loc(),
noneClasses: "xv-negative",
orderBy: [ {
attribute: "order"
}, {
attribute: "name"
} ]
}), enyo.kind({
name: "XV.OptionsPicker",
published: {
attr: null,
collection: null,
value: null,
disabled: !1
},
events: {
onValueChange: ""
},
handlers: {
onSelect: "itemSelected"
},
components: [ {
kind: "onyx.InputDecorator",
classes: "xv-input-decorator",
components: [ {
kind: "onyx.PickerDecorator",
components: [ {
classes: "xv-picker"
}, {
name: "picker",
kind: "onyx.Picker"
} ]
} ]
} ],
disabledChanged: function() {
this.$.inputDecorator.disabled = this.disabled, this.$.inputDecorator.bubble("onDisabledChange");
},
itemSelected: function(e, t) {
var n = this.$.picker.getSelected().content;
return this.setValue(n), !0;
},
setCollection: function(e) {
var t, n, r, i;
this.collection = e, e.comparator = this.sort, e.sort(), this.$.picker.destroyClientControls();
for (r = 0; r < e.length; r++) t = e.at(r), n = t.get("value"), i = this.$.picker.createComponent({
content: n
}), r === 0 && this.$.picker.setSelected(i);
this.render();
},
setValue: function(e, t) {
t = t || {};
var n = this.getValue(), r, i = this.$.picker.getComponents(), s = _.find(i, function(t) {
if (t.kind === "onyx.MenuItem") return t.content === e;
});
return s || (e = null), this.$.picker.setSelected(s), e !== n && (this.value = e, t.silent || (r = {
originator: this,
value: e
}, this.doValueChange(r))), e;
},
sort: function(e, t) {
var n = e.get("order"), r = t.get("order"), i, s;
return n === r ? (i = e.get("value"), s = t.get("value"), i < s ? -1 : 1) : n < r ? -1 : 1;
}
}), enyo.kind({
name: "XV.CharacteristicItem",
kind: "FittableColumns",
classes: "xv-characteristic-item",
published: {
value: null,
disabled: !1
},
handlers: {
onValueChange: "controlValueChanged"
},
components: [ {
kind: "XV.CharacteristicPicker",
attr: "characteristic",
showLabel: !1
}, {
kind: "XV.InputWidget",
attr: "value",
showLabel: !1
}, {
kind: "XV.DateWidget",
attr: "value",
showLabel: !1,
showing: !1
}, {
kind: "XV.OptionsPicker",
attr: "value",
showLabel: !1,
showing: !1
} ],
disabledChanged: function(e) {
this.$.characteristicPicker.setDisabled(this.disabled), this.$.inputWidget.setDisabled(this.disabled), this.$.dateWidget.setDisabled(this.disabled), this.$.optionsPicker.setDisabled(this.disabled);
},
controlValueChanged: function(r, i) {
var s = r.getAttr(), o = r.getValue(), u = {}, a = this.getValue(), f, l;
u[s] = _.isDate(o) ? o.toJSON() : o, a.set(u);
if (s === "characteristic") if (o) {
f = a.get("characteristic");
switch (f.get("characteristicType")) {
case n:
l = null;
break;
case e:
l = "";
break;
case t:
l = f.get("options").models[0].get("value");
}
a.set("value", l), this.valueChanged();
} else a.destroy();
return !0;
},
getCharacteristicPicker: function() {
return this.$.characteristicPicker;
},
valueChanged: function() {
var r = this.getValue(), i = r.get("characteristic"), s = i ? i.get("characteristicType") : e, o = r.get("value"), u, a;
switch (s) {
case e:
this.$.dateWidget.hide(), this.$.optionsPicker.hide(), this.$.inputWidget.show(), u = this.$.inputWidget;
break;
case n:
this.$.optionsPicker.hide(), this.$.inputWidget.hide(), this.$.dateWidget.show(), u = this.$.dateWidget;
break;
case t:
this.$.dateWidget.hide(), this.$.inputWidget.hide(), this.$.optionsPicker.show(), u = this.$.optionsPicker, a = i.get("options"), this.$.optionsPicker.setCollection(a);
}
this.$.characteristicPicker.setValue(i, {
silent: !0
}), u.setValue(o, {
silent: !0
});
}
}), enyo.kind({
name: "XV.CharacteristicsWidget",
classes: "xv-characteristics-widget xv-input",
published: {
attr: null,
model: null,
value: null,
which: null,
disabled: !1
},
components: [ {
kind: "onyx.GroupboxHeader",
content: "_characteristics".loc()
}, {
kind: "Repeater",
count: 0,
onSetupItem: "setupItem",
components: [ {
kind: "XV.CharacteristicItem"
} ]
}, {
kind: "FittableColumns",
classes: "xv-characteristic-buttons",
components: [ {
kind: "onyx.Button",
name: "newButton",
classes: "icon-plus xv-characteristic-button",
onclick: "newItem"
} ]
} ],
disabledChanged: function() {
this.$.newButton.setDisabled(this.disabled);
},
destroy: function() {
this.value && (this.value.off("add", this.lengthChanged, this), this.value.off("statusChange", this.lengthChanged, this)), this.inherited(arguments);
},
lengthChanged: function() {
this.$.repeater.setCount(this.readyModels().length);
},
newItem: function() {
var e = XT.getObjectByName(this.getModel()), t = new e(null, {
isNew: !0
});
this.value.add(t);
},
readyModels: function() {
return _.filter(this.value.models, function(e) {
var t = e.getStatus(), n = XM.Model;
return t === n.READY_CLEAN || t === n.READY_DIRTY || t === n.READY_NEW;
});
},
setupItem: function(e, t) {
var n = t.item.$.characteristicItem, r = this.readyModels()[t.index], i = this.getWhich(), s = n.getCharacteristicPicker(), o = function(e) {
return _.filter(e, function(e) {
return e.get(i);
});
};
return n.setValue(r), n.setDisabled(this.disabled), s && (s.filter = o, s.buildList(), r.get("characteristic") || s.select(1)), !0;
},
sort: function(e, t) {
var n = e.isNew(), r = t.isNew(), i = e.get("characteristic"), s = t.get("characteristic"), o = i ? i.get("order") : null, u = s ? s.get("order") : null, a, f;
return n === r ? o === u ? (a = i ? i.get("name") : null, f = s ? s.get("name") : null, a < f ? -1 : 1) : o < u ? -1 : 1 : n < r ? -1 : 1;
},
setValue: function(e) {
this.value && (this.value.off("add", this.lengthChanged, this), this.value.off("statusChange", this.lengthChanged, this)), this.value = e, this.value.on("add", this.lengthChanged, this), this.value.on("statusChange", this.lengthChanged, this), this.value.comparator = this.sort, this.value.sort(), this.lengthChanged();
}
});
})();

// address.js

(function() {
enyo.kind({
name: "XV.AddressWidget",
kind: "FittableRows",
classes: "xv-addresswidget",
published: {
attr: null,
value: null,
list: "XV.AddressList",
account: null
},
events: {
onSearch: "",
onValueChange: "",
onNotify: ""
},
handlers: {
onkeyup: "keyUp"
},
components: [ {
name: "viewer",
showing: !0,
fit: !0,
allowHtml: !0,
classes: "xv-addresswidget-viewer",
placeholder: "_none".loc(),
ontap: "mapTap"
}, {
kind: "FittableColumns",
classes: "xv-buttons",
name: "buttonColumns",
components: [ {
kind: "onyx.Button",
name: "editButton",
ontap: "edit",
onkeyup: "editButtonKeyUp",
classes: "icon-edit"
}, {
kind: "onyx.Button",
name: "searchButton",
ontap: "search",
onkeyup: "searchButtonKeyUp",
classes: "icon-search"
} ]
}, {
kind: "onyx.Popup",
name: "editor",
onHide: "editorHidden",
classes: "xv-addresswidget-editor",
modal: !0,
floating: !0,
centered: !0,
scrim: !0,
components: [ {
content: "_editAddress".loc(),
classes: "xv-addresswidget-editor-header"
}, {
kind: "onyx.InputDecorator",
fit: !0,
classes: "xv-addresswidget-input-decorator",
components: [ {
kind: "onyx.Input",
name: "line1",
placeholder: "_street".loc(),
classes: "xv-addresswidget-input",
onchange: "inputChanged"
} ]
}, {
kind: "onyx.InputDecorator",
fit: !0,
classes: "xv-addresswidget-input-decorator",
components: [ {
kind: "onyx.Input",
name: "line2",
classes: "xv-addresswidget-input",
onchange: "inputChanged"
} ]
}, {
kind: "onyx.InputDecorator",
fit: !0,
classes: "xv-addresswidget-input-decorator",
components: [ {
kind: "onyx.Input",
name: "line3",
classes: "xv-addresswidget-input",
onchange: "inputChanged"
} ]
}, {
kind: "onyx.InputDecorator",
fit: !0,
classes: "xv-addresswidget-input-decorator",
components: [ {
kind: "onyx.Input",
name: "city",
placeholder: "_city".loc(),
classes: "xv-addresswidget-input",
onchange: "inputChanged"
} ]
}, {
kind: "onyx.InputDecorator",
fit: !0,
classes: "xv-addresswidget-combobox-decorator",
components: [ {
kind: "XV.CountryCombobox",
name: "country",
onValueChange: "countryChanged",
showLabel: !1,
placeholder: "_country".loc()
} ]
}, {
kind: "onyx.InputDecorator",
fit: !0,
classes: "xv-addresswidget-combobox-decorator",
components: [ {
kind: "XV.StateCombobox",
name: "state",
placeholder: "_state".loc(),
onValueChange: "inputChanged",
showLabel: !1
} ]
}, {
kind: "onyx.InputDecorator",
fit: !0,
classes: "xv-addresswidget-input-decorator short",
components: [ {
kind: "onyx.Input",
name: "postalCode",
classes: "xv-addresswidget-input",
placeholder: "_postalCode".loc(),
onchange: "inputChanged"
} ]
}, {
tag: "br"
}, {
kind: "onyx.Button",
content: "_done".loc(),
ontap: "done",
classes: "onyx-blue"
} ]
} ],
countryChanged: function(e, t) {
var n = this.$.country.getValue();
return this.inputChanged(e, t), this.$.state.setCountry(n), !0;
},
destroy: function() {
this.value && this.value instanceof XM.Model && this.value.releaseLock(), this.inherited(arguments);
},
done: function() {
var e, t, n = !1;
if (!this._nextWidget) {
e = this.parent.children;
for (t = 0; t < e.length; t++) {
if (n && e[t].focus) {
this._nextWidget = e[t];
break;
}
e[t] === this && (n = !0);
}
}
this._popupDone = !0, this.$.editor.hide(), this.saveAddress(), this._nextWidget && this._nextWidget.focus();
},
edit: function() {
var e = this.getValue();
e || (e = new XM.AddressInfo(null, {
isNew: !0
}), this.setValue(e)), this.$.editor.showing || (this.$.editor.show(), this.$.line1.focus(), this._popupDone = !1);
},
editButtonKeyUp: function(e, t) {
return (t.keyCode === 13 || t.keyCode === 32) && this.edit(), !0;
},
editorHidden: function() {
this._popupDone || this.edit();
},
inputChanged: function(e, t) {
var n = this.getValue(), r = t.originator.name;
return n && (n.set(r, this.$[r].getValue()), this.setValue(n), this.valueChanged(), t = {
originator: this,
value: n
}, this.doValueChange(t)), !0;
},
keyUp: function(e, t) {
t.keyCode === 13 && this.done();
},
notify: function(e) {
var t = _.extend(e, {
originator: this,
model: this.getValue()
});
this.doNotify(t);
},
pickerTapped: function(e, t) {
t.originator.name === "iconButton" && this.receiveFocus();
},
saveAddress: function(e) {
var t = this, n = this.getValue(), r = n.isNew() ? 0 : 1, i = {}, s = {}, o = n.isValid(), u = XM.Model;
e = e || {};
if (o && n.getStatus() !== u.READY_CLEAN) if (n.getStatus() === XM.EMPTY || n.isAllEmpty()) n.isNew() && n.releaseNumber(), n.clear(), this.setValue(null); else if (n.isDirty()) return i.success = function(e) {
var i, o = {};
if (e) {
o[XM.Address.prototype.idAttribute] = e, i = XM.Address.findOrCreate(o), o.success = function() {
t.setValue(i), t.valueChanged();
}, i.fetch(o);
return;
}
s.success = function(e) {
var i = {}, s = {}, u, a;
e > r ? (i.type = XM.Model.YES_NO_CANCEL, i.callback = function(e) {
var r;
e.answer === !1 ? (r = function() {
var e = a.id, n = a.get("number");
e && n && (a.off("change:id change:number", u), a.save(null), t.setValue(a));
}, a = n.copy(), a.on("change:id change:number", r), r(), s[n.idAttribute] = n.id, n.fetch(s)) : e.answer === !0 ? n.save(null, o) : n.fetch({
success: function() {
t.valueChanged();
}
});
}, i.message = "_addressShared".loc() + " " + "_changeAll?".loc(), t.notify(i)) : n.save(null, o);
}, n.useCount(s);
}, XM.Address.findExisting(n.get("line1"), n.get("line2"), n.get("line3"), n.get("city"), n.get("state"), n.get("postalCode"), n.get("country"), i);
var a = n.save(null, e);
!a && e.success && e.success(n);
},
search: function() {
var e = this, t = this.getList(), n = this.getAccount(), r = [], i = function(t) {
e.setValue(t);
};
n && r.push({
name: "account",
value: n.id ? n.id : n
}), this.doSearch({
list: t,
callback: i,
parameterItemValues: r
});
},
mapTap: function() {
var e = this.getValue(), t = [ e.get("line1") || "", e.get("line2") || "", e.get("line3") || "", e.get("city") || "", e.get("state") || "", e.get("postalCode") || "", e.get("country") || "" ], n = !1;
for (var r = 0; r < t.length; r++) t[r] && (t[r] = t[r] + ",+", n = !0);
return n && window.open("http://maps.google.com/?q=" + t.join("")), !0;
},
searchButtonKeyUp: function(e, t) {
return (t.keyCode === 13 || t.keyCode === 32) && this.search(), !0;
},
setDisabled: function(e) {
this.$.viewer.addRemoveClass("disabled", e), this.$.editButton.setDisabled(e), this.$.searchButton.setDisabled(e);
},
setValue: function(e, t) {
var n = this, r, i, s, o = this.value ? this.value.id : null, u = e ? e.id : null, a = {};
this.value && this.value instanceof XM.Model && this.value.releaseLock();
if (e instanceof XM.Model && (_.isNull(e.etag) && e.id && !e.isNew() || e.recordType !== "XM.AddressInfo")) {
i = new XM.AddressInfo, s = function() {
n.setValue(i, t);
}, a[i.idAttribute] = e.id, a.success = s, i.fetch(a);
return;
}
t = t || {};
if (u === o) return;
this.value = e, this.valueChanged(e, t), this.$.state.setCountry(e && e.get("country")), t.silent || (r = {
originator: this,
value: e
}, this.doValueChange(r));
},
valueChanged: function(e, t) {
e = e || this.getValue();
var n = "", r = "", i = "", s = "", o = "", u = "", a = "", f = "";
e && (n = e.get("line1") || "", r = e.get("line2") || "", i = e.get("line3") || "", s = e.get("city") || "", o = e.get("state") || "", u = e.get("postalCode") || "", a = e.get("country") || "", f = XM.Address.format(e)), this.$.line1.setValue(n, t), this.$.line2.setValue(r, t), this.$.line3.setValue(i, t), this.$.city.setValue(s, t), this.$.state.setValue(o, t), this.$.postalCode.setValue(u, t), this.$.country.setValue(a, t), this.$.viewer.addRemoveClass("placeholder", !f), this.$.viewer.addRemoveClass("hyperlink", f), this.$.viewer.setContent(f || "_none".loc());
}
}), enyo.kind({
name: "XV.AddressFieldsWidget",
kind: "XV.AddressWidget",
inputChanged: function(e, t) {
var n = t.originator.name, r = this.attr[n];
return t.originator.attr = r, t.value = t.originator.getValue(), this.doValueChange(t), !0;
},
saveAddress: function() {},
setValue: function(e, t) {
var n = this, r;
e.get ? _.each(this.attr, function(t, i) {
r = {}, r.originator = {
attr: t
}, r.value = e.get(i), r.value !== undefined && n.doValueChange(r);
}) : (e = _.clone(e), e.get = function(e) {
return this[e];
}), this.$.state.setCountry(e.get("country")), this.value = e, this.valueChanged(e, t);
}
});
})();

// date.js

(function() {
enyo.kind({
name: "XV.Date",
kind: "XV.Input",
published: {
nullValue: null,
nullText: ""
},
getValueToString: function(e) {
return this.$.input.value;
},
setValue: function(e, t) {
var n = this.getNullValue();
e ? (_.isString(e) ? e = this.validate(e) : e = new Date(e.valueOf()), isNaN(e.getTime()) && (e = n)) : e = n, XV.Input.prototype.setValue.call(this, e, t);
},
textToDate: function(e) {
var t = !1, n = 864e5;
if (e === "0" || e.indexOf("+") === 0 || e.indexOf("-") === 0) t = new Date((new Date).getTime() + e * n); else if (e.indexOf("#") === 0) /^\d+$/.test(e.substring(1)) && (t = new Date, t.setMonth(0), t.setDate(e.substring(1))); else if (e.length && !isNaN(e)) {
t = new Date, t.setDate(e);
var r = new Date;
r.setMonth(r.getMonth() + 1), r.setDate(0), r.getTime() < t.getTime() && (t = r);
} else e && /^\d+[\/\-\.]\d+[\/\-\.]\d+/.test(e) && (t = new Date(e));
return !_.isDate(t) || isNaN(t.getTime()) ? !1 : (t && (t = this.applyTimezoneOffset(t)), t);
},
applyTimezoneOffset: function(e) {
return e.setHours(0, 0, 0, 0), XT.date.applyTimezoneOffset(e, !1);
},
validate: function(e) {
return e = this.textToDate(e), (_.isDate(e) || _.isEmpty(e)) && e !== !1 ? e : !1;
},
valueChanged: function(e) {
var t = this.getNullValue();
return _.isDate(e) && _.isDate(t) && XT.date.compareDate(e, t) === 0 ? e = this.getNullText() : e ? (e = XT.date.applyTimezoneOffset(e, !0), e = Globalize.format(e, "d")) : e = "", XV.Input.prototype.valueChanged.call(this, e);
}
}), enyo.kind({
name: "XV.DateWidget",
kind: "XV.Date",
classes: "xv-input xv-datewidget",
published: {
label: "",
showLabel: !0
},
components: [ {
kind: "FittableColumns",
components: [ {
name: "label",
content: "",
fit: !0,
classes: "xv-flexible-label"
}, {
kind: "onyx.InputDecorator",
name: "decorator",
tag: "div",
classes: "xv-input-decorator",
components: [ {
name: "input",
kind: "onyx.Input",
onchange: "inputChanged",
classes: "xv-subinput",
onkeydown: "keyDown"
}, {
name: "icon",
kind: "onyx.Icon",
ontap: "iconTapped",
classes: "icon-calendar"
} ]
}, {
name: "datePickPopup",
kind: "onyx.Popup",
maxHeight: 400,
floating: !0,
centered: !0,
modal: !0,
components: [ {
kind: "GTS.DatePicker",
name: "datePick",
style: "min-width:400px;",
onChange: "datePicked"
} ]
} ]
} ],
create: function() {
this.inherited(arguments), this.labelChanged(), this.showLabelChanged();
},
datePicked: function(e, t) {
var n = t, r = {};
this.applyTimezoneOffset(n), r.silent = !0, this.setValue(n, r), this.$.datePickPopup.hide(), this.$.input.focus();
},
disabledChanged: function() {
this.inherited(arguments), this.$.label.addRemoveClass("disabled", this.getDisabled());
},
iconTapped: function(e, t) {
this.$.datePickPopup.show(), this.$.datePick.render();
},
labelChanged: function() {
var e = (this.getLabel() || ("_" + this.attr || "").loc()) + ":";
this.$.label.setContent(e);
},
showLabelChanged: function() {
this.getShowLabel() ? this.$.label.show() : this.$.label.hide();
},
valueChanged: function(e) {
var t = e;
e = XV.Date.prototype.valueChanged.call(this, e), !this.$.input.value && this.$.input.attributes.value && (this.$.input.attributes.value = ""), this.$.datePick.setValue(e ? t : new Date), this.$.datePick.render();
}
});
})();

// completer.js

(function() {
enyo.kind({
name: "XV.Completer",
kind: "onyx.Picker",
classes: "xv-combobox-picker",
style: "width: 100px; z-index: 999;",
modal: !1,
adjustPosition: function(e) {
var t, n;
if (this.showing && this.hasNode()) {
this.removeClass("onyx-menu-up"), this.floating || this.applyPosition({
left: "auto"
});
var r = this.node.getBoundingClientRect(), i = r.height === undefined ? r.bottom - r.top : r.height, s = window.innerHeight === undefined ? document.documentElement.clientHeight : window.innerHeight, o = window.innerWidth === undefined ? document.documentElement.clientWidth : window.innerWidth;
this.menuUp = r.top + i > s && s - r.bottom < r.top - i, this.addRemoveClass("onyx-menu-up", this.menuUp), this.floating && (t = this.activatorOffset, n = t.height === undefined ? t.bottom - t.top : t.height, this.menuUp ? this.applyPosition({
top: t.top - n - i + (this.showOnTop ? t.height : 0),
bottom: "auto"
}) : r.top < t.top && t.top + (e ? t.height : 0) + i < s && this.applyPosition({
top: t.top + n + (this.showOnTop ? 0 : t.height),
bottom: "auto"
})), r.right > o && (this.floating ? this.applyPosition({
left: t.left - (r.left + r.width - o)
}) : this.applyPosition({
left: -(r.right - o)
})), r.left < 0 && (this.floating ? this.applyPosition({
left: 0,
right: "auto"
}) : this.getComputedStyleValue("right") === "auto" ? this.applyPosition({
left: -r.left
}) : this.applyPosition({
right: r.left
}));
}
},
buildList: function(e, t, n, r, i) {
e = _.isString(e) ? [ e ] : e;
var s = new RegExp("^" + t, "i"), o, u, a, f, l, c;
this.destroyClientControls();
if (n && n.length) {
u = i ? n : _.filter(n, function(t) {
for (c = 0; c < e.length; c++) {
a = t.getValue(e[c]) || "";
if (a.match(s)) return !0;
}
return !1;
});
for (l = 0; l < u.length; l++) o = u[l], a = o.getValue(e[0]), a && (f = o.getValue(e[0]), r && (f = f + " <span class='xv-completer-sidecar'>[" + o.getValue(r) + "]</span>"), this.createComponent({
content: f,
allowHtml: !0,
model: o
}));
this.render();
}
}
});
})();

// combobox.js

(function() {
enyo.kind({
name: "XV.ComboboxWidget",
kind: "XV.Input",
published: {
collection: "",
filter: null,
disabled: !1,
keyAttribute: "name",
label: "",
showLabel: !0,
tabStop: !0
},
classes: "xv-combobox xv-input",
handlers: {
onValueChange: "controlValueChanged"
},
components: [ {
kind: "FittableColumns",
name: "fittableColumns",
components: [ {
name: "label",
content: "",
fit: !0,
classes: "xv-flexible-label"
}, {
kind: "onyx.InputDecorator",
tag: "div",
classes: "input-decorator",
components: [ {
name: "input",
kind: "onyx.Input",
onkeyup: "keyUp",
onkeydown: "keyDown",
onblur: "receiveBlur",
onchange: "inputChanged"
}, {
kind: "onyx.IconButton",
name: "iconButton",
ontap: "toggleCompleter",
classes: "icon-sort"
} ]
}, {
name: "completer",
kind: "XV.Completer",
onSelect: "itemSelected"
} ]
} ],
create: function() {
this.inherited(arguments), this.collectionChanged(), this.filterChanged(), this.labelChanged(), this.showLabelChanged(), this.tabStopChanged();
},
autocomplete: function() {
var e = this.getKeyAttribute(), t = this.$.input.getValue(), n = this._collection ? this._collection.models : null, r = t ? new RegExp("^" + t, "i") : null, i;
n && n.length && r && (i = _.find(n, function(t) {
var n = t.get(e) || "";
return n.match(r);
})), i && this.setValue(i.get(e));
},
buildList: function() {
var e = this.getKeyAttribute(), t = this.$.input.getValue(), n = this.filteredList();
this.$.completer.buildList(e, t, n);
},
clear: function(e) {
this.setValue(!1, e);
},
collectionChanged: function() {
var e = this, t;
if (_.isObject(this.collection)) this._collection = this.collection; else {
this._collection = XT.getObjectByName(this.collection);
if (!this._collection) {
t = function() {
e.collectionChanged();
}, XT.getStartupManager().registerCallback(t);
return;
}
}
this.buildList();
},
controlValueChanged: function(e, t) {
if (t.originator !== this) return this.setValue(t.value), !0;
},
setDisabled: function(e) {
this.inherited(arguments), this.$.iconButton.setDisabled(e), this.$.label.addRemoveClass("disabled", e);
},
keyDown: function(e, t) {
this.inherited(arguments), t.keyCode === XV.KEY_TAB && (this.$.completer.hide(), this.autocomplete());
},
keyUp: function(e, t) {
if (t.keyCode === XV.KEY_TAB) return;
t.activator = this, this.$.completer.controls.length && this.$.completer.waterfall("onRequestHideMenu", t), this.buildList(), this.$.completer.controls.length && this.$.completer.waterfall("onRequestShowMenu", t);
},
itemSelected: function(e, t) {
return this.setValue(t.originator.content), this.$.completer.hide(), !0;
},
filterChanged: function() {
this.buildList();
},
filteredList: function(e, t) {
var n = this._collection ? this._collection.models : null, r = this.getFilter();
return r && (n = r(n)), n;
},
labelChanged: function() {
var e = (this.getLabel() || ("_" + this.attr || "").loc()) + ":";
this.$.label.setContent(e);
},
receiveBlur: function(e, t) {
this.autocomplete();
},
showLabelChanged: function() {
this.$.label.setShowing(this.getShowLabel());
},
tabStopChanged: function() {
this.$.input.setAttribute("tabIndex", this.getTabStop() ? null : -1);
},
toggleCompleter: function(e, t) {
t.activator = this;
var n = this.$.completer;
n.showing ? n.waterfall("onRequestHideMenu", t) : n.waterfall("onRequestShowMenu", t);
}
});
})();

// relation.js

(function() {
enyo.kind({
name: "XV.RelationWidget",
kind: enyo.Control,
classes: "xv-input xv-relationwidget",
published: {
attr: null,
label: "",
placeholder: "",
value: null,
list: "",
collection: "",
disabled: !1,
keyAttribute: "number",
sidecarAttribute: "",
nameAttribute: "name",
descripAttribute: "",
additionalAttribute: "",
skipCompleterFilter: !1,
query: null,
keySearch: !1
},
events: {
onSearch: "",
onValueChange: "",
onWorkspace: ""
},
handlers: {
onModelChange: "modelChanged",
onSelect: "itemSelected"
},
components: [ {
kind: "FittableColumns",
components: [ {
name: "label",
content: "",
fit: !0,
classes: "xv-flexible-label"
}, {
kind: "onyx.InputDecorator",
name: "decorator",
classes: "xv-input-decorator",
components: [ {
name: "input",
kind: "onyx.Input",
classes: "xv-subinput",
onkeyup: "keyUp",
onkeydown: "keyDown",
onblur: "receiveBlur",
onfocus: "receiveFocus",
fit: !0
}, {
kind: "onyx.MenuDecorator",
components: [ {
kind: "onyx.IconButton",
classes: "icon-folder-open-alt"
}, {
name: "popupMenu",
floating: !0,
kind: "onyx.Menu",
components: [ {
kind: "XV.MenuItem",
name: "searchItem",
content: "_search".loc()
}, {
kind: "XV.MenuItem",
name: "openItem",
content: "_open".loc(),
disabled: !0
}, {
kind: "XV.MenuItem",
name: "newItem",
content: "_new".loc(),
disabled: !0
} ]
} ]
}, {
name: "completer",
kind: "XV.Completer"
} ]
} ]
}, {
name: "name",
classes: "xv-relationwidget-description"
}, {
name: "description",
classes: "xv-relationwidget-description xv-relationwidget-secondarydescription"
} ],
addParameter: function(e, t) {
var n = this.getQuery() || {}, r = e.attribute;
return n.parameters ? n.parameters = _.filter(n.parameters, function(e) {
return !_.isEqual(e.attribute, r);
}) : n.parameters = [], n.parameters.push(e), this.setQuery(n), t ? _.contains(this._editableParams, r) || this._editableParams.push(r) : this._editableParams = _.without(this._editableParams, r), this;
},
autocomplete: function(e) {
var t = this.getKeyAttribute(), n = this.getValue(), r = this.$.input.getValue(), i, s = [];
_.isString(t) ? (s = n ? n.get(t) : "", i = r !== s) : (_.each(t, function(e) {
var t = n ? n.get(e) : "";
s.push(t);
}), i = i || !_.find(s, function(e) {
return r === e;
})), r && i ? this.fetchCollection(r, 1, "_fetchSuccess") : r || this.setValue(null);
},
clear: function(e) {
this.setValue(null, e);
},
create: function() {
this.inherited(arguments), this._editableParams = [], this.listChanged(), this.labelChanged(), this.disabledChanged();
},
disabledChanged: function() {
var t = this.getDisabled();
this.$.input.setDisabled(t), this.$.searchItem.setDisabled(t), this.$.newItem.setDisabled(e.apply(this) || t), this.$.name.addRemoveClass("disabled", t), this.$.description.addRemoveClass("disabled", t), this.$.label.addRemoveClass("disabled", t);
},
fetchCollection: function(e, t, n) {
var r = this.getKeyAttribute(), i = {}, s = {
attribute: r,
operator: "BEGINS_WITH",
value: e,
keySearch: this.keySearch
}, o = [];
this.getQuery() && (this.getQuery().orderBy && (i.orderBy = JSON.parse(JSON.stringify(this.getQuery().orderBy))), this.getQuery().parameters && (i.parameters = [], _.each(this.getQuery().parameters, function(e) {
i.parameters.push(e);
}))), _.isString(r) ? o = [ {
attribute: r
} ] : _.each(r, function(e) {
o.push({
attribute: e
});
}), i.parameters ? i.parameters.push(s) : i.parameters = [ s ], i.orderBy ? i.orderBy = i.orderby.concat(o) : i.orderBy = o, i.rowLimit = t || 10, this._collection.fetch({
success: enyo.bind(this, n),
query: i
});
},
focus: function() {
this.$.input.focus();
},
getFirstKey: function() {
var e = this.getKeyAttribute();
return _.isString(e) ? e : e[0];
},
getValueToString: function() {
return this.value.getValue(this.getFirstKey());
},
keyDown: function(e, t) {
this.inherited(arguments), t.activator = this.$.decorator, t.keyCode === 9 && (this.$.completer.waterfall("onRequestHideMenu", t), this.autocomplete());
},
keyUp: function(e, t) {
var n = this.getFirstKey(), r = this.getValue() ? this.getValue().get(n) : "", i = this.$.input.getValue(), s = this.$.completer;
t.activator = this.$.decorator, i && i !== r && t.keyCode !== 9 ? this.fetchCollection(i, 10, "_collectionFetchSuccess") : s.waterfall("onRequestHideMenu", t);
},
itemSelected: function(e, t) {
return t.originator.kind === "onyx.MenuItem" ? this.relationSelected(e, t) : this.menuItemSelected(e, t), !0;
},
labelChanged: function() {
var e = this.getLabel() || ("_" + this.attr || "").loc();
this.$.label.setContent(e + ":");
},
listChanged: function() {
var e = this.getList(), t, n;
delete this._List, delete this._Workspace;
if (!e) return;
this._List = XT.getObjectByName(e), n = this._List.prototype.getWorkspace(), this._Workspace = n ? XT.getObjectByName(n) : null, t = this.getCollection() ? XT.getObjectByName(this.getCollection()) : null;
if (!t) return;
this._collection = new t;
},
menuItemSelected: function(e, t) {
var n = this, r = t.originator, i = this.getList(), s = this.getValue(), o = s ? s.id : null, u = this._List ? this._List.prototype.getWorkspace() : null, a = this.getQuery() || {}, f = [], l, c = [];
_.each(a.parameters, function(e) {
_.contains(n._editableParams, e.attribute) ? f.push({
name: e.attribute,
value: e.value
}) : (f.push({
name: e.attribute,
showing: !1
}), c.push(e));
});
switch (r.name) {
case "searchItem":
l = function(e) {
n.setValue(e);
}, this.doSearch({
list: i,
callback: l,
parameterItemValues: f,
conditions: c,
query: this.getQuery()
});
break;
case "openItem":
this.doWorkspace({
workspace: u,
id: o,
allowNew: !1
});
break;
case "newItem":
l = function(e) {
if (!e) return;
var t = n._collection.model, r = {}, i, s = {};
s.success = function() {
n.setValue(i);
}, r[t.prototype.idAttribute] = e.id, i = t.findOrCreate(r), i.fetch(s);
}, this.doWorkspace({
workspace: u,
callback: l,
allowNew: !1
});
}
},
modelChanged: function(e, t) {
var n = this, r = this._List, i = r.prototype.getWorkspace(), s = i ? XT.getObjectByName(i) : null, o = {};
if (!r || !s || !this.value) return;
s.prototype.model === t.model && this.value.id === t.id && (o.success = function() {
n.setValue(this.value);
}, this.value.fetch(o));
},
placeholderChanged: function() {
var e = this.getPlaceholder();
this.$.input.setPlaceholder(e);
},
receiveBlur: function(e, t) {
this.autocomplete(), this._hasFocus = !1;
},
receiveFocus: function(e, t) {
this._hasFocus = !0, this._relationSelected = !1;
},
relationSelected: function(e, t) {
return this._relationSelected = !0, t.activator = this.$.decorator, this.setValue(t.originator.model), this.$.completer.waterfall("onRequestHideMenu", t), !0;
},
removeParameter: function(e) {
var t = this.getQuery();
return t && t.parameters && (t.parameters = _.filter(t.parameters, function(t) {
return t.attribute !== e;
})), this.setQuery(t), this._editableParams = _.without(this._editableParams, e), this;
},
setValue: function(t, n) {
n = n || {};
var r = this, i = t ? t.id : null, s = this.value ? this.value.id : null, o = this.getFirstKey(), u = this.getNameAttribute(), a = this.getDescripAttribute(), f = this.getAdditionalAttribute(), l = {
value: t,
originator: this
}, c = "", h = "", p = "", d = "", v = this._Workspace || (i ? this._List.prototype.getWorkspace(t) : null), m = this._collection.model, g, y, b = this.getList(), w, E, S, x, T = function() {
t && i && (t.couldRead ? r.$.openItem.setDisabled(!t.couldRead()) : r.$.openItem.setDisabled(!t.getClass().canRead()));
};
b && (w = XT.getObjectByName(b), S = w.prototype.collection, x = XT.getObjectByName(S), E = x.prototype.model);
if (t && (_.isNumber(t) || _.isString(t) || !(t instanceof m))) {
if (this.value === t || s === t) return;
if (!E || t instanceof XM.Model && !(t instanceof E)) throw "The type of model passed is incompatible with this widget";
g = _.isObject(t) ? t.id : t, y = new m, n = {
id: g,
success: function() {
r.setValue(y);
},
error: function() {
XT.log("Error setting relational widget value");
}
}, y.fetch(n);
return;
}
this.value = t, t && t.getValue && (c = t.getValue(o) || "", h = t.getValue(u) || "", p = t.getValue(a) || "", d = t.getValue(f) || ""), this.$.input.setValue(c), this.$.name.setShowing(h), this.$.name.setContent(h), this.$.description.setShowing(p), this.$.description.setContent(p), i !== s && !n.silent && this.doValueChange(l), r.$.openItem.setShowing(v), r.$.newItem.setShowing(v), r.$.openItem.setDisabled(!0), r.$.newItem.setDisabled(e.apply(this) || this.disabled), m && v && (XT.session ? T() : XT.getStartupManager().registerCallback(T));
},
_collectionFetchSuccess: function() {
if (!this._hasFocus) return;
var e = this.getKeyAttribute(), t = this.getSidecarAttribute(), n = this.$.input.getValue(), r = this._collection.models, i = {
activator: this.$.decorator
};
r.length ? (this.$.completer.buildList(e, n, r, t, this.skipCompleterFilter), this.$.completer.showing || this.$.completer.waterfall("onRequestShowMenu", i), this.$.completer.adjustPosition()) : this.$.completer.waterfall("onRequestHideMenu", i);
},
_fetchSuccess: function() {
if (this._relationSelected) return;
var e = this._collection.length ? this._collection.models[0] : null, t = enyo.dispatcher.captureTarget;
this.setValue(e), enyo.dispatcher.captureTarget = t;
}
});
var e = function() {
var e = this._Workspace, t = this._collection.model, n = !0;
return t && t.couldCreate ? n = !t.couldCreate() : t && (n = !t.canCreate()), n;
};
})();

// parameter.js

(function() {
enyo.kind({
name: "XV.ParameterItem",
classes: "xv-parameter-item",
published: {
value: null,
label: "",
filterLabel: "",
attr: "",
operator: "",
isCharacteristic: !1
},
events: {
onParameterChange: ""
},
handlers: {
onValueChange: "parameterChanged"
},
components: [ {
name: "input",
classes: "xv-parameter-item-input"
} ],
defaultKind: "XV.InputWidget",
create: function() {
this.inherited(arguments), this.labelChanged(), !this.getOperator() && this.defaultKind === "XV.InputWidget" ? this.setOperator("MATCHES") : this.$.input instanceof XV.Picker && this.$.input.setNoneText("_any".loc());
},
labelChanged: function() {
this.$.input.setLabel(this.label);
},
getParameter: function() {
var e, t = this.getAttr(), n = this.getValue();
return t && n !== undefined && n !== null && n !== "" && (e = {
attribute: t,
operator: this.getOperator(),
isCharacteristic: this.getIsCharacteristic(),
value: n
}), e;
},
getValue: function() {
var e = this.$.input.getValue();
return e && this.$.input.valueAttribute && (e = e.get(this.$.input.valueAttribute)), e;
},
parameterChanged: function() {
var e = {
value: this.getValue,
originator: this
};
return this.doParameterChange(e), !0;
},
setDisabled: function(e) {
return this.$.input.setDisabled ? this.$.input.setDisabled(e) : !1;
},
setValue: function(e, t) {
this.$.input.setValue(e, t);
}
}), enyo.kind(enyo.mixin({
name: "XV.ParameterWidget",
kind: "FittableRows",
classes: "xv-parameter-panel",
handlers: {
onItemSave: "saveItem",
onItemChange: "loadItem",
onParameterChange: "parameterChanged"
},
events: {
onParameterChange: ""
},
published: {
characteristicsRole: undefined,
showSaveFilter: !0,
showLayout: !1,
defaultFilter: null,
currentFilter: null,
currentLayout: null
},
defaultParameters: null,
defaultKind: "XV.ParameterItem",
isAllSetUp: !1,
create: function() {
var e = this.getCharacteristicsRole(), t = XM.Characteristic, n = this, r, i = {}, s = [];
this.inherited(arguments), this.processExtensions(), this.isAllSetUp = !0, e && (i[e] = !0, XM.characteristics.where(i).length && (this.createComponent({
kind: "onyx.GroupboxHeader",
content: "_characteristics".loc()
}), r = XM.characteristics.filter(function(n) {
var r = n.get("characteristicType");
return n.get(e) && n.get("isSearchable") && (r === t.TEXT || r === t.LIST);
}), _.each(r, function(e) {
var r;
i = {
name: e.get("name") + "Characteristic",
label: e.get("name"),
isCharacteristic: !0,
attr: e.get("name")
}, e.get("characteristicType") === t.LIST && (r = enyo.kind({
kind: "XV.PickerWidget",
idAttribute: "value",
nameAttribute: "value",
create: function() {
this.inherited(arguments), this.buildList();
},
filteredList: function() {
return e.get("options").models;
},
getValue: function() {
return this.value ? this.value.get("value") : null;
}
}), i.defaultKind = r), n.createComponent(i);
}), r = XM.characteristics.filter(function(n) {
var r = n.get("characteristicType");
return n.get(e) && n.get("isSearchable") && r === t.DATE;
}), _.each(r, function(e) {
n.createComponent({
kind: "onyx.GroupboxHeader",
content: e.get("name").loc()
}), i = {
name: e.get("name") + "FromCharacteristic",
label: "_from".loc(),
filterLabel: e.get("name") + " " + "_from".loc(),
operator: ">=",
attr: e.get("name"),
isCharacteristic: !0,
defaultKind: "XV.DateWidget"
}, n.createComponent(i), i = {
name: e.get("name") + "ToCharacteristic",
label: "_to".loc(),
filterLabel: e.get("name") + " " + "_to".loc(),
operator: "<=",
attr: e.get("name"),
isCharacteristic: !0,
defaultKind: "XV.DateWidget"
}, n.createComponent(i);
}))), this.setDefaultFilter(_.result(this, "defaultParameters")), this.getShowSaveFilter() && s.push({
kind: "XV.FilterForm",
name: "filterForm",
addBefore: null
}), this.getShowLayout() && s.push({
kind: "XV.LayoutForm",
name: "layoutForm",
addBefore: null
}), this.createComponents(s, {
owner: this
}), this.populateFromUserPref(), this._init = !0;
},
buildColumnList: function(e) {
this.$.layoutForm.addColumns(e);
},
defaultFilterChanged: function() {
this.populateParameters(this.getDefaultFilter());
},
getParameters: function() {
var e, t, n = [], r;
for (e = 0; e < this.children.length; e++) r = this.children[e], t = r && r.showing && r.getParameter ? r.getParameter() : null, t && (n = _.union(n, t));
return n;
},
getSelectedValues: function(e) {
e = e || {};
var t = {}, n, r, i, s, o, u, a, f;
for (n in this.$) this.$[n] instanceof XV.ParameterItem && this.$[n].showing && this.$.hasOwnProperty(n) && (r = this.$[n], i = r.getValue(), s = e.name ? r.getName() : r.getFilterLabel() || r.getLabel(), o = r.$.input, r.$.input.kind === "XV.CheckboxWidget" ? e.value ? t[s] = i : i === !0 && (t[s] = o.getValueToString ? o.getValueToString() : i) : r.$.input.kind === "XV.ToggleButtonWidget" ? e.value ? t[s] = i : i === !1 && (t[s] = o.getValueToString ? o.getValueToString() : i) : i !== undefined && i !== null && i !== "" && (e.deltaDate && r.$.input.kind === "XV.DateWidget" ? (a = XT.date.today(), u = XT.date.applyTimezoneOffset(o.getValue(), !0), f = XT.date.daysBetween(u, a), f = f < 0 ? "" + f : "+" + f, t[s] = f) : e.value ? t[s] = i instanceof XM.Model ? i.id : i : t[s] = o.getValueToString ? o.getValueToString() : i));
return t;
},
parameterChanged: function(e, t) {},
saveItem: function(e, t) {
var n = XT.getObjectByName("XM.Filter"), r = t.model, i = {}, s = {}, o = {}, u, a = this.kind;
e.itemType === "filter" ? o = JSON.stringify(this.getSelectedValues({
name: !0,
value: !0,
deltaDate: !0
})) : e.itemType === "layout" && (o = JSON.stringify(this.$.layoutForm.getColumnValues())), r || (r = new n(null, {
isNew: !0
})), r.set("name", t.itemName), r.set("shared", t.isShared), r.set("params", o), r.set("kind", a), r.set("type", e.itemType), i.success = function(e, n, r) {
t.callback(e);
}, r.isDirty() ? r.save(null, i) : i.success(r);
},
loadItem: function(e, t) {
var n = t.model, r = n ? n.get("params") : null, i = n ? n.get("type") : "filter";
i === "filter" ? (this.setCurrentFilter(n), this.clearParameters(), r = r ? r : this.getDefaultFilter(), this.populateParameters(r)) : i === "layout" && (this.setCurrentLayout(n), this.populateLayout(r)), this.saveToUserPref();
},
clearParameters: function() {
_.each(this.$, function(e) {
e instanceof XV.ParameterItem && e.showing && e.$.input.clear({
silent: !0
});
}), this._init && this.doParameterChange();
},
populateLayout: function(e) {
e = _.isObject(e) ? e : JSON.parse(e), this.$.layoutForm.loadColumns(e);
},
populateParameters: function(e) {
e = _.isObject(e) ? e : JSON.parse(e), _.each(e, function(e, t) {
var n = this.$[t];
n && n.setValue(e, {
silent: !0
});
}, this), this._init && this.doParameterChange();
},
populateFromUserPref: function() {
var e, t = this.kind, n = {}, r = {}, i;
e = XT.DataSource.getUserPreference(t), e && e !== "null" && (e = JSON.parse(e), n = e.filter || {}, r = e.layout || {}, this.getShowSaveFilter() && this.$.filterForm.$.itemPicker.setValue(n.uuid), this.getShowLayout() && this.$.layoutForm.$.itemPicker.setValue(r.uuid));
},
saveToUserPref: function() {
var e, t, n = this.kind, r = {}, i = this.getCurrentFilter(), s = this.getCurrentLayout();
r.filter = i || {}, r.layout = s || {}, e = JSON.stringify(r), t = XT.DataSource.getUserPreference(n) ? "replace" : "add", XT.DataSource.saveUserPreference(n, e, t), XT.session.preferences.set(n, e);
},
setParameterItemValues: function(e) {
var t = this, n = function(e, n) {
var r = t.$[e] || _.find(t.$, function(t) {
return t.attr === e;
});
r && (n.showing !== !1 && r.setValue(n.value, {
silent: !0
}), r.setShowing(n.showing !== !1));
};
_.each(e, function(e) {
typeof e.name == "string" ? n(e.name, e) : typeof e.name == "object" && _.each(e.name, function(t) {
n(t, e);
});
});
}
}, XV.ExtensionsMixin)), enyo.kind({
name: "XV.UserItemForm",
classes: "xv-filter-form",
events: {
onItemSave: "",
onItemChange: ""
},
handlers: {
onValueChange: "valueChanged",
onListChange: "listChanged"
},
itemType: "",
components: [],
activateSave: function(e, t) {
this.$.saveDrawer.setOpen(!this.$.saveDrawer.open), this.$.saveTopDrawer.changeIcon(this.$.saveDrawer.open);
},
activateManage: function(e, t) {
this.$.filterList.reset(), this.$.manageDrawer.setOpen(!this.$.manageDrawer.open), this.$.manageTopDrawer.changeIcon(this.$.manageDrawer.open);
},
checkExisting: function(e, t) {
var n = this.$.itemName.getValue() ? this.$.itemName.getValue().trim() : "", r = this.itemExists(n);
r ? this.$.existingPopup.show() : this.saveItem(e, t);
},
listChanged: function(e, t) {
t = t || {}, this.$.itemPicker.collectionChanged(), t.delete && t.model === this.$.itemPicker.getValue() && this.$.itemPicker.setValue(null), this.$.filterList.fetched();
},
create: function() {
this.inherited(arguments), this.$.apply.setDisabled(!this.validate());
var e = function(e, t) {
var n = _.filter(e, function(e) {
var t = this.parent.parent.kind === e.get("kind"), n = e.get("shared") || e.get("createdBy") === XM.currentUser.get("username"), r = this.parent.itemType === e.get("type") || this.parent.itemType === "filter" && !e.get("type");
if (t && n && r) return !0;
}, this);
return n;
};
this.$.itemPicker.filter = e, this.$.itemPicker.collectionChanged();
var t = this.$.filterList.getQuery() || {};
t.parameters = [], t.parameters = [ {
attribute: "createdBy",
operator: "=",
value: XT.session.details.username
}, {
attribute: "kind",
operator: "=",
value: this.parent.kind
}, {
attribute: "type",
operator: "=",
value: this.itemType,
includeNull: this.itemType === "filter"
} ], this.$.filterList.setQuery(t);
},
itemExists: function(e) {
var t = _.find(this.$.filterList.getValue().models, function(t) {
var n = t.get("name");
return n.toLowerCase() === e.toLowerCase();
});
return t;
},
hidePopup: function(e, t) {
this.$.existingPopup.hide();
},
saveItem: function(e, t) {
var n = this.$.itemName.getValue() ? this.$.itemName.getValue().trim() : "", r = this.$.isShared.getValue(), i = this.itemExists(n), s = this;
t = {
model: i,
itemName: n,
isShared: r,
callback: function(e) {
i || s.$.filterList.getValue().add(e), s.activateSave(), s.$.existingPopup.hide(), s.$.itemPicker.setValue(e), s.$.filterList.doListChange();
}
}, this.doItemSave(t);
},
validate: function() {
return this.$.itemName.getValue() ? !0 : !1;
},
valueChanged: function(e, t) {
this.$.apply.setDisabled(!this.validate());
if (e.kind === "XV.FilterPicker") {
var n = t.originator.value, r = n ? n.get("name") : null, i = n ? n.get("shared") : !1;
this.$.itemName.setValue(r), this.$.isShared.setValue(i), t = {
model: n
}, this.doItemChange(t);
}
return !0;
}
}), enyo.kind({
name: "XV.FilterForm",
kind: "XV.UserItemForm",
itemType: "filter",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_filters".loc()
}, {
kind: "XV.FilterPicker",
name: "itemPicker",
label: "_filter".loc()
}, {
kind: "XV.TopDrawer",
name: "saveTopDrawer",
ontap: "activateSave",
content: "_saveFilter".loc()
}, {
kind: "onyx.Drawer",
name: "saveDrawer",
open: !1,
animated: !0,
components: [ {
kind: "onyx.GroupboxHeader",
content: "_saveFilter".loc()
}, {
kind: "XV.InputWidget",
name: "itemName",
label: "_filterName".loc()
}, {
kind: "XV.CheckboxWidget",
name: "isShared",
attr: "isShared",
label: "_isShared".loc()
}, {
kind: "FittableColumns",
classes: "xv-buttons",
components: [ {
kind: "onyx.Button",
name: "apply",
classes: "icon-ok",
disabled: !0,
ontap: "checkExisting"
}, {
kind: "onyx.Button",
name: "cancel",
classes: "icon-remove",
ontap: "activateSave"
} ]
} ]
}, {
kind: "XV.TopDrawer",
name: "manageTopDrawer",
ontap: "activateManage",
content: "_manageFilters".loc()
}, {
kind: "onyx.Drawer",
name: "manageDrawer",
open: !1,
animated: !0,
components: [ {
kind: "onyx.GroupboxHeader",
content: "_manageFilters".loc()
}, {
kind: "XV.FilterList",
allowFilter: !1
}, {
kind: "FittableColumns",
classes: "xv-buttons",
components: [ {
kind: "onyx.Button",
name: "done",
classes: "icon-ok",
ontap: "activateManage"
} ]
} ]
}, {
kind: "onyx.Popup",
name: "existingPopup",
centered: !0,
modal: !0,
floating: !0,
scrim: !0,
components: [ {
content: "_filterExists".loc()
}, {
content: "_editFilter?".loc()
}, {
classes: "xv-buttons",
components: [ {
kind: "onyx.Button",
ontap: "saveItem",
classes: "selected icon-ok"
}, {
kind: "onyx.Button",
ontap: "hidePopup",
classes: "icon-remove"
} ]
} ]
} ]
}), enyo.kind({
name: "XV.LayoutForm",
kind: "XV.UserItemForm",
events: {
onColumnsChange: "",
onItemChange: "",
onItemSave: ""
},
itemType: "layout",
components: [ {
kind: "onyx.GroupboxHeader",
content: "_layout".loc()
}, {
kind: "XV.FilterPicker",
name: "itemPicker",
label: "_layout".loc()
}, {
kind: "XV.TopDrawer",
name: "layoutTopDrawer",
ontap: "activateLayout",
content: "_changeLayout".loc()
}, {
kind: "onyx.Drawer",
name: "columnsDrawer",
open: !1,
animated: !0,
components: [ {
kind: "XV.LayoutTree",
name: "layoutTree"
} ]
}, {
kind: "XV.TopDrawer",
name: "saveTopDrawer",
ontap: "activateSave",
content: "_saveLayout".loc()
}, {
kind: "onyx.Drawer",
name: "saveDrawer",
open: !1,
animated: !0,
components: [ {
kind: "onyx.GroupboxHeader",
content: "_saveLayout".loc()
}, {
kind: "XV.InputWidget",
name: "itemName",
label: "_layoutName".loc()
}, {
kind: "XV.CheckboxWidget",
name: "isShared",
attr: "isShared",
label: "_isShared".loc()
}, {
kind: "FittableColumns",
classes: "button-row",
components: [ {
kind: "onyx.Button",
name: "apply",
disabled: !0,
content: "_apply".loc(),
ontap: "checkExisting"
}, {
kind: "onyx.Button",
content: "_cancel".loc(),
ontap: "activateSave"
} ]
} ]
}, {
kind: "XV.TopDrawer",
name: "manageTopDrawer",
ontap: "activateManage",
content: "_manageLayouts".loc()
}, {
kind: "onyx.Drawer",
name: "manageDrawer",
open: !1,
animated: !0,
components: [ {
kind: "onyx.GroupboxHeader",
content: "_manageLayouts".loc()
}, {
kind: "XV.FilterList",
allowFilter: !1
}, {
kind: "FittableColumns",
classes: "button-row",
components: [ {
kind: "onyx.Button",
content: "_done".loc(),
ontap: "activateManage"
} ]
} ]
}, {
kind: "onyx.Popup",
name: "existingPopup",
centered: !0,
modal: !0,
floating: !0,
scrim: !0,
components: [ {
content: "_layoutExists".loc()
}, {
content: "_editLayout?".loc()
}, {
tag: "br"
}, {
kind: "onyx.Button",
content: "_edit".loc(),
ontap: "saveItem",
classes: "onyx-blue xv-popup-button"
}, {
kind: "onyx.Button",
content: "_cancel".loc(),
ontap: "hidePopup",
classes: "xv-popup-button"
} ]
} ],
activateLayout: function(e, t) {
this.$.columnsDrawer.setOpen(!this.$.columnsDrawer.open), this.$.layoutTopDrawer.changeIcon(this.$.columnsDrawer.open);
},
addColumns: function(e) {
var t, n, r = function(e) {
return e.attr === n[t];
}, i, s, o, u;
this.$.layoutTree.setListAttrs(e.getDisplayAttributes()), this.$.layoutTree.$.tree.destroyClientControls(), this.$.layoutTree.createTree(e), this.$.columnsDrawer.render();
},
getColumnValues: function() {
var e = {};
return _.each(this.$.layoutTree.$, function(t) {
t.order !== undefined && t.order !== null && (e[t.order] = t.getAttr());
}), e;
},
loadColumns: function(e) {
_.each(this.$.layoutTree.$, function(t) {
if (t.order !== undefined && t.order !== null && t.getAttr() !== e[t.order]) {
t.setAttr(e[t.order]);
var n = {
order: t.order,
value: e[t.order]
};
this.doColumnsChange(n);
}
}, this);
},
valueChanged: function(e, t) {
this.inherited(arguments), t.originator.kind === "XV.AttributePicker" && (t = {
order: t.originator.owner.order,
value: t.value
}, this.doColumnsChange(t));
}
}), enyo.kind({
name: "XV.TopDrawer",
kind: "FittableColumns",
classes: "onyx-groupbox-header",
published: {
content: ""
},
components: [ {
tag: "i",
classes: "icon-plus-sign-alt",
name: "drawerIcon"
}, {
name: "label"
} ],
changeIcon: function(e) {
e ? this.$.drawerIcon.setClasses("icon-minus-sign-alt") : this.$.drawerIcon.setClasses("icon-plus-sign-alt");
},
contentChanged: function() {
this.$.label.setContent(this.getContent());
},
create: function() {
this.inherited(arguments), this.contentChanged();
}
});
})();

// file_input.js

(function() {
enyo.kind({
name: "XV.FileInput",
kind: "XV.Input",
events: {
onValueChange: "",
onNotify: ""
},
handlers: {
onValueChange: "valueChange"
},
components: [ {
name: "input",
tag: "input type=file",
kind: "onyx.Input",
classes: "xv-subinput",
onchange: "inputChanged"
}, {
name: "scrim",
kind: "onyx.Scrim",
showing: !1,
floating: !0
} ],
setValue: function(e, t) {
t && t.silent ? this.value = e : this.inherited(arguments);
},
valueChange: function(e, t) {
if (t.transformedByFileInput) return !1;
var n = this, r = t.originator.$.input.hasNode().files[0], i = t.value, s;
if (!r) return;
i.indexOf("C:\\fakepath\\") === 0 && (i = i.replace("C:\\fakepath\\", ""));
if (!FileReader) {
this.doNotify({
originator: this,
message: "Sorry! File upload is only supported on modern browsers"
}), t.value = null;
return;
}
return s = new FileReader, s.onload = function() {
n.$.scrim.setShowing(!1), t.value = s.result, t.filename = i, t.transformedByFileInput = !0, n.doValueChange(t);
}, this.$.scrim.setShowing(!0), s.readAsBinaryString(r), !0;
}
});
})();

// toggle_button.js

(function() {
enyo.kind({
name: "XV.ToggleButton",
kind: "onyx.ToggleButton",
published: {
attr: null
},
events: {
onValueChange: ""
},
handlers: {
onChange: "changed"
},
clear: function(e) {
this.setValue(!1, e);
},
setValue: function(e, t) {
t = t || {}, this._silent = t.silent, this.inherited(arguments), this._silent = !1;
},
changed: function(e, t) {
this._silent || (t.value = this.getValue(), this.doValueChange(t));
}
}), enyo.kind({
name: "XV.ToggleButtonWidget",
kind: "XV.Input",
classes: "xv-inputwidget xv-checkboxwidget",
published: {
label: ""
},
components: [ {
kind: "FittableColumns",
components: [ {
name: "label",
content: "",
classes: "xv-label"
}, {
kind: "onyx.InputDecorator",
classes: "xv-input-decorator",
components: [ {
name: "input",
kind: "onyx.ToggleButton",
onChange: "inputChanged"
} ]
} ]
} ],
clear: function(e) {
this.setValue(!1, e);
},
create: function() {
this.inherited(arguments), this.labelChanged();
var e = {
silent: !0
};
this.valueChanged(this.getValue(), e);
},
disabledChanged: function() {
this.inherited(arguments), this.$.label.addRemoveClass("disabled", this.getDisabled());
},
inputChanged: function(e, t) {
var n = this.$.input.getValue();
this.setValue(n);
},
labelChanged: function() {
var e = (this.getLabel() || ("_" + this.attr || "").loc()) + ":";
this.$.label.setContent(e);
},
placeholderChanged: function() {},
valueChanged: function(e, t) {
return this.$.input.setValue(e, t), e;
},
typeChanged: function() {}
});
})();

// icon_button.js

(function() {
enyo.kind({
name: "XV.IconButton",
kind: "onyx.TooltipDecorator",
published: {
src: "",
content: ""
},
style: "margin: 0;",
handlers: {
ontap: "tapped"
},
autoDismiss: !0,
components: [ {
name: "iconButton",
kind: "onyx.IconButton",
showing: !0
} ],
create: function() {
this.inherited(arguments), this.srcChanged(), this.contentChanged();
},
srcChanged: function() {
this.$.iconButton.setSrc(this.src);
},
contentChanged: function() {},
tapped: function(e, t) {
if (e.name === "toolTip") return !0;
},
setActive: function() {
this.$.iconButton.setActive(this.active);
},
setDisabled: function() {
this.$.iconButton.setDisabled(this.disabled);
}
});
})();

// chart.js

(function() {
enyo.kind({
name: "XV.SelectableChart",
published: {
processedData: null,
groupByAttr: undefined,
filterAttr: "",
value: null,
model: null,
removeIconShowing: !1,
order: null,
chartTitle: "_chartTitle".loc(),
collection: "",
drillDownRecordType: "",
drillDownAttr: "",
filterOptions: [],
groupByOptions: [],
query: {
parameters: []
},
totalField: ""
},
classes: "selectable-chart",
components: [ {
kind: "onyx.Popup",
name: "spinnerPopup",
style: "margin-top:40px;margin-left:200px;",
components: [ {
kind: "onyx.Spinner"
}, {
name: "spinnerMessage",
content: "_loading".loc() + "..."
} ]
}, {
name: "chartTitleBar",
classes: "chart-title-bar",
components: [ {
name: "chartTitle",
classes: "chart-title"
}, {
kind: "onyx.IconButton",
name: "removeIcon",
src: "/assets/remove-icon.png",
ontap: "chartRemoved",
classes: "remove-icon",
showing: !1
} ]
}, {
name: "chartWrapper",
classes: "chart-bottom",
components: [ {
name: "chart",
components: [ {
name: "svg",
tag: "svg"
} ]
}, {
kind: "enyo.FittableColumns",
components: [ {
content: "_filterOn".loc() + ": ",
classes: "xv-picker-label",
name: "filterPickerLabel"
}, {
kind: "onyx.PickerDecorator",
name: "filterPickerDecorator",
onSelect: "filterSelected",
components: [ {
kind: "XV.PickerButton",
content: "_chooseOne".loc()
}, {
name: "filterPicker",
kind: "onyx.Picker"
} ]
}, {
content: "_groupBy".loc() + ": ",
classes: "xv-picker-label"
}, {
kind: "onyx.PickerDecorator",
onSelect: "groupBySelected",
components: [ {
kind: "XV.PickerButton",
content: "_chooseOne".loc()
}, {
name: "groupByPicker",
kind: "onyx.Picker"
} ]
} ]
} ]
} ],
events: {
onChartRemove: "",
onSearch: "",
onWorkspace: "",
onStatusChange: ""
},
aggregateData: function(e) {
return e;
},
chartRemoved: function(e, t) {
t.model = this.getModel(), this.doChartRemove(t);
},
create: function() {
this.inherited(arguments);
var e = this, t = this.getCollection(), n = t ? XT.getObjectByName(t) : !1;
this.$.removeIcon.setShowing(this.removeIconShowing), this.$.chartTitle.setContent(this.getChartTitle());
if (!n) {
console.log("Error: cannot find collection", t);
return;
}
_.each(this.getFilterOptions(), function(t) {
t.content = t.content || ("_" + t.name).loc(), e.getFilterOptions().length === 1 && (e.$.filterPickerLabel.setShowing(!1), e.$.filterPickerDecorator.setShowing(!1), e.setFilterAttr(t.name)), e.$.filterPicker.createComponent(t);
}), _.each(this.getGroupByOptions(), function(t) {
t.content = t.content || ("_" + (t.name || "all")).loc(), e.$.groupByPicker.createComponent(t);
}), this.setValue(new n), this.getValue().fetch({
query: this.getQuery(),
success: function(t, n) {
e.$.spinnerPopup.hide(), e.modelChanged(), e.orderChanged(), e.processData();
}
});
},
filterData: function(e, t) {
t(e);
},
filterAttrChanged: function() {
var e = this, t = _.find(this.$.filterPicker.controls, function(t) {
return t.name === e.getFilterAttr();
});
t && this.$.filterPicker.setSelected(t), this.processData();
},
filterSelected: function(e, t) {
this.setFilterAttr(t.originator.name), this.getModel().set("filter", t.originator.name);
},
groupByAttrChanged: function() {
var e = this, t = _.find(this.$.groupByPicker.controls, function(t) {
return t.name === e.getGroupByAttr();
});
this.$.groupByPicker.setSelected(t), this.processData();
},
groupBySelected: function(e, t) {
this.setGroupByAttr(t.originator.name), this.getModel().set("groupBy", t.originator.name);
},
modelChanged: function() {
var e = this.getModel(), t = XM.Model, n = e.get("filter") ? e.get("filter") : "all";
this.setFilterAttr(n), this.setGroupByAttr(e.get("groupBy")), this.setBindings("on");
},
orderChanged: function() {
this.getModel().set("order", this.getOrder());
},
plot: function() {},
processData: function() {
var e = this;
if (!this.getValue() || !this.getFilterAttr() || this.getGroupByAttr() === undefined || this.getGroupByAttr() === null) {
this.getFilterAttr() && this.getGroupByAttr() !== undefined && this.getGroupByAttr() !== null && this.$.spinnerPopup.show();
return;
}
this.filterData(this.getValue().models, function(t) {
var n, r;
n = _.groupBy(t, function(t) {
return !e.getGroupByAttr() || !t.get(e.getGroupByAttr()) ? null : typeof t.get(e.getGroupByAttr()) == "object" ? t.get(e.getGroupByAttr()).id : t.get(e.getGroupByAttr());
}), r = e.aggregateData(n), e.setProcessedData(r);
});
},
processedDataChanged: function() {
this.plot();
},
rendered: function() {
this.inherited(arguments), this.processData();
},
setBindings: function(e) {
e = e || "on", this.model[e]("statusChange", this.statusChanged, this);
},
statusChanged: function(e, t, n) {
var r = {
model: e,
status: t
};
this.doStatusChange(r);
}
}), enyo.kind({
name: "XV.DrilldownBarChart",
kind: "XV.SelectableChart",
filterOptions: [ {
name: "all",
parameters: []
} ],
aggregateData: function(e) {
var t = this, n = _.map(e, function(e, n) {
var r = _.reduce(e, function(e, n) {
var r = t.getTotalField() ? n.get(t.getTotalField()) : 1;
return {
label: e.label === "null" ? "_none".loc() : e.label || "_none".loc(),
value: e.value + r
};
}, {
label: n,
value: 0
});
return r;
});
return [ {
values: n
} ];
},
drillDown: function(e, t) {
var n = this, r = this.getValue().model.prototype.recordType, i = XV.getList(r), s = [ {
name: e,
value: t
} ], o = function(e) {
var t = n.getDrillDownRecordType() || n.getValue().model.prototype.recordType, r = n.getDrillDownAttr() || XT.getObjectByName(t).prototype.idAttribute, i = e.get(r);
i && n.doWorkspace({
workspace: XV.getWorkspace(t),
id: i
});
};
this.doSearch({
list: i,
searchText: "",
callback: o,
parameterItemValues: s,
conditions: _.union(this.getQuery().parameters, this.getFilterOptionParameters()),
query: null
});
},
filterData: function(e, t) {
var n = this, r = JSON.parse(JSON.stringify(this.getQuery())), i = this.getFilterOptionParameters();
r.parameters = _.union(r.parameters, i), this.getValue().fetch({
query: r,
success: function(e, n) {
t(e.models);
},
error: function() {
console.log("error in double-filtered query", arguments);
}
});
},
getFilterOptionParameters: function() {
var e = this, t = _.find(this.getFilterOptions(), function(t) {
return t.name === e.getFilterAttr();
});
return t.parameters;
},
plot: function() {
var e = this, t = this.$.svg.hasNode(), n = nv.models.discreteBarChart().x(function(e) {
return e.label;
}).y(function(e) {
return e.value;
}).valueFormat(d3.format(",.0f")).staggerLabels(!0).tooltips(!1).showValues(!0).width(400);
n.yAxis.tickFormat(d3.format(",.0f")), n.margin({
left: 80
}), d3.select(t).datum(this.getProcessedData()).transition().duration(500).call(n), d3.selectAll(".nv-bar").on("click", function(t, n) {
e.drillDown(e.getGroupByAttr(), t.label);
});
}
}), enyo.kind({
name: "XV.TimeSeriesChart",
kind: "XV.SelectableChart",
published: {
dateField: ""
},
filterOptions: [ {
name: "all",
parameters: []
} ],
aggregateData: function(e) {
var t = this, n = (new Date).getTime(), r = n, i = n, s = _.reduce(e, function(e, n) {
return _.each(n, function(e) {
var n = e.get(t.getDateField()).getTime();
r = Math.min(r, n), i = Math.max(i, n);
}), e + n.length;
}, 0), o = Math.ceil(Math.sqrt(s)), u = Math.ceil((i - r) / o), a = _.map(e, function(e, n) {
var s, o, a, f, l;
s = _.groupBy(e, function(e) {
var n = Math.floor((e.get(t.getDateField()).getTime() - r) / u);
return n * u + r;
}), o = _.map(s, function(e, n) {
var r = _.reduce(e, function(e, n, r) {
return e + n.get(t.getTotalField());
}, 0);
return {
x: n,
y: r
};
}), f = function(e) {
return e.x === String(a);
};
for (a = r; a <= i; a += u) l = _.find(o, f), l || o.push({
x: String(a),
y: 0
});
return o = _.sortBy(o, function(e) {
return e.x;
}), n = n === "null" ? "_none".loc() : n || "_none".loc(), {
key: n,
values: o
};
});
return a;
},
plot: function() {
var e = XT.app.$.postbooks.$.navigator.$.contentPanels.children, t = e[e.length - 1], n = this.parent.parent;
if (n.name !== t.name) return;
var r = this, i = this.$.svg.hasNode(), s = nv.models.multiBarChart().stacked(!0);
s.xAxis.tickFormat(function(e) {
return d3.time.format("%b %d %y")(new Date(Number(e)));
}), s.yAxis.tickFormat(d3.format(",.0f")), s.margin({
left: 80
}), d3.select(i).datum(this.getProcessedData()).transition().duration(500).call(s);
}
});
})();

// tree.js

(function() {
enyo.kind({
name: "XV.Tree",
kind: "FittableRows",
fit: !0,
classes: "xv-tree",
components: [ {
kind: "Node",
name: "tree",
content: "",
expandable: !0,
expanded: !0
} ],
buildTree: function(e, t) {
return !0;
},
contentChanged: function() {
this.$.tree.setContent(this.getContent());
},
create: function() {
this.inherited(arguments), this.contentChanged();
}
}), enyo.kind({
name: "XV.TreeNode",
kind: "Node",
expandable: !0,
expanded: !0,
classes: "xv-tree-node"
});
})();

// number_spinner.js

(function() {
enyo.kind({
name: "XV.NumberSpinnerWidget",
kind: "XV.NumberWidget",
published: {
maxlength: 3,
scale: XT.QTY_SCALE,
formatting: !0,
showSlider: !1,
maxValue: 100,
label: "",
showLabel: !0
},
classes: "spinner",
components: [ {
kind: "FittableColumns",
components: [ {
kind: "FittableRows",
components: [ {
name: "label",
classes: "xv-label"
} ]
}, {
kind: "FittableRows",
fit: !0,
components: [ {
kind: "onyx.Slider",
name: "slider",
onChange: "sliderChanged",
classes: "slider"
}, {
kind: "onyx.InputDecorator",
tag: "div",
classes: "input-decorator",
components: [ {
name: "input",
kind: "onyx.Input",
classes: "xv-subinput",
onchange: "inputChanged",
onkeydown: "keyDown"
}, {
kind: "FittableRows",
components: [ {
kind: "onyx.Button",
classes: "buttons",
ontap: "increase",
attributes: {
tabIndex: "-1"
},
components: [ {
tag: "i",
classes: "icon-angle-up"
} ]
}, {
kind: "onyx.Button",
classes: "buttons",
ontap: "decrease",
attributes: {
tabIndex: "-1"
},
components: [ {
tag: "i",
classes: "icon-angle-down"
} ]
} ]
} ]
} ]
} ]
} ],
create: function() {
this.inherited(arguments), this.labelChanged(), this.showSliderChanged(), this.showLabelChanged();
},
decrease: function(e, t) {
var n = Math.max(parseInt(this.$.input.getValue() || 0, 10) - 1, 0);
this.setValue(n), this.setSliderValue();
},
increase: function(e, t) {
var n = Math.min(parseInt(this.$.input.getValue() || 0, 10) + 1, this.getMaxValue());
this.setValue(n), this.setSliderValue();
},
setSliderValue: function() {
this.$.slider.setValue(this.$.input.getValue());
},
setValue: function(e, t) {
this.inherited(arguments), this.setSliderValue();
},
showSliderChanged: function() {
this.$.slider.setShowing(this.showSlider);
},
sliderChanged: function(e, t) {
this.$.input.setValue(Math.round(this.$.slider.getValue()));
}
});
})();

// dependencies.js

(function() {
enyo.kind({
name: "XV.DependencyPicker",
kind: "XV.PickerWidget",
published: {
suppressedId: ""
},
classes: "xv-dependency-picker",
showLabel: !1,
noneText: "_delete".loc(),
noneClasses: "xv-negative",
idAttribute: "uuid",
orderBy: [ {
attribute: "sequence"
} ],
filter: function(e, t) {
var n = this.getSuppressedId();
return _.filter(e || [], function(e) {
return e.id !== n;
});
}
}), enyo.kind({
name: "XV.DependencyItem",
kind: "FittableColumns",
classes: "xv-dependency-item",
published: {
value: null,
parentId: "",
disabled: !1
},
handlers: {
onValueChange: "controlValueChanged"
},
components: [ {
kind: "XV.DependencyPicker"
} ],
disabledChanged: function(e) {
this.$.dependencyPicker.setDisabled(this.disabled);
},
controlValueChanged: function(e, t) {
var n = e.getValue(), r = this.getValue();
return _.isObject(n) ? r.set("id", n.id) : (r.off("change"), r.unset("id"), r.destroy()), !0;
},
parentIdChanged: function() {
var e = this.$.dependencyPicker;
e.setSuppressedId(this.getParentId()), e.buildList();
},
setCollection: function(e) {
this.$.dependencyPicker.setCollection(e);
},
valueChanged: function() {
var e = this.$.dependencyPicker, t = this.getValue(), n = t.get("id");
e.setValue(n, {
silent: !0
});
}
});
var e = function(e) {
var t = this._successors.pluck("id").toString();
this.setValue({
successors: t
});
};
enyo.kind({
name: "XV.DependenciesWidget",
classes: "xv-dependencies-widget",
events: {
onValueChange: ""
},
published: {
attr: null,
model: null,
workflow: null,
parentId: "",
successors: null,
disabled: !1
},
components: [ {
kind: "onyx.GroupboxHeader",
content: "_successors".loc()
}, {
kind: "Repeater",
count: 0,
onSetupItem: "setupItem",
components: [ {
kind: "XV.DependencyItem"
} ]
}, {
kind: "FittableColumns",
classes: "xv-dependency-buttons",
components: [ {
kind: "onyx.Button",
name: "newButton",
classes: "icon-plus-sign-alt xv-dependency-button",
onclick: "newItem"
} ]
} ],
create: function() {
this.inherited(arguments), this._successors = new Backbone.Collection, this._successors.on("remove", e, this);
},
disabledChanged: function() {
this.$.newButton.setDisabled(this.disabled);
},
lengthChanged: function() {
this.$.repeater.setCount(this._successors.length);
},
newItem: function() {
var t = new Backbone.Model;
t.on("change", e, this), this._successors.add(t), this.lengthChanged();
},
setupItem: function(e, t) {
var n = t.item.$.dependencyItem, r = this._successors.at(t.index), i = this.getWorkflow();
return n.setDisabled(this.disabled), n.setCollection(i), n.setParentId(this.getParentId()), n.setValue(r), !0;
},
setValue: function(e, t) {
t = t || {};
var n = this.getAttr(), r = {}, i = _.keys(e), s, o, u;
for (u = 0; u < i.length; u++) s = i[u], o = "set" + s.slice(0, 1).toUpperCase() + s.slice(1), this[o](e[s]), n[s] && (r[n[s]] = e[s]);
!_.isEmpty(r) && !t.silent && this.doValueChange({
value: r
});
},
successorsChanged: function() {
var t = this.getSuccessors(), n = this, r = [];
t = t ? t.split(",") : [], _.each(t, function(t) {
var i = new Backbone.Model;
i.set("id", t), i.on("change", e, n), r.push(i);
}), this._successors.reset(r), this.lengthChanged();
}
});
})();

// list_base.js

(function() {
enyo.kind(_.extend({
name: "XV.ListBase",
kind: "List",
published: {
actions: null,
headerComponents: null
},
events: {
onNotify: "",
onSelectionChanged: "",
onSearch: "",
onTransactionList: "",
onWorkspace: ""
},
handlers: {
onActionSelected: "actionSelected",
onListItemMenuTap: "transformListAction",
onModelChange: "modelChanged",
onChange: "selectionChanged",
onSetupItem: "setupItem"
},
actionSelected: function(e, t) {
var n = t.action;
this[n.method || n.name](t);
},
create: function() {
this.inherited(arguments), this._actionPermissions = [], this._haveAllAnswers = [], this._selectedIndexes = [];
},
doneHelper: function(e) {
var t = this.getModel(e.index), n = this, r = function(r) {
e.deleteItem && r ? n.deleteItem(e) : n.refreshModel(t.id, e.callback);
};
return e.id = t.id, r;
},
getModel: function(e) {
return this.value.at(e);
},
haveAllAnswers: function() {
if (this._haveAllAnswers) return !0;
var e = this, t = e._actionPermissions, n;
return _.isEmpty(t) ? !1 : (n = _.reduce(this.getActions(), function(e, n) {
return e && _.isBoolean(t[n.name]);
}, !0), n && (this._haveAllAnswers = !0), n);
},
modelChanged: function(e, t) {
var n = this, r = this.getValue(), i = this.getWorkspace(), s = XT.getObjectByName(this.getCollection());
i = i ? XT.getObjectByName(i) : null, i && t && i.prototype.model === t.model && r && typeof s == "function" && this.refreshModel(t.id, t.done);
},
refreshModel: function(e, t) {},
resetActions: function() {
this._actionPermissions = {}, this._haveAllAnswers = undefined;
},
selectedIndexes: function() {
return _.keys(this.getSelection().selected);
},
selectionChanged: function(e, t) {
var n = this.selectedIndexes(), r = t.index, i = this.actions, s = this;
this.resetActions(), _.each(i, function(e) {
var t = e.prerequisite, i = s._actionPermissions, o = e.name, u = n.length, a = 0, f, l, c, h;
c = function(e) {
if (i[o] === !1) return;
if (e) {
a++;
if (a < u) return;
}
i[o] = e, s.haveAllAnswers() && (s.waterfallDown("onListMenuReady"), s.renderRow(r));
};
if (t) for (h = 0; h < n.length; h++) l = n[h] - 0, f = s.getModel(l), f instanceof XM.Info && !f[t] ? XT.getObjectByName(f.editableModel)[t](f, c) : f[t](c); else c(!0);
});
},
setupItem: function(e, t) {
this.$.listItem.setSelected(t.selected && this.toggleSelected);
if (this.$.listItem.decorated) return this.$.listItem.setValue(this.getModel(t.index)), !0;
},
transformListAction: function(e, t) {
var n = t.index, r = this.getModel(n);
if (!this.haveAllAnswers()) return !0;
t.model = r, t.list = this, t.actions = this.actions, t.actionPermissions = this._actionPermissions;
}
}, XV.FormattingMixin));
})();

// list.js

(function() {
var e = 50, t = 50, n = t * 2;
enyo.kind({
name: "XV.List",
kind: "XV.ListBase",
classes: "xv-list",
fixedHeight: !0,
published: {
label: "",
collection: null,
filterDescription: "",
exportActions: null,
navigatorActions: null,
isMore: !0,
parameterWidget: null,
canAddNew: !0,
allowPrint: !1,
allowFilter: !0,
showDeleteAction: !0,
newActions: null,
query: null,
value: null,
filtered: null
},
events: {
onExportList: "",
onItemTap: "",
onPrintList: "",
onPrintSelectList: "",
onReportList: ""
},
collectionChanged: function() {
var e = this.getCollection(), t = e ? XT.getObjectByName(e) : !1;
t ? this.setValue(new t) : this.setValue(null);
},
create: function() {
this.inherited(arguments);
var e = this.getActions() || [], t = _.findWhere(e, {
name: "delete"
}), n, r, i, s, o;
XM.View.setPresenter(this, "list"), this.collectionChanged(), this.queryChanged(), this.createOverflowRow(), r = this.getValue(), i = r ? r.model : !1, s = i && i.prototype.couldDestroy ? "couldDestroy" : "canDestroy", i.prototype.editableModel && (i = XT.getObjectByName(i.prototype.editableModel)), o = i.prototype.privileges, n = o && o.all && o.all.delete ? o.all.delete : undefined, !t && this.getShowDeleteAction() && e.push({
name: "delete",
privilege: n,
prerequisite: s,
notifyMessage: "_confirmDelete".loc() + " " + "_confirmAction".loc(),
method: "deleteItem",
isViewMethod: !0
}), this.setActions(e);
},
createOverflowRow: function() {
var e = [], t = this.createComponent({
kind: "XV.ListItem",
name: "overflow",
owner: this
});
_.each(this.$, function(t) {
t.kind === "XV.ListColumn" && e.push({
kind: "XV.ListColumn",
classes: t.classes,
components: [ {
kind: "XV.ListAttr",
allowLayout: !0,
overflow: !0,
showPlaceholder: !0
} ]
});
}), t.createComponents(e, {
owner: this
});
},
doDownload: function(e) {
this.openReport(XT.getOrganizationPath() + e.model.getReportUrl("download"));
},
doEmail: function(e) {
XT.session.config.emailAvailable ? e.model.doEmail() : this.openReport(XT.getOrganizationPath() + e.model.getReportUrl());
},
doPrint: function(e) {
XT.session.config.printAvailable ? e.model.doPrint() : this.openReport(XT.getOrganizationPath() + e.model.getReportUrl());
},
openReport: function(e) {
window.open(e, "_newtab");
},
getModel: function(e) {
return this.getFiltered() && this.getFiltered().models[e];
},
getExportActions: function() {
var e = this.exportActions || [], t = !XM.currentUser.get("disableExport"), n = t ? _.findWhere(e, {
name: "export"
}) : !0;
return n || e.push({
name: "export"
}), this.exportActions = e, e;
},
getSortActions: function() {
var e = this.sortActions || [], t = _.findWhere(e, {
name: "sort"
});
return t || e.push({
name: "sort"
}), this.sortActions = e, e;
},
deleteItem: function(e) {
var t = this.getFiltered(), n = e.model, r = n, i = {}, s = this, o = {}, u;
n instanceof XM.Info && (u = XT.getObjectByName(r.editableModel), o[u.prototype.idAttribute] = r.id, r = u.findOrCreate(o)), i.success = function() {
var i = {};
i.success = function() {
t.remove(n), s.fetched(), e.done && e.done();
}, i.error = function(e, t) {
XT.log("error destroying model from list", JSON.stringify(t));
}, r.destroy(i);
}, r.fetch(i);
},
getSearchableAttributes: function() {
var e = this.getValue().model;
return e.getSearchableAttributes ? e.getSearchableAttributes() : [];
},
getCurrentListAttributes: function() {
return _.map(_.filter(this.$, function(e) {
return e.kind === "XV.ListAttr";
}), function(e) {
return e.attr;
});
},
getDisplayAttributes: function() {
var e, t, n, r;
return n = this.getValue().model, e = _.without(n.getAttributeNames(), "id", "uuid") || [], t = _.filter(n.prototype.relations, function(e) {
return e.key !== "characteristics" && e.key !== "address";
}), r = _.map(_.filter(t, function(t) {
return _.contains(e, t.key);
}), function(e) {
var t = XT.getObjectByName(e.relatedModel), n = _.map(_.without(t.getAttributeNames(), "id", "uuid"), function(t) {
return e.key + "." + t;
});
return n;
}), e = _.difference(e, _.map(t, function(e) {
return e.key;
})), _.each(r, function() {
e = e.concat(_.flatten(r));
}), _.uniq(e);
},
getWorkspace: function() {
var e = this.getCollection(), t = e ? XT.getObjectByName(e) : null, n = t ? t.prototype.model.prototype.recordType : null;
return XV.getWorkspace(n);
},
"export": function() {
this.doExportList();
},
fetch: function(e) {
var n = this, r = this.getQuery() || {}, i;
this.fetching = !0, e = e ? _.clone(e) : {}, e.showMore = _.isBoolean(e.showMore) ? e.showMore : !1, i = e.success, e.showMore ? (r.rowOffset += t, e.update = !0, e.add = !0, e.remove = !1) : (this._lastLength = 0, r.rowOffset = 0, r.rowLimit = t), _.extend(e, {
success: function(e, t, r) {
n.fetched(e, t, r), i && i(e, t, r);
},
query: r
}), this.getValue().fetch(e);
},
fetched: function(t, n, r) {
if (this.destroyed) return;
var i = this.getQuery() || {}, s = i.rowOffset || 0, o = i.rowLimit || 0, u = this.getValue().length, a, f, l, c;
this.filter(t, n, r), f = this.getFiltered().length, a = o ? s + o <= u && this._lastLength !== u : !1, this.fetching = !1, this.isMore = a, this.setCount(f), this._lastLength = u, l = f && e > f ? f : e, l !== this.rowsPerPage && this.setRowsPerPage(l), s ? this.refresh() : this.reset(), this._maxTop = this.getScrollBounds().maxTop, f < u && this.lazyLoad();
},
filter: function(e, t, n) {
return this.filtered = this.value, this;
},
findNameInAttr: function(e, t) {
return _.find(e.split("."), function(e) {
return e === t;
});
},
getPlaceholderForAttr: function(e) {
var t, n;
return e.indexOf(".") !== -1 ? (t = e.split("."), n = ("_" + t[0]).loc() + " " + ("_" + t[1]).loc()) : n = ("_" + e).loc(), "_no".loc() + " " + n;
},
itemTap: function(e, t) {
if (!this.getToggleSelected() || t.originator.isKey) return this.doItemTap({
model: this.getModel(t.index)
}), !0;
},
lazyLoad: function() {
if (_.isUndefined(this._maxTop)) return;
var e = this._maxTop - this.rowHeight * n;
this.isMore && !this.fetching && this.getScrollPosition() > e && this.fetch({
showMore: !0
});
},
reportList: function() {
this.doReportList();
},
queryChanged: function() {
var e = this.getQuery(), t = this.getValue();
t && e && e.orderBy && (t.comparator = function(t, n) {
var r, i, s, o, u, a = t.getValue ? "getValue" : "get";
for (u = 0; u < e.orderBy.length; u++) {
s = e.orderBy[u].attribute, o = e.orderBy[u].numeric, r = e.orderBy[u].descending ? n[a](s) : t[a](s), i = e.orderBy[u].descending ? t[a](s) : n[a](s), r = o ? r - 0 : r, i = o ? i - 0 : i;
if (r !== i) return r > i ? 1 : -1;
}
return 0;
});
},
refreshModel: function(e, t) {
var n = this, r = this.getValue(), i = XT.getObjectByName(this.getCollection()), s, o, u, a = this.getValue().get(e);
u = JSON.parse(JSON.stringify(this.getQuery())), o = {
attribute: this.getValue().model.prototype.idAttribute,
operator: "=",
value: e
}, u.parameters ? u.parameters.push(o) : u.parameters = [ o ], s = new i, s.fetch({
query: u,
success: function(e, i) {
a && r.remove(a), e.size() > 0 && r.add(e.at(0), {
silent: !0
}), r.comparator && r.sort(), n.getCount() !== r.length && n.setCount(r.length), n.refresh(), t && t();
},
error: function() {
XT.log("Error checking model status in list");
}
});
},
scroll: function() {
var e = this.inherited(arguments);
return this.lazyLoad(), e;
},
setupItem: function(e, t) {
if (this.inherited(arguments)) return !0;
var n = t.index, r = t.originator.isSelected(n), i = this.getFiltered(), s = this.getModel(n), o = this.$.listItem.getActionIconButton(), u = this.getToggleSelected(), a = this.getActions(), f, l, c, h, p, d, v, m, g, y, b, w, E, S, x, T, N, C;
if (!s) return !0;
this.$.overflow.setShowing(!1), f = s.getValue ? s.getValue("isActive") : !0, l = _.isBoolean(f) ? !f : !1;
for (y in this.$) this.$.hasOwnProperty(y) && (b = this.$[y], h = b.classes === "italic", p = !1, d = !1, v = !1, b.isKey && (d = !0, p = u), b.headerAttr && (x = b.headerAttr, m = n ? i.models[n - 1] : !1, T = !m || s.getValue(x) !== m.getValue(x), this.$.header.canGenerate = T), b.footerAttr && (x = b.footerAttr, g = n ? i.models[n + 1] : !1, T = !g || s.getValue(x) !== g.getValue(x), this.$.footer.canGenerate = T), b.overflow && (_.isEmpty(b.attr) || this.$.overflow.setShowing(!0)), b.getAttr && (w = b, v = !1, x = b.getAttr(), E = s.getValue ? s.getValue(x) : s.get(x), c = _.isNull(E) || _.isUndefined(E) || E === "", C = s.getType ? s.getType(x) : "", S = w.formatter, E === undefined || E === null || E === "" ? x && (w.placeholder || w.showPlaceholder) && (E = w.placeholder || this.getPlaceholderForAttr(x), v = !0) : C === "Email" ? (p = !0, b.ontap = "sendMail") : C === "Phone" ? (p = !0, b.ontap = "callPhone") : C === "Url" && (p = !0, b.ontap = "sendUrl"), w.addRemoveClass("placeholder", v), w.addRemoveClass("hyperlink", p), w.addRemoveClass("bold", d), S ? E = this[S](E, w, s) : !v && !c && _.contains(this.formatted, C) && (E = this["format" + C](E, w, s)), w.setContent(E)));
return this.$.listItem.addRemoveClass("inactive", l), !0;
},
callPhone: function(e, t) {
return this.sendUrl(e, t, "tel://"), !0;
},
sendMail: function(e, t) {
return this.sendUrl(e, t, "mailto:"), !0;
},
sendUrl: function(e, t, n) {
var r = this.getModel(t.index), i = r ? r.getValue(e.attr) : null, s;
i && (n ? (s = window.open(n + i), s.close()) : s = window.open(i, "_blank"));
}
});
})();

// list_relations.js

(function() {
var e = 20, t = 5, n = {
name: "XV.ListRelations",
kind: "XV.ListBase",
classes: "xv-list",
fixedHeight: !0,
toggleSelected: !0,
published: {
attr: null,
value: null,
parentKey: "",
orderBy: null
},
events: {
onParentStatusChange: ""
},
destroy: function() {
var e = this.getValue(), t = e ? e.models : null, n = this;
t && _.each(t, function(e) {
e.off("statusChange", n.statusChanged, n);
}), e && (e.off("add", this.modelAdded, this), e.off("remove reset", this.lengthChanged, this), e[this.getParentKey()] && e[this.getParentKey()].off("statusChange", this.parentStatusChanged, this)), this.inherited(arguments);
},
getFirstSelected: function() {
var e = this.getSelection().selected, t;
for (t in e) if (e.hasOwnProperty(t)) return t;
},
getModel: function(e) {
return this.readyModels()[e];
},
getParent: function() {
var e = this.getParentKey(), t = this.getValue();
return e && t ? t[e] : null;
},
fetchRelated: function(t) {
var n = this.getParent(), r = this.getAttr().suffix(), i = {
max: t || e
};
this.hasMore() && n.fetchRelated(r, i);
},
hasMore: function() {
var e = this.getParent(), t = this.getValue(), n = t ? t.length : 0, r = this.getAttr().suffix(), i = e && r ? e.getRelation(r) : null, s = i && i.keyContents ? i.keyContents : [];
return n < s.length;
},
lengthChanged: function() {
var e = this.readyModels().length, t = this.getValue(), n;
n = e && 50 > e ? e : 50, n !== this.rowsPerPage && this.setRowsPerPage(n), t.comparator && t.sort(), this.setCount(e), this.refresh();
},
modelAdded: function(e) {
var t = e.getStatus(), n = XM.Model;
t === n.READY_CLEAN || t === n.READY_NEW ? this.lengthChanged() : e.on("statusChange", this.statusChanged, this);
},
orderByChanged: function() {
var e = this.getOrderBy() || [], t = this.getValue();
t && e.length && (t.comparator = function(t, n) {
var r, i, s, o;
for (o = 0; o < e.length; o++) {
s = e[o].attribute, r = e[o].descending ? n.getValue(s) : t.getValue(s), i = e[o].descending ? t.getValue(s) : n.getValue(s), r = isNaN(r) ? r : r - 0, i = isNaN(r) ? i : i - 0;
if (r !== i) return r > i ? 1 : -1;
}
return 0;
});
},
parentStatusChanged: function(e) {
this.doParentStatusChange(e);
},
readyModels: function() {
return _.filter(this.value.models, function(e) {
var t = e.getStatus(), n = XM.Model;
return t !== n.DESTROYED_DIRTY && t !== n.DESTRYED_CLEAN && t !== n.EMPTY;
});
},
refreshModel: function(e, t) {
var n = this.getValue(), r = n.get(e), i = r.getParent(!0);
i.fetch({
success: t
});
},
scroll: function(e, n) {
var r = this.inherited(arguments), i = this.getScrollBounds(), s = this._lastShowing || 0, o = this.value ? this.value.length : 0, u = i.clientHeight / this.rowHeight, a = Math.floor(i.top / this.rowHeight + u), f = a > s && o - a - t < 0 && this.hasMore();
return f && (this._lastShowing = a, this.fetchRelated(1)), r;
},
setupItem: function(e, t) {
if (this.inherited(arguments)) return !0;
var n, r, i, s, o, u, a, f, l, c, h, p, d;
n = t.index, r = this.getToggleSelected() && t.originator.isSelected(n), i = this.readyModels()[n];
if (!i) return;
s = i.getValue("isActive"), o = _.isBoolean(s) ? !s : !1;
for (a in this.$) this.$.hasOwnProperty(a) && this.$[a].getAttr && (l = this.$[a], f = !1, c = this.$[a].getAttr(), h = i.getValue(c), p = l.formatter, d = i.getType && i.getType(c), u = _.isNull(h) || _.isUndefined(h) || h === "", p ? (h = this[p](h, l, i), u = _.isNull(h) || _.isUndefined(h) || h === "") : !u && _.contains(this.formatted, d) && (h = this["format" + d](h, l, i)), u && l.placeholder && (h = l.placeholder, f = !0), l.setContent(h), l.addRemoveClass("placeholder", f));
return this.$.listItem.addRemoveClass("inactive", o), this.$.listItem.addRemoveClass("item-selected", r), !0;
},
statusChanged: function(e) {
e.getStatus() === XM.Model.READY_CLEAN && (e.off("statusChange", this.statusChanged, this), this.lengthChanged());
},
valueChanged: function() {
var e = this.getValue();
e && (e.on("add", this.modelAdded, this), e.on("remove reset", this.lengthChanged, this), e[this.getParentKey()] && e[this.getParentKey()].on("statusChange", this.parentStatusChanged, this), this.orderByChanged(), this.lengthChanged(), this.fetchRelated());
}
};
enyo.mixin(n, XV.FormattingMixin), enyo.mixin(n, XV.ListMixin), enyo.kind(n);
})();

// navigator.js

(function() {
var e = 0, t = 1, n = {
name: "XV.Navigator",
kind: "XV.ContainerPanels",
classes: "xv-navigator",
published: {
modules: [],
panelCache: {},
actions: [ {
name: "newTabItem",
label: "_openNewTab".loc(),
method: "newTab",
alwaysShowing: !0
}, {
name: "preferencesItem",
label: "_preferences".loc(),
method: "openPreferencesWorkspace"
}, {
name: "myAccountItem",
label: "_changePassword".loc(),
method: "showMyAccount"
}, {
name: "aboutItem",
label: "_about".loc(),
method: "showAbout"
} ]
},
events: {
onListAdded: "",
onNavigatorEvent: "",
onNotify: "",
onWorkspace: ""
},
handlers: {
onDeleteTap: "showDeletePopup",
onListItemMenuTap: "showListItemMenu",
onMessage: "setMessageContent",
onParameterChange: "requery",
onColumnsChange: "changeLayout",
onItemTap: "itemTap",
onExportList: "exportList",
onHotKey: "handleHotKey",
onPrintList: "printList",
onPrintSelectList: "printSelectList",
onReportList: "reportList"
},
showPullout: !0,
components: [ {
kind: "FittableRows",
name: "navigationMenu",
classes: "xv-menu-container",
components: [ {
kind: "onyx.Toolbar",
classes: "onyx-menu-toolbar",
components: [ {
kind: "font.TextIcon",
name: "backButton",
content: "_logout".loc(),
ontap: "backTapped",
icon: "chevron-left"
}, {
kind: "Group",
name: "iconButtonGroup",
tag: null,
components: [ {
kind: "font.TextIcon",
name: "historyIconButton",
icon: "time",
ontap: "showHistory",
content: "_history".loc()
}, {
kind: "font.TextIcon",
name: "searchIconButton",
icon: "search",
ontap: "showParameters",
content: "_search".loc(),
showing: !1
}, {
kind: "font.TextIcon",
name: "helpIconButton",
icon: "question",
ontap: "showHelp",
content: "_help".loc()
} ]
}, {
kind: "onyx.MenuDecorator",
onSelect: "actionSelected",
components: [ {
kind: "font.TextIcon",
icon: "cog",
content: "_actions".loc(),
name: "actionButton"
}, {
kind: "onyx.Menu",
name: "actionMenu",
floating: !0
} ]
}, {
kind: "onyx.Popup",
name: "aboutPopup",
centered: !0,
modal: !0,
floating: !0,
scrim: !0,
components: [ {
content: "Copyright xTuple 2014"
}, {
name: "aboutVersion",
allowHtml: !0
}, {
kind: "onyx.Button",
content: "_ok".loc(),
ontap: "closeAboutPopup"
} ]
} ]
}, {
name: "loginInfo",
classes: "xv-header"
}, {
name: "menuPanels",
kind: "Panels",
classes: "xv-panels",
draggable: !1,
fit: !0,
margin: 0,
components: [ {
name: "moduleMenu",
kind: "List",
touch: !0,
classes: "xv-navigator-menu",
onSetupItem: "setupModuleMenuItem",
ontap: "menuTap",
components: [ {
name: "moduleItem",
classes: "item enyo-border-box xv-list-item"
} ]
}, {
name: "panelMenu",
kind: "List",
touch: !0,
classes: "xv-navigator-menu",
onSetupItem: "setupPanelMenuItem",
ontap: "panelTap",
components: [ {
name: "listItem",
classes: "item enyo-border-box xv-list-item"
} ]
}, {} ]
} ]
}, {
kind: "FittableRows",
name: "list-view",
components: [ {
kind: "onyx.MoreToolbar",
name: "contentToolbar",
classes: "onyx-menu-toolbar",
movedClass: "xv-toolbar-moved",
components: [ {
kind: "onyx.Grabber",
classes: "spacer",
unmoveable: !0
}, {
name: "rightLabel",
classes: "xv-toolbar-label",
unmoveable: !0
}, {
name: "spacer",
classes: "spacer",
fit: !0
}, {
kind: "font.TextIcon",
name: "backPanelButton",
unmoveable: !0,
content: "_back".loc(),
ontap: "backPanelTapped",
icon: "chevron-left"
}, {
kind: "font.TextIcon",
name: "refreshButton",
icon: "rotate-right",
content: "_refresh".loc(),
ontap: "requery",
showing: !1
}, {
kind: "onyx.MenuDecorator",
onSelect: "newRecord",
showing: !1,
name: "newMenuButton",
components: [ {
kind: "font.TextIcon",
icon: "plus",
content: "_new".loc()
}, {
kind: "onyx.Menu",
name: "newMenu",
floating: !0
} ]
}, {
kind: "font.TextIcon",
icon: "plus",
content: "_new".loc(),
name: "newButton",
ontap: "newRecord",
showing: !1
}, {
kind: "font.TextIcon",
name: "sortButton",
content: "_sort".loc(),
icon: "sort-by-alphabet",
ontap: "showSortPopup",
showing: !1
}, {
kind: "onyx.MenuDecorator",
onSelect: "exportSelected",
name: "exportButton",
components: [ {
kind: "font.TextIcon",
icon: "share",
content: "_export".loc()
}, {
kind: "onyx.Menu",
name: "exportMenu",
floating: !0
} ]
}, {
name: "search",
kind: "onyx.InputDecorator",
showing: !1,
components: [ {
name: "searchInput",
kind: "onyx.Input",
classes: "xv-search",
placeholder: "_search".loc(),
onchange: "inputChanged"
}, {
kind: "Image",
src: "/assets/search-input-search.png",
name: "searchJump",
ontap: "jump"
}, {
kind: "XV.SortPopup",
name: "sortPopup",
showing: !1
} ]
} ]
}, {
name: "messageHeader"
}, {
name: "header",
classes: "xv-header"
}, {
name: "contentHeader"
}, {
name: "contentPanels",
kind: "Panels",
margin: 0,
fit: !0,
draggable: !1,
panelCount: 0,
classes: "scroll-ios"
}, {
name: "myAccountPopup",
kind: "XV.MyAccountPopup"
}, {
name: "listItemMenu",
kind: "onyx.Menu",
floating: !0,
onSelect: "listActionSelected",
maxHeight: 500,
components: []
} ]
} ],
fetched: {},
actionSelected: function(e, t) {
var n = this.$.menuPanels.getIndex(), r = this, i = t.originator.action, s = i.method || i.name;
i.context ? r = this.$.contentPanels.getActive() : n && !i.alwaysShowing && (r = this.getSelectedModule()), r[s](e, t);
},
activate: function() {
this.setMenuPanel(e);
},
backPanelTapped: function() {
this.setIndex(0);
},
backTapped: function() {
var t = this.$.menuPanels.getIndex();
if (t === e) {
var n = {
originator: this,
type: XM.Model.QUESTION,
callback: function(e) {
e.answer && XT.logout();
},
message: "_logoutConfirmation".loc()
};
this.doNotify(n);
} else this.setHeaderContent(""), this.setMenuPanel(e);
},
buildMenus: function() {
var e = this.$.actionMenu, t = this.$.exportMenu, n = this.$.newMenu, r = this.$.menuPanels.getIndex(), i = this.$.contentPanels.getActive(), s = r ? (this.getSelectedModule().actions || []).concat(this.getActions(!0)) : this.getActions(), o = s.slice(0), u = XT.session.privileges;
e.destroyClientControls(), r && i.getNavigatorActions && _.each(i.getNavigatorActions(), function(e) {
e.context = i, o.push(e);
}), _.each(o, function(t) {
var n = t.name, r = t.privilege ? t.privilege.split(" ") : [], i = !1;
r.length && (i = !_.some(r, function(e) {
return u.get(e);
})), e.createComponent({
name: n,
kind: XV.MenuItem,
content: t.label || ("_" + n).loc(),
action: t,
disabled: i
});
}), e.render(), this.$.actionButton.setShowing(o.length), o = [], t.destroyClientControls(), r && i.getExportActions && _.each(i.getExportActions(), function(e) {
e.context = i, o.push(e);
}), _.each(o, function(e) {
var n = e.name, r = e.privilege ? e.privilege.split(" ") : [], i = !1;
r.length && (i = !_.some(r, function(e) {
return u.get(e);
})), t.createComponent({
name: n,
kind: XV.MenuItem,
content: e.label || ("_" + n).loc(),
action: e,
disabled: i
});
}), t.render(), this.$.exportButton.setShowing(o.length), i.kindClasses ? this.$.sortButton.setShowing(i.kindClasses.indexOf("list") !== -1) : this.$.sortButton.setShowing(!1), o = [], n.destroyClientControls(), (r || r === 0) && i.getNewActions && _.each(i.getNewActions(), function(e) {
e.context = i, o.push(e);
}), _.each(o, function(e) {
n.createComponent({
name: e.name,
kind: XV.MenuItem,
content: e.label || ("_" + e.name).loc(),
item: e.item,
defaults: e.defaults,
allowNew: e.allowNew
});
}), n.render();
},
buildLayout: function() {
var e = this.$.contentPanels.getActive(), t = XT.app ? XT.app.$.pullout.getParameterWidget(e.name) : null;
t && t.showLayout && t.buildColumnList(e);
},
cachePanels: function() {
var e = this.$.contentPanels, t, n, r, i, s = function(e) {
return e.index === n;
}, o = function(e) {
var t = _.find(e.panels, s);
return t !== undefined;
};
while (e.children.length > 3) t = e.children[0], n = t.index, r = _.find(this.getModules(), o), i = _.find(r.panels, s), e.removeChild(t), e.children[2].render(), i.status = "cached", this.getPanelCache()[n] = t;
},
changeLayout: function(e, t) {
var n = t.value ? t.value : "", r = t.order, i = this.$.contentPanels.getActive(), s = _.filter(i.$, function(e) {
return e.kind === "XV.ListAttr";
});
for (var o = 0; o < s.length; o++) {
var u = s[o];
r === o + 1 && u.setAttr(n);
}
return this.requery(), this.buildLayout(), !0;
},
clearMessage: function() {
this.$.messageHeader.setContent(""), this.$.messageHeader.setClasses("");
},
closeAboutPopup: function() {
this.$.aboutPopup.hide();
},
create: function() {
this.inherited(arguments);
var e = this, t = function() {
e.buildMenus();
};
!XT.session || !XT.session.privileges ? XT.getStartupManager().registerCallback(t) : t();
},
exportSelected: function(e, t) {
var n = this.$.menuPanels.getIndex(), r = this, i = t.originator.action, s = i.method || i.name;
i.context[s](e, t);
},
getActions: function(e) {
var t = this.actions;
return e && (t = _.filter(t, function(e) {
return e.alwaysShowing === !0;
})), t;
},
getSelectedModule: function() {
return this._selectedModule;
},
exportList: function(e, t) {
return this.openExportTab("export"), !0;
},
newTab: function() {
window.open(XT.getOrganizationPath() + "/app", "_newtab");
},
openPreferencesWorkspace: function() {
this.doWorkspace({
workspace: "XV.UserPreferenceWorkspace",
id: !1
});
},
reportList: function(e, t) {
return this.openExportTab("report"), !0;
},
printList: function(e, t) {
var n = this.$.contentPanels.getActive(), r = n.value.model.prototype.recordType, i = JSON.parse(JSON.stringify(n.getQuery()));
return XT.DataSource.callRoute('report?details={"nameSpace":"%@","type":"%@","query":%@,"culture":%@,"print":%@}'.f(r.prefix(), r.suffix(), JSON.stringify(i), JSON.stringify(XT.locale.culture), "true"), {}, {
success: function(e) {
XT.session.config.debugging && XT.log("Print route success, type: ", r.suffix());
},
error: function(e) {
XT.session.config.debugging && XT.log("Print route error, type: ", r.suffix());
}
}), !0;
},
printSelectList: function(e, t) {
var n = this.$.contentPanels.getActive(), r = n.getSelection().getSelected();
return _.each(r, function(e, t) {
var r = n.getModel(t), i = r.editableModel || r.recordType, s = i.suffix(), o = {
nameSpace: i.prefix(),
type: i.suffix(),
id: r.id,
name: s,
culture: XT.locale.culture,
print: !0
};
XT.DataSource.callRoute("report?details=%@".f(JSON.stringify(o)), {}, {
success: function(e) {
XT.session.config.debugging && XT.log("Print route success, type: ", i.suffix());
},
error: function(e) {
XT.session.config.debugging && XT.log("Print route error, type: ", i.suffix());
}
});
}), !0;
},
openExportTab: function(e) {
var t = this.$.contentPanels.getActive(), n = t.value.model.prototype.recordType, r = JSON.parse(JSON.stringify(t.getQuery()));
delete r.rowLimit, delete r.rowOffset, window.open(XT.getOrganizationPath() + '/%@?details={"nameSpace":"%@","type":"%@","query":%@,"culture":%@,"print":%@}'.f(e, n.prefix(), n.suffix(), JSON.stringify(r), JSON.stringify(XT.locale.culture), "false"), "_newtab");
},
showSortPopup: function(e, t) {
this.$.sortPopup.setList(this.$.contentPanels.getActive()), this.$.sortPopup.setNav(this), this.$.sortPopup.setPickerStrings(), this.$.sortPopup.show();
},
fetch: function(e) {
e = e ? _.clone(e) : {};
var t = this.$.contentPanels.getActive(), n = t ? t.name : "", r, i, s, o, u;
if (!(t instanceof XV.List || t instanceof XV.Dashboard || t instanceof XV.Listboard)) return;
r = t.getQuery() || {}, i = this.$.searchInput.getValue();
if (t.allowFilter) {
s = XT.app ? XT.app.$.pullout.getParameterWidget(n) : null, o = s ? s.getParameters() : [], e.showMore = _.isBoolean(e.showMore) ? e.showMore : !1, u = this.formatQuery(s ? s.getSelectedValues() : null, i), t.setFilterDescription(u), this.setHeaderContent(u), delete r.parameters;
if (i || o.length) r.parameters = [], i && r.parameters.push({
attribute: t.getSearchableAttributes(),
operator: "MATCHES",
value: this.$.searchInput.getValue()
}), o && (r.parameters = r.parameters.concat(o));
s && s.showLayout && this.buildLayout();
}
t.setQuery(r), t.fetch(e);
},
formatQuery: function(e, t) {
var n, r = "";
for (n in e) r += n + ": " + e[n] + ", ";
return t && r ? r += "_match".loc() + ": " + t : t && (r += t), r && (r = "_filterBy".loc() + ": " + r), r.lastIndexOf(", ") + 2 === r.length && (r = r.substring(0, r.length - 2)), r;
},
handleHotKey: function(e, t) {
var n, r = this.getSelectedModule().name === "welcome", i, s = t.keyCode;
if (s >= 49 && s <= 57) {
n = s - 49, r ? this.setModule(Math.min(n, this.getModules().length - 1)) : this.setContentPanel(Math.min(n, this.getSelectedModule().panels.length - 1));
return;
}
if (!r) {
i = this.$.panelMenu.getSelection().lastSelected;
if (s === 38) {
this.setContentPanel(Math.max(i - 1, 0));
return;
}
if (s === 40) {
this.setContentPanel(Math.min(i + 1, this.getSelectedModule().panels.length - 1));
return;
}
}
switch (String.fromCharCode(s)) {
case "A":
this.showParameters();
break;
case "B":
this.backTapped();
break;
case "H":
this.showHelp();
break;
case "N":
this.newRecord({}, {
originator: {}
});
break;
case "R":
this.requery();
}
},
inputChanged: function(e, t) {
this.fetched = {}, this.fetch();
},
itemTap: function(e, t) {
var n = t.originator.getWorkspace(), r = t.model, i = r.couldRead ? !r.couldRead() : !r.getClass().canRead(), s = r && r.id ? r.id : !1;
return i ? (this.showError("_insufficientViewPrivileges".loc()), !0) : (n && this.doWorkspace({
workspace: n,
id: s
}), !0);
},
jump: function() {
var e = this.$.contentPanels.getActive(), t = e ? e.getWorkspace() : null, n = e.getValue().model, r = this._getModelProperty(n, "enforceUpperKey"), i = this.$.searchInput.getValue(), s = this, o = {}, u = this._getModelProperty(n, "documentKey"), a, f = {};
if (this._busy || !i || !u) return;
this._busy = !0, o.success = function(e) {
var r = {};
e ? (r.success = function() {
var n = a.couldRead ? !a.couldRead() : !a.getClass().canRead();
n ? this.showError("_insufficientViewPrivileges".loc()) : t && s.doWorkspace({
workspace: t,
id: e
}), s._busy = !1;
}, f[n.prototype.idAttribute] = e, a = n.findOrCreate(f), a.fetch(r)) : (s.showError("_noDocumentFound".loc()), s.$.searchInput.clear(), s._busy = !1);
}, i = r ? i.toUpperCase() : i, n.findExisting(u, i, o);
},
loginInfo: function() {
return this.$.loginInfo;
},
modulesChanged: function() {
var e = this.getModules() || [], t = this._modules || [], n, r, i, s, o, u, a = function(e) {
return _.find(t, function(t) {
return t.name === e;
});
}, f = function(e, t) {
return _.find(e, function(e) {
return e.name === t;
});
};
for (o = 0; o < e.length; o++) {
i = e[o].panels || [], n = a(e[o].name);
for (u = 0; u < i.length; u++) {
if (n) {
r = f(n.panels, i[u].name);
if (r) continue;
}
i[u].index = this.$.contentPanels.panelCount++, i[u].index < 3 ? (i[u].status = "active", i[u].toggleSelected === undefined && (i[u].toggleSelected = !0), s = this.$.contentPanels.createComponent(i[u]), s instanceof XV.List && this.doListAdded(s)) : i[u].status = "unborn";
}
}
this.$.moduleMenu.setCount(e.length), this._modules = JSON.parse(JSON.stringify(e)), this.render();
},
newRecord: function(e, t) {
var n = this.$.contentPanels.getActive(), r = n instanceof XV.List ? n.getWorkspace() : null, i = t.originator.item, s = t.originator.defaults, o = t.originator.allowNew, u, a, f;
if (n instanceof XV.Dashboard && i) return n.newRecord(i), !0;
if (n instanceof XV.Listboard && i) return n.newRecord(i), !0;
if (!n instanceof XV.List) return !0;
u = n.getValue().model, a = u.couldCreate ? u.couldCreate() : u.canCreate();
if (!a) return this.showError("_insufficientCreatePrivileges".loc()), !0;
if (r) {
var l = {};
this.doWorkspace({
workspace: r,
attributes: s,
allowNew: o === !1 ? !1 : !0
});
}
return t && t.preventDefault && t.preventDefault(), !0;
},
popupHidden: function(e, t) {
this._popupDone || t.originator.show();
},
requery: function(e, t) {
this.fetch();
},
setActiveIconButton: function(e) {
var t = null;
e === "search" ? t = this.$.searchIconButton : e === "history" && (t = this.$.historyIconButton), this.$.iconButtonGroup.setActive(t);
},
setContentPanel: function(e) {
var t = this.$.contentPanels, n = this.getSelectedModule(), r = n && n.panels ? n.panels[e].index : -1, i = n && n.panels ? n.panels[e].status : "unknown", s = this.$.contentHeader, o, u, a, f, l = !0;
this.clearMessage(), i === "active" ? o = _.find(t.children, function(e) {
return e.index === r;
}) : i === "unborn" ? (n.panels[e].status = "active", n.panels[e].toggleSelected === undefined && (n.panels[e].toggleSelected = !0), o = t.createComponent(n.panels[e]), o.render(), o instanceof XV.List && this.doListAdded(o)) : i === "cached" ? (n.panels[e].status = "active", o = this.panelCache[r], t.addChild(o), o.node = undefined, o.render()) : XT.error("Don't know what to do with this panel status");
if (t.index === this.$.contentPanels.indexOfChild(o)) return;
this.cachePanels(), u = o && o.label ? o.label : "", a = o && o.getCollection ? XT.getObjectByName(o.getCollection()) : !1;
if (!o) return;
this.$.searchIconButton.setShowing(!!o.parameterWidget), this.doNavigatorEvent({
name: o.name,
show: !1
}), this.$.newButton.setShowing(o.canAddNew && !o.newActions), this.$.newMenuButton.setShowing(o.canAddNew && o.newActions), o.canAddNew && a && (f = a.prototype.model, l = f.prototype.couldCreate ? !f.prototype.couldCreate() : !f.canCreate()), this.$.newButton.setDisabled(l), this.$.panelMenu.isSelected(e) || this.$.panelMenu.select(e), t.setIndex(this.$.contentPanels.indexOfChild(o)), this.$.rightLabel.setContent(u), o.getFilterDescription && this.setHeaderContent(o.getFilterDescription()), o.fetch && !this.fetched[r] && (this.fetch(), this.fetched[r] = !0), this.buildMenus(), this.$.contentToolbar.resized(), s.destroyClientControls(), o.headerComponents && (s.createComponents(o.headerComponents), s.render()), enyo.Panels.isScreenNarrow() && r && this.next();
},
setHeaderContent: function(e) {
this.$.header.setShowing(!!e), this.$.header.setContent(e);
},
setMenuPanel: function(e) {
var t = e ? "_back".loc() : "_logout".loc();
this.$.menuPanels.setIndex(e), this.$.menuPanels.getActive().select(0), this.setContentPanel(0), this.buildMenus(), this.$.backButton.setContent(t), this.$.backPanelButton.setContent(t), this.$.backPanelButton.setShowing(enyo.Panels.isScreenNarrow()), this.$.refreshButton.setShowing(e), this.$.search.setShowing(e), this.$.contentToolbar.resized();
},
setMessageContent: function(e, t) {
var n = t.message;
this.$.messageHeader.setContent(n);
},
setModule: function(e) {
var n = this.getModules()[e], r = n.panels || [], i = n.hasSubmenu !== !1 && r.length;
if (n !== this._selectedModule || enyo.Panels.isScreenNarrow()) this._selectedModule = n, i ? (this.$.panelMenu.setCount(r.length), this.$.panelMenu.render(), this.setMenuPanel(t)) : this.setContentPanel(0);
},
setModules: function(e) {
this.modules = e, this.modulesChanged();
},
setupModuleMenuItem: functi