--
-- PostgreSQL database dump
--

-- Dumped from database version 9.1.12
-- Dumped by pg_dump version 9.1.12
-- Started on 2014-03-27 12:35:03 EDT

SET statement_timeout = 0;
SET client_encoding = 'SQL_ASCII';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

SET search_path = fixcountry, pg_catalog;

--
-- TOC entry 9004 (class 0 OID 146609309)
-- Dependencies: 399 9464
-- Data for Name: pkgcmd; Type: TABLE DATA; Schema: fixcountry; Owner: admin
--

SET SESSION AUTHORIZATION DEFAULT;

ALTER TABLE pkgcmd DISABLE TRIGGER ALL;



ALTER TABLE pkgcmd ENABLE TRIGGER ALL;

--
-- TOC entry 9007 (class 0 OID 146609325)
-- Dependencies: 402 9004 9464
-- Data for Name: pkgcmdarg; Type: TABLE DATA; Schema: fixcountry; Owner: admin
--

ALTER TABLE pkgcmdarg DISABLE TRIGGER ALL;



ALTER TABLE pkgcmdarg ENABLE TRIGGER ALL;

--
-- TOC entry 9009 (class 0 OID 146609334)
-- Dependencies: 404 9464
-- Data for Name: pkgimage; Type: TABLE DATA; Schema: fixcountry; Owner: admin
--

ALTER TABLE pkgimage DISABLE TRIGGER ALL;



ALTER TABLE pkgimage ENABLE TRIGGER ALL;

--
-- TOC entry 9012 (class 0 OID 146609351)
-- Dependencies: 407 9464
-- Data for Name: pkgmetasql; Type: TABLE DATA; Schema: fixcountry; Owner: admin
--

ALTER TABLE pkgmetasql DISABLE TRIGGER ALL;

INSERT INTO pkgmetasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (449, 'fixcountry', 'strictcountrycheck', 'select details about countries used throughout the database that do not match country.country_name a copy of crm_strictcountrycheck to avoid problems later if someone disables or removes the fixCountry package', '-- Group: fixcountry
-- Name:  strictcountrycheck
-- Notes: select details about countries used throughout the database
--        that do not match country.country_name
--        a copy of crm_strictcountrycheck to avoid problems later if
--        someone disables or removes the fixCountry package
<? if exists("count") ?>
SELECT SUM(counter) AS counter FROM (
<? endif ?>
  SELECT <? if exists("count") ?> COUNT(*) AS counter
         <? else ?> addr_id, ''Address'' AS type, addr_number AS number, addr_country AS country, '''' AS detail
         <? endif ?>
    FROM addr
   WHERE addr_country != ''''
     AND addr_country NOT IN (SELECT country_name
                                FROM country
                               WHERE country_name IS NOT NULL)
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> cmhead_id, ''Credit Memo'', cmhead_number, cmhead_billtocountry, ''Bill-To''
         <? endif ?>
    FROM cmhead
   WHERE cmhead_billtocountry != ''''
     AND cmhead_billtocountry NOT IN (SELECT country_name
                                        FROM country
                                       WHERE country_name IS NOT NULL)
     <? if not exists("showAll") ?> AND (NOT cmhead_posted) <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> cmhead_id, ''Credit Memo'', cmhead_number, cmhead_billtocountry, ''Ship-To''
         <? endif ?>
    FROM cmhead
    WHERE cmhead_shipto_country != ''''
      AND cmhead_shipto_country NOT IN (SELECT country_name
                                          FROM country
                                         WHERE country_name IS NOT NULL)
      <? if not exists("showAll") ?> AND (NOT cmhead_posted) <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> invchead_id, ''Invoice'', invchead_invcnumber, invchead_billto_country, ''Bill-To''
         <? endif ?>
    FROM invchead
   WHERE invchead_billto_country != ''''
     AND invchead_billto_country NOT IN (SELECT country_name
                                           FROM country
                                          WHERE country_name IS NOT NULL)
     <? if not exists("showAll") ?> AND (NOT invchead_posted) <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> invchead_id, ''Invoice'', invchead_invcnumber, invchead_shipto_country, ''Ship-To''
         <? endif ?>
    FROM invchead
   WHERE invchead_shipto_country != ''''
     AND invchead_shipto_country NOT IN (SELECT country_name
                                           FROM country
                                          WHERE country_name IS NOT NULL)
     <? if not exists("showAll") ?> AND (NOT invchead_posted) <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> quhead_id, ''Quote'', CAST(quhead_number AS TEXT), quhead_billtocountry, ''Bill-To''
         <? endif ?>
    FROM quhead
   WHERE quhead_billtocountry != ''''
     AND quhead_billtocountry NOT IN (SELECT country_name
                                        FROM country
                                       WHERE country_name IS NOT NULL)
     <? if not exists("showAll") ?> AND (quhead_expire>=CURRENT_DATE) <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> quhead_id, ''Quote'', CAST(quhead_number AS TEXT), quhead_shiptocountry, ''Ship-To''
         <? endif ?>
    FROM quhead
   WHERE quhead_shiptocountry != ''''
     AND quhead_shiptocountry NOT IN (SELECT country_name
                                        FROM country
                                       WHERE country_name IS NOT NULL)
     <? if not exists("showAll") ?> AND (quhead_expire>=CURRENT_DATE) <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> cohead_id, ''Sales Order'', cohead_number, cohead_billtocountry, ''Bill-To''
         <? endif ?>
    FROM cohead
   WHERE cohead_billtocountry != ''''
     AND cohead_billtocountry NOT IN (SELECT country_name
                                        FROM country
                                       WHERE country_name IS NOT NULL)
    <? if not exists("showAll") ?>
     AND cohead_id IN (SELECT coitem_cohead_id
                         FROM coitem
                        WHERE COALESCE(coitem_status, ''O'')=''O'')
    <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> cohead_id, ''Sales Order'', cohead_number, cohead_shiptocountry, ''Ship-To''
         <? endif ?>
    FROM cohead
   WHERE cohead_shiptocountry != ''''
     AND cohead_shiptocountry NOT IN (SELECT country_name
                                       FROM country
                                      WHERE country_name IS NOT NULL)
    <? if not exists("showAll") ?>
     AND cohead_id IN (SELECT coitem_cohead_id
                         FROM coitem
                        WHERE COALESCE(coitem_status, ''O'')=''O'')
    <? endif ?>

<? if exists("count") ?>
) AS dummy;
<? endif ?>
', NULL, NULL, 0);


ALTER TABLE pkgmetasql ENABLE TRIGGER ALL;

--
-- TOC entry 9015 (class 0 OID 146609368)
-- Dependencies: 410 9464
-- Data for Name: pkgpriv; Type: TABLE DATA; Schema: fixcountry; Owner: admin
--

ALTER TABLE pkgpriv DISABLE TRIGGER ALL;



ALTER TABLE pkgpriv ENABLE TRIGGER ALL;

--
-- TOC entry 9018 (class 0 OID 146609384)
-- Dependencies: 413 9464
-- Data for Name: pkgreport; Type: TABLE DATA; Schema: fixcountry; Owner: admin
--

ALTER TABLE pkgreport DISABLE TRIGGER ALL;



ALTER TABLE pkgreport ENABLE TRIGGER ALL;

--
-- TOC entry 9021 (class 0 OID 146609401)
-- Dependencies: 416 9464
-- Data for Name: pkgscript; Type: TABLE DATA; Schema: fixcountry; Owner: admin
--

ALTER TABLE pkgscript DISABLE TRIGGER ALL;

INSERT INTO pkgscript (script_id, script_name, script_order, script_enabled, script_source, script_notes) VALUES (124, 'initMenu', 0, true, 'function sFixCountries()
{
  try {
  var newdlg = toolbox.openWindow("fixCountries", 0, Qt.Window, Qt.NonModal);
  } catch(e) { print("sFixCountries exception: " + e); }
}

var _crmutilsmenu = mainwindow.findChild("menu.crm.utilities");
var fixCountriesAction = _crmutilsmenu.addAction(
                  qsTr("Fix Countries before setting Strict Countries option"));
fixCountriesAction.enabled = privileges.value("MaintainAddresses")   &&
                             privileges.value("MaintainCreditMemos") &&
                             privileges.value("MaintainMiscInvoices")&&
                             privileges.value("MaintainSalesOrders") &&
                             privileges.value("MaintainQuotes");

fixCountriesAction.triggered.connect(sFixCountries);
', '');
INSERT INTO pkgscript (script_id, script_name, script_order, script_enabled, script_source, script_notes) VALUES (125, 'fixCountries', 0, true, 'var _addCountry = mywindow.findChild("_addCountry");
var _edit       = mywindow.findChild("_edit");
var _fixAbbr    = mywindow.findChild("_fixAbbr");
var _fixBulk    = mywindow.findChild("_fixBulk");
var _fixCase    = mywindow.findChild("_fixCase");
var _list       = mywindow.findChild("_list");
var _query      = mywindow.findChild("_query");
var _showAll    = mywindow.findChild("_showAll");

_list.addColumn("Record Type", -1, Qt.AlignLeft, true, "type");
_list.addColumn("Number",      -1, Qt.AlignLeft, true, "number");
_list.addColumn("Country",     -1, Qt.AlignLeft, true, "country");
_list.addColumn("Details",     -1, Qt.AlignLeft, true, "detail");

function sAddCountry()
{
  try {
  var params = new Object;;
  params.mode = "new";

  var newdlg = toolbox.openWindow("country", mywindow, Qt.Dialog, Qt.WindowModal);
  toolbox.lastWindow().set(params);
  newdlg.exec();
  } catch (e) { print("sAddCountry exception: " + e); }
}

function openEditorWindow(pwindow, pidname, pparent)
{
  try {
  var params = new Object;
  params[pidname] = _list.id();
  if (pidname == ''quhead_id'')
    params.mode = "editQuote";
  else
    params.mode = "edit";

  var newdlg = toolbox.openWindow(pwindow, pparent, Qt.Dialog, Qt.WindowModal);
  toolbox.lastWindow().set(params);
  newdlg.exec();
  } catch(e) { print("openEditorWindow exception (" + e.lineNumber + "): " + e); }
}

function sEdit()
{
  try {
  var currentItem = _list.currentItem();

  switch (currentItem.text(0))
  {
    case ''Address'':
      openEditorWindow("address", "addr_id", mywindow);
      break;

    case ''Credit Memo'':
      openEditorWindow("creditMemo", "cmhead_id", 0);
      break;

    case ''Invoice'':
      openEditorWindow("invoice", "invchead_id", mywindow);
      break;

    case ''Quote'':
      openEditorWindow("salesOrder", "quhead_id", 0);
      break;

    case ''Sales Order'':
      openEditorWindow("salesOrder", "sohead_id", 0);
      break;
  }
  sFillList();
  } catch (e) { print("sEdit() exception: " + e); }
}

function sFixBulk()
{
  print("sFixBulk() entered");
  try {
    var params = new Object;
    if (_showAll.checked)
      params.showAll = true;

    var newdlg = toolbox.openWindow("bulkFixCountry", mywindow,
                                    Qt.WindowModal, Qt.Dialog);
    toolbox.lastWindow().set(params);

    sFillList();
  } catch (e) { print("sFixBulk() exception: " + e); }
}

function sFixCase()
{
  try {
  if (QMessageBox.question(mywindow, qsTr("Are you sure?"),
                           qsTr("<p>Are you sure that you want to change all "
                              + "countries that appear to be correct except "
                              + "for upper- and lower-case differences in a "
                              + "batch?<p>(This change will obey the status "
                              + "of the ''Show closed records'' check box."),
                           QMessageBox.Yes, QMessageBox.No) == QMessageBox.No)
    return;

  var params = new Object;
  if (_showAll.checked)
    params.showAll = true;

  var qry = toolbox.executeQuery(
      "UPDATE addr SET addr_country = country_name"
    + "  FROM country "
    + " WHERE addr_country != ''''"
    + "   AND UPPER(addr_country) = UPPER(country_name)"
    + "   AND addr_country != country_name;", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Address: " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE cmhead SET cmhead_billtocountry = country_name"
    + "  FROM country "
    + " WHERE cmhead_billtocountry != ''''"
    + "   AND UPPER(cmhead_billtocountry) = UPPER(country_name)"
    + "   AND cmhead_billtocountry != country_name"
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT cmhead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Credit Memo (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE cmhead SET cmhead_shipto_country = country_name"
    + "  FROM country "
    + " WHERE cmhead_shipto_country != ''''"
    + "   AND UPPER(cmhead_shipto_country) = UPPER(country_name)"
    + "   AND cmhead_shipto_country != country_name"
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT cmhead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Credit Memo (Ship-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE invchead SET invchead_billto_country = country_name"
    + "  FROM country "
    + " WHERE invchead_billto_country != ''''"
    + "   AND UPPER(invchead_billto_country) = UPPER(country_name)"
    + "   AND invchead_billto_country != country_name"
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT invchead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Invoice (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE invchead SET invchead_shipto_country = country_name"
    + "  FROM country "
    + " WHERE invchead_shipto_country != ''''"
    + "   AND UPPER(invchead_shipto_country) = UPPER(country_name)"
    + "   AND invchead_shipto_country != country_name"
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT invchead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Invoice (Ship-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE quhead SET quhead_billtocountry = country_name"
    + "  FROM country"
    + " WHERE quhead_billtocountry != ''''"
    + "   AND UPPER(quhead_billtocountry) = UPPER(country_name)"
    + "   AND quhead_billtocountry != country_name"
    + ''  <? if not exists("showAll") ?>''
    + "   AND quhead_expire >= CURRENT_DATE"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Quote (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE quhead SET quhead_shiptocountry = country_name"
    + "  FROM country"
    + " WHERE quhead_shiptocountry != ''''"
    + "   AND UPPER(quhead_shiptocountry) = UPPER(country_name)"
    + "   AND quhead_shiptocountry != country_name"
    + ''  <? if not exists("showAll") ?>''
    + "   AND quhead_expire >= CURRENT_DATE"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Quote (Ship-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE cohead SET cohead_billtocountry = country_name"
    + ''  FROM country <? if not exists("showAll") ?>, coitem<? endif ?>''
    + " WHERE cohead_billtocountry != ''''"
    + "   AND UPPER(cohead_billtocountry) = UPPER(country_name)"
    + "   AND cohead_billtocountry != country_name"
    + ''   <? if not exists("showAll") ?>''
    + "   AND cohead_id=coitem_cohead_id AND COALESCE(coitem_status, ''O'')=''O''"
    + "   <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Sales Order (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE cohead SET cohead_shiptocountry = country_name"
    + ''  FROM country <? if not exists("showAll") ?>, coitem<? endif ?>''
    + " WHERE cohead_shiptocountry != ''''"
    + "   AND UPPER(cohead_shiptocountry) = UPPER(country_name)"
    + "   AND cohead_shiptocountry != country_name"
    + ''   <? if not exists("showAll") ?>''
    + "   AND cohead_id=coitem_cohead_id AND COALESCE(coitem_status, ''O'')=''O''"
    + "   <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Sales Order (Ship-To): " + qry.lastError().text);

  } catch (e) { QMessageBox.critical(mywindow, "sFixCase() exception", e); }

  sFillList();
}

function sFixAbbr()
{
  try {
  if (QMessageBox.question(mywindow, qsTr("Are you sure?"),
                           qsTr("<p>Are you sure that you want to replace all "
                              + "country abbreviations to the corresponding "
                              + "full country names?<p>(This change will obey "
                              + "the status of the ''Show closed records'' "
                              + "check box."),
                       QMessageBox.Yes, QMessageBox.No) == QMessageBox.No)
    return;

  var params = new Object;
  if (_showAll.checked)
    params.showAll = true;

  var qry = toolbox.executeQuery(
      "UPDATE addr SET addr_country = country_name"
    + "  FROM country "
    + " WHERE addr_country != ''''"
    + "   AND UPPER(addr_country) = UPPER(country_abbr);", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Address: " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE cmhead SET cmhead_billtocountry = country_name"
    + "  FROM country "
    + " WHERE cmhead_billtocountry != ''''"
    + "   AND UPPER(cmhead_billtocountry) = UPPER(country_abbr)"
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT cmhead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Credit Memo (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE cmhead SET cmhead_shipto_country = country_name"
    + "  FROM country "
    + " WHERE cmhead_shipto_country != ''''"
    + "   AND UPPER(cmhead_shipto_country) = UPPER(country_abbr)"
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT cmhead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Credit Memo (Ship-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE invchead SET invchead_billto_country = country_name"
    + "  FROM country "
    + " WHERE invchead_billto_country != ''''"
    + "   AND UPPER(invchead_billto_country) = UPPER(country_abbr)"
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT invchead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Invoice (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE invchead SET invchead_shipto_country = country_name"
    + "  FROM country "
    + " WHERE invchead_shipto_country != ''''"
    + "   AND UPPER(invchead_shipto_country) = UPPER(country_abbr)"
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT invchead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Invoice (Ship-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE quhead SET quhead_billtocountry = country_name"
    + "  FROM country"
    + " WHERE quhead_billtocountry != ''''"
    + "   AND UPPER(quhead_billtocountry) = UPPER(country_abbr)"
    + ''  <? if not exists("showAll") ?>''
    + "   AND quhead_expire >= CURRENT_DATE"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Quote (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE quhead SET quhead_shiptocountry = country_name"
    + "  FROM country"
    + " WHERE quhead_shiptocountry != ''''"
    + "   AND UPPER(quhead_shiptocountry) = UPPER(country_abbr)"
    + ''  <? if not exists("showAll") ?>''
    + "   AND quhead_expire >= CURRENT_DATE"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Quote (Ship-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE cohead SET cohead_billtocountry = country_name"
    + ''  FROM country <? if not exists("showAll") ?>, coitem<? endif ?>''
    + " WHERE cohead_billtocountry != ''''"
    + "   AND UPPER(cohead_billtocountry) = UPPER(country_abbr)"
    + ''   <? if not exists("showAll") ?>''
    + "   AND cohead_id=coitem_cohead_id AND COALESCE(coitem_status, ''O'')=''O''"
    + "   <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Sales Order (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      "UPDATE cohead SET cohead_shiptocountry = country_name"
    + ''  FROM country <? if not exists("showAll") ?>, coitem<? endif ?>''
    + " WHERE cohead_shiptocountry != ''''"
    + "   AND UPPER(cohead_shiptocountry) = UPPER(country_abbr)"
    + ''   <? if not exists("showAll") ?>''
    + "   AND cohead_id=coitem_cohead_id AND COALESCE(coitem_status, ''O'')=''O''"
    + "   <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Sales Order (Ship-To): " + qry.lastError().text);

  } catch (e)
  {
    QMessageBox.critical(mywindow, "sFixAbbr() exception", e);
  }
  sFillList();
}

function sFillList()
{
  try {
  var params = new Object;
  if (_showAll.checked)
    params.showAll = true;

  var qry = toolbox.executeDbQuery(''fixcountry'', ''strictcountrycheck'', params);
  _list.populate(qry);
  if (qry.lastError().type != 0)
  {
    QMessageBox.critical(mywindow, qsTr("Database Error"),
                         qry.lastError().text);
    return;
  }
  } catch (e) { print("sFillList exception: " + e); }
}

_addCountry.clicked.connect(sAddCountry);
_edit.clicked.connect(sEdit);
_fixAbbr.clicked.connect(sFixAbbr);
_fixBulk.clicked.connect(sFixBulk);
_fixCase.clicked.connect(sFixCase);
_query.clicked.connect(sFillList);
_showAll.toggled.connect(sFillList);

sFillList();

if (QMessageBox.question(mywindow, qsTr("Backed Up?"),
                         qsTr("<p>Have you backed up your database? "
                            + "You really should back up your database "
                            + "before running this utility."),
                         QMessageBox.Yes, QMessageBox.No) == QMessageBox.No)
  mywindow.close()

', '');
INSERT INTO pkgscript (script_id, script_name, script_order, script_enabled, script_source, script_notes) VALUES (126, 'bulkFixCountry', 0, true, 'var _buttons    = mywindow.findChild("_buttons");
var _oldCountry = mywindow.findChild("_oldCountry");
var _newCountry = mywindow.findChild("_newCountry");
var _params;

function set(params)
{
  _params = params;
  var qry = toolbox.executeQuery(
      "SELECT MIN(id), country, country AS code "
    + "  FROM ("
    + "  SELECT addr_id AS id, addr_country AS country"
    + "    FROM addr"
    + "   WHERE addr_country != ''''"
    + "     AND addr_country NOT IN (SELECT country_name"
    + "                                FROM country"
    + "                               WHERE country_name IS NOT NULL)"
    + "  UNION ALL"
    + "  SELECT cmhead_id, cmhead_billtocountry"
    + "    FROM cmhead"
    + "   WHERE cmhead_billtocountry != ''''"
    + "     AND cmhead_billtocountry NOT IN (SELECT country_name"
    + "                                        FROM country"
    + "                                       WHERE country_name IS NOT NULL)"
    + ''     <? if not exists("showAll") ?> AND (NOT cmhead_posted) <? endif ?>''
    + "  UNION ALL"
    + "  SELECT cmhead_id, cmhead_shipto_country"
    + "    FROM cmhead"
    + "    WHERE cmhead_shipto_country != ''''"
    + "      AND cmhead_shipto_country NOT IN (SELECT country_name"
    + "                                          FROM country"
    + "                                         WHERE country_name IS NOT NULL)"
    + ''      <? if not exists("showAll") ?> AND (NOT cmhead_posted) <? endif ?>''
    + "  UNION ALL"
    + "  SELECT invchead_id, invchead_billto_country"
    + "    FROM invchead"
    + "   WHERE invchead_billto_country != ''''"
    + "     AND invchead_billto_country NOT IN (SELECT country_name"
    + "                                           FROM country"
    + "                                          WHERE country_name IS NOT NULL)"
    + ''     <? if not exists("showAll") ?> AND (NOT invchead_posted) <? endif ?>''
    + "  UNION ALL"
    + "  SELECT invchead_id, invchead_shipto_country"
    + "    FROM invchead"
    + "   WHERE invchead_shipto_country != ''''"
    + "     AND invchead_shipto_country NOT IN (SELECT country_name"
    + "                                           FROM country"
    + "                                          WHERE country_name IS NOT NULL)"
    + ''     <? if not exists("showAll") ?> AND (NOT invchead_posted) <? endif ?>''
    + "  UNION ALL"
    + "  SELECT quhead_id, quhead_billtocountry"
    + "    FROM quhead"
    + "   WHERE quhead_billtocountry != ''''"
    + "     AND quhead_billtocountry NOT IN (SELECT country_name"
    + "                                        FROM country"
    + "                                       WHERE country_name IS NOT NULL)"
    + ''     <? if not exists("showAll") ?> AND (quhead_expire>=CURRENT_DATE) <? endif ?>''
    + "  UNION ALL"
    + "  SELECT quhead_id, quhead_shiptocountry"
    + "    FROM quhead"
    + "   WHERE quhead_shiptocountry != ''''"
    + "     AND quhead_shiptocountry NOT IN (SELECT country_name"
    + "                                        FROM country"
    + "                                       WHERE country_name IS NOT NULL)"
    + ''     <? if not exists("showAll") ?> AND (quhead_expire>=CURRENT_DATE) <? endif ?>''
    + "  UNION ALL"
    + "  SELECT cohead_id, cohead_billtocountry"
    + "    FROM cohead"
    + "   WHERE cohead_billtocountry != ''''"
    + "     AND cohead_billtocountry NOT IN (SELECT country_name"
    + "                                        FROM country"
    + "                                       WHERE country_name IS NOT NULL)"
    + ''    <? if not exists("showAll") ?>''
    + "     AND cohead_id IN (SELECT coitem_cohead_id"
    + "                         FROM coitem"
    + "                        WHERE COALESCE(coitem_status, ''O'')=''O'')"
    + ''    <? endif ?>''
    + "  UNION ALL"
    + "  SELECT cohead_id, cohead_shiptocountry"
    + "    FROM cohead"
    + "   WHERE cohead_shiptocountry != ''''"
    + "     AND cohead_shiptocountry NOT IN (SELECT country_name"
    + "                                       FROM country"
    + "                                      WHERE country_name IS NOT NULL)"
    + ''    <? if not exists("showAll") ?>''
    + "     AND cohead_id IN (SELECT coitem_cohead_id"
    + "                         FROM coitem"
    + "                        WHERE COALESCE(coitem_status, ''O'')=''O'')"
    + ''    <? endif ?>''
    + ") AS dummy "
    + "GROUP BY country "
    + "ORDER BY country;",

                                 params);
  _oldCountry.populate(qry);
  if (qry.lastError().type != 0)
    toolbox.messageBox("warning", mywindow, qsTr("Database Error"),
                       qry.lastError().text);
}

function sSave()
{
  try {
  var params = _params;
  params.oldCountry = _oldCountry.currentText;
  params.newCountry = _newCountry.currentText;

  var qry = toolbox.executeQuery(
      ''UPDATE addr SET addr_country = <? value("newCountry") ?>''
    + '' WHERE addr_country = <? value("oldCountry") ?>;'', params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Address: " + qry.lastError().text);

  qry = toolbox.executeQuery(
      ''UPDATE cmhead SET cmhead_billtocountry = <? value("newCountry") ?>''
    + '' WHERE cmhead_billtocountry = <? value("oldCountry") ?>''
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT cmhead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Credit Memo (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      ''UPDATE cmhead SET cmhead_shipto_country = <? value("newCountry") ?>''
    + '' WHERE cmhead_shipto_country = <? value("oldCountry") ?>''
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT cmhead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Credit Memo (Ship-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      ''UPDATE invchead SET invchead_billto_country = <? value("newCountry") ?>''
    + '' WHERE invchead_billto_country = <? value("oldCountry") ?>''
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT invchead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Invoice (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      ''UPDATE invchead SET invchead_shipto_country = <? value("newCountry") ?>''
    + '' WHERE invchead_shipto_country = <? value("oldCountry") ?>''
    + ''  <? if not exists("showAll") ?>''
    + "   AND NOT invchead_posted"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Invoice (Ship-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      ''UPDATE quhead SET quhead_billtocountry = <? value("newCountry") ?>''
    + '' WHERE quhead_billtocountry = <? value("oldCountry") ?>''
    + ''  <? if not exists("showAll") ?>''
    + "   AND quhead_expire >= CURRENT_DATE"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Quote (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      ''UPDATE quhead SET quhead_shiptocountry = <? value("newCountry") ?>''
    + '' WHERE quhead_shiptocountry = <? value("oldCountry") ?>''
    + ''  <? if not exists("showAll") ?>''
    + "   AND quhead_expire >= CURRENT_DATE"
    + "  <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Quote (Ship-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      ''UPDATE cohead SET cohead_billtocountry = <? value("newCountry") ?>''
    + '' WHERE cohead_billtocountry = <? value("oldCountry") ?>''
    + ''   <? if not exists("showAll") ?>''
    + "   AND cohead_id IN (SELECT coitem_cohead_id"
    + "                     FROM coitem"
    + "                     WHERE COALESCE(coitem_status, ''O'')=''O'')"
    + "   <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Sales Order (Bill-To): " + qry.lastError().text);

  qry = toolbox.executeQuery(
      ''UPDATE cohead SET cohead_shiptocountry = <? value("newCountry") ?>''
    + '' WHERE cohead_shiptocountry = <? value("oldCountry") ?>''
    + ''   <? if not exists("showAll") ?>''
    + "   AND cohead_id IN (SELECT coitem_cohead_id"
    + "                     FROM coitem"
    + "                     WHERE COALESCE(coitem_status, ''O'')=''O'')"
    + "   <? endif ?>", params);
  if (qry.lastError().type != 0)
    throw new Error("Error updating Sales Order (Ship-To): " + qry.lastError().text);

  }
  catch (e)
  {
     toolbox.messageBox("critical", mywindow,
                        "bulkFixCountry::sSave() exception", e);

  }
  mywindow.close();
}

_buttons.accepted.connect(sSave);
_buttons.rejected.connect(mywindow, "close()");
', '');


ALTER TABLE pkgscript ENABLE TRIGGER ALL;

--
-- TOC entry 9024 (class 0 OID 146609419)
-- Dependencies: 419 9464
-- Data for Name: pkguiform; Type: TABLE DATA; Schema: fixcountry; Owner: admin
--

ALTER TABLE pkguiform DISABLE TRIGGER ALL;

INSERT INTO pkguiform (uiform_id, uiform_name, uiform_order, uiform_enabled, uiform_source, uiform_notes) VALUES (58, 'fixCountries', 0, true, '<?xml version="1.0" encoding="UTF-8"?>
<ui version="4.0">
 <class>fixCountries</class>
 <widget class="QWidget" name="fixCountries">
  <property name="geometry">
   <rect>
    <x>0</x>
    <y>0</y>
    <width>800</width>
    <height>600</height>
   </rect>
  </property>
  <property name="maximumSize">
   <size>
    <width>1000</width>
    <height>16777215</height>
   </size>
  </property>
  <property name="windowTitle">
   <string>fixCountries</string>
  </property>
  <layout class="QGridLayout" name="gridLayout">
   <item row="1" column="1">
    <layout class="QVBoxLayout" name="verticalLayout">
     <item>
      <widget class="QPushButton" name="_query">
       <property name="text">
        <string>Query</string>
       </property>
      </widget>
     </item>
     <item>
      <spacer name="verticalSpacer">
       <property name="orientation">
        <enum>Qt::Vertical</enum>
       </property>
       <property name="sizeType">
        <enum>QSizePolicy::Fixed</enum>
       </property>
       <property name="sizeHint" stdset="0">
        <size>
         <width>20</width>
         <height>15</height>
        </size>
       </property>
      </spacer>
     </item>
     <item>
      <widget class="QPushButton" name="_fixCase">
       <property name="text">
        <string>Fix Case Differences</string>
       </property>
      </widget>
     </item>
     <item>
      <widget class="QPushButton" name="_fixAbbr">
       <property name="text">
        <string>Replace Abbreviations</string>
       </property>
      </widget>
     </item>
     <item>
      <widget class="QPushButton" name="_fixBulk">
       <property name="text">
        <string>Bulk Replace</string>
       </property>
      </widget>
     </item>
     <item>
      <spacer name="verticalSpacer_3">
       <property name="orientation">
        <enum>Qt::Vertical</enum>
       </property>
       <property name="sizeType">
        <enum>QSizePolicy::Fixed</enum>
       </property>
       <property name="sizeHint" stdset="0">
        <size>
         <width>20</width>
         <height>15</height>
        </size>
       </property>
      </spacer>
     </item>
     <item>
      <widget class="QPushButton" name="_edit">
       <property name="enabled">
        <bool>false</bool>
       </property>
       <property name="text">
        <string>Edit Selection</string>
       </property>
      </widget>
     </item>
     <item>
      <widget class="QPushButton" name="_addCountry">
       <property name="text">
        <string>Add Country</string>
       </property>
      </widget>
     </item>
     <item>
      <spacer name="verticalSpacer_2">
       <property name="orientation">
        <enum>Qt::Vertical</enum>
       </property>
       <property name="sizeHint" stdset="0">
        <size>
         <width>20</width>
         <height>40</height>
        </size>
       </property>
      </spacer>
     </item>
    </layout>
   </item>
   <item row="1" column="0">
    <widget class="XTreeWidget" name="_list">
     <property name="sizePolicy">
      <sizepolicy hsizetype="Expanding" vsizetype="Expanding">
       <horstretch>0</horstretch>
       <verstretch>3</verstretch>
      </sizepolicy>
     </property>
    </widget>
   </item>
   <item row="2" column="0">
    <widget class="XCheckBox" name="_showAll">
     <property name="text">
      <string>Show closed records</string>
     </property>
     <property name="forgetful">
      <bool>true</bool>
     </property>
    </widget>
   </item>
   <item row="0" column="0" colspan="2">
    <widget class="QLabel" name="label">
     <property name="text">
      <string>&lt;!DOCTYPE HTML PUBLIC &quot;-//W3C//DTD HTML 4.0//EN&quot; &quot;http://www.w3.org/TR/REC-html40/strict.dtd&quot;&gt;
&lt;html&gt;&lt;head&gt;&lt;meta name=&quot;qrichtext&quot; content=&quot;1&quot; /&gt;&lt;style type=&quot;text/css&quot;&gt;
p, li { white-space: pre-wrap; }
&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot; font-family:''Lucida Grande''; font-size:13pt; font-weight:400; font-style:normal;&quot;&gt;
&lt;p style=&quot; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;You must fix the countries in the following records before turning on Strict Country Checking (System &amp;gt; Configure Modules &amp;gt; CRM...).&lt;/p&gt;
&lt;p style=&quot;-qt-paragraph-type:empty; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;&lt;/p&gt;
&lt;p style=&quot; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;Here is a short description of your options (assume the &lt;span style=&quot; font-style:italic;&quot;&gt;country&lt;/span&gt; table has a country named ''Homeland'' with the abbreviation ''HL''):&lt;/p&gt;
&lt;ul style=&quot;-qt-list-indent: 1;&quot;&gt;&lt;li style=&quot; margin-top:12px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;&lt;span style=&quot; font-weight:600;&quot;&gt;Query&lt;/span&gt; will requery the database for records with invalid countries.&lt;/li&gt;
&lt;li style=&quot; font-weight:600;&quot; style=&quot; margin-top:1px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;Fix Case Differences&lt;span style=&quot; font-weight:400;&quot;&gt; will change all occurrences of ''HOMELAND'' or ''HomeLand'' to ''Homeland''.&lt;/span&gt;&lt;/li&gt;
&lt;li style=&quot; margin-top:1px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;&lt;span style=&quot; font-weight:600;&quot;&gt;Replace Abbreviations&lt;/span&gt; will change all occurrences of ''HL'' to ''Homeland''.&lt;/li&gt;
&lt;li style=&quot; margin-top:1px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;&lt;span style=&quot; font-weight:600;&quot;&gt;Bulk Replace&lt;/span&gt; will replace all occurrences of an invalid country that you choose with a valid country that you choose.&lt;/li&gt;
&lt;li style=&quot; margin-top:1px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;&lt;span style=&quot; font-weight:600;&quot;&gt;Edit Selection&lt;/span&gt; will open the selected record for you to fix. If a changed address remains on the list, delete duplicates with CRM &amp;gt; Address &amp;gt; List....&lt;/li&gt;
&lt;li style=&quot; margin-top:1px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;&lt;span style=&quot; font-weight:600;&quot;&gt;Add Country&lt;/span&gt; is for the rare case where you must add a new country. Try not to use this.&lt;/li&gt;
&lt;li style=&quot; margin-top:1px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;&lt;span style=&quot; font-weight:600;&quot;&gt;Show closed records&lt;/span&gt; will show historical data, such as closed sales orders and posted credit memos &amp;amp; invoices. These will continue to print properly if you don''t fix them, but you will have to change the country if you edit and save them with Strict Country Checking turned on.&lt;/li&gt;&lt;/ul&gt;&lt;/body&gt;&lt;/html&gt;</string>
     </property>
     <property name="textFormat">
      <enum>Qt::RichText</enum>
     </property>
     <property name="wordWrap">
      <bool>true</bool>
     </property>
    </widget>
   </item>
  </layout>
 </widget>
 <customwidgets>
  <customwidget>
   <class>XCheckBox</class>
   <extends>QCheckBox</extends>
   <header>xcheckbox.h</header>
  </customwidget>
  <customwidget>
   <class>XTreeWidget</class>
   <extends>QTreeWidget</extends>
   <header>xtreewidget.h</header>
  </customwidget>
 </customwidgets>
 <tabstops>
  <tabstop>_list</tabstop>
  <tabstop>_showAll</tabstop>
  <tabstop>_query</tabstop>
  <tabstop>_fixCase</tabstop>
  <tabstop>_fixAbbr</tabstop>
  <tabstop>_edit</tabstop>
  <tabstop>_addCountry</tabstop>
 </tabstops>
 <resources/>
 <connections>
  <connection>
   <sender>_list</sender>
   <signal>valid(bool)</signal>
   <receiver>_edit</receiver>
   <slot>setEnabled(bool)</slot>
   <hints>
    <hint type="sourcelabel">
     <x>551</x>
     <y>512</y>
    </hint>
    <hint type="destinationlabel">
     <x>616</x>
     <y>503</y>
    </hint>
   </hints>
  </connection>
 </connections>
</ui>
', '');
INSERT INTO pkguiform (uiform_id, uiform_name, uiform_order, uiform_enabled, uiform_source, uiform_notes) VALUES (59, 'bulkFixCountry', 0, true, '<?xml version="1.0" encoding="UTF-8"?>
<ui version="4.0">
 <class>bulkFixCountry</class>
 <widget class="QWidget" name="bulkFixCountry">
  <property name="geometry">
   <rect>
    <x>0</x>
    <y>0</y>
    <width>427</width>
    <height>162</height>
   </rect>
  </property>
  <property name="windowTitle">
   <string>Bulk Fix Invalid Country</string>
  </property>
  <layout class="QHBoxLayout" name="horizontalLayout">
   <item>
    <layout class="QFormLayout" name="formLayout">
     <item row="0" column="0">
      <widget class="QLabel" name="_oldCountryLit">
       <property name="text">
        <string>Replace all instances of this:</string>
       </property>
       <property name="buddy">
        <cstring>_oldCountry</cstring>
       </property>
      </widget>
     </item>
     <item row="1" column="0">
      <widget class="QLabel" name="_newCountryLit">
       <property name="text">
        <string>with this country:</string>
       </property>
       <property name="buddy">
        <cstring>_newCountry</cstring>
       </property>
      </widget>
     </item>
     <item row="1" column="1">
      <widget class="XComboBox" name="_newCountry">
       <property name="allowNull">
        <bool>true</bool>
       </property>
       <property name="type">
        <enum>XComboBox::Countries</enum>
       </property>
      </widget>
     </item>
     <item row="0" column="1">
      <widget class="XComboBox" name="_oldCountry"/>
     </item>
    </layout>
   </item>
   <item>
    <widget class="QDialogButtonBox" name="_buttons">
     <property name="orientation">
      <enum>Qt::Vertical</enum>
     </property>
     <property name="standardButtons">
      <set>QDialogButtonBox::Cancel|QDialogButtonBox::SaveAll</set>
     </property>
     <property name="centerButtons">
      <bool>false</bool>
     </property>
    </widget>
   </item>
  </layout>
 </widget>
 <customwidgets>
  <customwidget>
   <class>XComboBox</class>
   <extends>QComboBox</extends>
   <header>xcombobox.h</header>
  </customwidget>
 </customwidgets>
 <resources/>
 <connections/>
</ui>
', '');


ALTER TABLE pkguiform ENABLE TRIGGER ALL;

SET search_path = public, pg_catalog;

--
-- TOC entry 9025 (class 0 OID 146609427)
-- Dependencies: 420 9464
-- Data for Name: acalitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE acalitem DISABLE TRIGGER ALL;



ALTER TABLE acalitem ENABLE TRIGGER ALL;

--
-- TOC entry 8909 (class 0 OID 146607501)
-- Dependencies: 208 9464
-- Data for Name: curr_symbol; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE curr_symbol DISABLE TRIGGER ALL;

INSERT INTO curr_symbol (curr_id, curr_base, curr_name, curr_symbol, curr_abbr) VALUES (2, false, 'US Dollars', '$', 'USD');


ALTER TABLE curr_symbol ENABLE TRIGGER ALL;

--
-- TOC entry 8943 (class 0 OID 146608482)
-- Dependencies: 262 8909 9464
-- Data for Name: accnt; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE accnt DISABLE TRIGGER ALL;



ALTER TABLE accnt ENABLE TRIGGER ALL;

--
-- TOC entry 9468 (class 0 OID 0)
-- Dependencies: 421
-- Name: accnt_accnt_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('accnt_accnt_id_seq', 83, true);


--
-- TOC entry 8929 (class 0 OID 146608304)
-- Dependencies: 234 9464
-- Data for Name: addr; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE addr DISABLE TRIGGER ALL;



ALTER TABLE addr ENABLE TRIGGER ALL;

--
-- TOC entry 9469 (class 0 OID 0)
-- Dependencies: 422
-- Name: addr_addr_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('addr_addr_id_seq', 1, false);


--
-- TOC entry 9028 (class 0 OID 146609443)
-- Dependencies: 424 9464
-- Data for Name: alarm; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE alarm DISABLE TRIGGER ALL;



ALTER TABLE alarm ENABLE TRIGGER ALL;

--
-- TOC entry 9470 (class 0 OID 0)
-- Dependencies: 425
-- Name: alarm_alarm_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('alarm_alarm_id_seq', 1, false);


--
-- TOC entry 9030 (class 0 OID 146609454)
-- Dependencies: 426 9464
-- Data for Name: apaccnt; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE apaccnt DISABLE TRIGGER ALL;



ALTER TABLE apaccnt ENABLE TRIGGER ALL;

--
-- TOC entry 9471 (class 0 OID 0)
-- Dependencies: 427
-- Name: apaccnt_apaccnt_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('apaccnt_apaccnt_id_seq', 19, true);


--
-- TOC entry 8946 (class 0 OID 146608506)
-- Dependencies: 266 8909 9464
-- Data for Name: bankaccnt; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE bankaccnt DISABLE TRIGGER ALL;



ALTER TABLE bankaccnt ENABLE TRIGGER ALL;

--
-- TOC entry 8988 (class 0 OID 146609065)
-- Dependencies: 358 9464
-- Data for Name: expcat; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE expcat DISABLE TRIGGER ALL;



ALTER TABLE expcat ENABLE TRIGGER ALL;

--
-- TOC entry 9034 (class 0 OID 146609471)
-- Dependencies: 430 8946 8909 8988 9464
-- Data for Name: checkhead; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE checkhead DISABLE TRIGGER ALL;



ALTER TABLE checkhead ENABLE TRIGGER ALL;

--
-- TOC entry 8905 (class 0 OID 146606856)
-- Dependencies: 204 8929 9464
-- Data for Name: cntct; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cntct DISABLE TRIGGER ALL;



ALTER TABLE cntct ENABLE TRIGGER ALL;

--
-- TOC entry 8919 (class 0 OID 146607622)
-- Dependencies: 220 9464
-- Data for Name: taxzone; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE taxzone DISABLE TRIGGER ALL;



ALTER TABLE taxzone ENABLE TRIGGER ALL;

--
-- TOC entry 9001 (class 0 OID 146609279)
-- Dependencies: 393 9464
-- Data for Name: vendtype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE vendtype DISABLE TRIGGER ALL;



ALTER TABLE vendtype ENABLE TRIGGER ALL;

--
-- TOC entry 8911 (class 0 OID 146607514)
-- Dependencies: 210 8909 8905 8905 8929 8919 9001 9464
-- Data for Name: vendinfo; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE vendinfo DISABLE TRIGGER ALL;



ALTER TABLE vendinfo ENABLE TRIGGER ALL;

--
-- TOC entry 9032 (class 0 OID 146609462)
-- Dependencies: 428 9034 8911 8909 9464
-- Data for Name: apapply; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE apapply DISABLE TRIGGER ALL;



ALTER TABLE apapply ENABLE TRIGGER ALL;

--
-- TOC entry 9472 (class 0 OID 0)
-- Dependencies: 429
-- Name: apapply_apapply_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('apapply_apapply_id_seq', 1, false);


--
-- TOC entry 9036 (class 0 OID 146609505)
-- Dependencies: 434 8909 9464
-- Data for Name: apcreditapply; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE apcreditapply DISABLE TRIGGER ALL;



ALTER TABLE apcreditapply ENABLE TRIGGER ALL;

--
-- TOC entry 9473 (class 0 OID 0)
-- Dependencies: 435
-- Name: apcreditapply_apcreditapply_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('apcreditapply_apcreditapply_id_seq', 1, false);


--
-- TOC entry 8908 (class 0 OID 146607486)
-- Dependencies: 207 8911 8909 9464
-- Data for Name: apopen; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE apopen DISABLE TRIGGER ALL;



ALTER TABLE apopen ENABLE TRIGGER ALL;

--
-- TOC entry 9474 (class 0 OID 0)
-- Dependencies: 437
-- Name: apopen_apopen_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('apopen_apopen_id_seq', 70, true);


--
-- TOC entry 8954 (class 0 OID 146608628)
-- Dependencies: 284 8943 8929 8909 9464
-- Data for Name: taxauth; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE taxauth DISABLE TRIGGER ALL;



ALTER TABLE taxauth ENABLE TRIGGER ALL;

--
-- TOC entry 9386 (class 0 OID 146611044)
-- Dependencies: 807 9464
-- Data for Name: taxclass; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE taxclass DISABLE TRIGGER ALL;

INSERT INTO taxclass (taxclass_id, taxclass_code, taxclass_descrip, taxclass_sequence) VALUES (1, '1', 'Legacy Class 1', 0);
INSERT INTO taxclass (taxclass_id, taxclass_code, taxclass_descrip, taxclass_sequence) VALUES (2, '2', 'Legacy Class 2', 0);
INSERT INTO taxclass (taxclass_id, taxclass_code, taxclass_descrip, taxclass_sequence) VALUES (3, '3', 'Legacy Class 3', 0);


ALTER TABLE taxclass ENABLE TRIGGER ALL;

--
-- TOC entry 8990 (class 0 OID 146609104)
-- Dependencies: 363 8943 8954 9386 9464
-- Data for Name: tax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE tax DISABLE TRIGGER ALL;



ALTER TABLE tax ENABLE TRIGGER ALL;

--
-- TOC entry 8901 (class 0 OID 146606492)
-- Dependencies: 199 9464
-- Data for Name: taxtype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE taxtype DISABLE TRIGGER ALL;

INSERT INTO taxtype (taxtype_id, taxtype_name, taxtype_descrip, taxtype_sys) VALUES (1, 'Freight', 'System Defined Freight Tax Type. DO NOT CHANGE.', true);
INSERT INTO taxtype (taxtype_id, taxtype_name, taxtype_descrip, taxtype_sys) VALUES (2, 'Adjustment', 'System Defined Adjustment Tax Type. DO NOT CHANGE.', true);


ALTER TABLE taxtype ENABLE TRIGGER ALL;

--
-- TOC entry 9039 (class 0 OID 146609517)
-- Dependencies: 438 8990 8908 8990 8901 9464
-- Data for Name: apopentax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE apopentax DISABLE TRIGGER ALL;



ALTER TABLE apopentax ENABLE TRIGGER ALL;

--
-- TOC entry 9040 (class 0 OID 146609523)
-- Dependencies: 439 8909 9464
-- Data for Name: apselect; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE apselect DISABLE TRIGGER ALL;



ALTER TABLE apselect ENABLE TRIGGER ALL;

--
-- TOC entry 9475 (class 0 OID 0)
-- Dependencies: 440
-- Name: apselect_apselect_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('apselect_apselect_id_seq', 501, true);


--
-- TOC entry 9042 (class 0 OID 146609530)
-- Dependencies: 441 9464
-- Data for Name: araccnt; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE araccnt DISABLE TRIGGER ALL;



ALTER TABLE araccnt ENABLE TRIGGER ALL;

--
-- TOC entry 9476 (class 0 OID 0)
-- Dependencies: 442
-- Name: araccnt_araccnt_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('araccnt_araccnt_id_seq', 37, true);


--
-- TOC entry 9044 (class 0 OID 146609539)
-- Dependencies: 443 8909 9464
-- Data for Name: arapply; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE arapply DISABLE TRIGGER ALL;



ALTER TABLE arapply ENABLE TRIGGER ALL;

--
-- TOC entry 9477 (class 0 OID 0)
-- Dependencies: 444
-- Name: arapply_arapply_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('arapply_arapply_id_seq', 1, false);


--
-- TOC entry 9047 (class 0 OID 146609550)
-- Dependencies: 446 8909 9464
-- Data for Name: arcreditapply; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE arcreditapply DISABLE TRIGGER ALL;



ALTER TABLE arcreditapply ENABLE TRIGGER ALL;

--
-- TOC entry 9478 (class 0 OID 0)
-- Dependencies: 447
-- Name: arcreditapply_arcreditapply_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('arcreditapply_arcreditapply_id_seq', 1, false);


--
-- TOC entry 8972 (class 0 OID 146608876)
-- Dependencies: 325 9464
-- Data for Name: costcat; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE costcat DISABLE TRIGGER ALL;



ALTER TABLE costcat ENABLE TRIGGER ALL;

--
-- TOC entry 8951 (class 0 OID 146608599)
-- Dependencies: 280 9464
-- Data for Name: custtype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE custtype DISABLE TRIGGER ALL;



ALTER TABLE custtype ENABLE TRIGGER ALL;

--
-- TOC entry 8956 (class 0 OID 146608667)
-- Dependencies: 291 9464
-- Data for Name: dept; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE dept DISABLE TRIGGER ALL;



ALTER TABLE dept ENABLE TRIGGER ALL;

--
-- TOC entry 8938 (class 0 OID 146608409)
-- Dependencies: 248 9464
-- Data for Name: image; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE image DISABLE TRIGGER ALL;

INSERT INTO image (image_id, image_name, image_descrip, image_data) VALUES (14, 'Blue Pinstripe Background', 'Blue Pinstripe Background', 'begin 644 internal
MB5!.1PT*&@H````-24A$4@````(````""`(```#]U)IS````"7!(67,```L2
M```+$@''2W7[\````%DE$050(F6-DLNUD8&!@\?+R8F!@```-9P&L)F@250``
*``!)14Y$KD)@@@``
`
end
');


ALTER TABLE image ENABLE TRIGGER ALL;

--
-- TOC entry 8958 (class 0 OID 146608687)
-- Dependencies: 293 9464
-- Data for Name: shift; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE shift DISABLE TRIGGER ALL;



ALTER TABLE shift ENABLE TRIGGER ALL;

--
-- TOC entry 8953 (class 0 OID 146608615)
-- Dependencies: 282 9464
-- Data for Name: shipform; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE shipform DISABLE TRIGGER ALL;



ALTER TABLE shipform ENABLE TRIGGER ALL;

--
-- TOC entry 8999 (class 0 OID 146609240)
-- Dependencies: 386 9464
-- Data for Name: shipvia; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE shipvia DISABLE TRIGGER ALL;



ALTER TABLE shipvia ENABLE TRIGGER ALL;

--
-- TOC entry 9000 (class 0 OID 146609248)
-- Dependencies: 387 9464
-- Data for Name: sitetype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE sitetype DISABLE TRIGGER ALL;

INSERT INTO sitetype (sitetype_id, sitetype_name, sitetype_descrip) VALUES (1, 'WHSE', 'Warehouse');


ALTER TABLE sitetype ENABLE TRIGGER ALL;

--
-- TOC entry 8896 (class 0 OID 146606403)
-- Dependencies: 193 8943 8929 8972 8953 8999 9000 8919 9464
-- Data for Name: whsinfo; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE whsinfo DISABLE TRIGGER ALL;



ALTER TABLE whsinfo ENABLE TRIGGER ALL;

--
-- TOC entry 8957 (class 0 OID 146608674)
-- Dependencies: 292 8905 8956 8938 8958 8909 8896 9464
-- Data for Name: emp; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE emp DISABLE TRIGGER ALL;

INSERT INTO emp (emp_id, emp_code, emp_number, emp_active, emp_cntct_id, emp_warehous_id, emp_mgr_emp_id, emp_wage_type, emp_wage, emp_wage_curr_id, emp_wage_period, emp_dept_id, emp_shift_id, emp_notes, emp_image_id, emp_username, emp_extrate, emp_extrate_period, emp_startdate, emp_name) VALUES (2, 'ADMIN', 'admin', true, NULL, NULL, NULL, 'H', NULL, NULL, 'H', NULL, NULL, NULL, NULL, 'admin', NULL, 'H', NULL, 'Administrator');
INSERT INTO emp (emp_id, emp_code, emp_number, emp_active, emp_cntct_id, emp_warehous_id, emp_mgr_emp_id, emp_wage_type, emp_wage, emp_wage_curr_id, emp_wage_period, emp_dept_id, emp_shift_id, emp_notes, emp_image_id, emp_username, emp_extrate, emp_extrate_period, emp_startdate, emp_name) VALUES (1, 'MFGADMIN', 'mfgadmin', true, NULL, NULL, NULL, 'H', NULL, NULL, 'H', NULL, NULL, NULL, NULL, 'mfgadmin', NULL, 'H', NULL, 'OpenMFG Administrator');


ALTER TABLE emp ENABLE TRIGGER ALL;

--
-- TOC entry 8916 (class 0 OID 146607588)
-- Dependencies: 216 8957 9464
-- Data for Name: salesrep; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE salesrep DISABLE TRIGGER ALL;



ALTER TABLE salesrep ENABLE TRIGGER ALL;

--
-- TOC entry 8910 (class 0 OID 146607505)
-- Dependencies: 209 9464
-- Data for Name: terms; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE terms DISABLE TRIGGER ALL;



ALTER TABLE terms ENABLE TRIGGER ALL;

--
-- TOC entry 8913 (class 0 OID 146607555)
-- Dependencies: 213 8909 8909 8905 8905 8951 8916 8953 8919 8910 9464
-- Data for Name: custinfo; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE custinfo DISABLE TRIGGER ALL;



ALTER TABLE custinfo ENABLE TRIGGER ALL;

--
-- TOC entry 8912 (class 0 OID 146607540)
-- Dependencies: 212 8913 8916 8909 9464
-- Data for Name: aropen; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE aropen DISABLE TRIGGER ALL;



ALTER TABLE aropen ENABLE TRIGGER ALL;

--
-- TOC entry 9479 (class 0 OID 0)
-- Dependencies: 449
-- Name: aropen_aropen_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('aropen_aropen_id_seq', 292, true);


--
-- TOC entry 8994 (class 0 OID 146609177)
-- Dependencies: 374 9464
-- Data for Name: aropenalloc; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE aropenalloc DISABLE TRIGGER ALL;



ALTER TABLE aropenalloc ENABLE TRIGGER ALL;

--
-- TOC entry 9050 (class 0 OID 146609566)
-- Dependencies: 450 8990 8912 8990 8901 9464
-- Data for Name: aropentax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE aropentax DISABLE TRIGGER ALL;



ALTER TABLE aropentax ENABLE TRIGGER ALL;

--
-- TOC entry 9051 (class 0 OID 146609572)
-- Dependencies: 451 8901 8919 8909 9464
-- Data for Name: asohist; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE asohist DISABLE TRIGGER ALL;



ALTER TABLE asohist ENABLE TRIGGER ALL;

--
-- TOC entry 9480 (class 0 OID 0)
-- Dependencies: 452
-- Name: asohist_asohist_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('asohist_asohist_id_seq', 1, false);


--
-- TOC entry 9053 (class 0 OID 146609581)
-- Dependencies: 453 8990 9051 8990 8901 9464
-- Data for Name: asohisttax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE asohisttax DISABLE TRIGGER ALL;



ALTER TABLE asohisttax ENABLE TRIGGER ALL;

--
-- TOC entry 9054 (class 0 OID 146609587)
-- Dependencies: 454 9464
-- Data for Name: atlasmap; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE atlasmap DISABLE TRIGGER ALL;



ALTER TABLE atlasmap ENABLE TRIGGER ALL;

--
-- TOC entry 9481 (class 0 OID 0)
-- Dependencies: 455
-- Name: atlasmap_atlasmap_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('atlasmap_atlasmap_id_seq', 1, false);


--
-- TOC entry 9056 (class 0 OID 146609597)
-- Dependencies: 456 9464
-- Data for Name: backup_usr; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE backup_usr DISABLE TRIGGER ALL;

INSERT INTO backup_usr (usr_id, usr_username, usr_propername, usr_passwd, usr_locale_id, usr_initials, usr_agent, usr_active, usr_email, usr_dept_id, usr_shift_id, usr_window) VALUES (1, 'mfgadmin', 'OpenMFG Administrator', NULL, 3, 'ADMIN', true, true, 'chris@openmfg.com', NULL, NULL, '');
INSERT INTO backup_usr (usr_id, usr_username, usr_propername, usr_passwd, usr_locale_id, usr_initials, usr_agent, usr_active, usr_email, usr_dept_id, usr_shift_id, usr_window) VALUES (2, 'admin', 'Administrator', '', 3, 'ADMIN', true, true, 'admin@xtuple.com', NULL, NULL, NULL);


ALTER TABLE backup_usr ENABLE TRIGGER ALL;

--
-- TOC entry 9482 (class 0 OID 0)
-- Dependencies: 457
-- Name: bankaccnt_bankaccnt_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('bankaccnt_bankaccnt_id_seq', 12, true);


--
-- TOC entry 9058 (class 0 OID 146609605)
-- Dependencies: 458 8909 9464
-- Data for Name: bankadj; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE bankadj DISABLE TRIGGER ALL;



ALTER TABLE bankadj ENABLE TRIGGER ALL;

--
-- TOC entry 9483 (class 0 OID 0)
-- Dependencies: 459
-- Name: bankadj_bankadj_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('bankadj_bankadj_id_seq', 1, false);


--
-- TOC entry 9060 (class 0 OID 146609617)
-- Dependencies: 460 9464
-- Data for Name: bankadjtype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE bankadjtype DISABLE TRIGGER ALL;



ALTER TABLE bankadjtype ENABLE TRIGGER ALL;

--
-- TOC entry 9484 (class 0 OID 0)
-- Dependencies: 461
-- Name: bankadjtype_bankadjtype_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('bankadjtype_bankadjtype_id_seq', 1, false);


--
-- TOC entry 9062 (class 0 OID 146609627)
-- Dependencies: 462 9464
-- Data for Name: bankrec; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE bankrec DISABLE TRIGGER ALL;



ALTER TABLE bankrec ENABLE TRIGGER ALL;

--
-- TOC entry 9485 (class 0 OID 0)
-- Dependencies: 463
-- Name: bankrec_bankrec_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('bankrec_bankrec_id_seq', 1, false);


--
-- TOC entry 9064 (class 0 OID 146609638)
-- Dependencies: 464 9464
-- Data for Name: bankrecitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE bankrecitem DISABLE TRIGGER ALL;



ALTER TABLE bankrecitem ENABLE TRIGGER ALL;

--
-- TOC entry 9486 (class 0 OID 0)
-- Dependencies: 465
-- Name: bankrecitem_bankrecitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('bankrecitem_bankrecitem_id_seq', 1, false);


--
-- TOC entry 8967 (class 0 OID 146608805)
-- Dependencies: 313 9464
-- Data for Name: classcode; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE classcode DISABLE TRIGGER ALL;



ALTER TABLE classcode ENABLE TRIGGER ALL;

--
-- TOC entry 8960 (class 0 OID 146608722)
-- Dependencies: 299 9464
-- Data for Name: freightclass; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE freightclass DISABLE TRIGGER ALL;



ALTER TABLE freightclass ENABLE TRIGGER ALL;

--
-- TOC entry 8902 (class 0 OID 146606500)
-- Dependencies: 200 9464
-- Data for Name: uom; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE uom DISABLE TRIGGER ALL;



ALTER TABLE uom ENABLE TRIGGER ALL;

--
-- TOC entry 8894 (class 0 OID 146606350)
-- Dependencies: 191 8967 8960 8902 8902 9464
-- Data for Name: item; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE item DISABLE TRIGGER ALL;



ALTER TABLE item ENABLE TRIGGER ALL;

--
-- TOC entry 8940 (class 0 OID 146608440)
-- Dependencies: 254 8894 9464
-- Data for Name: bomhead; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE bomhead DISABLE TRIGGER ALL;



ALTER TABLE bomhead ENABLE TRIGGER ALL;

--
-- TOC entry 9487 (class 0 OID 0)
-- Dependencies: 466
-- Name: bomhead_bomhead_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('bomhead_bomhead_id_seq', 54, true);


--
-- TOC entry 8930 (class 0 OID 146608325)
-- Dependencies: 236 9464
-- Data for Name: char; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE "char" DISABLE TRIGGER ALL;



ALTER TABLE "char" ENABLE TRIGGER ALL;

--
-- TOC entry 8904 (class 0 OID 146606763)
-- Dependencies: 203 8930 8894 8894 8902 9464
-- Data for Name: bomitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE bomitem DISABLE TRIGGER ALL;



ALTER TABLE bomitem ENABLE TRIGGER ALL;

--
-- TOC entry 9488 (class 0 OID 0)
-- Dependencies: 467
-- Name: bomitem_bomitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('bomitem_bomitem_id_seq', 167, true);


--
-- TOC entry 8970 (class 0 OID 146608846)
-- Dependencies: 320 9464
-- Data for Name: costelem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE costelem DISABLE TRIGGER ALL;

INSERT INTO costelem (costelem_id, costelem_type, costelem_sys, costelem_po, costelem_active, costelem_exp_accnt_id, costelem_cost_item_id) VALUES (3, 'Material', true, true, true, NULL, -1);
INSERT INTO costelem (costelem_id, costelem_type, costelem_sys, costelem_po, costelem_active, costelem_exp_accnt_id, costelem_cost_item_id) VALUES (4, 'Direct Labor', true, false, true, NULL, -1);
INSERT INTO costelem (costelem_id, costelem_type, costelem_sys, costelem_po, costelem_active, costelem_exp_accnt_id, costelem_cost_item_id) VALUES (5, 'Overhead', true, false, true, NULL, -1);
INSERT INTO costelem (costelem_id, costelem_type, costelem_sys, costelem_po, costelem_active, costelem_exp_accnt_id, costelem_cost_item_id) VALUES (6, 'Machine Overhead', true, false, true, NULL, -1);


ALTER TABLE costelem ENABLE TRIGGER ALL;

--
-- TOC entry 9068 (class 0 OID 146609651)
-- Dependencies: 468 8904 8970 8909 9464
-- Data for Name: bomitemcost; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE bomitemcost DISABLE TRIGGER ALL;



ALTER TABLE bomitemcost ENABLE TRIGGER ALL;

--
-- TOC entry 9489 (class 0 OID 0)
-- Dependencies: 469
-- Name: bomitemcost_bomitemcost_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('bomitemcost_bomitemcost_id_seq', 1, false);


--
-- TOC entry 8941 (class 0 OID 146608463)
-- Dependencies: 258 8904 8894 9464
-- Data for Name: bomitemsub; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE bomitemsub DISABLE TRIGGER ALL;



ALTER TABLE bomitemsub ENABLE TRIGGER ALL;

--
-- TOC entry 9490 (class 0 OID 0)
-- Dependencies: 470
-- Name: bomitemsub_bomitemsub_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('bomitemsub_bomitemsub_id_seq', 1, false);


--
-- TOC entry 9071 (class 0 OID 146609662)
-- Dependencies: 471 8930 9464
-- Data for Name: bomwork; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE bomwork DISABLE TRIGGER ALL;



ALTER TABLE bomwork ENABLE TRIGGER ALL;

--
-- TOC entry 9491 (class 0 OID 0)
-- Dependencies: 472
-- Name: bomwork_bomwork_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('bomwork_bomwork_id_seq', 1, false);


--
-- TOC entry 8942 (class 0 OID 146608471)
-- Dependencies: 260 9464
-- Data for Name: budghead; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE budghead DISABLE TRIGGER ALL;

INSERT INTO budghead (budghead_id, budghead_name, budghead_descrip) VALUES (1, 'Default', 'Default budget for conversion');


ALTER TABLE budghead ENABLE TRIGGER ALL;

--
-- TOC entry 9492 (class 0 OID 0)
-- Dependencies: 474
-- Name: budghead_budghead_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('budghead_budghead_id_seq', 2, true);


--
-- TOC entry 8945 (class 0 OID 146608495)
-- Dependencies: 264 9464
-- Data for Name: period; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE period DISABLE TRIGGER ALL;



ALTER TABLE period ENABLE TRIGGER ALL;

--
-- TOC entry 8944 (class 0 OID 146608492)
-- Dependencies: 263 8942 8945 9464
-- Data for Name: budgitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE budgitem DISABLE TRIGGER ALL;



ALTER TABLE budgitem ENABLE TRIGGER ALL;

--
-- TOC entry 9493 (class 0 OID 0)
-- Dependencies: 475
-- Name: budgitem_budgitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('budgitem_budgitem_id_seq', 1, true);


--
-- TOC entry 9075 (class 0 OID 146609680)
-- Dependencies: 476 9464
-- Data for Name: calhead; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE calhead DISABLE TRIGGER ALL;



ALTER TABLE calhead ENABLE TRIGGER ALL;

--
-- TOC entry 9494 (class 0 OID 0)
-- Dependencies: 477
-- Name: calhead_calhead_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('calhead_calhead_id_seq', 46, true);


--
-- TOC entry 9495 (class 0 OID 0)
-- Dependencies: 478
-- Name: carrier_carrier_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('carrier_carrier_id_seq', 15, true);


--
-- TOC entry 8947 (class 0 OID 146608518)
-- Dependencies: 267 8946 8913 8909 9464
-- Data for Name: cashrcpt; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cashrcpt DISABLE TRIGGER ALL;



ALTER TABLE cashrcpt ENABLE TRIGGER ALL;

--
-- TOC entry 9496 (class 0 OID 0)
-- Dependencies: 479
-- Name: cashrcpt_cashrcpt_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cashrcpt_cashrcpt_id_seq', 112, true);


--
-- TOC entry 8948 (class 0 OID 146608537)
-- Dependencies: 269 8912 8947 9464
-- Data for Name: cashrcptitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cashrcptitem DISABLE TRIGGER ALL;



ALTER TABLE cashrcptitem ENABLE TRIGGER ALL;

--
-- TOC entry 9497 (class 0 OID 0)
-- Dependencies: 445
-- Name: cashrcptitem_cashrcptitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cashrcptitem_cashrcptitem_id_seq', 170, true);


--
-- TOC entry 8949 (class 0 OID 146608547)
-- Dependencies: 271 8943 8947 9464
-- Data for Name: cashrcptmisc; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cashrcptmisc DISABLE TRIGGER ALL;



ALTER TABLE cashrcptmisc ENABLE TRIGGER ALL;

--
-- TOC entry 9498 (class 0 OID 0)
-- Dependencies: 480
-- Name: cashrcptmisc_cashrcptmisc_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cashrcptmisc_cashrcptmisc_id_seq', 26, true);


--
-- TOC entry 8950 (class 0 OID 146608581)
-- Dependencies: 278 8913 9464
-- Data for Name: ccard; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE ccard DISABLE TRIGGER ALL;



ALTER TABLE ccard ENABLE TRIGGER ALL;

--
-- TOC entry 9499 (class 0 OID 0)
-- Dependencies: 481
-- Name: ccard_ccard_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('ccard_ccard_id_seq', 1, false);


--
-- TOC entry 9081 (class 0 OID 146609698)
-- Dependencies: 482 9464
-- Data for Name: ccardaud; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE ccardaud DISABLE TRIGGER ALL;



ALTER TABLE ccardaud ENABLE TRIGGER ALL;

--
-- TOC entry 9500 (class 0 OID 0)
-- Dependencies: 483
-- Name: ccardaud_ccardaud_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('ccardaud_ccardaud_id_seq', 1, false);


--
-- TOC entry 9083 (class 0 OID 146609708)
-- Dependencies: 484 8946 9464
-- Data for Name: ccbank; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE ccbank DISABLE TRIGGER ALL;

INSERT INTO ccbank (ccbank_id, ccbank_ccard_type, ccbank_bankaccnt_id) VALUES (1, 'A', NULL);
INSERT INTO ccbank (ccbank_id, ccbank_ccard_type, ccbank_bankaccnt_id) VALUES (2, 'D', NULL);
INSERT INTO ccbank (ccbank_id, ccbank_ccard_type, ccbank_bankaccnt_id) VALUES (3, 'M', NULL);
INSERT INTO ccbank (ccbank_id, ccbank_ccard_type, ccbank_bankaccnt_id) VALUES (4, 'P', NULL);
INSERT INTO ccbank (ccbank_id, ccbank_ccard_type, ccbank_bankaccnt_id) VALUES (5, 'V', NULL);


ALTER TABLE ccbank ENABLE TRIGGER ALL;

--
-- TOC entry 9501 (class 0 OID 0)
-- Dependencies: 485
-- Name: ccbank_ccbank_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('ccbank_ccbank_id_seq', 5, true);


--
-- TOC entry 9085 (class 0 OID 146609717)
-- Dependencies: 486 9464
-- Data for Name: ccpay; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE ccpay DISABLE TRIGGER ALL;



ALTER TABLE ccpay ENABLE TRIGGER ALL;

--
-- TOC entry 9502 (class 0 OID 0)
-- Dependencies: 487
-- Name: ccpay_ccpay_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('ccpay_ccpay_id_seq', 1, false);


--
-- TOC entry 9503 (class 0 OID 0)
-- Dependencies: 488
-- Name: char_char_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('char_char_id_seq', 11, true);


--
-- TOC entry 8931 (class 0 OID 146608345)
-- Dependencies: 237 9464
-- Data for Name: charass; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE charass DISABLE TRIGGER ALL;



ALTER TABLE charass ENABLE TRIGGER ALL;

--
-- TOC entry 9504 (class 0 OID 0)
-- Dependencies: 489
-- Name: charass_charass_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('charass_charass_id_seq', 1, false);


--
-- TOC entry 9089 (class 0 OID 146609734)
-- Dependencies: 490 8930 9464
-- Data for Name: charopt; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE charopt DISABLE TRIGGER ALL;



ALTER TABLE charopt ENABLE TRIGGER ALL;

--
-- TOC entry 9505 (class 0 OID 0)
-- Dependencies: 491
-- Name: charopt_charopt_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('charopt_charopt_id_seq', 1, false);


--
-- TOC entry 9506 (class 0 OID 0)
-- Dependencies: 492
-- Name: checkhead_checkhead_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('checkhead_checkhead_id_seq', 1, false);


--
-- TOC entry 9035 (class 0 OID 146609491)
-- Dependencies: 432 8908 8912 9034 8909 9464
-- Data for Name: checkitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE checkitem DISABLE TRIGGER ALL;



ALTER TABLE checkitem ENABLE TRIGGER ALL;

--
-- TOC entry 9507 (class 0 OID 0)
-- Dependencies: 493
-- Name: checkitem_checkitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('checkitem_checkitem_id_seq', 1, false);


--
-- TOC entry 9508 (class 0 OID 0)
-- Dependencies: 495
-- Name: classcode_classcode_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('classcode_classcode_id_seq', 32, true);


--
-- TOC entry 9002 (class 0 OID 146609300)
-- Dependencies: 397 9464
-- Data for Name: cmd; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cmd DISABLE TRIGGER ALL;



ALTER TABLE cmd ENABLE TRIGGER ALL;

--
-- TOC entry 9509 (class 0 OID 0)
-- Dependencies: 398
-- Name: cmd_cmd_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cmd_cmd_id_seq', 6, true);


--
-- TOC entry 9005 (class 0 OID 146609316)
-- Dependencies: 400 9002 9464
-- Data for Name: cmdarg; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cmdarg DISABLE TRIGGER ALL;



ALTER TABLE cmdarg ENABLE TRIGGER ALL;

--
-- TOC entry 9510 (class 0 OID 0)
-- Dependencies: 401
-- Name: cmdarg_cmdarg_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cmdarg_cmdarg_id_seq', 6, true);


--
-- TOC entry 8987 (class 0 OID 146609049)
-- Dependencies: 356 8905 8916 8919 8896 9464
-- Data for Name: prospect; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE prospect DISABLE TRIGGER ALL;



ALTER TABLE prospect ENABLE TRIGGER ALL;

--
-- TOC entry 8906 (class 0 OID 146607021)
-- Dependencies: 205 8905 8905 8913 8957 8987 8916 8954 8911 9464
-- Data for Name: crmacct; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE crmacct DISABLE TRIGGER ALL;

INSERT INTO crmacct (crmacct_id, crmacct_number, crmacct_name, crmacct_active, crmacct_type, crmacct_cust_id, crmacct_competitor_id, crmacct_partner_id, crmacct_prospect_id, crmacct_vend_id, crmacct_cntct_id_1, crmacct_cntct_id_2, crmacct_parent_id, crmacct_notes, crmacct_taxauth_id, crmacct_owner_username, crmacct_emp_id, crmacct_salesrep_id, crmacct_usr_username) VALUES (1, 'ADMIN', 'Administrator', true, 'I', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2, NULL, 'admin');
INSERT INTO crmacct (crmacct_id, crmacct_number, crmacct_name, crmacct_active, crmacct_type, crmacct_cust_id, crmacct_competitor_id, crmacct_partner_id, crmacct_prospect_id, crmacct_vend_id, crmacct_cntct_id_1, crmacct_cntct_id_2, crmacct_parent_id, crmacct_notes, crmacct_taxauth_id, crmacct_owner_username, crmacct_emp_id, crmacct_salesrep_id, crmacct_usr_username) VALUES (2, 'MFGADMIN', 'OpenMFG Administrator', true, 'I', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, 'mfgadmin');


ALTER TABLE crmacct ENABLE TRIGGER ALL;

--
-- TOC entry 9323 (class 0 OID 146610782)
-- Dependencies: 739 9464
-- Data for Name: prjtype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE prjtype DISABLE TRIGGER ALL;

INSERT INTO prjtype (prjtype_id, prjtype_code, prjtype_descr, prjtype_active) VALUES (1, 'Standard', 'Standard Projects', true);


ALTER TABLE prjtype ENABLE TRIGGER ALL;

--
-- TOC entry 8922 (class 0 OID 146607673)
-- Dependencies: 225 8905 8906 9323 9464
-- Data for Name: prj; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE prj DISABLE TRIGGER ALL;



ALTER TABLE prj ENABLE TRIGGER ALL;

--
-- TOC entry 8923 (class 0 OID 146607681)
-- Dependencies: 226 9464
-- Data for Name: saletype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE saletype DISABLE TRIGGER ALL;

INSERT INTO saletype (saletype_id, saletype_code, saletype_descr, saletype_active) VALUES (1, 'CUST', 'Customer', true);
INSERT INTO saletype (saletype_id, saletype_code, saletype_descr, saletype_active) VALUES (2, 'INT', 'Internet', true);
INSERT INTO saletype (saletype_id, saletype_code, saletype_descr, saletype_active) VALUES (3, 'REP', 'Sales Rep', true);


ALTER TABLE saletype ENABLE TRIGGER ALL;

--
-- TOC entry 8924 (class 0 OID 146607688)
-- Dependencies: 227 9464
-- Data for Name: shipzone; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE shipzone DISABLE TRIGGER ALL;



ALTER TABLE shipzone ENABLE TRIGGER ALL;

--
-- TOC entry 8917 (class 0 OID 146607604)
-- Dependencies: 218 8913 8901 8922 8916 8923 8924 8919 8909 9464
-- Data for Name: cmhead; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cmhead DISABLE TRIGGER ALL;



ALTER TABLE cmhead ENABLE TRIGGER ALL;

--
-- TOC entry 9511 (class 0 OID 0)
-- Dependencies: 496
-- Name: cmhead_cmhead_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cmhead_cmhead_id_seq', 206, true);


--
-- TOC entry 9095 (class 0 OID 146609756)
-- Dependencies: 497 8990 8917 8990 8901 9464
-- Data for Name: cmheadtax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cmheadtax DISABLE TRIGGER ALL;



ALTER TABLE cmheadtax ENABLE TRIGGER ALL;

--
-- TOC entry 8920 (class 0 OID 146607635)
-- Dependencies: 222 8917 8902 8902 8901 9464
-- Data for Name: cmitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cmitem DISABLE TRIGGER ALL;



ALTER TABLE cmitem ENABLE TRIGGER ALL;

--
-- TOC entry 9512 (class 0 OID 0)
-- Dependencies: 498
-- Name: cmitem_cmitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cmitem_cmitem_id_seq', 83, true);


--
-- TOC entry 9097 (class 0 OID 146609764)
-- Dependencies: 499 8990 8920 8990 8901 9464
-- Data for Name: cmitemtax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cmitemtax DISABLE TRIGGER ALL;



ALTER TABLE cmitemtax ENABLE TRIGGER ALL;

--
-- TOC entry 8932 (class 0 OID 146608357)
-- Dependencies: 239 9464
-- Data for Name: cmnttype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cmnttype DISABLE TRIGGER ALL;

INSERT INTO cmnttype (cmnttype_id, cmnttype_name, cmnttype_descrip, cmnttype_usedin, cmnttype_sys, cmnttype_editable, cmnttype_order) VALUES (1, 'General', 'General Comment', 'ICVPL', true, false, NULL);
INSERT INTO cmnttype (cmnttype_id, cmnttype_name, cmnttype_descrip, cmnttype_usedin, cmnttype_sys, cmnttype_editable, cmnttype_order) VALUES (2, 'ChangeLog', 'Change Log', 'ICVP', true, false, NULL);
INSERT INTO cmnttype (cmnttype_id, cmnttype_name, cmnttype_descrip, cmnttype_usedin, cmnttype_sys, cmnttype_editable, cmnttype_order) VALUES (3, 'Notes to Comment', 'Used by certain triggers to automatically create/update comment with content of notes.', NULL, true, false, NULL);


ALTER TABLE cmnttype ENABLE TRIGGER ALL;

--
-- TOC entry 9513 (class 0 OID 0)
-- Dependencies: 500
-- Name: cmnttype_cmnttype_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cmnttype_cmnttype_id_seq', 3, true);


--
-- TOC entry 9099 (class 0 OID 146609772)
-- Dependencies: 501 9464
-- Data for Name: cmnttypesource; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cmnttypesource DISABLE TRIGGER ALL;

INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (76, 1, 1);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (77, 2, 1);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (78, 1, 2);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (79, 2, 2);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (80, 1, 3);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (81, 2, 3);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (82, 1, 4);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (83, 2, 4);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (84, 1, 5);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (85, 2, 5);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (86, 1, 6);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (87, 2, 6);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (88, 1, 7);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (89, 2, 7);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (90, 1, 8);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (91, 2, 8);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (92, 1, 9);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (93, 2, 9);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (94, 1, 10);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (95, 2, 10);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (96, 1, 11);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (97, 2, 11);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (98, 1, 12);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (99, 2, 12);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (100, 1, 13);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (101, 2, 13);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (102, 1, 14);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (103, 2, 14);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (104, 1, 15);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (105, 2, 15);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (106, 1, 16);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (107, 2, 16);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (108, 1, 17);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (109, 2, 17);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (110, 1, 18);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (111, 2, 18);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (112, 1, 19);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (113, 2, 19);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (114, 1, 20);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (115, 2, 20);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (116, 1, 21);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (117, 2, 21);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (118, 1, 22);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (119, 2, 22);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (120, 1, 23);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (121, 2, 23);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (122, 1, 24);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (123, 2, 24);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (124, 1, 25);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (125, 2, 25);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (126, 1, 26);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (127, 2, 26);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (128, 1, 27);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (129, 2, 27);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (130, 1, 28);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (131, 2, 28);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (132, 1, 29);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (133, 2, 29);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (134, 1, 30);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (135, 2, 30);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (136, 1, 31);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (137, 2, 31);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (138, 1, 32);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (139, 2, 32);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (140, 1, 33);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (141, 2, 33);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (142, 1, 34);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (143, 2, 34);
INSERT INTO cmnttypesource (cmnttypesource_id, cmnttypesource_cmnttype_id, cmnttypesource_source_id) VALUES (144, 3, 12);


ALTER TABLE cmnttypesource ENABLE TRIGGER ALL;

--
-- TOC entry 9514 (class 0 OID 0)
-- Dependencies: 502
-- Name: cmnttypesource_cmnttypesource_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cmnttypesource_cmnttypesource_id_seq', 144, true);


--
-- TOC entry 9515 (class 0 OID 0)
-- Dependencies: 503
-- Name: cntct_cntct_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cntct_cntct_id_seq', 1, false);


--
-- TOC entry 9102 (class 0 OID 146609779)
-- Dependencies: 504 8929 8905 9464
-- Data for Name: cntctaddr; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cntctaddr DISABLE TRIGGER ALL;



ALTER TABLE cntctaddr ENABLE TRIGGER ALL;

--
-- TOC entry 9516 (class 0 OID 0)
-- Dependencies: 505
-- Name: cntctaddr_cntctaddr_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cntctaddr_cntctaddr_id_seq', 1, false);


--
-- TOC entry 9104 (class 0 OID 146609784)
-- Dependencies: 506 8905 9464
-- Data for Name: cntctdata; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cntctdata DISABLE TRIGGER ALL;



ALTER TABLE cntctdata ENABLE TRIGGER ALL;

--
-- TOC entry 9517 (class 0 OID 0)
-- Dependencies: 507
-- Name: cntctdata_cntctdata_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cntctdata_cntctdata_id_seq', 1, false);


--
-- TOC entry 9106 (class 0 OID 146609792)
-- Dependencies: 508 8905 9464
-- Data for Name: cntcteml; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cntcteml DISABLE TRIGGER ALL;



ALTER TABLE cntcteml ENABLE TRIGGER ALL;

--
-- TOC entry 9518 (class 0 OID 0)
-- Dependencies: 509
-- Name: cntcteml_cntcteml_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cntcteml_cntcteml_id_seq', 1, false);


--
-- TOC entry 9108 (class 0 OID 146609801)
-- Dependencies: 510 8905 9464
-- Data for Name: cntctmrgd; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cntctmrgd DISABLE TRIGGER ALL;



ALTER TABLE cntctmrgd ENABLE TRIGGER ALL;

--
-- TOC entry 9109 (class 0 OID 146609805)
-- Dependencies: 511 8905 9464
-- Data for Name: cntctsel; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cntctsel DISABLE TRIGGER ALL;



ALTER TABLE cntctsel ENABLE TRIGGER ALL;

--
-- TOC entry 8892 (class 0 OID 146606336)
-- Dependencies: 189 9464
-- Data for Name: cntslip; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cntslip DISABLE TRIGGER ALL;



ALTER TABLE cntslip ENABLE TRIGGER ALL;

--
-- TOC entry 9519 (class 0 OID 0)
-- Dependencies: 512
-- Name: cntslip_cntslip_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cntslip_cntslip_id_seq', 97, true);


--
-- TOC entry 8921 (class 0 OID 146607663)
-- Dependencies: 224 8923 8924 8919 8909 9464
-- Data for Name: invchead; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE invchead DISABLE TRIGGER ALL;



ALTER TABLE invchead ENABLE TRIGGER ALL;

--
-- TOC entry 8925 (class 0 OID 146607702)
-- Dependencies: 229 8921 8902 8902 8943 8901 9464
-- Data for Name: invcitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE invcitem DISABLE TRIGGER ALL;



ALTER TABLE invcitem ENABLE TRIGGER ALL;

--
-- TOC entry 9111 (class 0 OID 146609826)
-- Dependencies: 513 8925 8901 9464
-- Data for Name: cobill; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cobill DISABLE TRIGGER ALL;



ALTER TABLE cobill ENABLE TRIGGER ALL;

--
-- TOC entry 9520 (class 0 OID 0)
-- Dependencies: 514
-- Name: cobill_cobill_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cobill_cobill_id_seq', 528, true);


--
-- TOC entry 9113 (class 0 OID 146609835)
-- Dependencies: 515 8990 9111 8990 8901 9464
-- Data for Name: cobilltax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cobilltax DISABLE TRIGGER ALL;



ALTER TABLE cobilltax ENABLE TRIGGER ALL;

--
-- TOC entry 9114 (class 0 OID 146609841)
-- Dependencies: 516 8921 8901 8919 8909 9464
-- Data for Name: cobmisc; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cobmisc DISABLE TRIGGER ALL;



ALTER TABLE cobmisc ENABLE TRIGGER ALL;

--
-- TOC entry 9521 (class 0 OID 0)
-- Dependencies: 517
-- Name: cobmisc_cobmisc_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cobmisc_cobmisc_id_seq', 204, true);


--
-- TOC entry 9116 (class 0 OID 146609851)
-- Dependencies: 518 8990 9114 8990 8901 9464
-- Data for Name: cobmisctax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cobmisctax DISABLE TRIGGER ALL;



ALTER TABLE cobmisctax ENABLE TRIGGER ALL;

--
-- TOC entry 8964 (class 0 OID 146608763)
-- Dependencies: 305 9464
-- Data for Name: incdtpriority; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE incdtpriority DISABLE TRIGGER ALL;

INSERT INTO incdtpriority (incdtpriority_id, incdtpriority_name, incdtpriority_order, incdtpriority_descrip) VALUES (2, 'High', 1, NULL);
INSERT INTO incdtpriority (incdtpriority_id, incdtpriority_name, incdtpriority_order, incdtpriority_descrip) VALUES (3, 'Normal', 2, NULL);
INSERT INTO incdtpriority (incdtpriority_id, incdtpriority_name, incdtpriority_order, incdtpriority_descrip) VALUES (4, 'Low', 3, NULL);
INSERT INTO incdtpriority (incdtpriority_id, incdtpriority_name, incdtpriority_order, incdtpriority_descrip) VALUES (5, 'Very Low', 4, NULL);
INSERT INTO incdtpriority (incdtpriority_id, incdtpriority_name, incdtpriority_order, incdtpriority_descrip) VALUES (1, 'Very High', 0, NULL);


ALTER TABLE incdtpriority ENABLE TRIGGER ALL;

--
-- TOC entry 9284 (class 0 OID 146610596)
-- Dependencies: 696 9464
-- Data for Name: opsource; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE opsource DISABLE TRIGGER ALL;



ALTER TABLE opsource ENABLE TRIGGER ALL;

--
-- TOC entry 9286 (class 0 OID 146610605)
-- Dependencies: 698 9464
-- Data for Name: opstage; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE opstage DISABLE TRIGGER ALL;



ALTER TABLE opstage ENABLE TRIGGER ALL;

--
-- TOC entry 9288 (class 0 OID 146610616)
-- Dependencies: 700 9464
-- Data for Name: optype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE optype DISABLE TRIGGER ALL;



ALTER TABLE optype ENABLE TRIGGER ALL;

--
-- TOC entry 8926 (class 0 OID 146607829)
-- Dependencies: 231 8905 8906 9284 9286 9288 8964 9464
-- Data for Name: ophead; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE ophead DISABLE TRIGGER ALL;



ALTER TABLE ophead ENABLE TRIGGER ALL;

--
-- TOC entry 8918 (class 0 OID 146607614)
-- Dependencies: 219 8929 8905 8913 8916 8916 8953 8953 8924 8919 9464
-- Data for Name: shiptoinfo; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE shiptoinfo DISABLE TRIGGER ALL;



ALTER TABLE shiptoinfo ENABLE TRIGGER ALL;

--
-- TOC entry 8897 (class 0 OID 146606426)
-- Dependencies: 195 8905 8913 8943 8926 8922 8916 8923 8953 8905 8918 8924 8901 8919 8910 8896 8909 9464
-- Data for Name: cohead; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cohead DISABLE TRIGGER ALL;



ALTER TABLE cohead ENABLE TRIGGER ALL;

--
-- TOC entry 9522 (class 0 OID 0)
-- Dependencies: 519
-- Name: cohead_cohead_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cohead_cohead_id_seq', 2952, true);


--
-- TOC entry 8995 (class 0 OID 146609187)
-- Dependencies: 376 9085 8913 8916 8901 8919 8909 9464
-- Data for Name: cohist; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cohist DISABLE TRIGGER ALL;



ALTER TABLE cohist ENABLE TRIGGER ALL;

--
-- TOC entry 9523 (class 0 OID 0)
-- Dependencies: 520
-- Name: cohist_cohist_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cohist_cohist_id_seq', 493, true);


--
-- TOC entry 8998 (class 0 OID 146609204)
-- Dependencies: 379 8990 8995 8990 8901 9464
-- Data for Name: cohisttax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE cohisttax DISABLE TRIGGER ALL;



ALTER TABLE cohisttax ENABLE TRIGGER ALL;

--
-- TOC entry 8973 (class 0 OID 146608884)
-- Dependencies: 326 9464
-- Data for Name: plancode; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE plancode DISABLE TRIGGER ALL;



ALTER TABLE plancode ENABLE TRIGGER ALL;

--
-- TOC entry 8895 (class 0 OID 146606370)
-- Dependencies: 192 8972 8894 8973 8896 9464
-- Data for Name: itemsite; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE itemsite DISABLE TRIGGER ALL;



ALTER TABLE itemsite ENABLE TRIGGER ALL;

--
-- TOC entry 8898 (class 0 OID 146606445)
-- Dependencies: 196 8897 8943 8895 8902 8902 8943 8894 8901 9464
-- Data for Name: coitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE coitem DISABLE TRIGGER ALL;



ALTER TABLE coitem ENABLE TRIGGER ALL;

--
-- TOC entry 9524 (class 0 OID 0)
-- Dependencies: 521
-- Name: coitem_coitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('coitem_coitem_id_seq', 564, true);


--
-- TOC entry 8933 (class 0 OID 146608366)
-- Dependencies: 240 8932 9464
-- Data for Name: comment; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE comment DISABLE TRIGGER ALL;

INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (39, 1, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (40, 2, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (41, 3, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (42, 4, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (43, 5, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (44, 6, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (45, 7, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (46, 8, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (47, 9, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (48, 10, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (49, 11, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (50, 12, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (51, 13, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (52, 14, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (53, 15, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (54, 16, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (55, 17, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (56, 18, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (57, 19, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (58, 20, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (59, 21, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (60, 22, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (61, 23, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);
INSERT INTO comment (comment_id, comment_source_id, comment_date, comment_user, comment_text, comment_cmnttype_id, comment_source, comment_public) VALUES (62, 24, '2011-08-19 11:12:05.633058-04', 'admin', 'Created by admin', 2, 'CRMA', false);


ALTER TABLE comment ENABLE TRIGGER ALL;

--
-- TOC entry 9525 (class 0 OID 0)
-- Dependencies: 522
-- Name: comment_comment_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('comment_comment_id_seq', 62, true);


--
-- TOC entry 9121 (class 0 OID 146609865)
-- Dependencies: 523 8909 8943 8943 8943 8943 9464
-- Data for Name: company; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE company DISABLE TRIGGER ALL;



ALTER TABLE company ENABLE TRIGGER ALL;

--
-- TOC entry 9526 (class 0 OID 0)
-- Dependencies: 524
-- Name: company_company_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('company_company_id_seq', 1, false);


--
-- TOC entry 8974 (class 0 OID 146608902)
-- Dependencies: 329 8911 9464
-- Data for Name: contrct; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE contrct DISABLE TRIGGER ALL;



ALTER TABLE contrct ENABLE TRIGGER ALL;

--
-- TOC entry 9527 (class 0 OID 0)
-- Dependencies: 525
-- Name: contrct_contrct_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('contrct_contrct_id_seq', 1, false);


--
-- TOC entry 9528 (class 0 OID 0)
-- Dependencies: 529
-- Name: coship_coship_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('coship_coship_id_seq', 441, true);


--
-- TOC entry 9529 (class 0 OID 0)
-- Dependencies: 531
-- Name: cosmisc_cosmisc_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cosmisc_cosmisc_id_seq', 202, true);


--
-- TOC entry 9530 (class 0 OID 0)
-- Dependencies: 532
-- Name: cosrc_cosrc_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cosrc_cosrc_id_seq', 1, false);


--
-- TOC entry 9531 (class 0 OID 0)
-- Dependencies: 533
-- Name: costcat_costcat_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('costcat_costcat_id_seq', 29, true);


--
-- TOC entry 9532 (class 0 OID 0)
-- Dependencies: 534
-- Name: costelem_costelem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('costelem_costelem_id_seq', 20, true);


--
-- TOC entry 9131 (class 0 OID 146609915)
-- Dependencies: 535 8909 8909 9464
-- Data for Name: costhist; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE costhist DISABLE TRIGGER ALL;



ALTER TABLE costhist ENABLE TRIGGER ALL;

--
-- TOC entry 9533 (class 0 OID 0)
-- Dependencies: 536
-- Name: costhist_costhist_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('costhist_costhist_id_seq', 992, true);


--
-- TOC entry 9133 (class 0 OID 146609926)
-- Dependencies: 537 9464
-- Data for Name: costupdate; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE costupdate DISABLE TRIGGER ALL;



ALTER TABLE costupdate ENABLE TRIGGER ALL;

--
-- TOC entry 9134 (class 0 OID 146609930)
-- Dependencies: 538 9464
-- Data for Name: country; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE country DISABLE TRIGGER ALL;

INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (214, NULL, NULL, 'XTS', 'Code reserved for testing', '963', NULL, NULL);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (5, 'AD', 'Andorra', 'EUR', 'Euro', '978', 'â¬', 5);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (228, 'AE', 'United Arab Emirates', 'AED', 'UAE Dirham', '784', NULL, 223);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (1, 'AF', 'Afghanistan', 'AFN', 'Afghani', '971', NULL, 1);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (9, 'AG', 'Antigua And Barbuda', 'XCD', 'East Caribbean Dollar', '951', '$', 9);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (7, 'AI', 'Anguilla', 'XCD', 'East Caribbean Dollar', '951', '$', 7);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (2, 'AL', 'Albania', 'ALL', 'Lek', '8  ', NULL, 2);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (11, 'AM', 'Armenia', 'AMD', 'Armenian Dram', '51 ', NULL, 11);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (154, 'AN', 'Netherlands Antilles', 'ANG', 'Netherlands Antillian Guilder', '532', 'Æ', 152);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (6, 'AO', 'Angola', 'AOA', 'Kwanza', '973', NULL, 6);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (8, 'AQ', 'Antarctica', NULL, NULL, NULL, NULL, 8);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (10, 'AR', 'Argentina', 'ARS', 'Argentine Peso', '32 ', '$', 10);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (4, 'AS', 'American Samoa', 'USD', 'US Dollar', '840', '$', 4);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (14, 'AT', 'Austria', 'EUR', 'Euro', '978', 'â¬', 14);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (13, 'AU', 'Australia', 'AUD', 'Australian Dollar', '36 ', '$', 13);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (12, 'AW', 'Aruba', 'AWG', 'Aruban Guilder', '533', 'Æ', 12);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (15, 'AZ', 'Azerbaijan', 'AZN', 'Azerbaijanian Manat', '944', NULL, 15);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (27, 'BA', 'Bosnia And Herzegovina', 'BAM', 'Convertible Marks', '977', NULL, 27);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (19, 'BB', 'Barbados', 'BBD', 'Barbados Dollar', '52 ', '$', 19);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (18, 'BD', 'Bangladesh', 'BDT', 'Taka', '50 ', NULL, 18);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (21, 'BE', 'Belgium', 'EUR', 'Euro', '978', 'â¬', 21);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (35, 'BF', 'Burkina Faso', 'XOF', 'CFA Franc BCEAO', '952', NULL, 34);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (34, 'BG', 'Bulgaria', 'BGN', 'Bulgarian Lev', '975', NULL, 33);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (17, 'BH', 'Bahrain', 'BHD', 'Bahraini Dinar', '48 ', NULL, 17);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (36, 'BI', 'Burundi', 'BIF', 'Burundi Franc', '108', NULL, 35);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (23, 'BJ', 'Benin', 'XOF', 'CFA Franc BCEAO', '952', NULL, 23);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (24, 'BM', 'Bermuda', 'BMD', 'Bermudian Dollar', '60 ', '$', 24);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (33, 'BN', 'Brunei Darussalam', 'BND', 'Brunei Dollar', '96 ', '$', 32);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (26, 'BO', 'Bolivia', 'BOB', 'Boliviano', '68 ', '$', 26);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (30, 'BR', 'Brazil', 'BRL', 'Brazilian Real', '986', 'R$', 30);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (16, 'BS', 'Bahamas', 'BSD', 'Bahamian Dollar', '44 ', '$', 16);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (25, 'BT', 'Bhutan', 'BTN', 'Ngultrum', '64 ', NULL, 25);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (29, 'BV', 'Bouvet Island', 'NOK', 'Norwegian Krone', '578', NULL, 29);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (28, 'BW', 'Botswana', 'BWP', 'Pula', '72 ', NULL, 28);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (20, 'BY', 'Belarus', 'BYR', 'Belarussian Ruble', '974', NULL, 20);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (22, 'BZ', 'Belize', 'BZD', 'Belize Dollar', '84 ', '$', 22);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (39, 'CA', 'Canada', 'CAD', 'Canadian Dollar', '124', '$', 38);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (47, 'CC', 'Cocos (Keeling) Islands', 'AUD', 'Australian Dollar', '36 ', '$', 46);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (51, 'CD', 'Congo, The Democratic Republic Of', 'CDF', 'Franc Congolais', '976', NULL, 49);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (42, 'CF', 'Central African Republic', 'XAF', 'CFA Franc BEAC', '950', NULL, 41);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (50, 'CG', 'Congo', 'XAF', 'CFA Franc BEAC', '950', NULL, 50);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (209, 'CH', 'Switzerland', 'CHF', 'Swiss Franc', '756', NULL, 206);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (107, 'CI', 'Ivory Coast', 'XOF', 'CFA Frank BCEA', '952', NULL, 53);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (52, 'CK', 'Cook Islands', 'NZD', 'New Zealand Dollar', '554', '$', 51);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (44, 'CL', 'Chile', 'CLP', 'Chilean Peso', '152', '$', 43);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (38, 'CM', 'Cameroon', 'XAF', 'CFA Franc BEAC', '950', NULL, 37);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (45, 'CN', 'China', 'CNY', 'Yuan Renminbi', '156', NULL, 44);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (48, 'CO', 'Colombia', 'COP', 'Colombian Peso', '170', 'â±', 47);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (53, 'CR', 'Costa Rica', 'CRC', 'Costa Rican Colon', '188', 'â¡', 52);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (55, 'CU', 'Cuba', 'CUP', 'Cuban Peso', '192', 'â±', 55);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (40, 'CV', 'Cape Verde', 'CVE', 'Cape Verde Escudo', '132', NULL, 39);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (46, 'CX', 'Christmas Island', 'AUD', 'Australian Dollar', '36 ', '$', 45);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (56, 'CY', 'Cyprus', 'CYP', 'Cyprus Pound', '196', 'Â£', 56);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (57, 'CZ', 'Czech Republic', 'CZK', 'Czech Koruna', '203', NULL, 57);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (81, 'DE', 'Germany', 'EUR', 'Euro', '978', 'â¬', 82);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (59, 'DJ', 'Djibouti', 'DJF', 'Djibouti Franc', '262', NULL, 59);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (58, 'DK', 'Denmark', 'DKK', 'Danish Krone', '208', 'kr', 58);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (60, 'DM', 'Dominica', 'XCD', 'East Caribbean Dollar', '951', '$', 60);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (61, 'DO', 'Dominican Republic', 'DOP', 'Dominican Peso', '214', 'â±', 61);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (3, 'DZ', 'Algeria', 'DZD', 'Algerian Dinar', '12 ', NULL, 3);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (63, 'EC', 'Ecuador', 'USD', 'US Dollar', '840', '$', 63);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (68, 'EE', 'Estonia', 'EEK', 'Kroon', '233', NULL, 68);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (64, 'EG', 'Egypt', 'EGP', 'Egyptian Pound', '818', 'Â£', 64);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (239, 'EH', 'Western Sahara', 'MAD', 'Moroccan Dirham', '504', NULL, 236);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (67, 'ER', 'Eritrea', 'ERN', 'Nakfa', '232', NULL, 67);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (202, 'ES', 'Spain', 'EUR', 'Euro', '978', 'â¬', 197);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (69, 'ET', 'Ethiopia', 'ETB', 'Ethiopian Birr', '230', NULL, 69);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (73, 'FI', 'Finland', 'EUR', 'Euro', '978', 'â¬', 73);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (72, 'FJ', 'Fiji', 'FJD', 'Fiji Dollar', '242', '$', 72);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (70, 'FK', 'Falkland Islands (Malvinas)', 'FKP', 'Falkland Islands Pound', '238', 'Â£', 70);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (141, 'FM', 'Micronesia, Federated States Of', 'USD', 'US Dollar', '840', '$', 140);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (71, 'FO', 'Faroe Islands', 'DKK', 'Danish Krone', '208', NULL, 71);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (74, 'FR', 'France', 'EUR', 'Euro', '978', 'â¬', 74);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (78, 'GA', 'Gabon', 'XAF', 'CFA Franc BEAC', '950', NULL, 79);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (86, 'GD', 'Grenada', 'XCD', 'East Caribbean Dollar', '951', '$', 87);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (80, 'GE', 'Georgia', 'GEL', 'Lari', '981', NULL, 81);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (75, 'GF', 'French Guiana', 'EUR', 'Euro', '978', 'â¬', 76);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (82, 'GH', 'Ghana', 'GHC', 'Cedi', '288', NULL, 83);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (83, 'GI', 'Gibraltar', 'GIP', 'Gibraltar Pound', '292', 'Â£', 84);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (85, 'GL', 'Greenland', 'DKK', 'Danish Krone', '208', NULL, 86);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (79, 'GM', 'Gambia', 'GMD', 'Dalasi', '270', NULL, 80);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (90, 'GN', 'Guinea', 'GNF', 'Guinea Franc', '324', NULL, 91);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (87, 'GP', 'Guadeloupe', 'EUR', 'Euro', '978', 'â¬', 88);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (66, 'GQ', 'Equatorial Guinea', 'XAF', 'CFA Franc BEAC', '950', NULL, 66);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (84, 'GR', 'Greece', 'EUR', 'Euro', '978', 'â¬', 85);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (201, 'GS', 'South Georgia And The South Sandwich Islands ', 'GBP', 'Pound Sterling', '826', NULL, 196);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (89, 'GT', 'Guatemala', 'GTQ', 'Quetzal', '320', NULL, 90);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (88, 'GU', 'Guam', 'USD', 'US Dollar', '840', '$', 89);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (91, 'GW', 'Guinea-Bissau', 'XOF', 'CFA Franc BCEAO', '952', NULL, 92);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (92, 'GY', 'Guyana', 'GYD', 'Guyana Dollar', '328', '$', 93);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (97, 'HK', 'Hong Kong', 'HKD', 'Hong Kong Dollar', '344', '$', 97);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (94, 'HM', 'Heard Island And Mcdonald Islands', 'AUD', 'Australian Dollar', '36 ', '$', 95);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (96, 'HN', 'Honduras', 'HNL', 'Lempira', '340', NULL, 96);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (54, 'HR', 'Croatia', 'HRK', 'Croatian Kuna', '191', NULL, 54);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (93, 'HT', 'Haiti', 'HTG', 'Gourde', '332', NULL, 94);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (98, 'HU', 'Hungary', 'HUF', 'Forint', '348', NULL, 98);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (101, 'ID', 'Indonesia', 'IDR', 'Indonesia Rupiah', '360', NULL, 101);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (104, 'IE', 'Ireland', 'EUR', 'Euro', '978', 'â¬', 104);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (105, 'IL', 'Israel', 'ILS', 'New Israeli Sheqel', '376', 'âª', 105);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (100, 'IN', 'India', 'INR', 'Indian Rupee', '356', 'â¨', 100);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (31, 'IO', 'British Indian Ocean Territory', 'USD', 'US Dollar', '840', '$', 31);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (103, 'IQ', 'Iraq', 'IQD', 'Iraqi Dinar', '368', NULL, 103);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (102, 'IR', 'Iran', 'IRR', 'Iranian Rial', '364', 'ï·¼', 102);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (99, 'IS', 'Iceland', 'ISK', 'Iceland Krona', '352', NULL, 99);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (106, 'IT', 'Italy', 'EUR', 'Euro', '978', 'â¬', 106);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (108, 'JM', 'Jamaica', 'JMD', 'Jamaican Dollar', '388', '$', 107);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (110, 'JO', 'Jordan', 'JOD', 'Jordanian Dinar', '400', NULL, 109);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (109, 'JP', 'Japan', 'JPY', 'Yen', '392', 'Â¥', 108);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (112, 'KE', 'Kenya', 'KES', 'Kenyan Shilling', '404', NULL, 111);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (117, 'KG', 'Kyrgyzstan', 'KGS', 'Som', '417', NULL, 116);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (37, 'KH', 'Cambodia', 'KHR', 'Riel', '116', 'á', 36);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (113, 'KI', 'Kiribati', 'AUD', 'Australian Dollar', '36 ', '$', 112);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (49, 'KM', 'Comoros', 'KMF', 'Comoro Franc', '174', NULL, 48);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (183, 'KN', 'Saint Kitts And Nevis', 'XCD', 'East Caribbean Dollar', '951', '$', 180);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (114, 'KP', 'Korea, Democratic Peoples Republic Of', 'KPW', 'North Korean Won', '408', 'â©', 113);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (115, 'KR', 'Korea, Republic Of', 'KRW', 'South Korean Won', '410', 'â©', 114);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (116, 'KW', 'Kuwait', 'KWD', 'Kuwaiti Dinar', '414', NULL, 115);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (41, 'KY', 'Cayman Islands', 'KYD', 'Cayman Islands Dollar', '136', '$', 40);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (111, 'KZ', 'Kazakhstan', 'KZT', 'Tenge', '398', NULL, 110);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (118, 'LA', 'Laos', 'LAK', 'Kip', '418', 'â­', 117);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (120, 'LB', 'Lebanon', 'LBP', 'Lebanese Pound', '422', 'Â£', 119);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (184, 'LC', 'Saint Lucia', 'XCD', 'East Caribbean Dollar', '951', '$', 181);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (124, 'LI', 'Liechtenstein', 'CHF', 'Swiss Franc', '756', NULL, 123);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (203, 'LK', 'Sri Lanka', 'LKR', 'Sri Lanka Rupee', '144', 'à¯¹', 198);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (122, 'LR', 'Liberia', 'LRD', 'Liberian Dollar', '430', '$', 121);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (121, 'LS', 'Lesotho', 'LSL', 'Loti', '426', NULL, 120);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (125, 'LT', 'Lithuania', 'LTL', 'Lithuanian Litas', '440', NULL, 124);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (126, 'LU', 'Luxembourg', 'EUR', 'Euro', '978', 'â¬', 125);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (119, 'LV', 'Latvia', 'LVL', 'Latvian Lats', '428', NULL, 118);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (123, 'LY', 'Libyan Arab Jamahiriya', 'LYD', 'Libyan Dinar', '434', NULL, 122);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (147, 'MA', 'Morocco', 'MAD', 'Moroccan Dirham', '504', NULL, 145);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (143, 'MC', 'Monaco', 'EUR', 'Euro', '978', 'â¬', 142);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (142, 'MD', 'Moldova', 'MDL', 'Moldovan Leu', '498', NULL, 141);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (145, 'ME', 'Montenegro', 'EUR', 'Euro', '978', 'â¬', 241);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (129, 'MG', 'Madagascar', 'MGA', 'Malagascy Ariary', '969', NULL, 128);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (135, 'MH', 'Marshall Islands', 'USD', 'US Dollar', '840', '$', 134);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (128, 'MK', 'Macedonia, Former Yugoslav Republic Of', 'MKD', 'Denar', '807', NULL, 127);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (133, 'ML', 'Mali', 'XOF', 'CFA Franc BCEAO', '952', NULL, 132);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (149, 'MM', 'Myanmar', 'MMK', 'Kyat', '104', NULL, 147);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (144, 'MN', 'Mongolia', 'MNT', 'Tugrik', '496', 'â®', 143);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (127, 'MO', 'Macao', 'MOP', 'Pataca', '446', NULL, 126);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (162, 'MP', 'Northern Mariana Islands', 'USD', 'US Dollar', '840', '$', 160);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (136, 'MQ', 'Martinique', 'EUR', 'Euro', '978', 'â¬', 135);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (137, 'MR', 'Mauritania', 'MRO', 'Ouguiya', '478', NULL, 136);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (146, 'MS', 'Montserrat', 'XCD', 'East Caribbean Dollar', '951', '$', 144);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (134, 'MT', 'Malta', 'MTL', 'Maltese Lira', '470', 'â¤', 133);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (138, 'MU', 'Mauritius', 'MUR', 'Mauritius Rupee', '480', 'â¨', 137);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (132, 'MV', 'Maldives', 'MVR', 'Rufiyaa', '462', NULL, 131);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (130, 'MW', 'Malawi', 'MWK', 'Malawi Kwacha', '454', NULL, 129);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (140, 'MX', 'Mexico', 'MXN', 'Mexican Peso', '484', '$', 139);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (131, 'MY', 'Malaysia', 'MYR', 'Malaysian Ringgit', '458', NULL, 130);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (148, 'MZ', 'Mozambique', 'MZN', 'Metical', '943', NULL, 146);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (150, 'NA', 'Namibia', 'NAD', 'Namibian Dollar', '516', '$', 148);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (155, 'NC', 'New Caledonia', 'XPF', 'CFP Franc', '953', NULL, 153);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (158, 'NE', 'Niger', 'XOF', 'CFA Franc BCEAO', '952', NULL, 156);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (161, 'NF', 'Norfolk Island', 'AUD', 'Australian Dollar', '36 ', '$', 159);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (159, 'NG', 'Nigeria', 'NGN', 'Naira', '566', 'â¦', 157);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (157, 'NI', 'Nicaragua', 'NIO', 'Cordoba Oro', '558', NULL, 155);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (153, 'NL', 'Netherlands', 'EUR', 'Euro', '978', 'â¬', 151);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (163, 'NO', 'Norway', 'NOK', 'Norwegian Krone', '578', NULL, 161);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (152, 'NP', 'Nepal', 'NPR', 'Nepalese Rupee', '524', 'â¨', 150);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (151, 'NR', 'Nauru', 'AUD', 'Australian Dollar', '36 ', '$', 149);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (160, 'NU', 'Niue', 'NZD', 'New Zealand Dollar', '554', '$', 158);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (156, 'NZ', 'New Zealand', 'NZD', 'New Zealand Dollar', '554', '$', 154);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (164, 'OM', 'Oman', 'OMR', 'Rial Omani', '512', 'ï·¼', 162);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (168, 'PA', 'Panama', 'PAB', 'Balboa', '590', NULL, 166);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (171, 'PE', 'Peru', 'PEN', 'Nuevo Sol', '604', 'S/.', 169);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (76, 'PF', 'French Polynesia', 'XPF', 'CFP Franc', '953', NULL, 77);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (169, 'PG', 'Papua New Guinea', 'PGK', 'Kina', '598', NULL, 167);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (172, 'PH', 'Philippines', 'PHP', 'Philippine Peso', '608', 'â±', 170);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (165, 'PK', 'Pakistan', 'PKR', 'Pakistan Rupee', '586', 'â¨', 163);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (174, 'PL', 'Poland', 'PLN', 'Zloty', '985', NULL, 172);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (185, 'PM', 'Saint Pierre And Miquelon', 'EUR', 'Euro', '978', 'â¬', 200);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (173, 'PN', 'Pitcairn', 'NZD', 'New Zealand Dollar', '554', '$', 171);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (176, 'PR', 'Puerto Rico', 'USD', 'US Dollar', '840', '$', 174);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (167, 'PS', 'Palestinian Territories', NULL, NULL, NULL, NULL, 165);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (175, 'PT', 'Portugal', 'EUR', 'Euro', '978', 'â¬', 173);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (166, 'PW', 'Palau', 'USD', 'US Dollar', '840', '$', 164);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (170, 'PY', 'Paraguay', 'PYG', 'Guarani', '600', NULL, 168);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (177, 'QA', 'Qatar', 'QAR', 'Qatari Rial', '634', NULL, 175);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (178, 'RE', 'Reunion', 'EUR', 'Euro', '978', 'â¬', 176);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (179, 'RO', 'Romania', 'RON', 'New Leu', '946', NULL, 177);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (192, 'RS', 'Serbia', 'RSD', 'Serbian Dinar', '941', NULL, 241);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (180, 'RU', 'Russian Federation', 'RUB', 'Russian Ruble', '643', NULL, 178);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (181, 'RW', 'Rwanda', 'RWF', 'Rwanda Franc', '646', NULL, 179);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (190, 'SA', 'Saudi Arabia', 'SAR', 'Saudi Riyal', '682', 'ï·¼', 186);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (198, 'SB', 'Solomon Islands', 'SBD', 'Solomon Islands Dollar', '90 ', '$', 193);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (193, 'SC', 'Seychelles', 'SCR', 'Seychelles Rupee', '690', 'â¨', 188);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (204, 'SD', 'Sudan', 'SDD', 'Sudanese Dinar', '736', NULL, 201);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (208, 'SE', 'Sweden', 'SEK', 'Swedish Krona', '752', 'kr', 205);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (195, 'SG', 'Singapore', 'SGD', 'Singapore Dollar', '702', '$', 190);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (182, 'SH', 'Saint Helena', 'SHP', 'Saint Helena Pound', '654', 'Â£', 199);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (197, 'SI', 'Slovenia', 'SIT', 'Tolar', '705', NULL, 192);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (206, 'SJ', 'Svalbard And Jan Mayen', 'NOK', 'Norwegian Krone', '578', NULL, 203);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (196, 'SK', 'Slovakia', 'SKK', 'Slovak Koruna', '703', NULL, 191);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (194, 'SL', 'Sierra Leone', 'SLL', 'Leone', '694', NULL, 189);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (188, 'SM', 'San Marino', 'EUR', 'Euro', '978', 'â¬', 184);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (191, 'SN', 'Senegal', 'XOF', 'CFA Franc BCEAO', '952', NULL, 187);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (199, 'SO', 'Somalia', 'SOS', 'Somali Shilling', '706', NULL, 194);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (205, 'SR', 'Suriname', 'SRD', 'Surinam Dollar', '968', '$', 202);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (189, 'ST', 'Sao Tome And Principe', 'STD', 'Dobra', '678', NULL, 185);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (65, 'SV', 'El Salvador', 'SVC', 'El Salvador Colon', '222', 'â¡', 65);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (210, 'SY', 'Syria', 'SYP', 'Syrian Pound', '760', 'Â£', 207);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (207, 'SZ', 'Swaziland', 'SZL', 'Lilangeni', '748', NULL, 204);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (224, 'TC', 'Turks And Caicos Islands', 'USD', 'US Dollar', '840', '$', 219);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (43, 'TD', 'Chad', 'XAF', 'CFA Franc BEAC', '950', NULL, 42);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (77, 'TF', 'French Southern Territories', 'EUR', 'Euro', '978', 'â¬', 78);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (217, 'TG', 'Togo', 'XOF', 'CFA Franc BCEAO', '952', NULL, 212);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (215, 'TH', 'Thailand', 'THB', 'Baht', '764', 'à¸¿', 211);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (212, 'TJ', 'Tajikistan', 'TJS', 'Somoni', '972', NULL, 209);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (218, 'TK', 'Tokelau', 'NZD', 'New Zealand Dollar', '554', '$', 213);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (216, 'TL', 'Timor-Leste', 'USD', 'US Dollar', '840', '$', 62);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (223, 'TM', 'Turkmenistan', 'TMM', 'Turkmenistan Manat', '795', NULL, 218);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (221, 'TN', 'Tunisia', 'TND', 'Tunisian Dinar', '788', NULL, 216);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (219, 'TO', 'Tonga', 'TOP', 'Paanga', '776', NULL, 214);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (62, 'TP', 'East Timor', 'IDR', 'Indonesia Rupiah', '360', NULL, 62);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (222, 'TR', 'Turkey', 'TRY', 'New Turkish Lira', '949', 'â¤', 217);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (220, 'TT', 'Trinidad And Tobago', 'TTD', 'Trinidad and Tobago Dollar', '780', '$', 215);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (225, 'TV', 'Tuvalu', 'AUD', 'Australian Dollar', '36 ', '$', 220);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (211, 'TW', 'Taiwan', 'TWD', 'New Taiwan Dollar', '901', '$', 208);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (213, 'TZ', 'Tanzania', 'TZS', 'Tanzanian Shilling', '834', NULL, 210);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (227, 'UA', 'Ukraine', 'UAH', 'Hryvnia', '980', NULL, 222);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (226, 'UG', 'Uganda', 'UGX', 'Uganda Shilling', '800', NULL, 221);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (229, 'UK', 'United Kingdom', 'GBP', 'Pound Sterling', '826', 'Â£', 224);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (232, 'UM', 'U.S. Minor Outlying Islands', 'USD', 'US Dollar', '840', '$', 226);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (230, 'US', 'United States', 'USD', 'US Dollar', '840', '$', 225);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (231, 'UY', 'Uruguay', 'UYU', 'Peso Uruguayo', '858', 'â±', 227);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (234, 'UZ', 'Uzbekistan', 'UZS', 'Uzbekistan Sum', '860', NULL, 228);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (95, 'VA', 'Holy See (Vatican City State)', 'EUR', 'Euro', '978', 'â¬', 230);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (186, 'VC', 'Saint Vincent And The Grenadines', 'XCD', 'East Caribbean Dollar', '951', '$', 182);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (236, 'VE', 'Venezuela', 'VEB', 'Bolivar', '862', NULL, 231);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (32, 'VG', 'British Virgin Islands', 'USD', 'US Dollar', '840', '$', 233);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (233, 'VI', 'U.S. Virgin Islands', 'USD', 'US Dollar', '840', '$', 234);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (237, 'VN', 'Viet Nam', 'VND', 'Dong', '704', 'â«', 232);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (235, 'VU', 'Vanuatu', 'VUV', 'Vatu', '548', NULL, 229);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (238, 'WF', 'Wallis And Futuna', 'XPF', 'CFP Franc', '953', NULL, 235);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (187, 'WS', 'Samoa', 'WST', 'Tala', '882', NULL, 183);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (240, 'YE', 'Yemen', 'YER', 'Yemeni Rial', '886', 'ï·¼', 237);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (139, 'YT', 'Mayotte', 'EUR', 'Euro', '978', 'â¬', 138);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (200, 'ZA', 'South Africa', 'ZAR', 'Rand', '710', 'R', 195);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (241, 'ZM', 'Zambia', 'ZMK', 'Zambian Kwacha', '894', NULL, 239);
INSERT INTO country (country_id, country_abbr, country_name, country_curr_abbr, country_curr_name, country_curr_number, country_curr_symbol, country_qt_number) VALUES (242, 'ZW', 'Zimbabwe', 'ZWD', 'Zimbabwe Dollar', '716', '$', 240);


ALTER TABLE country ENABLE TRIGGER ALL;

--
-- TOC entry 9534 (class 0 OID 0)
-- Dependencies: 539
-- Name: country_country_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('country_country_id_seq', 242, true);


--
-- TOC entry 9535 (class 0 OID 0)
-- Dependencies: 543
-- Name: crmacct_crmacct_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('crmacct_crmacct_id_seq', 24, true);


--
-- TOC entry 9138 (class 0 OID 146609959)
-- Dependencies: 544 8906 8906 9464
-- Data for Name: crmacctsel; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE crmacctsel DISABLE TRIGGER ALL;



ALTER TABLE crmacctsel ENABLE TRIGGER ALL;

--
-- TOC entry 9139 (class 0 OID 146609980)
-- Dependencies: 545 8909 9464
-- Data for Name: curr_rate; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE curr_rate DISABLE TRIGGER ALL;

INSERT INTO curr_rate (curr_rate_id, curr_id, curr_rate, curr_effective, curr_expires) VALUES (2, 2, 1.00000000, '1970-01-01', '2100-01-01');


ALTER TABLE curr_rate ENABLE TRIGGER ALL;

--
-- TOC entry 9536 (class 0 OID 0)
-- Dependencies: 546
-- Name: curr_rate_curr_rate_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('curr_rate_curr_rate_id_seq', 2, true);


--
-- TOC entry 9537 (class 0 OID 0)
-- Dependencies: 547
-- Name: curr_symbol_curr_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('curr_symbol_curr_id_seq', 2, true);


--
-- TOC entry 9538 (class 0 OID 0)
-- Dependencies: 355
-- Name: cust_cust_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cust_cust_id_seq', 94, true);


--
-- TOC entry 9539 (class 0 OID 0)
-- Dependencies: 549
-- Name: cust_serial_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('cust_serial_seq', 1, false);


--
-- TOC entry 9143 (class 0 OID 146609995)
-- Dependencies: 550 9464
-- Data for Name: custform; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE custform DISABLE TRIGGER ALL;



ALTER TABLE custform ENABLE TRIGGER ALL;

--
-- TOC entry 9540 (class 0 OID 0)
-- Dependencies: 551
-- Name: custform_custform_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('custform_custform_id_seq', 7, true);


--
-- TOC entry 9145 (class 0 OID 146610004)
-- Dependencies: 552 9464
-- Data for Name: custgrp; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE custgrp DISABLE TRIGGER ALL;



ALTER TABLE custgrp ENABLE TRIGGER ALL;

--
-- TOC entry 9541 (class 0 OID 0)
-- Dependencies: 553
-- Name: custgrp_custgrp_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('custgrp_custgrp_id_seq', 24, true);


--
-- TOC entry 9147 (class 0 OID 146610014)
-- Dependencies: 554 9464
-- Data for Name: custgrpitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE custgrpitem DISABLE TRIGGER ALL;



ALTER TABLE custgrpitem ENABLE TRIGGER ALL;

--
-- TOC entry 9542 (class 0 OID 0)
-- Dependencies: 555
-- Name: custgrpitem_custgrpitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('custgrpitem_custgrpitem_id_seq', 47, true);


--
-- TOC entry 9543 (class 0 OID 0)
-- Dependencies: 556
-- Name: custtype_custtype_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('custtype_custtype_id_seq', 17, true);


--
-- TOC entry 9544 (class 0 OID 0)
-- Dependencies: 557
-- Name: dept_dept_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('dept_dept_id_seq', 1, false);


--
-- TOC entry 9151 (class 0 OID 146610024)
-- Dependencies: 558 9464
-- Data for Name: destination; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE destination DISABLE TRIGGER ALL;



ALTER TABLE destination ENABLE TRIGGER ALL;

--
-- TOC entry 9545 (class 0 OID 0)
-- Dependencies: 559
-- Name: destination_destination_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('destination_destination_id_seq', 12, true);


--
-- TOC entry 8934 (class 0 OID 146608377)
-- Dependencies: 242 9464
-- Data for Name: docass; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE docass DISABLE TRIGGER ALL;



ALTER TABLE docass ENABLE TRIGGER ALL;

--
-- TOC entry 9546 (class 0 OID 0)
-- Dependencies: 247
-- Name: docass_docass_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('docass_docass_id_seq', 1, true);


--
-- TOC entry 9547 (class 0 OID 0)
-- Dependencies: 562
-- Name: emp_emp_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('emp_emp_id_seq', 2, true);


--
-- TOC entry 9155 (class 0 OID 146610055)
-- Dependencies: 563 9464
-- Data for Name: empgrp; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE empgrp DISABLE TRIGGER ALL;



ALTER TABLE empgrp ENABLE TRIGGER ALL;

--
-- TOC entry 9548 (class 0 OID 0)
-- Dependencies: 564
-- Name: empgrp_empgrp_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('empgrp_empgrp_id_seq', 1, false);


--
-- TOC entry 9157 (class 0 OID 146610064)
-- Dependencies: 565 8957 9155 9464
-- Data for Name: empgrpitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE empgrpitem DISABLE TRIGGER ALL;



ALTER TABLE empgrpitem ENABLE TRIGGER ALL;

--
-- TOC entry 9549 (class 0 OID 0)
-- Dependencies: 566
-- Name: empgrpitem_empgrpitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('empgrpitem_empgrpitem_id_seq', 1, false);


--
-- TOC entry 9159 (class 0 OID 146610069)
-- Dependencies: 567 9464
-- Data for Name: evntlog; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE evntlog DISABLE TRIGGER ALL;



ALTER TABLE evntlog ENABLE TRIGGER ALL;

--
-- TOC entry 9550 (class 0 OID 0)
-- Dependencies: 568
-- Name: evntlog_evntlog_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('evntlog_evntlog_id_seq', 262, true);


--
-- TOC entry 9161 (class 0 OID 146610078)
-- Dependencies: 569 9464
-- Data for Name: evntnot; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE evntnot DISABLE TRIGGER ALL;



ALTER TABLE evntnot ENABLE TRIGGER ALL;

--
-- TOC entry 9551 (class 0 OID 0)
-- Dependencies: 570
-- Name: evntnot_evntnot_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('evntnot_evntnot_id_seq', 781, true);


--
-- TOC entry 9163 (class 0 OID 146610087)
-- Dependencies: 571 9464
-- Data for Name: evnttype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE evnttype DISABLE TRIGGER ALL;

INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (1, 'WoDueDateChanged', 'Work Order Due Date Changed', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (2, 'WoQtyChanged', 'Work Order Qty. Changed', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (3, 'WoCreated', 'Work Order Created', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (4, 'QOHBelowZero', 'QOH Dropped to a Negative Value', 'I/M');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (5, 'RWoDueDateRequestChange', 'Request to Change Released Due Date', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (6, 'RWoQtyRequestChange', 'Request to Change Released W/O Qty.', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (7, 'RWoRequestCancel', 'Request to Cancel Released W/O', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (8, 'WoCancelled', 'Work Order Canceled', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (9, 'CannotDistributeTransToGL', 'Cannot Distribute an Inventory Transaction to the G/L', 'G/L');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (10, 'SoitemQtyChanged', 'Sales Order Qty. Changed', 'S/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (11, 'SoitemCreated', 'Sales Order Item Added', 'S/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (12, 'SoitemSchedDateChanged', 'Sales Order Item Ship Date Changed', 'S/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (13, 'SoitemCancelled', 'Sales Order Item Cancelled', 'S/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (14, 'SoReleased', 'Sales Order Released', 'S/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (33, 'POitemCreate', 'Purchase Order Purchased Item Line Added', 'P/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (16, 'CannotConvertQuote', 'Cannot Convert a Quote to a Sales Order', 'S/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (17, 'DetachCCPayFromSO', 'Detached Credit Card payment from S/O', 'S/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (18, 'WODoubleClockIn', 'User clocked in to a Work Order without having previously clocked out', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (19, 'WODoubleClockOut', 'User clocked out of a Work Order without having previously clocked in', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (20, 'WOClockInOnClosedJob', 'User clocked in to a closed Work Order', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (21, 'WOClockOutWNoClockIn', 'User clocked out of a Work Order on which s/he was not clocked in', 'W/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (22, 'NewIncident', 'New Incident Created', 'CRM');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (23, 'UpdatedIncident', 'Incident Modified', 'CRM');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (24, 'ClosedIncident', 'Incident Closed', 'CRM');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (25, 'ReopenedIncident', 'Incident Which had been closed previously is being reopened', 'CRM');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (27, 'ToitemCreated', 'Transfer Order Item Created', 'I/M');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (29, 'ToitemQtyChanged', 'Transfer Order Item Qty. Changed', 'I/M');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (30, 'ToitemSchedDateChanged', 'Transfer Order Item Ship Date Changed', 'I/M');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (31, 'ToitemNoDestItemSite', 'Transfer Order Item created without an Item Site at the Destination Warehouse.', 'I/M');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (32, 'ToitemNoTransitItemSite', 'Transfer Order Item created without an Item Site at the Transit Warehouse.', 'I/M');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (28, 'ToitemCancelled', 'Transfer Order Item Cancelled', 'I/M');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (15, 'SoNotesChanged', 'Sales Order Order Comments Changed', 'S/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (34, 'TodoAlarm', 'To-Do Item Alarm', 'CRM');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (35, 'IncidentAlarm', 'Incident Alarm', 'CRM');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (36, 'TaskAlarm', 'Project Task Alarm', 'CRM');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (37, 'CostExceedsMaxDesired', 'Cost Exceeds Max Desired', 'P/D');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (38, 'PoItemCreatedBySo', 'Purchase Order Item Created by a Sales Order', 'P/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (39, 'PoItemUpdatedBySo', 'Purchase Order Item Updated by a Sales Order', 'P/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (40, 'PoItemSoCancelled', 'The Sales Order item has been cancelled for a linked Purchase Item', 'P/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (41, 'PoItemDropShipped', 'A Purchase Order Item has been Drop Shipped', 'P/O');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (42, 'CashReceiptPosted', 'A Cash Receipt has been posted', 'G/L');
INSERT INTO evnttype (evnttype_id, evnttype_name, evnttype_descrip, evnttype_module) VALUES (45, 'NewCustomer', 'A new Customer has been created', 'S/O');


ALTER TABLE evnttype ENABLE TRIGGER ALL;

--
-- TOC entry 9552 (class 0 OID 0)
-- Dependencies: 572
-- Name: evnttype_evnttype_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('evnttype_evnttype_id_seq', 45, true);


--
-- TOC entry 9553 (class 0 OID 0)
-- Dependencies: 573
-- Name: expcat_expcat_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('expcat_expcat_id_seq', 14, true);


--
-- TOC entry 8935 (class 0 OID 146608386)
-- Dependencies: 243 9464
-- Data for Name: file; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE file DISABLE TRIGGER ALL;



ALTER TABLE file ENABLE TRIGGER ALL;

--
-- TOC entry 9554 (class 0 OID 0)
-- Dependencies: 574
-- Name: file_file_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('file_file_id_seq', 1, false);


--
-- TOC entry 9167 (class 0 OID 146610101)
-- Dependencies: 575 9464
-- Data for Name: filter; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE filter DISABLE TRIGGER ALL;



ALTER TABLE filter ENABLE TRIGGER ALL;

--
-- TOC entry 9555 (class 0 OID 0)
-- Dependencies: 576
-- Name: filter_filter_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('filter_filter_id_seq', 1, false);


--
-- TOC entry 9169 (class 0 OID 146610110)
-- Dependencies: 577 9464
-- Data for Name: fincharg; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE fincharg DISABLE TRIGGER ALL;



ALTER TABLE fincharg ENABLE TRIGGER ALL;

--
-- TOC entry 9556 (class 0 OID 0)
-- Dependencies: 578
-- Name: fincharg_fincharg_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('fincharg_fincharg_id_seq', 1, false);


--
-- TOC entry 9173 (class 0 OID 146610165)
-- Dependencies: 582 9464
-- Data for Name: flcol; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE flcol DISABLE TRIGGER ALL;

INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (1, 6, 'Current', 'Current Month', 335, true, false, false, false, true, 'P', false, false, 'N', false, false, false, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (2, 6, 'Current, Budget', 'Current to Budget', 336, true, false, false, false, false, 'P', false, false, 'N', false, false, false, true, false, true, true);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (3, 6, 'Current, Prior Month', 'Current to Prior Month End', 337, true, false, false, false, false, 'P', true, false, 'N', false, true, true, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (4, 6, 'Current, Prior Quarter', 'Current to Prior Quarter End', 346, true, false, false, false, false, 'P', false, true, 'N', false, true, true, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (5, 6, 'Current, Prior Year', 'Current to Prior Year End', 338, true, false, false, false, false, 'P', false, false, 'F', false, true, true, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (6, 6, 'Current, Year Ago', 'Current to Month Prior Year', 337, true, false, false, false, false, 'Y', true, false, 'N', false, true, true, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (7, 7, 'Month', 'Current Month', 335, true, false, false, false, true, 'P', false, false, 'N', false, false, false, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (8, 7, 'Month, Budget', 'Current Month to Budget', 336, true, false, false, false, false, 'P', false, false, 'N', false, false, false, true, false, true, true);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (9, 7, 'Month, Prior Month', 'Current Month to Prior Month', 337, true, false, false, false, false, 'P', true, false, 'N', false, true, true, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (10, 7, 'Month, YTD', 'Month and Year to Date', 334, true, false, true, false, true, 'P', false, false, 'N', false, false, false, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (11, 7, 'Month, QTD', 'Month and Quarter to Date', 339, true, true, false, false, true, 'P', false, false, 'N', false, false, false, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (12, 7, 'QTD, Budget', 'Quarter to Date to Budget', 341, false, true, false, false, false, 'P', false, false, 'N', false, false, false, true, false, true, true);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (13, 7, 'QTD, Prior Quarter', 'Quarter to Date to Prior Quarter', 342, false, true, false, false, false, 'P', false, true, 'N', false, true, true, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (14, 7, 'YTD', 'Year To Date', 343, false, false, true, false, true, 'P', false, false, 'N', false, false, false, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (15, 7, 'YTD, Budget', 'Year to Date to Budget', 344, false, false, true, false, false, 'P', false, false, 'N', false, false, false, true, false, true, true);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (16, 7, 'YTD, Prior Full Year', 'Year to Date to Prior Full Year', 345, false, false, true, false, false, 'P', false, false, 'F', false, true, true, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (17, 7, 'Month, Prior Year Month', 'Current Month to Same Month Prior Year', 337, true, false, false, false, false, 'Y', true, false, 'N', false, true, true, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (19, 7, 'YTD, Prior Year YTD', 'Year to Date to Year to Date Prior Year', 345, false, false, true, false, false, 'P', false, false, 'D', false, true, true, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (20, 7, 'QTD', 'Quarter to Date', 340, false, true, false, false, true, 'P', false, false, 'N', false, false, false, false, false, false, false);
INSERT INTO flcol (flcol_id, flcol_flhead_id, flcol_name, flcol_descrip, flcol_report_id, flcol_month, flcol_quarter, flcol_year, flcol_showdb, flcol_prcnt, flcol_priortype, flcol_priormonth, flcol_priorquarter, flcol_prioryear, flcol_priorprcnt, flcol_priordiff, flcol_priordiffprcnt, flcol_budget, flcol_budgetprcnt, flcol_budgetdiff, flcol_budgetdiffprcnt) VALUES (18, 7, 'QTD, Prior Year Quarter', 'Quarter to Date to Same Quarter Prior Year', 342, false, true, false, false, false, 'Y', false, true, 'N', false, true, true, false, false, false, false);


ALTER TABLE flcol ENABLE TRIGGER ALL;

--
-- TOC entry 9557 (class 0 OID 0)
-- Dependencies: 583
-- Name: flcol_flcol_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('flcol_flcol_id_seq', 20, true);


--
-- TOC entry 9175 (class 0 OID 146610173)
-- Dependencies: 584 9464
-- Data for Name: flgrp; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE flgrp DISABLE TRIGGER ALL;

INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (2, 3, -1, 1, 'Revenue', 'Revenue', true, false, false, false, true, false, true, false, true, false, true, 3, true, true, true, true, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (3, 3, 2, 1, 'Sales', 'Sales', true, false, false, false, true, false, false, false, false, false, false, 3, true, true, true, true, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (4, 3, 2, 2, 'Cost of Goods Sold', 'Cost of Goods Sold', false, false, false, false, false, false, false, false, false, false, false, 3, false, false, false, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (5, 3, 2, 3, 'Gross Margin on Sales....................', 'Gross Margin on Sales....................', false, false, false, false, false, false, false, false, false, false, false, 3, false, false, false, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (6, 3, -1, 2, 'Expenses', 'Expenses', false, false, true, false, false, false, false, false, false, false, false, 3, false, false, false, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (7, 3, 6, 1, 'Expenses', 'Expenses', true, false, false, false, true, false, true, false, true, false, true, 3, true, true, true, true, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (8, 3, -1, 3, 'Net Income..............................', 'Net Income..............................', false, false, false, false, false, false, false, false, false, false, false, 3, false, false, false, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (9, 4, -1, 2, 'Liabilities and Owner''s Equity', 'Liabilities and Owner''s Equity', true, false, true, false, true, false, false, false, false, false, false, -1, false, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (10, 4, 9, 1, 'Liabilities', 'Liabilities', true, false, false, false, true, false, false, false, false, false, false, -1, false, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (11, 4, 10, 1, 'Current Liabilities', 'Current Liabilities', true, false, false, false, true, false, false, false, false, false, false, -1, false, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (12, 4, 10, 2, 'Long-Term Liabilities', 'Long-Term Liabilites', true, false, false, false, true, false, false, false, false, false, false, -1, false, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (13, 4, 9, 2, 'Owner''s Equity', 'Owner''s Equity', true, false, false, false, true, false, false, false, false, false, false, -1, false, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (14, 4, 13, 1, 'Shareholders'' Equity', 'Shareholders'' Equity', true, false, false, false, true, false, false, false, false, false, false, -1, false, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (15, 4, 13, 2, 'Profit / Loss', 'Profit / Loss', true, true, false, false, true, false, false, false, false, false, false, -1, false, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (16, 4, 13, 3, 'Retained Earnings', 'Retained Earnings', true, false, false, false, true, false, false, false, false, false, false, -1, false, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (17, 4, -1, 1, 'Assets', 'Assets', true, false, false, false, true, false, false, false, false, false, false, -1, false, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (18, 4, 17, 1, 'Current Assets', 'Current Assets', true, false, false, false, true, false, false, false, false, false, false, -1, false, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (19, 4, 17, 2, 'Fixed Assets', 'Fixed Assets', true, false, false, false, true, false, false, false, false, false, false, -1, false, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (20, 4, 17, 3, 'Other Assets', 'Other Assets', true, false, false, false, true, false, false, false, false, false, false, -1, false, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (21, 5, -1, 1, 'Cash Flows', 'Cash Flows', true, false, false, false, false, false, false, false, false, false, false, -1, true, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (22, 5, 21, 1, 'Cash Flows from Operating Activities', 'Cash Flows from Operating Activities', true, false, false, false, false, false, false, false, false, false, false, -1, true, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (23, 5, 22, 1, 'Cash Flows From Operating Activities', 'Cash Flows From Operating Activities', true, false, false, false, false, false, false, false, false, false, false, -1, true, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (24, 5, 23, 1, 'Net Income', 'Net Income', false, true, false, false, false, false, false, false, false, false, false, -1, true, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (25, 5, 22, 2, 'Charges Not Using Cash', 'Charges Not Using Cash', true, false, false, false, false, false, false, false, false, false, false, -1, true, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (26, 5, 22, 3, 'Change in Current Assets', 'Change in Current Assets', false, false, true, false, false, false, false, false, false, false, false, -1, false, false, false, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (27, 5, 22, 4, 'Short-Term Investments', 'Short-Term Investments', true, false, true, false, false, false, false, false, false, false, false, -1, true, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (28, 5, 22, 5, 'Net Receivables', 'Net Receivables', true, false, true, false, false, false, false, false, false, false, false, -1, true, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (29, 5, 22, 6, 'Inventory', 'Inventory', true, false, true, false, false, false, false, false, false, false, false, -1, true, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (30, 5, 22, 8, 'Change in Current Liabilities', 'Change in Current Liabilities', false, false, false, false, false, false, false, false, false, false, false, -1, false, false, false, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (31, 5, 22, 9, 'Accounts Payable', 'Accounts Payable', true, false, false, false, false, false, false, false, false, false, false, -1, true, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (32, 5, 22, 7, 'Prepaid Expenses', 'Prepaid Expenses', true, false, true, false, false, false, false, false, false, false, false, -1, true, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (33, 5, 22, 10, 'Notes Payable Current', 'Notes Payable Current', true, false, false, false, false, false, false, false, false, false, false, -1, true, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (34, 5, 22, 11, 'Current Maturities on Long-Term Debt', 'Current Maturities on Long-Term Debt', true, false, false, false, false, false, false, false, false, false, false, -1, true, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (35, 5, 22, 12, 'Taxes Payable', 'Tases Payable', true, false, false, false, false, false, false, false, false, false, false, -1, true, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (36, 5, 22, 13, 'Other Current Liabilities', 'Other Current Liabilities', true, false, true, false, false, false, false, false, false, false, false, -1, true, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (37, 5, 22, 14, 'Total Cash Flows from Operating Activities..........', 'Total Cash Flows from Operating Activities..........', false, false, false, false, false, false, false, false, false, false, false, -1, false, false, false, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (38, 5, 21, 2, 'Cash Flows from Investing Activities', 'Cash Flows from Investing Activities', true, false, true, false, false, false, false, false, false, false, false, -1, true, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (39, 5, 38, 1, 'Property, Plant, and Equipment', 'Property, Plant, and Equipment', true, false, false, false, false, false, false, false, false, false, false, -1, true, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (40, 5, 38, 2, 'Other Assets', 'Other Assets', true, false, false, false, false, false, false, false, false, false, false, -1, true, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (41, 5, 38, 3, 'Total Cash Flows from Investing Activities..........', 'Total Cash Flows from Investing Activities..........', false, false, false, false, false, false, false, false, false, false, false, -1, false, false, false, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (42, 5, 21, 3, 'Cash Flows from Financing Activities', 'Cash Flows from Financing Activities', true, false, false, false, false, false, false, false, false, false, false, -1, true, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (43, 5, 42, 1, 'Long-Term Debt', 'Long-Term Debt', true, false, false, false, false, false, false, false, false, false, false, -1, true, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (44, 5, 42, 2, 'Common Stock and Equity', 'Common Stock and Equity', true, false, false, false, false, false, false, false, false, false, false, -1, true, false, true, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (45, 5, 42, 3, 'Total Cash Flows from Financing Activities..........', 'Total Cash Flows from Financing Activities..........', false, false, false, false, false, false, false, false, false, false, false, -1, false, false, false, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (46, 5, -1, 2, 'Cash Position', 'Cash Position', false, false, false, false, false, false, false, false, false, false, false, -1, false, false, false, false, false, NULL);
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (47, 6, -1, 1, 'ASSETS', 'ASSETS', true, false, false, false, true, false, true, false, false, false, false, -1, false, false, false, false, true, 'Total Assets');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (48, 6, -1, 2, 'LIABILITIES AND OWNERS EQUITY', 'LIABILITIES AND OWNERS EQUITY', true, false, true, false, true, false, true, false, false, false, false, -1, false, false, false, false, true, 'Total Liabilities and Owners Equity');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (49, 6, 48, 1, 'LIABILITIES', 'LIABILITIES', true, false, false, false, true, false, true, false, true, false, true, -1, false, false, false, false, true, 'Total Liabilities');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (50, 6, 48, 2, 'OWNERS EQUITY', 'OWNERS EQUITY', true, false, false, false, true, false, true, false, true, false, true, -1, false, false, false, false, true, 'Total Owners Equity');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (51, 6, 50, 2, 'Net Income', '', false, true, false, false, true, false, true, false, true, false, true, -1, false, false, false, false, false, '');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (52, 7, -1, 1, 'INCOME', 'INCOME', true, false, false, false, false, false, true, false, false, false, false, -1, true, false, false, false, true, 'Net Income');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (53, 7, 52, 2, 'REVENUE', 'REVENUE', true, false, false, false, false, false, true, false, false, false, false, -1, true, false, false, false, true, 'Total Net Revenue');
INSERT INTO flgrp (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id, flgrp_order, flgrp_name, flgrp_descrip, flgrp_subtotal, flgrp_summarize, flgrp_subtract, flgrp_showstart, flgrp_showend, flgrp_showdelta, flgrp_showbudget, flgrp_showstartprcnt, flgrp_showendprcnt, flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_prcnt_flgrp_id, flgrp_showdiff, flgrp_showdiffprcnt, flgrp_showcustom, flgrp_showcustomprcnt, flgrp_usealtsubtotal, flgrp_altsubtotal) VALUES (54, 7, 52, 3, 'EXPENSES', 'EXPENSES', true, false, true, false, false, false, true, false, false, false, false, -1, true, false, false, false, true, 'Total Net Expenses');


ALTER TABLE flgrp ENABLE TRIGGER ALL;

--
-- TOC entry 9558 (class 0 OID 0)
-- Dependencies: 585
-- Name: flgrp_flgrp_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('flgrp_flgrp_id_seq', 54, true);


--
-- TOC entry 9171 (class 0 OID 146610118)
-- Dependencies: 579 9464
-- Data for Name: flhead; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE flhead DISABLE TRIGGER ALL;

INSERT INTO flhead (flhead_id, flhead_name, flhead_descrip, flhead_showtotal, flhead_showstart, flhead_showend, flhead_showdelta, flhead_showbudget, flhead_showdiff, flhead_showcustom, flhead_custom_label, flhead_usealttotal, flhead_alttotal, flhead_usealtbegin, flhead_altbegin, flhead_usealtend, flhead_altend, flhead_usealtdebits, flhead_altdebits, flhead_usealtcredits, flhead_altcredits, flhead_usealtbudget, flhead_altbudget, flhead_usealtdiff, flhead_altdiff, flhead_type, flhead_active, flhead_sys, flhead_notes) VALUES (3, 'Income Statement (OpenMFG)', 'Income Statement Template', true, true, true, false, true, true, true, 'Statement', false, NULL, false, NULL, false, NULL, false, NULL, false, NULL, false, NULL, false, NULL, 'A', true, false, '');
INSERT INTO flhead (flhead_id, flhead_name, flhead_descrip, flhead_showtotal, flhead_showstart, flhead_showend, flhead_showdelta, flhead_showbudget, flhead_showdiff, flhead_showcustom, flhead_custom_label, flhead_usealttotal, flhead_alttotal, flhead_usealtbegin, flhead_altbegin, flhead_usealtend, flhead_altend, flhead_usealtdebits, flhead_altdebits, flhead_usealtcredits, flhead_altcredits, flhead_usealtbudget, flhead_altbudget, flhead_usealtdiff, flhead_altdiff, flhead_type, flhead_active, flhead_sys, flhead_notes) VALUES (4, 'Balance Sheet (OpenMFG)', 'Balance Sheet Template', true, false, true, false, false, false, true, 'Statement', false, NULL, false, NULL, false, NULL, false, NULL, false, NULL, false, NULL, false, NULL, 'A', true, false, '');
INSERT INTO flhead (flhead_id, flhead_name, flhead_descrip, flhead_showtotal, flhead_showstart, flhead_showend, flhead_showdelta, flhead_showbudget, flhead_showdiff, flhead_showcustom, flhead_custom_label, flhead_usealttotal, flhead_alttotal, flhead_usealtbegin, flhead_altbegin, flhead_usealtend, flhead_altend, flhead_usealtdebits, flhead_altdebits, flhead_usealtcredits, flhead_altcredits, flhead_usealtbudget, flhead_altbudget, flhead_usealtdiff, flhead_altdiff, flhead_type, flhead_active, flhead_sys, flhead_notes) VALUES (5, 'Statement of Cash Flows (OpenMFG)', 'Statement of Cash Flows Template', true, false, false, false, false, true, true, 'Statement', false, NULL, false, NULL, false, NULL, false, NULL, false, NULL, false, NULL, false, NULL, 'A', true, false, '');
INSERT INTO flhead (flhead_id, flhead_name, flhead_descrip, flhead_showtotal, flhead_showstart, flhead_showend, flhead_showdelta, flhead_showbudget, flhead_showdiff, flhead_showcustom, flhead_custom_label, flhead_usealttotal, flhead_alttotal, flhead_usealtbegin, flhead_altbegin, flhead_usealtend, flhead_altend, flhead_usealtdebits, flhead_altdebits, flhead_usealtcredits, flhead_altcredits, flhead_usealtbudget, flhead_altbudget, flhead_usealtdiff, flhead_altdiff, flhead_type, flhead_active, flhead_sys, flhead_notes) VALUES (6, 'Basic Balance Sheet', 'Balance Sheet Template', false, false, false, false, false, false, false, NULL, false, NULL, false, NULL, false, NULL, false, NULL, false, NULL, false, NULL, false, NULL, 'B', true, true, '');
INSERT INTO flhead (flhead_id, flhead_name, flhead_descrip, flhead_showtotal, flhead_showstart, flhead_showend, flhead_showdelta, flhead_showbudget, flhead_showdiff, flhead_showcustom, flhead_custom_label, flhead_usealttotal, flhead_alttotal, flhead_usealtbegin, flhead_altbegin, flhead_usealtend, flhead_altend, flhead_usealtdebits, flhead_altdebits, flhead_usealtcredits, flhead_altcredits, flhead_usealtbudget, flhead_altbudget, flhead_usealtdiff, flhead_altdiff, flhead_type, flhead_active, flhead_sys, flhead_notes) VALUES (7, 'Basic Income Statement', 'Income Statement Template', false, false, false, false, false, false, false, '', false, '', false, '', false, '', false, '', false, '', false, '', false, '', 'I', true, true, '');


ALTER TABLE flhead ENABLE TRIGGER ALL;

--
-- TOC entry 9559 (class 0 OID 0)
-- Dependencies: 586
-- Name: flhead_flhead_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('flhead_flhead_id_seq', 7, true);


--
-- TOC entry 9172 (class 0 OID 146610143)
-- Dependencies: 580 9464
-- Data for Name: flitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE flitem DISABLE TRIGGER ALL;

INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (2, 6, 47, 1, -1, false, true, false, true, false, false, true, false, true, -1, true, false, false, false, 'S', 'All', 'All', 'All', 'All', 'A', 'All');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (3, 6, 49, 1, -1, false, true, false, true, false, false, true, false, true, -1, true, false, false, false, 'S', 'All', 'All', 'All', 'All', 'L', 'All');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (4, 6, 50, 1, -1, false, true, false, true, false, false, true, false, true, -1, true, false, false, false, 'S', 'All', 'All', 'All', 'All', 'Q', 'All');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (5, 6, 51, 1, -1, false, true, false, true, false, false, false, false, false, -1, true, false, false, false, 'S', 'All', 'All', 'All', 'All', 'R', 'All');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (6, 6, 51, 2, -1, false, true, false, true, true, false, false, false, false, -1, true, false, false, false, 'S', 'All', 'All', 'All', 'All', 'E', 'All');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (7, 7, 53, 1, -1, false, false, false, true, false, false, false, false, true, -1, true, true, false, false, 'S', 'All', 'All', 'All', 'All', 'R', 'All');
INSERT INTO flitem (flitem_id, flitem_flhead_id, flitem_flgrp_id, flitem_order, flitem_accnt_id, flitem_showstart, flitem_showend, flitem_showdelta, flitem_showbudget, flitem_subtract, flitem_showstartprcnt, flitem_showendprcnt, flitem_showdeltaprcnt, flitem_showbudgetprcnt, flitem_prcnt_flgrp_id, flitem_showdiff, flitem_showdiffprcnt, flitem_showcustom, flitem_showcustomprcnt, flitem_custom_source, flitem_company, flitem_profit, flitem_number, flitem_sub, flitem_type, flitem_subaccnttype_code) VALUES (8, 7, 54, 1, -1, false, false, false, true, false, false, false, false, true, -1, true, true, false, false, 'S', 'All', 'All', 'All', 'All', 'E', 'All');


ALTER TABLE flitem ENABLE TRIGGER ALL;

--
-- TOC entry 9560 (class 0 OID 0)
-- Dependencies: 587
-- Name: flitem_flitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('flitem_flitem_id_seq', 8, true);


--
-- TOC entry 9179 (class 0 OID 146610202)
-- Dependencies: 588 9171 8945 9464
-- Data for Name: flnotes; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE flnotes DISABLE TRIGGER ALL;



ALTER TABLE flnotes ENABLE TRIGGER ALL;

--
-- TOC entry 9561 (class 0 OID 0)
-- Dependencies: 589
-- Name: flnotes_flnotes_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('flnotes_flnotes_id_seq', 1, false);


--
-- TOC entry 9181 (class 0 OID 146610211)
-- Dependencies: 590 9464
-- Data for Name: flrpt; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE flrpt DISABLE TRIGGER ALL;



ALTER TABLE flrpt ENABLE TRIGGER ALL;

--
-- TOC entry 9562 (class 0 OID 0)
-- Dependencies: 591
-- Name: flrpt_flrpt_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('flrpt_flrpt_id_seq', 1, false);


--
-- TOC entry 9183 (class 0 OID 146610219)
-- Dependencies: 592 9464
-- Data for Name: flspec; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE flspec DISABLE TRIGGER ALL;



ALTER TABLE flspec ENABLE TRIGGER ALL;

--
-- TOC entry 9563 (class 0 OID 0)
-- Dependencies: 593
-- Name: flspec_flspec_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('flspec_flspec_id_seq', 1, false);


--
-- TOC entry 9185 (class 0 OID 146610241)
-- Dependencies: 594 9464
-- Data for Name: form; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE form DISABLE TRIGGER ALL;



ALTER TABLE form ENABLE TRIGGER ALL;

--
-- TOC entry 9564 (class 0 OID 0)
-- Dependencies: 595
-- Name: form_form_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('form_form_id_seq', 18, true);


--
-- TOC entry 9565 (class 0 OID 0)
-- Dependencies: 596
-- Name: freightclass_freightclass_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('freightclass_freightclass_id_seq', 1, false);


--
-- TOC entry 9188 (class 0 OID 146610253)
-- Dependencies: 597 9464
-- Data for Name: glseries; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE glseries DISABLE TRIGGER ALL;



ALTER TABLE glseries ENABLE TRIGGER ALL;

--
-- TOC entry 9566 (class 0 OID 0)
-- Dependencies: 598
-- Name: glseries_glseries_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('glseries_glseries_id_seq', 1563, true);


--
-- TOC entry 8980 (class 0 OID 146608963)
-- Dependencies: 340 9464
-- Data for Name: gltrans; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE gltrans DISABLE TRIGGER ALL;



ALTER TABLE gltrans ENABLE TRIGGER ALL;

--
-- TOC entry 9567 (class 0 OID 0)
-- Dependencies: 599
-- Name: gltrans_gltrans_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('gltrans_gltrans_id_seq', 7008, true);


--
-- TOC entry 9568 (class 0 OID 0)
-- Dependencies: 600
-- Name: gltrans_sequence_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('gltrans_sequence_seq', 3583, true);


--
-- TOC entry 9192 (class 0 OID 146610266)
-- Dependencies: 601 9464
-- Data for Name: grp; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE grp DISABLE TRIGGER ALL;



ALTER TABLE grp ENABLE TRIGGER ALL;

--
-- TOC entry 9569 (class 0 OID 0)
-- Dependencies: 602
-- Name: grp_grp_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('grp_grp_id_seq', 1, false);


--
-- TOC entry 9194 (class 0 OID 146610275)
-- Dependencies: 603 9192 9464
-- Data for Name: grppriv; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE grppriv DISABLE TRIGGER ALL;



ALTER TABLE grppriv ENABLE TRIGGER ALL;

--
-- TOC entry 9570 (class 0 OID 0)
-- Dependencies: 604
-- Name: grppriv_grppriv_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('grppriv_grppriv_id_seq', 1, false);


--
-- TOC entry 9196 (class 0 OID 146610280)
-- Dependencies: 605 9464
-- Data for Name: hnfc; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE hnfc DISABLE TRIGGER ALL;

INSERT INTO hnfc (hnfc_id, hnfc_code) VALUES (1, 'Dr');
INSERT INTO hnfc (hnfc_id, hnfc_code) VALUES (2, 'Miss');
INSERT INTO hnfc (hnfc_id, hnfc_code) VALUES (3, 'Mr');
INSERT INTO hnfc (hnfc_id, hnfc_code) VALUES (4, 'Mrs');
INSERT INTO hnfc (hnfc_id, hnfc_code) VALUES (5, 'Ms');


ALTER TABLE hnfc ENABLE TRIGGER ALL;

--
-- TOC entry 9571 (class 0 OID 0)
-- Dependencies: 606
-- Name: hnfc_hnfc_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('hnfc_hnfc_id_seq', 5, true);


--
-- TOC entry 9572 (class 0 OID 0)
-- Dependencies: 403
-- Name: image_image_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('image_image_id_seq', 6629, true);


--
-- TOC entry 8939 (class 0 OID 146608416)
-- Dependencies: 249 9464
-- Data for Name: imageass; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE imageass DISABLE TRIGGER ALL;



ALTER TABLE imageass ENABLE TRIGGER ALL;

--
-- TOC entry 8963 (class 0 OID 146608756)
-- Dependencies: 304 9464
-- Data for Name: incdtcat; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE incdtcat DISABLE TRIGGER ALL;



ALTER TABLE incdtcat ENABLE TRIGGER ALL;

--
-- TOC entry 8965 (class 0 OID 146608770)
-- Dependencies: 306 9464
-- Data for Name: incdtresolution; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE incdtresolution DISABLE TRIGGER ALL;

INSERT INTO incdtresolution (incdtresolution_id, incdtresolution_name, incdtresolution_order, incdtresolution_descrip) VALUES (1, 'Fixed', 0, NULL);
INSERT INTO incdtresolution (incdtresolution_id, incdtresolution_name, incdtresolution_order, incdtresolution_descrip) VALUES (2, 'Duplicate', 1, NULL);
INSERT INTO incdtresolution (incdtresolution_id, incdtresolution_name, incdtresolution_order, incdtresolution_descrip) VALUES (3, 'Not Fixable', 2, NULL);
INSERT INTO incdtresolution (incdtresolution_id, incdtresolution_name, incdtresolution_order, incdtresolution_descrip) VALUES (4, 'Won''t Fix', 3, NULL);


ALTER TABLE incdtresolution ENABLE TRIGGER ALL;

--
-- TOC entry 8966 (class 0 OID 146608777)
-- Dependencies: 307 9464
-- Data for Name: incdtseverity; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE incdtseverity DISABLE TRIGGER ALL;

INSERT INTO incdtseverity (incdtseverity_id, incdtseverity_name, incdtseverity_order, incdtseverity_descrip) VALUES (1, 'Trivial', 0, NULL);
INSERT INTO incdtseverity (incdtseverity_id, incdtseverity_name, incdtseverity_order, incdtseverity_descrip) VALUES (2, 'Minor', 1, NULL);
INSERT INTO incdtseverity (incdtseverity_id, incdtseverity_name, incdtseverity_order, incdtseverity_descrip) VALUES (3, 'Normal', 2, NULL);
INSERT INTO incdtseverity (incdtseverity_id, incdtseverity_name, incdtseverity_order, incdtseverity_descrip) VALUES (4, 'Severe', 3, NULL);
INSERT INTO incdtseverity (incdtseverity_id, incdtseverity_name, incdtseverity_order, incdtseverity_descrip) VALUES (5, 'Critical', 4, NULL);


ALTER TABLE incdtseverity ENABLE TRIGGER ALL;

--
-- TOC entry 8907 (class 0 OID 146607465)
-- Dependencies: 206 8912 8905 8906 8963 8964 8965 8966 8894 8922 9464
-- Data for Name: incdt; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE incdt DISABLE TRIGGER ALL;



ALTER TABLE incdt ENABLE TRIGGER ALL;

--
-- TOC entry 9573 (class 0 OID 0)
-- Dependencies: 607
-- Name: incdt_incdt_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('incdt_incdt_id_seq', 1, false);


--
-- TOC entry 9574 (class 0 OID 0)
-- Dependencies: 608
-- Name: incdtcat_incdtcat_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('incdtcat_incdtcat_id_seq', 1, false);


--
-- TOC entry 9200 (class 0 OID 146610293)
-- Dependencies: 609 8907 9464
-- Data for Name: incdthist; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE incdthist DISABLE TRIGGER ALL;



ALTER TABLE incdthist ENABLE TRIGGER ALL;

--
-- TOC entry 9575 (class 0 OID 0)
-- Dependencies: 610
-- Name: incdthist_incdthist_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('incdthist_incdthist_id_seq', 1, false);


--
-- TOC entry 9576 (class 0 OID 0)
-- Dependencies: 611
-- Name: incdtpriority_incdtpriority_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('incdtpriority_incdtpriority_id_seq', 5, true);


--
-- TOC entry 9577 (class 0 OID 0)
-- Dependencies: 612
-- Name: incdtresolution_incdtresolution_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('incdtresolution_incdtresolution_id_seq', 4, true);


--
-- TOC entry 9578 (class 0 OID 0)
-- Dependencies: 613
-- Name: incdtseverity_incdtseverity_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('incdtseverity_incdtseverity_id_seq', 5, true);


--
-- TOC entry 8903 (class 0 OID 146606747)
-- Dependencies: 202 8895 8945 9464
-- Data for Name: invbal; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE invbal DISABLE TRIGGER ALL;



ALTER TABLE invbal ENABLE TRIGGER ALL;

--
-- TOC entry 9579 (class 0 OID 0)
-- Dependencies: 614
-- Name: invbal_invbal_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('invbal_invbal_id_seq', 1, false);


--
-- TOC entry 9580 (class 0 OID 0)
-- Dependencies: 615
-- Name: invc_invc_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('invc_invc_id_seq', 1, false);


--
-- TOC entry 9581 (class 0 OID 0)
-- Dependencies: 616
-- Name: invchead_invchead_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('invchead_invchead_id_seq', 1, false);


--
-- TOC entry 9208 (class 0 OID 146610315)
-- Dependencies: 617 8990 8921 8990 8901 9464
-- Data for Name: invcheadtax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE invcheadtax DISABLE TRIGGER ALL;



ALTER TABLE invcheadtax ENABLE TRIGGER ALL;

--
-- TOC entry 9582 (class 0 OID 0)
-- Dependencies: 618
-- Name: invcitem_invcitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('invcitem_invcitem_id_seq', 1, false);


--
-- TOC entry 9210 (class 0 OID 146610323)
-- Dependencies: 619 8990 8925 8990 8901 9464
-- Data for Name: invcitemtax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE invcitemtax DISABLE TRIGGER ALL;



ALTER TABLE invcitemtax ENABLE TRIGGER ALL;

--
-- TOC entry 8893 (class 0 OID 146606343)
-- Dependencies: 190 9464
-- Data for Name: invcnt; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE invcnt DISABLE TRIGGER ALL;



ALTER TABLE invcnt ENABLE TRIGGER ALL;

--
-- TOC entry 9583 (class 0 OID 0)
-- Dependencies: 620
-- Name: invcnt_invcnt_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('invcnt_invcnt_id_seq', 213, true);


--
-- TOC entry 9212 (class 0 OID 146610331)
-- Dependencies: 621 9464
-- Data for Name: invdetail; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE invdetail DISABLE TRIGGER ALL;



ALTER TABLE invdetail ENABLE TRIGGER ALL;

--
-- TOC entry 9584 (class 0 OID 0)
-- Dependencies: 622
-- Name: invdetail_invdetail_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('invdetail_invdetail_id_seq', 1326, true);


--
-- TOC entry 9214 (class 0 OID 146610340)
-- Dependencies: 623 9464
-- Data for Name: invhist; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE invhist DISABLE TRIGGER ALL;



ALTER TABLE invhist ENABLE TRIGGER ALL;

--
-- TOC entry 9585 (class 0 OID 0)
-- Dependencies: 624
-- Name: invhist_invhist_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('invhist_invhist_id_seq', 2859, true);


--
-- TOC entry 9216 (class 0 OID 146610355)
-- Dependencies: 625 8988 9214 9464
-- Data for Name: invhistexpcat; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE invhistexpcat DISABLE TRIGGER ALL;



ALTER TABLE invhistexpcat ENABLE TRIGGER ALL;

--
-- TOC entry 9586 (class 0 OID 0)
-- Dependencies: 626
-- Name: invhistexpcat_invhistexpcat_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('invhistexpcat_invhistexpcat_id_seq', 1, false);


--
-- TOC entry 8962 (class 0 OID 146608737)
-- Dependencies: 301 8909 9464
-- Data for Name: ipshead; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE ipshead DISABLE TRIGGER ALL;



ALTER TABLE ipshead ENABLE TRIGGER ALL;

--
-- TOC entry 8983 (class 0 OID 146609004)
-- Dependencies: 347 8962 9464
-- Data for Name: ipsass; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE ipsass DISABLE TRIGGER ALL;



ALTER TABLE ipsass ENABLE TRIGGER ALL;

--
-- TOC entry 9587 (class 0 OID 0)
-- Dependencies: 628
-- Name: ipsass_ipsass_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('ipsass_ipsass_id_seq', 1, false);


--
-- TOC entry 9588 (class 0 OID 0)
-- Dependencies: 629
-- Name: ipsctyp_ipsctyp_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('ipsctyp_ipsctyp_id_seq', 16, true);


--
-- TOC entry 9589 (class 0 OID 0)
-- Dependencies: 630
-- Name: ipscust_ipscust_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('ipscust_ipscust_id_seq', 21, true);


--
-- TOC entry 8961 (class 0 OID 146608729)
-- Dependencies: 300 8960 8962 8924 8896 9464
-- Data for Name: ipsfreight; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE ipsfreight DISABLE TRIGGER ALL;



ALTER TABLE ipsfreight ENABLE TRIGGER ALL;

--
-- TOC entry 9590 (class 0 OID 0)
-- Dependencies: 631
-- Name: ipsfreight_ipsfreight_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('ipsfreight_ipsfreight_id_seq', 1, false);


--
-- TOC entry 9591 (class 0 OID 0)
-- Dependencies: 632
-- Name: ipshead_ipshead_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('ipshead_ipshead_id_seq', 58, true);


--
-- TOC entry 9592 (class 0 OID 0)
-- Dependencies: 633
-- Name: ipsitem_ipsitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('ipsitem_ipsitem_id_seq', 75, true);


--
-- TOC entry 8984 (class 0 OID 146609016)
-- Dependencies: 349 8962 8902 8902 8896 8894 9464
-- Data for Name: ipsiteminfo; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE ipsiteminfo DISABLE TRIGGER ALL;



ALTER TABLE ipsiteminfo ENABLE TRIGGER ALL;

--
-- TOC entry 8985 (class 0 OID 146609028)
-- Dependencies: 351 8930 8984 9464
-- Data for Name: ipsitemchar; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE ipsitemchar DISABLE TRIGGER ALL;



ALTER TABLE ipsitemchar ENABLE TRIGGER ALL;

--
-- TOC entry 9593 (class 0 OID 0)
-- Dependencies: 634
-- Name: ipsitemchar_ipsitemchar_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('ipsitemchar_ipsitemchar_id_seq', 1, false);


--
-- TOC entry 9225 (class 0 OID 146610384)
-- Dependencies: 636 9464
-- Data for Name: ipsprodcat_bak; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE ipsprodcat_bak DISABLE TRIGGER ALL;



ALTER TABLE ipsprodcat_bak ENABLE TRIGGER ALL;

--
-- TOC entry 9594 (class 0 OID 0)
-- Dependencies: 637
-- Name: ipsprodcat_ipsprodcat_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('ipsprodcat_ipsprodcat_id_seq', 1, false);


--
-- TOC entry 9595 (class 0 OID 0)
-- Dependencies: 638
-- Name: item_item_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('item_item_id_seq', 299, true);


--
-- TOC entry 8969 (class 0 OID 146608826)
-- Dependencies: 316 8906 8894 9464
-- Data for Name: itemalias; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE itemalias DISABLE TRIGGER ALL;



ALTER TABLE itemalias ENABLE TRIGGER ALL;

--
-- TOC entry 9596 (class 0 OID 0)
-- Dependencies: 639
-- Name: itemalias_itemalias_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('itemalias_itemalias_id_seq', 15, true);


--
-- TOC entry 9597 (class 0 OID 0)
-- Dependencies: 640
-- Name: itematr_itematr_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('itematr_itematr_id_seq', 29, true);


--
-- TOC entry 8971 (class 0 OID 146608854)
-- Dependencies: 321 8970 8909 8894 8909 9464
-- Data for Name: itemcost; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE itemcost DISABLE TRIGGER ALL;



ALTER TABLE itemcost ENABLE TRIGGER ALL;

--
-- TOC entry 9598 (class 0 OID 0)
-- Dependencies: 641
-- Name: itemcost_itemcost_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('itemcost_itemcost_id_seq', 299, true);


--
-- TOC entry 9599 (class 0 OID 0)
-- Dependencies: 642
-- Name: itemfrez_itemfrez_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('itemfrez_itemfrez_seq', 1, false);


--
-- TOC entry 9232 (class 0 OID 146610400)
-- Dependencies: 643 9464
-- Data for Name: itemgrp; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE itemgrp DISABLE TRIGGER ALL;



ALTER TABLE itemgrp ENABLE TRIGGER ALL;

--
-- TOC entry 9600 (class 0 OID 0)
-- Dependencies: 644
-- Name: itemgrp_itemgrp_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('itemgrp_itemgrp_id_seq', 19, true);


--
-- TOC entry 9234 (class 0 OID 146610411)
-- Dependencies: 645 9464
-- Data for Name: itemgrpitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE itemgrpitem DISABLE TRIGGER ALL;



ALTER TABLE itemgrpitem ENABLE TRIGGER ALL;

--
-- TOC entry 9601 (class 0 OID 0)
-- Dependencies: 646
-- Name: itemgrpitem_itemgrpitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('itemgrpitem_itemgrpitem_id_seq', 112, true);


--
-- TOC entry 9602 (class 0 OID 0)
-- Dependencies: 648
-- Name: itemimage_itemimage_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('itemimage_itemimage_id_seq', 20, true);


--
-- TOC entry 9237 (class 0 OID 146610425)
-- Dependencies: 649 9464
-- Data for Name: itemloc; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE itemloc DISABLE TRIGGER ALL;



ALTER TABLE itemloc ENABLE TRIGGER ALL;

--
-- TOC entry 9603 (class 0 OID 0)
-- Dependencies: 650
-- Name: itemloc_itemloc_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('itemloc_itemloc_id_seq', 511, true);


--
-- TOC entry 9604 (class 0 OID 0)
-- Dependencies: 651
-- Name: itemloc_series_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('itemloc_series_seq', 1022, true);


--
-- TOC entry 9240 (class 0 OID 146610433)
-- Dependencies: 652 9464
-- Data for Name: itemlocdist; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE itemlocdist DISABLE TRIGGER ALL;



ALTER TABLE itemlocdist ENABLE TRIGGER ALL;

--
-- TOC entry 9605 (class 0 OID 0)
-- Dependencies: 653
-- Name: itemlocdist_itemlocdist_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('itemlocdist_itemlocdist_id_seq', 2133, true);


--
-- TOC entry 9242 (class 0 OID 146610444)
-- Dependencies: 654 9464
-- Data for Name: itemlocpost; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE itemlocpost DISABLE TRIGGER ALL;



ALTER TABLE itemlocpost ENABLE TRIGGER ALL;

--
-- TOC entry 9606 (class 0 OID 0)
-- Dependencies: 655
-- Name: itemlocpost_itemlocpost_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('itemlocpost_itemlocpost_id_seq', 1, false);


--
-- TOC entry 9607 (class 0 OID 0)
-- Dependencies: 656
-- Name: itemopn_itemopn_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('itemopn_itemopn_id_seq', 39, true);


--
-- TOC entry 9608 (class 0 OID 0)
-- Dependencies: 657
-- Name: itemsite_itemsite_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('itemsite_itemsite_id_seq', 292, true);


--
-- TOC entry 8975 (class 0 OID 146608908)
-- Dependencies: 330 8974 8894 8911 9464
-- Data for Name: itemsrc; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE itemsrc DISABLE TRIGGER ALL;



ALTER TABLE itemsrc ENABLE TRIGGER ALL;

--
-- TOC entry 9609 (class 0 OID 0)
-- Dependencies: 658
-- Name: itemsrc_itemsrc_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('itemsrc_itemsrc_id_seq', 83, true);


--
-- TOC entry 8976 (class 0 OID 146608926)
-- Dependencies: 332 8975 8909 9464
-- Data for Name: itemsrcp; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE itemsrcp DISABLE TRIGGER ALL;



ALTER TABLE itemsrcp ENABLE TRIGGER ALL;

--
-- TOC entry 9610 (class 0 OID 0)
-- Dependencies: 659
-- Name: itemsrcp_itemsrcp_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('itemsrcp_itemsrcp_id_seq', 84, true);


--
-- TOC entry 8977 (class 0 OID 146608939)
-- Dependencies: 334 8894 8894 9464
-- Data for Name: itemsub; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE itemsub DISABLE TRIGGER ALL;



ALTER TABLE itemsub ENABLE TRIGGER ALL;

--
-- TOC entry 9611 (class 0 OID 0)
-- Dependencies: 660
-- Name: itemsub_itemsub_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('itemsub_itemsub_id_seq', 16, true);


--
-- TOC entry 8978 (class 0 OID 146608947)
-- Dependencies: 336 8894 8901 8919 9464
-- Data for Name: itemtax; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE itemtax DISABLE TRIGGER ALL;



ALTER TABLE itemtax ENABLE TRIGGER ALL;

--
-- TOC entry 9612 (class 0 OID 0)
-- Dependencies: 661
-- Name: itemtax_itemtax_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('itemtax_itemtax_id_seq', 1, false);


--
-- TOC entry 9250 (class 0 OID 146610461)
-- Dependencies: 662 8894 8894 9464
-- Data for Name: itemtrans; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE itemtrans DISABLE TRIGGER ALL;



ALTER TABLE itemtrans ENABLE TRIGGER ALL;

--
-- TOC entry 9613 (class 0 OID 0)
-- Dependencies: 663
-- Name: itemtrans_itemtrans_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('itemtrans_itemtrans_id_seq', 1, false);


--
-- TOC entry 8979 (class 0 OID 146608954)
-- Dependencies: 338 8902 8894 8902 9464
-- Data for Name: itemuomconv; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE itemuomconv DISABLE TRIGGER ALL;



ALTER TABLE itemuomconv ENABLE TRIGGER ALL;

--
-- TOC entry 9401 (class 0 OID 146611088)
-- Dependencies: 822 9464
-- Data for Name: uomtype; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE uomtype DISABLE TRIGGER ALL;

INSERT INTO uomtype (uomtype_id, uomtype_name, uomtype_descrip, uomtype_multiple) VALUES (1, 'Selling', 'Selling a.k.a. Pricing and Shipping UOMs.', true);
INSERT INTO uomtype (uomtype_id, uomtype_name, uomtype_descrip, uomtype_multiple) VALUES (2, 'Capacity', 'Capacity UOMs.', false);
INSERT INTO uomtype (uomtype_id, uomtype_name, uomtype_descrip, uomtype_multiple) VALUES (3, 'AltCapacity', 'Alternate Capacity UOMs.', false);
INSERT INTO uomtype (uomtype_id, uomtype_name, uomtype_descrip, uomtype_multiple) VALUES (4, 'MaterialIssue', 'Material Issuing UOMs.', false);


ALTER TABLE uomtype ENABLE TRIGGER ALL;

--
-- TOC entry 9252 (class 0 OID 146610466)
-- Dependencies: 664 8979 9401 9464
-- Data for Name: itemuom; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE itemuom DISABLE TRIGGER ALL;



ALTER TABLE itemuom ENABLE TRIGGER ALL;

--
-- TOC entry 9614 (class 0 OID 0)
-- Dependencies: 665
-- Name: itemuom_itemuom_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('itemuom_itemuom_id_seq', 1, false);


--
-- TOC entry 9615 (class 0 OID 0)
-- Dependencies: 666
-- Name: itemuomconv_itemuomconv_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('itemuomconv_itemuomconv_id_seq', 1, false);


--
-- TOC entry 9616 (class 0 OID 0)
-- Dependencies: 667
-- Name: journal_number_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('journal_number_seq', 2274, true);


--
-- TOC entry 9256 (class 0 OID 146610475)
-- Dependencies: 668 9464
-- Data for Name: jrnluse; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE jrnluse DISABLE TRIGGER ALL;



ALTER TABLE jrnluse ENABLE TRIGGER ALL;

--
-- TOC entry 9617 (class 0 OID 0)
-- Dependencies: 669
-- Name: jrnluse_jrnluse_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('jrnluse_jrnluse_id_seq', 280, true);


--
-- TOC entry 9258 (class 0 OID 146610484)
-- Dependencies: 670 9464
-- Data for Name: labeldef; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE labeldef DISABLE TRIGGER ALL;

INSERT INTO labeldef (labeldef_id, labeldef_name, labeldef_papersize, labeldef_columns, labeldef_rows, labeldef_width, labeldef_height, labeldef_start_offset_x, labeldef_start_offset_y, labeldef_horizontal_gap, labeldef_vertical_gap) VALUES (1, 'Avery 5263', 'Letter', 2, 5, 400, 200, 25, 50, 0, 0);
INSERT INTO labeldef (labeldef_id, labeldef_name, labeldef_papersize, labeldef_columns, labeldef_rows, labeldef_width, labeldef_height, labeldef_start_offset_x, labeldef_start_offset_y, labeldef_horizontal_gap, labeldef_vertical_gap) VALUES (2, 'Avery 5264', 'Letter', 2, 3, 400, 333, 25, 75, 0, 0);
INSERT INTO labeldef (labeldef_id, labeldef_name, labeldef_papersize, labeldef_columns, labeldef_rows, labeldef_width, labeldef_height, labeldef_start_offset_x, labeldef_start_offset_y, labeldef_horizontal_gap, labeldef_vertical_gap) VALUES (3, 'Avery 8460', 'Letter', 3, 10, 262, 100, 32, 50, 0, 0);
INSERT INTO labeldef (labeldef_id, labeldef_name, labeldef_papersize, labeldef_columns, labeldef_rows, labeldef_width, labeldef_height, labeldef_start_offset_x, labeldef_start_offset_y, labeldef_horizontal_gap, labeldef_vertical_gap) VALUES (4, 'CILS ALP1-9200-1', 'Letter', 3, 7, 200, 100, 62, 62, 81, 50);


ALTER TABLE labeldef ENABLE TRIGGER ALL;

--
-- TOC entry 9618 (class 0 OID 0)
-- Dependencies: 671
-- Name: labeldef_labeldef_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('labeldef_labeldef_id_seq', 4, true);


--
-- TOC entry 9260 (class 0 OID 146610492)
-- Dependencies: 672 9464
-- Data for Name: labelform; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE labelform DISABLE TRIGGER ALL;



ALTER TABLE labelform ENABLE TRIGGER ALL;

--
-- TOC entry 9619 (class 0 OID 0)
-- Dependencies: 673
-- Name: labelform_labelform_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('labelform_labelform_id_seq', 6, true);


--
-- TOC entry 9262 (class 0 OID 146610502)
-- Dependencies: 674 9464
-- Data for Name: lang; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE lang DISABLE TRIGGER ALL;

INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (1, 3, NULL, NULL, 'Afan');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (2, 156, NULL, NULL, 'Atsam');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (3, 16, NULL, NULL, 'Bhutani');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (4, 22, NULL, NULL, 'Byelorussian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (5, 23, NULL, NULL, 'Cambodian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (6, 158, NULL, NULL, 'Jju');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (7, 154, NULL, NULL, 'Koro');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (8, 68, NULL, NULL, 'Kurundi');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (9, 69, NULL, NULL, 'Laothian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (10, 101, NULL, NULL, 'SerboCroatian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (11, 102, NULL, NULL, 'Sesotho');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (12, 103, NULL, NULL, 'Setswana');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (13, 107, NULL, NULL, 'Siswati');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (14, 164, NULL, NULL, 'Tyap');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (15, NULL, 'ace', NULL, 'Achinese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (16, NULL, 'ach', NULL, 'Acoli');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (17, NULL, 'ada', NULL, 'Adangme');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (18, NULL, 'ady', NULL, 'Adyghe; Adygei');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (19, NULL, 'afa', NULL, 'Afro-Asiatic.(Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (20, NULL, 'afh', NULL, 'Afrihili');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (21, NULL, 'ain', NULL, 'Ainu');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (22, NULL, 'akk', NULL, 'Akkadian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (23, NULL, 'ale', NULL, 'Aleut');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (24, NULL, 'alg', NULL, 'Algonquian languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (25, NULL, 'alt', NULL, 'Southern Altai');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (26, NULL, 'ang', NULL, 'English, Old (ca.450-1100)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (27, NULL, 'anp', NULL, 'Angika');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (28, NULL, 'apa', NULL, 'Apache languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (29, NULL, 'arc', NULL, 'Official Aramaic (700-300 BCE); Imperial Aramaic (700-300 BCE)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (30, NULL, 'arn', NULL, 'Mapudungun; Mapuche');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (31, NULL, 'arp', NULL, 'Arapaho');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (32, NULL, 'art', NULL, 'Artificial (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (33, NULL, 'arw', NULL, 'Arawak');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (34, NULL, 'ast', NULL, 'Asturian; Bable; Leonese; Asturleonese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (35, NULL, 'ath', NULL, 'Athapascan languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (36, NULL, 'aus', NULL, 'Australian languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (37, NULL, 'awa', NULL, 'Awadhi');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (38, NULL, 'bad', NULL, 'Banda languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (39, NULL, 'bai', NULL, 'Bamileke languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (40, NULL, 'bal', NULL, 'Baluchi');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (41, NULL, 'ban', NULL, 'Balinese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (42, NULL, 'bas', NULL, 'Basa');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (43, NULL, 'bat', NULL, 'Baltic (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (44, NULL, 'bej', NULL, 'Beja; Bedawiyet');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (45, NULL, 'bem', NULL, 'Bemba');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (46, NULL, 'ber', NULL, 'Berber (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (47, NULL, 'bho', NULL, 'Bhojpuri');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (48, NULL, 'bik', NULL, 'Bikol');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (49, NULL, 'bin', NULL, 'Bini; Edo');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (50, NULL, 'bla', NULL, 'Siksika');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (51, NULL, 'bnt', NULL, 'Bantu (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (52, NULL, 'bra', NULL, 'Braj');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (53, NULL, 'btk', NULL, 'Batak languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (54, NULL, 'bua', NULL, 'Buriat');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (55, NULL, 'bug', NULL, 'Buginese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (56, 152, 'byn', NULL, 'Blin; Bilin');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (57, NULL, 'cad', NULL, 'Caddo');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (58, NULL, 'cai', NULL, 'Central American Indian (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (59, NULL, 'car', NULL, 'Galibi Carib');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (60, NULL, 'cau', NULL, 'Caucasian (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (61, NULL, 'ceb', NULL, 'Cebuano');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (62, NULL, 'cel', NULL, 'Celtic (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (63, NULL, 'chb', NULL, 'Chibcha');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (64, NULL, 'chg', NULL, 'Chagatai');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (65, NULL, 'chk', NULL, 'Chuukese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (66, NULL, 'chm', NULL, 'Mari');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (67, NULL, 'chn', NULL, 'Chinook jargon');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (68, NULL, 'cho', NULL, 'Choctaw');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (69, NULL, 'chp', NULL, 'Chipewyan; Dene Suline');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (70, NULL, 'chr', NULL, 'Cherokee');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (71, NULL, 'chy', NULL, 'Cheyenne');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (72, NULL, 'cmc', NULL, 'Chamic languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (73, NULL, 'cop', NULL, 'Coptic');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (74, NULL, 'cpe', NULL, 'Creoles and pidgins, English-based (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (75, NULL, 'cpf', NULL, 'Creoles and pidgins, French-based (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (76, NULL, 'cpp', NULL, 'Creoles and pidgins, Portuguese-based (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (77, NULL, 'crh', NULL, 'Crimean Tatar; Crimean Turkish');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (78, NULL, 'crp', NULL, 'Creoles and pidgins (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (79, NULL, 'csb', NULL, 'Kashubian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (80, NULL, 'cus', NULL, 'Cushitic (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (81, NULL, 'dak', NULL, 'Dakota');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (82, NULL, 'dar', NULL, 'Dargwa');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (83, NULL, 'day', NULL, 'Land Dayak languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (84, NULL, 'del', NULL, 'Delaware');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (85, NULL, 'den', NULL, 'Slave (Athapascan)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (86, NULL, 'dgr', NULL, 'Dogrib');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (87, NULL, 'din', NULL, 'Dinka');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (88, NULL, 'doi', NULL, 'Dogri');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (89, NULL, 'dra', NULL, 'Dravidian (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (90, NULL, 'dsb', NULL, 'Lower Sorbian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (91, NULL, 'dua', NULL, 'Duala');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (92, NULL, 'dum', NULL, 'Dutch, Middle (ca.1050-1350)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (93, NULL, 'dyu', NULL, 'Dyula');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (94, NULL, 'efi', NULL, 'Efik');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (95, NULL, 'egy', NULL, 'Egyptian (Ancient)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (96, NULL, 'eka', NULL, 'Ekajuk');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (97, NULL, 'elx', NULL, 'Elamite');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (98, NULL, 'enm', NULL, 'English, Middle (1100-1500)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (99, NULL, 'ewo', NULL, 'Ewondo');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (100, NULL, 'fan', NULL, 'Fang');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (101, NULL, 'fat', NULL, 'Fanti');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (102, NULL, 'fil', NULL, 'Filipino; Pilipino');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (103, NULL, 'fiu', NULL, 'Finno-Ugrian (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (104, NULL, 'fon', NULL, 'Fon');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (105, NULL, 'frm', NULL, 'French, Middle (ca.1400-1600)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (106, NULL, 'fro', NULL, 'French, Old (842-ca.1400)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (107, 38, 'frr', NULL, 'Northern Frisian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (108, 38, 'frs', NULL, 'Eastern Frisian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (109, 159, 'fur', NULL, 'Friulian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (110, 148, 'gaa', NULL, 'Ga');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (111, NULL, 'gay', NULL, 'Gayo');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (112, NULL, 'gba', NULL, 'Gbaya');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (113, NULL, 'gem', NULL, 'Germanic (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (114, 153, 'gez', NULL, 'Geez');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (115, NULL, 'gil', NULL, 'Gilbertese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (116, NULL, 'gmh', NULL, 'German, Middle High (ca.1050-1500)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (117, NULL, 'goh', NULL, 'German, Old High (ca.750-1050)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (118, NULL, 'gon', NULL, 'Gondi');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (119, NULL, 'gor', NULL, 'Gorontalo');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (120, NULL, 'got', NULL, 'Gothic');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (121, NULL, 'grb', NULL, 'Grebo');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (122, NULL, 'grc', NULL, 'Greek, Ancient (to 1453)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (123, NULL, 'gsw', NULL, 'Swiss German; Alemannic; Alsatian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (124, NULL, 'gwi', NULL, 'Gwich''in');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (125, NULL, 'hai', NULL, 'Haida');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (126, 163, 'haw', NULL, 'Hawaiian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (127, NULL, 'hil', NULL, 'Hiligaynon');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (128, NULL, 'him', NULL, 'Himachali');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (129, NULL, 'hit', NULL, 'Hittite');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (130, NULL, 'hmn', NULL, 'Hmong');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (131, NULL, 'hsb', NULL, 'Upper Sorbian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (132, NULL, 'hup', NULL, 'Hupa hupa');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (133, NULL, 'iba', NULL, 'Iban');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (134, NULL, 'ijo', NULL, 'Ijo languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (135, NULL, 'ilo', NULL, 'Iloko');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (136, NULL, 'inc', NULL, 'Indic (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (137, NULL, 'ine', NULL, 'Indo-European (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (138, NULL, 'inh', NULL, 'Ingush');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (139, NULL, 'ira', NULL, 'Iranian (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (140, NULL, 'iro', NULL, 'Iroquoian languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (141, NULL, 'jbo', NULL, 'Lojban');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (142, NULL, 'jpr', NULL, 'Judeo-Persian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (143, NULL, 'jrb', NULL, 'Judeo-Arabic');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (144, NULL, 'kaa', NULL, 'Kara-Kalpak');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (145, NULL, 'kab', NULL, 'Kabyle');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (146, NULL, 'kac', NULL, 'Kachin; Jingpho');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (147, 150, 'kam', NULL, 'Kamba');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (148, NULL, 'kar', NULL, 'Karen languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (149, NULL, 'kaw', NULL, 'Kawi');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (150, NULL, 'kbd', NULL, 'Kabardian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (151, NULL, 'kha', NULL, 'Khasi');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (152, NULL, 'khi', NULL, 'Khoisan (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (153, NULL, 'kho', NULL, 'Khotanese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (154, NULL, 'kmb', NULL, 'Kimbundu');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (155, 147, 'kok', NULL, 'Konkani');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (156, NULL, 'kos', NULL, 'Kosraean');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (157, NULL, 'kpe', NULL, 'Kpelle');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (158, NULL, 'krc', NULL, 'Karachay-Balkar');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (159, NULL, 'krl', NULL, 'Karelian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (160, NULL, 'kro', NULL, 'Kru languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (161, NULL, 'kru', NULL, 'Kurukh');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (162, NULL, 'kum', NULL, 'Kumyk');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (163, NULL, 'kut', NULL, 'Kutenai');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (164, NULL, 'lad', NULL, 'Ladino');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (165, NULL, 'lah', NULL, 'Lahnda');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (166, NULL, 'lam', NULL, 'Lamba');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (167, NULL, 'lez', NULL, 'Lezghian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (168, NULL, 'lol', NULL, 'Mongo');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (169, NULL, 'loz', NULL, 'Lozi');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (170, NULL, 'lua', NULL, 'Luba-Lulua');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (171, NULL, 'lui', NULL, 'Luiseno');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (172, NULL, 'lun', NULL, 'Lunda');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (173, NULL, 'luo', NULL, 'Luo (Kenya and Tanzania)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (174, NULL, 'lus', NULL, 'Lushai');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (175, NULL, 'mad', NULL, 'Madurese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (176, NULL, 'mag', NULL, 'Magahi');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (177, NULL, 'mai', NULL, 'Maithili');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (178, NULL, 'mak', NULL, 'Makasar');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (179, NULL, 'man', NULL, 'Mandingo');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (180, NULL, 'map', NULL, 'Austronesian (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (181, NULL, 'mas', NULL, 'Masai');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (182, NULL, 'mdf', NULL, 'Moksha');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (183, NULL, 'mdr', NULL, 'Mandar');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (184, NULL, 'men', NULL, 'Mende');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (185, NULL, 'mga', NULL, 'Irish, Middle (900-1200)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (186, NULL, 'mic', NULL, 'Mi''kmaq; Micmac');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (187, NULL, 'min', NULL, 'Minangkabau');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (188, NULL, 'mis', NULL, 'Uncoded languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (189, NULL, 'mkh', NULL, 'Mon-Khmer (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (190, NULL, 'mnc', NULL, 'Manchu');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (191, NULL, 'mni', NULL, 'Manipuri');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (192, NULL, 'mno', NULL, 'Manobo languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (193, NULL, 'moh', NULL, 'Mohawk');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (194, NULL, 'mos', NULL, 'Mossi');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (195, NULL, 'mul', NULL, 'Multiple languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (196, NULL, 'mun', NULL, 'Munda languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (197, NULL, 'mus', NULL, 'Creek');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (198, NULL, 'mwl', NULL, 'Mirandese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (199, NULL, 'mwr', NULL, 'Marwari');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (200, NULL, 'myn', NULL, 'Mayan languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (201, NULL, 'myv', NULL, 'Erzya');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (202, NULL, 'nah', NULL, 'Nahuatl languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (203, NULL, 'nai', NULL, 'North American Indian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (204, NULL, 'nap', NULL, 'Neapolitan');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (205, NULL, 'nds', NULL, 'Low German; Low Saxon; German, Low; Saxon, Low');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (206, NULL, 'new', NULL, 'Nepal Bhasa; Newari');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (207, NULL, 'nia', NULL, 'Nias');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (208, NULL, 'nic', NULL, 'Niger-Kordofanian (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (209, NULL, 'niu', NULL, 'Niuean');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (210, NULL, 'nog', NULL, 'Nogai');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (211, NULL, 'non', NULL, 'Norse, Old');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (212, NULL, 'nqo', NULL, 'N''Ko');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (213, NULL, 'nso', NULL, 'Pedi; Sepedi; Northern Sotho');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (214, NULL, 'nub', NULL, 'Nubian languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (215, NULL, 'nwc', NULL, 'Classical Newari; Old Newari; Classical Nepal Bhasa');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (216, NULL, 'nym', NULL, 'Nyamwezi');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (217, NULL, 'nyn', NULL, 'Nyankole');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (218, NULL, 'nyo', NULL, 'Nyoro');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (219, NULL, 'nzi', NULL, 'Nzima');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (220, NULL, 'osa', NULL, 'Osage');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (221, NULL, 'ota', NULL, 'Turkish, Ottoman (1500-1928)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (222, NULL, 'oto', NULL, 'Otomian languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (223, NULL, 'paa', NULL, 'Papuan (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (224, NULL, 'pag', NULL, 'Pangasinan');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (225, NULL, 'pal', NULL, 'Pahlavi');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (226, NULL, 'pam', NULL, 'Pampanga; Kapampangan');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (227, NULL, 'pap', NULL, 'Papiamento');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (228, NULL, 'pau', NULL, 'Palauan');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (229, NULL, 'peo', NULL, 'Persian, Old (ca.600-400 B.C.)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (230, NULL, 'phi', NULL, 'Philippine (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (231, NULL, 'phn', NULL, 'Phoenician');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (232, NULL, 'pon', NULL, 'Pohnpeian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (233, NULL, 'pra', NULL, 'Prakrit languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (234, NULL, 'pro', NULL, 'Provencal, Old (to 1500)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (235, NULL, 'raj', NULL, 'Rajasthani');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (236, NULL, 'rap', NULL, 'Rapanui');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (237, NULL, 'rar', NULL, 'Rarotongan; Cook Islands Maori');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (238, NULL, 'roa', NULL, 'Romance (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (239, NULL, 'rom', NULL, 'Romany');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (240, NULL, 'rup', NULL, 'Aromanian; Arumanian; Macedo-Romanian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (241, NULL, 'sad', NULL, 'Sandawe');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (242, NULL, 'sah', NULL, 'Yakut');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (243, NULL, 'sai', NULL, 'South American Indian (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (244, NULL, 'sal', NULL, 'Salishan languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (245, NULL, 'sam', NULL, 'Samaritan Aramaic');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (246, NULL, 'sas', NULL, 'Sasak');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (247, NULL, 'sat', NULL, 'Santali');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (248, NULL, 'scn', NULL, 'Sicilian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (249, NULL, 'sco', NULL, 'Scots');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (250, NULL, 'sel', NULL, 'Selkup');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (251, NULL, 'sem', NULL, 'Semitic (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (252, NULL, 'sga', NULL, 'Irish, Old (to 900)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (253, NULL, 'sgn', NULL, 'Sign languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (254, NULL, 'shn', NULL, 'Shan');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (255, 155, 'sid', NULL, 'Sidamo');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (256, NULL, 'sio', NULL, 'Siouan languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (257, NULL, 'sit', NULL, 'Sino-Tibetan (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (258, NULL, 'sla', NULL, 'Slavic (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (259, NULL, 'sma', NULL, 'Southern Sami');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (260, NULL, 'smi', NULL, 'Sami languages (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (261, NULL, 'smj', NULL, 'Lule Sami');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (262, NULL, 'smn', NULL, 'Inari Sami');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (263, NULL, 'sms', NULL, 'Skolt Sami');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (264, NULL, 'snk', NULL, 'Soninke');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (265, NULL, 'sog', NULL, 'Sogdian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (266, NULL, 'son', NULL, 'Songhai languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (267, NULL, 'srn', NULL, 'Sranan Tongo');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (268, NULL, 'srr', NULL, 'Serer');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (269, NULL, 'ssa', NULL, 'Nilo-Saharan (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (270, NULL, 'suk', NULL, 'Sukuma');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (271, NULL, 'sus', NULL, 'Susu');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (272, NULL, 'sux', NULL, 'Sumerian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (273, NULL, 'syc', NULL, 'Classical Syriac');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (274, 151, 'syr', NULL, 'Syriac');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (275, NULL, 'tai', NULL, 'Tai (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (276, NULL, 'tem', NULL, 'Timne');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (277, NULL, 'ter', NULL, 'Tereno');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (278, NULL, 'tet', NULL, 'Tetum');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (279, 157, 'tig', NULL, 'Tigre');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (280, NULL, 'tiv', NULL, 'Tiv');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (281, NULL, 'tkl', NULL, 'Tokelau');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (282, NULL, 'tlh', NULL, 'Klingon');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (283, NULL, 'tli', NULL, 'Tlingit');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (284, NULL, 'tmh', NULL, 'Tamashek');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (285, NULL, 'tog', NULL, 'Tonga (Nyasa)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (286, NULL, 'tpi', NULL, 'Tok Pisin');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (287, NULL, 'tsi', NULL, 'Tsimshian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (288, NULL, 'tum', NULL, 'Tumbuka');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (289, NULL, 'tup', NULL, 'Tupi languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (290, NULL, 'tut', NULL, 'Altaic (Other)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (291, NULL, 'tvl', NULL, 'Tuvalu');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (292, NULL, 'tyv', NULL, 'Tuvinian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (293, NULL, 'udm', NULL, 'Udmurt');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (294, NULL, 'uga', NULL, 'Ugaritic');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (295, NULL, 'umb', NULL, 'Umbundu');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (296, NULL, 'und', NULL, 'Undetermined');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (297, NULL, 'vai', NULL, 'Vai');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (298, NULL, 'vot', NULL, 'Votic');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (299, NULL, 'wak', NULL, 'Wakashan languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (300, 162, 'wal', NULL, 'Walamo');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (301, NULL, 'war', NULL, 'Waray');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (302, NULL, 'was', NULL, 'Washo');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (303, NULL, 'wen', NULL, 'Sorbian languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (304, NULL, 'xal', NULL, 'Kalmyk; Oirat');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (305, NULL, 'yao', NULL, 'Yao');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (306, NULL, 'yap', NULL, 'Yapese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (307, NULL, 'ypk', NULL, 'Yupik languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (308, NULL, 'zap', NULL, 'Zapotec');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (309, NULL, 'zbl', NULL, 'Blissymbols; Blissymbolics; Bliss');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (310, NULL, 'zen', NULL, 'Zenaga');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (311, NULL, 'znd', NULL, 'Zande languages');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (312, NULL, 'zun', NULL, 'Zuni');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (313, NULL, 'zxx', NULL, 'No linguistic content');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (314, NULL, 'zza', NULL, 'Zaza; Dimili; Dimli; Kirdki; Kirmanjki; Zazaki');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (315, 4, 'aar', 'aa', 'Afar');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (316, 2, 'abk', 'ab', 'Abkhazian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (317, NULL, 'ave', 'ae', 'Avestan');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (318, 5, 'afr', 'af', 'Afrikaans');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (319, 146, 'aka', 'ak', 'Akan');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (320, 7, 'amh', 'am', 'Amharic');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (321, NULL, 'arg', 'an', 'Aragonese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (322, 8, 'ara', 'ar', 'Arabic');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (323, 10, 'asm', 'as', 'Assamese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (324, NULL, 'ava', 'av', 'Avaric');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (325, 11, 'aym', 'ay', 'Aymara');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (326, 12, 'aze', 'az', 'Azerbaijani');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (327, 13, 'bak', 'ba', 'Bashkir');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (328, NULL, 'bel', 'be', 'Belarusian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (329, 20, 'bul', 'bg', 'Bulgarian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (330, 17, 'bih', 'bh', 'Bihari');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (331, 18, 'bis', 'bi', 'Bislama');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (332, NULL, 'bam', 'bm', 'Bambara');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (333, 15, 'ben', 'bn', 'Bengali');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (334, 121, 'bod', 'bo', 'Tibetan');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (335, 19, 'bre', 'br', 'Breton');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (336, 142, 'bos', 'bs', 'Bosnian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (337, 24, 'cat', 'ca', 'Catalan; Valencian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (338, NULL, 'che', 'ce', 'Chechen');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (339, NULL, 'cha', 'ch', 'Chamorro');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (340, 26, 'cos', 'co', 'Corsican');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (341, NULL, 'cre', 'cr', 'Cree');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (342, 28, 'ces', 'cs', 'Czech');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (343, NULL, 'chu', 'cu', 'Church Slavic; Old Slavonic; Church Slavonic; Old Bulgarian; Old Church Slavonic');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (344, NULL, 'chv', 'cv', 'Chuvash');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (345, 134, 'cym', 'cy', 'Welsh');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (346, 29, 'dan', 'da', 'Danish');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (347, 42, 'deu', 'de', 'German');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (348, 143, 'div', 'dv', 'Divehi; Dhivehi; Maldivian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (349, NULL, 'dzo', 'dz', 'Dzongkha');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (350, 161, 'ewe', 'ee', 'Ewe');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (351, 42, 'ell', 'el', 'Greek, Modern (1453-)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (352, 31, 'eng', 'en', 'English');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (353, 32, 'epo', 'eo', 'Esperanto');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (354, 111, 'spa', 'es', 'Spanish; Castilian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (355, 33, 'est', 'et', 'Estonian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (356, 14, 'eus', 'eu', 'Basque');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (357, 89, 'fas', 'fa', 'Persian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (358, NULL, 'ful', 'ff', 'Fulah');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (359, 36, 'fin', 'fi', 'Finnish');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (360, 35, 'fij', 'fj', 'Fijian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (361, 34, 'fao', 'fo', 'Faroese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (362, 37, 'fra', 'fr', 'French');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (363, 38, 'fry', 'fy', 'Western Frisian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (364, 57, 'gle', 'ga', 'Irish');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (365, 39, 'gla', 'gd', 'Gaelic; Scottish Gaelic');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (366, 40, 'glg', 'gl', 'Galician');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (367, 45, 'grn', 'gn', 'Guarani');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (368, 46, 'guj', 'gu', 'Gujarati');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (369, 144, 'glv', 'gv', 'Manx');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (370, 47, 'hau', 'ha', 'Hausa');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (371, 48, 'heb', 'he', 'Hebrew');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (372, 49, 'hin', 'hi', 'Hindi');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (373, NULL, 'hmo', 'ho', 'Hiri Motu');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (374, 27, 'hrv', 'hr', 'Croatian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (375, NULL, 'hat', 'ht', 'Haitian; Haitian Creole');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (376, 50, 'hun', 'hu', 'Hungarian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (377, 9, 'hye', 'hy', 'Armenian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (378, NULL, 'her', 'hz', 'Herero');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (379, 53, 'ina', 'ia', 'Interlingua (International Auxiliary language Association)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (380, 52, 'ind', 'id', 'Indonesian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (381, 54, 'ile', 'ie', 'Interlingue; Occidental');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (382, 149, 'ibo', 'ig', 'Igbo');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (383, NULL, 'iii', 'ii', 'Sichuan Yi; Nuosu');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (384, 56, 'ipk', 'ik', 'Inupiaq');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (385, NULL, 'ido', 'io', 'Ido');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (386, 51, 'isl', 'is', 'Icelandic');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (387, 58, 'ita', 'it', 'Italian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (388, 55, 'iku', 'iu', 'Inuktitut');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (389, 59, 'jpn', 'ja', 'Japanese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (390, 60, 'jav', 'jv', 'Javanese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (391, 41, 'kat', 'ka', 'Georgian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (392, NULL, 'kon', 'kg', 'Kongo');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (393, NULL, 'kik', 'ki', 'Kikuyu; Gikuyu');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (394, NULL, 'kua', 'kj', 'Kuanyama; Kwanyama');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (395, 63, 'kaz', 'kk', 'Kazakh');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (396, 44, 'kal', 'kl', 'Kalaallisut; Greenlandic');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (397, NULL, 'khm', 'km', 'Central Khmer');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (398, 61, 'kan', 'kn', 'Kannada');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (399, 66, 'kor', 'ko', 'Korean');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (400, NULL, 'kau', 'kr', 'Kanuri');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (401, 62, 'kas', 'ks', 'Kashmiri');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (402, 67, 'kur', 'ku', 'Kurdish');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (403, NULL, 'kom', 'kv', 'Komi');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (404, 145, 'cor', 'kw', 'Cornish');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (405, 65, 'kir', 'ky', 'Kirghiz; Kyrgyz');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (406, 70, 'lat', 'la', 'Latin');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (407, NULL, 'ltz', 'lb', 'Luxembourgish; Letzeburgesch');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (408, NULL, 'lug', 'lg', 'Ganda');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (409, NULL, 'lim', 'li', 'Limburgan; Limburger; Limburgish');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (410, 72, 'lin', 'ln', 'Lingala');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (411, NULL, 'lao', 'lo', 'Lao');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (412, 73, 'lit', 'lt', 'Lithuanian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (413, NULL, 'lub', 'lu', 'Luba-Katanga');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (414, 71, 'lav', 'lv', 'Latvian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (415, 75, 'mlg', 'mg', 'Malagasy');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (416, NULL, 'mah', 'mh', 'Marshallese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (417, 79, 'mri', 'mi', 'Maori');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (418, 74, 'mkd', 'mk', 'Macedonian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (419, 77, 'mal', 'ml', 'Malayalam');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (420, 82, 'mon', 'mn', 'Mongolian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (421, 81, 'mol', 'mo', 'Moldavian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (422, 80, 'mar', 'mr', 'Marathi');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (423, 76, 'msa', 'ms', 'Malay');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (424, 78, 'mlt', 'mt', 'Maltese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (425, 21, 'mya', 'my', 'Burmese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (426, 83, 'nau', 'na', 'Nauru');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (427, 85, 'nob', 'nb', 'Bokmal, Norwegian; Norwegian Bokmal');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (428, NULL, 'nde', 'nd', 'Ndebele, North; North Ndebele');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (429, 84, 'nep', 'ne', 'Nepali');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (430, NULL, 'ndo', 'ng', 'Ndonga');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (431, 30, 'nld', 'nl', 'Dutch; Flemish');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (432, 141, 'nno', 'nn', 'Norwegian Nynorsk; Nynorsk, Norwegian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (433, 141, 'nor', 'no', 'Norwegian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (434, NULL, 'nbl', 'nr', 'Ndebele, South; South Ndebele');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (435, NULL, 'nav', 'nv', 'Navajo; Navaho');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (436, 165, 'nya', 'ny', 'Chichewa; Chewa; Nyanja');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (437, 86, 'oci', 'oc', 'Occitan (post 1500); Provencal');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (438, NULL, 'oji', 'oj', 'Ojibwa');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (439, NULL, 'orm', 'om', 'Oromo');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (440, 87, 'ori', 'or', 'Oriya');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (441, NULL, 'oss', 'os', 'Ossetian; Ossetic');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (442, 92, 'pan', 'pa', 'Panjabi; Punjabi');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (443, NULL, 'pli', 'pi', 'Pali');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (444, 90, 'pol', 'pl', 'Polish');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (445, 88, 'pus', 'ps', 'Pushto; Pashto');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (446, 91, 'por', 'pt', 'Portuguese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (447, 93, 'que', 'qu', 'Quechua');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (448, 94, 'roh', 'rm', 'Romansh');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (449, NULL, 'run', 'rn', 'Rundi');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (450, 95, 'ron', 'ro', 'Romanian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (451, 96, 'rus', 'ru', 'Russian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (452, 64, 'kin', 'rw', 'Kinyarwanda');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (453, 99, 'san', 'sa', 'Sanskrit');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (454, NULL, 'srd', 'sc', 'Sardinian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (455, 105, 'snd', 'sd', 'Sindhi');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (456, NULL, 'sme', 'se', 'Northern Sami');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (457, 98, 'sag', 'sg', 'Sango');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (458, 106, 'sin', 'si', 'Sinhala; Sinhalese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (459, 108, 'slk', 'sk', 'Slovak');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (460, 109, 'slv', 'sl', 'Slovenian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (461, 97, 'smo', 'sm', 'Samoan');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (462, 104, 'sna', 'sn', 'Shona');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (463, 110, 'som', 'so', 'Somali');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (464, 6, 'sqi', 'sq', 'Albanian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (465, 100, 'srp', 'sr', 'Serbian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (466, NULL, 'ssw', 'ss', 'Swati');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (467, NULL, 'sot', 'st', 'Sotho, Southern');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (468, 112, 'sun', 'su', 'Sundanese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (469, 114, 'swe', 'sv', 'Swedish');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (470, 113, 'swa', 'sw', 'Swahili');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (471, 117, 'tam', 'ta', 'Tamil');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (472, 119, 'tel', 'te', 'Telugu');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (473, 116, 'tgk', 'tg', 'Tajik');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (474, 120, 'tha', 'th', 'Thai');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (475, 122, 'tir', 'ti', 'Tigrinya');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (476, 126, 'tuk', 'tk', 'Turkmen');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (477, 115, 'tgl', 'tl', 'Tagalog');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (478, NULL, 'tsn', 'tn', 'Tswana');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (479, 123, 'ton', 'to', 'Tonga (Tonga Islands)');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (480, 125, 'tur', 'tr', 'Turkish');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (481, 124, 'tso', 'ts', 'Tsonga');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (482, 118, 'tat', 'tt', 'Tatar');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (483, 127, 'twi', 'tw', 'Twi');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (484, NULL, 'tah', 'ty', 'Tahitian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (485, 128, 'uig', 'ug', 'Uighur; Uyghur');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (486, 129, 'ukr', 'uk', 'Ukrainian');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (487, 130, 'urd', 'ur', 'Urdu');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (488, 131, 'uzb', 'uz', 'Uzbek');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (489, 160, 'ven', 've', 'Venda');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (490, 132, 'vie', 'vi', 'Vietnamese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (491, 133, 'vol', 'vo', 'Volapak');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (492, NULL, 'wln', 'wa', 'Walloon');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (493, 135, 'wol', 'wo', 'Wolof');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (494, 136, 'xho', 'xh', 'Xhosa');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (495, 137, 'yid', 'yi', 'Yiddish');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (496, 138, 'yor', 'yo', 'Yoruba');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (497, 139, 'zha', 'za', 'Zhuang; Chuang');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (498, 25, 'zho', 'zh', 'Chinese');
INSERT INTO lang (lang_id, lang_qt_number, lang_abbr3, lang_abbr2, lang_name) VALUES (499, 140, 'zul', 'zu', 'Zulu');


ALTER TABLE lang ENABLE TRIGGER ALL;

--
-- TOC entry 9620 (class 0 OID 0)
-- Dependencies: 675
-- Name: lang_lang_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('lang_lang_id_seq', 499, true);


--
-- TOC entry 9264 (class 0 OID 146610510)
-- Dependencies: 676 9464
-- Data for Name: locale; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE locale DISABLE TRIGGER ALL;

INSERT INTO locale (locale_id, locale_code, locale_descrip, locale_lang_file, locale_dateformat, locale_currformat, locale_qtyformat, locale_comments, locale_qtyperformat, locale_salespriceformat, locale_extpriceformat, locale_timeformat, locale_timestampformat, local_costformat, locale_costformat, locale_purchpriceformat, locale_uomratioformat, locale_intervalformat, locale_lang_id, locale_country_id, locale_error_color, locale_warning_color, locale_emphasis_color, locale_altemphasis_color, locale_expired_color, locale_future_color, locale_curr_scale, locale_salesprice_scale, locale_purchprice_scale, locale_extprice_scale, locale_cost_scale, locale_qty_scale, locale_qtyper_scale, locale_uomratio_scale, locale_percent_scale, locale_weight_scale) VALUES (3, 'Default', 'Default Locale', '', 'DD Mon YYYY', '999,999,990.00', '.-', '', '999,999,990.0000', '999,999,990.0000', '999,999,990.00', 'HH:MI:SS', 'DD Mon YYYY HH:MI:SS', NULL, '999,999,990.0000', '999,999,990.0000', '999,999,990.00000', 'HH:MI:SS', -1, -1, '', '', '', '', '', '', 2, 4, 4, 2, 4, 2, 4, 5, 2, 2);
INSERT INTO locale (locale_id, locale_code, locale_descrip, locale_lang_file, locale_dateformat, locale_currformat, locale_qtyformat, locale_comments, locale_qtyperformat, locale_salespriceformat, locale_extpriceformat, locale_timeformat, locale_timestampformat, local_costformat, locale_costformat, locale_purchpriceformat, locale_uomratioformat, locale_intervalformat, locale_lang_id, locale_country_id, locale_error_color, locale_warning_color, locale_emphasis_color, locale_altemphasis_color, locale_expired_color, locale_future_color, locale_curr_scale, locale_salesprice_scale, locale_purchprice_scale, locale_extprice_scale, locale_cost_scale, locale_qty_scale, locale_qtyper_scale, locale_uomratio_scale, locale_percent_scale, locale_weight_scale) VALUES (4, 'Spanish', 'Locale for Mexican Spanish', 'OpenMFG.mx.sp', 'DD Mon YYYY', '999999990.00', '.-', '', '999999990.0000', '999999990.0000', '999999990.00', 'HH:MI:SS', 'DD Mon YYYY HH:MI:SS', NULL, '999999990.0000', '', '', 'HH:MI:SS', -1, -1, '', '', '', '', '', '', 2, 4, 0, 2, 4, 2, 4, 0, 2, 2);


ALTER TABLE locale ENABLE TRIGGER ALL;

--
-- TOC entry 9621 (class 0 OID 0)
-- Dependencies: 677
-- Name: locale_locale_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('locale_locale_id_seq', 27, true);


--
-- TOC entry 8981 (class 0 OID 146608978)
-- Dependencies: 342 9464
-- Data for Name: location; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE location DISABLE TRIGGER ALL;



ALTER TABLE location ENABLE TRIGGER ALL;

--
-- TOC entry 9622 (class 0 OID 0)
-- Dependencies: 678
-- Name: location_location_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('location_location_id_seq', 121, true);


--
-- TOC entry 9267 (class 0 OID 146610524)
-- Dependencies: 679 9464
-- Data for Name: locitem; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE locitem DISABLE TRIGGER ALL;



ALTER TABLE locitem ENABLE TRIGGER ALL;

--
-- TOC entry 9623 (class 0 OID 0)
-- Dependencies: 680
-- Name: locitem_locitem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('locitem_locitem_id_seq', 21, true);


--
-- TOC entry 9624 (class 0 OID 0)
-- Dependencies: 681
-- Name: log_log_id_seq; Type: SEQUENCE SET; Schema: public; Owner: admin
--

SELECT pg_catalog.setval('log_log_id_seq', 747, true);


--
-- TOC entry 9010 (class 0 OID 146609341)
-- Dependencies: 405 9464
-- Data for Name: metasql; Type: TABLE DATA; Schema: public; Owner: admin
--

ALTER TABLE metasql DISABLE TRIGGER ALL;

-- TODO: Now that the metasql source is built every time it would be nice to delete all of these, but
-- there were 9 extra entries in the backup that would be unaccounted for

INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (2, 'enterPoReceipt', 'poItemReceivingsFillList', '', '-- Group:enterPoReceipt
-- Name:poItemReceivingsFillList
-- Notes:

<? if exists("pohead_id") ?>
SELECT poitem_id, poitem_linenumber,
       formatDate(poitem_duedate),
       COALESCE(item_number, <? value("nonInventory") ?>),
       COALESCE(uom_name, <? value("na") ?>),
       warehous_code,
       poitem_vend_item_number,
       poitem_vend_uom,
       formatQty(poitem_qty_ordered),
       formatQty(poitem_qty_received),
       formatQty(qtyToReceive(<? value("ordertype") ?>, poitem_id))
FROM poitem 
  LEFT OUTER JOIN 
     ( itemsite 
<? if exists("selectedOnly") ?>
       JOIN usrsite ON (itemsite_warehous_id=usrsite_warehous_id) 
<? endif ?>
       JOIN item ON (itemsite_item_id=item_id) 
       JOIN uom ON (item_inv_uom_id=uom_id)
       JOIN whsinfo ON (itemsite_warehous_id=warehous_id)
     ) ON (poitem_itemsite_id=itemsite_id) 
WHERE ( (poitem_status <> ''C'')
<? if exists("selectedOnly") ?>
 AND (usrsite_username=current_user) 
<? endif ?>
 AND (poitem_pohead_id=<? value("pohead_id") ?>) )
ORDER BY poitem_linenumber;
<? elseif exists("rahead_id") ?>
SELECT raitem_id, raitem_linenumber,
       formatDate(rahead_expiredate),
       COALESCE(item_number, <? value("nonInventory") ?>),
       COALESCE(iu.uom_name, <? value("na") ?>),
       warehous_code,
       '''' AS vend_item_number,
       ru.uom_name,
       formatQty(raitem_qtyauthorized),
       formatQty(raitem_qtyreceived),
       formatQty(qtyToReceive(<? value("ordertype") ?>, raitem_id))
FROM rahead, raitem 
  LEFT OUTER JOIN 
     ( itemsite 
<? if exists("selectedOnly") ?>
       JOIN usrsite ON (itemsite_warehous_id=usrsite_warehous_id) 
<? endif ?>
       JOIN item ON (itemsite_item_id=item_id) 
       JOIN uom iu ON (item_inv_uom_id=uom_id)
       JOIN whsinfo ON (itemsite_warehous_id=warehous_id)
     ) ON (raitem_itemsite_id=itemsite_id), uom ru
WHERE ( (raitem_status <> ''C'')
 AND (raitem_qtyauthorized > 0)
 AND (raitem_disposition IN (''R'',''P'',''V''))
 AND (raitem_rahead_id=rahead_id)
 AND (raitem_qty_uom_id=ru.uom_id)
<? if exists("selectedOnly") ?>
 AND (usrsite_username=current_user) 
<? endif ?>
 AND (rahead_id=<? value("rahead_id") ?>) )
ORDER BY raitem_linenumber;
<? elseif exists("tohead_id") ?>
SELECT toitem_id, toitem_linenumber,
       formatDate(toitem_duedate),
       COALESCE(item_number, <? value("nonInventory") ?>),
       COALESCE(uom_name, <? value("na") ?>),
       warehous_code,
       '''',
       toitem_uom,
       formatQty(toitem_qty_ordered),
       formatQty(toitem_qty_received),
       formatQty(qtyToReceive(<? value("ordertype") ?>, toitem_id))
FROM tohead, itemsite
<? if exists("selectedOnly") ?>
       JOIN usrsite ON (itemsite_warehous_id=usrsite_warehous_id) 
<? endif ?>
, whsinfo, toitem, item JOIN uom ON (item_inv_uom_id=uom_id)
WHERE ((toitem_item_id=item_id)
  AND  (tohead_id=toitem_tohead_id)
  AND  (tohead_dest_warehous_id=itemsite_warehous_id)
  AND  (tohead_dest_warehous_id=warehous_id)
  AND  (toitem_item_id=itemsite_item_id)
  AND  (toitem_status <> ''C'')
<? if exists("selectedOnly") ?>
 AND (usrsite_username=current_user) 
<? endif ?>
  AND  (toitem_tohead_id=<? value("tohead_id") ?>) )
ORDER BY toitem_linenumber;
<? endif ?>
', 'admin', '2008-09-03', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (43, 'breederDistributionVariance', 'detail', 'used by dspBreederDistributionVarianceByItem, dspBreederDistributionVarianceByWarehouse', '-- Group: breederDistributionVariance
-- Name: detail
-- Notes: used by dspBreederDistributionVarianceByItem, dspBreederDistributionVarianceByWarehouse

SELECT brdvar_id, brdvar_postdate,
       pi.item_number AS pitem_number,
       ci.item_number AS citem_number,
       brdvar_stdqtyper,
       brdvar_stdqtyper * brdvar_wo_qty AS stdqty,
       brdvar_actqtyper,
       brdvar_actqtyper * brdvar_wo_qty AS actqty,
       brdvar_actqtyper-brdvar_stdqtyper AS qtypervariance,
       (brdvar_actqtyper-brdvar_stdqtyper) / brdvar_stdqtyper AS percentvariance,
       ''qtyper''   AS brdvar_stdqtyper_xtnumericrole,
       ''qty''     AS stdqty_xtnumericrole,
       ''qtyper''  AS brdvar_actqtyper_xtnumericrole,
       ''qty''     AS actqty_xtnumericrole,
       ''qtyper''  AS qtypervariance_xtnumericrole,
       ''percent'' AS percentvariance_xtnumericrole 
FROM brdvar, itemsite AS ps, itemsite AS cs, item AS ci, item AS pi
WHERE ( (brdvar_parent_itemsite_id=ps.itemsite_id)
    AND (brdvar_itemsite_id=cs.itemsite_id)
<? if exists("item_id") ?>
    AND (ps.itemsite_item_id=<? value("item_id") ?>)
    AND (pi.item_id=ci.item_id)
<? else ?>
    AND (ps.itemsite_item_id=pi.item_id)
<? endif ?>
    AND (cs.itemsite_item_id=ci.item_id)
    AND (brdvar_postdate BETWEEN <? value("startDate") ?>
                             AND <? value("endDate") ?>)
<? if exists("warehous_id") ?>
    AND (ps.itemsite_warehous_id=<? value("warehous_id") ?>)
<? endif ?>
) 
ORDER BY brdvar_postdate, pitem_number
<? if not exists("item_id") ?>
     , citem_number 
<? endif ?>
;
', 'admin', '2008-11-07', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (61, 'manufacture', 'laborvariance', 'shared by dspLaborVarianceBy*', '-- Group: manufacture
-- Name:  laborvariance
-- Notes: shared by dspLaborVarianceBy*

SELECT woopervar.*,
       item_number, wrkcnt_code,
       (woopervar_sutime - woopervar_stdsutime) AS suvar,
       (woopervar_rntime - woopervar_stdrntime) AS rnvar,
       ''qty'' AS woopervar_qtyord_xtnumericrole,
       ''qty'' AS woopervar_qtyrcv_xtnumericrole,
       ''1''   AS woopervar_stdsutime_xtnumericrole,
       ''1''   AS woopervar_stdrntime_xtnumericrole,
       ''1''   AS woopervar_sutime_xtnumericrole,
       ''1''   AS woopervar_rntime_xtnumericrole,
       ''1''   AS suvar_xtnumericrole,
       ''1''   AS rnvar_xtnumericrole
FROM woopervar
<? if exists("wo_id") ?>
     JOIN wo ON ((woopervar_number=wo_number)
             AND (woopervar_subnumber=wo_subnumber))
<? endif ?>
     JOIN itemsite ON (woopervar_parent_itemsite_id=itemsite_id)
     JOIN item ON (itemsite_item_id=item_id)
     LEFT OUTER JOIN wrkcnt ON (woopervar_wrkcnt_id=wrkcnt_id)
WHERE (true
<? if exists("startDate") ?>
   AND (woopervar_posted BETWEEN <? value("startDate") ?>
                             AND <? value("endDate") ?>)
<? endif ?>
<? if exists("item_id") ?>
   AND (itemsite_item_id=<? value("item_id") ?>)
<? endif ?>
<? if exists("booitem_id") ?>
   AND (woopervar_booitem_id=<? value("booitem_id") ?>)
<? endif ?>
<? if exists("wrkcnt_id") ?>
   AND (wrkcnt_id=<? value("wrkcnt_id") ?>)
<? endif ?>
<? if exists("wo_id") ?>
   AND (wo_id=<? value("wo_id") ?>)
<? endif ?>
<? if exists("warehous_id") ?>
   AND (itemsite_warehous_id=<? value("warehous_id") ?>)
<? endif ?>
)
ORDER BY woopervar_posted DESC, woopervar_seqnumber;
', 'admin', '2008-11-07', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (248, 'gleries', 'checkeditable', '', '-- Group: gleries
-- Name:  checkeditable
-- Notes: 
SELECT gltrans_id 
FROM accnt, gltrans 
  LEFT OUTER JOIN period ON (gltrans_date BETWEEN period_start AND period_end) 
WHERE ( (gltrans_accnt_id=accnt_id) 
  AND (gltrans_sequence=<? value("glSequence") ?>) 
  AND ( (gltrans_deleted) 
     OR (period_freeze) 
     OR (gltrans_rec) 
     OR (period_closed AND NOT accnt_closedpost) ) )
LIMIT 1;', 'admin', '2010-09-10', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (94, 'apApplications', 'detail', 'used by dspAPApplications Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: apApplications
-- Name: detail
-- Notes: used by dspAPApplications
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT apapply.*,
       vend_number, vend_name,
       CASE 
         WHEN apapply_source_doctype = ''K'' THEN
            apapply_checkhead_id
         ELSE
            apapply_source_apopen_id 
       END AS apapply_source_docnumber_xtidrole,
       CASE WHEN (apapply_source_doctype=''C'') THEN <? value("creditMemo") ?>
            WHEN (apapply_source_doctype=''K'') THEN <? value("check") ?>
            ELSE apapply_source_doctype
       END AS apapply_source_doctype_qtdisplayrole,
       CASE WHEN (apapply_target_doctype=''D'') THEN apapply_target_apopen_id
            WHEN (apapply_target_doctype=''V'') THEN (SELECT vohead_id
                                                    FROM vohead
                                                    WHERE (vohead_number=apapply_target_docnumber))
       END AS apapply_target_docnumber_xtidrole,
       CASE WHEN (apapply_target_doctype=''C'') THEN <? value("creditMemo") ?>
            WHEN (apapply_target_doctype=''D'') THEN <? value("debitMemo") ?>
            WHEN (apapply_target_doctype=''V'') THEN <? value("voucher") ?>
            WHEN (apapply_target_doctype=''K'') THEN <? value("check") ?>
            ELSE apapply_target_doctype
       END AS apapply_target_doctype_qtdisplayrole,
       formatDate(apapply_postdate) AS f_postdate,-- for openrpt
       formatMoney(apapply_amount) AS f_amount,   -- for openrpt
       currConcat(apapply_curr_id) AS currAbbr,
       currtobase(apapply_curr_id,apapply_amount,apapply_postdate) AS base_applied,
       ''curr'' AS apapply_amount_xtnumericrole,
       ''curr'' AS base_applied_xtnumericrole,
       0 AS base_applied_xttotalrole
FROM apapply, vendinfo
WHERE ( (apapply_vend_id=vend_id)
  AND   (apapply_postdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? if exists("doctypeList") ?>
  AND   (apapply_source_doctype IN (<? literal("doctypeList") ?>))
<? endif ?>
<? if exists("vend_id") ?>
  AND   (vend_id=<? value("vend_id") ?>)
<? elseif exists("vendtype_id") ?>
  AND   (vend_vendtype_id=<? value("vendtype_id") ?>)
<? elseif exists("vendtype_pattern") ?>
  AND   (vend_vendtype_id IN (SELECT vendtype_id FROM vendtype
                              WHERE (vendtype_code ~ <? value("vendtype_pattern") ?>)))
<? endif ?>
      )
ORDER BY apapply_postdate, apapply_source_docnumber;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (484, 'assessFinanceCharges', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: assessFinanceCharges
-- Name:  detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT aropen_id, aropen_docnumber, aropen_duedate, aropen_docdate,
       aropen_amount, aropen_paid, balance, aropen_fincharg_date, aropen_fincharg_amount,
       cust_number, cust_name,
       CASE WHEN (currToLocal(aropen_curr_id, fincharg_mincharg, aropen_distdate) >
                  (CASE WHEN (fincharg_assessoverdue)
                        THEN (balance + prevfincharge)
                        ELSE balance END * fincharg_air / 100.0 / 365 * CASE WHEN (fincharg_calcfrom=1)
                                                                             THEN duedateoverdue
                                                                             ELSE docdateoverdue END))
            THEN currToLocal(aropen_curr_id, fincharg_mincharg, aropen_distdate)
            ELSE (CASE WHEN (fincharg_assessoverdue)
                       THEN (balance + prevfincharge)
                       ELSE balance END * fincharg_air / 100.0 / 365 * CASE WHEN (fincharg_calcfrom=1)
                                                                            THEN duedateoverdue
                                                                            ELSE docdateoverdue END)
       END AS fincharge
FROM fincharg,
     (SELECT *,
             (aropen_amount - aropen_paid) AS balance,
             COALESCE(aropen_fincharg_amount, 0.0) AS prevfincharge,
             (<? value("assessmentDate") ?> - COALESCE(aropen_fincharg_date, aropen_duedate)) AS duedateoverdue,
             (<? value("assessmentDate") ?> - COALESCE(aropen_fincharg_date, aropen_docdate)) AS docdateoverdue
      FROM aropen JOIN custinfo ON (cust_id=aropen_cust_id)
                  LEFT OUTER JOIN terms ON (terms_id=aropen_terms_id)
                  LEFT OUTER JOIN custtype ON (cust_custtype_id=custtype_id)
                  LEFT OUTER JOIN custgrpitem ON (custgrpitem_cust_id=cust_id)
      WHERE ((aropen_doctype=''I'')
        AND  (aropen_open)
        AND  (COALESCE(terms_fincharg, FALSE))
        AND  (COALESCE(cust_financecharge, TRUE))
      <? if exists("cust_id") ?>
        AND   (aropen_cust_id=<? value("cust_id") ?>)
      <? endif ?>
      <? if exists("custtype_id") ?>
        AND   (custtype_id=<? value("custtype_id") ?>)
      <? endif ?>
      <? if exists("custtype_pattern") ?>
        AND   (custtype_code~<? value("custtype_pattern") ?>)
      <? endif ?>
      <? if exists("custgrp_id") ?>
        AND   (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)
      <? endif ?>
      )) AS data
WHERE ((COALESCE(aropen_fincharg_date, aropen_duedate) + COALESCE(cust_gracedays, fincharg_graceperiod)) < <? value("assessmentDate") ?>)
ORDER BY cust_number, aropen_docnumber;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (90, 'updateReorderLevels', 'post', 'itemsite with new reorder level Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: updateReorderLevels
-- Name:  post
-- Notes: itemsite with new reorder level
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

UPDATE itemsite SET
  itemsite_reorderlevel=<? value("itemsite_reorderlevel") ?>,
  itemsite_stocked=CASE WHEN (<? value("itemsite_reorderlevel") ?> = 0) THEN false
                        ELSE itemsite_stocked END,
  itemsite_useparams=CASE WHEN (<? value("itemsite_reorderlevel") ?> = 0) THEN false
                          ELSE itemsite_useparams END
WHERE (itemsite_id=<? value("itemsite_id") ?>)
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (117, 'bomItems', 'detail', 'used by bom, booItem Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: bomItems
-- Name: detail
-- Notes: used by bom, booItem
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT bomitem_id, item_id, *,
       (item_descrip1 || '' '' || item_descrip2) AS item_description,
       CASE WHEN (item_type=''P'') THEN text(<? value("purchased") ?>)
            WHEN (item_type=''M'') THEN text(<? value("manufactured") ?>)
            WHEN (item_type=''J'') THEN text(<? value("job") ?>)
            WHEN (item_type=''F'') THEN text(<? value("phantom") ?>)
            WHEN (item_type=''B'') THEN text(<? value("breeder") ?>)
            WHEN (item_type=''C'') THEN text(<? value("coProduct") ?>)
            WHEN (item_type=''Y'') THEN text(<? value("byProduct") ?>)
            WHEN (item_type=''R'') THEN text(<? value("reference") ?>)
            WHEN (item_type=''S'') THEN text(<? value("costing") ?>)
            WHEN (item_type=''T'') THEN text(<? value("tooling") ?>)
            WHEN (item_type=''A'') THEN text(<? value("assortment") ?>)
            WHEN (item_type=''O'') THEN text(<? value("outside") ?>)
            WHEN (item_type=''L'') THEN text(<? value("planning") ?>)
            WHEN (item_type=''K'') THEN text(<? value("kit") ?>)
            ELSE text(<? value("error") ?>)
       END AS itemtype,
       uom_name AS issueuom,
       CASE WHEN (bomitem_issuemethod = ''S'') THEN <? value("push") ?>
            WHEN (bomitem_issuemethod = ''L'') THEN <? value("pull") ?>
            WHEN (bomitem_issuemethod = ''M'') THEN <? value("mixed") ?>
            ELSE <? value("error") ?>
       END AS issuemethod,
       ''qty'' AS bomitem_qtyfxd_xtnumericrole,
       ''qtyper'' AS bomitem_qtyper_xtnumericrole,
       ''percent'' AS bomitem_scrap_xtnumericrole,
       CASE WHEN (bomitem_effective = startOfTime()) THEN NULL
            ELSE bomitem_effective END AS effective,
       CASE WHEN (bomitem_expires = endOfTime()) THEN NULL
            ELSE bomitem_expires END AS expires,
       <? value("always") ?> AS effective_xtnullrole,
       <? value("never") ?>  AS expires_xtnullrole,
       CASE WHEN (bomitem_expires <= CURRENT_DATE) THEN ''expired''
            WHEN (bomitem_effective > CURRENT_DATE) THEN ''future''
            WHEN (item_type=''M'') THEN ''altemphasis''
       END AS qtforegroundrole
<? if exists("booitem_id") ?>
FROM bomitem(<? value("item_id") ?>), item, uom, xtmfg.booitem
<? else ?>
FROM bomitem(<? value("item_id") ?>, <? value("revision_id") ?>), item, uom
<? endif ?>
WHERE ((bomitem_item_id=item_id)
  AND (bomitem_uom_id=uom_id)
<? if not exists("showExpired") ?>
  AND (bomitem_expires > CURRENT_DATE)
<? endif ?>
<? if not exists("showFuture") ?>
  AND (bomitem_effective <= CURRENT_DATE)
<? endif ?>
<? if exists("booitem_id") ?>
  AND (booitem_id = <? value("booitem_id") ?>)
  AND (bomitem_booitem_seq_id = booitem_seq_id)
<? endif ?>
  )
ORDER BY bomitem_seqnumber, bomitem_effective;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (36, 'apAging', 'detail', 'used by dspTimePhasedOpenAPItems Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: apAging
-- Name: detail
-- Notes: used by dspTimePhasedOpenAPItems
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT apaging_vend_id, apaging_vend_number, apaging_vend_name,
       SUM(apaging_total_val) AS apaging_total_val_sum,
       SUM(apaging_cur_val) AS apaging_cur_val_sum,
       SUM(apaging_thirty_val) AS apaging_thirty_val_sum,
       SUM(apaging_sixty_val) AS apaging_sixty_val_sum,
       SUM(apaging_ninety_val) AS apaging_ninety_val_sum,
       SUM(apaging_plus_val) AS apaging_plus_val_sum,
       ''curr'' AS apaging_total_val_sum_xtnumericrole,
       ''curr'' AS apaging_cur_val_sum_xtnumericrole,
       ''curr'' AS apaging_thirty_val_sum_xtnumericrole,
       ''curr'' AS apaging_sixty_val_sum_xtnumericrole,
       ''curr'' AS apaging_ninety_val_sum_xtnumericrole,
       ''curr'' AS apaging_plus_val_sum_xtnumericrole,
       0 AS apaging_total_val_sum_xttotalrole,
       0 AS apaging_cur_val_sum_xttotalrole,
       0 AS apaging_thirty_val_sum_xttotalrole,
       0 AS apaging_sixty_val_sum_xttotalrole,
       0 AS apaging_ninety_val_sum_xttotalrole,
       0 AS apaging_plus_val_sum_xttotalrole

FROM apaging(<? value("relDate") ?>, <? value("useDocDate") ?>)
<? if exists("vend_id") ?>
WHERE (apaging_vend_id=<? value("vend_id") ?>)
<? elseif exists("vendtype_id") ?>
WHERE (apaging_vend_vendtype_id=<? value("vendtype_id") ?>)
<? elseif exists("vendtype_pattern") ?>
WHERE (apaging_vendtype_code ~ <? value("vendtype_pattern") ?>)
<? endif ?>
GROUP BY apaging_vend_number,apaging_vend_id,apaging_vend_name
ORDER BY apaging_vend_number;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (417, 'bookings', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: bookings
-- Name: detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT   coitem_id AS id, coitem_cohead_id AS altId,
         formatSoLineNumber(coitem_id) AS f_linenumber,
         getSoSchedDate(cohead_id) AS sort_scheddate,
         coitem.*, cohead.*,
         cust_number, cust_name,
         item_number, item_descrip1, (item_descrip1 || '' '' || item_descrip2) AS itemdescription,
         uom_name,
         warehous_code,
         qtyAtShipping(coitem_id) AS qtyatshipping,
-- TODO - not needed, remove? (very slow)
--         qtyAvailable(itemsite_id, coitem_scheddate) AS qtyavailable,
--         (qtyAvailable(itemsite_id, coitem_scheddate) < 0.0) AS stockout,
--         CASE WHEN (itemsite_useparams) THEN (qtyAvailable(itemsite_id, coitem_scheddate) <= itemsite_reorderlevel)
--              ELSE (qtyAvailable(itemsite_id, coitem_scheddate) <= 0.0)
--         END AS reorder,
         noNeg(coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned) AS qtybalance,
         currtobase(cohead_curr_id, coitem_price, cohead_orderdate) AS baseunitprice,
         round((coitem_qtyord * coitem_qty_invuomratio) *
                     (coitem_price / coitem_price_invuomratio), 2) AS extprice,
         round((coitem_qtyord * coitem_qty_invuomratio) *
                     (currtobase(cohead_curr_id, coitem_price, cohead_orderdate) / coitem_price_invuomratio), 2) AS baseextprice,
         round((noNeg(coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned) * coitem_qty_invuomratio) *
                     (coitem_price / coitem_price_invuomratio), 2) AS extpricebalance,
         round((noNeg(coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned) * coitem_qty_invuomratio) *
                     (currtobase(cohead_curr_id, coitem_price, cohead_orderdate) / coitem_price_invuomratio), 2) AS baseextpricebalance,
         curr_abbr AS currAbbr,
-- TODO - not needed, remove? (very slow)
--         CASE WHEN (qtyAvailable(itemsite_id, coitem_scheddate) < 0.0) THEN ''error''
--              WHEN itemsite_useparams AND (qtyAvailable(itemsite_id, coitem_scheddate) <= itemsite_reorderlevel) THEN ''warning''
--              WHEN NOT itemsite_useparams AND (qtyAvailable(itemsite_id, coitem_scheddate) <= 0.0) THEN ''warning''
--         END AS qtyavailable_qtforegroundrole,
       ''qty'' AS coitem_qtyord_xtnumericrole,
       ''qty'' AS coitem_qtyshipped_xtnumericrole,
       ''qty'' AS coitem_qtyreturned_xtnumericrole,
       ''qty'' AS qtyatshipping_xtnumericrole,
       ''qty'' AS qtybalance_xtnumericrole,
       ''qty'' AS qtyavailable_xtnumericrole,
       ''salesprice'' AS coitem_price_xtnumericrole,
       ''salesprice'' AS baseunitprice_xtnumericrole,
       ''curr'' AS extprice_xtnumericrole,
       ''curr'' AS baseextprice_xtnumericrole,
       ''curr'' AS extpricebalance_xtnumericrole,
       ''curr'' AS baseextpricebalance_xtnumericrole,
       0 AS coitem_qtyord_xttotalrole,
       0 AS coitem_qtyshipped_xttotalrole,
       0 AS coitem_qtyreturned_xttotalrole,
       0 AS qtybalance_xttotalrole,
       0 AS baseextprice_xttotalrole,
       0 AS baseextpricebalance_xttotalrole
  FROM coitem JOIN cohead ON (cohead_id=coitem_cohead_id)
              JOIN custinfo ON (cust_id=cohead_cust_id)
              JOIN itemsite ON (itemsite_id=coitem_itemsite_id)
              JOIN site() ON (warehous_id=itemsite_warehous_id)
              JOIN item ON (item_id=itemsite_item_id)
              JOIN uom ON (uom_id=coitem_qty_uom_id)
              JOIN curr_symbol ON (curr_id=cohead_curr_id)
<? foreach("char_id_text_list") ?>
     LEFT OUTER JOIN charass charass_alias<? literal("char_id_text_list") ?> 
          ON ((charass_alias<? literal("char_id_text_list") ?>.charass_target_type=''SO'') 
         AND  (charass_alias<? literal("char_id_text_list") ?>.charass_target_id=cohead_id)
         AND  (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=<? value("char_id_text_list") ?>))
     LEFT OUTER JOIN char char_alias<? literal("char_id_text_list") ?> 
          ON (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=char_alias<? literal("char_id_text_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_list_list") ?>
     LEFT OUTER JOIN charass charass_alias<? literal("char_id_list_list") ?> 
          ON ((charass_alias<? literal("char_id_list_list") ?>.charass_target_type=''SO'') 
         AND  (charass_alias<? literal("char_id_list_list") ?>.charass_target_id=cohead_id)
         AND  (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=<? value("char_id_list_list") ?>))
     LEFT OUTER JOIN char char_alias<? literal("char_id_list_list") ?> 
          ON (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=char_alias<? literal("char_id_list_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_date_list") ?>
     LEFT OUTER JOIN charass charass_alias<? literal("char_id_date_list") ?> 
          ON ((charass_alias<? literal("char_id_date_list") ?>.charass_target_type=''SO'') 
         AND  (charass_alias<? literal("char_id_date_list") ?>.charass_target_id=cohead_id)
         AND  (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=<? value("char_id_date_list") ?>))
     LEFT OUTER JOIN char char_alias<? literal("char_id_date_list") ?> 
          ON (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=char_alias<? literal("char_id_date_list") ?>.char_id)
<? endforeach ?>
  WHERE ( (coitem_status<>''X'')
  <? if exists("cohead_id") ?>
    AND  (coitem_cohead_id=<? value("cohead_id") ?>)
  <? endif ?>
  <? if exists("openOnly") ?>
    AND  (coitem_status<>''C'')
  <? endif ?>
  <? if exists("startDate") ?>
    AND  (cohead_orderdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
  <? endif ?>

  <? if exists("salesrep_id") ?>
    AND  (cohead_salesrep_id=<? value("salesrep_id") ?>)
  <? endif ?>
  <? if exists("shipto_id") ?>
    AND  (cohead_shipto_id=<? value("shipto_id") ?>)
  <? endif ?>
  <? if exists("cust_id") ?>
    AND  (cohead_cust_id=<? value("cust_id") ?>)
  <? elseif exists("custtype_id") ?>
    AND  (cust_custtype_id=<? value("custtype_id") ?>)
  <? elseif exists("custtype_pattern") ?>
    AND  (cust_custtype_id IN (SELECT DISTINCT custtype_id
                               FROM custtype
                               WHERE (custtype_code ~ <? value("custtype_pattern") ?>)))
  <? elseif exists("custgrp") ?>
    AND (cust_id IN (SELECT DISTINCT custgrpitem_cust_id
                     FROM custgrpitem))
  <? elseif exists("custgrp_id") ?>
    AND (cust_id IN (SELECT DISTINCT custgrpitem_cust_id
                     FROM custgrpitem
                     WHERE (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)))
  <? elseif exists("custgrp_pattern") ?>
    AND (cust_id IN (SELECT DISTINCT custgrpitem_cust_id
                     FROM custgrp, custgrpitem
                     WHERE ( (custgrpitem_custgrp_id=custgrp_id)
                       AND   (custgrp_name ~ <? value("custgrp_pattern") ?>) )) )
  <? endif ?>

  <? if exists("item_id") ?>
    AND  (itemsite_item_id=<? value("item_id") ?>)
  <? elseif exists("prodcat_id") ?>
    AND (item_prodcat_id=<? value("prodcat_id") ?>)
  <? elseif exists("prodcat_pattern") ?>
    AND (item_prodcat_id IN (SELECT DISTINCT prodcat_id
                             FROM prodcat
                             WHERE (prodcat_code ~ <? value("prodcat_pattern") ?>)))
  <? endif ?>

  <? if exists("warehous_id") ?>
    AND  (itemsite_warehous_id=<? value("warehous_id") ?>)
  <? endif ?>
  <? literal("charClause") ?>
        )

<? if exists("orderByScheddate") ?>
  ORDER BY sort_scheddate, cohead_number, coitem_linenumber, coitem_subnumber
<? elseif exists("orderByOrderdate") ?>
  ORDER BY cohead_orderdate, cohead_number, coitem_linenumber, coitem_subnumber
<? else ?>
  ORDER BY cohead_number, coitem_linenumber, coitem_subnumber
<? endif ?>
;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (129, 'apOpenItems', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: apOpenItems
-- Name:  detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT apopen_id, apopen_ponumber, apopen_docnumber,
                    CASE WHEN (apopen_doctype=''C'') THEN <? value("creditMemo") ?>
                         WHEN (apopen_doctype=''D'') THEN <? value("debitMemo") ?>
                         WHEN (apopen_doctype=''V'') THEN <? value("voucher") ?>
                         ELSE <? value("other") ?>
                    END AS f_doctype,
                    vend_number, vend_name,
                    apopen_invcnumber AS invoicenumber,
                    apopen_docdate, apopen_duedate, apopen_amount, apopen_status, 
<? if exists("isReport") ?>
                    formatDate(apopen_docdate) AS f_docdate, 
                    formatDate(apopen_duedate) AS f_duedate, 
                    formatMoney(apopen_amount) AS f_amount,
                    formatMoney(apopen_paid - COALESCE(SUM(apapply_target_paid),0)) AS f_paid,
                    formatMoney((apopen_amount - apopen_paid + COALESCE(SUM(apapply_target_paid),0)) * 
                    CASE WHEN apopen_doctype IN (''D'', ''V'') THEN 1 ELSE -1 
                    END) AS f_balance,
                    formatMoney((apopen_amount - apopen_paid + COALESCE(SUM(apapply_target_paid),0)) 
                    / apopen_curr_rate * (CASE WHEN apopen_doctype IN (''D'', ''V'') THEN 1 ELSE -1 
                         END)) AS f_base_balance,
<? endif ?>
                    apopen_paid - COALESCE(SUM(apapply_target_paid),0) AS paid,
                    (apopen_amount - apopen_paid + COALESCE(SUM(apapply_target_paid),0)) * 
                    CASE WHEN apopen_doctype IN (''D'', ''V'') THEN 1 ELSE -1 
                    END AS balance,
                    currConcat(apopen_curr_id) AS currAbbr,
                    (apopen_amount - apopen_paid + COALESCE(SUM(apapply_target_paid),0)) 
                    / apopen_curr_rate * (CASE WHEN apopen_doctype IN (''D'', ''V'') THEN 1 ELSE -1 
                         END) AS base_balance,
                    ''curr'' AS apopen_amount_xtnumericrole,
                    ''curr'' AS paid_xtnumericrole,
                    ''curr'' AS balance_xtnumericrole,
                    ''curr'' AS base_balance_xtnumericrole,
                    0 AS base_balance_xttotalrole 
             FROM apopen 
               JOIN vendinfo ON (vend_id=apopen_vend_id)
               JOIN vendtype ON (vendtype_id=vend_vendtype_id)
               LEFT OUTER JOIN apapply ON (((apopen_id=apapply_target_apopen_id) 
                                       OR (apopen_id=apapply_source_apopen_id)) 
                                       AND (apapply_postdate > <? value("asofDate") ?>)) 
              WHERE ( (COALESCE(apopen_closedate,date <? value("asofDate") ?> + integer ''1'')><? value("asofDate") ?>) 
                AND   (CASE WHEN (<? value("useDocDate") ?>) THEN apopen_docdate ELSE apopen_distdate END<=<? value("asofDate") ?>)
<? if exists("vend_id") ?>
                AND   (apopen_vend_id=<? value("vend_id") ?>)
<? endif ?>
<? if exists("vendtype_id") ?>
                AND   (vendtype_id=<? value("vendtype_id") ?>)
<? endif ?>
<? if exists("vendtype_pattern") ?>
                AND   (vendtype_code~<? value("vendtype_pattern") ?>)
<? endif ?>
                AND   (apopen_duedate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>) ) 
              GROUP BY apopen_id, apopen_ponumber, apopen_docnumber,apopen_doctype, apopen_invcnumber, apopen_docdate, 
                apopen_duedate, apopen_docdate, apopen_amount, apopen_paid, apopen_curr_id, apopen_curr_rate,
                apopen.apopen_status, vend_number, vend_name
              ORDER BY apopen_docdate;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (428, 'contactmerge', 'select', 'Processes contact selections Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: contactmerge
-- Name: select
-- Notes: Processes contact selections
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT cntctselect(
  <? value("cntct_id") ?>, 
  <? value("target") ?>) AS result;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (481, 'contrct', 'itemsources', 'Selection of Contract Related Item Sources', '-- Group: contrct
-- Name:  itemsources
-- Notes: Selection of Contract Related Item Sources
SELECT itemsrc_id,
	-1 AS pohead_id, 
	'' '' AS seq,
	'' '' AS poitem_ordnumber, 
        item_number,
	item_descrip1,
	itemsrc_vend_uom,
	itemsrc_vend_item_number,
	min(contisrc_min) AS contisrc_min,
	sum(poitem_qty_unreleased) AS poitem_qty_unreleased,
	sum(poitem_qty_ordered)    AS poitem_qty_ordered,
	sum(poitem_qty_received)   AS poitem_qty_received,
	sum(poitem_qty_returned)   AS poitem_qty_returned,
	null AS poitem_duedate,
	null AS poitem_status,
	0 AS xtindentrole 
	FROM (SELECT contrct_id, 
		itemsrc_id,
		pohead_number || ''-'' || ltrim(to_char(poitem_linenumber, ''999'')) AS poitem_ordnumber, 
		item_number,
		item_descrip1,
		itemsrc_vend_uom,
		itemsrc_vend_item_number,
		contisrc_min,
		CASE WHEN poitem_status = ''U'' THEN poitem_qty_ordered
		  ELSE 0
		END AS poitem_qty_unreleased,
		CASE WHEN poitem_status = ''O'' THEN poitem_qty_ordered
		     WHEN poitem_status = ''C'' THEN poitem_qty_ordered
                  ELSE 0
		END AS poitem_qty_ordered,
		poitem_qty_received,
		poitem_qty_returned,
		poitem_duedate, 
		poitem_status
		FROM contrct JOIN itemsrc  ON (itemsrc_contrct_id  = contrct_id)
		  LEFT OUTER JOIN contisrc ON (contisrc_itemsrc_id = itemsrc_id)
		  LEFT OUTER JOIN poitem   ON (poitem_itemsrc_id   = itemsrc_id)
		  LEFT OUTER JOIN pohead   ON (pohead_id           = poitem_pohead_id)
			     JOIN item     ON (itemsrc_item_id     = item_id)
		WHERE (contrct_id = <? value("contrct_id") ?>)) AS dummy1
	WHERE (contrct_id = <? value("contrct_id") ?>)
	GROUP BY itemsrc_id, itemsrc_vend_item_number, itemsrc_vend_uom, item_number, item_descrip1

UNION  -- PO Line Items

SELECT itemsrc_id,
	pohead_id, 
	pohead_number || ''-'' || ltrim(to_char(poitem_linenumber, ''999'')) AS seq,
        pohead_number || ''-'' || ltrim(to_char(poitem_linenumber, ''999'')) AS poitem_ordnumber,  
        null AS item_number,
	null AS item_descrip1,
	null AS itemsrc_vend_uom,
	null AS itemsrc_vend_item_number,
	null AS contisrc_min,
	CASE WHEN poitem_status = ''U'' THEN poitem_qty_ordered
	  ELSE 0
	END AS poitem_qty_unreleased,
	CASE WHEN poitem_status = ''O'' THEN poitem_qty_ordered
	     WHEN poitem_status = ''C'' THEN poitem_qty_ordered
          ELSE 0
	END AS poitem_qty_ordered,
	poitem_qty_received,
	poitem_qty_returned,
	poitem_duedate, 
	CASE WHEN poitem_status = ''O'' THEN ''Open''
	     WHEN poitem_status = ''C'' THEN ''Closed''
	     ELSE ''Unreleased''
	END AS poitem_status,
	1 AS xtindentrole 
	FROM contrct JOIN itemsrc  ON (itemsrc_contrct_id  = contrct_id)
	  LEFT OUTER JOIN contisrc ON (contisrc_itemsrc_id = itemsrc_id)
		     JOIN poitem   ON (poitem_itemsrc_id   = itemsrc_id)
		     JOIN pohead   ON (pohead_id           = poitem_pohead_id)
		     JOIN itemsite ON (poitem_itemsite_id  = itemsite_id)
		     JOIN item     ON (itemsite_item_id    = item_id)
	WHERE (contrct_id = <? value("contrct_id") ?>)

UNION -- Receipts

SELECT itemsrc_id,
	pohead_id,  
	poitem_ordnumber || ''R'' || to_char(recv_date, ''YYYYMMDDHH24:MI:SS'') AS seq,
	''Receipt'' AS poitem_ordnumber,
	null AS item_number,
	null AS item_descrip1,
	recv_vend_uom AS vend_uom,
	null AS itemsrc_vend_item_number,
	null AS contisrc_min,
	null AS poitem_qty_unreleased,
	null AS poitem_qty_ordered,
	recv_qty AS poitem_qty_received,
	null AS poitem_qty_returned,
	recv_date AS poitem_duedate,
	recv_trans_usr_name AS username,
	2 AS xtindentrole
  FROM recv JOIN (SELECT pohead_number || ''-'' || ltrim(to_char(poitem_linenumber, ''999'')) AS poitem_ordnumber, 
			    poitem_pohead_id, poitem_linenumber, poitem_id, pohead_id, 
			    poitem_itemsrc_id
			FROM poitem JOIN pohead ON (pohead_id = poitem_pohead_id)) AS dummy ON (poitem_id   = recv_orderitem_id)
               JOIN itemsite ON (itemsite_id = recv_itemsite_id)
               JOIN item     ON (item_id     = itemsite_item_id)
               JOIN itemsrc  ON (poitem_itemsrc_id = itemsrc_id)
  WHERE (itemsrc_contrct_id = <? value("contrct_id") ?>) 

UNION -- Returns

SELECT itemsrc_id, 
	pohead_id,  
	poitem_ordnumber || ''R'' || to_char(poreject_date, ''YYYYMMDDHH24:MI:SS'') AS seq,
	''Return'' AS poitem_ordnumber,
	null AS item_number,
	null AS item_descrip1,
	poreject_vend_uom AS vend_uom,
	null AS itemsrc_vend_item_number,
	null AS contisrc_min,
	null AS poitem_qty_unreleased,
	null AS poitem_qty_ordered,
	null AS poitem_qty_received,
	poreject_qty AS poitem_qty_returned,
	poreject_date AS poitem_duedate,
	poreject_trans_username AS username,
	2 AS xtindentrole 
  FROM poreject JOIN (SELECT pohead_number || ''-'' || ltrim(to_char(poitem_linenumber, ''999'')) AS poitem_ordnumber, 
			    poitem_pohead_id, poitem_linenumber, poitem_id, pohead_id, 
			    poitem_itemsrc_id
			FROM poitem JOIN pohead ON (pohead_id = poitem_pohead_id)) AS dummy ON (poitem_id   = poreject_poitem_id)
               JOIN itemsite ON (itemsite_id = poreject_itemsite_id)
               JOIN item     ON (item_id     = itemsite_item_id)
               JOIN itemsrc  ON (poitem_itemsrc_id = itemsrc_id)
  WHERE (itemsrc_contrct_id = <? value("contrct_id") ?>) 

ORDER BY itemsrc_id, seq, poitem_ordnumber, poitem_duedate, xtindentrole;
', 'admin', '2013-11-11', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (308, 'apOpenItems', 'selectedpayments', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: apOpenItems
-- Name:  selectedpayments
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT *,
       CASE WHEN (apopen_doctype=''V'') THEN <? value("voucher") ?>
            WHEN (apopen_doctype=''D'') THEN <? value("debitmemo") ?>
            WHEN (apopen_doctype=''C'') THEN <? value("creditmemo") ?>
       END AS doctype,
       ''curr'' AS apselect_amount_xtnumericrole,
       ''curr'' AS apselect_amount_base_xtnumericrole,
       ''curr'' AS apselect_running_base_xtnumericrole,
       0 AS apselect_running_base_xtrunninginit,
       1 AS apselect_running_base_xtrunningrole
FROM (
-- Vouchers and Debits
SELECT apopen_id, apselect_id,
       (bankaccnt_name || ''-'' || bankaccnt_descrip) AS f_bank,
       (vend_number || ''-'' || vend_name) AS f_vendor,
       apopen_docnumber, apopen_ponumber, apselect_amount,
       apopen_invcnumber, apopen_doctype,
       currToBase(apselect_curr_id, apselect_amount, CURRENT_DATE) AS apselect_amount_base,
       currToBase(apselect_curr_id, apselect_amount, CURRENT_DATE) AS apselect_running_base,
       currConcat(apselect_curr_id) AS currAbbr
FROM apopen, apselect, vendinfo, bankaccnt
WHERE ( (apopen_vend_id=vend_id)
  AND   (apselect_apopen_id=apopen_id)
  AND   (apselect_bankaccnt_id=bankaccnt_id) 
  AND   (apopen_doctype IN (''V'', ''D''))
<? if exists("bankaccntid") ?>
  AND   (bankaccnt_id=<? value("bankaccntid") ?>)
<? endif ?>
<? if exists("vend_id") ?>
  AND (vend_id=<? value("vend_id") ?>)
<? elseif exists("vendtype_id") ?>
  AND (vend_vendtype_id=<? value("vendtype_id") ?>)
<? elseif exists("vendtype_pattern") ?>
  AND (vend_vendtype_id IN (SELECT vendtype_id
                            FROM vendtype
                            WHERE (vendtype_code ~ <? value("vendtype_pattern") ?>)))
<? endif ?>
 )
UNION
-- Credits
SELECT apopen_id, apselect_id,
       (bankaccnt_name || ''-'' || bankaccnt_descrip) AS f_bank,
       (vend_number || ''-'' || vend_name) AS f_vendor,
       apopen_docnumber, apopen_ponumber, apselect_amount,
       apopen_invcnumber, apopen_doctype,
       currToBase(apselect_curr_id, apselect_amount, CURRENT_DATE) AS apselect_amount_base,
       currToBase(apselect_curr_id, apselect_amount, CURRENT_DATE) * -1.0 AS apselect_running_base,
       currConcat(apselect_curr_id) AS currAbbr
FROM apopen, apselect, vendinfo, bankaccnt
WHERE ( (apopen_vend_id=vend_id)
  AND   (apselect_apopen_id=apopen_id)
  AND   (apselect_bankaccnt_id=bankaccnt_id) 
  AND   (apopen_doctype=''C'')
<? if exists("bankaccntid") ?>
  AND   (bankaccnt_id=<? value("bankaccntid") ?>)
<? endif ?>
<? if exists("vend_id") ?>
  AND (vend_id=<? value("vend_id") ?>)
<? elseif exists("vendtype_id") ?>
  AND (vend_vendtype_id=<? value("vendtype_id") ?>)
<? elseif exists("vendtype_pattern") ?>
  AND (vend_vendtype_id IN (SELECT vendtype_id
                            FROM vendtype
                            WHERE (vendtype_code ~ <? value("vendtype_pattern") ?>)))
<? endif ?>
 )
ORDER BY f_bank, f_vendor, apopen_docnumber
) AS data;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (42, 'arOpenItems', 'detail', 'used by arWorkBench, dspAROpenItems Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: arOpenItems
-- Name: detail
-- Notes: used by arWorkBench, dspAROpenItems
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

<? if exists("totalOnly") ?>
SELECT SUM(CASE WHEN (aropen_doctype IN (''C'', ''R'')) THEN
                    (aropen_amount - aropen_paid) / aropen_curr_rate * -1
                ELSE (aropen_amount - aropen_paid) / aropen_curr_rate
           END) AS total_balance
FROM aropen JOIN custinfo ON (aropen_cust_id=cust_id)
            LEFT OUTER JOIN custtype ON (cust_custtype_id=custtype_id)
            LEFT OUTER JOIN custgrpitem ON (custgrpitem_cust_id=cust_id)
WHERE ( (aropen_open)
<? if exists("cust_id") ?>
  AND   (aropen_cust_id=<? value("cust_id") ?>)
<? endif ?>
<? if exists("custtype_id") ?>
  AND   (custtype_id=<? value("custtype_id") ?>)
<? endif ?>
<? if exists("custtype_pattern") ?>
  AND   (custtype_code~<? value("custtype_pattern") ?>)
<? endif ?>
<? if exists("custgrp_id") ?>
  AND   (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)
<? endif ?>
      )
;
<? else ?>

-- Get unposted invoices
<? if exists("showUnposted") ?>
<? if not exists("creditsOnly") ?>
SELECT -1 AS id,
       0 AS altId,
       invchead_invcnumber AS docnumber,
       invchead_id AS docnumber_xtidrole,
       invchead_posted AS posted,
       invchead_invcdate AS docdate,
       NULL::date AS aropen_duedate,
       invchead_ordernumber AS ordernumber,
       cohead_id AS ordernumber_xtidrole,
       <? value("invoice") ?>  AS doctype,
       NULL AS doctype_qtforegroundrole,
       invoicetotal(invchead_id) AS amount,
       currtobase(invchead_curr_id, invoicetotal(invchead_id), invchead_invcdate) AS base_amount,
       0 AS paid,
       0 AS base_paid,
       0 AS balance,
       currConcat(invchead_curr_id) AS currAbbr,
       0 AS base_balance,
<? if exists("includeFormatted") ?>
       formatDate(invchead_invcdate) AS f_docdate,
       NULL::text AS f_duedate,
       formatMoney(0) AS f_amount,
       formatMoney(0) AS f_paid,
       formatMoney(0) AS f_balance,
<? endif ?>
       cust_id, cust_number, cust_name,
       (invchead_recurring_invchead_id IS NOT NULL) AS recurring,
       false AS open,
       NULL AS ccard_number,
       ''curr'' AS amount_xtnumericrole,
       ''curr'' AS base_amount_xtnumericrole,
       0 AS base_amount_xttotalrole,
       ''curr'' AS paid_xtnumericrole,
       ''curr'' AS base_paid_xtnumericrole,
       0 AS base_paid_xttotalrole,
       ''curr'' AS balance_xtnumericrole,
       ''curr'' AS base_balance_xtnumericrole,
       0 AS base_balance_xttotalrole,
       NULL::text AS aropen_docnumber_qtdisplayrole,
       NULL::text AS aropen_docdate_qtdisplayrole,
       0 AS xtindentrole,
       '''' AS aropen_duedate_qtforegroundrole,
       NULL::integer AS ccard_number_xtidrole,
       firstLine(invchead_notes) AS notes
FROM invchead
           LEFT OUTER JOIN cohead ON (invchead_ordernumber=cohead_number)
           JOIN custinfo ON (invchead_cust_id=cust_id)
           JOIN custtype ON (cust_custtype_id=custtype_id)
	   LEFT OUTER JOIN custgrpitem ON (custgrpitem_cust_id=cust_id)
WHERE ((NOT invchead_posted)
<? if exists("cust_id") ?>
  AND   (invchead_cust_id=<? value("cust_id") ?>)
<? endif ?>
<? if exists("custtype_id") ?>
  AND   (custtype_id=<? value("custtype_id") ?>)
<? endif ?>
<? if exists("custtype_pattern") ?>
  AND   (custtype_code~<? value("custtype_pattern") ?>)
<? endif ?>
<? if exists("custgrp_id") ?>
  AND   (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)
<? endif ?>
<? if exists("startDate") ?>
  AND   (invchead_invcdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
      )
  GROUP BY id,                      altId,                  invchead_id,
           invchead_invcdate,       invchead_posted,        invchead_curr_id,
           invchead_recurring,      invchead_invcnumber,    invchead_posted,
           invchead_ordernumber,    cohead_id,
           cust_id,                 cust_number,            cust_name,
           invchead_recurring_invchead_id, invchead_notes

UNION
<? endif ?>
<? endif ?>

-- Get unposted credit memos
<? if exists("showUnposted") ?>
<? if not exists("debitsOnly") ?>
SELECT -1 AS id,
       1 AS altId,
       cmhead_number AS docnumber,
       cmhead_id AS docnumber_xtidrole,
       cmhead_posted AS posted,
       cmhead_docdate AS docdate,
       NULL::date AS aropen_duedate,
       NULL::text AS ordernumber,
       -1 AS ordernumber_xtidrole,
       <? value("return") ?>  AS doctype,
       CASE WHEN (NOT cmhead_posted) THEN ''emphasis''
       END AS doctype_qtforegroundrole,
       creditmemototal(cmhead_id) AS amount,
       currtobase(cmhead_curr_id, creditmemototal(cmhead_id), cmhead_docdate) AS base_amount,
       0 AS paid,
       0 AS base_paid,
       0 AS balance,
       currConcat(cmhead_curr_id) AS currAbbr,
       0  AS base_balance,
<? if exists("includeFormatted") ?>
       formatDate(cmhead_docdate) AS f_docdate,
       NULL::text AS f_duedate,
       formatMoney(creditmemototal(cmhead_id)) AS f_amount,
       formatMoney(0) AS f_paid,
       formatMoney(0) AS f_balance,
<? endif ?>
       cust_id, cust_number, cust_name,
       false AS recurring,
       false AS open,
       NULL AS ccard_number,
       ''curr'' AS amount_xtnumericrole,
       ''curr'' AS base_amount_xtnumericrole,
       0 AS base_amount_xttotalrole,
       ''curr'' AS paid_xtnumericrole,
       ''curr'' AS base_paid_xtnumericrole,
       0 AS base_paid_xttotalrole,
       ''curr'' AS balance_xtnumericrole,
       ''curr'' AS base_balance_xtnumericrole,
       0 AS base_balance_xttotalrole,
       NULL::text AS aropen_docnumber_qtdisplayrole,
       NULL::text AS aropen_docdate_qtdisplayrole,
       0 AS xtindentrole,
       '''' AS aropen_duedate_qtforegroundrole,
       NULL::integer AS ccard_number_xtidrole,
       firstLine(cmhead_comments) AS notes
FROM cmhead
            JOIN custinfo ON (cmhead_cust_id=cust_id)
            JOIN custtype ON (cust_custtype_id=custtype_id)
	    LEFT OUTER JOIN custgrpitem ON (custgrpitem_cust_id=cust_id)
WHERE ((NOT cmhead_posted)
<? if exists("cust_id") ?>
  AND   (cmhead_cust_id=<? value("cust_id") ?>)
<? endif ?>
<? if exists("custtype_id") ?>
  AND   (custtype_id=<? value("custtype_id") ?>)
<? endif ?>
<? if exists("custtype_pattern") ?>
  AND   (custtype_code~<? value("custtype_pattern") ?>)
<? endif ?>
<? if exists("custgrp_id") ?>
  AND   (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)
<? endif ?>
<? if exists("startDate") ?>
  AND   (cmhead_docdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
      )
  GROUP BY id,                      altId,                  cmhead_id,
           cmhead_docdate,          cmhead_posted,          cmhead_curr_id,
           cmhead_number,           cmhead_posted,          cmhead_comments,
           cust_id,                 cust_number,            cust_name

UNION
<? endif ?>
<? endif ?>

-- Get Posted AR Open
SELECT aropen_id AS id,
       CASE WHEN (aropen_doctype=''I'') THEN 0
            WHEN (aropen_doctype=''C'') THEN 1
            WHEN (aropen_doctype=''D'') THEN 2
            WHEN (aropen_doctype=''R'') THEN 3
            ELSE -1
       END AS altId,
       aropen_docnumber AS docnumber,
       COALESCE(invchead_id,cmhead_id,-1) AS docnumber_xtidrole,
       true AS posted,
       aropen_docdate AS docdate,
       aropen_duedate,
       aropen_ordernumber AS ordernumber,
       COALESCE(cohead_id,-1) AS ordernumber_xtidrole,
       CASE WHEN (aropen_doctype=''I'') THEN <? value("invoice") ?>
            WHEN (aropen_doctype=''C'') THEN <? value("creditMemo") ?>
            WHEN (aropen_doctype=''D'') THEN <? value("debitMemo") ?>
            WHEN (aropen_doctype=''R'') THEN <? value("cashdeposit") ?>
            ELSE <? value("other") ?>
       END AS doctype,
       CASE WHEN (aropen_doctype=''C'') THEN ''emphasis'' 
         ELSE CASE WHEN(aropen_doctype=''R'')THEN ''altemphasis''
         END
       END AS doctype_qtforegroundrole,
       aropen_amount AS amount,
       aropen_amount/aropen_curr_rate AS base_amount,
       (aropen_paid - (COALESCE(SUM(arapply_target_paid),0))) AS paid,
       (aropen_paid - (COALESCE(SUM(arapply_target_paid),0))/aropen_curr_rate) AS base_paid,
        (((aropen_amount-aropen_paid+COALESCE(SUM(arapply_target_paid),0))) *
        CASE WHEN (aropen_doctype IN (''C'', ''R'')) THEN -1 ELSE 1 END) AS balance,
       currConcat(aropen_curr_id) AS currAbbr,
        (((aropen_amount-aropen_paid+COALESCE(SUM(arapply_target_paid),0)))/aropen_curr_rate *
        CASE WHEN (aropen_doctype IN (''C'', ''R'')) THEN -1 ELSE 1 END)  AS base_balance,
<? if exists("includeFormatted") ?>
       formatDate(aropen_docdate) AS f_docdate,
       formatDate(aropen_duedate) AS f_duedate,
       formatMoney(aropen_amount) AS f_amount,
       formatMoney(aropen_paid - (COALESCE(SUM(arapply_target_paid),0))) AS f_paid,
       formatMoney((((aropen_amount-aropen_paid+COALESCE(SUM(arapply_target_paid),0))) *
        CASE WHEN (aropen_doctype IN (''C'', ''R'')) THEN -1 ELSE 1 END)) AS f_balance,
<? endif ?>
       cust_id, cust_number, cust_name,
       COALESCE(invchead_recurring_invchead_id IS NOT NULL, false) AS recurring,
       aropen_open AS open,
       formatccnumber(decrypt(setbytea(ccard_number),
                              setbytea(<? value("key") ?>), ''bf'')) AS ccard_number,
       ''curr'' AS amount_xtnumericrole,
       ''curr'' AS base_amount_xtnumericrole,
       0 AS base_amount_xttotalrole,
       ''curr'' AS paid_xtnumericrole,
       ''curr'' AS base_paid_xtnumericrole,
       0 AS base_paid_xttotalrole,
       ''curr''AS balance_xtnumericrole,
       ''curr'' AS base_balance_xtnumericrole,
       0 AS base_balance_xttotalrole,
       NULL AS aropen_docnumber_qtdisplayrole,
       NULL AS aropen_docdate_qtdisplayrole,
       0 AS xtindentrole,
       CASE WHEN ((COALESCE(aropen_duedate,current_date) < current_date) AND COALESCE(aropen_open,FALSE)) THEN ''error'' 
       END AS aropen_duedate_qtforegroundrole,
       ccpay_id AS ccard_number_xtidrole,
       firstLine(aropen_notes) AS notes
FROM aropen 
<? if exists("incidentsOnly") ?>
            JOIN incdt ON (incdt_aropen_id=aropen_id)
<? endif ?>
            JOIN custinfo ON (aropen_cust_id=cust_id)
            JOIN custtype ON (cust_custtype_id=custtype_id)
	    LEFT OUTER JOIN custgrpitem ON (custgrpitem_cust_id=cust_id)
            LEFT OUTER JOIN invchead ON ((aropen_docnumber=invchead_invcnumber)
                                   AND (aropen_doctype=''I''))
            LEFT OUTER JOIN cohead ON (invchead_ordernumber=cohead_number)
            LEFT OUTER JOIN cmhead ON ((aropen_docnumber=cmhead_number)
                                   AND (aropen_doctype=''C''))
            LEFT OUTER JOIN arapply ON (((aropen_id=arapply_source_aropen_id)
                             OR (aropen_id=arapply_target_aropen_id))
                             AND (arapply_distdate>COALESCE(<? value("asofDate") ?>,current_date)))
            LEFT OUTER JOIN payaropen ON (payaropen_aropen_id=aropen_id)
            LEFT OUTER JOIN ccpay     ON (payaropen_ccpay_id=ccpay_id)
            LEFT OUTER JOIN ccard     ON (ccpay_ccard_id=ccard_id)
WHERE ((true)
<? if not exists("showClosed") ?>
  AND (aropen_docdate <= COALESCE(<? value("asofDate") ?>, current_date))
  AND (COALESCE(aropen_closedate, DATE(<? value("asofDate") ?>) + 1, current_date + 1) > COALESCE(<? value("asofDate") ?>, current_date)) 
<? endif ?>
<? if exists("debitsOnly") ?>
  AND   (aropen_doctype IN (''D'',''I''))
<? elseif exists("creditsOnly") ?>
  AND   (aropen_doctype IN (''C'', ''R''))
<? endif ?>
<? if exists("cust_id") ?>
  AND   (aropen_cust_id=<? value("cust_id") ?>)
<? endif ?>
<? if exists("custtype_id") ?>
  AND   (custtype_id=<? value("custtype_id") ?>)
<? endif ?>
<? if exists("custgrp_id") ?>
  AND   (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)
<? endif ?>
<? if exists("custtype_pattern") ?>
  AND   (custtype_code~<? value("custtype_pattern") ?>)
<? endif ?>
<? if exists("startDate") ?>
  AND   (aropen_docdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
<? if exists("startDueDate") ?>
  AND   (aropen_duedate >= <? value("startDueDate") ?>)
<? endif ?>
<? if exists("endDueDate") ?>
  AND   (aropen_duedate <= <? value("endDueDate") ?>)
<? endif ?>
      )
  GROUP BY id,                      altId,	            invchead_id,
           aropen_docdate,          aropen_duedate,         aropen_doctype,         
           aropen_docnumber,        aropen_amount,          
           aropen_notes,            aropen_posted,          aropen_ordernumber,
           aropen_paid,             aropen_open,            aropen_curr_id,
           aropen_closedate,        aropen_curr_rate,       cmhead_id,
           cust_id, 		    cust_number,            cust_name,
           cohead_id,               ccpay_id,               ccard_number,
           invchead_recurring_invchead_id
UNION
SELECT -1,
       4 AS altId,
       aropen_docnumber AS docnumber,
       -1 AS docnumber_xtidrole,
       NULL AS posted, 
       aropen_docdate AS docdate,
       NULL AS aropen_duedate,
       CAST(incdt_number AS text) AS ordernumber,
       incdt_id AS ordernumber_xtidrole,
       NULL AS doctype,
       NULL AS doctype_qtforegroundrole,
       NULL AS amount,
       NULL AS base_amount,
       NULL AS paid,
       NULL AS base_paid,
       NULL AS balance,
       NULL AS currAbbr,
       NULL AS base_balance,
<? if exists("includeFormatted") ?>
       NULL AS f_docdate,
       NULL AS f_duedate,
       NULL AS f_amount,
       NULL AS f_paid,
       NULL AS f_balance,
<? endif ?>
       NULL,incdt_assigned_username, incdt_summary,
       NULL AS recurring, NULL AS open,
       NULL AS ccard_number,
       ''curr'' AS amount_xtnumericrole,
       ''curr'' AS base_amount_xtnumericrole,
       0 AS base_amount_xttotalrole,
       ''curr'' AS paid_xtnumericrole,
       ''curr'' AS base_paid_xtnumericrole,
       0 AS base_paid_xttotalrole,
       ''curr'' AS balance_xtnumericrole,
       ''curr'' AS base_balance_xtnumericrole,
       0 AS base_balance_xttotalrole,
       '''' AS aropen_docnumber_qtdisplayrole,
       '''' AS aropen_docdate_qtdisplayrole,
       1 AS xtindentrole,
       CASE WHEN ((COALESCE(aropen_duedate,current_date) < current_date) AND COALESCE(aropen_open,FALSE)) THEN ''error'' 
       END AS aropen_duedate_qtforegroundrole,
       NULL::integer AS ccard_xtidrole,
       firstLine(incdt_descrip) AS notes
FROM incdt JOIN aropen ON (aropen_id=incdt_aropen_id)
           JOIN custinfo ON (aropen_cust_id=cust_id)
           JOIN custtype ON (cust_custtype_id=custtype_id)
	   LEFT OUTER JOIN custgrpitem ON (custgrpitem_cust_id=cust_id)
WHERE ((true)
<? if not exists("showClosed") ?>
  AND (aropen_docdate <= COALESCE(<? value("asofDate") ?>, current_date))
  AND (COALESCE(aropen_closedate, DATE(<? value("asofDate") ?>) + 1, current_date + 1) > COALESCE(<? value("asofDate") ?>, current_date)) 
<? endif ?>
<? if exists("debitsOnly") ?>
  AND   (NOT aropen_doctype IN (''C'', ''R''))
<? endif ?>
<? if exists("creditsOnly") ?>
  AND   (aropen_doctype IN (''C'', ''R''))
<? endif ?>
<? if exists("cust_id") ?>
  AND   (aropen_cust_id=<? value("cust_id") ?>)
<? endif ?>
<? if exists("custtype_id") ?>
  AND   (custtype_id=<? value("custtype_id") ?>)
<? endif ?>
<? if exists("custtype_pattern") ?>
  AND   (custtype_code~<? value("custtype_pattern") ?>)
<? endif ?>
<? if exists("custgrp_id") ?>
  AND   (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)
<? endif ?>
<? if exists("startDate") ?>
  AND   (aropen_docdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
<? if exists("startDueDate") ?>
  AND   (aropen_duedate >= <? value("startDueDate") ?>)
<? endif ?>
<? if exists("endDueDate") ?>
  AND   (aropen_duedate <= <? value("endDueDate") ?>)
<? endif ?>
      )

ORDER BY
  docdate DESC, docnumber DESC, xtindentrole
;
<? endif ?>
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (309, 'apOpenItems', 'selectpayments', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: apOpenItems
-- Name:  selectpayments
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT *,
       CASE WHEN (apopen_doctype=''V'') THEN <? value("voucher") ?>
            WHEN (apopen_doctype=''D'') THEN <? value("debitMemo") ?>
            WHEN (apopen_doctype=''C'') THEN <? value("creditMemo") ?>
       END AS doctype,
       CASE WHEN (apopen_duedate < CURRENT_DATE) THEN ''error''
            WHEN(apopen_duedate > CURRENT_DATE) THEN ''emphasis''
            WHEN(CURRENT_DATE <= determineDiscountDate(apopen_terms_id, apopen_docdate)) THEN ''altemphasis''
       END AS apopen_duedate_qtforegroundrole, 
       CASE WHEN (apopen_status = ''H'') THEN ''error'' END AS qtforegroundrole,
       ''curr'' AS amount_xtnumericrole,
       ''curr'' AS selected_xtnumericrole,
       ''curr'' AS running_selected_xtnumericrole,
       ''curr'' AS running_amount_xtnumericrole,
       ''curr'' AS discount_xtnumericrole,
       ''curr'' AS base_amount_xtnumericrole,
       ''curr'' AS base_selected_xtnumericrole,
       ''curr'' AS base_discount_xtnumericrole,
       0      AS base_amount_xttotalrole,
       0      AS base_selected_xttotalrole,
       0      AS base_discount_xttotalrole,
       0      AS running_selected_xtrunninginit,
       0      AS running_amount_xtrunninginit,
       1      AS running_selected_xtrunningrole,
       1      AS running_amount_xtrunningrole
 FROM (
-- Vouchers and Debits
SELECT apopen_id, COALESCE(apselect_id, -1) AS apselectid,
       (vend_number || ''-'' || vend_name) AS vendor,
       apopen_doctype, apopen_docnumber, apopen_ponumber, apopen_invcnumber,
       apopen_duedate, apopen_terms_id, apopen_docdate, apopen_status,
       (apopen_amount - apopen_paid - apCheckPending(apopen_id)) AS amount,
       ((apopen_amount - apopen_paid - apCheckPending(apopen_id)) / apopen_curr_rate) AS base_amount,
       ((apopen_amount - apopen_paid - apCheckPending(apopen_id)) / apopen_curr_rate) AS running_amount,
       COALESCE(apselect_amount, 0.0) AS selected,
       (COALESCE(apselect_amount, 0.0) / apopen_curr_rate) AS base_selected,
       (COALESCE(apselect_amount, 0.0) / apopen_curr_rate) AS running_selected,
       COALESCE(apselect_discount,0.0) AS discount,
       (COALESCE(apselect_discount,0.0) / apopen_curr_rate)AS base_discount,
       currConcat(apopen_curr_id) AS curr_concat
FROM vendinfo JOIN apopen ON (apopen_vend_id=vend_id)
              LEFT OUTER JOIN apselect ON (apselect_apopen_id=apopen_id)
WHERE ( (apopen_open)
 AND (apopen_doctype IN (''V'', ''D''))
<? if exists("vend_id") ?>
 AND (vend_id=<? value("vend_id") ?>)
<? elseif exists("vendtype_id") ?>
 AND (vend_vendtype_id=<? value("vendtype_id") ?>)
<? elseif exists("vendtype_pattern") ?>
 AND (vend_vendtype_id IN (SELECT vendtype_id
                           FROM vendtype
                           WHERE (vendtype_code ~ <? value("vendtype_pattern") ?>)))
<? endif ?>
<? if exists("olderDate") ?>
 AND (apopen_duedate <= <? value("olderDate") ?>)
<? elseif exists("startDate") ?>
 AND (apopen_duedate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
<? if exists("curr_id") ?>
 AND (apopen_curr_id=<? value("curr_id") ?>)
<? endif ?>
)
UNION
-- Credits
SELECT apopen_id, COALESCE(apselect_id, -1) AS apselectid,
       (vend_number || ''-'' || vend_name) AS vendor,
       apopen_doctype, apopen_docnumber, apopen_ponumber, apopen_invcnumber,
       apopen_duedate, apopen_terms_id, apopen_docdate, apopen_status,
       (apopen_amount - apopen_paid - apCheckPending(apopen_id)) AS amount,
       ((apopen_amount - apopen_paid - apCheckPending(apopen_id)) / apopen_curr_rate) AS base_amount,
       ((apopen_amount - apopen_paid - apCheckPending(apopen_id)) / apopen_curr_rate) * -1.0 AS running_amount,
       COALESCE(apselect_amount, 0.0) AS selected,
       (COALESCE(apselect_amount, 0.0) / apopen_curr_rate) AS base_selected,
       (COALESCE(apselect_amount, 0.0) / apopen_curr_rate) * -1.0 AS running_selected,
       COALESCE(apselect_discount,0.0) AS discount,
       (COALESCE(apselect_discount,0.0) / apopen_curr_rate)AS base_discount,
       currConcat(apopen_curr_id) AS curr_concat
FROM vendinfo JOIN apopen ON (apopen_vend_id=vend_id)
              LEFT OUTER JOIN apselect ON (apselect_apopen_id=apopen_id)
WHERE ( (apopen_open)
 AND (apopen_doctype = ''C'')
<? if exists("vend_id") ?>
 AND (vend_id=<? value("vend_id") ?>)
<? elseif exists("vendtype_id") ?>
 AND (vend_vendtype_id=<? value("vendtype_id") ?>)
<? elseif exists("vendtype_pattern") ?>
 AND (vend_vendtype_id IN (SELECT vendtype_id
                           FROM vendtype
                           WHERE (vendtype_code ~ <? value("vendtype_pattern") ?>)))
<? endif ?>
<? if exists("olderDate") ?>
 AND (apopen_duedate <= <? value("olderDate") ?>)
<? elseif exists("startDate") ?>
 AND (apopen_duedate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
<? if exists("curr_id") ?>
 AND (apopen_curr_id=<? value("curr_id") ?>)
<? endif ?>
)
ORDER BY apopen_duedate, amount DESC) AS data
WHERE (amount != 0);
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (444, 'bankrec', 'checks', 'used by reconcileBankaccount Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: bankrec
-- Name: checks
-- Notes: used by reconcileBankaccount
--        Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
--        See www.xtuple.com/CPAL for the full text of the software license.

<? if exists("summary") ?>
SELECT COALESCE(SUM(amount),0.0) AS cleared_amount
  FROM ( SELECT COALESCE( bankrecitem_amount,
                          currToLocal(bankaccnt_curr_id, gltrans_amount, gltrans_date) ) AS amount
           FROM (bankaccnt CROSS JOIN gltrans)
                       JOIN bankrecitem ON ((bankrecitem_source=''GL'')
                                        AND (bankrecitem_source_id=gltrans_id)
                                        AND (bankrecitem_bankrec_id=<? value("bankrecid") ?>)
                                        AND (bankrecitem_cleared))
          WHERE ((gltrans_accnt_id=bankaccnt_accnt_id)
            AND (NOT gltrans_deleted)
            AND (NOT gltrans_rec)
            AND (gltrans_amount > 0)
            AND (gltrans_doctype != ''JP'')
            AND (bankaccnt_id=<? value("bankaccntid") ?>) )
          UNION ALL
         SELECT COALESCE( bankrecitem_amount,
                          currToLocal(bankaccnt_curr_id, sltrans_amount, sltrans_date) ) AS amount
           FROM (bankaccnt CROSS JOIN sltrans)
                       JOIN bankrecitem ON ((bankrecitem_source=''SL'')
                                        AND (bankrecitem_source_id=sltrans_id)
                                        AND (bankrecitem_bankrec_id=<? value("bankrecid") ?>)
                                        AND (bankrecitem_cleared))
          WHERE ((sltrans_accnt_id=bankaccnt_accnt_id)
            AND (NOT sltrans_rec)
            AND (sltrans_amount > 0)
            AND (bankaccnt_id=<? value("bankaccntid") ?>) )
          UNION ALL
         SELECT CASE WHEN(bankadjtype_iscredit=false) THEN (bankadj_amount * -1) ELSE bankadj_amount END AS amount
           FROM bankadj, bankadjtype, bankrecitem
          WHERE ( (bankrecitem_source=''AD'')
            AND (bankrecitem_source_id=bankadj_id)
            AND (bankrecitem_bankrec_id=<? value("bankrecid") ?>)
            AND (bankrecitem_cleared)
            AND (bankadj_bankadjtype_id=bankadjtype_id)
            AND (NOT bankadj_posted)
            AND (((bankadjtype_iscredit=true) AND (bankadj_amount > 0)) OR ((bankadjtype_iscredit=false) AND (bankadj_amount < 0)))
            AND (bankadj_bankaccnt_id=<? value("bankaccntid") ?>) ) ) AS data;
<? else ?>
SELECT gltrans_id AS id, 1 AS altid,
       COALESCE(bankrecitem_cleared, FALSE) AS cleared,
       gltrans_date AS transdate,
       gltrans_doctype AS doc_type,
       gltrans_docnumber AS doc_number,
       gltrans_notes AS notes,
       (SELECT currConcat(COALESCE(checkhead_curr_id, baseCurrId()))) AS doc_curr,
       COALESCE(bankrecitem_curr_rate, checkhead_curr_rate, currRate(bankaccnt_curr_id, gltrans_date)) AS doc_exchrate,
       gltrans_amount AS base_amount,
       CASE WHEN (bankaccnt_curr_id=checkhead_curr_id) THEN
         COALESCE( bankrecitem_amount,
                   checkhead_amount,
                   currToLocal(bankaccnt_curr_id, gltrans_amount, gltrans_date) )
            ELSE
         COALESCE( bankrecitem_amount,
                   currToLocal(bankaccnt_curr_id, gltrans_amount, gltrans_date) )
       END AS amount,
       gltrans_date AS sortdate,
       ''uomratio'' AS doc_exchrate_xtnumericrole,
       ''curr'' AS base_amount_xtnumericrole,
       ''curr'' AS amount_xtnumericrole
  FROM (bankaccnt CROSS JOIN gltrans)
              LEFT OUTER JOIN bankrecitem ON ((bankrecitem_source=''GL'')
                                          AND (bankrecitem_source_id=gltrans_id)
                                          AND (bankrecitem_bankrec_id=<? value("bankrecid") ?>)
                                          AND (bankrecitem_cleared))
              LEFT OUTER JOIN checkhead ON ((gltrans_doctype=''CK'')
                                        AND (gltrans_misc_id=checkhead_id))
 WHERE ((gltrans_accnt_id=bankaccnt_accnt_id)
   AND (NOT gltrans_deleted)
   AND (NOT gltrans_rec)
   AND (NOT COALESCE(checkhead_void, false))
   AND (gltrans_amount > 0)
   AND (gltrans_doctype != ''JP'')
   AND (bankaccnt_id=<? value("bankaccntid") ?>) )
 UNION ALL
SELECT sltrans_id AS id, 2 AS altid,
       COALESCE(bankrecitem_cleared, FALSE) AS cleared,
       sltrans_date AS transdate,
       sltrans_doctype AS doc_type,
       sltrans_docnumber AS doc_number,
       sltrans_notes AS notes,
       (SELECT currConcat(COALESCE(checkhead_curr_id, baseCurrId()))) AS doc_curr,
       COALESCE(bankrecitem_curr_rate, checkhead_curr_rate, currRate(bankaccnt_curr_id, sltrans_date)) AS doc_exchrate,
       sltrans_amount AS base_amount,
       CASE WHEN (bankaccnt_curr_id=checkhead_curr_id) THEN
         COALESCE( bankrecitem_amount,
                   checkhead_amount,
                   currToLocal(bankaccnt_curr_id, sltrans_amount, sltrans_date) )
            ELSE
         COALESCE( bankrecitem_amount,
                   currToLocal(bankaccnt_curr_id, sltrans_amount, sltrans_date) )
       END AS amount,
       sltrans_date AS sortdate,
       ''uomratio'' AS doc_exchrate_xtnumericrole,
       ''curr'' AS base_amount_xtnumericrole,
       ''curr'' AS amount_xtnumericrole
  FROM (bankaccnt CROSS JOIN sltrans)
              LEFT OUTER JOIN bankrecitem ON ((bankrecitem_source=''SL'')
                                          AND (bankrecitem_source_id=sltrans_id)
                                          AND (bankrecitem_bankrec_id=<? value("bankrecid") ?>)
                                          AND (bankrecitem_cleared))
              LEFT OUTER JOIN checkhead ON ((sltrans_doctype=''CK'')
                                        AND (sltrans_misc_id=checkhead_id))
 WHERE ((sltrans_accnt_id=bankaccnt_accnt_id)
   AND (NOT sltrans_rec)
   AND (NOT COALESCE(checkhead_void, false))
   AND (sltrans_amount > 0)
   AND (bankaccnt_id=<? value("bankaccntid") ?>) )
 UNION ALL
SELECT bankadj_id AS id, 3 AS altid,
       COALESCE(bankrecitem_cleared, FALSE) AS cleared,
       bankadj_date AS transdate,
       ''ADJ'' AS doc_type,
       bankadj_docnumber AS doc_number,
       bankadjtype_name AS notes,
       (SELECT currConcat(bankadj_curr_id)) AS doc_curr,
       1.0 AS doc_exchrate,
       CASE WHEN(bankadjtype_iscredit=false) THEN (bankadj_amount * -1.0) ELSE bankadj_amount END AS base_amount,
       CASE WHEN(bankadjtype_iscredit=false) THEN (bankadj_amount * -1.0) ELSE bankadj_amount END AS amount,
       bankadj_date AS sortdate,
       ''uomratio'' AS doc_exchrate_xtnumericrole,
       ''curr'' AS base_amount_xtnumericrole,
       ''curr'' AS amount_xtnumericrole
  FROM (bankadjtype CROSS JOIN bankadj)
               LEFT OUTER JOIN bankrecitem ON ((bankrecitem_source=''AD'')
                                           AND (bankrecitem_source_id=bankadj_id)
                                           AND (bankrecitem_bankrec_id=<? value("bankrecid") ?>)
                                           AND (bankrecitem_cleared))
 WHERE ( (((bankadjtype_iscredit=true) AND (bankadj_amount > 0)) OR ((bankadjtype_iscredit=false) AND (bankadj_amount < 0)))
   AND (bankadj_bankadjtype_id=bankadjtype_id)
   AND (NOT bankadj_posted)
   AND (bankadj_bankaccnt_id=<? value("bankaccntid") ?>) )
ORDER BY sortdate;
<? endif ?>
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (115, 'workOrderSchedule', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: workOrderSchedule
-- Name:  detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT wo_id,
       CASE WHEN (wo_ordid IS NULL) THEN -1
            ELSE wo_ordid
       END AS orderid,
       wo.*, warehous_code, uom_name,
       item_number, (item_descrip1 || '' '' || item_descrip2) AS itemdescrip,
       item_descrip1, item_descrip2,
       formatQty(wo_qtyord) AS ordered,
       formatQty(wo_qtyrcv) AS received,
       formatDate(wo_startdate) AS startdate,
       formatDate(wo_duedate) AS duedate,
       formatWONumber(wo_id) AS wonumber,
       ''qty'' AS wo_qtyord_xtnumericrole,
       ''qty'' AS wo_qtyrcv_xtnumericrole,
       CASE WHEN ((wo_startdate<=CURRENT_DATE) AND (wo_status IN (''O'',''E'',''S'',''R''))) THEN ''error''
       END AS wo_startdate_qtforegroundrole,
       CASE WHEN (wo_duedate<=CURRENT_DATE) THEN ''error''
       END AS wo_duedate_qtforegroundrole,
       CASE WHEN (wo_duedate<=CURRENT_DATE) THEN ''Overdue''
            ELSE ''On Time''
       END AS condition,
       CASE WHEN (wo_duedate<=CURRENT_DATE) THEN ''error'' END AS condition_qtforegroundrole
FROM itemsite, whsinfo, item, uom, wo
<? if reExists("woSoStatus") ?>
 JOIN coitem ON ((coitem_order_id=wo_id)
             AND (coitem_order_type=''W''))
<? endif ?>
WHERE ( (wo_itemsite_id=itemsite_id)
  AND (itemsite_item_id=item_id)
  AND (item_inv_uom_id=uom_id)
  AND (itemsite_warehous_id=warehous_id)
<? if exists("search_pattern") ?>
  AND ( (wo_number::TEXT ~* <? value("search_pattern") ?>)
    OR  (item_number ~* <? value("search_pattern") ?>)
    OR  (item_descrip1 || item_descrip2 ~* <? value("search_pattern") ?>) )
<? endif ?>
<? if exists("woSoStatus") ?>
  AND (coitem_status <> ''X'')
<? elseif exists("woSoStatusMismatch") ?>
  AND (coitem_status=''C'')
<? endif ?>
<? if exists("startDate") ?>
  AND (wo_startdate >= <? value("startDate") ?>)
<? endif ?>
<? if exists("endDate") ?>
  AND (wo_startdate <= <? value("endDate") ?>)
<? endif ?>
<? if exists("warehous_id") ?>
  AND (itemsite_warehous_id=<? value("warehous_id") ?>)
<? endif ?>
<? if exists("item_id") ?>
  AND (itemsite_item_id=<? value("item_id") ?>)
<? endif ?>
<? if exists("wo_id") ?>
  AND (wo_number IN (SELECT wo_number
                     FROM wo
                     WHERE (wo_id=<? value("wo_id") ?>)))
<? endif ?>
<? if exists("status_list") ?>
<? foreach("status_list") ?>
  <? if isfirst("status_list") ?>
    AND (wo_status=<? value("status_list") ?>
  <? else ?>
    OR wo_status=<? value("status_list") ?>
  <? endif ?>
  <? if islast("status_list") ?>
    )
  <? endif ?>
<? endforeach ?>
<? elseif exists("showOnlyRI") ?>
  AND (wo_status IN (''R'',''I''))
<? else ?>
  AND (wo_status<>''C'')
<? endif ?>
<? if exists("showOnlyTopLevel") ?>
  AND (wo_ordtype<>''W'')
<? endif ?>
<? if exists("classcode_id") ?>
  AND (item_classcode_id=<? value("classcode_id") ?>)
<? endif ?>
<? if exists("itemgrp_id") ?>
  AND (item_id IN (SELECT itemgrpitem_item_id
                   FROM itemgrpitem
                   WHERE (itemgrpitem_itemgrp_id=<? value("itemgrp_id") ?>)))
<? endif ?>
<? if exists("plancode_id") ?>
  AND (itemsite_plancode_id=<? value("plancode_id") ?>)
<? endif ?>
<? if exists("wrkcnt_id") ?>
  AND (wo_id IN (SELECT wooper_wo_id
                 FROM wooper
                 WHERE (wooper_wrkcnt_id=<? value("wrkcnt_id") ?>)))
<? endif ?>
<? if exists("classcode_pattern") ?>
  AND (item_classcode_id IN (SELECT classcode_id
                             FROM classcode
                             WHERE (classcode_code ~ <? value("classcode_pattern") ?>)))
<? endif ?>
<? if exists("itemgrp_pattern") ?>
  AND (item_id IN (SELECT itemgrpitem_item_id
                   FROM itemgrpitem, itemgrp
                   WHERE ( (itemgrpitem_itemgrp_id=itemgrp_id) AND (itemgrp_name ~ <? value("itemgrp_pattern") ?>) ) ))
<? endif ?>
<? if exists("plancode_pattern") ?>
  AND (itemsite_plancode_id IN (SELECT plancode_id
                                FROM plancode
                                WHERE (plancode_code ~ <? value("plancode_pattern") ?>)))
<? endif ?>
<? if exists("wrkcnt_pattern") ?>
  AND (wo_id IN (SELECT wooper_wo_id
                 FROM wooper, wrkcnt
                 WHERE ((wooper_wrkcnt_id=wrkcnt_id) AND (wrkcnt_code ~ <? value("wrkcnt_pattern") ?>))))
<? endif ?>
   )
ORDER BY 
<? if exists("sortByStartDate") ?>
  wo_startdate,
<? elseif exists("sortByDueDate") ?>
  wo_duedate,
<? elseif exists("sortByItemNumber") ?>
  item_number,
<? endif ?>
  wo_number, wo_subnumber;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (44, 'capacityUOMs', 'detail', 'used by dspCapacityUOMsByClassCode, dspCapacityUOMsByProductCategory Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: capacityUOMs
-- Name: detail
-- Notes: used by dspCapacityUOMsByClassCode, dspCapacityUOMsByProductCategory
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT item_id, item_number,
<? if exists("getclasscode") ?>
       classcode_code,
<? endif ?>
       (item_descrip1 || '' '' || item_descrip2) AS descrip,
       uom_name,
       itemcapuom(item_id)       AS capuom,
       itemcapinvrat(item_id)    AS capinvrat,
       itemaltcapuom(item_id)    AS altcapuom,
       itemaltcapinvrat(item_id) AS altcapinvrat,
       ''uomratio'' AS capinvrat_xtnumericrole,
       ''uomratio'' AS altcapinvrat_xtnumericrole
FROM item
     JOIN uom ON (item_inv_uom_id=uom_id)
<? if exists("getclasscode") ?>
     LEFT OUTER JOIN classcode ON (item_classcode_id=classcode_id)
<? endif ?>
WHERE (
<? if exists("getclasscode") ?> true <? else ?> item_sold <? endif ?>
<? if exists("prodcat_id") ?>
   AND (item_prodcat_id=<? value("prodcat_id") ?>)
<? elseif exists("prodcat_pattern") ?>
   AND (item_prodcat_id IN (SELECT prodcat_id
                            FROM prodcat
                            WHERE (prodcat_code ~ <? value("prodcat_pattern") ?>)))
<? elseif exists("classcode_id") ?>
   AND (classcode_id=<? value("classcode_id") ?>)
<? elseif exists("classcode_pattern") ?>
   AND (classcode_code ~ <? value("classcode_pattern") ?>)
<? endif ?>
)
ORDER BY <? if exists("getclasscode") ?> classcode_code, <? endif ?>
         item_number;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (361, 'glseries', 'checkeditable', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: glseries
-- Name:  checkeditable
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT gltrans_id 
FROM accnt, gltrans 
  LEFT OUTER JOIN period ON (gltrans_date BETWEEN period_start AND period_end) 
WHERE ( (gltrans_accnt_id=accnt_id) 
  AND (gltrans_sequence=<? value("glSequence") ?>) 
  AND ( (gltrans_deleted) 
     OR (period_closed) 
     OR (gltrans_rec) 
     OR (period_freeze AND NOT checkPrivilege(''PostFrozenPeriod'')) ) )
LIMIT 1;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (96, 'ccpayments', 'list', 'list credit card payments, optionally by customer Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: ccpayments
-- Name:  list
-- Notes: list credit card payments, optionally by customer
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT ccpay_id AS id, 
       CASE WHEN ((ccpay_status = ''A'') AND 
                 (date_part(''day'', CURRENT_TIMESTAMP - ccpay_transaction_datetime) < COALESCE(<? value("ccValidDays") ?>,0))) THEN
         1
       ELSE 0
       END AS altid, cohead_id,
       ccpay.*,
       cust_number, cust_name,       
       ccpay_type AS type,       
       CASE WHEN (ccpay_type=''A'') THEN <? value("preauth") ?>
            WHEN (ccpay_type=''C'') THEN <? value("charge") ?>
            WHEN (ccpay_type=''R'') THEN <? value("refund") ?>
            ELSE ccpay_type
       END AS type_qtdisplayrole,
       ccpay_status AS status,
       CASE WHEN (ccpay_status=''A'') THEN <? value("authorized") ?>
            WHEN (ccpay_status=''C'') THEN <? value("approved") ?>
            WHEN (ccpay_status=''D'') THEN <? value("declined") ?>
            WHEN (ccpay_status=''V'') THEN <? value("voided") ?>
            WHEN (ccpay_status=''X'') THEN <? value("noapproval") ?>
            ELSE ccpay_status
       END AS status_qtdisplayrole,
       currConcat(ccpay_curr_id) AS currAbbr,
       COALESCE(cohead_number, ccpay_order_number) AS docnumber,
       ABS(COALESCE(payco_amount, ccpay_amount)) AS allocated,
       currConcat(COALESCE(payco_curr_id, ccpay_curr_id)) AS payco_currAbbr,
       cust_number, cust_name,
       ''curr'' AS ccpay_amount_xtnumericrole,
       ''curr'' AS allocated_xtnumericrole,
        CASE WHEN ((ccpay_status = ''A'')
              AND (date_part(''day'', CURRENT_TIMESTAMP - ccpay_transaction_datetime) >= COALESCE(<? value("ccValidDays") ?>,0))) THEN
          ''error''
        END AS qtforegroundrole
  FROM ccpay LEFT OUTER JOIN 
       (payco JOIN cohead ON (payco_cohead_id=cohead_id))
         ON (payco_ccpay_id=ccpay_id)
      JOIN custinfo ON (ccpay_cust_id=cust_id)
      JOIN custtype ON (cust_custtype_id=custtype_id)
      LEFT OUTER JOIN custgrpitem ON (custgrpitem_cust_id=cust_id)
  WHERE ((true)
<? if exists("processed") ?>
  AND (ccpay_status != ''A'')
<? elseif exists("authorizations") ?>
  AND (ccpay_status = ''A'')
<? endif ?>
<? if exists("validOnly") ?>
  AND ((ccpay_status != ''A'')
  OR (date_part(''day'', CURRENT_TIMESTAMP - ccpay_transaction_datetime) < <? value("ccValidDays") ?>))
<? endif ?>
<? if exists("cust_id") ?>
  AND   (ccpay_cust_id=<? value("cust_id") ?>)
<? endif ?>
<? if exists("custtype_id") ?>
  AND   (custtype_id=<? value("custtype_id") ?>)
<? endif ?>
<? if exists("custtype_pattern") ?>
  AND   (custtype_code~<? value("custtype_pattern") ?>)
<? endif ?>
<? if exists("custgrp_id") ?>
  AND   (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)
<? endif ?>)
 ORDER BY ccpay_transaction_datetime;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (456, 'charass', 'populate', 'Populate characteristic assignments combobox Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: charass
-- Name:  populate
-- Notes: Populate characteristic assignments combobox
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

<? if exists("name") ?>
SELECT -1 AS charass_char_id, '''' AS char_name
UNION
SELECT DISTINCT charass_char_id, char_name
<? else ?>
SELECT -1 AS charass_id, '''' AS charass_value
UNION
SELECT DISTINCT charass_id, charass_value
<? endif ?>
FROM charass, char
WHERE ((charass_char_id=char_id)
  AND (charass_target_type=<? value("type") ?>)
  AND (charass_target_id= <? value("id") ?>))
<? if exists("char") ?>
  AND (charass_char_id= <? value("char") ?>)
  AND (COALESCE(charass_value,'''')!='''')
<? endif ?>
<? if exists("name") ?>
ORDER BY char_name;
<? else ?>
ORDER BY charass_value;
<? endif ?>
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (419, 'contactmerge', 'delete', 'Delete a contact Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: contactmerge
-- Name: delete
-- Notes: Delete a contact
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

DELETE FROM cntct WHERE (cntct_id=<? value("cntct_id") ?>);
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (230, 'addresses', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: addresses
-- Name:  detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT DISTINCT ON (addr_country, addr_state, addr_city, addr_line1, addr_number) 
  addr_id, addr_line1, addr_line2, addr_line3, 
  addr_city, addr_state, addr_country, addr_postalcode 
<? foreach("char_id_text_list") ?>
  , charass_alias<? literal("char_id_text_list") ?>.charass_value AS char<? literal("char_id_text_list") ?>
<? endforeach ?>
<? foreach("char_id_list_list") ?>
  , charass_alias<? literal("char_id_list_list") ?>.charass_value AS char<? literal("char_id_list_list") ?>
<? endforeach ?>
<? foreach("char_id_date_list") ?>
  , charass_alias<? literal("char_id_date_list") ?>.charass_value::date AS char<? literal("char_id_date_list") ?>
<? endforeach ?>
FROM addr 
<? foreach("char_id_text_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_text_list") ?> ON ((charass_alias<? literal("char_id_text_list") ?>.charass_target_type=''ADDR'') 
                                                                    AND  (charass_alias<? literal("char_id_text_list") ?>.charass_target_id=addr_id)
                                                                    AND  (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=<? value("char_id_text_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_text_list") ?> ON (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=char_alias<? literal("char_id_text_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_list_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_list_list") ?> ON ((charass_alias<? literal("char_id_list_list") ?>.charass_target_type=''ADDR'') 
                                                                    AND  (charass_alias<? literal("char_id_list_list") ?>.charass_target_id=addr_id)
                                                                    AND  (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=<? value("char_id_list_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_list_list") ?> ON (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=char_alias<? literal("char_id_list_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_date_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_date_list") ?> ON ((charass_alias<? literal("char_id_date_list") ?>.charass_target_type=''ADDR'') 
                                                                    AND  (charass_alias<? literal("char_id_date_list") ?>.charass_target_id=addr_id)
                                                                    AND  (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=<? value("char_id_date_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_date_list") ?> ON (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=char_alias<? literal("char_id_date_list") ?>.char_id)
<? endforeach ?>
WHERE true
<? if not exists("showInactive") ?> 
 AND addr_active 
<? endif ?>
<? literal("charClause") ?>
ORDER BY addr_country, addr_state, addr_city, addr_line1, addr_number;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (446, 'bankrec', 'receipts', 'used by reconcileBankaccount Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: bankrec
-- Name: receipts
-- Notes: used by reconcileBankaccount
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

<? if exists("summary") ?>
SELECT COALESCE(SUM(amount),0.0) AS cleared_amount
  FROM ( SELECT COALESCE( bankrecitem_amount,
                          (currToLocal(bankaccnt_curr_id, gltrans_amount, gltrans_date) * -1.0) ) AS amount
           FROM (bankaccnt CROSS JOIN gltrans)
                      JOIN bankrecitem ON ((bankrecitem_source=''GL'')
                                       AND (bankrecitem_source_id=gltrans_id)
                                       AND (bankrecitem_bankrec_id=<? value("bankrecid") ?>)
                                       AND (bankrecitem_cleared))
          WHERE ((gltrans_accnt_id=bankaccnt_accnt_id)
            AND (NOT gltrans_deleted)
            AND (NOT gltrans_rec)
            AND (gltrans_amount < 0)
            AND (gltrans_doctype != ''JP'')
            AND (bankaccnt_id=<? value("bankaccntid") ?>) )
          UNION ALL
         SELECT COALESCE( bankrecitem_amount,
                          (currToLocal(bankaccnt_curr_id, sltrans_amount, sltrans_date) * -1.0) ) AS amount
           FROM (bankaccnt CROSS JOIN sltrans)
                      JOIN bankrecitem ON ((bankrecitem_source=''SL'')
                                       AND (bankrecitem_source_id=sltrans_id)
                                       AND (bankrecitem_bankrec_id=<? value("bankrecid") ?>)
                                       AND (bankrecitem_cleared))
          WHERE ((sltrans_accnt_id=bankaccnt_accnt_id)
            AND (NOT sltrans_rec)
            AND (sltrans_amount < 0)
            AND (bankaccnt_id=<? value("bankaccntid") ?>) )
          UNION ALL
         SELECT CASE WHEN(bankadjtype_iscredit=true) THEN (bankadj_amount * -1) ELSE bankadj_amount END AS amount
           FROM bankrecitem, bankadj, bankadjtype
          WHERE ( (bankrecitem_source=''AD'')
            AND (bankrecitem_source_id=bankadj_id)
            AND (bankrecitem_bankrec_id=<? value("bankrecid") ?>)
            AND (bankrecitem_cleared)
            AND (bankadj_bankadjtype_id=bankadjtype_id)
            AND (NOT bankadj_posted)
            AND (((bankadjtype_iscredit=false) AND (bankadj_amount > 0)) OR (bankadjtype_iscredit=true AND (bankadj_amount < 0)))
            AND (bankadj_bankaccnt_id=<? value("bankaccntid") ?>) ) ) AS data;
<? else ?>
SELECT gltrans_id AS id, 1 AS altid,
       jrnluse_use AS use, gltrans_journalnumber AS jrnlnum,
       COALESCE(date(jrnluse_date), gltrans_date) AS f_jrnldate,
       COALESCE(bankrecitem_cleared, FALSE) AS cleared,
       gltrans_date AS f_date,
       gltrans_doctype AS doc_type,
       gltrans_docnumber AS docnumber,
       gltrans_notes AS notes,
       currConcat(COALESCE(cashrcpt_curr_id, baseCurrId())) AS doc_curr,
       COALESCE(bankrecitem_curr_rate, cashrcpt_curr_rate, currRate(bankaccnt_curr_id, gltrans_date)) AS doc_exchrate,
       (gltrans_amount * -1.0) AS base_amount,
       CASE WHEN (bankaccnt_curr_id=cashrcpt_curr_id) THEN
         COALESCE( bankrecitem_amount,
                   cashrcpt_amount,
                   (currToLocal(bankaccnt_curr_id, gltrans_amount, gltrans_date) * -1.0) )
            ELSE
         COALESCE( bankrecitem_amount,
                   (currToLocal(bankaccnt_curr_id, gltrans_amount, gltrans_date) * -1.0) )
       END AS amount,
       COALESCE(date(jrnluse_date), gltrans_date) AS jrnldate,
       gltrans_date AS sortdate,
       ''uomratio'' AS doc_exchrate_xtnumericrole,
       ''curr'' AS base_amount_xtnumericrole,
       ''curr'' AS amount_xtnumericrole
  FROM bankaccnt
  JOIN gltrans ON (bankaccnt_accnt_id=gltrans_accnt_id)
  LEFT OUTER JOIN bankrecitem ON ((bankrecitem_source=''GL'')
                              AND (bankrecitem_source_id=gltrans_id)
                              AND (bankrecitem_bankrec_id=<? value("bankrecid") ?>)
                              AND (bankrecitem_cleared))
  LEFT OUTER JOIN jrnluse ON (jrnluse_number=gltrans_journalnumber AND jrnluse_use=''C/R'')
  LEFT OUTER JOIN cashrcpt  ON ((gltrans_source=''A/R'')
                            AND (gltrans_doctype=''CR'')
                            AND (gltrans_misc_id=cashrcpt_id))
  LEFT OUTER JOIN checkhead ON ((gltrans_doctype=''CK'')
                            AND (gltrans_misc_id=checkhead_id))
 WHERE ((NOT gltrans_deleted)
   AND (NOT gltrans_rec)
   AND (NOT COALESCE(checkhead_void, false))
   AND (gltrans_amount < 0)
   AND (gltrans_doctype != ''JP'')
   AND (bankaccnt_id=<? value("bankaccntid") ?>) )
 UNION ALL
SELECT sltrans_id AS id, 2 AS altid,
       jrnluse_use AS use, sltrans_journalnumber AS jrnlnum,
       COALESCE(date(jrnluse_date), sltrans_date) AS f_jrnldate,
       COALESCE(bankrecitem_cleared, FALSE) AS cleared,
       sltrans_date AS f_date,
       sltrans_doctype AS doc_type,
       sltrans_docnumber AS docnumber,
       sltrans_notes AS notes,
       currConcat(COALESCE(cashrcpt_curr_id, baseCurrId())) AS doc_curr,
       COALESCE(bankrecitem_curr_rate, cashrcpt_curr_rate, currRate(bankaccnt_curr_id, sltrans_date)) AS doc_exchrate,
       (sltrans_amount * -1.0) AS base_amount,
       CASE WHEN (bankaccnt_curr_id=cashrcpt_curr_id) THEN
         COALESCE( bankrecitem_amount,
                   cashrcpt_amount,
                   (currToLocal(bankaccnt_curr_id, sltrans_amount, sltrans_date) * -1.0) )
            ELSE
         COALESCE( bankrecitem_amount,
                   (currToLocal(bankaccnt_curr_id, sltrans_amount, sltrans_date) * -1.0) )
       END AS amount,
       COALESCE(date(jrnluse_date), sltrans_date) AS jrnldate,
       sltrans_date AS sortdate,
       ''uomratio'' AS doc_exchrate_xtnumericrole,
       ''curr'' AS base_amount_xtnumericrole,
       ''curr'' AS amount_xtnumericrole
  FROM bankaccnt
  JOIN sltrans ON (bankaccnt_accnt_id=sltrans_accnt_id)
  LEFT OUTER JOIN bankrecitem ON ((bankrecitem_source=''SL'')
                              AND (bankrecitem_source_id=sltrans_id)
                              AND (bankrecitem_bankrec_id=<? value("bankrecid") ?>)
                              AND (bankrecitem_cleared))
  LEFT OUTER JOIN jrnluse ON (jrnluse_number=sltrans_journalnumber AND jrnluse_use=''C/R'')
  LEFT OUTER JOIN cashrcpt  ON ((sltrans_source=''A/R'')
                            AND (sltrans_doctype=''CR'')
                            AND (sltrans_misc_id=cashrcpt_id))
  LEFT OUTER JOIN checkhead ON ((sltrans_doctype=''CK'')
                            AND (sltrans_misc_id=checkhead_id))
 WHERE ((NOT sltrans_rec)
   AND (NOT COALESCE(checkhead_void, false))
   AND (sltrans_amount < 0)
   AND (bankaccnt_id=<? value("bankaccntid") ?>) )
 UNION ALL
SELECT bankadj_id AS id, 3 AS altid,
       '''' AS use, NULL AS jrnlnum, bankadj_date AS f_jrnldate,
       COALESCE(bankrecitem_cleared, FALSE) AS cleared,
       bankadj_date AS f_date,
       ''ADJ'' AS doc_type,
       bankadj_docnumber AS docnumber,
       bankadjtype_name AS notes,
       currConcat(bankadj_curr_id) AS doc_curr,
       1.0 AS doc_exchrate,
       CASE WHEN(bankadjtype_iscredit=true) THEN (bankadj_amount * -1.0) ELSE bankadj_amount END AS base_amount,
       CASE WHEN(bankadjtype_iscredit=true) THEN (bankadj_amount * -1.0) ELSE bankadj_amount END AS amount,
       bankadj_date AS jrnldate,
       bankadj_date AS sortdate,
       ''uomratio'' AS doc_exchrate_xtnumericrole,
       ''curr'' AS base_amount_xtnumericrole,
       ''curr'' AS amount_xtnumericrole
  FROM (bankadjtype CROSS JOIN bankadj)
               LEFT OUTER JOIN bankrecitem ON ((bankrecitem_source=''AD'')
                                           AND (bankrecitem_source_id=bankadj_id)
                                           AND (bankrecitem_bankrec_id=<? value("bankrecid") ?>))
 WHERE ( (((bankadjtype_iscredit=false) AND (bankadj_amount > 0)) OR ((bankadjtype_iscredit=true) AND (bankadj_amount < 0)))
   AND (bankadj_bankadjtype_id=bankadjtype_id)
   AND (NOT bankadj_posted)
   AND (bankadj_bankaccnt_id=<? value("bankaccntid") ?>) )
ORDER BY jrnldate, jrnlnum, sortdate;
<? endif ?>
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (99, 'contacts', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: contacts
-- Name: detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT DISTINCT ON (length(cntct_last_name)=0, length(cntct_first_name)=0, cntct_last_name, cntct_first_name, cntct_number) 
  cntct_id AS id
<? if not exists("idOnly") ?> 
, addr_id AS altId, addr.*,
  crmacct_id, crmacct_number, crmacct_name,
  cntct.* 
<? foreach("char_id_text_list") ?>
  , charass_alias<? literal("char_id_text_list") ?>.charass_value AS char<? literal("char_id_text_list") ?>
<? endforeach ?>
<? foreach("char_id_list_list") ?>
  , charass_alias<? literal("char_id_list_list") ?>.charass_value AS char<? literal("char_id_list_list") ?>
<? endforeach ?>
<? foreach("char_id_date_list") ?>
  , charass_alias<? literal("char_id_date_list") ?>.charass_value::date AS char<? literal("char_id_date_list") ?>
<? endforeach ?>
<? endif ?>
<? if exists("hasContext") ?>
FROM cntct
<? else ?>
FROM cntct()
<? endif ?>
  LEFT OUTER JOIN crmacct ON (cntct_crmacct_id=crmacct_id) 
  LEFT OUTER JOIN addr ON (cntct_addr_id=addr_id) 
  LEFT OUTER JOIN cntcteml ON (cntcteml_cntct_id=cntct_id)
<? foreach("char_id_text_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_text_list") ?> ON ((charass_alias<? literal("char_id_text_list") ?>.charass_target_type=''CNTCT'') 
                                                                    AND  (charass_alias<? literal("char_id_text_list") ?>.charass_target_id=cntct_id)
                                                                    AND  (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=<? value("char_id_text_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_text_list") ?> ON (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=char_alias<? literal("char_id_text_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_list_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_list_list") ?> ON ((charass_alias<? literal("char_id_list_list") ?>.charass_target_type=''CNTCT'') 
                                                                    AND  (charass_alias<? literal("char_id_list_list") ?>.charass_target_id=cntct_id)
                                                                    AND  (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=<? value("char_id_list_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_list_list") ?> ON (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=char_alias<? literal("char_id_list_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_date_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_date_list") ?> ON ((charass_alias<? literal("char_id_date_list") ?>.charass_target_type=''CNTCT'') 
                                                                    AND  (charass_alias<? literal("char_id_date_list") ?>.charass_target_id=cntct_id)
                                                                    AND  (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=<? value("char_id_date_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_date_list") ?> ON (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=char_alias<? literal("char_id_date_list") ?>.char_id)
<? endforeach ?>
WHERE true
<? if exists("owner_username") ?> 
  AND (cntct_owner_username=<? value("owner_username") ?>) 
<? elseif exists("owner_usr_pattern") ?>
  AND (cntct_owner_username ~ <? value("owner_usr_pattern") ?>) 
<? endif ?>
<? if exists("activeOnly") ?> 
  AND cntct_active
<? endif ?>
<? if exists("search_pattern") ?>
  AND (
 (crmacct_number ~* <? value("search_pattern") ?>)
  OR (crmacct_name ~* <? value("search_pattern") ?>)
  OR (COALESCE(cntct_first_name,'''') || '' '' || COALESCE(cntct_last_name,'''') ~* <? value("search_pattern") ?>)
  OR (COALESCE(cntct_phone,'''') || '' '' || COALESCE(cntct_phone2,'''') || '' '' || COALESCE(cntct_fax,'''') ~* <? value("search_pattern") ?>)
  OR (COALESCE(cntcteml_email,'''') ~* <? value("search_pattern") ?>)
  OR (COALESCE(addr_line1,'''') || '' '' || COALESCE(addr_line2,'''') || '' '' || COALESCE(addr_line3,'''') ~* <? value("search_pattern") ?>)
  OR (COALESCE(addr_city,'''') ~* <? value("search_pattern") ?>)
  OR (COALESCE(addr_state,'''') ~* <? value("search_pattern") ?>)
  OR (COALESCE(addr_postalcode,'''') ~* <? value("search_pattern") ?>)
  OR (COALESCE(addr_country,'''') ~* <? value("search_pattern") ?>)
)
<? endif ?>
<? if exists("cntct_id") ?>
  AND (cntct_id=<? value("cntct_id")?>)
<? endif ?>
<? if exists("crmacct_id") ?>
  AND (crmacct_id=<? value("crmacct_id")?>)
<? endif ?>
<? if exists("cntct_name_pattern") ?>
  AND (COALESCE(cntct_first_name,'''') || '' '' || COALESCE(cntct_last_name,'''') ~* <? value("cntct_name_pattern") ?>)
<? endif ?>
<? if exists("cntct_phone_pattern") ?>
  AND (COALESCE(cntct_phone,'''') || '' '' || COALESCE(cntct_phone2,'''') || '' '' || COALESCE(cntct_fax,'''') ~* <? value("cntct_phone_pattern") ?>)
<? endif ?>
<? if exists("cntct_email_pattern") ?>
  AND (COALESCE(cntcteml_email,'''') ~* <? value("cntct_email_pattern") ?>)
<? endif ?>
<? if exists("addr_street_pattern") ?>
  AND (COALESCE(addr_line1,'''') || '' '' || COALESCE(addr_line2,'''') || '' '' || COALESCE(addr_line3,'''') ~* <? value("addr_street_pattern") ?>)
<? endif ?>
<? if exists("addr_city_pattern") ?>
  AND (COALESCE(addr_city,'''') ~* <? value("addr_city_pattern") ?>)
<? endif ?>
<? if exists("addr_state_pattern") ?>
  AND (COALESCE(addr_state,'''') ~* <? value("addr_state_pattern") ?>)
<? endif ?>
<? if exists("addr_postalcode_pattern") ?>
  AND (COALESCE(addr_postalcode,'''') ~* <? value("addr_postalcode_pattern") ?>)
<? endif ?>
<? if exists("addr_country_pattern") ?>
  AND (COALESCE(addr_country,'''') ~* <? value("addr_country_pattern") ?>)
<? endif ?>
<? if exists("id") ?>
  AND (cntct_id=<? literal("id") ?>)
<? endif ?>
<? if exists("addr_id") ?>
  AND (addr_id=<? value("addr_id") ?>)
<? endif ?>
<? literal("charClause") ?>
ORDER BY length(cntct_last_name)=0, length(cntct_first_name)=0, cntct_last_name, cntct_first_name, cntct_number, cntcteml_primary desc;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (105, 'bankrecHistory', 'reconciled', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: bankrecHistory
-- Name: reconciled
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

<? if exists("treeView") ?>
SELECT -1 AS gltrans_id, bankrec_opendate AS gltrans_date, formatDate(bankrec_opendate) AS f_date,
       <? value("openingBalance") ?> AS gltrans_docnumber, <? value("openingBalance") ?> AS type, 0 AS sort, NULL AS gltrans_notes, 
       bankrec_openbal AS amount, formatMoney(bankrec_openbal) AS f_amount,
       ''curr'' AS amount_xtnumericrole,
       0 AS xtindentrole
  FROM bankrec
  WHERE (bankrec_id=<? value("bankrec_id") ?>)
  
UNION
<? endif ?>

SELECT gltrans_id, gltrans_date, formatDate(gltrans_date) AS f_date,
       gltrans_docnumber,
       CASE WHEN gltrans_doctype = ''CK'' THEN <? value("Checks") ?>
            WHEN gltrans_doctype = ''CR'' THEN <? value("Deposits") ?>
            ELSE <? value("Adjustments") ?> END AS type,
       CASE WHEN gltrans_doctype = ''CK'' THEN 1
            WHEN gltrans_doctype = ''CR'' THEN 2
            ELSE ''3'' END AS sort,
       gltrans_notes AS notes,
       COALESCE( bankrecitem_amount,
                 (currtolocal(bankaccnt_curr_id, gltrans_amount, gltrans_date) * -1.0) ) AS amount,
       formatMoney(COALESCE( bankrecitem_amount,
                             (currtolocal(bankaccnt_curr_id, gltrans_amount, gltrans_date) * -1.0) ) ) AS f_amount,
       ''curr'' AS amount_xtnumericrole,
       1 AS xtindentrole
  FROM gltrans, bankrecitem 
    JOIN bankrec ON (bankrecitem_bankrec_id=bankrec_id)
    JOIN bankaccnt ON (bankaccnt_id=bankrec_bankaccnt_id)
 WHERE ((bankrecitem_bankrec_id=<? value("bankrec_id") ?>)
   AND (bankrecitem_source=''GL'')
   AND (bankrecitem_source_id=gltrans_id) ) 

UNION

SELECT sltrans_id, sltrans_date, formatDate(sltrans_date) AS f_date,
       sltrans_docnumber,
       CASE WHEN sltrans_doctype = ''CK'' THEN <? value("Checks") ?>
            WHEN sltrans_doctype = ''CR'' THEN <? value("Deposits") ?>
            ELSE <? value("Adjustments") ?> END AS type,
       CASE WHEN sltrans_doctype = ''CK'' THEN 1
            WHEN sltrans_doctype = ''CR'' THEN 2
            ELSE ''3'' END AS sort,
       sltrans_notes AS notes,
       COALESCE( bankrecitem_amount,
                 (currtolocal(bankaccnt_curr_id, sltrans_amount, sltrans_date) * -1.0) ) AS amount,
       formatMoney(COALESCE( bankrecitem_amount,
                             (currtolocal(bankaccnt_curr_id, sltrans_amount, sltrans_date) * -1.0) ) ) AS f_amount,
       ''curr'' AS amount_xtnumericrole,
       1 AS xtindentrole
  FROM sltrans, bankrecitem 
    JOIN bankrec ON (bankrecitem_bankrec_id=bankrec_id)
    JOIN bankaccnt ON (bankaccnt_id=bankrec_bankaccnt_id)
 WHERE ((bankrecitem_bankrec_id=<? value("bankrec_id") ?>)
   AND (bankrecitem_source=''SL'')
   AND (bankrecitem_source_id=sltrans_id) ) 

<? if exists("treeView") ?>
UNION

SELECT -1 AS gltrans_id, bankrec_enddate, formatDate(bankrec_enddate) AS f_date,
       <? value("closingBalance") ?>, <? value("closingBalance") ?> AS type, 7 AS sort, NULL, 
       bankrec_endbal AS amount, formatMoney(bankrec_endbal) AS f_amount,
       ''curr'' AS amount_xtnumericrole,
       0 AS xtindentrole
  FROM bankrec
  WHERE (bankrec_id=<? value("bankrec_id") ?>)

UNION
SELECT -1, NULL, NULL, <? value("Checks") ?>, NULL, 1, NULL, NULL, NULL, ''curr'', 0 
UNION
SELECT -1, NULL, NULL, <? value("Deposits") ?>, NULL, 2, NULL, NULL, NULL, ''curr'', 0 
UNION
SELECT -1, NULL, NULL, <? value("Adjustments") ?>, NULL, 3, NULL, NULL, NULL, ''curr'', 0 
<? endif ?>

ORDER BY  sort, xtindentrole, type, f_date, gltrans_id
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (253, 'inventoryAvailabilitybyWorkorder', 'detail', 'used by dspInventoryAvailabilityByWorkOrder Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: inventoryAvailabilitybyWorkorder
-- Name: detail
-- Notes: used by dspInventoryAvailabilityByWorkOrder
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT *, ''qty'' AS woinvav_qoh_xtnumericrole,
       ''qty'' AS woinvav_balance_xtnumericrole,
       ''qty'' AS woinvav_allocated_xtnumericrole,
       ''qty'' AS woinvav_ordered_xtnumericrole,
       ''qty'' AS woinvav_woavail_xtnumericrole,
       ''qty'' AS woinvav_totalavail_xtnumericrole,
       CASE WHEN (woinvav_womatl_id) = -1 THEN ''altemphasis''
            WHEN (woinvav_qoh < 0) THEN ''error''
            WHEN (woinvav_qoh < woinvav_reorderlevel) THEN ''warning''
            WHEN ((woinvav_qoh - woinvav_balance) < 0) THEN ''altemphasis''
            WHEN ((woinvav_qoh - woinvav_allocated) < 0) THEN ''altemphasis''
       END AS woinvav_qoh_qtforegroundrole,
       CASE WHEN (woinvav_womatl_id) = -1 THEN ''altemphasis''
            WHEN ((woinvav_qoh + woinvav_ordered - woinvav_balance) < 0) THEN ''error''
            WHEN ((woinvav_qoh + woinvav_ordered - woinvav_balance) < woinvav_reorderlevel) THEN ''warning''
       END AS woinvav_woavail_qtforegroundrole,
       CASE WHEN (woinvav_womatl_id) = -1 THEN ''altemphasis''
            WHEN ((woinvav_qoh + woinvav_ordered - woinvav_allocated) < 0) THEN ''error''
            WHEN ((woinvav_qoh + woinvav_ordered - woinvav_allocated) < woinvav_reorderlevel) THEN ''warning''
       END AS woinvav_totalavail_qtforegroundrole,
       CASE WHEN (woinvav_womatl_id = -1) THEN ''altemphasis''
         ELSE null
       END AS qtforegroundrole,
       woinvav_level AS xtindentrole
FROM woinvavail(<? value("wo_id") ?>,
<? if exists("IndentedParentChild") ?>
                true,
<? else ?>
                false,
<? endif ?>
<? if exists("summarizedParentChild") ?>
                true,
<? else ?>
                false,
<? endif ?>
<? if exists("onlyShowShortages") ?>
                true,
<? else ?>
                false,
<? endif ?>
<? if exists("onlyShowInsufficientInventory") ?>
                true
<? else ?>
                false
<? endif ?>
               ) AS data;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (474, 'contracts', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: contracts
-- Name: detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT contrct_id, 
       vend_number, vend_name, 
       contrct.*,
       CASE WHEN COALESCE(contrct_effective, startOfTime()) <=
                 startOfTime() THEN <? value("always") ?>
       END AS contrct_effective_qtdisplayrole,
       CASE WHEN COALESCE(contrct_expires, endOfTime()) >=
                 endOfTime() THEN <? value("never") ?>
       END AS contrct_expires_qtdisplayrole,
       CASE WHEN (COALESCE(contrct_expires, endOfTime()) < CURRENT_DATE) THEN ''expired''
            WHEN (COALESCE(contrct_effective, startOfTime()) > CURRENT_DATE) THEN ''future''
       END AS qtforegroundrole,
       (SELECT count(*) FROM itemsrc WHERE (itemsrc_contrct_id=contrct_id)) AS item_count 
FROM contrct JOIN vendinfo ON (vend_id=contrct_vend_id)
WHERE ((true)
<? if exists("vend_id") ?>
  AND (contrct_vend_id=<? value("vend_id") ?>)
<? endif ?>
<? if exists("effectiveStartDate") ?>
  AND (contrct_effective >= <? value("effectiveStartDate") ?>)
<? endif ?>
<? if exists("effectiveEndDate") ?>
  AND (contrct_effective <= <? value("effectiveEndDate") ?>)
<? endif ?>
<? if exists("expireStartDate") ?>
  AND (contrct_expires >= <? value("expireStartDate") ?>)
<? endif ?>
<? if exists("expireEndDate") ?>
  AND (contrct_expires <= <? value("expireEndDate") ?>)
<? endif ?>
<? if exists("search_pattern") ?>
  AND ( (contrct_number ~* <? value("search_pattern") ?>)
    OR  (COALESCE(contrct_descrip,'''') ~* <? value("search_pattern") ?>) )
<? endif ?>
)
ORDER By vend_number, contrct_number
;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (97, 'checks', 'detail', 'used by printChecks Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: checks
-- Name: detail
-- Notes: used by printChecks
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT checkhead.*, form_report_name AS report_name
FROM checkhead
LEFT OUTER JOIN vendinfo ON((checkhead_recip_id = vend_id)
                        AND (checkhead_recip_type = ''V''))
LEFT OUTER JOIN custinfo ON((checkhead_recip_id = cust_id)
                        AND (checkhead_recip_type = ''C''))
LEFT OUTER JOIN taxauth ON((checkhead_recip_id = taxauth_id)
                       AND (checkhead_recip_type = ''T'')),
     bankaccnt, form
WHERE ( (checkhead_bankaccnt_id=bankaccnt_id)
  AND   (bankaccnt_check_form_id=form_id)
<? if exists("toPrintOnly") ?>
  AND   (NOT checkhead_printed)
  AND   (NOT checkhead_void)
<? endif ?>
<? if exists("bankaccnt_id") ?>
  AND   (bankaccnt_id=<? value("bankaccnt_id" ?>)
<? endif ?>
      )
<? if exists("orderByName") ?>
ORDER BY checkhead_recip_type DESC, COALESCE(vend_name, cust_name, taxauth_name)
<? else ?>
ORDER BY checkhead_recip_type DESC, COALESCE(vend_number, cust_number, taxauth_code)
<? endif ?>
<? if exists("numtoprint") ?>
LIMIT <? value("numtoprint") ?>
<? endif ?>
;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (35, 'allocations', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: allocations
-- Name: detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT source_id, type, order_number, item_number, totalqty, relievedqty, balanceqty, duedate,
       balanceqty AS runningbal,
       ''qty'' AS totalqty_xtnumericrole,
       ''qty'' AS relievedqty_xtnumericrole,
       ''qty'' AS balanceqty_xtnumericrole,
       0 AS runningbal_xtrunningrole,
       ''qty'' AS runningbal_xtnumericrole,
       CASE WHEN (duedate < CURRENT_DATE) THEN ''error''
       END AS duedate_qtforegroundrole
FROM
(
SELECT womatl_id AS source_id, TEXT(''W/O'') AS type,
       formatWoNumber(wo_id) AS order_number,
       paritem.item_number,
       itemuomtouom(component.itemsite_item_id, womatl_uom_id, NULL, womatl_qtyreq)  AS totalqty,
       itemuomtouom(component.itemsite_item_id, womatl_uom_id, NULL, womatl_qtyiss) AS relievedqty,
       itemuomtouom(component.itemsite_item_id, womatl_uom_id, NULL, noNeg(womatl_qtyreq - womatl_qtyiss)) AS balanceqty,
       womatl_duedate AS duedate

FROM womatl, wo, itemsite AS parent, itemsite AS component, item AS paritem, item AS compitem
WHERE ((womatl_wo_id=wo_id)
  AND (wo_status<>''C'')
  AND (wo_itemsite_id=parent.itemsite_id)
  AND (womatl_itemsite_id=component.itemsite_id)
  AND (parent.itemsite_item_id=paritem.item_id)
  AND (component.itemsite_item_id=compitem.item_id)
  AND (compitem.item_type != ''T'')
  AND (component.itemsite_warehous_id=<? value("warehous_id") ?>)
  AND (component.itemsite_item_id=<? value("item_id") ?>)
<? if exists("leadTime") ?>
  AND (womatl_duedate <= (CURRENT_DATE + component.itemsite_leadtime))
<? elseif exists("days") ?>
  AND (womatl_duedate <= (CURRENT_DATE + <? value("days") ?>))
<? elseif exists("date") ?>
  AND (womatl_duedate <= <? value("date") ?>)
<? elseif exists("startDate") ?>
  AND (womatl_duedate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
)

UNION 

-- Special handling for tools
SELECT womatl_id AS source_id, TEXT(''W/O'') AS type,
       formatWoNumber(wo_id) AS order_number,
       paritem.item_number,
       itemuomtouom(component.itemsite_item_id, womatl_uom_id, NULL, womatl_qtyreq)  AS totalqty,
       COALESCE(sum(invhist_invqty),0) AS relievedqty,
       noNeg(itemuomtouom(component.itemsite_item_id, womatl_uom_id, NULL, womatl_qtyreq) - COALESCE(sum(invhist_invqty),0)) AS balanceqty,
       womatl_duedate AS duedate

FROM itemsite AS parent, itemsite AS component, item paritem, item AS compitem, wo, womatl
  LEFT OUTER JOIN womatlpost ON (womatl_id=womatlpost_womatl_id)
  LEFT OUTER JOIN invhist ON ((womatlpost_invhist_id=invhist_id)
                          AND (invhist_invqty > 0))
WHERE ((womatl_wo_id=wo_id)
  AND (wo_status<>''C'')
  AND (wo_itemsite_id=parent.itemsite_id)
  AND (womatl_itemsite_id=component.itemsite_id)
  AND (parent.itemsite_item_id=paritem.item_id)
  AND (component.itemsite_item_id=compitem.item_id)
  AND (compitem.item_type=''T'')
  AND (component.itemsite_warehous_id=<? value("warehous_id") ?>)
  AND (component.itemsite_item_id=<? value("item_id") ?>)
<? if exists("leadTime") ?>
  AND (womatl_duedate <= (CURRENT_DATE + component.itemsite_leadtime))
<? elseif exists("days") ?>
  AND (womatl_duedate <= (CURRENT_DATE + <? value("days") ?>))
<? elseif exists("date") ?>
  AND (womatl_duedate <= <? value("date") ?>)
<? elseif exists("startDate") ?>
  AND (womatl_duedate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
)
GROUP BY womatl_id, wo_id, paritem.item_number, womatl_uom_id, womatl_qtyreq, womatl_duedate, component.itemsite_item_id

UNION 
SELECT coitem_id AS source_id, TEXT(''S/O'') AS type,
       formatSoNumber(coitem_id) AS order_number,
       item_number,
       itemuomtouom(itemsite_item_id, coitem_qty_uom_id, NULL, coitem_qtyord) AS totalqty,
       itemuomtouom(itemsite_item_id, coitem_qty_uom_id, NULL, (coitem_qtyshipped + qtyAtShipping(coitem_id)) - coitem_qtyreturned) as relievedqty,
       itemuomtouom(itemsite_item_id, coitem_qty_uom_id, NULL, noNeg(coitem_qtyord - (coitem_qtyshipped + qtyAtShipping(coitem_id)) + coitem_qtyreturned)) AS balanceqty,
       coitem_scheddate as duedate
FROM cohead, coitem, itemsite, item 
WHERE ( (coitem_cohead_id=cohead_id)
  AND  (coitem_itemsite_id=itemsite_id)
  AND  (itemsite_item_id=item_id)
  AND  (item_sold)
  AND  (coitem_status NOT IN (''C'',''X''))
  AND  (itemsite_warehous_id=<? value("warehous_id") ?>)
  AND  (itemsite_item_id=<? value("item_id") ?>)
<? if exists("leadTime") ?>
  AND  (coitem_scheddate <= (CURRENT_DATE + itemsite_leadtime))
<? elseif exists("days") ?>
  AND  (coitem_scheddate <= (CURRENT_DATE + <? value("days") ?>))
<? elseif exists("date") ?>
  AND  (coitem_scheddate <= <? value("date") ?>)
<? elseif exists("startDate") ?>
  AND  (coitem_scheddate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
)

<? if exists("MultiWhs") ?>
UNION 
SELECT toitem_id AS source_id, TEXT(''T/O'') AS type,
       TEXT(tohead_number) AS order_number,
       item_number,
       toitem_qty_ordered AS totalqty,
       (toitem_qty_shipped + qtyAtShipping(toitem_id)) as relievedqty,
       noNeg(toitem_qty_ordered - (toitem_qty_shipped + qtyAtShipping(toitem_id))) AS balanceqty,
       toitem_schedshipdate as duedate
FROM tohead, toitem, itemsite, item 
WHERE ((toitem_tohead_id=tohead_id)
  AND  (toitem_item_id=itemsite_item_id)
  AND  (tohead_src_warehous_id=<? value("warehous_id") ?>)
  AND  (itemsite_item_id=item_id)
  AND  (toitem_status NOT IN (''C'',''X''))
  AND  (itemsite_warehous_id=<? value("warehous_id") ?>)
  AND  (itemsite_item_id=<? value("item_id") ?>)
<? if exists("leadTime") ?>
  AND  (toitem_schedshipdate <= (CURRENT_DATE + itemsite_leadtime))
<? elseif exists("days") ?>
  AND  (toitem_schedshipdate <= (CURRENT_DATE + <? value("days") ?>))
<? elseif exists("date") ?>
  AND  (toitem_schedshipdate <= <? value("date") ?>)
<? elseif exists("startDate") ?>
  AND  (toitem_schedshipdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
)
<? endif ?>
) AS dummy

ORDER BY duedate;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (482, 'contract', 'itemsources', 'Selection of Contract Related Item Sources', '-- Group: contract
-- Name:  itemsources
-- Notes: Selection of Contract Related Item Sources
SELECT itemsrc_id,
	-1 AS pohead_id, 
	'' '' AS seq,
	'' '' AS poitem_ordnumber, 
        item_number,
	item_descrip1,
	itemsrc_vend_uom,
	itemsrc_vend_item_number,
	itemsrc_contrct_min,
	sum(poitem_qty_unreleased) AS poitem_qty_unreleased,
	sum(poitem_qty_ordered)    AS poitem_qty_ordered,
	sum(poitem_qty_received)   AS poitem_qty_received,
	sum(poitem_qty_returned)   AS poitem_qty_returned,
	null AS poitem_duedate,
	null AS poitem_status,
	0 AS xtindentrole 
	FROM (SELECT contrct_id, 
		itemsrc_id,
		pohead_number || ''-'' || ltrim(to_char(poitem_linenumber, ''999'')) AS poitem_ordnumber, 
		item_number,
		item_descrip1,
		itemsrc_vend_uom,
		itemsrc_vend_item_number,
		itemsrc_contrct_min,
		CASE WHEN poitem_status = ''U'' THEN poitem_qty_ordered
		  ELSE 0
		END AS poitem_qty_unreleased,
		CASE WHEN poitem_status = ''O'' THEN poitem_qty_ordered
		     WHEN poitem_status = ''C'' THEN poitem_qty_ordered
                  ELSE 0
		END AS poitem_qty_ordered,
		poitem_qty_received,
		poitem_qty_returned,
		poitem_duedate, 
		poitem_status
		FROM contrct JOIN itemsrc  ON (itemsrc_contrct_id  = contrct_id)
		  LEFT OUTER JOIN poitem   ON (poitem_itemsrc_id   = itemsrc_id)
		  LEFT OUTER JOIN pohead   ON (pohead_id           = poitem_pohead_id)
			     JOIN item     ON (itemsrc_item_id     = item_id)
		WHERE (contrct_id = <? value("contrct_id") ?>)) AS dummy1
	WHERE (contrct_id = <? value("contrct_id") ?>)
	GROUP BY itemsrc_id, itemsrc_vend_item_number, itemsrc_vend_uom, itemsrc_contrct_min,
                item_number, item_descrip1

UNION  -- PO Line Items

SELECT itemsrc_id,
	pohead_id, 
	pohead_number || ''-'' || ltrim(to_char(poitem_linenumber, ''999'')) AS seq,
        pohead_number || ''-'' || ltrim(to_char(poitem_linenumber, ''999'')) AS poitem_ordnumber,  
        null AS item_number,
	null AS item_descrip1,
	null AS itemsrc_vend_uom,
	null AS itemsrc_vend_item_number,
	null AS itemsrc_contrct_min,
	CASE WHEN poitem_status = ''U'' THEN poitem_qty_ordered
	  ELSE 0
	END AS poitem_qty_unreleased,
	CASE WHEN poitem_status = ''O'' THEN poitem_qty_ordered
	     WHEN poitem_status = ''C'' THEN poitem_qty_ordered
          ELSE 0
	END AS poitem_qty_ordered,
	poitem_qty_received,
	poitem_qty_returned,
	poitem_duedate, 
	CASE WHEN poitem_status = ''O'' THEN ''Open''
	     WHEN poitem_status = ''C'' THEN ''Closed''
	     ELSE ''Unreleased''
	END AS poitem_status,
	1 AS xtindentrole 
	FROM contrct JOIN itemsrc  ON (itemsrc_contrct_id  = contrct_id)
		     JOIN poitem   ON (poitem_itemsrc_id   = itemsrc_id)
		     JOIN pohead   ON (pohead_id           = poitem_pohead_id)
		     JOIN itemsite ON (poitem_itemsite_id  = itemsite_id)
		     JOIN item     ON (itemsite_item_id    = item_id)
	WHERE (contrct_id = <? value("contrct_id") ?>)

UNION -- Receipts

SELECT itemsrc_id,
	pohead_id,  
	poitem_ordnumber || ''R'' || to_char(recv_date, ''YYYYMMDDHH24:MI:SS'') AS seq,
	''Receipt'' AS poitem_ordnumber,
	null AS item_number,
	null AS item_descrip1,
	recv_vend_uom AS vend_uom,
	null AS itemsrc_vend_item_number,
	null AS itemsrc_contrct_min,
	null AS poitem_qty_unreleased,
	null AS poitem_qty_ordered,
	recv_qty AS poitem_qty_received,
	null AS poitem_qty_returned,
	recv_date AS poitem_duedate,
	recv_trans_usr_name AS username,
	2 AS xtindentrole
  FROM recv JOIN (SELECT pohead_number || ''-'' || ltrim(to_char(poitem_linenumber, ''999'')) AS poitem_ordnumber, 
			    poitem_pohead_id, poitem_linenumber, poitem_id, pohead_id, 
			    poitem_itemsrc_id
			FROM poitem JOIN pohead ON (pohead_id = poitem_pohead_id)) AS dummy ON (poitem_id   = recv_orderitem_id)
               JOIN itemsite ON (itemsite_id = recv_itemsite_id)
               JOIN item     ON (item_id     = itemsite_item_id)
               JOIN itemsrc  ON (poitem_itemsrc_id = itemsrc_id)
  WHERE (itemsrc_contrct_id = <? value("contrct_id") ?>) 

UNION -- Returns

SELECT itemsrc_id, 
	pohead_id,  
	poitem_ordnumber || ''R'' || to_char(poreject_date, ''YYYYMMDDHH24:MI:SS'') AS seq,
	''Return'' AS poitem_ordnumber,
	null AS item_number,
	null AS item_descrip1,
	poreject_vend_uom AS vend_uom,
	null AS itemsrc_vend_item_number,
	null AS itemsrc_contrct_min,
	null AS poitem_qty_unreleased,
	null AS poitem_qty_ordered,
	null AS poitem_qty_received,
	poreject_qty AS poitem_qty_returned,
	poreject_date AS poitem_duedate,
	poreject_trans_username AS username,
	2 AS xtindentrole 
  FROM poreject JOIN (SELECT pohead_number || ''-'' || ltrim(to_char(poitem_linenumber, ''999'')) AS poitem_ordnumber, 
			    poitem_pohead_id, poitem_linenumber, poitem_id, pohead_id, 
			    poitem_itemsrc_id
			FROM poitem JOIN pohead ON (pohead_id = poitem_pohead_id)) AS dummy ON (poitem_id   = poreject_poitem_id)
               JOIN itemsite ON (itemsite_id = poreject_itemsite_id)
               JOIN item     ON (item_id     = itemsite_item_id)
               JOIN itemsrc  ON (poitem_itemsrc_id = itemsrc_id)
  WHERE (itemsrc_contrct_id = <? value("contrct_id") ?>) 

ORDER BY itemsrc_id, seq, poitem_ordnumber, poitem_duedate, xtindentrole;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (37, 'arAging', 'detail', 'used by dspTimePhasedOpenARItems Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: arAging
-- Name: detail
-- Notes: used by dspTimePhasedOpenARItems
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT araging_cust_id, araging_cust_number, araging_cust_name,
       SUM(araging_total_val) AS araging_total_val_sum,
       SUM(araging_cur_val) AS araging_cur_val_sum,
       SUM(araging_thirty_val) AS araging_thirty_val_sum,
       SUM(araging_sixty_val) AS araging_sixty_val_sum,
       SUM(araging_ninety_val) AS araging_ninety_val_sum,
       SUM(araging_plus_val) AS araging_plus_val_sum,
       ''curr'' AS araging_total_val_sum_xtnumericrole,
       ''curr'' AS araging_cur_val_sum_xtnumericrole,
       ''curr'' AS araging_thirty_val_sum_xtnumericrole,
       ''curr'' AS araging_sixty_val_sum_xtnumericrole,
       ''curr'' AS araging_ninety_val_sum_xtnumericrole,
       ''curr'' AS araging_plus_val_sum_xtnumericrole,
       0 AS araging_total_val_sum_xttotalrole,
       0 AS araging_cur_val_sum_xttotalrole,
       0 AS araging_thirty_val_sum_xttotalrole,
       0 AS araging_sixty_val_sum_xttotalrole,
       0 AS araging_ninety_val_sum_xttotalrole,
       0 AS araging_plus_val_sum_xttotalrole

FROM araging(<? value("relDate") ?>, <? value("useDocDate") ?>) 
<? if exists("cust_id") ?>
WHERE (araging_cust_id=<? value("cust_id") ?>)
<? elseif exists("custtype_id") ?>
WHERE (araging_cust_custtype_id=<? value("custtype_id") ?>)
<? elseif exists("custgrp_id") ?>
LEFT OUTER JOIN custgrpitem ON (araging_cust_id = custgrpitem_cust_id)
WHERE (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)
<? elseif exists("custtype_pattern") ?>
WHERE (araging_custtype_code ~ <? value("custtype_pattern") ?>)
<? endif ?>
GROUP BY araging_cust_number,araging_cust_id,araging_cust_name
ORDER BY araging_cust_number;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (38, 'arApplications', 'detail', 'used by dspARApplications Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: arApplications
-- Name: detail
-- Notes: used by dspARApplications
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT arapply.*,
       cust_number, cust_name,
       CASE WHEN (arapply_source_doctype=''C'') THEN <? value("creditMemo") ?>
            WHEN (arapply_source_doctype=''R'') THEN <? value("cashdeposit") ?>
            WHEN (arapply_fundstype=''C'') THEN <? value("check") ?>
            WHEN (arapply_fundstype=''T'') THEN <? value("certifiedCheck") ?>
            WHEN (arapply_fundstype=''M'') THEN <? value("masterCard") ?>
            WHEN (arapply_fundstype=''V'') THEN <? value("visa") ?>
            WHEN (arapply_fundstype=''A'') THEN <? value("americanExpress") ?>
            WHEN (arapply_fundstype=''D'') THEN <? value("discoverCard") ?>
            WHEN (arapply_fundstype=''R'') THEN <? value("otherCreditCard") ?>
            WHEN (arapply_fundstype=''K'') THEN <? value("cash") ?>
            WHEN (arapply_fundstype=''W'') THEN <? value("wireTransfer") ?>
            WHEN (arapply_fundstype=''O'') THEN <? value("other") ?>
       END AS doctype,
       CASE WHEN (arapply_source_doctype=''C'') THEN <? value("creditMemo") ?>
            WHEN (arapply_source_doctype=''R'') THEN <? value("cashdeposit") ?>
            WHEN (arapply_source_doctype=''K'') THEN <? value("apcheck") ?>
            ELSE <? value("other") ?>
       END AS sourcedoctype,
       CASE WHEN (arapply_target_doctype=''D'') THEN <? value("debitMemo") ?>
            WHEN (arapply_target_doctype=''I'') THEN <? value("invoice") ?>
            WHEN (arapply_target_doctype=''K'') THEN <? value("apcheck") ?>
            ELSE <? value("other") ?>
       END AS targetdoctype,
       CASE WHEN (arapply_source_doctype IN (''C'',''R'')) THEN TEXT(arapply_source_docnumber)
            ELSE arapply_refnumber
       END AS source,
       TEXT(arapply_target_docnumber) AS target,
       currConcat(arapply_curr_id) AS currAbbr,
       currtobase(arapply_curr_id,arapply_applied,arapply_postdate) AS base_applied,
       ''curr'' AS arapply_applied_xtnumericrole,
       ''curr'' AS base_applied_xtnumericrole,
       0 AS base_applied_xttotalrole
FROM arapply, custinfo
WHERE ( (arapply_cust_id=cust_id)
  AND   (arapply_postdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
  AND   (arapply_source_doctype IN (
<? if exists("includeCreditMemos") ?>
  <? if exists("includeCashReceipts") ?>
            ''K'', ''C'', ''R''
  <? else ?>
            ''C'', ''R''
  <? endif ?>
<? else ?>
            ''K''
<? endif ?> ))
<? if exists("cust_id") ?>
  AND   (cust_id=<? value("cust_id") ?>)
<? elseif exists("custtype_id") ?>
  AND   (cust_custtype_id=<? value("custtype_id") ?>)
<? elseif exists("custtype_pattern") ?>
  AND   (cust_custtype_id IN (SELECT custtype_id FROM custtype
                              WHERE (custtype_code ~ <? value("custtype_pattern") ?>)))
<? endif ?>
      )
ORDER BY arapply_postdate, source;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (106, 'bankrecHistory', 'unreconciled', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: bankrecHistory
-- Name: unreconciled
-- Notes: 
--        Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
--        See www.xtuple.com/CPAL for the full text of the software license.

SELECT gltrans_id, gltrans_date, formatDate(gltrans_date) AS f_date,
      gltrans_docnumber,
       CASE WHEN gltrans_doctype = ''CK'' THEN <? value("Checks") ?>
            WHEN gltrans_doctype = ''CR'' THEN <? value("Deposits") ?>
            ELSE <? value("Adjustments") ?> END AS type,
       CASE WHEN gltrans_doctype = ''CK'' THEN 1
            WHEN gltrans_doctype = ''CR'' THEN 2
            ELSE ''3'' END AS sort,
      gltrans_notes AS notes,
      currtolocal(bankaccnt_curr_id,gltrans_amount,gltrans_date) * -1 AS amount,
      formatMoney(currtolocal(bankaccnt_curr_id,gltrans_amount,gltrans_date) * -1) AS f_amount,
      CASE WHEN gltrans_doctype = ''CK'' THEN 
        currtolocal(bankaccnt_curr_id,gltrans_amount,gltrans_date) * -1
      ELSE 0 END AS rtcheck,
      CASE WHEN gltrans_doctype = ''CR'' THEN 
        currtolocal(bankaccnt_curr_id,gltrans_amount,gltrans_date) * -1
      ELSE 0 END AS rtdep,
      CASE WHEN gltrans_doctype NOT IN (''CK'',''CR'') THEN 
        currtolocal(bankaccnt_curr_id,gltrans_amount,gltrans_date) * -1
      ELSE 0 END AS rtadj,
      ''curr'' AS amount_xtnumericrole,
      1 AS xtindentrole
 FROM gltrans
   JOIN bankaccnt ON (bankaccnt_accnt_id = gltrans_accnt_id)
   JOIN bankrec selrec ON ((selrec.bankrec_bankaccnt_id = bankaccnt_id)
                       AND (selrec.bankrec_id=<? value("bankrec_id") ?>))
   LEFT OUTER JOIN bankrecitem ON ((bankrecitem_source=''GL'')

                              AND (bankrecitem_source_id=gltrans_id))
   LEFT OUTER JOIN bankrec actrec ON (actrec.bankrec_id = bankrecitem_bankrec_id)
   LEFT OUTER JOIN checkhead ON ((gltrans_doctype=''CK'')
                             AND (gltrans_misc_id=checkhead_id))
<? if exists("showUnreconciled") ?>
 WHERE ((COALESCE(actrec.bankrec_postdate,endoftime()) > COALESCE(selrec.bankrec_postdate,now()))
  AND (NOT gltrans_deleted)
  AND (NOT COALESCE(checkhead_void, false)))
  AND (gltrans_doctype != ''JP'')
<? else ?>
 WHERE (false)
<? endif ?>

UNION

SELECT sltrans_id, sltrans_date, formatDate(sltrans_date) AS f_date,
      sltrans_docnumber,
       CASE WHEN sltrans_doctype = ''CK'' THEN <? value("Checks") ?>
            WHEN sltrans_doctype = ''CR'' THEN <? value("Deposits") ?>
            ELSE <? value("Adjustments") ?> END AS type,
       CASE WHEN sltrans_doctype = ''CK'' THEN 1
            WHEN sltrans_doctype = ''CR'' THEN 2
            ELSE ''3'' END AS sort,
      sltrans_notes AS notes,
      currtolocal(bankaccnt_curr_id,sltrans_amount,sltrans_date) * -1 AS amount,
      formatMoney(currtolocal(bankaccnt_curr_id,sltrans_amount,sltrans_date) * -1) AS f_amount,
      CASE WHEN sltrans_doctype = ''CK'' THEN 
        currtolocal(bankaccnt_curr_id,sltrans_amount,sltrans_date) * -1
      ELSE 0 END AS rtcheck,
      CASE WHEN sltrans_doctype = ''CR'' THEN 
        currtolocal(bankaccnt_curr_id,sltrans_amount,sltrans_date) * -1
      ELSE 0 END AS rtdep,
      CASE WHEN sltrans_doctype NOT IN (''CK'',''CR'') THEN 
        currtolocal(bankaccnt_curr_id,sltrans_amount,sltrans_date) * -1
      ELSE 0 END AS rtadj,
      ''curr'' AS amount_xtnumericrole,
      1 AS xtindentrole
 FROM sltrans
   JOIN bankaccnt ON (bankaccnt_accnt_id = sltrans_accnt_id)
   JOIN bankrec selrec ON ((selrec.bankrec_bankaccnt_id = bankaccnt_id)
                       AND (selrec.bankrec_id=<? value("bankrec_id") ?>))
   LEFT OUTER JOIN bankrecitem ON ((bankrecitem_source=''SL'')

                              AND (bankrecitem_source_id=sltrans_id))
   LEFT OUTER JOIN bankrec actrec ON (actrec.bankrec_id = bankrecitem_bankrec_id)
   LEFT OUTER JOIN checkhead ON ((sltrans_doctype=''CK'')
                             AND (sltrans_misc_id=checkhead_id))
<? if exists("showUnreconciled") ?>
 WHERE ((COALESCE(actrec.bankrec_postdate,endoftime()) > COALESCE(selrec.bankrec_postdate,now()))
  AND (NOT COALESCE(checkhead_void, false)))
<? if exists("treeView") ?>
UNION
SELECT -1, NULL, NULL, <? value("Checks") ?>, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL,''curr'', 0 
UNION
SELECT -1, NULL, NULL, <? value("Deposits") ?>, NULL, 2, NULL, NULL, NULL, NULL, NULL, NULL, ''curr'', 0 
UNION
SELECT -1, NULL, NULL, <? value("Adjustments") ?>, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, ''curr'', 0
<? endif ?>

ORDER BY  sort, xtindentrole, type, f_date, gltrans_id
<? else ?>
 WHERE (false)
<? endif ?>
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (236, 'costedBOM', 'detail', 'used by dspCostedIndentedBOM, dspCostedSingleLevelBOM, dspCostedSummarizedBOM Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: costedBOM
-- Name: detail
-- Notes: used by dspCostedIndentedBOM, dspCostedSingleLevelBOM, dspCostedSummarizedBOM
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT
<? if exists("indentedBOM") ?>
       bomdata_bomwork_id AS id,
<? elseif exists("singleLevelBOM") ?>
       bomdata_bomitem_id AS id,
<? elseif exists("summarizedBOM") ?>
       -1,
<? endif ?>
       
<? if exists("indentedBOM") ?>
       CASE WHEN bomdata_bomwork_parent_id = -1 AND bomdata_bomwork_id = -1 THEN -1
         ELSE bomdata_item_id
       END AS altid,
<? elseif exists("singleLevelBOM") ?>
       CASE WHEN (bomdata_bomitem_id = -1) THEN -1
         ELSE bomdata_item_id
       END AS altid,
<? endif ?>
       *,

<? if exists("useStandardCosts") ?>
       bomdata_stdunitcost AS unitcost,
       bomdata_stdextendedcost AS extendedcost,
<? elseif exists("useActualCosts") ?>
       bomdata_actunitcost AS unitcost,
       bomdata_actextendedcost AS extendedcost,
<? endif ?>

       ''qty'' AS bomdata_batchsize_xtnumericrole,
       ''qty'' AS bomdata_qtyfxd_xtnumericrole,
       ''qtyper'' AS bomdata_qtyper_xtnumericrole,
       ''percent'' AS bomdata_scrap_xtnumericrole,
       ''qtyper'' AS bomdata_qtyreq_xtnumericrole,
       ''cost'' AS unitcost_xtnumericrole,
       ''cost'' AS extendedcost_xtnumericrole,
       CASE WHEN COALESCE(bomdata_effective, startOfTime()) <= startOfTime() THEN <? value("always") ?>
         END AS bomdata_effective_qtdisplayrole,
       CASE WHEN COALESCE(bomdata_expires, endOfTime()) <= endOfTime() THEN <? value("never") ?>
         END AS bomdata_expires_qtdisplayrole,
       CASE WHEN bomdata_expired THEN ''expired''
            WHEN bomdata_future  THEN ''future''
       END AS qtforegroundrole
<? if exists("indentedBOM") ?>
       , bomdata_bomwork_level - 1 AS xtindentrole
<? elseif exists("singleLevelBOM") ?>
       , 0 AS extendedcost_xttotalrole
<? endif ?>
FROM
<? if exists("indentedBOM") ?>
     indentedbom(<? value("item_id") ?>, <? value("revision_id") ?>, 0, 0);
<? elseif exists("singleLevelBOM") ?>
     singlelevelbom(<? value("item_id") ?>, <? value("revision_id") ?>, 0, 0);
<? elseif exists("summarizedBOM") ?>
     summarizedBOM(<? value("item_id") ?>, <? value("revision_id") ?>, <? value("expiredDays") ?>, <? value("futureDays") ?>);
<? endif ?>
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (237, 'countSlip', 'detail', 'used by dspCountSlipEditList, dspCountSlipsByWarehouse Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: countSlip
-- Name: detail
-- Notes: used by dspCountSlipEditList, dspCountSlipsByWarehouse
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT cntslip_id,
       CASE WHEN (cntslip_posted) THEN 1
         ELSE 0
       END,
       cntslip_username AS user,
<? if exists("numericSlips") ?>
       toNumeric(cntslip_number, 0) AS cntslip_number,
       cntslip_number AS cntslip_number_qtdisplayrole,
<? else ?>
       cntslip_number,
<? endif ?>
       CASE WHEN (cntslip_location_id=-1) THEN ''''
         ELSE formatLocationName(cntslip_location_id)
       END AS locname,
       invcnt_tagnumber,
<? if exists("byWarehouse") ?>
       warehous_code,
       item_number, (item_descrip1 || '' '' || item_descrip2) AS descrip,
<? endif ?>
       cntslip_lotserial, cntslip_posted,
       cntslip_entered, cntslip_qty,
       ''qty'' AS cntslip_qty_xtnumericrole,
       cntslip_posted AS posted
FROM cntslip, invcnt
<? if exists("byWarehouse") ?>
     JOIN itemsite ON (invcnt_itemsite_id=itemsite_id)
     JOIN item ON (itemsite_item_id=item_id)
     JOIN whsinfo ON (itemsite_warehous_id=warehous_id)
<? endif ?>
WHERE ((cntslip_cnttag_id=invcnt_id)
<? if exists("byWarehouse") ?>
   AND (cntslip_entered BETWEEN <? value("startDate") ?> AND  (<? value("endDate") ?>::DATE + 1))
  <? if not exists("showUnposted") ?>
    AND (cntslip_posted)
  <? endif ?>
  <? if exists("warehous_id") ?>
    AND (itemsite_warehous_id=<? value("warehous_id") ?>)
  <? endif ?>
<? else ?>
    AND (NOT invcnt_posted)
    AND (invcnt_id=<? value("cnttag_id") ?>)
<? endif ?>
      )
ORDER BY cntslip_number;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (271, 'poHistory', 'detail', 'used by dspPoHistory Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: poHistory
-- Name: detail
-- Notes: used by dspPoHistory
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT poitem_id, poitem.*,
       COALESCE(item_number, <? value("nonInventory") ?>) AS itemnumber,
       COALESCE(uom_name, <? value("na") ?>) AS uomname,
       CASE WHEN (LENGTH(TRIM(BOTH ''    '' FROM poitem_vend_item_descrip)) <= 0)
            THEN(item_descrip1 || '' '' || item_descrip2)
         ELSE poitem_vend_item_descrip
       END AS itemdescription,
       ''qty'' AS poitem_qty_ordered_xtnumericrole,
       ''qty'' AS poitem_qty_received_xtnumericrole,
       ''qty'' AS poitem_qty_returned_xtnumericrole
FROM poitem LEFT OUTER JOIN
     ( itemsite JOIN item
       ON (itemsite_item_id=item_id) JOIN uom ON (item_inv_uom_id=uom_id))
       ON (poitem_itemsite_id=itemsite_id)
WHERE (poitem_pohead_id=<? value("pohead_id") ?>)
ORDER BY poitem_linenumber;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (266, 'orderActivityByProject', 'detail', 'All projects', '-- Group: orderActivityByProject
-- Name:  detail
-- Notes: All projects

SELECT *, 
  formatQty(qty) AS f_qty,
  formatMoney(value) AS f_value,
  ''curr'' AS qty_xtnumericrole,
  ''curr'' AS value_xtnumericrole,
  CASE WHEN COALESCE(hrs_balance,0) < 0 THEN ''red'' END AS hrs_balance_qtforegroundrole,
  CASE WHEN COALESCE(exp_balance,0) < 0 THEN ''red'' END AS exp_balance_qtforegroundrole
FROM (
SELECT prj_id AS id,
       1 AS type,
       ''0'' AS subtype,
       0 AS section,
       NULL  AS section_qtdisplayrole,
       prj_number AS name,
       CASE                         
           WHEN prj_status = ''C'' THEN <? value(''complete'') ?>
           WHEN prj_status = ''O'' THEN <? value(''inprocess'') ?>
           WHEN prj_status = ''P'' THEN <? value(''planning'') ?>
       END AS status,
       prjtype_code AS project_type,
       prj_name AS item,
       firstline(prj_descrip) AS descrip,
       crmacct_name AS customer, 
       cntct_name AS contact,
       addr_city AS city,
       addr_state AS state,
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value,
       prj_due_date AS due,
       prj_assigned_date AS assigned,
       prj_start_date AS started,
       prj_completed_date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
       CASE WHEN (prj_status = ''O'' AND prj_due_date < current_date) THEN ''red'' 
         WHEN (prj_status = ''O'' AND prj_due_date BETWEEN current_date AND current_date + (fetchmetricvalue(''ProjectDueDateWarning'')||'' days'')::interval) THEN ''orange'' 
         END AS due_qtforegroundrole,
       0 AS xtindentrole
  FROM prj
  LEFT OUTER JOIN prjtype ON (prj_prjtype_id=prjtype_id)
  LEFT OUTER JOIN crmacct ON (prj_crmacct_id=crmacct_id)
  LEFT OUTER JOIN cntct ON (crmacct_cntct_id_1=cntct_id)
  LEFT OUTER JOIN addr ON (cntct_addr_id=addr_id)

 WHERE (prj_id = <? value("prj_id") ?> )
 
UNION ALL
----- TASKS -----
SELECT DISTINCT -1 AS id, 
       3 AS type,
       ''0'' AS subtype,
       1 AS section,
       ''Tasks'' AS section_qtdisplayrole,
       ''Tasks'' AS name,
       NULL::text AS status,
       NULL::text AS project_type,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
       NULL::text AS due_qtforegroundrole,
       1 AS xtindentrole

UNION ALL

SELECT prjtask_id AS id,
       5 AS type,
       ''0'' AS subtype,
       1 AS section,
       NULL AS section_qtdisplayrole,
       prjtask_number AS name,
       CASE                         
           WHEN prjtask_status = ''C'' THEN <? value(''complete'') ?>
           WHEN prjtask_status = ''O'' THEN <? value(''inprocess'') ?>
           WHEN prjtask_status = ''P'' THEN <? value(''planning'') ?>
       END AS status,
       NULL::text AS project_type,
       prjtask_name AS item,
       prjtask_descrip AS descrip,
       cust_name as customer,
       cntct_name AS contact,
       addr_city AS city,
       addr_state AS state,
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value,
       prjtask_due_date AS due,
       prjtask_assigned_date AS assigned,
       prjtask_start_date AS started,
       prjtask_completed_date AS completed,
       prjtask_hours_budget AS hrs_budget,
       prjtask_hours_actual AS hrs_actual,
       (prjtask_hours_budget-prjtask_hours_actual) AS hrs_balance,
       prjtask_exp_budget AS exp_budget,
       prjtask_exp_actual AS exp_actual,
       (prjtask_exp_budget-prjtask_exp_actual) AS exp_balance,
       CASE WHEN (prjtask_status = ''O'' AND prjtask_due_date < current_date) THEN ''red'' 
         WHEN (prjtask_status = ''O'' AND prjtask_due_date BETWEEN current_date AND current_date + (fetchmetricvalue(''ProjectDueDateWarning'')||'' days'')::interval) THEN ''orange'' 
         END AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM prjtask
  LEFT OUTER JOIN te.teprjtask ON (prjtask_id = teprjtask_prjtask_id)
  LEFT OUTER JOIN custinfo ON (teprjtask_cust_id=cust_id)
  LEFT OUTER JOIN cntct ON (cust_corrcntct_id=cntct_id)
  LEFT OUTER JOIN addr ON (cntct_addr_id=addr_id)

 WHERE (prjtask_prj_id = <? value("prj_id") ?> )
 GROUP BY custinfo.cust_name, prjtask.prjtask_id, addr.addr_city, addr.addr_state, cntct_name

<? if exists("showIn") ?>
UNION ALL
----- INCIDENTS -----

SELECT DISTINCT -1 AS id, 
       100 AS type,
       ''0'' AS subtype,
       1 AS section,
       ''Incidents'' AS section_qtdisplayrole,
       ''Incidents'' AS name,
       NULL::text AS status,
       NULL::text AS project_type,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
       NULL::text AS due_qtforegroundrole,
       1 AS xtindentrole
    FROM incdt
UNION ALL

SELECT incdt_id AS id,
       105 AS type,
       ''0'' AS subtype,
       1 AS section,
       NULL AS section_qtdisplayrole,
       incdt_number::text AS name,
       CASE                         
           WHEN incdt_status = ''L'' THEN <? value(''closed'') ?>
           WHEN incdt_status = ''N'' THEN <? value(''new'') ?>
           WHEN incdt_status = ''F'' THEN <? value(''feedback'') ?>
           WHEN incdt_status = ''A'' THEN <? value(''assigned'') ?>	
           WHEN incdt_status = ''R'' THEN <? value(''resolved'') ?>
           WHEN incdt_status = ''C'' THEN <? value(''confirmed'') ?>
       END AS status,
       NULL::text AS project_type,
       incdt_number::text AS item,
       incdt_summary AS descrip,
       crmacct_number AS customer,
       crmacct_name AS contact,
       addr_city AS city,
       addr_state AS state,
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
       NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM incdt
  LEFT OUTER JOIN crmacct ON (incdt_crmacct_id=crmacct_id)
  LEFT OUTER JOIN cntct ON (incdt_cntct_id=cntct_id)
  LEFT OUTER JOIN addr ON (cntct_addr_id=addr_id)

 WHERE (incdt_prj_id = <? value("prj_id") ?> )
 GROUP BY incdt_id, incdt_prj_id, incdt_number, crmacct_number, crmacct_name, addr.addr_city, addr.addr_state, cntct_name, incdt_number, incdt_status, incdt_assigned_username, incdt_owner_username, incdt_number, incdt_summary 
<? endif ?>
   
<? if exists("showSo") ?>
UNION ALL

----- QUOTES -----
SELECT DISTINCT -1 AS id, 
       10 AS type,
       ''0'' AS subtype,
       1 AS section,
       <? value("quotes") ?> AS section_qtdisplayrole,
       <? value("quotes") ?> AS name,
       NULL::text AS status,
       NULL::text AS project_type,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value, 
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
       NULL::text AS due_qtforegroundrole,
       1 AS xtindentrole
  FROM quhead
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=quhead_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
 WHERE (quhead_prj_id = <? value("prj_id") ?>)
<? if exists("owner_username") ?>
   AND (quhead_owner_username=<? value("owner_username") ?>)
<? endif ?>

UNION ALL

SELECT quhead_id AS id, 
       15 AS type,
       quhead_number AS subtype,
       1 AS section,
       <? value("quotes") ?> AS section_qtdisplayrole,
       quhead_number AS name,
       CASE WHEN (quhead_status = ''C'') THEN 
         <? value("converted") ?>
            WHEN (quhead_status = ''X'') THEN
         <? value("canceled") ?>
            WHEN (COALESCE(quhead_expire, current_date + 1) > current_date) THEN
         <? value("open") ?>
            ELSE
         <? value("expired") ?>
       END AS status,
       NULL::text AS project_type,
       NULL::text AS item,
       NULL::text AS descrip,
       cust_name AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       NULL AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
       NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM quhead
  JOIN custinfo ON (quhead_cust_id=cust_id)
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=quhead_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
    JOIN quitem ON (quitem_quhead_id = quhead_id)
 WHERE (quhead_prj_id = <? value("prj_id") ?>)
<? if exists("owner_username") ?>
   AND (quhead_owner_username=<? value("owner_username") ?>)
<? endif ?>
GROUP BY quhead_id, quhead_number, quhead_status, quhead_expire, quhead_freight, quhead_misc, custinfo.cust_name

UNION ALL

SELECT quitem_id AS id, 
       17 AS type,
       quhead_number AS subtype,
       1 AS section,
       <? value("quotes") ?> AS section_qtdisplayrole,
       quitem_linenumber::text AS name, 
       CASE WHEN (quhead_status = ''C'') THEN 
         <? value("converted") ?>
            WHEN (quhead_status = ''X'') THEN
         <? value("canceled") ?>
            WHEN (COALESCE(quhead_expire, current_date + 1) > current_date) THEN
         <? value("open") ?>
            ELSE
         <? value("Expired") ?>
       END AS status,
       NULL::text AS project_type,
       item_number AS item,
       item_descrip1 || '' '' || item_descrip2 AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       quitem_qtyord,
       uom_name AS uom,
       (quitem_qtyord * quitem_qty_invuomratio) * (quitem_price / quitem_price_invuomratio) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
       NULL::text AS due_qtforegroundrole,
       3 AS xtindentrole
  FROM quhead
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=quhead_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
    JOIN quitem ON (quitem_quhead_id = quhead_id)
    JOIN uom ON (quitem_qty_uom_id = uom_id)
    JOIN itemsite ON (quitem_itemsite_id = itemsite_id)
    JOIN item ON (itemsite_item_id = item_id)
 WHERE (quhead_prj_id = <? value("prj_id") ?>)
<? if exists("owner_username") ?>
   AND (quhead_owner_username=<? value("owner_username") ?>)
<? endif ?>

UNION ALL

SELECT quhead_id AS id, 
       18 AS type,
       quhead_number AS subtype,
       1 AS section,
       <? value("quotes") ?> AS section_qtdisplayrole,
       <? value("total") ?> AS name,
       NULL AS status,
       NULL::text AS project_type,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       SUM((quitem_qtyord * quitem_qty_invuomratio) * (quitem_price / quitem_price_invuomratio)) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM quhead
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=quhead_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
    JOIN quitem ON (quitem_quhead_id = quhead_id)
 WHERE (quhead_prj_id = <? value("prj_id") ?>)
<? if exists("owner_username") ?>
   AND (quhead_owner_username=<? value("owner_username") ?>)
<? endif ?>
GROUP BY quhead_id, quhead_number

UNION ALL

SELECT -1 AS id, 
       19 AS type,
       MAX(quhead_number) AS subtype,
       1 AS section,
       <? value("quotes") ?> AS section_qtdisplayrole,
       <? value("total") ?> || '' '' || <? value("quotes") ?> AS name,
       NULL AS status,
       NULL::text AS project_type,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       SUM((quitem_qtyord * quitem_qty_invuomratio) * (quitem_price / quitem_price_invuomratio)) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM quhead
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=quhead_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
    JOIN quitem ON (quitem_quhead_id = quhead_id)
 WHERE (quhead_prj_id = <? value("prj_id") ?>)
<? if exists("owner_username") ?>
   AND (quhead_owner_username=<? value("owner_username") ?>)
<? endif ?>

UNION ALL

------ SALES ORDERS ------
SELECT DISTINCT -1 AS id, 
       20 AS type,
       ''0'' AS subtype,
       2 AS section,
       <? value("sos") ?> AS section_qtdisplayrole,
       <? value("sos") ?> AS name,
       NULL::text AS status,
       NULL::text AS project_type,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       1 AS xtindentrole
  FROM cohead
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=cohead_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
 WHERE (cohead_prj_id = <? value("prj_id") ?>)

UNION ALL

SELECT cohead_id AS id, 
       25 AS type,
       cohead_number::text AS subtype,
       2 AS section,
       <? value("sos") ?> AS section_qtdisplayrole,
       cohead_number::text AS name,
      COALESCE((SELECT 
                  CASE WHEN (coitem_status = ''O'') THEN
                    <? value("open") ?>
                       WHEN (coitem_status = ''C'') THEN
                    <? value("closed" ?>
                      ELSE
                    <? value("canceled") ?>
                  END
                FROM 
               (SELECT coitem_status,
                   CASE 
                     WHEN (coitem_status = ''O'') THEN 1
                     WHEN (coitem_status = ''C'') then 2
                     ELSE  3
                  END AS type
                  FROM coitem
                 WHERE (coitem_cohead_id=cohead_id)
                 ORDER BY type
                 LIMIT 1) AS sts) ,''O'')
        AS status,
       NULL::text AS project_type,
       shipto_num AS item,
       shipto_name AS descrip,
       cust_name AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       NULL AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM cohead
    JOIN custinfo ON (cust_id = cohead_cust_id)
    LEFT OUTER JOIN shiptoinfo ON (cohead_shipto_id = shipto_id)
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=cohead_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
    JOIN coitem ON (coitem_cohead_id = cohead_id)
 WHERE (cohead_prj_id = <? value("prj_id") ?>)
GROUP BY cohead_id, cohead_number, shipto_num, shipto_name, cust_name

UNION ALL

SELECT coitem_id AS id, 
       27 AS type,
       cohead_number::text AS subtype,
       2 AS section,
       <? value("sos") ?> AS section_qtdisplayrole,
       coitem_linenumber::text AS name, 
       CASE WHEN (coitem_status = ''O'') THEN
         <? value("open") ?>
            WHEN (coitem_status = ''C'') THEN
         <? value("closed") ?>
            WHEN (coitem_status = ''X'') THEN
         <? value("canceled") ?>
       END AS status,
       NULL::text AS project_type,
       item_number AS item,
       item_descrip1 || '' '' || item_descrip2 AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       coitem_qtyord,
       uom_name AS uom,
       (coitem_qtyord * coitem_qty_invuomratio) * (coitem_price / coitem_price_invuomratio) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       3 AS xtindentrole
  FROM cohead
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=cohead_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
    JOIN coitem ON (coitem_cohead_id = cohead_id)
    JOIN uom ON (coitem_qty_uom_id = uom_id)
    JOIN itemsite ON (coitem_itemsite_id = itemsite_id)
    JOIN item ON (itemsite_item_id = item_id)
 WHERE (cohead_prj_id = <? value("prj_id") ?>)

UNION ALL

SELECT cohead_id AS id, 
       28 AS type,
       cohead_number::text AS subtype,
       2 AS section,
       <? value("sos") ?> AS section_qtdisplayrole,
       <? value("total") ?> AS name,
       NULL AS status,
       NULL::text AS project_type,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       SUM((coitem_qtyord * coitem_qty_invuomratio) * (coitem_price / coitem_price_invuomratio)) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM cohead
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=cohead_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
    JOIN coitem ON (coitem_cohead_id = cohead_id)
 WHERE (cohead_prj_id = <? value("prj_id") ?>)
GROUP BY cohead_id, cohead_number

UNION ALL

SELECT -1 AS id, 
       29 AS type,
       MAX(cohead_number::text) AS subtype,
       2 AS section,
       <? value("sos") ?> AS section_qtdisplayrole,
       <? value("total") ?> || '' '' || <? value("sos") ?> AS name,
       NULL AS status,
       NULL::text AS project_type,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       SUM((coitem_qtyord * coitem_qty_invuomratio) * (coitem_price / coitem_price_invuomratio)) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        	
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM cohead
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=cohead_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
    JOIN coitem ON (coitem_cohead_id = cohead_id)
 WHERE (cohead_prj_id = <? value("prj_id") ?>)

UNION ALL

------ INVOICES -------
SELECT DISTINCT -1 AS id, 
       30 AS type,
       ''0'' AS subtype,
       3 AS section,
       <? value("invoices") ?> AS section_qtdisplayrole,
       <? value("invoices") ?> AS name,
       NULL::text AS status,
       NULL::text AS project_type,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       1 AS xtindentrole
  FROM invchead
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=invchead_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
 WHERE (invchead_prj_id = <? value("prj_id") ?>)

UNION ALL

SELECT invchead_id AS id,
       35 AS type,
       invchead_invcnumber::text AS subtype,
       3 AS section,
       <? value("invoices") ?> AS section_qtdisplayrole,
       invchead_invcnumber::text AS name,
       CASE WHEN (invchead_posted) THEN
         <? value("posted") ?>
       ELSE <? value("unposted") ?>
       END AS status,
       NULL::text AS project_type,
       shipto_num AS item,
       shipto_name AS descrip,
       cust_name AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       NULL AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM invchead
    JOIN custinfo ON (cust_id=invchead_cust_id)
    LEFT OUTER JOIN shiptoinfo ON (invchead_shipto_id = shipto_id)
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=invchead_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
    JOIN invcitem ON (invcitem_invchead_id = invchead_id)
 WHERE (invchead_prj_id = <? value("prj_id") ?>)
GROUP BY invchead_id, invchead_invcnumber, shipto_num, shipto_name, invchead_freight, invchead_misc_amount, invchead_posted, cust_name

UNION ALL

SELECT invcitem_id AS id, 
       37 AS type,
       invchead_invcnumber::text AS subtype,
       3 AS section,
       <? value("invoices") ?> AS section_qtdisplayrole,
       invcitem_linenumber::text AS name, 
       CASE WHEN (invchead_posted) THEN
         <? value("posted") ?>
       ELSE <? value("unposted") ?>
       END AS status,
       NULL::text AS project_type,
       COALESCE(item_number,invcitem_number) AS item,
       COALESCE(item_descrip1 || '' '' || item_descrip2,invcitem_descrip) AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       invcitem_billed AS qty,
       uom_name AS uom,
       (invcitem_billed * invcitem_qty_invuomratio) * (invcitem_price / invcitem_price_invuomratio) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       3 AS xtindentrole
  FROM invchead
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=invchead_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
    JOIN invcitem ON (invcitem_invchead_id = invchead_id)
    LEFT OUTER JOIN item ON (invcitem_item_id = item_id)
    LEFT OUTER JOIN uom ON (invcitem_qty_uom_id = uom_id)
 WHERE (invchead_prj_id = <? value("prj_id") ?>)

UNION ALL

SELECT invchead_id AS id, 
       38 AS type,
       invchead_invcnumber::text AS subtype,
       3 AS section,
       <? value("invoices") ?> AS section_qtdisplayrole,
       <? value("total") ?> AS name,
       NULL AS status,
       NULL::text AS project_type,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       SUM((invcitem_billed * invcitem_qty_invuomratio) * (invcitem_price / invcitem_price_invuomratio)) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
       
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM invchead
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=invchead_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
    JOIN invcitem ON (invcitem_invchead_id = invchead_id)
 WHERE (invchead_prj_id = <? value("prj_id") ?>)
GROUP BY invchead_id, invchead_invcnumber

UNION ALL

SELECT -1 AS id, 
       39 AS type,
       MAX(invchead_invcnumber::text) AS subtype,
       3 AS section,
       <? value("invoices") ?> AS section_qtdisplayrole,
       <? value("total") ?> || '' '' || <? value("invoices") ?> AS name,
       NULL AS status,
       NULL::text AS project_type,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       SUM((invcitem_billed * invcitem_qty_invuomratio) * (invcitem_price / invcitem_price_invuomratio)) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM invchead
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=invchead_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
    JOIN invcitem ON (invcitem_invchead_id = invchead_id)
 WHERE (invchead_prj_id = <? value("prj_id") ?>)

<? endif ?>


<? if exists("showWo") ?>
UNION ALL

------ WORK ORDERS -------
SELECT DISTINCT -1 AS id, 
       40 AS type,
       ''0'' AS subtype,
       4 AS section,
       <? value("wos") ?> AS section_qtdisplayrole,
       <? value("wos") ?> AS name,
       NULL::text AS status,
       NULL::text AS project_type,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       1 AS xtindentrole
  FROM wo
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=wo_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
 WHERE (wo_prj_id = <? value("prj_id") ?>)

UNION ALL

SELECT wo_id AS id, 
       45 AS type,
       formatWoNumber(wo_id) AS subtype,
       4 AS section,
       <? value("wos") ?> AS section_qtdisplayrole,
       formatWoNumber(wo_id) AS name,
       CASE WHEN (wo_status = ''O'') THEN
         <? value("open") ?>
            WHEN (wo_status = ''E'') THEN
         <? value("exploded") ?>
            WHEN (wo_status = ''R'') THEN
         <? value("released") ?>
            WHEN (wo_status = ''I'') THEN
         <? value("inprocess") ?>
            WHEN (wo_status = ''C'') THEN
         <? value("closed") ?>
       END AS status,
       NULL::text AS project_type,
       item_number AS item,
       item_descrip1 || '' '' || item_descrip2 AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       wo_qtyord AS qty,
       uom_name AS uom,
       wo_postedvalue AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
       
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM wo
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=wo_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
    JOIN itemsite ON (itemsite_id=wo_itemsite_id)
    JOIN item ON (itemsite_item_id=item_id)
    JOIN uom ON (item_inv_uom_id=uom_id)
 WHERE (wo_prj_id = <? value("prj_id") ?>)

UNION ALL

SELECT -1 AS id, 
       49 AS type,
       MAX(formatWoNumber(wo_id)) AS subtype,
       4 AS section,
       <? value("wos") ?> AS section_qtdisplayrole,
       <? value("total") ?> || '' '' || <? value("wos") ?> AS name,
       NULL AS status,
       NULL::text AS project_type,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       SUM(wo_postedvalue) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM wo
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=wo_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
 WHERE (wo_prj_id = <? value("prj_id") ?>)

<? endif ?>


<? if exists("showPo") ?>
 UNION ALL

------ PURCHASE REQUESTS ------
SELECT DISTINCT -1 AS id, 
       50 AS type,
       ''0'' AS subtype,
       5 AS section,
       <? value("prs") ?> AS section_qtdisplayrole,
       <? value("prs") ?> AS name,
       NULL::text AS status,
       NULL::text AS project_type,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       1 AS xtindentrole
  FROM pr
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=pr_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
 WHERE (pr_prj_id = <? value("prj_id") ?>)

UNION ALL

SELECT pr_id AS id, 
       55 AS type,
       pr_number::text || ''-'' || pr_subnumber::text AS subtype,
       5 AS section,
       <? value("prs") ?> AS section_qtdisplayrole,
       pr_number::text || ''-'' || pr_subnumber::text AS name,
       <? value("open") ?> AS status, 
       NULL::text AS project_type,
       item_number AS item,
       (item_descrip1 || '' '' || item_descrip2) AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       pr_qtyreq AS qty,
       uom_name AS uom,
       stdcost(item_id) * pr_qtyreq AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM pr
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=pr_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
    JOIN itemsite ON (itemsite_id = pr_itemsite_id)
    JOIN item ON (itemsite_item_id = item_id)
    JOIN uom ON (item_inv_uom_id = uom_id)
 WHERE (pr_prj_id=<? value("prj_id") ?>)

UNION ALL

SELECT -1 AS id, 
       59 AS type,
       MAX(pr_number::text || ''-'' || pr_subnumber::text) AS subtype,
       5 AS section,
       <? value("prs") ?> AS section_qtdisplayrole,
       <? value("total") ?> || '' '' || <? value("prs") ?> AS name,
       NULL AS status,
       NULL::text AS project_type,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,       
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       SUM(stdcost(item_id) * pr_qtyreq) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM pr
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=pr_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
    JOIN itemsite ON (itemsite_id = pr_itemsite_id)
    JOIN item ON (itemsite_item_id = item_id)
 WHERE (pr_prj_id = <? value("prj_id") ?>)

UNION ALL

------ PURCHASE ORDERS ------
SELECT DISTINCT -1 AS id, 
       60 AS type,
       ''0'' AS subtype,
       6 AS section,
       <? value("pos") ?> AS section_qtdisplayrole,
       <? value("pos") ?> AS name,
       NULL::text AS status,
       NULL::text AS project_type,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       1 AS xtindentrole
  FROM poitem
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=poitem_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
 WHERE (poitem_prj_id = <? value("prj_id") ?>)

UNION ALL

SELECT pohead_id AS id,
       65 AS type,
       pohead_number::text AS subtype,
       6 AS section,
       <? value("pos") ?> AS section_qtdisplayrole,
       pohead_number::text AS name,
       CASE WHEN (pohead_status = ''U'') THEN
         <? value("unreleased") ?>
            WHEN (pohead_status = ''O'') THEN
         <? value("open") ?>
            WHEN (pohead_status = ''C'') THEN
         <? value("closed") ?>
       END AS status,
       NULL::text AS project_type,
       NULL AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL AS uom,
       NULL AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM pohead
    JOIN poitem ON (poitem_pohead_id = pohead_id)
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=poitem_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
 WHERE (poitem_prj_id = <? value("prj_id") ?>)
GROUP BY pohead_id, pohead_number, pohead_freight, pohead_status

UNION ALL

SELECT poitem_id AS id, 
       67 AS type,
       pohead_number::text AS subtype,
       6 AS section,
       <? value("pos") ?> AS section_qtdisplayrole,
       poitem_linenumber::text AS name, 
       CASE WHEN (poitem_status = ''U'') THEN
         <? value("unreleased") ?>
            WHEN (poitem_status = ''O'') THEN
         <? value("open") ?>
            WHEN (poitem_status = ''C'') THEN
         <? value("closed") ?>
       END AS status,
       NULL::text AS project_type,
       COALESCE(item_number,poitem_vend_item_number) AS item,
       COALESCE((item_descrip1 || '' '' || item_descrip2),poitem_vend_item_descrip) AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       poitem_qty_ordered,
       poitem_vend_uom AS uom,
       (poitem_qty_ordered * poitem_unitprice) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       3 AS xtindentrole
  FROM pohead
    JOIN poitem ON (poitem_pohead_id = pohead_id)
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=poitem_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
    LEFT OUTER JOIN itemsite ON (poitem_itemsite_id=itemsite_id)
    LEFT OUTER JOIN item ON (itemsite_item_id = item_id)
 WHERE (poitem_prj_id = <? value("prj_id") ?>)

UNION ALL

SELECT pohead_id AS id, 
       68 AS type,
       pohead_number::text AS subtype,
       6 AS section,
       <? value("pos") ?> AS section_qtdisplayrole,
       <? value("total") ?> AS name,
       NULL AS status,
       NULL::text AS project_type,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       SUM(poitem_qty_ordered * poitem_unitprice) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM pohead
    JOIN poitem ON (poitem_pohead_id = pohead_id)
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=poitem_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
 WHERE (poitem_prj_id = <? value("prj_id") ?>)
GROUP BY pohead_id, pohead_number

UNION ALL

SELECT -1 AS id, 
       69 AS type,
       MAX(pohead_number::text) AS subtype,
       6 AS section,
       <? value("sos") ?> AS section_qtdisplayrole,
       <? value("total") ?> || '' '' || <? value("pos") ?> AS name,
       NULL AS status,
       NULL::text AS project_type,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       SUM(poitem_qty_ordered * poitem_unitprice) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM pohead
    JOIN poitem ON (poitem_pohead_id = pohead_id)
<? if exists("owner_username") ?>
    JOIN prj ON (prj_id=poitem_prj_id
            AND ((prj_owner_username=<? value("owner_username") ?>) OR (prj_username=<? value("owner_username") ?>)))
<? endif ?>
 WHERE (poitem_prj_id = <? value("prj_id") ?>)

<? endif ?>

) data
ORDER BY section, subtype, type, id;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (39, 'arHistory', 'detail', 'used by dspCustomerARHistory, dspCustomerInformation Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: arHistory
-- Name: detail
-- Notes: used by dspCustomerARHistory, dspCustomerInformation
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT aropen_id, applyid,
       sortdate, sortnumber, type,
       docnumber, open, documenttype,
       docdate, duedate, amount, balance, base_balance, currAbbr,
       formatBoolYN(open) AS f_open,
       formatDate(docdate) AS f_docdate, formatDate(duedate) AS f_duedate,
       ''curr'' AS amount_xtnumericrole,
       ''curr'' AS balance_xtnumericrole,
       ''curr'' AS base_balance_xtnumericrole,
       0 AS base_balance_xttotalrole,
       type AS xtindentrole
  FROM (
    SELECT 0 AS type, aropen_id, -1 AS applyid,
           aropen_docdate AS sortdate, (aropen_docnumber || aropen_doctype) AS sortnumber,
           aropen_docnumber AS docnumber,
           aropen_open AS open,
           CASE WHEN (aropen_doctype=''I'') THEN <? value("invoice") ?>
                WHEN (aropen_doctype=''C'') THEN <? value("creditMemo") ?>
                WHEN (aropen_doctype=''D'') THEN <? value("debitMemo") ?>
                WHEN (aropen_doctype=''R'') then <? value("cashdeposit") ?>
                ELSE <? value("other") ?>
           END AS documenttype,
           aropen_docdate AS docdate,
           aropen_duedate AS duedate,
           aropen_amount AS amount,
           (aropen_amount - aropen_paid) AS balance,
           CASE WHEN (aropen_doctype IN (''C'', ''R'')) THEN
                        (currtobase(aropen_curr_id,(aropen_amount - aropen_paid),aropen_docdate) * -1.0)
                ELSE currtobase(aropen_curr_id,(aropen_amount - aropen_paid),aropen_docdate)
           END AS base_balance,
           currConcat(aropen_curr_id) AS currAbbr
     FROM aropen
    WHERE ( (aropen_cust_id=<? value("cust_id") ?>) 
    <? if exists("startDate") ?>
      AND   (aropen_docdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
    <? endif ?> )

    UNION
    SELECT 1 AS type, -1 AS aropen_id, arapply_source_aropen_id AS applyid,
           aropen_docdate AS sortdate, (aropen_docnumber || aropen_doctype) AS sortnumber,
           CASE WHEN (arapply_source_doctype IN (''C'',''R'')) THEN arapply_source_docnumber
                WHEN (arapply_source_doctype=''K'') THEN arapply_refnumber
                ELSE <? value("error") ?>
           END AS docnumber,
           NULL AS open,
           CASE WHEN (arapply_source_doctype=''C'') THEN <? value("creditMemo") ?>
                WHEN (arapply_source_doctype=''R'') THEN <? value("cashdeposit") ?>
                WHEN (arapply_fundstype=''C'') THEN <? value("check") ?>
                WHEN (arapply_fundstype=''T'') THEN <? value("certifiedCheck") ?>
                WHEN (arapply_fundstype=''M'') THEN <? value("masterCard") ?>
                WHEN (arapply_fundstype=''V'') THEN <? value("visa") ?>
                WHEN (arapply_fundstype=''A'') THEN <? value("americanExpres") ?>
                WHEN (arapply_fundstype=''D'') THEN <? value("discoverCard") ?>
                WHEN (arapply_fundstype=''R'') THEN <? value("otherCreditCard") ?>
                WHEN (arapply_fundstype=''K'') THEN <? value("cash") ?>
                WHEN (arapply_fundstype=''W'') THEN <? value("wireTransfer") ?>
                WHEN (arapply_fundstype=''O'') THEN <? value("other") ?>
           END AS documenttype,
           COALESCE(cashrcpt_docdate, arapply_postdate) AS docdate,
           arapply_distdate AS duedate,
           arapply_applied AS amount,
           0 AS balance,
           0 AS base_balance,
           currConcat(arapply_curr_id) AS currAbbr
     FROM arapply JOIN aropen ON (arapply_target_aropen_id=aropen_id)
                  LEFT OUTER JOIN cashrcptitem ON ( (arapply_reftype=''CR'') AND
                                                    (arapply_ref_id=cashrcptitem_id) )
                  LEFT OUTER JOIN cashrcpt ON (cashrcpt_id=cashrcptitem_cashrcpt_id)
    WHERE ( (arapply_target_doctype IN (''I'', ''D''))
      AND   (arapply_cust_id=<? value("cust_id") ?>)
      AND   (aropen_cust_id=<? value("cust_id") ?>)
    <? if exists("startDate") ?>
      AND   (aropen_docdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
    <? endif ?> )

    UNION
    SELECT 2 AS type, -1 AS aropen_id, arapply_target_aropen_id AS applyid,
           aropen_docdate AS sortdate, (aropen_docnumber || aropen_doctype) AS sortnumber,
           arapply_target_docnumber AS docnumber,
           NULL AS open,
           CASE WHEN (arapply_target_doctype=''I'') THEN <? value("invoice") ?>
                WHEN (arapply_target_doctype=''D'') THEN <? value("debitMemo") ?>
                ELSE <? value("other") ?>
           END AS documenttype,
           arapply_postdate AS docdate,
           arapply_distdate AS duedate,
           arapply_applied AS amount,
           0 AS balance,
           0 AS base_balance,
           currConcat(arapply_curr_id) AS currAbbr
     FROM arapply, aropen
    WHERE ( (arapply_source_doctype IN (''K'', ''C'', ''R''))
      AND  (arapply_source_aropen_id=aropen_id)
      AND  (arapply_cust_id=<? value("cust_id") ?>)
      AND  (aropen_cust_id=<? value("cust_id") ?>)
    <? if exists("startDate") ?>
      AND   (aropen_docdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
    <? endif ?> )

    UNION
    SELECT 0 AS type, -1 AS aropen_id, -1 AS applyid,
           invchead_invcdate AS sortdate, (invchead_invcnumber || ''I'') AS sortnumber,
           invchead_invcnumber AS docnumber,
           false AS open,
           <? value("zeroinvoice") ?> AS documenttype,
           invchead_invcdate AS docdate,
           invchead_invcdate AS duedate,
           0 AS amount,
           0 AS balance,
           0 AS base_balance,
           currConcat(invchead_curr_id) AS currAbbr
     FROM invchead
    WHERE ( (invchead_cust_id=<? value("cust_id") ?>) 
    <? if exists("startDate") ?>
      AND   (invchead_invcdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
    <? endif ?>
      AND   (invchead_posted)
      AND   ((SELECT SUM(invcitem_price)
              FROM invcitem
             WHERE (invcitem_invchead_id=invchead_id))=0) )
  ) AS data
  ORDER BY sortdate, sortnumber, type;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (277, 'projects', 'detail', ' Copyright (c) 1999-2013 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.  xTuple version 4.2.0 - Modified to significantly amend the display of this screen and its filters. xTuple version 4.3.0 - Add Incidents to hierarchy display', '-- Group: projects
-- Name:  detail
-- Notes: 
--        Copyright (c) 1999-2013 by OpenMFG LLC, d/b/a xTuple.
--        See www.xtuple.com/CPAL for the full text of the software license.
--        
--        xTuple version 4.2.0 - Modified to significantly amend the display of this screen and its filters.
--        xTuple version 4.3.0 - Add Incidents to hierarchy display
SELECT *, 
  formatQty(qty) AS f_qty,
  formatMoney(value) AS f_value,
  ''curr'' AS qty_xtnumericrole,
  ''curr'' AS value_xtnumericrole,
  CASE WHEN COALESCE(hrs_balance,0) < 0 THEN ''red'' END AS hrs_balance_qtforegroundrole,
  CASE WHEN COALESCE(exp_balance,0) < 0 THEN ''red'' END AS exp_balance_qtforegroundrole
FROM (
SELECT prj_id AS id,
       1 AS type,
       ''0'' AS subtype,
       0 AS section,
       prj_id AS project,
       NULL  AS section_qtdisplayrole,
       prj_number AS name,
       CASE                         
           WHEN prj_status = ''C'' THEN <? value(''complete'') ?>
           WHEN prj_status = ''O'' THEN <? value(''inprocess'') ?>
           WHEN prj_status = ''P'' THEN <? value(''planning'') ?>
       END AS status,
       COALESCE(prjtype_descr, ''Undefined'') AS project_type,
       prj_username,
       prj_owner_username,
       prj_name AS item,
       firstline(prj_descrip) AS descrip,
       crmacct_name AS customer, 
       cntct_name AS contact,
       addr_city AS city,
       addr_state AS state,
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value,
       prj_due_date AS due,
       prj_assigned_date AS assigned,
       prj_start_date AS started,
       prj_completed_date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
       CASE WHEN (prj_status = ''O'' AND prj_due_date < current_date) THEN ''red'' 
         WHEN (prj_status = ''O'' AND prj_due_date BETWEEN current_date AND current_date + (fetchmetricvalue(''ProjectDueDateWarning'')||'' days'')::interval) THEN ''orange'' 
         END AS due_qtforegroundrole,
       0 AS xtindentrole
  FROM prj()
  LEFT OUTER JOIN prjtype ON (prj_prjtype_id=prjtype_id)
  LEFT OUTER JOIN crmacct ON (prj_crmacct_id=crmacct_id)
  LEFT OUTER JOIN cntct ON (crmacct_cntct_id_1=cntct_id)
  LEFT OUTER JOIN addr ON (cntct_addr_id=addr_id)

 WHERE (1=1 )
 
UNION ALL
----- TASKS -----
SELECT DISTINCT -1 AS id, 
       3 AS type,
       ''0'' AS subtype,
       1 AS section,
       prjtask_prj_id AS project,
       <? value(''tasks'') ?> AS section_qtdisplayrole,
       <? value(''tasks'') ?> AS name,
       NULL::text AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
       NULL::text AS due_qtforegroundrole,
       1 AS xtindentrole
    FROM prjtask
UNION ALL

SELECT prjtask_id AS id,
       5 AS type,
       ''0'' AS subtype,
       1 AS section,
       prjtask_prj_id AS project,
       NULL AS section_qtdisplayrole,
       prjtask_number AS name,
       CASE                         
           WHEN prjtask_status = ''C'' THEN <? value(''complete'') ?>
           WHEN prjtask_status = ''O'' THEN <? value(''inprocess'') ?>
           WHEN prjtask_status = ''P'' THEN <? value(''planning'') ?>
       END AS status,
       NULL::text AS project_type,
       prjtask_username AS prj_username,
       prjtask_owner_username AS prj_owner_username,
       prjtask_name AS item,
       prjtask_descrip AS descrip,
       cust_name as customer,
       cntct_name AS contact,
       addr_city AS city,
       addr_state AS state,
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value,
       prjtask_due_date AS due,
       prjtask_assigned_date AS assigned,
       prjtask_start_date AS started,
       prjtask_completed_date AS completed,
       prjtask_hours_budget AS hrs_budget,
       prjtask_hours_actual AS hrs_actual,
       (prjtask_hours_budget-prjtask_hours_actual) AS hrs_balance,
       prjtask_exp_budget AS exp_budget,
       prjtask_exp_actual AS exp_actual,
       (prjtask_exp_budget-prjtask_exp_actual) AS exp_balance,
       CASE WHEN (prjtask_status = ''O'' AND prjtask_due_date < current_date) THEN ''red'' 
         WHEN (prjtask_status = ''O'' AND prjtask_due_date BETWEEN current_date AND current_date + (fetchmetricvalue(''ProjectDueDateWarning'')||'' days'')::interval) THEN ''orange'' 
         END AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM prjtask
  LEFT OUTER JOIN te.teprjtask ON (prjtask_id = teprjtask_prjtask_id)
  LEFT OUTER JOIN custinfo ON (teprjtask_cust_id=cust_id)
  LEFT OUTER JOIN cntct ON (cust_corrcntct_id=cntct_id)
  LEFT OUTER JOIN addr ON (cntct_addr_id=addr_id)

 WHERE (1=1 )
 GROUP BY prjtask_prj_id, custinfo.cust_name, prjtask.prjtask_id, addr.addr_city, addr.addr_state, cntct_name, prjtask.prjtask_number, prjtask.prjtask_status, prjtask_username, prjtask.prjtask_owner_username, prjtask_name, prjtask_descrip, prjtask_due_date, prjtask_assigned_date, prjtask_start_date, prjtask_completed_date, prjtask_hours_budget, prjtask_hours_actual, prjtask_exp_budget, prjtask_exp_actual

<? if exists("showIn") ?>

UNION ALL
----- INCIDENTS -----
SELECT DISTINCT -1 AS id, 
       100 AS type,
       ''0'' AS subtype,
       1 AS section,
       incdt_prj_id AS project,
       ''Incidents'' AS section_qtdisplayrole,
       ''Incidents'' AS name,
       NULL::text AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
       NULL::text AS due_qtforegroundrole,
       1 AS xtindentrole
    FROM incdt
UNION ALL

SELECT incdt_id AS id,
       105 AS type,
       ''0'' AS subtype,
       1 AS section,
       incdt_prj_id AS project,
       NULL AS section_qtdisplayrole,
       incdt_number::text AS name,
       CASE                         
           WHEN incdt_status = ''L'' THEN <? value(''closed'') ?>
           WHEN incdt_status = ''N'' THEN <? value(''new'') ?>
           WHEN incdt_status = ''F'' THEN <? value(''feedback'') ?>
           WHEN incdt_status = ''A'' THEN <? value(''assigned'') ?>	
           WHEN incdt_status = ''R'' THEN <? value(''resolved'') ?>
           WHEN incdt_status = ''C'' THEN <? value(''confirmed'') ?>
       END AS status,
       NULL::text AS project_type,
       incdt_assigned_username AS prj_username,
       incdt_owner_username AS prj_owner_username,
       incdt_number::text AS item,
       incdt_summary AS descrip,
       crmacct_number AS customer,
       crmacct_name AS contact,
       addr_city AS city,
       addr_state AS state,
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
       NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM incdt
  LEFT OUTER JOIN crmacct ON (incdt_crmacct_id=crmacct_id)
  LEFT OUTER JOIN cntct ON (incdt_cntct_id=cntct_id)
  LEFT OUTER JOIN addr ON (cntct_addr_id=addr_id)

 WHERE (1=1 )
 GROUP BY incdt_id, incdt_prj_id, incdt_number, crmacct_number, crmacct_name, addr.addr_city, addr.addr_state, cntct_name, incdt_number, incdt_status, incdt_assigned_username, incdt_owner_username, incdt_number, incdt_summary
<? endif ?>
    
<? if exists("showSo") ?>
UNION ALL

----- QUOTES -----
SELECT DISTINCT -1 AS id, 
       10 AS type,
       ''0'' AS subtype,
       1 AS section,
       prj_id AS project,
       <? value("quotes") ?> AS section_qtdisplayrole,
       <? value("quotes") ?> AS name,
       NULL::text AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value, 
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
       NULL::text AS due_qtforegroundrole,
       1 AS xtindentrole
  FROM quhead
  JOIN prj() ON (quhead_prj_id=prj_id)
 WHERE (1=1)
UNION ALL

SELECT quhead_id AS id, 
       15 AS type,
       quhead_number AS subtype,
       1 AS section,
       prj_id AS project,
       <? value("quotes") ?> AS section_qtdisplayrole,
       quhead_number AS name,
       CASE WHEN (quhead_status = ''C'') THEN 
         <? value("converted") ?>
            WHEN (quhead_status = ''X'') THEN
         <? value("canceled") ?>
            WHEN (COALESCE(quhead_expire, current_date + 1) > current_date) THEN
         <? value("open") ?>
            ELSE
         <? value("expired") ?>
       END AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       NULL::text AS item,
       NULL::text AS descrip,
       cust_name AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       NULL AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
       NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM quhead
  JOIN prj() ON (quhead_prj_id=prj_id)
  JOIN custinfo ON (quhead_cust_id=cust_id)
    JOIN quitem ON (quitem_quhead_id = quhead_id)
 WHERE (1=1)
GROUP BY prj_id, quhead_id, quhead_number, quhead_status, quhead_expire, quhead_freight, quhead_misc, custinfo.cust_name

UNION ALL

SELECT quitem_id AS id, 
       17 AS type,
       quhead_number AS subtype,
       1 AS section,
       prj_id AS project,
       <? value("quotes") ?> AS section_qtdisplayrole,
       quitem_linenumber::text AS name, 
       CASE WHEN (quhead_status = ''C'') THEN 
         <? value("converted") ?>
            WHEN (quhead_status = ''X'') THEN
         <? value("canceled") ?>
            WHEN (COALESCE(quhead_expire, current_date + 1) > current_date) THEN
         <? value("open") ?>
            ELSE
         <? value("expired") ?>
       END AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       item_number AS item,
       item_descrip1 || '' '' || item_descrip2 AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       quitem_qtyord,
       uom_name AS uom,
       (quitem_qtyord * quitem_qty_invuomratio) * (quitem_price / quitem_price_invuomratio) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance, 
       NULL::text AS due_qtforegroundrole,
       3 AS xtindentrole
  FROM quhead
  JOIN prj() ON (quhead_prj_id=prj_id)
    JOIN quitem ON (quitem_quhead_id = quhead_id)
    JOIN uom ON (quitem_qty_uom_id = uom_id)
    JOIN itemsite ON (quitem_itemsite_id = itemsite_id)
    JOIN item ON (itemsite_item_id = item_id)
 WHERE (1=1)

UNION ALL

SELECT quhead_id AS id, 
       18 AS type,
       quhead_number AS subtype,
       1 AS section,
       prj_id AS project,
       <? value("quotes") ?> AS section_qtdisplayrole,
       <? value("total") ?> AS name,
       NULL AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       SUM((quitem_qtyord * quitem_qty_invuomratio) * (quitem_price / quitem_price_invuomratio)) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM quhead
    JOIN prj() ON (quhead_prj_id=prj_id)
    JOIN quitem ON (quitem_quhead_id = quhead_id)
 WHERE (1=1)
GROUP BY prj_id, quhead_id, quhead_number

UNION ALL

SELECT -1 AS id, 
       19 AS type,
       MAX(quhead_number) AS subtype,
       1 AS section,
       prj_id AS project,
       <? value("quotes") ?> AS section_qtdisplayrole,
       <? value("total") ?> || '' '' || <? value("quotes") ?> AS name,
       NULL AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       SUM((quitem_qtyord * quitem_qty_invuomratio) * (quitem_price / quitem_price_invuomratio)) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM quhead
    JOIN prj() ON (quhead_prj_id=prj_id)
    JOIN quitem ON (quitem_quhead_id = quhead_id)
 WHERE (1=1)
 GROUP BY prj_id

UNION ALL

------ SALES ORDERS ------
SELECT DISTINCT -1 AS id, 
       20 AS type,
       ''0'' AS subtype,
       2 AS section,
       prj_id AS project,
       <? value("sos") ?> AS section_qtdisplayrole,
       <? value("sos") ?> AS name,
       NULL::text AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       1 AS xtindentrole
  FROM cohead
    JOIN prj() ON (cohead_prj_id=prj_id)
 WHERE (1=1)

UNION ALL

SELECT cohead_id AS id, 
       25 AS type,
       cohead_number::text AS subtype,
       2 AS section,
       prj_id AS project,
       <? value("sos") ?> AS section_qtdisplayrole,
       cohead_number::text AS name,
      COALESCE((SELECT 
                  CASE WHEN (coitem_status = ''O'') THEN
                    <? value("open") ?>
                       WHEN (coitem_status = ''C'') THEN
                    <? value("closed" ?>
                      ELSE
                    <? value("canceled") ?>
                  END
                FROM 
               (SELECT coitem_status,
                   CASE 
                     WHEN (coitem_status = ''O'') THEN 1
                     WHEN (coitem_status = ''C'') then 2
                     ELSE  3
                  END AS type
                  FROM coitem
                 WHERE (coitem_cohead_id=cohead_id)
                 ORDER BY type
                 LIMIT 1) AS sts) ,''O'')
        AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       shipto_num AS item,
       shipto_name AS descrip,
       cust_name AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       NULL AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM cohead
    JOIN prj() ON (cohead_prj_id=prj_id)
    JOIN custinfo ON (cust_id = cohead_cust_id)
    LEFT OUTER JOIN shiptoinfo ON (cohead_shipto_id = shipto_id)
    JOIN coitem ON (coitem_cohead_id = cohead_id)
 WHERE (1=1)
GROUP BY prj_id,cohead_id, cohead_number, shipto_num, shipto_name, cust_name

UNION ALL

SELECT coitem_id AS id, 
       27 AS type,
       cohead_number::text AS subtype,
       2 AS section,
       prj_id AS project,
       <? value("sos") ?> AS section_qtdisplayrole,
       coitem_linenumber::text AS name, 
       CASE WHEN (coitem_status = ''O'') THEN
         <? value("open") ?>
            WHEN (coitem_status = ''C'') THEN
         <? value("closed" ?>
            WHEN (coitem_status = ''X'') THEN
         <? value("canceled") ?>
       END AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       item_number AS item,
       item_descrip1 || '' '' || item_descrip2 AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       coitem_qtyord,
       uom_name AS uom,
       (coitem_qtyord * coitem_qty_invuomratio) * (coitem_price / coitem_price_invuomratio) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       3 AS xtindentrole
  FROM cohead
    JOIN prj() ON (cohead_prj_id=prj_id)
    JOIN coitem ON (coitem_cohead_id = cohead_id)
    JOIN uom ON (coitem_qty_uom_id = uom_id)
    JOIN itemsite ON (coitem_itemsite_id = itemsite_id)
    JOIN item ON (itemsite_item_id = item_id)
 WHERE (1=1)

UNION ALL

SELECT cohead_id AS id, 
       28 AS type,
       cohead_number::text AS subtype,
       2 AS section,
       prj_id AS project,
       <? value("sos") ?> AS section_qtdisplayrole,
       <? value("total") ?> AS name,
       NULL AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       SUM((coitem_qtyord * coitem_qty_invuomratio) * (coitem_price / coitem_price_invuomratio)) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM cohead
    JOIN prj() ON (cohead_prj_id=prj_id)
    JOIN coitem ON (coitem_cohead_id = cohead_id)
 WHERE (1=1)
GROUP BY prj_id,cohead_id, cohead_number

UNION ALL

SELECT -1 AS id, 
       29 AS type,
       MAX(cohead_number::text) AS subtype,
       2 AS section,
       prj_id AS project,
       <? value("sos") ?> AS section_qtdisplayrole,
       <? value("total") ?> || '' '' || <? value("sos") ?> AS name,
       NULL AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       SUM((coitem_qtyord * coitem_qty_invuomratio) * (coitem_price / coitem_price_invuomratio)) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        	
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM cohead
    JOIN prj() ON (cohead_prj_id=prj_id)
    JOIN coitem ON (coitem_cohead_id = cohead_id)
 WHERE (1=1)
 GROUP BY prj_id
 
UNION ALL

------ INVOICES -------
SELECT DISTINCT -1 AS id, 
       30 AS type,
       ''0'' AS subtype,
       3 AS section,
       prj_id AS project,
       <? value("invoices") ?> AS section_qtdisplayrole,
       <? value("invoices") ?> AS name,
       NULL::text AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       1 AS xtindentrole
  FROM invchead
  JOIN prj() ON (invchead_prj_id=prj_id)
 WHERE (1=1)

UNION ALL

SELECT invchead_id AS id,
       35 AS type,
       invchead_invcnumber::text AS subtype,
       3 AS section,
       prj_id AS project,
       <? value("invoices") ?> AS section_qtdisplayrole,
       invchead_invcnumber::text AS name,
       CASE WHEN (invchead_posted) THEN
         <? value("posted") ?>
       ELSE <? value("unposted") ?>
       END AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       shipto_num AS item,
       shipto_name AS descrip,
       cust_name AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       NULL AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM invchead
    JOIN prj() ON (invchead_prj_id=prj_id)
    JOIN custinfo ON (cust_id=invchead_cust_id)
    LEFT OUTER JOIN shiptoinfo ON (invchead_shipto_id = shipto_id)

    JOIN invcitem ON (invcitem_invchead_id = invchead_id)
 WHERE (1=1)
GROUP BY prj_id,invchead_id, invchead_invcnumber, shipto_num, shipto_name, invchead_freight, invchead_misc_amount, invchead_posted, cust_name

UNION ALL

SELECT invcitem_id AS id, 
       37 AS type,
       invchead_invcnumber::text AS subtype,
       3 AS section,
       prj_id AS project,
       <? value("invoices") ?> AS section_qtdisplayrole,
       invcitem_linenumber::text AS name, 
       CASE WHEN (invchead_posted) THEN
         <? value("posted") ?>
       ELSE <? value("unposted") ?>
       END AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       COALESCE(item_number,invcitem_number) AS item,
       COALESCE(item_descrip1 || '' '' || item_descrip2,invcitem_descrip) AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       invcitem_billed AS qty,
       uom_name AS uom,
       (invcitem_billed * invcitem_qty_invuomratio) * (invcitem_price / invcitem_price_invuomratio) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       3 AS xtindentrole
  FROM invchead
    JOIN prj() ON (invchead_prj_id=prj_id)
    JOIN invcitem ON (invcitem_invchead_id = invchead_id)
    LEFT OUTER JOIN item ON (invcitem_item_id = item_id)
    LEFT OUTER JOIN uom ON (invcitem_qty_uom_id = uom_id)
 WHERE (1=1)

UNION ALL

SELECT invchead_id AS id, 
       38 AS type,
       invchead_invcnumber::text AS subtype,
       3 AS section,
       prj_id AS project,
       <? value("invoices") ?> AS section_qtdisplayrole,
       <? value("total") ?> AS name,
       NULL AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       SUM((invcitem_billed * invcitem_qty_invuomratio) * (invcitem_price / invcitem_price_invuomratio)) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
       
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM invchead
    JOIN prj() ON (invchead_prj_id=prj_id)
    JOIN invcitem ON (invcitem_invchead_id = invchead_id)
 WHERE (1=1)
GROUP BY prj_id,invchead_id, invchead_invcnumber

UNION ALL

SELECT -1 AS id, 
       39 AS type,
       MAX(invchead_invcnumber::text) AS subtype,
       3 AS section,
       prj_id AS project,
       <? value("invoices") ?> AS section_qtdisplayrole,
       <? value("total") ?> || '' '' || <? value("invoices") ?> AS name,
       NULL AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       SUM((invcitem_billed * invcitem_qty_invuomratio) * (invcitem_price / invcitem_price_invuomratio)) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM invchead
    JOIN prj() ON (invchead_prj_id=prj_id)
    JOIN invcitem ON (invcitem_invchead_id = invchead_id)
 WHERE (1=1)
 GROUP BY prj_id
 
<? endif ?>  

<? if exists("showWo") ?>
UNION ALL

------ WORK ORDERS -------
SELECT DISTINCT -1 AS id, 
       40 AS type,
       ''0'' AS subtype,
       4 AS section,
       prj_id AS project,
       <? value("wos") ?> AS section_qtdisplayrole,
       <? value("wos") ?> AS name,
       NULL::text AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       1 AS xtindentrole
  FROM wo 
  JOIN prj() ON (wo_prj_id=prj_id)
 WHERE (1=1)

UNION ALL

SELECT wo_id AS id, 
       45 AS type,
       formatWoNumber(wo_id) AS subtype,
       4 AS section,
       prj_id AS project,
       <? value("wos") ?> AS section_qtdisplayrole,
       formatWoNumber(wo_id) AS name,
       CASE WHEN (wo_status = ''O'') THEN
         <? value("open") ?>
            WHEN (wo_status = ''E'') THEN
         <? value("exploded") ?>
            WHEN (wo_status = ''R'') THEN
         <? value("released") ?>
            WHEN (wo_status = ''I'') THEN
         <? value("inprocess") ?>
            WHEN (wo_status = ''C'') THEN
         <? value("closed" ?>
       END AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       item_number AS item,
       item_descrip1 || '' '' || item_descrip2 AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       wo_qtyord AS qty,
       uom_name AS uom,
       wo_postedvalue AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
       
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM wo
    JOIN prj() ON (wo_prj_id=prj_id)
    JOIN itemsite ON (itemsite_id=wo_itemsite_id)
    JOIN item ON (itemsite_item_id=item_id)
    JOIN uom ON (item_inv_uom_id=uom_id)
 WHERE (1=1)

UNION ALL

SELECT -1 AS id, 
       49 AS type,
       MAX(formatWoNumber(wo_id)) AS subtype,
       4 AS section,
       prj_id AS project,
       <? value("wos") ?> AS section_qtdisplayrole,
       <? value("total") ?> || '' '' || <? value("wos") ?> AS name,
       NULL AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       SUM(wo_postedvalue) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM wo
     JOIN prj() ON (wo_prj_id=prj_id)
 WHERE (1=1)
 GROUP BY prj_id

<? endif ?>


<? if exists("showPo") ?>
 UNION ALL
------ PURCHASE REQUESTS ------
SELECT DISTINCT -1 AS id, 
       50 AS type,
       ''0'' AS subtype,
       5 AS section,
       prj_id AS project,
       <? value("prs") ?> AS section_qtdisplayrole,
       <? value("prs") ?> AS name,
       NULL::text AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       1 AS xtindentrole
  FROM pr
    JOIN prj() ON (pr_prj_id=prj_id)
 WHERE (1=1)

UNION ALL

SELECT pr_id AS id, 
       55 AS type,
       pr_number::text || ''-'' || pr_subnumber::text AS subtype,
       5 AS section,
       prj_id AS project,
       <? value("prs") ?> AS section_qtdisplayrole,
       pr_number::text || ''-'' || pr_subnumber::text AS name,
       <? value("open") ?> AS status, 
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       item_number AS item,
       (item_descrip1 || '' '' || item_descrip2) AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       pr_qtyreq AS qty,
       uom_name AS uom,
       stdcost(item_id) * pr_qtyreq AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM pr
    JOIN prj() ON (pr_prj_id=prj_id)
    JOIN itemsite ON (itemsite_id = pr_itemsite_id)
    JOIN item ON (itemsite_item_id = item_id)
    JOIN uom ON (item_inv_uom_id = uom_id)
 WHERE (1=1)

UNION ALL

SELECT -1 AS id, 
       59 AS type,
       MAX(pr_number::text || ''-'' || pr_subnumber::text) AS subtype,
       5 AS section,
       prj_id AS project,
       <? value("prs") ?> AS section_qtdisplayrole,
       <? value("total") ?> || '' '' || <? value("prs") ?> AS name,
       NULL AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,       
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       SUM(stdcost(item_id) * pr_qtyreq) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM pr
    JOIN prj() ON (pr_prj_id=prj_id)
    JOIN itemsite ON (itemsite_id = pr_itemsite_id)
    JOIN item ON (itemsite_item_id = item_id)
 WHERE (1=1)
 GROUP BY prj_id
 
UNION ALL

------ PURCHASE ORDERS ------
SELECT DISTINCT -1 AS id, 
       60 AS type,
       ''0'' AS subtype,
       6 AS section,
       prj_id AS project,
       <? value("pos") ?> AS section_qtdisplayrole,
       <? value("pos") ?> AS name,
       NULL::text AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL::numeric AS qty,
       NULL::text AS uom,
       NULL::numeric AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       1 AS xtindentrole
  FROM poitem
    JOIN prj() ON (poitem_prj_id=prj_id)
 WHERE (1=1)

UNION ALL

SELECT pohead_id AS id,
       65 AS type,
       pohead_number::text AS subtype,
       6 AS section,
       prj_id AS project,
       <? value("pos") ?> AS section_qtdisplayrole,
       pohead_number::text AS name,
       CASE WHEN (pohead_status = ''U'') THEN
         <? value("unreleased") ?>
            WHEN (pohead_status = ''O'') THEN
         <? value("open") ?>
            WHEN (pohead_status = ''C'') THEN
         <? value("closed" ?>
       END AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       NULL AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL AS uom,
       NULL AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM pohead
    JOIN poitem ON (poitem_pohead_id = pohead_id)
    JOIN prj() ON (poitem_prj_id=prj_id)
 WHERE (1=1)
GROUP BY prj_id,pohead_id, pohead_number, pohead_freight, pohead_status

UNION ALL

SELECT poitem_id AS id, 
       67 AS type,
       pohead_number::text AS subtype,
       6 AS section,
       prj_id AS project,
       <? value("pos") ?> AS section_qtdisplayrole,
       poitem_linenumber::text AS name, 
       CASE WHEN (poitem_status = ''U'') THEN
         <? value("unreleased") ?>
            WHEN (poitem_status = ''O'') THEN
         <? value("open") ?>
            WHEN (poitem_status = ''C'') THEN
         <? value("closed" ?>
       END AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       COALESCE(item_number,poitem_vend_item_number) AS item,
       COALESCE((item_descrip1 || '' '' || item_descrip2),poitem_vend_item_descrip) AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       poitem_qty_ordered,
       poitem_vend_uom AS uom,
       (poitem_qty_ordered * poitem_unitprice) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       3 AS xtindentrole
  FROM pohead
    JOIN poitem ON (poitem_pohead_id = pohead_id)
    JOIN prj() ON (poitem_prj_id=prj_id)
    LEFT OUTER JOIN itemsite ON (poitem_itemsite_id=itemsite_id)
    LEFT OUTER JOIN item ON (itemsite_item_id = item_id)
 WHERE (1=1)

UNION ALL

SELECT pohead_id AS id, 
       68 AS type,
       pohead_number::text AS subtype,
       6 AS section,
       prj_id AS project,
       <? value("pos") ?> AS section_qtdisplayrole,
       <? value("total") ?> AS name,
       NULL AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       SUM(poitem_qty_ordered * poitem_unitprice) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM pohead
    JOIN poitem ON (poitem_pohead_id = pohead_id)
    JOIN prj() ON (poitem_prj_id=prj_id)
 WHERE (1=1)
GROUP BY prj_id,pohead_id, pohead_number

UNION ALL

SELECT -1 AS id, 
       69 AS type,
       MAX(pohead_number::text) AS subtype,
       6 AS section,
       prj_id AS project,
       ''qty'' AS section_qtdisplayrole,
       <? value("total") ?> || '' '' || <? value("pos") ?> AS name,
       NULL AS status,
       NULL::text AS project_type,
       NULL::text AS prj_username,
       NULL::text AS prj_owner_username,
       NULL::text AS item,
       NULL::text AS descrip,
       NULL::text AS customer,
       NULL::text AS contact,
       NULL::text AS city,
       NULL::text AS state,       
       NULL AS qty,
       NULL::text AS uom,
       SUM(poitem_qty_ordered * poitem_unitprice) AS value,
       NULL::date AS due,
       NULL::date AS assigned,
       NULL::date AS started,
       NULL::date AS completed,
       NULL::numeric AS hrs_budget,
       NULL::numeric AS hrs_actual,
       NULL::numeric AS hrs_balance,
       NULL::numeric AS exp_budget,
       NULL::numeric AS exp_actual,
       NULL::numeric AS exp_balance,
        
	NULL::text AS due_qtforegroundrole,
       2 AS xtindentrole
  FROM pohead
    JOIN poitem ON (poitem_pohead_id = pohead_id)
    JOIN prj() ON (poitem_prj_id=prj_id)
 WHERE (1=1)
 GROUP BY prj_id 

<? endif ?>

) data

WHERE (true)
<? if exists("search_pattern") ?>
   AND project IN (SELECT prj_id FROM prj WHERE ( (prj_number ~* <? value("search_pattern") ?>)
     OR  (prj_name ~* <? value("search_pattern") ?>)
     OR  (prj_descrip ~* <? value("search_pattern") ?>) ))
<? endif ?>
<? if exists("username") ?>
  AND (prj_username=<? value("username") ?> OR prj_owner_username=<? value("username") ?>)
<? endif ?>
<? if exists("assigned_username") ?> 
  AND (prj_username=<? value("assigned_username") ?>) 
<? elseif exists("assigned_usr_pattern") ?>
  AND (prj_username ~ <? value("assigned_usr_pattern") ?>) 
<? endif ?>
<? if exists("owner_username") ?> 
  AND (prj_owner_username=<? value("owner_username") ?>)
<? elseif exists("owner_usr_pattern") ?>
  AND (prj_owner_username ~ <? value("owner_usr_pattern") ?>) 
<? endif ?>
<? if exists("crmacct_id") ?>
  AND project IN (SELECT prj_id FROM prj WHERE (prj_crmacct_id=<? value("crmacct_id") ?>))
<? endif ?>
<? if exists("cntct_id") ?>
  AND project IN (SELECT prj_id FROM prj WHERE (prj_cntct_id=<? value("cntct_id") ?>))
<? endif ?>
<? if exists("startStartDate") ?>
  AND project IN (SELECT prj_id FROM prj WHERE (prj_start_date >= <? value("startStartDate") ?>))
<? endif ?>
<? if exists("startEndDate") ?>
  AND project IN (SELECT prj_id FROM prj WHERE (prj_start_date <= <? value("startEndDate") ?>))
<? endif ?>
<? if exists("dueStartDate") ?>
  AND project IN (SELECT prj_id FROM prj WHERE (prj_due_date >= <? value("dueStartDate") ?>))
<? endif ?>
<? if exists("dueEndDate") ?>
  AND project IN (SELECT prj_id FROM prj WHERE (prj_due_date <= <? value("dueEndDate") ?>))
<? endif ?>
<? if exists("assignedStartDate") ?>
  AND project IN (SELECT prj_id FROM prj WHERE (prj_assigned_date >= <? value("assignedStartDate") ?>))
<? endif ?>
<? if exists("assignedEndDate") ?>
  AND project IN (SELECT prj_id FROM prj WHERE (prj_assigned_date <= <? value("assignedEndDate") ?>))
<? endif ?>
<? if exists("completedStartDate") ?>
  AND project IN (SELECT prj_id FROM prj WHERE (prj_completed_date >= <? value("completedStartDate") ?>))
<? endif ?>
<? if exists("completedEndDate") ?>
  AND project IN (SELECT prj_id FROM prj WHERE (prj_completed_date <= <? value("completedEndDate") ?>))
<? endif ?>
<? if not exists("showComplete") ?>
  AND project IN (SELECT prj_id FROM prj WHERE prj_status <> ''C'')
<? endif ?>
<? if exists("prj_id") ?>
  AND (project=<? value("prj_id") ?>)
<? endif ?>
<? if exists("prjtype_id") ?>
  AND project IN (SELECT prj_id FROM prj WHERE (prj_prjtype_id=<? value("prjtype_id") ?>))
<? endif ?>
<? if exists("project_task") ?>
  AND project IN (SELECT DISTINCT prjtask_prj_id FROM prjtask where ((prjtask_number ~* <? value("project_task") ?>)
						OR (prjtask_name ~* <? value("project_task") ?>)
						OR (prjtask_descrip ~* <? value("project_task") ?>)))
<? endif ?>
<? if exists("cohead_id") ?>
  AND project IN (SELECT cohead_prj_id FROM cohead where cohead_id=<? value("cohead_id") ?>)
<? endif ?>
<? if exists("wo_id") ?>
  AND project IN (SELECT wo_prj_id FROM wo WHERE wo_id=<? value("wo_id") ?>)
<? endif ?>
<? if exists("pohead_id") ?>
  AND project IN (SELECT poitem_prj_id FROM pohead JOIN poitem ON (pohead_id=poitem_pohead_id) 
			WHERE pohead_id=<? value("pohead_id") ?>)
<? endif ?>


ORDER BY project, section, subtype, type, id;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (278, 'prospects', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: prospects
-- Name:  detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT 
  prospect.*,
  cntct.*, addr.*
FROM prospect 
  LEFT OUTER JOIN cntct ON (prospect_cntct_id=cntct_id) 
  LEFT OUTER JOIN addr ON (cntct_addr_id=addr_id) 
WHERE true
<? if not exists("showInactive") ?> 
  AND prospect_active 
<? endif ?>
<? if exists("owner_username") ?> 
  AND (prospect_owner_username=<? value("owner_username") ?>) 
<? elseif exists("owner_usr_pattern") ?>
  AND (prospect_owner_username ~ <? value("owner_usr_pattern") ?>) 
<? endif ?>
<? if exists("search_pattern") ?>
  AND ((prospect_number ~* <? value("search_pattern") ?>)
       OR (prospect_name ~* <? value("search_pattern") ?>)
       OR (COALESCE(cntct_first_name,'''') || '' '' || COALESCE(cntct_last_name,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(cntct_phone,'''') || '' '' || COALESCE(cntct_phone2,'''') || '' '' || COALESCE(cntct_fax,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(cntct_email,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(addr_line1,'''') || '' '' || COALESCE(addr_line2,'''') || '' '' || COALESCE(addr_line3,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(addr_city,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(addr_state,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(addr_postalcode,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(addr_country,'''') ~* <? value("search_pattern") ?>))
<? endif ?>
<? if exists("prospect_number_pattern") ?>
  AND (prospect_number ~* <? value("prospect_number_pattern") ?>)
<? endif ?>
<? if exists("prospect_name_pattern") ?>
  AND (prospect_name ~* <? value("prospect_name_pattern") ?>)
<? endif ?>
<? if exists("cntct_name_pattern") ?>
  AND (COALESCE(cntct_first_name,'''') || '' '' || COALESCE(cntct_last_name,'''') ~* <? value("cntct_name_pattern") ?>)
<? endif ?>
<? if exists("cntct_phone_pattern") ?>
  AND (COALESCE(cntct_phone,'''') || '' '' || COALESCE(cntct_phone2,'''') || '' '' || COALESCE(cntct_fax,'''') ~* <? value("cntct_phone_pattern") ?>)
<? endif ?>
<? if exists("cntct_email_pattern") ?>
  AND (COALESCE(cntct_email,'''') ~* <? value("cntct_email_pattern") ?>)
<? endif ?>
<? if exists("addr_street_pattern") ?>
  AND (COALESCE(addr_line1,'''') || '' '' || COALESCE(addr_line2,'''') || '' '' || COALESCE(addr_line3,'''') ~* <? value("addr_street_pattern") ?>)
<? endif ?>
<? if exists("addr_city_pattern") ?>
  AND (COALESCE(addr_city,'''') ~* <? value("addr_city_pattern") ?>)
<? endif ?>
<? if exists("addr_state_pattern") ?>
  AND (COALESCE(addr_state,'''') ~* <? value("addr_state_pattern") ?>)
<? endif ?>
<? if exists("addr_postalcode_pattern") ?>
  AND (COALESCE(addr_postalcode,'''') ~* <? value("addr_postalcode_pattern") ?>)
<? endif ?>
<? if exists("addr_country_pattern") ?>
  AND (COALESCE(addr_country,'''') ~* <? value("addr_country_pattern") ?>)
<? endif ?>
<? if exists("id") ?>
  AND (prospect_id=<? value("id") ?>
<? endif ?>
ORDER BY prospect_number; 
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (276, 'prices', 'detail', 'used by dspPricesByCustomerType, dspPricesByCustomer, dspPricesByItem Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: prices
-- Name: detail
-- Notes: used by dspPricesByCustomerType, dspPricesByCustomer, dspPricesByItem
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT itemid, sourcetype, schedulename, type,
<? if not exists("byItem") ?>
       itemnumber, itemdescrip, priceuom,
<? else ?>
       typename,
<? endif ?>
       CASE WHEN (qtybreak <> -1) THEN qtybreak END AS f_qtybreak,
       price,
       currConcat(curr_id) AS currConcat,
       ''qty'' AS f_qtybreak_xtnumericrole,
       <? value("na") ?> AS f_qtybreak_xtnullrole,
       ''salesprice'' AS price_xtnumericrole
<? if exists("showCosts") ?>
  <? if exists("byItem") ?>
       , CASE WHEN (<? value("cost") ?> <> 0) THEN <? value("cost") ?> END AS f_cost,
       CASE WHEN ((price <> 0) AND (<? value("cost") ?> <> 0)) THEN ((price - <? value("cost") ?>) /  price) END AS f_margin,
  <? else ?>
       , CASE WHEN (cost IS NOT NULL) THEN cost END AS f_cost,
      CASE WHEN ((price <> 0) AND (cost <>0)) THEN ((price - cost) / price) END AS f_margin,
  <? endif ?>
       ''cost'' AS f_cost_xtnumericrole,
       <? value("costna") ?> AS f_cost_xtnullrole,
       ''percent'' AS f_margin_xtnumericrole,
       <? value("na") ?> AS f_margin_xtnullrole,
  <? if exists("byItem") ?>
       CASE WHEN (<? value("cost") ?> > price) THEN ''error'' END AS f_margin_qtforegroundrole
  <? else ?>
       CASE WHEN (cost > price) THEN ''error'' END AS f_margin_qtforegroundrole
  <? endif ?>
<? endif ?>
FROM (
<? if not exists("byCustomerType") ?>
      SELECT
  <? if exists("byCustomer") ?>
             ipsprice_id AS itemid, 1 AS sourcetype,
             ipshead_name AS schedulename, <? value("customer") ?> AS type,
             item_number AS itemnumber, uom_name AS priceuom, iteminvpricerat(item_id) AS invpricerat,
             (item_descrip1 || '' '' || item_descrip2) AS itemdescrip,
             ipsprice_qtybreak AS qtybreak,
             ipsprice_price AS price, ipshead_curr_id AS curr_id,
             ipshead_updated AS effective
    <? if exists("useStandardCosts") ?>
             , (stdcost(item_id) * iteminvpricerat(item_id)) AS cost
    <? elseif exists("useActualCosts") ?>
             , (actcost(item_id) * iteminvpricerat(item_id)) AS cost
    <? endif ?>
  <? else ?>
             ipsprice_id AS itemid, 1 AS sourcetype,
             ipshead_name AS schedulename, <? value("customer") ?> AS type,
             cust_name AS typename,
             ipsprice_qtybreak AS qtybreak, ipsprice_price AS price, ipshead_curr_id AS curr_id
  <? endif ?>
      FROM ipsass, ipshead, ipsprice, item,
  <? if exists("byCustomer") ?>
           uom
  <? else ?>
          custinfo
  <? endif ?>
      WHERE ((ipsass_ipshead_id=ipshead_id)
         AND (ipsprice_ipshead_id=ipshead_id)
         AND (ipsprice_item_id=item_id)
  <? if exists("byCustomer") ?>
         AND (item_price_uom_id=uom_id)
         AND (ipsass_cust_id=<? value("cust_id") ?>)
         <? if exists("item_id") ?>
         AND (item_id=<? value("item_id") ?>)
         <? endif ?>
  <? else ?>
         AND (ipsass_cust_id=cust_id)
         AND (item_id=<? value("item_id") ?>)
  <? endif ?>
         AND (COALESCE(LENGTH(ipsass_shipto_pattern), 0) = 0)
  <? if not exists("showExpired") ?>
         AND (ipshead_expires > CURRENT_DATE)
  <? endif ?>
  <? if not exists("showFuture") ?>
         AND (ipshead_effective <= CURRENT_DATE)
  <? endif ?>
            )

      UNION
<? endif ?>

      SELECT
<? if exists("byItem") ?>
             ipsprice_id AS itemid, 2 AS sourcetype,
             ipshead_name AS schedulename, <? value("custType") ?> AS type,
             (custtype_code || ''-'' || custtype_descrip) AS typename,
             ipsprice_qtybreak AS qtybreak, ipsprice_price AS price, ipshead_curr_id AS curr_id
<? else ?>
             ipsprice_id AS itemid,
  <? if exists("byCustomerType") ?>
             1 AS sourcetype,
  <? elseif exists("byCustomer") ?>
             2 AS sourcetype,
  <? endif ?>
             ipshead_name AS schedulename, <? value("custType") ?> AS type,
             item_number AS itemnumber, uom_name AS priceuom, iteminvpricerat(item_id) AS invpricerat,
             (item_descrip1 || '' '' || item_descrip2) AS itemdescrip,
             ipsprice_qtybreak AS qtybreak,
             ipsprice_price AS price, ipshead_curr_id AS curr_id,
             ipshead_updated AS effective
  <? if exists("showCosts") ?>
    <? if exists("useStandardCosts") ?>
             , (stdcost(
      <? if exists("byCustomerType") ?>
                ipsprice_item_id
      <? elseif exists("byCustomer") ?>
                item_id
      <? endif ?>
                     ) * iteminvpricerat(item_id)) AS cost
    <? elseif exists("useActualCosts") ?>
             , (actcost(
      <? if exists("byCustomerType") ?>
                ipsprice_item_id
      <? elseif exists("byCustomer") ?>
                item_id
      <? endif ?>
                     ) * iteminvpricerat(item_id)) AS cost
    <? endif ?>
  <? endif ?>
<? endif ?>
      FROM ipsass, ipshead, ipsprice, item,
<? if exists("byItem") ?>
           custtype
<? else ?>
           uom
<? endif ?>
<? if exists("byCustomer") ?>
           , custinfo
<? endif ?>
      WHERE ((ipsass_ipshead_id=ipshead_id)
         AND (ipsprice_ipshead_id=ipshead_id)
         AND (ipsprice_item_id=item_id)
<? if not exists("byItem") ?>
         AND (item_price_uom_id=uom_id)
<? endif ?>
<? if exists("byCustomerType") ?>
         AND (ipsass_custtype_id=<? value("custtype_id") ?>)
<? elseif exists("byCustomer") ?>
         AND (ipsass_custtype_id=cust_custtype_id)
         AND (cust_id=<? value("cust_id") ?>)
         <? if exists("item_id") ?>
         AND (item_id=<? value("item_id") ?>)
         <? endif ?>
<? else ?>
         AND (ipsass_custtype_id=custtype_id)
         AND (item_id=<? value("item_id") ?>)
<? endif ?>
<? if not exists("showExpired") ?>
         AND (ipshead_expires > CURRENT_DATE)
<? endif ?>
<? if not exists("showFuture") ?>
         AND (ipshead_effective <= CURRENT_DATE)
<? endif ?>
            )

      UNION

      SELECT
<? if exists("byItem") ?>
             ipsprice_id AS itemid, 3 AS sourcetype,
             ipshead_name AS schedulename, <? value("custTypePattern") ?> AS type,
             (custtype_code || ''-'' || custtype_descrip) AS typename,
             ipsprice_qtybreak AS qtybreak, ipsprice_price AS price, ipshead_curr_id AS curr_id
<? else ?>
             ipsprice_id AS itemid,
  <? if exists("byCustomerType") ?>
             2 AS sourcetype,
  <? elseif exists("byCustomer") ?>
             3 AS sourcetype,
  <? endif ?>
             ipshead_name AS schedulename, <? value("custTypePattern") ?> AS type,
             item_number AS itemnumber, uom_name AS priceuom, iteminvpricerat(item_id) AS invpricerat,
             (item_descrip1 || '' '' || item_descrip2) AS itemdescrip,
             ipsprice_qtybreak AS qtybreak,
             ipsprice_price AS price, ipshead_curr_id AS curr_id,
             ipshead_updated AS effective
  <? if exists("showCosts") ?>
    <? if exists("useStandardCosts") ?>
             , (stdcost(
      <? if exists("byCustomerType") ?>
                ipsprice_item_id
      <? elseif exists("byCustomer") ?>
                item_id
      <? endif ?>
                     ) * iteminvpricerat(item_id)) AS cost
    <? elseif exists("useActualCosts") ?>
             , (actcost(
      <? if exists("byCustomerType") ?>
                ipsprice_item_id
      <? elseif exists("byCustomer") ?>
                item_id
      <? endif ?>
                     ) * iteminvpricerat(item_id)) AS cost
    <? endif ?>
  <? endif ?>
<? endif ?>
      FROM ipsass, ipshead, ipsprice, item, custtype
<? if not exists("byItem") ?>
           , uom
<? endif ?>
<? if exists("byCustomer") ?>
           , custinfo
<? endif ?>
      WHERE ((ipsass_ipshead_id=ipshead_id)
         AND (ipsprice_ipshead_id=ipshead_id)
         AND (ipsprice_item_id=item_id)
<? if not exists("byItem") ?>
         AND (item_price_uom_id=uom_id)
<? endif ?>
         AND (coalesce(length(ipsass_custtype_pattern), 0) > 0)
         AND (custtype_code ~ ipsass_custtype_pattern)
<? if exists("byCustomerType") ?>
         AND (custtype_id=<? value("custtype_id") ?>)
<? elseif exists("byCustomer") ?>
         AND (cust_id=<? value("cust_id") ?>)
         <? if exists("item_id") ?>
         AND (item_id=<? value("item_id") ?>)
         <? endif ?>
<? else ?>
         AND (item_id=<? value("item_id") ?>)
<? endif ?>
<? if not exists("showExpired") ?>
         AND (ipshead_expires > CURRENT_DATE)
<? endif ?>
<? if not exists("showFuture") ?>
         AND (ipshead_effective <= CURRENT_DATE)
<? endif ?>
            )

      UNION

      SELECT
<? if exists("byItem") ?>
             ipsprice_id AS itemid, 4 AS sourcetype,
             ipshead_name AS schedulename, <? value("sale") ?> AS type,
             sale_name AS typename,
             ipsprice_qtybreak AS qtybreak, ipsprice_price AS price, ipshead_curr_id AS curr_id
<? else ?>
             ipsprice_id AS itemid,
<? if exists("byCustomerType") ?>
             3
<? elseif exists("byCustomer") ?>
             4
<? endif ?> AS sourcetype,
             ipshead_name AS schedulename, (<? value("sale") ?> || ''-'' || sale_name) AS type,
             item_number AS itemnumber, uom_name AS priceuom, iteminvpricerat(item_id) AS invpricerat,
             (item_descrip1 || '' '' || item_descrip2) AS itemdescrip,
             ipsprice_qtybreak AS qtybreak,
             ipsprice_price AS price, ipshead_curr_id AS curr_id,
             ipshead_updated AS effective
<? if exists("showCosts") ?>
  <? if exists("useStandardCosts") ?>
             , (stdcost(
    <? if exists("byCustomerType") ?>
                ipsprice_item_id
    <? elseif exists("byCustomer") ?>
                item_id
    <? endif ?>
                     ) * iteminvpricerat(item_id)) AS cost
    <? elseif exists("useActualCosts") ?>
             , (actcost(
    <? if exists("byCustomerType") ?>
                ipsprice_item_id
    <? elseif exists("byCustomer") ?>
                item_id
    <? endif ?>
                     ) * iteminvpricerat(item_id)) AS cost
    <? endif ?>
  <? endif ?>
<? endif ?>
      FROM sale, ipshead, ipsprice, item
<? if not exists("byItem") ?>
           , uom
<? endif ?>
      WHERE ((sale_ipshead_id=ipshead_id)
         AND (ipsprice_ipshead_id=ipshead_id)
<? if not exists("byItem") ?>
         AND (item_price_uom_id=uom_id)
<? endif ?>
<? if exists("byItem") ?>
         AND (ipsprice_item_id=<? value("item_id") ?>)
  <? if not exists("showExpired") ?>
         AND (sale_enddate > CURRENT_DATE)
  <? endif ?>
  <? if not exists("showFuture") ?>
         AND (sale_startdate <= CURRENT_DATE)
  <? endif ?>
<? else ?>
         AND (ipsprice_item_id=item_id)
  <? if not exists("showExpired") ?>
         AND (ipshead_expires > CURRENT_DATE)
  <? endif ?>
  <? if not exists("showFuture") ?>
         AND (ipshead_effective <= CURRENT_DATE)
  <? endif ?>
<? endif ?>
            )

<? if exists("byItem") ?>

      UNION

      SELECT ipsprice_id AS itemid, 5 AS sourcetype,
             ipshead_name AS schedulename, <? value("shipTo") ?> AS type,
             (cust_name || ''-'' || shipto_num) AS typename,
             ipsprice_qtybreak AS qtybreak, ipsprice_price AS price, ipshead_curr_id AS curr_id
      FROM ipsass, ipshead, ipsprice, custinfo, shiptoinfo, item
      WHERE ((ipsass_ipshead_id=ipshead_id)
         AND (ipsprice_ipshead_id=ipshead_id)
         AND (ipsass_shipto_id=shipto_id)
         AND (shipto_cust_id=cust_id)
         AND (ipsprice_item_id=item_id)
         AND (item_id=<? value("item_id") ?>)
  <? if not exists("showExpired") ?>
         AND (ipshead_expires > CURRENT_DATE)
  <? endif ?>
  <? if not exists("showFuture") ?>
         AND (ipshead_effective <= CURRENT_DATE)
  <? endif ?>
            )

      UNION

      SELECT ipsprice_id AS itemid, 6 AS sourcetype,
             ipshead_name AS schedulename, <? value("shipToPattern") ?> AS type,
             (cust_name || ''-'' || shipto_num) AS typename,
             ipsprice_qtybreak AS qtybreak, ipsprice_price AS price, ipshead_curr_id AS curr_id
      FROM ipsass, ipshead, ipsprice, custinfo, shiptoinfo, item
      WHERE ((ipsass_ipshead_id=ipshead_id)
         AND (ipsprice_ipshead_id=ipshead_id)
         AND (COALESCE(LENGTH(ipsass_shipto_pattern),0) > 0)
         AND (shipto_num ~ ipsass_shipto_pattern)
         AND (ipsass_cust_id=cust_id)
         AND (shipto_cust_id=cust_id)
         AND (ipsprice_item_id=item_id)
         AND (item_id=:item_id)
  <? if not exists("showExpired") ?>
         AND (ipshead_expires > CURRENT_DATE)
  <? endif ?>
  <? if not exists("showFuture") ?>
         AND (ipshead_effective <= CURRENT_DATE)
  <? endif ?>
            )
<? endif ?>

      UNION

      SELECT
<? if exists("byItem") ?>
             item_id AS itemid, 0 AS sourcetype,
             <? value("listPrice") ?> AS schedulename, <? value("na") ?> AS type,
             '''' AS typename,
             -1 AS qtybreak, item_listprice AS price, baseCurrId() AS curr_id
<? else ?>
             item_id AS itemid, 0 AS sourcetype,
             '''' AS schedulename, <? value("listPrice") ?> AS type,
             item_number AS itemnumber, uom_name AS priceuom, iteminvpricerat(item_id) AS invpricerat,
             (item_descrip1 || '' '' || item_descrip2) AS itemdescrip,
             -1 AS qtybreak,
  <? if exists("byCustomerType") ?>
             item_listprice AS price,
  <? elseif exists("byCustomer") ?>
             (item_listprice - (item_listprice * cust_discntprcnt)) AS price,
  <? endif ?>
             baseCurrId() AS curr_id,
             CURRENT_DATE AS effective
  <? if exists("useStandardCosts") ?>
             , (stdcost(item_id) * iteminvpricerat(item_id)) AS cost
  <? elseif exists("useActualCosts") ?>
             , (actcost(item_id) * iteminvpricerat(item_id)) AS cost
  <? endif ?>
<? endif ?>
<? if exists("byCustomerType") ?>
      FROM item JOIN uom ON (item_price_uom_id=uom_id)
<? elseif exists("byCustomer") ?>
      FROM custinfo, item JOIN uom ON (item_price_uom_id=uom_id)
<? else ?>
      FROM item
<? endif ?>
      WHERE (
<? if not exists("byItem") ?>
             (item_sold)
         AND (item_active)
<? else ?>
             (item_id=<? value("item_id") ?>)
<? endif ?>
         AND (NOT item_exclusive)
<? if exists("byCustomer") ?>
         AND (cust_id=<? value("cust_id") ?>)
         <? if exists("item_id") ?>
         AND (item_id=<? value("item_id") ?>)
         <? endif ?>
<? endif ?>
            )
     ) AS data
ORDER BY
<? if not exists("byItem") ?>
         itemnumber,
<? endif ?>
         price;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (238, 'countTag', 'detail', 'used by dspCountTagEditList Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: countTag
-- Name: detail
-- Notes: used by dspCountTagEditList
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT *,
       CASE WHEN (xtindentrole = 1) THEN NULL
     <? if exists("varianceValue") ?>
            WHEN (ABS(variancecost) >  <? value("varianceValue") ?>) THEN ''error''
     <? elseif exists("variancePercent") ?>
            WHEN (ABS(varianceprcnt * 100.0) >  <? value("variancePercent") ?>) THEN ''error''
     <? else ?>
            ELSE NULL
     <? endif ?>
       END AS qtforegroundrole,
       CASE WHEN (xtindentrole = 1) THEN NULL
            WHEN (qohafter IS NOT NULL) THEN ''emphasis''
       END AS qohafter_qtforegroundrole,
       CASE WHEN (xtindentrole = 0) THEN NULL ELSE '''' END AS invcnt_priority_qtdisplayrole,
       ''qty'' AS qoh_xtnumericrole,
       ''qty'' AS qohafter_xtnumericrole,
       ''qty'' AS variance_xtnumericrole,
       ''percent'' AS varianceprcnt_xtnumericrole,
       ''curr'' AS variancecost_xtnumericrole
FROM (
      SELECT invcnt_id, -1 AS cntslip_id, invcnt_priority,
             COALESCE(invcnt_tagnumber, ''Misc.'') AS tagnumber,
             invcnt_tagdate AS tagdate,
             item_number, (item_descrip1 || item_descrip2) AS item_descrip, warehous_code,
	     CASE WHEN (location_id IS NOT NULL) THEN
               location_name
               ELSE <? value("all") ?> END AS loc_specific,
             CASE WHEN (invcnt_location_id IS NOT NULL)
               THEN (SELECT SUM(itemloc_qty)
                     FROM itemloc JOIN location ON (location_id=itemloc_location_id)
                     WHERE ((itemloc_itemsite_id=itemsite_id)
                       AND  (itemloc_location_id=invcnt_location_id)
                       AND  (location_netable)))
               ELSE itemsite_qtyonhand
             END AS qoh,
             CASE WHEN (invcnt_location_id IS NOT NULL)
               THEN (SELECT SUM(itemloc_qty)
                     FROM itemloc JOIN location ON (location_id=itemloc_location_id)
                     WHERE ((itemloc_itemsite_id=itemsite_id)
                       AND  (itemloc_location_id=invcnt_location_id)
                       AND  (NOT location_netable)))
               ELSE itemsite_nnqoh
             END AS nnqoh,
      <? if exists("showSlips") ?>
             calcTotalSlipQty(invcnt_id) AS qohafter,
             (calcTotalSlipQty(invcnt_id) - (itemsite_qtyonhand + itemsite_nnqoh)) AS variance,
             CASE WHEN (calcTotalSlipQty(invcnt_id) IS NULL) THEN NULL
                  WHEN (((itemsite_qtyonhand + itemsite_nnqoh) = 0) AND (calcTotalSlipQty(invcnt_id) > 0)) THEN 1
                  WHEN (((itemsite_qtyonhand + itemsite_nnqoh) = 0) AND (calcTotalSlipQty(invcnt_id) < 0)) THEN -1
                  WHEN (((itemsite_qtyonhand + itemsite_nnqoh) = 0) AND (calcTotalSlipQty(invcnt_id) = 0)) THEN 0
               ELSE ((1 - (calcTotalSlipQty(invcnt_id) / (itemsite_qtyonhand + itemsite_nnqoh))) * -1)
             END AS varianceprcnt,
             (itemCost(itemsite_id) * (calcTotalSlipQty(invcnt_id) - (itemsite_qtyonhand + itemsite_nnqoh))) AS variancecost,
      <? else ?>
             COALESCE(invcnt_qoh_after, 0.0) AS qohafter,
             (invcnt_qoh_after - (itemsite_qtyonhand + itemsite_nnqoh)) AS variance,
             CASE WHEN (invcnt_qoh_after IS NULL) THEN NULL
                  WHEN (((itemsite_qtyonhand + itemsite_nnqoh) = 0) AND (invcnt_qoh_after > 0)) THEN 1
                  WHEN (((itemsite_qtyonhand + itemsite_nnqoh) = 0) AND (invcnt_qoh_after < 0)) THEN -1
                  WHEN (((itemsite_qtyonhand + itemsite_nnqoh) = 0) AND (invcnt_qoh_after = 0)) THEN 0
               ELSE ((1 - (invcnt_qoh_after / (itemsite_qtyonhand + itemsite_nnqoh))) * -1)
             END AS varianceprcnt,
             (itemCost(itemsite_id) * (invcnt_qoh_after - (itemsite_qtyonhand + itemsite_nnqoh))) AS variancecost,
      <? endif ?>
             item_number AS orderby,
             0 AS xtindentrole
      FROM invcnt LEFT OUTER JOIN location ON (invcnt_location_id=location_id),
     item, whsinfo, itemsite
      WHERE ((invcnt_itemsite_id=itemsite_id)
         AND (itemsite_item_id=item_id)
         AND (itemsite_warehous_id=warehous_id)
         AND (NOT invcnt_posted)
      <? if exists("warehous_id") ?>
         AND (itemsite_warehous_id=<? value("warehous_id") ?>)
      <? endif ?>
      <? if exists("classcode_id") ?>
         AND (item_classcode_id=<? value("classcode_id") ?>)
      <? elseif exists("classcode_pattern") ?>
         AND (item_classcode_id IN (SELECT classcode_id FROM classcode WHERE (classcode_code ~ <? value("classcode_pattern") ?>)))
      <? elseif exists("plancode_id") ?>
         AND (itemsite_plancode_id=<? value("plancode_id") ?>)
      <? elseif exists("plancode_pattern") ?>
         AND (itemsite_plancode_id IN (SELECT plancode_id FROM plancode WHERE (plancode_code ~ <? value("plancode_pattern") ?>)))
      <? endif ?>
      <? if exists("showSlips") ?>
            )
      UNION
      SELECT invcnt_id, cntslip_id, invcnt_priority,
             cntslip_number AS tagnumber,
             cntslip_entered AS tagdate,
             CASE WHEN (cntslip_posted) THEN <? value("posted") ?>
               ELSE <? value("unposted") ?>
             END AS item_number,
             '''' AS item_descrip,
             '''' AS warehous_code,
             '''' AS loc_specific,
             NULL AS qoh,
             NULL AS nnqoh,
             cntslip_qty AS qohafter,
             NULL AS variance, NULL AS varianceprcnt, 0 AS variancecost,
             item_number AS orderby,
             1 AS xtindentrole
      FROM cntslip, invcnt, itemsite, item
      WHERE ((cntslip_cnttag_id=invcnt_id)
         AND (invcnt_itemsite_id=itemsite_id)
         AND (itemsite_item_id=item_id)
         AND (NOT invcnt_posted)
       <? if exists("warehous_id") ?>
         AND (itemsite_warehous_id=<? value("warehous_id") ?>)
       <? endif ?>
       <? if exists("classcode_id") ?>
         AND (item_classcode_id=<? value("classcode_id") ?>)
       <? elseif exists("classcode_pattern") ?>
         AND (item_classcode_id IN (SELECT classcode_id FROM classcode WHERE (classcode_code ~ <? value("classcode_pattern") ?>)))
       <? elseif exists("plancode_id") ?>
         AND (itemsite_plancode_id=<? value("plancode_id") ?>)
       <? elseif exists("plancode_pattern") ?>
         AND (itemsite_plancode_id IN (SELECT plancode_id FROM plancode WHERE (plancode_code ~ <? value("plancode_pattern") ?>)))
       <? endif ?>
       <? endif ?>
            )
) AS dummy
ORDER BY invcnt_priority DESC, orderby, invcnt_id, cntslip_id;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (233, 'bom', 'detail', 'used by dspIndentedBOM, dspSingleLevelBOM, dspSummarizedBOM Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: bom
-- Name: detail
-- Notes: used by dspIndentedBOM, dspSingleLevelBOM, dspSummarizedBOM
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT <? if exists("bySingleLvl") ?>
         bomitem_item_id AS itemid, bomitem.*, item_number,
         invuom.uom_name AS invuomname, issueuom.uom_name AS issueuomname,
         (item_descrip1 || '' '' || item_descrip2) AS itemdescription,
         (itemuomtouomratio(bomitem_item_id, bomitem_uom_id, NULL) * bomitem_qtyfxd) AS invqtyfxd,
         (itemuomtouomratio(bomitem_item_id, bomitem_uom_id, NULL) * bomitem_qtyper) AS invqtyper,
         ''qty'' AS bomitem_qtyfxd_xtnumericrole,
         ''qty'' AS invqtyfxd_xtnumericrole,
         ''qtyper'' AS bomitem_qtyper_xtnumericrole,
         ''qtyper'' AS invqtyper_xtnumericrole,
         ''percent'' AS bomitem_scrap_xtnumericrole,
         CASE WHEN COALESCE(bomitem_effective, startOfTime()) = startOfTime() 
           THEN <? value("always") ?>
         END AS bomitem_effective_qtdisplayrole,
         CASE WHEN COALESCE(bomitem_expires, endOfTime()) = endOfTime() 
           THEN <? value("never") ?>
         END AS bomitem_expires_qtdisplayrole,
         CASE WHEN (bomitem_expires < CURRENT_DATE) THEN ''expired''
              WHEN (bomitem_effective >= CURRENT_DATE) THEN ''future''
              WHEN (item_type=''M'') THEN ''altemphasis''
         END AS qtforegroundrole
       <? else ?>
         <? if exists("bySummarized") ?>
           item_id AS itemid,
         <? else ?>
           bomdata_item_id AS itemid,
         <? endif ?>
         *,''percent'' AS bomdata_scrap_xtnumericrole,
         ''qtyper'' AS bomdata_qtyreq_xtnumericrole,
         CASE WHEN COALESCE(bomdata_effective, startOfTime()) <=
                   startOfTime() THEN <? value("always") ?>
         END AS bomdata_effective_qtdisplayrole,
         CASE WHEN COALESCE(bomdata_expires, endOfTime()) >=
                   endOfTime() THEN <? value("never") ?>
         END AS bomdata_expires_qtdisplayrole,
         CASE WHEN (bomdata_expired) THEN ''expired''
              WHEN (bomdata_future) THEN ''future''
         END AS qtforegroundrole
         <? if not exists("bySummarized") ?>
           , bomdata_bomwork_level - 1 AS xtindentrole
         <? endif ?>
       <? endif ?>
FROM <? if exists("bySingleLvl") ?>
       bomitem(<? value("item_id") ?>,<? value("revision_id") ?>),
       item, uom AS issueuom, uom AS invuom
     <? elseif exists("byIndented") ?>
       indentedBOM(<? value("item_id") ?>,
                   <? value("revision_id") ?>,
                   <? value("expiredDays") ?>,
                   <? value("futureDays") ?>)
     <? elseif exists("bySummarized") ?>
       summarizedBOM(<? value("item_id") ?>,
                     <? value("revision_id") ?>,
                     <? value("expiredDays") ?>,
                     <? value("futureDays") ?>)
       JOIN item ON (bomdata_item_number=item_number)
     <? endif ?>
WHERE ((TRUE)
<? if exists("byIndented") ?>
   AND (bomdata_item_id > 0)
<? elseif exists("bySingleLvl") ?>
   AND (bomitem_item_id=item_id)
   AND (item_inv_uom_id=invuom.uom_id)
   AND (bomitem_uom_id=issueuom.uom_id)
  <? if exists("expiredDays") ?>
   AND (bomitem_expires > (CURRENT_DATE - <? value("expiredDays") ?>))
  <? else ?>
   AND (bomitem_expires > CURRENT_DATE)
  <? endif ?>
  <? if exists("effectiveDays") ?>
   AND (bomitem_effective <= (CURRENT_DATE + <? value("effectiveDays") ?>))
  <? else ?>
   AND (bomitem_effective <= CURRENT_DATE)
  <? endif ?>
<? endif ?>
      )
<? if exists("bySingleLvl") ?>
 ORDER BY bomitem_seqnumber, bomitem_effective
<? endif ?>
;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (234, 'briefEarnedCommission', 'detail', 'used by dspBriefEarnedCommissions Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: briefEarnedCommission
-- Name: detail
-- Notes: used by dspBriefEarnedCommissions
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT cohist_salesrep_id, salesrep_number, salesrep_name, cust_number, cust_name,
       cohist_ordernumber, cohist_invcnumber, cohist_invcdate, currAbbr,
       SUM(extprice) AS sumextprice,
       SUM(cohist_commission) AS sumcommission,
       SUM(baseextprice) AS sumbaseextprice,
       SUM(basecommission) AS sumbasecommission,
       ''curr'' AS sumextprice_xtnumericrole,
       ''curr'' AS sumcommission_xtnumericrole,
       ''curr'' AS sumbaseextprice_xtnumericrole,
       ''curr'' AS sumbasecommission_xtnumericrole,
       0 AS sumbaseextprice_xttotalrole,
       0 AS sumbasecommission_xttotalrole
<? if exists("includeMisc") ?>
FROM saleshistorymisc
<? else ?>
FROM saleshistory
<? endif ?>
WHERE ((cohist_commission <> 0)
    AND(cohist_invcdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
    <? if exists("includeMisc") ?>
    AND (COALESCE(cohist_misc_type, '''') <> ''T'')
    AND (COALESCE(cohist_misc_type, '''') <> ''F'')
    <? endif ?>
    <? if exists("salesrep_id") ?>
    AND (cohist_salesrep_id=<? value("salesrep_id") ?>)
    <? endif ?>
      )
GROUP BY cohist_salesrep_id, salesrep_number, salesrep_name, cust_number, cust_name,
         cohist_ordernumber, cohist_invcnumber, cohist_invcdate, currAbbr
ORDER BY salesrep_number, cust_number, cohist_invcdate;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (280, 'reorderExceptionsByPlannerCode', 'detail', 'used by dspReorderExceptionsByPlannerCode Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: reorderExceptionsByPlannerCode
-- Name: detail
-- Notes: used by dspReorderExceptionsByPlannerCode
--        Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
--        See www.xtuple.com/CPAL for the full text of the software license.

SELECT itemsite_id, itemtype, warehous_code, item_number,
       (item_descrip1 || '' '' || item_descrip2) AS itemdescrip,
       reorderdate, reorderlevel,
       (itemsite_qtyonhand - qtyAllocated(itemsite_id, reorderdate) +
         qtyOrdered(itemsite_id, reorderdate)) AS projavail,
       ''qty'' AS reorderlevel_xtnumericrole,
       ''qty'' AS projavail_xtnumericrole
FROM (SELECT itemsite_id,
             CASE WHEN (item_type IN (''M'', ''B'', ''T'')) THEN 1
                  WHEN (item_type IN (''P'', ''O'')) THEN 2
               ELSE 3
             END AS itemtype,
             warehous_code, item_number, item_descrip1,
             item_descrip2,
             reorderDate(itemsite_id,
                         <? value("lookAheadDays") ?>,
                         <? value("includePlannedOrders") ?>)
             AS reorderdate,
             itemsite_qtyonhand, reorderlevel
      FROM (SELECT itemsite_id, itemsite_item_id,
                   itemsite_warehous_id, itemsite_qtyonhand,
                   CASE WHEN(itemsite_useparams) THEN itemsite_reorderlevel
                     ELSE 0.0
                   END AS reorderlevel
            FROM itemsite
            WHERE ((true)
            <? if exists("warehous_id") ?>
               AND (itemsite_warehous_id=<? value("warehous_id") ?>)
            <? endif ?>
            <? if exists("plancode_id") ?>
               AND (itemsite_plancode_id=<? value("plancode_id") ?>)
            <? elseif exists("plancode_pattern") ?>
               AND (itemsite_plancode_id IN (SELECT plancode_id
                                             FROM plancode
                                             WHERE (plancode_code ~ <? value("plancode_pattern") ?>)))
            <? endif ?>
                  )
           ) AS itemsitedata, item, whsinfo
      WHERE ((itemsite_item_id=item_id)
         AND (itemsite_warehous_id=warehous_id))
     ) AS data
WHERE (reorderdate IS NOT NULL)
ORDER BY reorderdate, item_number;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (433, 'salesOrderItems', 'list', 'used by salesOrder Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: salesOrderItems
-- Name: list
-- Notes: used by salesOrder
--        Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
--        See www.xtuple.com/CPAL for the full text of the software license.

SELECT coitem_id, coitem_altid, groupby,
       coitem_linenumber, coitem_subnumber, f_linenumber,
       warehous_code, item_number, item_type, description,
       item_number_cust, item_descrip1_cust, item_descrip2_cust, item_barcode,
       prodweight, packweight,
       enhanced_status, coitem_firm,
       qty_uom, price_uom, ship_uom,
       coitem_memo,
-- always create formatted columns for scheduled reports
       formatDate(coitem_scheddate) AS f_scheddate,
       formatSalesPrice(coitem_price) AS f_price,
       formatSalesPrice(coitem_custprice) AS f_custprice,
       formatPrcnt(discountfromcust / 100) AS f_discountfromcust,
       formatQty(coitem_qtyord) AS f_qtyord, 
       CASE WHEN (qtyshipped > 0.0) THEN formatQty(qtyshipped) ELSE NULL END AS f_qtyshipped,
       CASE WHEN (qtyshipped > 0.0) THEN formatQty(balance) ELSE NULL END AS f_balance,
       CASE WHEN (qtyatshipping > 0.0) THEN formatQty(qtyatshipping) ELSE NULL END AS f_qtyatshipping,
       formatMoney(extprice) AS f_extprice,
       CASE WHEN (extprice_shipped > 0.0) THEN formatMoney(extprice_shipped) ELSE NULL END AS f_extprice_shipped,
-- end formatted columns
       coitem_scheddate, coitem_price, coitem_custprice, discountfromcust,
       coitem_unitcost, margin, marginpercent,
       coitem_qtyord, qtyshipped, balance, qtyatshipping,
       extprice, extprice_shipped,
       CASE WHEN (discountfromcust=100.0) THEN ''N/A'' END AS discountfromcust_qtdisplayrole,
       ''qty'' AS coitem_qtyord_xtnumericrole,
       ''qty'' AS qtyshipped_xtnumericrole,
       ''qty'' AS balance_xtnumericrole,
       ''qty'' AS qtyatshipping_xtnumericrole,
       ''qty'' AS prodweight_xtnumericrole,
       ''qty'' AS packweight_xtnumericrole,
       ''salesprice'' AS coitem_price_xtnumericrole,
       ''salesprice'' AS coitem_custprice_xtnumericrole,
       ''cost'' AS coitem_unitcost_xtnumericrole,
       ''curr'' AS extprice_xtnumericrole,
       ''curr'' AS extprice_shipped_xtnumericrole,
       ''curr'' AS margin_xtnumericrole,
       ''percent'' AS marginpercent_xtnumericrole,
       CASE WHEN fetchMetricBool(''EnableSOShipping'') AND
                 coitem_scheddate > CURRENT_DATE AND
                 (noNeg(coitem_qtyord) <> qtyAtShipping(''SO'', coitem_id)) THEN ''future''
            WHEN fetchMetricBool(''EnableSOShipping'') AND
                 (noNeg(coitem_qtyord) <> qtyAtShipping(''SO'', coitem_id)) THEN ''expired''
            WHEN (coitem_status NOT IN (''C'', ''X'') AND
                  EXISTS(SELECT coitem_id
                         FROM coitem
                         WHERE ((coitem_status=''C'')
                           AND  (coitem_cohead_id=<? value("cohead_id") ?>)))) THEN ''error''
       END AS coitem_scheddate_qtforegroundrole,
       CASE WHEN coitem_subnumber = 0 THEN 0
            ELSE 1
       END AS xtindentrole,
       spplytype, ordrnumbr,
       itemsite_qtyonhand,
       ''qty'' AS itemsite_qtyonhand_xtnumericrole
<? if exists("includeReservations") ?>
       ,
       reserved,
       reservable,
       ''qty'' AS reserved_xtnumericrole,
       ''qty'' AS reservable_xtnumericrole
<? endif?>
FROM (
SELECT coitem_id,
       CASE WHEN (coitem_status=''C'') THEN 1
            WHEN (coitem_status=''X'') THEN 4
            WHEN ( (coitem_status=''O'') AND ( (qtyAtShipping(''SO'', coitem_id) > 0) OR (coitem_qtyshipped > 0) ) ) THEN 2
            ELSE 3
       END AS coitem_altid, 1 AS groupby,
       coitem_linenumber, coitem_subnumber, formatSoLineNumber(coitem_id) AS f_linenumber,
       warehous_code, item_number, item_type,
       (item_descrip1 || '' '' || item_descrip2) AS description,
       CASE WHEN (coitem_custpn != '''') THEN coitem_custpn
            ELSE item_number
       END AS item_number_cust,
       CASE WHEN (coitem_custpn != '''' AND itemalias_usedescrip=TRUE) THEN itemalias_descrip1
            ELSE item_descrip1
       END AS item_descrip1_cust,
       CASE WHEN (coitem_custpn != '''' AND itemalias_usedescrip=TRUE) THEN itemalias_descrip2
            ELSE item_descrip2
       END AS item_descrip2_cust,
       formatitemsitebarcode(itemsite_id) AS item_barcode,
       (coitem_qtyord / coitem_qty_invuomratio * item_prodweight) AS prodweight,
       (coitem_qtyord / coitem_qty_invuomratio * item_packweight) AS packweight,
       coitem_status, coitem_firm,
       getSoitemStatus(coitem_id) AS enhanced_status,
       quom.uom_name AS qty_uom, puom.uom_name AS price_uom,
       itemSellingUOM(item_id) AS ship_uom,
       coitem_memo,
       coitem_scheddate, coitem_price, coitem_custprice, coitem_qtyord,
       CASE WHEN (coitem_custprice = 0.0) THEN 100.0
            ELSE ((1.0 - (coitem_price / coitem_custprice)) * 100.0)
       END AS discountfromcust,
       coitem_unitcost,
       ROUND((coitem_qtyord * coitem_qty_invuomratio) *
             ((coitem_price / coitem_price_invuomratio) - coitem_unitcost),2) AS margin,
       CASE WHEN (coitem_price = 0.0) THEN 100.0
            ELSE ((coitem_price - coitem_unitcost) / coitem_price)
       END AS marginpercent,
       noNeg(coitem_qtyshipped - coitem_qtyreturned) AS qtyshipped,
       noNeg(coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned) AS balance,
       qtyAtShipping(''SO'', coitem_id) AS qtyatshipping,
       ROUND((coitem_qtyord * coitem_qty_invuomratio) *
             (coitem_price / coitem_price_invuomratio),2) AS extprice,
       ROUND(((coitem_qtyshipped - coitem_qtyreturned) * coitem_qty_invuomratio) *
              (coitem_price / coitem_price_invuomratio),2) AS extprice_shipped,
       CASE WHEN coitem_order_type=''W'' THEN TEXT( ''WO'')
            WHEN coitem_order_type=''P'' THEN TEXT(''PO'' )
            WHEN coitem_order_type=''R'' THEN TEXT(''PR'')
            ELSE TEXT ('' '')
       END AS spplytype,
       CASE WHEN coitem_order_type=''W'' THEN (wo_number || ''-'' || wo_subnumber)
            WHEN coitem_order_type=''P'' THEN (pohead_number || ''-'' || poitem_linenumber)
            WHEN coitem_order_type=''R'' THEN (pr_number || ''-'' || pr_subnumber)
            ELSE TEXT ('' '')
       END AS ordrnumbr,
       itemsite_qtyonhand
<? if exists("includeReservations") ?>
       ,
       coitem_qtyreserved AS reserved,
       itemsite_qtyonhand - qtyreserved(itemsite_id) AS reservable
<? endif?>
  FROM cohead
       JOIN coitem ON (coitem_cohead_id=cohead_id)
       JOIN itemsite ON (itemsite_id=coitem_itemsite_id)
       JOIN item ON (item_id=itemsite_item_id)
       JOIN whsinfo ON (warehous_id=itemsite_warehous_id)
       JOIN uom AS quom ON (quom.uom_id=coitem_qty_uom_id)
       JOIN uom AS puom ON (puom.uom_id=coitem_price_uom_id)
       LEFT OUTER JOIN itemalias ON ((itemalias_item_id=item_id) AND (itemalias_number=coitem_custpn))
       LEFT OUTER JOIN wo ON (coitem_order_id = wo_id)
       LEFT OUTER JOIN pr ON (coitem_order_id = pr_id)
       LEFT OUTER JOIN (pohead JOIN poitem ON (pohead_id = poitem_pohead_id))
         ON (coitem_order_id = poitem_id)
 WHERE (cohead_id=<? value("sohead_id") ?>)

<? if exists("excludeCancelled") ?>
 AND (coitem_status != ''X'')
<? endif?>

<? if exists("excludeClosed") ?>
 AND (coitem_status != ''C'')
<? endif?>

<? if exists("excludeKits") ?>
 AND (item_type != ''K'')
<? endif?>

) AS data
ORDER BY coitem_linenumber, coitem_subnumber;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (436, 'countTags', 'create', 'used by createCountTagsByParameterList Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: countTags
-- Name: create
-- Notes: used by createCountTagsByParameterList
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT createCountTag(itemsite_id, <? value("comments") ?>, <? value("priority") ?>, <? value("freeze") ?>, <? value("location_id") ?>)
FROM ( SELECT itemsite_id
       FROM itemsite JOIN item ON (item_id=itemsite_item_id)
<? if exists("location_id") ?>
                     JOIN itemloc ON ( (itemloc_location_id=<? value("location_id") ?>)
                                   AND (itemloc_itemsite_id = itemsite_id)
                                   AND (validLocation(<? value("location_id") ?>, itemsite_id)) )
<? endif ?>
       WHERE (itemsite_active)
         AND (item_active)
<? if exists("warehous_id") ?>
         AND (itemsite_warehous_id=<? value("warehous_id") ?>)
<? endif ?>
<? if exists("classcode_id") ?>
         AND (item_classcode_id=<? value("classcode_id") ?>)
<? elseif exists("classcode_pattern") ?>
         AND (item_classcode_id IN (SELECT classcode_id
                                    FROM classcode
                                    WHERE (classcode_code ~ <? value("classcode_pattern") ?>)))
<? endif ?>
<? if exists("plancode_id") ?>
  AND (itemsite_plancode_id=<? value("plancode_id") ?>)
<? elseif exists("plancode_pattern") ?>
  AND (itemsite_plancode_id IN (SELECT plancode_id
                                FROM plancode
                                WHERE (plancode_code ~ <? value("plancode_pattern") ?>)))
<? endif ?>
<? if exists("ignoreZeroBalance") ?>
         AND (itemsite_qtyonhand <> 0.0)
<? endif ?>
       ORDER BY item_number ) AS data;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (235, 'briefSalesHistory', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: briefSalesHistory
-- Name: detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT
       COALESCE(cohead_id,-1) AS cohead_id, cust_id, cohist_ponumber,
       cust_custtype_id, custtype_code,
       cohist_cust_id, SUM(extcost) AS extcost,
       ''curr'' AS extcost_xtnumericrole,
       0 AS extcost_xttotalrole,
       cohist_ordernumber,
       cust_number, cust_name, invoicenumber,
       cohist_orderdate, cohist_invcdate,
       SUM(baseextprice) AS extended,
       ''curr'' AS extended_xtnumericrole,
       0 AS extended_xttotalrole
FROM saleshistory
  LEFT OUTER JOIN cohead ON (cohead_number=cohist_ordernumber)
WHERE ((cohist_invcdate BETWEEN <? value("startDate") ?> AND  <? value("endDate") ?>)
<? if exists("cust_id") ?>
   AND (cohist_cust_id=<? value("cust_id") ?>)
<? endif ?>
<? if exists("shipto_id") ?>
   AND (cohist_shipto_id=<? value("shipto_id") ?>)
<? endif ?>
<? if exists("custtype_id") ?>
   AND (cust_custtype_id=<? value("custtype_id") ?>)
<? endif ?>
<? if exists("custtype_pattern") ?>
   AND (custtype_code ~ <? value("custtype_pattern") ?>)
<? endif ?>
<? if exists("custgrp_id") ?>
  AND (cust_id IN (SELECT DISTINCT custgrpitem_cust_id
                   FROM custgrpitem
                   WHERE (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)))
<? endif ?>
<? if exists("custgrp_pattern") ?>
  AND (cust_id IN (SELECT DISTINCT custgrpitem_cust_id
                   FROM custgrp, custgrpitem
                   WHERE ( (custgrpitem_custgrp_id=custgrp_id)
                     AND   (custgrp_name ~ <? value("custgrp_pattern") ?>) )) )
<? endif ?>
<? if exists("warehous_id") ?>
   AND (itemsite_warehous_id=<? value("warehous_id") ?>)
<? endif ?>
<? if exists("item_id") ?>
  AND  (itemsite_item_id=<? value("item_id") ?>)
<? endif ?>
<? if exists("prodcat_id") ?>
   AND (item_prodcat_id=<? value("prodcat_id") ?>)
<? endif ?>
<? if exists("prodcat_pattern") ?>
   AND (item_prodcat_id IN (SELECT prodcat_id
                            FROM prodcat
                            WHERE (prodcat_code ~ <? value("prodcat_pattern") ?>)))
<? endif ?>
<? if exists("salesrep_id") ?>
   AND (cohist_salesrep_id=<? value("salesrep_id") ?>)
<? endif ?>
      )
GROUP BY cohead_id, cust_id,cust_number,cust_custtype_id,cohist_cust_id,custtype_code,
         cust_name,cohist_ordernumber, cohist_ponumber,
         invoicenumber,cohist_orderdate, cohist_invcdate
ORDER BY cohist_invcdate, cohist_orderdate;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (478, 'saletype', 'table', 'maintain saletype table Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: saletype
-- Name: table
-- Notes: maintain saletype table
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

<? if exists("ViewMode") ?>
  SELECT *
    FROM saletype
   WHERE true
  <? if exists("saletype_id") ?>
    AND (saletype_id=<? value("saletype_id") ?>) 
  <? endif ?>
  <? if exists("saletype_code") ?>
    AND (UPPER(saletype_code)=UPPER(<? value("saletype_code") ?>)) 
  <? endif ?>
  ORDER BY saletype_code;

<? elseif exists("NewMode") ?>
  INSERT INTO saletype
    ( saletype_code,
      saletype_descr,
      saletype_active )
  VALUES
    ( UPPER(<? value("saletype_code") ?>),
      <? value("saletype_descr") ?>,
      <? value("saletype_active") ?> )
  RETURNING saletype_id;

<? elseif exists("EditMode") ?>
  UPDATE saletype
    SET saletype_code=UPPER(<? value("saletype_code") ?>),
        saletype_descr=<? value("saletype_descr") ?>,
        saletype_active=<? value("saletype_active") ?>
  WHERE (saletype_id=<? value("saletype_id") ?>);

<? elseif exists("DeleteMode") ?>
  DELETE FROM saletype WHERE saletype_id=<? value("saletype_id") ?>;

<? elseif exists("DeleteUnusedMode") ?>
  SELECT deleteUnusedSaleTypes() AS result;

<? else ?>
  RAISE EXCEPTION ''saletype invalid mode'';
<? endif ?>
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (450, 'contact', 'muststayactive', 'This query determines whether a given contact should be kept active because other active records depend on it. Todo - should this be moved to the cntctAfterTrigger? Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: contact
-- Name:  muststayactive
-- Notes: This query determines whether a given contact should be kept
--        active because other active records depend on it.
--        Todo - should this be moved to the cntctAfterTrigger?
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT EXISTS(
 SELECT 1
   FROM crmacct
  WHERE(crmacct_active
    AND (<? value("id") ?> IN (crmacct_cntct_id_1, crmacct_cntct_id_2)))
 UNION SELECT 3
   FROM custinfo
  WHERE (cust_active
    AND (<? value("id") ?> IN (cust_cntct_id, cust_corrcntct_id)))
 UNION SELECT 5
   FROM vendinfo
  WHERE (vend_active
    AND (<? value("id") ?> IN (vend_cntct1_id, vend_cntct2_id)))
 UNION SELECT 7
   FROM prospect
  WHERE (prospect_active AND (prospect_cntct_id=<? value("id") ?>))
 UNION SELECT 8
   FROM shiptoinfo
  WHERE (shipto_active AND (shipto_cntct_id=<? value("id") ?>))
 UNION SELECT 9
   FROM vendaddrinfo
   JOIN vendinfo ON (vendaddr_vend_id=vend_id)
  WHERE (vend_active AND (vendaddr_cntct_id=<? value("id") ?>))
 UNION SELECT 10
   FROM whsinfo
  WHERE (warehous_active AND (warehous_cntct_id=<? value("id") ?>))
 UNION SELECT 11
   FROM emp
  WHERE (emp_active AND (emp_cntct_id=<? value("id") ?>))
 UNION SELECT 21
   FROM todoitem
  WHERE (todoitem_completed_date IS NOT NULL
    AND (todoitem_cntct_id=<? value("id") ?>))
) AS inuse;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (310, 'creditMemo', 'editlist', 'used by creditMemoEditList Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: creditMemo
-- Name: editlist
-- Notes: used by creditMemoEditList
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT *,
       (''C/M-'' || formatCreditMemoNumber(cmhead_id)) AS docnumber,
       currConcat(curr_id) AS currabbr,
       CASE WHEN seq != 0 THEN ''''
       END AS docnumber_qtdisplayrole,
       ''qty'' AS qtytobill_xtnumericrole,
       ''price'' AS price_xtnumericrole,
       ''curr'' AS extprice_xtnumericrole,
       CASE WHEN namedescrip = <? value("notassigned") ?> THEN ''error'' END AS qtforegroundrole
FROM (

SELECT cmhead_id, -1 AS altid,
       cmhead_number AS ordernumber,
       cust_number AS custitemnumber,
       cmhead_billtoname AS namedescrip,
       CAST(NULL AS TEXT) AS uom_name,
       CAST(NULL AS NUMERIC) AS qtytobill,
       CAST(NULL AS NUMERIC) AS price,
       CAST(NULL AS NUMERIC) AS extprice,
       cmhead_curr_id AS curr_id,
       0 AS cmitem_linenumber, 0 AS xtindentrole, 0 AS seq
FROM cmhead JOIN custinfo ON (cmhead_cust_id=cust_id)
WHERE ((NOT cmhead_posted)
  AND  (NOT cmhead_hold))

UNION
SELECT cmhead_id, cmitem_id,
       NULL, item_number,
       item_descrip1,
       uom_name, cmitem_qtycredit * cmitem_qty_invuomratio,
       cmitem_unitprice / cmitem_price_invuomratio,
       cmitem_qtycredit * cmitem_qty_invuomratio * cmitem_unitprice / cmitem_price_invuomratio,
       cmhead_curr_id AS curr_id,
       cmitem_linenumber, 1 AS xtindentrole, 1 AS seq
FROM cmhead, cmitem, itemsite, item, uom
WHERE ((NOT cmhead_posted)
  AND  (NOT cmhead_hold)
  AND  (cmhead_id=cmitem_cmhead_id)
  AND  (cmitem_itemsite_id=itemsite_id)
  AND  (itemsite_item_id=item_id)
  AND  (item_inv_uom_id=uom_id))

UNION
SELECT cmhead_id, -1,
       NULL, <? value("debit") ?>,
       COALESCE((SELECT formatGLAccountLong(accnt_id)
                 FROM accnt, salesaccnt
                 WHERE ((salesaccnt_sales_accnt_id=accnt_id)
                    AND (salesaccnt_id=findSalesAccnt(itemsite_id, ''IS'', cmhead_cust_id,
                                                      cmhead_saletype_id, cmhead_shipzone_id)))), <? value("notassigned") ?>),
       NULL, NULL, NULL,
       cmitem_qtycredit * cmitem_qty_invuomratio * cmitem_unitprice / cmitem_price_invuomratio,
       cmhead_curr_id AS curr_id,
       cmitem_linenumber, 2 AS xtindentrole, 2 AS seq
FROM cmhead, cmitem, itemsite, item, uom
WHERE ((NOT cmhead_posted)
  AND  (NOT cmhead_hold)
  AND  (cmhead_id=cmitem_cmhead_id)
  AND  (cmitem_itemsite_id=itemsite_id)
  AND  (itemsite_item_id=item_id)
  AND  (item_inv_uom_id=uom_id))

UNION
SELECT cmhead_id, -1,
       NULL, <? value("debit") ?>,
       CASE WHEN (accnt_id IS NULL) THEN <? value("notassigned") ?>
            ELSE formatGLAccountLong(accnt_id)
       END,
       NULL, NULL, cmhead_freight,
       cmhead_freight,
       cmhead_curr_id AS curr_id,
       99999, 1 AS xtindentrole, 3 AS seq
FROM cmhead LEFT OUTER JOIN accnt ON (accnt_id=findFreightAccount(cmhead_cust_id))
WHERE ((NOT cmhead_posted)
  AND  (NOT cmhead_hold)
  AND  (cmhead_freight <> 0))

UNION
SELECT cmhead_id, -1,
       NULL, <? value("debit") ?>,
       formatGLAccountLong(cmhead_misc_accnt_id),
       NULL, NULL, cmhead_misc,
       cmhead_misc,
       cmhead_curr_id AS curr_id,
       99999, 1 AS xtindentrole, 4 AS seq
FROM cmhead LEFT OUTER JOIN accnt ON (accnt_id=findFreightAccount(cmhead_cust_id))
WHERE ((NOT cmhead_posted)
  AND  (NOT cmhead_hold)
  AND  (cmhead_misc <> 0))

UNION
SELECT cmhead_id, -1,
       NULL, <? value("debit") ?>,
       CASE WHEN (tax_sales_accnt_id IS NULL) THEN <? value("taxes") ?>
            ELSE formatGLAccountLong(tax_sales_accnt_id)
       END,
       NULL, NULL, SUM(taxhist_tax * -1.0),
       SUM(taxhist_tax * -1.0),
       cmhead_curr_id AS curr_id,
       99999, 1 AS xtindentrole, 5 AS seq
FROM cmhead JOIN cmheadtax ON ((taxhist_parent_id=cmhead_id) AND (taxhist_tax <> 0.0))
            JOIN tax ON (tax_id=taxhist_tax_id)
WHERE ((NOT cmhead_posted)
  AND  (NOT cmhead_hold))
GROUP BY cmhead_id, tax_sales_accnt_id, cmhead_curr_id

UNION
SELECT cmhead_id, -1,
       NULL, <? value("debit") ?>,
       CASE WHEN (tax_sales_accnt_id IS NULL) THEN <? value("taxes") ?>
            ELSE formatGLAccountLong(tax_sales_accnt_id)
       END,
       NULL, NULL, SUM(taxhist_tax * -1.0),
       SUM(taxhist_tax * -1.0),
       cmhead_curr_id AS curr_id,
       99999, 1 AS xtindentrole, 5 AS seq
FROM cmhead JOIN cmitem ON (cmitem_cmhead_id=cmhead_id)
            JOIN cmitemtax ON ((taxhist_parent_id=cmitem_id) AND (taxhist_tax <> 0.0))
            JOIN tax ON (tax_id=taxhist_tax_id)
WHERE ((NOT cmhead_posted)
  AND  (NOT cmhead_hold))
GROUP BY cmhead_id, tax_sales_accnt_id, cmhead_curr_id

UNION
SELECT cmhead_id, -1,
       NULL, <? value("credit") ?>,
       CASE WHEN (accnt_id IS NULL) THEN <? value("notassigned") ?>
            ELSE formatGLAccountLong(accnt_id)
       END,
       NULL, NULL, NULL,
       SUM((cmitem_qtycredit * cmitem_qty_invuomratio) *
           (cmitem_unitprice / cmitem_price_invuomratio)) +
           cmhead_freight + cmhead_misc +
           (SELECT COALESCE(SUM(taxhist_tax * -1.0), 0.0) FROM cmheadtax WHERE (taxhist_parent_id=cmhead_id)) +
           (SELECT COALESCE(SUM(taxhist_tax * -1.0), 0.0) FROM cmitem JOIN cmitemtax ON (taxhist_parent_id=cmitem_id)
                                    WHERE (cmitem_cmhead_id=cmhead_id))
            AS extprice,
       cmhead_curr_id AS curr_id,
       99999, 1 AS xtindentrole, 6 AS seq
FROM cmhead LEFT OUTER JOIN cmitem ON (cmhead_id=cmitem_cmhead_id)
            LEFT OUTER JOIN accnt ON (accnt_id=findARAccount(cmhead_cust_id))
WHERE ((NOT cmhead_posted)
  AND  (NOT cmhead_hold))
GROUP BY cmhead_id, cmhead_cust_id, cmhead_freight, cmhead_misc, accnt_id, cmhead_curr_id

) AS dummy
ORDER BY docnumber, cmitem_linenumber, seq;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (40, 'arOpenApplications', 'detail', 'used by applyARCreditMemo, cashReceipt Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: arOpenApplications
-- Name: detail
-- Notes: used by applyARCreditMemo, cashReceipt
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT *,
       ''curr'' AS balance_xtnumericrole,
       ''curr'' AS applied_xtnumericrole,
       ''curr'' AS pending_xtnumericrole,
       currConcat(balance_curr) AS balance_curr_qtdisplayrole,
       CASE WHEN (doctype=''D'') THEN <? value("debitMemo") ?>
            WHEN (doctype=''I'') THEN <? value("invoice") ?>
            WHEN (doctype=''C'') THEN <? value("creditMemo") ?>
            WHEN (doctype=''R'') THEN <? value("cashdeposit") ?>
       END AS doctype_qtdisplayrole,
       CASE WHEN (doctype=''C'') THEN ''emphasis''
            WHEN (doctype=''R'') THEN ''altemphasis''
       END AS doctype_qtforegroundrole,
<? if exists("cashrcpt_id") ?>
    CASE WHEN (pending - currtobase(cashrcpt_curr_id, applied, cashrcpt_distdate) - discount > balance) 
    AND doctype IN (''I'',''D'')
    AND NOT cashrcpt_posted
<? else ?>
    CASE WHEN (pending - applied - discount > balance)
<? endif ?>  
       THEN ''error'' END AS qtforegroundrole
FROM (SELECT
      aropen_id,
<? if exists("cashrcpt_id") ?>
       COALESCE(s.cashrcptitem_id, -1) AS alt_id,
       COALESCE(cashrcpt_posted,FALSE) AS cashrcpt_posted,
       cashrcpt_curr_id,
       cashrcpt_distdate,
<? endif ?>
       aropen_doctype AS doctype,
       aropen_docnumber, aropen_ordernumber,
       aropen_docdate, aropen_duedate,
       (aropen_amount - aropen_paid - calcpendingarapplications(aropen_id)) *
       (CASE WHEN aropen_doctype IN (''C'',''R'') THEN -1 ELSE 1 END ) AS balance,
       aropen_curr_id AS balance_curr,
<? if exists("cashrcpt_id") ?>
       COALESCE(s.cashrcptitem_amount, 0.0) AS applied,
       COALESCE(s.cashrcptitem_discount, 0.0) AS discount,
--       (SELECT COALESCE(SUM(p.cashrcptitem_amount), 0)
--                      FROM cashrcptitem p
--                     WHERE (p.cashrcptitem_aropen_id=aropen_id)
--                     AND (p.cashrcptitem_cashrcpt_id=<? value("cashrcpt_id") ?>))
--                   AS applied,
--       (SELECT COALESCE(SUM(p.cashrcptitem_discount), 0)
--                      FROM cashrcptitem p
--                     WHERE (p.cashrcptitem_aropen_id=aropen_id)
--                     AND (p.cashrcptitem_cashrcpt_id=<? value("cashrcpt_id") ?>))
--                   AS discount,
       currConcat(cashrcpt_curr_id) AS applied_curr,
<? elseif exists("source_aropen_id") ?>
       COALESCE(arcreditapply_amount, 0) AS applied,
       0 AS discount,
       currConcat(arcreditapply_curr_id) AS applied_curr,
<? endif ?>
       calcpendingarapplications(aropen_id) AS pending,
       currConcat(aropen_curr_id) AS pending_curr
 FROM aropen LEFT OUTER JOIN
 <? if exists("cashrcpt_id") ?>
      cashrcptitem s ON (s.cashrcptitem_aropen_id=aropen_id
                     AND cashrcptitem_cashrcpt_id=<? value("cashrcpt_id") ?>)
        LEFT OUTER JOIN
      cashrcpt ON (cashrcptitem_cashrcpt_id = cashrcpt_id
               AND cashrcpt_id=<? value("cashrcpt_id") ?>)
<? elseif exists("source_aropen_id") ?>
      arcreditapply ON ((arcreditapply_source_aropen_id=<? value("source_aropen_id") ?>)
                    AND (arcreditapply_target_aropen_id=aropen_id) )
<? endif ?>
 WHERE (
<? if exists("posted") ?> 
   (s.cashrcptitem_aropen_id=aropen_id)
<? else ?>
   (aropen_open)
<? endif ?>
<? if exists("noCredits") ?>
   AND (aropen_doctype IN (''D'', ''I''))
<? elseif exists("cashrcpt_id") ?>
<? else ?>
   AND (aropen_doctype IN (''D'', ''I''))
<? endif ?>
   AND (aropen_cust_id=<? value("cust_id") ?>) )
 ) AS dummy
 ORDER BY aropen_duedate, balance;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (435, 'backlog', 'detail', ' Notes: Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: backlog
-- Name: detail
-- Notes:
-- Notes:
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT
       cohead_id, coitem_id, *, currconcat(cohead_curr_id) AS currAbbr,
       CASE WHEN xtindentrole = 0 THEN cohead_number
       END AS coitem_linenumber_qtdisplayrole,
       CASE WHEN xtindentrole = 0 THEN cust_name
       END AS item_number_qtdisplayrole,
       CASE WHEN (coitem_scheddate <= current_date AND qtybalance > 0) THEN ''error'' 
            WHEN (qtybalance > 0) THEN ''emphasis'' 
       END AS coitem_scheddate_qtforegroundrole,
       CASE WHEN (xtindentrole = 0) THEN ''''
       END AS qtybalance_qtdisplayrole,
       ''qty'' AS coitem_qtyord_xtnumericrole,
       ''qty'' AS coitem_qtyshipped_xtnumericrole,
       ''qty'' AS coitem_qtyreturned_xtnumericrole,
       ''qty'' AS qtyatshipping_xtnumericrole,
       ''qty'' AS qtybalance_xtnumericrole,
       ''qty'' AS qtyavailable_xtnumericrole,
       ''salesprice'' AS coitem_price_xtnumericrole,
       ''salesprice'' AS baseunitprice_xtnumericrole,
       ''curr'' AS extprice_xtnumericrole,
       ''curr'' AS baseextprice_xtnumericrole,
       ''curr'' AS extpricebalance_xtnumericrole,
       ''curr'' AS baseextpricebalance_xtnumericrole,
       0 AS coitem_qtyord_xttotalrole,
       0 AS coitem_qtyshipped_xttotalrole,
       0 AS coitem_qtyreturned_xttotalrole,
       0 AS qtybalance_xttotalrole,
       0 AS baseextprice_xttotalrole,
       0 AS baseextpricebalance_xttotalrole
FROM (
  SELECT
         0 AS xtindentrole,
         -- dummy coitem record
         -1            AS coitem_id,        NULL::INTEGER AS coitem_cohead_id,
         cohead_number::INTEGER AS coitem_linenumber,NULL::INTEGER AS coitem_itemsite_id,
         NULL::TEXT    AS coitem_status,    coitem_scheddate,
         getSoSchedDate(cohead_id) AS sort_scheddate,
         NULL::DATE    AS coitem_promdate,  NULL::NUMERIC AS coitem_qtyord,
         NULL::NUMERIC AS coitem_unitcost,  NULL::NUMERIC AS coitem_price,
         NULL::NUMERIC AS coitem_custprice, NULL::NUMERIC AS coitem_qtyshipped,
         NULL::INTEGER AS coitem_order_id,  NULL::TEXT    AS coitem_memo,
         NULL::BOOLEAN AS coitem_imported,  NULL::NUMERIC AS coitem_qtyreturned,
         NULL::TIMESTAMP AS coitem_closedate, NULL::BOOLEAN AS coitem_firm,
         NULL::TEXT    AS coitem_custpn,    NULL::TEXT    AS coitem_order_type,
         NULL::TEXT    AS coitem_close_username,
         NULL::TIMESTAMP AS coitem_lastupdated,
         NULL::INTEGER AS coitem_substitute_item_id,
         NULL::TIMESTAMP AS coitem_created, NULL::TEXT    AS coitem_creator,
         NULL::NUMERIC AS coitem_prcost,
         NULL::INTEGER AS coitem_qty_uom_id,
         NULL::NUMERIC AS coitem_qty_invuomratio,
         NULL::INTEGER AS coitem_price_uom_id,
         NULL::NUMERIC AS coitem_price_invuomratio,
         NULL::BOOLEAN AS coitem_warranty,
         NULL::INTEGER AS coitem_cos_accnt_id,
         NULL::NUMERIC AS coitem_qtyreserved,
         NULL::INTEGER AS coitem_subnumber,
         cohead.*,
         cust_number, cust_name,
         NULL::TEXT AS item_number, NULL::TEXT AS item_descrip1,
         NULL::TEXT AS itemdescription,
         NULL::TEXT AS uom_name,
         NULL::TEXT AS warehous_code,
         noNeg(coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned) AS qtybalance,
         NULL::NUMERIC AS baseunitprice,
         NULL::NUMERIC AS extprice,
         NULL::NUMERIC AS baseextprice,
         NULL::NUMERIC AS extpricebalance,
         NULL::NUMERIC AS baseextpricebalance

  FROM coitem JOIN cohead ON (cohead_id=coitem_cohead_id)
              JOIN custinfo ON (cust_id=cohead_cust_id)
              JOIN itemsite ON (itemsite_id=coitem_itemsite_id)
              JOIN site() ON (warehous_id=itemsite_warehous_id)
              JOIN item ON (item_id=itemsite_item_id)
              JOIN uom ON (uom_id=coitem_qty_uom_id)
<? foreach("char_id_text_list") ?>
     LEFT OUTER JOIN charass charass_alias<? literal("char_id_text_list") ?> 
          ON ((charass_alias<? literal("char_id_text_list") ?>.charass_target_type=''SO'') 
         AND  (charass_alias<? literal("char_id_text_list") ?>.charass_target_id=cohead_id)
         AND  (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=<? value("char_id_text_list") ?>))
     LEFT OUTER JOIN char char_alias<? literal("char_id_text_list") ?> 
          ON (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=char_alias<? literal("char_id_text_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_list_list") ?>
     LEFT OUTER JOIN charass charass_alias<? literal("char_id_list_list") ?> 
          ON ((charass_alias<? literal("char_id_list_list") ?>.charass_target_type=''SO'') 
         AND  (charass_alias<? literal("char_id_list_list") ?>.charass_target_id=cohead_id)
         AND  (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=<? value("char_id_list_list") ?>))
     LEFT OUTER JOIN char char_alias<? literal("char_id_list_list") ?> 
          ON (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=char_alias<? literal("char_id_list_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_date_list") ?>
     LEFT OUTER JOIN charass charass_alias<? literal("char_id_date_list") ?> 
          ON ((charass_alias<? literal("char_id_date_list") ?>.charass_target_type=''SO'') 
         AND  (charass_alias<? literal("char_id_date_list") ?>.charass_target_id=cohead_id)
         AND  (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=<? value("char_id_date_list") ?>))
     LEFT OUTER JOIN char char_alias<? literal("char_id_date_list") ?> 
          ON (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=char_alias<? literal("char_id_date_list") ?>.char_id)
<? endforeach ?>
  WHERE (coitem_id IN (SELECT coitem_id
                     FROM coitem
                    WHERE coitem_status = ''O''
                      AND coitem_cohead_id=cohead_id
                    ORDER BY coitem_scheddate ASC -- TODO: find a better way
                    LIMIT 1)
  <? if exists("cohead_id") ?>
    AND  (coitem_cohead_id=<? value("cohead_id") ?>)
  <? endif ?>
  <? if exists("startDate") ?>
    AND  (cohead_orderdate >= <? value("startDate") ?>)
  <? endif ?>
  <? if exists("endDate") ?>
    AND  (cohead_orderdate <= <? value("endDate") ?>)
  <? endif ?>
  <? if exists("startDateSched") ?>
    AND  (coitem_scheddate >= <? value("startDateSched") ?>)
  <? endif ?>
  <? if exists("endDateSched") ?>
    AND  (coitem_scheddate <= <? value("endDateSched") ?>)
  <? endif ?>
  <? if exists("salesrep_id") ?>
    AND  (cohead_salesrep_id=<? value("salesrep_id") ?>)
  <? endif ?>
  <? if exists("shipto_id") ?>
    AND  (cohead_shipto_id=<? value("shipto_id") ?>)
  <? endif ?>
  <? if exists("cust_id") ?>
    AND  (cohead_cust_id=<? value("cust_id") ?>)
  <? endif ?>
  <? if exists("custtype_id") ?>
    AND  (cust_custtype_id=<? value("custtype_id") ?>)
  <? endif ?>
  <? if exists("custtype_pattern") ?>
    AND  (cust_custtype_id IN (SELECT DISTINCT custtype_id
                               FROM custtype
                               WHERE (custtype_code ~ <? value("custtype_pattern") ?>)))
  <? endif ?>
  <? if exists("custgrp") ?>
    AND (cust_id IN (SELECT DISTINCT custgrpitem_cust_id
                     FROM custgrpitem))
  <? endif ?>
  <? if exists("custgrp_id") ?>
    AND (cust_id IN (SELECT DISTINCT custgrpitem_cust_id
                     FROM custgrpitem
                     WHERE (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)))
  <? endif ?>
  <? if exists("custgrp_pattern") ?>
    AND (cust_id IN (SELECT DISTINCT custgrpitem_cust_id
                     FROM custgrp, custgrpitem
                     WHERE ( (custgrpitem_custgrp_id=custgrp_id)
                       AND   (custgrp_name ~ <? value("custgrp_pattern") ?>) )) )
  <? endif ?>

  <? if exists("item_id") ?>
    AND  (itemsite_item_id=<? value("item_id") ?>)
  <? endif ?>
  <? if exists("prodcat_id") ?>
    AND (item_prodcat_id=<? value("prodcat_id") ?>)
  <? endif ?>
  <? if exists("prodcat_pattern") ?>
    AND (item_prodcat_id IN (SELECT DISTINCT prodcat_id
                             FROM prodcat
                             WHERE (prodcat_code ~ <? value("prodcat_pattern") ?>)))
  <? endif ?>

  <? if exists("warehous_id") ?>
    AND  (itemsite_warehous_id=<? value("warehous_id") ?>)
  <? endif ?>
  <? literal("charClause") ?>
        )

  UNION

  SELECT 
         1 AS xtindentrole,
         coitem_id,        coitem_cohead_id,
         coitem_linenumber,coitem_itemsite_id,
         coitem_status,    coitem_scheddate,
         getSoSchedDate(cohead_id) AS sort_scheddate,
         coitem_promdate,  coitem_qtyord,
         coitem_unitcost,  coitem_price,
         coitem_custprice, coitem_qtyshipped,
         coitem_order_id,  coitem_memo,
         coitem_imported,  coitem_qtyreturned,
         coitem_closedate, coitem_firm,
         coitem_custpn,    coitem_order_type,
         coitem_close_username,
         coitem_lastupdated,
         coitem_substitute_item_id,
         coitem_created,   coitem_creator,
         coitem_prcost,
         coitem_qty_uom_id,
         coitem_qty_invuomratio,
         coitem_price_uom_id,
         coitem_price_invuomratio,
         coitem_warranty,
         coitem_cos_accnt_id,
         coitem_qtyreserved,
         coitem_subnumber,
         cohead.*,
         cust_number, cust_name,
         item_number, item_descrip1, (item_descrip1 || '' '' || item_descrip2) AS itemdescription,
         uom_name,
         warehous_code,
         noNeg(coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned) AS qtybalance,
         currtobase(cohead_curr_id, coitem_price, cohead_orderdate) AS baseunitprice,
         round((coitem_qtyord * coitem_qty_invuomratio) *
                     (coitem_price / coitem_price_invuomratio), 2) AS extprice,
         round((coitem_qtyord * coitem_qty_invuomratio) *
                     (currtobase(cohead_curr_id, coitem_price, cohead_orderdate) / coitem_price_invuomratio), 2) AS baseextprice,
         round((noNeg(coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned) * coitem_qty_invuomratio) *
                     (coitem_price / coitem_price_invuomratio), 2) AS extpricebalance,
         round((noNeg(coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned) * coitem_qty_invuomratio) *
                     (currtobase(cohead_curr_id, coitem_price, cohead_orderdate) / coitem_price_invuomratio), 2) AS baseextpricebalance

  FROM coitem JOIN cohead ON (cohead_id=coitem_cohead_id)
              JOIN custinfo ON (cust_id=cohead_cust_id)
              JOIN itemsite ON (itemsite_id=coitem_itemsite_id)
              JOIN site() ON (warehous_id=itemsite_warehous_id)
              JOIN item ON (item_id=itemsite_item_id)
              JOIN uom ON (uom_id=coitem_qty_uom_id)
<? foreach("char_id_text_list") ?>
     LEFT OUTER JOIN charass charass_alias<? literal("char_id_text_list") ?> 
          ON ((charass_alias<? literal("char_id_text_list") ?>.charass_target_type=''SO'') 
         AND  (charass_alias<? literal("char_id_text_list") ?>.charass_target_id=cohead_id)
         AND  (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=<? value("char_id_text_list") ?>))
     LEFT OUTER JOIN char char_alias<? literal("char_id_text_list") ?> 
          ON (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=char_alias<? literal("char_id_text_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_list_list") ?>
     LEFT OUTER JOIN charass charass_alias<? literal("char_id_list_list") ?> 
          ON ((charass_alias<? literal("char_id_list_list") ?>.charass_target_type=''SO'') 
         AND  (charass_alias<? literal("char_id_list_list") ?>.charass_target_id=cohead_id)
         AND  (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=<? value("char_id_list_list") ?>))
     LEFT OUTER JOIN char char_alias<? literal("char_id_list_list") ?> 
          ON (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=char_alias<? literal("char_id_list_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_date_list") ?>
     LEFT OUTER JOIN charass charass_alias<? literal("char_id_date_list") ?> 
          ON ((charass_alias<? literal("char_id_date_list") ?>.charass_target_type=''SO'') 
         AND  (charass_alias<? literal("char_id_date_list") ?>.charass_target_id=cohead_id)
         AND  (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=<? value("char_id_date_list") ?>))
     LEFT OUTER JOIN char char_alias<? literal("char_id_date_list") ?> 
          ON (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=char_alias<? literal("char_id_date_list") ?>.char_id)
<? endforeach ?>
  WHERE ( (coitem_status=''O'')
  <? if exists("cohead_id") ?>
    AND  (coitem_cohead_id=<? value("cohead_id") ?>)
  <? endif ?>
  <? if exists("startDate") ?>
    AND  (cohead_orderdate >= <? value("startDate") ?>)
  <? endif ?>
  <? if exists("endDate") ?>
    AND  (cohead_orderdate <= <? value("endDate") ?>)
  <? endif ?>
  <? if exists("startDateSched") ?>
    AND  (coitem_scheddate >= <? value("startDateSched") ?>)
  <? endif ?>
  <? if exists("endDateSched") ?>
    AND  (coitem_scheddate <= <? value("endDateSched") ?>)
  <? endif ?>
  <? if exists("salesrep_id") ?>
    AND  (cohead_salesrep_id=<? value("salesrep_id") ?>)
  <? endif ?>
  <? if exists("shipto_id") ?>
    AND  (cohead_shipto_id=<? value("shipto_id") ?>)
  <? endif ?>
  <? if exists("cust_id") ?>
    AND  (cohead_cust_id=<? value("cust_id") ?>)
  <? endif ?>
  <? if exists("custtype_id") ?>
    AND  (cust_custtype_id=<? value("custtype_id") ?>)
  <? endif ?>
  <? if exists("custtype_pattern") ?>
    AND  (cust_custtype_id IN (SELECT DISTINCT custtype_id
                               FROM custtype
                               WHERE (custtype_code ~ <? value("custtype_pattern") ?>)))
  <? endif ?>
  <? if exists("custgrp") ?>
    AND (cust_id IN (SELECT DISTINCT custgrpitem_cust_id
                     FROM custgrpitem))
  <? endif ?>
  <? if exists("custgrp_id") ?>
    AND (cust_id IN (SELECT DISTINCT custgrpitem_cust_id
                     FROM custgrpitem
                     WHERE (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)))
  <? endif ?>
  <? if exists("custgrp_pattern") ?>
    AND (cust_id IN (SELECT DISTINCT custgrpitem_cust_id
                     FROM custgrp, custgrpitem
                     WHERE ( (custgrpitem_custgrp_id=custgrp_id)
                       AND   (custgrp_name ~ <? value("custgrp_pattern") ?>) )) )
  <? endif ?>

  <? if exists("item_id") ?>
    AND  (itemsite_item_id=<? value("item_id") ?>)
  <? endif ?>
  <? if exists("prodcat_id") ?>
    AND (item_prodcat_id=<? value("prodcat_id") ?>)
  <? endif ?>
  <? if exists("prodcat_pattern") ?>
    AND (item_prodcat_id IN (SELECT DISTINCT prodcat_id
                             FROM prodcat
                             WHERE (prodcat_code ~ <? value("prodcat_pattern") ?>)))
  <? endif ?>

  <? if exists("warehous_id") ?>
    AND  (itemsite_warehous_id=<? value("warehous_id") ?>)
  <? endif ?>
  <? literal("charClause") ?>
        )

) AS dummy
ORDER BY cohead_number, xtindentrole, coitem_linenumber;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (114, 'crm', 'strictcountrycheck', 'select details about countries used throughout the database that do not match country.country_name  Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: crm
-- Name:  strictcountrycheck
-- Notes: select details about countries used throughout the database
--        that do not match country.country_name
--
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

<? if exists("count") ?>
SELECT SUM(counter) AS counter FROM (
<? endif ?>
  SELECT <? if exists("count") ?> COUNT(*) AS counter
         <? else ?> addr_id, ''Address'' AS type, addr_number AS number, addr_country AS country, '''' AS detail
         <? endif ?>
    FROM addr
   WHERE addr_country != ''''
     AND addr_country NOT IN (SELECT country_name
                                FROM country
                               WHERE country_name IS NOT NULL)
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> cmhead_id, ''Credit Memo'', cmhead_number, cmhead_billtocountry, ''Bill-To''
         <? endif ?>
    FROM cmhead
   WHERE cmhead_billtocountry != ''''
     AND cmhead_billtocountry NOT IN (SELECT country_name
                                        FROM country
                                       WHERE country_name IS NOT NULL)
     <? if not exists("showAll") ?> AND (NOT cmhead_posted) <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> cmhead_id, ''Credit Memo'', cmhead_number, cmhead_billtocountry, ''Ship-To''
         <? endif ?>
    FROM cmhead
    WHERE cmhead_shipto_country != ''''
      AND cmhead_shipto_country NOT IN (SELECT country_name
                                          FROM country
                                         WHERE country_name IS NOT NULL)
      <? if not exists("showAll") ?> AND (NOT cmhead_posted) <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> invchead_id, ''Invoice'', invchead_invcnumber, invchead_billto_country, ''Bill-To''
         <? endif ?>
    FROM invchead
   WHERE invchead_billto_country != ''''
     AND invchead_billto_country NOT IN (SELECT country_name
                                           FROM country
                                          WHERE country_name IS NOT NULL)
     <? if not exists("showAll") ?> AND (NOT invchead_posted) <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> invchead_id, ''Invoice'', invchead_invcnumber, invchead_shipto_country, ''Ship-To''
         <? endif ?>
    FROM invchead
   WHERE invchead_shipto_country != ''''
     AND invchead_shipto_country NOT IN (SELECT country_name
                                           FROM country
                                          WHERE country_name IS NOT NULL)
     <? if not exists("showAll") ?> AND (NOT invchead_posted) <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> quhead_id, ''Quote'', quhead_number, quhead_billtocountry, ''Bill-To''
         <? endif ?>
    FROM quhead
   WHERE quhead_billtocountry != ''''
     AND quhead_billtocountry NOT IN (SELECT country_name
                                        FROM country
                                       WHERE country_name IS NOT NULL)
     <? if not exists("showAll") ?> AND (quhead_expire>=CURRENT_DATE) <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> quhead_id, ''Quote'', quhead_number, quhead_shiptocountry, ''Ship-To''
         <? endif ?>
    FROM quhead
   WHERE quhead_shiptocountry != ''''
     AND quhead_shiptocountry NOT IN (SELECT country_name
                                        FROM country
                                       WHERE country_name IS NOT NULL)
     <? if not exists("showAll") ?> AND (quhead_expire>=CURRENT_DATE) <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> cohead_id, ''Sales Order'', cohead_number, cohead_billtocountry, ''Bill-To''
         <? endif ?>
    FROM cohead
   WHERE cohead_billtocountry != ''''
     AND cohead_billtocountry NOT IN (SELECT country_name
                                        FROM country
                                       WHERE country_name IS NOT NULL)
    <? if not exists("showAll") ?>
     AND cohead_id IN (SELECT coitem_cohead_id
                         FROM coitem
                        WHERE COALESCE(coitem_status, ''O'')=''O'')
    <? endif ?>
  UNION ALL
  SELECT <? if exists("count") ?> COUNT(*)
         <? else ?> cohead_id, ''Sales Order'', cohead_number, cohead_shiptocountry, ''Ship-To''
         <? endif ?>
    FROM cohead
   WHERE cohead_shiptocountry != ''''
     AND cohead_shiptocountry NOT IN (SELECT country_name
                                       FROM country
                                      WHERE country_name IS NOT NULL)
    <? if not exists("showAll") ?>
     AND cohead_id IN (SELECT coitem_cohead_id
                         FROM coitem
                        WHERE COALESCE(coitem_status, ''O'')=''O'')
    <? endif ?>

<? if exists("count") ?>
) AS dummy;
<? endif ?>
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (426, 'contactmerge', 'search', 'Search for contacts Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: contactmerge
-- Name: search
-- Notes: Search for contacts
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT cntct_id,
  CASE
    WHEN (cntctsel_cntct_id IS NOT NULL AND cntctsel_target) THEN
      1 -- Selected as target contact
    WHEN (cntctsel_cntct_id IS NOT NULL AND NOT cntctsel_target) THEN
      2 -- Selected as contact to merge
    WHEN (cntctmrgd_cntct_id IS NOT NULL AND cntctUsed(cntctmrgd_cntct_id)=false) THEN
      3 -- Already merged contact
    WHEN (cntctmrgd_cntct_id IS NOT NULL) THEN
      4 -- Already merged contact, but still has relationships
    ELSE
      0 -- No status
  END AS status,
  cntctdups.*, 
  cntctdup_level AS xtindentrole,
  CASE
    WHEN (cntctsel_cntct_id IS NOT NULL AND cntctsel_target) THEN
      ''altemphasis'' -- Selected as target contact
    WHEN (cntctsel_cntct_id IS NOT NULL AND NOT cntctsel_target) THEN
      ''emphasis'' -- Selected as contact to merge
    WHEN (cntctmrgd_cntct_id IS NOT NULL AND cntctUsed(cntctmrgd_cntct_id)=false) THEN
      ''warning'' -- Already merged contact
    WHEN (cntctmrgd_cntct_id IS NOT NULL) THEN
      ''error'' -- Already merged contact, but still has relationships
  END AS qtforegroundrole
FROM cntctdups(
  <? value("searchText") ?>, 
  <? value("searchContactName") ?>, 
  <? value("searchPhone") ?>, 
  <? value("searchEmail") ?>, 
  <? value("searchNumber") ?>, 
  <? value("searchName") ?>, 
  <? value("showInactive") ?>, 
  <? value("ignoreBlanks") ?>,
  <? value("IndentedDups") ?>, 
  <? value("CheckHnfc") ?>, 
  <? value("CheckFirst") ?>, 
  <? value("CheckMiddle") ?>, 
  <? value("CheckLast") ?>, 
  <? value("CheckSuffix") ?>, 
  <? value("CheckPhone") ?>, 
  <? value("CheckEmail") ?>)
  LEFT OUTER JOIN cntctsel ON (cntct_id=cntctsel_cntct_id)
  LEFT OUTER JOIN cntctmrgd ON (cntct_id=cntctmrgd_cntct_id);
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (422, 'contactmerge', 'merge', 'Merge contact selections Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: contactmerge
-- Name: merge
-- Notes: Merge contact selections
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT cntctmerge(
  src.cntctsel_cntct_id, 
  trgt.cntctsel_cntct_id,
  <? value("purge") ?>::boolean) AS result
FROM cntctsel src, cntctsel trgt
WHERE ((trgt.cntctsel_target)
AND (NOT src.cntctsel_target));
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (447, 'crmaccountmerge', 'pickdatasources', 'Show the records the user has selected to merge crm accounts. Emphasize the particular fields in each record that s/he has selected. Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: crmaccountmerge
-- Name:  pickdatasources
-- Notes: Show the records the user has selected to merge crm accounts. Emphasize
--        the particular fields in each record that s/he has selected.
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT c.crmacct_id,
       crmacctsel_dest_crmacct_id,
       c.crmacct_active,
       formatCntctName(c.crmacct_cntct_id_1) AS primary,
       formatCntctName(c.crmacct_cntct_id_2) AS secondary,
       c.crmacct_competitor_id IS NOT NULL   AS competitor,
       c.crmacct_cust_id       IS NOT NULL   AS cust,
       c.crmacct_emp_id        IS NOT NULL   AS emp,
       c.crmacct_name,
       c.crmacct_number,
       c.crmacct_owner_username              AS owner,
       p.crmacct_number                      AS parent,
       c.crmacct_partner_id    IS NOT NULL   AS partner,
       c.crmacct_prospect_id   IS NOT NULL   AS prospect,
       c.crmacct_salesrep_id   IS NOT NULL   AS salesrep,
       c.crmacct_taxauth_id    IS NOT NULL   AS taxauth,
       c.crmacct_type,
       c.crmacct_usr_username  IS NOT NULL   AS usr,
       c.crmacct_vend_id       IS NOT NULL   AS vend,
       trim(firstline(c.crmacct_notes))      AS notes,

       CASE crmacctsel_src_crmacct_id=crmacctsel_dest_crmacct_id
            WHEN true THEN ''#ccc''
       END AS qtbackgroundrole,

       CASE WHEN c.crmacct_active IS NULL THEN <? value(''na'') ?> END AS crmacct_active_qtdisplayrole,
       CASE WHEN COALESCE(formatCntctName(c.crmacct_cntct_id_1), '''') = '''' THEN <? value(''na'') ?> END AS primary_qtdisplayrole,
       CASE WHEN COALESCE(formatCntctName(c.crmacct_cntct_id_2), '''') = '''' THEN <? value(''na'') ?> END AS secondary_qtdisplayrole,
       CASE WHEN COALESCE(c.crmacct_name,           '''') = '''' THEN <? value(''na'') ?>  END AS crmacct_name_qtdisplayrole,
       CASE WHEN COALESCE(c.crmacct_number,         '''') = '''' THEN <? value(''na'') ?>  END AS crmacct_number_qtdisplayrole,
       CASE WHEN COALESCE(c.crmacct_owner_username, '''') = '''' THEN <? value(''na'') ?>  END AS owner_qtdisplayrole,
       CASE WHEN COALESCE(p.crmacct_number,         '''') = '''' THEN <? value(''na'') ?>  END AS parent_qtdisplayrole,
       CASE c.crmacct_type WHEN ''I'' THEN <? value(''individual'') ?>
                           WHEN ''O'' THEN <? value(''organization'') ?>
                           ELSE <? value(''na'') ?> END AS crmacct_type_qtdisplayrole,
       CASE WHEN COALESCE(TRIM(firstline(c.crmacct_notes)), '''') = '''' THEN <? value(''na'') ?> END AS notes_qtdisplayrole,

       CASE WHEN crmacctsel_mrg_crmacct_number         THEN ''emphasis'' END AS crmacct_number_qtforegroundrole,
       CASE WHEN crmacctsel_mrg_crmacct_active         THEN ''emphasis'' END AS crmacct_active_qtforegroundrole,
       CASE WHEN crmacctsel_mrg_crmacct_cntct_id_1     THEN ''emphasis'' END AS primary_qtforegroundrole,
       CASE WHEN crmacctsel_mrg_crmacct_cntct_id_2     THEN ''emphasis'' END AS secondary_qtforegroundrole,
       CASE WHEN crmacctsel_mrg_crmacct_competitor_id  THEN ''emphasis'' END AS competitor_qtforegroundrole,
       CASE WHEN crmacctsel_mrg_crmacct_cust_id        THEN ''emphasis'' END AS cust_qtforegroundrole,
       CASE WHEN crmacctsel_mrg_crmacct_emp_id         THEN ''emphasis'' END AS emp_qtforegroundrole,
       CASE WHEN crmacctsel_mrg_crmacct_name           THEN ''emphasis'' END AS crmacct_name_qtforegroundrole,
       CASE WHEN crmacctsel_mrg_crmacct_owner_username THEN ''emphasis'' END AS owner_qtforegroundrole,
       CASE WHEN crmacctsel_mrg_crmacct_parent_id      THEN ''emphasis'' END AS parent_qtforegroundrole,
       CASE WHEN crmacctsel_mrg_crmacct_partner_id     THEN ''emphasis'' END AS partner_qtforegroundrole,
       CASE WHEN crmacctsel_mrg_crmacct_prospect_id    THEN ''emphasis'' END AS prospect_qtforegroundrole,
       CASE WHEN crmacctsel_mrg_crmacct_salesrep_id    THEN ''emphasis'' END AS salesrep_qtforegroundrole,
       CASE WHEN crmacctsel_mrg_crmacct_taxauth_id     THEN ''emphasis'' END AS taxauth_qtforegroundrole,
       CASE WHEN crmacctsel_mrg_crmacct_type           THEN ''emphasis'' END AS crmacct_type_qtforegroundrole,
       CASE WHEN crmacctsel_mrg_crmacct_usr_username   THEN ''emphasis'' END AS usr_qtforegroundrole,
       CASE WHEN crmacctsel_mrg_crmacct_vend_id        THEN ''emphasis'' END AS vend_qtforegroundrole,
       CASE WHEN crmacctsel_mrg_crmacct_notes          THEN ''emphasis'' END AS notes_qtforegroundrole,

       c.crmacct_cntct_id_1   AS primary_xtidrole,
       c.crmacct_cntct_id_2   AS secondary_xtidrole,
       c.crmacct_cust_id      AS cust_xtidrole,
       c.crmacct_emp_id       AS emp_xtidrole,
       c.crmacct_parent_id    AS parent_xtidrole,
       c.crmacct_prospect_id  AS prospect_xtidrole,
       c.crmacct_salesrep_id  AS salesrep_xtidrole,
       c.crmacct_taxauth_id   AS taxauth_xtidrole,
       c.crmacct_usr_username AS usr_xtidrole,
       c.crmacct_vend_id      AS vend_xtidrole,

       c.crmacct_notes AS notes_qttooltiprole

  FROM crmacct c
  JOIN crmacctsel ON (c.crmacct_id=crmacctsel_src_crmacct_id)
  LEFT OUTER JOIN crmacct p ON (c.crmacct_parent_id=p.crmacct_id)
 WHERE crmacctsel_dest_crmacct_id=<? value(''destid'') ?>
 ORDER BY qtbackgroundrole DESC, c.crmacct_number;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (104, 'taxHistory', 'detail', ' ---------BEGIN SUMMARY---------- Notes: Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: taxHistory
-- Name: detail
-- Notes:
-----------BEGIN SUMMARY----------
-- Notes:
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

<? if exists("summary") ?>
SELECT <? literal("groupBy") ?>, 
  <? literal("groupBy") ?>_descrip AS description, 
  SUM(salesbase) AS salesbase,
  SUM(freightbase) AS freightbase, 
  CASE WHEN (SUM(freighttax) > 0) THEN true ELSE false END AS freighttax, 
  SUM(salestaxbase) AS salestaxbase,
  SUM(purchasebase) AS purchasebase,
  SUM(purchasetaxbase) * -1 AS purchasetaxbase, 
  SUM(salestaxbase) + SUM(purchasetaxbase) AS nettaxbase,
  ''curr'' AS salesbase_xtnumericrole,
  ''curr'' AS freightbase_xtnumericrole,
  ''curr'' AS salestaxbase_xtnumericrole,
  ''curr'' AS purchasebase_xtnumericrole,
  ''curr'' AS purchasetaxbase_xtnumericrole,
  ''curr'' AS nettaxbase_xtnumericrole,
  0 AS salestaxbase_xttotalrole,
  0 AS purchasetaxbase_xttotalrole,
  0 AS nettaxbase_xttotalrole
FROM (
<? endif ?>
------------END SUMMARY--------------
<? if exists("showSales") ?>
------------BEGIN SALES--------------
-- All sales tax history including memos 
SELECT 
  taxhist_distdate, taxhist_journalnumber,
  tax_code AS tax, tax_descrip,
  COALESCE(taxtype_name,<? value("none") ?>) AS taxtype, taxtype_descrip,
  COALESCE(taxclass_code,<? value("none") ?>) AS taxclass, taxclass_descrip,
  COALESCE(taxauth_code,<? value("none") ?>) AS taxauth, taxauth_name AS taxauth_descrip,
  COALESCE(taxzone_code,<? value("none") ?>) AS taxzone, taxzone_descrip, curr_abbr, 
  cohist_invcnumber AS docnumber, 
  <? value("sales") ?> AS source,
  CASE
    WHEN (cohist_doctype=''I'') THEN
      <? value("invoice") ?>
    WHEN (cohist_doctype=''C'') THEN
      <? value("creditmemo") ?> 
    WHEN (cohist_doctype=''D'') THEN
      <? value("debitmemo") ?>
    ELSE
      <? value("other") ?>
  END AS doctype,
  item_number, COALESCE(item_descrip1,cohist_misc_descrip) AS description,
  CASE
    WHEN (cohist_doctype != ''C'') THEN
      cohist_ordernumber 
  END AS ordernumber, cohist_invcdate AS docdate,
  cohist_billtoname AS name, 
  cohist_qtyshipped AS qty, 
  cohist_unitprice AS unitprice, (cohist_qtyshipped * cohist_unitprice) AS amount,
  CASE
    WHEN (cohist_misc_type IS NULL OR cohist_misc_type IN (''M'',''F'')) THEN
      currToBase(cohist_curr_id, cohist_qtyshipped * cohist_unitprice, cohist_invcdate) 
    ELSE 0
  END AS salesbase,
  CASE
    WHEN (cohist_misc_type = ''F'') THEN
      currToBase(cohist_curr_id, cohist_qtyshipped * cohist_unitprice, cohist_invcdate) 
    ELSE 0
  END AS freightbase,
  CASE
    WHEN (cohist_misc_type = ''F'') THEN
      taxhist_tax / taxhist_curr_rate
    ELSE 0
  END AS freighttax,
  0 AS purchasebase,
  taxhist_tax AS taxlocal,
  taxhist_tax / taxhist_curr_rate AS taxbase,
  taxhist_tax / taxhist_curr_rate AS salestaxbase,
  0 AS purchasetaxbase,
  ''qty'' AS qty_xtnumericrole,
  ''saleprice'' AS unitprice_xtnumericrole,
  ''extprice'' AS amount_xtnumericrole,
  ''curr'' AS taxhist_tax_xtnumericrole,
  ''curr'' AS taxbase_xtnumericrole,
   0 AS taxbase_xttotalrole
FROM cohisttax
 JOIN cohist ON (cohist_id=taxhist_parent_id)
 JOIN taxtype ON (taxtype_id=taxhist_taxtype_id)
 JOIN tax ON (tax_id=taxhist_tax_id)
 JOIN curr_symbol ON (curr_id=taxhist_curr_id)
 LEFT OUTER JOIN taxclass ON (tax_taxclass_id=taxclass_id)
 LEFT OUTER JOIN taxauth ON (tax_taxauth_id=taxauth_id)
 LEFT OUTER JOIN taxzone ON (cohist_taxzone_id=taxzone_id)
 LEFT OUTER JOIN itemsite ON (cohist_itemsite_id=itemsite_id)
 LEFT OUTER JOIN item ON (itemsite_item_id=item_id)
<? if exists("distDate") ?>
WHERE ((taxhist_distdate BETWEEN <? value("startDate") ?>
                             AND <? value("endDate") ?>)
<? else ?>
WHERE ((taxhist_docdate BETWEEN <? value("startDate") ?>
                             AND <? value("endDate") ?>)
<? endif ?>
<? if exists("tax_id") ?>
 AND (taxhist_tax_id=<? value("tax_id") ?>)
<? endif ?>
<? if exists("taxtype_id") ?>
 AND (taxhist_taxtype_id=<? value("taxtype_id") ?>)
<? endif ?>
<? if exists("taxclass_id") ?>
 AND (taxclass_id=<? value("taxclass_id") ?>)
<? endif ?>
<? if exists("taxauth_id") ?>
 AND (taxauth_id=<? value("taxauth_id") ?>)
<? endif ?>
<? if exists("taxzone_id") ?>
 AND (taxzone_id=<? value("taxzone_id") ?>)
<? endif ?>
)
<? endif ?>
--------------END SALES--------------------
<? if exists("showPurchases") ?>
<? if exists("showSales") ?>
-- Union because sales and purchase shown together
UNION ALL
<? endif ?>
<? endif ?>
------------BEGIN PURCHASE----------------
<? if exists("showPurchases") ?>
-- A/P Memo history
SELECT 
  taxhist_distdate, taxhist_journalnumber,
  tax_code AS tax, tax_descrip,
  COALESCE(taxtype_name,<? value("none") ?>) AS taxtype, taxtype_descrip,
  COALESCE(taxclass_code,<? value("none") ?>) AS taxclass, taxclass_descrip,
  COALESCE(taxauth_code,<? value("none") ?>) AS taxauth, taxauth_name AS taxauth_descrip,
  <? value("none") ?> AS taxzone,'''' AS taxzone_descrip, curr_abbr, 
  apopen_docnumber AS docnumber, 
  <? value("purchase") ?> AS source,
  CASE
    WHEN (apopen_doctype=''C'') THEN
      <? value("creditmemo") ?> 
    WHEN (apopen_doctype=''D'') THEN
      <? value("debitmemo") ?>
    ELSE
      <? value("other") ?>
  END AS doctype,
  '''' AS item_number, apopen_notes AS description,
  apopen_ponumber AS ordernumber, apopen_docdate AS docdate,
  vend_name AS name, 
  1 AS qty, 
  apopen_amount AS unitprice, apopen_amount AS amount,
  0 AS salesbase,
  0 AS freightbase,
  0 AS freighttax,
  apopen_amount / apopen_curr_rate AS purchasebase,
  taxhist_tax AS taxlocal,
  taxhist_tax / taxhist_curr_rate AS taxbase,
  0 AS salestaxbase,
  taxhist_tax / taxhist_curr_rate AS purchasetaxbase,
  ''qty'' AS qty_xtnumericrole,
  ''purchaseprice'' AS unitprice_xtnumericrole,
  ''extprice'' AS extension_xtnumericrole,
  ''curr'' AS taxhist_tax_xtnumericrole,
  ''curr'' AS taxbase_xtnumericrole,
   0 AS taxbase_xttotalrole
FROM apopentax
 JOIN apopen ON (apopen_id=taxhist_parent_id)
 JOIN vendinfo ON (apopen_vend_id=vend_id)
 JOIN taxtype ON (taxtype_id=taxhist_taxtype_id)
 JOIN tax ON (tax_id=taxhist_tax_id)
 JOIN curr_symbol ON (curr_id=taxhist_curr_id)
 LEFT OUTER JOIN taxclass ON (tax_taxclass_id=taxclass_id)
 LEFT OUTER JOIN taxauth ON (tax_taxauth_id=taxauth_id)
<? if exists("distDate") ?>
WHERE ((taxhist_distdate BETWEEN <? value("startDate") ?>
                             AND <? value("endDate") ?>)
<? else ?>
WHERE ((taxhist_docdate BETWEEN <? value("startDate") ?>
                             AND <? value("endDate") ?>)
<? endif ?>
<? if exists("tax_id") ?>
 AND (taxhist_tax_id=<? value("tax_id") ?>)
<? endif ?>
<? if exists("taxtype_id") ?>
 AND (taxhist_taxtype_id=<? value("taxtype_id") ?>)
<? endif ?>
<? if exists("taxclass_id") ?>
 AND (taxclass_id=<? value("taxclass_id") ?>)
<? endif ?>
<? if exists("taxauth_id") ?>
 AND (taxauth_id=<? value("taxauth_id") ?>)
<? endif ?>
<? if exists("taxzone_id") ?>
 AND (false)
<? endif ?>
 AND (taxhist_distdate IS NOT NULL)
)
UNION ALL
--Voucher Header History
SELECT 
  taxhist_distdate, taxhist_journalnumber,
  tax_code AS tax, tax_descrip,
  COALESCE(taxtype_name,<? value("none") ?>) AS taxtype, taxtype_descrip,
  COALESCE(taxclass_code,<? value("none") ?>) AS taxclass, taxclass_descrip,
  COALESCE(taxauth_code,<? value("none") ?>) AS taxauth, taxauth_name AS taxauth_descrip,
  COALESCE(taxzone_code,<? value("none") ?>) AS taxzone, taxzone_descrip, curr_abbr, 
  vohead_number AS docnumber, 
  <? value("purchase") ?> AS source,
  <? value("voucher") ?>  AS doctype,
  '''', vohead_notes AS description,
  pohead_number AS ordernumber, vohead_docdate AS docdate,
  vend_name AS name, 
  1 AS qty, 
  0 AS unitprice, 0 AS amount,
  0 AS salesbase,
  0 AS freightbase,
  0 AS freighttax,
  0 AS purchasebase,
  taxhist_tax AS taxlocal,
  taxhist_tax / taxhist_curr_rate AS taxbase,
  0 AS salestaxbase,
  taxhist_tax / taxhist_curr_rate AS purchasetaxbase,
  ''qty'' AS qty_xtnumericrole,
  ''purchaseprice'' AS unitprice_xtnumericrole,
  ''extprice'' AS amount_xtnumericrole,
  ''curr'' AS taxhist_tax_xtnumericrole,
  ''curr'' AS taxbase_xtnumericrole,
   0 AS taxbase_xttotalrole
FROM voheadtax
 JOIN vohead ON (vohead_id=taxhist_parent_id)
 LEFT OUTER JOIN pohead ON (vohead_pohead_id=pohead_id)
 JOIN vendinfo ON (vohead_vend_id=vend_id)
 JOIN taxtype ON (taxtype_id=taxhist_taxtype_id)
 JOIN tax ON (tax_id=taxhist_tax_id)
 JOIN curr_symbol ON (curr_id=taxhist_curr_id)
 LEFT OUTER JOIN taxclass ON (tax_taxclass_id=taxclass_id)
 LEFT OUTER JOIN taxauth ON (tax_taxauth_id=taxauth_id)
 LEFT OUTER JOIN taxzone ON (vohead_taxzone_id=taxzone_id)
<? if exists("distDate") ?>
WHERE ((taxhist_distdate BETWEEN <? value("startDate") ?>
                             AND <? value("endDate") ?>)
<? else ?>
WHERE ((taxhist_docdate BETWEEN <? value("startDate") ?>
                             AND <? value("endDate") ?>)
<? endif ?>
<? if exists("tax_id") ?>
 AND (taxhist_tax_id=<? value("tax_id") ?>)
<? endif ?>
<? if exists("taxtype_id") ?>
 AND (taxhist_taxtype_id=<? value("taxtype_id") ?>)
<? endif ?>
<? if exists("taxclass_id") ?>
 AND (taxclass_id=<? value("taxclass_id") ?>)
<? endif ?>
<? if exists("taxauth_id") ?>
 AND (taxauth_id=<? value("taxauth_id") ?>)
<? endif ?>
<? if exists("taxzone_id") ?>
 AND (taxzone_id=<? value("taxzone_id") ?>)
<? endif ?>
 AND (taxhist_distdate IS NOT NULL)
)
UNION ALL
--Voucher Line Item
SELECT 
  taxhist_distdate, taxhist_journalnumber,
  tax_code AS tax, tax_descrip,
  COALESCE(taxtype_name,<? value("none") ?>) AS taxtype, taxtype_descrip,
  COALESCE(taxclass_code,<? value("none") ?>) AS taxclass, taxclass_descrip,
  COALESCE(taxauth_code,<? value("none") ?>) AS taxauth, taxauth_name AS taxauth_descrip,
  COALESCE(taxzone_code,<? value("none") ?>) AS taxzone, taxzone_descrip, curr_abbr, 
  vohead_number AS docnumber, 
  <? value("purchase") ?> AS source,
  <? value("voucher") ?>  AS doctype,
  COALESCE(item_number,expcat_code), COALESCE(item_descrip1,expcat_descrip) AS description,
  pohead_number AS ordernumber, vohead_docdate AS docdate,
  vend_name AS name, 
  voitem_qty AS qty, 
  COALESCE(SUM(vodist_amount),0)/voitem_qty AS unitprice, COALESCE(SUM(vodist_amount),0) AS amount,
  0 AS salesbase,
  0 AS freightbase,
  0 AS freighttax,
  currToBase(vohead_curr_id, COALESCE(SUM(vodist_amount),0), vohead_distdate)  AS purchasebase,
  taxhist_tax AS taxlocal,
  taxhist_tax / taxhist_curr_rate AS taxbase,
  0 AS salestaxbase,
  taxhist_tax / taxhist_curr_rate AS purchasetaxbase,
  ''qty'' AS qty_xtnumericrole,
  ''purchaseprice'' AS unitprice_xtnumericrole,
  ''extprice'' AS amount_xtnumericrole,
  ''curr'' AS taxhist_tax_xtnumericrole,
  ''curr'' AS taxbase_xtnumericrole,
   0 AS taxbase_xttotalrole
FROM voitemtax
 JOIN voitem ON (voitem_id=taxhist_parent_id)
 JOIN vohead ON (vohead_id=voitem_vohead_id)
 JOIN pohead ON (vohead_pohead_id=pohead_id)
 JOIN poitem ON (voitem_poitem_id=poitem_id)
 JOIN vodist ON ((vodist_poitem_id=poitem_id)
            AND  (vodist_vohead_id=vohead_id))
 JOIN vendinfo ON (vohead_vend_id=vend_id)
 JOIN taxtype ON (taxtype_id=taxhist_taxtype_id)
 JOIN tax ON (tax_id=taxhist_tax_id)
 JOIN curr_symbol ON (curr_id=taxhist_curr_id)
 LEFT OUTER JOIN taxclass ON (tax_taxclass_id=taxclass_id)
 LEFT OUTER JOIN taxauth ON (tax_taxauth_id=taxauth_id)
 LEFT OUTER JOIN taxzone ON (vohead_taxzone_id=taxzone_id)
 LEFT OUTER JOIN itemsite ON (poitem_itemsite_id=itemsite_id)
 LEFT OUTER JOIN item ON (itemsite_item_id=item_id)
 LEFT OUTER JOIN expcat ON (expcat_id=poitem_expcat_id)
<? if exists("distDate") ?>
WHERE ((taxhist_distdate BETWEEN <? value("startDate") ?>
                             AND <? value("endDate") ?>)
<? else ?>
WHERE ((taxhist_docdate BETWEEN <? value("startDate") ?>
                             AND <? value("endDate") ?>)
<? endif ?>
<? if exists("tax_id") ?>
 AND (taxhist_tax_id=<? value("tax_id") ?>)
<? endif ?>
<? if exists("taxtype_id") ?>
 AND (taxhist_taxtype_id=<? value("taxtype_id") ?>)
<? endif ?>
<? if exists("taxclass_id") ?>
 AND (taxclass_id=<? value("taxclass_id") ?>)
<? endif ?>
<? if exists("taxauth_id") ?>
 AND (taxauth_id=<? value("taxauth_id") ?>)
<? endif ?>
<? if exists("taxzone_id") ?>
 AND (taxzone_id=<? value("taxzone_id") ?>)
<? endif ?>
 AND (taxhist_distdate IS NOT NULL)
)
GROUP BY taxhist_id,taxhist_distdate,tax_code,tax_descrip,
  taxtype_name,taxtype_descrip,taxclass_code,taxclass_descrip,
  taxauth_code,taxauth_descrip,taxzone,taxzone_descrip,curr_abbr,
  vohead_number,pohead_number,item_number,item_descrip1,
  vohead_curr_id,vohead_distdate,vohead_docdate,vend_name,
  expcat_code,expcat_descrip,taxhist_tax,taxhist_curr_rate,
  voitem_qty, taxhist_journalnumber
<? endif ?>
-------------END PURCHASE--------------
ORDER BY docdate DESC, docnumber DESC

<? if exists("summary") ?>
) AS data
GROUP BY <? literal("groupBy") ?>, <? literal("groupBy") ?>_descrip
ORDER BY <? literal("groupBy") ?>
<? endif ?>

', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (438, 'contact', 'uses', 'Find and report uses of the contact Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: contact
-- Name:  uses
-- Notes: Find and report uses of the contact
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

<? if not exists(''core'') ?>
SELECT <? value("id") ?>::text || ''.'' || type_id::text || ''.'' || type_code::text,
       <? value("id") ?> AS contact,
       *
FROM (
<? endif ?>
  SELECT crmacct_id AS type_id, 1 AS type_code, <? value("crmacct") ?> AS type,
         crmacct_number AS number,
         crmacct_name AS name, <? value("primary") ?> AS role,
         (crmacct_active) AS active,
         crmacct_owner_username AS owner
    FROM crmacct WHERE (crmacct_cntct_id_1=<? value("id") ?>)
  
  UNION ALL
  SELECT crmacct_id AS type_id, 2 AS type_code, <? value("crmacct") ?> AS type,
         crmacct_number AS number,
         crmacct_name AS name, <? value("secondary") ?> AS role,
         (crmacct_active) AS active,
         crmacct_owner_username AS owner
    FROM crmacct WHERE (crmacct_cntct_id_2=<? value("id") ?>)
  
  UNION ALL
  SELECT cust_id AS type_id, 3 AS type_code, <? value("cust") ?> AS type,
         cust_number AS number,
         cust_name AS name, <? value("billing") ?> AS role,
         (cust_active) AS active,
         '''' AS owner
    FROM custinfo WHERE (cust_cntct_id=<? value("id") ?>)
  
  UNION ALL
  SELECT cust_id AS type_id, 4 AS type_code, <? value("cust") ?> AS type,
         cust_number AS number,
         cust_name AS name, <? value("correspond") ?> AS role,
         (cust_active) AS active,
         '''' AS owner
    FROM custinfo WHERE (cust_corrcntct_id=<? value("id") ?>)
  
  UNION ALL
  SELECT vend_id AS type_id, 5 AS type_code, <? value("vend") ?> AS type,
         vend_number AS number,
         vend_name AS name, <? value("primary") ?> AS role,
         (vend_active) AS active,
         '''' AS owner
    FROM vendinfo WHERE (vend_cntct1_id=<? value("id") ?>)
  
  UNION ALL
  SELECT vend_id AS type_id, 6 AS type_code, <? value("vend") ?> AS type,
         vend_number AS number,
         vend_name AS name, <? value("secondary") ?> AS role,
         (vend_active) AS active,
         '''' AS owner
    FROM vendinfo WHERE (vend_cntct2_id=<? value("id") ?>)
  
  UNION ALL
  SELECT prospect_id AS type_id, 7 AS type_code, <? value("prospect") ?> AS type,
         prospect_number AS number,
         prospect_name AS name, '''' AS role,
         (prospect_active) AS active,
         '''' AS owner
    FROM prospect WHERE (prospect_cntct_id=<? value("id") ?>)
  
  UNION ALL
  SELECT shipto_id AS type_id, 8 AS type_code, <? value("shipto") ?> AS type,
         shipto_num AS number,
         shipto_name AS name, <? value("shipto") ?> AS role,
         (shipto_active) AS active,
         '''' AS owner
    FROM shiptoinfo WHERE (shipto_cntct_id=<? value("id") ?>)
  
  UNION ALL
  SELECT vendaddr_id AS type_id, 9 AS type_code, <? value("vendaddr") ?> AS type,
         vendaddr_code AS number,
         vendaddr_name AS name, '''' AS role,
         (true) AS active,
         '''' AS owner
    FROM vendaddrinfo WHERE (vendaddr_cntct_id=<? value("id") ?>)
   
  UNION ALL
  SELECT warehous_id AS type_id, 10 AS type_code, <? value("whs") ?> AS type,
         warehous_code AS number,
         warehous_descrip AS name, '''' AS role,
         (warehous_active) AS active,
         '''' AS owner
    FROM whsinfo WHERE (warehous_cntct_id=<? value("id") ?>)
  
  UNION ALL
  SELECT emp_id AS type_id, 11 AS type_code, <? value("emp") ?> AS type,
         emp_code AS number,
         emp_number AS name, '''' AS role,
         (emp_active) AS active,
         '''' AS owner
    FROM emp WHERE (emp_cntct_id=<? value("id") ?>)

<? if exists("showOrders") ?>
  UNION ALL
  SELECT cohead_id AS id, 12 AS altId, <? value("cohead") ?> AS type,
         cohead_number AS number,
         cust_number AS name, <? value("billing") ?> AS role,
         (cohead_status = ''O'') AS active,
         '''' AS owner
    FROM cohead JOIN custinfo ON (cohead_cust_id=cust_id)
   WHERE (<? value("id") ?>=cohead_billto_cntct_id)

  UNION ALL
  SELECT cohead_id AS id, 13 AS altId, <? value("cohead") ?> AS type,
         cohead_number AS number,
         cust_number AS name,  <? value("shipto") ?> AS role,
         (cohead_status = ''O'') AS active,
         '''' AS owner
    FROM cohead JOIN custinfo ON (cohead_cust_id=cust_id)
   WHERE (<? value("id") ?>=cohead_shipto_cntct_id)
<? endif ?>

  UNION ALL
  SELECT incdt_id AS id, 14 AS altId, <? value("incdt") ?> AS type,
         incdt_number::TEXT AS number,
         incdt_summary AS name, '''' AS role,
         (incdt_status NOT IN (''R'', ''L'')) AS active,
         incdt_owner_username AS owner
    FROM incdt
   WHERE (incdt_cntct_id=<? value("id") ?>)

<? if exists("lsreg") ?>
  UNION ALL
  SELECT lsreg_id AS id, 15 AS altId, <? value("lsreg") ?> AS type,
         ls_number AS number,
         item_number AS name, '''' AS role,
         (lsreg_expiredate > current_date) AS active,
         '''' AS owner
    FROM lsreg JOIN ls ON (lsreg_ls_id=ls_id) JOIN item ON (ls_item_id=item_id)
   WHERE (lsreg_cntct_id=<? value("id") ?>)
<? endif ?>

  UNION ALL
  SELECT ophead_id AS id, 16 AS altId, <? value("ophead") ?> AS type,
         ophead_number AS number,
         ophead_name AS name, '''' AS role,
         ophead_active AS active,
         ophead_owner_username AS owner
    FROM ophead
   WHERE (ophead_cntct_id=<? value("id") ?>)

<? if exists("showOrders") ?>
  UNION ALL
  SELECT pohead_id AS id, 17 AS altId, <? value("pohead") ?> AS type,
         pohead_number AS number,
         vend_number AS name, <? value("vendcntct") ?> AS role,
         (pohead_status != ''C'') AS active,
         '''' AS owner
    FROM pohead JOIN vendinfo ON (pohead_vend_id=vend_id)
   WHERE (<? value("id") ?>=pohead_vend_cntct_id)

  UNION ALL
  SELECT pohead_id AS id, 18 AS altId, <? value("pohead") ?> AS type,
         pohead_number AS number,
         vend_number AS name, <? value("shipto") ?> AS role,
         (pohead_status != ''C'') AS active,
         '''' AS owner
    FROM pohead JOIN vendinfo ON (pohead_vend_id=vend_id)
   WHERE (<? value("id") ?>=pohead_shipto_cntct_id)

  UNION ALL
  SELECT quhead_id AS id, 19 AS altId, <? value("quhead") ?> AS type,
         quhead_number AS number,
         COALESCE(cust_number, prospect_number) AS name,
         <? value("billing") ?> AS role,
         (quhead_status = ''O'') AS active,
         '''' AS owner
    FROM quhead LEFT OUTER JOIN custinfo ON (quhead_cust_id=cust_id)
                LEFT OUTER JOIN prospect ON (quhead_cust_id=prospect_id)
   WHERE (<? value("id") ?>=quhead_billto_cntct_id)

  UNION ALL
  SELECT quhead_id AS id, 20 AS altId, <? value("quhead") ?> AS type,
         quhead_number AS number,
         COALESCE(cust_number, prospect_number) AS name,
         <? value("shipto") ?> AS role,
         (quhead_status = ''O'') AS active,
         '''' AS owner
    FROM quhead LEFT OUTER JOIN custinfo ON (quhead_cust_id=cust_id)
                LEFT OUTER JOIN prospect ON (quhead_cust_id=prospect_id)
   WHERE (<? value("id") ?>=quhead_shipto_cntct_id)
<? endif ?>

  UNION ALL
  SELECT todoitem_id, 21 AS altId, <? value("todo") ?> AS type,
         todoitem_seq::TEXT AS number,
         todoitem_name AS name, '''' AS role,
         (todoitem_completed_date IS NULL) AS active,
         todoitem_owner_username AS owner
    FROM todoitem
   WHERE todoitem_cntct_id=<? value("id") ?>

<? if exists("showOrders") ?>
  <? if exists("tohead") ?>
  UNION ALL
  SELECT tohead_id, 22 AS altId, <? value("tohead") ?> AS type,
         tohead_number AS number,
         tohead_srcname || '' -> '' || tohead_destname AS name,
         <? value("from") ?>  AS role,
         (tohead_status = ''O'') AS active,
         '''' AS owner
    FROM tohead
   WHERE (<? value("id") ?>=tohead_srccntct_id)
  UNION ALL
  SELECT tohead_id, 23 AS altId, <? value("tohead") ?> AS type,
         tohead_number AS number,
         tohead_srcname || '' -> '' || tohead_destname AS name,
         <? value("dest") ?> AS role,
         (tohead_status = ''O'') AS active,
         '''' AS owner
    FROM tohead
   WHERE (<? value("id") ?>=tohead_destcntct_id)
  <? endif ?>
<? endif ?>

<? if not exists(''core'') ?>
) AS innerq
<? endif ?>
  ORDER BY type, number;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (434, 'accountNumbers', 'detail', 'used by accountNumbers Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: accountNumbers
-- Name: detail
-- Notes: used by accountNumbers
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT accnt_id, *,
       CASE WHEN(accnt_type=''A'') THEN <? value("asset") ?>
            WHEN(accnt_type=''E'') THEN <? value("expense") ?>
            WHEN(accnt_type=''L'') THEN <? value("liability") ?>
            WHEN(accnt_type=''Q'') THEN <? value("equity") ?>
            WHEN(accnt_type=''R'') THEN <? value("revenue") ?>
            ELSE accnt_type
       END AS accnt_type_qtdisplayrole,
       accnt_active 
  FROM (ONLY accnt LEFT OUTER JOIN
             company ON (accnt_company=company_number)) 
       LEFT OUTER JOIN subaccnttype ON (accnt_type=subaccnttype_accnt_type AND accnt_subaccnttype_code=subaccnttype_code)
 WHERE true
<? if not exists("showExternal") ?>
  AND (NOT COALESCE(company_external, false)) 
<? endif ?>
<? if not exists("showInactive") ?>
  AND COALESCE(accnt_active, false)
<? endif ?>
ORDER BY accnt_number, accnt_sub, accnt_profit;

', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (420, 'contactmerge', 'deselect', 'Removes contact selection Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: contactmerge
-- Name: deselect
-- Notes: Removes contact selection
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

DELETE FROM cntctsel
WHERE (cntctsel_cntct_id=<? value("cntct_id") ?>);
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (421, 'contactmerge', 'merged', 'Lists all merged contacts Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: contactmerge
-- Name: merged
-- Notes:  Lists all merged contacts
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT cntct_id,
  CASE
    WHEN (cntctUsed(cntctmrgd_cntct_id)=false) THEN
      3 -- Already merged contact
    ELSE
      4 -- Already merged contact, but still has relationships
  END AS status,
  cntct.*,crmacct_number,crmacct_name,addr.*, 
 0 AS xtindentrole,
  CASE
    WHEN (cntctUsed(cntctmrgd_cntct_id)=false) THEN
      ''warning'' -- Already merged contact
    ELSE
      ''error''  -- Already merged contact, but still has relationships
  END AS qtforegroundrole
FROM cntct
  JOIN cntctmrgd ON (cntct_id=cntctmrgd_cntct_id)
  LEFT OUTER JOIN addr ON (cntct_addr_id=addr_id)
  LEFT OUTER JOIN crmacct ON (cntct_crmacct_id=crmacct_id);
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (427, 'contactmerge', 'selectcol', 'Selects a specific column Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: contactmerge
-- Name: selectcol
-- Notes: Selects a specific column
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT cntctselectcol(<? value("cntct_id") ?>, <? value("col_number") ?>);
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (448, 'crmaccountmerge', 'wip', 'show an indented list of crm account merges that have data to purge. this includes those that have been started but not completed as well as those that have been completed but neither purged nor undone. Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: crmaccountmerge
-- Name:  wip
-- Notes: show an indented list of crm account merges that have
--        data to purge. this includes those that have been started
--        but not completed as well as those that have been completed
--        but neither purged nor undone.
--        Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
--        See www.xtuple.com/CPAL for the full text of the software license.

SELECT DISTINCT
       d.crmacct_id,     d.crmacct_id,
       d.crmacct_number, d.crmacct_name,
       d.crmacct_number AS destnumber,
       <? value(''mergedKey'') ?>    AS status,
       <? value(''mergedParent'') ?> AS status_qtdisplayrole,
       0 AS xtindentrole
  FROM crmacct d
  JOIN mrgundo ON (d.crmacct_id=mrgundo_base_id
               AND mrgundo_base_schema=''public''
               AND mrgundo_base_table=''crmacct'')
<? if exists(''destid'') ?>
 WHERE d.crmacct_id = <? value("destid") ?>
<? endif ?>
UNION ALL
SELECT s.crmacct_id,     d.crmacct_id,
       s.crmacct_number, s.crmacct_name,
       d.crmacct_number AS destnumber,
       <? value(''mergedKey'') ?> AS status,
       <? value(''merged'') ?>    AS status_qtdisplayrole,
<? if exists(''sourceAccountOnly'') ?>
       0
<? else ?>
       1
<? endif ?>
  FROM crmacct s
  JOIN mrgundo ON (mrgundo_schema=''public''
               AND mrgundo_table=''crmacct''
               AND mrgundo_pkey_col=''crmacct_id''
               AND mrgundo_pkey_id=s.crmacct_id
               AND mrgundo_col IS NULL)
  JOIN crmacct d ON (mrgundo_base_id=d.crmacct_id
                 AND mrgundo_base_schema=''public'')
<? if exists(''destid'') ?>
 WHERE d.crmacct_id = <? value("destid") ?>
<? endif ?>
UNION
SELECT s.crmacct_id,     d.crmacct_id,
       s.crmacct_number, s.crmacct_name,
       d.crmacct_number AS destnumber, 
       <? value(''selectedKey'') ?> AS status,
       <? value(''selected'') ?>    AS status_qtdisplayrole,
       CASE WHEN s.crmacct_id=d.crmacct_id THEN 0
            ELSE 1
       END
  FROM crmacct d
  JOIN crmacctsel ON (d.crmacct_id=crmacctsel_dest_crmacct_id)
  JOIN crmacct s  ON (crmacctsel_src_crmacct_id=s.crmacct_id)
<? if exists(''destid'') ?>
 WHERE d.crmacct_id = <? value("destid") ?>
<? endif ?>

ORDER BY destnumber, xtindentrole, crmacct_number;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (239, 'crmaccounts', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: crmaccounts
-- Name:  detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT DISTINCT ON (crmacct_number)
  crmacct_id AS id, crmacct_number, crmacct_name, crmacct_owner_username,
  cntct.*, addr.*,
  (crmacct_cust_id       IS NOT NULL) AS cust,
  (crmacct_prospect_id   IS NOT NULL) AS prospect,
  (crmacct_vend_id       IS NOT NULL) AS vend,
  (crmacct_competitor_id IS NOT NULL) AS competitor,
  (crmacct_partner_id    IS NOT NULL) AS partner,
  (crmacct_taxauth_id    IS NOT NULL) AS taxauth,
  (crmacct_usr_username  IS NOT NULL) AS usr,
  (crmacct_emp_id        IS NOT NULL) AS emp,
  (crmacct_salesrep_id   IS NOT NULL) AS salesrep
<? foreach("char_id_text_list") ?>
  , charass_alias<? literal("char_id_text_list") ?>.charass_value AS char<? literal("char_id_text_list") ?>
<? endforeach ?>
<? foreach("char_id_list_list") ?>
  , charass_alias<? literal("char_id_list_list") ?>.charass_value AS char<? literal("char_id_list_list") ?>
<? endforeach ?>
<? foreach("char_id_date_list") ?>
  , charass_alias<? literal("char_id_date_list") ?>.charass_value::date AS char<? literal("char_id_date_list") ?>
<? endforeach ?>
FROM crmacct() LEFT OUTER JOIN
  cntct ON (crmacct_cntct_id_1=cntct_id) LEFT OUTER JOIN
  addr ON (cntct_addr_id=addr_id) 
<? foreach("char_id_text_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_text_list") ?> ON ((charass_alias<? literal("char_id_text_list") ?>.charass_target_type=''CRMACCT'') 
                                                                    AND  (charass_alias<? literal("char_id_text_list") ?>.charass_target_id=crmacct_id)
                                                                    AND  (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=<? value("char_id_text_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_text_list") ?> ON (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=char_alias<? literal("char_id_text_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_list_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_list_list") ?> ON ((charass_alias<? literal("char_id_list_list") ?>.charass_target_type=''CRMACCT'') 
                                                                    AND  (charass_alias<? literal("char_id_list_list") ?>.charass_target_id=crmacct_id)
                                                                    AND  (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=<? value("char_id_list_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_list_list") ?> ON (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=char_alias<? literal("char_id_list_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_date_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_date_list") ?> ON ((charass_alias<? literal("char_id_date_list") ?>.charass_target_type=''CRMACCT'') 
                                                                    AND  (charass_alias<? literal("char_id_date_list") ?>.charass_target_id=crmacct_id)
                                                                    AND  (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=<? value("char_id_date_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_date_list") ?> ON (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=char_alias<? literal("char_id_date_list") ?>.char_id)
<? endforeach ?>
WHERE true
<? if exists("owner_username") ?> 
  AND (crmacct_owner_username=<? value("owner_username") ?>) 
<? elseif exists("owner_usr_pattern") ?>
  AND (crmacct_owner_username ~ <? value("owner_usr_pattern") ?>) 
<? endif ?>
<? if not exists("showInactive") ?> 
  AND crmacct_active 
<? endif ?>
<? if exists("search_pattern") ?>
  AND ((crmacct_number ~* <? value("search_pattern") ?>)
       OR (crmacct_name ~* <? value("search_pattern") ?>)
       OR (COALESCE(cntct_first_name,'''') || '' '' || COALESCE(cntct_last_name,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(cntct_phone,'''') || '' '' || COALESCE(cntct_phone2,'''') || '' '' || COALESCE(cntct_fax,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(cntct_email,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(addr_line1,'''') || '' '' || COALESCE(addr_line2,'''') || '' '' || COALESCE(addr_line3,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(addr_city,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(addr_state,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(addr_postalcode,'''') ~* <? value("search_pattern") ?>)
       OR (addr_country ~* <? value("search_pattern") ?>))
<? endif ?>
<? if exists("crmacct_number_pattern") ?>
  AND (crmacct_number ~* <? value("crmacct_number_pattern") ?>)
<? endif ?>
<? if exists("crmacct_name_pattern") ?>
  AND (crmacct_name ~* <? value("crmacct_name_pattern") ?>)
<? endif ?>
<? if exists("cntct_name_pattern") ?>
  AND (COALESCE(cntct_first_name,'''') || '' '' || COALESCE(cntct_last_name,'''') ~* <? value("cntct_name_pattern") ?>)
<? endif ?>
<? if exists("cntct_phone_pattern") ?>
  AND (COALESCE(cntct_phone,'''') || '' '' || COALESCE(cntct_phone2,'''') || '' '' || COALESCE(cntct_fax,'''') ~* <? value("cntct_phone_pattern") ?>)
<? endif ?>
<? if exists("cntct_email_pattern") ?>
  AND (COALESCE(cntct_email,'''') ~* <? value("cntct_email_pattern") ?>)
<? endif ?>
<? if exists("addr_street_pattern") ?>
  AND (COALESCE(addr_line1,'''') || '' '' || COALESCE(addr_line2,'''') || '' '' || COALESCE(addr_line3,'''') ~* <? value("addr_street_pattern") ?>)
<? endif ?>
<? if exists("addr_city_pattern") ?>
  AND (COALESCE(addr_city,'''') ~* <? value("addr_city_pattern") ?>)
<? endif ?>
<? if exists("addr_state_pattern") ?>
  AND (COALESCE(addr_state,'''') ~* <? value("addr_state_pattern") ?>)
<? endif ?>
<? if exists("addr_postalcode_pattern") ?>
  AND (COALESCE(addr_postalcode,'''') ~* <? value("addr_postalcode_pattern") ?>)
<? endif ?>
<? if exists("addr_country_pattern") ?>
  AND (COALESCE(addr_country,'''') ~* <? value("addr_country_pattern") ?>)
<? endif ?>
<? if exists("id") ?>
  AND (crmacct_id=<? value("id") ?>)
<? endif ?>
<? literal("charClause") ?>

<? if exists("excludeMergeWIP") ?>
  AND (crmacct_id NOT IN (SELECT mrgundo_base_id
                            FROM mrgundo
                           WHERE (mrgundo_base_schema=''public'')
                             AND (mrgundo_base_table=''crmacct'')
                          UNION
                          SELECT crmacctsel_src_crmacct_id
                            FROM crmacctsel
                          UNION
                          SELECT crmacctsel_dest_crmacct_id
                            FROM crmacctsel))
<? endif ?>
ORDER BY crmacct_number; 
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (95, 'currencyConversions', 'detail', 'used by currencyConversions the N in round(curr_rate, N) has to be SCALE - 1 of curr_rates NUMERIC(p, SCALE) type definition Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: currencyConversions
-- Name: detail
-- Notes: used by currencyConversions
--        the N in round(curr_rate, N) has to be SCALE - 1 of curr_rates
--        NUMERIC(p, SCALE) type definition
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT curr_rate_id, currConcat(curr_id) AS f_curr,
<? if exists("invert") ?>
       round((1.0 / curr_rate),5) AS rate,
<? else ?>
       round(curr_rate,5) AS rate,
<? endif ?>
       ''uomratio'' AS rate_xtnumericrole,
       curr_effective, curr_expires
FROM curr_symbol NATURAL JOIN curr_rate
WHERE ( (curr_base = FALSE)
  AND   (curr_expires >= <? value("startDate") ?>)
  AND   (curr_effective <= <? value("endDate") ?>)
<? if exists("curr_id") ?>
  AND   (curr_id = <? value("curr_id") ?>)
<? endif ?>
<? if exists("currConcat_pattern") ?>
  AND   (currConcat(curr_id) ~ <? value("currConcat_pattern") ?>)
<? endif ?>
      )
ORDER BY f_curr, curr_effective, curr_expires;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (231, 'arOpenItems', 'f_detail', 'This version for printed reports that need a way to include formatted values since there is no good way to differentiate different printed parameters in display class.  Used to be printed version got an extra parameter. Formatted values slow things down considerably on screen version otherwise. This should go away if/when we get OpenRPT to do its own formatting. Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: arOpenItems
-- Name:  f_detail
-- Notes: This version for printed reports that need a way to include formatted values
--        since there is no good way to differentiate different printed parameters in 
--        display class.  Used to be printed version got an extra parameter. Formatted
--        values slow things down considerably on screen version otherwise. This
--        should go away if/when we get OpenRPT to do its own formatting.
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

<? if exists("totalOnly") ?>
SELECT SUM(CASE WHEN (aropen_doctype IN (''C'', ''R'')) THEN
                    (aropen_amount - aropen_paid) / aropen_curr_rate * -1
                ELSE (aropen_amount - aropen_paid) / aropen_curr_rate
           END) AS total_balance
FROM aropen JOIN custinfo ON (aropen_cust_id=cust_id)
            LEFT OUTER JOIN custtype ON (cust_custtype_id=custtype_id)
            LEFT OUTER JOIN custgrpitem ON (custgrpitem_cust_id=cust_id)
WHERE ( (aropen_open)
<? if exists("cust_id") ?>
  AND   (aropen_cust_id=<? value("cust_id") ?>)
<? endif ?>
<? if exists("custtype_id") ?>
  AND   (custtype_id=<? value("custtype_id") ?>)
<? endif ?>
<? if exists("custtype_pattern") ?>
  AND   (custtype_code~<? value("custtype_pattern") ?>)
<? endif ?>
<? if exists("custgrp_id") ?>
  AND   (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)
<? endif ?>
      )
;
<? else ?>

-- Get unposted invoices
<? if exists("showUnposted") ?>
<? if not exists("creditsOnly") ?>
SELECT -1 AS id,
       0 AS altId,
       invchead_invcnumber AS docnumber,
       invchead_id AS docnumber_xtidrole,
       invchead_posted AS posted,
       invchead_invcdate AS docdate,
       NULL::date AS aropen_duedate,
       invchead_ordernumber AS ordernumber,
       cohead_id AS ordernumber_xtidrole,
       <? value("invoice") ?>  AS doctype,
       NULL AS doctype_qtforegroundrole,
       invoicetotal(invchead_id) AS amount,
       currtobase(invchead_curr_id, invoicetotal(invchead_id), invchead_invcdate) AS base_amount,
       0 AS paid,
       0 AS base_paid,
       0 AS balance,
       currConcat(invchead_curr_id) AS currAbbr,
       0 AS base_balance,
       formatDate(invchead_invcdate) AS f_docdate,
       NULL::text AS f_duedate,
       formatMoney(invoicetotal(invchead_id)) AS f_amount,
       formatMoney(0) AS f_paid,
       formatMoney(0) AS f_balance,
       cust_id, cust_number, cust_name,
       (invchead_recurring_invchead_id IS NOT NULL) AS recurring,
       false AS open,
       NULL AS ccard_number,
       ''curr'' AS amount_xtnumericrole,
       ''curr'' AS base_amount_xtnumericrole,
       0 AS base_amount_xttotalrole,
       ''curr'' AS paid_xtnumericrole,
       ''curr'' AS base_paid_xtnumericrole,
       0 AS base_paid_xttotalrole,
       ''curr'' AS balance_xtnumericrole,
       ''curr'' AS base_balance_xtnumericrole,
       0 AS base_balance_xttotalrole,
       NULL::text AS aropen_docnumber_qtdisplayrole,
       NULL::text AS aropen_docdate_qtdisplayrole,
       0 AS xtindentrole,
       '''' AS aropen_duedate_qtforegroundrole,
       NULL::integer AS ccard_number_xtidrole,
       firstLine(invchead_notes) AS notes
FROM invchead
           LEFT OUTER JOIN cohead ON (invchead_ordernumber=cohead_number)
           JOIN custinfo ON (invchead_cust_id=cust_id)
           JOIN custtype ON (cust_custtype_id=custtype_id)
	   LEFT OUTER JOIN custgrpitem ON (custgrpitem_cust_id=cust_id)
WHERE ((NOT invchead_posted)
<? if exists("cust_id") ?>
  AND   (invchead_cust_id=<? value("cust_id") ?>)
<? endif ?>
<? if exists("custtype_id") ?>
  AND   (custtype_id=<? value("custtype_id") ?>)
<? endif ?>
<? if exists("custtype_pattern") ?>
  AND   (custtype_code~<? value("custtype_pattern") ?>)
<? endif ?>
<? if exists("custgrp_id") ?>
  AND   (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)
<? endif ?>
<? if exists("startDate") ?>
  AND   (invchead_invcdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
      )
  GROUP BY id,                      altId,                  invchead_id,
           invchead_invcdate,       invchead_posted,        invchead_curr_id,
           invchead_recurring,      invchead_invcnumber,    invchead_posted,
           invchead_ordernumber,    cohead_id,
           cust_id,                 cust_number,            cust_name,
           invchead_recurring_invchead_id, invchead_notes

UNION
<? endif ?>
<? endif ?>

-- Get unposted credit memos
<? if exists("showUnposted") ?>
<? if not exists("debitsOnly") ?>
SELECT -1 AS id,
       1 AS altId,
       cmhead_number AS docnumber,
       cmhead_id AS docnumber_xtidrole,
       cmhead_posted AS posted,
       cmhead_docdate AS docdate,
       NULL::date AS aropen_duedate,
       NULL::text AS ordernumber,
       -1 AS ordernumber_xtidrole,
       <? value("return") ?>  AS doctype,
       CASE WHEN (NOT cmhead_posted) THEN ''emphasis''
       END AS doctype_qtforegroundrole,
       creditmemototal(cmhead_id) AS amount,
       currtobase(cmhead_curr_id, creditmemototal(cmhead_id), cmhead_docdate) AS base_amount,
       0 AS paid,
       0 AS base_paid,
       0 AS balance,
       currConcat(cmhead_curr_id) AS currAbbr,
       0  AS base_balance,
       formatDate(cmhead_docdate) AS f_docdate,
       NULL::text AS f_duedate,
       formatMoney(creditmemototal(cmhead_id)) AS f_amount,
       formatMoney(0) AS f_paid,
       formatMoney(0) AS f_balance,
       cust_id, cust_number, cust_name,
       false AS recurring,
       false AS open,
       NULL AS ccard_number,
       ''curr'' AS amount_xtnumericrole,
       ''curr'' AS base_amount_xtnumericrole,
       0 AS base_amount_xttotalrole,
       ''curr'' AS paid_xtnumericrole,
       ''curr'' AS base_paid_xtnumericrole,
       0 AS base_paid_xttotalrole,
       ''curr'' AS balance_xtnumericrole,
       ''curr'' AS base_balance_xtnumericrole,
       0 AS base_balance_xttotalrole,
       NULL::text AS aropen_docnumber_qtdisplayrole,
       NULL::text AS aropen_docdate_qtdisplayrole,
       0 AS xtindentrole,
       '''' AS aropen_duedate_qtforegroundrole,
       NULL::integer AS ccard_number_xtidrole,
       firstLine(cmhead_comments) AS notes
FROM cmhead
            JOIN custinfo ON (cmhead_cust_id=cust_id)
            JOIN custtype ON (cust_custtype_id=custtype_id)
	    LEFT OUTER JOIN custgrpitem ON (custgrpitem_cust_id=cust_id)
WHERE ((NOT cmhead_posted)
<? if exists("cust_id") ?>
  AND   (cmhead_cust_id=<? value("cust_id") ?>)
<? endif ?>
<? if exists("custtype_id") ?>
  AND   (custtype_id=<? value("custtype_id") ?>)
<? endif ?>
<? if exists("custtype_pattern") ?>
  AND   (custtype_code~<? value("custtype_pattern") ?>)
<? endif ?>
<? if exists("custgrp_id") ?>
  AND   (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)
<? endif ?>
<? if exists("startDate") ?>
  AND   (cmhead_docdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
      )
  GROUP BY id,                      altId,                  cmhead_id,
           cmhead_docdate,          cmhead_posted,          cmhead_curr_id,
           cmhead_number,           cmhead_posted,          cmhead_comments,
           cust_id,                 cust_number,            cust_name

UNION
<? endif ?>
<? endif ?>

-- Get Posted AR Open
SELECT aropen_id AS id,
       CASE WHEN (aropen_doctype=''I'') THEN 0
            WHEN (aropen_doctype=''C'') THEN 1
            WHEN (aropen_doctype=''D'') THEN 2
            WHEN (aropen_doctype=''R'') THEN 3
            ELSE -1
       END AS altId,
       aropen_docnumber AS docnumber,
       COALESCE(invchead_id,cmhead_id,-1) AS docnumber_xtidrole,
       true AS posted,
       aropen_docdate AS docdate,
       aropen_duedate,
       aropen_ordernumber AS ordernumber,
       COALESCE(cohead_id,-1) AS ordernumber_xtidrole,
       CASE WHEN (aropen_doctype=''I'') THEN <? value("invoice") ?>
            WHEN (aropen_doctype=''C'') THEN <? value("creditMemo") ?>
            WHEN (aropen_doctype=''D'') THEN <? value("debitMemo") ?>
            WHEN (aropen_doctype=''R'') THEN <? value("cashdeposit") ?>
            ELSE <? value("other") ?>
       END AS doctype,
       CASE WHEN (aropen_doctype=''C'') THEN ''emphasis'' 
         ELSE CASE WHEN(aropen_doctype=''R'')THEN ''altemphasis''
         END
       END AS doctype_qtforegroundrole,
       aropen_amount AS amount,
       aropen_amount/aropen_curr_rate AS base_amount,
       (aropen_paid - (COALESCE(SUM(arapply_target_paid),0))) AS paid,
       (aropen_paid - (COALESCE(SUM(arapply_target_paid),0))/aropen_curr_rate) AS base_paid,
        (((aropen_amount-aropen_paid+COALESCE(SUM(arapply_target_paid),0))) *
        CASE WHEN (aropen_doctype IN (''C'', ''R'')) THEN -1 ELSE 1 END) AS balance,
       currConcat(aropen_curr_id) AS currAbbr,
        (((aropen_amount-aropen_paid+COALESCE(SUM(arapply_target_paid),0)))/aropen_curr_rate *
        CASE WHEN (aropen_doctype IN (''C'', ''R'')) THEN -1 ELSE 1 END)  AS base_balance,
       formatDate(aropen_docdate) AS f_docdate,
       formatDate(aropen_duedate) AS f_duedate,
       formatMoney(aropen_amount) AS f_amount,
       formatMoney(aropen_paid - (COALESCE(SUM(arapply_target_paid),0))) AS f_paid,
       formatMoney((((aropen_amount-aropen_paid+COALESCE(SUM(arapply_target_paid),0))) *
        CASE WHEN (aropen_doctype IN (''C'', ''R'')) THEN -1 ELSE 1 END)) AS f_balance,
       cust_id, cust_number, cust_name,
       COALESCE(invchead_recurring_invchead_id IS NOT NULL, false) AS recurring,
       aropen_open AS open,
       formatccnumber(decrypt(setbytea(ccard_number),
                              setbytea(<? value("key") ?>), ''bf'')) AS ccard_number,
       ''curr'' AS amount_xtnumericrole,
       ''curr'' AS base_amount_xtnumericrole,
       0 AS base_amount_xttotalrole,
       ''curr'' AS paid_xtnumericrole,
       ''curr'' AS base_paid_xtnumericrole,
       0 AS base_paid_xttotalrole,
       ''curr''AS balance_xtnumericrole,
       ''curr'' AS base_balance_xtnumericrole,
       0 AS base_balance_xttotalrole,
       NULL AS aropen_docnumber_qtdisplayrole,
       NULL AS aropen_docdate_qtdisplayrole,
       0 AS xtindentrole,
       CASE WHEN ((COALESCE(aropen_duedate,current_date) < current_date) AND COALESCE(aropen_open,FALSE)) THEN ''error'' 
       END AS aropen_duedate_qtforegroundrole,
       ccpay_id AS ccard_number_xtidrole,
       firstLine(aropen_notes) AS notes
FROM aropen 
<? if exists("incidentsOnly") ?>
            JOIN incdt ON (incdt_aropen_id=aropen_id)
<? endif ?>
            JOIN custinfo ON (aropen_cust_id=cust_id)
            JOIN custtype ON (cust_custtype_id=custtype_id)
	    LEFT OUTER JOIN custgrpitem ON (custgrpitem_cust_id=cust_id)
            LEFT OUTER JOIN invchead ON ((aropen_docnumber=invchead_invcnumber)
                                   AND (aropen_doctype=''I''))
            LEFT OUTER JOIN cohead ON (invchead_ordernumber=cohead_number)
            LEFT OUTER JOIN cmhead ON ((aropen_docnumber=cmhead_number)
                                   AND (aropen_doctype=''C''))
            LEFT OUTER JOIN arapply ON (((aropen_id=arapply_source_aropen_id)
                             OR (aropen_id=arapply_target_aropen_id))
                             AND (arapply_distdate>COALESCE(<? value("asofDate") ?>,current_date)))
            LEFT OUTER JOIN payaropen ON (payaropen_aropen_id=aropen_id)
            LEFT OUTER JOIN ccpay     ON (payaropen_ccpay_id=ccpay_id)
            LEFT OUTER JOIN ccard     ON (ccpay_ccard_id=ccard_id)
WHERE ((true)
<? if not exists("showClosed") ?>
  AND (aropen_docdate <= COALESCE(<? value("asofDate") ?>, current_date))
  AND (COALESCE(aropen_closedate, DATE(<? value("asofDate") ?>) + 1, current_date + 1) > COALESCE(<? value("asofDate") ?>, current_date)) 
<? endif ?>
<? if exists("debitsOnly") ?>
  AND   (aropen_doctype IN (''D'',''I''))
<? elseif exists("creditsOnly") ?>
  AND   (aropen_doctype IN (''C'', ''R''))
<? endif ?>
<? if exists("cust_id") ?>
  AND   (aropen_cust_id=<? value("cust_id") ?>)
<? endif ?>
<? if exists("custtype_id") ?>
  AND   (custtype_id=<? value("custtype_id") ?>)
<? endif ?>
<? if exists("custgrp_id") ?>
  AND   (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)
<? endif ?>
<? if exists("custtype_pattern") ?>
  AND   (custtype_code~<? value("custtype_pattern") ?>)
<? endif ?>
<? if exists("startDate") ?>
  AND   (aropen_docdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
<? if exists("startDueDate") ?>
  AND   (aropen_duedate >= <? value("startDueDate") ?>)
<? endif ?>
<? if exists("endDueDate") ?>
  AND   (aropen_duedate <= <? value("endDueDate") ?>)
<? endif ?>
      )
  GROUP BY id,                      altId,	            invchead_id,
           aropen_docdate,          aropen_duedate,         aropen_doctype,         
           aropen_docnumber,        aropen_amount,          
           aropen_notes,            aropen_posted,          aropen_ordernumber,
           aropen_paid,             aropen_open,            aropen_curr_id,
           aropen_closedate,        aropen_curr_rate,       cmhead_id,
           cust_id, 		    cust_number,            cust_name,
           cohead_id,               ccpay_id,               ccard_number,
           invchead_recurring_invchead_id
UNION
SELECT -1,
       4 AS altId,
       aropen_docnumber AS docnumber,
       -1 AS docnumber_xtidrole,
       NULL AS posted, 
       aropen_docdate AS docdate,
       NULL AS aropen_duedate,
       CAST(incdt_number AS text) AS ordernumber,
       incdt_id AS ordernumber_xtidrole,
       NULL AS doctype,
       NULL AS doctype_qtforegroundrole,
       NULL AS amount,
       NULL AS base_amount,
       NULL AS paid,
       NULL AS base_paid,
       NULL AS balance,
       NULL AS currAbbr,
       NULL AS base_balance,
       NULL AS f_docdate,
       NULL AS f_duedate,
       NULL AS f_amount,
       NULL AS f_paid,
       NULL AS f_balance,
       NULL,incdt_assigned_username, incdt_summary,
       NULL AS recurring, NULL AS open,
       NULL AS ccard_number,
       ''curr'' AS amount_xtnumericrole,
       ''curr'' AS base_amount_xtnumericrole,
       0 AS base_amount_xttotalrole,
       ''curr'' AS paid_xtnumericrole,
       ''curr'' AS base_paid_xtnumericrole,
       0 AS base_paid_xttotalrole,
       ''curr'' AS balance_xtnumericrole,
       ''curr'' AS base_balance_xtnumericrole,
       0 AS base_balance_xttotalrole,
       '''' AS aropen_docnumber_qtdisplayrole,
       '''' AS aropen_docdate_qtdisplayrole,
       1 AS xtindentrole,
       CASE WHEN ((COALESCE(aropen_duedate,current_date) < current_date) AND COALESCE(aropen_open,FALSE)) THEN ''error'' 
       END AS aropen_duedate_qtforegroundrole,
       NULL::integer AS ccard_xtidrole,
       firstLine(incdt_descrip) AS notes
FROM incdt JOIN aropen ON (aropen_id=incdt_aropen_id)
           JOIN custinfo ON (aropen_cust_id=cust_id)
           JOIN custtype ON (cust_custtype_id=custtype_id)
	   LEFT OUTER JOIN custgrpitem ON (custgrpitem_cust_id=cust_id)
WHERE ((true)
<? if not exists("showClosed") ?>
  AND (aropen_docdate <= COALESCE(<? value("asofDate") ?>, current_date))
  AND (COALESCE(aropen_closedate, DATE(<? value("asofDate") ?>) + 1, current_date + 1) > COALESCE(<? value("asofDate") ?>, current_date)) 
<? endif ?>
<? if exists("debitsOnly") ?>
  AND   (NOT aropen_doctype IN (''C'', ''R''))
<? endif ?>
<? if exists("creditsOnly") ?>
  AND   (aropen_doctype IN (''C'', ''R''))
<? endif ?>
<? if exists("cust_id") ?>
  AND   (aropen_cust_id=<? value("cust_id") ?>)
<? endif ?>
<? if exists("custtype_id") ?>
  AND   (custtype_id=<? value("custtype_id") ?>)
<? endif ?>
<? if exists("custtype_pattern") ?>
  AND   (custtype_code~<? value("custtype_pattern") ?>)
<? endif ?>
<? if exists("custgrp_id") ?>
  AND   (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)
<? endif ?>
<? if exists("startDate") ?>
  AND   (aropen_docdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
<? if exists("startDueDate") ?>
  AND   (aropen_duedate >= <? value("startDueDate") ?>)
<? endif ?>
<? if exists("endDueDate") ?>
  AND   (aropen_duedate <= <? value("endDueDate") ?>)
<? endif ?>
      )

ORDER BY
  docdate DESC, docnumber DESC, xtindentrole
;
<? endif ?>
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (46, 'checkRegister', 'detail', 'used by dspCheckRegister and viewCheckRun; shows all the checks for a given date range, bank account, check number(optional), and recipient(optional), optionally restricted to ''new'' (un-posted/replaced/deleted) checks for viewing check runs. fills in the check item detail if showDetail is passed. Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: checkRegister
-- Name: detail
-- Notes: used by dspCheckRegister and viewCheckRun;
--        shows all the checks for a given date range, bank account, 
--        check number(optional), and recipient(optional), optionally restricted
--        to ''new'' (un-posted/replaced/deleted) checks for viewing check runs.
--        fills in the check item detail if showDetail is passed.
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT checkhead_id AS checkid,
       CASE WHEN(checkhead_void) THEN -1
            WHEN(checkhead_posted) THEN 1
            ELSE 0
       END AS extra,
       -1 AS checkitem_id,
       checkhead_void, checkhead_misc,
       checkhead_printed, checkhead_posted,
       CASE when checkhead_number = -1 THEN
         ''Unspecified''
       ELSE TEXT(checkhead_number) END AS number,
       COALESCE((SELECT checkrecip_number || ''-'' || checkrecip_name
                 FROM checkrecip
                 WHERE ((checkhead_recip_id=checkrecip_id)
		   AND  (checkhead_recip_type=checkrecip_type)))
                ,
		checkhead_recip_type || ''-'' || checkhead_recip_id ) AS description,
       checkhead_checkdate AS checkdate,
       checkhead_amount AS amount, 
       checkhead_amount / checkhead_curr_rate AS base_amount, 
       currConcat(checkhead_curr_id) AS currAbbr,
       checkhead_number,
       checkhead_ach_batch,
       1 AS orderby,
       ''curr'' AS amount_xtnumericrole,
       ''curr'' AS base_amount_xtnumericrole,
       NULL AS checkhead_void_qtdisplayrole,    NULL AS checkhead_misc_qtdisplayrole,
       NULL AS checkhead_printed_qtdisplayrole, NULL AS checkhead_posted_qtdisplayrole,
       0 AS xtindentrole
  FROM checkhead
 WHERE ((checkhead_bankaccnt_id=<? value("bankaccnt_id") ?>)
   <? if exists("startDate") ?>
     AND (checkhead_checkdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
   <? elseif exists("newOnly") ?>
     AND (NOT checkhead_posted)
     AND (NOT checkhead_replaced)
     AND (NOT checkhead_deleted)
   <? endif ?>
   <? if exists("check_number") ?>
      AND   (CAST(checkhead_number AS text) ~ <? value("check_number") ?>)
   <? endif ?>
   <? if exists("recip") ?>
      <? if exists("recip_type_v") ?>
         AND   (checkhead_recip_type = ''V'' )
      <? endif ?>
      <? if exists("recip_type_c") ?>
         AND   (checkhead_recip_type = ''C'' )
      <? endif ?>
      <? if exists("recip_type_t") ?>
         AND   (checkhead_recip_type = ''T'' )
      <? endif ?>
      <? if exists("recip_id") ?>
         AND   (checkhead_recip_id = <? value("recip_id") ?> )
      <? endif ?>
   <? endif ?>
   <? if exists("vend_id") ?>
     AND (checkhead_recip_type = ''V'')
     AND (checkhead_recip_id = <? value("vend_id") ?>)
   <? elseif exists("vendtype_id") ?>
     AND (checkhead_recip_type = ''V'')
     AND (checkhead_recip_id IN (SELECT vend_id
                                 FROM vendinfo
                                 WHERE (vend_vendtype_id=<? value("vendtype_id") ?>)))
   <? elseif exists("vendtype_pattern") ?>
     AND (checkhead_recip_type = ''V'')
     AND (checkhead_recip_id IN (SELECT vend_id
                                 FROM vendinfo, vendtype
                                 WHERE  (vend_vendtype_id=vendtype_id)
                                   AND  (vendtype_code ~ <? value("vendtype_pattern") ?>)))
   <? endif ?>
)
<? if exists("showDetail") ?>
UNION
SELECT checkitem_checkhead_id AS checkid, 0 AS extra, checkitem_id,
       checkhead_void, checkhead_misc,
       checkhead_printed, checkhead_posted,
       (CASE apopen_doctype WHEN ''V'' THEN <? value("voucher") ?>
                            WHEN ''D'' THEN <? value("debitMemo") ?>
                            WHEN ''C'' THEN <? value("creditMemo") ?>
                            ELSE ''''
        END || ''-'' || CAST(COALESCE(checkitem_ranumber, checkitem_vouchernumber) AS TEXT)) AS number,
       CAST(COALESCE(checkitem_invcnumber, checkitem_cmnumber) AS TEXT) AS description,
       CAST(NULL AS DATE) AS checkdate,
       checkitem_amount AS amount,
       currtobase(checkhead_curr_id,checkitem_amount,checkhead_checkdate) AS base_amount, 
       currConcat(checkitem_curr_id) AS currAbbr, 
       checkhead_number, 
       NULL AS checkhead_ach_batch,
       2 AS orderby,
       ''curr'' AS amount_xtnumericrole,
       ''curr'' AS base_amount_xtnumericrole,
       '''' AS checkhead_void_qtdisplayrole,    '''' AS checkhead_misc_qtdisplayrole,
       '''' AS checkhead_printed_qtdisplayrole, '''' AS checkhead_posted_qtdisplayrole,
       1 AS xtindentrole
  FROM checkhead JOIN checkitem ON (checkitem_checkhead_id=checkhead_id)
                 LEFT OUTER JOIN apopen ON (apopen_id=checkitem_apopen_id)
 WHERE ((checkhead_bankaccnt_id=<? value("bankaccnt_id") ?>)
   <? if exists("startDate") ?>
     AND   (checkhead_checkdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
   <? elseif exists("newOnly") ?>
     AND (NOT checkhead_posted)
     AND (NOT checkhead_replaced)
     AND (NOT checkhead_deleted)
   <? endif ?>
   <? if exists("check_number") ?>
      AND   (CAST(checkhead_number AS text) ~ <? value("check_number") ?>)
   <? endif ?>
   <? if exists("recip") ?>
      <? if exists("recip_type_v") ?>
         AND   (checkhead_recip_type = ''V'' )
      <? endif ?>
      <? if exists("recip_type_c") ?>
         AND   (checkhead_recip_type = ''C'' )
      <? endif ?>
      <? if exists("recip_type_t") ?>
         AND   (checkhead_recip_type = ''T'' )
      <? endif ?>
      <? if exists("recip_id") ?>
         AND   (checkhead_recip_id = <? value("recip_id") ?> )
      <? endif ?>
   <? endif ?>
   <? if exists("vend_id") ?>
     AND (checkhead_recip_type = ''V'')
     AND (checkhead_recip_id = <? value("vend_id") ?>)
   <? elseif exists("vendtype_id") ?>
     AND (checkhead_recip_type = ''V'')
     AND (checkhead_recip_id IN (SELECT vend_id
                                 FROM vendinfo
                                 WHERE (vend_vendtype_id=<? value("vendtype_id") ?>)))
   <? elseif exists("vendtype_pattern") ?>
     AND (checkhead_recip_type = ''V'')
     AND (checkhead_recip_id IN (SELECT vend_id
                                 FROM vendinfo, vendtype
                                 WHERE  (vend_vendtype_id=vendtype_id)
                                   AND  (vendtype_code ~ <? value("vendtype_pattern") ?>)))
   <? endif ?>
   )
<? endif ?>
 ORDER BY checkhead_number, checkid, orderby;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (423, 'contactmerge', 'populate', 'Queries selected contact info Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: contactmerge
-- Name: populate
-- Notes: Queries selected contact info
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT cntct.*,
  crmacct_number,
  crmacct_name,
  addr.*,
  CASE WHEN cntctsel_mrg_first_name THEN ''emphasis'' END AS cntct_first_name_qtforegroundrole,
  CASE WHEN cntctsel_mrg_last_name THEN ''emphasis'' END AS cntct_last_name_qtforegroundrole,
  CASE WHEN cntctsel_mrg_honorific THEN ''emphasis'' END AS cntct_honorific_qtforegroundrole,
  CASE WHEN cntctsel_mrg_initials THEN ''emphasis'' END AS cntct_initials_qtforegroundrole,
  CASE WHEN cntctsel_mrg_phone THEN ''emphasis'' END AS cntct_phone_qtforegroundrole,
  CASE WHEN cntctsel_mrg_phone2 THEN ''emphasis'' END AS cntct_phone2_qtforegroundrole,
  CASE WHEN cntctsel_mrg_fax THEN ''emphasis'' END AS cntct_fax_qtforegroundrole,
  CASE WHEN cntctsel_mrg_email THEN ''emphasis'' END AS cntct_email_qtforegroundrole,
  CASE WHEN cntctsel_mrg_webaddr THEN ''emphasis'' END AS cntct_webaddr_qtforegroundrole,
  CASE WHEN cntctsel_mrg_notes THEN ''emphasis'' END AS cntct_notes_qtforegroundrole,
  CASE WHEN cntctsel_mrg_title THEN ''emphasis'' END AS cntct_title_qtforegroundrole,
  CASE WHEN cntctsel_mrg_middle THEN ''emphasis'' END AS cntct_middle_qtforegroundrole,
  CASE WHEN cntctsel_mrg_suffix THEN ''emphasis'' END AS cntct_suffix_qtforegroundrole,
  CASE WHEN cntctsel_mrg_owner_username THEN ''emphasis'' END AS cntct_owner_username_qtforegroundrole,
  CASE WHEN cntctsel_mrg_crmacct_id THEN ''emphasis'' END AS crmacct_number_qtforegroundrole,
  CASE WHEN cntctsel_mrg_crmacct_id THEN ''emphasis'' END AS crmacct_name_qtforegroundrole,
  CASE WHEN cntctsel_mrg_addr_id THEN ''emphasis'' END AS addr_line1_qtforegroundrole,
  CASE WHEN cntctsel_mrg_addr_id THEN ''emphasis'' END AS addr_line2_qtforegroundrole,
  CASE WHEN cntctsel_mrg_addr_id THEN ''emphasis'' END AS addr_line3_qtforegroundrole,
  CASE WHEN cntctsel_mrg_addr_id THEN ''emphasis'' END AS addr_city_qtforegroundrole,
  CASE WHEN cntctsel_mrg_addr_id THEN ''emphasis'' END AS addr_state_qtforegroundrole,
  CASE WHEN cntctsel_mrg_addr_id THEN ''emphasis'' END AS addr_postalcode_qtforegroundrole,
  CASE WHEN cntctsel_mrg_addr_id THEN ''emphasis'' END AS addr_country_qtforegroundrole,
  CASE WHEN cntctsel_mrg_addr_id THEN ''emphasis'' END AS addr_notes_qtforegroundrole,
  CASE WHEN cntctsel_mrg_addr_id THEN ''emphasis'' END AS addr_number_qtforegroundrole
FROM cntctsel
  JOIN cntct ON (cntctsel_cntct_id=cntct_id)
  LEFT OUTER JOIN addr ON (cntct_addr_id=addr_id)
  LEFT OUTER JOIN crmacct ON (cntct_crmacct_id=crmacct_id)
WHERE (cntctsel_target=<? value("target") ?>);
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (242, 'customers', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: customers
-- Name:  detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT DISTINCT ON ( cust_number ) 
  cust_id, cust_custtype_id, 
  cust_active, cust_number, cust_name,
  custtype_code,
  bill_cntct.cntct_first_name AS bill_first_name,
  bill_cntct.cntct_last_name AS bill_last_name,
  bill_cntct.cntct_title AS bill_title,
  bill_cntct.cntct_phone AS bill_phone,
  bill_cntct.cntct_fax AS bill_fax,
  bill_cntct.cntct_email AS bill_email,
  bill_addr.addr_line1 AS bill_line1,
  bill_addr.addr_line2 AS bill_line2,
  bill_addr.addr_line3 AS bill_line3,
  bill_addr.addr_city AS bill_city,
  bill_addr.addr_state AS bill_state,
  bill_addr.addr_postalcode AS bill_postalcode,
  bill_addr.addr_country AS bill_country,
  corr_cntct.cntct_first_name AS corr_first_name,
  corr_cntct.cntct_last_name AS corr_last_name,
  corr_cntct.cntct_phone AS corr_phone,
  corr_cntct.cntct_fax AS corr_fax,
  corr_cntct.cntct_email AS corr_email,
  corr_addr.addr_line1 AS corr_line1,
  corr_addr.addr_line2 AS corr_line2,
  corr_addr.addr_line3 AS corr_line3,
  corr_addr.addr_city AS corr_city,
  corr_addr.addr_state AS corr_state,
  corr_addr.addr_postalcode AS corr_postalcode,
  corr_addr.addr_country AS corr_country
<? foreach("char_id_text_list") ?>
  , charass_alias<? literal("char_id_text_list") ?>.charass_value AS char<? literal("char_id_text_list") ?>
<? endforeach ?>
<? foreach("char_id_list_list") ?>
  , charass_alias<? literal("char_id_list_list") ?>.charass_value AS char<? literal("char_id_list_list") ?>
<? endforeach ?>
<? foreach("char_id_date_list") ?>
  , charass_alias<? literal("char_id_date_list") ?>.charass_value::date AS char<? literal("char_id_date_list") ?>
<? endforeach ?>
FROM custinfo
  JOIN custtype ON (cust_custtype_id=custtype_id)
  LEFT OUTER JOIN cntct bill_cntct ON (cust_cntct_id=bill_cntct.cntct_id) 
  LEFT OUTER JOIN addr bill_addr ON (bill_cntct.cntct_addr_id=bill_addr.addr_id)
  LEFT OUTER JOIN cntct corr_cntct ON (cust_corrcntct_id=corr_cntct.cntct_id) 
  LEFT OUTER JOIN addr corr_addr ON (corr_cntct.cntct_addr_id=corr_addr.addr_id)
<? foreach("char_id_text_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_text_list") ?> ON ((charass_alias<? literal("char_id_text_list") ?>.charass_target_type=''C'') 
                                                                    AND  (charass_alias<? literal("char_id_text_list") ?>.charass_target_id=cust_id)
                                                                    AND  (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=<? value("char_id_text_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_text_list") ?> ON (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=char_alias<? literal("char_id_text_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_list_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_list_list") ?> ON ((charass_alias<? literal("char_id_list_list") ?>.charass_target_type=''C'') 
                                                                    AND  (charass_alias<? literal("char_id_list_list") ?>.charass_target_id=cust_id)
                                                                    AND  (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=<? value("char_id_list_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_list_list") ?> ON (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=char_alias<? literal("char_id_list_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_date_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_date_list") ?> ON ((charass_alias<? literal("char_id_date_list") ?>.charass_target_type=''C'') 
                                                                    AND  (charass_alias<? literal("char_id_date_list") ?>.charass_target_id=cust_id)
                                                                    AND  (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=<? value("char_id_date_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_date_list") ?> ON (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=char_alias<? literal("char_id_date_list") ?>.char_id)
<? endforeach ?>
WHERE true
<? if not exists("showInactive") ?> 
  AND cust_active 
<? endif ?>
<? if exists("search_pattern") ?>
  AND ((cust_number ~* <? value("search_pattern") ?>)
       OR (cust_name ~* <? value("search_pattern") ?>)
       OR (custtype_code ~* <? value("search_pattern") ?>)
       OR (COALESCE(bill_cntct.cntct_first_name,'''') || '' '' || COALESCE(bill_cntct.cntct_last_name,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(bill_cntct.cntct_phone,'''') || '' '' || COALESCE(bill_cntct.cntct_phone2,'''') || '' '' || COALESCE(bill_cntct.cntct_fax, '''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(bill_cntct.cntct_email, '''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(bill_addr.addr_line1,'''') || '' '' || COALESCE(bill_addr.addr_line2,'''') || '' '' || COALESCE(bill_addr.addr_line3,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(bill_addr.addr_city,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(bill_addr.addr_state,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(bill_addr.addr_postalcode,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(bill_addr.addr_country,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(corr_cntct.cntct_first_name,'''') || '' '' || COALESCE(corr_cntct.cntct_last_name,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(corr_cntct.cntct_phone,'''') || '' '' || COALESCE(corr_cntct.cntct_phone2,'''') || '' '' || COALESCE(corr_cntct.cntct_fax, '''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(corr_cntct.cntct_email, '''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(corr_addr.addr_line1,'''') || '' '' || COALESCE(corr_addr.addr_line2,'''') || '' '' || COALESCE(corr_addr.addr_line3,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(corr_addr.addr_city,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(corr_addr.addr_state,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(corr_addr.addr_postalcode,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(corr_addr.addr_country,'''') ~* <? value("search_pattern") ?>))
<? endif ?>
<? if exists("cust_number_pattern") ?>
  AND (cust_number ~* <? value("cust_number_pattern") ?>)
<? endif ?>
<? if exists("cust_name_pattern") ?>
  AND (cust_name ~* <? value("cust_name_pattern") ?>)
<? endif ?>
<? if exists("custtype_code_pattern") ?>
  AND (custtype_code ~* <? value("custtype_code_pattern") ?>)
<? endif ?>
<? if exists("cntct_name_pattern") ?>
  AND (COALESCE(bill_cntct.cntct_first_name,'''') || '' '' || COALESCE(bill_cntct.cntct_last_name, '''') ~* <? value("cntct_name_pattern") ?> 
   OR  COALESCE(corr_cntct.cntct_first_name,'''') || '' '' || COALESCE(corr_cntct.cntct_last_name, '''') ~* <? value("cntct_name_pattern") ?>)
<? endif ?>
<? if exists("cntct_phone_pattern") ?>
  AND (COALESCE(bill_cntct.cntct_phone,'''') || '' '' || COALESCE(bill_cntct.cntct_phone2,'''') || '' '' || COALESCE(bill_cntct.cntct_fax,'''') ~* <? value("cntct_phone_pattern") ?>
   OR  COALESCE(corr_cntct.cntct_phone,'''') || '' '' || COALESCE(corr_cntct.cntct_phone2,'''') || '' '' || COALESCE(corr_cntct.cntct_fax,'''') ~* <? value("cntct_phone_pattern") ?>)
<? endif ?>
<? if exists("cntct_email_pattern") ?>
  AND (COALESCE(bill_cntct.cntct_email,'''') ~* <? value("cntct_email_pattern") ?>
   OR  COALESCE(corr_cntct.cntct_email,'''') ~* <? value("cntct_email_pattern") ?>)
<? endif ?>
<? if exists("addr_street_pattern") ?>
  AND (COALESCE(bill_addr.addr_line1,'''') || '' '' || COALESCE(bill_addr.addr_line2,'''') || '' '' || COALESCE(bill_addr.addr_line3,'''') ~* <? value("addr_street_pattern") ?>
   OR  COALESCE(corr_addr.addr_line1,'''') || '' '' || COALESCE(corr_addr.addr_line2,'''') || '' '' || COALESCE(corr_addr.addr_line3,'''') ~* <? value("addr_street_pattern") ?>)
<? endif ?>
<? if exists("addr_city_pattern") ?>
  AND (COALESCE(bill_addr.addr_city,'''') ~* <? value("addr_city_pattern") ?>
   OR  COALESCE(corr_addr.addr_city,'''') ~* <? value("addr_city_pattern") ?>)
<? endif ?>
<? if exists("addr_state_pattern") ?>
  AND (COALESCE(bill_addr.addr_state,'''') ~* <? value("addr_state_pattern") ?>
   OR  COALESCE(corr_addr.addr_state,'''') ~* <? value("addr_state_pattern") ?>)
<? endif ?>
<? if exists("addr_postalcode_pattern") ?>
  AND (COALESCE(bill_addr.addr_postalcode,'''') ~* <? value("addr_postalcode_pattern") ?>
   OR  COALESCE(corr_addr.addr_postalcode,'''') ~* <? value("addr_postalcode_pattern") ?>)
<? endif ?>
<? if exists("addr_country_pattern") ?>
  AND (COALESCE(bill_addr.addr_country,'''') ~* <? value("addr_country_pattern") ?>
   OR  COALESCE(corr_addr.addr_country,'''') ~* <? value("addr_country_pattern") ?>)
<? endif ?>
<? if exists("salesrep_id") ?>
  AND (cust_salesrep_id = <? value("salesrep_id") ?>)
<? endif ?>
<? literal("charClause") ?>
ORDER BY cust_number; 
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (120, 'updateprices', 'add', ' Notes: Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: updateprices
-- Name: add
-- Notes:
-- Notes:
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

  INSERT INTO selsched
<? if exists("ipshead_id") ?>
  VALUES (<? value("ipshead_id") ?>);
<? else ?>
  SELECT ipshead_id
  FROM ipshead
  WHERE ( (ipshead_id NOT IN (
  	SELECT selsched_ipshead_id
  	FROM selsched
  	WHERE (selsched_ipshead_id=ipshead_id)))
<? if not exists("showEffective") ?>
  AND (ipshead_effective <= CURRENT_DATE)
<? endif ?>
<? if not exists("showExpired") ?>
  AND (ipshead_expires > CURRENT_DATE)
<? endif ?>
<? if not exists("showCurrent") ?>
  AND (CURRENT_DATE NOT BETWEEN ipshead_effective AND ipshead_expires -1)
<? endif ?>
 );

', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (445, 'bankrec', 'clearedbalance', 'used by reconcileBankaccount Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: bankrec
-- Name: clearedbalance
-- Notes: used by reconcileBankaccount
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT (COALESCE(SUM(amount),0.0) + <? value("begBal") ?>) AS cleared_amount,
       <? value("endBal") ?> AS end_amount,
       (<? value("endBal") ?> - (<? value("begBal") ?> + (COALESCE(SUM(amount),0.0)))) AS diff_amount,
       round(<? value("endBal") ?> - (<? value("begBal") ?> + COALESCE(SUM(amount),0.0)), 2) AS diff_value
  FROM ( SELECT CASE WHEN (gltrans_amount > 0) THEN bankrecitem_amount * -1.0
                     ELSE bankrecitem_amount END AS amount
           FROM bankaccnt, gltrans, bankrecitem
          WHERE ((gltrans_accnt_id=bankaccnt_accnt_id)
            AND (bankrecitem_source=''GL'')
            AND (bankrecitem_source_id=gltrans_id)
            AND (bankrecitem_bankrec_id=<? value("bankrecid") ?>)
            AND (bankrecitem_cleared)
            AND (NOT gltrans_rec)
            AND (bankaccnt_id=<? value("bankaccntid") ?>) ) 
          UNION ALL
         SELECT CASE WHEN (sltrans_amount > 0) THEN bankrecitem_amount * -1.0
                     ELSE bankrecitem_amount END AS amount
           FROM bankaccnt, sltrans, bankrecitem
          WHERE ((sltrans_accnt_id=bankaccnt_accnt_id)
            AND (bankrecitem_source=''SL'')
            AND (bankrecitem_source_id=sltrans_id)
            AND (bankrecitem_bankrec_id=<? value("bankrecid") ?>)
            AND (bankrecitem_cleared)
            AND (NOT sltrans_rec)
            AND (bankaccnt_id=<? value("bankaccntid") ?>) )
          UNION ALL
         SELECT CASE WHEN(bankadjtype_iscredit=true) THEN (bankadj_amount * -1) ELSE bankadj_amount END AS amount
           FROM bankadj, bankadjtype, bankrecitem
          WHERE ( (bankrecitem_source=''AD'')
            AND (bankrecitem_source_id=bankadj_id)
            AND (bankrecitem_bankrec_id=<? value("bankrecid") ?>)
            AND (bankrecitem_cleared)
            AND (bankadj_bankadjtype_id=bankadjtype_id)
            AND (NOT bankadj_posted)
            AND (bankadj_bankaccnt_id=<? value("bankaccntid") ?>) ) ) AS data;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (45, 'cashReceipts', 'detail', 'used by dspCashReceipts There are 2 display modes for this query: 1) Legacy mode which uses A/R Application information 2) Version 3.3.0 upgrade mode which uses Cash Receipt information Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: cashReceipts
-- Name: detail
-- Notes: used by dspCashReceipts
-- There are 2 display modes for this query:
-- 1) Legacy mode which uses A/R Application information
-- 2) Version 3.3.0 upgrade mode which uses Cash Receipt information
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

<? if exists("LegacyDisplayMode") ?>

-- Posted cash receipts
SELECT arapply_id, 1 AS type, '''' AS cashrcpt_number, cust_number, cust_name,
       false AS voided, true AS posted, arapply_postdate AS postdate,
       ( CASE WHEN (arapply_source_doctype=''C'') THEN <? value("creditMemo") ?>
              WHEN (arapply_source_doctype=''R'') THEN <? value("cashdeposit") ?>
              WHEN (arapply_fundstype=''C'') THEN <? value("check") ?>
              WHEN (arapply_fundstype=''T'') THEN <? value("certifiedCheck") ?>
              WHEN (arapply_fundstype=''M'') THEN <? value("masterCard") ?>
              WHEN (arapply_fundstype=''V'') THEN <? value("visa") ?>
              WHEN (arapply_fundstype=''A'') THEN <? value("americanExpress") ?>
              WHEN (arapply_fundstype=''D'') THEN <? value("discoverCard") ?>
              WHEN (arapply_fundstype=''R'') THEN <? value("otherCreditCard") ?>
              WHEN (arapply_fundstype=''K'') THEN <? value("cash") ?>
              WHEN (arapply_fundstype=''W'') THEN <? value("wireTransfer") ?>
              WHEN (arapply_fundstype=''O'') THEN <? value("other") ?>
         END || '' '' ||
         CASE WHEN (arapply_source_doctype IN (''C'',''R'')) THEN TEXT(arapply_source_docnumber)
              ELSE arapply_refnumber
         END ) AS source,
       COALESCE(cashrcptitem_cashrcpt_id,cashrcptmisc_cashrcpt_id,-1) AS source_xtidrole,
       ( CASE WHEN (arapply_target_doctype=''D'') THEN <? value("debitMemo") ?>
              WHEN (arapply_target_doctype=''I'') THEN <? value("invoice") ?>
              ELSE <? value("other") ?>
         END || '' '' || TEXT(arapply_target_docnumber) ) AS target,
       COALESCE(arapply_target_aropen_id,-1) AS target_xtidrole,
       arapply_applied AS applied,
       ''curr'' AS applied_xtnumericrole,
       currtobase(arapply_curr_id,arapply_applied,arapply_postdate) AS base_applied,
<? if exists("includeFormatted") ?>
       formatDate(arapply_postdate) AS f_postdate,
       formatMoney(arapply_applied) AS f_applied,
       formatMoney(currtobase(arapply_curr_id,arapply_applied,arapply_postdate)) AS f_base_applied,
<? endif ?>
       ''curr'' AS base_applied_xtnumericrole,
       0 AS base_applied_xttotalrole,
       currConcat(arapply_curr_id) AS currAbbr,
       arapply_postdate AS sortdate
FROM custinfo LEFT OUTER JOIN custgrpitem ON (custgrpitem_cust_id=cust_id), arapply
  LEFT OUTER JOIN cashrcptitem ON ((arapply_reftype=''CRA'')
                               AND (arapply_ref_id=cashrcptitem_id))
  LEFT OUTER JOIN cashrcptmisc ON ((arapply_reftype=''CRD'')
                               AND (arapply_ref_id=cashrcptmisc_id))
WHERE ( (arapply_cust_id=cust_id)
  AND   (arapply_postdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
  AND   (arapply_source_doctype =''K'')
<? if exists("cust_id") ?>
  AND   (cust_id=<? value("cust_id") ?>)
<? elseif exists("custtype_id") ?>
  AND   (cust_custtype_id=<? value("custtype_id") ?>)
<? elseif exists("custgrp_id") ?>
  AND   (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)
<? elseif exists("custtype_pattern") ?>
  AND   (cust_custtype_id IN (SELECT custtype_id FROM custtype WHERE (custtype_code ~ <? value("custtype_pattern") ?>)))
<? endif ?>
      )

-- Unposted cash receipts
UNION
SELECT cashrcpt_id, 2 AS type, '''' AS cashrcpt_number, cust_number, cust_name,
       false AS voided, false AS posted, cashrcpt_distdate AS postdate,
       ( CASE WHEN (cashrcpt_fundstype=''C'') THEN <? value("check") ?>
              WHEN (cashrcpt_fundstype=''T'') THEN <? value("certifiedCheck") ?>
              WHEN (cashrcpt_fundstype=''M'') THEN <? value("masterCard") ?>
              WHEN (cashrcpt_fundstype=''V'') THEN <? value("visa") ?>
              WHEN (cashrcpt_fundstype=''A'') THEN <? value("americanExpress") ?>
              WHEN (cashrcpt_fundstype=''D'') THEN <? value("discoverCard") ?>
              WHEN (cashrcpt_fundstype=''R'') THEN <? value("otherCreditCard") ?>
              WHEN (cashrcpt_fundstype=''K'') THEN <? value("cash") ?>
              WHEN (cashrcpt_fundstype=''W'') THEN <? value("wireTransfer") ?>
              WHEN (cashrcpt_fundstype=''O'') THEN <? value("other") ?>
         END || '' '' || cashrcpt_docnumber ) AS source,
      cashrcpt_id AS source_xtidrole,
       <? value("unposted") ?> AS target,
       -1 AS target_xtidrole,
       cashrcpt_amount AS applied,
       ''curr'' AS applied_xtnumericrole,
       (cashrcpt_amount / cashrcpt_curr_rate) AS base_applied,
<? if exists("includeFormatted") ?>
       formatDate(cashrcpt_distdate) AS f_postdate,
       formatMoney(cashrcpt_amount) AS f_applied,
       formatMoney(cashrcpt_amount / cashrcpt_curr_rate) AS f_base_applied,
<? endif ?>
       ''curr'' AS base_applied_xtnumericrole,
       0 AS base_applied_xttotalrole,
       currConcat(cashrcpt_curr_id) AS currAbbr,
       cashrcpt_distdate AS sortdate
FROM cashrcpt, custinfo LEFT OUTER JOIN custgrpitem ON (custgrpitem_cust_id=cust_id)
WHERE ( (NOT cashrcpt_posted)
  AND   (cashrcpt_cust_id=cust_id)
  AND   (cashrcpt_distdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? if exists("cust_id") ?>
  AND   (cust_id=<? value("cust_id") ?>)
<? elseif exists("custtype_id") ?>
  AND   (cust_custtype_id=<? value("custtype_id") ?>)
<? elseif exists("custgrp_id") ?>
  AND   (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)
<? elseif exists("custtype_pattern") ?>
  AND   (cust_custtype_id IN (SELECT custtype_id FROM custtype WHERE (custtype_code ~ <? value("custtype_pattern") ?>)))
<? endif ?>
      )

-- Cash Advance
UNION
SELECT aropen_id, 3 AS type, '''' AS cashrcpt_number, cust_number, cust_name,
       false AS voided, true AS posted, aropen_docdate AS postdate,
       ( CASE WHEN (substr(aropen_notes, 16, 1)=''C'') THEN <? value("check") ?>
              WHEN (substr(aropen_notes, 16, 1)=''T'') THEN <? value("certifiedCheck") ?>
              WHEN (substr(aropen_notes, 16, 1)=''M'') THEN <? value("masterCard") ?>
              WHEN (substr(aropen_notes, 16, 1)=''V'') THEN <? value("visa") ?>
              WHEN (substr(aropen_notes, 16, 1)=''A'') THEN <? value("americanExpress") ?>
              WHEN (substr(aropen_notes, 16, 1)=''D'') THEN <? value("discoverCard") ?>
              WHEN (substr(aropen_notes, 16, 1)=''R'') THEN <? value("otherCreditCard") ?>
              WHEN (substr(aropen_notes, 16, 1)=''K'') THEN <? value("cash") ?>
              WHEN (substr(aropen_notes, 16, 1)=''W'') THEN <? value("wireTransfer") ?>
              WHEN (substr(aropen_notes, 16, 1)=''O'') THEN <? value("other") ?>
         END || '' '' ||
         substr(aropen_notes, 18) ) AS source,
       cashrcptitem_cashrcpt_id AS source_xtidrole,
       CASE WHEN aropen_doctype = ''R'' THEN
         <? value("cashdeposit") ?> 
       ELSE <? value("creditMemo") ?> 
       END AS target,
       aropen_id AS target_xtidrole,
       aropen_amount AS applied,
       ''curr'' AS applied_xtnumericrole,
       aropen_amount / aropen_curr_rate AS base_applied,
<? if exists("includeFormatted") ?>
       formatDate(aropen_docdate) AS f_postdate,
       formatMoney(aropen_amount) AS f_applied,
       formatMoney(aropen_amount / aropen_curr_rate) AS f_base_applied,
<? endif ?>
       ''curr'' AS base_applied_xtnumericrole,
       0 AS base_applied_xttotalrole,
       currConcat(aropen_curr_id) AS currAbbr,
       aropen_duedate AS sortdate
FROM custinfo LEFT OUTER JOIN custgrpitem ON (custgrpitem_cust_id=cust_id), aropen
  JOIN cashrcptitem ON (aropen_id=cashrcptitem_aropen_id)
WHERE ( (aropen_cust_id=cust_id)
  AND   (aropen_doctype IN (''R'',''C''))
  AND   (aropen_docdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? if exists("cust_id") ?>
  AND   (cust_id=<? value("cust_id") ?>)
<? elseif exists("custtype_id") ?>
  AND   (cust_custtype_id=<? value("custtype_id") ?>)
<? elseif exists("custgrp_id") ?>
  AND   (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)
<? elseif exists("custtype_pattern") ?>
  AND   (cust_custtype_id IN (SELECT custtype_id FROM custtype WHERE (custtype_code ~ <? value("custtype_pattern") ?>)))
<? endif ?>
      )
ORDER BY sortdate, source;

<? else ?>

--  New Display Mode

SELECT id, type, cashrcpt_number, cust_number, cust_name,
       postdate, posted, voided,
       source, source_xtidrole,
       posted,
       target, target_xtidrole,
       applied,
       base_applied,
<? if exists("includeFormatted") ?>
       formatDate(postdate) AS f_postdate,
       formatMoney(applied) AS f_applied,
       formatMoney(base_applied) AS f_base_applied,
<? endif ?>
       currAbbr,
       sortdate,
       ''curr'' AS applied_xtnumericrole,
       ''curr'' AS base_applied_xtnumericrole,
       base_applied_xttotalrole,
       type AS xtindentrole
FROM (

--  Cash Receipt headers
SELECT cashrcpt_id AS id, 0 AS type, cashrcpt_number, cust_number, cust_name,
       cashrcpt_distdate AS postdate, cashrcpt_posted AS posted, cashrcpt_void AS voided,
       ( CASE WHEN (cashrcpt_fundstype=''C'') THEN <? value("check") ?>
              WHEN (cashrcpt_fundstype=''T'') THEN <? value("certifiedCheck") ?>
              WHEN (cashrcpt_fundstype=''M'') THEN <? value("masterCard") ?>
              WHEN (cashrcpt_fundstype=''V'') THEN <? value("visa") ?>
              WHEN (cashrcpt_fundstype=''A'') THEN <? value("americanExpress") ?>
              WHEN (cashrcpt_fundstype=''D'') THEN <? value("discoverCard") ?>
              WHEN (cashrcpt_fundstype=''R'') THEN <? value("otherCreditCard") ?>
              WHEN (cashrcpt_fundstype=''K'') THEN <? value("cash") ?>
              WHEN (cashrcpt_fundstype=''W'') THEN <? value("wireTransfer") ?>
              WHEN (cashrcpt_fundstype=''O'') THEN <? value("other") ?>
         END || '' '' || cashrcpt_docnumber ) AS source,
       cashrcpt_id AS source_xtidrole,
       CASE WHEN (cashrcpt_void) THEN <? value("voided") ?>
            WHEN (NOT cashrcpt_posted) THEN <? value("unposted") ?>
            ELSE                           ''''
       END AS target,
       -1 AS target_xtidrole,
       cashrcpt_amount AS applied,
       (cashrcpt_amount / cashrcpt_curr_rate) AS base_applied,
       currConcat(cashrcpt_curr_id) AS currAbbr,
       cashrcpt_distdate AS sortdate,
       0 AS base_applied_xttotalrole,
       -1 AS arapply_id
FROM cashrcpt JOIN custinfo ON (cust_id=cashrcpt_cust_id) LEFT OUTER JOIN custgrpitem ON (custgrpitem_cust_id=cust_id)
WHERE ( (cashrcpt_distdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? if exists("cust_id") ?>
  AND   (cust_id=<? value("cust_id") ?>)
<? elseif exists("custtype_id") ?>
  AND   (cust_custtype_id=<? value("custtype_id") ?>)
<? elseif exists("custgrp_id") ?>
  AND   (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)
<? elseif exists("custtype_pattern") ?>
  AND   (cust_custtype_id IN (SELECT custtype_id FROM custtype WHERE (custtype_code ~ <? value("custtype_pattern") ?>)))
<? endif ?>
      )

--  Cash Receipt items
UNION
SELECT cashrcpt_id AS id, 1 AS type, '''', '''', '''',
       cashrcpt_distdate AS postdate, cashrcpt_posted AS posted, cashrcpt_void AS voided,
       '''' AS source,
       cashrcpt_id AS source_xtidrole,
       ( CASE WHEN (aropen_doctype=''D'') THEN <? value("debitMemo") ?>
              WHEN (aropen_doctype=''I'') THEN <? value("invoice") ?>
              WHEN (aropen_doctype=''C'') THEN <? value("creditMemo") ?>
              WHEN (aropen_doctype=''R'') THEN <? value("cashdeposit") ?>
              ELSE <? value("other") ?>
         END || '' '' || TEXT(aropen_docnumber) ) AS target,
       aropen_id AS target_xtidrole,
       COALESCE(arapply_applied, cashrcptitem_amount) AS applied,
       (COALESCE(arapply_applied,cashrcptitem_amount) / cashrcpt_curr_rate) AS base_applied,
       currConcat(cashrcpt_curr_id) AS currAbbr,
       cashrcpt_distdate AS sortdate,
       -1 AS base_applied_xttotalrole,
       arapply_id
FROM cashrcpt JOIN custinfo ON (cust_id=cashrcpt_cust_id)
              LEFT OUTER JOIN custgrpitem ON (custgrpitem_cust_id=cust_id)
              JOIN cashrcptitem ON (cashrcptitem_cashrcpt_id=cashrcpt_id)
              JOIN aropen ON (aropen_id=cashrcptitem_aropen_id)
              LEFT OUTER JOIN arapply ON ((arapply_target_aropen_id=aropen_id OR
                                          arapply_source_aropen_id=aropen_id) AND
                                          arapply_reftype=''CRA'' AND
                                          arapply_ref_id=cashrcptitem_id)
WHERE ( (cashrcpt_distdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? if exists("cust_id") ?>
  AND   (cust_id=<? value("cust_id") ?>)
<? elseif exists("custtype_id") ?>
  AND   (cust_custtype_id=<? value("custtype_id") ?>)
<? elseif exists("custgrp_id") ?>
  AND   (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)
<? elseif exists("custtype_pattern") ?>
  AND   (cust_custtype_id IN (SELECT custtype_id FROM custtype WHERE (custtype_code ~ <? value("custtype_pattern") ?>)))
<? endif ?>
      )

--  Cash Receipt misc
UNION
SELECT cashrcpt_id AS id, 1 AS type, '''', '''', '''',
       cashrcpt_distdate AS postdate, cashrcpt_posted AS posted, cashrcpt_void AS voided,
       '''' AS source,
       cashrcpt_id AS source_xtidrole,
       formatGLAccount(cashrcptmisc_accnt_id) AS target,
       -1 AS target_xtidrole,
       COALESCE(arapply_applied, cashrcptmisc_amount) AS applied,
       (COALESCE(arapply_applied, cashrcptmisc_amount) / cashrcpt_curr_rate) AS base_applied,
       currConcat(cashrcpt_curr_id) AS currAbbr,
       cashrcpt_distdate AS sortdate,
       -1 AS base_applied_xttotalrole,
       arapply_id
FROM cashrcpt JOIN custinfo ON (cust_id=cashrcpt_cust_id)
              LEFT OUTER JOIN custgrpitem ON (custgrpitem_cust_id=cust_id)
              JOIN cashrcptmisc ON (cashrcptmisc_cashrcpt_id=cashrcpt_id)
              LEFT OUTER JOIN arapply ON (arapply_reftype=''CRD'' AND
                                          arapply_ref_id=cashrcptmisc_id)
WHERE ( (cashrcpt_distdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? if exists("cust_id") ?>
  AND   (cust_id=<? value("cust_id") ?>)
<? elseif exists("custtype_id") ?>
  AND   (cust_custtype_id=<? value("custtype_id") ?>)
<? elseif exists("custgrp_id") ?>
  AND   (custgrpitem_custgrp_id=<? value("custgrp_id") ?>)
<? elseif exists("custtype_pattern") ?>
  AND   (cust_custtype_id IN (SELECT custtype_id FROM custtype WHERE (custtype_code ~ <? value("custtype_pattern") ?>)))
<? endif ?>
      )
  ) AS data
ORDER BY sortdate, id, type, target;

<? endif ?>

', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (424, 'contactmerge', 'purge', 'Purge contact(s) that was/were previously merged Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: contactmerge
-- Name: purge
-- Notes: Purge contact(s) that was/were previously merged
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

DELETE FROM cntct WHERE cntct_id IN
(SELECT cntctmrgd_cntct_id
  FROM cntctmrgd
  WHERE (NOT cntctmrgd_error)
<? if exists("cntct_id") ?>
AND (cntctmrgd_cntct_id=<? value("cntct_id") ?>)
<? endif ?>)
AND (NOT cntctUsed(cntct_id));
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (439, 'customers', 'statement', 'used by printStatementsByCustomerType SELECT cust_id, (cust_number || ''-'' || cust_name) AS customer, findCustomerForm(cust_id, ''S'') AS reportname FROM <? if exists("asofDate") ?> (SELECT araging_cust_id FROM araging(<? value ("asofDate") ?>, true))AS data, <? endif ?> custinfo, custtype, aropen WHERE (cust_custtype_id=custtype_id) AND (aropen_cust_id=cust_id) AND (aropen_open) <? if exists("graceDays") ?> AND (aropen_duedate < (CURRENT_DATE - <? value ("graceDays") ?>)) <? endif ?> <? if exists("custtype_id") ?> AND (custtype_id=<? value ("custtype_id") ?>) <? elseif exists("custtype_pattern") ?> AND (custtype_code ~ <? value ("custtype_pattern") ?>) <? endif ?> <? if exists("asofDate") ?> AND (cust_id = araging_cust_id) <? endif ?> GROUP BY cust_id, cust_number, cust_name HAVING (SUM((aropen_amount - aropen_paid) * CASE WHEN (aropen_doctype IN (''C'', ''R'')) THEN -1 ELSE 1 END) > 0) ORDER BY cust_number; Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: customers
-- Name:  statement
-- Notes: used by printStatementsByCustomerType
--SELECT cust_id, (cust_number || ''-'' || cust_name) AS customer,
--       findCustomerForm(cust_id, ''S'') AS reportname
--FROM
--<? if exists("asofDate") ?>
--  (SELECT araging_cust_id FROM araging(<? value ("asofDate") ?>, true))AS data,
--<? endif ?>
--  custinfo, custtype, aropen
--WHERE (cust_custtype_id=custtype_id)
-- AND (aropen_cust_id=cust_id)
-- AND (aropen_open)
--<? if exists("graceDays") ?>
-- AND (aropen_duedate < (CURRENT_DATE - <? value ("graceDays") ?>))
--<? endif ?>
--<? if exists("custtype_id") ?>
-- AND (custtype_id=<? value ("custtype_id") ?>)
--<? elseif exists("custtype_pattern") ?>
-- AND (custtype_code ~ <? value ("custtype_pattern") ?>)
--<? endif ?>
--<? if exists("asofDate") ?>
-- AND (cust_id = araging_cust_id)
--<? endif ?>
--GROUP BY cust_id, cust_number, cust_name
--HAVING (SUM((aropen_amount - aropen_paid) *
--             CASE WHEN (aropen_doctype IN (''C'', ''R'')) THEN -1
--                  ELSE 1 END) > 0)
--ORDER BY cust_number;
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT araging_cust_id AS cust_id,
       (araging_cust_number || ''-'' || araging_cust_name) AS customer,
       findCustomerForm(araging_cust_id, ''S'') AS reportname
FROM araging(<? value ("asofDate") ?>, true)
WHERE (true)
<? if exists("graceDays") ?>
 AND (COALESCE(araging_duedate, startOfTime()) < (CURRENT_DATE - <? value ("graceDays") ?>))
<? endif ?>
<? if exists("custtype_id") ?>
 AND (araging_cust_custtype_id=<? value ("custtype_id") ?>)
<? elseif exists("custtype_pattern") ?>
 AND (araging_custtype_code ~ <? value ("custtype_pattern") ?>)
<? endif ?>
GROUP BY araging_cust_id, araging_cust_number, araging_cust_name
ORDER BY araging_cust_number;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (118, 'distributeInventory', 'locations', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: distributeInventory
-- Name: locations
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT id, type, locationname, defaultlocation,
		        location_netable, lotserial, f_expiration, expired,
                        qty, qtytagged, (qty + qtytagged) AS balance,
                        ''qty'' AS qty_xtnumericrole,
                        ''qty'' AS qtytagged_xtnumericrole,
                        ''qty'' AS balance_xtnumericrole,
                        CASE WHEN expired THEN ''error'' END AS qtforegroundrole, 
                        CASE WHEN expired THEN ''error'' 
                             WHEN defaultlocation AND expired = false THEN ''altemphasis'' 
                        ELSE null END AS defaultlocation_qtforegroundrole, 
                        CASE WHEN expired THEN ''error'' 
                             WHEN qty > 0 AND expired = false THEN ''altemphasis'' 
                        ELSE null END AS qty_qtforegroundrole 
                 FROM ( 
		 <? if exists("cNoIncludeLotSerial") ?>
		 SELECT location_id AS id, <? value("locationType") ?> AS type,
		        formatLocationName(location_id) AS locationname,
		        CASE WHEN (<? value("transtype") ?> = ''R'' AND location_id=itemsite_recvlocation_id) THEN TRUE
		             WHEN (<? value("transtype") ?> = ''I'' AND location_id=itemsite_issuelocation_id) THEN TRUE
		             WHEN (<? value("transtype") ?> = ''O'' AND location_id=itemsite_location_id) THEN TRUE
                             ELSE FALSE
                        END AS defaultlocation,
		        location_netable,
		        TEXT('''') AS lotserial,
		        TEXT(<? value("na") ?>) AS f_expiration, FALSE AS expired,
		        qtyLocation(location_id, NULL, NULL, NULL, itemsite_id, itemlocdist_order_type, itemlocdist_order_id, itemlocdist_id) AS qty,
		        itemlocdistQty(location_id, itemlocdist_id) AS qtytagged 
		 FROM itemlocdist, location, itemsite 
		 WHERE ( (itemlocdist_itemsite_id=itemsite_id)
		  AND (itemsite_loccntrl)
		  AND (itemsite_warehous_id=location_warehous_id)
		  AND (validLocation(location_id, itemsite_id))
		  AND (itemlocdist_id=<? value("itemlocdist_id") ?>) ) 
		 <? elseif exists("cIncludeLotSerial") ?>
		 SELECT itemloc_id AS id, <? value("itemlocType") ?> AS type,
		        COALESCE(formatLocationName(location_id),
		                 <? value("undefined") ?>) AS locationname,
		        (location_id IS NOT NULL AND
		         CASE WHEN (<? value("transtype") ?> = ''R'' AND location_id=itemsite_recvlocation_id) THEN TRUE
		              WHEN (<? value("transtype") ?> = ''I'' AND location_id=itemsite_issuelocation_id) THEN TRUE
   		              WHEN (<? value("transtype") ?> = ''O'' AND location_id=itemsite_location_id) THEN TRUE
                              ELSE FALSE
                         END) AS defaultlocation,
		        COALESCE(location_netable, false) AS location_netable,
		        ls_number AS lotserial,
		        CASE WHEN (itemsite_perishable) THEN formatDate(itemloc_expiration)
		             ELSE <? value("na") ?>
		        END AS f_expiration,
		        CASE WHEN (itemsite_perishable) THEN (itemloc_expiration < CURRENT_DATE)
		             ELSE FALSE 
		        END AS expired,
		        qtyLocation(itemloc_location_id, itemloc_ls_id, itemloc_expiration, itemloc_warrpurc, itemsite_id, itemlocdist_order_type, itemlocdist_order_id, itemlocdist_id) AS qty,
		        ( SELECT COALESCE(SUM(target.itemlocdist_qty), 0)
		          FROM itemlocdist AS target
		          WHERE ( (target.itemlocdist_source_type=''I'')
		           AND (target.itemlocdist_source_id=itemloc_id)
		           AND (target.itemlocdist_itemlocdist_id=source.itemlocdist_id)) ) AS qtytagged 
		 FROM itemlocdist AS source, itemsite, itemloc 
                   LEFT OUTER JOIN location ON (itemloc_location_id=location_id) 
                   LEFT OUTER JOIN ls ON (itemloc_ls_id=ls_id) 
		 WHERE ( (source.itemlocdist_itemsite_id=itemsite_id)
		  AND (itemloc_itemsite_id=itemsite_id)
		  AND (source.itemlocdist_id=<? value("itemlocdist_id") ?>) ) 
		  UNION 
		 SELECT location_id AS id, <? value("locationType") ?> AS type,
		        formatLocationName(location_id) AS locationname,
		        CASE WHEN (<? value("transtype") ?> = ''R'' AND location_id=itemsite_recvlocation_id) THEN TRUE
		             WHEN (<? value("transtype") ?> = ''I'' AND location_id=itemsite_issuelocation_id) THEN TRUE
		             WHEN (<? value("transtype") ?> = ''O'' AND location_id=itemsite_location_id) THEN TRUE
                             ELSE FALSE
                        END AS defaultlocation,
		        location_netable,
		        TEXT('''') AS lotserial,
		        TEXT(<? value("na") ?>) AS f_expiration, FALSE AS expired,
		        qtyLocation(location_id, NULL, NULL, NULL, itemsite_id, itemlocdist_order_type, itemlocdist_order_id, itemlocdist_id) AS qty,
		        itemlocdistQty(location_id, itemlocdist_id) AS qtytagged 
		 FROM itemlocdist, location, itemsite 
		 WHERE ( (itemlocdist_itemsite_id=itemsite_id)
		  AND (itemsite_loccntrl)
		  AND (itemsite_warehous_id=location_warehous_id)
		  AND (validLocation(location_id, itemsite_id))
                  AND (itemsite_id=<? value("itemsite_id") ?> ) 
		  AND (location_id NOT IN (SELECT DISTINCT itemloc_location_id FROM itemloc WHERE (itemloc_itemsite_id=itemsite_id)))
		  AND (itemlocdist_id=<? value("itemlocdist_id") ?>) ) 
		 <? endif ?>
		 ) AS data 
                 WHERE ((TRUE) 
		 <? if exists("showOnlyTagged") ?>
		 AND (qtytagged != 0) 
		 <? endif ?>
                 <? if exists("showQtyOnly") ?>
                 AND (qty > 0) 
                 <? endif ?>
		 ) ORDER BY locationname;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (232, 'billingSelections', 'detail', 'used by dspBillingSelections Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: billingSelections
-- Name: detail
-- Notes: used by dspBillingSelections
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT cobmisc_id, cohead_id,
       cohead_number, cust_number, cust_name,
       sum(round(coitem_price*cobill_qty,2)) AS subtotal,
       cobmisc_misc, cobmisc_freight, calcCobmiscTax(cobmisc_id) AS cobmisc_tax, cobmisc_payment,
       (sum(round(coitem_price * cobill_qty, 2)) +
                  cobmisc_misc + cobmisc_freight +
                  calcCobmiscTax(cobmisc_id)) AS total,
       ''curr'' AS subtotal_xtnumericrole,
       ''curr'' AS total_xtnumericrole,
       ''curr'' AS cobmisc_misc_xtnumericrole,
       ''curr'' AS cobmisc_freight_xtnumericrole,
       ''curr'' AS cobmisc_tax_xtnumericrole,
       ''curr'' AS cobmisc_payment_xtnumericrole
FROM cobmisc, cohead, custinfo, coitem, cobill
WHERE ((cobmisc_cohead_id=cohead_id)
   AND (cohead_cust_id=cust_id)
   AND (coitem_cohead_id=cohead_id)
   AND (cobill_coitem_id=coitem_id)
   AND (NOT cobmisc_posted))
GROUP BY cobmisc_id, cohead_id, cohead_number, cust_number,
         cust_name, cobmisc_misc, cobmisc_freight, cobmisc_tax, cobmisc_payment
ORDER BY cohead_number;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (48, 'creditCards', 'detail', 'used by cashReceipt, customer, salesOrder Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: creditCards
-- Name: detail
-- Notes: used by cashReceipt, customer, salesOrder
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT ccard_id, ccard_seq,
       CASE WHEN (ccard_type=''M'') THEN <? value("masterCard") ?>
            WHEN (ccard_type=''V'') THEN <? value("visa") ?>
            WHEN (ccard_type=''A'') THEN <? value("americanExpress") ?>
            WHEN (ccard_type=''D'') THEN <? value("discover") ?>
            ELSE <? value("other") ?>
       END AS type,
       formatccnumber(decrypt(setbytea(ccard_number),
                              setbytea(<? value("key") ?>), ''bf'')) AS f_number,
       ccard_active,
       formatbytea(decrypt(setbytea(ccard_name),
                           setbytea(<? value("key") ?>), ''bf'')) AS ccard_name,
       formatbytea(decrypt(setbytea(ccard_month_expired),
                           setbytea(<? value("key") ?>), ''bf'')) ||
                   ''-'' ||
                   formatbytea(decrypt(setbytea(ccard_year_expired),
                                       setbytea(<? value("key") ?>),
                                       ''bf'')) AS expiration 
FROM ccard 
WHERE ((ccard_cust_id=<? value("cust_id") ?>) 
<? if exists("ccard_type") ?>
 AND   (ccard_type=<? value("ccard_type") ?>)
<? endif ?>
<? if exists("activeonly") ?>
 AND   (ccard_active)
<? endif ?>
)
ORDER BY ccard_seq;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (50, 'events', 'detail', 'used by eventManager Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: events
-- Name: detail
-- Notes: used by eventManager
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT evntlog_id, evntlog_ord_id, evntlog_newdate,
       evntlog_newvalue, warehous_code,
       evntlog_evnttime,
       evntlog_dispatched,
       evnttype_name, evntlog_number 
  FROM evnttype, evntlog LEFT OUTER JOIN whsinfo ON (evntlog_warehous_id=warehous_id)
WHERE ( (evntlog_evnttype_id=evnttype_id)
 AND (evntlog_username=<? value("username") ?>)
<? if exists("warehous_id") ?>
 AND (warehous_id=<? value("warehous_id") ?>)
<? endif ?>
<? if not exists("showAcknowledged") ?>
 AND (evntlog_dispatched IS NULL)
<? endif ?>
) 
ORDER BY evntlog_evnttime;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (418, 'contactmerge', 'contactused', 'Checks to see if this contact is used anywhere Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: contactmerge
-- Name: contactused
-- Notes: Checks to see if this contact is used anywhere
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT cntctused(<? value("cntct_id") ?>) AS used;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (112, 'costelem', 'unusedbyitem', 'list the cost elements that can be applied to an item that have not already been applied to that item. takes an item_id and type. Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: costelem
-- Name:  unusedbyitem
-- Notes: list the cost elements that can be applied to an item that have
--        not already been applied to that item. takes an item_id and type.
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

<? if exists("item_id") ?>

SELECT costelem_id, costelem_type
FROM costelem
WHERE ((costelem_active)
   AND (NOT costelem_sys
        OR (CASE WHEN fetchMetricBool(''Routings'') AND
                     (<? value("itemtype") ?> IN (''M'', ''F'', ''B'', ''C'', ''T'')) THEN
               costelem_type IN (''Direct Labor'', ''Overhead'', ''Machine Overhead'')
                 WHEN (<? value("itemtype") ?> IN (''O'', ''P'')) THEN
                                                   costelem_type IN (''Material'')
            END))
   AND (costelem_id NOT IN (SELECT itemcost_costelem_id
                            FROM itemcost
                            WHERE ((NOT itemcost_lowlevel)
                               AND (itemcost_item_id=<? value("item_id") ?>))))
      )
ORDER BY costelem_type;

<? elseif exists("bomitem_id") ?>

SELECT costelem_id, costelem_type
FROM costelem
WHERE ((costelem_active)
   AND (NOT costelem_sys
        OR (CASE WHEN fetchMetricBool(''Routings'') AND
                     (<? value("itemtype") ?> IN (''M'', ''F'', ''B'', ''C'', ''T'')) THEN
               costelem_type IN (''Direct Labor'', ''Overhead'', ''Machine Overhead'')
                 WHEN (<? value("itemtype") ?> IN (''O'', ''P'')) THEN
                                                   costelem_type IN (''Material'')
            END))
   AND (costelem_id NOT IN (SELECT bomitemcost_costelem_id
                            FROM bomitemcost
                            WHERE ((NOT bomitemcost_lowlevel)
                               AND (bomitemcost_bomitem_id=<? value("bomitem_id") ?>))))
      )
ORDER BY costelem_type;


<? endif ?>
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (245, 'expiredInventory', 'detail', 'used by dspExpiredInventoryByClassCode Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: expiredInventory
-- Name: detail
-- Notes: used by dspExpiredInventoryByClassCode
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT itemsite_id, itemloc_id, warehous_code, item_number, uom_name,
       ls_number, itemloc_expiration,
       itemloc_qty, costmethod, cost,
       noNeg(cost * itemloc_qty) AS value,
       ''qty'' AS itemloc_qty_xtnumericrole,
       ''cost'' AS cost_xtnumericrole,
       ''curr'' AS value_xtnumericrole,
       ''red'' AS qtforegroundrole 
FROM ( SELECT itemsite_id, itemloc_id, warehous_code, item_number,
              uom_name, ls_number,
              CASE WHEN <? value("expiretype") ?>=''Perishability'' THEN 
                   itemloc_expiration
                ELSE itemloc_warrpurc
              END AS itemloc_expiration,
              itemloc_qty,
              CASE WHEN(itemsite_costmethod=''A'') THEN ''Average''
                   WHEN(itemsite_costmethod=''S'') THEN ''Standard''
                   WHEN(itemsite_costmethod=''J'') THEN ''Job''
                   WHEN(itemsite_costmethod=''N'') THEN ''None''
                ELSE ''UNKNOWN''
              END AS costmethod,
            <? if exists("useStandardCosts") ?>
              stdcost(itemsite_item_id) AS cost
            <? elseif exists("useActualCosts") ?>
              actcost(itemsite_item_id) AS cost
            <? else ?>
              (itemsite_value / CASE WHEN(itemsite_qtyonhand=0) THEN 1 ELSE itemsite_qtyonhand END) AS cost
            <? endif ?>
       FROM itemloc, itemsite, item, whsinfo, uom, ls
       WHERE ((itemloc_itemsite_id=itemsite_id)
          AND (itemsite_item_id=item_id)
          AND (item_inv_uom_id=uom_id)
          AND (itemsite_warehous_id=warehous_id)
          AND (itemloc_ls_id=ls_id)
        <? if exists("perishability") ?>
          AND (itemsite_perishable)
          AND (itemloc_expiration < (CURRENT_DATE + <? value("thresholdDays") ?>))
        <? else ?>
          AND (itemsite_warrpurc)
          AND (itemloc_warrpurc < (CURRENT_DATE + <? value("thresholdDays") ?>))
        <? endif ?>
        <? if exists("warehous_id") ?>
          AND (itemsite_warehous_id=<? value("warehous_id") ?>)
        <? endif ?>
        <? if exists("classcode_id") ?>
          AND (item_classcode_id=<? value("classcode_id") ?>)
        <? elseif exists("classcode_pattern") ?>
          AND (item_classcode_id IN (SELECT classcode_id
                                     FROM classcode
                                     WHERE classcode_code ~ <? value("classcode_pattern") ?>))
        <? endif ?>
             )
     ) AS data
ORDER BY warehous_code, item_number;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (249, 'glseries', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: glseries
-- Name:  detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT *, 
                          CASE WHEN <? literal("table") ?>_id = -1 THEN 0
                          ELSE 1 END AS xtindentrole,
                          CASE WHEN <? literal("table") ?>_id = -1 THEN <? literal("table") ?>_date
                          END AS transdate,   
                          ''curr'' AS debit_xtnumericrole,
                          ''curr'' AS credit_xtnumericrole 
                   FROM (SELECT DISTINCT 
                          <? literal("table") ?>_sequence AS sequence, 
                          -1 AS <? literal("table") ?>_id, 
                          <? literal("table") ?>_date, 
                          <? literal("table") ?>_source AS source, 
                          <? literal("table") ?>_journalnumber AS journalnumber,
                          <? literal("table") ?>_doctype AS doctype, '''' AS docnumber,
                          -1 AS accnt_id, firstLine(<? literal("table") ?>_notes) AS accnt_id_qtdisplayrole,
                          0.0 AS amount,
                          CAST(NULL AS NUMERIC) AS debit,
                          CAST(NULL AS NUMERIC) AS credit,
                          <? literal("table") ?>_posted AS posted 
                   FROM <? literal("table") ?> 
                   WHERE ( (true) 
                   <? if exists("gltrans") ?>
                    AND (NOT gltrans_deleted) 
                   <? endif ?>
                    AND (<? literal("table") ?>_date BETWEEN <? value("startDate") ?>
                                            AND <? value("endDate") ?>)
                   <? if exists("source") ?>
                      AND (<? literal("table") ?>_source=<? value("source") ?>)
                   <? endif ?>
                   <? if exists("startJrnlnum") ?>
                      AND (<? literal("table") ?>_journalnumber BETWEEN <? value("startJrnlnum") ?>
                                                     AND <? value("endJrnlnum") ?>)
                   <? endif ?>
                   ) 
                   UNION ALL 
                   SELECT <? literal("table") ?>_sequence AS sequence, 
                          <? literal("table") ?>_id, 
                          <? literal("table") ?>_date, 
                          NULL, NULL,
                          NULL, <? literal("table") ?>_docnumber AS docnumber,
                          accnt_id, (formatGLAccount(accnt_id) || '' - '' || accnt_descrip) AS accnt_id_qtdisplayrole,
                          <? literal("table") ?>_amount,
                          CASE WHEN (<? literal("table") ?>_amount < 0) THEN (<? literal("table") ?>_amount * -1)
                          END AS debit,
                          CASE WHEN (<? literal("table") ?>_amount > 0) THEN <? literal("table") ?>_amount 
                          END AS credit,
                          NULL AS posted 
                   FROM <? literal("table") ?> JOIN accnt ON (<? literal("table") ?>_accnt_id=accnt_id) 
                   WHERE ( (true) 
                   <? if exists("gltrans") ?>
                    AND (NOT gltrans_deleted) 
                   <? endif ?>
                     AND (<? literal("table") ?>_date BETWEEN <? value("startDate") ?>
                                            AND <? value("endDate") ?>)
                   <? if exists("source") ?>
                      AND (<? literal("table") ?>_source=<? value("source") ?>)
                   <? endif ?>
                   <? if exists("startJrnlnum") ?>
                      AND (<? literal("table") ?>_journalnumber BETWEEN <? value("startJrnlnum") ?>
                                                     AND <? value("endJrnlnum") ?>)
                   <? endif ?>
                    ) 
                   ) AS dummy 
                   ORDER BY sequence,
                            xtindentrole, amount;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (133, 'gltransactions', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: gltransactions
-- Name:  detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT gltrans_id, gltrans_accnt_id,gltrans_date,gltrans_created,gltrans_source,
       gltrans_doctype,gltrans_journalnumber,gltrans_posted,gltrans_username,
       CASE WHEN(gltrans_docnumber=''Misc.'' AND
              invhist_docnumber IS NOT NULL) THEN
              (gltrans_docnumber || '' - '' || invhist_docnumber)
            ELSE gltrans_docnumber
       END AS docnumber,
       firstLine(gltrans_notes) AS notes,
       (formatGLAccount(accnt_id) || '' - '' || accnt_descrip) AS account,
       CASE WHEN (gltrans_amount < 0) THEN ABS(gltrans_amount)
            ELSE NULL
       END AS debit,
       CASE WHEN (gltrans_amount > 0) THEN gltrans_amount
            ELSE NULL
       END AS credit,
       CASE WHEN accnt_type IN (''A'',''E'') THEN 
         gltrans_amount * -1 
       ELSE gltrans_amount END AS running,
       ''curr'' AS debit_xtnumericrole,
       ''curr'' AS credit_xtnumericrole,
       ''curr'' AS running_xtnumericrole,
       0 AS running_xtrunningrole,
       gltrans_deleted AS xtdeletedrole,
<? value("beginningBalance") ?> AS running_xtrunninginit 
FROM gltrans JOIN accnt ON (gltrans_accnt_id=accnt_id) 
     LEFT OUTER JOIN invhist ON (gltrans_misc_id=invhist_id
                            AND gltrans_docnumber=''Misc.'') 
<? if exists("company_id") ?>
     JOIN company ON (accnt_company=company_number) 
<? endif ?>
<? if exists("prfcntr_id") ?>
     JOIN prftcntr ON (accnt_profit=prftcntr_number) 
<? endif ?>
<? if exists("subaccnt_id") ?>
     JOIN subaccnt ON (accnt_sub=subaccnt_number) 
<? endif ?>
<? if exists("subType") ?>
     JOIN subaccnttype ON (subaccnttype_code=accnt_subaccnttype_code) 
<? endif ?>
WHERE (
<? if exists("startDate") ?>
  <? if exists("endDate") ?>
       (gltrans_date BETWEEN <? value("startDate") ?>
                         AND <? value("endDate") ?>)
  <? else ?>
       (gltrans_date BETWEEN <? value("startDate") ?>
                         AND endoftime())
  <? endif ?>
<? else ?>
  <? if exists("endDate") ?>
       (gltrans_date BETWEEN startoftime()
                         AND <? value("endDate") ?>)
  <? else ?>
       (gltrans_date BETWEEN startoftime()
                         AND endoftime())
  <? endif ?>
<? endif ?>
<? if not exists("showDeleted") ?>
   AND (NOT gltrans_deleted)
<? endif ?>
<? if exists("company_id") ?>
   AND (company_id=<? value("company_id") ?>)
<? endif ?>
<? if exists("prfcntr_id") ?>
   AND (prftcntr_id=<? value("prfcntr_id") ?>)
<? endif ?>
<? if exists("accnt_number") ?>
   AND (accnt_number=<? value("accnt_number") ?>)
<? endif ?>
<? if exists("subaccnt_id") ?>
   AND (subaccnt_id=<? value("subaccnt_id") ?>)
<? endif ?>
<? if exists("subType") ?>
   AND (subaccnttype_id=<? value("subType") ?>)
<? endif ?>
<? if exists("accntType") ?>
   AND (accnt_type= <? value("accntType") ?>)
<? endif ?>
<? if exists("accnt_id") ?>
   AND (gltrans_accnt_id=<? value("accnt_id") ?>)
<? endif ?>
<? if exists("docnum") ?>
   AND (gltrans_docnumber = case when <? value("docnum") ?> = '''' then 
 gltrans_docnumber else 
<? value("docnum") ?> end ) 
<? endif ?>
<? if exists("source") ?>
   AND (gltrans_source=<? value("source") ?>)
<? endif ?>
) 
ORDER BY
<? if exists("beginningBalance") ?>
   gltrans_date,
<? else ?>
   gltrans_created DESC,
<? endif ?>
   gltrans_sequence, gltrans_amount;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (47, 'countTags', 'detail', 'used by dspCountTagsByClassCode, dspCountTagsByItem, dspCountTagsByWarehouse Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: countTags
-- Name: detail
-- Notes: used by dspCountTagsByClassCode, dspCountTagsByItem, dspCountTagsByWarehouse
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT invcnt_id, invcnt_tagnumber, warehous_code,
       item_number, (item_descrip1 || item_descrip2) AS item_descrip,
       invcnt_tagdate,
       CASE WHEN invcnt_tagdate IS NOT NULL THEN invcnt_tag_username
       END AS creator,
       invcnt_cntdate,
       CASE WHEN invcnt_cntdate IS NOT NULL THEN invcnt_cnt_username
       END AS counter,
       invcnt_postdate,
       CASE WHEN invcnt_postdate IS NOT NULL THEN invcnt_post_username
       END AS poster,
       CASE WHEN (NOT invcnt_posted) THEN NULL
            ELSE invcnt_qoh_before
       END AS qohbefore,
       invcnt_qoh_after,
       CASE WHEN (NOT invcnt_posted) THEN NULL
            ELSE (invcnt_qoh_after - invcnt_qoh_before)
       END AS variance,
       CASE WHEN (NOT invcnt_posted) THEN NULL
            WHEN ((invcnt_qoh_before = 0) AND (invcnt_qoh_after = 0)) THEN 0
            WHEN (invcnt_qoh_before = 0) THEN 1
            ELSE ((1 - (invcnt_qoh_after / invcnt_qoh_before)) * -1)
       END AS percent,
      ''qty'' AS qohbefore_xtnumericrole,
      ''qty'' AS invcnt_qoh_after_xtnumericrole,
      ''qty'' AS variance_xtnumericrole,
      ''percent'' AS percent_xtnumericrole 
FROM invcnt, itemsite, item, whsinfo
WHERE ((invcnt_itemsite_id=itemsite_id)
  AND  (itemsite_item_id=item_id)
  AND  (itemsite_warehous_id=warehous_id)
  AND  (DATE(invcnt_tagdate) BETWEEN <? value("startDate") ?>
                                 AND <? value("endDate") ?>)
<? if not exists("showUnposted") ?>
  AND  invcnt_posted
<? endif ?>
<? if exists("warehous_id") ?>
  AND  (itemsite_warehous_id=<? value("warehous_id") ?>)
<? endif ?>
<? if exists("classcode_id") ?>
  AND  (item_classcode_id=<? value("classcode_id") ?>)
<? elseif exists("classcode_pattern") ?>
  AND  (item_classcode_id IN (SELECT classcode_id
                             FROM classcode
                             WHERE (classcode_code ~ <? value("classcode_pattern") ?>)))
<? endif ?>
<? if exists("item_id") ?>
  AND  (item_id=<? value("item_id") ?>)
<? endif ?>
)
ORDER BY invcnt_tagdate;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (49, 'creditMemoCreditCards', 'detail', 'used by arWorkBench, returnAuthorization, returnAuthorizationWorkbench Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: creditMemoCreditCards
-- Name: detail
-- Notes: used by arWorkBench, returnAuthorization, returnAuthorizationWorkbench
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT cmhead_number, cmhead_freight, cmhead_curr_id,
       SUM(ROUND((cmitem_qtycredit * cmitem_qty_invuomratio) * 
                 (cmitem_unitprice / cmitem_price_invuomratio), 2)) +
       cmhead_freight + cmhead_misc +
       COALESCE( (SELECT SUM(tax) * -1 AS tax FROM
                 (SELECT ROUND(SUM(taxdetail_tax), 2) AS tax
                  FROM tax
                   JOIN calculateTaxDetailSummary(''CM'', <? value("cmhead_id") ?>, ''T'') ON (taxdetail_tax_id=tax_id)
                  GROUP BY tax_id) AS data), 0) AS total,
       COALESCE( (SELECT SUM(tax) * -1 AS tax FROM
                 (SELECT ROUND(SUM(taxdetail_tax), 2) AS tax
                  FROM tax
                   JOIN calculateTaxDetailSummary(''CM'', <? value("cmhead_id") ?>, ''T'') ON (taxdetail_tax_id=tax_id)
                  GROUP BY tax_id) AS data), 0) AS tax_in_cmcurr,
       ccard_id, ccard_seq, ccpay_id,
       cohead_number
FROM ccard, cmitem, cmhead LEFT OUTER JOIN
     rahead ON (cmhead_rahead_id=rahead_id) LEFT OUTER JOIN
     cohead ON (rahead_orig_cohead_id=cohead_id) LEFT OUTER JOIN
     ccpay  ON (ccpay_order_number=cohead_number AND ccpay_type=''C'')
WHERE ((cmitem_cmhead_id=cmhead_id)
  AND  (cmhead_cust_id=ccard_cust_id)
  AND  (ccard_active)
  AND  (ccpay_ccard_id=ccard_id OR ccpay_ccard_id IS NULL)
  AND  (cmhead_id=<? value("cmhead_id") ?>))
GROUP BY cmhead_number, cmhead_curr_id, cmhead_freight,
         cmhead_misc, ccard_id, ccard_seq, ccpay_id,
	 cohead_number
ORDER BY ccpay_id DESC, ccard_seq 
LIMIT 1;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (100, 'incidents', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: incidents 
-- Name: detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT DISTINCT ON (incdt_number) incdt_id AS id,
incdt_number, DATE(incdt_timestamp) AS incdt_timestamp,
crmacct_name,
incdtcat_name, incdtseverity_name,  
incdtpriority_name, crmacct_name, 
CASE WHEN(incdt_status=''N'') THEN <? value("new") ?>
WHEN(incdt_status=''F'') THEN <? value("feedback") ?>
WHEN(incdt_status=''C'') THEN <? value("confirmed") ?>
WHEN(incdt_status=''A'') THEN <? value("assigned") ?>
WHEN(incdt_status=''R'') THEN <? value("resolved") ?>
WHEN(incdt_status=''L'') THEN <? value("closed") ?>
ELSE incdt_status
END,
incdt_assigned_username, incdt_owner_username,
incdt_summary, cntct_name, incdt_updated::date AS incdt_updated,
prj_number, incdt_public,
item_number,
<? if exists("LotSerialControl") ?>
ls_number,
<? endif ?>
status_color AS qtbackgroundrole 
<? foreach("char_id_text_list") ?>
  , charass_alias<? literal("char_id_text_list") ?>.charass_value AS char<? literal("char_id_text_list") ?>
<? endforeach ?>
<? foreach("char_id_list_list") ?>
  , charass_alias<? literal("char_id_list_list") ?>.charass_value AS char<? literal("char_id_list_list") ?>
<? endforeach ?>
<? foreach("char_id_date_list") ?>
  , charass_alias<? literal("char_id_date_list") ?>.charass_value::date AS char<? literal("char_id_date_list") ?>
<? endforeach ?>
FROM crmacct, status, incdt()
  JOIN cntct ON (incdt_cntct_id=cntct_id)
  LEFT OUTER JOIN incdtcat ON (incdtcat_id=incdt_incdtcat_id) 
  LEFT OUTER JOIN incdtseverity ON (incdtseverity_id=incdt_incdtseverity_id) 
  LEFT OUTER JOIN incdtpriority ON (incdtpriority_id=incdt_incdtpriority_id) 
  LEFT OUTER JOIN prj ON (incdt_prj_id=prj_id)
  LEFT OUTER JOIN item ON (item_id=incdt_item_id)
<? if exists("LotSerialControl") ?>
  LEFT OUTER JOIN ls ON (ls_id=incdt_ls_id)
<? endif ?>
<? foreach("char_id_text_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_text_list") ?> ON ((charass_alias<? literal("char_id_text_list") ?>.charass_target_type=''INCDT'') 
                                                                    AND  (charass_alias<? literal("char_id_text_list") ?>.charass_target_id=incdt_id)
                                                                    AND  (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=<? value("char_id_text_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_text_list") ?> ON (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=char_alias<? literal("char_id_text_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_list_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_list_list") ?> ON ((charass_alias<? literal("char_id_list_list") ?>.charass_target_type=''INCDT'') 
                                                                    AND  (charass_alias<? literal("char_id_list_list") ?>.charass_target_id=incdt_id)
                                                                    AND  (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=<? value("char_id_list_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_list_list") ?> ON (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=char_alias<? literal("char_id_list_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_date_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_date_list") ?> ON ((charass_alias<? literal("char_id_date_list") ?>.charass_target_type=''INCDT'') 
                                                                    AND  (charass_alias<? literal("char_id_date_list") ?>.charass_target_id=incdt_id)
                                                                    AND  (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=<? value("char_id_date_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_date_list") ?> ON (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=char_alias<? literal("char_id_date_list") ?>.char_id)
<? endforeach ?>
WHERE ((incdt_crmacct_id=crmacct_id)
AND (status_type=''INCDT'')
AND (incdt_status=status_code)
<? if exists("statuslist") ?>
AND (status_seq IN (-1
  <? foreach("statuslist") ?> , <? value("statuslist") ?> <? endforeach ?>
  ))
<? endif ?>
<? if exists("status_equal") ?> 
AND (status_seq = <? value("status_equal") ?>) 
<? endif ?>
<? if exists("status_above") ?> 
AND (status_seq < <? value("status_above") ?>) 
<? endif ?>
<? if exists("cntct_id") ?> 
AND (incdt_cntct_id = <? value("cntct_id") ?>) 
<? endif ?>
<? if exists("username") ?>
AND (<? value("username") ?> IN (incdt_assigned_username, incdt_owner_username))
<? endif ?>
<? if exists("owner_username") ?> 
AND (incdt_owner_username=<? value("owner_username") ?>) 
<? endif ?>
<? if exists("owner_usr_pattern" ?>
AND (incdt_owner_username ~ <? value("owner_usr_pattern") ?>) 
<? endif ?>
<? if exists("assigned_username") ?> 
AND (incdt_assigned_username=<? value("assigned_username") ?>) 
<? endif ?>
<? if exists("assigned_usr_pattern" ?>
AND (incdt_assigned_username ~ <? value("assigned_usr_pattern") ?>) 
<? endif ?>
<? if exists("incdtpriority_id_list") ?>
AND (incdt_incdtpriority_id IN (-1
  <? foreach("incdtpriority_id_list") ?> , <? value("incdtpriority_id_list") ?> <? endforeach ?>
  ))
<? endif ?>
<? if exists("categorylist") ?>
AND (incdt_incdtcat_id IN (-1
  <? foreach("categorylist") ?> , <? value("categorylist") ?> <? endforeach ?>
  ))
<? endif ?>
<? if exists("category_id") ?> 
AND (incdt_incdtcat_id=<? value("category_id") ?>) 
<? endif ?> 
<? if exists("severity_id") ?> 
AND (incdt_incdtseverity_id=<? value("severity_id") ?>) 
<? endif ?>
<? if exists("crmAccountId") ?> 
AND (incdt_crmacct_id=<? value("crmAccountId") ?>) 
<? endif ?> 
<? if exists("prj_id") ?> 
AND (incdt_prj_id=<? value("prj_id") ?>) 
<? endif ?> 
<? if exists("public") ?> 
AND (incdt_public=<? value("public") ?>) 
<? endif ?> 
)
 
<? if exists("search_pattern") ?> 
AND ((incdt_number::text ~* <? value("search_pattern") ?>)
OR (incdt_summary ~* <? value("search_pattern") ?>)
OR (incdt_descrip ~* <? value("search_pattern") ?>)
OR (incdt_id IN (SELECT comment_source_id
FROM comment
WHERE((comment_source=''INCDT'')
AND (comment_text ~* <? value("search_pattern") ?>)))))
<? endif ?>
<? if exists("item_id") ?>
AND (incdt_item_id=<? value("item_id") ?>)
<? endif ?>
<? if exists("lspattern") ?>
AND (ls_number ~* <? value("lspattern") ?>)
<? endif ?>
<? if exists("id") ?>
AND (incdt_id=<? value("id") ?>)
<? endif ?>
AND (incdt_timestamp BETWEEN COALESCE(<? value("startDate") ?>, startOfTime()) AND COALESCE(<? value("endDate") ?>, endOfTime())+1) 
<? literal("charClause") ?>
ORDER BY incdt_number;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (425, 'contactmerge', 'restore', 'Restore a contact that was previously merged Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: contactmerge
-- Name: restore
-- Notes: Restore a contact that was previously merged
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT cntctrestore(cntctmrgd_cntct_id) AS result
FROM cntctmrgd
<? if exists("cntct_id") ?>
WHERE (cntctmrgd_cntct_id=<? value("cntct_id") ?>)
<? endif ?>
;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (243, 'depositesRegister', 'detail', 'used by dspDepositsRegister Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: depositesRegister
-- Name: detail
-- Notes: used by dspDepositsRegister
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT trans_id, trans_date, trans_source,
       CASE WHEN (trans_doctype=''IN'') THEN <? value("invoice") ?>
            WHEN (trans_doctype=''CM'') THEN <? value("creditmemo") ?>
         ELSE trans_doctype
       END AS doctype,
       trans_docnumber, firstLine(trans_notes) AS f_notes,
       (formatGLAccount(accnt_id) || '' - '' || accnt_descrip) AS f_accnt,
       CASE WHEN (trans_amount < 0) THEN formatMoney(ABS(trans_amount))
         ELSE ''''
       END AS f_debit,
       CASE WHEN (trans_amount < 0) THEN ABS(trans_amount)
         ELSE 0
       END AS debit,
       CASE WHEN (trans_amount > 0) THEN trans_amount
         ELSE 0
       END AS credit,
       (aropen_amount - aropen_paid) AS balance,
       currtobase(aropen_curr_id,(aropen_amount - aropen_paid),aropen_docdate) AS base_balance,
       currconcat(aropen_curr_id) AS currAbbr,
       ''curr'' AS debit_xtnumericrole,
       ''curr'' AS credit_xtnumericrole,
       ''curr'' AS balance_xtnumericrole,
       ''curr'' AS base_balance_xtnumericrole,
       0 AS debit_xttotalrole,
       0 AS credit_xttotalrole,
       0 AS base_balance_xttotalrole
FROM (
SELECT gltrans_id AS trans_id, gltrans_date AS trans_date, gltrans_created AS trans_created,
       gltrans_source AS trans_source, gltrans_doctype AS trans_doctype, gltrans_sequence AS trans_sequence,
       gltrans_docnumber AS trans_docnumber, gltrans_notes AS trans_notes, gltrans_amount AS trans_amount,
       accnt_id, accnt_descrip,
       aropen_amount, aropen_paid, aropen_curr_id, aropen_docdate
FROM gltrans LEFT OUTER JOIN aropen ON ((text(gltrans_docnumber) = ''I-'' || text(aropen_docnumber))
                                    AND (aropen_doctype=''I'')), accnt
WHERE ((gltrans_accnt_id=accnt_id)
   AND (gltrans_doctype = ''CR'')
   AND (gltrans_date BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>) )
UNION
SELECT sltrans_id AS trans_id, sltrans_date AS trans_date, sltrans_created AS trans_created,
       sltrans_source AS trans_source, sltrans_doctype AS trans_doctype, sltrans_sequence AS trans_sequence,
       sltrans_docnumber AS trans_docnumber, sltrans_notes AS trans_notes, sltrans_amount AS trans_amount,
       accnt_id, accnt_descrip,
       aropen_amount, aropen_paid, aropen_curr_id, aropen_docdate
FROM sltrans LEFT OUTER JOIN aropen ON ((text(sltrans_docnumber) = ''I-'' || text(aropen_docnumber))
                                    AND (aropen_doctype=''I'')), accnt
WHERE ((sltrans_accnt_id=accnt_id)
   AND (sltrans_doctype = ''CR'')
   AND (sltrans_date BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>) )
     ) AS data
ORDER BY trans_created DESC, trans_sequence, trans_amount;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (52, 'inventoryAvailability', 'general', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: inventoryAvailability
-- Name:  general
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT itemsite_id, altId,
       item_number, (item_descrip1 || '' '' || item_descrip2) AS itemdescrip,
       uom_name,
       warehous_id, warehous_code, itemsite_leadtime,
       qoh, allocated, noNeg(qoh - allocated) AS unallocated, 
       ordered, requests, reorderlevel, outlevel,
       (qoh - allocated + ordered) AS available,
       vend_number,
       ''qty'' AS qoh_xtnumericrole,
       ''qty'' AS allocated_xtnumericrole,
       ''qty'' AS unallocated_xtnumericrole,       
       ''qty'' AS ordered_xtnumericrole,
       ''qty'' AS requests_xtnumericrole,
       ''qty'' AS reorderlevel_xtnumericrole,
       ''qty'' AS outlevel_xtnumericrole,
       ''qty'' AS available_xtnumericrole,
       <? if exists("byDates") ?>
         ''grey'' AS qoh_qtforegroundrole,
       <? endif ?>
       CASE WHEN ((qoh - allocated + ordered) < 0) THEN ''error''
            WHEN ((qoh - allocated + ordered) <= reorderlevel) THEN ''warning''
       END AS available_qtforegroundrole
FROM (SELECT 
           <? if reExists("[vV]end") ?>
             DISTINCT
           <? endif ?>
             itemsite_id,
             CASE WHEN (item_type IN (''P'', ''O'')) THEN 1
                  WHEN (item_type IN (''M'')) THEN 2
                  ELSE 0
             END AS altId,
             item_number, item_descrip1, item_descrip2, item_inv_uom_id,
             warehous_id, warehous_code, itemsite_leadtime,
             itemsite_qtyonhand AS qoh,
             CASE WHEN itemsite_useparams THEN itemsite_reorderlevel
                  ELSE 0.0
             END AS reorderlevel,
             CASE WHEN itemsite_useparams THEN itemsite_ordertoqty
                  ELSE 0.0
             END AS outlevel,
             <? if exists("byVend") ?>
               vend_number,
             <? else ?>
               NULL AS vend_number,
             <? endif ?>
             <? if exists("byLeadTime") ?>
               qtyAllocated(itemsite_id, itemsite_leadtime) AS allocated,
               qtyOrdered(itemsite_id,   itemsite_leadtime) AS ordered, 
               qtypr(itemsite_id,   itemsite_leadtime) AS requests
             <? elseif exists("byDays") ?>
               qtyAllocated(itemsite_id, CAST(<? value("byDays") ?> AS INTEGER)) AS allocated,
               qtyOrdered(itemsite_id,   CAST(<? value("byDays") ?> AS INTEGER)) AS ordered,
               qtypr(itemsite_id,   CAST(<? value("byDays") ?> AS INTEGER)) AS requests  
             <? elseif exists("byDate") ?>
               qtyAllocated(itemsite_id, (<? value("byDate") ?> - CURRENT_DATE)) AS allocated,
               qtyOrdered(itemsite_id,   (<? value("byDate") ?> - CURRENT_DATE)) AS ordered,
               qtypr(itemsite_id,   (<? value("byDate") ?> - CURRENT_DATE)) AS requests 
             <? elseif exists("byDates") ?>
               qtyAllocated(itemsite_id, <? value("startDate") ?>, <? value("endDate") ?>) AS allocated,
               qtyOrdered(itemsite_id,   <? value("startDate") ?>, <? value("endDate") ?>) AS ordered,
               qtypr(itemsite_id,   <? value("startDate") ?>, <? value("endDate") ?>) AS requests
             <? endif ?>
      FROM item, itemsite, whsinfo
           <? if reExists("[vV]end") ?>
             , vendinfo JOIN itemsrc ON (itemsrc_vend_id=vend_id)
           <? endif ?>
      WHERE ( (itemsite_active)
          AND (itemsite_item_id=item_id)
          AND (itemsite_warehous_id=warehous_id)
          <? if exists("warehous_id") ?>
            AND (warehous_id=<? value("warehous_id") ?>)
          <? endif ?>
          <? if exists("item_id") ?>
            AND (item_id=<? value("item_id") ?>)
          <? elseif exists("classcode_id") ?>
            AND (item_classcode_id=<? value("classcode_id") ?>)
          <? elseif exists("classcode_pattern") ?>
            AND (item_classcode_id IN (SELECT classcode_id
                                       FROM classcode
                                       WHERE (classcode_code ~ <? value("classcode_pattern") ?>)))
          <? elseif exists("plancode_id") ?>
            AND (itemsite_plancode_id=<? value("plancode_id") ?>)
          <? elseif exists("plancode_pattern") ?>
            AND (itemsite_plancode_id IN (SELECT plancode_id
                                          FROM plancode
                                          WHERE (plancode_code ~ <? value("plancode_pattern") ?>)))
          <? elseif exists("itemgrp_id") ?>
            AND (item_id IN (SELECT itemgrpitem_item_id
                             FROM itemgrpitem
                             WHERE (itemgrpitem_itemgrp_id=<? value("itemgrp_id") ?>)))
          <? elseif exists("itemgrp_pattern") ?>
            AND (item_id IN (SELECT itemgrpitem_item_id
                             FROM itemgrpitem, itemgrp
                             WHERE ( (itemgrpitem_itemgrp_id=itemgrp_id)
                                    AND (itemgrp_name ~ <? value("itemgrp_pattern") ?>) ) ))
          <? elseif exists("itemgrp") ?>
            AND (item_id IN (SELECT DISTINCT itemgrpitem_item_id FROM itemgrpitem))
          <? endif ?>
          <? if reExists("[vV]end") ?>
            AND (itemsrc_item_id=item_id)
          <? endif ?>
          <? if exists("vend_id") ?>
            AND (vend_id=<? value("vend_id") ?>)
          <? elseif exists("vendtype_id") ?>
            AND (vend_vendtype_id=<? value("vendtype_id") ?>)
          <? elseif exists("vendtype_pattern") ?>
            AND (vend_vendtype_id IN (SELECT vendtype_id
                                      FROM vendtype
                                      WHERE (vendtype_code ~ <? value("vendtype_pattern") ?>)))
          <? endif ?>
      ) ) AS data, uom
WHERE ((item_inv_uom_id=uom_id)
<? if exists("showReorder") ?>
  AND ((qoh - allocated + ordered) <= reorderlevel) 
  <? if exists("ignoreReorderAtZero") ?>
    AND NOT ( ((qoh - allocated + ordered) = 0) AND (reorderlevel = 0))
  <? endif ?>
<? elseif exists("showShortages") ?>
  AND ((qoh - allocated + ordered) < 0) 
<? endif ?>
)

ORDER BY
<? if exists("ListNumericItemNumbersFirst") ?>
  toNumeric(item_number, 999999999999999),
<? elseif exists("byVend") ?>
  vend_number,
<? endif ?>
  item_number, warehous_code DESC;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (254, 'inventoryLocator', 'detail', 'used by dspInventoryLocator Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. Lot/Serial Characteristics additions by Specter Vision Solutions, Inc. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: inventoryLocator
-- Name: detail
-- Notes: used by dspInventoryLocator
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- Lot/Serial Characteristics additions by Specter Vision Solutions, Inc.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT *,
       <? value("na") ?> AS locationname_xtnullrole,
       <? value("na") ?> AS netable_xtnullrole,
       <? value("na") ?> AS lotserial_xtnullrole,
       <? value("na") ?> AS expiration_xtnullrole,
       <? value("na") ?> AS warranty_xtnullrole,
       CASE WHEN (itemsite_perishable
                  AND itemloc_expiration <= CURRENT_DATE) THEN ''error''
            WHEN (itemsite_warrpurc
                  AND itemloc_warrpurc <= CURRENT_DATE) THEN ''error''
       END AS qtforegroundrole,
       ''qty'' AS qoh_xtnumericrole
FROM (SELECT itemloc_id, 1 AS type, warehous_code,
             itemsite_perishable, itemloc_expiration,
             itemsite_warrpurc, itemloc_warrpurc,
             CASE WHEN (location_id IS NOT NULL) THEN
                        (formatLocationName(location_id) || ''-'' || firstLine(location_descrip))
             END AS locationname,
             CASE WHEN (location_id IS NOT NULL) THEN location_netable
             END AS netable,
             CASE WHEN (itemsite_controlmethod IN (''L'', ''S'')) THEN
                        formatlotserialnumber(itemloc_ls_id)
             END AS lotserial,
             CASE WHEN (itemsite_perishable) THEN itemloc_expiration
             END AS expiration,
             CASE WHEN (itemsite_warrpurc) THEN itemloc_warrpurc
             END AS warranty,
             itemloc_qty AS qoh
<? foreach("char_id_text_list") ?>
  , charass_alias<? literal("char_id_text_list") ?>.charass_value AS char<? literal("char_id_text_list") ?>
<? endforeach ?>
<? foreach("char_id_list_list") ?>
  , charass_alias<? literal("char_id_list_list") ?>.charass_value AS char<? literal("char_id_list_list") ?>
<? endforeach ?>
<? foreach("char_id_date_list") ?>
  , charass_alias<? literal("char_id_date_list") ?>.charass_value::date AS char<? literal("char_id_date_list") ?>
<? endforeach ?>
      FROM itemsite, whsinfo,
           itemloc LEFT OUTER JOIN location ON (itemloc_location_id=location_id)
<? foreach("char_id_text_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_text_list") ?> ON ((charass_alias<? literal("char_id_text_list") ?>.charass_target_type=''LS'')
                                                                    AND  (charass_alias<? literal("char_id_text_list") ?>.charass_target_id=itemloc_ls_id)
                                                                    AND  (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=<? value("char_id_text_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_text_list") ?> ON (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=char_alias<? literal("char_id_text_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_list_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_list_list") ?> ON ((charass_alias<? literal("char_id_list_list") ?>.charass_target_type=''LS'')
                                                                    AND  (charass_alias<? literal("char_id_list_list") ?>.charass_target_id=itemloc_ls_id)
                                                                    AND  (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=<? value("char_id_list_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_list_list") ?> ON (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=char_alias<? literal("char_id_list_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_date_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_date_list") ?> ON ((charass_alias<? literal("char_id_date_list") ?>.charass_target_type=''LS'')
                                                                    AND  (charass_alias<? literal("char_id_date_list") ?>.charass_target_id=itemloc_ls_id)
                                                                    AND  (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=<? value("char_id_date_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_date_list") ?> ON (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=char_alias<? literal("char_id_date_list") ?>.char_id)
<? endforeach ?>
      WHERE ((itemsite_loccntrl OR (itemsite_controlmethod IN (''L'', ''S'')))
         AND (itemloc_itemsite_id=itemsite_id)
         AND (itemsite_warehous_id=warehous_id)
         AND (itemsite_item_id=<? value("item_id") ?>)
      <? if exists("warehous_id") ?>
         AND (itemsite_warehous_id=<? value("warehous_id") ?>)
      <? endif ?>
      <? if exists("site") ?>
         AND (itemsite_warehous_id=<? value("site")?>)
      <? endif ?>
      <? if exists("lot_serial") ?>
         AND (formatlotserialnumber(itemloc_ls_id)=<? value("lot_serial")?>)
      <? endif ?>
      <? if exists("_location_name") ?>
         AND (formatLocationName(location_id)=<? value("_location_name")?>)
      <? endif ?>
      <? literal("charClause") ?>
            )
      UNION
      SELECT itemsite_id, 2 AS type, warehous_code,
             itemsite_perishable, NULL AS itemloc_expiration,
             itemsite_warrpurc, NULL AS itemloc_warrpurc,
             NULL AS locationname,
             NULL AS netable,
             NULL AS lotserial,
             NULL AS expiration,
             NULL AS warranty,
             itemsite_qtyonhand AS qoh
<? foreach("char_id_text_list" ?>
          , NULL AS char<? value("char_id_text_list") ?>
<? endforeach ?>
<? foreach("char_id_list_list" ?>
          , NULL AS char<? value("char_id_list_list") ?>
<? endforeach ?>
<? foreach("char_id_date_list" ?>
          , NULL AS char<? value("char_id_date_list") ?>
<? endforeach ?>
      FROM itemsite, whsinfo
      WHERE ((NOT itemsite_loccntrl)
         AND (itemsite_controlmethod NOT IN (''L'', ''S''))
         AND (itemsite_warehous_id=warehous_id)
         AND (itemsite_item_id=<? value("item_id") ?>)
      <? if exists("warehous_id") ?>
         AND (itemsite_warehous_id=<? value("warehous_id") ?>)
      <? endif ?>
            )
     ) AS dummy
ORDER BY warehous_code, locationname, lotserial;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (244, 'detailedInventoryHistory', 'detail', 'used by dspDetailedInventoryHistoryByLocation, dspDetailedInventoryHistoryByLotSerial Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: detailedInventoryHistory
-- Name: detail
-- Notes: used by dspDetailedInventoryHistoryByLocation, dspDetailedInventoryHistoryByLotSerial
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT
<? if exists("byLocation") ?>
       invhist_id, invhist_transdate, invhist_transtype,
       (invhist_ordtype || ''-'' || invhist_ordnumber) AS ordernumber,
       invhist_invuom,
       item_number, formatlotserialnumber(invdetail_ls_id) AS lotserial,
       CASE WHEN invhist_posted THEN invdetail_qty
       END AS transqty,
       CASE WHEN invhist_posted THEN invdetail_qty_before
       END AS qohbefore,
       CASE WHEN invhist_posted THEN invdetail_qty_after
       END AS qohafter,
       invhist_posted,
       ''qty'' AS transqty_xtnumericrole,
       ''qty'' AS qohbefore_xtnumericrole,
       ''qty'' AS qohafter_xtnumericrole,
       CASE WHEN NOT invhist_posted THEN ''warning''
       END AS qtforegroundrole
<? else ?>
       *
<? endif ?>
FROM <? if exists("byLocation") ?>
       invdetail, invhist, itemsite, item
     <? else ?>
       lshist (<? value("itemid") ?>,<? value("warehouseid") ?>,<? value("lotSerial") ?>,
               <? value("pattern") ?>,<? value("transType") ?>,<? value("startDate") ?>,
               <? value("endDate") ?>,<? value("trace") ?>,1)
     <? endif ?>
WHERE (
<? if exists("byLocation") ?>
        (invdetail_invhist_id=invhist_id)
    AND (invhist_itemsite_id=itemsite_id)
    AND (itemsite_item_id=item_id)
    AND (invdetail_location_id=<? value("location_id") ?>)
    AND (DATE(invhist_transdate) BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
    AND (transType(invhist_transtype, <? value("transType") ?>))
<? else ?>
        (TRUE)
<? endif ?>
      )
<? if exists("byLocation") ?>
ORDER BY invhist_transdate DESC, invhist_transtype
<? endif ?>
;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (255, 'invoiceInformation', 'detail', 'used by dspInvoiceInformation Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: invoiceInformation
-- Name: detail
-- Notes: used by dspInvoiceInformation
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT arapply_id,
       CASE WHEN (arapply_source_doctype = ''C'') THEN <? value("creditMemo") ?>
            WHEN (arapply_source_doctype = ''R'') THEN <? value("cashdeposit") ?>
            WHEN (arapply_fundstype=''C'') THEN <? value("check") ?>
            WHEN (arapply_fundstype=''T'') THEN <? value("certifiedCheck") ?>
            WHEN (arapply_fundstype=''M'') THEN <? value("masterCard") ?>
            WHEN (arapply_fundstype=''V'') THEN <? value("visa") ?>
            WHEN (arapply_fundstype=''A'') THEN <? value("americanExpress") ?>
            WHEN (arapply_fundstype=''D'') THEN <? value("discoverCard") ?>
            WHEN (arapply_fundstype=''R'') THEN <? value("otherCreditCard") ?>
            WHEN (arapply_fundstype=''K'') THEN <? value("cash") ?>
            WHEN (arapply_fundstype=''W'') THEN <? value("wireTransfer") ?>
            WHEN (arapply_fundstype=''O'') THEN <? value("other") ?>
       END AS doctype,
       CASE WHEN (arapply_source_doctype IN (''C'',''R'')) THEN arapply_source_docnumber
            WHEN (arapply_source_doctype = ''K'') THEN arapply_refnumber
         ELSE <? value("error") ?>
       END AS docnumber,
       arapply_postdate, arapply_applied,
       currConcat(arapply_curr_id) AS currabbr,
       currToBase(arapply_curr_id, arapply_applied, arapply_postdate) AS baseapplied,
       ''curr'' AS arapply_applied_xtnumericrole,
       ''curr'' AS baseapplied_xtnumericrole
FROM arapply
WHERE ((arapply_target_doctype=''I'')
   AND (arapply_target_docnumber=<? value("aropen_docnumber") ?>))
ORDER BY arapply_postdate;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (256, 'invoiceRegister', 'detail', 'used by dspInvoiceRegister Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: invoiceRegister
-- Name: detail
-- Notes: used by dspInvoiceRegister
--        Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
--        See www.xtuple.com/CPAL for the full text of the software license.

SELECT DISTINCT *
FROM (
-- G/L Transactions
SELECT DISTINCT
       -1 AS gltrans_id, -1 AS altId,
       gltrans_date,  '''' AS gltrans_source,
       '''' AS doctype, '''' AS gltrans_docnumber,
       '''' AS notes,   '''' AS account,
       CAST(NULL AS NUMERIC) AS debit,
       CAST(NULL AS NUMERIC) AS credit,
       ''curr'' AS debit_xtnumericrole,
       ''curr'' AS credit_xtnumericrole,
       0 AS xtindentrole,
       gltrans_date AS transdate
FROM gltrans
WHERE ((gltrans_doctype IN (''IN'', ''CM'', ''DM'', ''CD''))
   AND (gltrans_source = ''A/R'')
   AND (gltrans_date BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? if exists("accnt_id") ?>
   AND (gltrans_accnt_id=<? value("accnt_id") ?>)
<? endif ?>
      )

UNION
-- Journals
SELECT DISTINCT
       -1 AS gltrans_id, -1 AS altId,
       sltrans_date AS gltrans_date,  '''' AS gltrans_source,
       '''' AS doctype, '''' AS gltrans_docnumber,
       '''' AS notes,   '''' AS account,
       CAST(NULL AS NUMERIC) AS debit,
       CAST(NULL AS NUMERIC) AS credit,
       ''curr'' AS debit_xtnumericrole,
       ''curr'' AS credit_xtnumericrole,
       0 AS xtindentrole,
       sltrans_date AS transdate
FROM sltrans
WHERE ((sltrans_doctype IN (''IN'', ''CM'', ''DM'', ''CD''))
   AND (sltrans_source = ''A/R'')
   AND (sltrans_date BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? if exists("accnt_id") ?>
   AND (sltrans_accnt_id=<? value("accnt_id") ?>)
<? endif ?>
      )
) AS data

UNION
-- G/L Transactions
SELECT gltrans_id,
       CASE WHEN(gltrans_doctype=''IN'') THEN 1
            WHEN(gltrans_doctype=''CM'') THEN 2
            WHEN(gltrans_doctype=''DM'') THEN 3
            WHEN(gltrans_doctype=''CD'') THEN 4
         ELSE -1
       END AS altId,
       gltrans_date, gltrans_source,
       CASE WHEN(gltrans_doctype=''IN'') THEN <? value("invoice") ?>
            WHEN(gltrans_doctype=''CM'') THEN <? value("creditmemo") ?>
            WHEN(gltrans_doctype=''DM'') THEN <? value("debitmemo") ?>
            WHEN(gltrans_doctype=''CD'') THEN <? value("cashdeposit") ?>
         ELSE gltrans_doctype
       END AS doctype,
       gltrans_docnumber,
       CASE WHEN(gltrans_doctype=''IN'') THEN
                 (SELECT invchead_shipto_name
                  FROM aropen LEFT OUTER JOIN
                       invchead
                       ON (invchead_id=aropen_cobmisc_id
                       AND invchead_cust_id=aropen_cust_id)
                  WHERE ((aropen_docnumber=gltrans_docnumber)
                     AND (aropen_doctype=''I'')))
         ELSE firstLine(gltrans_notes)
       END AS f_notes,
       (formatGLAccount(accnt_id) || '' - '' || accnt_descrip) AS f_accnt,
       CASE WHEN (gltrans_amount < 0) THEN ABS(gltrans_amount)
         ELSE 0
       END AS debit,
       CASE WHEN (gltrans_amount > 0) THEN gltrans_amount
         ELSE 0
       END AS credit,
       ''curr'' AS debit_xtnumericrole,
       ''curr'' AS credit_xtnumericrole,
       1 AS xtindentrole,
       NULL AS transdate
FROM gltrans, accnt
WHERE ((gltrans_accnt_id=accnt_id)
   AND (gltrans_doctype IN (''IN'', ''CM'', ''DM'', ''CD''))
   AND (gltrans_source = ''A/R'')
   AND (gltrans_date BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? if exists("accnt_id") ?>
   AND (gltrans_accnt_id=<? value("accnt_id") ?>)
<? endif ?>
   )

UNION
-- Journals
SELECT sltrans_id,
       CASE WHEN(sltrans_doctype=''IN'') THEN 1
            WHEN(sltrans_doctype=''CM'') THEN 2
            WHEN(sltrans_doctype=''DM'') THEN 3
            WHEN(sltrans_doctype=''CD'') THEN 4
         ELSE -1
       END AS altId,
       sltrans_date AS gltrans_date, sltrans_source AS gltrans_date,
       CASE WHEN(sltrans_doctype=''IN'') THEN <? value("invoice") ?>
            WHEN(sltrans_doctype=''CM'') THEN <? value("creditmemo") ?>
            WHEN(sltrans_doctype=''DM'') THEN <? value("debitmemo") ?>
            WHEN(sltrans_doctype=''CD'') THEN <? value("cashdeposit") ?>
         ELSE sltrans_doctype
       END AS doctype,
       sltrans_docnumber AS gltrans_docnumber,
       CASE WHEN(sltrans_doctype=''IN'') THEN
                 (SELECT invchead_shipto_name
                  FROM aropen LEFT OUTER JOIN
                       invchead
                       ON (invchead_id=aropen_cobmisc_id
                       AND invchead_cust_id=aropen_cust_id)
                  WHERE ((aropen_docnumber=sltrans_docnumber)
                     AND (aropen_doctype=''I'')))
         ELSE firstLine(sltrans_notes)
       END AS f_notes,
       (formatGLAccount(accnt_id) || '' - '' || accnt_descrip) AS f_accnt,
       CASE WHEN (sltrans_amount < 0) THEN ABS(sltrans_amount)
         ELSE 0
       END AS debit,
       CASE WHEN (sltrans_amount > 0) THEN sltrans_amount
         ELSE 0
       END AS credit,
       ''curr'' AS debit_xtnumericrole,
       ''curr'' AS credit_xtnumericrole,
       1 AS xtindentrole,
       NULL AS transdate
FROM sltrans, accnt
WHERE ((sltrans_accnt_id=accnt_id)
   AND (sltrans_doctype IN (''IN'', ''CM'', ''DM'', ''CD''))
   AND (sltrans_source = ''A/R'')
   AND (sltrans_date BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? if exists("accnt_id") ?>
   AND (sltrans_accnt_id=<? value("accnt_id") ?>)
<? endif ?>
      )
ORDER BY gltrans_date, gltrans_docnumber, xtindentrole;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (55, 'invoices', 'detail', 'used by reprintInvoices, unpostedInvoices, dspRecurringInvoices Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: invoices
-- Name: detail
-- Notes: used by reprintInvoices, unpostedInvoices, dspRecurringInvoices
--        Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
--        See www.xtuple.com/CPAL for the full text of the software license.

SELECT invchead_id, cust_id,
       invchead.*,
       cust_number, cust_name,
       (TEXT(cust_number) || '' - '' || cust_name) AS customer,
       COALESCE(invchead_gldistdate, invchead_invcdate) AS gldistdate,
       invoicetotal(invchead_id) AS extprice,
       CASE WHEN (aropen_open) THEN (aropen_amount - aropen_paid)
            ELSE 0
       END AS balance,
       (invchead_recurring_invchead_id IS NOT NULL) AS isRecurring,
       recur_freq,
       recur_period,
       CASE WHEN (recur_period=''D'') THEN <? value("day") ?>
            WHEN (recur_period=''W'') THEN <? value("week") ?>
            WHEN (recur_period=''M'') THEN <? value("month") ?>
            WHEN (recur_period=''Y'') THEN <? value("year") ?>
            WHEN (recur_period=''m'') THEN <? value("minute") ?>
            WHEN (recur_period=''H'') THEN <? value("hour") ?>
            ELSE <? value("none") ?>
       END AS recur_period_qtdisplayrole,
       recur_end,
       <? if exists(''getForm'') ?>
         invchead_invcnumber AS docnumber,
         findCustomerForm(cust_id, ''I'') AS reportname,
       <? endif ?>
       CASE WHEN (calcInvoiceAmt(invchead_id,''S'') != 0.0)
              THEN (calcInvoiceAmt(invchead_id,''M'') / calcInvoiceAmt(invchead_id,''S''))
            ELSE 1.0
       END AS marginpercent,
       ''percent'' AS marginpercent_xtnumericrole,
       ''curr'' AS extprice_xtnumericrole,
       ''curr'' AS balance_xtnumericrole,
       CASE WHEN (aropen_id IS NULL) THEN ''Unposted'' END AS balance_qtdisplayrole
FROM invchead JOIN custinfo ON (cust_id=invchead_cust_id)
              LEFT OUTER JOIN aropen ON ( (aropen_doctype=''I'') AND (aropen_docnumber=invchead_invcnumber) )
              LEFT OUTER JOIN recur ON (invchead_recurring_invchead_id=recur_parent_id AND recur_parent_type=''I'')
WHERE ( (true)
<? if exists("unpostedOnly") ?>
  AND   (NOT invchead_posted)
<? endif ?>
<? if exists("postedOnly") ?>
  AND   (invchead_posted)
<? endif ?>
<? if exists("recurringOnly") ?>
  AND   (invchead_recurring_invchead_id IS NOT NULL)
<? endif ?>
<? if exists("cust_id") ?>
  AND   (invchead_cust_id=<? value("cust_id") ?>)
<? endif ?>
<? if exists("startDate") ?>
  AND   (invchead_invcdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
<? if exists("invc_pattern") ?>
  AND   (invchead_invcnumber ~ <? value("invc_pattern") ?>)
<? endif ?>
<? if exists("balanceOnly") ?>
  AND   (aropen_open AND (aropen_amount - aropen_paid > 0))
<? endif ?>
  AND   (checkInvoiceSitePrivs(invchead_id)) )
ORDER BY invchead_invcnumber
;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (465, 'employees', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: employees
-- Name:  detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT emp_id, warehous_code, emp_active, emp_code, emp_number,
  cntct_first_name, cntct_last_name
<? foreach("char_id_text_list") ?>
  , charass_alias<? literal("char_id_text_list") ?>.charass_value AS char<? literal("char_id_text_list") ?>
<? endforeach ?>
<? foreach("char_id_list_list") ?>
  , charass_alias<? literal("char_id_list_list") ?>.charass_value AS char<? literal("char_id_list_list") ?>
<? endforeach ?>
<? foreach("char_id_date_list") ?>
  , charass_alias<? literal("char_id_date_list") ?>.charass_value::date AS char<? literal("char_id_date_list") ?>
<? endforeach ?>
FROM emp
  LEFT OUTER JOIN cntct ON (emp_cntct_id=cntct_id)
  LEFT OUTER JOIN whsinfo ON (emp_warehous_id=warehous_id)
<? foreach("char_id_text_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_text_list") ?> ON ((charass_alias<? literal("char_id_text_list") ?>.charass_target_type=''EMP'') 
                                                                    AND  (charass_alias<? literal("char_id_text_list") ?>.charass_target_id=emp_id)
                                                                    AND  (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=<? value("char_id_text_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_text_list") ?> ON (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=char_alias<? literal("char_id_text_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_list_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_list_list") ?> ON ((charass_alias<? literal("char_id_list_list") ?>.charass_target_type=''EMP'') 
                                                                    AND  (charass_alias<? literal("char_id_list_list") ?>.charass_target_id=emp_id)
                                                                    AND  (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=<? value("char_id_list_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_list_list") ?> ON (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=char_alias<? literal("char_id_list_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_date_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_date_list") ?> ON ((charass_alias<? literal("char_id_date_list") ?>.charass_target_type=''EMP'') 
                                                                    AND  (charass_alias<? literal("char_id_date_list") ?>.charass_target_id=emp_id)
                                                                    AND  (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=<? value("char_id_date_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_date_list") ?> ON (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=char_alias<? literal("char_id_date_list") ?>.char_id)
<? endforeach ?>
WHERE (true)
<? if exists("warehous_id") ?>
  AND (warehous_id=<? value("warehous_id") ?>)
<? endif ?>
<? if exists("activeOnly") ?> 
  AND emp_active 
<? endif ?>
<? if exists("search_pattern") ?>
  AND ((emp_code ~* <? value("search_pattern") ?>)
       OR (emp_number ~* <? value("search_pattern") ?>)
       OR (COALESCE(cntct_first_name,'''') || '' '' || COALESCE(cntct_last_name,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(cntct_phone,'''') || '' '' || COALESCE(cntct_phone2,'''') || '' '' || COALESCE(cntct_fax,'''') ~* <? value("search_pattern") ?>)
       OR (COALESCE(cntct_email,'''') ~* <? value("search_pattern") ?>))
<? endif ?>
<? literal("charClause") ?>
ORDER BY emp_code;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (475, 'issueToShipping', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: issueToShipping
-- Name:  detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT *,
       noNeg(qtyord - qtyshipped + qtyreturned) AS balance,
       indent AS xtindentrole,
       ''qty'' AS qtyord_xtnumericrole,
       ''qty'' AS qtyshipped_xtnumericrole,
       ''qty'' AS qtyreturned_xtnumericrole,
       ''qty'' AS balance_xtnumericrole,
       ''qty'' AS atshipping_xtnumericrole,
       CASE WHEN (scheddate > CURRENT_DATE AND
                  noNeg(qtyord - qtyshipped + qtyreturned) <> atshipping) THEN ''future''
            WHEN (noNeg(qtyord - qtyshipped + qtyreturned) <> atshipping) THEN ''expired''
       END AS qtforegroundrole 
FROM (
<? if exists("sohead_id") ?>
SELECT coitem_id AS lineitem_id, 
       CASE WHEN (itemsite_costmethod = ''J'') THEN 1 
            ELSE 0 
       END AS job, 0 AS indent,
       getOpenShipment(''SO'', <? value("sohead_id") ?>, <? value("warehous_id") ?>) AS shiphead_number, 
       formatSoLineNumber(coitem_id) AS linenumber, item_number,
       (item_descrip1 || '' '' || item_descrip2) AS itemdescrip,
       warehous_code,
       coitem_scheddate AS scheddate,
       uom_name,
       coitem_qtyord AS qtyord,
       coitem_qtyshipped AS qtyshipped,
       coitem_qtyreturned AS qtyreturned,
       qtyAtShipping(coitem_id) AS atshipping, 
       coitem_scheddate AS seq1, coitem_linenumber AS seq2, coitem_subnumber AS seq3 
FROM coitem JOIN itemsite ON (itemsite_id=coitem_itemsite_id)
            JOIN item ON (item_id=itemsite_item_id)
            JOIN site() ON (warehous_id=itemsite_warehous_id)
            JOIN uom ON (uom_id=coitem_qty_uom_id)
WHERE ( (coitem_status NOT IN (''C'',''X''))
  AND   (item_type != ''K'')
<? if exists("warehous_id") ?>
  AND   (itemsite_warehous_id=<? value("warehous_id") ?>) 
<? endif ?>
  AND   (coitem_cohead_id=<? value("sohead_id") ?>) ) 

<? if exists("includeReservations") ?>
UNION ALL
SELECT coitem_id AS lineitem_id, 
       CASE WHEN (itemsite_costmethod = ''J'') THEN 1 
            ELSE 0 
       END AS job, 1 AS indent,
       '''' AS shiphead_number, 
       '''' AS linenumber, formatLocationName(itemloc_location_id) AS item_number,
       formatLotSerialNumber(itemloc_ls_id) AS itemdescrip,
       '''' AS warehous_code,
       NULL AS scheddate,
       '''' AS uom_name,
       reserve_qty AS qtyord,
       NULL AS qtyshipped,
       NULL AS qtyreturned,
       NULL AS atshipping, 
       coitem_scheddate AS seq1, coitem_linenumber AS seq2, coitem_subnumber AS seq3 
FROM coitem JOIN itemsite ON (itemsite_id=coitem_itemsite_id)
            JOIN item ON (item_id=itemsite_item_id)
            JOIN site() ON (warehous_id=itemsite_warehous_id)
            JOIN reserve ON (reserve_demand_id=coitem_id AND
                             reserve_demand_type=''SO'' AND
                             reserve_supply_type=''I'')
            JOIN itemloc ON (itemloc_id=reserve_supply_id)
WHERE ( (coitem_status NOT IN (''C'',''X''))
  AND   (item_type != ''K'')
  AND   ((itemsite_controlmethod IN (''L'', ''S'')) OR (itemsite_loccntrl))
<? if exists("warehous_id") ?>
  AND   (itemsite_warehous_id=<? value("warehous_id") ?>) 
<? endif ?>
  AND   (coitem_cohead_id=<? value("sohead_id") ?>) ) 
UNION ALL
SELECT coitem_id AS lineitem_id, 
       CASE WHEN (itemsite_costmethod = ''J'') THEN 1 
            ELSE 0 
       END AS job, 1 AS indent,
       '''' AS shiphead_number, 
       '''' AS linenumber, ''N/A'',
       ''N/A'' AS itemdescrip,
       '''' AS warehous_code,
       NULL AS scheddate,
       '''' AS uom_name,
       coitem_qtyreserved AS qtyord,
       NULL AS qtyshipped,
       NULL AS qtyreturned,
       NULL AS atshipping, 
       coitem_scheddate AS seq1, coitem_linenumber AS seq2, coitem_subnumber AS seq3 
FROM coitem JOIN itemsite ON (itemsite_id=coitem_itemsite_id)
            JOIN item ON (item_id=itemsite_item_id)
            JOIN site() ON (warehous_id=itemsite_warehous_id)
WHERE ( (coitem_status NOT IN (''C'',''X''))
  AND   (item_type != ''K'')
  AND   ((itemsite_controlmethod = ''R'') AND (NOT itemsite_loccntrl))
  AND   (coitem_qtyreserved > 0.0)
<? if exists("warehous_id") ?>
  AND   (itemsite_warehous_id=<? value("warehous_id") ?>) 
<? endif ?>
  AND   (coitem_cohead_id=<? value("sohead_id") ?>) ) 
<? endif ?>

<? elseif exists("tohead_id") ?>

SELECT toitem_id AS lineitem_id, 
       0 AS lsJob, 0 AS indent,
       getOpenShipment(''TO'', <? value("tohead_id") ?>, <? value("warehous_id") ?>) AS shiphead_number, 
       toitem_linenumber AS linenumber, item_number,
       (item_descrip1 || '' '' || item_descrip2) AS itemdescrip,
       tohead_srcname AS warehous_code,
       toitem_schedshipdate AS scheddate,
       uom_name,
       toitem_qty_ordered AS qtyord,
       toitem_qty_shipped AS qtyshipped,
       0 AS qtyreturned,
       qtyAtShipping(''TO'', toitem_id) AS atshipping, 
       toitem_schedshipdate AS seq1, toitem_linenumber AS seq2, 0 AS seq3 
FROM item, tohead, site(), uom, toitem
WHERE ( (toitem_item_id=item_id)
 AND (toitem_status NOT IN (''C'',''X''))
 AND (toitem_tohead_id=tohead_id)
 AND (tohead_src_warehous_id=warehous_id)
 AND (item_inv_uom_id=uom_id)
<? if exists("warehous_id") ?>
  AND   (tohead_src_warehous_id=<? value("warehous_id") ?>) 
<? endif ?>
 AND (tohead_id=<? value("tohead_id") ?>) ) 
<? endif ?>
) AS sub 
ORDER BY seq1, seq2, seq3, indent;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (257, 'itemCost', 'detail', 'used by dspItemCostSummary, dspItemCostsByClassCode, dspItemCostHistory Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: itemCost
-- Name: detail
-- Notes: used by dspItemCostSummary, dspItemCostsByClassCode, dspItemCostHistory
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT 
      <? if exists("byHistory") ?>
        costhist_id, costelem_type,
        formatBoolYN(costhist_lowlevel) AS lowlevel,
        CASE WHEN costhist_type=''A'' THEN <? value("actual") ?>
             WHEN costhist_type=''S'' THEN <? value("standard") ?>
             WHEN costhist_type=''D'' THEN <? value("delete") ?>
             WHEN costhist_type=''N'' THEN <? value("new") ?>
        END AS type,
        costhist_date,
        costhist_username AS username,
        costhist_oldcost,
        currConcat(costhist_oldcurr_id) AS oldcurr, 
	costhist_newcost,
        currConcat(costhist_newcurr_id) AS newcurr,
        ''cost'' AS costhist_oldcost_xtnumericrole,
        ''cost'' AS costhist_newcost_xtnumericrole
      <? elseif exists("byClassCode") ?>
        item_id, item_number, description, item_active, 
        uom_name, scost, acost, 
        CASE WHEN (scost = 0) THEN NULL  
          ELSE ((acost - scost) / scost)      
        END AS percent_variance,
        ''percent'' AS percent_variance_xtnumericrole, 
        CASE WHEN (scost = 0) THEN NULL 
             WHEN (((acost - scost) / scost) < 0) THEN ''error'' 
          ELSE NULL 
        END AS percent_variance_qtforegroundrole, 
        <? if exists("onlyShowDiffCosts") ?>
          CASE WHEN (scost != acost
                     AND ABS(scost - acost) < 10 ^ (-1 * <? value("costscale") ?>))
               THEN ''altemphasis'' 
          END AS qtforegroundrole,
        <? endif ?> 
        ''cost'' AS scost_xtnumericrole,
        ''cost'' AS acost_xtnumericrole 
      <? elseif exists("bySummrey") ?>
        itemcost_id,
        CASE WHEN (costelem_sys) THEN 1
          ELSE 0
        END,
        costelem_type, formatBoolYN(itemcost_lowlevel) AS lowlevel,
        itemcost_stdcost,
        currToBase(itemcost_curr_id, itemcost_actcost, NULL) AS itemcost_actcost,
        itemcost_updated, itemcost_posted,
        ''cost'' AS itemcost_stdcost_xtnumericrole,
        ''cost'' AS itemcost_actcost_xtnumericrole,
        0 AS itemcost_stdcost_xttotalrole,
        0 AS itemcost_actcost_xttotalrole,
        CASE WHEN COALESCE(itemcost_posted, endOfTime()) >= endOfTime() 
             THEN <? value("never") ?>
        END AS itemcost_posted_qtdisplayrole,
        CASE WHEN COALESCE(itemcost_updated, endOfTime()) >= endOfTime()
             THEN <? value("never") ?>
        END AS itemcost_updated_qtdisplayrole
      <? endif ?>
FROM <? if exists("byClassCode") ?>
       (SELECT item_id, item_number, item_active,
               (item_descrip1 || '' '' || item_descrip2) AS description,
               uom_name, stdcost(item_id) AS scost, actcost(item_id) AS acost
        FROM item, classcode, uom
        WHERE ((item_classcode_id=classcode_id)
          AND  (item_inv_uom_id=uom_id)
          <? if exists("classcode_id") ?>
            AND (classcode_id=<? value("classcode_id") ?>)
          <? elseif exists("classcode_pattern") ?>
            AND (classcode_code ~ <? value("classcode_pattern") ?>)
          <? endif ?> 
              ) ) AS data 
     <? elseif exists("byHistory") ?>
       costhist,costelem
     <? elseif exists("bySummrey") ?>
       itemcost, costelem
     <? endif ?>   
WHERE ( <? if exists("byHistory") ?>
         (costhist_costelem_id=costelem_id)
     AND (costhist_item_id=<? value("item_id") ?>)
        <? elseif exists("byClassCode") ?> 
          true 
          <? if exists("onlyShowZeroCosts") ?>
            AND ((scost=0) OR (acost=0)) 
          <? endif ?> 
          <? if exists("onlyShowDiffCosts") ?>
            AND (scost != acost) 
            AND (ABS(scost - acost) > 10 ^ (-1 * <? value("costscale") ?>))
          <? endif ?>
          <? if exists("onlyShowActive") ?>
            AND (item_active) 
          <? endif ?> 
        <? elseif exists("bySummrey") ?>
          (itemcost_costelem_id=costelem_id)
      AND (itemcost_item_id=<? value("item_id") ?>)
        <? endif ?>
      ) 
ORDER BY <? if exists("byHistory") ?>
           costhist_date, costelem_type;
         <? elseif exists("byClassCode") ?> 
           item_number;
         <? elseif exists("bySummrey") ?>
           itemcost_lowlevel, costelem_type;
         <? endif ?>
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (430, 'itemPricingSchedule', 'detail', 'used by itemPricingSchedule Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: itemPricingSchedule
-- Name: detail
-- Notes: used by itemPricingSchedule
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.


SELECT ipsitem_id AS id, 1 AS altid,
       CASE WHEN (ipsitem_item_id IS NOT NULL) THEN <? value("item") ?>
            ELSE <? value("prodcat") ?>
       END AS target,
       COALESCE(item_number, prodcat_code) AS number,
       COALESCE(item_descrip1 || '' '' || item_descrip2, prodcat_descrip) AS descrip,
       qty.uom_name AS qtyuom, ipsitem_qtybreak AS qtybreak,
       price.uom_name AS priceuom,
       ((COALESCE(ipsitem_discntprcnt, 0.0) * 100) + ipsitem_price) AS price,
       (COALESCE(ipsitem_fixedamtdiscount, 0.0) + 0.00) AS fixedAmt,
       noNeg(CASE WHEN (ipsitem_type=''N'') THEN
                   ipsitem_price
                  WHEN (ipsitem_type=''D'') THEN
                   (item_listprice - (item_listprice * COALESCE(ipsitem_discntprcnt, 0.0)) - COALESCE(ipsitem_fixedamtdiscount, 0.0))
                  WHEN ((ipsitem_type = ''M'') AND fetchMetricBool(''Long30Markups'') AND fetchMetricBool(''WholesalePriceCosting'')) THEN
                   (item_listcost / (1.0 - ipsitem_discntprcnt) + ipsitem_fixedamtdiscount)
                  WHEN ((ipsitem_type = ''M'') AND fetchMetricBool(''Long30Markups'')) THEN
                   (itemCost(itemsite_id) / (1.0 - ipsitem_discntprcnt) + ipsitem_fixedamtdiscount)
                  WHEN (ipsitem_type = ''M'' AND fetchMetricBool(''WholesalePriceCosting'')) THEN
                   (item_listcost + (item_listcost * ipsitem_discntprcnt) + ipsitem_fixedamtdiscount)
                  WHEN (ipsitem_type = ''M'') THEN
                   (itemCost(itemsite_id) + (itemCost(itemsite_id) * ipsitem_discntprcnt) + ipsitem_fixedamtdiscount)
                  ELSE 0.0
             END) AS netPrice,
       CASE WHEN (ipsitem_type=''N'') THEN <? value("nominal") ?>
            WHEN (ipsitem_type=''D'') THEN <? value("discount") ?>
            WHEN (ipsitem_type=''M'') THEN <? value("markup") ?>
            ELSE ''error''
       END AS type,
       CASE WHEN (ipsitem_type=''N'') THEN <? value("price") ?>
            WHEN ((ipsitem_type IN (''D'', ''M'')) AND (COALESCE(ipsitem_discntprcnt, 0.0)=0.0) AND (COALESCE(ipsitem_fixedamtdiscount, 0.0)<>0.0)) THEN <? value("fixed") ?>
            WHEN ((ipsitem_type IN (''D'', ''M'')) AND (COALESCE(ipsitem_discntprcnt, 0.0)<>0.0) AND (COALESCE(ipsitem_fixedamtdiscount, 0.0)=0.0)) THEN <? value("percent") ?>
            WHEN (ipsitem_type IN (''D'', ''M'')) THEN <? value("mixed") ?>
            ELSE ''error''
       END AS method,
       ''qty'' AS qtybreak_xtnumericrole,
       ''salesprice'' AS netPrice_xtnumericrole,
       ''salesprice'' AS price_xtnumericrole
FROM ipsiteminfo LEFT OUTER JOIN item ON (item_id=ipsitem_item_id)
                 LEFT OUTER JOIN prodcat ON (prodcat_id=ipsitem_prodcat_id)
                 LEFT OUTER JOIN uom AS qty ON (qty.uom_id=ipsitem_qty_uom_id)
                 LEFT OUTER JOIN uom AS price ON (price.uom_id=ipsitem_price_uom_id)
                 LEFT OUTER JOIN itemsite ON (itemsite_item_id=item_id AND itemsite_warehous_id=<? value("warehous_id") ?>)
WHERE (ipsitem_ipshead_id=<? value("ipshead_id") ?>)

UNION

SELECT ipsfreight_id AS id, 2 AS altid, <? value("freight") ?> AS type,
       CASE WHEN (ipsfreight_type=''F'') THEN <? value("flatrate") ?>
            ELSE <? value("peruom") ?>
       END AS number,
       (''From '' || COALESCE(warehous_code, <? value("allsites") ?>) || '' To '' || COALESCE(shipzone_name, <? value("allzones") ?>)) AS descrip,
       CASE WHEN (ipsfreight_type=''P'') THEN uom_name END AS qtyuom,
       CASE WHEN (ipsfreight_type=''P'') THEN ipsfreight_qtybreak END AS qtybreak,
       uom_name AS priceuom, ipsfreight_price AS price,
       0.00 AS fixedAmt,
       NULL AS netPrice,
       NULL AS type,
       NULL AS method,
       ''weight'' AS qtybreak_xtnumericrole,
       ''salesprice'' AS netPrice_xtnumericrole,
       ''salesprice'' AS price_xtnumericrole
FROM ipsfreight LEFT OUTER JOIN uom ON (uom_item_weight)
                LEFT OUTER JOIN whsinfo ON (warehous_id=ipsfreight_warehous_id)
                LEFT OUTER JOIN shipzone ON (shipzone_id=ipsfreight_shipzone_id)
WHERE ( (ipsfreight_ipshead_id=<? value("ipshead_id") ?>) )
ORDER BY altid, number, qtybreak;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (247, 'frozenItemSites', 'detail', 'used by dspFrozenItemSites Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: frozenItemSites
-- Name: detail
-- Notes: used by dspFrozenItemSites
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT itemsite_id, warehous_code, item_number,
        (item_descrip1 || '' '' || item_descrip2) AS descrip,
        COALESCE((SELECT invcnt_tagnumber
                  FROM invcnt
                  WHERE ((NOT invcnt_posted)
                          AND (invcnt_itemsite_id=itemsite_id)) LIMIT 1), '''') AS cnttag
FROM itemsite, item, whsinfo
WHERE ( (itemsite_item_id=item_id)
    AND (itemsite_warehous_id=warehous_id)
    AND (itemsite_freeze)
<? if exists("warehous_id") ?>
    AND (itemsite_warehous_id=<? value("warehous_id") ?>)
<? endif ?>
      )
ORDER BY warehous_code, item_number;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (415, 'glseries', 'postjournal', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: glseries
-- Name:  postjournal
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT postJournals(<? value("sequence") ?>) AS result;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (252, 'invalidBillsofMaterials', 'detail', 'used by dspInvalidBillsOfMaterials Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: invalidBillsofMaterials
-- Name: detail
-- Notes: used by dspInvalidBillsOfMaterials
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT itemsite_id, parent.item_id AS pitem_id,
       component.item_id AS citem_id,
       warehous_id, warehous_code,
       parent.item_number AS parentitem,
       component.item_number AS componentitem,
       (component.item_descrip1 || '' '' || component.item_descrip2) AS descrip
FROM bomitem, itemsite, item AS parent, item AS component, whsinfo
WHERE ((bomitem_parent_item_id=parent.item_id)
   AND (bomitem_item_id=component.item_id)
   AND (CURRENT_DATE BETWEEN bomitem_effective AND (bomitem_expires - 1))
   AND (itemsite_item_id=parent.item_id)
   AND (itemsite_warehous_id=warehous_id)
   AND (parent.item_type=''M'')
   AND (itemsite_wosupply)
   AND (itemsite_active)
   AND (component.item_id NOT IN ( SELECT itemsite_item_id
                                   FROM itemsite
                                   WHERE ((itemsite_warehous_id=warehous_id)
                                      AND (itemsite_active)) ) ) 
<? if exists("warehous_id") ?>
   AND (warehous_id=<? value("warehous_id") ?>)
<? endif ?>
      )
ORDER BY warehous_code, parentitem, componentitem;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (56, 'itemReceipt', 'populateEdit', 'used by enterPoitemReceipt, splitReceipt ----PURCHASE ORDER---------- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: itemReceipt
-- Name: populateEdit
-- Notes: used by enterPoitemReceipt, splitReceipt
------PURCHASE ORDER----------
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT pohead_number AS order_number, poitem_linenumber AS orderitem_linenumber,
       (poitem_itemsite_id > 0) AS inventoryitem,
       COALESCE(poitem_itemsite_id, -1) AS itemsiteid,
       COALESCE(poitem_vend_item_number, '''') AS vend_item_number,
       COALESCE(poitem_vend_uom, '''') AS vend_uom,
       COALESCE(poitem_vend_item_descrip, '''') AS vend_item_descrip,
       poitem_invvenduomratio AS orderitem_qty_invuomratio,
       poitem_duedate AS duedate,
       poitem_qty_ordered AS orderitem_qty_ordered,
       recv_qty AS qtyreceived,
       poitem_qty_returned AS qtyreturned,
       qtyToReceive(''PO'', poitem_id) AS qtytoreceive,
       (poitem_qty_ordered) AS receivable,
       recv_notes AS notes, recv_freight, recv_order_type,
       recv_freight_curr_id AS curr_id, recv_date AS effective,
       recv_purchcost, recv_purchcost_curr_id,
       CASE WHEN (itemsite_costmethod=''A'' AND NOT(recv_posted)) THEN TRUE
            ELSE FALSE
       END AS costmethod_average,
       ''uomratio'' AS orderitem_qty_invuomratio_xtnumericrole,
       ''qty'' AS orderitem_qty_ordered_xtnumericrole, 
       ''qty'' AS qtyreceived_xtnumericrole, 
       ''qty'' AS qtyreturned_xtnumericrole, 
       ''qty'' AS qtytoreceive_xtnumericrole, 
       ''qty'' AS receivable_xtnumericrole,
       ''purchprice'' AS recv_purchcost_xtnumericrole 
FROM recv 
  JOIN  poitem ON ((recv_orderitem_id=poitem_id)
               AND (recv_order_type=''PO''))
  JOIN  pohead ON (poitem_pohead_id=pohead_id)
  LEFT OUTER JOIN itemsite ON (poitem_itemsite_id=itemsite_id)
WHERE (recv_id=<? value("recv_id") ?>)
<? if exists ("EnableReturnAuth") ?>
UNION
-------RETURN AUTHORIZATIONS-----------
SELECT rahead_number AS order_number, raitem_linenumber AS orderitem_linenumber,
       (raitem_itemsite_id > 0) AS inventoryitem,
       COALESCE(raitem_itemsite_id, -1) AS itemsiteid,
       '''' AS vend_item_number,
       '''' AS vend_uom,
       '''' AS vend_item_descrip,
       raitem_qty_invuomratio AS orderitem_qty_invuomratio,
       raitem_scheddate AS duedate,
       raitem_qtyauthorized AS orderitem_qty_ordered,
       recv_qty AS qtyreceived,
       0 AS qtyreturned,
       qtyToReceive(''RA'', raitem_id) AS qtytoreceive,
       (raitem_qtyauthorized) AS receivable,
       recv_notes AS notes, recv_freight, recv_order_type,
       recv_freight_curr_id AS curr_id, recv_date AS effective,
       NULL AS recv_purchcost, NULL AS recv_purchcost_curr_id,
       NULL AS costmethod_average,
       ''uomratio'' AS orderitem_qty_invuomratio_xtnumericrole,
       ''qty'' AS orderitem_qty_ordered_xtnumericrole, 
       ''qty'' AS qtyreceived_xtnumericrole, 
       ''qty'' AS qtyreturned_xtnumericrole, 
       ''qty'' AS qtytoreceive_xtnumericrole, 
       ''qty'' AS receivable_xtnumericrole,
       ''purchprice'' AS recv_purchcost_xtnumericrole 
FROM recv
  JOIN  raitem ON ((recv_orderitem_id=raitem_id)
               AND (recv_order_type=''RA''))
  JOIN  rahead ON (raitem_rahead_id=rahead_id)
WHERE (recv_id=<? value("recv_id") ?>)
<? endif ?>
<? if exists ("MultiWhs") ?>
UNION
----------TRANSFER ORDERS---------
SELECT tohead_number AS order_number, toitem_linenumber AS orderitem_linenumber,
       (itemsite_id > 0) AS inventoryitem,
       itemsite_id AS itemsiteid,
       '''' AS vend_item_number,
       '''' AS vend_uom,
       '''' AS vend_item_descrip,
       1 AS orderitem_qty_invuomratio,
       toitem_duedate AS duedate,
       toitem_qty_ordered AS orderitem_qty_ordered,
       recv_qty AS qtyreceived,
       0 AS qtyreturned,
       qtyToReceive(''TO'', toitem_id) AS qtytoreceive,
       (toitem_qty_ordered) AS receivable,
       recv_notes AS notes, recv_freight, recv_order_type,
       recv_freight_curr_id AS curr_id, recv_date AS effective,
       NULL AS recv_purchcost, NULL AS recv_purchcost_curr_id,
       NULL AS costmethod_average,
       ''uomratio'' AS orderitem_qty_invuomratio_xtnumericrole,
       ''qty'' AS orderitem_qty_ordered_xtnumericrole, 
       ''qty'' AS qtyreceived_xtnumericrole, 
       ''qty'' AS qtyreturned_xtnumericrole, 
       ''qty'' AS qtytoreceive_xtnumericrole, 
       ''qty'' AS receivable_xtnumericrole,
       ''purchprice'' AS recv_purchcost_xtnumericrole 
FROM itemsite, recv
  JOIN  toitem ON ((recv_orderitem_id=toitem_id)
               AND (recv_order_type=''TO''))
  JOIN  tohead ON (toitem_tohead_id=tohead_id)
WHERE ((recv_id=<? value("recv_id") ?>)
  AND  (tohead_dest_warehous_id=itemsite_warehous_id)
  AND  (toitem_item_id=itemsite_item_id))
<? endif ?>;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (429, 'invoices', 'print', 'used by printInvoices Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: invoices
-- Name: print
-- Notes: used by printInvoices
--        Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
--        See www.xtuple.com/CPAL for the full text of the software license.

SELECT invchead_id,          invchead_id         AS docid,
       invchead_invcnumber,  invchead_invcnumber AS docnumber,
       invchead_ordernumber, invchead_posted     AS posted,
       findCustomerForm(invchead_cust_id, ''I'')   AS reportname
  FROM invchead
  WHERE (NOT invchead_printed)
    AND (NOT invchead_posted)
    AND (checkInvoiceSitePrivs(invchead_id))
<? if exists("shipvia") ?>
    AND (invchead_shipvia=<? value("shipvia") ?>) 
<? endif ?>
ORDER BY invchead_ordernumber;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (57, 'itemReceipt', 'populateNew', 'used by enterPoitemReceipt -------PURCHASE ORDERS------------- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: itemReceipt
-- Name: populateNew
-- Notes: used by enterPoitemReceipt
---------PURCHASE ORDERS-------------
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT pohead_number AS order_number, poitem_linenumber AS orderitem_linenumber,
       (poitem_itemsite_id > 0) AS inventoryitem,
       COALESCE(poitem_itemsite_id, -1) AS itemsiteid,
       COALESCE(poitem_vend_item_number, '''') AS vend_item_number,
       COALESCE(poitem_vend_uom, '''') AS vend_uom,
       COALESCE(poitem_vend_item_descrip, '''') AS vend_item_descrip,
       poitem_invvenduomratio AS orderitem_qty_invuomratio,
       poitem_duedate AS duedate,
       poitem_qty_ordered AS orderitem_qty_ordered,
       poitem_qty_received AS qtyreceived,
       poitem_qty_returned AS qtyreturned,
       qtyToReceive(''PO'', poitem_id) AS qtytoreceive,
       (poitem_qty_ordered - poitem_qty_received) AS receivable,
       ( SELECT recv_notes
           FROM recv
          WHERE ((recv_orderitem_id=poitem_id)
	    AND  (recv_order_type=''PO'')
            AND  (NOT recv_posted))
	  LIMIT 1 ) AS notes,
       COALESCE(freightForRecv(''PO'', poitem_id, false),
		poitem_freight - freightForRecv(''PO'', poitem_id, true),
		freightForRecv(''PO'', poitem_id, true)) AS recv_freight,
       pohead_curr_id AS curr_id, CURRENT_DATE AS effective, 
       poitem_unitprice AS recv_purchcost,
       pohead_curr_id AS recv_purchcost_curr_id,
       CASE WHEN (itemsite_costmethod=''A'') THEN TRUE 
	    ELSE FALSE 
       END AS costmethod_average,
       ''uomratio'' AS orderitem_qty_invuomratio_xtnumericrole,
       ''qty'' AS orderitem_qty_ordered_xtnumericrole, 
       ''qty'' AS qtyreceived_xtnumericrole, 
       ''qty'' AS qtyreturned_xtnumericrole, 
       ''qty'' AS qtytoreceive_xtnumericrole, 
       ''qty'' AS receivable_xtnumericrole,
       ''purchprice'' AS recv_purchcost_xtnumericrole 
FROM pohead
  JOIN poitem ON (pohead_id=poitem_pohead_id)
  LEFT OUTER JOIN itemsite ON (poitem_itemsite_id=itemsite_id)
WHERE ((poitem_status <> ''C'')
  AND  (poitem_id=<? value("orderitem_id") ?>)
  AND  (''PO''=<? value("ordertype") ?>) )
<? if exists ("EnableReturnAuth") ?>
UNION
---------RETURN AUTHORIZATIONS-------------
SELECT rahead_number AS order_number, raitem_linenumber AS orderitem_linenumber,
       (raitem_itemsite_id > 0) AS inventoryitem,
       COALESCE(raitem_itemsite_id, -1) AS itemsiteid,
       '''' AS vend_item_number,
       '''' AS vend_uom,
       '''' AS vend_item_descrip,
       raitem_qty_invuomratio AS orderitem_qty_invuomratio,
       raitem_scheddate AS duedate,
       raitem_qtyauthorized AS orderitem_qty_ordered,
       raitem_qtyreceived AS qtyreceived,
       0 AS qtyreturned,
       qtyToReceive(''RA'', raitem_id) AS qtytoreceive,
       (raitem_qtyauthorized - raitem_qtyreceived) AS receivable,
       ( SELECT recv_notes
           FROM recv
          WHERE ((recv_orderitem_id=raitem_id)
	    AND  (recv_order_type=''RA'')
            AND  (NOT recv_posted))
	  LIMIT 1 ) AS notes,
       COALESCE(freightForRecv(''RA'', raitem_id, false),
		freightForRecv(''RA'', raitem_id, true)) AS recv_freight,
       rahead_curr_id AS curr_id, CURRENT_DATE AS effective, 
       NULL AS recv_purchcost, NULL AS recv_purchcost_curr_id,
       NULL AS costmethod_average,
       ''uomratio'' AS orderitem_qty_invuomratio_xtnumericrole,
       ''qty'' AS orderitem_qty_ordered_xtnumericrole, 
       ''qty'' AS qtyreceived_xtnumericrole, 
       ''qty'' AS qtyreturned_xtnumericrole, 
       ''qty'' AS qtytoreceive_xtnumericrole, 
       ''qty'' AS receivable_xtnumericrole,
       ''purchprice'' AS recv_purchcost_xtnumericrole 
FROM rahead
  JOIN raitem ON (rahead_id=raitem_rahead_id)
WHERE ((raitem_status <> ''C'')
  AND  (raitem_id=<? value("orderitem_id") ?>)
  AND  (''RA''=<? value("ordertype") ?>) )
<? endif ?>
<? if exists ("MultiWhs") ?>
UNION
-------------TRANSFER ORDERS--------------
SELECT tohead_number AS order_number, toitem_linenumber AS orderitem_linenumber,
       (itemsite_id > 0) AS inventoryitem,
       COALESCE(itemsite_id, -1) AS itemsiteid,
       '''' AS vend_item_number,
       '''' AS vend_uom,
       '''' AS vend_item_descrip,
       1 AS orderitem_qty_invuomratio,
       toitem_duedate AS duedate,
       toitem_qty_ordered AS orderitem_qty_ordered,
       toitem_qty_received AS qtyreceived,
       toitem_qty_shipped AS qtyreturned,
       qtyToReceive(''TO'', toitem_id) AS qtytoreceive,
       (toitem_qty_ordered - toitem_qty_received) AS receivable,
       ( SELECT recv_notes
           FROM recv
          WHERE ((recv_orderitem_id=toitem_id)
	    AND  (recv_order_type=''TO'')
            AND  (NOT recv_posted))
	  LIMIT 1 ) AS notes,
       COALESCE(freightForRecv(''TO'', toitem_id, false),
		freightForRecv(''TO'', toitem_id, true)) AS recv_freight,
       baseCurrId() AS curr_id, CURRENT_DATE AS effective, 
       NULL AS recv_purchcost, NULL AS recv_purchcost_curr_id,
       NULL AS costmethod_average,
       ''uomratio'' AS orderitem_qty_invuomratio_xtnumericrole,
       ''qty'' AS orderitem_qty_ordered_xtnumericrole, 
       ''qty'' AS qtyreceived_xtnumericrole, 
       ''qty'' AS qtyreturned_xtnumericrole, 
       ''qty'' AS qtytoreceive_xtnumericrole, 
       ''qty'' AS receivable_xtnumericrole,
       ''purchprice'' AS recv_purchcost_xtnumericrole 
FROM itemsite, tohead
  JOIN toitem ON (tohead_id=toitem_tohead_id) 
WHERE ((toitem_status NOT IN (''C'', ''X''))
  AND  (toitem_id=<? value("orderitem_id") ?>)
  AND  (''TO''=<? value("ordertype") ?>)
  AND  (tohead_dest_warehous_id=itemsite_warehous_id)
  AND  (toitem_item_id=itemsite_item_id))
<? endif ?>;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (260, 'itemSources', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: itemSources
-- Name: detail
-- Notes: 
--        Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
--        See www.xtuple.com/CPAL for the full text of the software license.
<? if not exists("defaultOnly") ?>
  SELECT itemsrc_id, 
       vend_name, 
       item_number, uom_name,
       (item_descrip1 || '' '' || item_descrip2) AS item_descrip,
       contrct_number,
       COALESCE( (SELECT SUM(poitem_qty_ordered)
                  FROM poitem
                  WHERE (poitem_itemsrc_id=itemsrc_id)), 0.0) AS purchased_qty,
       itemsrc.*,
       ''qty'' AS itemsrc_invvendoruomratio_xtnumericrole,
       CASE WHEN COALESCE(itemsrc_effective, startOfTime()) <=
                 startOfTime() THEN <? value("always") ?>
       END AS itemsrc_effective_qtdisplayrole,
       CASE WHEN COALESCE(itemsrc_expires, endOfTime()) >=
                 endOfTime() THEN <? value("never") ?>
       END AS itemsrc_expires_qtdisplayrole,
       CASE WHEN (COALESCE(itemsrc_expires, endOfTime()) < CURRENT_DATE) THEN ''expired''
            WHEN (COALESCE(itemsrc_effective, startOfTime()) > CURRENT_DATE) THEN ''future''
       END AS qtforegroundrole
  FROM itemsrc JOIN vendinfo ON (vend_id=itemsrc_vend_id AND vend_active)
               JOIN item ON (item_id=itemsrc_item_id)
               JOIN uom ON (uom_id=item_inv_uom_id)
               LEFT OUTER JOIN contrct ON (contrct_id=itemsrc_contrct_id) 
  WHERE ((true)
<? if not exists("showInactive") ?>
   AND (itemsrc_active)
<? endif ?>
<? if exists("item_id") ?>
   AND (itemsrc_item_id=<? value("item_id") ?>)
<? endif ?>
<? if exists("vend_id") ?>
   AND (itemsrc_vend_id=<? value("vend_id") ?>)
<? endif ?>
<? if exists("contrct_id") ?>
   AND (itemsrc_contrct_id=<? value("contrct_id") ?>)
<? endif ?>
<? if exists("contract_number_pattern") ?>
   AND (contrct_number ~* <? value("contract_number_pattern") ?>)
<? endif ?>
<? if not exists("showExpired") ?>
   AND (itemsrc_expires > CURRENT_DATE)
<? endif ?>
<? if not exists("showFuture") ?>
   AND (itemsrc_effective <= CURRENT_DATE)
<? endif ?>
)
<? if exists("item_id") ?>
ORDER BY itemsrc_contrct_id, itemsrc_ranking, vend_name,
         itemsrc_vend_item_number, itemsrc_manuf_name,
         itemsrc_manuf_item_number
<? else ?>
ORDER By item_number, vend_name
<? endif ?>
<? else ?>
  SELECT itemsrc_id, 0 AS ranked FROM itemsrc, contrct 
    WHERE ((itemsrc_item_id= <? value("item_id") ?>) AND (itemsrc_default) 
           AND (contrct_id = itemsrc_contrct_id)) 
  UNION 
  SELECT itemsrc_id, 2 AS ranked 
    FROM itemsrc JOIN (SELECT * FROM 
                        (SELECT CASE WHEN ((itemsrc_item_id=<? value("item_id") ?>) AND (NOT itemsrc_default)
                                            AND (contrct_id = itemsrc_contrct_id)) THEN -1
                                     ELSE itemsrc_id
                                END AS dummy_id FROM itemsrc, contrct 
                           WHERE ((itemsrc_item_id=<? value("item_id") ?>) AND (NOT itemsrc_default) 
                                  AND (contrct_id = itemsrc_contrct_id))
                         UNION 
                         SELECT itemsrc_id AS dummy_id 
                           FROM itemsrc 
                           WHERE ((itemsrc_item_id=<? value("item_id") ?>) AND (itemsrc_default))
                         ) AS dummy
                       LIMIT 1) AS dummy2
                        ON (itemsrc_id=dummy_id)
    WHERE ((itemsrc_item_id=<? value("item_id") ?>) AND (itemsrc_default) AND (COALESCE(itemsrc_contrct_id,0)=0))

ORDER by ranked
<? endif ?>
;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (476, 'itemSources', 'prices', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: itemSources
-- Name: prices
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT itemsrcp_id, itemsrc_id,
       vend_number, vend_name,
       currConcat(vend_curr_id) AS vend_curr,
       item_number,
       (item_descrip1 || '' '' || item_descrip2) AS item_descrip,
       warehous_code, uom_name,
       contrct_number,
       itemsrc.*,
       (itemsrc_vend_item_number || ''/'' || itemsrc_manuf_item_number) AS itemsrc_descrip,
       itemsrcp.*,
       currConcat(itemsrcp_curr_id) AS item_curr,
       noNeg(CASE WHEN (itemsrcp_type=''N'') THEN currToBase(itemsrcp_curr_id, itemsrcp_price, itemsrcp_updated)
                  WHEN (itemsrcp_type=''D'') THEN (item_listcost - (item_listcost * COALESCE(itemsrcp_discntprcnt, 0.0)) - COALESCE(itemsrcp_fixedamtdiscount, 0.0))
                  ELSE 0.0
             END) AS price_base,
       noNeg(CASE WHEN (itemsrcp_type=''N'') THEN itemsrcp_price
                  WHEN (itemsrcp_type=''D'') THEN (item_listcost - (item_listcost * COALESCE(itemsrcp_discntprcnt, 0.0)) - COALESCE(itemsrcp_fixedamtdiscount, 0.0))
                  ELSE 0.0
             END) AS price_local,
       CASE WHEN (itemsrcp_type=''N'') THEN <? value("nominal") ?>
            WHEN (itemsrcp_type=''D'') THEN <? value("discount") ?>
            ELSE ''error''
       END AS type,
       CASE WHEN (itemsrcp_type=''N'') THEN <? value("price") ?>
            WHEN ((itemsrcp_type=''D'') AND (COALESCE(itemsrcp_discntprcnt, 0.0)=0.0) AND (COALESCE(itemsrcp_fixedamtdiscount, 0.0)<>0.0)) THEN <? value("fixed") ?>
            WHEN ((itemsrcp_type=''D'') AND (COALESCE(itemsrcp_discntprcnt, 0.0)<>0.0) AND (COALESCE(itemsrcp_fixedamtdiscount, 0.0)=0.0)) THEN <? value("percent") ?>
            WHEN (itemsrcp_type=''D'') THEN <? value("mixed") ?>
            ELSE ''error''
       END AS method,
       ''qty'' AS itemsrc_invvendoruomratio_xtnumericrole,
       ''qty'' AS itemsrc_minordqty_xtnumericrole,
       ''qty'' AS itemsrc_ordqtymult_xtnumericrole,
       ''qty'' AS itemsrcp_qtybreak_xtnumericrole,
       ''purchprice'' AS price_local_xtnumericrole,
       ''purchprice'' AS price_base_xtnumericrole,
       ''percent'' AS itemsrcp_discntprcnt_xtnumericrole,
       CASE WHEN (warehous_code IS NULL) THEN <? value("all") ?>
       END AS warehous_code_qtdisplayrole,
       CASE WHEN (itemsrcp_dropship) THEN <? value("dropship") ?>
            ELSE <? value("stock") ?>
       END AS itemsrcp_dropship_qtdisplayrole,
       CASE WHEN COALESCE(itemsrc_effective, startOfTime()) <=
                 startOfTime() THEN <? value("always") ?>
       END AS itemsrc_effective_qtdisplayrole,
       CASE WHEN COALESCE(itemsrc_expires, endOfTime()) >=
                 endOfTime() THEN <? value("never") ?>
       END AS itemsrc_expires_qtdisplayrole,
       CASE WHEN (COALESCE(itemsrc_expires, endOfTime()) < CURRENT_DATE) THEN ''expired''
            WHEN (COALESCE(itemsrc_effective, startOfTime()) > CURRENT_DATE) THEN ''future''
       END AS qtforegroundrole
FROM itemsrc JOIN vendinfo ON (vend_id=itemsrc_vend_id AND vend_active)
             JOIN item ON (item_id=itemsrc_item_id)
             JOIN uom ON (uom_id=item_inv_uom_id)
             JOIN itemsrcp ON (itemsrcp_itemsrc_id=itemsrc_id)
             LEFT OUTER JOIN contrct ON (contrct_id=itemsrc_contrct_id)
             LEFT OUTER JOIN whsinfo ON (warehous_id=itemsrcp_warehous_id)
WHERE ((true)
<? if not exists("showInactive") ?>
   AND (itemsrc_active)
<? endif ?>
<? if exists("item_id") ?>
  AND (itemsrc_item_id=<? value("item_id") ?>)
<? endif ?>
<? if exists("vend_id") ?>
  AND (itemsrc_vend_id=<? value("vend_id") ?>)
<? endif ?>
<? if exists("itemsrc_id") ?>
  AND (itemsrc_id=<? value("itemsrc_id") ?>)
<? endif ?>
<? if exists("warehous_id") ?>
  AND (itemsrcp_warehous_id=<? value("warehous_id") ?>)
<? endif ?>
<? if exists("showDropShip") ?>
   AND (itemsrcp_dropship)
<? endif ?>
<? if exists("search_pattern") ?>
  AND ( (item_number ~* <? value("search_pattern") ?>)
    OR  (COALESCE(item_descrip1,'''') || COALESCE(item_descrip2,'''') ~* <? value("search_pattern") ?>) )
<? endif ?>
<? if exists("item_number_pattern") ?>
  AND (item_number ~* <? value("item_number_pattern") ?>)
<? endif ?>
<? if exists("item_descrip_pattern") ?>
  AND (COALESCE(item_descrip1,'''') || COALESCE(item_descrip2,'''') ~* <? value("item_descrip_pattern") ?>)
<? endif ?>
<? if exists("contrct_id") ?>
  AND (itemsrc_contrct_id=<? value("contrct_id") ?>)
<? endif ?>
<? if exists("contract_number_pattern") ?>
  AND (contrct_number ~* <? value("contract_number_pattern") ?>)
<? endif ?>
<? if exists("vend_name_pattern") ?>
  AND (vend_name ~* <? value("vend_name_pattern") ?>)
<? endif ?>
<? if exists("vend_item_number_pattern") ?>
  AND (itemsrc_vend_item_number ~* <? value("vend_item_number_pattern") ?>)
<? endif ?>
<? if exists("manuf_pattern") ?>
  AND (itemsrc_manuf_name ~* <? value("manuf_pattern") ?>)
<? endif ?>
<? if exists("manuf_item_number_pattern") ?>
  AND (itemsrc_manuf_item_number ~* <? value("manuf_item_number_pattern") ?>)
<? endif ?>
<? if exists("effectiveStartDate") ?>
  AND (COALESCE(contrct_effective, itemsrc_effective) >= <? value("effectiveStartDate") ?>)
<? endif ?>
<? if exists("effectiveEndDate") ?>
  AND (COALESCE(contrct_effective, itemsrc_effective) <= <? value("effectiveEndDate") ?>)
<? endif ?>
<? if exists("expireStartDate") ?>
  AND (COALESCE(contrct_expires, itemsrc_expires) >= <? value("expireStartDate") ?>)
<? endif ?>
<? if exists("expireEndDate") ?>
  AND (COALESCE(contrct_expires, itemsrc_expires) <= <? value("expireEndDate") ?>)
<? endif ?>
)
ORDER By item_number, vend_name, itemsrcp_qtybreak
;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (477, 'itemSources', 'search', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: itemSources
-- Name: search
-- Notes: 
--        Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
--        See www.xtuple.com/CPAL for the full text of the software license.

  SELECT itemsrc_id AS id,
         1 AS altid,
         item_number,
         (item_descrip1 || '' '' || item_descrip2) AS item_descrip,
         vend_name,
         itemsrc_vend_item_number,
         itemsrc_vend_item_descrip,
         itemsrc_manuf_name,
         itemsrc_manuf_item_number,
         itemsrc_manuf_item_descrip,
         contrct_number
    FROM vendinfo JOIN itemsrc ON (itemsrc_vend_id=vend_id)
                  JOIN item ON (item_id=itemsrc_item_id)
       LEFT OUTER JOIN contrct ON (itemsrc_contrct_id = contrct_id)
   WHERE (vend_id=<? value("vend_id") ?>)
     AND ( (FALSE)
<? if exists("searchNumber") ?>
        OR (item_number ~* <? value("searchNumber") ?>)
<? endif ?>
<? if exists("searchVendNumber") ?>
        OR (itemsrc_vend_item_number ~* <? value("searchVendNumber") ?>)
<? endif ?>
<? if exists("searchDescrip1") ?>
        OR (item_descrip1 ~* <? value("searchDescrip1") ?>)
<? endif ?>
<? if exists("searchDescrip2") ?>
        OR (item_descrip2 ~* <? value("searchDescrip2") ?>)
<? endif ?>
<? if exists("searchVendDescrip") ?>
        OR (itemsrc_vend_item_descrip ~* <? value("searchVendDescrip") ?>)
<? endif ?>
<? if exists("searchManufName") ?>
        OR (itemsrc_manuf_name ~* <? value("searchManufName") ?>)
<? endif ?>
<? if exists("searchManufNumber") ?>
        OR (itemsrc_manuf_item_number ~* <? value("searchManufNumber") ?>)
<? endif ?>
       )
  UNION
  SELECT DISTINCT poitem_expcat_id AS id,
                  2 AS altid,
                  <? value("non") ?> AS item_number,
                  (expcat_code || '' '' || expcat_descrip) AS item_descrip,
                  vend_name,
                  poitem_vend_item_number,
                  poitem_vend_item_descrip,
                  poitem_manuf_name,
                  poitem_manuf_item_number,
                  poitem_manuf_item_descrip,
                  null AS contrct_id 
    FROM vendinfo JOIN pohead ON (pohead_vend_id=vend_id)
                  JOIN poitem ON (poitem_pohead_id=pohead_id)
                  LEFT OUTER JOIN expcat ON (poitem_expcat_id=expcat_id)
   WHERE (vend_id=<? value("vend_id") ?>)
     AND (COALESCE(poitem_vend_item_number, '''')!='''')
     AND (poitem_itemsite_id IS NULL)
     AND ( (FALSE)
<? if exists("searchVendNumber") ?>
        OR (poitem_vend_item_number ~* <? value("searchVendNumber") ?>)
<? endif ?>
<? if exists("searchDescrip1") ?>
        OR (expcat_code ~* <? value("searchDescrip1") ?>)
        OR (expcat_descrip ~* <? value("searchDescrip1") ?>)
<? endif ?>
<? if exists("searchVendDescrip") ?>
        OR (poitem_vend_item_descrip ~* <? value("searchVendDescrip") ?>)
<? endif ?>
<? if exists("searchManufName") ?>
        OR (poitem_manuf_name ~* <? value("searchManufName") ?>)
<? endif ?>
<? if exists("searchManufNumber") ?>
        OR (poitem_manuf_item_number ~* <? value("searchManufNumber") ?>)
<? endif ?>
       )
  ORDER BY item_number, vend_name;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (246, 'freightPrices', 'detail', 'used by dspFreightPricesByCustomer, dspFreightPricesByCustomerType Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: freightPrices
-- Name: detail
-- Notes: used by dspFreightPricesByCustomer, dspFreightPricesByCustomerType
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT itemid, sourcetype, ipshead_name, source, ipsfreight_qtybreak, ipsfreight_price,
       CASE WHEN (ipsfreight_type = ''F'') THEN <? value("flatrate") ?>
         ELSE <? value("peruom") ?>
       END AS method,
       currConcat(ipshead_curr_id) AS currConcat,
       warehous_code, shipzone_name, freightclass_code, ipsfreight_shipvia,
       ''qty'' AS ipsfreight_qtybreak_xtnumericrole,
       <? value("na") ?> AS ipsfreight_qtybreak_xtnullrole,
       ''salesprice'' AS ipsfreight_price_xtnumericrole,
       <? value("any") ?> AS warehous_code_xtnullrole,
       <? value("any") ?> AS shipzone_name_xtnullrole,
       <? value("any") ?> AS freightclass_code_xtnullrole,
       <? value("any") ?> AS ipsfreight_shipvia_xtnullrole
FROM (SELECT ipsfreight_id AS itemid, 1 AS sourcetype,
             ipshead_name,
<? if exists("byCust") ?>
             <? value("customer") ?> AS source,
<? elseif exists("byCustType") ?>
             <? value("custType") ?> AS source,
<? endif ?>
             ipsfreight_qtybreak, ipsfreight_price,
             ipsfreight_type, ipshead_curr_id,
             warehous_code, shipzone_name, freightclass_code, ipsfreight_shipvia
      FROM ipsass JOIN ipshead ON (ipshead_id=ipsass_ipshead_id)
           JOIN ipsfreight ON (ipsfreight_ipshead_id=ipshead_id)
           LEFT OUTER JOIN whsinfo ON (warehous_id=ipsfreight_warehous_id)
           LEFT OUTER JOIN shipzone ON (shipzone_id=ipsfreight_shipzone_id)
           LEFT OUTER JOIN freightclass ON (freightclass_id=ipsfreight_freightclass_id)
      WHERE ((true)
<? if exists("byCust") ?>
         AND (ipsass_cust_id=<? value("cust_id") ?>)
         AND (COALESCE(LENGTH(ipsass_shipto_pattern), 0) = 0)
<? elseif exists("byCustType") ?>
         AND (ipsass_custtype_id=<? value("custtype_id") ?>)
<? endif ?>
<? if not exists("showExpired") ?>
         AND (ipshead_expires > CURRENT_DATE)
<? endif ?>
<? if not exists("showFuture") ?>
         AND (ipshead_effective <= CURRENT_DATE)
<? endif ?>
            )

      UNION

      SELECT ipsfreight_id AS itemid, 2 AS sourcetype,
             ipshead_name,
<? if exists("byCust") ?>
             <? value("custType") ?> AS source,
<? elseif exists("byCustType") ?>
             <? value("custTypePattern") ?> AS source,
<? endif ?>
             ipsfreight_qtybreak, ipsfreight_price,
             ipsfreight_type, ipshead_curr_id,
             warehous_code, shipzone_name, freightclass_code, ipsfreight_shipvia
      FROM ipsass
<? if exists("byCustType") ?>
           JOIN custtype ON ((coalesce(length(ipsass_custtype_pattern), 0) > 0) AND
                                         (custtype_code ~ ipsass_custtype_pattern))
<? endif ?>
           JOIN ipshead ON (ipshead_id=ipsass_ipshead_id)
           JOIN ipsfreight ON (ipsfreight_ipshead_id=ipshead_id)
<? if exists("byCust") ?>
           JOIN custinfo ON (cust_custtype_id=ipsass_custtype_id)
<? endif ?>
           LEFT OUTER JOIN whsinfo ON (warehous_id=ipsfreight_warehous_id)
           LEFT OUTER JOIN shipzone ON (shipzone_id=ipsfreight_shipzone_id)
           LEFT OUTER JOIN freightclass ON (freightclass_id=ipsfreight_freightclass_id)
      WHERE ((true)
<? if exists("byCust") ?>
         AND (cust_id=<? value("cust_id") ?>)
<? elseif exists("byCustType") ?>
         AND (custtype_id=<? value("custtype_id") ?>)
<? endif ?>
<? if not exists("showExpired") ?>
         AND (ipshead_expires > CURRENT_DATE)
<? endif ?>
<? if not exists("showFuture") ?>
         AND (ipshead_effective <= CURRENT_DATE)
<? endif ?>
            )

      UNION

      SELECT ipsfreight_id AS itemid, 3 AS sourcetype,
             ipshead_name,
<? if exists("byCust") ?>
             <? value("custTypePattern") ?> AS source,
<? elseif exists("byCustType") ?>
             (<? value("sale") ?> || ''-'' || sale_name) AS source,
<? endif ?>
             ipsfreight_qtybreak, ipsfreight_price,
             ipsfreight_type, ipshead_curr_id,
             warehous_code, shipzone_name, freightclass_code, ipsfreight_shipvia
      FROM
<? if exists("byCust") ?>
           custinfo JOIN custtype ON (custtype_id=cust_custtype_id)
                JOIN ipsass ON ((coalesce(length(ipsass_custtype_pattern), 0) > 0) AND
                                (custtype_code ~ ipsass_custtype_pattern))
                JOIN ipshead ON (ipshead_id=ipsass_ipshead_id)
<? elseif exists("byCustType") ?>
           sale JOIN ipshead ON (ipshead_id=sale_ipshead_id)
<? endif ?>
                JOIN ipsfreight ON (ipsfreight_ipshead_id=ipshead_id)
                LEFT OUTER JOIN whsinfo ON (warehous_id=ipsfreight_warehous_id)
                LEFT OUTER JOIN shipzone ON (shipzone_id=ipsfreight_shipzone_id)
                LEFT OUTER JOIN freightclass ON (freightclass_id=ipsfreight_freightclass_id)
      WHERE ((true)
<? if exists("byCust") ?>
         AND (cust_id=<? value("cust_id") ?>)
<? elseif exists("byCustType") ?>
         AND (true)
<? endif ?>
<? if not exists("showExpired") ?>
  <? if exists("byCust") ?>
         AND (ipshead_expires > CURRENT_DATE)
  <? elseif exists("byCustType") ?>
         AND (sale_enddate > CURRENT_DATE)
  <? endif ?>
<? endif ?>
<? if not exists("showFuture") ?>
  <? if exists("byCust") ?>
         AND (ipshead_effective <= CURRENT_DATE)
  <? elseif exists("byCustType") ?>
         AND (sale_startdate <= CURRENT_DATE)
  <? endif ?>
<? endif ?>
            )

<? if exists("byCust") ?>
      UNION

      SELECT ipsfreight_id AS itemid, 4 AS sourcetype,
             ipshead_name, (<? value("sale") ?> || ''-'' || sale_name) AS source,
             ipsfreight_qtybreak, ipsfreight_price,
             ipsfreight_type, ipshead_curr_id,
             warehous_code, shipzone_name, freightclass_code, ipsfreight_shipvia
      FROM sale JOIN ipshead ON (ipshead_id=sale_ipshead_id)
                JOIN ipsfreight ON (ipsfreight_ipshead_id=ipshead_id)
                LEFT OUTER JOIN whsinfo ON (warehous_id=ipsfreight_warehous_id)
                LEFT OUTER JOIN shipzone ON (shipzone_id=ipsfreight_shipzone_id)
                LEFT OUTER JOIN freightclass ON (freightclass_id=ipsfreight_freightclass_id)
      WHERE ((true)
  <? if not exists("showExpired") ?>
         AND (sale_enddate > CURRENT_DATE)
  <? endif ?>
  <? if not exists("showFuture") ?>
         AND (sale_startdate <= CURRENT_DATE)
  <? endif ?>
            )
<? endif ?>
     ) AS data
ORDER BY ipsfreight_qtybreak, ipsfreight_price;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (113, 'itemcostdetail', 'detail', 'dspItemCostDetail Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: itemcostdetail
-- Name:  detail
-- Notes: dspItemCostDetail
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT id, item.item_id, seqnumber, item_number,
       (item_descrip1 || '' '' || item_descrip2) AS itemdescrip, uom_name,
       qtyper,       ''qtyper'' AS qtyper_xtnumericrole,
       scrap,        ''scrap'' AS scrap_xtnumericrole,
       cost,         ''cost'' AS cost_xtnumericrole,
       extendedcost, ''cost'' AS extendedcost_xtnumericrole,
       0 AS extendedcost_xttotalrole 
FROM uom, item, (
<? if exists("useBOM") ?>
     SELECT bomitem_id AS id, bomitem_seqnumber AS seqnumber,
            (itemuomtouomratio(bomitem_item_id, bomitem_uom_id, NULL) * bomitem_qtyper) AS qtyper,
            bomitem_scrap AS scrap,
            bomitem_item_id AS item_id,
  <? if exists("standardCost") ?>
            itemcost_stdcost AS cost,
            (itemuomtouom(bomitem_item_id, bomitem_uom_id, NULL,
                          (bomitem_qtyfxd/bomhead_batchsize + bomitem_qtyper) * (1 + bomitem_scrap), ''qtyper'') * itemcost_stdcost) AS extendedcost
  <? elseif exists("actualCost") ?>
            currToBase(itemcost_curr_id, itemcost_actcost, NULL) AS cost,
            (itemuomtouom(bomitem_item_id, bomitem_uom_id, NULL,
                          (bomitem_qtyfxd/bomhead_batchsize + bomitem_qtyper) * (1 + bomitem_scrap), ''qtyper'') *
             currToBase(itemcost_curr_id, itemcost_actcost, NULL)) AS extendedcost 
  <? endif ?>
    FROM bomitem
         JOIN itemcost ON (itemcost_item_id=bomitem_item_id)
         JOIN costelem ON (itemcost_costelem_id=costelem_id)
         JOIN bomhead ON (bomhead_item_id=bomitem_parent_item_id AND bomhead_rev_id=bomitem_rev_id)
  <? if exists("includeRevisionControl") ?>
    LEFT OUTER JOIN rev ON ((bomitem_rev_id=rev_id) AND (COALESCE(rev_status, ''A'')=''A'')) 
  <? endif ?>
    WHERE ((CURRENT_DATE BETWEEN bomitem_effective AND (bomitem_expires-1))
     AND (bomitem_parent_item_id=<? value("item_id") ?>)
     AND (costelem_id=<? value("costelem_id") ?>) ) 
<? elseif exists("useBBOM") ?>
     SELECT bbomitem_id AS id, bbomitem_seqnumber AS seqnumber,
            bbomitem_qtyper AS qtyper,
            bbomitem_costabsorb AS scrap,
            bbomitem_parent_item_id AS item_id,
  <? if exists("standardCost") ?>
            itemcost_stdcost AS cost,
            (itemcost_stdcost / bbomitem_qtyper *
             bbomitem_costabsorb) AS extendedcost 
  <? elseif exists("actualCost") ?>
            currToBase(itemcost_curr_id, itemcost_actcost, NULL) AS cost,
            (currToBase(itemcost_curr_id, itemcost_actcost, NULL) / bbomitem_qtyper *
             bbomitem_costabsorb) AS extendedcost 
  <? endif ?>
    FROM xtmfg.bbomitem
         JOIN itemcost ON (itemcost_item_id=bbomitem_parent_item_id)
    WHERE ((CURRENT_DATE BETWEEN bbomitem_effective AND (bbomitem_expires-1))
     AND (itemcost_costelem_id=<? value("costelem_id") ?>)
     AND (bbomitem_item_id=<? value("item_id") ?>) )
    UNION
    SELECT source.bbomitem_id, source.bbomitem_seqnumber AS seqnumber,
           source.bbomitem_qtyper, target.bbomitem_costabsorb,
           item_id,
  <? if exists("standardCost") ?>
           itemcost_stdcost AS cost,
           (itemcost_stdcost * source.bbomitem_qtyper /
            target.bbomitem_qtyper * target.bbomitem_costabsorb) AS extendedcost 
  <? elseif exists("actualCost") ?>
           currToBase(itemcost_curr_id, itemcost_actcost, NULL) AS cost,
           (currToBase(itemcost_curr_id, itemcost_actcost, NULL) * source.bbomitem_qtyper /
            target.bbomitem_qtyper * target.bbomitem_costabsorb) AS extendedcost 
  <? endif ?>
    FROM xtmfg.bbomitem AS source
         JOIN item     ON (source.bbomitem_item_id=item_id)
         JOIN itemcost ON (source.bbomitem_item_id=itemcost_item_id)
         JOIN xtmfg.bbomitem AS target
              ON (source.bbomitem_parent_item_id=target.bbomitem_parent_item_id)
    WHERE ((CURRENT_DATE BETWEEN source.bbomitem_effective
                            AND (source.bbomitem_expires-1))
     AND (CURRENT_DATE BETWEEN target.bbomitem_effective
                          AND (target.bbomitem_expires-1))
     AND (item_type=''Y'')
     AND (target.bbomitem_item_id=<? value("item_id") ?>)
     AND (itemcost_costelem_id=<? value("costelem_id") ?>) )
<? endif ?>
) AS data 
WHERE ((data.item_id=item.item_id)
   AND (item_inv_uom_id=uom_id)) 
ORDER BY seqnumber;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (258, 'items', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: items
-- Name:  detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

 SELECT
        <? if exists("ListNumericItemNumbersFirst") ?>
         DISTINCT ON ( toNumeric(item_number, 999999999999999), item_number )
        <? else ?>
         DISTINCT ON ( item_number )
        <? endif ?>
               item.*, classcode.*, uom.*, prodcat.*, freightclass.*,
               <? foreach("char_id_text_list") ?>
                      charass_alias<? literal("char_id_text_list") ?>.charass_value AS char<? literal("char_id_text_list") ?>,
               <? endforeach ?>
               <? foreach("char_id_list_list") ?>
                      charass_alias<? literal("char_id_list_list") ?>.charass_value AS char<? literal("char_id_list_list") ?>,
               <? endforeach ?>
               <? foreach("char_id_date_list") ?>
                      charass_alias<? literal("char_id_date_list") ?>.charass_value::date AS char<? literal("char_id_date_list") ?>,
               <? endforeach ?>
                      (COALESCE(item_descrip1,'''') || '' '' || COALESCE(item_descrip2,'''')) as item_descrip,
                      CASE WHEN (item_type=''P'') THEN text(<? value("purchased") ?>)
                           WHEN (item_type=''M'') THEN text(<? value("manufactured") ?>)
                           WHEN (item_type=''F'') THEN text(<? value("phantom") ?>)
                           WHEN (item_type=''B'') THEN text(<? value("breeder") ?>)
                           WHEN (item_type=''C'') THEN text(<? value("coProduct") ?>)
                           WHEN (item_type=''Y'') THEN text(<? value("byProduct") ?>)
                           WHEN (item_type=''R'') THEN text(<? value("reference") ?>)
                           WHEN (item_type=''S'') THEN text(<? value("costing") ?>)
                           WHEN (item_type=''T'') THEN text(<? value("tooling") ?>)
                           WHEN (item_type=''A'') THEN text(<? value("assortment") ?>)
                           WHEN (item_type=''O'') THEN text(<? value("outside") ?>)
                           WHEN (item_type=''L'') THEN text(<? value("planning") ?>)
                           WHEN (item_type=''K'') THEN text(<? value("kit") ?>)
                           ELSE text(<? value("error") ?>)
                      END AS f_item_type,
                      CASE WHEN (item_type=''P'') THEN text(<? value("purchased") ?>)
                           WHEN (item_type=''M'') THEN text(<? value("manufactured") ?>)
                           WHEN (item_type=''F'') THEN text(<? value("phantom") ?>)
                           WHEN (item_type=''B'') THEN text(<? value("breeder") ?>)
                           WHEN (item_type=''C'') THEN text(<? value("coProduct") ?>)
                           WHEN (item_type=''Y'') THEN text(<? value("byProduct") ?>)
                           WHEN (item_type=''R'') THEN text(<? value("reference") ?>)
                           WHEN (item_type=''S'') THEN text(<? value("costing") ?>)
                           WHEN (item_type=''T'') THEN text(<? value("tooling") ?>)
                           WHEN (item_type=''A'') THEN text(<? value("assortment") ?>)
                           WHEN (item_type=''O'') THEN text(<? value("outside") ?>)
                           WHEN (item_type=''L'') THEN text(<? value("planning") ?>)
                           WHEN (item_type=''K'') THEN text(<? value("kit") ?>)
                           ELSE text(<? value("error") ?>)
                      END AS item_type_qtdisplayrole
               FROM item
                 JOIN classcode ON (item_classcode_id=classcode_id)
                 JOIN uom ON (item_inv_uom_id=uom_id)
                 LEFT OUTER JOIN prodcat ON (item_prodcat_id=prodcat_id)
                 LEFT OUTER JOIN freightclass ON (item_freightclass_id=freightclass_id)
               <? if exists("itemgrp_id") ?>
                 JOIN itemgrpitem ON (item_id=itemgrpitem_item_id)
                 JOIN itemgrp ON (itemgrp_id=itemgrpitem_itemgrp_id)
               <? endif ?>
               <? foreach("char_id_text_list") ?>
                 LEFT OUTER JOIN charass charass_alias<? literal("char_id_text_list") ?> 
                   ON ((charass_alias<? literal("char_id_text_list") ?>.charass_target_type=''I'') 
                   AND  (charass_alias<? literal("char_id_text_list") ?>.charass_target_id=item_id)
                   AND  (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=<? value("char_id_text_list") ?>))
                 LEFT OUTER JOIN char char_alias<? literal("char_id_text_list") ?> 
                   ON (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=char_alias<? literal("char_id_text_list") ?>.char_id)
               <? endforeach ?>
               <? foreach("char_id_list_list") ?>
                 LEFT OUTER JOIN charass charass_alias<? literal("char_id_list_list") ?> 
                   ON ((charass_alias<? literal("char_id_list_list") ?>.charass_target_type=''I'') 
                   AND  (charass_alias<? literal("char_id_list_list") ?>.charass_target_id=item_id)
                   AND  (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=<? value("char_id_list_list") ?>))
                 LEFT OUTER JOIN char char_alias<? literal("char_id_list_list") ?> 
                   ON (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=char_alias<? literal("char_id_list_list") ?>.char_id)
               <? endforeach ?>
               <? foreach("char_id_date_list") ?>
                 LEFT OUTER JOIN charass charass_alias<? literal("char_id_date_list") ?> 
                   ON ((charass_alias<? literal("char_id_date_list") ?>.charass_target_type=''I'') 
                   AND  (charass_alias<? literal("char_id_date_list") ?>.charass_target_id=item_id)
                   AND  (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=<? value("char_id_date_list") ?>))
                 LEFT OUTER JOIN char char_alias<? literal("char_id_date_list") ?> 
                   ON (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=char_alias<? literal("char_id_date_list") ?>.char_id)
               <? endforeach ?>
               WHERE ( true
               <? if exists("search_pattern") ?>
                AND ( (item_number ~* <? value("search_pattern") ?>)
                      OR  (COALESCE(item_descrip1,'''') || COALESCE(item_descrip2,'''') ~* <? value("search_pattern") ?>) )
               <? endif ?>
               <? if exists("showPurchased") ?>
                AND (item_type IN (''P'', ''O''))
               <? elseif exists("showManufactured") ?>
                AND (item_type IN (''M'', ''F'', ''B'',''K''))
               <? elseif exists("showSold") ?>
                AND (item_sold)
               <? endif ?>
               <? if exists("item_type") ?>
                AND (item_type=<? value("item_type") ?>)
               <? endif ?>
               <? if not exists("showInactive") ?>
                AND (item_active)
               <? endif ?>
               <? if exists("classcode_id") ?>
                AND (item_classcode_id=<? value("classcode_id") ?>)
               <? endif ?>
               <? if exists("prodcat_id") ?>
                AND (item_prodcat_id=<? value("prodcat_id") ?>)
               <? endif ?>
               <? if exists("freightclass_id") ?>
                AND (item_freightclass_id=<? value("freightclass_id") ?>)
               <? endif ?>
               <? if exists("itemgrp_id") ?>
                AND (itemgrp_id=<? value("itemgrp_id") ?>)
               <? endif ?>
               <? if exists("item_number_pattern") ?>
                AND (item_number ~* <? value("item_number_pattern") ?>)
               <? endif ?>
               <? if exists("item_descrip_pattern") ?>
                AND (COALESCE(item_descrip1,'''') || COALESCE(item_descrip2,'''') ~* <? value("item_descrip_pattern") ?>)
               <? endif ?>
               <? if exists("classcode_pattern") ?>
                AND (classcode_code ~* <? value("classcode_pattern") ?>)
               <? endif ?>
               <? if exists("prodcat_pattern") ?>
                AND (prodcat_code  ~* <? value("prodcat_pattern") ?>)
               <? endif ?>
               <? if exists("freightclass_pattern") ?>
                AND (freightclass_code ~* <? value("freightclass_pattern") ?>)
               <? endif ?>
               <? literal("charClause") ?>
               ) ORDER BY
               <? if exists("ListNumericItemNumbersFirst") ?>
                toNumeric(item_number, 999999999999999),
               <? endif ?>
                item_number;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (60, 'manufacture', 'jobcosting', 'used by dspJobCosting Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: manufacture
-- Name: jobcosting
-- Notes: used by dspJobCosting
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT *, 0 AS cost_xttotalrole,
       ''qty'' AS qty_xtnumericrole,
       ''cost'' AS cost_xtnumericrole
FROM (
  SELECT womatl_id AS id, 3 AS sort,
         <? value("material") ?> AS type, item_number AS code,
         item_descrip1 AS descrip,
         (SUM(COALESCE(invhist_invqty,0))) AS qty,
         uom_name AS uom,
         SUM(COALESCE(invhist_invqty * invhist_unitcost,0)) AS cost,
         NULL as wooper_seqnumber
  FROM womatl
    LEFT OUTER JOIN womatlpost ON (womatl_id=womatlpost_womatl_id)
    LEFT OUTER JOIN invhist ON (womatlpost_invhist_id=invhist_id),
    itemsite, item, uom
  WHERE ((womatl_wo_id=<? value("wo_id") ?>)
     AND (womatl_itemsite_id=itemsite_id)
     AND (itemsite_item_id=item_id)
     AND (item_inv_uom_id=uom_id))
  GROUP BY womatl_id, item_number, item_descrip1, uom_name
  ) AS data
ORDER BY sort, code;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (51, 'inventoryAvailability', 'byCustOrSO', 'query to get item availability by either customer id/type/pattern or by cohead_id Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: inventoryAvailability
-- Name:  byCustOrSO
-- Notes: query to get item availability by either customer id/type/pattern
--        or by cohead_id
--        Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
--        See www.xtuple.com/CPAL for the full text of the software license.

SELECT id, altid, cohead_id,
       item_number, descrip, uom_name,
       qoh, sobalance, allocated, ordered,
       atshipping,
       CASE WHEN (xtindentrole=1) THEN
<? if exists("useReservationNetting") ?>
                  coitem_qtyreserved
<? else ?>
                  (qoh + ordered - sobalance)
<? endif ?>
            WHEN (xtindentrole=2) THEN (qoh + ordered - sobalance)
       END AS orderavail,
       (qoh + ordered - allocated) AS totalavail,
       orderdate, duedate,
       reorderlevel,
<? if exists("sohead_id") ?> (xtindentrole - 1) AS <? endif ?> xtindentrole, 
       ''qty'' AS qoh_xtnumericrole,
       ''qty'' AS sobalance_xtnumericrole,
       ''qty'' AS allocated_xtnumericrole,
       ''qty'' AS ordered_xtnumericrole,
       ''qty'' AS orderavail_xtnumericrole,
       ''qty'' AS totalavail_xtnumericrole,
       ''qty'' AS atshipping_xtnumericrole,
       CASE WHEN (pack_id IS NOT NULL) THEN ''altemphasis''
       END AS qtforegroundrole,
       CASE WHEN (qoh < 0) THEN ''error''
            WHEN (qoh < reorderlevel) THEN ''warning''
       END AS qoh_qtforegroundrole,
       CASE WHEN (
<? if exists("useReservationNetting") ?>
                  coitem_qtyreserved < 0
<? else ?>
                  (qoh + ordered - sobalance) < 0
<? endif ?>
                 ) THEN ''error''
            WHEN ((qoh + ordered - sobalance) <= reorderlevel) THEN ''warning''
       END AS orderavail_qtforegroundrole,
       CASE WHEN ((qoh + ordered - allocated) < 0) THEN ''error''
            WHEN ((qoh + ordered - allocated) <= reorderlevel) THEN ''warning''
       END AS totalavail_qtforegroundrole,
       CASE WHEN (xtindentrole = 2 AND (orderdate <= CURRENT_DATE)
              AND (descrip IN (''O'',''E'',''S'',''R''))) THEN ''error''
       END AS atshipping_qtforegroundrole,
       CASE WHEN (xtindentrole = 2 AND duedate<=CURRENT_DATE) THEN ''error''
       END AS orderdate_qtforegroundrole,
       CASE WHEN (xtindentrole = 2 AND duedate<=CURRENT_DATE) THEN ''error''
       END AS duedate_qtforegroundrole,
<? if exists("useReservationNetting") ?>
       CASE WHEN (coitem_qtyreserved > 0
              AND sobalance > coitem_qtyreserved) THEN ''emphasis''
            WHEN ((sobalance <> 0)
              AND ((sobalance - coitem_qtyreserved) = 0)) THEN ''altemphasis''
       END AS qtforegroundrole,
<? endif ?>
       CASE WHEN (xtindentrole = 2) THEN ''''
       END AS sobalance_qtdisplayrole
FROM (
<? if not exists("sohead_id") ?>
    SELECT cohead_id AS id, -2 AS altid, cohead_id, cohead_number,
           cohead_number AS item_number,
           '''' AS trueitem_number,
           (cust_number||''-''||cust_name) AS descrip,
           '''' AS uom_name, CAST(NULL AS NUMERIC) AS qoh,
           CAST(NULL AS NUMERIC) AS sobalance,
           CAST(NULL AS NUMERIC) AS allocated,
           CAST(NULL AS NUMERIC) AS ordered,
           CAST(NULL AS NUMERIC) AS atshipping,
           CAST(NULL AS NUMERIC) AS coitem_qtyreserved,
           cohead_orderdate AS orderdate, MIN(coitem_scheddate) AS duedate,
           pack_id,
           CAST(NULL AS NUMERIC) AS reorderlevel,
           0 AS xtindentrole
     FROM cohead
     LEFT OUTER JOIN pack ON (pack_head_type=''SO'' AND pack_head_id=cohead_id)
     JOIN custinfo ON (cohead_cust_id=cust_id)
     JOIN coitem   ON (coitem_cohead_id=cohead_id)
     JOIN itemsite ON (coitem_itemsite_id=itemsite_id)
     WHERE ((coitem_status NOT IN (''C'', ''X''))
  <? if exists("custtype_id") ?>
        AND (cust_custtype_id=<? value("custtype_id") ?>)
  <? elseif exists("custtype_pattern") ?>
        AND (cust_custtype_id IN (SELECT custtype_id
                                  FROM custtype
                                  WHERE(custtype_code ~ <? value("custtype_pattern") ?>)))
  <? endif ?>
      )
      GROUP BY cohead_id, item_number, cust_number,
               cust_name, cohead_orderdate, pack_id
  <? if exists("onlyShowShortages") ?>
      HAVING (MIN(noNeg(itemsite_qtyonhand) +
                  qtyOrdered(itemsite_id, coitem_scheddate) -
                  qtyAllocated(itemsite_id, coitem_scheddate)) < 0
              OR MIN(noNeg(itemsite_qtyonhand) +
                  qtyOrdered(itemsite_id, coitem_scheddate) -
                  noNeg(coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned)) < 0
           )
  <? endif ?>
    UNION
<? endif ?>
    SELECT itemsite_id AS id, coitem_id AS altid, cohead_id, cohead_number,
            item_number,
            item_number AS trueitem_number,
            (item_descrip1 || '' '' || item_descrip2) AS descrip,
            uom_name, noNeg(itemsite_qtyonhand) AS qoh,
            noNeg(coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned) AS sobalance,
            qtyAllocated(itemsite_id, coitem_scheddate) AS allocated,
            qtyOrdered(itemsite_id, coitem_scheddate) AS ordered,
            qtyatshipping(coitem_id) AS atshipping,
            itemuomtouom(item_id, coitem_qty_uom_id, null, coitem_qtyreserved) AS coitem_qtyreserved,
            CAST(NULL AS DATE) AS orderdate, coitem_scheddate AS duedate,
            CAST(NULL AS INTEGER) AS pack_id,
            CASE WHEN(itemsite_useparams) THEN itemsite_reorderlevel
                 ELSE 0.0 END AS reorderlevel,
            1 AS xtindentrole
     FROM cohead
<? if not exists("sohead_id") ?> JOIN custinfo ON (cohead_cust_id=cust_id)<? endif ?>
          , itemsite, item, uom, site(), coitem
     WHERE ((coitem_cohead_id=cohead_id)
        AND (coitem_itemsite_id=itemsite_id)
        AND (itemsite_warehous_id=warehous_id)
        AND (itemsite_item_id=item_id)
        AND (item_inv_uom_id=uom_id)
        AND (coitem_status NOT IN (''C'', ''X''))
<? if exists("sohead_id") ?>
        AND (cohead_id=<? value("sohead_id") ?>)
<? elseif exists("custtype_id") ?>
        AND (cust_custtype_id=<? value("custtype_id") ?>)
<? elseif exists("custtype_pattern") ?>
        AND (cust_custtype_id IN (SELECT custtype_id
                                  FROM custtype
                                  WHERE(custtype_code ~ <? value("custtype_pattern") ?>)))
<? endif ?>
<? if exists("onlyShowShortages") ?>
        AND ((noNeg(itemsite_qtyonhand) + qtyOrdered(itemsite_id, coitem_scheddate) - qtyAllocated(itemsite_id, coitem_scheddate) < 0)
          OR (noNeg(itemsite_qtyonhand) + qtyOrdered(itemsite_id, coitem_scheddate) - noNeg(coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned) < 0))
<? endif ?>
    )
<? if exists("showWoSupply") ?>
    UNION
    SELECT  itemsite_id, -1, cohead_id, cohead_number,
            formatwonumber(wo_id),
            item_number AS trueitem_number,
            wo_status,
            NULL, NULL,
            noNeg(coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned) AS sobalance,
            NULL,
            noNeg((wo_qtyord-wo_qtyrcv)) AS ordered,
            NULL,
            NULL,
            wo_startdate, wo_duedate,
            NULL AS pack_id,
            CASE WHEN(itemsite_useparams) THEN itemsite_reorderlevel
                 ELSE 0.0 END AS reorderlevel,
            2 AS xtindentrole
     FROM cohead
<? if not exists("sohead_id") ?> JOIN custinfo ON (cohead_cust_id=cust_id)<? endif ?>
          , itemsite, item, uom, site(), coitem
          LEFT OUTER JOIN wo
           ON ((coitem_itemsite_id=wo_itemsite_id)
           AND (wo_status IN (''E'',''R'',''I''))
           AND (wo_qtyord-wo_qtyrcv > 0)
           AND (noNeg(coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned-qtyatshipping(coitem_id)) >
            (SELECT itemsite_qtyonhand FROM itemsite WHERE (itemsite_id=coitem_itemsite_id))))
     WHERE ((coitem_cohead_id=cohead_id)
        AND (coitem_itemsite_id=itemsite_id)
        AND (itemsite_warehous_id=warehous_id)
        AND (itemsite_item_id=item_id)
        AND (item_inv_uom_id=uom_id)
        AND (coitem_status NOT IN (''C'', ''X''))
  <? if exists("sohead_id") ?>
        AND (cohead_id=<? value("sohead_id") ?>)
  <? elseif exists("custtype_id") ?>
        AND (cust_custtype_id=<? value("custtype_id") ?>)
  <? elseif exists("custtype_pattern") ?>
        AND (cust_custtype_id IN (SELECT custtype_id
                                  FROM custtype
                                  WHERE(custtype_code ~ <? value("custtype_pattern") ?>)))
  <? endif ?>
  <? if exists("onlyShowShortages") ?>
        AND ((noNeg(itemsite_qtyonhand) + qtyOrdered(itemsite_id, coitem_scheddate) - qtyAllocated(itemsite_id, coitem_scheddate) < 0)
          OR (noNeg(itemsite_qtyonhand) + qtyOrdered(itemsite_id, coitem_scheddate) - noNeg(coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned) < 0))
  <? endif ?>
  )
<? endif ?>
) AS data
ORDER BY cohead_number, trueitem_number,
         xtindentrole;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (54, 'inventoryHistory', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: inventoryHistory
-- Name: detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT invhist_id, invdetail_id, invhist_transdate AS sortdate,
       formatDateTime(invhist_transdate) AS transdate,
       CASE WHEN (level=0) THEN invhist_transdate END AS invhist_transdate,
       CASE WHEN (level=0) THEN invhist_created END AS invhist_created,
       CASE WHEN (level=0) THEN invhist_user END AS invhist_user,
       CASE WHEN (level=0) THEN invhist_transtype END AS invhist_transtype,
       CASE WHEN (level=0) THEN warehous_code END AS warehous_code,
       CASE WHEN (level=0) THEN ordernumber
            ELSE locationname
       END AS orderlocation,
       CASE WHEN (level=0) THEN item_number END AS item_number,
       CASE WHEN (level=0) THEN invhist_invuom END AS invhist_invuom,
       CASE WHEN (level=0 AND invhist_transtype IN (''EX'',''IM'',''SH'',''SI'')) THEN (invhist_invqty * -1.0)
            WHEN (level=0) THEN invhist_invqty
            ELSE invdetail_qty
       END AS transqty,
       CASE WHEN (level=0) THEN invhist_value_after - invhist_value_before
       END AS transvalue,
       CASE WHEN (level=0) THEN locfrom END AS locfrom,
       CASE WHEN (level=0) THEN invhist_qoh_before
            ELSE invdetail_qty_before
       END AS qohbefore,
       CASE WHEN (level=0) THEN locto END AS locto,
       CASE WHEN (level=0) THEN invhist_qoh_after
            ELSE invdetail_qty_after
       END AS qohafter,
       CASE WHEN (level=0) THEN costmethod END AS costmethod,
       CASE WHEN (level=0) THEN invhist_value_before END AS invhist_value_before,
       CASE WHEN (level=0) THEN invhist_value_after END AS invhist_value_after,
       ''qty'' AS transqty_xtnumericrole,
       ''curr'' AS transvalue_xtnumericrole,
       0 AS transvalue_xttotalrole,
       ''qty'' AS qohbefore_xtnumericrole,
       ''qty'' AS qohafter_xtnumericrole,
       ''curr'' AS invhist_value_before_xtnumericrole,
       ''curr'' AS invhist_value_after_xtnumericrole,
       CASE WHEN (NOT invhist_posted) THEN NULL END AS qohbefore_qtdisplayrole,
       CASE WHEN (NOT invhist_posted) THEN NULL END AS qohafter_qtdisplayrole,
       CASE WHEN (NOT invhist_posted) THEN NULL END AS invhist_value_before_qtdisplayrole,
       CASE WHEN (NOT invhist_posted) THEN NULL END AS invhist_value_after_qtdisplayrole,
       CASE WHEN (NOT invhist_posted) THEN NULL END AS costmethod_qtdisplayrole,
       CASE WHEN (NOT invhist_posted) THEN NULL END AS locto_qtdisplayrole,
       CASE WHEN (NOT invhist_posted) THEN NULL END AS locfrom_qtdisplayrole,
       CASE WHEN (NOT invhist_posted) THEN ''warning'' END AS qtforegroundrole,
       level AS xtindentrole
FROM (
SELECT invhist.*, 0 AS level,
       whs1.warehous_code AS warehous_code, item_number,
       CASE WHEN (invhist_ordtype NOT LIKE '''') THEN (invhist_ordtype || ''-'' || invhist_ordnumber)
            ELSE invhist_ordnumber
       END AS ordernumber,
       CASE WHEN (invhist_costmethod=''A'') THEN <? value("average") ?>
            WHEN (invhist_costmethod=''S'') THEN <? value("standard") ?>
            WHEN (invhist_costmethod=''J'') THEN <? value("job") ?>
            WHEN (invhist_costmethod=''N'') THEN <? value("none") ?>
            ELSE <? value("unknown") ?>
       END AS costmethod,
       0 AS invdetail_id, '''' AS locationname,
       0 AS invdetail_qty, 0 AS invdetail_qty_before, 0 AS invdetail_qty_after,
       CASE WHEN (invhist_transtype=''TW'' AND invhist_invqty < 0) THEN whs1.warehous_code
            WHEN (invhist_transtype=''TW'') THEN whs2.warehous_code
            WHEN (invhist_transtype=''AD'' AND invhist_invqty < 0) THEN whs1.warehous_code
            WHEN (invhist_transtype=''AD'') THEN ''ADJ''
            WHEN (invhist_transtype=''EX'') THEN whs1.warehous_code
            WHEN (invhist_transtype=''IB'') THEN whs1.warehous_code
            WHEN (invhist_transtype=''IM'' AND invhist_invqty < 0) THEN ''WIP''
            WHEN (invhist_transtype=''IM'') THEN whs1.warehous_code
            WHEN (invhist_transtype=''IT'') THEN whs1.warehous_code
            WHEN (invhist_transtype=''RB'') THEN ''WIP''
            WHEN (invhist_transtype=''RM'') THEN ''WIP''
            WHEN (invhist_transtype=''RP'') THEN whs1.warehous_code
            WHEN (invhist_transtype=''RR'') THEN ''CUST''
            WHEN (invhist_transtype=''RS'') THEN ''SHIP''
            WHEN (invhist_transtype=''SH'') THEN whs1.warehous_code
            WHEN (invhist_transtype=''SI'') THEN whs1.warehous_code
            WHEN (invhist_transtype=''SV'') THEN whs1.warehous_code
	 WHEN (invhist_transtype=''TR'') THEN whs2.warehous_code
	 WHEN (invhist_transtype=''TS'') THEN whs1.warehous_code
	 WHEN (invhist_transtype=''RI'') THEN whs1.warehous_code
            ELSE ''''
       END AS locfrom,
       CASE WHEN (invhist_transtype=''TW'' AND invhist_invqty < 0) THEN whs2.warehous_code
            WHEN (invhist_transtype=''TW'') THEN whs1.warehous_code
            WHEN (invhist_transtype=''AD'' AND invhist_invqty < 0) THEN ''ADJ''
            WHEN (invhist_transtype=''AD'') THEN whs1.warehous_code
            WHEN (invhist_transtype=''CC'') THEN whs1.warehous_code
            WHEN (invhist_transtype=''EX'') THEN ''EXPENSE''
            WHEN (invhist_transtype=''IB'') THEN ''WIP''
            WHEN (invhist_transtype=''IM'' AND invhist_invqty < 0) THEN whs1.warehous_code
            WHEN (invhist_transtype=''IM'') THEN ''WIP''
            WHEN (invhist_transtype=''NN'') THEN whs1.warehous_code
            WHEN (invhist_transtype=''RB'') THEN whs1.warehous_code
            WHEN (invhist_transtype=''RM'') THEN whs1.warehous_code
            WHEN (invhist_transtype=''RP'') THEN ''PURCH''
            WHEN (invhist_transtype=''RR'') THEN whs1.warehous_code
            WHEN (invhist_transtype=''RS'') THEN whs1.warehous_code
            WHEN (invhist_transtype=''RT'') THEN whs1.warehous_code
            WHEN (invhist_transtype=''RX'') THEN whs1.warehous_code
            WHEN (invhist_transtype=''SH'') THEN ''SHIP''
            WHEN (invhist_transtype=''SI'') THEN ''SCRAP''
            WHEN (invhist_transtype=''SV'') THEN ''SHIP''
            WHEN (invhist_transtype=''TR'') THEN whs1.warehous_code
            WHEN (invhist_transtype=''TS'') THEN whs2.warehous_code
            WHEN (invhist_transtype=''RI'') THEN ''WIP''
            ELSE ''''
       END AS locto 
FROM itemsite, item, whsinfo AS whs1, invhist
  LEFT OUTER JOIN whsinfo AS whs2 ON (invhist_xfer_warehous_id=whs2.warehous_id)
WHERE ( (invhist_itemsite_id=itemsite_id)
  AND  (itemsite_item_id=item_id) 
  AND  (itemsite_warehous_id=whs1.warehous_id)
  AND  (DATE(invhist_transdate) BETWEEN <? value("startDate") ?> AND <? value("endDate") ?> )
  AND  (transType(invhist_transtype, <? value("transType") ?>))
<? if exists("orderNumber") ?>
  AND  (invhist_ordnumber ~ <? value("orderNumber") ?>)
<? endif ?>
<? if exists("cohead_id") ?>
  AND  (invhist_ordtype=''SO'')
  AND  (invhist_ordnumber ~ (
    SELECT cohead_number 
    FROM cohead 
    WHERE cohead_id=<? value("cohead_id") ?>))
<? endif ?>
<? if exists("pohead_id") ?>
  AND  (invhist_ordtype=''PO'')
  AND  (invhist_ordnumber ~ (
    SELECT pohead_number 
    FROM pohead 
    WHERE pohead_id=<? value("pohead_id") ?>))
<? endif ?>
<? if exists("tohead_id") ?>
  AND  (invhist_ordtype=''TO'')
  AND  (invhist_ordnumber ~ (
    SELECT tohead_number 
    FROM tohead 
    WHERE tohead_id=<? value("tohead_id") ?>))
<? endif ?>
<? if exists("wo_id") ?>
  AND  (invhist_ordtype=''WO'')
  AND  (invhist_ordnumber ~ formatWoNumber(<? value("wo_id") ?>))
<? endif ?>
<? if exists("warehous_id") ?>
  AND  (itemsite_warehous_id=<? value("warehous_id") ?>)
<? endif ?>
<? if exists("item_id") ?>
  AND  (itemsite_item_id=<? value("item_id") ?>)
<? endif ?>
<? if exists("classcode_id") ?>
  AND  (item_classcode_id=<? value("classcode_id") ?>)
<? endif ?>
<? if exists("itemgrp_id") ?>
  AND (item_id IN (SELECT itemgrpitem_item_id
		   FROM itemgrpitem
		   WHERE (itemgrpitem_itemgrp_id=<? value("itemgrp_id") ?>)))
<? endif ?>
<? if exists("plancode_id") ?>
  AND  (itemsite_plancode_id=<? value("plancode_id") ?>)
<? endif ?>
<? if exists("classcode_pattern") ?>
  AND  (item_classcode_id IN (SELECT classcode_id
			      FROM classcode
			      WHERE (classcode_code ~ <? value ("classcode_pattern") ?>)))
<? endif ?>
<? if exists("itemgrp_pattern") ?>
  AND (item_id IN (SELECT itemgrpitem_item_id
		   FROM itemgrpitem, itemgrp
		   WHERE ( (itemgrpitem_itemgrp_id=itemgrp_id)
		     AND  (itemgrp_name ~ <? value ("itemgrp_pattern") ?>))))
<? endif ?>
<? if exists("plancode_pattern") ?>
  AND (itemsite_plancode_id IN (SELECT plancode_id
				FROM plancode
				WHERE (plancode_code ~ <? value("plancode_pattern") ?>)))
<? endif ?>
<? if exists("itemgrp") ?>
  AND (item_id IN (SELECT DISTINCT itemgrpitem_item_id FROM itemgrpitem))
<? endif ?>
) 
UNION SELECT invhist.*, 1 AS level,
             '''' AS warehous_code, '''' AS item_number,
             '''' AS ordernumber,
             '''' AS costmethod,
             invdetail_id,
             CASE WHEN (invdetail_location_id=-1) THEN formatlotserialnumber(invdetail_ls_id)
                  WHEN (invdetail_ls_id IS NULL) THEN formatLocationName(invdetail_location_id)
                  ELSE (formatLocationName(invdetail_location_id) || ''-'' || formatlotserialnumber(invdetail_ls_id))
             END AS locationname,
             invdetail_qty, invdetail_qty_before, invdetail_qty_after,
             '''' AS locfrom,
             '''' AS locto 
FROM itemsite, item, whsinfo AS whs1, invdetail, invhist LEFT OUTER JOIN
     whsinfo AS whs2 ON (invhist_xfer_warehous_id=whs2.warehous_id)
WHERE ((invhist_hasdetail)
  AND (invhist_itemsite_id=itemsite_id)
  AND (itemsite_item_id=item_id)
  AND (itemsite_warehous_id=whs1.warehous_id)
  AND (invdetail_invhist_id=invhist_id)
  AND  (DATE(invhist_transdate) BETWEEN <? value("startDate") ?> AND <? value("endDate") ?> )
  AND (transType(invhist_transtype, <? value("transType") ?>))
<? if exists("orderType") ?>
  AND  (invhist_ordtype=<? value("orderType") ?>)
<? endif ?>
<? if exists("orderNumber") ?>
  AND  (invhist_ordnumber ~ <? value("orderNumber") ?>)
<? endif ?>
<? if exists("cohead_id") ?>
  AND  (invhist_ordtype=''SO'')
  AND  (invhist_ordnumber ~ (
    SELECT cohead_number 
    FROM cohead 
    WHERE cohead_id=<? value("cohead_id") ?>))
<? endif ?>
<? if exists("pohead_id") ?>
  AND  (invhist_ordtype=''PO'')
  AND  (invhist_ordnumber ~ (
    SELECT pohead_number 
    FROM pohead 
    WHERE pohead_id=<? value("pohead_id") ?>))
<? endif ?>
<? if exists("tohead_id") ?>
  AND  (invhist_ordtype=''TO'')
  AND  (invhist_ordnumber ~ (
    SELECT tohead_number 
    FROM tohead 
    WHERE tohead_id=<? value("tohead_id") ?>))
<? endif ?>
<? if exists("wo_id") ?>
  AND  (invhist_ordtype=''WO'')
  AND  (invhist_ordnumber ~ formatWoNumber(<? value("wo_id") ?>))
<? endif ?>
<? if exists("warehous_id") ?>
  AND  (itemsite_warehous_id=<? value("warehous_id") ?>)
<? endif ?>
<? if exists("item_id") ?>
  AND  (itemsite_item_id=<? value("item_id") ?>)
<? endif ?>
<? if exists("classcode_id") ?>
  AND  (item_classcode_id=<? value("classcode_id") ?>)
<? endif ?>
<? if exists("itemgrp_id") ?>
  AND (item_id IN (SELECT itemgrpitem_item_id
		   FROM itemgrpitem
		   WHERE (itemgrpitem_itemgrp_id=<? value("itemgrp_id") ?>)))
<? endif ?>
<? if exists("plancode_id") ?>
  AND  (itemsite_plancode_id=<? value("plancode_id") ?>)
<? endif ?>
<? if exists("classcode_pattern") ?>
  AND  (item_classcode_id IN (SELECT classcode_id
			      FROM classcode
			      WHERE (classcode_code ~ <? value ("classcode_pattern") ?>)))
<? endif ?>
<? if exists("itemgrp_pattern") ?>
  AND (item_id IN (SELECT itemgrpitem_item_id
		   FROM itemgrpitem, itemgrp
		   WHERE ( (itemgrpitem_itemgrp_id=itemgrp_id)
		     AND  (itemgrp_name ~ <? value ("itemgrp_pattern") ?>))))
<? endif ?>
<? if exists("plancode_pattern") ?>
  AND (itemsite_plancode_id IN (SELECT plancode_id
				FROM plancode
				WHERE (plancode_code ~ <? value("plancode_pattern") ?>)))
<? endif ?>
<? if exists("itemgrp") ?>
  AND (item_id IN (SELECT DISTINCT itemgrpitem_item_id FROM itemgrpitem))
<? endif ?>
)

   ) AS data
ORDER BY sortdate DESC, invhist_id, level;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (457, 'itemCost', 'list', 'used by maintainItemCosts, bomItem Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: itemCost
-- Name: list
-- Notes: used by maintainItemCosts, bomItem
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

-- The order of checking for item_id first is important.

<? if exists("item_id") ?>

SELECT itemcost_id,
       CASE WHEN (costelem_sys) THEN 1
            ELSE 0
       END,
       CASE WHEN itemcost_costelem_id = -1 THEN :error
	    ELSE costelem_type
       END AS costelem_type, itemcost_lowlevel,
       itemcost_stdcost, currConcat(baseCurrID()) AS baseCurr,
       itemcost_posted,
       itemcost_actcost, currConcat(itemcost_curr_id) AS costCurr,
       itemcost_updated,
       currToBase(itemcost_curr_id, itemcost_actcost, CURRENT_DATE) AS actcostBase,
       itemcost_curr_id,
       CASE WHEN (COALESCE(itemcost_posted, startOfTime()) <= startOfTime()) THEN :never
       END AS itemcost_posted_qtdisplayrole,
       ''cost'' AS itemcost_stdcost_xtnumericrole,
       ''cost'' AS itemcost_actcost_xtnumericrole
FROM itemcost LEFT OUTER JOIN costelem ON (itemcost_costelem_id=costelem_id)
WHERE (itemcost_item_id=<? value("item_id") ?>)
ORDER BY itemcost_lowlevel, costelem_type;

<? elseif exists("bomitem_id") ?>

SELECT bomitemcost_id AS itemcost_id,
       CASE WHEN (costelem_sys) THEN 1
            ELSE 0
       END,
       CASE WHEN bomitemcost_costelem_id = -1 THEN :error
	    ELSE costelem_type
       END AS costelem_type,
       bomitemcost_lowlevel AS itemcost_lowlevel,
       bomitemcost_stdcost AS itemcost_stdcost, currConcat(baseCurrID()) AS baseCurr,
       bomitemcost_posted AS itemcost_posted,
       bomitemcost_actcost AS itemcost_actcost,
       currConcat(bomitemcost_curr_id) AS costCurr,
       bomitemcost_updated AS itemcost_updated,
       currToBase(bomitemcost_curr_id, bomitemcost_actcost, CURRENT_DATE) AS actcostBase,
       bomitemcost_curr_id AS itemcost_curr_id,
       CASE WHEN (COALESCE(bomitemcost_posted, startOfTime()) <= startOfTime()) THEN :never
       END AS itemcost_posted_qtdisplayrole,
       ''cost'' AS itemcost_stdcost_xtnumericrole,
       ''cost'' AS itemcost_actcost_xtnumericrole
FROM bomitemcost LEFT OUTER JOIN costelem ON (bomitemcost_costelem_id=costelem_id)
WHERE (bomitemcost_bomitem_id=<? value("bomitem_id") ?>)
ORDER BY bomitemcost_lowlevel, costelem_type;

<? endif ?>
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (451, 'metasqls', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: metasqls
-- Name:  detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

<? if exists(''byPackage'') ?>
SELECT metasql_id, metasql_group, metasql_name,
       firstline(metasql_notes) AS metasql_notes, metasql_grade,
       CASE nspname WHEN ''public'' THEN '''' ELSE nspname END AS pkgname,
       CASE nspname WHEN ''public'' THEN 0
                                  ELSE 1 END AS xtindentrole,
       metasql_notes AS metasql_notes_qttooltiprole 
  FROM metasql
  JOIN pg_class     ON (metasql.tableoid=pg_class.oid)
  JOIN pg_namespace ON (relnamespace=pg_namespace.oid)
 UNION 
SELECT -1, pkghead_name, NULL,
       firstline(pkghead_descrip), NULL,
       pkghead_name, 0, pkghead_descrip
  FROM metasql, pg_class, pg_namespace
       RIGHT OUTER JOIN pkghead ON (nspname=pkghead_name)
 WHERE ((metasql.tableoid=pg_class.oid)
    AND (relnamespace=pg_namespace.oid))
ORDER BY pkgname, xtindentrole, metasql_group, metasql_name,
         metasql_grade DESC, metasql_id;
<? else ?>
SELECT metasql_id, metasql_group, metasql_name,
       firstline(metasql_notes) AS metasql_notes,
       metasql_grade,
       CASE nspname WHEN ''public'' THEN '''' ELSE nspname END AS pkgname,
       metasql_notes AS metasql_notes_qttooltiprole 
  FROM metasql
  JOIN pg_class     ON (metasql.tableoid=pg_class.oid)
  JOIN pg_namespace ON (relnamespace=pg_namespace.oid)
ORDER BY metasql_group, metasql_name,
         metasql_grade DESC, metasql_id;
 <? endif ?>
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (440, 'openVouchers', 'populate', 'used by openVouchers Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: openVouchers
-- Name: populate
-- Notes: used by openVouchers
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT vohead_id, COALESCE(pohead_id, -1), vohead_number,
       COALESCE(TEXT(pohead_number), TEXT(<? value("misc") ?>)) AS ponumber,
       (vend_number || ''-'' || vend_name) AS vendor, vendtype_code, vohead_invcnumber,
       vohead_distdate, COALESCE(vohead_gldistdate, vohead_distdate) AS postdate,
       vohead_amount, ''curr'' AS vohead_amount_xtnumericrole,
       formatDate(vohead_distdate) AS f_distdate,
       formatDate(COALESCE(vohead_gldistdate, vohead_distdate)) AS f_postdate,
       formatMoney(vohead_amount) AS f_amount
  FROM vendinfo JOIN vendtype ON (vendtype_id=vend_vendtype_id)
                JOIN vohead ON (vohead_vend_id=vend_id)
                LEFT OUTER JOIN pohead ON (vohead_pohead_id=pohead_id) 
 WHERE (NOT vohead_posted)
<? if exists("vend_id") ?>
 AND (vend_id=<? value("vend_id") ?>)
<? elseif exists("vendtype_id") ?>
 AND (vend_vendtype_id=<? value("vendtype_id") ?>)
<? elseif exists("vendtype_pattern") ?>
 AND (vendtype_code ~ <? value("vendtype_pattern") ?>)
<? endif ?>
 ORDER BY vohead_number;
 
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (265, 'opensalesorders', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: opensalesorders
-- Name:  detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT DISTINCT
       cohead.*,
       COALESCE(cust_number, :error) AS cust_number,
       getSoSchedDate(cohead_id) AS scheddate, 
       getSoStatus(cohead_id) AS status,
<? foreach("char_id_text_list") ?>
       charass_alias<? literal("char_id_text_list") ?>.charass_value AS char<? literal("char_id_text_list") ?>,
<? endforeach ?>
<? foreach("char_id_list_list") ?>
       charass_alias<? literal("char_id_list_list") ?>.charass_value AS char<? literal("char_id_list_list") ?>,
<? endforeach ?>
<? foreach("char_id_date_list") ?>
       charass_alias<? literal("char_id_date_list") ?>.charass_value::date AS char<? literal("char_id_date_list") ?>,
<? endforeach ?>
       firstline(cohead_ordercomments) AS notes,
       calcSalesOrderAmt(cohead_id) AS ordertotal,
       CASE WHEN (calcSalesOrderAmt(cohead_id,''S'') != 0.0)
              THEN (calcSalesOrderAmt(cohead_id,''M'') / calcSalesOrderAmt(cohead_id,''S''))
            ELSE 1.0
       END AS ordermarginpercent,
       ''percent'' AS ordermarginpercent_xtnumericrole,
       ''extprice'' AS ordertotal_xtnumericrole
FROM cohead 
     JOIN custinfo ON (cohead_cust_id=cust_id) 
     JOIN custtype ON (cust_custtype_id=custtype_id)
<? if exists("selectedSites") ?> 
     JOIN coitem ON (coitem_cohead_id=cohead_id) 
     JOIN itemsite ON (coitem_itemsite_id=itemsite_id) 
     JOIN site() ON (itemsite_warehous_id=warehous_id) 
<? elseif  exists("warehous_id") ?> 
     LEFT OUTER JOIN coitem ON (coitem_cohead_id=cohead_id) 
     LEFT OUTER JOIN itemsite ON (coitem_itemsite_id=itemsite_id) 
     LEFT OUTER JOIN whsinfo ON (itemsite_warehous_id=warehous_id) 
<? endif ?> 
<? foreach("char_id_text_list") ?>
     LEFT OUTER JOIN charass charass_alias<? literal("char_id_text_list") ?> 
          ON ((charass_alias<? literal("char_id_text_list") ?>.charass_target_type=''SO'') 
         AND  (charass_alias<? literal("char_id_text_list") ?>.charass_target_id=cohead_id)
         AND  (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=<? value("char_id_text_list") ?>))
     LEFT OUTER JOIN char char_alias<? literal("char_id_text_list") ?> 
          ON (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=char_alias<? literal("char_id_text_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_list_list") ?>
     LEFT OUTER JOIN charass charass_alias<? literal("char_id_list_list") ?> 
          ON ((charass_alias<? literal("char_id_list_list") ?>.charass_target_type=''SO'') 
         AND  (charass_alias<? literal("char_id_list_list") ?>.charass_target_id=cohead_id)
         AND  (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=<? value("char_id_list_list") ?>))
     LEFT OUTER JOIN char char_alias<? literal("char_id_list_list") ?> 
          ON (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=char_alias<? literal("char_id_list_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_date_list") ?>
     LEFT OUTER JOIN charass charass_alias<? literal("char_id_date_list") ?> 
          ON ((charass_alias<? literal("char_id_date_list") ?>.charass_target_type=''SO'') 
         AND  (charass_alias<? literal("char_id_date_list") ?>.charass_target_id=cohead_id)
         AND  (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=<? value("char_id_date_list") ?>))
     LEFT OUTER JOIN char char_alias<? literal("char_id_date_list") ?> 
          ON (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=char_alias<? literal("char_id_date_list") ?>.char_id)
<? endforeach ?>
WHERE((true) 
<? if exists("cust_id") ?>
  AND (cust_id=<? value("cust_id") ?> )
<? endif ?>
<? if exists("custtype_id") ?>
  AND (cust_custtype_id=<? value("custtype_id") ?>)
<? endif ?>
<? if exists("custtype_pattern") ?>
  AND (custtype_code ~* <? value("custtype_pattern") ?>)
<? endif ?>
<? if exists("poNumber") ?>
  AND  (cohead_custponumber~*<? value("poNumber") ?>)
<? endif ?>
<? if exists("startDate") ?>
  AND (cohead_orderdate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
<? if not exists("showClosed") ?> 
  AND (cohead_status=''O'')
<? endif ?>
<? if  exists("warehous_id") ?>
  AND (warehous_id=<? value("warehous_id") ?>)
<? endif ?>
<? if  exists("salesrep_id") ?>
  AND (cohead_salesrep_id=<? value("salesrep_id") ?>)
<? endif ?>
<? literal("charClause") ?>
  ) 
ORDER BY cohead_number;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (58, 'itemReceipt', 'sourceItemSite', 'used by enterPoitemReceipt Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: itemReceipt
-- Name: sourceItemSite
-- Notes: used by enterPoitemReceipt
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

<? if exists("poitem_id") ?>			-- this should never be called
  SELECT -1 AS itemsite_id, -1 AS warehous_id;
<? elseif exists("toitem_id") ?>
  SELECT itemsite_id, tohead_dest_warehous_id AS warehous_id
  FROM tohead, toitem, itemsite 
  WHERE ((itemsite_item_id=toitem_item_id)
    AND  (itemsite_warehous_id=tohead_src_warehous_id)
    AND  (toitem_tohead_id=tohead_id)
    AND  (toitem_id=<? value("toitem_id") ?>));
<? elseif exists("recv_id") ?>			-- this should never be called
  SELECT itemsite_id, tohead_dest_warehous_id AS warehous_id
  FROM tohead, toitem, itemsite, recv
  WHERE ((itemsite_item_id=toitem_item_id)
    AND  (itemsite_warehous_id=tohead_src_warehous_id)
    AND  (toitem_tohead_id=tohead_id)
    AND  (toitem_id=recv_orderitem_id)
    AND  (recv_id=<? value("recv_id") ?>));
<? endif ?>
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (412, 'journals', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: journals
-- Name:  detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT sltrans.*,
       CASE WHEN(sltrans_docnumber=''Misc.'' AND
              invhist_docnumber IS NOT NULL) THEN
              (sltrans_docnumber || '' - '' || invhist_docnumber)
            ELSE sltrans_docnumber
       END AS docnumber,
       firstLine(sltrans_notes) AS notes,
       sltrans_journalnumber,
       (formatGLAccount(accnt_id) || '' - '' || accnt_descrip) AS account,
       CASE WHEN (sltrans_amount < 0) THEN ABS(sltrans_amount)
            ELSE NULL
       END AS debit,
       CASE WHEN (sltrans_amount > 0) THEN sltrans_amount
            ELSE NULL
       END AS credit,
       sltrans_gltrans_journalnumber,
       ''curr'' AS debit_xtnumericrole,
       ''curr'' AS credit_xtnumericrole
FROM sltrans JOIN accnt ON (sltrans_accnt_id=accnt_id) 
     LEFT OUTER JOIN invhist ON (sltrans_misc_id=invhist_id
                            AND sltrans_docnumber=''Misc.'') 
<? if exists("company_id") ?>
     JOIN company ON (accnt_company=company_number) 
<? endif ?>
<? if exists("prfcntr_id") ?>
     JOIN prftcntr ON (accnt_profit=prftcntr_number) 
<? endif ?>
<? if exists("subaccnt_id") ?>
     JOIN subaccnt ON (accnt_sub=subaccnt_number) 
<? endif ?>
<? if exists("subType") ?>
     JOIN subaccnttype ON (subaccnttype_code=accnt_subaccnttype_code) 
<? endif ?>
WHERE (
<? if exists("startDate") ?>
  <? if exists("endDate") ?>
       (sltrans_date BETWEEN <? value("startDate") ?>
                         AND <? value("endDate") ?>)
  <? else ?>
       (sltrans_date BETWEEN <? value("startDate") ?>
                         AND endoftime())
  <? endif ?>
<? else ?>
  <? if exists("endDate") ?>
       (sltrans_date BETWEEN startoftime()
                         AND <? value("endDate") ?>)
  <? else ?>
       (sltrans_date BETWEEN startoftime()
                         AND endoftime())
  <? endif ?>
<? endif ?>
<? if exists("company_id") ?>
   AND (company_id=<? value("company_id") ?>)
<? endif ?>
<? if exists("prfcntr_id") ?>
   AND (prftcntr_id=<? value("prfcntr_id") ?>)
<? endif ?>
<? if exists("accnt_number") ?>
   AND (accnt_number=<? value("accnt_number") ?>)
<? endif ?>
<? if exists("subaccnt_id") ?>
   AND (subaccnt_id=<? value("subaccnt_id") ?>)
<? endif ?>
<? if exists("subType") ?>
   AND (subaccnttype_id=<? value("subType") ?>)
<? endif ?>
<? if exists("accntType") ?>
   AND (accnt_type= <? value("accntType") ?>)
<? endif ?>
<? if exists("accnt_id") ?>
   AND (sltrans_accnt_id=<? value("accnt_id") ?>)
<? endif ?>
<? if exists("docnum") ?>
   AND (sltrans_docnumber = case when <? value("docnum") ?> = '''' then 
 sltrans_docnumber else 
<? value("docnum") ?> end ) 
<? endif ?>
<? if exists("source") ?>
   AND (sltrans_source=<? value("source") ?>)
<? endif ?>
<? if exists("source_pattern") ?>
   AND (sltrans_source ~* <? value("source_pattern") ?>)
<? endif ?>
<? if exists("posted") ?>
   AND (sltrans_posted=<? value("posted") ?>)
<? endif ?>
<? if exists("journalnumber") ?>
   AND (sltrans_gltrans_journalnumber::text=<? value("journalnumber") ?>)
<? endif ?>
) 
ORDER BY sltrans_created,
   sltrans_sequence, sltrans_amount;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (63, 'opportunities', 'detail', 'used by opportunityList Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: opportunities
-- Name: detail
-- Notes: used by opportunityList
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT DISTINCT ON (incdtpriority_order, ophead_target_date, ophead_name, ophead_id) 
       ophead_id AS id,
       CASE WHEN (ophead_active) THEN 0 ELSE 1 END AS altId,
       ophead_number,
       ophead_name,
       ophead_active,
       crmacct_number,
       ophead_owner_username,
       ophead_username,
       opstage_name,
       incdtpriority_name,
       opsource_name,
       optype_name,
       (ophead_probability_prcnt * .01) AS ophead_probability_prcnt,
       ophead_amount,
       currConcat(ophead_curr_id) As f_currency,
       ophead_target_date,
       ophead_actual_date,
       formatMoney(ophead_amount) AS f_amount,
       formatMoney(COALESCE(ophead_amount,0) * COALESCE(ophead_probability_prcnt * 0.01)) AS f_value,	
       formatDate(ophead_target_date) AS f_targetdate,
       formatDate(ophead_actual_date) AS f_actualdate,
       ''extprice'' AS ophead_amount_xtnumericrole,
       ''percent'' AS ophead_probability_prcnt_xtnumericrole
<? foreach("char_id_text_list") ?>
  , charass_alias<? literal("char_id_text_list") ?>.charass_value AS char<? literal("char_id_text_list") ?>
<? endforeach ?>
<? foreach("char_id_list_list") ?>
  , charass_alias<? literal("char_id_list_list") ?>.charass_value AS char<? literal("char_id_list_list") ?>
<? endforeach ?>
<? foreach("char_id_date_list") ?>
  , charass_alias<? literal("char_id_date_list") ?>.charass_value::date AS char<? literal("char_id_date_list") ?>
<? endforeach ?>
FROM ophead()
  LEFT OUTER JOIN incdtpriority ON (ophead_priority_id=incdtpriority_id)
  LEFT OUTER JOIN crmacct ON (ophead_crmacct_id=crmacct_id)
  LEFT OUTER JOIN opstage ON (ophead_opstage_id=opstage_id)
  LEFT OUTER JOIN opsource ON (ophead_opsource_id=opsource_id)
  LEFT OUTER JOIN optype ON (ophead_optype_id=optype_id)
<? foreach("char_id_text_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_text_list") ?> ON ((charass_alias<? literal("char_id_text_list") ?>.charass_target_type=''OPP'') 
                                                                    AND  (charass_alias<? literal("char_id_text_list") ?>.charass_target_id=ophead_id)
                                                                    AND  (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=<? value("char_id_text_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_text_list") ?> ON (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=char_alias<? literal("char_id_text_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_list_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_list_list") ?> ON ((charass_alias<? literal("char_id_list_list") ?>.charass_target_type=''OPP'') 
                                                                    AND  (charass_alias<? literal("char_id_list_list") ?>.charass_target_id=ophead_id)
                                                                    AND  (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=<? value("char_id_list_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_list_list") ?> ON (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=char_alias<? literal("char_id_list_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_date_list") ?>
  LEFT OUTER JOIN charass charass_alias<? literal("char_id_date_list") ?> ON ((charass_alias<? literal("char_id_date_list") ?>.charass_target_type=''OPP'') 
                                                                    AND  (charass_alias<? literal("char_id_date_list") ?>.charass_target_id=ophead_id)
                                                                    AND  (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=<? value("char_id_date_list") ?>))
  LEFT OUTER JOIN char char_alias<? literal("char_id_date_list") ?> ON (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=char_alias<? literal("char_id_date_list") ?>.char_id)
<? endforeach ?>
WHERE((true)
<? if exists("startDate") ?>
   AND ((ophead_target_date >= <? value("startDate") ?>)
    OR (<? value("startDate") ?> <= startOfTime()) AND (ophead_target_date IS NULL))
<? endif ?>
<? if exists("endDate") ?>
   AND ((ophead_target_date <= <? value("endDate") ?>)
    OR (<? value("endDate") ?> >= endOfTime()) AND (ophead_target_date IS NULL))
<? endif ?>
<? if exists("opsource_id") ?>
   AND (ophead_opsource_id=<? value("opsource_id") ?>)
<? endif ?>
<? if exists("opsource_pattern") ?>
   AND (opsource_name ~ <? value("opsource_pattern") ?>)
<? endif ?>
<? if exists("opstage_id") ?>
   AND (ophead_opstage_id=<? value("opstage_id") ?>)
<? endif ?>
<? if exists("opstage_pattern") ?>
   AND (opstage_name ~ <? value("opstage_pattern") ?>)
<? endif ?>
<? if exists("optype_id") ?>
   AND (ophead_optype_id=<? value("optype_id") ?>)
<? endif ?>
<? if exists("optype_pattern") ?>
   AND (optype_name ~ <? value("optype_pattern") ?>)
<? endif ?>
<? if exists("username") ?>
   AND (<? value("username") ?> IN (ophead_username, ophead_owner_username))
<? endif ?>
<? if exists("assigned_username") ?>
   AND (ophead_username=<? value("assigned_username") ?>)
<? endif ?>
<? if exists("assigned_usr_pattern") ?>
   AND (ophead_username ~ <? value("assigned_usr_pattern") ?>)
<? endif ?>
<? if exists("owner_username") ?>
   AND (ophead_owner_username=<? value("owner_username") ?>)
<? endif ?>
<? if exists("owner_usr_pattern") ?>
   AND (ophead_owner_username ~ <? value("owner_usr_pattern") ?>)
<? endif ?>
<? if exists("crmacct_id") ?>
   AND (ophead_crmacct_id = <? value("crmacct_id") ?>)
<? endif ?>
<? if exists("search_pattern") ?> 
   AND (ophead_name ~* <? value("search_pattern") ?>)
<? endif ?>
<? if exists("activeOnly") ?> 
   AND (ophead_active)
<? endif ?>
<? if exists("id") ?>
   AND (ophead_id=<? value("id") ?>
<? endif ?>
<? literal("charClause") ?>
 )
ORDER BY incdtpriority_order, ophead_target_date, ophead_name, ophead_id;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (59, 'maintainShipping', 'detail', 'used by maintainShipping order header info Copyright (c) 1999-2013 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: maintainShipping
-- Name: detail
-- Notes: used by maintainShipping
--        order header info
--        Copyright (c) 1999-2013 by OpenMFG LLC, d/b/a xTuple.
--        See www.xtuple.com/CPAL for the full text of the software license.

-- order header info
SELECT shiphead_id AS parent_id, cohead_id AS child_id,
       shiphead_number, cohead_number AS linenumber,
       ''SO'' AS ordertype,
       CASE WHEN (shiphead_sfstatus=''N'') THEN <? value("notPrinted") ?>
            WHEN (shiphead_sfstatus=''D'') THEN <? value("dirty") ?>
            WHEN (shiphead_sfstatus=''P'') THEN <? value("printed") ?>
            ELSE <? value("error") ?>
       END AS sfstatus,
       cust_number AS dest, cust_name AS description,
       shiphead_shipvia, NULL AS uom_name,
       NULL AS shipqty, NULL AS shipvalue,
<? if exists("includeFormatted") ?>
       NULL AS f_shipqty, NULL AS f_shipvalue,
<? endif ?>
       cohead_holdtype AS holdtype,
       shiphead_notes AS notes,
       shiphead_number AS shiphead_number_qtdisplayrole,
       ''SO'' AS ordertype_qtdisplayrole,
       ''qty'' AS shipqty_xtnumericrole,
       ''cost'' AS shipvalue_xtnumericrole,
       0 AS shipvalue_xttotalrole,
       0 AS xtindentrole,
       shiphead_id AS seq1, shiphead_order_id AS seq2,
       0 AS seq3, 0 AS seq4
FROM shiphead, custinfo, cohead
 <? if exists("warehous_id") ?>
      JOIN coitem ON (coitem_cohead_id=cohead_id)
      JOIN itemsite ON ((coitem_itemsite_id=itemsite_id)
                    AND (itemsite_warehous_id=<? value("warehous_id") ?>))
 <? endif ?>
WHERE ((NOT shiphead_shipped)
 AND (shiphead_order_type=''SO'')
 AND (shiphead_order_id=cohead_id)
 AND (cohead_cust_id=cust_id)
<? if exists("cust_id") ?>
 AND (cust_id=<? value("cust_id") ?>)
<? endif ?>
<? if exists("cohead_id") ?>
 AND (cohead_id=<? value("cohead_id") ?>)
<? endif ?>
) 
-- order line info
UNION ALL
SELECT cohead_id AS parent_id, coitem_id AS child_id,
       '''' AS shiphead_number, CAST(coitem_linenumber AS TEXT) AS linenumber,
       ''SO Item'' AS ordertype,
       NULL AS sfstatus,
       item_number AS dest, (item_descrip1 || '' '' || item_descrip2) AS description,
       NULL AS shiphead_shipvia, uom_name,
       qtyAtShipping(''SO'', coitem_id) AS shipqty,
       valueAtShipping(''SO'', coitem_id) AS shipvalue,
<? if exists("includeFormatted") ?>
       formatQty(qtyAtShipping(''SO'', coitem_id)) AS f_shipqty,
       formatCost(valueAtShipping(''SO'', coitem_id)) AS f_shipvalue,
<? endif ?>
       cohead_holdtype AS holdtype,
       '''' as notes,
       NULL AS shiphead_number_qtdisplayrole,
       NULL AS ordertype_qtdisplayrole,
       ''qty'' AS shipqty_xtnumericrole,
       ''cost'' AS shipvalue_xtnumericrole,
       0 AS shipvalue_xttotalrole,
       1 AS xtindentrole,
       shiphead_id AS seq1, shiphead_order_id AS seq2,
       coitem_id AS seq3, 0 AS seq4
FROM shiphead, cohead, coitem, uom, itemsite, item
WHERE ((NOT shiphead_shipped)
 AND (shiphead_order_type=''SO'')
 AND (shiphead_order_id=cohead_id)
 AND (cohead_id=coitem_cohead_id)
 AND (coitem_qty_uom_id=uom_id)
 AND (coitem_itemsite_id=itemsite_id)
 AND (itemsite_item_id=item_id)
 <? if exists("warehous_id") ?>
 AND (itemsite_warehous_id=<? value("warehous_id") ?>)
 <? endif ?>
<? if exists("cust_id") ?>
 AND (cohead_cust_id=<? value("cust_id") ?>)
<? endif ?>
<? if exists("cohead_id") ?>
 AND (cohead_id=<? value("cohead_id") ?>)
<? endif ?>
) 
-- shipitem info
UNION ALL
SELECT shiphead_id AS parent_id, shipitem_id AS child_id,
       '''' AS shiphead_number, '''' AS linenumber,
       ''SO Ship'' AS ordertype,
       NULL AS sfstatus,
       '''' AS dest,
       formatDate(shipitem_transdate) || '' by '' || shipitem_trans_username AS description,
       '''' AS shiphead_shipvia, '''' AS uom_name,
       shipitem_qty AS shipqty,
       NULL AS shipvalue,
<? if exists("includeFormatted") ?>
       formatQty(shipitem_qty) AS f_shipqty,
       NULL AS f_shipvalue,
<? endif ?>
       '''' AS holdtype,
       '''' AS notes,
       NULL AS shiphead_number_qtdisplayrole,
       NULL AS ordertype_qtdisplayrole,
       ''qty'' AS shipqty_xtnumericrole,
       ''cost'' AS shipvalue_xtnumericrole,
       0 AS shipvalue_xttotalrole,
       2 AS xtindentrole,
       shiphead_id AS seq1, shiphead_order_id AS seq2,
       shipitem_orderitem_id AS seq3, shipitem_id AS seq4
FROM shiphead JOIN cohead ON (cohead_id=shiphead_order_id)
              JOIN shipitem ON (shipitem_shiphead_id=shiphead_id)
 <? if exists("warehous_id") ?>
      JOIN coitem ON ((shipitem_orderitem_id=coitem_id)
                  AND (shiphead_order_type=''SO''))
      JOIN itemsite ON ((coitem_itemsite_id=itemsite_id)
                    AND (itemsite_warehous_id=<? value("warehous_id") ?>))
 <? endif ?>
WHERE ((NOT shiphead_shipped)
 AND (shiphead_order_type=''SO'')
<? if exists("cust_id") ?>
 AND (cohead_cust_id=<? value("cust_id") ?>)
<? endif ?>
<? if exists("cohead_id") ?>
 AND (cohead_id=<? value("cohead_id") ?>)
<? endif ?>
) 
<? if exists("includeDistributions") ?>
-- distribution info
UNION ALL
SELECT shiphead_id AS parent_id, shipitem_id AS child_id,
       '''' AS shiphead_number, '''' AS linenumber,
       ''SO Dist'' AS ordertype,
       NULL AS sfstatus,
       formatLocationName(invdetail_location_id) AS dest,
       formatLotSerialNumber(invdetail_ls_id) AS description,
       formatDate(invdetail_expiration) AS shiphead_shipvia, '''' AS uom_name,
       invdetail_qty AS shipqty,
       NULL AS shipvalue,
<? if exists("includeFormatted") ?>
       formatQty(invdetail_qty) AS f_shipqty,
       NULL AS f_shipvalue,
<? endif ?>
       '''' AS holdtype,
       '''' AS notes,
       NULL AS shiphead_number_qtdisplayrole,
       NULL AS ordertype_qtdisplayrole,
       ''qty'' AS shipqty_xtnumericrole,
       ''cost'' AS shipvalue_xtnumericrole,
       0 AS shipvalue_xttotalrole,
       3 AS xtindentrole,
       shiphead_id AS seq1, shiphead_order_id AS seq2,
       shipitem_orderitem_id AS seq3, shipitem_id AS seq4
FROM shiphead JOIN cohead ON (cohead_id=shiphead_order_id)
              JOIN shipitem ON (shipitem_shiphead_id=shiphead_id)
              LEFT OUTER JOIN invhist ON (invhist_id=shipitem_invhist_id)
              LEFT OUTER JOIN invdetail ON (invdetail_invhist_id=invhist_id)
 <? if exists("warehous_id") ?>
      JOIN coitem ON ((shipitem_orderitem_id=coitem_id)
                  AND (shiphead_order_type=''SO''))
      JOIN itemsite ON ((coitem_itemsite_id=itemsite_id)
                    AND (itemsite_warehous_id=<? value("warehous_id") ?>))
 <? endif ?>
WHERE ((NOT shiphead_shipped)
 AND (shiphead_order_type=''SO'')
<? if exists("cust_id") ?>
 AND (cohead_cust_id=<? value("cust_id") ?>)
<? endif ?>
<? if exists("cohead_id") ?>
 AND (cohead_id=<? value("cohead_id") ?>)
<? endif ?>
) 
<? endif ?>

<? if exists("MultiWhs") ?>
UNION ALL
-- order header info
SELECT shiphead_id AS parent_id, tohead_id AS child_id,
       shiphead_number, tohead_number AS linenumber,
       ''TO'' AS ordertype,
       CASE WHEN (shiphead_sfstatus=''N'') THEN <? value("notPrinted") ?>
            WHEN (shiphead_sfstatus=''D'') THEN <? value("dirty") ?>
            WHEN (shiphead_sfstatus=''P'') THEN <? value("printed") ?>
            ELSE <? value("error") ?>
       END AS sfstatus,
       tohead_destname AS dest, tohead_destcntct_name AS description,
       shiphead_shipvia, NULL AS uom_name,
       NULL AS shipqty, NULL AS shipvalue,
<? if exists("includeFormatted") ?>
       NULL AS f_shipqty, NULL AS f_shipvalue,
<? endif ?>
       ''TO'' AS holdtype,
       shiphead_notes AS notes,
       shiphead_number AS shiphead_number_qtdisplayrole,
       ''TO'' AS ordertype_qtdisplayrole,
       ''qty'' AS shipqty_xtnumericrole,
       ''cost'' AS shipvalue_xtnumericrole,
       0 AS shipvalue_xttotalrole,
       0 AS xtindentrole,
       shiphead_id AS seq1, shiphead_order_id AS seq2,
       0 AS seq3, 0 AS seq4
FROM shiphead, tohead
 <? if exists("warehous_id") ?>
      JOIN toitem ON (toitem_tohead_id=tohead_id)
      JOIN itemsite ON ((toitem_item_id=itemsite_item_id)
                    AND (itemsite_warehous_id=<? value("warehous_id") ?>))
 <? endif ?>
WHERE ((NOT shiphead_shipped)
 AND (shiphead_order_type=''TO'')
 AND (shiphead_order_id=tohead_id)
<? if exists("cust_id") ?>
 AND FALSE
<? endif ?>
<? if exists("cohead_id") ?>
 AND FALSE
<? endif ?>
) 
-- order line info
UNION ALL
SELECT tohead_id AS parent_id, toitem_id AS child_id,
       '''' AS shiphead_number, CAST(toitem_linenumber AS TEXT) AS linenumber,
       ''TO'' AS ordertype,
       NULL AS sfstatus,
       item_number AS dest, (item_descrip1 || '' '' || item_descrip2) AS description,
       NULL AS shiphead_shipvia, toitem_uom AS uom_name,
       qtyAtShipping(''TO'', toitem_id) AS shipqty,
       valueAtShipping(''TO'', toitem_id) AS shipvalue,
<? if exists("includeFormatted") ?>
       formatQty(qtyAtShipping(''TO'', toitem_id)) AS f_shipqty,
       formatCost(valueAtShipping(''TO'', toitem_id)) AS f_shipvalue,
<? endif ?>
       ''TO'' AS holdtype,
       '''' AS notes,
       NULL AS shiphead_number_qtdisplayrole,
       NULL AS ordertype_qtdisplayrole,
       ''qty'' AS shipqty_xtnumericrole,
       ''cost'' AS shipvalue_xtnumericrole,
       0 AS shipvalue_xttotalrole,
       1 AS xtindentrole,
       shiphead_id AS seq1, shiphead_order_id AS seq2,
       toitem_id AS seq3, 0 AS seq4
FROM shiphead, tohead, item, toitem
 <? if exists("warehous_id") ?>
      JOIN itemsite ON ((toitem_item_id=itemsite_item_id)
                    AND (itemsite_warehous_id=<? value("warehous_id") ?>))
 <? endif ?>
WHERE ((NOT shiphead_shipped)
 AND (shiphead_order_type=''TO'')
 AND (shiphead_order_id=tohead_id)
 AND (tohead_id=toitem_tohead_id)
 AND (toitem_item_id=item_id)
<? if exists("cust_id") ?>
 AND FALSE
<? endif ?>
<? if exists("cohead_id") ?>
 AND FALSE
<? endif ?>
) 
-- shipitem info
UNION
SELECT shiphead_id AS parent_id, shipitem_id AS child_id,
       '''' AS shiphead_number, '''' AS linenumber,
       ''TO'' AS ordertype,
       NULL AS sfstatus,
       '''' AS dest,
       formatDate(shipitem_transdate) || '' by '' || shipitem_trans_username AS description,
       '''' AS shiphead_shipvia, '''' AS uom_name,
       shipitem_qty AS shipqty,
       NULL AS shipvalue,
<? if exists("includeFormatted") ?>
       formatQty(shipitem_qty) AS f_shipqty,
       NULL AS f_shipvalue,
<? endif ?>
       '''' AS holdtype,
       '''' AS notes,
       NULL AS shiphead_number_qtdisplayrole,
       NULL AS ordertype_qtdisplayrole,
       ''qty'' AS shipqty_xtnumericrole,
       ''cost'' AS shipvalue_xtnumericrole,
       0 AS shipvalue_xttotalrole,
       2 AS xtindentrole,
       shiphead_id AS seq1, shiphead_order_id AS seq2,
       shipitem_orderitem_id AS seq3, shipitem_id AS seq4
FROM shiphead JOIN shipitem ON (shipitem_shiphead_id=shiphead_id)
 <? if exists("warehous_id") ?>
      JOIN toitem ON ((shipitem_orderitem_id=toitem_id)
                  AND (shiphead_order_type=''TO''))
      JOIN itemsite ON ((toitem_item_id=itemsite_item_id)
                    AND (itemsite_warehous_id=<? value("warehous_id") ?>))
 <? endif ?>
WHERE ((NOT shiphead_shipped)
 AND (shiphead_order_type=''TO'')
<? if exists("cust_id") ?>
 AND FALSE
<? endif ?>
<? if exists("cohead_id") ?>
 AND FALSE
<? endif ?>
) 

<? endif ?>
ORDER BY seq1, seq2, seq3, seq4, xtindentrole;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (262, 'mrpDetail', 'detail', 'used by dspMRPDetail Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: mrpDetail
-- Name: detail
-- Notes: used by dspMRPDetail
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT formatQty(itemsite_qtyonhand) AS f_qoh,itemsite_qtyonhand
       , qtyAllocated(itemsite_id, findPeriodStart(<? value("cursorId") ?>),
                       findPeriodEnd(<? value("cursorId") ?>)) AS allocations<? value("counter") ?>,
       qtyOrdered(itemsite_id, findPeriodStart(<? value("cursorId") ?>),
                       findPeriodEnd(<? value("cursorId") ?>)) AS orders<? value("counter") ?>,
       qtyFirmedAllocated(itemsite_id, findPeriodStart(<? value("cursorId") ?>),
                       findPeriodEnd(<? value("cursorId") ?>)) AS firmedallocations<? value("counter") ?>,
       qtyFirmed(itemsite_id, findPeriodStart(<? value("cursorId") ?>),
                       findPeriodEnd(<? value("cursorId") ?>)) AS firmedorders<? value("counter") ?>
FROM itemsite
WHERE (itemsite_id=<? value("itemsite_id") ?>);
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (64, 'orders', 'detail', 'used by dspOrders Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: orders
-- Name: detail
-- Notes: used by dspOrders
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT source_id, type, order_type, order_status, order_number, duedate,
       totalqty, relievedqty, balanceqty, balanceqty AS runningbalanceqty,
       ''qty'' AS totalqty_xtnumericrole,
       ''qty'' AS relievedqty_xtnumericrole,
       ''qty'' AS balanceqty_xtnumericrole,
       0 AS runningbalanceqty_xtrunningrole,
       CASE WHEN (late) THEN ''error'' END AS duedate_qtforegroundrole
FROM
(
SELECT poitem_id AS source_id, 1 AS type, TEXT(''P/O'') AS order_type,
       pohead_status AS order_status,
       TEXT(pohead_number) AS order_number,
       poitem_qty_ordered AS totalqty,
       poitem_qty_received AS relievedqty,
       noNeg(poitem_qty_ordered - poitem_qty_received) AS balanceqty,
       poitem_duedate AS duedate,
       (poitem_duedate < CURRENT_DATE) AS late
FROM pohead, poitem, itemsite
WHERE ((poitem_pohead_id=pohead_id)
  AND  (poitem_status IN (''O'',''U''))
  AND  (poitem_itemsite_id=itemsite_id)
  AND  (itemsite_item_id=<? value("item_id") ?>)
  AND  (itemsite_warehous_id=<? value("warehous_id") ?>)
<? if exists("useLeadTime") ?>
  AND  (poitem_duedate <= (CURRENT_DATE + itemsite_leadtime))
<? elseif exists("days") ?>
  AND  (poitem_duedate <= (CURRENT_DATE + <? value("days") ?>))
<? elseif exists("date") ?>
  AND  (poitem_duedate<=<? value("date") ?>)
<? elseif exists("startDate") ?>
  AND  (poitem_duedate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
      )

UNION
SELECT wo_id AS source_id, 2 AS type, TEXT(''W/O'') AS order_type,
       wo_status AS order_status,
       formatWONumber(wo_id) AS order_number,
       wo_qtyord AS totalqty,
       wo_qtyrcv AS relievedqty,
       noNeg(wo_qtyord - wo_qtyrcv) AS balanceqty,
       wo_duedate AS duedate,
       (wo_duedate < CURRENT_DATE) AS late 
FROM wo, itemsite
WHERE ((wo_status<>''C'')
  AND  (wo_itemsite_id=itemsite_id)
  AND  (itemsite_item_id=<? value("item_id") ?>)
  AND  (itemsite_warehous_id=<? value("warehous_id") ?>)
  AND  (<? value("itemType") ?> NOT IN (''C'', ''Y''))
<? if exists("useLeadTime") ?>
  AND  (wo_duedate <= (CURRENT_DATE + itemsite_leadtime))
<? elseif exists("days") ?>
  AND  (wo_duedate <= (CURRENT_DATE + <? value("days") ?>))
<? elseif exists("date") ?>
  AND  (wo_duedate<=<? value("date") ?>)
<? elseif exists("startDate") ?>
  AND  (wo_duedate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
      )

-- Tooling is also supply on Work Orders
UNION
SELECT wo_id AS source_id, 2 AS type, TEXT(''W/O'') AS order_type,
       wo_status AS order_status,
       formatWONumber(wo_id) AS order_number,
       womatl_qtyreq AS totalqty,
       COALESCE(sum(abs(invhist_invqty)),0) AS relievedqty,
       noNeg(womatl_qtyreq - COALESCE(sum(abs(invhist_invqty)),0)) AS balanceqty,
       wo_duedate AS duedate,
       (wo_duedate < CURRENT_DATE) AS late 
FROM womatl
  JOIN wo ON (wo_id=womatl_wo_id)
  JOIN itemsite ON (itemsite_id=womatl_itemsite_id)
  JOIN item ON (item_id=itemsite_item_id)
  LEFT OUTER JOIN womatlpost ON (womatl_id=womatlpost_womatl_id)
  LEFT OUTER JOIN invhist ON ((womatlpost_invhist_id=invhist_id)
                          AND (invhist_invqty < 0))
WHERE ((wo_status<>''C'')
  AND  (itemsite_item_id=<? value("item_id") ?>)
  AND  (itemsite_warehous_id=<? value("warehous_id") ?>)
  AND  (item_type = ''T'')
<? if exists("useLeadTime") ?>
  AND  (wo_duedate <= (CURRENT_DATE + itemsite_leadtime))
<? elseif exists("days") ?>
  AND  (wo_duedate <= (CURRENT_DATE + <? value("days") ?>))
<? elseif exists("date") ?>
  AND  (wo_duedate<=<? value("date") ?>)
<? elseif exists("startDate") ?>
  AND  (wo_duedate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
      )
GROUP BY wo_id, wo_status, womatl_qtyreq, wo_duedate

<? if exists("Manufacturing") ?>
UNION
SELECT wo_id AS source_id, 2 AS type, TEXT(''W/O'') AS order_type,
       wo_status AS order_status,
       formatWONumber(wo_id) AS order_number,
       wo_qtyord AS totalqty,
       wo_qtyrcv AS relievedqty,
       noNeg(wo_qtyord - wo_qtyrcv) AS balanceqty,
       wo_duedate AS duedate,
       (wo_duedate < CURRENT_DATE) AS late
FROM wo, xtmfg.brddist, itemsite
WHERE ((brddist_wo_id=wo_id)
  AND  (wo_status<>''C'')
  AND  (brddist_itemsite_id=itemsite_id)
  AND  (itemsite_item_id=<? value("item_id") ?>)
  AND  (itemsite_warehous_id=<? value("warehous_id") ?>)
  AND  (<? value("itemType") ?> IN (''C'', ''Y''))
<? if exists("useLeadTime") ?>
  AND (wo_duedate <= (CURRENT_DATE + itemsite_leadtime))
<? elseif exists("days") ?>
  AND (wo_duedate <= (CURRENT_DATE + <? value("days") ?>))
<? elseif exists("date") ?>
  AND (wo_duedate<=<? value("date") ?>)
<? elseif exists("startDate") ?>
  AND (wo_duedate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
     )
<? endif ?>

<? if exists("Standard") ?>
UNION
SELECT toitem_id AS source_id, 3 AS type, TEXT(''T/O'') AS order_type,
       tohead_status AS order_status,
       TEXT(tohead_number) AS order_number,
       toitem_qty_ordered AS totalqty,
       toitem_qty_received AS relievedqty,
       noNeg(toitem_qty_ordered - toitem_qty_received) AS balanceqty,
       toitem_duedate AS duedate,
       (toitem_duedate < CURRENT_DATE) AS late
FROM tohead, toitem, itemsite
WHERE ((toitem_tohead_id=tohead_id)
  AND  (toitem_status=''O'')
  AND  (toitem_item_id=itemsite_item_id)
  AND  (tohead_dest_warehous_id=itemsite_warehous_id)
  AND  (itemsite_item_id=<? value("item_id") ?>)
  AND  (itemsite_warehous_id=<? value("warehous_id") ?>)
<? if exists("useLeadTime") ?>
  AND  (toitem_duedate <= (CURRENT_DATE + itemsite_leadtime))
<? elseif exists("days") ?>
  AND  (toitem_duedate <= (CURRENT_DATE + <? value("days") ?>))
<? elseif exists("date") ?>
  AND  (toitem_duedate<=<? value("date") ?>)
<? elseif exists("startDate") ?>
  AND  (toitem_duedate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? endif ?>
      )
<? endif ?>

) AS data

ORDER BY duedate;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (111, 'package', 'items', 'replace the not-so-old pkgitem table with direct query of catalogs and tables so we never miss anything and do not have to maintain the data TODO: is there a better sort order? Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: package
-- Name:  items
-- Notes: replace the not-so-old pkgitem table with direct query of catalogs
--        and tables so we never miss anything and do not have to maintain the
--        data
-- TODO: is there a better sort order?
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT *,
       CASE WHEN pkgitem_type=''C'' THEN <? value("script") ?>
            WHEN pkgitem_type=''D'' THEN <? value("cmd") ?>
            WHEN pkgitem_type=''F'' THEN <? value("function") ?>
            WHEN pkgitem_type=''G'' THEN <? value("trigger") ?>
            WHEN pkgitem_type=''I'' THEN <? value("image") ?>
            WHEN pkgitem_type=''M'' THEN <? value("metasql") ?>
            WHEN pkgitem_type=''P'' THEN <? value("priv") ?>
            WHEN pkgitem_type=''R'' THEN <? value("report") ?>
            WHEN pkgitem_type=''S'' THEN <? value("schema") ?>
            WHEN pkgitem_type=''T'' THEN <? value("table") ?>
            WHEN pkgitem_type=''U'' THEN <? value("uiform") ?>
            WHEN pkgitem_type=''V'' THEN <? value("view") ?>
            WHEN pkgitem_type=''sequence'' THEN <? value("sequence") ?>
            WHEN pkgitem_type=''index''    THEN <? value("index") ?>
       ELSE pkgitem_type END AS pkgitem_type_qtdisplayrole
FROM (
SELECT script_id AS pkgitem_id, ''C'' AS pkgitem_type,
       script_id AS pkgitem_item_id,
       script_name AS pkgitem_name,
       script_notes AS pkgitem_descrip
  FROM <? literal("pkgname") ?>.pkgscript 
UNION 
SELECT cmd_id AS pkgitem_id, ''D'' AS pkgitem_type,
       cmd_id AS pkgitem_item_id,
       cmd_name AS pkgitem_name,
       cmd_descrip AS pkgitem_descrip 
  FROM <? literal("pkgname") ?>.pkgcmd 
UNION 
SELECT pg_proc.oid AS pkgitem_id, ''F'' AS pkgitem_type,
       pg_proc.oid AS pkgitem_item_id,
       proname || ''('' || oidvectortypes(proargtypes)
               || '')'' AS pkgitem_name,
       pg_catalog.obj_description(pg_proc.oid, ''pg_proc'') AS pkgitem_descrip 
  FROM pg_proc
       JOIN pg_namespace ON (pronamespace=pg_namespace.oid)
 WHERE (nspname=<? value("pkgname") ?>) 
UNION 
SELECT t.oid AS pkgitem_id, ''G'' AS pkgitem_type,
       t.oid AS pkgitem_item_id,
       tgname AS pkgitem_name,
       pg_catalog.obj_description(t.oid, ''pg_trigger'') AS pkgitem_descrip 
  FROM pg_trigger t
       JOIN pg_class ON (tgrelid=pg_class.oid)
       JOIN pg_namespace ON (relnamespace=pg_namespace.oid)
 WHERE ((nspname=<? value("pkgname") ?>) 
<? if not exists("showsystemdetails") ?>
    AND (tgconstraint = 0)
   AND  (tgname !~ ''^pkg(cmd(arg)?|image|metasql|priv|report|script|uiform)'')
<? endif ?>
    )
UNION 
SELECT image_id AS pkgitem_id, ''I'' AS pkgitem_type,
       image_id AS pkgitem_item_id,
       image_name AS pkgitem_name,
       image_descrip AS pkgitem_descrip 
  FROM <? literal("pkgname") ?>.pkgimage 
UNION 
SELECT metasql_id AS pkgitem_id, ''M'' AS pkgitem_type,
       metasql_id AS pkgitem_item_id,
       metasql_group || ''-'' || metasql_name AS pkgitem_name,
       metasql_notes AS pkgitem_descrip 
  FROM <? literal("pkgname") ?>.pkgmetasql 
UNION 
SELECT priv_id AS pkgitem_id, ''P'' AS pkgitem_type,
       priv_id AS pkgitem_item_id,
       priv_module || ''.'' || priv_name AS pkgitem_name,
       priv_descrip AS pkgitem_descrip 
  FROM <? literal("pkgname") ?>.pkgpriv 
UNION 
SELECT report_id AS pkgitem_id, ''R'' AS pkgitem_type,
       report_id AS pkgitem_item_id,
       report_name AS pkgitem_name,
       report_descrip AS pkgitem_descrip 
  FROM <? literal("pkgname") ?>.pkgreport 
UNION 
SELECT n.oid AS pkgitem_id, ''S'' AS pkgitem_type,
       n.oid AS pkgitem_item_id,
       nspname AS pkgitem_name,
       pg_catalog.obj_description(n.oid, ''pg_namespace'') AS pkgitem_descrip 
  FROM pg_namespace n
 WHERE (nspname=<? value("pkgname") ?>) 
UNION 
SELECT c.oid AS pkgitem_id, ''T'' AS pkgitem_type,
       c.oid AS pkgitem_item_id,
       relname AS pkgitem_name,
       pg_catalog.obj_description(c.oid, ''pg_class'') AS pkgitem_descrip 
  FROM pg_class c
       JOIN pg_namespace ON (relnamespace=pg_namespace.oid)
 WHERE ((nspname=<? value("pkgname") ?>)
   AND  (relkind=''r'')
<? if not exists("showsystemdetails") ?>
   AND  (relname !~ ''^pkg(cmd(arg)?|image|metasql|priv|report|script|uiform)$'')
<? endif ?>
   )
UNION 
SELECT uiform_id AS pkgitem_id, ''U'' AS pkgitem_type,
       uiform_id AS pkgitem_item_id,
       uiform_name AS pkgitem_name,
       uiform_notes AS pkgitem_descrip 
  FROM <? literal("pkgname") ?>.pkguiform 
UNION 
SELECT c.oid AS pkgitem_id, ''V'' AS pkgitem_type,
       c.oid AS pkgitem_item_id,
       relname AS pkgitem_name,
       pg_catalog.obj_description(c.oid, ''pg_class'') AS pkgitem_descrip 
  FROM pg_class c
       JOIN pg_namespace ON (relnamespace=pg_namespace.oid)
 WHERE ((nspname=<? value("pkgname") ?>)
   AND  (relkind=''v''))
<? if exists("showsystemdetails") ?>
UNION
SELECT c.oid AS pkgitem_id, ''sequence'' AS pkgitem_type,
       c.oid AS pkgitem_item_id,
       relname AS pkgitem_name,
       pg_catalog.obj_description(c.oid, ''pg_class'') AS pkgitem_descrip 
  FROM pg_class c
       JOIN pg_namespace ON (relnamespace=pg_namespace.oid)
 WHERE ((nspname=<? value("pkgname") ?>)
   AND  (relkind=''S''))
UNION
SELECT c.oid AS pkgitem_id, ''index'' AS pkgitem_type,
       c.oid AS pkgitem_item_id,
       relname AS pkgitem_name,
       pg_catalog.obj_description(c.oid, ''pg_class'') AS pkgitem_descrip 
  FROM pg_class c
       JOIN pg_namespace ON (relnamespace=pg_namespace.oid)
 WHERE ((nspname=<? value("pkgname") ?>)
   AND  (relkind=''i''))
<? endif ?>
) AS pkgitem 
ORDER BY pkgitem_type_qtdisplayrole, pkgitem_name;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (69, 'packingList', 'shipment', 'used by printPackingList Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: packingList
-- Name: shipment
-- Notes: used by printPackingList
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT shiphead_order_id, shiphead_order_type, shiphead_shipform_id, cohead_number AS number
FROM shiphead, cohead
WHERE ((shiphead_id=<? value("shiphead_id") ?>)
  AND  (cohead_id=shiphead_order_id)
  AND  (shiphead_order_type=''SO''))
<? if exists("MultiWhs") ?>
UNION
SELECT shiphead_order_id, shiphead_order_type, shiphead_shipform_id, tohead_number AS number
FROM shiphead, tohead
WHERE ((shiphead_id=<? value("shiphead_id") ?>)
  AND  (tohead_id=shiphead_order_id)
  AND  (shiphead_order_type=''TO''))
<? endif ?>
;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (259, 'itemSites', 'detail', ' Notes: Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: itemSites
-- Name: detail
-- Notes:
-- Notes:
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT itemsite_id,warehous_code,itemsite_qtyonhand, itemsite_active, 
       CASE WHEN ( (itemsite_loccntrl) OR
                   (itemsite_controlmethod IN (''L'', ''S'')) ) THEN 1
            ELSE 0
       END AS altId,
       CASE WHEN itemsite_controlmethod=''R'' THEN <? value("regular") ?>
                           WHEN itemsite_controlmethod=''N'' THEN <? value("none") ?>
                           WHEN itemsite_controlmethod=''L'' THEN <? value("lot") ?>
                           WHEN itemsite_controlmethod=''S'' THEN <? value("serial") ?>
                      END AS controlmethod,
         itemsite_loccntrl,
         item_number,
         (item_descrip1 || '' '' || item_descrip2) AS description, 
         uom_name,
         CASE WHEN (itemsite_sold) THEN TEXT(itemsite_soldranking)
         END AS soldranking,
         CASE WHEN (itemsite_datelastcount=startOfTime()) THEN NULL
           ELSE itemsite_datelastcount
         END AS datelastcount,
         CASE WHEN (itemsite_datelastused=startOfTime()) THEN NULL
           ELSE itemsite_datelastused
         END AS datelastused,
         itemsite_abcclass, itemsite_cyclecountfreq,
         ''qty'' AS itemsite_qtyonhand_xtnumericrole,
        <? value("na") ?> AS soldranking_xtnullrole,
        <? value("never") ?> AS datelastused_xtnullrole,
        <? value("never") ?> AS datelastcount_xtnullrole             
FROM item, uom, itemsite, whsinfo
WHERE ((itemsite_warehous_id=warehous_id)
         AND (itemsite_item_id=item_id)
         AND(item_inv_uom_id=uom_id)
       <? if exists("search_pattern") ?>
         AND ((item_number ~* <? value("search_pattern") ?>)
           OR (COALESCE(item_descrip1,'''') || '' '' || COALESCE(item_descrip2,'''') ~* <? value("search_pattern") ?>)
           OR (warehous_code ~* <? value("search_pattern") ?>))
       <? endif ?>
       <? if exists("item_id") ?>
         AND (item_id=<? value("item_id") ?>)
       <? endif ?>
       <? if exists("classcode_id") ?>
         AND (item_classcode_id=<? value("classcode_id") ?>)
       <? endif ?>
       <? if exists("itemgrp_id") ?>
         AND (item_id IN (SELECT itemgrpitem_item_id 
                          FROM itemgrpitem 
                          WHERE (itemgrpitem_itemgrp_id=<? value("itemgrp_id") ?>)))
       <? endif ?>
       <? if exists("plancode_id") ?>
         AND (itemsite_plancode_id=<? value("plancode_id") ?>)
       <? endif ?>
       <? if exists("costcat_id") ?>
         AND (itemsite_costcat_id=<? value("costcat_id") ?>)
       <? endif ?>
       <? if exists("classcode_pattern") ?>
         AND (item_classcode_id IN (SELECT classcode_id 
                                    FROM classcode 
                                    WHERE (classcode_code ~ <? value("classcode_pattern") ?>)))
       <? endif ?>
       <? if exists("itemgrp_pattern") ?>
         AND (item_id IN (SELECT itemgrpitem_item_id 
                          FROM itemgrpitem, itemgrp 
                          WHERE ( (itemgrpitem_itemgrp_id=itemgrp_id) 
                              AND (itemgrp_name ~ <? value("itemgrp_pattern") ?>) ) ))
       <? endif ?>
       <? if exists("plancode_pattern") ?>
         AND (itemsite_plancode_id IN (SELECT plancode_id 
                                       FROM plancode 
                                       WHERE (plancode_code ~ <? value("plancode_pattern") ?>)))
       <? endif ?>
       <? if exists("costcat_pattern") ?>
         AND (itemsite_costcat_id IN (SELECT costcat_id 
                                      FROM costcat 
                                      WHERE (costcat_code ~ <? value("costcat_pattern") ?>)))
       <? endif ?>
     <? if exists("warehous_id") ?>
       AND (warehous_id=<? value("warehous_id") ?>)
     <? endif ?>
   <? if not exists("showInactive") ?>
     AND (itemsite_active)
   <? endif ?>
       )
ORDER BY item_number, warehous_code;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (485, 'packingListBatch', 'clear', 'used by packingListBatch Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: packingListBatch
-- Name: clear
-- Notes: used by packingListBatch
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

DELETE FROM pack WHERE pack_id IN
  (SELECT pack_id
   FROM pack JOIN cohead ON (cohead_id=pack_head_id)
             JOIN coitem ON (coitem_cohead_id=cohead_id)
             JOIN itemsite ON (itemsite_id=coitem_itemsite_id)
   WHERE ( (checkSOSitePrivs(cohead_id))
     AND   (pack_head_type=''SO'')
     AND   (pack_printed) 
<? if exists("warehous_id") ?>
     AND   (itemsite_warehous_id = <? value("warehous_id") ?>)
<? endif ?>
         )
  );

<? if exists("MultiWhs") ?>
DELETE FROM pack WHERE pack_id IN
  (SELECT pack_id
   FROM pack JOIN tohead ON (tohead_id=pack_head_id)
   WHERE ( (pack_head_type=''TO'')
     AND   (pack_printed)
<? if exists("warehous_id") ?>
     AND   (tohead_src_warehous_id = <? value("warehous_id") ?>)
<? endif ?>
         )
  );
<? endif ?>
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (67, 'packingListBatch', 'detail', 'used by packingListBatch Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: packingListBatch
-- Name: detail
-- Notes: used by packingListBatch
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT DISTINCT
       cohead_id, pack_shiphead_id, 
       cohead_number AS order_number, pack_head_type,
       cohead_shipvia AS shipvia,
       formatShipmentNumber(pack_shiphead_id) AS shipment_number, 
       cust_number AS number, cohead_billtoname AS name,
       CASE WHEN (cohead_holdtype=''N'') THEN <? value("none") ?>
            WHEN (cohead_holdtype=''C'') THEN <? value("credit") ?>
            WHEN (cohead_holdtype=''S'') THEN <? value("ship") ?>
            WHEN (cohead_holdtype=''P'') THEN <? value("pack") ?>
            WHEN (cohead_holdtype=''R'') THEN <? value("return") ?>
            ELSE <? value("other") ?>
       END AS f_holdtype,
       pack_printed
FROM pack JOIN cohead ON (cohead_id=pack_head_id)
          JOIN custinfo ON (cust_id=cohead_cust_id)
          JOIN coitem ON (coitem_cohead_id=cohead_id)
          JOIN itemsite ON (itemsite_id=coitem_itemsite_id)
WHERE ( (pack_head_type=''SO'')
  AND   (checkSOSitePrivs(cohead_id))
<? if exists("warehous_id") ?>
  AND   (itemsite_warehous_id = <? value("warehous_id") ?>)
<? endif ?>
      )

<? if exists("MultiWhs") ?>
UNION ALL 
SELECT tohead_id, pack_shiphead_id, 
       tohead_number AS order_number, pack_head_type,
       tohead_shipvia AS shipvia,
       formatShipmentNumber(pack_shiphead_id) AS shipment_number, 
       tohead_destname AS number, tohead_destcntct_name AS name,
       '''' AS f_holdtype,
       pack_printed
FROM pack JOIN tohead ON (tohead_id=pack_head_id) 
WHERE ( (pack_head_type=''TO'') 
<? if exists("warehous_id") ?>
  AND   (tohead_src_warehous_id = <? value("warehous_id") ?>)
<? endif ?>
      )
<? endif ?>
ORDER BY 3;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (68, 'packingListBatch', 'print', 'used by packingListBatch Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: packingListBatch
-- Name: print
-- Notes: used by packingListBatch
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT DISTINCT
       pack_id, pack_head_id, pack_head_type, pack_shiphead_id,
       COALESCE(shipform_report_name, findCustomerForm(cohead_cust_id, ''P'')) AS packform,
       findCustomerForm(cohead_cust_id, ''L'') AS pickform 
FROM pack JOIN cohead ON (cohead_id=pack_head_id)
          JOIN coitem ON (coitem_cohead_id=cohead_id)
          JOIN itemsite ON (itemsite_id=coitem_itemsite_id)
          LEFT OUTER JOIN shipform ON (shipform_id=cohead_shipform_id)
WHERE ( (checkSOSitePrivs(cohead_id))
  AND   (pack_head_type=''SO'')
  AND   (NOT pack_printed) 
<? if exists("warehous_id") ?>
  AND   (itemsite_warehous_id = <? value("warehous_id") ?>)
<? endif ?>
      )

<? if exists("MultiWhs") ?>
UNION ALL
SELECT pack_id, pack_head_id, pack_head_type, pack_shiphead_id,
       COALESCE(shipform_report_name, findTOForm(tohead_id, ''P'')) AS packform,
       findTOForm(tohead_id, ''L'') AS pickform 
FROM pack JOIN tohead ON (tohead_id=pack_head_id)
          LEFT OUTER JOIN shipform ON (shipform_id=tohead_shipform_id)
WHERE ( (pack_head_type=''TO'')
  AND   (NOT pack_printed)
<? if exists("warehous_id") ?>
  AND   (tohead_src_warehous_id = <? value("warehous_id") ?>)
<? endif ?>
      )
<? endif ?>
;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (65, 'packingListBatchByShipVia', 'print', 'used by printPackingListBatchByShipVia Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: packingListBatchByShipVia
-- Name: print
-- Notes: used by printPackingListBatchByShipVia
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT DISTINCT pack_head_id, pack_head_type, pack_shiphead_id, getSoStatus(cohead_id) AS orderhead_status,
       COALESCE(shipform_report_name, findCustomerForm(cohead_cust_id, ''P'')) AS packform,
       findCustomerForm(cohead_cust_id, ''L'') AS pickform
FROM pack JOIN cohead ON (cohead_id=pack_head_id)
          JOIN coitem ON (coitem_cohead_id=cohead_id)
          JOIN itemsite ON (itemsite_id=coitem_itemsite_id)
          LEFT OUTER JOIN shipform ON (shipform_id=cohead_shipform_id)
WHERE ( (NOT pack_printed)
  AND   (pack_head_type=''SO'')
  AND   (getSoStatus(cohead_id) <> ''C'') 
<? if exists("shipvia") ?>
  AND   (cohead_shipvia=<? value("shipvia") ?>)
<? endif ?>
  AND   (checkSOSitePrivs(cohead_id))
  AND	(coitem_scheddate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? if exists("warehous_id") ?>
  AND   (itemsite_warehous_id = <? value("warehous_id") ?>)
<? endif ?>
      )

<? if exists("MultiWhs") ?>
UNION ALL
SELECT DISTINCT pack_head_id, pack_head_type, pack_shiphead_id, tohead_status AS orderhead_status,
       COALESCE(shipform_report_name, findTOForm(tohead_id, ''P'')) AS packform,
       findTOForm(tohead_id, ''L'') AS pickform
FROM pack JOIN tohead ON (tohead_id=pack_head_id)
          JOIN toitem ON (toitem_tohead_id = tohead_id) 
          LEFT OUTER JOIN shipform ON (shipform_id=tohead_shipform_id)
WHERE ( (NOT pack_printed)
  AND   (pack_head_type=''TO'')
  AND   (tohead_status <> ''C'') 
<? if exists("shipvia") ?>
  AND   (tohead_shipvia=<? value("shipvia") ?>)
<? endif ?>
  AND	(toitem_duedate BETWEEN <? value("startDate") ?> AND <? value("endDate") ?>)
<? if exists("warehous_id") ?>
  AND   (tohead_src_warehous_id = <? value("warehous_id") ?>)
<? endif ?>
      )
<? endif ?>

;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (261, 'itemsWithoutItemSources', 'detail', 'used by dspItemsWithoutItemSources Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: itemsWithoutItemSources
-- Name: detail
-- Notes: used by dspItemsWithoutItemSources
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT item_id, item_number,
       (item_descrip1 || '' '' || item_descrip2) AS descrip,
       CASE WHEN (item_type = ''P'') THEN <? value("purchased") ?>
            WHEN (item_type = ''O'') THEN <? value("outside") ?>
       END AS type 
FROM item 
WHERE ( (item_type IN (''P'', ''O''))
    AND (item_active)
    AND (item_id NOT IN (SELECT DISTINCT itemsrc_item_id
                         FROM itemsrc 
                         WHERE (itemsrc_active))) ) 
ORDER BY item_number;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (263, 'mrpDetail', 'item', 'used by dspMRPDetail Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: mrpDetail
-- Name: item
-- Notes: used by dspMRPDetail
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT itemsite_id, item_type, item_number,
       (item_descrip1 || '' '' || item_descrip2) AS descrip,
       warehous_code
FROM itemsite, item, whsinfo
WHERE ( (itemsite_active)
    AND (itemsite_item_id=item_id)
    AND (itemsite_warehous_id=warehous_id)
    AND (itemsite_planning_type=''M'')
<? if exists("plancode_id") ?>
    AND (itemsite_plancode_id=<? value("plancode_id") ?>)
<? elseif exists("plancode_pattern") ?>
    AND (itemsite_plancode_id IN (SELECT plancode_id 
                                  FROM plancode 
                                  WHERE (plancode_code ~ <? value("plancode_pattern") ?>)))
<? endif ?>
<? if exists("warehous_id") ?>
    AND (warehous_id=<? value("warehous_id") ?>)
<? endif ?>
      )
ORDER BY item_number, warehous_code;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (264, 'openpurchaseorders', 'detail', ' Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: openpurchaseorders
-- Name:  detail
-- Notes: 
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT DISTINCT
       pohead_id AS id, COALESCE(pohead_cohead_id, -1) AS altid,
       pohead.*,
       calcPurchaseOrderDueDate(pohead_id) AS min_duedate,
       calcPurchaseOrderAmt(pohead_id) AS order_total,
       vend_name, vend_number, vendtype_code,
<? foreach("char_id_text_list") ?>
       charass_alias<? literal("char_id_text_list") ?>.charass_value AS char<? literal("char_id_text_list") ?>,
<? endforeach ?>
<? foreach("char_id_list_list") ?>
       charass_alias<? literal("char_id_list_list") ?>.charass_value AS char<? literal("char_id_list_list") ?>,
<? endforeach ?>
<? foreach("char_id_date_list") ?>
       charass_alias<? literal("char_id_date_list") ?>.charass_value::date AS char<? literal("char_id_date_list") ?>,
<? endforeach ?>
       CASE WHEN(pohead_status=''C'') THEN <? value("closed") ?>
            WHEN(pohead_status=''U'') THEN <? value("unposted") ?>
            WHEN(pohead_status=''O'') THEN <? value("open") ?>
            ELSE pohead_status
       END AS pohead_status_qtdisplayrole,
       ''currency'' AS order_total_xtnumericrole
FROM pohead 
     JOIN vendinfo ON (pohead_vend_id=vend_id)
     JOIN vendtype ON (vend_vendtype_id=vendtype_id)
<? if exists("pohead_agent_usr_id") ?>
     JOIN usr ON (pohead_agent_username=usr_username)
<? endif ?> 
<? if exists("warehous_id") ?>
     JOIN poitem ON (poitem_pohead_id=pohead_id) 
     JOIN itemsite ON (poitem_itemsite_id=itemsite_id)
<? endif ?> 
<? foreach("char_id_text_list") ?>
     LEFT OUTER JOIN charass charass_alias<? literal("char_id_text_list") ?> 
          ON ((charass_alias<? literal("char_id_text_list") ?>.charass_target_type=''PO'') 
         AND  (charass_alias<? literal("char_id_text_list") ?>.charass_target_id=pohead_id)
         AND  (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=<? value("char_id_text_list") ?>))
     LEFT OUTER JOIN char char_alias<? literal("char_id_text_list") ?> 
          ON (charass_alias<? literal("char_id_text_list") ?>.charass_char_id=char_alias<? literal("char_id_text_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_list_list") ?>
     LEFT OUTER JOIN charass charass_alias<? literal("char_id_list_list") ?> 
          ON ((charass_alias<? literal("char_id_list_list") ?>.charass_target_type=''PO'') 
         AND  (charass_alias<? literal("char_id_list_list") ?>.charass_target_id=pohead_id)
         AND  (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=<? value("char_id_list_list") ?>))
     LEFT OUTER JOIN char char_alias<? literal("char_id_list_list") ?> 
          ON (charass_alias<? literal("char_id_list_list") ?>.charass_char_id=char_alias<? literal("char_id_list_list") ?>.char_id)
<? endforeach ?>
<? foreach("char_id_date_list") ?>
     LEFT OUTER JOIN charass charass_alias<? literal("char_id_date_list") ?> 
          ON ((charass_alias<? literal("char_id_date_list") ?>.charass_target_type=''PO'') 
         AND  (charass_alias<? literal("char_id_date_list") ?>.charass_target_id=pohead_id)
         AND  (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=<? value("char_id_date_list") ?>))
     LEFT OUTER JOIN char char_alias<? literal("char_id_date_list") ?> 
          ON (charass_alias<? literal("char_id_date_list") ?>.charass_char_id=char_alias<? literal("char_id_date_list") ?>.char_id)
<? endforeach ?>
WHERE ( true
<? if exists("search_pattern") ?> 
  AND ((pohead_number::text ~* <? value("search_pattern") ?>) 
    OR (vend_number ~* <? value("search_pattern") ?>)
    OR (vend_name ~* <? value("search_pattern") ?>)
    OR (pohead_agent_username ~* <? value("search_pattern") ?>)
    OR (vendtype_code ~* <? value("search_pattern") ?>)
    OR (COALESCE(pohead_vend_cntct_first_name,'''') || '' '' || COALESCE(pohead_vend_cntct_last_name,'''') ~* <? value("search_pattern") ?>)
    OR (COALESCE(pohead_vend_cntct_phone,'''') ||'' '' || COALESCE(pohead_vend_cntct_fax,'''') ~* <? value("search_pattern") ?>)
    OR (COALESCE(pohead_vend_cntct_email,'''') ~* <? value("search_pattern") ?>)
    OR (COALESCE(pohead_vendaddress1,'''') || '' '' || COALESCE(pohead_vendaddress2,'''') || '' '' || COALESCE(pohead_vendaddress3,'''') ~* <? value("search_pattern") ?>)
    OR (COALESCE(pohead_vendcity,'''') ~* <? value("search_pattern") ?>)
    OR (COALESCE(pohead_vendstate,'''') ~* <? value("search_pattern") ?>)
    OR (COALESCE(pohead_vendzipcode,'''') ~* <? value("search_pattern") ?>)
    OR (COALESCE(pohead_vendcountry,'''') ~* <? value("search_pattern") ?>)
    OR (COALESCE(pohead_shipto_cntct_first_name,'''') || '' '' || COALESCE(pohead_shipto_cntct_last_name,'''') ~* <? value("search_pattern") ?>)
    OR (COALESCE(pohead_shipto_cntct_phone,'''') || '' '' || COALESCE(pohead_shipto_cntct_fax,'''') ~* <? value("search_pattern") ?>)
    OR (COALESCE(pohead_shipto_cntct_email,'''') ~* <? value("search_pattern") ?>)
    OR (COALESCE(pohead_shiptoaddress1,'''') || '' '' || COALESCE(pohead_vendaddress2,'''') || '' '' || COALESCE(pohead_vendaddress3,'''') ~* <? value("search_pattern") ?>)
    OR (COALESCE(pohead_shiptocity,'''') ~* <? value("search_pattern") ?>)
    OR (COALESCE(pohead_shiptostate,'''') ~* <? value("search_pattern") ?>)
    OR (COALESCE(pohead_shiptozipcode,'''') ~* <? value("search_pattern") ?>)
    OR (COALESCE(pohead_shiptocountry,'''') ~* <? value("search_pattern") ?>)
    )
<? endif ?> 
<? if exists("showUnreleased") ?> 
  AND (pohead_status =''U'') 
<? endif ?> 
<? if exists("showOpen") ?>
  AND (pohead_status=''O'' )
<? endif ?> 
<? if exists("showBoth") ?> 
  AND (pohead_status IN (''U'', ''O'') ) 
<? endif ?> 
<? if exists("shownothing") ?> 
  AND (pohead_status NOT IN (''U'', ''O'', ''C'')) 
<? endif ?> 
<? if exists("vend_id") ?>
  AND (vend_id=<? value("vend_id") ?>)
<? endif ?> 
<? if exists("vendtype_id") ?>
  AND (vend_vendtype_id=<? value("vendtype_id") ?>)
<? endif ?> 
<? if exists("vendtype_pattern") ?>
  AND (vendtype_code ~* <? value("vendtype_pattern") ?>)
<? endif ?> 
<? if exists("pohead_agent_usr_id") ?>
  AND (usr_id  = <? value("pohead_agent_usr_id") ?>)
<? endif ?> 
<? if exists("warehous_id") ?>
  AND (itemsite_warehous_id = <? value("warehous_id") ?>)
<? endif ?> 
<? literal("charClause") ?>
 ) 
ORDER BY pohead_number;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (458, 'packingList', 'getreport', 'get the reportname should be used for a packing list or pick list Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: packingList
-- Name:  getreport
-- Notes: get the reportname should be used for a packing list or pick list
--        Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
--        See www.xtuple.com/CPAL for the full text of the software license.

<? if exists(''sohead_id'') ?>
SELECT findCustomerForm(cohead_cust_id,
                       <? value(''form'') ?>) AS reportname
  FROM cohead 
 WHERE (cohead_id=<? value(''sohead_id'' ?>);
<? elseif exists(''tohead_id'') ?>
SELECT findTOForm(<? value(''tohead_id'') ?>,
                  <? value(''form'') ?>) AS reportname;
<? endif ?>
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (66, 'packingListBatchByShipVia', 'shipVia', 'used by printPackingListBatchByShipVia Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: packingListBatchByShipVia
-- Name: shipVia
-- Notes: used by printPackingListBatchByShipVia
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.


SELECT max(id), shipvia
FROM (
SELECT max(cohead_id) AS id, cohead_shipvia AS shipvia
FROM pack JOIN cohead ON (cohead_id=pack_head_id)
          JOIN coitem ON (coitem_cohead_id=cohead_id AND coitem_status=''O'')
          JOIN itemsite ON (itemsite_id=coitem_itemsite_id)
WHERE ( (NOT pack_printed)
  AND   (pack_head_type=''SO'')
<? if exists("warehous_id") ?>
  AND   (itemsite_warehous_id = <? value("warehous_id") ?>)
<? endif ?>
      )
GROUP BY cohead_shipvia
<? if exists("MultiWhs") ?>
UNION
SELECT max(tohead_id) AS id, tohead_shipvia AS shipvia
FROM pack JOIN tohead ON (tohead_id=pack_head_id AND tohead_status=''O'')
WHERE ( (NOT pack_printed)
  AND   (pack_head_type=''TO'')
<? if exists("warehous_id") ?>
  AND   (tohead_src_warehous_id = <? value("warehous_id") ?>)
<? endif ?>
      )
GROUP BY tohead_shipvia
<? endif ?>
) data
GROUP BY shipvia
ORDER BY shipvia
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (267, 'partiallyShippedOrders', 'detail', 'used by dspPartiallyShippedOrders Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: partiallyShippedOrders
-- Name: detail
-- Notes: used by dspPartiallyShippedOrders
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

SELECT CASE WHEN (cohead_holdtype IN (''P'', ''C'', ''R'')) THEN -1
         ELSE cohead_id
       END AS _coheadid, cohead_id,
       cohead_holdtype, cohead_number, cust_name,
       CASE WHEN (cohead_holdtype=''N'') THEN <? value("none") ?>
            WHEN (cohead_holdtype=''C'') THEN <? value("credit") ?>
            WHEN (cohead_holdtype=''S'') THEN <? value("ship") ?>
            WHEN (cohead_holdtype=''P'') THEN <? value("pack") ?>
            WHEN (cohead_holdtype=''R'') THEN <? value("return") ?>
         ELSE <? value("other") ?>
       END AS f_holdtype,
       cohead_orderdate,
       (MIN(coitem_scheddate)) AS minscheddate,
       cohead_packdate,
       SUM( (noNeg(coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned) * coitem_qty_invuomratio) *
                  (coitem_price / coitem_price_invuomratio) ) AS extprice,
       currConcat(cohead_curr_id) AS currAbbr,
       SUM(currToBase(cohead_curr_id,
          (noNeg(coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned) * coitem_qty_invuomratio) *
          (coitem_price / coitem_price_invuomratio),
          CURRENT_DATE)) AS extprice_base,
       ''curr'' AS extprice_xtnumericrole,
       ''curr'' AS extprice_base_xtnumericrole,
       <? if exists("singlecurrency") ?>
         0 AS extprice_xttotalrole 
       <? else ?>
         0 AS extprice_base_xttotalrole 
       <? endif ?>
FROM cohead, itemsite, item, custinfo, coitem
WHERE ( (coitem_cohead_id=cohead_id)
    AND (cohead_cust_id=cust_id)
    AND (coitem_itemsite_id=itemsite_id)
    AND (itemsite_item_id=item_id)
    AND (coitem_status=''O'')
    AND (cohead_id IN ( SELECT DISTINCT coitem_cohead_id
                        FROM coitem
                        WHERE (coitem_qtyshipped > 0) ))
    AND (coitem_qtyshipped < coitem_qtyord)
    AND (coitem_scheddate BETWEEN <? value("startDate") ?>
                              AND <? value("endDate") ?>)
    <? if exists("warehous_id") ?>
      AND (itemsite_warehous_id=<? value("warehous_id") ?>)
    <? endif ?>
      ) 
GROUP BY cohead_id, cohead_number, cust_name,
         cohead_holdtype, cohead_orderdate, cohead_packdate,
         cohead_curr_id 
ORDER BY minscheddate, cohead_number;
', 'admin', '2014-03-20', 0);
INSERT INTO metasql (metasql_id, metasql_group, metasql_name, metasql_notes, metasql_query, metasql_lastuser, metasql_lastupdate, metasql_grade) VALUES (268, 'pendingAvailability', 'detail', 'used by dspPendingAvailability Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple. See www.xtuple.com/CPAL for the full text of the software license.', '-- Group: pendingAvailability
-- Name: detail
-- Notes: used by dspPendingAvailability
-- Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.

<? if exists("showIndented") ?>

-- Indented BOM
SELECT itemsite_id, reorderlevel,
       bomdata_bomwork_level,
       bomdata_bomwork_id,
       bomdata_bomwork_parent_id,
       bomdata_bomwork_seqnumber AS bomitem_seqnumber,
       bomdata_item_number AS item_number,
       bomdata_itemdescription AS item_descrip,
       bomdata_uom_name AS uom_name,
       pendalloc,
       ordered,
       qoh,
       (totalalloc + pendalloc) AS totalalloc,
       (qoh + ordered - (totalalloc + pendalloc)) AS totalavail,
       ''qty'' AS pendalloc_xtnumericrole,
       ''qty'' AS ordered_xtnumericrole,
       ''qty'' AS qoh_xtnumericrole,
       ''qty'' AS totalalloc_xtnumericrole,
       ''qty'' AS totalavail_xtnumericrole,
       CASE WHEN (qoh < pendalloc) THEN ''error'' END AS qoh_qtforegroundrole,
       CASE WHEN ((qoh + ordered - (totalalloc + pendalloc)) < reorderlevel)  THEN ''error''
            WHEN ((qoh + ordered - (totalalloc + pendalloc)) = reorderlevel) THEN ''warning''
       END AS totalavail_qtforegroundrole,
       bomdata_bomwork_level - 1 AS xtindentrole
  FROM ( SELECT itemsite_id,
                CASE WHEN(itemsite_useparams)
                     THEN itemsite_reorderlevel
                     ELSE 0.0
                     END AS reorderlevel,
                ib.*,
                ((bomdata_qtyreq::NUMERIC * <? value("buildQty") ?>) * (1 + bomdata_scrap::NUMERIC)) AS pendalloc,
                qtyAllocated(itemsite_id, DATE(<? value("buildDate") ?>)) AS totalalloc,
                noNeg(itemsite_qtyonhand) AS qoh,
                qtyOrdered(itemsite_id, DATE(<? value("buildDate