/*jshint node:true, indent:2, curly:false, eqeqeq:true, immed:true,
latedef:true, newcap:true, noarg:true, regexp:true, undef:true,
strict:true, trailing:true, white:true */
/*global XT:true */

// Place strings you want to localize here.  In your app, use the key and
// localize it using "key string".loc().  HINT: For your key names, use the
// english string with an underscore in front.  This way you can still see
// how your UI will look and you'll notice right away when something needs a
// localized string added to this file!

(function () {
  "use strict";

  var lang = XT.stringsFor("en_US", {
    "_xtdb_attachQuoteToOpportunity1": "The selected Quote cannot be attached because the Quote cannot be found.",
    "_xtdb_attachQuoteToOpportunity2": "The selected Quote cannot be attached because the Opportunity cannot be found.",
    "_xtdb_attachQuoteToOpportunity3": "The selected Quote cannot be attached because it is already associated with an Opportunity. You must detach this Quote before you may attach it.",
    "_xtdb_attachSalesOrderToOpportunity1": "The selected Sales Order cannot be attached because the Sales Order cannot be found.",
    "_xtdb_attachSalesOrderToOpportunity2": "The selected Sales Order cannot be attached because the Opportunity cannot be found.",
    "_xtdb_attachSalesOrderToOpportunity3": "The selected Sales Order cannot be attached because it is already associated with an Opportunity. You must detach this Sales Order before you may attach it.",
    "_xtdb_changeCMHeadTaxAuth1": "This Credit Memo was not found.",
    "_xtdb_changeCMHeadTaxAuth2": "This Tax Authority was not found.",
    "_xtdb_changeInvoiceTaxZone1": "This Invoice was not found.",
    "_xtdb_changeInvoiceTaxZone2": "Freight Tax Type was not found.",
    "_xtdb_changeCobTaxZone1": "This Bill was not found.",
    "_xtdb_changeCobTaxZone2": "Freight Tax Type was not found.",
    "_xtdb_changeQuoteTaxZone1": "This Quote was not found.",
    "_xtdb_changeSOTaxZone1": "This Sales Order was not found.",
    "_xtdb_changeTOTax1": "This Transfer Order was not found.",
    "_xtdb_changeTOTaxAuth2": "This Tax Authority was not found.",
    "_xtdb_closeAccountingPeriod1": "The selected Accounting Period cannot be closed because it is already closed.",
    "_xtdb_closeAccountingPeriod2": "The selected Accounting Period cannot be closed because there is a gap between the end of the previous Period and the start of this Period. You must edit either the previous Perod or this Period to eliminate the gap.",
    "_xtdb_closeAccountingPeriod3": "The selected Accounting Period cannot be closed because the previous Period is not closed. You must close the previous Period before you may close this Period.",
    "_xtdb_closeAccountingPeriod4": "The selected Accounting Period cannot be closed because there is a gap between the end of this Period and the start of the next Period. You must edit either this Period or the next Period to eliminate the gap.",
    "_xtdb_closeAccountingPeriod5": "The selected Accounting Period cannot be closed because it ends in the future.",
    "_xtdb_closeAccountingPeriod6": "The selected Accounting Period cannot be closed because it is the last period in the Fiscal Year and the next Fiscal Year has not been defined yet. Create the next Fiscal Year before closing this Accounting Period.",
    "_xtdb_closeAccountingYearPeriod7": "The selected Fiscal Year cannot be closed because you have not specified a Year End Equity Account in the accounting configuration.",
    "_xtdb_closeAccountingYearPeriod8": "The selected Fiscal Year cannot be closed because there does not seem to be an Accounting Period defined for the beginning of the next Fiscal Year.",
    "_xtdb_closeAccountingYearPeriod9": "The selected Fiscal Year cannot be closed because there is no Trial Balance record for the account in the required Period. Or you have not specified a Year End Equity Account in the accounting configuration.",
    "_xtdb_closeAccountingYearPeriod10": "The selected Fiscal Year cannot be closed because there are periods within the year that are still open.",
    "_xtdb_closeAccountingYearPeriod11": "The selected Fiscal Year cannot be closed because there are prior years that are still open.",
    "_xtdb_closeToItem1": "The item cannot be Closed at this time as there is inventory at shipping.",
    "_xtdb_convertCustomerToProspect10": "Could not convert Customer to Prospect to because there is already a Prospect with this internal ID.",
    "_xtdb_convertProspectToCustomer10": "Could not convert Prospect to Customer because there is already a Customer with this internal ID.",
    "_xtdb_convertQuote1": "Quote #%1 has one or more line items without a warehouse specified. These line items must be fixed before you may convert this quote.",
    "_xtdb_convertQuote2": "Cannot find the Customer data for Quote #%1.",
    "_xtdb_convertQuote3": "Quote #%1 is associated with a Prospect, not a Customer. Convert the Prospect to a Customer first.",
    "_xtdb_convertQuote4": "Quote #%1 is for a Customer that has been placed on a Credit Hold and you do not have privilege to create Sales Orders for Customers on Credit Hold. The selected Customer must be taken off of Credit Hold before you may create convert this Quote.",
    "_xtdb_convertQuote5": "Quote #%1 is for a Customer that has been placed on a Credit Warning and you do not have privilege to create Sales Orders for Customers on Credit Warning. The selected Customer must be taken off of Credit Warning before you may create convert this Quote.",
    "_xtdb_convertQuote6": "Quote #%1 has expired and can not be converted.",
    "_xtdb_convertQuote7": "Quote #%1 has references a PO number that has already been used.",
    "_xtdb_copyItemSite1": "Could not copy the Item Site because it does not appear to exist.",
    "_xtdb_copyItemSite2": "Could not copy the Item Site because the warehouse for the new Item Site record does not appear to exist.",
    "_xtdb_copyItemSite3": "You do not have sufficient privilege to create an Item Site.",
    "_xtdb_copyBOM1": "Could not find the Source BOM to copy.",
    "_xtdb_copyBOM2": "The selected source Item does not have any Bill of Material Component Items associated with it.",
    "_xtdb_copyBOM3": "The selected target Item already has a Bill of Materials associated with it. You must first delete the Bill of Materials for the selected target item before attempting to copy an existing Bill of Materials.",
    "_xtdb_copyBOM4": "The Item you are trying to copy this Bill of Material to is a component item which would cause a recursive Bill of Material.",
    "_xtdb_copyPO1": "Could not find the P/O to copy.",
    "_xtdb_copyPO2": "The Vendor of the original P/O does not match the Vendor for the copy. Changing the Vendor is not yet supported when copying a P/O.",
    "_xtdb_copyPO3": "The system does not allow purchases of Items for this Vendor without Item Sources and at least one line item item in the original P/O does not have an active Item Source.",
    "_xtdb_copyPO4": "At least one line item in the original P/O does not have an active Item Source Price for this Vendor.",
    "_xtdb_copyPrj1": "Copying an existing project failed, possibly because the source project does not exist.",
    "_xtdb_correctOperationPosting1": "You may not correct a quantity greater than the amount originally posted.",
    "_xtdb_correctReceipt12": "The receipt has been split and may not be corrected. Correct Receipt.",
    "_xtdb_createAccountingPeriod1": "The Start Date falls within another Accounting Period.",
    "_xtdb_createAccountingPeriod2": "The End Date falls within another Accounting Period.",
    "_xtdb_createAccountingPeriod3": "The Start and End Dates enclose another Accounting Period.",
    "_xtdb_createAccountingPeriod4": "The Period dates are outside the selected Fiscal Year.",
    "_xtdb_createAccountingPeriod5": "The Start Date must be prior to the End Date.",
    "_xtdb_createAccountingYearPeriod1": "The Year is closed.",
    "_xtdb_createAccountingYearPeriod2": "Year dates may not overlap another year.",
    "_xtdb_createAccountingYearPeriod3": "Year dates may not overlap another year.",
    "_xtdb_createAccountingYearPeriod4": "Periods exist for this year outside the proposed dates.",
    "_xtdb_createAccountingYearPeriod5": "The Start Date must be prior to the End Date",
    "_xtdb_createAPCreditMemoApplication1": "You may not apply more than the balance due to this document.",
    "_xtdb_createAPCreditMemoApplication2": "You may not apply more than the amount available to apply for this Credit Memo.",
    "_xtdb_createARCreditMemo1": "Either the Prepaid Account or the A/R Account  for this Customer could not be found.",
    "_xtdb_createBOMItem1": "You may not create a BOM Item that defines a Parent that is composed of itself.",
    "_xtdb_createBOMItem2": "The Component that you have selected for this BOM Item is a manufactured or phantom Item that uses the Parent Item as a Component Item in its own BOM. You may not create a recursive BOM.",
    "_xtdb_createCrmAcct1": "This CRM Account Number is already in use by an existing CRM Account. Please choose a different number and save again.",
    "_xtdb_createCrmAcct2": "This CRM Account Number is already in use by an existing Customer. Please choose a different number and save again.",
    "_xtdb_createCrmAcct5": "This CRM Account Number is already in use by an existing Prospect. Please choose a different number and save again.",
    "_xtdb_createCrmAcct6": "This CRM Account Number is already in use by an existing Vendor. Please choose a different number and save again.",
    "_xtdb_createCrmAcct7": "This CRM Account Number is already in use by an existing Tax Authority. Please choose a different number and save again.",
    "_xtdb_createProspect1": "Cannot create a Prospect because there is no CRM Account to tie it to.",
    "_xtdb_createProspect2": "Cannot create a Prospect for this CRM Account because it is already a Customer.",
    "_xtdb_createProspect3": "Cannot create a Prospect for this CRM Account because it is already a Prospect.",
    "_xtdb_createPurchaseToSale1": "SO Header Information related to this SO Item not found!",
    "_xtdb_createPurchaseToSale2": "Item Source Information not found!",
    "_xtdb_createRecurringItems10": "Cannot create recurring items with an unrecognized object type.",
    "_xtdb_CreateRevision2": "Revision control not enabled.",
    "_xtdb_createTodoItem1": "The To-Do List Item cannot be created as there is no assigned User.",
    "_xtdb_createTodoItem2": "The To-Do List Item cannot be created as the Task Name is blank.",
    "_xtdb_createTodoItem3": "The To-Do List Item cannot be created as there is no Due Date.",
    "_xtdb_createWo1": "Work Order can not be created because Site not allowed to Manufacture this Item.",
    "_xtdb_createWo2": "Work Order can not be exploded because items on the BOM exist without itemsites.",
    "_xtdb_deleteAccount1": "The selected G/L Account cannot be deleted as it is currently used in one or more Cost Categories. You must reassign these Cost Category assignments before you may delete the selected G/L Account.",
    "_xtdb_deleteAccount2": "The selected G/L Account cannot be deleted as it is currently used in one or more Sales Account Assignment. You must reassign these Sales Account Assignments before you may delete the selected G/L Account.",
    "_xtdb_deleteAccount3": "The selected G/L Account cannot be deleted as it is currently used in one or more Customer A/R Account assignments. You must reassign these Customer A/R Account assignments before you may delete the selected G/L Account.",
    "_xtdb_deleteAccount4": "The selected G/L Account cannot be deleted as it is currently used as the default Account one or more Sites. You must reassign the default Account for these Sites before you may delete the selected G/L Account.",
    "_xtdb_deleteAccount5": "The selected G/L Account cannot be deleted as it is currently used in one or more Bank Accounts. You must reassign these Bank Accounts before you may delete the selected G/L Account.",
    "_xtdb_deleteAccount6": "The selected G/L Account cannot be deleted as it is currently used in one or more Expense Categories. You must reassign these Expense Categories before you may delete the selected G/L Account.",
    "_xtdb_deleteAccount7": "The selected G/L Account cannot be deleted as it is currently used in one or more Tax Codes. You must reassign these Tax Codes before you may delete the selected G/L Account.",
    "_xtdb_deleteAccount8": "The selected G/L Account cannot be deleted as it is currently used in one or more Standard Journals. You must reassign these Standard Journal Items before you may delete the selected G/L Account.",
    "_xtdb_deleteAccount9": "The selected G/L Account cannot be deleted as it is currently used in one or more Customer A/P Account assignments. You must reassign these Customer A/P Account assignments before you may delete the selected G/L Account.",
    "_xtdb_deleteAccount10": "The selected G/L Account cannot be deleted as it is currently used in one or more Currency definition. You must reassign these Currency definitions before you may delete the selected G/L Account.",
    "_xtdb_deleteAccount11": "The selected G/L Account cannot be deleted as it is currently used in one or more A/R Open Items. You must reassign these Currency definitions before you may delete the selected G/L Account.",
    "_xtdb_deleteAccount99": "The selected G/L Account cannot be deleted as there have been G/L Transactions posted against it.",
    "_xtdb_deleteAccountingPeriod4": "The selected Accounting Period has G/L Transactions posted against it and, thus, cannot be deleted.",
    "_xtdb_deleteAccountingPeriod5": "The selected Accounting Period is not the last accounting period and cannot be deleted.",
    "_xtdb_deleteAccountingYearPeriod1": "The selected Fiscal Year cannot be deleted because it is closed.",
    "_xtdb_deleteAccountingYearPeriod2": "The selected Fiscal Year cannot be deleted because there are Accounting Periods defined for it.",
    "_xtdb_deleteAddress1": "The selected Address cannot be deleted as it is used by an active Contact.",
    "_xtdb_deleteAddress2": "The selected Address cannot be deleted as it is used by an active Vendor.",
    "_xtdb_deleteAddress3": "The selected Address cannot be deleted as it is used by an active Ship-To Address.",
    "_xtdb_deleteAddress4": "The selected Address cannot be deleted as it is used by an active Vendor Address.",
    "_xtdb_deleteAddress5": "The selected Address cannot be deleted as it is used by an active Site.",
    "_xtdb_deleteBankAdjustmentType1": "The selected Bank Adjustment Type cannot be deleted because it is currently used by a Bank Adjustment.",
    "_xtdb_deleteCashrcpt1": "The selected Cash Receipt cannot be deleted because it is a Customer Deposit made with a Credit Card and the card has already been charged.",
    "_xtdb_deleteCharacteristic1": "The selected Characteristic cannot be deleted because there are Items assigned to it. You must remove these assignments before you may delete the selected Characteristic.",
    "_xtdb_deleteCharacteristic2": "The selected Characteristic cannot be deleted because there are Customers assigned to it. You must remove these assignments before you may delete the selected Characteristic.",
    "_xtdb_deleteCharacteristic3": "The selected Characteristic cannot be deleted because there are Addresses assigned to it. You must remove these assignments before you may delete the selected Characteristic.",
    "_xtdb_deleteCharacteristic4": "The selected Characteristic cannot be deleted because there are Contacts assigned to it. You must remove these assignments before you may delete the selected Characteristic.",
    "_xtdb_deleteCharacteristic5": "The selected Characteristic cannot be deleted because there are CRM Accounts assigned to it. You must remove these assignments before you may delete the selected Characteristic.",
    "_xtdb_deleteCharacteristic6": "The selected Characteristic cannot be deleted because there are Incidents assigned to it. You must remove these assignments before you may delete the selected Characteristic.",
    "_xtdb_deleteCharacteristic7": "The selected Characteristic cannot be deleted because there are Employees assigned to it. You must remove these assignments before you may delete the selected Characteristic.",
    "_xtdb_deleteCheck1": "Cannot delete this check because either it has not been voided, it has already been posted or replaced, or it has been transmitted electronically.",
    "_xtdb_deleteClassCode1": "The selected Class Code cannot be deleted because there are Items that are assigned to it. You must reassign these Items before you may delete the selected Class Code.",
    "_xtdb_deleteCompany1": "The selected Company cannot be deleted as it is in use by existing Account. You must reclass these Accounts before you may delete the selected Company.",
    "_xtdb_deleteContact1": "The selected Contact cannot be deleted as s/he is the primary or secondary Contact for a CRM Account.",
    "_xtdb_deleteContact2": "The selected Contact cannot be deleted as s/he is the Correspondence or Billing Contact for a Customer.",
    "_xtdb_deleteContact3": "The selected Contact cannot be deleted as s/he is the primary or secondary Contact for a Vendor.",
    "_xtdb_deleteContact4": "The selected Contact cannot be deleted as s/he is the Contact for a Ship-To Address.",
    "_xtdb_deleteContact5": "The selected Contact cannot be deleted as s/he is the Contact for a Vendor Address.",
    "_xtdb_deleteContact6": "The selected Contact cannot be deleted as s/he is the Contact for a Site.",
    "_xtdb_deleteCRMAccount1": "The selected CRM Account cannot be deleted as it is a Customer.",
    "_xtdb_deleteCRMAccount2": "The selected CRM Account cannot be deleted as it is a Vendor.",
    "_xtdb_deleteCRMAccount3": "The selected CRM Account cannot be deleted as it is a Prospect.",
    "_xtdb_deleteCRMAccount4": "The selected CRM Account cannot be deleted as it has Contacts. You may Detach the Contacts from this CRM Account and try deleting it again or set its status to inactive",
    "_xtdb_deleteCRMAccount5": "The selected CRM Account cannot be deleted as it is a Tax Authority.",
    "_xtdb_deleteCRMAccount6": "The selected CRM Account cannot be deleted as it is a Sales Rep.",
    "_xtdb_deleteCRMAccount7": "The selected CRM Account cannot be deleted as it is a Employee.",
    "_xtdb_deleteCRMAccount8": "The selected CRM Account cannot be deleted as it is a User.",
    "_xtdb_deleteCustomer1": "The selected Customer cannot be deleted as there are still Ship-Tos assigned to it. You must delete all of the selected Customer's Ship-Tos before you may delete it.",
    "_xtdb_deleteCustomer2": "The selected Customer cannot be deleted as there has been Sales History recorded for this Customer. You may Edit the selected Customer and set its status to inactive.",
    "_xtdb_deleteCustomer3": "Credit Memos",
    "_xtdb_deleteCustomer4": "custhist",
    "_xtdb_deleteCustomer5": "A/R Open",
    "_xtdb_deleteCustomer6": "The selected Customer cannot be deleted as Checks have been written to it.",
    "_xtdb_deleteCustomer7": "The selected Customer cannot be deleted as there are still Invoices assigned to it. You must delete all of the selected Customer's Invoices before you may delete it",
    "_xtdb_deleteCustomer8": "The selected Customer cannot be deleted as there are still Quotes assigned to it. You must delete all of the selected Customer's Quotes before you may delete it",
    "_xtdb_deleteCustomerType1": "The selected Customer Type cannot be deleted as there are one or more Customers assigned to it. You must reassign these Customers before you may delete the selected Customer Type.",
    "_xtdb_deleteEmpgrp1": "The selected Employee Group cannot be deleted as there are one or more Employees assigned to it. You must reassign these Employees before you may delete the selected Employee Group.",
    "_xtdb_deleteForm1": "The selected Check Format cannot be deleted as it is used by one or more Bank Accounts. You must reassign these Bank Accounts before you may delete the selected Check Form.",
    "_xtdb_deleteFreightClass1": "The selected Freight Class cannot be deleted because there are Items that are assigned to it. You must reassign these Items before you may delete the selected Freight Class.",
    "_xtdb_deleteIncident1": "This Incident cannot be deleted as there are To-Do List Items associated with it.",
    "_xtdb_deleteIncident2": "This Incident cannot be deleted as there are Comments associated with it.",
    "_xtdb_deleteItem1": "This Item cannot be deleted as it is used in one or more bills of materials.",
    "_xtdb_deleteItem2": "This Item cannot be deleted as there are Item Site records associated with it.",
    "_xtdb_deleteItem3": "This Item cannot be deleted as there are Substitute records associated with it.",
    "_xtdb_deleteItem4": "This Item cannot be deleted as there are Breeder BOM records associated with it.",
    "_xtdb_deleteItem5": "This Item cannot be deleted as there are assignement records associated with it.",
    "_xtdb_deleteItem6": "This Item cannot be deleted as there are Revision Control records associated with it.",
    "_xtdb_deleteItemSite1": "The selected Item Site cannot be deleted as there is Inventory History posted against it. You may edit the Item Site and deactivate it.",
    "_xtdb_deleteItemSite2": "The selected Item Site cannot be deleted as there is Work Order History posted against it. You may edit the Item Site and deactivate it.",
    "_xtdb_deleteItemSite3": "The selected Item Site cannot be deleted as there is Sales History posted against it. You may edit the Item Site and deactivate it.",
    "_xtdb_deleteItemSite4": "The selected Item Site cannot be deleted as there is Purchasing History posted against it. You may edit the Item Site and deactivate it.",
    "_xtdb_deleteItemSite5": "The selected Item Site cannot be deleted as there is Planning History posted against it. You may edit the Item Site and deactivate it.",
    "_xtdb_deleteItemSite6": "The selected Item Site cannot be deleted as there are Production Plans associated with it.",
    "_xtdb_deleteItemSite7": "The selected Item Site cannot be deleted as it is used as a Supplied from Site.",
    "_xtdb_deleteItemSite9": "The selected Item Site cannot be deleted as there is a non-zero Inventory Quantity posted against it.",
    "_xtdb_deleteItemUOMConv1": "This UOM Conversion cannot be deleted as there are records for this Item which use this UOM.",
    "_xtdb_deleteOpenRecurringItems10": "Cannot delete open recurring items with an invalid type.",
    "_xtdb_deleteOpenRecurringItems11": "Cannot delete open recurring items without a valid parent item.",
    "_xtdb_deleteOpportunity1": "The selected Opportunity cannot be deleted because there are ToDo Items assigned to it. You must delete or reassign these ToDo Items before you may delete it.",
    "_xtdb_deleteOpportunity2": "The selected Opportunity cannot be deleted because there are Quotes assigned to it. You must delete or reassign these Quotes before you may delete it.",
    "_xtdb_deleteOpportunity3": "The selected Opportunity cannot be deleted because there are Sales Orders assigned to it. You must delete or reassign these Sales Orders before you may delete it.",
    "_xtdb_deletePackage1": "The selected Package cannot be deleted because there are other packages that depend on it to function properly.",
    "_xtdb_deleteProfitCenter1": "The selected Profit Center cannot be deleted as it is in use by existing Account. You must reclass these Accounts before you may delete the selected Profit Center.",
    "_xtdb_deleteProspect1": "The selected Prospect cannot be deleted as there are still Quotes for it. You must delete all of this Prospect's Quotes before you may delete the Prospect.",
    "_xtdb_deleteSalesRep1": "The selected Sales Rep. cannot be deleted as he/she is still assigned to one or more Customers. You must reassign different Sales Reps. to all Customers to which the selected Sales Rep. is assigned before you may delete the selected Sales Rep.",
    "_xtdb_deleteSalesRep2": "The selected Sales Rep. cannot be deleted as he/she is still assigned to one or more Ship-tos. You must reassign different Sales Reps. to all Ship-tos to which the selected Sales Rep. is assigned before you may delete the selected Sales Rep.",
    "_xtdb_deleteSalesRep3": "The selected Sales Rep. cannot be deleted as there has been sales history recorded against him/her. You may edit and set the selected Sales Rep's active status to inactive.",
    "_xtdb_deleteShipto1": "The selected Shipto cannot be deleted as there is still Archived Sales History assigned to it. You must delete all of the selected Customer's Ship-Tos before you may delete it.",
    "_xtdb_deleteShipto2": "The selected Shipto cannot be deleted as there has been Sales History recorded for this Shipto. You may Edit the selected Shipto and set its status to inactive.",
    "_xtdb_deleteShipto3": "The selected Shipto cannot be deleted as there has been Credit Memos recorded for this Shipto. You may Edit the selected Shipto and set its status to inactive.",
    "_xtdb_deleteShipto4": "The selected Shipto cannot be deleted as there has been Sales History recorded for this Shipto. You may Edit the selected Shipto and set its status to inactive.",
    "_xtdb_deleteShipto5": "The selected Shipto cannot be deleted as there has been Quote History recorded for this Shipto. You may Edit the selected Shipto and set its status to inactive.",
    "_xtdb_deleteShipto6": "The selected Shipto cannot be deleted as there has been Invoice History recorded for this Shipto. You may Edit the selected Shipto and set its status to inactive.",
    "_xtdb_deleteSO1": "This Sales Order cannot be deleted because a Credit Card has been charged for it.",
    "_xtdb_deleteSO2": "This Sales Order cannot be deleted because there is Credit Card transaction history for it.",
    "_xtdb_deleteSO101": "This Sales Order cannot be deleted as some of its line items have already been shipped.",
    "_xtdb_deleteSO102": "This Sales Order cannot be deleted as some of its line items have already been issued to shipping.",
    "_xtdb_deleteSO103": "This Sales Order cannot be deleted as some of its line items are linked to a Return Authorization. You must resolve this conflict before you may delete this Sales Order.",
    "_xtdb_deleteSO104": "This Sales Order cannot be deleted as some of its line items are linked to an In Process Work Order. You must resolve this conflict before you may delete this Sales Order.",
    "_xtdb_deleteSO105": "This Sales Order cannot be deleted as some of its line items have transaction history.",
    "_xtdb_deleteSO10": "This Sales Order cannot be deleted as one or more of its Line items have associated Purchase Order Line Items which are either closed or have receipts associated with them. You may want to consider cancelling this Sales Order instead.",
    "_xtdb_deleteSO20": "The Sales Order was deleted successfully. However, the Released Purchase Orders associated with one or more line items of this Sales Order could not be deleted. You must delete these Purchase Orders seperately if desired.",
    "_xtdb_deleteSOItem101": "This Sales Order Item cannot be deleted as it has already been shipped.",
    "_xtdb_deleteSOItem102": "This Sales Order Item cannot be deleted as it has already been issued to shipping.",
    "_xtdb_deleteSOItem103": "This Sales Order Item cannot be deleted as it is linked to a Return Authorization. You must resolve this conflict before you may delete this Sales Order Item.",
    "_xtdb_deleteSOItem104": "This Sales Order Item cannot be deleted as it is linked to an In Process Work Order. You must resolve this conflict before you may delete this Sales Order Item.",
    "_xtdb_deleteSOItem105": "This Sales Order Item cannot be deleted as it has generated Inventory History. You may want to consider cancelling this Sales Order Item.",
    "_xtdb_deleteSOItem10": "This Sales Order Item cannot be deleted as it has associated Purchase Order Line Item which is either closed or has receipts associated with it. You may want to consider cancelling this Sales Order Item instead.",
    "_xtdb_deleteSOItem20": "The Sales Order Item was deleted successfully. However, the Purchase Order Line Item associated with this Sales Line could not be deleted. You must delete this Purchase Line Item seperately if desired.",
    "_xtdb_deleteSubaccount1": "The selected Subaccount cannot be deleted as it is in use by existing Account. You must reclass these Accounts before you may delete the selected Subaccount.",
    "_xtdb_deleteTO1": "This Transfer Order cannot be deleted as some of its line items have already been shipped.",
    "_xtdb_deleteTO2": "This Transfer Order cannot be deleted as some of its line items have already been issued to shipping. You must return this stock before you may delete this Transfer Order.",
    "_xtdb_deleteTax10": "This Tax Code cannot be deleted as there are Tax Assignments that refer to it. Change those Tax Assignments before trying to delete this Tax Code.",
    "_xtdb_deleteTaxAuthority1": "This Tax Authority cannot be deleted as there are Tax Selections for it. Change or delete those Tax Selections before deleting this Tax Authority.",
    "_xtdb_deleteTaxAuthority7": "This Tax Authority cannot be deleted as Checks have been written to it.",
    "_xtdb_deleteTaxClass1": "This Tax Class cannot be deleted as there are Tax Codes that refer to it.",
    "_xtdb_deleteTaxZone1": "This Tax Zone cannot be deleted as there are Tax Assignments that refer to it.",
    "_xtdb_deleteTaxZone2": "This Tax Zone cannot be deleted as there are Tax Registrations that refer to it.",
    "_xtdb_deleteTo1": "This Transfer Order cannot be deleted as line items for it have already been shipped.",
    "_xtdb_deleteTo2": "This Transfer Order cannot be deleted as line items for it have been issued to shipping.",
    "_xtdb_deleteTo3": "This Transfer Order cannot be deleted as the order number cannot be released.",
    "_xtdb_deleteVendor1": "The selected Vendor cannot be deleted as there have been P/Os created against it. You may deactivate this Vendor instead.",
    "_xtdb_deleteVendor2": "The selected Vendor cannot be deleted as there has been P/O Material Receipt History posted against it. You may deactivate this Vendor instead.",
    "_xtdb_deleteVendor3": "The selected Vendor cannot be deleted as there has been P/O Material Return History posted against it. You may deactivate this Vendor instead.",
    "_xtdb_deleteVendor4": "The selected Vendor cannot be deleted as there have been Vouchers posted against it. You may deactivate this Vendor instead.",
    "_xtdb_deleteVendor5": "The selected Vendor cannot be deleted as there have been A/P Open Items posted against it. You may deactivate this Vendor instead.",
    "_xtdb_deleteVendor6": "The selected Vendor cannot be deleted as there have been A/P Applications posted against it. You may deactivate this Vendor instead.",
    "_xtdb_deleteVendor7": "The selected Vendor cannot be deleted as there have been Checks posted against it. You may deactivate this Vendor instead.",
    "_xtdb_deleteWo1": "The Work Order cannot be deleted because time clock entries exist for it. Please Close it instead of trying to Delete it.",
    "_xtdb_deleteWo2": "The Work Order cannot be deleted for Job Item Types. Please close the associated Sales Order instead of trying to Delete it.",
    "_xtdb_deleteWo3": "The Work Order cannot be deleted in the current status. Please close the associated Sales Order instead of trying to Delete it.",
    "_xtdb_disablePackage1": "This version of the PostgreSQL database server does not support package enabling or disabling. Upgrade to PostgreSQL 8.2 or later.",
    "_xtdb_disablePackage2": "Could not find a package with the internal id % to enable or disable.",
    "_xtdb_distributeVoucherLine2": "Distribution would result in zero quantity and amount. Please distribute manually.",
    "_xtdb_distributeVoucherLine3": "The purchase order and voucher have different currencies. Please distribute manually.",
    "_xtdb_distributeVoucherLine4": "Distribution would result in a negative amount. Please distribute manually.",
    "_xtdb_distributeVoucherLine5": "Item has multiple cost elements. Please distribute manually.",
    "_xtdb_editccnumber1": "You must select Master Card, Visa, American Express or Discover as the credit card type.",
    "_xtdb_editccnumber2": "The length of a Master Card credit card number has to be 16 digits.",
    "_xtdb_editccnumber3": "The length of a Visa credit card number has to be either 13 or 16 digits.",
    "_xtdb_editccnumber4": "The length of an American Express credit card number has to be 15 digits.",
    "_xtdb_editccnumber5": "The length of a Discover credit card number has to be 16 digits.",
    "_xtdb_editccnumber6": "The first two digits for a valid Master Card number must be between 51 and 55",
    "_xtdb_editccnumber7": "The first digit for a valid Visa number must be 4",
    "_xtdb_editccnumber8": "The first two digits for a valid American Express number must be 34 or 37.",
    "_xtdb_editccnumber9": "The first four digits for a valid Discover Express number must be 6011.",
    "_xtdb_editccnumber10": "The credit card number that you have provided is not valid.",
    "_xtdb_enterReceipt1": "Information for this order line item could not be found. If it is a Purchase Order Item then it does not appear to exist. If it is a Transfer Order Item then either the Transfer Order does not exist or there is no Item Site for this line item.",
    "_xtdb_explodeWo1": "Work Order %1 cannot be Exploded as there is no valid Bill of Materials on file for the Work Order Item. You must create a valid Bill of Materials for the Work Order Item before you may explode the Work Order.",
    "_xtdb_explodeWo2": "Work Order %1 cannot be Exploded as there are one or more Component Items on the Bill of Materials for the Work Order Item that are not valid in the Work Order Site. You must create a valid Item Site for all of the Component Items before you may explode this Work Order.",
    "_xtdb_explodeWo3": "Work Order %1 cannot be Exploded as there are one or more Co-Product/By-Product Items on the Breeder Bill of Materials for the Work Order Item that do not exist in the Work Order Site. You must create a valid Item Site for all of the Co-Product/ By-Product Items before you may explode this Work Order.",
    "_xtdb_explodeWo4": "Work Order %1 cannot be Exploded because it is not Open.",
    "_xtdb_explodeWo9": "Work Order %1 cannot be Exploded because the quantity ordered is not valid.",
    "_xtdb_fkeycheck1": "Cannot check dependencies when the contact is one of multiple foreign key columns.",
    "_xtdb_freezeAccountingPeriod1": "Cannot freeze this Accounting Period because it is still open.",
    "_xtdb_freezeAccountingPeriod2": "Cannot freeze this Accounting Period because it is already frozen.",
    "_xtdb_insertGLTransaction3": "Nothing to do as the value to post to the G/L is 0.",
    "_xtdb_insertGLTransaction4": "Cannot post a G/L transaction to a closed period.",
    "_xtdb_insertIntoGLSeries1": "Cannot add to a G/L Series because the Account is NULL or -1.",
    "_xtdb_insertIntoGLSeries4": "Cannot add to a G/L Series because the Accounting Period is closed.",
    "_xtdb_issueToShipping10": "The Next Shipment Number has not been set in the Configure S/R window. Set that value and try issuing to shipping again.",
    "_xtdb_issueToShipping11": "Not a supported order type.",
    "_xtdb_issueToShipping12": "The selected Sales Order is on Credit Hold and must be taken off of Credit Hold before any inventory may be issued to it.",
    "_xtdb_issueToShipping13": "The selected Sales Order is on Packing Hold and must be taken off of Packing Hold before any inventory may be issued to it.",
    "_xtdb_issueToShipping14": "The selected Sales Order is on Return Hold. The Customer must return all materials for a related Return Authorization before any inven tory may be issued to this Order.",
    "_xtdb_issueToShipping15": "The selected Sales Order is configured for Auto Registration. The Customer Account does not have a Primary Contact. A Primary Contact must be assigned to this Customer Account before any inven tory may be issued to this Order.",
    "_xtdb_issueToShipping20": "There is not enough Inventory to issue the amount required of one of the Average Cost items requested. Average Cost items may not have a negative quantity on hand.",
    "_xtdb_login1": "The specified Username does not exist in the specified Database. Contact your Systems Administrator to report this issue",
    "_xtdb_login2": "The specified Username exists in the specified Database but is not Active. Contact your Systems Administrator to report this issue.",
    "_xtdb_login3": "The specified Database is currently in Maintenance Mode and can only be accessed by System Administators. Contact your Systems Administrator to report this issue.",
    "_xtdb_massReplaceBomitem1": "Cannot make this BOM Item replacement because it would create a recursive BOM.",
    "_xtdb_openAccountingPeriod1": "Cannot open this Accounting Period because it is already open.",
    "_xtdb_openAccountingPeriod2": "Cannot open this Accounting Period because it is frozen.",
    "_xtdb_openAccountingPeriod3": "Cannot open this Accounting Period because subsequent periods are closed.",
    "_xtdb_openAccountingPeriod4": "Cannot open this Accounting Period because the fiscal year is closed.",
    "_xtdb_openAccountingYearPeriod2": "Cannot open this Accounting Year because subsequent years are closed.",
    "_xtdb_openRecurringItems10": "Cannot count open recurring items with an invalid type.",
    "_xtdb_openRecurringItems11": "Cannot count open recurring items without a valid parent item.",
    "_xtdb_openRecurringItems12": "Don't know how to count open recurring invoices.",
    "_xtdb_postAPCreditMemoApplication1": "There are no A/P Credit Memo applications to post.",
    "_xtdb_postAPCreditMemoApplication2": "There are no A/P Credit Memo applications to post.",
    "_xtdb_postAPCreditMemoApplication3": "The total value of the applications that are you attempting to post is greater than the value of the A/P Credit Memo itself.",
    "_xtdb_postAPCreditMemoApplication4": "At least one A/P Credit Memo application cannot be posted because there is no current exchange rate for its currency.",
    "_xtdb_postAPCreditMemoApplication5": "The A/P Credit Memo to apply was not found.",
    "_xtdb_postAPCreditMemoApplication6": "The amount to apply for this A/P Credit Memo is NULL.",
    "_xtdb_postARCreditMemoApplication1": "There are no A/R Credit Memo applications to post.",
    "_xtdb_postARCreditMemoApplication2": "Either there are no A/R Credit Memo applications to post or there is no exchange rate for one of the applications.",
    "_xtdb_postARCreditMemoApplication3": "The total value of the applications that you are attempting to post is greater than the value of the A/R Credit Memo itself. Please reduce the applications to total less than the value of the Credit Memo.",
    "_xtdb_postARCreditMemoApplication4": "At least one A/R Credit Memo application cannot be posted because there is no current exchange rate for its currency.",
    "_xtdb_postARCreditMemoApplication5": "The A/R Credit Memo to apply was not found.",
    "_xtdb_postBankAdjustment1": "This Bank Adjustment could not be posted because the one or more required records do not exist.",
    "_xtdb_postBankAdjustment3": "This Bank Adjustment could not be posted because the total adjustment is 0 so there is nothing to post.",
    "_xtdb_postBankReconciliation1": "This Bank Reconciliation could not be posted because the G/L Account could not be verified.",
    "_xtdb_createInvoice1": "This Billing Selection cannot be posted because it has already been posted.",
    "_xtdb_createInvoices5": "The G/L Account Assignments for one or more of the Billing Selections that you are trying to post are not configured correctly. Therefore, G/L Transactions cannot be posted for these. You must contact your Systems Administrator to have this corrected before you may post these Billing Selections.",
    "_xtdb_postCashReceipt1": "The selected Cash Receipt cannot be posted as the amount distributed is greater than the amount received. You must correct this before you may post this Cash Receipt.",
    "_xtdb_postCashReceipt2": "The selected Cash Receipt cannot be posted as the amount received must be greater than zero. You must correct this before you may post this Cash Receipt.",
    "_xtdb_postCashReceipt5": "The selected Cash Receipt cannot be posted as the A/R Account cannot be determined. You must make an A/R Account Assignment for the Customer Type to which this Customer is assigned before you may post this Cash Receipt.",
    "_xtdb_postCashReceipt6": "The selected Cash Receipt cannot be posted as the Bank Account cannot be determined. You must make a Bank Account Assignment for this Cash Receipt before you may post it.",
    "_xtdb_postCashReceipt7": "The selected Cash Receipt cannot be posted, probably because the Customer's Prepaid Account was not found.",
    "_xtdb_postCashReceipt8": "Cannot post this Cash Receipt because the credit card records could not be found.",
    "_xtdb_postCCCashReceipt1": "Cannot post this Cash Receipt because annot find the default Bank Account for this Credit Card.",
    "_xtdb_postCCCashReceipt11": "Cannot post this Cash Receipt because the record of the credit card transaction either does not exist or is not consistent.",
    "_xtdb_postCCcredit1": "Cannot post this Credit Card refund because the default Bank Account for this Credit Card could not be found.",
    "_xtdb_postCCcredit2": "Cannot post this Credit Card refund because an invalid id/reference-type pair was passed.",
    "_xtdb_postCCcredit3": "Cannot post this Credit Card refund because the credit card and refund records could not be found.",
    "_xtdb_postCCcredit4": "Cannot post this Credit Card refund because the credit card payment records is not for a refund.",
    "_xtdb_postCheck10": "Cannot post this Check because it has already been posted.",
    "_xtdb_postCheck11": "Cannot post this Check because the recipient type is not valid.",
    "_xtdb_postCheck12": "Cannot post this Check because the Expense Category could not be found.",
    "_xtdb_postCheck13": "Cannot post this Check because the G/L Account against which it is to be posted is not valid.",
    "_xtdb_postCountTag1": "Cannot post this Count Tag because The total Count Slip quantity is greater than the Count Tag quantity.",
    "_xtdb_postCountTag2": "Cannot post this Count Tag because the total Count Slip quantity is less than the Count Tag quantity for a Lot/Serial-controlled Item Site.",
    "_xtdb_postCountTag3": "Cannot post this Count Tag because the total Count Slip quantity is less than the Count Tag quantity and there is no default location.",
    "_xtdb_postCountTag4": "Cannot post this Count Tag because the total Count Slip quantity is less than the Count Tag quantity and we don't post to default locations.",
    "_xtdb_postCreditMemo10": "This Credit Memo cannot be posted because it has already been posted.",
    "_xtdb_postCreditMemo11": "This Credit Memo is on Hold and, thus, cannot be posted.",
    "_xtdb_postCreditMemo12": "The Sales Account Assignment for this Credit Memo is not configured correctly. Because of this, G/L Transactions cannot be posted for this Credit Memo. You must contact your Systems Administrator to have this corrected before you may post this Credit Memo.",
    "_xtdb_postCreditMemo14": "The Misc. Charge Account Assignment for this Credit Memo is not configured correctly. Because of this, G/L Transactions cannot be posted for this Credit Memo. You must contact your Systems Administrator to have this corrected before you may post this Credit Memo.",
    "_xtdb_postCreditMemo16": "The Freight Account Assignment for this Credit Memo is not configured correctly. Because of this, G/L Transactions cannot be posted for this Credit Memo. You must contact your Systems Administrator to have this corrected before you may post this Credit Memo.",
    "_xtdb_postCreditMemo18": "The A/R Account Assignment for this Credit Memo is not configured correctly. Because of this, G/L Transactions cannot be posted for this Credit Memo. You must contact your Systems Administrator to have this corrected before you may post this Credit Memo.",
    "_xtdb_postGLSeries4": "Could not post this G/L Series because the Accounting Period is closed.",
    "_xtdb_postGLSeries5": "Could not post this G/L Series because the G/L Series Discrepancy Account was not found.",
    "_xtdb_postGLSeriesNoSumm1": "Could not post this G/L Series because the Debits and Credits are unbalanced.",
    "_xtdb_postInvoice10": "Unable to post this Invoice because it has already been posted.",
    "_xtdb_postInvoice11": "Unable to post this Invoice because the Sales Account was not found.",
    "_xtdb_postInvoice12": "Unable to post this Invoice because there was an error processing Line Item taxes.",
    "_xtdb_postInvoice13": "Unable to post this Invoice because there was an error processing Misc. Line Item taxes.",
    "_xtdb_postInvoice14": "Unable to post this Invoice because the Freight Account was not found.",
    "_xtdb_postInvoice15": "Unable to post this Invoice because there was an error processing Freight taxes.",
    "_xtdb_postInvoice16": "Unable to post this Invoice because there was an error processing Tax Adjustments.",
    "_xtdb_postInvoice17": "Unable to post this Invoice because the A/R Account was not found.",
    "_xtdb_postInvTrans1": "Could not post an inventory transaction because the Item Site has no Control Method or the Item has an Item Type of Reference.",
    "_xtdb_postInvTrans2": "Could not post an inventory transaction because the transaction will cause an Average Costed Item to go negative which is not allowed.",
    "_xtdb_postProduction1": "Unable to post this Production because the Work Order status is not Exploded, Released, or InProcess.",
    "_xtdb_postProduction2": "Unable to post this Production because backflushing component usage could not be completed due to missing Item Sites.",
    "_xtdb_postProduction3": "Unable to post this Production because of missing Item Site or Cost Category.",
    "_xtdb_postReceipt10": "This Receipt Line has already been posted.",
    "_xtdb_postReceipt11": "This Receipt Line cannot be posted because it has a quantity of 0.",
    "_xtdb_postReceipt12": "This Purchase Order Receipt Line has no Standard Cost assigned to it.",
    "_xtdb_postReceipt16": "Cannot not issue item to shipping. No Sales Order item found against this PO Item.",
    "_xtdb_postReceipt17": "Cannot not issue item to shipping. Inventory history not found.",
    "_xtdb_postVoucher5": "The Cost Category for one or more Item Sites for the Purchase Order covered by this Voucher is not configured with Purchase Price Variance or P/O Liability Clearing Account Numbers or the Vendor of this Voucher is not configured with an A/P Account Number. Because of this, G/L Transactions cannot be posted for this Voucher.",
    "_xtdb_recallShipment1": "This shipment cannot be recalled because it does not appear to have been shipped.",
    "_xtdb_recallShipment2": "This shipment cannot be recalled because it appears to have been invoiced.",
    "_xtdb_recallShipment3": "This shipment cannot be recalled because it has already been received at its destination.",
    "_xtdb_recallShipment4": "This shipment cannot be recalled because it appears to have been invoiced and the invoice has been posted.",
    "_xtdb_recallShipment5": "This shipment cannot be recalled because it contains one or more Line Items with Site/ Product Category/Customer combinations that have not been properly described in Sales Account Assignments. These assignments must be made before G/L Transactions can be posted and this Sales Order is allowed to be recalled.",
    "_xtdb_recallShipment6": "This shipment cannot be recalled because the associated Transfer Order is closed.",
    "_xtdb_releasePurchaseOrder1": "Cannot release this Purchase Order because it does not have any unreleased Purchase Order Items.",
    "_xtdb_releaseTransferOrder1": "Cannot release this Transfer Order because it does not have any line items.",
    "_xtdb_releaseUnusedBillingHeader1": "Cannot release this Billing Header because it has already been posted.",
    "_xtdb_releaseUnusedBillingHeader2": "Cannot release this Billing Header because it has Line Items.",
    "_xtdb_relocateInventory1": "You cannot Relocate more inventory than is available.",
    "_xtdb_returnCompleteShipment5": "Either a Cost Category for the Items you are trying to Return is not configured with a Shipping Asset Account Number or a Customer Type/Product Category/Site Sales Account assignment does not exist . Because of this, G/L Transactions cannot be posted for this Return. You must contact your Systems Administrator to have this corrected before you may Return this Shipment.",
    "_xtdb_returnItemShipments5": "Either a Cost Category for the Items you are trying to Return is not configured with a Shipping Asset Account Number or a Customer Type/Product Category/Site Sales Account assignment does not exist . Because of this, G/L Transactions cannot be posted for this Return. You must contact your Systems Administrator to have this corrected before you may Return this Shipment.",
    "_xtdb_returnShipmentTransaction5": "Either a Cost Category for the Items you are trying to Return is not configured with a Shipping Asset Account Number or a Customer Type/Product Category/Site Sales Account assignment does not exist . Because of this, G/L Transactions cannot be posted for this Return. You must contact your Systems Administrator to have this corrected before you may Return this Shipment.",
    "_xtdb_reverseCashReceipt1": "The selected Cash Receipt cannot be reversed as the amount distributed is greater than the amount received.",
    "_xtdb_reverseCashReceipt2": "The selected Cash Receipt cannot be reversed as the amount received must be greater than zero.",
    "_xtdb_reverseCashReceipt5": "The selected Cash Receipt cannot be reversed as the A/R Account cannot be determined. You must make an A/R Account Assignment for the Customer Type to which this Customer is assigned before you may reverse this Cash Receipt.",
    "_xtdb_reverseCashReceipt6": "The selected Cash Receipt cannot be reversed as the Bank Account cannot be determined. You must make a Bank Account Assignment for this Cash Receipt before you may reverse it.",
    "_xtdb_reverseCashReceipt7": "The selected Cash Receipt cannot be reversed, probably because the Customer's Prepaid Account was not found.",
    "_xtdb_reverseCashReceipt8": "Cannot reverse this Cash Receipt because the credit card records could not be found.",
    "_xtdb_saveAlarm10": "An alarm for this item already exists.",
    "_xtdb_selectForBilling1": "The quantity you have selected for Billing is less than the quantity shipped. You may not bill for less than the quantity shipped.",
    "_xtdb_shipShipment5": "This Sales Order may not be shipped as it contains one or more Line Items that have Site/Product Category/Customer combinations that have not been properly described in Sales Account Assignments. These assignments must be made before G/L Transactions can be posted and this Sales Order is allowed to ship.",
    "_xtdb_shipShipment6": "This Transfer Order may not be shipped because there is no Item Site for the Transit Site.",
    "_xtdb_shipShipment8": "This Shipment cannot be shipped because it appears to have already shipped.",
    "_xtdb_shipShipment12": "The selected Order is on Credit Hold and must be taken off of Credit Hold before it may be shipped.",
    "_xtdb_shipShipment13": "The selected Order is on Packing Hold and must be taken off of Packing Hold before it may be shipped.",
    "_xtdb_shipShipment14": "The selected Order is on Return Hold. The Customer  must return all materials for a related Return Authorization before this order may be shipped.",
    "_xtdb_shipShipment15": "The selected Order is on Shipping Hold and must be taken off of Shipping Hold before it may be shipped.",
    "_xtdb_shipShipment50": "This Shipment cannot be shipped because it does not appear to exist.",
    "_xtdb_shipShipment99": "This Order may not be shipped because it has been marked as Ship Complete and quantities for one or more Line Items are still not completely issued. Please correct this before shipping the Order.",
    "_xtdb_splitReceipt1": "Only Purchase Order Receipts may be split.",
    "_xtdb_splitReceipt2": "Only posted receipts may be split.",
    "_xtdb_splitReceipt3": "Vouchered receitps may not be split.",
    "_xtdb_splitReceipt4": "Split quantity must me less than original receipt quantity.",
    "_xtdb_splitReceipt5": "Split freight may not be greater than original freight.",
    "_xtdb_splitReceipt6": "Receipt not found.",
    "_xtdb_splitReceipt7": "The split quantity must be a positive number.",
    "_xtdb_splitRecurrence11": "Cannot create recurring items without a valid parent item to copy.",
    "_xtdb_sufficientInventoryToShipItem1": "Cannot figure out which line item to issue.",
    "_xtdb_sufficientInventoryToShipItem2": "There is not enough Inventory to issue the amount required of Item %1 in Site %2.",
    "_xtdb_sufficientInventoryToShipItem3": "Item Number %1 in Site %2 is a Multiple Location or Lot/Serial controlled Item which is short on Inventory. This transaction cannot be completed as is. Please make sure there is sufficient Quantity on Hand before proceeding.",
    "_xtdb_sufficientInventoryToShipItem11": "Invalid Order Type. Only Sales Orders and Transfer Orders may be shipped from this window.",
    "_xtdb_sufficientInventoryToShipOrder1": "Cannot check inventory levels for an invalid item.",
    "_xtdb_sufficientInventoryToShipOrder2": "There is not enough Inventory to issue the amount required of one of the items requested.",
    "_xtdb_sufficientInventoryToShipOrder3": "One of the requested items is a Multiple Location or Lot/Serial controlled Item which is sort on Inventory.",
    "_xtdb_thawAccountingPeriod1": "Cannot thaw this Accounting Period because it is closed.",
    "_xtdb_thawAccountingPeriod2": "Cannot thaw this Accounting Period because it is not frozen.",
    "_xtdb_todoItemMove1": "Cannot change the Sequence of a non-existent To-Do List Item. Possible cause: no To-Do List Item was selected.",
    "_xtdb_updateTodoItem1": "The To-Do List Item cannot be updated as there is no assigned User.",
    "_xtdb_updateTodoItem2": "The To-Do List Item cannot be updated as the Task Name is blank.",
    "_xtdb_updateTodoItem3": "The To-Do List Item cannot be updated as there is no Due Date.",
    "_xtdb_updateTodoItem10": "The To-Do List Item cannot be updated as an invalid internal ID was supplied .",
    "_xtdb_voidCheck1": "Cannot void this check because either it has already been voided, posted, or replaced, or it has been transmitted electronically. If this check has been posted, try Void Posted Check with the Check Register window.",
    "_xtdb_voidCreditMemo10": "Unable to void this Credit Memo because it has not been posted.",
    "_xtdb_voidCreditMemo11": "Unable to void this Credit Memo because the Sales Account was not found.",
    "_xtdb_voidCreditMemo20": "Unable to void this Credit Memo because there A/R Applications posted against this Credit Memo.",
    "_xtdb_voidInvoice10": "Unable to void this Invoice because it has not been posted.",
    "_xtdb_voidInvoice11": "Unable to void this Invoice because the Sales Account was not found.",
    "_xtdb_voidInvoice20": "Unable to void this Invoice because there A/R Applications posted against this Invoice.",
    "_xtdb_voidPostedCheck10": "Cannot void this check because it has already been voided.",
    "_xtdb_voidPostedCheck11": "Cannot void this check because the recipient type is not valid.",
    "_xtdb_voidPostedCheck12": "Cannot void this check because the Expense Category could not be found.",
    "_xtdb_voidPostedCheck13": "Cannot void this check because the G/L account to which the funds should be credited is not valid.",
    "_xtdb_voidPostedCheck14": "Cannot void this check because the check has has been reconciled in Bank Reconciliation.",
    "_xtdb_replaceVoidedCheck1": "Cannot replace a check that is not voided or has already been posted or replaced.",
    "_xtdb_replaceVoidedCheck2": "Cannot replace this voided check because one of its line items has been reselected for billing and is represented on another check.",
    "_xtdb_reserveSoLineQty1": "Cannot reserve more quantity than remaining on order.",
    "_xtdb_reserveSoLineQty2": "Cannot reserve negative quantities.",
    "_xtdb_reserveSoLineQty3": "Cannot reserve more quantity than currently on hand and already reserved.",
    "_xtdb_woClockIn9": "Work Order %1 cannot be Exploded as it seems to have an invalid Order Quantity.",
    "_xtdb_woClockIn10": "Work Order %1 has at least one Item in its Bill of Materials with the Push issue method that has not yet been issued. You must issue all Push Items to this Work Order.",
    "_xtdb_woClockIn11": "Work Order %1 has at least one Item in its Bill of Materials with the Push issue method that does not have the required quantity issued. You must issue all Push Items to this Work Order.",
    "_xtdb_woClockIn12": "Work Order %1 is closed.",
  });

  if (typeof exports !== 'undefined') {
    exports.language = lang;
  }
}());
